///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include "DeleteAtomsModifier.h"

namespace AtomViz {

IMPLEMENT_SERIALIZABLE_PLUGIN_CLASS(DeleteAtomsModifier, AtomsObjectModifierBase)

/******************************************************************************
* This modifies the input object.
******************************************************************************/
EvaluationStatus DeleteAtomsModifier::modifyAtomsObject(TimeTicks time, TimeInterval& validityInterval)
{
	QString statusMessage = tr("%n input atoms", 0, input()->atomsCount());

	// Get the selection channel.
	DataChannel* selChannel = expectStandardChannel(DataChannel::SelectionChannel);

	// Compute filter mask.
	dynamic_bitset<> mask(input()->atomsCount());
	const int* s = selChannel->constDataInt();
	for(size_t i = 0; i < selChannel->size(); i++) {
		if(*s++) {
			mask.set(i);
		}
	}

	// Replace referenced data channels with real copies and apply filter.
	output()->deleteAtoms(mask);

	statusMessage += tr("\n%n atoms deleted", 0, input()->atomsCount() - output()->atomsCount());
	return EvaluationStatus(EvaluationStatus::EVALUATION_SUCCESS, QString(), statusMessage);
}


IMPLEMENT_PLUGIN_CLASS(DeleteAtomsModifierEditor, AtomsObjectModifierEditorBase)

/******************************************************************************
* Sets up the UI widgets of the editor.
******************************************************************************/
void DeleteAtomsModifierEditor::createUI(const RolloutInsertionParameters& rolloutParams)
{
	// Create a rollout.
	QWidget* rollout = createRollout(tr("Delete Selected Atoms"), rolloutParams, "atomviz.modifiers.delete_selected_atoms");

    // Create the rollout contents.
	QVBoxLayout* layout = new QVBoxLayout(rollout);
	layout->setContentsMargins(4,4,4,4);
	layout->setSpacing(0);

	// Status label.
	layout->addWidget(statusLabel());
}

};	// End of namespace AtomViz
