///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <base/Base.h>
#include <base/utilities/Logger.h>

namespace Base {

QIODevice* GetStdErrFile() {
	static QFile stderrFile;
	static bool initialized = false;
	if(!initialized) {
		stderrFile.open(stderr, QIODevice::WriteOnly);
		initialized = true;
	}
	return &stderrFile;
}

LoggerObject __msg_logger(GetStdErrFile());
LoggerObject __verbose_msg_logger(GetStdErrFile(), false);

/// Writes the current date/time to the output stream for logging purposes.
QTextStream& logdate(QTextStream& s)
{
	return s << '[' << QTime::currentTime().toString(Qt::ISODate) << "] ";
}

};	// End of namespace Base
