///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __OVITO_BOOLEAN_ACTION_PROPERTY_UI_H
#define __OVITO_BOOLEAN_ACTION_PROPERTY_UI_H

#include <core/Core.h>
#include "ParameterUI.h"

namespace Core {

/******************************************************************************
* This UI allows the user to change a boolean property of the object being edited.
******************************************************************************/
class CORE_DLLEXPORT BooleanActionPropertyUI : public PropertyParameterUI
{
public:
	/// Constructor for a Qt property.
	BooleanActionPropertyUI(PropertiesEditor* parentEditor, const char* propertyName, QAction* action);

	/// Constructor for a PropertyField property.
	BooleanActionPropertyUI(PropertiesEditor* parentEditor, const PropertyFieldDescriptor& propField, QAction* action);
	
	/// This returns the action associated with this parameter UI.
	QAction* action() const { return _action; }
	
	/// This method is called when a new editable object has been assigned to the properties owner this
	/// parameter UI belongs to.
	virtual void resetUI();

	/// This method updates the displayed value of the property UI.
	virtual void updateUI();
	
	/// Sets the enabled state of the UI.
	virtual void setEnabled(bool enabled);
	
public:
	
	Q_PROPERTY(QAction action READ action)
	
public Q_SLOTS:
	
	/// Takes the value entered by the user and stores it in the property field 
	/// this property UI is bound to. 
	void updatePropertyValue();
	
protected:

	/// The check box of the UI component.
	QPointer<QAction> _action;

private:

	Q_OBJECT
	DECLARE_ABSTRACT_PLUGIN_CLASS(BooleanActionPropertyUI)
};

};

#endif // __OVITO_BOOLEAN_ACTION_PROPERTY_UI_H
