///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __OVITO_FLOAT_PROPERTY_UI_H
#define __OVITO_FLOAT_PROPERTY_UI_H

#include <core/Core.h>
#include "NumericalPropertyUI.h"

namespace Core {

/******************************************************************************
* A parameter UI for floating-point object properties.
******************************************************************************/
class CORE_DLLEXPORT FloatPropertyUI : public NumericalPropertyUI
{
public:

	/// Constructor for a Qt property.
	FloatPropertyUI(PropertiesEditor* parentEditor, const char* propertyName, const QString& labelText = QString(), ParameterUnit* parameterUnit = NULL);

	/// Constructor for a PropertyField property.
	FloatPropertyUI(PropertiesEditor* parentEditor, const PropertyFieldDescriptor& propField);
	
	/// Gets the minimum value to be entered.
	/// This value is in native controller units.
	FloatType minValue() const;

	/// Sets the minimum value to be entered.
	/// This value must be specified in native controller units.
	void setMinValue(FloatType minValue);

	/// Gets the maximum value to be entered.
	/// This value is in native controller units.
	FloatType maxValue() const;

	/// Sets the maximum value to be entered.
	/// This value must be specified in native controller units.
	void setMaxValue(FloatType maxValue);

	/// This method updates the displayed value of the parameter UI.
	virtual void updateUI();
	
	/// Takes the value entered by the user and stores it in the property field 
	/// this property UI is bound to. 
	virtual void updatePropertyValue();
	
public:
	
	Q_PROPERTY(FloatType minValue READ minValue WRITE setMinValue)	
	Q_PROPERTY(FloatType maxValue READ maxValue WRITE setMaxValue)	
	
private:

	Q_OBJECT
	DECLARE_ABSTRACT_PLUGIN_CLASS(FloatPropertyUI)
};

};

#endif // __OVITO_FLOAT_PROPERTY_UI_H
