//
// C++ Implementation: CSkyEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CSkyEdit.hpp"

CSkyEditDlg::CSkyEditDlg(QString strTitle, QWidget * parent, Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   point = NULL;
   ui.setupUi(this);
    
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));

   myParent = parent;
   setWindowTitle(strTitle);
}

CSkyEditDlg::~CSkyEditDlg() {
}

void CSkyEditDlg::slotGetData()
{
    if(point != NULL){
      slotGetData(point);
    }
}

void CSkyEditDlg::slotGetData(FolderListItem *i)
{
    point=i;
    
    ui.text->setText(i->text(0));
    ui.on->setChecked(i->GetValue("on",i).toInt());

    ui.sunroth->setValue(i->GetValue("sunroth",i).toInt());
    ui.sunrotv->setValue(i->GetValue("sunrotv",i).toInt());
    
    ui.moonroth->setValue(i->GetValue("moonroth",i).toInt());
    ui.moonrotv->setValue(i->GetValue("moonrotv",i).toInt());

    ui.cl1on->setChecked(i->GetValue("cl1on",i).toInt());
    ui.cl2on->setChecked(i->GetValue("cl2on",i).toInt());
    ui.cl3on->setChecked(i->GetValue("cl3on",i).toInt());

    ui.cl1h->setValue(i->GetValue("cl1h",i).toInt());
    ui.cl2h->setValue(i->GetValue("cl2h",i).toInt());
    ui.cl3h->setValue(i->GetValue("cl3h",i).toInt());

    ui.cl1s->setValue(i->GetValue("cl1s",i).toInt());
    ui.cl2s->setValue(i->GetValue("cl2s",i).toInt());
    ui.cl3s->setValue(i->GetValue("cl3s",i).toInt());

    ui.cl1d->setValue(i->GetValue("cl1d",i).toInt());
    ui.cl2d->setValue(i->GetValue("cl2d",i).toInt());
    ui.cl3d->setValue(i->GetValue("cl3d",i).toInt());

    qWarning( "CSkyEditDlg::slotGetData(): Geht !" );
}

void CSkyEditDlg::slotEditData()
{
    if(point != NULL){
        point->setText(0,ui.text->text());

        point->SetValue("on", ui.on->isChecked() ? "1" : "0");

        point->SetValue("sunroth",ui.sunroth->text());
        point->SetValue("sunrotv",ui.sunrotv->text());
    
        point->SetValue("moonroth",ui.moonroth->text());
        point->SetValue("moonrotv",ui.moonrotv->text());

        point->SetValue("cl1on", ui.cl1on->isChecked() ? "1" : "0");
        point->SetValue("cl2on", ui.cl2on->isChecked() ? "1" : "0");
        point->SetValue("cl3on", ui.cl3on->isChecked() ? "1" : "0");

        point->SetValue("cl1h",ui.cl1h->text());
        point->SetValue("cl2h",ui.cl2h->text());
        point->SetValue("cl3h",ui.cl3h->text());

        point->SetValue("cl1s",ui.cl1s->text());
        point->SetValue("cl2s",ui.cl2s->text());
        point->SetValue("cl3s",ui.cl3s->text());

        point->SetValue("cl1d",ui.cl1d->text());
        point->SetValue("cl2d",ui.cl2d->text());
        point->SetValue("cl3d",ui.cl3d->text());
	
        point->updategl();
    }
    qWarning( "CSkyEditDlg::slotEditData(): Geht !" );
}
