/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2009  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

#ifdef HAVE_SDL

/* only EV_KBD */
int sw_scope_kbd_func(struct subwin *sw, struct event *ev, int fw){
	SDL_Rect area;

    if (!sdl) return 0;
	switch (ev->x){
		case ' ':
			sw->scope_mode++;
			if (sw->scope_mode == 4) sw->scope_mode = 0;

            area.x = 0;
            area.y = 0;
            area.w = sw->screen->w;
            area.h = sw->screen->h;
            SDL_FillRect(sw->screen, &area, makecol(0, 0, 0));
			break;
	}
    return 0;
}


int sw_scope_mouse_func(struct subwin *sw, struct event *ev, int fw){
    if (!sdl) return 0;
    return 0;
}


void sw_scope_redraw(struct subwin *sw, int flags){
	SDL_Rect area;
	int i, y, y0, a, c, x;
	int oy0=0, oy1=0;

    if (!sdl) return;
//	dbg("sw_scope_redraw(gdirty=%d)\n", sw->gdirty); 
    fill_area(sw->x, sw->y, sw->w, sw->h, 0);
	if (!sw->gdirty) return;
	sw->gdirty=0;

    if (sw->scope_mode == 3){
        sw_fft_redraw(sw, flags);
        return;
    }

	area.x = 0;
	area.y = 0;
	area.w = sw->screen->w;
	area.h = sw->screen->h;
    SDL_FillRect(sw->screen, &area, makecol(0, 0, 0));

#ifdef HAVE_SNDFILE
    if (ssbd->channels == 1){
        c = ssbd->recording ? sdl->red : sdl->green;
        y0 = sw->screen->h / 2;
        a = sw->screen->h / 2 - 1;
        ssbd_assert();
        for (i=0; i<SSBBUFFER_LEN; i++){
            if (i==sw->screen->w) break;
            y = ((int)ssbd->buffer2[i] * (int)a) / 32768; 
			switch(sw->scope_mode){
            	case 0:
					line(sw->screen, i, y0+y, i, y0-y, c); 
					break;
            	case 1:
					fast_putpixel(sw->screen, i, y0-y, c); 
					break;
				case 2:
					if (i==0){
                     	oy0 = y0-y;
						break;
					}
					line(sw->screen, i-1, oy0, i, y0-y, c);
                    oy0 = y0-y;
					break;
			}
        }
        ssbd_assert();
    }

    if (ssbd->channels == 2){
        c = ssbd->recording ? sdl->red : sdl->green;
        y0 = sw->screen->h / 4;
        a = sw->screen->h / 4 - 1;
        ssbd_assert();
        for (i=0, x=0; i<SSBBUFFER_LEN; i+=2, x++){
            if (x==sw->screen->w) break;
            y = ((int)ssbd->buffer2[i] * (int)a) / 32768; 
			switch(sw->scope_mode){
            	case 0:
					line(sw->screen, x, y0+y, x, y0-y, c); 
					break;
            	case 1:
					fast_putpixel(sw->screen, x, y0-y, c); 
					break;
				case 2:
					if (x==0){
                     	oy0 = y0-y;
						break;
					}
					line(sw->screen, x-1, oy0, x, y0-y, c);
                    oy0 = y0-y;
					break;
			}
        }
        ssbd_assert();
        y0 = (sw->screen->h * 3)/ 4;
        for (i=1, x=0; i<SSBBUFFER_LEN; i+=2, x++){
            if (x==sw->screen->w) break;
            y = ((int)ssbd->buffer2[i] * (int)a) / 32768; 
			switch(sw->scope_mode){
            	case 0:
					line(sw->screen, x, y0+y, x, y0-y, c); 
					break;
            	case 1:
					fast_putpixel(sw->screen, x, y0-y, c); 
					break;
				case 2:
					if (x==0){
                     	oy1 = y0-y;
						break;
					}
					line(sw->screen, x-1, oy1, x, y0-y, c);
                    oy1 = y0-y;
					break;
			}
        }
        ssbd_assert();
    }
#endif

}

void sw_scope_check_bounds(struct subwin *sw){

    if (!sdl) return;
    if (!aband) return;
}

void sw_scope_raise(struct subwin *sw){
    sw->gdirty=1;      
}


#else
int sw_scope_kbd_func(struct subwin *sw, struct event *ev, int fw){
    return 0;
}

int sw_scope_mouse_func(struct subwin *sw, struct event *ev, int fw){
    return 0;
}

void sw_scope_redraw(struct subwin *sw, int flags){
}

void sw_scope_check_bounds(struct subwin *sw){
}

void sw_scope_raise(struct subwin *sw){
}

#endif
