
/*
 * ===========================
 * VDK Visual Development Kit
 * Version 2.0.2
 * May 2002
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 * Based on ISDataBox
 * Developed by Ionutz Borcoman <borco@borco-ei.eng.hokudai.ac.jp>
 * based on  GtkDatabox - An extension to the gtk+ library
 * Copyright (C) 1998-1999 Roland Bock
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <vdk/vdkdatabox.h>
#include <stdlib.h>
const GtkDataboxCoord zeroCoord = {0,0};
const GtkDataboxValue zeroValue = {0.0, 0.0};

VDKDataBox::VDKDataBox(VDKForm *owner)
  :VDKObject(owner),
   Rulers("Rulers", this, true, &VDKDataBox::SetRulers),
   Scrollbars("Scrollbars", this, true, &VDKDataBox::SetScrollbars),
   Zoom("Zoom", this, true, &VDKDataBox::SetZoom),
   TopLeft("TopLeft", this, zeroValue),
   BottomRight("BottomRight", this, zeroValue),
   Mark("Mark", this, zeroCoord),
   Select("Select", this, zeroCoord)   
{
  widget = sigwid = gtk_databox_new();

  gtk_signal_connect (GTK_OBJECT (widget), "gtk_databox_zoomed",
			       GTK_SIGNAL_FUNC(&VDKDataBox::_zoomed),
					  this);
  gtk_signal_connect (GTK_OBJECT (widget), "gtk_databox_marked",
			  GTK_SIGNAL_FUNC(&VDKDataBox::_marked),
					  this);
  gtk_signal_connect (GTK_OBJECT (widget), "gtk_databox_selection_started",
			  GTK_SIGNAL_FUNC(&VDKDataBox::_selectionStarted),
					  this);
  gtk_signal_connect (GTK_OBJECT (widget), "gtk_databox_selection_changed",
			  GTK_SIGNAL_FUNC(&VDKDataBox::_selectionChanged),
					  this);
  gtk_signal_connect (GTK_OBJECT (widget), "gtk_databox_selection_stopped",
			  GTK_SIGNAL_FUNC(&VDKDataBox::_selectionStoped),
					  this);
  gtk_signal_connect (GTK_OBJECT (widget), "gtk_databox_selection_canceled",
			  GTK_SIGNAL_FUNC(&VDKDataBox::_selectionCanceled),
					  this);
  ConnectDefaultSignals();
}

VDKDataBox::~VDKDataBox()
{
}

void
VDKDataBox::SetRulers(bool val)
{
  if(val)
    gtk_databox_show_rulers(GTK_DATABOX(widget));
  else
    gtk_databox_hide_rulers(GTK_DATABOX(widget));
}


void
VDKDataBox::SetScrollbars(bool val)
{
  if(val)
    gtk_databox_show_scrollbars(GTK_DATABOX(widget));
  else
    gtk_databox_hide_scrollbars(GTK_DATABOX(widget));
}

void
VDKDataBox::SetZoom(bool val)
{
  if(val)
    gtk_databox_enable_zoom(GTK_DATABOX(widget));
  else
    gtk_databox_disable_zoom(GTK_DATABOX(widget));
}

GtkDataboxValue
VDKDataBox::GetValue(GtkDataboxCoord coord)
{
  GtkDataboxValue ret;
  gtk_databox_data_get_value(GTK_DATABOX(widget), coord, &ret);
  return ret;
}

void
VDKDataBox::GetExtrema(GtkDataboxValue& min, GtkDataboxValue& max, bool visible)
{
  if(visible)
    gtk_databox_data_get_visible_extrema(GTK_DATABOX(widget), &min, &max);
  else
    gtk_databox_data_get_extrema(GTK_DATABOX(widget), &min, &max);
}

void
VDKDataBox::Rescale()
{
  gtk_databox_rescale(GTK_DATABOX(widget));
}

void
VDKDataBox::Rescale(GtkDataboxValue min, GtkDataboxValue max)
{
  gtk_databox_rescale_with_values(GTK_DATABOX(widget), min, max);
}

void 
VDKDataBox::Redraw()
{
  gtk_databox_redraw(GTK_DATABOX(widget));
}

VDKColor*
VDKDataBox::GetColor(int index)
{
  VDKColor *ret;
  GdkColor *color;

  color = (GdkColor*) malloc (sizeof(GdkColor));
  gtk_databox_data_get_color(GTK_DATABOX(widget), index, color);
  ret = new VDKColor(this, 
		     color->red,
		     color->green,
		     color->blue);
  free(color);
  
  return ret;
}

void 
VDKDataBox::SetColor(int index, VDKColor* color, bool redraw)
{
  GdkColor *tmp = color->Color();
  gtk_databox_data_set_color(GTK_DATABOX(widget), index, *tmp);
  if(redraw)
    Redraw();
}

gint 
VDKDataBox::RemoveData(gint index)
{
  return gtk_databox_data_remove(GTK_DATABOX(widget), index);
}

gint 
VDKDataBox::RemoveData()
{
  return gtk_databox_data_remove_all(GTK_DATABOX(widget));
}

gint 
VDKDataBox::DestroyData(gint index)
{
  return gtk_databox_data_destroy(GTK_DATABOX(widget), index);
}

gint 
VDKDataBox::DestroyData()
{
  return gtk_databox_data_destroy_all(GTK_DATABOX(widget));
}

gint 
VDKDataBox::AddXY(guint length, gfloat *X, gfloat *Y, 
				 VDKColor *color,
				 GtkDataboxDataType type, guint dotSize)
{
  return gtk_databox_data_add_x_y(GTK_DATABOX(widget), length, 
				  X, Y,
				  (GdkColor)*(color->Color()),
				  type, dotSize);
}

gint 
VDKDataBox::AddX (guint length, gfloat *X, guint indexSharedY, VDKColor *color, 
				 GtkDataboxDataType type, guint dotSize)
{
  return gtk_databox_data_add_x(GTK_DATABOX(widget), length, 
				X, indexSharedY,
				(GdkColor)*(color->Color()),
				type, dotSize);
}

gint 
VDKDataBox::AddY (guint length, gfloat *Y, guint indexSharedX, VDKColor *color, 
				 GtkDataboxDataType type, guint dotSize)
{
  return gtk_databox_data_add_y(GTK_DATABOX(widget), length, 
				Y, indexSharedX,
				(GdkColor)*(color->Color()),
				type, dotSize);
}

/*****************************
 * Signal handling functions *
 *****************************/
gint 
VDKDataBox::_zoomed(GtkDatabox *, 
		    GtkDataboxValue *top_left, 
		    GtkDataboxValue *bottom_right, 
		    gpointer gp)
{
  g_return_val_if_fail(gp != NULL,TRUE);
  VDKDataBox *obj = reinterpret_cast<VDKDataBox*>(gp);

  obj->TopLeft(*top_left);
  obj->BottomRight(*bottom_right);
  obj->SignalEmitParent(databox_zoomed_signal);
  obj->SignalEmitParent("databox_zoomed");
  
  return 0;
}

gint 
VDKDataBox::_marked(GtkDatabox *, 
		    GtkDataboxCoord *mark, 
		    gpointer gp)
{
  g_return_val_if_fail(gp != NULL,TRUE);
  VDKDataBox *obj = reinterpret_cast<VDKDataBox*>(gp);

  obj->Mark(*mark);
  obj->SignalEmitParent(databox_marked_signal);
  obj->SignalEmitParent("databox_marked");
  
  return 0;
}

gint 
VDKDataBox::_selectionStarted(GtkDatabox *, 
			      GtkDataboxCoord *mark, 
			      gpointer gp)
{
  g_return_val_if_fail(gp != NULL,TRUE);
  VDKDataBox *obj = reinterpret_cast<VDKDataBox*>(gp);

  obj->Mark(*mark);
  obj->SignalEmitParent(databox_selection_started_signal);
  obj->SignalEmitParent("databox_selection_started");

  return 0;
}

gint 
VDKDataBox::_selectionChanged(GtkDatabox *, 
			      GtkDataboxCoord *mark, 
			      GtkDataboxCoord *select, 
			      gpointer gp)
{
  g_return_val_if_fail(gp != NULL,TRUE);
  VDKDataBox *obj = reinterpret_cast<VDKDataBox*>(gp);

  obj->Mark(*mark);
  obj->Select(*select);
  obj->SignalEmitParent(databox_selection_changed_signal);
  obj->SignalEmitParent("databox_selection_changed");

  return 0;
}
  
gint 
VDKDataBox::_selectionStoped(GtkDatabox *, 
			     GtkDataboxCoord *mark, 
			     GtkDataboxCoord *select, 
			     gpointer gp)
{
  g_return_val_if_fail(gp != NULL,TRUE);
  VDKDataBox *obj = reinterpret_cast<VDKDataBox*>(gp);

  obj->Mark(*mark);
  obj->Select(*select);
  obj->SignalEmitParent(databox_selection_stopped_signal);
  obj->SignalEmitParent("databox_selection_stopped");

  return 0;
}
  
gint 
VDKDataBox::_selectionCanceled(GtkDatabox *, 
			       gpointer gp)
{
  g_return_val_if_fail(gp != NULL,TRUE);
  VDKDataBox *obj = reinterpret_cast<VDKDataBox*>(gp);

  obj->SignalEmitParent(databox_selection_canceled_signal);
  obj->SignalEmitParent("databox_selection_canceled");

  return 0;
}
/*
 */
void 
VDKDataBox::SetBackground(VDKRgb color, GtkStateType state)
{
  if(!widget) return;
  _setBackground_(GTK_DATABOX(widget)->draw,
		  color.red,color.green,color.blue, state);
}
