/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.environment;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLEnvironmentalSensorNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLTimeDependentNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseSensorNode;

public abstract class BaseProximitySensor
extends BaseSensorNode
implements VRMLEnvironmentalSensorNodeType,
VRMLTimeDependentNodeType {
    private static final int[] SECONDARY_TYPE = new int[]{52};
    protected static final int FIELD_CENTER = 1;
    protected static final int FIELD_SIZE = 2;
    protected static final int FIELD_ENABLED = 3;
    protected static final int FIELD_IS_ACTIVE = 4;
    protected static final int FIELD_POSITION_CHANGED = 5;
    protected static final int FIELD_ORIENTATION_CHANGED = 6;
    protected static final int FIELD_CENTEROFROTATION_CHANGED = 7;
    protected static final int FIELD_ENTER_TIME = 8;
    protected static final int FIELD_EXIT_TIME = 9;
    protected static final int LAST_PROXIMITYSENSOR_INDEX = 9;
    private static final int NUM_FIELDS = 10;
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected float[] vfCenter = new float[3];
    protected float[] vfSize = new float[3];
    protected boolean vfEnabled = true;
    protected boolean vfIsActive = false;
    protected float[] vfCenterOfRotationChanged;
    protected float[] vfPositionChanged = new float[3];
    protected float[] vfOrientationChanged = new float[4];
    protected double vfEnterTime = -1.0;
    protected double vfExitTime = -1.0;
    protected VRMLClock vrmlClock;

    public BaseProximitySensor() {
        super("ProximitySensor");
        this.vfCenterOfRotationChanged = new float[3];
        this.hasChanged = new boolean[10];
    }

    public BaseProximitySensor(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("center");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCenter[0] = vRMLFieldData.floatArrayValue[0];
            this.vfCenter[1] = vRMLFieldData.floatArrayValue[1];
            this.vfCenter[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("size");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSize[0] = vRMLFieldData.floatArrayValue[0];
            this.vfSize[1] = vRMLFieldData.floatArrayValue[1];
            this.vfSize[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("enabled");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEnabled = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        this.vrmlClock = vRMLClock;
    }

    public void setEnabled(boolean bl) {
        if (!this.vfIsActive && this.vfEnabled != bl) {
            this.vfEnabled = bl;
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    public boolean getEnabled() {
        return this.vfEnabled;
    }

    public boolean getIsActive() {
        return this.vfIsActive;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 9) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 14;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfCenter;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfSize;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfEnabled;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfIsActive;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfPositionChanged;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfOrientationChanged;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfCenterOfRotationChanged;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfEnterTime;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfExitTime;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfCenter, 3);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfSize, 3);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfEnabled);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfIsActive);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfPositionChanged, 3);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfOrientationChanged, 4);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfCenterOfRotationChanged, 3);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfEnterTime);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfExitTime);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                this.setEnabled(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                this.setSize(fArray);
                break;
            }
            case 1: {
                this.setCenter(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    protected void setSize(float[] fArray) {
        this.vfSize = fArray;
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    protected void setCenter(float[] fArray) {
        this.vfCenter = fArray;
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[10];
        fieldMap = new HashMap(30);
        BaseProximitySensor.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseProximitySensor.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFVec3f", "center");
        BaseProximitySensor.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFVec3f", "size");
        BaseProximitySensor.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseProximitySensor.fieldDecl[4] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseProximitySensor.fieldDecl[5] = new VRMLFieldDeclaration(4, "SFVec3f", "position_changed");
        BaseProximitySensor.fieldDecl[6] = new VRMLFieldDeclaration(4, "SFRotation", "orientation_changed");
        BaseProximitySensor.fieldDecl[7] = new VRMLFieldDeclaration(4, "SFVec3f", "centerOfRotation_changed");
        BaseProximitySensor.fieldDecl[8] = new VRMLFieldDeclaration(4, "SFTime", "enterTime");
        BaseProximitySensor.fieldDecl[9] = new VRMLFieldDeclaration(4, "SFTime", "exitTime");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("center", n);
        fieldMap.put("set_center", n);
        fieldMap.put("center_changed", n);
        n = new Integer(2);
        fieldMap.put("size", n);
        fieldMap.put("set_size", n);
        fieldMap.put("size_changed", n);
        n = new Integer(3);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        fieldMap.put("isActive", new Integer(4));
        fieldMap.put("centerOfRotation_changed", new Integer(7));
        fieldMap.put("position_changed", new Integer(5));
        fieldMap.put("orientation_changed", new Integer(6));
        fieldMap.put("enterTime", new Integer(8));
        fieldMap.put("exitTime", new Integer(9));
    }
}

