/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.gui.Global;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.FixedAngleObject;
import rene.zirkel.objects.PointObject;

public class AngleConstructor
extends ObjectConstructor {
    PointObject P1 = null;
    PointObject P2 = null;
    PointObject P3 = null;
    boolean Fixed = false;
    FixedAngleObject A;
    ConstructionObject O;
    boolean ShowsValue;
    int Moved;

    public AngleConstructor(boolean bl) {
        this.Fixed = bl;
    }

    public AngleConstructor() {
        this(false);
    }

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!zirkelCanvas.Visual) {
            return;
        }
        if (this.P1 == null) {
            this.P1 = this.select(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
            if (this.P1 != null) {
                this.P1.setSelected(true);
                zirkelCanvas.repaint();
            }
            this.showStatus(zirkelCanvas);
        } else if (this.P2 == null) {
            this.P2 = this.select(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
            if (this.P2 != null) {
                this.P2.setSelected(true);
                zirkelCanvas.repaint();
            }
            this.showStatus(zirkelCanvas);
        } else if (!mouseEvent.isShiftDown() && !this.Fixed) {
            this.P3 = this.select(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
            if (this.P3 != null) {
                if (this.P3 == this.P1 || this.P3 == this.P2) {
                    this.P3 = null;
                    return;
                }
                AngleObject angleObject = new AngleObject(zirkelCanvas.getConstruction(), this.P1, this.P2, this.P3);
                zirkelCanvas.addObject(angleObject);
                angleObject.setDefaults();
                if (this.P3.moveable() && !this.P3.isPointOn() && zirkelCanvas.isNewPoint()) {
                    this.ShowsValue = angleObject.showValue();
                    if (Global.getParameter("options.movefixname", true)) {
                        angleObject.setShowValue(true);
                    }
                    this.O = angleObject;
                    this.Dragging = true;
                    angleObject.validate();
                    zirkelCanvas.repaint();
                } else {
                    this.Dragging = false;
                    this.P3 = null;
                    this.P2 = null;
                    this.P1 = null;
                    this.reset(zirkelCanvas);
                    zirkelCanvas.validate();
                    zirkelCanvas.repaint();
                }
            }
        } else {
            FixedAngleObject fixedAngleObject = new FixedAngleObject(zirkelCanvas.getConstruction(), this.P1, this.P2, zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()));
            zirkelCanvas.addObject(fixedAngleObject);
            fixedAngleObject.setDefaults();
            fixedAngleObject.init(zirkelCanvas.getConstruction(), zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()));
            this.Moved = 0;
            this.Dragging = true;
            this.ShowsValue = fixedAngleObject.showValue();
            if (Global.getParameter("options.movefixname", true)) {
                fixedAngleObject.setShowValue(true);
            }
            this.A = fixedAngleObject;
            this.O = this.A;
            this.P3 = null;
            zirkelCanvas.repaint();
        }
    }

    public boolean waitForLastPoint() {
        return this.P1 != null && this.P2 != null;
    }

    public boolean waitForPoint() {
        return !this.Fixed || this.P1 == null || this.P2 == null;
    }

    public void finishConstruction(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!this.Fixed) {
            this.P3 = this.select(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
            if (this.P3 != null) {
                AngleObject angleObject = new AngleObject(zirkelCanvas.getConstruction(), this.P1, this.P2, this.P3);
                zirkelCanvas.addObject(angleObject);
                angleObject.setDefaults();
            }
            zirkelCanvas.repaint();
            this.P3 = null;
        } else {
            FixedAngleObject fixedAngleObject = new FixedAngleObject(zirkelCanvas.getConstruction(), this.P1, this.P2, zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()));
            zirkelCanvas.addObject(fixedAngleObject);
            fixedAngleObject.setDefaults();
            fixedAngleObject.init(zirkelCanvas.getConstruction(), zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()));
            zirkelCanvas.setPreviewObject(fixedAngleObject);
            zirkelCanvas.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!this.Dragging) {
            return;
        }
        ++this.Moved;
        if (this.P3 == null) {
            this.A.init(zirkelCanvas.getConstruction(), zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()));
            if (this.A instanceof FixedAngleObject) {
                this.A.setDragable(this.Moved > 5);
            }
        } else {
            this.P3.move(zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()));
            zirkelCanvas.validate();
        }
        zirkelCanvas.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!this.Dragging) {
            return;
        }
        this.Dragging = false;
        this.O.setShowValue(this.ShowsValue);
        zirkelCanvas.repaint();
        if (this.P3 == null) {
            zirkelCanvas.clearSelected();
            this.A.round();
            if (this.Moved < 5) {
                this.A.edit(zirkelCanvas);
                if (this.A instanceof FixedAngleObject && this.A.isEditAborted()) {
                    zirkelCanvas.delete(this.A);
                    this.reset(zirkelCanvas);
                    return;
                }
            }
            this.A.validate();
            zirkelCanvas.check();
        } else {
            this.P3.updateText();
        }
        this.reset(zirkelCanvas);
        zirkelCanvas.showStatus();
    }

    public PointObject select(int n, int n2, ZirkelCanvas zirkelCanvas) {
        return zirkelCanvas.selectCreatePoint(n, n2);
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        super.reset(zirkelCanvas);
        if (zirkelCanvas.Visual) {
            this.P3 = null;
            this.P2 = null;
            this.P1 = null;
            this.showStatus(zirkelCanvas);
        } else {
            zirkelCanvas.setPrompt(Zirkel.name("prompt.angle"));
        }
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.Fixed) {
            if (this.P1 == null) {
                zirkelCanvas.showStatus(Zirkel.name("message.fixedangle.first"));
            } else if (this.P2 == null) {
                zirkelCanvas.showStatus(Zirkel.name("message.fixedangle.root"));
            } else {
                zirkelCanvas.showStatus(Zirkel.name("message.fixedangle.second"));
            }
        } else if (this.P1 == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.angle.first"));
        } else if (this.P2 == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.angle.root"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.angle.second"));
        }
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        Object object;
        ConstructionObject constructionObject;
        if (!this.testTree(xmlTree, "Angle")) {
            return false;
        }
        XmlTag xmlTag = xmlTree.getTag();
        if (!xmlTag.hasParam("first")) {
            constructionObject = new AngleObject(construction);
            try {
                if (xmlTag.hasParam("display")) {
                    object = xmlTag.getValue("display");
                    if (((String)object).equals("small")) {
                        ((AngleObject)constructionObject).setDisplaySize(0);
                    }
                    if (((String)object).equals("large")) {
                        ((AngleObject)constructionObject).setDisplaySize(3);
                    }
                    if (((String)object).equals("larger")) {
                        ((AngleObject)constructionObject).setDisplaySize(2);
                    }
                    if (((String)object).equals("rectangle")) {
                        ((AngleObject)constructionObject).setDisplaySize(4);
                    }
                }
                this.setName(xmlTag, constructionObject);
                this.set(xmlTree, constructionObject);
                construction.add(constructionObject);
                this.setConditionals(xmlTree, construction, constructionObject);
                if (xmlTag.hasTrueParam("filled")) {
                    ((AngleObject)constructionObject).setFilled(true);
                }
                if (xmlTag.hasParam("fixed")) {
                    ((AngleObject)constructionObject).setFixed(xmlTag.getValue("fixed"));
                }
                if (xmlTag.hasTrueParam("acute")) {
                    constructionObject.setObtuse(false);
                } else {
                    constructionObject.setObtuse(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!xmlTag.hasParam("first") || !xmlTag.hasParam("root")) {
            throw new ConstructionException("Angle parameters missing!");
        }
        if (xmlTag.hasParam("second")) {
            try {
                constructionObject = (PointObject)construction.find(xmlTag.getValue("first"));
                object = (PointObject)construction.find(xmlTag.getValue("root"));
                PointObject pointObject = (PointObject)construction.find(xmlTag.getValue("second"));
                AngleObject angleObject = new AngleObject(construction, (PointObject)constructionObject, (PointObject)object, pointObject);
                if (xmlTag.hasParam("display")) {
                    String string = xmlTag.getValue("display");
                    if (string.equals("small")) {
                        angleObject.setDisplaySize(0);
                    }
                    if (string.equals("large")) {
                        angleObject.setDisplaySize(3);
                    }
                    if (string.equals("larger")) {
                        angleObject.setDisplaySize(2);
                    }
                    if (string.equals("rectangle")) {
                        angleObject.setDisplaySize(4);
                    }
                }
                this.setName(xmlTag, angleObject);
                this.set(xmlTree, angleObject);
                construction.add(angleObject);
                this.setConditionals(xmlTree, construction, angleObject);
                if (xmlTag.hasTrueParam("filled")) {
                    angleObject.setFilled(true);
                }
                if (xmlTag.hasParam("fixed")) {
                    angleObject.setFixed(xmlTag.getValue("fixed"));
                }
                if (xmlTag.hasTrueParam("acute")) {
                    angleObject.setObtuse(false);
                }
                angleObject.setObtuse(true);
            }
            catch (ConstructionException constructionException) {
                throw constructionException;
            }
            catch (Exception exception) {
                throw new ConstructionException("Angle parameters illegal!");
            }
        } else {
            try {
                constructionObject = (PointObject)construction.find(xmlTag.getValue("first"));
                object = (PointObject)construction.find(xmlTag.getValue("root"));
                FixedAngleObject fixedAngleObject = new FixedAngleObject(construction, (PointObject)constructionObject, (PointObject)object, 0.0, 0.0);
                if (xmlTag.hasParam("display")) {
                    String string = xmlTag.getValue("display");
                    if (string.equals("small")) {
                        fixedAngleObject.setDisplaySize(0);
                    }
                    if (string.equals("large")) {
                        fixedAngleObject.setDisplaySize(3);
                    }
                    if (string.equals("larger")) {
                        fixedAngleObject.setDisplaySize(2);
                    }
                    if (string.equals("rectangle")) {
                        fixedAngleObject.setDisplaySize(4);
                    }
                }
                this.setName(xmlTag, fixedAngleObject);
                this.set(xmlTree, fixedAngleObject);
                construction.add(fixedAngleObject);
                this.setConditionals(xmlTree, construction, fixedAngleObject);
                if (xmlTag.hasTrueParam("filled")) {
                    fixedAngleObject.setFilled(true);
                }
                if (xmlTag.hasTrueParam("acute")) {
                    fixedAngleObject.setObtuse(false);
                } else {
                    fixedAngleObject.setObtuse(true);
                }
                if (xmlTag.hasTrueParam("inverse")) {
                    fixedAngleObject.setInverse(true);
                } else {
                    fixedAngleObject.setInverse(false);
                }
                if (xmlTag.hasTrueParam("reduced")) {
                    fixedAngleObject.setReduced(true);
                } else {
                    fixedAngleObject.setReduced(false);
                }
                if (xmlTag.hasTrueParam("dragable")) {
                    fixedAngleObject.setDragable(true);
                }
                if (xmlTag.hasTrueParam("drawable")) {
                    fixedAngleObject.setDragable(true);
                }
                if (!xmlTag.hasParam("fixed")) {
                    throw new ConstructionException("");
                }
                fixedAngleObject.setFixed(xmlTag.getValue("fixed"));
            }
            catch (ConstructionException constructionException) {
                throw constructionException;
            }
            catch (Exception exception) {
                throw new ConstructionException("Angle parameters illegal!");
            }
        }
        return true;
    }

    public String getTag() {
        return "Angle";
    }

    public void construct(Construction construction, String string, String[] stringArray, int n) throws ConstructionException {
        if (n != 3) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        ConstructionObject constructionObject = construction.find(stringArray[0]);
        if (constructionObject == null) {
            throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[0]);
        }
        ConstructionObject constructionObject2 = construction.find(stringArray[1]);
        if (constructionObject2 == null) {
            throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[1]);
        }
        ConstructionObject constructionObject3 = construction.find(stringArray[2]);
        if (constructionObject3 == null || !(constructionObject3 instanceof PointObject)) {
            Expression expression = new Expression(stringArray[2], construction, null);
            if (!expression.isValid()) {
                throw new ConstructionException(Zirkel.name("exception.expression"));
            }
            FixedAngleObject fixedAngleObject = new FixedAngleObject(construction, (PointObject)constructionObject, (PointObject)constructionObject2, 0.0, 0.0);
            fixedAngleObject.setFixed(stringArray[2]);
            if (!string.equals("")) {
                fixedAngleObject.setNameCheck(string);
            }
            construction.add(fixedAngleObject);
            fixedAngleObject.setDefaults();
            fixedAngleObject.setObtuse(true);
            fixedAngleObject.setFixed(stringArray[2]);
            fixedAngleObject.validate();
            return;
        }
        if (!(constructionObject instanceof PointObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[0]);
        }
        if (!(constructionObject2 instanceof PointObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[1]);
        }
        if (!(constructionObject3 instanceof PointObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[2]);
        }
        if (constructionObject == constructionObject2 || constructionObject2 == constructionObject3) {
            throw new ConstructionException(Zirkel.name("exception.parameter"));
        }
        AngleObject angleObject = new AngleObject(construction, (PointObject)constructionObject, (PointObject)constructionObject2, (PointObject)constructionObject3);
        if (!string.equals("")) {
            angleObject.setNameCheck(string);
        }
        construction.add(angleObject);
        angleObject.setDefaults();
    }
}

