#!/usr/bin/python3

from distutils.core import setup
from DistUtilsExtra.command import (build_extra, build_i18n)
import glob

setup(
    name='command-not-found',
    version='0.3',
    packages=['CommandNotFound'],
    scripts=['command-not-found'],
    cmdclass={"build": build_extra.build_extra,
                "build_i18n": build_i18n.build_i18n,
                },
    data_files=[
        ('share/command-not-found/programs.d', glob.glob("data/programs.d/*")),
        ('share/command-not-found/', ['data/priority.txt']),
        ('../etc', ['bash_command_not_found', 'zsh_command_not_found']),
    ])
