static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2010 Martin Nordholts <martinn@src.gnome.org>                    \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"/tmp/gegl-buffer.gegl\")             \n"
"  description(_(\"Path of GeglBuffer file to load.\"))                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE gegl-buffer-load-op.c                                \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_buffer_load_op_ensure_buffer (GeglProperties *o)                         \n"
"{                                                                             \n"
"  if (!o->user_data)                                                          \n"
"    o->user_data = gegl_buffer_load (o->path);                                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"gegl_buffer_load_op_get_bounding_box (GeglOperation *operation)               \n"
"{                                                                             \n"
"  GeglRectangle  result = { 0, 0, 0, 0 };                                     \n"
"  GeglProperties    *o      = GEGL_PROPERTIES (operation);                    \n"
"                                                                              \n"
"  gegl_buffer_load_op_ensure_buffer (o);                                      \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      result.width  = gegl_buffer_get_width  (GEGL_BUFFER (o->user_data));    \n"
"      result.height = gegl_buffer_get_height (GEGL_BUFFER (o->user_data));    \n"
"    }                                                                         \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"gegl_buffer_load_op_process (GeglOperation        *operation,                 \n"
"                             GeglOperationContext *context,                   \n"
"                             const gchar          *output_pad,                \n"
"                             const GeglRectangle  *result,                    \n"
"                             gint                  level)                     \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  gegl_buffer_load_op_ensure_buffer (o);                                      \n"
"                                                                              \n"
"  gegl_operation_context_take_object (context, output_pad, o->user_data);     \n"
"  o->user_data = NULL;                                                        \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class;                                        \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"                                                                              \n"
"  operation_class->process          = gegl_buffer_load_op_process;            \n"
"  operation_class->get_bounding_box = gegl_buffer_load_op_get_bounding_box;   \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"gegl:gegl-buffer-load\",                               \n"
"    \"categories\" , \"hidden\",                                              \n"
"    \"description\", _(\"GeglBuffer file loader.\"),                          \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  gegl_extension_handler_register (\".gegl\", \"gegl:gegl-buffer-load\");     \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
