'\" t
.TH grolbp @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
grolbp \-
.I groff
output driver for Canon CaPSL printers
.
.
.\" Modified from grolj4 man page by Francisco Andrés Verdú
.\" <pandres@dragonet.es> for the grolbp program.
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1994-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_grolbp_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY grolbp
.RB [ \-l ]
.RB [ \-c\~\c
.IR num-copies ]
.RB [ \-F\~\c
.IR font-directory ]
.RB [ \-o\~\c
.IR orientation ]
.RB [ \-p\~\c
.IR paper-format ]
.RB [ \-w\~\c
.IR width ]
.RI [ file\~ .\|.\|.]
.
.SY grolbp
[\c
.BI \-\-copies= num-copies\c
] [\c
.BI \-\-fontdir= font-directory\c
] [\c
.B \-\-landscape\c
] [\c
.BI \-\-linewidth= width\c
] [\c
.BI \-\-orientation= orientation\c
] [\c
.BI \-\-papersize= paper-format\c
]
.RI [ file\~ .\|.\|.]
.YS
.
.
.SY grolbp
.B \-h
.
.SY grolbp
.B \-\-help
.YS
.
.
.SY grolbp
.B \-v
.
.SY grolbp
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
This GNU
.I roff
output driver translates the output of
.MR @g@troff @MAN1EXT@
into a CaPSL and VDM format suitable for Canon LBP-4 and LBP-8 printers.
.
Normally,
.I grolbp
is invoked by
.MR groff @MAN1EXT@
when the latter is given the
.RB \[lq] \-T\~lbp \[rq]
option.
.
(In this installation,
.B @DEVICE@
is the default output device.)
.
Use
.IR groff 's
.B \-P
option to pass any options shown above to
.IR grolbp .
.
If no
.I file
arguments are given,
or if
.I file
is \[lq]\-\[rq],
.I grolbp
reads the standard input stream.
.
Output is written to the standard output stream.
.
.
.\" ====================================================================
.SS Typefaces
.\" ====================================================================
.
The driver supports the Dutch,
Swiss,
and Swiss-Narrow scalable typefaces,
each in the regular,
bold,
italic,
and bold-italic styles.
.
Additionally,
the bitmapped,
monospaced Courier and Elite typefaces are available in regular,
bold,
and
italic styles;
Courier at 8 and 12 points,
Elite at 8 and 10 points.
.
The following chart summarizes the
.I groff
font names used to access them.
.
.
.P
.TS
tab(|) allbox center;
Cb Cb Cb Cb Cb
L L L L L
.
Typeface | Roman | Bold | Italic | Bold-Italic
Dutch | TR | TB | TI | TBI
Swiss | HR | HB | HI | HBI
Swiss Narrow | HNR | HNB | HNI | HNBI
Courier | CR | CB | CI |
Elite | ER | EB | EI |
.TE
.
.
.\" ====================================================================
.SS "Paper format, orientation, and device description file"
.\" ====================================================================
.
.I grolbp
supports paper formats
.RB \[lq] A4 \[rq],
.RB \[lq] letter \[rq],
.RB \[lq] legal \[rq],
and
.RB \[lq] executive \[rq].
.
These are matched case-insensitively.
.
The
.BR \-p ,
.B \-\-papersize
option overrides any setting in the device description file
.IR DESC .
.
If neither specifies a paper format,
A4 is assumed.
.
.
.P
In its
.I DESC
file,
.I grolbp
(case-insensitively) recognizes an
.B orientation
directive accepting one mandatory argument,
.B portrait
or
.BR landscape .
.
The first valid orientation directive encountered controls.
.\" XXX: This is inconsistent with other description file processing.
.
The
.BR \-l ,
.BR \-o ,
and
.B \-\-orientation
command-line options
override any setting in
.IR DESC .
.
If none of the foregoing specify the orientation,
portrait is assumed.
.
.
.\" ====================================================================
.SS "Font description files"
.\" ====================================================================
.
In addition to the font description file directives documented in
.MR groff_font @MAN5EXT@ ,
.I grolbp
recognizes
.BR lbpname ,
which maps the
.I groff
font name to the font name used internally by the printer.
.
Its syntax is as follows.
.RS
.EX
.RI lbpname\~ printer-font-name
.EE
.RE
.
.
.BR lbpname 's
argument is case-sensitive.
.
The printer's font names are encoded as follows.
.
.
.P
For bitmapped fonts,
.I printer-font_name
has the form
.RS
.EX
.RI N\[la] base-font-name \[ra]\[la] font-style \[ra]
.EE
.RE
.I base-font-name
is the font name as it appears in the printer's font listings without
the first letter,
up to
(but not including)
the font size.
.
.I font-style
can be one of the letters
.BR R ,
.BR I ,
or
.BR B ,
.\" The bold-italic style apparently was not supported for bitmap fonts.
indicating the roman,
italic,
and bold styles,
respectively.
.
For instance,
if the printer's \[lq]font listing A\[rq]
shows \[lq]Nelite12I.ISO_USA\[rq],
the corresponding entry in the
.I groff
font description file is
.RS
.EX
lbpname NeliteI
.EE
.RE
.
You may need to modify
.I grolbp
to add support for new bitmapped fonts,
since the available font names and font sizes of bitmapped fonts
(as documented above)
are hard-coded into the program.
.
.
.P
For scalable fonts,
.I printer-font-name
is identical to the font name as it appears in the printer's \[lq]font
listing A\[rq].
.
For instance,
to select the \[lq]Swiss\[rq] font in bold-italic style,
which appears in the font listing
as \%\[lq]Swiss\-BoldOblique\[rq],
.RS
.EX
lbpname Swiss\-BoldOblique
.EE
.RE
is the required directive,
and this is what we find in the
.I groff
font description file
.I HBI
for the
.B lbp
device.
.
.
.\" ====================================================================
.SS "Drawing commands"
.\" ====================================================================
.
For compatibility with
.MR grolj4 @MAN1EXT@ ,
an additional drawing command is available.
.
.
.TP
.BI \[rs]D\[aq]R\~ "dh dv" \[aq]
Draw a rule
(solid black rectangle)
with one corner at the drawing position,
and the diagonally opposite corner at the drawing position
.RI +( dh , dv ).
.\" XXX , at which the drawing position will be afterward. ?
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-h
and
.B \-\-help
display a usage message,
while
.B \-v
and
.B \-\-version
show version information;
all exit afterward.
.
.
.TP
.BI \-c " num-copies"
.TQ
.BI \-\-copies= num-copies
Produce
.I num-copies
copies of each page.
.
.
.TP
.BI \-F " font-directory"
.TQ
.BI \-\-fontdir= font-directory
Prepend directory
.RI font-directory /dev name
to the search path for font and device description files;
.I name
is the name of the device,
usually
.BR lbp .
.
.
.TP
.B \-l
.TQ
.B \-\-landscape
Format the document in landscape orientation.
.
.
.TP
.BI \-o " orientation"
.TQ
.BI \-\-orientation= orientation
Format the document in the given
.IR orientation ,
which must be
.RB \%\[lq] portrait \[rq]
or
.RB \%\[lq] landscape \[rq].
.
.
.TP
.BI \-p " paper-format"
.TQ
.BI \-\-papersize= paper-format
Set the paper format to
.IR paper-format ,
which must be a valid paper format as described above.
.
.
.TP
.BI \-w " width"
.TQ
.BI \-\-linewidth= width
Set the default line thickness to
.I width
thousandths of an em;
the default is
.B 40
(0.04\~em).
.
.
.\" ====================================================================
.SH Environment
.\" ====================================================================
.
.TP
.I GROFF_FONT_PATH
lists directories in which to seek the selected output device's
directory of device and font description files.
.
See
.MR @g@troff @MAN1EXT@
and
.MR groff_font @MAN5EXT@ .
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I @FONTDIR@/\:\%devlbp/\:DESC
describes the
.B lbp
output device.
.
.
.TP
.IR @FONTDIR@/\:\%devlbp/ F
describes the font known
.RI as\~ F
on device
.BR lbp .
.
.
.TP
.I @MACRODIR@/\:lbp\:.tmac
defines macros for use with the
.B lbp
output device.
.
It is automatically loaded by
.I troffrc
when the
.B lbp
output device is selected.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.MR groff @MAN1EXT@ ,
.MR @g@troff @MAN1EXT@ ,
.MR groff_out @MAN5EXT@ ,
.MR groff_font @MAN5EXT@ ,
.MR groff_char @MAN7EXT@
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_grolbp_1_man_C]
.do rr *groff_grolbp_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
