#!/bin/bash
TEMPDIR=`mktemp -d /tmp/tmp.XXXXXXXXXX`
trap "rm -rf $TEMPDIR" EXIT
CFGFILE=heat.conf.sample
GENERATOR=tools/config/generate_sample.sh
mkdir -p $TEMPDIR/{a,b}/etc/heat
cp etc/heat/$CFGFILE $TEMPDIR/a/etc/heat
$GENERATOR -b ./ -p heat -o $TEMPDIR/b/etc/heat &> /dev/null
if [ ! -f "$TEMPDIR/b/etc/heat/$CFGFILE" ]; then
    echo "Error: $CFGFILE can not be generated by $GENERATOR." 1>&2
    exit 2
elif ! (cd $TEMPDIR; diff -Naur a b); then
    echo "Error: $CFGFILE is not up to date, please run $GENERATOR." 1>&2
    exit 42
fi
