; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc < %s -mtriple=arm64-eabi | FileCheck %s
; RUN: llc < %s -mtriple=arm64-eabi -global-isel -global-isel-abort=1 | FileCheck %s
; RUN: llc < %s -mtriple=arm64-eabi -global-isel -global-isel-abort=1 -stop-after=irtranslator | FileCheck %s --check-prefix=GISEL-MIR

%struct.A = type { i8 }
%struct.B = type { i32 }
%struct.C = type { %struct.B }
%struct.D = type { %struct.B }
%struct.E = type { %struct.B, %struct.B }

declare %struct.A* @A_ctor_base(%struct.A* returned)
declare %struct.B* @B_ctor_base(%struct.B* returned, i32)
declare %struct.B* @B_ctor_complete(%struct.B* returned, i32)

declare %struct.A* @A_ctor_base_nothisret(%struct.A*)
declare %struct.B* @B_ctor_base_nothisret(%struct.B*, i32)
declare %struct.B* @B_ctor_complete_nothisret(%struct.B*, i32)

define %struct.C* @C_ctor_base(%struct.C* returned %this, i32 %x) {
  ; GISEL-MIR-LABEL: name: C_ctor_base
  ; GISEL-MIR: bb.1.entry:
  ; GISEL-MIR:   liveins: $w1, $x0
  ; GISEL-MIR:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; GISEL-MIR:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; GISEL-MIR:   ADJCALLSTACKDOWN 0, 0, implicit-def $sp, implicit $sp
  ; GISEL-MIR:   $x0 = COPY [[COPY]](p0)
  ; GISEL-MIR:   BL @A_ctor_base, csr_aarch64_aapcs_thisreturn, implicit-def $lr, implicit $sp, implicit $x0
  ; GISEL-MIR:   [[COPY2:%[0-9]+]]:_(p0) = COPY [[COPY]](p0)
  ; GISEL-MIR:   ADJCALLSTACKUP 0, 0, implicit-def $sp, implicit $sp
  ; GISEL-MIR:   $x0 = COPY [[COPY]](p0)
  ; GISEL-MIR:   $w1 = COPY [[COPY1]](s32)
  ; GISEL-MIR:   TCRETURNdi @B_ctor_base, 0, csr_aarch64_aapcs, implicit $sp, implicit $x0, implicit $w1
entry:
; CHECK-LABEL: C_ctor_base:
; CHECK-NOT: mov {{x[0-9]+}}, x0
; CHECK: bl {{_?A_ctor_base}}
; CHECK-NOT: mov x0, {{x[0-9]+}}
; CHECK: b {{_?B_ctor_base}}
  %0 = bitcast %struct.C* %this to %struct.A*
  %call = tail call %struct.A* @A_ctor_base(%struct.A* returned %0)
  %1 = getelementptr inbounds %struct.C, %struct.C* %this, i32 0, i32 0
  %call2 = tail call %struct.B* @B_ctor_base(%struct.B* returned %1, i32 %x)
  ret %struct.C* %this
}

define %struct.C* @C_ctor_base_nothisret(%struct.C* %this, i32 %x) {
  ; GISEL-MIR-LABEL: name: C_ctor_base_nothisret
  ; GISEL-MIR: bb.1.entry:
  ; GISEL-MIR:   liveins: $w1, $x0
  ; GISEL-MIR:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; GISEL-MIR:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; GISEL-MIR:   ADJCALLSTACKDOWN 0, 0, implicit-def $sp, implicit $sp
  ; GISEL-MIR:   $x0 = COPY [[COPY]](p0)
  ; GISEL-MIR:   BL @A_ctor_base_nothisret, csr_aarch64_aapcs, implicit-def $lr, implicit $sp, implicit $x0, implicit-def $x0
  ; GISEL-MIR:   [[COPY2:%[0-9]+]]:_(p0) = COPY $x0
  ; GISEL-MIR:   ADJCALLSTACKUP 0, 0, implicit-def $sp, implicit $sp
  ; GISEL-MIR:   ADJCALLSTACKDOWN 0, 0, implicit-def $sp, implicit $sp
  ; GISEL-MIR:   $x0 = COPY [[COPY]](p0)
  ; GISEL-MIR:   $w1 = COPY [[COPY1]](s32)
  ; GISEL-MIR:   BL @B_ctor_base_nothisret, csr_aarch64_aapcs, implicit-def $lr, implicit $sp, implicit $x0, implicit $w1, implicit-def $x0
  ; GISEL-MIR:   [[COPY3:%[0-9]+]]:_(p0) = COPY $x0
  ; GISEL-MIR:   ADJCALLSTACKUP 0, 0, implicit-def $sp, implicit $sp
  ; GISEL-MIR:   $x0 = COPY [[COPY]](p0)
  ; GISEL-MIR:   RET_ReallyLR implicit $x0
entry:
; CHECK-LABEL: C_ctor_base_nothisret:
; CHECK: mov [[SAVETHIS:x[0-9]+]], x0
; CHECK: bl {{_?A_ctor_base_nothisret}}
; CHECK: mov x0, [[SAVETHIS]]
; CHECK-NOT: b {{_?B_ctor_base_nothisret}}
  %0 = bitcast %struct.C* %this to %struct.A*
  %call = tail call %struct.A* @A_ctor_base_nothisret(%struct.A* %0)
  %1 = getelementptr inbounds %struct.C, %struct.C* %this, i32 0, i32 0
  %call2 = tail call %struct.B* @B_ctor_base_nothisret(%struct.B* %1, i32 %x)
  ret %struct.C* %this
}

define %struct.C* @C_ctor_complete(%struct.C* %this, i32 %x) {
  ; GISEL-MIR-LABEL: name: C_ctor_complete
  ; GISEL-MIR: bb.1.entry:
  ; GISEL-MIR:   liveins: $w1, $x0
  ; GISEL-MIR:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; GISEL-MIR:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; GISEL-MIR:   $x0 = COPY [[COPY]](p0)
  ; GISEL-MIR:   $w1 = COPY [[COPY1]](s32)
  ; GISEL-MIR:   TCRETURNdi @C_ctor_base, 0, csr_aarch64_aapcs, implicit $sp, implicit $x0, implicit $w1
entry:
; CHECK-LABEL: C_ctor_complete:
; CHECK: b {{_?C_ctor_base}}
  %call = tail call %struct.C* @C_ctor_base(%struct.C* returned %this, i32 %x)
  ret %struct.C* %this
}

define %struct.C* @C_ctor_complete_nothisret(%struct.C* %this, i32 %x) {
  ; GISEL-MIR-LABEL: name: C_ctor_complete_nothisret
  ; GISEL-MIR: bb.1.entry:
  ; GISEL-MIR:   liveins: $w1, $x0
  ; GISEL-MIR:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; GISEL-MIR:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; GISEL-MIR:   ADJCALLSTACKDOWN 0, 0, implicit-def $sp, implicit $sp
  ; GISEL-MIR:   $x0 = COPY [[COPY]](p0)
  ; GISEL-MIR:   $w1 = COPY [[COPY1]](s32)
  ; GISEL-MIR:   BL @C_ctor_base_nothisret, csr_aarch64_aapcs, implicit-def $lr, implicit $sp, implicit $x0, implicit $w1, implicit-def $x0
  ; GISEL-MIR:   [[COPY2:%[0-9]+]]:_(p0) = COPY $x0
  ; GISEL-MIR:   ADJCALLSTACKUP 0, 0, implicit-def $sp, implicit $sp
  ; GISEL-MIR:   $x0 = COPY [[COPY]](p0)
  ; GISEL-MIR:   RET_ReallyLR implicit $x0
entry:
; CHECK-LABEL: C_ctor_complete_nothisret:
; CHECK-NOT: b {{_?C_ctor_base_nothisret}}
  %call = tail call %struct.C* @C_ctor_base_nothisret(%struct.C* %this, i32 %x)
  ret %struct.C* %this
}

define %struct.D* @D_ctor_base(%struct.D* %this, i32 %x) {
  ; GISEL-MIR-LABEL: name: D_ctor_base
  ; GISEL-MIR: bb.1.entry:
  ; GISEL-MIR:   liveins: $w1, $x0
  ; GISEL-MIR:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; GISEL-MIR:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; GISEL-MIR:   ADJCALLSTACKDOWN 0, 0, implicit-def $sp, implicit $sp
  ; GISEL-MIR:   $x0 = COPY [[COPY]](p0)
  ; GISEL-MIR:   $w1 = COPY [[COPY1]](s32)
  ; GISEL-MIR:   BL @B_ctor_complete, csr_aarch64_aapcs_thisreturn, implicit-def $lr, implicit $sp, implicit $x0, implicit $w1
  ; GISEL-MIR:   [[COPY2:%[0-9]+]]:_(p0) = COPY [[COPY]](p0)
  ; GISEL-MIR:   ADJCALLSTACKUP 0, 0, implicit-def $sp, implicit $sp
  ; GISEL-MIR:   $x0 = COPY [[COPY]](p0)
  ; GISEL-MIR:   $w1 = COPY [[COPY1]](s32)
  ; GISEL-MIR:   TCRETURNdi @B_ctor_complete, 0, csr_aarch64_aapcs, implicit $sp, implicit $x0, implicit $w1
entry:
; CHECK-LABEL: D_ctor_base:
; CHECK-NOT: mov {{x[0-9]+}}, x0
; CHECK: bl {{_?B_ctor_complete}}
; CHECK-NOT: mov x0, {{x[0-9]+}}
; CHECK: b {{_?B_ctor_complete}}
  %b = getelementptr inbounds %struct.D, %struct.D* %this, i32 0, i32 0
  %call = tail call %struct.B* @B_ctor_complete(%struct.B* returned %b, i32 %x)
  %call2 = tail call %struct.B* @B_ctor_complete(%struct.B* returned %b, i32 %x)
  ret %struct.D* %this
}

define %struct.E* @E_ctor_base(%struct.E* %this, i32 %x) {
  ; GISEL-MIR-LABEL: name: E_ctor_base
  ; GISEL-MIR: bb.1.entry:
  ; GISEL-MIR:   liveins: $w1, $x0
  ; GISEL-MIR:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; GISEL-MIR:   [[COPY1:%[0-9]+]]:_(s32) = COPY $w1
  ; GISEL-MIR:   ADJCALLSTACKDOWN 0, 0, implicit-def $sp, implicit $sp
  ; GISEL-MIR:   $x0 = COPY [[COPY]](p0)
  ; GISEL-MIR:   $w1 = COPY [[COPY1]](s32)
  ; GISEL-MIR:   BL @B_ctor_complete, csr_aarch64_aapcs_thisreturn, implicit-def $lr, implicit $sp, implicit $x0, implicit $w1
  ; GISEL-MIR:   [[COPY2:%[0-9]+]]:_(p0) = COPY [[COPY]](p0)
  ; GISEL-MIR:   ADJCALLSTACKUP 0, 0, implicit-def $sp, implicit $sp
  ; GISEL-MIR:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 4
  ; GISEL-MIR:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[C]](s64)
  ; GISEL-MIR:   ADJCALLSTACKDOWN 0, 0, implicit-def $sp, implicit $sp
  ; GISEL-MIR:   $x0 = COPY [[PTR_ADD]](p0)
  ; GISEL-MIR:   $w1 = COPY [[COPY1]](s32)
  ; GISEL-MIR:   BL @B_ctor_complete, csr_aarch64_aapcs_thisreturn, implicit-def $lr, implicit $sp, implicit $x0, implicit $w1
  ; GISEL-MIR:   [[COPY3:%[0-9]+]]:_(p0) = COPY [[PTR_ADD]](p0)
  ; GISEL-MIR:   ADJCALLSTACKUP 0, 0, implicit-def $sp, implicit $sp
  ; GISEL-MIR:   $x0 = COPY [[COPY]](p0)
  ; GISEL-MIR:   RET_ReallyLR implicit $x0
entry:
; CHECK-LABEL: E_ctor_base:
; CHECK-NOT: b {{_?B_ctor_complete}}
  %b = getelementptr inbounds %struct.E, %struct.E* %this, i32 0, i32 0
  %call = tail call %struct.B* @B_ctor_complete(%struct.B* returned %b, i32 %x)
  %b2 = getelementptr inbounds %struct.E, %struct.E* %this, i32 0, i32 1
  %call2 = tail call %struct.B* @B_ctor_complete(%struct.B* returned %b2, i32 %x)
  ret %struct.E* %this
}
