/*
 * base64.h - Base 64 encoding/decoding implementation
 * Copyright (C) 2006 Collabora Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __BASE64_H__
#define __BASE64_H__

#include <glib.h>

gchar *_lm_base64_encode (const gchar *str, gsize n);
gchar *_lm_base64_decode (const gchar *str, gsize *len);

#define base64_encode _lm_base64_encode
#define base64_decode _lm_base64_decode

#endif /* __BASE64_H__ */
