/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.sample;

import [Ljava.lang.String;;
import com.claritysys.jvm.builder.ArrayClassLoader;
import com.claritysys.jvm.builder.CodeBuilder;
import com.claritysys.jvm.classfile.CfMethod;
import com.claritysys.jvm.classfile.ClassFile;
import com.claritysys.jvm.classfile.ClassFileFormatException;
import com.claritysys.jvm.classfile.JVM;
import com.claritysys.jvm.disassembler.Disassembler;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;

public final class SampleHelloWorld
implements JVM {
    public static void main(String[] args) throws ClassFileFormatException {
        ClassFile cf = new ClassFile("Hello", "java/lang/Object", "Generated from SampleHelloWorld");
        CfMethod method = cf.addMethod(9, "main", "([Ljava/lang/String;)V");
        CodeBuilder code = new CodeBuilder(method);
        code.addImport("java.io.PrintStream");
        code.addImport("java.lang.String");
        code.addImport("java.lang.System");
        code.add((short)178, "@PrintStream", "@System.out");
        code.add((short)18, "Hello world!");
        code.add((short)182, "@PrintStream.println(String)");
        code.add((short)177);
        code.flush();
        System.out.println("\nHere is the generated class:");
        ClassFile cfCopy = ClassFile.fromArray(cf.writeToArray());
        OutputStreamWriter sysOut = new OutputStreamWriter(System.out);
        Disassembler disassembler = new Disassembler(cfCopy, sysOut);
        disassembler.disassemble();
        System.out.println("\nDynamically loading and executing class: ");
        ArrayClassLoader loader = new ArrayClassLoader();
        loader.addCachedType(cf);
        Class<?> helloClass = null;
        try {
            helloClass = loader.loadClass("Hello");
        }
        catch (ClassNotFoundException e) {
            System.out.println("  **Error loading generated class: " + e);
            System.exit(1);
        }
        try {
            Method methodMain = helloClass.getDeclaredMethod("main", String;.class);
            System.out.print("  - Output from generated class:  ");
            System.out.flush();
            methodMain.invoke(null, new Object[]{null});
        }
        catch (Exception e) {
            System.out.println("  **Error invoking method: " + e);
            System.exit(1);
        }
    }
}

