/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.result;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import jd.io.Encoding;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.XsltResult;
import jd.xml.xslt.format.OutputFormat;
import jd.xml.xslt.result.AttributeList;
import jd.xml.xslt.result.NamespaceSupport;
import jd.xml.xslt.result.ResultBuilder;
import jd.xml.xslt.result.output.Output;
import jd.xml.xslt.result.output.OutputFactory;

public abstract class MarkupResultBuilder
extends ResultBuilder {
    protected static final Encoding UTF_8 = Encoding.forName("UTF-8");
    protected static final int BUFFER_SIZE = 4096;
    protected static final int MAX_POS = 4095;
    protected OutputFormat outputFormat_;
    protected XsltResult result_;
    protected Encoding encoding_;
    protected boolean outNewLine_;
    protected boolean outAutoFlush_;
    protected boolean indent_;
    protected boolean elementStarted_;
    protected Output output_;
    protected NamespaceSupport nsSupport_;
    protected AttributeList attributes_;
    private int outIndent_;

    public MarkupResultBuilder(XsltResult xsltResult) {
        super(xsltResult.getUri());
        this.result_ = xsltResult;
    }

    public void startDocument(OutputFormat outputFormat) {
        this.outputFormat_ = outputFormat;
        this.encoding_ = outputFormat.getEncoding(UTF_8);
        this.outIndent_ = 0;
        this.outNewLine_ = true;
        this.nsSupport_ = new NamespaceSupport();
        this.attributes_ = new AttributeList();
        if (this.result_.getWriter() != null) {
            this.output_ = OutputFactory.createOutput(this.result_.getWriter());
        } else {
            try {
                OutputStream outputStream = this.result_.getOutputStream();
                this.outAutoFlush_ = outputStream == System.out || outputStream == System.err;
                this.output_ = OutputFactory.createOutput(outputStream, this.encoding_);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.convertException(unsupportedEncodingException);
            }
        }
    }

    public void endDocument() {
        this.flushNode(false);
        try {
            if (!this.outNewLine_) {
                this.println();
            }
            this.output_.flush();
        }
        catch (Exception exception) {
            this.convertException(exception);
        }
    }

    public void addComment(String string) {
        this.flushNode(true);
        if (this.indent_) {
            this.printLineBreak();
        }
        Output output = this.output_;
        output.printSmallByte('<');
        output.printSmallByte('!');
        output.printSmallByte('-');
        output.printSmallByte('-');
        output.printString(string);
        output.printSmallByte('-');
        output.printSmallByte('-');
        output.printSmallByte('>');
    }

    public void addAttribute(String string, String string2, String string3, String string4) {
        if (!this.elementStarted_) {
            throw new XsltException("cannot add attribute " + string + "='" + string4 + "' (no element open)");
        }
        if (string3 != null) {
            string = this.nsSupport_.adjustAttributeName(string, string2, string3);
        }
        this.attributes_.add(string, string4);
    }

    public void addNamespace(String string, String string2, boolean bl) {
        if (bl) {
            if (!this.elementStarted_) {
                return;
            }
            if (this.attributes_.size() != 0) {
                return;
            }
        }
        this.nsSupport_.addDeclaration(string, string2, !bl);
    }

    public String getNamespacePrefix(String string) {
        return this.nsSupport_.getPrefix(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        try {
            if (this.output_ != null) {
                this.output_.flush();
            }
        }
        finally {
            this.result_.cleanup();
        }
    }

    protected final void println() {
        this.output_.printSmallByte('\n');
        this.outNewLine_ = true;
        if (this.outAutoFlush_) {
            this.output_.flush();
        }
    }

    protected final void printAttribute(String string, String string2) {
        Output output = this.output_;
        output.printSmallByte(' ');
        output.printString(string);
        output.printSmallByte('=');
        output.printSmallByte('\"');
        output.printString(string2);
        output.printSmallByte('\"');
    }

    protected final boolean printCharReference(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = n >= 55296 && n <= 56319 && n2 >= 0;
        if (bl) {
            n = (n - 55296) * 1024 + (n2 - 56320) + 65536;
        }
        Output output = this.output_;
        output.printSmallByte('&');
        output.printSmallByte('#');
        output.printString(Integer.toString(n));
        output.printSmallByte(';');
        return bl;
    }

    protected final int printCharReference(char c, String string, int n, int n2) {
        int n3 = n < n2 - 1 ? (int)string.charAt(n + 1) : -1;
        return this.printCharReference(c, n3) ? n + 1 : n;
    }

    protected final void printIndent() {
        this.outNewLine_ = false;
        this.output_.printSmallBytes(' ', this.outIndent_);
    }

    protected final void increasePrintIndent() {
        this.outIndent_ += 2;
    }

    protected final void decreasePrintIndent() {
        this.outIndent_ -= 2;
    }

    protected abstract void printLineBreak();

    protected abstract void flushNode(boolean var1);
}

