%define name libe-book
%define version 0.0.3
%define RELEASE 1
%define release     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}

Name: %{name}
Summary: Library for reading and converting reflowable e-book formats
Version: %{version}
Release: %{release}
Source: %{name}-%{version}.tar.xz
Group: System Environment/Libraries
URL: http://libe-book.sf.net/
BuildRoot: %{_tmppath}/%{name}-%{version}-buildroot
BuildRequires: libwpd-devel >= 0.9.0, gcc-c++, libstdc++-devel, pkgconfig >= 0.9.0
License: LGPLv2.1+ or MPLv2.0+
Prefix: %{prefix}

%description
libe-book is a library for reading and converting reflowable e-book formats

%package tools
Requires: libe-book
Summary: Tools to convert reflowable e-books into other formats
Group: Applications/Publishing

%description tools
Tools to convert EBOOK images into other formats.
Currently supported: raw svg

%package devel
Requires: %{name} >= %{version}
Requires: libwpd-devel >= 0.9.0
Summary: Files for developing with libe-book.
Group: Development/Libraries

%description devel
Includes and definitions for developing with libe-book.

%if %{!?_without_docs:1}%{?_without_docs:0}
%package docs
Requires: %{name} >= %{version}
BuildRequires: doxygen
Summary: Documentation of libe-book API
Group: Development/Documentation

%description docs
Documentation of libe-book API for developing with libe-book
%endif

%prep
%__rm -rf $RPM_BUILD_ROOT

%setup -q -n %{name}-%{version}

%build
%configure --prefix=%{_prefix} --libdir=%{_libdir} \
        %{?_with_debug:--enable-debug}  \

%__make

%install
umask 022

%__make DESTDIR=$RPM_BUILD_ROOT install
%__rm -rf $RPM_BUILD_ROOT/%{_libdir}/libe-book*.la

%clean
%__rm -rf $RPM_BUILD_ROOT $RPM_BUILD_DIR/file.list.%{name}

%files
%defattr(644,root,root,755)
%{_libdir}/libe-book*.so.*
%doc ChangeLog README COPYING AUTHORS

%files tools
%defattr(755,root,root,755)
%{_bindir}/pdb2*

%files devel
%defattr(644,root,root,755)
%{_libdir}/libe-book*.so
%{_libdir}/pkgconfig/libe-book*.pc
%{_includedir}/libe-book-0.0/libe-book

%if %{!?_without_docs:1}%{?_without_docs:0}
%files docs
%{_datadir}/*
%endif

%changelog
* Sun May 19 2013 David Tardon <dtardon@redhat.com>
- Copy spec from libcdr
