#include <stdlib.h>
#include <stdio.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"

#include "uwa-test-client.h"

#define ICON_URL "http://www.ubuntu.com/sites/www.ubuntu.com/files/active/02_ubuntu/U_homepage/picto-desktop.png"

static GMainLoop *mainloop = NULL;
static gint count = 0;

static void
playlist_activated (UnityWebappsContext *context,
		    const gchar *playlist_name,
		    gpointer user_data)
{
  count ++;
  printf("Playlist activated: %s \n", playlist_name);
  
  if (count == 3)
    {
      g_main_loop_quit (mainloop);
    }
}

static void
context_ready (UnityWebappsContext *context, gpointer user_data)
{
  const gchar *playlists[] = {"Playlist1", "Playlist2", "Playlist3", NULL};

  
  unity_webapps_music_player_set_track (context, "Test artist",
					"Test album",
					"Playlist Test",
					ICON_URL);
  unity_webapps_music_player_set_playlists (context, playlists);
  
  unity_webapps_music_player_on_playlist_activated_callback (context, playlist_activated, NULL);

  printf("Activate on test music player \n");

}

gint
main (gint argc, gchar **argv)
{
  UnityWebappsService *service;
  
  g_type_init ();
  
  service = unity_webapps_service_new ();
  
  unity_webapps_context_new (service, "Test", "test.ts", ICON_URL, NULL, context_ready, NULL);
  
  mainloop = g_main_loop_new (NULL, FALSE);
  
  g_main_loop_run (mainloop);
  
  return 0;  
}
