/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the plugins of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file. Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** As a special exception, The Qt Company gives you certain additional
** rights. These rights are described in The Qt Company LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "qbig5codec.h"

QT_BEGIN_NAMESPACE

#ifndef QT_NO_TEXTCODEC
static int qt_Big5hkscsToUnicode(const uchar *s, uint *pwc);
static int qt_UnicodeToBig5hkscs(uint wc, uchar *r);

#define InRange(c, lower, upper)  (((c) >= (lower)) && ((c) <= (upper)))
#define IsLatin(c)        ((c) < 0x80)
#define IsFirstByte(c)        (InRange((c), 0x81, 0xFE))
#define IsSecondByteRange1(c)        (InRange((c), 0x40, 0x7E))
#define IsSecondByteRange2(c)        (InRange((c), 0xA1, 0xFE))
#define IsSecondByte(c)        (IsSecondByteRange1(c) || IsSecondByteRange2(c))

#define        QValidChar(u)        ((u) ? QChar((ushort)(u)) : QChar(QChar::ReplacementCharacter))


int QBig5Codec::_mibEnum()
{
    return 2026;
}

QByteArray QBig5Codec::_name()
{
    return "Big5";
}

struct B5Map {
    ushort x;
    ushort y;
};

struct B5Index {
    const B5Map * table;
    ushort tableSize;
};

// Big 5 to Unicode maping tables.
// Tables are in sorted order on X(all table together) & Y(individually)
static const B5Map b5_8140_to_uc_map[] = {
        /* 0x8140 - 0x8DFE */
         {0x8140,0xeeb8},  {0x8141,0xeeb9},  {0x8142,0xeeba},  {0x8143,0xeebb}, 
         {0x8144,0xeebc},  {0x8145,0xeebd},  {0x8146,0xeebe},  {0x8147,0xeebf}, 
         {0x8148,0xeec0},  {0x8149,0xeec1},  {0x814a,0xeec2},  {0x814b,0xeec3}, 
         {0x814c,0xeec4},  {0x814d,0xeec5},  {0x814e,0xeec6},  {0x814f,0xeec7}, 
         {0x8150,0xeec8},  {0x8151,0xeec9},  {0x8152,0xeeca},  {0x8153,0xeecb}, 
         {0x8154,0xeecc},  {0x8155,0xeecd},  {0x8156,0xeece},  {0x8157,0xeecf}, 
         {0x8158,0xeed0},  {0x8159,0xeed1},  {0x815a,0xeed2},  {0x815b,0xeed3}, 
         {0x815c,0xeed4},  {0x815d,0xeed5},  {0x815e,0xeed6},  {0x815f,0xeed7}, 
         {0x8160,0xeed8},  {0x8161,0xeed9},  {0x8162,0xeeda},  {0x8163,0xeedb}, 
         {0x8164,0xeedc},  {0x8165,0xeedd},  {0x8166,0xeede},  {0x8167,0xeedf}, 
         {0x8168,0xeee0},  {0x8169,0xeee1},  {0x816a,0xeee2},  {0x816b,0xeee3}, 
         {0x816c,0xeee4},  {0x816d,0xeee5},  {0x816e,0xeee6},  {0x816f,0xeee7}, 
         {0x8170,0xeee8},  {0x8171,0xeee9},  {0x8172,0xeeea},  {0x8173,0xeeeb}, 
         {0x8174,0xeeec},  {0x8175,0xeeed},  {0x8176,0xeeee},  {0x8177,0xeeef}, 
         {0x8178,0xeef0},  {0x8179,0xeef1},  {0x817a,0xeef2},  {0x817b,0xeef3}, 
         {0x817c,0xeef4},  {0x817d,0xeef5},  {0x817e,0xeef6},  {0x81a1,0xeef7}, 
         {0x81a2,0xeef8},  {0x81a3,0xeef9},  {0x81a4,0xeefa},  {0x81a5,0xeefb}, 
         {0x81a6,0xeefc},  {0x81a7,0xeefd},  {0x81a8,0xeefe},  {0x81a9,0xeeff}, 
         {0x81aa,0xef00},  {0x81ab,0xef01},  {0x81ac,0xef02},  {0x81ad,0xef03}, 
         {0x81ae,0xef04},  {0x81af,0xef05},  {0x81b0,0xef06},  {0x81b1,0xef07}, 
         {0x81b2,0xef08},  {0x81b3,0xef09},  {0x81b4,0xef0a},  {0x81b5,0xef0b}, 
         {0x81b6,0xef0c},  {0x81b7,0xef0d},  {0x81b8,0xef0e},  {0x81b9,0xef0f}, 
         {0x81ba,0xef10},  {0x81bb,0xef11},  {0x81bc,0xef12},  {0x81bd,0xef13}, 
         {0x81be,0xef14},  {0x81bf,0xef15},  {0x81c0,0xef16},  {0x81c1,0xef17}, 
         {0x81c2,0xef18},  {0x81c3,0xef19},  {0x81c4,0xef1a},  {0x81c5,0xef1b}, 
         {0x81c6,0xef1c},  {0x81c7,0xef1d},  {0x81c8,0xef1e},  {0x81c9,0xef1f}, 
         {0x81ca,0xef20},  {0x81cb,0xef21},  {0x81cc,0xef22},  {0x81cd,0xef23}, 
         {0x81ce,0xef24},  {0x81cf,0xef25},  {0x81d0,0xef26},  {0x81d1,0xef27}, 
         {0x81d2,0xef28},  {0x81d3,0xef29},  {0x81d4,0xef2a},  {0x81d5,0xef2b}, 
         {0x81d6,0xef2c},  {0x81d7,0xef2d},  {0x81d8,0xef2e},  {0x81d9,0xef2f}, 
         {0x81da,0xef30},  {0x81db,0xef31},  {0x81dc,0xef32},  {0x81dd,0xef33}, 
         {0x81de,0xef34},  {0x81df,0xef35},  {0x81e0,0xef36},  {0x81e1,0xef37}, 
         {0x81e2,0xef38},  {0x81e3,0xef39},  {0x81e4,0xef3a},  {0x81e5,0xef3b}, 
         {0x81e6,0xef3c},  {0x81e7,0xef3d},  {0x81e8,0xef3e},  {0x81e9,0xef3f}, 
         {0x81ea,0xef40},  {0x81eb,0xef41},  {0x81ec,0xef42},  {0x81ed,0xef43}, 
         {0x81ee,0xef44},  {0x81ef,0xef45},  {0x81f0,0xef46},  {0x81f1,0xef47}, 
         {0x81f2,0xef48},  {0x81f3,0xef49},  {0x81f4,0xef4a},  {0x81f5,0xef4b}, 
         {0x81f6,0xef4c},  {0x81f7,0xef4d},  {0x81f8,0xef4e},  {0x81f9,0xef4f}, 
         {0x81fa,0xef50},  {0x81fb,0xef51},  {0x81fc,0xef52},  {0x81fd,0xef53}, 
         {0x81fe,0xef54},  {0x8240,0xef55},  {0x8241,0xef56},  {0x8242,0xef57}, 
         {0x8243,0xef58},  {0x8244,0xef59},  {0x8245,0xef5a},  {0x8246,0xef5b}, 
         {0x8247,0xef5c},  {0x8248,0xef5d},  {0x8249,0xef5e},  {0x824a,0xef5f}, 
         {0x824b,0xef60},  {0x824c,0xef61},  {0x824d,0xef62},  {0x824e,0xef63}, 
         {0x824f,0xef64},  {0x8250,0xef65},  {0x8251,0xef66},  {0x8252,0xef67}, 
         {0x8253,0xef68},  {0x8254,0xef69},  {0x8255,0xef6a},  {0x8256,0xef6b}, 
         {0x8257,0xef6c},  {0x8258,0xef6d},  {0x8259,0xef6e},  {0x825a,0xef6f}, 
         {0x825b,0xef70},  {0x825c,0xef71},  {0x825d,0xef72},  {0x825e,0xef73}, 
         {0x825f,0xef74},  {0x8260,0xef75},  {0x8261,0xef76},  {0x8262,0xef77}, 
         {0x8263,0xef78},  {0x8264,0xef79},  {0x8265,0xef7a},  {0x8266,0xef7b}, 
         {0x8267,0xef7c},  {0x8268,0xef7d},  {0x8269,0xef7e},  {0x826a,0xef7f}, 
         {0x826b,0xef80},  {0x826c,0xef81},  {0x826d,0xef82},  {0x826e,0xef83}, 
         {0x826f,0xef84},  {0x8270,0xef85},  {0x8271,0xef86},  {0x8272,0xef87}, 
         {0x8273,0xef88},  {0x8274,0xef89},  {0x8275,0xef8a},  {0x8276,0xef8b}, 
         {0x8277,0xef8c},  {0x8278,0xef8d},  {0x8279,0xef8e},  {0x827a,0xef8f}, 
         {0x827b,0xef90},  {0x827c,0xef91},  {0x827d,0xef92},  {0x827e,0xef93}, 
         {0x82a1,0xef94},  {0x82a2,0xef95},  {0x82a3,0xef96},  {0x82a4,0xef97}, 
         {0x82a5,0xef98},  {0x82a6,0xef99},  {0x82a7,0xef9a},  {0x82a8,0xef9b}, 
         {0x82a9,0xef9c},  {0x82aa,0xef9d},  {0x82ab,0xef9e},  {0x82ac,0xef9f}, 
         {0x82ad,0xefa0},  {0x82ae,0xefa1},  {0x82af,0xefa2},  {0x82b0,0xefa3}, 
         {0x82b1,0xefa4},  {0x82b2,0xefa5},  {0x82b3,0xefa6},  {0x82b4,0xefa7}, 
         {0x82b5,0xefa8},  {0x82b6,0xefa9},  {0x82b7,0xefaa},  {0x82b8,0xefab}, 
         {0x82b9,0xefac},  {0x82ba,0xefad},  {0x82bb,0xefae},  {0x82bc,0xefaf}, 
         {0x82bd,0xefb0},  {0x82be,0xefb1},  {0x82bf,0xefb2},  {0x82c0,0xefb3}, 
         {0x82c1,0xefb4},  {0x82c2,0xefb5},  {0x82c3,0xefb6},  {0x82c4,0xefb7}, 
         {0x82c5,0xefb8},  {0x82c6,0xefb9},  {0x82c7,0xefba},  {0x82c8,0xefbb}, 
         {0x82c9,0xefbc},  {0x82ca,0xefbd},  {0x82cb,0xefbe},  {0x82cc,0xefbf}, 
         {0x82cd,0xefc0},  {0x82ce,0xefc1},  {0x82cf,0xefc2},  {0x82d0,0xefc3}, 
         {0x82d1,0xefc4},  {0x82d2,0xefc5},  {0x82d3,0xefc6},  {0x82d4,0xefc7}, 
         {0x82d5,0xefc8},  {0x82d6,0xefc9},  {0x82d7,0xefca},  {0x82d8,0xefcb}, 
         {0x82d9,0xefcc},  {0x82da,0xefcd},  {0x82db,0xefce},  {0x82dc,0xefcf}, 
         {0x82dd,0xefd0},  {0x82de,0xefd1},  {0x82df,0xefd2},  {0x82e0,0xefd3}, 
         {0x82e1,0xefd4},  {0x82e2,0xefd5},  {0x82e3,0xefd6},  {0x82e4,0xefd7}, 
         {0x82e5,0xefd8},  {0x82e6,0xefd9},  {0x82e7,0xefda},  {0x82e8,0xefdb}, 
         {0x82e9,0xefdc},  {0x82ea,0xefdd},  {0x82eb,0xefde},  {0x82ec,0xefdf}, 
         {0x82ed,0xefe0},  {0x82ee,0xefe1},  {0x82ef,0xefe2},  {0x82f0,0xefe3}, 
         {0x82f1,0xefe4},  {0x82f2,0xefe5},  {0x82f3,0xefe6},  {0x82f4,0xefe7}, 
         {0x82f5,0xefe8},  {0x82f6,0xefe9},  {0x82f7,0xefea},  {0x82f8,0xefeb}, 
         {0x82f9,0xefec},  {0x82fa,0xefed},  {0x82fb,0xefee},  {0x82fc,0xefef}, 
         {0x82fd,0xeff0},  {0x82fe,0xeff1},  {0x8340,0xeff2},  {0x8341,0xeff3}, 
         {0x8342,0xeff4},  {0x8343,0xeff5},  {0x8344,0xeff6},  {0x8345,0xeff7}, 
         {0x8346,0xeff8},  {0x8347,0xeff9},  {0x8348,0xeffa},  {0x8349,0xeffb}, 
         {0x834a,0xeffc},  {0x834b,0xeffd},  {0x834c,0xeffe},  {0x834d,0xefff}, 
         {0x834e,0xf000},  {0x834f,0xf001},  {0x8350,0xf002},  {0x8351,0xf003}, 
         {0x8352,0xf004},  {0x8353,0xf005},  {0x8354,0xf006},  {0x8355,0xf007}, 
         {0x8356,0xf008},  {0x8357,0xf009},  {0x8358,0xf00a},  {0x8359,0xf00b}, 
         {0x835a,0xf00c},  {0x835b,0xf00d},  {0x835c,0xf00e},  {0x835d,0xf00f}, 
         {0x835e,0xf010},  {0x835f,0xf011},  {0x8360,0xf012},  {0x8361,0xf013}, 
         {0x8362,0xf014},  {0x8363,0xf015},  {0x8364,0xf016},  {0x8365,0xf017}, 
         {0x8366,0xf018},  {0x8367,0xf019},  {0x8368,0xf01a},  {0x8369,0xf01b}, 
         {0x836a,0xf01c},  {0x836b,0xf01d},  {0x836c,0xf01e},  {0x836d,0xf01f}, 
         {0x836e,0xf020},  {0x836f,0xf021},  {0x8370,0xf022},  {0x8371,0xf023}, 
         {0x8372,0xf024},  {0x8373,0xf025},  {0x8374,0xf026},  {0x8375,0xf027}, 
         {0x8376,0xf028},  {0x8377,0xf029},  {0x8378,0xf02a},  {0x8379,0xf02b}, 
         {0x837a,0xf02c},  {0x837b,0xf02d},  {0x837c,0xf02e},  {0x837d,0xf02f}, 
         {0x837e,0xf030},  {0x83a1,0xf031},  {0x83a2,0xf032},  {0x83a3,0xf033}, 
         {0x83a4,0xf034},  {0x83a5,0xf035},  {0x83a6,0xf036},  {0x83a7,0xf037}, 
         {0x83a8,0xf038},  {0x83a9,0xf039},  {0x83aa,0xf03a},  {0x83ab,0xf03b}, 
         {0x83ac,0xf03c},  {0x83ad,0xf03d},  {0x83ae,0xf03e},  {0x83af,0xf03f}, 
         {0x83b0,0xf040},  {0x83b1,0xf041},  {0x83b2,0xf042},  {0x83b3,0xf043}, 
         {0x83b4,0xf044},  {0x83b5,0xf045},  {0x83b6,0xf046},  {0x83b7,0xf047}, 
         {0x83b8,0xf048},  {0x83b9,0xf049},  {0x83ba,0xf04a},  {0x83bb,0xf04b}, 
         {0x83bc,0xf04c},  {0x83bd,0xf04d},  {0x83be,0xf04e},  {0x83bf,0xf04f}, 
         {0x83c0,0xf050},  {0x83c1,0xf051},  {0x83c2,0xf052},  {0x83c3,0xf053}, 
         {0x83c4,0xf054},  {0x83c5,0xf055},  {0x83c6,0xf056},  {0x83c7,0xf057}, 
         {0x83c8,0xf058},  {0x83c9,0xf059},  {0x83ca,0xf05a},  {0x83cb,0xf05b}, 
         {0x83cc,0xf05c},  {0x83cd,0xf05d},  {0x83ce,0xf05e},  {0x83cf,0xf05f}, 
         {0x83d0,0xf060},  {0x83d1,0xf061},  {0x83d2,0xf062},  {0x83d3,0xf063}, 
         {0x83d4,0xf064},  {0x83d5,0xf065},  {0x83d6,0xf066},  {0x83d7,0xf067}, 
         {0x83d8,0xf068},  {0x83d9,0xf069},  {0x83da,0xf06a},  {0x83db,0xf06b}, 
         {0x83dc,0xf06c},  {0x83dd,0xf06d},  {0x83de,0xf06e},  {0x83df,0xf06f}, 
         {0x83e0,0xf070},  {0x83e1,0xf071},  {0x83e2,0xf072},  {0x83e3,0xf073}, 
         {0x83e4,0xf074},  {0x83e5,0xf075},  {0x83e6,0xf076},  {0x83e7,0xf077}, 
         {0x83e8,0xf078},  {0x83e9,0xf079},  {0x83ea,0xf07a},  {0x83eb,0xf07b}, 
         {0x83ec,0xf07c},  {0x83ed,0xf07d},  {0x83ee,0xf07e},  {0x83ef,0xf07f}, 
         {0x83f0,0xf080},  {0x83f1,0xf081},  {0x83f2,0xf082},  {0x83f3,0xf083}, 
         {0x83f4,0xf084},  {0x83f5,0xf085},  {0x83f6,0xf086},  {0x83f7,0xf087}, 
         {0x83f8,0xf088},  {0x83f9,0xf089},  {0x83fa,0xf08a},  {0x83fb,0xf08b}, 
         {0x83fc,0xf08c},  {0x83fd,0xf08d},  {0x83fe,0xf08e},  {0x8440,0xf08f}, 
         {0x8441,0xf090},  {0x8442,0xf091},  {0x8443,0xf092},  {0x8444,0xf093}, 
         {0x8445,0xf094},  {0x8446,0xf095},  {0x8447,0xf096},  {0x8448,0xf097}, 
         {0x8449,0xf098},  {0x844a,0xf099},  {0x844b,0xf09a},  {0x844c,0xf09b}, 
         {0x844d,0xf09c},  {0x844e,0xf09d},  {0x844f,0xf09e},  {0x8450,0xf09f}, 
         {0x8451,0xf0a0},  {0x8452,0xf0a1},  {0x8453,0xf0a2},  {0x8454,0xf0a3}, 
         {0x8455,0xf0a4},  {0x8456,0xf0a5},  {0x8457,0xf0a6},  {0x8458,0xf0a7}, 
         {0x8459,0xf0a8},  {0x845a,0xf0a9},  {0x845b,0xf0aa},  {0x845c,0xf0ab}, 
         {0x845d,0xf0ac},  {0x845e,0xf0ad},  {0x845f,0xf0ae},  {0x8460,0xf0af}, 
         {0x8461,0xf0b0},  {0x8462,0xf0b1},  {0x8463,0xf0b2},  {0x8464,0xf0b3}, 
         {0x8465,0xf0b4},  {0x8466,0xf0b5},  {0x8467,0xf0b6},  {0x8468,0xf0b7}, 
         {0x8469,0xf0b8},  {0x846a,0xf0b9},  {0x846b,0xf0ba},  {0x846c,0xf0bb}, 
         {0x846d,0xf0bc},  {0x846e,0xf0bd},  {0x846f,0xf0be},  {0x8470,0xf0bf}, 
         {0x8471,0xf0c0},  {0x8472,0xf0c1},  {0x8473,0xf0c2},  {0x8474,0xf0c3}, 
         {0x8475,0xf0c4},  {0x8476,0xf0c5},  {0x8477,0xf0c6},  {0x8478,0xf0c7}, 
         {0x8479,0xf0c8},  {0x847a,0xf0c9},  {0x847b,0xf0ca},  {0x847c,0xf0cb}, 
         {0x847d,0xf0cc},  {0x847e,0xf0cd},  {0x84a1,0xf0ce},  {0x84a2,0xf0cf}, 
         {0x84a3,0xf0d0},  {0x84a4,0xf0d1},  {0x84a5,0xf0d2},  {0x84a6,0xf0d3}, 
         {0x84a7,0xf0d4},  {0x84a8,0xf0d5},  {0x84a9,0xf0d6},  {0x84aa,0xf0d7}, 
         {0x84ab,0xf0d8},  {0x84ac,0xf0d9},  {0x84ad,0xf0da},  {0x84ae,0xf0db}, 
         {0x84af,0xf0dc},  {0x84b0,0xf0dd},  {0x84b1,0xf0de},  {0x84b2,0xf0df}, 
         {0x84b3,0xf0e0},  {0x84b4,0xf0e1},  {0x84b5,0xf0e2},  {0x84b6,0xf0e3}, 
         {0x84b7,0xf0e4},  {0x84b8,0xf0e5},  {0x84b9,0xf0e6},  {0x84ba,0xf0e7}, 
         {0x84bb,0xf0e8},  {0x84bc,0xf0e9},  {0x84bd,0xf0ea},  {0x84be,0xf0eb}, 
         {0x84bf,0xf0ec},  {0x84c0,0xf0ed},  {0x84c1,0xf0ee},  {0x84c2,0xf0ef}, 
         {0x84c3,0xf0f0},  {0x84c4,0xf0f1},  {0x84c5,0xf0f2},  {0x84c6,0xf0f3}, 
         {0x84c7,0xf0f4},  {0x84c8,0xf0f5},  {0x84c9,0xf0f6},  {0x84ca,0xf0f7}, 
         {0x84cb,0xf0f8},  {0x84cc,0xf0f9},  {0x84cd,0xf0fa},  {0x84ce,0xf0fb}, 
         {0x84cf,0xf0fc},  {0x84d0,0xf0fd},  {0x84d1,0xf0fe},  {0x84d2,0xf0ff}, 
         {0x84d3,0xf100},  {0x84d4,0xf101},  {0x84d5,0xf102},  {0x84d6,0xf103}, 
         {0x84d7,0xf104},  {0x84d8,0xf105},  {0x84d9,0xf106},  {0x84da,0xf107}, 
         {0x84db,0xf108},  {0x84dc,0xf109},  {0x84dd,0xf10a},  {0x84de,0xf10b}, 
         {0x84df,0xf10c},  {0x84e0,0xf10d},  {0x84e1,0xf10e},  {0x84e2,0xf10f}, 
         {0x84e3,0xf110},  {0x84e4,0xf111},  {0x84e5,0xf112},  {0x84e6,0xf113}, 
         {0x84e7,0xf114},  {0x84e8,0xf115},  {0x84e9,0xf116},  {0x84ea,0xf117}, 
         {0x84eb,0xf118},  {0x84ec,0xf119},  {0x84ed,0xf11a},  {0x84ee,0xf11b}, 
         {0x84ef,0xf11c},  {0x84f0,0xf11d},  {0x84f1,0xf11e},  {0x84f2,0xf11f}, 
         {0x84f3,0xf120},  {0x84f4,0xf121},  {0x84f5,0xf122},  {0x84f6,0xf123}, 
         {0x84f7,0xf124},  {0x84f8,0xf125},  {0x84f9,0xf126},  {0x84fa,0xf127}, 
         {0x84fb,0xf128},  {0x84fc,0xf129},  {0x84fd,0xf12a},  {0x84fe,0xf12b}, 
         {0x8540,0xf12c},  {0x8541,0xf12d},  {0x8542,0xf12e},  {0x8543,0xf12f}, 
         {0x8544,0xf130},  {0x8545,0xf131},  {0x8546,0xf132},  {0x8547,0xf133}, 
         {0x8548,0xf134},  {0x8549,0xf135},  {0x854a,0xf136},  {0x854b,0xf137}, 
         {0x854c,0xf138},  {0x854d,0xf139},  {0x854e,0xf13a},  {0x854f,0xf13b}, 
         {0x8550,0xf13c},  {0x8551,0xf13d},  {0x8552,0xf13e},  {0x8553,0xf13f}, 
         {0x8554,0xf140},  {0x8555,0xf141},  {0x8556,0xf142},  {0x8557,0xf143}, 
         {0x8558,0xf144},  {0x8559,0xf145},  {0x855a,0xf146},  {0x855b,0xf147}, 
         {0x855c,0xf148},  {0x855d,0xf149},  {0x855e,0xf14a},  {0x855f,0xf14b}, 
         {0x8560,0xf14c},  {0x8561,0xf14d},  {0x8562,0xf14e},  {0x8563,0xf14f}, 
         {0x8564,0xf150},  {0x8565,0xf151},  {0x8566,0xf152},  {0x8567,0xf153}, 
         {0x8568,0xf154},  {0x8569,0xf155},  {0x856a,0xf156},  {0x856b,0xf157}, 
         {0x856c,0xf158},  {0x856d,0xf159},  {0x856e,0xf15a},  {0x856f,0xf15b}, 
         {0x8570,0xf15c},  {0x8571,0xf15d},  {0x8572,0xf15e},  {0x8573,0xf15f}, 
         {0x8574,0xf160},  {0x8575,0xf161},  {0x8576,0xf162},  {0x8577,0xf163}, 
         {0x8578,0xf164},  {0x8579,0xf165},  {0x857a,0xf166},  {0x857b,0xf167}, 
         {0x857c,0xf168},  {0x857d,0xf169},  {0x857e,0xf16a},  {0x85a1,0xf16b}, 
         {0x85a2,0xf16c},  {0x85a3,0xf16d},  {0x85a4,0xf16e},  {0x85a5,0xf16f}, 
         {0x85a6,0xf170},  {0x85a7,0xf171},  {0x85a8,0xf172},  {0x85a9,0xf173}, 
         {0x85aa,0xf174},  {0x85ab,0xf175},  {0x85ac,0xf176},  {0x85ad,0xf177}, 
         {0x85ae,0xf178},  {0x85af,0xf179},  {0x85b0,0xf17a},  {0x85b1,0xf17b}, 
         {0x85b2,0xf17c},  {0x85b3,0xf17d},  {0x85b4,0xf17e},  {0x85b5,0xf17f}, 
         {0x85b6,0xf180},  {0x85b7,0xf181},  {0x85b8,0xf182},  {0x85b9,0xf183}, 
         {0x85ba,0xf184},  {0x85bb,0xf185},  {0x85bc,0xf186},  {0x85bd,0xf187}, 
         {0x85be,0xf188},  {0x85bf,0xf189},  {0x85c0,0xf18a},  {0x85c1,0xf18b}, 
         {0x85c2,0xf18c},  {0x85c3,0xf18d},  {0x85c4,0xf18e},  {0x85c5,0xf18f}, 
         {0x85c6,0xf190},  {0x85c7,0xf191},  {0x85c8,0xf192},  {0x85c9,0xf193}, 
         {0x85ca,0xf194},  {0x85cb,0xf195},  {0x85cc,0xf196},  {0x85cd,0xf197}, 
         {0x85ce,0xf198},  {0x85cf,0xf199},  {0x85d0,0xf19a},  {0x85d1,0xf19b}, 
         {0x85d2,0xf19c},  {0x85d3,0xf19d},  {0x85d4,0xf19e},  {0x85d5,0xf19f}, 
         {0x85d6,0xf1a0},  {0x85d7,0xf1a1},  {0x85d8,0xf1a2},  {0x85d9,0xf1a3}, 
         {0x85da,0xf1a4},  {0x85db,0xf1a5},  {0x85dc,0xf1a6},  {0x85dd,0xf1a7}, 
         {0x85de,0xf1a8},  {0x85df,0xf1a9},  {0x85e0,0xf1aa},  {0x85e1,0xf1ab}, 
         {0x85e2,0xf1ac},  {0x85e3,0xf1ad},  {0x85e4,0xf1ae},  {0x85e5,0xf1af}, 
         {0x85e6,0xf1b0},  {0x85e7,0xf1b1},  {0x85e8,0xf1b2},  {0x85e9,0xf1b3}, 
         {0x85ea,0xf1b4},  {0x85eb,0xf1b5},  {0x85ec,0xf1b6},  {0x85ed,0xf1b7}, 
         {0x85ee,0xf1b8},  {0x85ef,0xf1b9},  {0x85f0,0xf1ba},  {0x85f1,0xf1bb}, 
         {0x85f2,0xf1bc},  {0x85f3,0xf1bd},  {0x85f4,0xf1be},  {0x85f5,0xf1bf}, 
         {0x85f6,0xf1c0},  {0x85f7,0xf1c1},  {0x85f8,0xf1c2},  {0x85f9,0xf1c3}, 
         {0x85fa,0xf1c4},  {0x85fb,0xf1c5},  {0x85fc,0xf1c6},  {0x85fd,0xf1c7}, 
         {0x85fe,0xf1c8},  {0x8640,0xf1c9},  {0x8641,0xf1ca},  {0x8642,0xf1cb}, 
         {0x8643,0xf1cc},  {0x8644,0xf1cd},  {0x8645,0xf1ce},  {0x8646,0xf1cf}, 
         {0x8647,0xf1d0},  {0x8648,0xf1d1},  {0x8649,0xf1d2},  {0x864a,0xf1d3}, 
         {0x864b,0xf1d4},  {0x864c,0xf1d5},  {0x864d,0xf1d6},  {0x864e,0xf1d7}, 
         {0x864f,0xf1d8},  {0x8650,0xf1d9},  {0x8651,0xf1da},  {0x8652,0xf1db}, 
         {0x8653,0xf1dc},  {0x8654,0xf1dd},  {0x8655,0xf1de},  {0x8656,0xf1df}, 
         {0x8657,0xf1e0},  {0x8658,0xf1e1},  {0x8659,0xf1e2},  {0x865a,0xf1e3}, 
         {0x865b,0xf1e4},  {0x865c,0xf1e5},  {0x865d,0xf1e6},  {0x865e,0xf1e7}, 
         {0x865f,0xf1e8},  {0x8660,0xf1e9},  {0x8661,0xf1ea},  {0x8662,0xf1eb}, 
         {0x8663,0xf1ec},  {0x8664,0xf1ed},  {0x8665,0xf1ee},  {0x8666,0xf1ef}, 
         {0x8667,0xf1f0},  {0x8668,0xf1f1},  {0x8669,0xf1f2},  {0x866a,0xf1f3}, 
         {0x866b,0xf1f4},  {0x866c,0xf1f5},  {0x866d,0xf1f6},  {0x866e,0xf1f7}, 
         {0x866f,0xf1f8},  {0x8670,0xf1f9},  {0x8671,0xf1fa},  {0x8672,0xf1fb}, 
         {0x8673,0xf1fc},  {0x8674,0xf1fd},  {0x8675,0xf1fe},  {0x8676,0xf1ff}, 
         {0x8677,0xf200},  {0x8678,0xf201},  {0x8679,0xf202},  {0x867a,0xf203}, 
         {0x867b,0xf204},  {0x867c,0xf205},  {0x867d,0xf206},  {0x867e,0xf207}, 
         {0x86a1,0xf208},  {0x86a2,0xf209},  {0x86a3,0xf20a},  {0x86a4,0xf20b}, 
         {0x86a5,0xf20c},  {0x86a6,0xf20d},  {0x86a7,0xf20e},  {0x86a8,0xf20f}, 
         {0x86a9,0xf210},  {0x86aa,0xf211},  {0x86ab,0xf212},  {0x86ac,0xf213}, 
         {0x86ad,0xf214},  {0x86ae,0xf215},  {0x86af,0xf216},  {0x86b0,0xf217}, 
         {0x86b1,0xf218},  {0x86b2,0xf219},  {0x86b3,0xf21a},  {0x86b4,0xf21b}, 
         {0x86b5,0xf21c},  {0x86b6,0xf21d},  {0x86b7,0xf21e},  {0x86b8,0xf21f}, 
         {0x86b9,0xf220},  {0x86ba,0xf221},  {0x86bb,0xf222},  {0x86bc,0xf223}, 
         {0x86bd,0xf224},  {0x86be,0xf225},  {0x86bf,0xf226},  {0x86c0,0xf227}, 
         {0x86c1,0xf228},  {0x86c2,0xf229},  {0x86c3,0xf22a},  {0x86c4,0xf22b}, 
         {0x86c5,0xf22c},  {0x86c6,0xf22d},  {0x86c7,0xf22e},  {0x86c8,0xf22f}, 
         {0x86c9,0xf230},  {0x86ca,0xf231},  {0x86cb,0xf232},  {0x86cc,0xf233}, 
         {0x86cd,0xf234},  {0x86ce,0xf235},  {0x86cf,0xf236},  {0x86d0,0xf237}, 
         {0x86d1,0xf238},  {0x86d2,0xf239},  {0x86d3,0xf23a},  {0x86d4,0xf23b}, 
         {0x86d5,0xf23c},  {0x86d6,0xf23d},  {0x86d7,0xf23e},  {0x86d8,0xf23f}, 
         {0x86d9,0xf240},  {0x86da,0xf241},  {0x86db,0xf242},  {0x86dc,0xf243}, 
         {0x86dd,0xf244},  {0x86de,0xf245},  {0x86df,0xf246},  {0x86e0,0xf247}, 
         {0x86e1,0xf248},  {0x86e2,0xf249},  {0x86e3,0xf24a},  {0x86e4,0xf24b}, 
         {0x86e5,0xf24c},  {0x86e6,0xf24d},  {0x86e7,0xf24e},  {0x86e8,0xf24f}, 
         {0x86e9,0xf250},  {0x86ea,0xf251},  {0x86eb,0xf252},  {0x86ec,0xf253}, 
         {0x86ed,0xf254},  {0x86ee,0xf255},  {0x86ef,0xf256},  {0x86f0,0xf257}, 
         {0x86f1,0xf258},  {0x86f2,0xf259},  {0x86f3,0xf25a},  {0x86f4,0xf25b}, 
         {0x86f5,0xf25c},  {0x86f6,0xf25d},  {0x86f7,0xf25e},  {0x86f8,0xf25f}, 
         {0x86f9,0xf260},  {0x86fa,0xf261},  {0x86fb,0xf262},  {0x86fc,0xf263}, 
         {0x86fd,0xf264},  {0x86fe,0xf265},  {0x8740,0xf266},  {0x8741,0xf267}, 
         {0x8742,0xf268},  {0x8743,0xf269},  {0x8744,0xf26a},  {0x8745,0xf26b}, 
         {0x8746,0xf26c},  {0x8747,0xf26d},  {0x8748,0xf26e},  {0x8749,0xf26f}, 
         {0x874a,0xf270},  {0x874b,0xf271},  {0x874c,0xf272},  {0x874d,0xf273}, 
         {0x874e,0xf274},  {0x874f,0xf275},  {0x8750,0xf276},  {0x8751,0xf277}, 
         {0x8752,0xf278},  {0x8753,0xf279},  {0x8754,0xf27a},  {0x8755,0xf27b}, 
         {0x8756,0xf27c},  {0x8757,0xf27d},  {0x8758,0xf27e},  {0x8759,0xf27f}, 
         {0x875a,0xf280},  {0x875b,0xf281},  {0x875c,0xf282},  {0x875d,0xf283}, 
         {0x875e,0xf284},  {0x875f,0xf285},  {0x8760,0xf286},  {0x8761,0xf287}, 
         {0x8762,0xf288},  {0x8763,0xf289},  {0x8764,0xf28a},  {0x8765,0xf28b}, 
         {0x8766,0xf28c},  {0x8767,0xf28d},  {0x8768,0xf28e},  {0x8769,0xf28f}, 
         {0x876a,0xf290},  {0x876b,0xf291},  {0x876c,0xf292},  {0x876d,0xf293}, 
         {0x876e,0xf294},  {0x876f,0xf295},  {0x8770,0xf296},  {0x8771,0xf297}, 
         {0x8772,0xf298},  {0x8773,0xf299},  {0x8774,0xf29a},  {0x8775,0xf29b}, 
         {0x8776,0xf29c},  {0x8777,0xf29d},  {0x8778,0xf29e},  {0x8779,0xf29f}, 
         {0x877a,0xf2a0},  {0x877b,0xf2a1},  {0x877c,0xf2a2},  {0x877d,0xf2a3}, 
         {0x877e,0xf2a4},  {0x87a1,0xf2a5},  {0x87a2,0xf2a6},  {0x87a3,0xf2a7}, 
         {0x87a4,0xf2a8},  {0x87a5,0xf2a9},  {0x87a6,0xf2aa},  {0x87a7,0xf2ab}, 
         {0x87a8,0xf2ac},  {0x87a9,0xf2ad},  {0x87aa,0xf2ae},  {0x87ab,0xf2af}, 
         {0x87ac,0xf2b0},  {0x87ad,0xf2b1},  {0x87ae,0xf2b2},  {0x87af,0xf2b3}, 
         {0x87b0,0xf2b4},  {0x87b1,0xf2b5},  {0x87b2,0xf2b6},  {0x87b3,0xf2b7}, 
         {0x87b4,0xf2b8},  {0x87b5,0xf2b9},  {0x87b6,0xf2ba},  {0x87b7,0xf2bb}, 
         {0x87b8,0xf2bc},  {0x87b9,0xf2bd},  {0x87ba,0xf2be},  {0x87bb,0xf2bf}, 
         {0x87bc,0xf2c0},  {0x87bd,0xf2c1},  {0x87be,0xf2c2},  {0x87bf,0xf2c3}, 
         {0x87c0,0xf2c4},  {0x87c1,0xf2c5},  {0x87c2,0xf2c6},  {0x87c3,0xf2c7}, 
         {0x87c4,0xf2c8},  {0x87c5,0xf2c9},  {0x87c6,0xf2ca},  {0x87c7,0xf2cb}, 
         {0x87c8,0xf2cc},  {0x87c9,0xf2cd},  {0x87ca,0xf2ce},  {0x87cb,0xf2cf}, 
         {0x87cc,0xf2d0},  {0x87cd,0xf2d1},  {0x87ce,0xf2d2},  {0x87cf,0xf2d3}, 
         {0x87d0,0xf2d4},  {0x87d1,0xf2d5},  {0x87d2,0xf2d6},  {0x87d3,0xf2d7}, 
         {0x87d4,0xf2d8},  {0x87d5,0xf2d9},  {0x87d6,0xf2da},  {0x87d7,0xf2db}, 
         {0x87d8,0xf2dc},  {0x87d9,0xf2dd},  {0x87da,0xf2de},  {0x87db,0xf2df}, 
         {0x87dc,0xf2e0},  {0x87dd,0xf2e1},  {0x87de,0xf2e2},  {0x87df,0xf2e3}, 
         {0x87e0,0xf2e4},  {0x87e1,0xf2e5},  {0x87e2,0xf2e6},  {0x87e3,0xf2e7}, 
         {0x87e4,0xf2e8},  {0x87e5,0xf2e9},  {0x87e6,0xf2ea},  {0x87e7,0xf2eb}, 
         {0x87e8,0xf2ec},  {0x87e9,0xf2ed},  {0x87ea,0xf2ee},  {0x87eb,0xf2ef}, 
         {0x87ec,0xf2f0},  {0x87ed,0xf2f1},  {0x87ee,0xf2f2},  {0x87ef,0xf2f3}, 
         {0x87f0,0xf2f4},  {0x87f1,0xf2f5},  {0x87f2,0xf2f6},  {0x87f3,0xf2f7}, 
         {0x87f4,0xf2f8},  {0x87f5,0xf2f9},  {0x87f6,0xf2fa},  {0x87f7,0xf2fb}, 
         {0x87f8,0xf2fc},  {0x87f9,0xf2fd},  {0x87fa,0xf2fe},  {0x87fb,0xf2ff}, 
         {0x87fc,0xf300},  {0x87fd,0xf301},  {0x87fe,0xf302},  {0x8840,0xf303}, 
         {0x8841,0xf304},  {0x8842,0xf305},  {0x8843,0xf306},  {0x8844,0xf307}, 
         {0x8845,0xf308},  {0x8846,0xf309},  {0x8847,0xf30a},  {0x8848,0xf30b}, 
         {0x8849,0xf30c},  {0x884a,0xf30d},  {0x884b,0xf30e},  {0x884c,0xf30f}, 
         {0x884d,0xf310},  {0x884e,0xf311},  {0x884f,0xf312},  {0x8850,0xf313}, 
         {0x8851,0xf314},  {0x8852,0xf315},  {0x8853,0xf316},  {0x8854,0xf317}, 
         {0x8855,0xf318},  {0x8856,0xf319},  {0x8857,0xf31a},  {0x8858,0xf31b}, 
         {0x8859,0xf31c},  {0x885a,0xf31d},  {0x885b,0xf31e},  {0x885c,0xf31f}, 
         {0x885d,0xf320},  {0x885e,0xf321},  {0x885f,0xf322},  {0x8860,0xf323}, 
         {0x8861,0xf324},  {0x8862,0xf325},  {0x8863,0xf326},  {0x8864,0xf327}, 
         {0x8865,0xf328},  {0x8866,0xf329},  {0x8867,0xf32a},  {0x8868,0xf32b}, 
         {0x8869,0xf32c},  {0x886a,0xf32d},  {0x886b,0xf32e},  {0x886c,0xf32f}, 
         {0x886d,0xf330},  {0x886e,0xf331},  {0x886f,0xf332},  {0x8870,0xf333}, 
         {0x8871,0xf334},  {0x8872,0xf335},  {0x8873,0xf336},  {0x8874,0xf337}, 
         {0x8875,0xf338},  {0x8876,0xf339},  {0x8877,0xf33a},  {0x8878,0xf33b}, 
         {0x8879,0xf33c},  {0x887a,0xf33d},  {0x887b,0xf33e},  {0x887c,0xf33f}, 
         {0x887d,0xf340},  {0x887e,0xf341},  {0x88a1,0xf342},  {0x88a2,0xf343}, 
         {0x88a3,0xf344},  {0x88a4,0xf345},  {0x88a5,0xf346},  {0x88a6,0xf347}, 
         {0x88a7,0xf348},  {0x88a8,0xf349},  {0x88a9,0xf34a},  {0x88aa,0xf34b}, 
         {0x88ab,0xf34c},  {0x88ac,0xf34d},  {0x88ad,0xf34e},  {0x88ae,0xf34f}, 
         {0x88af,0xf350},  {0x88b0,0xf351},  {0x88b1,0xf352},  {0x88b2,0xf353}, 
         {0x88b3,0xf354},  {0x88b4,0xf355},  {0x88b5,0xf356},  {0x88b6,0xf357}, 
         {0x88b7,0xf358},  {0x88b8,0xf359},  {0x88b9,0xf35a},  {0x88ba,0xf35b}, 
         {0x88bb,0xf35c},  {0x88bc,0xf35d},  {0x88bd,0xf35e},  {0x88be,0xf35f}, 
         {0x88bf,0xf360},  {0x88c0,0xf361},  {0x88c1,0xf362},  {0x88c2,0xf363}, 
         {0x88c3,0xf364},  {0x88c4,0xf365},  {0x88c5,0xf366},  {0x88c6,0xf367}, 
         {0x88c7,0xf368},  {0x88c8,0xf369},  {0x88c9,0xf36a},  {0x88ca,0xf36b}, 
         {0x88cb,0xf36c},  {0x88cc,0xf36d},  {0x88cd,0xf36e},  {0x88ce,0xf36f}, 
         {0x88cf,0xf370},  {0x88d0,0xf371},  {0x88d1,0xf372},  {0x88d2,0xf373}, 
         {0x88d3,0xf374},  {0x88d4,0xf375},  {0x88d5,0xf376},  {0x88d6,0xf377}, 
         {0x88d7,0xf378},  {0x88d8,0xf379},  {0x88d9,0xf37a},  {0x88da,0xf37b}, 
         {0x88db,0xf37c},  {0x88dc,0xf37d},  {0x88dd,0xf37e},  {0x88de,0xf37f}, 
         {0x88df,0xf380},  {0x88e0,0xf381},  {0x88e1,0xf382},  {0x88e2,0xf383}, 
         {0x88e3,0xf384},  {0x88e4,0xf385},  {0x88e5,0xf386},  {0x88e6,0xf387}, 
         {0x88e7,0xf388},  {0x88e8,0xf389},  {0x88e9,0xf38a},  {0x88ea,0xf38b}, 
         {0x88eb,0xf38c},  {0x88ec,0xf38d},  {0x88ed,0xf38e},  {0x88ee,0xf38f}, 
         {0x88ef,0xf390},  {0x88f0,0xf391},  {0x88f1,0xf392},  {0x88f2,0xf393}, 
         {0x88f3,0xf394},  {0x88f4,0xf395},  {0x88f5,0xf396},  {0x88f6,0xf397}, 
         {0x88f7,0xf398},  {0x88f8,0xf399},  {0x88f9,0xf39a},  {0x88fa,0xf39b}, 
         {0x88fb,0xf39c},  {0x88fc,0xf39d},  {0x88fd,0xf39e},  {0x88fe,0xf39f}, 
         {0x8940,0xf3a0},  {0x8941,0xf3a1},  {0x8942,0xf3a2},  {0x8943,0xf3a3}, 
         {0x8944,0xf3a4},  {0x8945,0xf3a5},  {0x8946,0xf3a6},  {0x8947,0xf3a7}, 
         {0x8948,0xf3a8},  {0x8949,0xf3a9},  {0x894a,0xf3aa},  {0x894b,0xf3ab}, 
         {0x894c,0xf3ac},  {0x894d,0xf3ad},  {0x894e,0xf3ae},  {0x894f,0xf3af}, 
         {0x8950,0xf3b0},  {0x8951,0xf3b1},  {0x8952,0xf3b2},  {0x8953,0xf3b3}, 
         {0x8954,0xf3b4},  {0x8955,0xf3b5},  {0x8956,0xf3b6},  {0x8957,0xf3b7}, 
         {0x8958,0xf3b8},  {0x8959,0xf3b9},  {0x895a,0xf3ba},  {0x895b,0xf3bb}, 
         {0x895c,0xf3bc},  {0x895d,0xf3bd},  {0x895e,0xf3be},  {0x895f,0xf3bf}, 
         {0x8960,0xf3c0},  {0x8961,0xf3c1},  {0x8962,0xf3c2},  {0x8963,0xf3c3}, 
         {0x8964,0xf3c4},  {0x8965,0xf3c5},  {0x8966,0xf3c6},  {0x8967,0xf3c7}, 
         {0x8968,0xf3c8},  {0x8969,0xf3c9},  {0x896a,0xf3ca},  {0x896b,0xf3cb}, 
         {0x896c,0xf3cc},  {0x896d,0xf3cd},  {0x896e,0xf3ce},  {0x896f,0xf3cf}, 
         {0x8970,0xf3d0},  {0x8971,0xf3d1},  {0x8972,0xf3d2},  {0x8973,0xf3d3}, 
         {0x8974,0xf3d4},  {0x8975,0xf3d5},  {0x8976,0xf3d6},  {0x8977,0xf3d7}, 
         {0x8978,0xf3d8},  {0x8979,0xf3d9},  {0x897a,0xf3da},  {0x897b,0xf3db}, 
         {0x897c,0xf3dc},  {0x897d,0xf3dd},  {0x897e,0xf3de},  {0x89a1,0xf3df}, 
         {0x89a2,0xf3e0},  {0x89a3,0xf3e1},  {0x89a4,0xf3e2},  {0x89a5,0xf3e3}, 
         {0x89a6,0xf3e4},  {0x89a7,0xf3e5},  {0x89a8,0xf3e6},  {0x89a9,0xf3e7}, 
         {0x89aa,0xf3e8},  {0x89ab,0xf3e9},  {0x89ac,0xf3ea},  {0x89ad,0xf3eb}, 
         {0x89ae,0xf3ec},  {0x89af,0xf3ed},  {0x89b0,0xf3ee},  {0x89b1,0xf3ef}, 
         {0x89b2,0xf3f0},  {0x89b3,0xf3f1},  {0x89b4,0xf3f2},  {0x89b5,0xf3f3}, 
         {0x89b6,0xf3f4},  {0x89b7,0xf3f5},  {0x89b8,0xf3f6},  {0x89b9,0xf3f7}, 
         {0x89ba,0xf3f8},  {0x89bb,0xf3f9},  {0x89bc,0xf3fa},  {0x89bd,0xf3fb}, 
         {0x89be,0xf3fc},  {0x89bf,0xf3fd},  {0x89c0,0xf3fe},  {0x89c1,0xf3ff}, 
         {0x89c2,0xf400},  {0x89c3,0xf401},  {0x89c4,0xf402},  {0x89c5,0xf403}, 
         {0x89c6,0xf404},  {0x89c7,0xf405},  {0x89c8,0xf406},  {0x89c9,0xf407}, 
         {0x89ca,0xf408},  {0x89cb,0xf409},  {0x89cc,0xf40a},  {0x89cd,0xf40b}, 
         {0x89ce,0xf40c},  {0x89cf,0xf40d},  {0x89d0,0xf40e},  {0x89d1,0xf40f}, 
         {0x89d2,0xf410},  {0x89d3,0xf411},  {0x89d4,0xf412},  {0x89d5,0xf413}, 
         {0x89d6,0xf414},  {0x89d7,0xf415},  {0x89d8,0xf416},  {0x89d9,0xf417}, 
         {0x89da,0xf418},  {0x89db,0xf419},  {0x89dc,0xf41a},  {0x89dd,0xf41b}, 
         {0x89de,0xf41c},  {0x89df,0xf41d},  {0x89e0,0xf41e},  {0x89e1,0xf41f}, 
         {0x89e2,0xf420},  {0x89e3,0xf421},  {0x89e4,0xf422},  {0x89e5,0xf423}, 
         {0x89e6,0xf424},  {0x89e7,0xf425},  {0x89e8,0xf426},  {0x89e9,0xf427}, 
         {0x89ea,0xf428},  {0x89eb,0xf429},  {0x89ec,0xf42a},  {0x89ed,0xf42b}, 
         {0x89ee,0xf42c},  {0x89ef,0xf42d},  {0x89f0,0xf42e},  {0x89f1,0xf42f}, 
         {0x89f2,0xf430},  {0x89f3,0xf431},  {0x89f4,0xf432},  {0x89f5,0xf433}, 
         {0x89f6,0xf434},  {0x89f7,0xf435},  {0x89f8,0xf436},  {0x89f9,0xf437}, 
         {0x89fa,0xf438},  {0x89fb,0xf439},  {0x89fc,0xf43a},  {0x89fd,0xf43b}, 
         {0x89fe,0xf43c},  {0x8a40,0xf43d},  {0x8a41,0xf43e},  {0x8a42,0xf43f}, 
         {0x8a43,0xf440},  {0x8a44,0xf441},  {0x8a45,0xf442},  {0x8a46,0xf443}, 
         {0x8a47,0xf444},  {0x8a48,0xf445},  {0x8a49,0xf446},  {0x8a4a,0xf447}, 
         {0x8a4b,0xf448},  {0x8a4c,0xf449},  {0x8a4d,0xf44a},  {0x8a4e,0xf44b}, 
         {0x8a4f,0xf44c},  {0x8a50,0xf44d},  {0x8a51,0xf44e},  {0x8a52,0xf44f}, 
         {0x8a53,0xf450},  {0x8a54,0xf451},  {0x8a55,0xf452},  {0x8a56,0xf453}, 
         {0x8a57,0xf454},  {0x8a58,0xf455},  {0x8a59,0xf456},  {0x8a5a,0xf457}, 
         {0x8a5b,0xf458},  {0x8a5c,0xf459},  {0x8a5d,0xf45a},  {0x8a5e,0xf45b}, 
         {0x8a5f,0xf45c},  {0x8a60,0xf45d},  {0x8a61,0xf45e},  {0x8a62,0xf45f}, 
         {0x8a63,0xf460},  {0x8a64,0xf461},  {0x8a65,0xf462},  {0x8a66,0xf463}, 
         {0x8a67,0xf464},  {0x8a68,0xf465},  {0x8a69,0xf466},  {0x8a6a,0xf467}, 
         {0x8a6b,0xf468},  {0x8a6c,0xf469},  {0x8a6d,0xf46a},  {0x8a6e,0xf46b}, 
         {0x8a6f,0xf46c},  {0x8a70,0xf46d},  {0x8a71,0xf46e},  {0x8a72,0xf46f}, 
         {0x8a73,0xf470},  {0x8a74,0xf471},  {0x8a75,0xf472},  {0x8a76,0xf473}, 
         {0x8a77,0xf474},  {0x8a78,0xf475},  {0x8a79,0xf476},  {0x8a7a,0xf477}, 
         {0x8a7b,0xf478},  {0x8a7c,0xf479},  {0x8a7d,0xf47a},  {0x8a7e,0xf47b}, 
         {0x8aa1,0xf47c},  {0x8aa2,0xf47d},  {0x8aa3,0xf47e},  {0x8aa4,0xf47f}, 
         {0x8aa5,0xf480},  {0x8aa6,0xf481},  {0x8aa7,0xf482},  {0x8aa8,0xf483}, 
         {0x8aa9,0xf484},  {0x8aaa,0xf485},  {0x8aab,0xf486},  {0x8aac,0xf487}, 
         {0x8aad,0xf488},  {0x8aae,0xf489},  {0x8aaf,0xf48a},  {0x8ab0,0xf48b}, 
         {0x8ab1,0xf48c},  {0x8ab2,0xf48d},  {0x8ab3,0xf48e},  {0x8ab4,0xf48f}, 
         {0x8ab5,0xf490},  {0x8ab6,0xf491},  {0x8ab7,0xf492},  {0x8ab8,0xf493}, 
         {0x8ab9,0xf494},  {0x8aba,0xf495},  {0x8abb,0xf496},  {0x8abc,0xf497}, 
         {0x8abd,0xf498},  {0x8abe,0xf499},  {0x8abf,0xf49a},  {0x8ac0,0xf49b}, 
         {0x8ac1,0xf49c},  {0x8ac2,0xf49d},  {0x8ac3,0xf49e},  {0x8ac4,0xf49f}, 
         {0x8ac5,0xf4a0},  {0x8ac6,0xf4a1},  {0x8ac7,0xf4a2},  {0x8ac8,0xf4a3}, 
         {0x8ac9,0xf4a4},  {0x8aca,0xf4a5},  {0x8acb,0xf4a6},  {0x8acc,0xf4a7}, 
         {0x8acd,0xf4a8},  {0x8ace,0xf4a9},  {0x8acf,0xf4aa},  {0x8ad0,0xf4ab}, 
         {0x8ad1,0xf4ac},  {0x8ad2,0xf4ad},  {0x8ad3,0xf4ae},  {0x8ad4,0xf4af}, 
         {0x8ad5,0xf4b0},  {0x8ad6,0xf4b1},  {0x8ad7,0xf4b2},  {0x8ad8,0xf4b3}, 
         {0x8ad9,0xf4b4},  {0x8ada,0xf4b5},  {0x8adb,0xf4b6},  {0x8adc,0xf4b7}, 
         {0x8add,0xf4b8},  {0x8ade,0xf4b9},  {0x8adf,0xf4ba},  {0x8ae0,0xf4bb}, 
         {0x8ae1,0xf4bc},  {0x8ae2,0xf4bd},  {0x8ae3,0xf4be},  {0x8ae4,0xf4bf}, 
         {0x8ae5,0xf4c0},  {0x8ae6,0xf4c1},  {0x8ae7,0xf4c2},  {0x8ae8,0xf4c3}, 
         {0x8ae9,0xf4c4},  {0x8aea,0xf4c5},  {0x8aeb,0xf4c6},  {0x8aec,0xf4c7}, 
         {0x8aed,0xf4c8},  {0x8aee,0xf4c9},  {0x8aef,0xf4ca},  {0x8af0,0xf4cb}, 
         {0x8af1,0xf4cc},  {0x8af2,0xf4cd},  {0x8af3,0xf4ce},  {0x8af4,0xf4cf}, 
         {0x8af5,0xf4d0},  {0x8af6,0xf4d1},  {0x8af7,0xf4d2},  {0x8af8,0xf4d3}, 
         {0x8af9,0xf4d4},  {0x8afa,0xf4d5},  {0x8afb,0xf4d6},  {0x8afc,0xf4d7}, 
         {0x8afd,0xf4d8},  {0x8afe,0xf4d9},  {0x8b40,0xf4da},  {0x8b41,0xf4db}, 
         {0x8b42,0xf4dc},  {0x8b43,0xf4dd},  {0x8b44,0xf4de},  {0x8b45,0xf4df}, 
         {0x8b46,0xf4e0},  {0x8b47,0xf4e1},  {0x8b48,0xf4e2},  {0x8b49,0xf4e3}, 
         {0x8b4a,0xf4e4},  {0x8b4b,0xf4e5},  {0x8b4c,0xf4e6},  {0x8b4d,0xf4e7}, 
         {0x8b4e,0xf4e8},  {0x8b4f,0xf4e9},  {0x8b50,0xf4ea},  {0x8b51,0xf4eb}, 
         {0x8b52,0xf4ec},  {0x8b53,0xf4ed},  {0x8b54,0xf4ee},  {0x8b55,0xf4ef}, 
         {0x8b56,0xf4f0},  {0x8b57,0xf4f1},  {0x8b58,0xf4f2},  {0x8b59,0xf4f3}, 
         {0x8b5a,0xf4f4},  {0x8b5b,0xf4f5},  {0x8b5c,0xf4f6},  {0x8b5d,0xf4f7}, 
         {0x8b5e,0xf4f8},  {0x8b5f,0xf4f9},  {0x8b60,0xf4fa},  {0x8b61,0xf4fb}, 
         {0x8b62,0xf4fc},  {0x8b63,0xf4fd},  {0x8b64,0xf4fe},  {0x8b65,0xf4ff}, 
         {0x8b66,0xf500},  {0x8b67,0xf501},  {0x8b68,0xf502},  {0x8b69,0xf503}, 
         {0x8b6a,0xf504},  {0x8b6b,0xf505},  {0x8b6c,0xf506},  {0x8b6d,0xf507}, 
         {0x8b6e,0xf508},  {0x8b6f,0xf509},  {0x8b70,0xf50a},  {0x8b71,0xf50b}, 
         {0x8b72,0xf50c},  {0x8b73,0xf50d},  {0x8b74,0xf50e},  {0x8b75,0xf50f}, 
         {0x8b76,0xf510},  {0x8b77,0xf511},  {0x8b78,0xf512},  {0x8b79,0xf513}, 
         {0x8b7a,0xf514},  {0x8b7b,0xf515},  {0x8b7c,0xf516},  {0x8b7d,0xf517}, 
         {0x8b7e,0xf518},  {0x8ba1,0xf519},  {0x8ba2,0xf51a},  {0x8ba3,0xf51b}, 
         {0x8ba4,0xf51c},  {0x8ba5,0xf51d},  {0x8ba6,0xf51e},  {0x8ba7,0xf51f}, 
         {0x8ba8,0xf520},  {0x8ba9,0xf521},  {0x8baa,0xf522},  {0x8bab,0xf523}, 
         {0x8bac,0xf524},  {0x8bad,0xf525},  {0x8bae,0xf526},  {0x8baf,0xf527}, 
         {0x8bb0,0xf528},  {0x8bb1,0xf529},  {0x8bb2,0xf52a},  {0x8bb3,0xf52b}, 
         {0x8bb4,0xf52c},  {0x8bb5,0xf52d},  {0x8bb6,0xf52e},  {0x8bb7,0xf52f}, 
         {0x8bb8,0xf530},  {0x8bb9,0xf531},  {0x8bba,0xf532},  {0x8bbb,0xf533}, 
         {0x8bbc,0xf534},  {0x8bbd,0xf535},  {0x8bbe,0xf536},  {0x8bbf,0xf537}, 
         {0x8bc0,0xf538},  {0x8bc1,0xf539},  {0x8bc2,0xf53a},  {0x8bc3,0xf53b}, 
         {0x8bc4,0xf53c},  {0x8bc5,0xf53d},  {0x8bc6,0xf53e},  {0x8bc7,0xf53f}, 
         {0x8bc8,0xf540},  {0x8bc9,0xf541},  {0x8bca,0xf542},  {0x8bcb,0xf543}, 
         {0x8bcc,0xf544},  {0x8bcd,0xf545},  {0x8bce,0xf546},  {0x8bcf,0xf547}, 
         {0x8bd0,0xf548},  {0x8bd1,0xf549},  {0x8bd2,0xf54a},  {0x8bd3,0xf54b}, 
         {0x8bd4,0xf54c},  {0x8bd5,0xf54d},  {0x8bd6,0xf54e},  {0x8bd7,0xf54f}, 
         {0x8bd8,0xf550},  {0x8bd9,0xf551},  {0x8bda,0xf552},  {0x8bdb,0xf553}, 
         {0x8bdc,0xf554},  {0x8bdd,0xf555},  {0x8bde,0xf556},  {0x8bdf,0xf557}, 
         {0x8be0,0xf558},  {0x8be1,0xf559},  {0x8be2,0xf55a},  {0x8be3,0xf55b}, 
         {0x8be4,0xf55c},  {0x8be5,0xf55d},  {0x8be6,0xf55e},  {0x8be7,0xf55f}, 
         {0x8be8,0xf560},  {0x8be9,0xf561},  {0x8bea,0xf562},  {0x8beb,0xf563}, 
         {0x8bec,0xf564},  {0x8bed,0xf565},  {0x8bee,0xf566},  {0x8bef,0xf567}, 
         {0x8bf0,0xf568},  {0x8bf1,0xf569},  {0x8bf2,0xf56a},  {0x8bf3,0xf56b}, 
         {0x8bf4,0xf56c},  {0x8bf5,0xf56d},  {0x8bf6,0xf56e},  {0x8bf7,0xf56f}, 
         {0x8bf8,0xf570},  {0x8bf9,0xf571},  {0x8bfa,0xf572},  {0x8bfb,0xf573}, 
         {0x8bfc,0xf574},  {0x8bfd,0xf575},  {0x8bfe,0xf576},  {0x8c40,0xf577}, 
         {0x8c41,0xf578},  {0x8c42,0xf579},  {0x8c43,0xf57a},  {0x8c44,0xf57b}, 
         {0x8c45,0xf57c},  {0x8c46,0xf57d},  {0x8c47,0xf57e},  {0x8c48,0xf57f}, 
         {0x8c49,0xf580},  {0x8c4a,0xf581},  {0x8c4b,0xf582},  {0x8c4c,0xf583}, 
         {0x8c4d,0xf584},  {0x8c4e,0xf585},  {0x8c4f,0xf586},  {0x8c50,0xf587}, 
         {0x8c51,0xf588},  {0x8c52,0xf589},  {0x8c53,0xf58a},  {0x8c54,0xf58b}, 
         {0x8c55,0xf58c},  {0x8c56,0xf58d},  {0x8c57,0xf58e},  {0x8c58,0xf58f}, 
         {0x8c59,0xf590},  {0x8c5a,0xf591},  {0x8c5b,0xf592},  {0x8c5c,0xf593}, 
         {0x8c5d,0xf594},  {0x8c5e,0xf595},  {0x8c5f,0xf596},  {0x8c60,0xf597}, 
         {0x8c61,0xf598},  {0x8c62,0xf599},  {0x8c63,0xf59a},  {0x8c64,0xf59b}, 
         {0x8c65,0xf59c},  {0x8c66,0xf59d},  {0x8c67,0xf59e},  {0x8c68,0xf59f}, 
         {0x8c69,0xf5a0},  {0x8c6a,0xf5a1},  {0x8c6b,0xf5a2},  {0x8c6c,0xf5a3}, 
         {0x8c6d,0xf5a4},  {0x8c6e,0xf5a5},  {0x8c6f,0xf5a6},  {0x8c70,0xf5a7}, 
         {0x8c71,0xf5a8},  {0x8c72,0xf5a9},  {0x8c73,0xf5aa},  {0x8c74,0xf5ab}, 
         {0x8c75,0xf5ac},  {0x8c76,0xf5ad},  {0x8c77,0xf5ae},  {0x8c78,0xf5af}, 
         {0x8c79,0xf5b0},  {0x8c7a,0xf5b1},  {0x8c7b,0xf5b2},  {0x8c7c,0xf5b3}, 
         {0x8c7d,0xf5b4},  {0x8c7e,0xf5b5},  {0x8ca1,0xf5b6},  {0x8ca2,0xf5b7}, 
         {0x8ca3,0xf5b8},  {0x8ca4,0xf5b9},  {0x8ca5,0xf5ba},  {0x8ca6,0xf5bb}, 
         {0x8ca7,0xf5bc},  {0x8ca8,0xf5bd},  {0x8ca9,0xf5be},  {0x8caa,0xf5bf}, 
         {0x8cab,0xf5c0},  {0x8cac,0xf5c1},  {0x8cad,0xf5c2},  {0x8cae,0xf5c3}, 
         {0x8caf,0xf5c4},  {0x8cb0,0xf5c5},  {0x8cb1,0xf5c6},  {0x8cb2,0xf5c7}, 
         {0x8cb3,0xf5c8},  {0x8cb4,0xf5c9},  {0x8cb5,0xf5ca},  {0x8cb6,0xf5cb}, 
         {0x8cb7,0xf5cc},  {0x8cb8,0xf5cd},  {0x8cb9,0xf5ce},  {0x8cba,0xf5cf}, 
         {0x8cbb,0xf5d0},  {0x8cbc,0xf5d1},  {0x8cbd,0xf5d2},  {0x8cbe,0xf5d3}, 
         {0x8cbf,0xf5d4},  {0x8cc0,0xf5d5},  {0x8cc1,0xf5d6},  {0x8cc2,0xf5d7}, 
         {0x8cc3,0xf5d8},  {0x8cc4,0xf5d9},  {0x8cc5,0xf5da},  {0x8cc6,0xf5db}, 
         {0x8cc7,0xf5dc},  {0x8cc8,0xf5dd},  {0x8cc9,0xf5de},  {0x8cca,0xf5df}, 
         {0x8ccb,0xf5e0},  {0x8ccc,0xf5e1},  {0x8ccd,0xf5e2},  {0x8cce,0xf5e3}, 
         {0x8ccf,0xf5e4},  {0x8cd0,0xf5e5},  {0x8cd1,0xf5e6},  {0x8cd2,0xf5e7}, 
         {0x8cd3,0xf5e8},  {0x8cd4,0xf5e9},  {0x8cd5,0xf5ea},  {0x8cd6,0xf5eb}, 
         {0x8cd7,0xf5ec},  {0x8cd8,0xf5ed},  {0x8cd9,0xf5ee},  {0x8cda,0xf5ef}, 
         {0x8cdb,0xf5f0},  {0x8cdc,0xf5f1},  {0x8cdd,0xf5f2},  {0x8cde,0xf5f3}, 
         {0x8cdf,0xf5f4},  {0x8ce0,0xf5f5},  {0x8ce1,0xf5f6},  {0x8ce2,0xf5f7}, 
         {0x8ce3,0xf5f8},  {0x8ce4,0xf5f9},  {0x8ce5,0xf5fa},  {0x8ce6,0xf5fb}, 
         {0x8ce7,0xf5fc},  {0x8ce8,0xf5fd},  {0x8ce9,0xf5fe},  {0x8cea,0xf5ff}, 
         {0x8ceb,0xf600},  {0x8cec,0xf601},  {0x8ced,0xf602},  {0x8cee,0xf603}, 
         {0x8cef,0xf604},  {0x8cf0,0xf605},  {0x8cf1,0xf606},  {0x8cf2,0xf607}, 
         {0x8cf3,0xf608},  {0x8cf4,0xf609},  {0x8cf5,0xf60a},  {0x8cf6,0xf60b}, 
         {0x8cf7,0xf60c},  {0x8cf8,0xf60d},  {0x8cf9,0xf60e},  {0x8cfa,0xf60f}, 
         {0x8cfb,0xf610},  {0x8cfc,0xf611},  {0x8cfd,0xf612},  {0x8cfe,0xf613}, 
         {0x8d40,0xf614},  {0x8d41,0xf615},  {0x8d42,0xf616},  {0x8d43,0xf617}, 
         {0x8d44,0xf618},  {0x8d45,0xf619},  {0x8d46,0xf61a},  {0x8d47,0xf61b}, 
         {0x8d48,0xf61c},  {0x8d49,0xf61d},  {0x8d4a,0xf61e},  {0x8d4b,0xf61f}, 
         {0x8d4c,0xf620},  {0x8d4d,0xf621},  {0x8d4e,0xf622},  {0x8d4f,0xf623}, 
         {0x8d50,0xf624},  {0x8d51,0xf625},  {0x8d52,0xf626},  {0x8d53,0xf627}, 
         {0x8d54,0xf628},  {0x8d55,0xf629},  {0x8d56,0xf62a},  {0x8d57,0xf62b}, 
         {0x8d58,0xf62c},  {0x8d59,0xf62d},  {0x8d5a,0xf62e},  {0x8d5b,0xf62f}, 
         {0x8d5c,0xf630},  {0x8d5d,0xf631},  {0x8d5e,0xf632},  {0x8d5f,0xf633}, 
         {0x8d60,0xf634},  {0x8d61,0xf635},  {0x8d62,0xf636},  {0x8d63,0xf637}, 
         {0x8d64,0xf638},  {0x8d65,0xf639},  {0x8d66,0xf63a},  {0x8d67,0xf63b}, 
         {0x8d68,0xf63c},  {0x8d69,0xf63d},  {0x8d6a,0xf63e},  {0x8d6b,0xf63f}, 
         {0x8d6c,0xf640},  {0x8d6d,0xf641},  {0x8d6e,0xf642},  {0x8d6f,0xf643}, 
         {0x8d70,0xf644},  {0x8d71,0xf645},  {0x8d72,0xf646},  {0x8d73,0xf647}, 
         {0x8d74,0xf648},  {0x8d75,0xf649},  {0x8d76,0xf64a},  {0x8d77,0xf64b}, 
         {0x8d78,0xf64c},  {0x8d79,0xf64d},  {0x8d7a,0xf64e},  {0x8d7b,0xf64f}, 
         {0x8d7c,0xf650},  {0x8d7d,0xf651},  {0x8d7e,0xf652},  {0x8da1,0xf653}, 
         {0x8da2,0xf654},  {0x8da3,0xf655},  {0x8da4,0xf656},  {0x8da5,0xf657}, 
         {0x8da6,0xf658},  {0x8da7,0xf659},  {0x8da8,0xf65a},  {0x8da9,0xf65b}, 
         {0x8daa,0xf65c},  {0x8dab,0xf65d},  {0x8dac,0xf65e},  {0x8dad,0xf65f}, 
         {0x8dae,0xf660},  {0x8daf,0xf661},  {0x8db0,0xf662},  {0x8db1,0xf663}, 
         {0x8db2,0xf664},  {0x8db3,0xf665},  {0x8db4,0xf666},  {0x8db5,0xf667}, 
         {0x8db6,0xf668},  {0x8db7,0xf669},  {0x8db8,0xf66a},  {0x8db9,0xf66b}, 
         {0x8dba,0xf66c},  {0x8dbb,0xf66d},  {0x8dbc,0xf66e},  {0x8dbd,0xf66f}, 
         {0x8dbe,0xf670},  {0x8dbf,0xf671},  {0x8dc0,0xf672},  {0x8dc1,0xf673}, 
         {0x8dc2,0xf674},  {0x8dc3,0xf675},  {0x8dc4,0xf676},  {0x8dc5,0xf677}, 
         {0x8dc6,0xf678},  {0x8dc7,0xf679},  {0x8dc8,0xf67a},  {0x8dc9,0xf67b}, 
         {0x8dca,0xf67c},  {0x8dcb,0xf67d},  {0x8dcc,0xf67e},  {0x8dcd,0xf67f}, 
         {0x8dce,0xf680},  {0x8dcf,0xf681},  {0x8dd0,0xf682},  {0x8dd1,0xf683}, 
         {0x8dd2,0xf684},  {0x8dd3,0xf685},  {0x8dd4,0xf686},  {0x8dd5,0xf687}, 
         {0x8dd6,0xf688},  {0x8dd7,0xf689},  {0x8dd8,0xf68a},  {0x8dd9,0xf68b}, 
         {0x8dda,0xf68c},  {0x8ddb,0xf68d},  {0x8ddc,0xf68e},  {0x8ddd,0xf68f}, 
         {0x8dde,0xf690},  {0x8ddf,0xf691},  {0x8de0,0xf692},  {0x8de1,0xf693}, 
         {0x8de2,0xf694},  {0x8de3,0xf695},  {0x8de4,0xf696},  {0x8de5,0xf697}, 
         {0x8de6,0xf698},  {0x8de7,0xf699},  {0x8de8,0xf69a},  {0x8de9,0xf69b}, 
         {0x8dea,0xf69c},  {0x8deb,0xf69d},  {0x8dec,0xf69e},  {0x8ded,0xf69f}, 
         {0x8dee,0xf6a0},  {0x8def,0xf6a1},  {0x8df0,0xf6a2},  {0x8df1,0xf6a3}, 
         {0x8df2,0xf6a4},  {0x8df3,0xf6a5},  {0x8df4,0xf6a6},  {0x8df5,0xf6a7}, 
         {0x8df6,0xf6a8},  {0x8df7,0xf6a9},  {0x8df8,0xf6aa},  {0x8df9,0xf6ab}, 
         {0x8dfa,0xf6ac},  {0x8dfb,0xf6ad},  {0x8dfc,0xf6ae},  {0x8dfd,0xf6af}, 
         {0x8dfe,0xf6b0} 
};
static const B5Map b5_8E40_to_uc_map[] = {
        /* 0x8E40 - 0xA0FE */
         {0x8e40,0xe311},  {0x8e41,0xe312},  {0x8e42,0xe313},  {0x8e43,0xe314}, 
         {0x8e44,0xe315},  {0x8e45,0xe316},  {0x8e46,0xe317},  {0x8e47,0xe318}, 
         {0x8e48,0xe319},  {0x8e49,0xe31a},  {0x8e4a,0xe31b},  {0x8e4b,0xe31c}, 
         {0x8e4c,0xe31d},  {0x8e4d,0xe31e},  {0x8e4e,0xe31f},  {0x8e4f,0xe320}, 
         {0x8e50,0xe321},  {0x8e51,0xe322},  {0x8e52,0xe323},  {0x8e53,0xe324}, 
         {0x8e54,0xe325},  {0x8e55,0xe326},  {0x8e56,0xe327},  {0x8e57,0xe328}, 
         {0x8e58,0xe329},  {0x8e59,0xe32a},  {0x8e5a,0xe32b},  {0x8e5b,0xe32c}, 
         {0x8e5c,0xe32d},  {0x8e5d,0xe32e},  {0x8e5e,0xe32f},  {0x8e5f,0xe330}, 
         {0x8e60,0xe331},  {0x8e61,0xe332},  {0x8e62,0xe333},  {0x8e63,0xe334}, 
         {0x8e64,0xe335},  {0x8e65,0xe336},  {0x8e66,0xe337},  {0x8e67,0xe338}, 
         {0x8e68,0xe339},  {0x8e69,0xe33a},  {0x8e6a,0xe33b},  {0x8e6b,0xe33c}, 
         {0x8e6c,0xe33d},  {0x8e6d,0xe33e},  {0x8e6e,0xe33f},  {0x8e6f,0xe340}, 
         {0x8e70,0xe341},  {0x8e71,0xe342},  {0x8e72,0xe343},  {0x8e73,0xe344}, 
         {0x8e74,0xe345},  {0x8e75,0xe346},  {0x8e76,0xe347},  {0x8e77,0xe348}, 
         {0x8e78,0xe349},  {0x8e79,0xe34a},  {0x8e7a,0xe34b},  {0x8e7b,0xe34c}, 
         {0x8e7c,0xe34d},  {0x8e7d,0xe34e},  {0x8e7e,0xe34f},  {0x8ea1,0xe350}, 
         {0x8ea2,0xe351},  {0x8ea3,0xe352},  {0x8ea4,0xe353},  {0x8ea5,0xe354}, 
         {0x8ea6,0xe355},  {0x8ea7,0xe356},  {0x8ea8,0xe357},  {0x8ea9,0xe358}, 
         {0x8eaa,0xe359},  {0x8eab,0xe35a},  {0x8eac,0xe35b},  {0x8ead,0xe35c}, 
         {0x8eae,0xe35d},  {0x8eaf,0xe35e},  {0x8eb0,0xe35f},  {0x8eb1,0xe360}, 
         {0x8eb2,0xe361},  {0x8eb3,0xe362},  {0x8eb4,0xe363},  {0x8eb5,0xe364}, 
         {0x8eb6,0xe365},  {0x8eb7,0xe366},  {0x8eb8,0xe367},  {0x8eb9,0xe368}, 
         {0x8eba,0xe369},  {0x8ebb,0xe36a},  {0x8ebc,0xe36b},  {0x8ebd,0xe36c}, 
         {0x8ebe,0xe36d},  {0x8ebf,0xe36e},  {0x8ec0,0xe36f},  {0x8ec1,0xe370}, 
         {0x8ec2,0xe371},  {0x8ec3,0xe372},  {0x8ec4,0xe373},  {0x8ec5,0xe374}, 
         {0x8ec6,0xe375},  {0x8ec7,0xe376},  {0x8ec8,0xe377},  {0x8ec9,0xe378}, 
         {0x8eca,0xe379},  {0x8ecb,0xe37a},  {0x8ecc,0xe37b},  {0x8ecd,0xe37c}, 
         {0x8ece,0xe37d},  {0x8ecf,0xe37e},  {0x8ed0,0xe37f},  {0x8ed1,0xe380}, 
         {0x8ed2,0xe381},  {0x8ed3,0xe382},  {0x8ed4,0xe383},  {0x8ed5,0xe384}, 
         {0x8ed6,0xe385},  {0x8ed7,0xe386},  {0x8ed8,0xe387},  {0x8ed9,0xe388}, 
         {0x8eda,0xe389},  {0x8edb,0xe38a},  {0x8edc,0xe38b},  {0x8edd,0xe38c}, 
         {0x8ede,0xe38d},  {0x8edf,0xe38e},  {0x8ee0,0xe38f},  {0x8ee1,0xe390}, 
         {0x8ee2,0xe391},  {0x8ee3,0xe392},  {0x8ee4,0xe393},  {0x8ee5,0xe394}, 
         {0x8ee6,0xe395},  {0x8ee7,0xe396},  {0x8ee8,0xe397},  {0x8ee9,0xe398}, 
         {0x8eea,0xe399},  {0x8eeb,0xe39a},  {0x8eec,0xe39b},  {0x8eed,0xe39c}, 
         {0x8eee,0xe39d},  {0x8eef,0xe39e},  {0x8ef0,0xe39f},  {0x8ef1,0xe3a0}, 
         {0x8ef2,0xe3a1},  {0x8ef3,0xe3a2},  {0x8ef4,0xe3a3},  {0x8ef5,0xe3a4}, 
         {0x8ef6,0xe3a5},  {0x8ef7,0xe3a6},  {0x8ef8,0xe3a7},  {0x8ef9,0xe3a8}, 
         {0x8efa,0xe3a9},  {0x8efb,0xe3aa},  {0x8efc,0xe3ab},  {0x8efd,0xe3ac}, 
         {0x8efe,0xe3ad},  {0x8f40,0xe3ae},  {0x8f41,0xe3af},  {0x8f42,0xe3b0}, 
         {0x8f43,0xe3b1},  {0x8f44,0xe3b2},  {0x8f45,0xe3b3},  {0x8f46,0xe3b4}, 
         {0x8f47,0xe3b5},  {0x8f48,0xe3b6},  {0x8f49,0xe3b7},  {0x8f4a,0xe3b8}, 
         {0x8f4b,0xe3b9},  {0x8f4c,0xe3ba},  {0x8f4d,0xe3bb},  {0x8f4e,0xe3bc}, 
         {0x8f4f,0xe3bd},  {0x8f50,0xe3be},  {0x8f51,0xe3bf},  {0x8f52,0xe3c0}, 
         {0x8f53,0xe3c1},  {0x8f54,0xe3c2},  {0x8f55,0xe3c3},  {0x8f56,0xe3c4}, 
         {0x8f57,0xe3c5},  {0x8f58,0xe3c6},  {0x8f59,0xe3c7},  {0x8f5a,0xe3c8}, 
         {0x8f5b,0xe3c9},  {0x8f5c,0xe3ca},  {0x8f5d,0xe3cb},  {0x8f5e,0xe3cc}, 
         {0x8f5f,0xe3cd},  {0x8f60,0xe3ce},  {0x8f61,0xe3cf},  {0x8f62,0xe3d0}, 
         {0x8f63,0xe3d1},  {0x8f64,0xe3d2},  {0x8f65,0xe3d3},  {0x8f66,0xe3d4}, 
         {0x8f67,0xe3d5},  {0x8f68,0xe3d6},  {0x8f69,0xe3d7},  {0x8f6a,0xe3d8}, 
         {0x8f6b,0xe3d9},  {0x8f6c,0xe3da},  {0x8f6d,0xe3db},  {0x8f6e,0xe3dc}, 
         {0x8f6f,0xe3dd},  {0x8f70,0xe3de},  {0x8f71,0xe3df},  {0x8f72,0xe3e0}, 
         {0x8f73,0xe3e1},  {0x8f74,0xe3e2},  {0x8f75,0xe3e3},  {0x8f76,0xe3e4}, 
         {0x8f77,0xe3e5},  {0x8f78,0xe3e6},  {0x8f79,0xe3e7},  {0x8f7a,0xe3e8}, 
         {0x8f7b,0xe3e9},  {0x8f7c,0xe3ea},  {0x8f7d,0xe3eb},  {0x8f7e,0xe3ec}, 
         {0x8fa1,0xe3ed},  {0x8fa2,0xe3ee},  {0x8fa3,0xe3ef},  {0x8fa4,0xe3f0}, 
         {0x8fa5,0xe3f1},  {0x8fa6,0xe3f2},  {0x8fa7,0xe3f3},  {0x8fa8,0xe3f4}, 
         {0x8fa9,0xe3f5},  {0x8faa,0xe3f6},  {0x8fab,0xe3f7},  {0x8fac,0xe3f8}, 
         {0x8fad,0xe3f9},  {0x8fae,0xe3fa},  {0x8faf,0xe3fb},  {0x8fb0,0xe3fc}, 
         {0x8fb1,0xe3fd},  {0x8fb2,0xe3fe},  {0x8fb3,0xe3ff},  {0x8fb4,0xe400}, 
         {0x8fb5,0xe401},  {0x8fb6,0xe402},  {0x8fb7,0xe403},  {0x8fb8,0xe404}, 
         {0x8fb9,0xe405},  {0x8fba,0xe406},  {0x8fbb,0xe407},  {0x8fbc,0xe408}, 
         {0x8fbd,0xe409},  {0x8fbe,0xe40a},  {0x8fbf,0xe40b},  {0x8fc0,0xe40c}, 
         {0x8fc1,0xe40d},  {0x8fc2,0xe40e},  {0x8fc3,0xe40f},  {0x8fc4,0xe410}, 
         {0x8fc5,0xe411},  {0x8fc6,0xe412},  {0x8fc7,0xe413},  {0x8fc8,0xe414}, 
         {0x8fc9,0xe415},  {0x8fca,0xe416},  {0x8fcb,0xe417},  {0x8fcc,0xe418}, 
         {0x8fcd,0xe419},  {0x8fce,0xe41a},  {0x8fcf,0xe41b},  {0x8fd0,0xe41c}, 
         {0x8fd1,0xe41d},  {0x8fd2,0xe41e},  {0x8fd3,0xe41f},  {0x8fd4,0xe420}, 
         {0x8fd5,0xe421},  {0x8fd6,0xe422},  {0x8fd7,0xe423},  {0x8fd8,0xe424}, 
         {0x8fd9,0xe425},  {0x8fda,0xe426},  {0x8fdb,0xe427},  {0x8fdc,0xe428}, 
         {0x8fdd,0xe429},  {0x8fde,0xe42a},  {0x8fdf,0xe42b},  {0x8fe0,0xe42c}, 
         {0x8fe1,0xe42d},  {0x8fe2,0xe42e},  {0x8fe3,0xe42f},  {0x8fe4,0xe430}, 
         {0x8fe5,0xe431},  {0x8fe6,0xe432},  {0x8fe7,0xe433},  {0x8fe8,0xe434}, 
         {0x8fe9,0xe435},  {0x8fea,0xe436},  {0x8feb,0xe437},  {0x8fec,0xe438}, 
         {0x8fed,0xe439},  {0x8fee,0xe43a},  {0x8fef,0xe43b},  {0x8ff0,0xe43c}, 
         {0x8ff1,0xe43d},  {0x8ff2,0xe43e},  {0x8ff3,0xe43f},  {0x8ff4,0xe440}, 
         {0x8ff5,0xe441},  {0x8ff6,0xe442},  {0x8ff7,0xe443},  {0x8ff8,0xe444}, 
         {0x8ff9,0xe445},  {0x8ffa,0xe446},  {0x8ffb,0xe447},  {0x8ffc,0xe448}, 
         {0x8ffd,0xe449},  {0x8ffe,0xe44a},  {0x9040,0xe44b},  {0x9041,0xe44c}, 
         {0x9042,0xe44d},  {0x9043,0xe44e},  {0x9044,0xe44f},  {0x9045,0xe450}, 
         {0x9046,0xe451},  {0x9047,0xe452},  {0x9048,0xe453},  {0x9049,0xe454}, 
         {0x904a,0xe455},  {0x904b,0xe456},  {0x904c,0xe457},  {0x904d,0xe458}, 
         {0x904e,0xe459},  {0x904f,0xe45a},  {0x9050,0xe45b},  {0x9051,0xe45c}, 
         {0x9052,0xe45d},  {0x9053,0xe45e},  {0x9054,0xe45f},  {0x9055,0xe460}, 
         {0x9056,0xe461},  {0x9057,0xe462},  {0x9058,0xe463},  {0x9059,0xe464}, 
         {0x905a,0xe465},  {0x905b,0xe466},  {0x905c,0xe467},  {0x905d,0xe468}, 
         {0x905e,0xe469},  {0x905f,0xe46a},  {0x9060,0xe46b},  {0x9061,0xe46c}, 
         {0x9062,0xe46d},  {0x9063,0xe46e},  {0x9064,0xe46f},  {0x9065,0xe470}, 
         {0x9066,0xe471},  {0x9067,0xe472},  {0x9068,0xe473},  {0x9069,0xe474}, 
         {0x906a,0xe475},  {0x906b,0xe476},  {0x906c,0xe477},  {0x906d,0xe478}, 
         {0x906e,0xe479},  {0x906f,0xe47a},  {0x9070,0xe47b},  {0x9071,0xe47c}, 
         {0x9072,0xe47d},  {0x9073,0xe47e},  {0x9074,0xe47f},  {0x9075,0xe480}, 
         {0x9076,0xe481},  {0x9077,0xe482},  {0x9078,0xe483},  {0x9079,0xe484}, 
         {0x907a,0xe485},  {0x907b,0xe486},  {0x907c,0xe487},  {0x907d,0xe488}, 
         {0x907e,0xe489},  {0x90a1,0xe48a},  {0x90a2,0xe48b},  {0x90a3,0xe48c}, 
         {0x90a4,0xe48d},  {0x90a5,0xe48e},  {0x90a6,0xe48f},  {0x90a7,0xe490}, 
         {0x90a8,0xe491},  {0x90a9,0xe492},  {0x90aa,0xe493},  {0x90ab,0xe494}, 
         {0x90ac,0xe495},  {0x90ad,0xe496},  {0x90ae,0xe497},  {0x90af,0xe498}, 
         {0x90b0,0xe499},  {0x90b1,0xe49a},  {0x90b2,0xe49b},  {0x90b3,0xe49c}, 
         {0x90b4,0xe49d},  {0x90b5,0xe49e},  {0x90b6,0xe49f},  {0x90b7,0xe4a0}, 
         {0x90b8,0xe4a1},  {0x90b9,0xe4a2},  {0x90ba,0xe4a3},  {0x90bb,0xe4a4}, 
         {0x90bc,0xe4a5},  {0x90bd,0xe4a6},  {0x90be,0xe4a7},  {0x90bf,0xe4a8}, 
         {0x90c0,0xe4a9},  {0x90c1,0xe4aa},  {0x90c2,0xe4ab},  {0x90c3,0xe4ac}, 
         {0x90c4,0xe4ad},  {0x90c5,0xe4ae},  {0x90c6,0xe4af},  {0x90c7,0xe4b0}, 
         {0x90c8,0xe4b1},  {0x90c9,0xe4b2},  {0x90ca,0xe4b3},  {0x90cb,0xe4b4}, 
         {0x90cc,0xe4b5},  {0x90cd,0xe4b6},  {0x90ce,0xe4b7},  {0x90cf,0xe4b8}, 
         {0x90d0,0xe4b9},  {0x90d1,0xe4ba},  {0x90d2,0xe4bb},  {0x90d3,0xe4bc}, 
         {0x90d4,0xe4bd},  {0x90d5,0xe4be},  {0x90d6,0xe4bf},  {0x90d7,0xe4c0}, 
         {0x90d8,0xe4c1},  {0x90d9,0xe4c2},  {0x90da,0xe4c3},  {0x90db,0xe4c4}, 
         {0x90dc,0xe4c5},  {0x90dd,0xe4c6},  {0x90de,0xe4c7},  {0x90df,0xe4c8}, 
         {0x90e0,0xe4c9},  {0x90e1,0xe4ca},  {0x90e2,0xe4cb},  {0x90e3,0xe4cc}, 
         {0x90e4,0xe4cd},  {0x90e5,0xe4ce},  {0x90e6,0xe4cf},  {0x90e7,0xe4d0}, 
         {0x90e8,0xe4d1},  {0x90e9,0xe4d2},  {0x90ea,0xe4d3},  {0x90eb,0xe4d4}, 
         {0x90ec,0xe4d5},  {0x90ed,0xe4d6},  {0x90ee,0xe4d7},  {0x90ef,0xe4d8}, 
         {0x90f0,0xe4d9},  {0x90f1,0xe4da},  {0x90f2,0xe4db},  {0x90f3,0xe4dc}, 
         {0x90f4,0xe4dd},  {0x90f5,0xe4de},  {0x90f6,0xe4df},  {0x90f7,0xe4e0}, 
         {0x90f8,0xe4e1},  {0x90f9,0xe4e2},  {0x90fa,0xe4e3},  {0x90fb,0xe4e4}, 
         {0x90fc,0xe4e5},  {0x90fd,0xe4e6},  {0x90fe,0xe4e7},  {0x9140,0xe4e8}, 
         {0x9141,0xe4e9},  {0x9142,0xe4ea},  {0x9143,0xe4eb},  {0x9144,0xe4ec}, 
         {0x9145,0xe4ed},  {0x9146,0xe4ee},  {0x9147,0xe4ef},  {0x9148,0xe4f0}, 
         {0x9149,0xe4f1},  {0x914a,0xe4f2},  {0x914b,0xe4f3},  {0x914c,0xe4f4}, 
         {0x914d,0xe4f5},  {0x914e,0xe4f6},  {0x914f,0xe4f7},  {0x9150,0xe4f8}, 
         {0x9151,0xe4f9},  {0x9152,0xe4fa},  {0x9153,0xe4fb},  {0x9154,0xe4fc}, 
         {0x9155,0xe4fd},  {0x9156,0xe4fe},  {0x9157,0xe4ff},  {0x9158,0xe500}, 
         {0x9159,0xe501},  {0x915a,0xe502},  {0x915b,0xe503},  {0x915c,0xe504}, 
         {0x915d,0xe505},  {0x915e,0xe506},  {0x915f,0xe507},  {0x9160,0xe508}, 
         {0x9161,0xe509},  {0x9162,0xe50a},  {0x9163,0xe50b},  {0x9164,0xe50c}, 
         {0x9165,0xe50d},  {0x9166,0xe50e},  {0x9167,0xe50f},  {0x9168,0xe510}, 
         {0x9169,0xe511},  {0x916a,0xe512},  {0x916b,0xe513},  {0x916c,0xe514}, 
         {0x916d,0xe515},  {0x916e,0xe516},  {0x916f,0xe517},  {0x9170,0xe518}, 
         {0x9171,0xe519},  {0x9172,0xe51a},  {0x9173,0xe51b},  {0x9174,0xe51c}, 
         {0x9175,0xe51d},  {0x9176,0xe51e},  {0x9177,0xe51f},  {0x9178,0xe520}, 
         {0x9179,0xe521},  {0x917a,0xe522},  {0x917b,0xe523},  {0x917c,0xe524}, 
         {0x917d,0xe525},  {0x917e,0xe526},  {0x91a1,0xe527},  {0x91a2,0xe528}, 
         {0x91a3,0xe529},  {0x91a4,0xe52a},  {0x91a5,0xe52b},  {0x91a6,0xe52c}, 
         {0x91a7,0xe52d},  {0x91a8,0xe52e},  {0x91a9,0xe52f},  {0x91aa,0xe530}, 
         {0x91ab,0xe531},  {0x91ac,0xe532},  {0x91ad,0xe533},  {0x91ae,0xe534}, 
         {0x91af,0xe535},  {0x91b0,0xe536},  {0x91b1,0xe537},  {0x91b2,0xe538}, 
         {0x91b3,0xe539},  {0x91b4,0xe53a},  {0x91b5,0xe53b},  {0x91b6,0xe53c}, 
         {0x91b7,0xe53d},  {0x91b8,0xe53e},  {0x91b9,0xe53f},  {0x91ba,0xe540}, 
         {0x91bb,0xe541},  {0x91bc,0xe542},  {0x91bd,0xe543},  {0x91be,0xe544}, 
         {0x91bf,0xe545},  {0x91c0,0xe546},  {0x91c1,0xe547},  {0x91c2,0xe548}, 
         {0x91c3,0xe549},  {0x91c4,0xe54a},  {0x91c5,0xe54b},  {0x91c6,0xe54c}, 
         {0x91c7,0xe54d},  {0x91c8,0xe54e},  {0x91c9,0xe54f},  {0x91ca,0xe550}, 
         {0x91cb,0xe551},  {0x91cc,0xe552},  {0x91cd,0xe553},  {0x91ce,0xe554}, 
         {0x91cf,0xe555},  {0x91d0,0xe556},  {0x91d1,0xe557},  {0x91d2,0xe558}, 
         {0x91d3,0xe559},  {0x91d4,0xe55a},  {0x91d5,0xe55b},  {0x91d6,0xe55c}, 
         {0x91d7,0xe55d},  {0x91d8,0xe55e},  {0x91d9,0xe55f},  {0x91da,0xe560}, 
         {0x91db,0xe561},  {0x91dc,0xe562},  {0x91dd,0xe563},  {0x91de,0xe564}, 
         {0x91df,0xe565},  {0x91e0,0xe566},  {0x91e1,0xe567},  {0x91e2,0xe568}, 
         {0x91e3,0xe569},  {0x91e4,0xe56a},  {0x91e5,0xe56b},  {0x91e6,0xe56c}, 
         {0x91e7,0xe56d},  {0x91e8,0xe56e},  {0x91e9,0xe56f},  {0x91ea,0xe570}, 
         {0x91eb,0xe571},  {0x91ec,0xe572},  {0x91ed,0xe573},  {0x91ee,0xe574}, 
         {0x91ef,0xe575},  {0x91f0,0xe576},  {0x91f1,0xe577},  {0x91f2,0xe578}, 
         {0x91f3,0xe579},  {0x91f4,0xe57a},  {0x91f5,0xe57b},  {0x91f6,0xe57c}, 
         {0x91f7,0xe57d},  {0x91f8,0xe57e},  {0x91f9,0xe57f},  {0x91fa,0xe580}, 
         {0x91fb,0xe581},  {0x91fc,0xe582},  {0x91fd,0xe583},  {0x91fe,0xe584}, 
         {0x9240,0xe585},  {0x9241,0xe586},  {0x9242,0xe587},  {0x9243,0xe588}, 
         {0x9244,0xe589},  {0x9245,0xe58a},  {0x9246,0xe58b},  {0x9247,0xe58c}, 
         {0x9248,0xe58d},  {0x9249,0xe58e},  {0x924a,0xe58f},  {0x924b,0xe590}, 
         {0x924c,0xe591},  {0x924d,0xe592},  {0x924e,0xe593},  {0x924f,0xe594}, 
         {0x9250,0xe595},  {0x9251,0xe596},  {0x9252,0xe597},  {0x9253,0xe598}, 
         {0x9254,0xe599},  {0x9255,0xe59a},  {0x9256,0xe59b},  {0x9257,0xe59c}, 
         {0x9258,0xe59d},  {0x9259,0xe59e},  {0x925a,0xe59f},  {0x925b,0xe5a0}, 
         {0x925c,0xe5a1},  {0x925d,0xe5a2},  {0x925e,0xe5a3},  {0x925f,0xe5a4}, 
         {0x9260,0xe5a5},  {0x9261,0xe5a6},  {0x9262,0xe5a7},  {0x9263,0xe5a8}, 
         {0x9264,0xe5a9},  {0x9265,0xe5aa},  {0x9266,0xe5ab},  {0x9267,0xe5ac}, 
         {0x9268,0xe5ad},  {0x9269,0xe5ae},  {0x926a,0xe5af},  {0x926b,0xe5b0}, 
         {0x926c,0xe5b1},  {0x926d,0xe5b2},  {0x926e,0xe5b3},  {0x926f,0xe5b4}, 
         {0x9270,0xe5b5},  {0x9271,0xe5b6},  {0x9272,0xe5b7},  {0x9273,0xe5b8}, 
         {0x9274,0xe5b9},  {0x9275,0xe5ba},  {0x9276,0xe5bb},  {0x9277,0xe5bc}, 
         {0x9278,0xe5bd},  {0x9279,0xe5be},  {0x927a,0xe5bf},  {0x927b,0xe5c0}, 
         {0x927c,0xe5c1},  {0x927d,0xe5c2},  {0x927e,0xe5c3},  {0x92a1,0xe5c4}, 
         {0x92a2,0xe5c5},  {0x92a3,0xe5c6},  {0x92a4,0xe5c7},  {0x92a5,0xe5c8}, 
         {0x92a6,0xe5c9},  {0x92a7,0xe5ca},  {0x92a8,0xe5cb},  {0x92a9,0xe5cc}, 
         {0x92aa,0xe5cd},  {0x92ab,0xe5ce},  {0x92ac,0xe5cf},  {0x92ad,0xe5d0}, 
         {0x92ae,0xe5d1},  {0x92af,0xe5d2},  {0x92b0,0xe5d3},  {0x92b1,0xe5d4}, 
         {0x92b2,0xe5d5},  {0x92b3,0xe5d6},  {0x92b4,0xe5d7},  {0x92b5,0xe5d8}, 
         {0x92b6,0xe5d9},  {0x92b7,0xe5da},  {0x92b8,0xe5db},  {0x92b9,0xe5dc}, 
         {0x92ba,0xe5dd},  {0x92bb,0xe5de},  {0x92bc,0xe5df},  {0x92bd,0xe5e0}, 
         {0x92be,0xe5e1},  {0x92bf,0xe5e2},  {0x92c0,0xe5e3},  {0x92c1,0xe5e4}, 
         {0x92c2,0xe5e5},  {0x92c3,0xe5e6},  {0x92c4,0xe5e7},  {0x92c5,0xe5e8}, 
         {0x92c6,0xe5e9},  {0x92c7,0xe5ea},  {0x92c8,0xe5eb},  {0x92c9,0xe5ec}, 
         {0x92ca,0xe5ed},  {0x92cb,0xe5ee},  {0x92cc,0xe5ef},  {0x92cd,0xe5f0}, 
         {0x92ce,0xe5f1},  {0x92cf,0xe5f2},  {0x92d0,0xe5f3},  {0x92d1,0xe5f4}, 
         {0x92d2,0xe5f5},  {0x92d3,0xe5f6},  {0x92d4,0xe5f7},  {0x92d5,0xe5f8}, 
         {0x92d6,0xe5f9},  {0x92d7,0xe5fa},  {0x92d8,0xe5fb},  {0x92d9,0xe5fc}, 
         {0x92da,0xe5fd},  {0x92db,0xe5fe},  {0x92dc,0xe5ff},  {0x92dd,0xe600}, 
         {0x92de,0xe601},  {0x92df,0xe602},  {0x92e0,0xe603},  {0x92e1,0xe604}, 
         {0x92e2,0xe605},  {0x92e3,0xe606},  {0x92e4,0xe607},  {0x92e5,0xe608}, 
         {0x92e6,0xe609},  {0x92e7,0xe60a},  {0x92e8,0xe60b},  {0x92e9,0xe60c}, 
         {0x92ea,0xe60d},  {0x92eb,0xe60e},  {0x92ec,0xe60f},  {0x92ed,0xe610}, 
         {0x92ee,0xe611},  {0x92ef,0xe612},  {0x92f0,0xe613},  {0x92f1,0xe614}, 
         {0x92f2,0xe615},  {0x92f3,0xe616},  {0x92f4,0xe617},  {0x92f5,0xe618}, 
         {0x92f6,0xe619},  {0x92f7,0xe61a},  {0x92f8,0xe61b},  {0x92f9,0xe61c}, 
         {0x92fa,0xe61d},  {0x92fb,0xe61e},  {0x92fc,0xe61f},  {0x92fd,0xe620}, 
         {0x92fe,0xe621},  {0x9340,0xe622},  {0x9341,0xe623},  {0x9342,0xe624}, 
         {0x9343,0xe625},  {0x9344,0xe626},  {0x9345,0xe627},  {0x9346,0xe628}, 
         {0x9347,0xe629},  {0x9348,0xe62a},  {0x9349,0xe62b},  {0x934a,0xe62c}, 
         {0x934b,0xe62d},  {0x934c,0xe62e},  {0x934d,0xe62f},  {0x934e,0xe630}, 
         {0x934f,0xe631},  {0x9350,0xe632},  {0x9351,0xe633},  {0x9352,0xe634}, 
         {0x9353,0xe635},  {0x9354,0xe636},  {0x9355,0xe637},  {0x9356,0xe638}, 
         {0x9357,0xe639},  {0x9358,0xe63a},  {0x9359,0xe63b},  {0x935a,0xe63c}, 
         {0x935b,0xe63d},  {0x935c,0xe63e},  {0x935d,0xe63f},  {0x935e,0xe640}, 
         {0x935f,0xe641},  {0x9360,0xe642},  {0x9361,0xe643},  {0x9362,0xe644}, 
         {0x9363,0xe645},  {0x9364,0xe646},  {0x9365,0xe647},  {0x9366,0xe648}, 
         {0x9367,0xe649},  {0x9368,0xe64a},  {0x9369,0xe64b},  {0x936a,0xe64c}, 
         {0x936b,0xe64d},  {0x936c,0xe64e},  {0x936d,0xe64f},  {0x936e,0xe650}, 
         {0x936f,0xe651},  {0x9370,0xe652},  {0x9371,0xe653},  {0x9372,0xe654}, 
         {0x9373,0xe655},  {0x9374,0xe656},  {0x9375,0xe657},  {0x9376,0xe658}, 
         {0x9377,0xe659},  {0x9378,0xe65a},  {0x9379,0xe65b},  {0x937a,0xe65c}, 
         {0x937b,0xe65d},  {0x937c,0xe65e},  {0x937d,0xe65f},  {0x937e,0xe660}, 
         {0x93a1,0xe661},  {0x93a2,0xe662},  {0x93a3,0xe663},  {0x93a4,0xe664}, 
         {0x93a5,0xe665},  {0x93a6,0xe666},  {0x93a7,0xe667},  {0x93a8,0xe668}, 
         {0x93a9,0xe669},  {0x93aa,0xe66a},  {0x93ab,0xe66b},  {0x93ac,0xe66c}, 
         {0x93ad,0xe66d},  {0x93ae,0xe66e},  {0x93af,0xe66f},  {0x93b0,0xe670}, 
         {0x93b1,0xe671},  {0x93b2,0xe672},  {0x93b3,0xe673},  {0x93b4,0xe674}, 
         {0x93b5,0xe675},  {0x93b6,0xe676},  {0x93b7,0xe677},  {0x93b8,0xe678}, 
         {0x93b9,0xe679},  {0x93ba,0xe67a},  {0x93bb,0xe67b},  {0x93bc,0xe67c}, 
         {0x93bd,0xe67d},  {0x93be,0xe67e},  {0x93bf,0xe67f},  {0x93c0,0xe680}, 
         {0x93c1,0xe681},  {0x93c2,0xe682},  {0x93c3,0xe683},  {0x93c4,0xe684}, 
         {0x93c5,0xe685},  {0x93c6,0xe686},  {0x93c7,0xe687},  {0x93c8,0xe688}, 
         {0x93c9,0xe689},  {0x93ca,0xe68a},  {0x93cb,0xe68b},  {0x93cc,0xe68c}, 
         {0x93cd,0xe68d},  {0x93ce,0xe68e},  {0x93cf,0xe68f},  {0x93d0,0xe690}, 
         {0x93d1,0xe691},  {0x93d2,0xe692},  {0x93d3,0xe693},  {0x93d4,0xe694}, 
         {0x93d5,0xe695},  {0x93d6,0xe696},  {0x93d7,0xe697},  {0x93d8,0xe698}, 
         {0x93d9,0xe699},  {0x93da,0xe69a},  {0x93db,0xe69b},  {0x93dc,0xe69c}, 
         {0x93dd,0xe69d},  {0x93de,0xe69e},  {0x93df,0xe69f},  {0x93e0,0xe6a0}, 
         {0x93e1,0xe6a1},  {0x93e2,0xe6a2},  {0x93e3,0xe6a3},  {0x93e4,0xe6a4}, 
         {0x93e5,0xe6a5},  {0x93e6,0xe6a6},  {0x93e7,0xe6a7},  {0x93e8,0xe6a8}, 
         {0x93e9,0xe6a9},  {0x93ea,0xe6aa},  {0x93eb,0xe6ab},  {0x93ec,0xe6ac}, 
         {0x93ed,0xe6ad},  {0x93ee,0xe6ae},  {0x93ef,0xe6af},  {0x93f0,0xe6b0}, 
         {0x93f1,0xe6b1},  {0x93f2,0xe6b2},  {0x93f3,0xe6b3},  {0x93f4,0xe6b4}, 
         {0x93f5,0xe6b5},  {0x93f6,0xe6b6},  {0x93f7,0xe6b7},  {0x93f8,0xe6b8}, 
         {0x93f9,0xe6b9},  {0x93fa,0xe6ba},  {0x93fb,0xe6bb},  {0x93fc,0xe6bc}, 
         {0x93fd,0xe6bd},  {0x93fe,0xe6be},  {0x9440,0xe6bf},  {0x9441,0xe6c0}, 
         {0x9442,0xe6c1},  {0x9443,0xe6c2},  {0x9444,0xe6c3},  {0x9445,0xe6c4}, 
         {0x9446,0xe6c5},  {0x9447,0xe6c6},  {0x9448,0xe6c7},  {0x9449,0xe6c8}, 
         {0x944a,0xe6c9},  {0x944b,0xe6ca},  {0x944c,0xe6cb},  {0x944d,0xe6cc}, 
         {0x944e,0xe6cd},  {0x944f,0xe6ce},  {0x9450,0xe6cf},  {0x9451,0xe6d0}, 
         {0x9452,0xe6d1},  {0x9453,0xe6d2},  {0x9454,0xe6d3},  {0x9455,0xe6d4}, 
         {0x9456,0xe6d5},  {0x9457,0xe6d6},  {0x9458,0xe6d7},  {0x9459,0xe6d8}, 
         {0x945a,0xe6d9},  {0x945b,0xe6da},  {0x945c,0xe6db},  {0x945d,0xe6dc}, 
         {0x945e,0xe6dd},  {0x945f,0xe6de},  {0x9460,0xe6df},  {0x9461,0xe6e0}, 
         {0x9462,0xe6e1},  {0x9463,0xe6e2},  {0x9464,0xe6e3},  {0x9465,0xe6e4}, 
         {0x9466,0xe6e5},  {0x9467,0xe6e6},  {0x9468,0xe6e7},  {0x9469,0xe6e8}, 
         {0x946a,0xe6e9},  {0x946b,0xe6ea},  {0x946c,0xe6eb},  {0x946d,0xe6ec}, 
         {0x946e,0xe6ed},  {0x946f,0xe6ee},  {0x9470,0xe6ef},  {0x9471,0xe6f0}, 
         {0x9472,0xe6f1},  {0x9473,0xe6f2},  {0x9474,0xe6f3},  {0x9475,0xe6f4}, 
         {0x9476,0xe6f5},  {0x9477,0xe6f6},  {0x9478,0xe6f7},  {0x9479,0xe6f8}, 
         {0x947a,0xe6f9},  {0x947b,0xe6fa},  {0x947c,0xe6fb},  {0x947d,0xe6fc}, 
         {0x947e,0xe6fd},  {0x94a1,0xe6fe},  {0x94a2,0xe6ff},  {0x94a3,0xe700}, 
         {0x94a4,0xe701},  {0x94a5,0xe702},  {0x94a6,0xe703},  {0x94a7,0xe704}, 
         {0x94a8,0xe705},  {0x94a9,0xe706},  {0x94aa,0xe707},  {0x94ab,0xe708}, 
         {0x94ac,0xe709},  {0x94ad,0xe70a},  {0x94ae,0xe70b},  {0x94af,0xe70c}, 
         {0x94b0,0xe70d},  {0x94b1,0xe70e},  {0x94b2,0xe70f},  {0x94b3,0xe710}, 
         {0x94b4,0xe711},  {0x94b5,0xe712},  {0x94b6,0xe713},  {0x94b7,0xe714}, 
         {0x94b8,0xe715},  {0x94b9,0xe716},  {0x94ba,0xe717},  {0x94bb,0xe718}, 
         {0x94bc,0xe719},  {0x94bd,0xe71a},  {0x94be,0xe71b},  {0x94bf,0xe71c}, 
         {0x94c0,0xe71d},  {0x94c1,0xe71e},  {0x94c2,0xe71f},  {0x94c3,0xe720}, 
         {0x94c4,0xe721},  {0x94c5,0xe722},  {0x94c6,0xe723},  {0x94c7,0xe724}, 
         {0x94c8,0xe725},  {0x94c9,0xe726},  {0x94ca,0xe727},  {0x94cb,0xe728}, 
         {0x94cc,0xe729},  {0x94cd,0xe72a},  {0x94ce,0xe72b},  {0x94cf,0xe72c}, 
         {0x94d0,0xe72d},  {0x94d1,0xe72e},  {0x94d2,0xe72f},  {0x94d3,0xe730}, 
         {0x94d4,0xe731},  {0x94d5,0xe732},  {0x94d6,0xe733},  {0x94d7,0xe734}, 
         {0x94d8,0xe735},  {0x94d9,0xe736},  {0x94da,0xe737},  {0x94db,0xe738}, 
         {0x94dc,0xe739},  {0x94dd,0xe73a},  {0x94de,0xe73b},  {0x94df,0xe73c}, 
         {0x94e0,0xe73d},  {0x94e1,0xe73e},  {0x94e2,0xe73f},  {0x94e3,0xe740}, 
         {0x94e4,0xe741},  {0x94e5,0xe742},  {0x94e6,0xe743},  {0x94e7,0xe744}, 
         {0x94e8,0xe745},  {0x94e9,0xe746},  {0x94ea,0xe747},  {0x94eb,0xe748}, 
         {0x94ec,0xe749},  {0x94ed,0xe74a},  {0x94ee,0xe74b},  {0x94ef,0xe74c}, 
         {0x94f0,0xe74d},  {0x94f1,0xe74e},  {0x94f2,0xe74f},  {0x94f3,0xe750}, 
         {0x94f4,0xe751},  {0x94f5,0xe752},  {0x94f6,0xe753},  {0x94f7,0xe754}, 
         {0x94f8,0xe755},  {0x94f9,0xe756},  {0x94fa,0xe757},  {0x94fb,0xe758}, 
         {0x94fc,0xe759},  {0x94fd,0xe75a},  {0x94fe,0xe75b},  {0x9540,0xe75c}, 
         {0x9541,0xe75d},  {0x9542,0xe75e},  {0x9543,0xe75f},  {0x9544,0xe760}, 
         {0x9545,0xe761},  {0x9546,0xe762},  {0x9547,0xe763},  {0x9548,0xe764}, 
         {0x9549,0xe765},  {0x954a,0xe766},  {0x954b,0xe767},  {0x954c,0xe768}, 
         {0x954d,0xe769},  {0x954e,0xe76a},  {0x954f,0xe76b},  {0x9550,0xe76c}, 
         {0x9551,0xe76d},  {0x9552,0xe76e},  {0x9553,0xe76f},  {0x9554,0xe770}, 
         {0x9555,0xe771},  {0x9556,0xe772},  {0x9557,0xe773},  {0x9558,0xe774}, 
         {0x9559,0xe775},  {0x955a,0xe776},  {0x955b,0xe777},  {0x955c,0xe778}, 
         {0x955d,0xe779},  {0x955e,0xe77a},  {0x955f,0xe77b},  {0x9560,0xe77c}, 
         {0x9561,0xe77d},  {0x9562,0xe77e},  {0x9563,0xe77f},  {0x9564,0xe780}, 
         {0x9565,0xe781},  {0x9566,0xe782},  {0x9567,0xe783},  {0x9568,0xe784}, 
         {0x9569,0xe785},  {0x956a,0xe786},  {0x956b,0xe787},  {0x956c,0xe788}, 
         {0x956d,0xe789},  {0x956e,0xe78a},  {0x956f,0xe78b},  {0x9570,0xe78c}, 
         {0x9571,0xe78d},  {0x9572,0xe78e},  {0x9573,0xe78f},  {0x9574,0xe790}, 
         {0x9575,0xe791},  {0x9576,0xe792},  {0x9577,0xe793},  {0x9578,0xe794}, 
         {0x9579,0xe795},  {0x957a,0xe796},  {0x957b,0xe797},  {0x957c,0xe798}, 
         {0x957d,0xe799},  {0x957e,0xe79a},  {0x95a1,0xe79b},  {0x95a2,0xe79c}, 
         {0x95a3,0xe79d},  {0x95a4,0xe79e},  {0x95a5,0xe79f},  {0x95a6,0xe7a0}, 
         {0x95a7,0xe7a1},  {0x95a8,0xe7a2},  {0x95a9,0xe7a3},  {0x95aa,0xe7a4}, 
         {0x95ab,0xe7a5},  {0x95ac,0xe7a6},  {0x95ad,0xe7a7},  {0x95ae,0xe7a8}, 
         {0x95af,0xe7a9},  {0x95b0,0xe7aa},  {0x95b1,0xe7ab},  {0x95b2,0xe7ac}, 
         {0x95b3,0xe7ad},  {0x95b4,0xe7ae},  {0x95b5,0xe7af},  {0x95b6,0xe7b0}, 
         {0x95b7,0xe7b1},  {0x95b8,0xe7b2},  {0x95b9,0xe7b3},  {0x95ba,0xe7b4}, 
         {0x95bb,0xe7b5},  {0x95bc,0xe7b6},  {0x95bd,0xe7b7},  {0x95be,0xe7b8}, 
         {0x95bf,0xe7b9},  {0x95c0,0xe7ba},  {0x95c1,0xe7bb},  {0x95c2,0xe7bc}, 
         {0x95c3,0xe7bd},  {0x95c4,0xe7be},  {0x95c5,0xe7bf},  {0x95c6,0xe7c0}, 
         {0x95c7,0xe7c1},  {0x95c8,0xe7c2},  {0x95c9,0xe7c3},  {0x95ca,0xe7c4}, 
         {0x95cb,0xe7c5},  {0x95cc,0xe7c6},  {0x95cd,0xe7c7},  {0x95ce,0xe7c8}, 
         {0x95cf,0xe7c9},  {0x95d0,0xe7ca},  {0x95d1,0xe7cb},  {0x95d2,0xe7cc}, 
         {0x95d3,0xe7cd},  {0x95d4,0xe7ce},  {0x95d5,0xe7cf},  {0x95d6,0xe7d0}, 
         {0x95d7,0xe7d1},  {0x95d8,0xe7d2},  {0x95d9,0xe7d3},  {0x95da,0xe7d4}, 
         {0x95db,0xe7d5},  {0x95dc,0xe7d6},  {0x95dd,0xe7d7},  {0x95de,0xe7d8}, 
         {0x95df,0xe7d9},  {0x95e0,0xe7da},  {0x95e1,0xe7db},  {0x95e2,0xe7dc}, 
         {0x95e3,0xe7dd},  {0x95e4,0xe7de},  {0x95e5,0xe7df},  {0x95e6,0xe7e0}, 
         {0x95e7,0xe7e1},  {0x95e8,0xe7e2},  {0x95e9,0xe7e3},  {0x95ea,0xe7e4}, 
         {0x95eb,0xe7e5},  {0x95ec,0xe7e6},  {0x95ed,0xe7e7},  {0x95ee,0xe7e8}, 
         {0x95ef,0xe7e9},  {0x95f0,0xe7ea},  {0x95f1,0xe7eb},  {0x95f2,0xe7ec}, 
         {0x95f3,0xe7ed},  {0x95f4,0xe7ee},  {0x95f5,0xe7ef},  {0x95f6,0xe7f0}, 
         {0x95f7,0xe7f1},  {0x95f8,0xe7f2},  {0x95f9,0xe7f3},  {0x95fa,0xe7f4}, 
         {0x95fb,0xe7f5},  {0x95fc,0xe7f6},  {0x95fd,0xe7f7},  {0x95fe,0xe7f8}, 
         {0x9640,0xe7f9},  {0x9641,0xe7fa},  {0x9642,0xe7fb},  {0x9643,0xe7fc}, 
         {0x9644,0xe7fd},  {0x9645,0xe7fe},  {0x9646,0xe7ff},  {0x9647,0xe800}, 
         {0x9648,0xe801},  {0x9649,0xe802},  {0x964a,0xe803},  {0x964b,0xe804}, 
         {0x964c,0xe805},  {0x964d,0xe806},  {0x964e,0xe807},  {0x964f,0xe808}, 
         {0x9650,0xe809},  {0x9651,0xe80a},  {0x9652,0xe80b},  {0x9653,0xe80c}, 
         {0x9654,0xe80d},  {0x9655,0xe80e},  {0x9656,0xe80f},  {0x9657,0xe810}, 
         {0x9658,0xe811},  {0x9659,0xe812},  {0x965a,0xe813},  {0x965b,0xe814}, 
         {0x965c,0xe815},  {0x965d,0xe816},  {0x965e,0xe817},  {0x965f,0xe818}, 
         {0x9660,0xe819},  {0x9661,0xe81a},  {0x9662,0xe81b},  {0x9663,0xe81c}, 
         {0x9664,0xe81d},  {0x9665,0xe81e},  {0x9666,0xe81f},  {0x9667,0xe820}, 
         {0x9668,0xe821},  {0x9669,0xe822},  {0x966a,0xe823},  {0x966b,0xe824}, 
         {0x966c,0xe825},  {0x966d,0xe826},  {0x966e,0xe827},  {0x966f,0xe828}, 
         {0x9670,0xe829},  {0x9671,0xe82a},  {0x9672,0xe82b},  {0x9673,0xe82c}, 
         {0x9674,0xe82d},  {0x9675,0xe82e},  {0x9676,0xe82f},  {0x9677,0xe830}, 
         {0x9678,0xe831},  {0x9679,0xe832},  {0x967a,0xe833},  {0x967b,0xe834}, 
         {0x967c,0xe835},  {0x967d,0xe836},  {0x967e,0xe837},  {0x96a1,0xe838}, 
         {0x96a2,0xe839},  {0x96a3,0xe83a},  {0x96a4,0xe83b},  {0x96a5,0xe83c}, 
         {0x96a6,0xe83d},  {0x96a7,0xe83e},  {0x96a8,0xe83f},  {0x96a9,0xe840}, 
         {0x96aa,0xe841},  {0x96ab,0xe842},  {0x96ac,0xe843},  {0x96ad,0xe844}, 
         {0x96ae,0xe845},  {0x96af,0xe846},  {0x96b0,0xe847},  {0x96b1,0xe848}, 
         {0x96b2,0xe849},  {0x96b3,0xe84a},  {0x96b4,0xe84b},  {0x96b5,0xe84c}, 
         {0x96b6,0xe84d},  {0x96b7,0xe84e},  {0x96b8,0xe84f},  {0x96b9,0xe850}, 
         {0x96ba,0xe851},  {0x96bb,0xe852},  {0x96bc,0xe853},  {0x96bd,0xe854}, 
         {0x96be,0xe855},  {0x96bf,0xe856},  {0x96c0,0xe857},  {0x96c1,0xe858}, 
         {0x96c2,0xe859},  {0x96c3,0xe85a},  {0x96c4,0xe85b},  {0x96c5,0xe85c}, 
         {0x96c6,0xe85d},  {0x96c7,0xe85e},  {0x96c8,0xe85f},  {0x96c9,0xe860}, 
         {0x96ca,0xe861},  {0x96cb,0xe862},  {0x96cc,0xe863},  {0x96cd,0xe864}, 
         {0x96ce,0xe865},  {0x96cf,0xe866},  {0x96d0,0xe867},  {0x96d1,0xe868}, 
         {0x96d2,0xe869},  {0x96d3,0xe86a},  {0x96d4,0xe86b},  {0x96d5,0xe86c}, 
         {0x96d6,0xe86d},  {0x96d7,0xe86e},  {0x96d8,0xe86f},  {0x96d9,0xe870}, 
         {0x96da,0xe871},  {0x96db,0xe872},  {0x96dc,0xe873},  {0x96dd,0xe874}, 
         {0x96de,0xe875},  {0x96df,0xe876},  {0x96e0,0xe877},  {0x96e1,0xe878}, 
         {0x96e2,0xe879},  {0x96e3,0xe87a},  {0x96e4,0xe87b},  {0x96e5,0xe87c}, 
         {0x96e6,0xe87d},  {0x96e7,0xe87e},  {0x96e8,0xe87f},  {0x96e9,0xe880}, 
         {0x96ea,0xe881},  {0x96eb,0xe882},  {0x96ec,0xe883},  {0x96ed,0xe884}, 
         {0x96ee,0xe885},  {0x96ef,0xe886},  {0x96f0,0xe887},  {0x96f1,0xe888}, 
         {0x96f2,0xe889},  {0x96f3,0xe88a},  {0x96f4,0xe88b},  {0x96f5,0xe88c}, 
         {0x96f6,0xe88d},  {0x96f7,0xe88e},  {0x96f8,0xe88f},  {0x96f9,0xe890}, 
         {0x96fa,0xe891},  {0x96fb,0xe892},  {0x96fc,0xe893},  {0x96fd,0xe894}, 
         {0x96fe,0xe895},  {0x9740,0xe896},  {0x9741,0xe897},  {0x9742,0xe898}, 
         {0x9743,0xe899},  {0x9744,0xe89a},  {0x9745,0xe89b},  {0x9746,0xe89c}, 
         {0x9747,0xe89d},  {0x9748,0xe89e},  {0x9749,0xe89f},  {0x974a,0xe8a0}, 
         {0x974b,0xe8a1},  {0x974c,0xe8a2},  {0x974d,0xe8a3},  {0x974e,0xe8a4}, 
         {0x974f,0xe8a5},  {0x9750,0xe8a6},  {0x9751,0xe8a7},  {0x9752,0xe8a8}, 
         {0x9753,0xe8a9},  {0x9754,0xe8aa},  {0x9755,0xe8ab},  {0x9756,0xe8ac}, 
         {0x9757,0xe8ad},  {0x9758,0xe8ae},  {0x9759,0xe8af},  {0x975a,0xe8b0}, 
         {0x975b,0xe8b1},  {0x975c,0xe8b2},  {0x975d,0xe8b3},  {0x975e,0xe8b4}, 
         {0x975f,0xe8b5},  {0x9760,0xe8b6},  {0x9761,0xe8b7},  {0x9762,0xe8b8}, 
         {0x9763,0xe8b9},  {0x9764,0xe8ba},  {0x9765,0xe8bb},  {0x9766,0xe8bc}, 
         {0x9767,0xe8bd},  {0x9768,0xe8be},  {0x9769,0xe8bf},  {0x976a,0xe8c0}, 
         {0x976b,0xe8c1},  {0x976c,0xe8c2},  {0x976d,0xe8c3},  {0x976e,0xe8c4}, 
         {0x976f,0xe8c5},  {0x9770,0xe8c6},  {0x9771,0xe8c7},  {0x9772,0xe8c8}, 
         {0x9773,0xe8c9},  {0x9774,0xe8ca},  {0x9775,0xe8cb},  {0x9776,0xe8cc}, 
         {0x9777,0xe8cd},  {0x9778,0xe8ce},  {0x9779,0xe8cf},  {0x977a,0xe8d0}, 
         {0x977b,0xe8d1},  {0x977c,0xe8d2},  {0x977d,0xe8d3},  {0x977e,0xe8d4}, 
         {0x97a1,0xe8d5},  {0x97a2,0xe8d6},  {0x97a3,0xe8d7},  {0x97a4,0xe8d8}, 
         {0x97a5,0xe8d9},  {0x97a6,0xe8da},  {0x97a7,0xe8db},  {0x97a8,0xe8dc}, 
         {0x97a9,0xe8dd},  {0x97aa,0xe8de},  {0x97ab,0xe8df},  {0x97ac,0xe8e0}, 
         {0x97ad,0xe8e1},  {0x97ae,0xe8e2},  {0x97af,0xe8e3},  {0x97b0,0xe8e4}, 
         {0x97b1,0xe8e5},  {0x97b2,0xe8e6},  {0x97b3,0xe8e7},  {0x97b4,0xe8e8}, 
         {0x97b5,0xe8e9},  {0x97b6,0xe8ea},  {0x97b7,0xe8eb},  {0x97b8,0xe8ec}, 
         {0x97b9,0xe8ed},  {0x97ba,0xe8ee},  {0x97bb,0xe8ef},  {0x97bc,0xe8f0}, 
         {0x97bd,0xe8f1},  {0x97be,0xe8f2},  {0x97bf,0xe8f3},  {0x97c0,0xe8f4}, 
         {0x97c1,0xe8f5},  {0x97c2,0xe8f6},  {0x97c3,0xe8f7},  {0x97c4,0xe8f8}, 
         {0x97c5,0xe8f9},  {0x97c6,0xe8fa},  {0x97c7,0xe8fb},  {0x97c8,0xe8fc}, 
         {0x97c9,0xe8fd},  {0x97ca,0xe8fe},  {0x97cb,0xe8ff},  {0x97cc,0xe900}, 
         {0x97cd,0xe901},  {0x97ce,0xe902},  {0x97cf,0xe903},  {0x97d0,0xe904}, 
         {0x97d1,0xe905},  {0x97d2,0xe906},  {0x97d3,0xe907},  {0x97d4,0xe908}, 
         {0x97d5,0xe909},  {0x97d6,0xe90a},  {0x97d7,0xe90b},  {0x97d8,0xe90c}, 
         {0x97d9,0xe90d},  {0x97da,0xe90e},  {0x97db,0xe90f},  {0x97dc,0xe910}, 
         {0x97dd,0xe911},  {0x97de,0xe912},  {0x97df,0xe913},  {0x97e0,0xe914}, 
         {0x97e1,0xe915},  {0x97e2,0xe916},  {0x97e3,0xe917},  {0x97e4,0xe918}, 
         {0x97e5,0xe919},  {0x97e6,0xe91a},  {0x97e7,0xe91b},  {0x97e8,0xe91c}, 
         {0x97e9,0xe91d},  {0x97ea,0xe91e},  {0x97eb,0xe91f},  {0x97ec,0xe920}, 
         {0x97ed,0xe921},  {0x97ee,0xe922},  {0x97ef,0xe923},  {0x97f0,0xe924}, 
         {0x97f1,0xe925},  {0x97f2,0xe926},  {0x97f3,0xe927},  {0x97f4,0xe928}, 
         {0x97f5,0xe929},  {0x97f6,0xe92a},  {0x97f7,0xe92b},  {0x97f8,0xe92c}, 
         {0x97f9,0xe92d},  {0x97fa,0xe92e},  {0x97fb,0xe92f},  {0x97fc,0xe930}, 
         {0x97fd,0xe931},  {0x97fe,0xe932},  {0x9840,0xe933},  {0x9841,0xe934}, 
         {0x9842,0xe935},  {0x9843,0xe936},  {0x9844,0xe937},  {0x9845,0xe938}, 
         {0x9846,0xe939},  {0x9847,0xe93a},  {0x9848,0xe93b},  {0x9849,0xe93c}, 
         {0x984a,0xe93d},  {0x984b,0xe93e},  {0x984c,0xe93f},  {0x984d,0xe940}, 
         {0x984e,0xe941},  {0x984f,0xe942},  {0x9850,0xe943},  {0x9851,0xe944}, 
         {0x9852,0xe945},  {0x9853,0xe946},  {0x9854,0xe947},  {0x9855,0xe948}, 
         {0x9856,0xe949},  {0x9857,0xe94a},  {0x9858,0xe94b},  {0x9859,0xe94c}, 
         {0x985a,0xe94d},  {0x985b,0xe94e},  {0x985c,0xe94f},  {0x985d,0xe950}, 
         {0x985e,0xe951},  {0x985f,0xe952},  {0x9860,0xe953},  {0x9861,0xe954}, 
         {0x9862,0xe955},  {0x9863,0xe956},  {0x9864,0xe957},  {0x9865,0xe958}, 
         {0x9866,0xe959},  {0x9867,0xe95a},  {0x9868,0xe95b},  {0x9869,0xe95c}, 
         {0x986a,0xe95d},  {0x986b,0xe95e},  {0x986c,0xe95f},  {0x986d,0xe960}, 
         {0x986e,0xe961},  {0x986f,0xe962},  {0x9870,0xe963},  {0x9871,0xe964}, 
         {0x9872,0xe965},  {0x9873,0xe966},  {0x9874,0xe967},  {0x9875,0xe968}, 
         {0x9876,0xe969},  {0x9877,0xe96a},  {0x9878,0xe96b},  {0x9879,0xe96c}, 
         {0x987a,0xe96d},  {0x987b,0xe96e},  {0x987c,0xe96f},  {0x987d,0xe970}, 
         {0x987e,0xe971},  {0x98a1,0xe972},  {0x98a2,0xe973},  {0x98a3,0xe974}, 
         {0x98a4,0xe975},  {0x98a5,0xe976},  {0x98a6,0xe977},  {0x98a7,0xe978}, 
         {0x98a8,0xe979},  {0x98a9,0xe97a},  {0x98aa,0xe97b},  {0x98ab,0xe97c}, 
         {0x98ac,0xe97d},  {0x98ad,0xe97e},  {0x98ae,0xe97f},  {0x98af,0xe980}, 
         {0x98b0,0xe981},  {0x98b1,0xe982},  {0x98b2,0xe983},  {0x98b3,0xe984}, 
         {0x98b4,0xe985},  {0x98b5,0xe986},  {0x98b6,0xe987},  {0x98b7,0xe988}, 
         {0x98b8,0xe989},  {0x98b9,0xe98a},  {0x98ba,0xe98b},  {0x98bb,0xe98c}, 
         {0x98bc,0xe98d},  {0x98bd,0xe98e},  {0x98be,0xe98f},  {0x98bf,0xe990}, 
         {0x98c0,0xe991},  {0x98c1,0xe992},  {0x98c2,0xe993},  {0x98c3,0xe994}, 
         {0x98c4,0xe995},  {0x98c5,0xe996},  {0x98c6,0xe997},  {0x98c7,0xe998}, 
         {0x98c8,0xe999},  {0x98c9,0xe99a},  {0x98ca,0xe99b},  {0x98cb,0xe99c}, 
         {0x98cc,0xe99d},  {0x98cd,0xe99e},  {0x98ce,0xe99f},  {0x98cf,0xe9a0}, 
         {0x98d0,0xe9a1},  {0x98d1,0xe9a2},  {0x98d2,0xe9a3},  {0x98d3,0xe9a4}, 
         {0x98d4,0xe9a5},  {0x98d5,0xe9a6},  {0x98d6,0xe9a7},  {0x98d7,0xe9a8}, 
         {0x98d8,0xe9a9},  {0x98d9,0xe9aa},  {0x98da,0xe9ab},  {0x98db,0xe9ac}, 
         {0x98dc,0xe9ad},  {0x98dd,0xe9ae},  {0x98de,0xe9af},  {0x98df,0xe9b0}, 
         {0x98e0,0xe9b1},  {0x98e1,0xe9b2},  {0x98e2,0xe9b3},  {0x98e3,0xe9b4}, 
         {0x98e4,0xe9b5},  {0x98e5,0xe9b6},  {0x98e6,0xe9b7},  {0x98e7,0xe9b8}, 
         {0x98e8,0xe9b9},  {0x98e9,0xe9ba},  {0x98ea,0xe9bb},  {0x98eb,0xe9bc}, 
         {0x98ec,0xe9bd},  {0x98ed,0xe9be},  {0x98ee,0xe9bf},  {0x98ef,0xe9c0}, 
         {0x98f0,0xe9c1},  {0x98f1,0xe9c2},  {0x98f2,0xe9c3},  {0x98f3,0xe9c4}, 
         {0x98f4,0xe9c5},  {0x98f5,0xe9c6},  {0x98f6,0xe9c7},  {0x98f7,0xe9c8}, 
         {0x98f8,0xe9c9},  {0x98f9,0xe9ca},  {0x98fa,0xe9cb},  {0x98fb,0xe9cc}, 
         {0x98fc,0xe9cd},  {0x98fd,0xe9ce},  {0x98fe,0xe9cf},  {0x9940,0xe9d0}, 
         {0x9941,0xe9d1},  {0x9942,0xe9d2},  {0x9943,0xe9d3},  {0x9944,0xe9d4}, 
         {0x9945,0xe9d5},  {0x9946,0xe9d6},  {0x9947,0xe9d7},  {0x9948,0xe9d8}, 
         {0x9949,0xe9d9},  {0x994a,0xe9da},  {0x994b,0xe9db},  {0x994c,0xe9dc}, 
         {0x994d,0xe9dd},  {0x994e,0xe9de},  {0x994f,0xe9df},  {0x9950,0xe9e0}, 
         {0x9951,0xe9e1},  {0x9952,0xe9e2},  {0x9953,0xe9e3},  {0x9954,0xe9e4}, 
         {0x9955,0xe9e5},  {0x9956,0xe9e6},  {0x9957,0xe9e7},  {0x9958,0xe9e8}, 
         {0x9959,0xe9e9},  {0x995a,0xe9ea},  {0x995b,0xe9eb},  {0x995c,0xe9ec}, 
         {0x995d,0xe9ed},  {0x995e,0xe9ee},  {0x995f,0xe9ef},  {0x9960,0xe9f0}, 
         {0x9961,0xe9f1},  {0x9962,0xe9f2},  {0x9963,0xe9f3},  {0x9964,0xe9f4}, 
         {0x9965,0xe9f5},  {0x9966,0xe9f6},  {0x9967,0xe9f7},  {0x9968,0xe9f8}, 
         {0x9969,0xe9f9},  {0x996a,0xe9fa},  {0x996b,0xe9fb},  {0x996c,0xe9fc}, 
         {0x996d,0xe9fd},  {0x996e,0xe9fe},  {0x996f,0xe9ff},  {0x9970,0xea00}, 
         {0x9971,0xea01},  {0x9972,0xea02},  {0x9973,0xea03},  {0x9974,0xea04}, 
         {0x9975,0xea05},  {0x9976,0xea06},  {0x9977,0xea07},  {0x9978,0xea08}, 
         {0x9979,0xea09},  {0x997a,0xea0a},  {0x997b,0xea0b},  {0x997c,0xea0c}, 
         {0x997d,0xea0d},  {0x997e,0xea0e},  {0x99a1,0xea0f},  {0x99a2,0xea10}, 
         {0x99a3,0xea11},  {0x99a4,0xea12},  {0x99a5,0xea13},  {0x99a6,0xea14}, 
         {0x99a7,0xea15},  {0x99a8,0xea16},  {0x99a9,0xea17},  {0x99aa,0xea18}, 
         {0x99ab,0xea19},  {0x99ac,0xea1a},  {0x99ad,0xea1b},  {0x99ae,0xea1c}, 
         {0x99af,0xea1d},  {0x99b0,0xea1e},  {0x99b1,0xea1f},  {0x99b2,0xea20}, 
         {0x99b3,0xea21},  {0x99b4,0xea22},  {0x99b5,0xea23},  {0x99b6,0xea24}, 
         {0x99b7,0xea25},  {0x99b8,0xea26},  {0x99b9,0xea27},  {0x99ba,0xea28}, 
         {0x99bb,0xea29},  {0x99bc,0xea2a},  {0x99bd,0xea2b},  {0x99be,0xea2c}, 
         {0x99bf,0xea2d},  {0x99c0,0xea2e},  {0x99c1,0xea2f},  {0x99c2,0xea30}, 
         {0x99c3,0xea31},  {0x99c4,0xea32},  {0x99c5,0xea33},  {0x99c6,0xea34}, 
         {0x99c7,0xea35},  {0x99c8,0xea36},  {0x99c9,0xea37},  {0x99ca,0xea38}, 
         {0x99cb,0xea39},  {0x99cc,0xea3a},  {0x99cd,0xea3b},  {0x99ce,0xea3c}, 
         {0x99cf,0xea3d},  {0x99d0,0xea3e},  {0x99d1,0xea3f},  {0x99d2,0xea40}, 
         {0x99d3,0xea41},  {0x99d4,0xea42},  {0x99d5,0xea43},  {0x99d6,0xea44}, 
         {0x99d7,0xea45},  {0x99d8,0xea46},  {0x99d9,0xea47},  {0x99da,0xea48}, 
         {0x99db,0xea49},  {0x99dc,0xea4a},  {0x99dd,0xea4b},  {0x99de,0xea4c}, 
         {0x99df,0xea4d},  {0x99e0,0xea4e},  {0x99e1,0xea4f},  {0x99e2,0xea50}, 
         {0x99e3,0xea51},  {0x99e4,0xea52},  {0x99e5,0xea53},  {0x99e6,0xea54}, 
         {0x99e7,0xea55},  {0x99e8,0xea56},  {0x99e9,0xea57},  {0x99ea,0xea58}, 
         {0x99eb,0xea59},  {0x99ec,0xea5a},  {0x99ed,0xea5b},  {0x99ee,0xea5c}, 
         {0x99ef,0xea5d},  {0x99f0,0xea5e},  {0x99f1,0xea5f},  {0x99f2,0xea60}, 
         {0x99f3,0xea61},  {0x99f4,0xea62},  {0x99f5,0xea63},  {0x99f6,0xea64}, 
         {0x99f7,0xea65},  {0x99f8,0xea66},  {0x99f9,0xea67},  {0x99fa,0xea68}, 
         {0x99fb,0xea69},  {0x99fc,0xea6a},  {0x99fd,0xea6b},  {0x99fe,0xea6c}, 
         {0x9a40,0xea6d},  {0x9a41,0xea6e},  {0x9a42,0xea6f},  {0x9a43,0xea70}, 
         {0x9a44,0xea71},  {0x9a45,0xea72},  {0x9a46,0xea73},  {0x9a47,0xea74}, 
         {0x9a48,0xea75},  {0x9a49,0xea76},  {0x9a4a,0xea77},  {0x9a4b,0xea78}, 
         {0x9a4c,0xea79},  {0x9a4d,0xea7a},  {0x9a4e,0xea7b},  {0x9a4f,0xea7c}, 
         {0x9a50,0xea7d},  {0x9a51,0xea7e},  {0x9a52,0xea7f},  {0x9a53,0xea80}, 
         {0x9a54,0xea81},  {0x9a55,0xea82},  {0x9a56,0xea83},  {0x9a57,0xea84}, 
         {0x9a58,0xea85},  {0x9a59,0xea86},  {0x9a5a,0xea87},  {0x9a5b,0xea88}, 
         {0x9a5c,0xea89},  {0x9a5d,0xea8a},  {0x9a5e,0xea8b},  {0x9a5f,0xea8c}, 
         {0x9a60,0xea8d},  {0x9a61,0xea8e},  {0x9a62,0xea8f},  {0x9a63,0xea90}, 
         {0x9a64,0xea91},  {0x9a65,0xea92},  {0x9a66,0xea93},  {0x9a67,0xea94}, 
         {0x9a68,0xea95},  {0x9a69,0xea96},  {0x9a6a,0xea97},  {0x9a6b,0xea98}, 
         {0x9a6c,0xea99},  {0x9a6d,0xea9a},  {0x9a6e,0xea9b},  {0x9a6f,0xea9c}, 
         {0x9a70,0xea9d},  {0x9a71,0xea9e},  {0x9a72,0xea9f},  {0x9a73,0xeaa0}, 
         {0x9a74,0xeaa1},  {0x9a75,0xeaa2},  {0x9a76,0xeaa3},  {0x9a77,0xeaa4}, 
         {0x9a78,0xeaa5},  {0x9a79,0xeaa6},  {0x9a7a,0xeaa7},  {0x9a7b,0xeaa8}, 
         {0x9a7c,0xeaa9},  {0x9a7d,0xeaaa},  {0x9a7e,0xeaab},  {0x9aa1,0xeaac}, 
         {0x9aa2,0xeaad},  {0x9aa3,0xeaae},  {0x9aa4,0xeaaf},  {0x9aa5,0xeab0}, 
         {0x9aa6,0xeab1},  {0x9aa7,0xeab2},  {0x9aa8,0xeab3},  {0x9aa9,0xeab4}, 
         {0x9aaa,0xeab5},  {0x9aab,0xeab6},  {0x9aac,0xeab7},  {0x9aad,0xeab8}, 
         {0x9aae,0xeab9},  {0x9aaf,0xeaba},  {0x9ab0,0xeabb},  {0x9ab1,0xeabc}, 
         {0x9ab2,0xeabd},  {0x9ab3,0xeabe},  {0x9ab4,0xeabf},  {0x9ab5,0xeac0}, 
         {0x9ab6,0xeac1},  {0x9ab7,0xeac2},  {0x9ab8,0xeac3},  {0x9ab9,0xeac4}, 
         {0x9aba,0xeac5},  {0x9abb,0xeac6},  {0x9abc,0xeac7},  {0x9abd,0xeac8}, 
         {0x9abe,0xeac9},  {0x9abf,0xeaca},  {0x9ac0,0xeacb},  {0x9ac1,0xeacc}, 
         {0x9ac2,0xeacd},  {0x9ac3,0xeace},  {0x9ac4,0xeacf},  {0x9ac5,0xead0}, 
         {0x9ac6,0xead1},  {0x9ac7,0xead2},  {0x9ac8,0xead3},  {0x9ac9,0xead4}, 
         {0x9aca,0xead5},  {0x9acb,0xead6},  {0x9acc,0xead7},  {0x9acd,0xead8}, 
         {0x9ace,0xead9},  {0x9acf,0xeada},  {0x9ad0,0xeadb},  {0x9ad1,0xeadc}, 
         {0x9ad2,0xeadd},  {0x9ad3,0xeade},  {0x9ad4,0xeadf},  {0x9ad5,0xeae0}, 
         {0x9ad6,0xeae1},  {0x9ad7,0xeae2},  {0x9ad8,0xeae3},  {0x9ad9,0xeae4}, 
         {0x9ada,0xeae5},  {0x9adb,0xeae6},  {0x9adc,0xeae7},  {0x9add,0xeae8}, 
         {0x9ade,0xeae9},  {0x9adf,0xeaea},  {0x9ae0,0xeaeb},  {0x9ae1,0xeaec}, 
         {0x9ae2,0xeaed},  {0x9ae3,0xeaee},  {0x9ae4,0xeaef},  {0x9ae5,0xeaf0}, 
         {0x9ae6,0xeaf1},  {0x9ae7,0xeaf2},  {0x9ae8,0xeaf3},  {0x9ae9,0xeaf4}, 
         {0x9aea,0xeaf5},  {0x9aeb,0xeaf6},  {0x9aec,0xeaf7},  {0x9aed,0xeaf8}, 
         {0x9aee,0xeaf9},  {0x9aef,0xeafa},  {0x9af0,0xeafb},  {0x9af1,0xeafc}, 
         {0x9af2,0xeafd},  {0x9af3,0xeafe},  {0x9af4,0xeaff},  {0x9af5,0xeb00}, 
         {0x9af6,0xeb01},  {0x9af7,0xeb02},  {0x9af8,0xeb03},  {0x9af9,0xeb04}, 
         {0x9afa,0xeb05},  {0x9afb,0xeb06},  {0x9afc,0xeb07},  {0x9afd,0xeb08}, 
         {0x9afe,0xeb09},  {0x9b40,0xeb0a},  {0x9b41,0xeb0b},  {0x9b42,0xeb0c}, 
         {0x9b43,0xeb0d},  {0x9b44,0xeb0e},  {0x9b45,0xeb0f},  {0x9b46,0xeb10}, 
         {0x9b47,0xeb11},  {0x9b48,0xeb12},  {0x9b49,0xeb13},  {0x9b4a,0xeb14}, 
         {0x9b4b,0xeb15},  {0x9b4c,0xeb16},  {0x9b4d,0xeb17},  {0x9b4e,0xeb18}, 
         {0x9b4f,0xeb19},  {0x9b50,0xeb1a},  {0x9b51,0xeb1b},  {0x9b52,0xeb1c}, 
         {0x9b53,0xeb1d},  {0x9b54,0xeb1e},  {0x9b55,0xeb1f},  {0x9b56,0xeb20}, 
         {0x9b57,0xeb21},  {0x9b58,0xeb22},  {0x9b59,0xeb23},  {0x9b5a,0xeb24}, 
         {0x9b5b,0xeb25},  {0x9b5c,0xeb26},  {0x9b5d,0xeb27},  {0x9b5e,0xeb28}, 
         {0x9b5f,0xeb29},  {0x9b60,0xeb2a},  {0x9b61,0xeb2b},  {0x9b62,0xeb2c}, 
         {0x9b63,0xeb2d},  {0x9b64,0xeb2e},  {0x9b65,0xeb2f},  {0x9b66,0xeb30}, 
         {0x9b67,0xeb31},  {0x9b68,0xeb32},  {0x9b69,0xeb33},  {0x9b6a,0xeb34}, 
         {0x9b6b,0xeb35},  {0x9b6c,0xeb36},  {0x9b6d,0xeb37},  {0x9b6e,0xeb38}, 
         {0x9b6f,0xeb39},  {0x9b70,0xeb3a},  {0x9b71,0xeb3b},  {0x9b72,0xeb3c}, 
         {0x9b73,0xeb3d},  {0x9b74,0xeb3e},  {0x9b75,0xeb3f},  {0x9b76,0xeb40}, 
         {0x9b77,0xeb41},  {0x9b78,0xeb42},  {0x9b79,0xeb43},  {0x9b7a,0xeb44}, 
         {0x9b7b,0xeb45},  {0x9b7c,0xeb46},  {0x9b7d,0xeb47},  {0x9b7e,0xeb48}, 
         {0x9ba1,0xeb49},  {0x9ba2,0xeb4a},  {0x9ba3,0xeb4b},  {0x9ba4,0xeb4c}, 
         {0x9ba5,0xeb4d},  {0x9ba6,0xeb4e},  {0x9ba7,0xeb4f},  {0x9ba8,0xeb50}, 
         {0x9ba9,0xeb51},  {0x9baa,0xeb52},  {0x9bab,0xeb53},  {0x9bac,0xeb54}, 
         {0x9bad,0xeb55},  {0x9bae,0xeb56},  {0x9baf,0xeb57},  {0x9bb0,0xeb58}, 
         {0x9bb1,0xeb59},  {0x9bb2,0xeb5a},  {0x9bb3,0xeb5b},  {0x9bb4,0xeb5c}, 
         {0x9bb5,0xeb5d},  {0x9bb6,0xeb5e},  {0x9bb7,0xeb5f},  {0x9bb8,0xeb60}, 
         {0x9bb9,0xeb61},  {0x9bba,0xeb62},  {0x9bbb,0xeb63},  {0x9bbc,0xeb64}, 
         {0x9bbd,0xeb65},  {0x9bbe,0xeb66},  {0x9bbf,0xeb67},  {0x9bc0,0xeb68}, 
         {0x9bc1,0xeb69},  {0x9bc2,0xeb6a},  {0x9bc3,0xeb6b},  {0x9bc4,0xeb6c}, 
         {0x9bc5,0xeb6d},  {0x9bc6,0xeb6e},  {0x9bc7,0xeb6f},  {0x9bc8,0xeb70}, 
         {0x9bc9,0xeb71},  {0x9bca,0xeb72},  {0x9bcb,0xeb73},  {0x9bcc,0xeb74}, 
         {0x9bcd,0xeb75},  {0x9bce,0xeb76},  {0x9bcf,0xeb77},  {0x9bd0,0xeb78}, 
         {0x9bd1,0xeb79},  {0x9bd2,0xeb7a},  {0x9bd3,0xeb7b},  {0x9bd4,0xeb7c}, 
         {0x9bd5,0xeb7d},  {0x9bd6,0xeb7e},  {0x9bd7,0xeb7f},  {0x9bd8,0xeb80}, 
         {0x9bd9,0xeb81},  {0x9bda,0xeb82},  {0x9bdb,0xeb83},  {0x9bdc,0xeb84}, 
         {0x9bdd,0xeb85},  {0x9bde,0xeb86},  {0x9bdf,0xeb87},  {0x9be0,0xeb88}, 
         {0x9be1,0xeb89},  {0x9be2,0xeb8a},  {0x9be3,0xeb8b},  {0x9be4,0xeb8c}, 
         {0x9be5,0xeb8d},  {0x9be6,0xeb8e},  {0x9be7,0xeb8f},  {0x9be8,0xeb90}, 
         {0x9be9,0xeb91},  {0x9bea,0xeb92},  {0x9beb,0xeb93},  {0x9bec,0xeb94}, 
         {0x9bed,0xeb95},  {0x9bee,0xeb96},  {0x9bef,0xeb97},  {0x9bf0,0xeb98}, 
         {0x9bf1,0xeb99},  {0x9bf2,0xeb9a},  {0x9bf3,0xeb9b},  {0x9bf4,0xeb9c}, 
         {0x9bf5,0xeb9d},  {0x9bf6,0xeb9e},  {0x9bf7,0xeb9f},  {0x9bf8,0xeba0}, 
         {0x9bf9,0xeba1},  {0x9bfa,0xeba2},  {0x9bfb,0xeba3},  {0x9bfc,0xeba4}, 
         {0x9bfd,0xeba5},  {0x9bfe,0xeba6},  {0x9c40,0xeba7},  {0x9c41,0xeba8}, 
         {0x9c42,0xeba9},  {0x9c43,0xebaa},  {0x9c44,0xebab},  {0x9c45,0xebac}, 
         {0x9c46,0xebad},  {0x9c47,0xebae},  {0x9c48,0xebaf},  {0x9c49,0xebb0}, 
         {0x9c4a,0xebb1},  {0x9c4b,0xebb2},  {0x9c4c,0xebb3},  {0x9c4d,0xebb4}, 
         {0x9c4e,0xebb5},  {0x9c4f,0xebb6},  {0x9c50,0xebb7},  {0x9c51,0xebb8}, 
         {0x9c52,0xebb9},  {0x9c53,0xebba},  {0x9c54,0xebbb},  {0x9c55,0xebbc}, 
         {0x9c56,0xebbd},  {0x9c57,0xebbe},  {0x9c58,0xebbf},  {0x9c59,0xebc0}, 
         {0x9c5a,0xebc1},  {0x9c5b,0xebc2},  {0x9c5c,0xebc3},  {0x9c5d,0xebc4}, 
         {0x9c5e,0xebc5},  {0x9c5f,0xebc6},  {0x9c60,0xebc7},  {0x9c61,0xebc8}, 
         {0x9c62,0xebc9},  {0x9c63,0xebca},  {0x9c64,0xebcb},  {0x9c65,0xebcc}, 
         {0x9c66,0xebcd},  {0x9c67,0xebce},  {0x9c68,0xebcf},  {0x9c69,0xebd0}, 
         {0x9c6a,0xebd1},  {0x9c6b,0xebd2},  {0x9c6c,0xebd3},  {0x9c6d,0xebd4}, 
         {0x9c6e,0xebd5},  {0x9c6f,0xebd6},  {0x9c70,0xebd7},  {0x9c71,0xebd8}, 
         {0x9c72,0xebd9},  {0x9c73,0xebda},  {0x9c74,0xebdb},  {0x9c75,0xebdc}, 
         {0x9c76,0xebdd},  {0x9c77,0xebde},  {0x9c78,0xebdf},  {0x9c79,0xebe0}, 
         {0x9c7a,0xebe1},  {0x9c7b,0xebe2},  {0x9c7c,0xebe3},  {0x9c7d,0xebe4}, 
         {0x9c7e,0xebe5},  {0x9ca1,0xebe6},  {0x9ca2,0xebe7},  {0x9ca3,0xebe8}, 
         {0x9ca4,0xebe9},  {0x9ca5,0xebea},  {0x9ca6,0xebeb},  {0x9ca7,0xebec}, 
         {0x9ca8,0xebed},  {0x9ca9,0xebee},  {0x9caa,0xebef},  {0x9cab,0xebf0}, 
         {0x9cac,0xebf1},  {0x9cad,0xebf2},  {0x9cae,0xebf3},  {0x9caf,0xebf4}, 
         {0x9cb0,0xebf5},  {0x9cb1,0xebf6},  {0x9cb2,0xebf7},  {0x9cb3,0xebf8}, 
         {0x9cb4,0xebf9},  {0x9cb5,0xebfa},  {0x9cb6,0xebfb},  {0x9cb7,0xebfc}, 
         {0x9cb8,0xebfd},  {0x9cb9,0xebfe},  {0x9cba,0xebff},  {0x9cbb,0xec00}, 
         {0x9cbc,0xec01},  {0x9cbd,0xec02},  {0x9cbe,0xec03},  {0x9cbf,0xec04}, 
         {0x9cc0,0xec05},  {0x9cc1,0xec06},  {0x9cc2,0xec07},  {0x9cc3,0xec08}, 
         {0x9cc4,0xec09},  {0x9cc5,0xec0a},  {0x9cc6,0xec0b},  {0x9cc7,0xec0c}, 
         {0x9cc8,0xec0d},  {0x9cc9,0xec0e},  {0x9cca,0xec0f},  {0x9ccb,0xec10}, 
         {0x9ccc,0xec11},  {0x9ccd,0xec12},  {0x9cce,0xec13},  {0x9ccf,0xec14}, 
         {0x9cd0,0xec15},  {0x9cd1,0xec16},  {0x9cd2,0xec17},  {0x9cd3,0xec18}, 
         {0x9cd4,0xec19},  {0x9cd5,0xec1a},  {0x9cd6,0xec1b},  {0x9cd7,0xec1c}, 
         {0x9cd8,0xec1d},  {0x9cd9,0xec1e},  {0x9cda,0xec1f},  {0x9cdb,0xec20}, 
         {0x9cdc,0xec21},  {0x9cdd,0xec22},  {0x9cde,0xec23},  {0x9cdf,0xec24}, 
         {0x9ce0,0xec25},  {0x9ce1,0xec26},  {0x9ce2,0xec27},  {0x9ce3,0xec28}, 
         {0x9ce4,0xec29},  {0x9ce5,0xec2a},  {0x9ce6,0xec2b},  {0x9ce7,0xec2c}, 
         {0x9ce8,0xec2d},  {0x9ce9,0xec2e},  {0x9cea,0xec2f},  {0x9ceb,0xec30}, 
         {0x9cec,0xec31},  {0x9ced,0xec32},  {0x9cee,0xec33},  {0x9cef,0xec34}, 
         {0x9cf0,0xec35},  {0x9cf1,0xec36},  {0x9cf2,0xec37},  {0x9cf3,0xec38}, 
         {0x9cf4,0xec39},  {0x9cf5,0xec3a},  {0x9cf6,0xec3b},  {0x9cf7,0xec3c}, 
         {0x9cf8,0xec3d},  {0x9cf9,0xec3e},  {0x9cfa,0xec3f},  {0x9cfb,0xec40}, 
         {0x9cfc,0xec41},  {0x9cfd,0xec42},  {0x9cfe,0xec43},  {0x9d40,0xec44}, 
         {0x9d41,0xec45},  {0x9d42,0xec46},  {0x9d43,0xec47},  {0x9d44,0xec48}, 
         {0x9d45,0xec49},  {0x9d46,0xec4a},  {0x9d47,0xec4b},  {0x9d48,0xec4c}, 
         {0x9d49,0xec4d},  {0x9d4a,0xec4e},  {0x9d4b,0xec4f},  {0x9d4c,0xec50}, 
         {0x9d4d,0xec51},  {0x9d4e,0xec52},  {0x9d4f,0xec53},  {0x9d50,0xec54}, 
         {0x9d51,0xec55},  {0x9d52,0xec56},  {0x9d53,0xec57},  {0x9d54,0xec58}, 
         {0x9d55,0xec59},  {0x9d56,0xec5a},  {0x9d57,0xec5b},  {0x9d58,0xec5c}, 
         {0x9d59,0xec5d},  {0x9d5a,0xec5e},  {0x9d5b,0xec5f},  {0x9d5c,0xec60}, 
         {0x9d5d,0xec61},  {0x9d5e,0xec62},  {0x9d5f,0xec63},  {0x9d60,0xec64}, 
         {0x9d61,0xec65},  {0x9d62,0xec66},  {0x9d63,0xec67},  {0x9d64,0xec68}, 
         {0x9d65,0xec69},  {0x9d66,0xec6a},  {0x9d67,0xec6b},  {0x9d68,0xec6c}, 
         {0x9d69,0xec6d},  {0x9d6a,0xec6e},  {0x9d6b,0xec6f},  {0x9d6c,0xec70}, 
         {0x9d6d,0xec71},  {0x9d6e,0xec72},  {0x9d6f,0xec73},  {0x9d70,0xec74}, 
         {0x9d71,0xec75},  {0x9d72,0xec76},  {0x9d73,0xec77},  {0x9d74,0xec78}, 
         {0x9d75,0xec79},  {0x9d76,0xec7a},  {0x9d77,0xec7b},  {0x9d78,0xec7c}, 
         {0x9d79,0xec7d},  {0x9d7a,0xec7e},  {0x9d7b,0xec7f},  {0x9d7c,0xec80}, 
         {0x9d7d,0xec81},  {0x9d7e,0xec82},  {0x9da1,0xec83},  {0x9da2,0xec84}, 
         {0x9da3,0xec85},  {0x9da4,0xec86},  {0x9da5,0xec87},  {0x9da6,0xec88}, 
         {0x9da7,0xec89},  {0x9da8,0xec8a},  {0x9da9,0xec8b},  {0x9daa,0xec8c}, 
         {0x9dab,0xec8d},  {0x9dac,0xec8e},  {0x9dad,0xec8f},  {0x9dae,0xec90}, 
         {0x9daf,0xec91},  {0x9db0,0xec92},  {0x9db1,0xec93},  {0x9db2,0xec94}, 
         {0x9db3,0xec95},  {0x9db4,0xec96},  {0x9db5,0xec97},  {0x9db6,0xec98}, 
         {0x9db7,0xec99},  {0x9db8,0xec9a},  {0x9db9,0xec9b},  {0x9dba,0xec9c}, 
         {0x9dbb,0xec9d},  {0x9dbc,0xec9e},  {0x9dbd,0xec9f},  {0x9dbe,0xeca0}, 
         {0x9dbf,0xeca1},  {0x9dc0,0xeca2},  {0x9dc1,0xeca3},  {0x9dc2,0xeca4}, 
         {0x9dc3,0xeca5},  {0x9dc4,0xeca6},  {0x9dc5,0xeca7},  {0x9dc6,0xeca8}, 
         {0x9dc7,0xeca9},  {0x9dc8,0xecaa},  {0x9dc9,0xecab},  {0x9dca,0xecac}, 
         {0x9dcb,0xecad},  {0x9dcc,0xecae},  {0x9dcd,0xecaf},  {0x9dce,0xecb0}, 
         {0x9dcf,0xecb1},  {0x9dd0,0xecb2},  {0x9dd1,0xecb3},  {0x9dd2,0xecb4}, 
         {0x9dd3,0xecb5},  {0x9dd4,0xecb6},  {0x9dd5,0xecb7},  {0x9dd6,0xecb8}, 
         {0x9dd7,0xecb9},  {0x9dd8,0xecba},  {0x9dd9,0xecbb},  {0x9dda,0xecbc}, 
         {0x9ddb,0xecbd},  {0x9ddc,0xecbe},  {0x9ddd,0xecbf},  {0x9dde,0xecc0}, 
         {0x9ddf,0xecc1},  {0x9de0,0xecc2},  {0x9de1,0xecc3},  {0x9de2,0xecc4}, 
         {0x9de3,0xecc5},  {0x9de4,0xecc6},  {0x9de5,0xecc7},  {0x9de6,0xecc8}, 
         {0x9de7,0xecc9},  {0x9de8,0xecca},  {0x9de9,0xeccb},  {0x9dea,0xeccc}, 
         {0x9deb,0xeccd},  {0x9dec,0xecce},  {0x9ded,0xeccf},  {0x9dee,0xecd0}, 
         {0x9def,0xecd1},  {0x9df0,0xecd2},  {0x9df1,0xecd3},  {0x9df2,0xecd4}, 
         {0x9df3,0xecd5},  {0x9df4,0xecd6},  {0x9df5,0xecd7},  {0x9df6,0xecd8}, 
         {0x9df7,0xecd9},  {0x9df8,0xecda},  {0x9df9,0xecdb},  {0x9dfa,0xecdc}, 
         {0x9dfb,0xecdd},  {0x9dfc,0xecde},  {0x9dfd,0xecdf},  {0x9dfe,0xece0}, 
         {0x9e40,0xece1},  {0x9e41,0xece2},  {0x9e42,0xece3},  {0x9e43,0xece4}, 
         {0x9e44,0xece5},  {0x9e45,0xece6},  {0x9e46,0xece7},  {0x9e47,0xece8}, 
         {0x9e48,0xece9},  {0x9e49,0xecea},  {0x9e4a,0xeceb},  {0x9e4b,0xecec}, 
         {0x9e4c,0xeced},  {0x9e4d,0xecee},  {0x9e4e,0xecef},  {0x9e4f,0xecf0}, 
         {0x9e50,0xecf1},  {0x9e51,0xecf2},  {0x9e52,0xecf3},  {0x9e53,0xecf4}, 
         {0x9e54,0xecf5},  {0x9e55,0xecf6},  {0x9e56,0xecf7},  {0x9e57,0xecf8}, 
         {0x9e58,0xecf9},  {0x9e59,0xecfa},  {0x9e5a,0xecfb},  {0x9e5b,0xecfc}, 
         {0x9e5c,0xecfd},  {0x9e5d,0xecfe},  {0x9e5e,0xecff},  {0x9e5f,0xed00}, 
         {0x9e60,0xed01},  {0x9e61,0xed02},  {0x9e62,0xed03},  {0x9e63,0xed04}, 
         {0x9e64,0xed05},  {0x9e65,0xed06},  {0x9e66,0xed07},  {0x9e67,0xed08}, 
         {0x9e68,0xed09},  {0x9e69,0xed0a},  {0x9e6a,0xed0b},  {0x9e6b,0xed0c}, 
         {0x9e6c,0xed0d},  {0x9e6d,0xed0e},  {0x9e6e,0xed0f},  {0x9e6f,0xed10}, 
         {0x9e70,0xed11},  {0x9e71,0xed12},  {0x9e72,0xed13},  {0x9e73,0xed14}, 
         {0x9e74,0xed15},  {0x9e75,0xed16},  {0x9e76,0xed17},  {0x9e77,0xed18}, 
         {0x9e78,0xed19},  {0x9e79,0xed1a},  {0x9e7a,0xed1b},  {0x9e7b,0xed1c}, 
         {0x9e7c,0xed1d},  {0x9e7d,0xed1e},  {0x9e7e,0xed1f},  {0x9ea1,0xed20}, 
         {0x9ea2,0xed21},  {0x9ea3,0xed22},  {0x9ea4,0xed23},  {0x9ea5,0xed24}, 
         {0x9ea6,0xed25},  {0x9ea7,0xed26},  {0x9ea8,0xed27},  {0x9ea9,0xed28}, 
         {0x9eaa,0xed29},  {0x9eab,0xed2a},  {0x9eac,0xed2b},  {0x9ead,0xed2c}, 
         {0x9eae,0xed2d},  {0x9eaf,0xed2e},  {0x9eb0,0xed2f},  {0x9eb1,0xed30}, 
         {0x9eb2,0xed31},  {0x9eb3,0xed32},  {0x9eb4,0xed33},  {0x9eb5,0xed34}, 
         {0x9eb6,0xed35},  {0x9eb7,0xed36},  {0x9eb8,0xed37},  {0x9eb9,0xed38}, 
         {0x9eba,0xed39},  {0x9ebb,0xed3a},  {0x9ebc,0xed3b},  {0x9ebd,0xed3c}, 
         {0x9ebe,0xed3d},  {0x9ebf,0xed3e},  {0x9ec0,0xed3f},  {0x9ec1,0xed40}, 
         {0x9ec2,0xed41},  {0x9ec3,0xed42},  {0x9ec4,0xed43},  {0x9ec5,0xed44}, 
         {0x9ec6,0xed45},  {0x9ec7,0xed46},  {0x9ec8,0xed47},  {0x9ec9,0xed48}, 
         {0x9eca,0xed49},  {0x9ecb,0xed4a},  {0x9ecc,0xed4b},  {0x9ecd,0xed4c}, 
         {0x9ece,0xed4d},  {0x9ecf,0xed4e},  {0x9ed0,0xed4f},  {0x9ed1,0xed50}, 
         {0x9ed2,0xed51},  {0x9ed3,0xed52},  {0x9ed4,0xed53},  {0x9ed5,0xed54}, 
         {0x9ed6,0xed55},  {0x9ed7,0xed56},  {0x9ed8,0xed57},  {0x9ed9,0xed58}, 
         {0x9eda,0xed59},  {0x9edb,0xed5a},  {0x9edc,0xed5b},  {0x9edd,0xed5c}, 
         {0x9ede,0xed5d},  {0x9edf,0xed5e},  {0x9ee0,0xed5f},  {0x9ee1,0xed60}, 
         {0x9ee2,0xed61},  {0x9ee3,0xed62},  {0x9ee4,0xed63},  {0x9ee5,0xed64}, 
         {0x9ee6,0xed65},  {0x9ee7,0xed66},  {0x9ee8,0xed67},  {0x9ee9,0xed68}, 
         {0x9eea,0xed69},  {0x9eeb,0xed6a},  {0x9eec,0xed6b},  {0x9eed,0xed6c}, 
         {0x9eee,0xed6d},  {0x9eef,0xed6e},  {0x9ef0,0xed6f},  {0x9ef1,0xed70}, 
         {0x9ef2,0xed71},  {0x9ef3,0xed72},  {0x9ef4,0xed73},  {0x9ef5,0xed74}, 
         {0x9ef6,0xed75},  {0x9ef7,0xed76},  {0x9ef8,0xed77},  {0x9ef9,0xed78}, 
         {0x9efa,0xed79},  {0x9efb,0xed7a},  {0x9efc,0xed7b},  {0x9efd,0xed7c}, 
         {0x9efe,0xed7d},  {0x9f40,0xed7e},  {0x9f41,0xed7f},  {0x9f42,0xed80}, 
         {0x9f43,0xed81},  {0x9f44,0xed82},  {0x9f45,0xed83},  {0x9f46,0xed84}, 
         {0x9f47,0xed85},  {0x9f48,0xed86},  {0x9f49,0xed87},  {0x9f4a,0xed88}, 
         {0x9f4b,0xed89},  {0x9f4c,0xed8a},  {0x9f4d,0xed8b},  {0x9f4e,0xed8c}, 
         {0x9f4f,0xed8d},  {0x9f50,0xed8e},  {0x9f51,0xed8f},  {0x9f52,0xed90}, 
         {0x9f53,0xed91},  {0x9f54,0xed92},  {0x9f55,0xed93},  {0x9f56,0xed94}, 
         {0x9f57,0xed95},  {0x9f58,0xed96},  {0x9f59,0xed97},  {0x9f5a,0xed98}, 
         {0x9f5b,0xed99},  {0x9f5c,0xed9a},  {0x9f5d,0xed9b},  {0x9f5e,0xed9c}, 
         {0x9f5f,0xed9d},  {0x9f60,0xed9e},  {0x9f61,0xed9f},  {0x9f62,0xeda0}, 
         {0x9f63,0xeda1},  {0x9f64,0xeda2},  {0x9f65,0xeda3},  {0x9f66,0xeda4}, 
         {0x9f67,0xeda5},  {0x9f68,0xeda6},  {0x9f69,0xeda7},  {0x9f6a,0xeda8}, 
         {0x9f6b,0xeda9},  {0x9f6c,0xedaa},  {0x9f6d,0xedab},  {0x9f6e,0xedac}, 
         {0x9f6f,0xedad},  {0x9f70,0xedae},  {0x9f71,0xedaf},  {0x9f72,0xedb0}, 
         {0x9f73,0xedb1},  {0x9f74,0xedb2},  {0x9f75,0xedb3},  {0x9f76,0xedb4}, 
         {0x9f77,0xedb5},  {0x9f78,0xedb6},  {0x9f79,0xedb7},  {0x9f7a,0xedb8}, 
         {0x9f7b,0xedb9},  {0x9f7c,0xedba},  {0x9f7d,0xedbb},  {0x9f7e,0xedbc}, 
         {0x9fa1,0xedbd},  {0x9fa2,0xedbe},  {0x9fa3,0xedbf},  {0x9fa4,0xedc0}, 
         {0x9fa5,0xedc1},  {0x9fa6,0xedc2},  {0x9fa7,0xedc3},  {0x9fa8,0xedc4}, 
         {0x9fa9,0xedc5},  {0x9faa,0xedc6},  {0x9fab,0xedc7},  {0x9fac,0xedc8}, 
         {0x9fad,0xedc9},  {0x9fae,0xedca},  {0x9faf,0xedcb},  {0x9fb0,0xedcc}, 
         {0x9fb1,0xedcd},  {0x9fb2,0xedce},  {0x9fb3,0xedcf},  {0x9fb4,0xedd0}, 
         {0x9fb5,0xedd1},  {0x9fb6,0xedd2},  {0x9fb7,0xedd3},  {0x9fb8,0xedd4}, 
         {0x9fb9,0xedd5},  {0x9fba,0xedd6},  {0x9fbb,0xedd7},  {0x9fbc,0xedd8}, 
         {0x9fbd,0xedd9},  {0x9fbe,0xedda},  {0x9fbf,0xeddb},  {0x9fc0,0xeddc}, 
         {0x9fc1,0xeddd},  {0x9fc2,0xedde},  {0x9fc3,0xeddf},  {0x9fc4,0xede0}, 
         {0x9fc5,0xede1},  {0x9fc6,0xede2},  {0x9fc7,0xede3},  {0x9fc8,0xede4}, 
         {0x9fc9,0xede5},  {0x9fca,0xede6},  {0x9fcb,0xede7},  {0x9fcc,0xede8}, 
         {0x9fcd,0xede9},  {0x9fce,0xedea},  {0x9fcf,0xedeb},  {0x9fd0,0xedec}, 
         {0x9fd1,0xeded},  {0x9fd2,0xedee},  {0x9fd3,0xedef},  {0x9fd4,0xedf0}, 
         {0x9fd5,0xedf1},  {0x9fd6,0xedf2},  {0x9fd7,0xedf3},  {0x9fd8,0xedf4}, 
         {0x9fd9,0xedf5},  {0x9fda,0xedf6},  {0x9fdb,0xedf7},  {0x9fdc,0xedf8}, 
         {0x9fdd,0xedf9},  {0x9fde,0xedfa},  {0x9fdf,0xedfb},  {0x9fe0,0xedfc}, 
         {0x9fe1,0xedfd},  {0x9fe2,0xedfe},  {0x9fe3,0xedff},  {0x9fe4,0xee00}, 
         {0x9fe5,0xee01},  {0x9fe6,0xee02},  {0x9fe7,0xee03},  {0x9fe8,0xee04}, 
         {0x9fe9,0xee05},  {0x9fea,0xee06},  {0x9feb,0xee07},  {0x9fec,0xee08}, 
         {0x9fed,0xee09},  {0x9fee,0xee0a},  {0x9fef,0xee0b},  {0x9ff0,0xee0c}, 
         {0x9ff1,0xee0d},  {0x9ff2,0xee0e},  {0x9ff3,0xee0f},  {0x9ff4,0xee10}, 
         {0x9ff5,0xee11},  {0x9ff6,0xee12},  {0x9ff7,0xee13},  {0x9ff8,0xee14}, 
         {0x9ff9,0xee15},  {0x9ffa,0xee16},  {0x9ffb,0xee17},  {0x9ffc,0xee18}, 
         {0x9ffd,0xee19},  {0x9ffe,0xee1a},  {0xa040,0xee1b},  {0xa041,0xee1c}, 
         {0xa042,0xee1d},  {0xa043,0xee1e},  {0xa044,0xee1f},  {0xa045,0xee20}, 
         {0xa046,0xee21},  {0xa047,0xee22},  {0xa048,0xee23},  {0xa049,0xee24}, 
         {0xa04a,0xee25},  {0xa04b,0xee26},  {0xa04c,0xee27},  {0xa04d,0xee28}, 
         {0xa04e,0xee29},  {0xa04f,0xee2a},  {0xa050,0xee2b},  {0xa051,0xee2c}, 
         {0xa052,0xee2d},  {0xa053,0xee2e},  {0xa054,0xee2f},  {0xa055,0xee30}, 
         {0xa056,0xee31},  {0xa057,0xee32},  {0xa058,0xee33},  {0xa059,0xee34}, 
         {0xa05a,0xee35},  {0xa05b,0xee36},  {0xa05c,0xee37},  {0xa05d,0xee38}, 
         {0xa05e,0xee39},  {0xa05f,0xee3a},  {0xa060,0xee3b},  {0xa061,0xee3c}, 
         {0xa062,0xee3d},  {0xa063,0xee3e},  {0xa064,0xee3f},  {0xa065,0xee40}, 
         {0xa066,0xee41},  {0xa067,0xee42},  {0xa068,0xee43},  {0xa069,0xee44}, 
         {0xa06a,0xee45},  {0xa06b,0xee46},  {0xa06c,0xee47},  {0xa06d,0xee48}, 
         {0xa06e,0xee49},  {0xa06f,0xee4a},  {0xa070,0xee4b},  {0xa071,0xee4c}, 
         {0xa072,0xee4d},  {0xa073,0xee4e},  {0xa074,0xee4f},  {0xa075,0xee50}, 
         {0xa076,0xee51},  {0xa077,0xee52},  {0xa078,0xee53},  {0xa079,0xee54}, 
         {0xa07a,0xee55},  {0xa07b,0xee56},  {0xa07c,0xee57},  {0xa07d,0xee58}, 
         {0xa07e,0xee59},  {0xa0a1,0xee5a},  {0xa0a2,0xee5b},  {0xa0a3,0xee5c}, 
         {0xa0a4,0xee5d},  {0xa0a5,0xee5e},  {0xa0a6,0xee5f},  {0xa0a7,0xee60}, 
         {0xa0a8,0xee61},  {0xa0a9,0xee62},  {0xa0aa,0xee63},  {0xa0ab,0xee64}, 
         {0xa0ac,0xee65},  {0xa0ad,0xee66},  {0xa0ae,0xee67},  {0xa0af,0xee68}, 
         {0xa0b0,0xee69},  {0xa0b1,0xee6a},  {0xa0b2,0xee6b},  {0xa0b3,0xee6c}, 
         {0xa0b4,0xee6d},  {0xa0b5,0xee6e},  {0xa0b6,0xee6f},  {0xa0b7,0xee70}, 
         {0xa0b8,0xee71},  {0xa0b9,0xee72},  {0xa0ba,0xee73},  {0xa0bb,0xee74}, 
         {0xa0bc,0xee75},  {0xa0bd,0xee76},  {0xa0be,0xee77},  {0xa0bf,0xee78}, 
         {0xa0c0,0xee79},  {0xa0c1,0xee7a},  {0xa0c2,0xee7b},  {0xa0c3,0xee7c}, 
         {0xa0c4,0xee7d},  {0xa0c5,0xee7e},  {0xa0c6,0xee7f},  {0xa0c7,0xee80}, 
         {0xa0c8,0xee81},  {0xa0c9,0xee82},  {0xa0ca,0xee83},  {0xa0cb,0xee84}, 
         {0xa0cc,0xee85},  {0xa0cd,0xee86},  {0xa0ce,0xee87},  {0xa0cf,0xee88}, 
         {0xa0d0,0xee89},  {0xa0d1,0xee8a},  {0xa0d2,0xee8b},  {0xa0d3,0xee8c}, 
         {0xa0d4,0xee8d},  {0xa0d5,0xee8e},  {0xa0d6,0xee8f},  {0xa0d7,0xee90}, 
         {0xa0d8,0xee91},  {0xa0d9,0xee92},  {0xa0da,0xee93},  {0xa0db,0xee94}, 
         {0xa0dc,0xee95},  {0xa0dd,0xee96},  {0xa0de,0xee97},  {0xa0df,0xee98}, 
         {0xa0e0,0xee99},  {0xa0e1,0xee9a},  {0xa0e2,0xee9b},  {0xa0e3,0xee9c}, 
         {0xa0e4,0xee9d},  {0xa0e5,0xee9e},  {0xa0e6,0xee9f},  {0xa0e7,0xeea0}, 
         {0xa0e8,0xeea1},  {0xa0e9,0xeea2},  {0xa0ea,0xeea3},  {0xa0eb,0xeea4}, 
         {0xa0ec,0xeea5},  {0xa0ed,0xeea6},  {0xa0ee,0xeea7},  {0xa0ef,0xeea8}, 
         {0xa0f0,0xeea9},  {0xa0f1,0xeeaa},  {0xa0f2,0xeeab},  {0xa0f3,0xeeac}, 
         {0xa0f4,0xeead},  {0xa0f5,0xeeae},  {0xa0f6,0xeeaf},  {0xa0f7,0xeeb0}, 
         {0xa0f8,0xeeb1},  {0xa0f9,0xeeb2},  {0xa0fa,0xeeb3},  {0xa0fb,0xeeb4}, 
         {0xa0fc,0xeeb5},  {0xa0fd,0xeeb6},  {0xa0fe,0xeeb7} 
};
static const B5Map b5_C6A1_to_uc_map[] = {
        /* 0xC6A1 - 0xC8FE */
         {0xc6a1,0xf6b1},  {0xc6a2,0xf6b2},  {0xc6a3,0xf6b3},  {0xc6a4,0xf6b4}, 
         {0xc6a5,0xf6b5},  {0xc6a6,0xf6b6},  {0xc6a7,0xf6b7},  {0xc6a8,0xf6b8}, 
         {0xc6a9,0xf6b9},  {0xc6aa,0xf6ba},  {0xc6ab,0xf6bb},  {0xc6ac,0xf6bc}, 
         {0xc6ad,0xf6bd},  {0xc6ae,0xf6be},  {0xc6af,0xf6bf},  {0xc6b0,0xf6c0}, 
         {0xc6b1,0xf6c1},  {0xc6b2,0xf6c2},  {0xc6b3,0xf6c3},  {0xc6b4,0xf6c4}, 
         {0xc6b5,0xf6c5},  {0xc6b6,0xf6c6},  {0xc6b7,0xf6c7},  {0xc6b8,0xf6c8}, 
         {0xc6b9,0xf6c9},  {0xc6ba,0xf6ca},  {0xc6bb,0xf6cb},  {0xc6bc,0xf6cc}, 
         {0xc6bd,0xf6cd},  {0xc6be,0xf6ce},  {0xc6bf,0xf6cf},  {0xc6c0,0xf6d0}, 
         {0xc6c1,0xf6d1},  {0xc6c2,0xf6d2},  {0xc6c3,0xf6d3},  {0xc6c4,0xf6d4}, 
         {0xc6c5,0xf6d5},  {0xc6c6,0xf6d6},  {0xc6c7,0xf6d7},  {0xc6c8,0xf6d8}, 
         {0xc6c9,0xf6d9},  {0xc6ca,0xf6da},  {0xc6cb,0xf6db},  {0xc6cc,0xf6dc}, 
         {0xc6cd,0xf6dd},  {0xc6ce,0xf6de},  {0xc6cf,0xf6df},  {0xc6d0,0xf6e0}, 
         {0xc6d1,0xf6e1},  {0xc6d2,0xf6e2},  {0xc6d3,0xf6e3},  {0xc6d4,0xf6e4}, 
         {0xc6d5,0xf6e5},  {0xc6d6,0xf6e6},  {0xc6d7,0xf6e7},  {0xc6d8,0xf6e8}, 
         {0xc6d9,0xf6e9},  {0xc6da,0xf6ea},  {0xc6db,0xf6eb},  {0xc6dc,0xf6ec}, 
         {0xc6dd,0xf6ed},  {0xc6de,0xf6ee},  {0xc6df,0xf6ef},  {0xc6e0,0xf6f0}, 
         {0xc6e1,0xf6f1},  {0xc6e2,0xf6f2},  {0xc6e3,0xf6f3},  {0xc6e4,0xf6f4}, 
         {0xc6e5,0xf6f5},  {0xc6e6,0xf6f6},  {0xc6e7,0xf6f7},  {0xc6e8,0xf6f8}, 
         {0xc6e9,0xf6f9},  {0xc6ea,0xf6fa},  {0xc6eb,0xf6fb},  {0xc6ec,0xf6fc}, 
         {0xc6ed,0xf6fd},  {0xc6ee,0xf6fe},  {0xc6ef,0xf6ff},  {0xc6f0,0xf700}, 
         {0xc6f1,0xf701},  {0xc6f2,0xf702},  {0xc6f3,0xf703},  {0xc6f4,0xf704}, 
         {0xc6f5,0xf705},  {0xc6f6,0xf706},  {0xc6f7,0xf707},  {0xc6f8,0xf708}, 
         {0xc6f9,0xf709},  {0xc6fa,0xf70a},  {0xc6fb,0xf70b},  {0xc6fc,0xf70c}, 
         {0xc6fd,0xf70d},  {0xc6fe,0xf70e},  {0xc740,0xf70f},  {0xc741,0xf710}, 
         {0xc742,0xf711},  {0xc743,0xf712},  {0xc744,0xf713},  {0xc745,0xf714}, 
         {0xc746,0xf715},  {0xc747,0xf716},  {0xc748,0xf717},  {0xc749,0xf718}, 
         {0xc74a,0xf719},  {0xc74b,0xf71a},  {0xc74c,0xf71b},  {0xc74d,0xf71c}, 
         {0xc74e,0xf71d},  {0xc74f,0xf71e},  {0xc750,0xf71f},  {0xc751,0xf720}, 
         {0xc752,0xf721},  {0xc753,0xf722},  {0xc754,0xf723},  {0xc755,0xf724}, 
         {0xc756,0xf725},  {0xc757,0xf726},  {0xc758,0xf727},  {0xc759,0xf728}, 
         {0xc75a,0xf729},  {0xc75b,0xf72a},  {0xc75c,0xf72b},  {0xc75d,0xf72c}, 
         {0xc75e,0xf72d},  {0xc75f,0xf72e},  {0xc760,0xf72f},  {0xc761,0xf730}, 
         {0xc762,0xf731},  {0xc763,0xf732},  {0xc764,0xf733},  {0xc765,0xf734}, 
         {0xc766,0xf735},  {0xc767,0xf736},  {0xc768,0xf737},  {0xc769,0xf738}, 
         {0xc76a,0xf739},  {0xc76b,0xf73a},  {0xc76c,0xf73b},  {0xc76d,0xf73c}, 
         {0xc76e,0xf73d},  {0xc76f,0xf73e},  {0xc770,0xf73f},  {0xc771,0xf740}, 
         {0xc772,0xf741},  {0xc773,0xf742},  {0xc774,0xf743},  {0xc775,0xf744}, 
         {0xc776,0xf745},  {0xc777,0xf746},  {0xc778,0xf747},  {0xc779,0xf748}, 
         {0xc77a,0xf749},  {0xc77b,0xf74a},  {0xc77c,0xf74b},  {0xc77d,0xf74c}, 
         {0xc77e,0xf74d},  {0xc7a1,0xf74e},  {0xc7a2,0xf74f},  {0xc7a3,0xf750}, 
         {0xc7a4,0xf751},  {0xc7a5,0xf752},  {0xc7a6,0xf753},  {0xc7a7,0xf754}, 
         {0xc7a8,0xf755},  {0xc7a9,0xf756},  {0xc7aa,0xf757},  {0xc7ab,0xf758}, 
         {0xc7ac,0xf759},  {0xc7ad,0xf75a},  {0xc7ae,0xf75b},  {0xc7af,0xf75c}, 
         {0xc7b0,0xf75d},  {0xc7b1,0xf75e},  {0xc7b2,0xf75f},  {0xc7b3,0xf760}, 
         {0xc7b4,0xf761},  {0xc7b5,0xf762},  {0xc7b6,0xf763},  {0xc7b7,0xf764}, 
         {0xc7b8,0xf765},  {0xc7b9,0xf766},  {0xc7ba,0xf767},  {0xc7bb,0xf768}, 
         {0xc7bc,0xf769},  {0xc7bd,0xf76a},  {0xc7be,0xf76b},  {0xc7bf,0xf76c}, 
         {0xc7c0,0xf76d},  {0xc7c1,0xf76e},  {0xc7c2,0xf76f},  {0xc7c3,0xf770}, 
         {0xc7c4,0xf771},  {0xc7c5,0xf772},  {0xc7c6,0xf773},  {0xc7c7,0xf774}, 
         {0xc7c8,0xf775},  {0xc7c9,0xf776},  {0xc7ca,0xf777},  {0xc7cb,0xf778}, 
         {0xc7cc,0xf779},  {0xc7cd,0xf77a},  {0xc7ce,0xf77b},  {0xc7cf,0xf77c}, 
         {0xc7d0,0xf77d},  {0xc7d1,0xf77e},  {0xc7d2,0xf77f},  {0xc7d3,0xf780}, 
         {0xc7d4,0xf781},  {0xc7d5,0xf782},  {0xc7d6,0xf783},  {0xc7d7,0xf784}, 
         {0xc7d8,0xf785},  {0xc7d9,0xf786},  {0xc7da,0xf787},  {0xc7db,0xf788}, 
         {0xc7dc,0xf789},  {0xc7dd,0xf78a},  {0xc7de,0xf78b},  {0xc7df,0xf78c}, 
         {0xc7e0,0xf78d},  {0xc7e1,0xf78e},  {0xc7e2,0xf78f},  {0xc7e3,0xf790}, 
         {0xc7e4,0xf791},  {0xc7e5,0xf792},  {0xc7e6,0xf793},  {0xc7e7,0xf794}, 
         {0xc7e8,0xf795},  {0xc7e9,0xf796},  {0xc7ea,0xf797},  {0xc7eb,0xf798}, 
         {0xc7ec,0xf799},  {0xc7ed,0xf79a},  {0xc7ee,0xf79b},  {0xc7ef,0xf79c}, 
         {0xc7f0,0xf79d},  {0xc7f1,0xf79e},  {0xc7f2,0xf79f},  {0xc7f3,0xf7a0}, 
         {0xc7f4,0xf7a1},  {0xc7f5,0xf7a2},  {0xc7f6,0xf7a3},  {0xc7f7,0xf7a4}, 
         {0xc7f8,0xf7a5},  {0xc7f9,0xf7a6},  {0xc7fa,0xf7a7},  {0xc7fb,0xf7a8}, 
         {0xc7fc,0xf7a9},  {0xc7fd,0xf7aa},  {0xc7fe,0xf7ab},  {0xc840,0xf7ac}, 
         {0xc841,0xf7ad},  {0xc842,0xf7ae},  {0xc843,0xf7af},  {0xc844,0xf7b0}, 
         {0xc845,0xf7b1},  {0xc846,0xf7b2},  {0xc847,0xf7b3},  {0xc848,0xf7b4}, 
         {0xc849,0xf7b5},  {0xc84a,0xf7b6},  {0xc84b,0xf7b7},  {0xc84c,0xf7b8}, 
         {0xc84d,0xf7b9},  {0xc84e,0xf7ba},  {0xc84f,0xf7bb},  {0xc850,0xf7bc}, 
         {0xc851,0xf7bd},  {0xc852,0xf7be},  {0xc853,0xf7bf},  {0xc854,0xf7c0}, 
         {0xc855,0xf7c1},  {0xc856,0xf7c2},  {0xc857,0xf7c3},  {0xc858,0xf7c4}, 
         {0xc859,0xf7c5},  {0xc85a,0xf7c6},  {0xc85b,0xf7c7},  {0xc85c,0xf7c8}, 
         {0xc85d,0xf7c9},  {0xc85e,0xf7ca},  {0xc85f,0xf7cb},  {0xc860,0xf7cc}, 
         {0xc861,0xf7cd},  {0xc862,0xf7ce},  {0xc863,0xf7cf},  {0xc864,0xf7d0}, 
         {0xc865,0xf7d1},  {0xc866,0xf7d2},  {0xc867,0xf7d3},  {0xc868,0xf7d4}, 
         {0xc869,0xf7d5},  {0xc86a,0xf7d6},  {0xc86b,0xf7d7},  {0xc86c,0xf7d8}, 
         {0xc86d,0xf7d9},  {0xc86e,0xf7da},  {0xc86f,0xf7db},  {0xc870,0xf7dc}, 
         {0xc871,0xf7dd},  {0xc872,0xf7de},  {0xc873,0xf7df},  {0xc874,0xf7e0}, 
         {0xc875,0xf7e1},  {0xc876,0xf7e2},  {0xc877,0xf7e3},  {0xc878,0xf7e4}, 
         {0xc879,0xf7e5},  {0xc87a,0xf7e6},  {0xc87b,0xf7e7},  {0xc87c,0xf7e8}, 
         {0xc87d,0xf7e9},  {0xc87e,0xf7ea},  {0xc8a1,0xf7eb},  {0xc8a2,0xf7ec}, 
         {0xc8a3,0xf7ed},  {0xc8a4,0xf7ee},  {0xc8a5,0xf7ef},  {0xc8a6,0xf7f0}, 
         {0xc8a7,0xf7f1},  {0xc8a8,0xf7f2},  {0xc8a9,0xf7f3},  {0xc8aa,0xf7f4}, 
         {0xc8ab,0xf7f5},  {0xc8ac,0xf7f6},  {0xc8ad,0xf7f7},  {0xc8ae,0xf7f8}, 
         {0xc8af,0xf7f9},  {0xc8b0,0xf7fa},  {0xc8b1,0xf7fb},  {0xc8b2,0xf7fc}, 
         {0xc8b3,0xf7fd},  {0xc8b4,0xf7fe},  {0xc8b5,0xf7ff},  {0xc8b6,0xf800}, 
         {0xc8b7,0xf801},  {0xc8b8,0xf802},  {0xc8b9,0xf803},  {0xc8ba,0xf804}, 
         {0xc8bb,0xf805},  {0xc8bc,0xf806},  {0xc8bd,0xf807},  {0xc8be,0xf808}, 
         {0xc8bf,0xf809},  {0xc8c0,0xf80a},  {0xc8c1,0xf80b},  {0xc8c2,0xf80c}, 
         {0xc8c3,0xf80d},  {0xc8c4,0xf80e},  {0xc8c5,0xf80f},  {0xc8c6,0xf810}, 
         {0xc8c7,0xf811},  {0xc8c8,0xf812},  {0xc8c9,0xf813},  {0xc8ca,0xf814}, 
         {0xc8cb,0xf815},  {0xc8cc,0xf816},  {0xc8cd,0xf817},  {0xc8ce,0xf818}, 
         {0xc8cf,0xf819},  {0xc8d0,0xf81a},  {0xc8d1,0xf81b},  {0xc8d2,0xf81c}, 
         {0xc8d3,0xf81d},  {0xc8d4,0xf81e},  {0xc8d5,0xf81f},  {0xc8d6,0xf820}, 
         {0xc8d7,0xf821},  {0xc8d8,0xf822},  {0xc8d9,0xf823},  {0xc8da,0xf824}, 
         {0xc8db,0xf825},  {0xc8dc,0xf826},  {0xc8dd,0xf827},  {0xc8de,0xf828}, 
         {0xc8df,0xf829},  {0xc8e0,0xf82a},  {0xc8e1,0xf82b},  {0xc8e2,0xf82c}, 
         {0xc8e3,0xf82d},  {0xc8e4,0xf82e},  {0xc8e5,0xf82f},  {0xc8e6,0xf830}, 
         {0xc8e7,0xf831},  {0xc8e8,0xf832},  {0xc8e9,0xf833},  {0xc8ea,0xf834}, 
         {0xc8eb,0xf835},  {0xc8ec,0xf836},  {0xc8ed,0xf837},  {0xc8ee,0xf838}, 
         {0xc8ef,0xf839},  {0xc8f0,0xf83a},  {0xc8f1,0xf83b},  {0xc8f2,0xf83c}, 
         {0xc8f3,0xf83d},  {0xc8f4,0xf83e},  {0xc8f5,0xf83f},  {0xc8f6,0xf840}, 
         {0xc8f7,0xf841},  {0xc8f8,0xf842},  {0xc8f9,0xf843},  {0xc8fa,0xf844}, 
         {0xc8fb,0xf845},  {0xc8fc,0xf846},  {0xc8fd,0xf847},  {0xc8fe,0xf848}
};
//This table is for values 0xFA40 - 0xFEFE also includes 0xf9fe
static const B5Map b5_FA40_to_uc_map[] = {
         {0xf9fe,0x2593},
        /* 0xFA40 - 0xFEFE */
         {0xfa40,0xe000},  {0xfa41,0xe001},  {0xfa42,0xe002},  {0xfa43,0xe003}, 
         {0xfa44,0xe004},  {0xfa45,0xe005},  {0xfa46,0xe006},  {0xfa47,0xe007}, 
         {0xfa48,0xe008},  {0xfa49,0xe009},  {0xfa4a,0xe00a},  {0xfa4b,0xe00b}, 
         {0xfa4c,0xe00c},  {0xfa4d,0xe00d},  {0xfa4e,0xe00e},  {0xfa4f,0xe00f}, 
         {0xfa50,0xe010},  {0xfa51,0xe011},  {0xfa52,0xe012},  {0xfa53,0xe013}, 
         {0xfa54,0xe014},  {0xfa55,0xe015},  {0xfa56,0xe016},  {0xfa57,0xe017}, 
         {0xfa58,0xe018},  {0xfa59,0xe019},  {0xfa5a,0xe01a},  {0xfa5b,0xe01b}, 
         {0xfa5c,0xe01c},  {0xfa5d,0xe01d},  {0xfa5e,0xe01e},  {0xfa5f,0xe01f}, 
         {0xfa60,0xe020},  {0xfa61,0xe021},  {0xfa62,0xe022},  {0xfa63,0xe023}, 
         {0xfa64,0xe024},  {0xfa65,0xe025},  {0xfa66,0xe026},  {0xfa67,0xe027}, 
         {0xfa68,0xe028},  {0xfa69,0xe029},  {0xfa6a,0xe02a},  {0xfa6b,0xe02b}, 
         {0xfa6c,0xe02c},  {0xfa6d,0xe02d},  {0xfa6e,0xe02e},  {0xfa6f,0xe02f}, 
         {0xfa70,0xe030},  {0xfa71,0xe031},  {0xfa72,0xe032},  {0xfa73,0xe033}, 
         {0xfa74,0xe034},  {0xfa75,0xe035},  {0xfa76,0xe036},  {0xfa77,0xe037}, 
         {0xfa78,0xe038},  {0xfa79,0xe039},  {0xfa7a,0xe03a},  {0xfa7b,0xe03b}, 
         {0xfa7c,0xe03c},  {0xfa7d,0xe03d},  {0xfa7e,0xe03e},  {0xfaa1,0xe03f}, 
         {0xfaa2,0xe040},  {0xfaa3,0xe041},  {0xfaa4,0xe042},  {0xfaa5,0xe043}, 
         {0xfaa6,0xe044},  {0xfaa7,0xe045},  {0xfaa8,0xe046},  {0xfaa9,0xe047}, 
         {0xfaaa,0xe048},  {0xfaab,0xe049},  {0xfaac,0xe04a},  {0xfaad,0xe04b}, 
         {0xfaae,0xe04c},  {0xfaaf,0xe04d},  {0xfab0,0xe04e},  {0xfab1,0xe04f}, 
         {0xfab2,0xe050},  {0xfab3,0xe051},  {0xfab4,0xe052},  {0xfab5,0xe053}, 
         {0xfab6,0xe054},  {0xfab7,0xe055},  {0xfab8,0xe056},  {0xfab9,0xe057}, 
         {0xfaba,0xe058},  {0xfabb,0xe059},  {0xfabc,0xe05a},  {0xfabd,0xe05b}, 
         {0xfabe,0xe05c},  {0xfabf,0xe05d},  {0xfac0,0xe05e},  {0xfac1,0xe05f}, 
         {0xfac2,0xe060},  {0xfac3,0xe061},  {0xfac4,0xe062},  {0xfac5,0xe063}, 
         {0xfac6,0xe064},  {0xfac7,0xe065},  {0xfac8,0xe066},  {0xfac9,0xe067}, 
         {0xfaca,0xe068},  {0xfacb,0xe069},  {0xfacc,0xe06a},  {0xfacd,0xe06b}, 
         {0xface,0xe06c},  {0xfacf,0xe06d},  {0xfad0,0xe06e},  {0xfad1,0xe06f}, 
         {0xfad2,0xe070},  {0xfad3,0xe071},  {0xfad4,0xe072},  {0xfad5,0xe073}, 
         {0xfad6,0xe074},  {0xfad7,0xe075},  {0xfad8,0xe076},  {0xfad9,0xe077}, 
         {0xfada,0xe078},  {0xfadb,0xe079},  {0xfadc,0xe07a},  {0xfadd,0xe07b}, 
         {0xfade,0xe07c},  {0xfadf,0xe07d},  {0xfae0,0xe07e},  {0xfae1,0xe07f}, 
         {0xfae2,0xe080},  {0xfae3,0xe081},  {0xfae4,0xe082},  {0xfae5,0xe083}, 
         {0xfae6,0xe084},  {0xfae7,0xe085},  {0xfae8,0xe086},  {0xfae9,0xe087}, 
         {0xfaea,0xe088},  {0xfaeb,0xe089},  {0xfaec,0xe08a},  {0xfaed,0xe08b}, 
         {0xfaee,0xe08c},  {0xfaef,0xe08d},  {0xfaf0,0xe08e},  {0xfaf1,0xe08f}, 
         {0xfaf2,0xe090},  {0xfaf3,0xe091},  {0xfaf4,0xe092},  {0xfaf5,0xe093}, 
         {0xfaf6,0xe094},  {0xfaf7,0xe095},  {0xfaf8,0xe096},  {0xfaf9,0xe097}, 
         {0xfafa,0xe098},  {0xfafb,0xe099},  {0xfafc,0xe09a},  {0xfafd,0xe09b}, 
         {0xfafe,0xe09c},  {0xfb40,0xe09d},  {0xfb41,0xe09e},  {0xfb42,0xe09f}, 
         {0xfb43,0xe0a0},  {0xfb44,0xe0a1},  {0xfb45,0xe0a2},  {0xfb46,0xe0a3}, 
         {0xfb47,0xe0a4},  {0xfb48,0xe0a5},  {0xfb49,0xe0a6},  {0xfb4a,0xe0a7}, 
         {0xfb4b,0xe0a8},  {0xfb4c,0xe0a9},  {0xfb4d,0xe0aa},  {0xfb4e,0xe0ab}, 
         {0xfb4f,0xe0ac},  {0xfb50,0xe0ad},  {0xfb51,0xe0ae},  {0xfb52,0xe0af}, 
         {0xfb53,0xe0b0},  {0xfb54,0xe0b1},  {0xfb55,0xe0b2},  {0xfb56,0xe0b3}, 
         {0xfb57,0xe0b4},  {0xfb58,0xe0b5},  {0xfb59,0xe0b6},  {0xfb5a,0xe0b7}, 
         {0xfb5b,0xe0b8},  {0xfb5c,0xe0b9},  {0xfb5d,0xe0ba},  {0xfb5e,0xe0bb}, 
         {0xfb5f,0xe0bc},  {0xfb60,0xe0bd},  {0xfb61,0xe0be},  {0xfb62,0xe0bf}, 
         {0xfb63,0xe0c0},  {0xfb64,0xe0c1},  {0xfb65,0xe0c2},  {0xfb66,0xe0c3}, 
         {0xfb67,0xe0c4},  {0xfb68,0xe0c5},  {0xfb69,0xe0c6},  {0xfb6a,0xe0c7}, 
         {0xfb6b,0xe0c8},  {0xfb6c,0xe0c9},  {0xfb6d,0xe0ca},  {0xfb6e,0xe0cb}, 
         {0xfb6f,0xe0cc},  {0xfb70,0xe0cd},  {0xfb71,0xe0ce},  {0xfb72,0xe0cf}, 
         {0xfb73,0xe0d0},  {0xfb74,0xe0d1},  {0xfb75,0xe0d2},  {0xfb76,0xe0d3}, 
         {0xfb77,0xe0d4},  {0xfb78,0xe0d5},  {0xfb79,0xe0d6},  {0xfb7a,0xe0d7}, 
         {0xfb7b,0xe0d8},  {0xfb7c,0xe0d9},  {0xfb7d,0xe0da},  {0xfb7e,0xe0db}, 
         {0xfba1,0xe0dc},  {0xfba2,0xe0dd},  {0xfba3,0xe0de},  {0xfba4,0xe0df}, 
         {0xfba5,0xe0e0},  {0xfba6,0xe0e1},  {0xfba7,0xe0e2},  {0xfba8,0xe0e3}, 
         {0xfba9,0xe0e4},  {0xfbaa,0xe0e5},  {0xfbab,0xe0e6},  {0xfbac,0xe0e7}, 
         {0xfbad,0xe0e8},  {0xfbae,0xe0e9},  {0xfbaf,0xe0ea},  {0xfbb0,0xe0eb}, 
         {0xfbb1,0xe0ec},  {0xfbb2,0xe0ed},  {0xfbb3,0xe0ee},  {0xfbb4,0xe0ef}, 
         {0xfbb5,0xe0f0},  {0xfbb6,0xe0f1},  {0xfbb7,0xe0f2},  {0xfbb8,0xe0f3}, 
         {0xfbb9,0xe0f4},  {0xfbba,0xe0f5},  {0xfbbb,0xe0f6},  {0xfbbc,0xe0f7}, 
         {0xfbbd,0xe0f8},  {0xfbbe,0xe0f9},  {0xfbbf,0xe0fa},  {0xfbc0,0xe0fb}, 
         {0xfbc1,0xe0fc},  {0xfbc2,0xe0fd},  {0xfbc3,0xe0fe},  {0xfbc4,0xe0ff}, 
         {0xfbc5,0xe100},  {0xfbc6,0xe101},  {0xfbc7,0xe102},  {0xfbc8,0xe103}, 
         {0xfbc9,0xe104},  {0xfbca,0xe105},  {0xfbcb,0xe106},  {0xfbcc,0xe107}, 
         {0xfbcd,0xe108},  {0xfbce,0xe109},  {0xfbcf,0xe10a},  {0xfbd0,0xe10b}, 
         {0xfbd1,0xe10c},  {0xfbd2,0xe10d},  {0xfbd3,0xe10e},  {0xfbd4,0xe10f}, 
         {0xfbd5,0xe110},  {0xfbd6,0xe111},  {0xfbd7,0xe112},  {0xfbd8,0xe113}, 
         {0xfbd9,0xe114},  {0xfbda,0xe115},  {0xfbdb,0xe116},  {0xfbdc,0xe117}, 
         {0xfbdd,0xe118},  {0xfbde,0xe119},  {0xfbdf,0xe11a},  {0xfbe0,0xe11b}, 
         {0xfbe1,0xe11c},  {0xfbe2,0xe11d},  {0xfbe3,0xe11e},  {0xfbe4,0xe11f}, 
         {0xfbe5,0xe120},  {0xfbe6,0xe121},  {0xfbe7,0xe122},  {0xfbe8,0xe123}, 
         {0xfbe9,0xe124},  {0xfbea,0xe125},  {0xfbeb,0xe126},  {0xfbec,0xe127}, 
         {0xfbed,0xe128},  {0xfbee,0xe129},  {0xfbef,0xe12a},  {0xfbf0,0xe12b}, 
         {0xfbf1,0xe12c},  {0xfbf2,0xe12d},  {0xfbf3,0xe12e},  {0xfbf4,0xe12f}, 
         {0xfbf5,0xe130},  {0xfbf6,0xe131},  {0xfbf7,0xe132},  {0xfbf8,0xe133}, 
         {0xfbf9,0xe134},  {0xfbfa,0xe135},  {0xfbfb,0xe136},  {0xfbfc,0xe137}, 
         {0xfbfd,0xe138},  {0xfbfe,0xe139},  {0xfc40,0xe13a},  {0xfc41,0xe13b}, 
         {0xfc42,0xe13c},  {0xfc43,0xe13d},  {0xfc44,0xe13e},  {0xfc45,0xe13f}, 
         {0xfc46,0xe140},  {0xfc47,0xe141},  {0xfc48,0xe142},  {0xfc49,0xe143}, 
         {0xfc4a,0xe144},  {0xfc4b,0xe145},  {0xfc4c,0xe146},  {0xfc4d,0xe147}, 
         {0xfc4e,0xe148},  {0xfc4f,0xe149},  {0xfc50,0xe14a},  {0xfc51,0xe14b}, 
         {0xfc52,0xe14c},  {0xfc53,0xe14d},  {0xfc54,0xe14e},  {0xfc55,0xe14f}, 
         {0xfc56,0xe150},  {0xfc57,0xe151},  {0xfc58,0xe152},  {0xfc59,0xe153}, 
         {0xfc5a,0xe154},  {0xfc5b,0xe155},  {0xfc5c,0xe156},  {0xfc5d,0xe157}, 
         {0xfc5e,0xe158},  {0xfc5f,0xe159},  {0xfc60,0xe15a},  {0xfc61,0xe15b}, 
         {0xfc62,0xe15c},  {0xfc63,0xe15d},  {0xfc64,0xe15e},  {0xfc65,0xe15f}, 
         {0xfc66,0xe160},  {0xfc67,0xe161},  {0xfc68,0xe162},  {0xfc69,0xe163}, 
         {0xfc6a,0xe164},  {0xfc6b,0xe165},  {0xfc6c,0xe166},  {0xfc6d,0xe167}, 
         {0xfc6e,0xe168},  {0xfc6f,0xe169},  {0xfc70,0xe16a},  {0xfc71,0xe16b}, 
         {0xfc72,0xe16c},  {0xfc73,0xe16d},  {0xfc74,0xe16e},  {0xfc75,0xe16f}, 
         {0xfc76,0xe170},  {0xfc77,0xe171},  {0xfc78,0xe172},  {0xfc79,0xe173}, 
         {0xfc7a,0xe174},  {0xfc7b,0xe175},  {0xfc7c,0xe176},  {0xfc7d,0xe177}, 
         {0xfc7e,0xe178},  {0xfca1,0xe179},  {0xfca2,0xe17a},  {0xfca3,0xe17b}, 
         {0xfca4,0xe17c},  {0xfca5,0xe17d},  {0xfca6,0xe17e},  {0xfca7,0xe17f}, 
         {0xfca8,0xe180},  {0xfca9,0xe181},  {0xfcaa,0xe182},  {0xfcab,0xe183}, 
         {0xfcac,0xe184},  {0xfcad,0xe185},  {0xfcae,0xe186},  {0xfcaf,0xe187}, 
         {0xfcb0,0xe188},  {0xfcb1,0xe189},  {0xfcb2,0xe18a},  {0xfcb3,0xe18b}, 
         {0xfcb4,0xe18c},  {0xfcb5,0xe18d},  {0xfcb6,0xe18e},  {0xfcb7,0xe18f}, 
         {0xfcb8,0xe190},  {0xfcb9,0xe191},  {0xfcba,0xe192},  {0xfcbb,0xe193}, 
         {0xfcbc,0xe194},  {0xfcbd,0xe195},  {0xfcbe,0xe196},  {0xfcbf,0xe197}, 
         {0xfcc0,0xe198},  {0xfcc1,0xe199},  {0xfcc2,0xe19a},  {0xfcc3,0xe19b}, 
         {0xfcc4,0xe19c},  {0xfcc5,0xe19d},  {0xfcc6,0xe19e},  {0xfcc7,0xe19f}, 
         {0xfcc8,0xe1a0},  {0xfcc9,0xe1a1},  {0xfcca,0xe1a2},  {0xfccb,0xe1a3}, 
         {0xfccc,0xe1a4},  {0xfccd,0xe1a5},  {0xfcce,0xe1a6},  {0xfccf,0xe1a7}, 
         {0xfcd0,0xe1a8},  {0xfcd1,0xe1a9},  {0xfcd2,0xe1aa},  {0xfcd3,0xe1ab}, 
         {0xfcd4,0xe1ac},  {0xfcd5,0xe1ad},  {0xfcd6,0xe1ae},  {0xfcd7,0xe1af}, 
         {0xfcd8,0xe1b0},  {0xfcd9,0xe1b1},  {0xfcda,0xe1b2},  {0xfcdb,0xe1b3}, 
         {0xfcdc,0xe1b4},  {0xfcdd,0xe1b5},  {0xfcde,0xe1b6},  {0xfcdf,0xe1b7}, 
         {0xfce0,0xe1b8},  {0xfce1,0xe1b9},  {0xfce2,0xe1ba},  {0xfce3,0xe1bb}, 
         {0xfce4,0xe1bc},  {0xfce5,0xe1bd},  {0xfce6,0xe1be},  {0xfce7,0xe1bf}, 
         {0xfce8,0xe1c0},  {0xfce9,0xe1c1},  {0xfcea,0xe1c2},  {0xfceb,0xe1c3}, 
         {0xfcec,0xe1c4},  {0xfced,0xe1c5},  {0xfcee,0xe1c6},  {0xfcef,0xe1c7}, 
         {0xfcf0,0xe1c8},  {0xfcf1,0xe1c9},  {0xfcf2,0xe1ca},  {0xfcf3,0xe1cb}, 
         {0xfcf4,0xe1cc},  {0xfcf5,0xe1cd},  {0xfcf6,0xe1ce},  {0xfcf7,0xe1cf}, 
         {0xfcf8,0xe1d0},  {0xfcf9,0xe1d1},  {0xfcfa,0xe1d2},  {0xfcfb,0xe1d3}, 
         {0xfcfc,0xe1d4},  {0xfcfd,0xe1d5},  {0xfcfe,0xe1d6},  {0xfd40,0xe1d7}, 
         {0xfd41,0xe1d8},  {0xfd42,0xe1d9},  {0xfd43,0xe1da},  {0xfd44,0xe1db}, 
         {0xfd45,0xe1dc},  {0xfd46,0xe1dd},  {0xfd47,0xe1de},  {0xfd48,0xe1df}, 
         {0xfd49,0xe1e0},  {0xfd4a,0xe1e1},  {0xfd4b,0xe1e2},  {0xfd4c,0xe1e3}, 
         {0xfd4d,0xe1e4},  {0xfd4e,0xe1e5},  {0xfd4f,0xe1e6},  {0xfd50,0xe1e7}, 
         {0xfd51,0xe1e8},  {0xfd52,0xe1e9},  {0xfd53,0xe1ea},  {0xfd54,0xe1eb}, 
         {0xfd55,0xe1ec},  {0xfd56,0xe1ed},  {0xfd57,0xe1ee},  {0xfd58,0xe1ef}, 
         {0xfd59,0xe1f0},  {0xfd5a,0xe1f1},  {0xfd5b,0xe1f2},  {0xfd5c,0xe1f3}, 
         {0xfd5d,0xe1f4},  {0xfd5e,0xe1f5},  {0xfd5f,0xe1f6},  {0xfd60,0xe1f7}, 
         {0xfd61,0xe1f8},  {0xfd62,0xe1f9},  {0xfd63,0xe1fa},  {0xfd64,0xe1fb}, 
         {0xfd65,0xe1fc},  {0xfd66,0xe1fd},  {0xfd67,0xe1fe},  {0xfd68,0xe1ff}, 
         {0xfd69,0xe200},  {0xfd6a,0xe201},  {0xfd6b,0xe202},  {0xfd6c,0xe203}, 
         {0xfd6d,0xe204},  {0xfd6e,0xe205},  {0xfd6f,0xe206},  {0xfd70,0xe207}, 
         {0xfd71,0xe208},  {0xfd72,0xe209},  {0xfd73,0xe20a},  {0xfd74,0xe20b}, 
         {0xfd75,0xe20c},  {0xfd76,0xe20d},  {0xfd77,0xe20e},  {0xfd78,0xe20f}, 
         {0xfd79,0xe210},  {0xfd7a,0xe211},  {0xfd7b,0xe212},  {0xfd7c,0xe213}, 
         {0xfd7d,0xe214},  {0xfd7e,0xe215},  {0xfda1,0xe216},  {0xfda2,0xe217}, 
         {0xfda3,0xe218},  {0xfda4,0xe219},  {0xfda5,0xe21a},  {0xfda6,0xe21b}, 
         {0xfda7,0xe21c},  {0xfda8,0xe21d},  {0xfda9,0xe21e},  {0xfdaa,0xe21f}, 
         {0xfdab,0xe220},  {0xfdac,0xe221},  {0xfdad,0xe222},  {0xfdae,0xe223}, 
         {0xfdaf,0xe224},  {0xfdb0,0xe225},  {0xfdb1,0xe226},  {0xfdb2,0xe227}, 
         {0xfdb3,0xe228},  {0xfdb4,0xe229},  {0xfdb5,0xe22a},  {0xfdb6,0xe22b}, 
         {0xfdb7,0xe22c},  {0xfdb8,0xe22d},  {0xfdb9,0xe22e},  {0xfdba,0xe22f}, 
         {0xfdbb,0xe230},  {0xfdbc,0xe231},  {0xfdbd,0xe232},  {0xfdbe,0xe233}, 
         {0xfdbf,0xe234},  {0xfdc0,0xe235},  {0xfdc1,0xe236},  {0xfdc2,0xe237}, 
         {0xfdc3,0xe238},  {0xfdc4,0xe239},  {0xfdc5,0xe23a},  {0xfdc6,0xe23b}, 
         {0xfdc7,0xe23c},  {0xfdc8,0xe23d},  {0xfdc9,0xe23e},  {0xfdca,0xe23f}, 
         {0xfdcb,0xe240},  {0xfdcc,0xe241},  {0xfdcd,0xe242},  {0xfdce,0xe243}, 
         {0xfdcf,0xe244},  {0xfdd0,0xe245},  {0xfdd1,0xe246},  {0xfdd2,0xe247}, 
         {0xfdd3,0xe248},  {0xfdd4,0xe249},  {0xfdd5,0xe24a},  {0xfdd6,0xe24b}, 
         {0xfdd7,0xe24c},  {0xfdd8,0xe24d},  {0xfdd9,0xe24e},  {0xfdda,0xe24f}, 
         {0xfddb,0xe250},  {0xfddc,0xe251},  {0xfddd,0xe252},  {0xfdde,0xe253}, 
         {0xfddf,0xe254},  {0xfde0,0xe255},  {0xfde1,0xe256},  {0xfde2,0xe257}, 
         {0xfde3,0xe258},  {0xfde4,0xe259},  {0xfde5,0xe25a},  {0xfde6,0xe25b}, 
         {0xfde7,0xe25c},  {0xfde8,0xe25d},  {0xfde9,0xe25e},  {0xfdea,0xe25f}, 
         {0xfdeb,0xe260},  {0xfdec,0xe261},  {0xfded,0xe262},  {0xfdee,0xe263}, 
         {0xfdef,0xe264},  {0xfdf0,0xe265},  {0xfdf1,0xe266},  {0xfdf2,0xe267}, 
         {0xfdf3,0xe268},  {0xfdf4,0xe269},  {0xfdf5,0xe26a},  {0xfdf6,0xe26b}, 
         {0xfdf7,0xe26c},  {0xfdf8,0xe26d},  {0xfdf9,0xe26e},  {0xfdfa,0xe26f}, 
         {0xfdfb,0xe270},  {0xfdfc,0xe271},  {0xfdfd,0xe272},  {0xfdfe,0xe273}, 
         {0xfe40,0xe274},  {0xfe41,0xe275},  {0xfe42,0xe276},  {0xfe43,0xe277}, 
         {0xfe44,0xe278},  {0xfe45,0xe279},  {0xfe46,0xe27a},  {0xfe47,0xe27b}, 
         {0xfe48,0xe27c},  {0xfe49,0xe27d},  {0xfe4a,0xe27e},  {0xfe4b,0xe27f}, 
         {0xfe4c,0xe280},  {0xfe4d,0xe281},  {0xfe4e,0xe282},  {0xfe4f,0xe283}, 
         {0xfe50,0xe284},  {0xfe51,0xe285},  {0xfe52,0xe286},  {0xfe53,0xe287}, 
         {0xfe54,0xe288},  {0xfe55,0xe289},  {0xfe56,0xe28a},  {0xfe57,0xe28b}, 
         {0xfe58,0xe28c},  {0xfe59,0xe28d},  {0xfe5a,0xe28e},  {0xfe5b,0xe28f}, 
         {0xfe5c,0xe290},  {0xfe5d,0xe291},  {0xfe5e,0xe292},  {0xfe5f,0xe293}, 
         {0xfe60,0xe294},  {0xfe61,0xe295},  {0xfe62,0xe296},  {0xfe63,0xe297}, 
         {0xfe64,0xe298},  {0xfe65,0xe299},  {0xfe66,0xe29a},  {0xfe67,0xe29b}, 
         {0xfe68,0xe29c},  {0xfe69,0xe29d},  {0xfe6a,0xe29e},  {0xfe6b,0xe29f}, 
         {0xfe6c,0xe2a0},  {0xfe6d,0xe2a1},  {0xfe6e,0xe2a2},  {0xfe6f,0xe2a3}, 
         {0xfe70,0xe2a4},  {0xfe71,0xe2a5},  {0xfe72,0xe2a6},  {0xfe73,0xe2a7}, 
         {0xfe74,0xe2a8},  {0xfe75,0xe2a9},  {0xfe76,0xe2aa},  {0xfe77,0xe2ab}, 
         {0xfe78,0xe2ac},  {0xfe79,0xe2ad},  {0xfe7a,0xe2ae},  {0xfe7b,0xe2af}, 
         {0xfe7c,0xe2b0},  {0xfe7d,0xe2b1},  {0xfe7e,0xe2b2},  {0xfea1,0xe2b3}, 
         {0xfea2,0xe2b4},  {0xfea3,0xe2b5},  {0xfea4,0xe2b6},  {0xfea5,0xe2b7}, 
         {0xfea6,0xe2b8},  {0xfea7,0xe2b9},  {0xfea8,0xe2ba},  {0xfea9,0xe2bb}, 
         {0xfeaa,0xe2bc},  {0xfeab,0xe2bd},  {0xfeac,0xe2be},  {0xfead,0xe2bf}, 
         {0xfeae,0xe2c0},  {0xfeaf,0xe2c1},  {0xfeb0,0xe2c2},  {0xfeb1,0xe2c3}, 
         {0xfeb2,0xe2c4},  {0xfeb3,0xe2c5},  {0xfeb4,0xe2c6},  {0xfeb5,0xe2c7}, 
         {0xfeb6,0xe2c8},  {0xfeb7,0xe2c9},  {0xfeb8,0xe2ca},  {0xfeb9,0xe2cb}, 
         {0xfeba,0xe2cc},  {0xfebb,0xe2cd},  {0xfebc,0xe2ce},  {0xfebd,0xe2cf}, 
         {0xfebe,0xe2d0},  {0xfebf,0xe2d1},  {0xfec0,0xe2d2},  {0xfec1,0xe2d3}, 
         {0xfec2,0xe2d4},  {0xfec3,0xe2d5},  {0xfec4,0xe2d6},  {0xfec5,0xe2d7}, 
         {0xfec6,0xe2d8},  {0xfec7,0xe2d9},  {0xfec8,0xe2da},  {0xfec9,0xe2db}, 
         {0xfeca,0xe2dc},  {0xfecb,0xe2dd},  {0xfecc,0xe2de},  {0xfecd,0xe2df}, 
         {0xfece,0xe2e0},  {0xfecf,0xe2e1},  {0xfed0,0xe2e2},  {0xfed1,0xe2e3}, 
         {0xfed2,0xe2e4},  {0xfed3,0xe2e5},  {0xfed4,0xe2e6},  {0xfed5,0xe2e7}, 
         {0xfed6,0xe2e8},  {0xfed7,0xe2e9},  {0xfed8,0xe2ea},  {0xfed9,0xe2eb}, 
         {0xfeda,0xe2ec},  {0xfedb,0xe2ed},  {0xfedc,0xe2ee},  {0xfedd,0xe2ef}, 
         {0xfede,0xe2f0},  {0xfedf,0xe2f1},  {0xfee0,0xe2f2},  {0xfee1,0xe2f3}, 
         {0xfee2,0xe2f4},  {0xfee3,0xe2f5},  {0xfee4,0xe2f6},  {0xfee5,0xe2f7}, 
         {0xfee6,0xe2f8},  {0xfee7,0xe2f9},  {0xfee8,0xe2fa},  {0xfee9,0xe2fb}, 
         {0xfeea,0xe2fc},  {0xfeeb,0xe2fd},  {0xfeec,0xe2fe},  {0xfeed,0xe2ff}, 
         {0xfeee,0xe300},  {0xfeef,0xe301},  {0xfef0,0xe302},  {0xfef1,0xe303}, 
         {0xfef2,0xe304},  {0xfef3,0xe305},  {0xfef4,0xe306},  {0xfef5,0xe307}, 
         {0xfef6,0xe308},  {0xfef7,0xe309},  {0xfef8,0xe30a},  {0xfef9,0xe30b}, 
         {0xfefa,0xe30c},  {0xfefb,0xe30d},  {0xfefc,0xe30e},  {0xfefd,0xe30f}, 
         {0xfefe,0xe310} 
};

static const B5Map uc_to_b5_map[] = {
        {0xa2a4,0x2550},  {0xa2a5,0x255e},   {0xa2a7,0x2561},  {0xa2a6,0x256a},
        {0xa27e,0x256d},  {0xa2a1,0x256e},   {0xa2a3,0x256f},  {0xa2a2,0x2570}
};

//All the tables  are sorted on both x and y, so can be used for binary search
static B5Index b5_map_table[5] = {
    {b5_8140_to_uc_map , sizeof(b5_8140_to_uc_map)/sizeof(B5Map)},
    {b5_8E40_to_uc_map , sizeof(b5_8E40_to_uc_map)/sizeof(B5Map)},
    {b5_C6A1_to_uc_map , sizeof(b5_C6A1_to_uc_map)/sizeof(B5Map)},
    {b5_FA40_to_uc_map , sizeof(b5_FA40_to_uc_map)/sizeof(B5Map)},
    {uc_to_b5_map , sizeof(uc_to_b5_map)/sizeof(B5Map)}
};

static int qt_Big5ToUnicode(const uchar *buf, uint *u)
{
    //for this conversion only first 4 tables are used.
    for(int i = 0; i < 4; i++) {
        int start = 0;
        int end = b5_map_table[i].tableSize - 1;

        uint b5 = (buf[0] << 8) + buf[1];
        while (start <= end) {
            int middle = (end + start + 1)/2;
            if (b5_map_table[i].table[middle].x == b5) {
                *u = b5_map_table[i].table[middle].y;
                return 2;
            } else if (b5_map_table[i].table[middle].x > b5) {
                end = middle - 1;
            } else {
                start = middle + 1;
            }
        }
    }
    return qt_Big5hkscsToUnicode(buf, u);
}

static int qt_UnicodeToBig5(ushort ch, uchar *buf)
{
    //all the tables are individually sorted on Y
    for(int i = 0; i < 5; i++) {
        int start = 0;
        int end = b5_map_table[i].tableSize - 1;

        while (start <= end) {
            int middle = (end + start + 1)/2;
            if (b5_map_table[i].table[middle].y == ch) {
                buf[0] = b5_map_table[i].table[middle].x >> 8;
                buf[1] = b5_map_table[i].table[middle].x & 0xff;
                return 2;
            } else if (b5_map_table[i].table[middle].y > ch) {
                end = middle - 1;
            } else {
                start = middle + 1;
            }
        }
    }
    return qt_UnicodeToBig5hkscs(ch, buf);
}

QString QBig5Codec::convertToUnicode(const char* chars, int len, ConverterState *state) const
{
    QChar replacement = QChar::ReplacementCharacter;
    uchar buf[2] = {0};
    int nbuf = 0;
    if (state) {
        if (state->flags & ConvertInvalidToNull)
            replacement = QChar::Null;
        nbuf = state->remainingChars;
        buf[0] = state->state_data[0];
        buf[1] = state->state_data[1];
    }
    int invalid = 0;

    //qDebug("QBig5Codec::toUnicode(const char* chars = \"%s\", int len = %d)", chars, len);
    QString result;
    for (int i=0; i<len; i++) {
        uchar ch = chars[i];
        switch (nbuf) {
        case 0:
            if (IsLatin(ch)) {
                // ASCII
                result += QLatin1Char(ch);
            } else if (IsFirstByte(ch)) {
                // Big5-ETen
                buf[0] = ch;
                nbuf = 1;
            } else {
                // Invalid
                result += replacement;
                ++invalid;
            }
            break;
        case 1:
            if (IsSecondByte(ch)) {
                // Big5-ETen
                uint u;
                buf[1] = ch;
                if (qt_Big5ToUnicode(buf, &u) == 2)
                    result += QValidChar(u);
                else {
                    // Error
                    result += replacement;
                    ++invalid;
                }
            } else {
                // Error
                result += replacement;
                ++invalid;
            }
            nbuf = 0;
            break;
        }
    }
    if (state) {
        state->remainingChars = nbuf;
        state->state_data[0] = buf[0];
        state->state_data[1] = buf[1];
        state->invalidChars += invalid;
    }
    return result;
}

QByteArray QBig5Codec::convertFromUnicode(const QChar *uc, int len, ConverterState *state) const
{
    char replacement = '?';
    if (state) {
        if (state->flags & ConvertInvalidToNull)
            replacement = 0;
    }

    int invalid = 0;

    int rlen = 2*len + 1;
    QByteArray rstr;
    rstr.resize(rlen);

    uchar* cursor = (uchar*)rstr.data();
    for (int i=0; i<len; i++) {
        ushort ch = uc[i].unicode();
        uchar c[2];
        if (ch < 0x80) {
            // ASCII
            *cursor++ = ch;
        } else if (qt_UnicodeToBig5(ch, c) == 2 && c[0] >= 0xa1 && c[0] <= 0xf9) {
            *cursor++ = c[0];
            *cursor++ = c[1];
        } else {
            *cursor++ = replacement;
            ++invalid;
        }
    }
    rstr.resize(cursor - (uchar*)rstr.constData());

    if (state) {
        state->invalidChars += invalid;
    }
    return rstr;
}

QList<QByteArray> QBig5Codec::_aliases()
{
    QList<QByteArray> aliases;
    aliases += "Big5-ETen";
    aliases += "CP950";
    return aliases;
}

int QBig5hkscsCodec::_mibEnum()
{
    return 2101;
}


QByteArray QBig5hkscsCodec::_name()
{
    return "Big5-HKSCS";
}


QString QBig5hkscsCodec::convertToUnicode(const char* chars, int len, ConverterState *state) const
{
    uchar buf[2] = {0};
    int nbuf = 0;
    QChar replacement = QChar::ReplacementCharacter;
    if (state) {
        if (state->flags & ConvertInvalidToNull)
            replacement = QChar::Null;
        nbuf = state->remainingChars;
        buf[0] = state->state_data[0];
        buf[1] = state->state_data[1];
    }
    int invalid = 0;

    //qDebug("QBig5hkscsCodec::toUnicode(const char* chars = \"%s\", int len = %d)", chars, len);
    QString result;
    for (int i=0; i<len; i++) {
        uchar ch = chars[i];
        switch (nbuf) {
        case 0:
            if (IsLatin(ch)) {
                // ASCII
                result += QLatin1Char(ch);
            } else if (IsFirstByte(ch)) {
                // Big5-HKSCS
                buf[0] = ch;
                nbuf = 1;
            } else {
                // Invalid
                result += replacement;
                ++invalid;
            }
            break;
        case 1:
            if (IsSecondByte(ch)) {
                // Big5-HKSCS
                uint u;
                buf[1] = ch;
                if (qt_Big5hkscsToUnicode(buf, &u) == 2)
                    result += QValidChar(u);
                else {
                    // Error
                    result += replacement;
                    ++invalid;
                }
            } else {
                // Error
                result += replacement;
                ++invalid;
            }
            nbuf = 0;
            break;
        }
    }
    if (state) {
        state->remainingChars = nbuf;
        state->state_data[0] = buf[0];
        state->state_data[1] = buf[1];
        state->invalidChars += invalid;
    }
    return result;
}


QByteArray QBig5hkscsCodec::convertFromUnicode(const QChar *uc, int len, ConverterState *state) const
{
    char replacement = '?';
    if (state) {
        if (state->flags & ConvertInvalidToNull)
            replacement = 0;
    }

    int invalid = 0;

    int rlen = 2*len + 1;
    QByteArray rstr;
    rstr.resize(rlen);
    uchar* cursor = (uchar*)rstr.data();
    for (int i = 0; i < len; i++) {
        unsigned short ch = uc[i].unicode();
        uchar c[2];
        if (ch < 0x80) {
            // ASCII
            *cursor++ = ch;
        } else if (qt_UnicodeToBig5hkscs(ch, c) == 2) {
            // Big5-HKSCS
            *cursor++ = c[0];
            *cursor++ = c[1];
        } else {
            // Error
            *cursor++ = replacement;
        }
    }
    rstr.resize(cursor - (uchar*)rstr.constData());

    if (state) {
        state->invalidChars += invalid;
    }
    return rstr;
}



#ifdef Q_WS_X11
QFontBig5Codec::QFontBig5Codec()
{
    //qDebug("QFontBig5Codec::QFontBig5Codec()");
}


QByteArray QFontBig5Codec::_name()
{
    //qDebug("QFontBig5Codec::name() = \"big5-0\"");
    return "big5-0";
}


int QFontBig5Codec::_mibEnum()
{
    //qDebug("QFontBig5Codec::mibEnum() = -2026");
    return -2026;
}


QString QFontBig5Codec::convertToUnicode(const char* /*chars*/, int /*len*/, ConverterState *) const
{
    return QString();
}

QByteArray QFontBig5Codec::convertFromUnicode(const QChar *uc, int len, ConverterState *) const
{
    //qDebug("QFontBig5Codec::fromUnicode(const QString& uc, int& lenInOut = %d)", lenInOut);
    QByteArray result;
    result.resize(len * 2);
    uchar *rdata = (uchar *) result.data();
    const QChar *ucp = uc;

    for (int i = 0; i < len; i++) {
        QChar ch(*ucp++);
        uchar c[2];

#if 0
        if (ch.row() == 0) {
            if (ch.cell() == ' ')
                ch = QChar(0x3000);
            else if (ch.cell() > ' ' && ch.cell() < 127)
                ch = QChar(ch.cell()-' ', 255);
        }
#endif
        if (qt_UnicodeToBig5hkscs(ch.unicode(), c) == 2 &&
             c[0] >= 0xa1 && c[0] <= 0xf9) {
            *rdata++ = c[0];
            *rdata++ = c[1];
        } else {
            *rdata++ = 0;
            *rdata++ = 0;
        }
    }
    return result;
}



QFontBig5hkscsCodec::QFontBig5hkscsCodec()
{
    //qDebug("QFontBig5hkscsCodec::QFontBig5hkscsCodec()");
}


QByteArray QFontBig5hkscsCodec::_name()
{
    //qDebug("QFontBig5hkscsCodec::name() = \"big5hkscs-0\"");
    return "big5hkscs-0";
}


int QFontBig5hkscsCodec::_mibEnum()
{
    //qDebug("QFontBig5hkscsCodec::mibEnum() = -2101");
    return -2101;
}


QString QFontBig5hkscsCodec::convertToUnicode(const char* /*chars*/, int /*len*/, ConverterState *) const
{
    return QString();
}

QByteArray QFontBig5hkscsCodec::convertFromUnicode(const QChar *uc, int len, ConverterState *) const
{
    //qDebug("QFontBig5hkscsCodec::fromUnicode(const QString& uc, int& lenInOut = %d)", lenInOut);
    QByteArray result;
    result.resize(len * 2);
    uchar *rdata = (uchar *) result.data();
    const QChar *ucp = uc;

    for (int i = 0; i < len; i++) {
        QChar ch(*ucp++);
        uchar c[2];

#if 0
        if (ch.row() == 0) {
            if (ch.cell() == ' ')
                ch = QChar(0x3000);
            else if (ch.cell() > ' ' && ch.cell() < 127)
                ch = QChar(ch.cell()-' ', 255);
        }
#endif
        if (qt_UnicodeToBig5hkscs(ch.unicode(), c) == 2) {
            *rdata++ = c[0];
            *rdata++ = c[1];
        } else {
            //white square
            *rdata++ = 0;
            *rdata++ = 0;
        }
    }
    return result;
}


#endif // Q_WS_X11

/* ====================================================================== */

/*
 * big5hkscs to ucs4 convert routing
 */

static ushort const big5hkscs_to_ucs[] = {
    /* Big5-HKSCS 0x8140 .. 0x817E */
    0xEEB8, 0xEEB9, 0xEEBA, 0xEEBB, 0xEEBC, 0xEEBD, 0xEEBE, 0xEEBF,
    0xEEC0, 0xEEC1, 0xEEC2, 0xEEC3, 0xEEC4, 0xEEC5, 0xEEC6, 0xEEC7,
    0xEEC8, 0xEEC9, 0xEECA, 0xEECB, 0xEECC, 0xEECD, 0xEECE, 0xEECF,
    0xEED0, 0xEED1, 0xEED2, 0xEED3, 0xEED4, 0xEED5, 0xEED6, 0xEED7,
    0xEED8, 0xEED9, 0xEEDA, 0xEEDB, 0xEEDC, 0xEEDD, 0xEEDE, 0xEEDF,
    0xEEE0, 0xEEE1, 0xEEE2, 0xEEE3, 0xEEE4, 0xEEE5, 0xEEE6, 0xEEE7,
    0xEEE8, 0xEEE9, 0xEEEA, 0xEEEB, 0xEEEC, 0xEEED, 0xEEEE, 0xEEEF,
    0xEEF0, 0xEEF1, 0xEEF2, 0xEEF3, 0xEEF4, 0xEEF5, 0xEEF6,
    /* Big5-HKSCS 0x81A1 .. 0x81FE */
            0xEEF7, 0xEEF8, 0xEEF9, 0xEEFA, 0xEEFB, 0xEEFC, 0xEEFD,
    0xEEFE, 0xEEFF, 0xEF00, 0xEF01, 0xEF02, 0xEF03, 0xEF04, 0xEF05,
    0xEF06, 0xEF07, 0xEF08, 0xEF09, 0xEF0A, 0xEF0B, 0xEF0C, 0xEF0D,
    0xEF0E, 0xEF0F, 0xEF10, 0xEF11, 0xEF12, 0xEF13, 0xEF14, 0xEF15,
    0xEF16, 0xEF17, 0xEF18, 0xEF19, 0xEF1A, 0xEF1B, 0xEF1C, 0xEF1D,
    0xEF1E, 0xEF1F, 0xEF20, 0xEF21, 0xEF22, 0xEF23, 0xEF24, 0xEF25,
    0xEF26, 0xEF27, 0xEF28, 0xEF29, 0xEF2A, 0xEF2B, 0xEF2C, 0xEF2D,
    0xEF2E, 0xEF2F, 0xEF30, 0xEF31, 0xEF32, 0xEF33, 0xEF34, 0xEF35,
    0xEF36, 0xEF37, 0xEF38, 0xEF39, 0xEF3A, 0xEF3B, 0xEF3C, 0xEF3D,
    0xEF3E, 0xEF3F, 0xEF40, 0xEF41, 0xEF42, 0xEF43, 0xEF44, 0xEF45,
    0xEF46, 0xEF47, 0xEF48, 0xEF49, 0xEF4A, 0xEF4B, 0xEF4C, 0xEF4D,
    0xEF4E, 0xEF4F, 0xEF50, 0xEF51, 0xEF52, 0xEF53, 0xEF54,
    /* Big5-HKSCS 0x8240 .. 0x827E */
    0xEF55, 0xEF56, 0xEF57, 0xEF58, 0xEF59, 0xEF5A, 0xEF5B, 0xEF5C,
    0xEF5D, 0xEF5E, 0xEF5F, 0xEF60, 0xEF61, 0xEF62, 0xEF63, 0xEF64,
    0xEF65, 0xEF66, 0xEF67, 0xEF68, 0xEF69, 0xEF6A, 0xEF6B, 0xEF6C,
    0xEF6D, 0xEF6E, 0xEF6F, 0xEF70, 0xEF71, 0xEF72, 0xEF73, 0xEF74,
    0xEF75, 0xEF76, 0xEF77, 0xEF78, 0xEF79, 0xEF7A, 0xEF7B, 0xEF7C,
    0xEF7D, 0xEF7E, 0xEF7F, 0xEF80, 0xEF81, 0xEF82, 0xEF83, 0xEF84,
    0xEF85, 0xEF86, 0xEF87, 0xEF88, 0xEF89, 0xEF8A, 0xEF8B, 0xEF8C,
    0xEF8D, 0xEF8E, 0xEF8F, 0xEF90, 0xEF91, 0xEF92, 0xEF93,
    /* Big5-HKSCS 0x82A1 .. 0x82FE */
            0xEF94, 0xEF95, 0xEF96, 0xEF97, 0xEF98, 0xEF99, 0xEF9A,
    0xEF9B, 0xEF9C, 0xEF9D, 0xEF9E, 0xEF9F, 0xEFA0, 0xEFA1, 0xEFA2,
    0xEFA3, 0xEFA4, 0xEFA5, 0xEFA6, 0xEFA7, 0xEFA8, 0xEFA9, 0xEFAA,
    0xEFAB, 0xEFAC, 0xEFAD, 0xEFAE, 0xEFAF, 0xEFB0, 0xEFB1, 0xEFB2,
    0xEFB3, 0xEFB4, 0xEFB5, 0xEFB6, 0xEFB7, 0xEFB8, 0xEFB9, 0xEFBA,
    0xEFBB, 0xEFBC, 0xEFBD, 0xEFBE, 0xEFBF, 0xEFC0, 0xEFC1, 0xEFC2,
    0xEFC3, 0xEFC4, 0xEFC5, 0xEFC6, 0xEFC7, 0xEFC8, 0xEFC9, 0xEFCA,
    0xEFCB, 0xEFCC, 0xEFCD, 0xEFCE, 0xEFCF, 0xEFD0, 0xEFD1, 0xEFD2,
    0xEFD3, 0xEFD4, 0xEFD5, 0xEFD6, 0xEFD7, 0xEFD8, 0xEFD9, 0xEFDA,
    0xEFDB, 0xEFDC, 0xEFDD, 0xEFDE, 0xEFDF, 0xEFE0, 0xEFE1, 0xEFE2,
    0xEFE3, 0xEFE4, 0xEFE5, 0xEFE6, 0xEFE7, 0xEFE8, 0xEFE9, 0xEFEA,
    0xEFEB, 0xEFEC, 0xEFED, 0xEFEE, 0xEFEF, 0xEFF0, 0xEFF1,
    /* Big5-HKSCS 0x8340 .. 0x837E */
    0xEFF2, 0xEFF3, 0xEFF4, 0xEFF5, 0xEFF6, 0xEFF7, 0xEFF8, 0xEFF9,
    0xEFFA, 0xEFFB, 0xEFFC, 0xEFFD, 0xEFFE, 0xEFFF, 0xF000, 0xF001,
    0xF002, 0xF003, 0xF004, 0xF005, 0xF006, 0xF007, 0xF008, 0xF009,
    0xF00A, 0xF00B, 0xF00C, 0xF00D, 0xF00E, 0xF00F, 0xF010, 0xF011,
    0xF012, 0xF013, 0xF014, 0xF015, 0xF016, 0xF017, 0xF018, 0xF019,
    0xF01A, 0xF01B, 0xF01C, 0xF01D, 0xF01E, 0xF01F, 0xF020, 0xF021,
    0xF022, 0xF023, 0xF024, 0xF025, 0xF026, 0xF027, 0xF028, 0xF029,
    0xF02A, 0xF02B, 0xF02C, 0xF02D, 0xF02E, 0xF02F, 0xF030,
    /* Big5-HKSCS 0x83A1 .. 0x83FE */
            0xF031, 0xF032, 0xF033, 0xF034, 0xF035, 0xF036, 0xF037,
    0xF038, 0xF039, 0xF03A, 0xF03B, 0xF03C, 0xF03D, 0xF03E, 0xF03F,
    0xF040, 0xF041, 0xF042, 0xF043, 0xF044, 0xF045, 0xF046, 0xF047,
    0xF048, 0xF049, 0xF04A, 0xF04B, 0xF04C, 0xF04D, 0xF04E, 0xF04F,
    0xF050, 0xF051, 0xF052, 0xF053, 0xF054, 0xF055, 0xF056, 0xF057,
    0xF058, 0xF059, 0xF05A, 0xF05B, 0xF05C, 0xF05D, 0xF05E, 0xF05F,
    0xF060, 0xF061, 0xF062, 0xF063, 0xF064, 0xF065, 0xF066, 0xF067,
    0xF068, 0xF069, 0xF06A, 0xF06B, 0xF06C, 0xF06D, 0xF06E, 0xF06F,
    0xF070, 0xF071, 0xF072, 0xF073, 0xF074, 0xF075, 0xF076, 0xF077,
    0xF078, 0xF079, 0xF07A, 0xF07B, 0xF07C, 0xF07D, 0xF07E, 0xF07F,
    0xF080, 0xF081, 0xF082, 0xF083, 0xF084, 0xF085, 0xF086, 0xF087,
    0xF088, 0xF089, 0xF08A, 0xF08B, 0xF08C, 0xF08D, 0xF08E,
    /* Big5-HKSCS 0x8440 .. 0x847E */
    0xF08F, 0xF090, 0xF091, 0xF092, 0xF093, 0xF094, 0xF095, 0xF096,
    0xF097, 0xF098, 0xF099, 0xF09A, 0xF09B, 0xF09C, 0xF09D, 0xF09E,
    0xF09F, 0xF0A0, 0xF0A1, 0xF0A2, 0xF0A3, 0xF0A4, 0xF0A5, 0xF0A6,
    0xF0A7, 0xF0A8, 0xF0A9, 0xF0AA, 0xF0AB, 0xF0AC, 0xF0AD, 0xF0AE,
    0xF0AF, 0xF0B0, 0xF0B1, 0xF0B2, 0xF0B3, 0xF0B4, 0xF0B5, 0xF0B6,
    0xF0B7, 0xF0B8, 0xF0B9, 0xF0BA, 0xF0BB, 0xF0BC, 0xF0BD, 0xF0BE,
    0xF0BF, 0xF0C0, 0xF0C1, 0xF0C2, 0xF0C3, 0xF0C4, 0xF0C5, 0xF0C6,
    0xF0C7, 0xF0C8, 0xF0C9, 0xF0CA, 0xF0CB, 0xF0CC, 0xF0CD,
    /* Big5-HKSCS 0x84A1 .. 0x84FE */
            0xF0CE, 0xF0CF, 0xF0D0, 0xF0D1, 0xF0D2, 0xF0D3, 0xF0D4,
    0xF0D5, 0xF0D6, 0xF0D7, 0xF0D8, 0xF0D9, 0xF0DA, 0xF0DB, 0xF0DC,
    0xF0DD, 0xF0DE, 0xF0DF, 0xF0E0, 0xF0E1, 0xF0E2, 0xF0E3, 0xF0E4,
    0xF0E5, 0xF0E6, 0xF0E7, 0xF0E8, 0xF0E9, 0xF0EA, 0xF0EB, 0xF0EC,
    0xF0ED, 0xF0EE, 0xF0EF, 0xF0F0, 0xF0F1, 0xF0F2, 0xF0F3, 0xF0F4,
    0xF0F5, 0xF0F6, 0xF0F7, 0xF0F8, 0xF0F9, 0xF0FA, 0xF0FB, 0xF0FC,
    0xF0FD, 0xF0FE, 0xF0FF, 0xF100, 0xF101, 0xF102, 0xF103, 0xF104,
    0xF105, 0xF106, 0xF107, 0xF108, 0xF109, 0xF10A, 0xF10B, 0xF10C,
    0xF10D, 0xF10E, 0xF10F, 0xF110, 0xF111, 0xF112, 0xF113, 0xF114,
    0xF115, 0xF116, 0xF117, 0xF118, 0xF119, 0xF11A, 0xF11B, 0xF11C,
    0xF11D, 0xF11E, 0xF11F, 0xF120, 0xF121, 0xF122, 0xF123, 0xF124,
    0xF125, 0xF126, 0xF127, 0xF128, 0xF129, 0xF12A, 0xF12B,
    /* Big5-HKSCS 0x8540 .. 0x857E */
    0xF12C, 0xF12D, 0xF12E, 0xF12F, 0xF130, 0xF131, 0xF132, 0xF133,
    0xF134, 0xF135, 0xF136, 0xF137, 0xF138, 0xF139, 0xF13A, 0xF13B,
    0xF13C, 0xF13D, 0xF13E, 0xF13F, 0xF140, 0xF141, 0xF142, 0xF143,
    0xF144, 0xF145, 0xF146, 0xF147, 0xF148, 0xF149, 0xF14A, 0xF14B,
    0xF14C, 0xF14D, 0xF14E, 0xF14F, 0xF150, 0xF151, 0xF152, 0xF153,
    0xF154, 0xF155, 0xF156, 0xF157, 0xF158, 0xF159, 0xF15A, 0xF15B,
    0xF15C, 0xF15D, 0xF15E, 0xF15F, 0xF160, 0xF161, 0xF162, 0xF163,
    0xF164, 0xF165, 0xF166, 0xF167, 0xF168, 0xF169, 0xF16A,
    /* Big5-HKSCS 0x85A1 .. 0x85FE */
            0xF16B, 0xF16C, 0xF16D, 0xF16E, 0xF16F, 0xF170, 0xF171,
    0xF172, 0xF173, 0xF174, 0xF175, 0xF176, 0xF177, 0xF178, 0xF179,
    0xF17A, 0xF17B, 0xF17C, 0xF17D, 0xF17E, 0xF17F, 0xF180, 0xF181,
    0xF182, 0xF183, 0xF184, 0xF185, 0xF186, 0xF187, 0xF188, 0xF189,
    0xF18A, 0xF18B, 0xF18C, 0xF18D, 0xF18E, 0xF18F, 0xF190, 0xF191,
    0xF192, 0xF193, 0xF194, 0xF195, 0xF196, 0xF197, 0xF198, 0xF199,
    0xF19A, 0xF19B, 0xF19C, 0xF19D, 0xF19E, 0xF19F, 0xF1A0, 0xF1A1,
    0xF1A2, 0xF1A3, 0xF1A4, 0xF1A5, 0xF1A6, 0xF1A7, 0xF1A8, 0xF1A9,
    0xF1AA, 0xF1AB, 0xF1AC, 0xF1AD, 0xF1AE, 0xF1AF, 0xF1B0, 0xF1B1,
    0xF1B2, 0xF1B3, 0xF1B4, 0xF1B5, 0xF1B6, 0xF1B7, 0xF1B8, 0xF1B9,
    0xF1BA, 0xF1BB, 0xF1BC, 0xF1BD, 0xF1BE, 0xF1BF, 0xF1C0, 0xF1C1,
    0xF1C2, 0xF1C3, 0xF1C4, 0xF1C5, 0xF1C6, 0xF1C7, 0xF1C8,
    /* Big5-HKSCS 0x8640 .. 0x867E */
    0xF1C9, 0xF1CA, 0xF1CB, 0xF1CC, 0xF1CD, 0xF1CE, 0xF1CF, 0xF1D0,
    0xF1D1, 0xF1D2, 0xF1D3, 0xF1D4, 0xF1D5, 0xF1D6, 0xF1D7, 0xF1D8,
    0xF1D9, 0xF1DA, 0xF1DB, 0xF1DC, 0xF1DD, 0xF1DE, 0xF1DF, 0xF1E0,
    0xF1E1, 0xF1E2, 0xF1E3, 0xF1E4, 0xF1E5, 0xF1E6, 0xF1E7, 0xF1E8,
    0xF1E9, 0xF1EA, 0xF1EB, 0xF1EC, 0xF1ED, 0xF1EE, 0xF1EF, 0xF1F0,
    0xF1F1, 0xF1F2, 0xF1F3, 0xF1F4, 0xF1F5, 0xF1F6, 0xF1F7, 0xF1F8,
    0xF1F9, 0xF1FA, 0xF1FB, 0xF1FC, 0xF1FD, 0xF1FE, 0xF1FF, 0xF200,
    0xF201, 0xF202, 0xF203, 0xF204, 0xF205, 0xF206, 0xF207,
    /* Big5-HKSCS 0x86A1 .. 0x86FE */
            0xF208, 0xF209, 0xF20A, 0xF20B, 0xF20C, 0xF20D, 0xF20E,
    0xF20F, 0xF210, 0xF211, 0xF212, 0xF213, 0xF214, 0xF215, 0xF216,
    0xF217, 0xF218, 0xF219, 0xF21A, 0xF21B, 0xF21C, 0xF21D, 0xF21E,
    0xF21F, 0xF220, 0xF221, 0xF222, 0xF223, 0xF224, 0xF225, 0xF226,
    0xF227, 0xF228, 0xF229, 0xF22A, 0xF22B, 0xF22C, 0xF22D, 0xF22E,
    0xF22F, 0xF230, 0xF231, 0xF232, 0xF233, 0xF234, 0xF235, 0xF236,
    0xF237, 0xF238, 0xF239, 0xF23A, 0xF23B, 0xF23C, 0xF23D, 0xF23E,
    0xF23F, 0xF240, 0xF241, 0xF242, 0xF243, 0xF244, 0xF245, 0xF246,
    0xF247, 0xF248, 0xF249, 0xF24A, 0xF24B, 0xF24C, 0xF24D, 0xF24E,
    0xF24F, 0xF250, 0xF251, 0xF252, 0xF253, 0xF254, 0xF255, 0xF256,
    0xF257, 0xF258, 0xF259, 0xF25A, 0xF25B, 0xF25C, 0xF25D, 0xF25E,
    0xF25F, 0xF260, 0xF261, 0xF262, 0xF263, 0xF264, 0xF265,
    /* Big5-HKSCS 0x8740 .. 0x877E */
    0xF266, 0xF267, 0xF268, 0xF269, 0xF26A, 0xF26B, 0xF26C, 0xF26D,
    0xF26E, 0xF26F, 0xF270, 0xF271, 0xF272, 0xF273, 0xF274, 0xF275,
    0xF276, 0xF277, 0xF278, 0xF279, 0xF27A, 0xF27B, 0xF27C, 0xF27D,
    0xF27E, 0xF27F, 0xF280, 0xF281, 0xF282, 0xF283, 0xF284, 0xF285,
    0xF286, 0xF287, 0xF288, 0xF289, 0xF28A, 0xF28B, 0xF28C, 0xF28D,
    0xF28E, 0xF28F, 0xF290, 0xF291, 0xF292, 0xF293, 0xF294, 0xF295,
    0xF296, 0xF297, 0xF298, 0xF299, 0xF29A, 0xF29B, 0xF29C, 0xF29D,
    0xF29E, 0xF29F, 0xF2A0, 0xF2A1, 0xF2A2, 0xF2A3, 0xF2A4,
    /* Big5-HKSCS 0x87A1 .. 0x87FE */
            0xF2A5, 0xF2A6, 0xF2A7, 0xF2A8, 0xF2A9, 0xF2AA, 0xF2AB,
    0xF2AC, 0xF2AD, 0xF2AE, 0xF2AF, 0xF2B0, 0xF2B1, 0xF2B2, 0xF2B3,
    0xF2B4, 0xF2B5, 0xF2B6, 0xF2B7, 0xF2B8, 0xF2B9, 0xF2BA, 0xF2BB,
    0xF2BC, 0xF2BD, 0xF2BE, 0xF2BF, 0xF2C0, 0xF2C1, 0xF2C2, 0xF2C3,
    0xF2C4, 0xF2C5, 0xF2C6, 0xF2C7, 0xF2C8, 0xF2C9, 0xF2CA, 0xF2CB,
    0xF2CC, 0xF2CD, 0xF2CE, 0xF2CF, 0xF2D0, 0xF2D1, 0xF2D2, 0xF2D3,
    0xF2D4, 0xF2D5, 0xF2D6, 0xF2D7, 0xF2D8, 0xF2D9, 0xF2DA, 0xF2DB,
    0xF2DC, 0xF2DD, 0xF2DE, 0xF2DF, 0xF2E0, 0xF2E1, 0xF2E2, 0xF2E3,
    0xF2E4, 0xF2E5, 0xF2E6, 0xF2E7, 0xF2E8, 0xF2E9, 0xF2EA, 0xF2EB,
    0xF2EC, 0xF2ED, 0xF2EE, 0xF2EF, 0xF2F0, 0xF2F1, 0xF2F2, 0xF2F3,
    0xF2F4, 0xF2F5, 0xF2F6, 0xF2F7, 0xF2F8, 0xF2F9, 0xF2FA, 0xF2FB,
    0xF2FC, 0xF2FD, 0xF2FE, 0xF2FF, 0xF300, 0xF301, 0xF302,
    /* Big5-HKSCS 0x8840 .. 0x887E */
    0xF303, 0xF304, 0xF305, 0xF306, 0xF307, 0xF308, 0xF309, 0xF30A,
    0xF30B, 0xF30C, 0xF30D, 0xF30E, 0xF30F, 0xF310, 0xF311, 0xF312,
    0xF313, 0xF314, 0xF315, 0xF316, 0xF317, 0xF318, 0x0100, 0x00C1,
    0x01CD, 0x00C0, 0x0112, 0x00C9, 0x011A, 0x00C8, 0x014C, 0x00D3,
    0x01D1, 0x00D2, 0xF325, 0x1EBE, 0xF327, 0x1EC0, 0x00CA, 0x0101,
    0x00E1, 0x01CE, 0x00E0, 0x0251, 0x0113, 0x00E9, 0x011B, 0x00E8,
    0x012B, 0x00ED, 0x01D0, 0x00EC, 0x014D, 0x00F3, 0x01D2, 0x00F2,
    0x016B, 0x00FA, 0x01D4, 0x00F9, 0x01D6, 0x01D8, 0x01DA,
    /* Big5-HKSCS 0x88A1 .. 0x88FE */
            0x01DC, 0x00FC, 0xF344, 0x1EBF, 0xF346, 0x1EC1, 0x00EA,
    0x0261, 0xF34A, 0xF34B, 0xF34C, 0xF34D, 0xF34E, 0xF34F, 0xF350,
    0xF351, 0xF352, 0xF353, 0xF354, 0xF355, 0xF356, 0xF357, 0xF358,
    0xF359, 0xF35A, 0xF35B, 0xF35C, 0xF35D, 0xF35E, 0xF35F, 0xF360,
    0xF361, 0xF362, 0xF363, 0xF364, 0xF365, 0xF366, 0xF367, 0xF368,
    0xF369, 0xF36A, 0xF36B, 0xF36C, 0xF36D, 0xF36E, 0xF36F, 0xF370,
    0xF371, 0xF372, 0xF373, 0xF374, 0xF375, 0xF376, 0xF377, 0xF378,
    0xF379, 0xF37A, 0xF37B, 0xF37C, 0xF37D, 0xF37E, 0xF37F, 0xF380,
    0xF381, 0xF382, 0xF383, 0xF384, 0xF385, 0xF386, 0xF387, 0xF388,
    0xF389, 0xF38A, 0xF38B, 0xF38C, 0xF38D, 0xF38E, 0xF38F, 0xF390,
    0xF391, 0xF392, 0xF393, 0xF394, 0xF395, 0xF396, 0xF397, 0xF398,
    0xF399, 0xF39A, 0xF39B, 0xF39C, 0xF39D, 0xF39E, 0xF39F,
    /* Big5-HKSCS 0x8940 .. 0x897E */
    0xF3A0, 0xF3A1, 0xF3A2, 0x650A, 0xF3A4, 0xF3A5, 0x4E3D, 0x6EDD,
    0x9D4E, 0x91DF, 0xF3AA, 0xF3AB, 0xF3AC, 0x6491, 0x4F1A, 0x4F28,
    0x4FA8, 0x5156, 0x5174, 0x519C, 0x51E4, 0x52A1, 0x52A8, 0x533B,
    0x534E, 0x53D1, 0x53D8, 0x56E2, 0x58F0, 0x5904, 0x5907, 0x5932,
    0x5934, 0x5B66, 0x5B9E, 0x5B9F, 0x5C9A, 0x5E86, 0x603B, 0x6589,
    0x67FE, 0x6804, 0x6865, 0x6D4E, 0x70BC, 0x7535, 0x7EA4, 0x7EAC,
    0x7EBA, 0x7EC7, 0x7ECF, 0x7EDF, 0x7F06, 0x7F37, 0x827A, 0x82CF,
    0x836F, 0x89C6, 0x8BBE, 0x8BE2, 0x8F66, 0x8F67, 0x8F6E,
    /* Big5-HKSCS 0x89A1 .. 0x89FE */
            0x7411, 0x7CFC, 0x7DCD, 0x6946, 0x7AC9, 0x5227, 0xF3E5,
    0xF3E6, 0xF3E7, 0xF3E8, 0x918C, 0x78B8, 0x915E, 0x80BC, 0xF3ED,
    0x8D0B, 0x80F6, 0xF3F0, 0xF3F1, 0xF3F2, 0x809F, 0x9EC7, 0x4CCD,
    0x9DC9, 0x9E0C, 0x4C3E, 0xF3F9, 0xF3FA, 0x9E0A, 0xF3FC, 0x35C1,
    0xF3FE, 0x6E9A, 0x823E, 0x7519, 0xF402, 0x4911, 0x9A6C, 0x9A8F,
    0x9F99, 0x7987, 0xF408, 0xF409, 0xF40A, 0xF40B, 0x4E24, 0x4E81,
    0x4E80, 0x4E87, 0x4EBF, 0x4EEB, 0x4F37, 0x344C, 0x4FBD, 0x3E48,
    0x5003, 0x5088, 0x347D, 0x3493, 0x34A5, 0x5186, 0x5905, 0x51DB,
    0x51FC, 0x5205, 0x4E89, 0x5279, 0x5290, 0x5327, 0x35C7, 0x53A9,
    0x3551, 0x53B0, 0x3553, 0x53C2, 0x5423, 0x356D, 0x3572, 0x3681,
    0x5493, 0x54A3, 0x54B4, 0x54B9, 0x54D0, 0x54EF, 0x5518, 0x5523,
    0x5528, 0x3598, 0x553F, 0x35A5, 0x35BF, 0x55D7, 0x35C5,
    /* Big5-HKSCS 0x8A40 .. 0x8A7E */
    0xF43D, 0x5525, 0xF43F, 0xF440, 0xF441, 0xF442, 0x5590, 0xF444,
    0x39EC, 0xF446, 0x8E46, 0xF448, 0xF449, 0x4053, 0xF44B, 0x777A,
    0xF44D, 0x3A34, 0x47D5, 0xF450, 0xF451, 0xF452, 0x64DD, 0xF454,
    0xF455, 0xF456, 0xF457, 0x648D, 0x8E7E, 0xF45A, 0xF45B, 0xF45C,
    0xF45D, 0xF45E, 0xF45F, 0xF460, 0xF461, 0xF462, 0xF463, 0x47F4,
    0xF465, 0xF466, 0x9AB2, 0x3A67, 0xF469, 0x3FED, 0x3506, 0xF46C,
    0xF46D, 0xF46E, 0xF46F, 0x9D6E, 0x9815, 0xF472, 0x43D9, 0xF474,
    0x64B4, 0x54E3, 0xF477, 0xF478, 0xF479, 0x39FB, 0xF47B,
    /* Big5-HKSCS 0x8AA1 .. 0x8AFE */
            0xF47C, 0xF47D, 0xF47E, 0x64EA, 0xF480, 0xF481, 0x8E68,
    0xF483, 0xF484, 0xF485, 0xF486, 0x480B, 0xF488, 0x3FFA, 0x5873,
    0xF48B, 0xF48C, 0xF48D, 0xF48E, 0xF48F, 0xF490, 0xF491, 0x5579,
    0x40BB, 0x43BA, 0xF495, 0x4AB4, 0xF497, 0xF498, 0x81AA, 0x98F5,
    0xF49B, 0x6379, 0x39FE, 0xF49E, 0x8DC0, 0x56A1, 0x647C, 0x3E43,
    0xF4A3, 0xF4A4, 0xF4A5, 0xF4A6, 0xF4A7, 0xF4A8, 0xF4A9, 0xF4AA,
    0x3992, 0x3A06, 0xF4AD, 0x3578, 0xF4AF, 0xF4B0, 0x5652, 0xF4B2,
    0xF4B3, 0xF4B4, 0x34BC, 0x6C3D, 0xF4B7, 0xF4B8, 0xF4B9, 0xF4BA,
    0xF4BB, 0xF4BC, 0xF4BD, 0xF4BE, 0xF4BF, 0xF4C0, 0xF4C1, 0x7F93,
    0xF4C3, 0xF4C4, 0xF4C5, 0x35FB, 0xF4C7, 0xF4C8, 0xF4C9, 0xF4CA,
    0x3F93, 0xF4CC, 0xF4CD, 0xF4CE, 0xF4CF, 0xF4D0, 0xF4D1, 0xF4D2,
    0xF4D3, 0xF4D4, 0xF4D5, 0x3FF9, 0xF4D7, 0x6432, 0xF4D9,
    /* Big5-HKSCS 0x8B40 .. 0x8B7E */
    0xF4DA, 0xF4DB, 0xF4DC, 0xF4DD, 0xF4DE, 0xF4DF, 0xF4E0, 0x3A18,
    0xF4E2, 0xF4E3, 0xF4E4, 0xF4E5, 0xF4E6, 0xF4E7, 0xF4E8, 0xF4E9,
    0x95AA, 0x54CC, 0x82C4, 0x55B9, 0xF4EE, 0xF4EF, 0x9C26, 0x9AB6,
    0xF4F2, 0xF4F3, 0x7140, 0x816D, 0x80EC, 0x5C1C, 0xF4F8, 0x8134,
    0x3797, 0x535F, 0xF4FC, 0x91B6, 0xF4FE, 0xF4FF, 0xF500, 0xF501,
    0x35DD, 0xF503, 0x3609, 0xF505, 0x56AF, 0xF507, 0xF508, 0xF509,
    0xF50A, 0xF50B, 0xF50C, 0xF50D, 0xF50E, 0xF50F, 0xF510, 0xF511,
    0x5A54, 0xF513, 0xF514, 0xF515, 0xF516, 0x579C, 0xF518,
    /* Big5-HKSCS 0x8BA1 .. 0x8BFE */
            0xF519, 0xF51A, 0xF51B, 0xF51C, 0xF51D, 0x3703, 0xF51F,
    0xF520, 0xF521, 0xF522, 0xF523, 0xF524, 0xF525, 0xF526, 0x5899,
    0x5268, 0x361A, 0xF52A, 0x7BB2, 0x5B68, 0x4800, 0x4B2C, 0x9F27,
    0x49E7, 0x9C1F, 0x9B8D, 0xF533, 0xF534, 0x55FB, 0x35F2, 0x5689,
    0x4E28, 0x5902, 0xF53A, 0xF53B, 0x9751, 0xF53D, 0x4E5B, 0x4EBB,
    0x353E, 0x5C23, 0x5F51, 0x5FC4, 0x38FA, 0x624C, 0x6535, 0x6B7A,
    0x6C35, 0x6C3A, 0x706C, 0x722B, 0x4E2C, 0x72AD, 0xF54E, 0x7F52,
    0x793B, 0x7CF9, 0x7F53, 0xF553, 0x34C1, 0xF555, 0xF556, 0x8002,
    0x8080, 0xF559, 0xF55A, 0x535D, 0x8864, 0x89C1, 0xF55E, 0x8BA0,
    0x8D1D, 0x9485, 0x9578, 0x957F, 0x95E8, 0xF565, 0x97E6, 0x9875,
    0x98CE, 0x98DE, 0x9963, 0xF56B, 0x9C7C, 0x9E1F, 0x9EC4, 0x6B6F,
    0xF907, 0x4E37, 0xF572, 0x961D, 0x6237, 0x94A2, 0xF576,
    /* Big5-HKSCS 0x8C40 .. 0x8C7E */
    0x503B, 0x6DFE, 0xF579, 0xF57A, 0x3DC9, 0x888F, 0xF57D, 0x7077,
    0x5CF5, 0x4B20, 0xF581, 0x3559, 0xF583, 0x6122, 0xF585, 0x8FA7,
    0x91F6, 0x7191, 0x6719, 0x73BA, 0xF58B, 0xF58C, 0x3C8B, 0xF58E,
    0x4B10, 0x78E4, 0x7402, 0x51AE, 0xF593, 0x4009, 0x6A63, 0xF596,
    0x4223, 0x860F, 0xF599, 0x7A2A, 0xF59B, 0xF59C, 0x9755, 0x704D,
    0x5324, 0xF5A0, 0x93F4, 0x76D9, 0xF5A3, 0xF5A4, 0x77DD, 0x4EA3,
    0x4FF0, 0x50BC, 0x4E2F, 0x4F17, 0xF5AB, 0x5434, 0x7D8B, 0x5892,
    0x58D0, 0xF5B0, 0x5E92, 0x5E99, 0x5FC2, 0xF5B4, 0x658B,
    /* Big5-HKSCS 0x8CA1 .. 0x8CFE */
            0xF5B6, 0x6919, 0x6A43, 0xF5B9, 0x6CFF, 0xF5BB, 0x7200,
    0xF5BD, 0x738C, 0x3EDB, 0xF5C0, 0x5B15, 0x74B9, 0x8B83, 0xF5C4,
    0xF5C5, 0x7A93, 0x7BEC, 0x7CC3, 0x7E6C, 0x82F8, 0x8597, 0xF5CC,
    0x8890, 0xF5CE, 0x8EB9, 0xF5D0, 0x8FCF, 0x855F, 0x99E0, 0x9221,
    0xF5D5, 0xF5D6, 0xF5D7, 0x4071, 0x42A2, 0x5A1A, 0xF5DB, 0xF5DC,
    0xF5DD, 0x9868, 0x676B, 0x4276, 0x573D, 0xF5E2, 0x85D6, 0xF5E4,
    0x82BF, 0xF5E6, 0x4C81, 0xF5E8, 0x5D7B, 0xF5EA, 0xF5EB, 0xF5EC,
    0xF5ED, 0x5B96, 0xF5EF, 0xF5F0, 0x7E5B, 0xF5F2, 0xF5F3, 0xF5F4,
    0xF5F5, 0xF5F6, 0xF5F7, 0xF5F8, 0xF5F9, 0xF5FA, 0xF5FB, 0xF5FC,
    0xF5FD, 0xF5FE, 0xF5FF, 0xF600, 0xF601, 0xF602, 0xF603, 0xF604,
    0xF605, 0xF606, 0xF607, 0xF608, 0xF609, 0xF60A, 0xF60B, 0xF60C,
    0xF60D, 0xF60E, 0xF60F, 0xF610, 0xF611, 0xF612, 0xF613,
    /* Big5-HKSCS 0x8D40 .. 0x8D7E */
    0xF614, 0xF615, 0xF616, 0xF617, 0xF618, 0xF619, 0xF61A, 0xF61B,
    0xF61C, 0xF61D, 0xF61E, 0xF61F, 0xF620, 0xF621, 0xF622, 0xF623,
    0xF624, 0xF625, 0xF626, 0xF627, 0xF628, 0xF629, 0xF62A, 0xF62B,
    0xF62C, 0xF62D, 0xF62E, 0xF62F, 0xF630, 0xF631, 0xF632, 0xF633,
    0x5D3E, 0x5D48, 0x5D56, 0x3DFC, 0x380F, 0x5DA4, 0x5DB9, 0x3820,
    0x3838, 0x5E42, 0x5EBD, 0x5F25, 0x5F83, 0x3908, 0x3914, 0x393F,
    0x394D, 0x60D7, 0x613D, 0x5CE5, 0x3989, 0x61B7, 0x61B9, 0x61CF,
    0x39B8, 0x622C, 0x6290, 0x62E5, 0x6318, 0x39F8, 0x56B1,
    /* Big5-HKSCS 0x8DA1 .. 0x8DFE */
            0x3A03, 0x63E2, 0x63FB, 0x6407, 0x645A, 0x3A4B, 0x64C0,
    0x5D15, 0x5621, 0x9F9F, 0x3A97, 0x6586, 0x3ABD, 0x65FF, 0x6653,
    0x3AF2, 0x6692, 0x3B22, 0x6716, 0x3B42, 0x67A4, 0x6800, 0x3B58,
    0x684A, 0x6884, 0x3B72, 0x3B71, 0x3B7B, 0x6909, 0x6943, 0x725C,
    0x6964, 0x699F, 0x6985, 0x3BBC, 0x69D6, 0x3BDD, 0x6A65, 0x6A74,
    0x6A71, 0x6A82, 0x3BEC, 0x6A99, 0x3BF2, 0x6AAB, 0x6AB5, 0x6AD4,
    0x6AF6, 0x6B81, 0x6BC1, 0x6BEA, 0x6C75, 0x6CAA, 0x3CCB, 0x6D02,
    0x6D06, 0x6D26, 0x6D81, 0x3CEF, 0x6DA4, 0x6DB1, 0x6E15, 0x6E18,
    0x6E29, 0x6E86, 0xF694, 0x6EBB, 0x6EE2, 0x6EDA, 0x9F7F, 0x6EE8,
    0x6EE9, 0x6F24, 0x6F34, 0x3D46, 0xF69E, 0x6F81, 0x6FBE, 0x3D6A,
    0x3D75, 0x71B7, 0x5C99, 0x3D8A, 0x702C, 0x3D91, 0x7050, 0x7054,
    0x706F, 0x707F, 0x7089, 0xF6AD, 0x43C1, 0x35F1, 0xF6B0,
    /* Big5-HKSCS 0x8E40 .. 0x8E7E */
    0xE311, 0x57BE, 0xE313, 0x713E, 0xE315, 0x364E, 0x69A2, 0xE318,
    0x5B74, 0x7A49, 0xE31B, 0xE31C, 0x7A65, 0x7A7D, 0xE31F, 0x7ABB,
    0x7AB0, 0x7AC2, 0x7AC3, 0x71D1, 0xE325, 0x41CA, 0x7ADA, 0x7ADD,
    0x7AEA, 0x41EF, 0x54B2, 0xE32C, 0x7B0B, 0x7B55, 0x7B29, 0xE330,
    0xE331, 0x7BA2, 0x7B6F, 0x839C, 0xE335, 0xE336, 0x7BD0, 0x8421,
    0x7B92, 0x7BB8, 0xE33B, 0x3DAD, 0xE33D, 0x8492, 0x7BFA, 0x7C06,
    0x7C35, 0xE342, 0x7C44, 0x7C83, 0xE345, 0x7CA6, 0x667D, 0xE348,
    0x7CC9, 0x7CC7, 0x7CE6, 0x7C74, 0x7CF3, 0x7CF5, 0x7CCE,
    /* Big5-HKSCS 0x8EA1 .. 0x8EFE */
            0x7E67, 0x451D, 0xE352, 0x7D5D, 0xE354, 0x748D, 0x7D89,
    0x7DAB, 0x7135, 0x7DB3, 0x7DD2, 0xE35B, 0xE35C, 0x7DE4, 0x3D13,
    0x7DF5, 0xE360, 0x7DE5, 0xE362, 0x7E1D, 0xE364, 0xE365, 0x7E6E,
    0x7E92, 0x432B, 0x946C, 0x7E27, 0x7F40, 0x7F41, 0x7F47, 0x7936,
    0xE36F, 0x99E1, 0x7F97, 0xE372, 0x7FA3, 0xE374, 0xE375, 0x455C,
    0xE377, 0x4503, 0xE379, 0x7FFA, 0xE37B, 0x8005, 0x8008, 0x801D,
    0x8028, 0x802F, 0xE381, 0xE382, 0x803B, 0x803C, 0x8061, 0xE386,
    0x4989, 0xE388, 0xE389, 0xE38A, 0x6725, 0x80A7, 0xE38D, 0x8107,
    0x811A, 0x58B0, 0xE391, 0x6C7F, 0xE393, 0xE394, 0x64E7, 0xE396,
    0x8218, 0xE398, 0x6A53, 0xE39A, 0xE39B, 0x447A, 0x8229, 0xE39E,
    0xE39F, 0xE3A0, 0x4FF9, 0xE3A2, 0x84E2, 0x8362, 0xE3A5, 0xE3A6,
    0xE3A7, 0xE3A8, 0xE3A9, 0x82AA, 0x691B, 0xE3AC, 0x41DB,
    /* Big5-HKSCS 0x8F40 .. 0x8F7E */
    0x854B, 0x82D0, 0x831A, 0xE3B1, 0xE3B2, 0x36C1, 0xE3B4, 0xE3B5,
    0x827B, 0x82E2, 0x8318, 0xE3B9, 0xE3BA, 0xE3BB, 0xE3BC, 0xE3BD,
    0x3DBF, 0x831D, 0x55EC, 0x8385, 0x450B, 0xE3C3, 0x83AC, 0x83C1,
    0x83D3, 0x347E, 0xE3C8, 0x6A57, 0x855A, 0x3496, 0xE3CC, 0xE3CD,
    0x8458, 0xE3CF, 0x8471, 0x3DD3, 0x44E4, 0x6AA7, 0x844A, 0xE3D5,
    0x7958, 0x84A8, 0xE3D8, 0xE3D9, 0xE3DA, 0x84DE, 0x840F, 0x8391,
    0x44A0, 0x8493, 0x84E4, 0xE3E1, 0x4240, 0xE3E3, 0x4543, 0x8534,
    0x5AF2, 0xE3E7, 0x4527, 0x8573, 0x4516, 0x67BF, 0x8616,
    /* Big5-HKSCS 0x8FA1 .. 0x8FFE */
            0xE3ED, 0xE3EE, 0x85C1, 0xE3F0, 0x8602, 0xE3F2, 0xE3F3,
    0xE3F4, 0x456A, 0x8628, 0x3648, 0xE3F8, 0x53F7, 0xE3FA, 0x867E,
    0x8771, 0xE3FD, 0x87EE, 0xE3FF, 0x87B1, 0x87DA, 0x880F, 0x5661,
    0x866C, 0x6856, 0x460F, 0x8845, 0x8846, 0xE409, 0xE40A, 0xE40B,
    0x885E, 0x889C, 0x465B, 0x88B4, 0x88B5, 0x63C1, 0x88C5, 0x7777,
    0xE414, 0x8987, 0x898A, 0x89A6, 0x89A9, 0x89A7, 0x89BC, 0xE41B,
    0x89E7, 0xE41D, 0xE41E, 0x8A9C, 0x7793, 0x91FE, 0x8A90, 0xE423,
    0x7AE9, 0xE425, 0xE426, 0x4713, 0xE428, 0x717C, 0x8B0C, 0x8B1F,
    0xE42C, 0xE42D, 0x8B3F, 0x8B4C, 0x8B4D, 0x8AA9, 0xE432, 0x8B90,
    0x8B9B, 0x8AAF, 0xE436, 0x4615, 0x884F, 0x8C9B, 0xE43A, 0xE43B,
    0xE43C, 0x3725, 0xE43E, 0x8CD6, 0xE440, 0xE441, 0x8D12, 0x8D03,
    0xE444, 0x8CDB, 0x705C, 0x8D11, 0xE448, 0x3ED0, 0x8D77,
    /* Big5-HKSCS 0x9040 .. 0x907E */
    0x8DA9, 0xE44C, 0xE44D, 0xE44E, 0x3B7C, 0xE450, 0xE451, 0x7AE7,
    0x8EAD, 0x8EB6, 0x8EC3, 0x92D4, 0x8F19, 0x8F2D, 0xE459, 0xE45A,
    0x8FA5, 0x9303, 0xE45D, 0xE45E, 0x8FB3, 0x492A, 0xE461, 0xE462,
    0xE463, 0x5EF8, 0xE465, 0x8FF9, 0xE467, 0xE468, 0xE469, 0xE46A,
    0x3980, 0xE46C, 0x9037, 0xE46E, 0xE46F, 0x9061, 0xE471, 0xE472,
    0x90A8, 0xE474, 0x90C4, 0xE476, 0x90AE, 0x90FD, 0x9167, 0x3AF0,
    0x91A9, 0x91C4, 0x7CAC, 0xE47E, 0xE47F, 0x920E, 0x6C9F, 0x9241,
    0x9262, 0xE484, 0x92B9, 0xE486, 0xE487, 0xE488, 0xE489,
    /* Big5-HKSCS 0x90A1 .. 0x90FE */
            0xE48A, 0x932C, 0x936B, 0xE48D, 0xE48E, 0x708F, 0x5AC3,
    0xE491, 0xE492, 0x4965, 0x9244, 0xE495, 0xE496, 0xE497, 0x9373,
    0x945B, 0x8EBC, 0x9585, 0x95A6, 0x9426, 0x95A0, 0x6FF6, 0x42B9,
    0xE4A1, 0xE4A2, 0xE4A3, 0xE4A4, 0x49DF, 0x6C1C, 0x967B, 0x9696,
    0x416C, 0x96A3, 0xE4AB, 0x61DA, 0x96B6, 0x78F5, 0xE4AF, 0x96BD,
    0x53CC, 0x49A1, 0xE4B3, 0xE4B4, 0xE4B5, 0xE4B6, 0xE4B7, 0xE4B8,
    0xE4B9, 0xE4BA, 0x9731, 0x8642, 0x9736, 0x4A0F, 0x453D, 0x4585,
    0xE4C1, 0x7075, 0x5B41, 0x971B, 0x975C, 0xE4C6, 0x9757, 0x5B4A,
    0xE4C9, 0x975F, 0x9425, 0x50D0, 0xE4CD, 0xE4CE, 0x9789, 0x979F,
    0x97B1, 0x97BE, 0x97C0, 0x97D2, 0x97E0, 0xE4D6, 0x97EE, 0x741C,
    0xE4D9, 0x97FF, 0x97F5, 0xE4DC, 0xE4DD, 0x4AD1, 0x9834, 0x9833,
    0x984B, 0x9866, 0x3B0E, 0xE4E4, 0x3D51, 0xE4E6, 0xE4E7,
    /* Big5-HKSCS 0x9140 .. 0x917E */
    0xE4E8, 0x98CA, 0x98B7, 0x98C8, 0x98C7, 0x4AFF, 0xE4EE, 0xE4EF,
    0x55B0, 0x98E1, 0x98E6, 0x98EC, 0x9378, 0x9939, 0xE4F6, 0x4B72,
    0xE4F8, 0xE4F9, 0x99F5, 0x9A0C, 0x9A3B, 0x9A10, 0x9A58, 0xE4FF,
    0x36C4, 0xE501, 0xE502, 0x9AE0, 0x9AE2, 0xE505, 0x9AF4, 0x4C0E,
    0x9B14, 0x9B2D, 0xE50A, 0x5034, 0x9B34, 0xE50D, 0x38C3, 0xE50F,
    0x9B50, 0x9B40, 0xE512, 0x5A45, 0xE514, 0x9B8E, 0xE516, 0x9C02,
    0x9BFF, 0x9C0C, 0xE51A, 0x9DD4, 0xE51C, 0xE51D, 0xE51E, 0xE51F,
    0xE520, 0xE521, 0x9D7E, 0x9D83, 0xE524, 0x9E0E, 0x6888,
    /* Big5-HKSCS 0x91A1 .. 0x91FE */
            0x9DC4, 0xE528, 0xE529, 0xE52A, 0xE52B, 0xE52C, 0x9D39,
    0xE52E, 0xE52F, 0x9E90, 0x9E95, 0x9E9E, 0x9EA2, 0x4D34, 0x9EAA,
    0x9EAF, 0xE537, 0x9EC1, 0x3B60, 0x39E5, 0x3D1D, 0x4F32, 0x37BE,
    0xE53E, 0x9F02, 0x9F08, 0x4B96, 0x9424, 0xE543, 0x9F17, 0x9F16,
    0x9F39, 0x569F, 0x568A, 0x9F45, 0x99B8, 0xE54B, 0x97F2, 0x847F,
    0x9F62, 0x9F69, 0x7ADC, 0x9F8E, 0x7216, 0x4BBE, 0xE554, 0xE555,
    0x7177, 0xE557, 0xE558, 0xE559, 0x739E, 0xE55B, 0xE55C, 0x799F,
    0xE55E, 0xE55F, 0x9369, 0x93F3, 0xE562, 0x92EC, 0x9381, 0x93CB,
    0xE566, 0xE567, 0x7217, 0x3EEB, 0x7772, 0x7A43, 0x70D0, 0xE56D,
    0xE56E, 0x717E, 0xE570, 0x70A3, 0xE572, 0xE573, 0x3EC7, 0xE575,
    0xE576, 0xE577, 0x3722, 0xE579, 0xE57A, 0x36E1, 0xE57C, 0xE57D,
    0xE57E, 0x3723, 0xE580, 0x575B, 0xE582, 0xE583, 0xE584,
    /* Big5-HKSCS 0x9240 .. 0x927E */
    0xE585, 0xE586, 0x8503, 0xE588, 0x8503, 0x8455, 0xE58B, 0xE58C,
    0xE58D, 0xE58E, 0xE58F, 0xE590, 0x44F4, 0xE592, 0xE593, 0xE594,
    0x67F9, 0x3733, 0x3C15, 0x3DE7, 0x586C, 0xE59A, 0x6810, 0x4057,
    0xE59D, 0xE59E, 0xE59F, 0xE5A0, 0xE5A1, 0x54CB, 0x569E, 0xE5A4,
    0x5692, 0xE5A6, 0xE5A7, 0xE5A8, 0x93C6, 0xE5AA, 0x939C, 0x4EF8,
    0x512B, 0x3819, 0xE5AF, 0x4EBC, 0xE5B1, 0xE5B2, 0x4F4B, 0x4F8A,
    0xE5B5, 0x5A68, 0xE5B7, 0xE5B8, 0x3999, 0xE5BA, 0xE5BB, 0x3435,
    0x4F29, 0xE5BE, 0xE5BF, 0xE5C0, 0x8ADA, 0xE5C2, 0x4E98,
    /* Big5-HKSCS 0x92A1 .. 0x92FE */
            0x50CD, 0x510D, 0x4FA2, 0x4F03, 0xE5C8, 0xE5C9, 0x4F42,
    0x502E, 0x506C, 0x5081, 0x4FCC, 0x4FE5, 0x5058, 0x50FC, 0x5159,
    0x515B, 0x515D, 0x515E, 0x6E76, 0xE5D7, 0xE5D8, 0xE5D9, 0x6D72,
    0xE5DB, 0xE5DC, 0x51A8, 0x51C3, 0xE5DF, 0x44DD, 0xE5E1, 0xE5E2,
    0xE5E3, 0x8D7A, 0xE5E5, 0xE5E6, 0x5259, 0x52A4, 0xE5E9, 0x52E1,
    0x936E, 0x467A, 0x718C, 0xE5EE, 0xE5EF, 0xE5F0, 0xE5F1, 0x69D1,
    0xE5F3, 0x7479, 0x3EDE, 0x7499, 0x7414, 0x7456, 0x7398, 0x4B8E,
    0xE5FB, 0xE5FC, 0x53D0, 0x3584, 0x720F, 0xE600, 0x55B4, 0xE602,
    0x54CD, 0xE604, 0x571D, 0x925D, 0x96F4, 0x9366, 0x57DD, 0x578D,
    0x577F, 0x363E, 0x58CB, 0x5A99, 0xE60F, 0xE610, 0xE611, 0xE612,
    0x5A2C, 0x59B8, 0x928F, 0x5A7E, 0x5ACF, 0x5A12, 0xE619, 0xE61A,
    0xE61B, 0xE61C, 0x36F5, 0x6D05, 0x7443, 0x5A21, 0xE621,
    /* Big5-HKSCS 0x9340 .. 0x937E */
    0x5A81, 0xE623, 0xE624, 0x93E0, 0x748C, 0xE627, 0x7105, 0x4972,
    0x9408, 0xE62B, 0x93BD, 0x37A0, 0x5C1E, 0x5C9E, 0x5E5E, 0x5E48,
    0xE632, 0xE633, 0xE634, 0x5ECD, 0x5B4F, 0xE637, 0xE638, 0x3701,
    0xE63A, 0x36DD, 0xE63C, 0x36D3, 0x812A, 0xE63F, 0xE640, 0xE641,
    0xE642, 0x5F0C, 0x5F0E, 0xE645, 0xE646, 0x5A6B, 0xE648, 0x5B44,
    0x8614, 0xE64B, 0x8860, 0x607E, 0xE64E, 0xE64F, 0x5FDB, 0x3EB8,
    0xE652, 0xE653, 0xE654, 0xE655, 0x61C0, 0xE657, 0xE658, 0xE659,
    0x6199, 0x6198, 0x6075, 0xE65D, 0xE65E, 0xE65F, 0xE660,
    /* Big5-HKSCS 0x93A1 .. 0x93FE */
            0x6471, 0xE662, 0xE663, 0x3A29, 0xE665, 0xE666, 0xE667,
    0xE668, 0x6337, 0xE66A, 0x64B6, 0x6331, 0x63D1, 0xE66E, 0xE66F,
    0x62A4, 0xE671, 0x643B, 0x656B, 0x6972, 0x3BF4, 0xE676, 0xE677,
    0xE678, 0xE679, 0x550D, 0xE67B, 0xE67C, 0xE67D, 0x66CE, 0xE67F,
    0xE680, 0x3AE0, 0x4190, 0xE683, 0xE684, 0xE685, 0xE686, 0xE687,
    0xE688, 0x78EE, 0xE68A, 0xE68B, 0xE68C, 0x3464, 0xE68E, 0xE68F,
    0xE690, 0x668E, 0xE692, 0x666B, 0x4B93, 0x6630, 0xE696, 0xE697,
    0x6663, 0xE699, 0xE69A, 0x661E, 0xE69C, 0x38D1, 0xE69E, 0xE69F,
    0x3B99, 0xE6A1, 0xE6A2, 0x74D0, 0x3B96, 0x678F, 0xE6A6, 0x68B6,
    0x681E, 0x3BC4, 0x6ABE, 0x3863, 0xE6AC, 0xE6AD, 0x6A33, 0x6A52,
    0x6AC9, 0x6B05, 0xE6B2, 0x6511, 0x6898, 0x6A4C, 0x3BD7, 0x6A7A,
    0x6B57, 0xE6B9, 0xE6BA, 0x93A0, 0x92F2, 0xE6BD, 0xE6BE,
    /* Big5-HKSCS 0x9440 .. 0x947E */
    0x9289, 0xE6C0, 0xE6C1, 0x9467, 0x6DA5, 0x6F0B, 0xE6C5, 0x6D67,
    0xE6C7, 0x3D8F, 0x6E04, 0xE6CA, 0x5A3D, 0x6E0A, 0x5847, 0x6D24,
    0x7842, 0x713B, 0xE6D1, 0xE6D2, 0x70F1, 0x7250, 0x7287, 0x7294,
    0xE6D7, 0xE6D8, 0x5179, 0xE6DA, 0xE6DB, 0x747A, 0xE6DD, 0xE6DE,
    0xE6DF, 0xE6E0, 0xE6E1, 0x3F06, 0x3EB1, 0xE6E4, 0xE6E5, 0xE6E6,
    0x60A7, 0x3EF3, 0x74CC, 0x743C, 0x9387, 0x7437, 0x449F, 0xE6EE,
    0x4551, 0x7583, 0x3F63, 0xE6F2, 0xE6F3, 0x3F58, 0x7555, 0x7673,
    0xE6F7, 0x3B19, 0x7468, 0xE6FA, 0xE6FB, 0xE6FC, 0x3AFB,
    /* Big5-HKSCS 0x94A1 .. 0x94FE */
            0x3DCD, 0xE6FF, 0x3EFF, 0xE701, 0xE702, 0x91FA, 0x5732,
    0x9342, 0xE706, 0xE707, 0x50DF, 0xE709, 0xE70A, 0x7778, 0xE70C,
    0x770E, 0x770F, 0x777B, 0xE710, 0xE711, 0x3A5E, 0xE713, 0x7438,
    0x749B, 0x3EBF, 0xE717, 0xE718, 0x40C8, 0xE71A, 0xE71B, 0x9307,
    0xE71D, 0x781E, 0x788D, 0x7888, 0x78D2, 0x73D0, 0x7959, 0xE724,
    0xE725, 0x410E, 0x799B, 0x8496, 0x79A5, 0x6A2D, 0xE72B, 0x7A3A,
    0x79F4, 0x416E, 0xE72F, 0x4132, 0x9235, 0x79F1, 0xE733, 0xE734,
    0xE735, 0xE736, 0xE737, 0x3597, 0x556B, 0x3570, 0x36AA, 0xE73C,
    0xE73D, 0x7AE2, 0x5A59, 0xE740, 0xE741, 0xE742, 0x5A0D, 0xE744,
    0x78F0, 0x5A2A, 0xE747, 0x7AFE, 0x41F9, 0x7C5D, 0x7C6D, 0x4211,
    0xE74D, 0xE74E, 0xE74F, 0x7CCD, 0xE751, 0xE752, 0x7C8E, 0x7C7C,
    0x7CAE, 0x6AB2, 0x7DDC, 0x7E07, 0x7DD3, 0x7F4E, 0xE75B,
    /* Big5-HKSCS 0x9540 .. 0x957E */
    0xE75C, 0xE75D, 0x7D97, 0xE75F, 0x426A, 0xE761, 0xE762, 0x67D6,
    0xE764, 0xE765, 0x57C4, 0xE767, 0xE768, 0xE769, 0x7FDD, 0x7B27,
    0xE76C, 0xE76D, 0xE76E, 0x7B0C, 0xE770, 0x99E6, 0x8645, 0x9A63,
    0x6A1C, 0xE775, 0x39E2, 0xE777, 0xE778, 0x9A1F, 0xE77A, 0x8480,
    0xE77C, 0xE77D, 0x44EA, 0x8137, 0x4402, 0x80C6, 0x8109, 0x8142,
    0xE784, 0x98C3, 0xE786, 0x8262, 0x8265, 0xE789, 0x8453, 0xE78B,
    0x8610, 0xE78D, 0x5A86, 0x417F, 0xE790, 0x5B2B, 0xE792, 0x5AE4,
    0xE794, 0x86A0, 0xE796, 0xE797, 0x882D, 0xE799, 0x5A02,
    /* Big5-HKSCS 0x95A1 .. 0x95FE */
            0x886E, 0x4F45, 0x8887, 0x88BF, 0x88E6, 0x8965, 0x894D,
    0xE7A2, 0x8954, 0xE7A4, 0xE7A5, 0xE7A6, 0xE7A7, 0xE7A8, 0xE7A9,
    0x3EAD, 0x84A3, 0x46F5, 0x46CF, 0x37F2, 0x8A3D, 0x8A1C, 0xE7B1,
    0x5F4D, 0x922B, 0xE7B4, 0x65D4, 0x7129, 0x70C4, 0xE7B8, 0x9D6D,
    0x8C9F, 0x8CE9, 0xE7BC, 0x599A, 0x77C3, 0x59F0, 0x436E, 0x36D4,
    0x8E2A, 0x8EA7, 0xE7C4, 0x8F30, 0x8F4A, 0x42F4, 0x6C58, 0x6FBB,
    0xE7CA, 0x489B, 0x6F79, 0x6E8B, 0xE7CE, 0x9BE9, 0x36B5, 0xE7D1,
    0x90BB, 0x9097, 0x5571, 0x4906, 0x91BB, 0x9404, 0xE7D8, 0x4062,
    0xE7DA, 0x9427, 0xE7DC, 0xE7DD, 0x84E5, 0x8A2B, 0x9599, 0x95A7,
    0x9597, 0x9596, 0xE7E4, 0x7445, 0x3EC2, 0xE7E7, 0xE7E8, 0xE7E9,
    0x3EE7, 0xE7EB, 0x968F, 0xE7ED, 0xE7EE, 0xE7EF, 0x3ECC, 0xE7F1,
    0xE7F2, 0xE7F3, 0x7412, 0x746B, 0x3EFC, 0x9741, 0xE7F8,
    /* Big5-HKSCS 0x9640 .. 0x967E */
    0x6847, 0x4A1D, 0xE7FB, 0xE7FC, 0x975D, 0x9368, 0xE7FF, 0xE800,
    0xE801, 0xE802, 0x92BA, 0x5B11, 0x8B69, 0x493C, 0x73F9, 0xE808,
    0x979B, 0x9771, 0x9938, 0xE80C, 0x5DC1, 0xE80E, 0xE80F, 0x981F,
    0xE811, 0x92F6, 0xE813, 0x91E5, 0x44C0, 0xE816, 0xE817, 0xE818,
    0x98DC, 0xE81A, 0x3F00, 0x922A, 0x4925, 0x8414, 0x993B, 0x994D,
    0xE821, 0x3DFD, 0x999B, 0x4B6F, 0x99AA, 0x9A5C, 0xE827, 0xE828,
    0x6A8F, 0x9A21, 0x5AFE, 0x9A2F, 0xE82D, 0x4B90, 0xE82F, 0x99BC,
    0x4BBD, 0x4B97, 0x937D, 0x5872, 0xE835, 0x5822, 0xE837,
    /* Big5-HKSCS 0x96A1 .. 0x96FE */
            0xE838, 0x7844, 0xE83A, 0xE83B, 0x68C5, 0x3D7D, 0x9458,
    0x3927, 0x6150, 0xE841, 0xE842, 0x6107, 0x9C4F, 0x9C53, 0x9C7B,
    0x9C35, 0x9C10, 0x9B7F, 0x9BCF, 0xE84B, 0x9B9F, 0xE84D, 0xE84E,
    0x9D21, 0x4CAE, 0xE851, 0x9E18, 0x4CB0, 0x9D0C, 0xE855, 0xE856,
    0xE857, 0xE858, 0x9DA5, 0x84BD, 0xE85B, 0xE85C, 0xE85D, 0x85FC,
    0x4533, 0xE860, 0xE861, 0xE862, 0x8420, 0x85EE, 0xE865, 0xE866,
    0xE867, 0x79E2, 0xE869, 0xE86A, 0x492D, 0xE86C, 0x3D62, 0x93DB,
    0x92BE, 0x9348, 0xE871, 0x78B9, 0x9277, 0x944D, 0x4FE4, 0x3440,
    0x9064, 0xE878, 0x783D, 0x7854, 0x78B6, 0x784B, 0xE87D, 0xE87E,
    0xE87F, 0x369A, 0x4F72, 0x6FDA, 0x6FD9, 0x701E, 0x701E, 0x5414,
    0xE887, 0x57BB, 0x58F3, 0x578A, 0x9D16, 0x57D7, 0x7134, 0x34AF,
    0xE88F, 0x71EB, 0xE891, 0xE892, 0x5B28, 0xE894, 0xE895,
    /* Big5-HKSCS 0x9740 .. 0x977E */
    0x610C, 0x5ACE, 0x5A0B, 0x42BC, 0xE89A, 0x372C, 0x4B7B, 0xE89D,
    0x93BB, 0x93B8, 0xE8A0, 0xE8A1, 0x8472, 0xE8A3, 0xE8A4, 0xE8A5,
    0xE8A6, 0xE8A7, 0x5994, 0xE8A9, 0xE8AA, 0x7DA8, 0xE8AC, 0xE8AD,
    0xE8AE, 0xE8AF, 0xE8B0, 0x92E5, 0x73E2, 0x3EE9, 0x74B4, 0xE8B5,
    0xE8B6, 0x3EE1, 0xE8B8, 0x6AD8, 0x73F3, 0x73FB, 0x3ED6, 0xE8BD,
    0xE8BE, 0xE8BF, 0xE8C0, 0xE8C1, 0xE8C2, 0xE8C3, 0x7448, 0xE8C5,
    0x70A5, 0xE8C7, 0x9284, 0x73E6, 0x935F, 0xE8CB, 0x9331, 0xE8CD,
    0xE8CE, 0x9386, 0xE8D0, 0xE8D1, 0x4935, 0xE8D3, 0x716B,
    /* Big5-HKSCS 0x97A1 .. 0x97FE */
            0xE8D5, 0xE8D6, 0x56A4, 0xE8D8, 0xE8D9, 0xE8DA, 0x5502,
    0x79C4, 0xE8DD, 0x7DFE, 0xE8DF, 0xE8E0, 0xE8E1, 0x452E, 0x9401,
    0x370A, 0xE8E5, 0xE8E6, 0x59B0, 0xE8E8, 0xE8E9, 0xE8EA, 0x5AA1,
    0x36E2, 0xE8ED, 0x36B0, 0x925F, 0x5A79, 0xE8F1, 0xE8F2, 0x9374,
    0x3CCD, 0xE8F5, 0x4A96, 0x398A, 0x50F4, 0x3D69, 0x3D4C, 0xE8FB,
    0x7175, 0x42FB, 0xE8FE, 0x6E0F, 0xE900, 0x44EB, 0x6D57, 0xE903,
    0x7067, 0x6CAF, 0x3CD6, 0xE907, 0xE908, 0x6E02, 0x6F0C, 0x3D6F,
    0xE90C, 0x7551, 0x36BC, 0x34C8, 0x4680, 0x3EDA, 0x4871, 0x59C4,
    0x926E, 0x493E, 0x8F41, 0xE917, 0xE918, 0x5812, 0x57C8, 0x36D6,
    0xE91C, 0x70FE, 0xE91E, 0xE91F, 0xE920, 0xE921, 0xE922, 0x68B9,
    0x6967, 0xE925, 0xE926, 0xE927, 0xE928, 0xE929, 0xE92A, 0xE92B,
    0xE92C, 0x6A1A, 0xE92E, 0xE92F, 0x843E, 0x44DF, 0x44CE,
    /* Big5-HKSCS 0x9840 .. 0x987E */
    0xE933, 0xE934, 0xE935, 0xE936, 0x6F17, 0xE938, 0x833D, 0xE93A,
    0x83ED, 0xE93C, 0xE93D, 0xE93E, 0x5989, 0x5A82, 0xE941, 0x5A61,
    0x5A71, 0xE944, 0xE945, 0x372D, 0x59EF, 0xE948, 0x36C7, 0x718E,
    0x9390, 0x669A, 0xE94D, 0x5A6E, 0x5A2B, 0xE950, 0x6A2B, 0xE952,
    0xE953, 0xE954, 0xE955, 0x711D, 0xE957, 0xE958, 0x4FB0, 0xE95A,
    0x5CC2, 0xE95C, 0xE95D, 0xE95E, 0x6A0C, 0xE960, 0xE961, 0x70A6,
    0x7133, 0xE964, 0x3DA5, 0x6CDF, 0xE967, 0xE968, 0x7E65, 0x59EB,
    0x5D2F, 0x3DF3, 0x5F5C, 0xE96E, 0xE96F, 0x7DA4, 0x8426,
    /* Big5-HKSCS 0x98A1 .. 0x98FE */
            0x5485, 0xE973, 0xE974, 0xE975, 0x577E, 0xE977, 0xE978,
    0x3FE5, 0xE97A, 0xE97B, 0x7003, 0xE97D, 0x5D70, 0x738F, 0x7CD3,
    0xE981, 0xE982, 0x4FC8, 0x7FE7, 0x72CD, 0x7310, 0xE987, 0x7338,
    0x7339, 0xE98A, 0x7341, 0x7348, 0x3EA9, 0xE98E, 0x906C, 0x71F5,
    0xE991, 0x73E1, 0x81F6, 0x3ECA, 0x770C, 0x3ED1, 0x6CA2, 0x56FD,
    0x7419, 0x741E, 0x741F, 0x3EE2, 0x3EF0, 0x3EF4, 0x3EFA, 0x74D3,
    0x3F0E, 0x3F53, 0x7542, 0x756D, 0x7572, 0x758D, 0x3F7C, 0x75C8,
    0x75DC, 0x3FC0, 0x764D, 0x3FD7, 0x7674, 0x3FDC, 0x767A, 0xE9B0,
    0x7188, 0x5623, 0x8980, 0x5869, 0x401D, 0x7743, 0x4039, 0x6761,
    0x4045, 0x35DB, 0x7798, 0x406A, 0x406F, 0x5C5E, 0x77BE, 0x77CB,
    0x58F2, 0x7818, 0x70B9, 0x781C, 0x40A8, 0x7839, 0x7847, 0x7851,
    0x7866, 0x8448, 0xE9CB, 0x7933, 0x6803, 0x7932, 0x4103,
    /* Big5-HKSCS 0x9940 .. 0x997E */
    0x4109, 0x7991, 0x7999, 0x8FBB, 0x7A06, 0x8FBC, 0x4167, 0x7A91,
    0x41B2, 0x7ABC, 0x8279, 0x41C4, 0x7ACF, 0x7ADB, 0x41CF, 0x4E21,
    0x7B62, 0x7B6C, 0x7B7B, 0x7C12, 0x7C1B, 0x4260, 0x427A, 0x7C7B,
    0x7C9C, 0x428C, 0x7CB8, 0x4294, 0x7CED, 0x8F93, 0x70C0, 0xE9EF,
    0x7DCF, 0x7DD4, 0x7DD0, 0x7DFD, 0x7FAE, 0x7FB4, 0x729F, 0x4397,
    0x8020, 0x8025, 0x7B39, 0x802E, 0x8031, 0x8054, 0x3DCC, 0x57B4,
    0x70A0, 0x80B7, 0x80E9, 0x43ED, 0x810C, 0x732A, 0x810E, 0x8112,
    0x7560, 0x8114, 0x4401, 0x3B39, 0x8156, 0x8159, 0x815A,
    /* Big5-HKSCS 0x99A1 .. 0x99FE */
            0x4413, 0x583A, 0x817C, 0x8184, 0x4425, 0x8193, 0x442D,
    0x81A5, 0x57EF, 0x81C1, 0x81E4, 0x8254, 0x448F, 0x82A6, 0x8276,
    0x82CA, 0x82D8, 0x82FF, 0x44B0, 0x8357, 0x9669, 0x698A, 0x8405,
    0x70F5, 0x8464, 0x60E3, 0x8488, 0x4504, 0x84BE, 0x84E1, 0x84F8,
    0x8510, 0x8538, 0x8552, 0x453B, 0x856F, 0x8570, 0x85E0, 0x4577,
    0x8672, 0x8692, 0x86B2, 0x86EF, 0x9645, 0x878B, 0x4606, 0x4617,
    0x88AE, 0x88FF, 0x8924, 0x8947, 0x8991, 0xEA43, 0x8A29, 0x8A38,
    0x8A94, 0x8AB4, 0x8C51, 0x8CD4, 0x8CF2, 0x8D1C, 0x4798, 0x585F,
    0x8DC3, 0x47ED, 0x4EEE, 0x8E3A, 0x55D8, 0x5754, 0x8E71, 0x55F5,
    0x8EB0, 0x4837, 0x8ECE, 0x8EE2, 0x8EE4, 0x8EED, 0x8EF2, 0x8FB7,
    0x8FC1, 0x8FCA, 0x8FCC, 0x9033, 0x99C4, 0x48AD, 0x98E0, 0x9213,
    0x491E, 0x9228, 0x9258, 0x926B, 0x92B1, 0x92AE, 0x92BF,
    /* Big5-HKSCS 0x9A40 .. 0x9A7E */
    0x92E3, 0x92EB, 0x92F3, 0x92F4, 0x92FD, 0x9343, 0x9384, 0x93AD,
    0x4945, 0x4951, 0x9EBF, 0x9417, 0x5301, 0x941D, 0x942D, 0x943E,
    0x496A, 0x9454, 0x9479, 0x952D, 0x95A2, 0x49A7, 0x95F4, 0x9633,
    0x49E5, 0x67A0, 0x4A24, 0x9740, 0x4A35, 0x97B2, 0x97C2, 0x5654,
    0x4AE4, 0x60E8, 0x98B9, 0x4B19, 0x98F1, 0x5844, 0x990E, 0x9919,
    0x51B4, 0x991C, 0x9937, 0x9942, 0x995D, 0x9962, 0x4B70, 0x99C5,
    0x4B9D, 0x9A3C, 0x9B0F, 0x7A83, 0x9B69, 0x9B81, 0x9BDD, 0x9BF1,
    0x9BF4, 0x4C6D, 0x9C20, 0x376F, 0xEAA9, 0x9D49, 0x9C3A,
    /* Big5-HKSCS 0x9AA1 .. 0x9AFE */
            0x9EFE, 0x5650, 0x9D93, 0x9DBD, 0x9DC0, 0x9DFC, 0x94F6,
    0x8FB6, 0x9E7B, 0x9EAC, 0x9EB1, 0x9EBD, 0x9EC6, 0x94DC, 0x9EE2,
    0x9EF1, 0x9EF8, 0x7AC8, 0x9F44, 0xEABF, 0xEAC0, 0xEAC1, 0x691A,
    0x94C3, 0x59AC, 0xEAC5, 0x5840, 0x94C1, 0x37B9, 0xEAC9, 0xEACA,
    0xEACB, 0xEACC, 0x5757, 0x7173, 0xEACF, 0xEAD0, 0xEAD1, 0x546A,
    0xEAD3, 0xEAD4, 0x549E, 0xEAD6, 0xEAD7, 0xEAD8, 0xEAD9, 0xEADA,
    0x60E7, 0xEADC, 0x567A, 0xEADE, 0xEADF, 0xEAE0, 0xEAE1, 0xEAE2,
    0xEAE3, 0x6955, 0x9C2F, 0x87A5, 0xEAE7, 0xEAE8, 0xEAE9, 0xEAEA,
    0xEAEB, 0xEAEC, 0x5C20, 0xEAEE, 0x5E0B, 0xEAF0, 0xEAF1, 0xEAF2,
    0x671E, 0xEAF4, 0xEAF5, 0xEAF6, 0x3647, 0xEAF8, 0xEAF9, 0xEAFA,
    0xEAFB, 0x5364, 0x84AD, 0xEAFE, 0xEAFF, 0xEB00, 0x8B81, 0xEB02,
    0xEB03, 0xEB04, 0xEB05, 0x4E78, 0x70BB, 0xEB08, 0xEB09,
    /* Big5-HKSCS 0x9B40 .. 0x9B7E */
    0xEB0A, 0xEB0B, 0xEB0C, 0xEB0D, 0xEB0E, 0xEB0F, 0x62C3, 0xEB11,
    0xEB12, 0x7198, 0x6855, 0xEB15, 0x69E9, 0x36C8, 0xEB18, 0xEB19,
    0xEB1A, 0xEB1B, 0xEB1C, 0xEB1D, 0x82FD, 0xEB1F, 0xEB20, 0xEB21,
    0x89A5, 0xEB23, 0x8FA0, 0xEB25, 0x97B8, 0xEB27, 0x9847, 0x9ABD,
    0xEB2A, 0xEB2B, 0xEB2C, 0xEB2D, 0xEB2E, 0xEB2F, 0xEB30, 0xEB31,
    0xEB32, 0xEB33, 0xEB34, 0xEB35, 0xEB36, 0xEB37, 0xEB38, 0xEB39,
    0x5FB1, 0x6648, 0x66BF, 0xEB3D, 0xEB3E, 0xEB3F, 0x7201, 0xEB41,
    0x77D7, 0xEB43, 0xEB44, 0x7E87, 0xEB46, 0x58B5, 0x670E,
    /* Big5-HKSCS 0x9BA1 .. 0x9BFE */
            0x6918, 0xEB4A, 0xEB4B, 0xEB4C, 0xEB4D, 0xEB4E, 0xEB4F,
    0xEB50, 0x48D0, 0x4AB8, 0xEB53, 0xEB54, 0xEB55, 0xEB56, 0xEB57,
    0xEB58, 0xEB59, 0xEB5A, 0xEB5B, 0x51D2, 0xEB5D, 0x599F, 0xEB5F,
    0x3BBE, 0xEB61, 0xEB62, 0xEB63, 0x5788, 0xEB65, 0x399B, 0xEB67,
    0xEB68, 0xEB69, 0x3762, 0xEB6B, 0x8B5E, 0xEB6D, 0x99D6, 0xEB6F,
    0xEB70, 0xEB71, 0x7209, 0xEB73, 0xEB74, 0x5965, 0xEB76, 0xEB77,
    0xEB78, 0x8EDA, 0xEB7A, 0x528F, 0x573F, 0x7171, 0xEB7E, 0xEB7F,
    0xEB80, 0xEB81, 0x55BC, 0xEB83, 0xEB84, 0xEB85, 0x91D4, 0x3473,
    0xEB88, 0xEB89, 0xEB8A, 0x4718, 0xEB8C, 0xEB8D, 0xEB8E, 0xEB8F,
    0xEB90, 0x5066, 0x34FB, 0xEB93, 0x60DE, 0xEB95, 0x477C, 0xEB97,
    0xEB98, 0xEB99, 0xEB9A, 0xEB9B, 0x57A1, 0x7151, 0x6FB6, 0xEB9F,
    0xEBA0, 0x9056, 0xEBA2, 0xEBA3, 0x8B62, 0xEBA5, 0xEBA6,
    /* Big5-HKSCS 0x9C40 .. 0x9C7E */
    0x5D5B, 0xEBA8, 0x8F36, 0xEBAA, 0xEBAB, 0x8AEA, 0xEBAD, 0xEBAE,
    0xEBAF, 0xEBB0, 0x4BC0, 0xEBB2, 0xEBB3, 0xEBB4, 0x9465, 0xEBB6,
    0x6195, 0x5A27, 0xEBB9, 0x4FBB, 0x56B9, 0xEBBC, 0xEBBD, 0x4E6A,
    0xEBBF, 0x9656, 0x6D8F, 0xEBC2, 0x3618, 0x8977, 0xEBC5, 0xEBC6,
    0xEBC7, 0xEBC8, 0x71DF, 0xEBCA, 0x7B42, 0xEBCC, 0xEBCD, 0xEBCE,
    0x9104, 0xEBD0, 0x7A45, 0x9DF0, 0xEBD3, 0x9A26, 0xEBD5, 0x365F,
    0xEBD7, 0xEBD8, 0x7983, 0xEBDA, 0xEBDB, 0x5D2C, 0xEBDD, 0x83CF,
    0xEBDF, 0x46D0, 0xEBE1, 0x753B, 0x8865, 0xEBE4, 0x58B6,
    /* Big5-HKSCS 0x9CA1 .. 0x9CFE */
            0x371C, 0xEBE7, 0xEBE8, 0xEBE9, 0x3C54, 0xEBEB, 0xEBEC,
    0x9281, 0xEBEE, 0xEBEF, 0x9330, 0xEBF1, 0xEBF2, 0x6C39, 0x949F,
    0xEBF5, 0xEBF6, 0x8827, 0x88F5, 0xEBF9, 0xEBFA, 0xEBFB, 0x6EB8,
    0xEBFD, 0xEBFE, 0x39A4, 0x36B9, 0x5C10, 0x79E3, 0x453F, 0x66B6,
    0xEC05, 0xEC06, 0x8943, 0xEC08, 0xEC09, 0x56D6, 0x40DF, 0xEC0C,
    0x39A1, 0xEC0E, 0xEC0F, 0xEC10, 0x71AD, 0x8366, 0xEC13, 0xEC14,
    0x5A67, 0x4CB7, 0xEC17, 0xEC18, 0xEC19, 0xEC1A, 0xEC1B, 0xEC1C,
    0xEC1D, 0x7B43, 0x797E, 0xEC20, 0x6FB5, 0xEC22, 0x6A03, 0xEC24,
    0x53A2, 0xEC26, 0x93BF, 0x6836, 0x975D, 0xEC2A, 0xEC2B, 0xEC2C,
    0xEC2D, 0xEC2E, 0xEC2F, 0x5D85, 0xEC31, 0xEC32, 0x5715, 0x9823,
    0xEC35, 0x5DAB, 0xEC37, 0x65BE, 0x69D5, 0x53D2, 0xEC3B, 0xEC3C,
    0x3C11, 0x6736, 0xEC3F, 0xEC40, 0xEC41, 0xEC42, 0xEC43,
    /* Big5-HKSCS 0x9D40 .. 0x9D7E */
    0xEC44, 0xEC45, 0xEC46, 0xEC47, 0xEC48, 0xEC49, 0x35CA, 0xEC4B,
    0xEC4C, 0x48FA, 0x63E6, 0xEC4F, 0x7808, 0x9255, 0xEC52, 0x43F2,
    0xEC54, 0x43DF, 0xEC56, 0xEC57, 0xEC58, 0x59F8, 0xEC5A, 0x8F0B,
    0xEC5C, 0xEC5D, 0x7B51, 0xEC5F, 0xEC60, 0x3DF7, 0xEC62, 0xEC63,
    0x8FD0, 0x728F, 0x568B, 0xEC67, 0xEC68, 0xEC69, 0xEC6A, 0xEC6B,
    0xEC6C, 0xEC6D, 0xEC6E, 0xEC6F, 0xEC70, 0xEC71, 0xEC72, 0xEC73,
    0x7E9F, 0xEC75, 0xEC76, 0x4CA4, 0x9547, 0xEC79, 0x71A2, 0xEC7B,
    0x4D91, 0x9012, 0xEC7E, 0x4D9C, 0xEC80, 0x8FBE, 0x55C1,
    /* Big5-HKSCS 0x9DA1 .. 0x9DFE */
            0x8FBA, 0xEC84, 0x8FB9, 0xEC86, 0x4509, 0x7E7F, 0x6F56,
    0x6AB1, 0x4EEA, 0x34E4, 0xEC8D, 0xEC8E, 0x373A, 0x8E80, 0xEC91,
    0xEC92, 0xEC93, 0xEC94, 0xEC95, 0xEC96, 0x3DEB, 0xEC98, 0xEC99,
    0xEC9A, 0xEC9B, 0x4E9A, 0xEC9D, 0xEC9E, 0x56BF, 0xECA0, 0x8E0E,
    0x5B6D, 0xECA3, 0xECA4, 0x63DE, 0x62D0, 0xECA7, 0xECA8, 0x6530,
    0x562D, 0xECAB, 0x541A, 0xECAD, 0x3DC6, 0xECAF, 0x4C7D, 0x5622,
    0x561E, 0x7F49, 0xECB4, 0x5975, 0xECB6, 0x8770, 0x4E1C, 0xECB9,
    0xECBA, 0xECBB, 0x8117, 0x9D5E, 0x8D18, 0x763B, 0x9C45, 0x764E,
    0x77B9, 0x9345, 0x5432, 0x8148, 0x82F7, 0x5625, 0x8132, 0x8418,
    0x80BD, 0x55EA, 0x7962, 0x5643, 0x5416, 0xECCF, 0x35CE, 0x5605,
    0x55F1, 0x66F1, 0xECD4, 0x362D, 0x7534, 0x55F0, 0x55BA, 0x5497,
    0x5572, 0xECDB, 0xECDC, 0x5ED0, 0xECDE, 0xECDF, 0xECE0,
    /* Big5-HKSCS 0x9E40 .. 0x9E7E */
    0xECE1, 0x9EAB, 0x7D5A, 0x55DE, 0xECE5, 0x629D, 0x976D, 0x5494,
    0x8CCD, 0x71F6, 0x9176, 0x63FC, 0x63B9, 0x63FE, 0x5569, 0xECF0,
    0x9C72, 0xECF2, 0x519A, 0x34DF, 0xECF5, 0x51A7, 0x544D, 0x551E,
    0x5513, 0x7666, 0x8E2D, 0xECFC, 0x75B1, 0x80B6, 0x8804, 0x8786,
    0x88C7, 0x81B6, 0x841C, 0xED04, 0x44EC, 0x7304, 0xED07, 0x5B90,
    0x830B, 0xED0A, 0x567B, 0xED0C, 0xED0D, 0xED0E, 0xED0F, 0xED10,
    0xED11, 0x9170, 0xED13, 0x9208, 0xED15, 0xED16, 0xED17, 0xED18,
    0x7266, 0xED1A, 0x474E, 0xED1C, 0xED1D, 0xED1E, 0x40FA,
    /* Big5-HKSCS 0x9EA1 .. 0x9EFE */
            0x9C5D, 0x651F, 0xED22, 0x48F3, 0xED24, 0xED25, 0xED26,
    0xED27, 0x6062, 0xED29, 0xED2A, 0xED2B, 0xED2C, 0xED2D, 0x71A3,
    0x7E8E, 0x9D50, 0x4E1A, 0x4E04, 0x3577, 0x5B0D, 0x6CB2, 0x5367,
    0x36AC, 0x39DC, 0x537D, 0x36A5, 0xED3B, 0x589A, 0xED3D, 0x822D,
    0x544B, 0x57AA, 0xED41, 0xED42, 0xED43, 0x3A52, 0xED45, 0x7374,
    0xED47, 0x4D09, 0x9BED, 0xED4A, 0xED4B, 0x4C5B, 0xED4D, 0xED4E,
    0xED4F, 0x845C, 0xED51, 0xED52, 0xED53, 0xED54, 0x632E, 0x7D25,
    0xED57, 0xED58, 0x3A2A, 0x9008, 0x52CC, 0x3E74, 0x367A, 0x45E9,
    0xED5F, 0x7640, 0x5AF0, 0xED62, 0x787A, 0x47B6, 0x58A7, 0x40BF,
    0x567C, 0x9B8B, 0x5D74, 0x7654, 0xED6B, 0x9E85, 0x4CE1, 0x75F9,
    0x37FB, 0x6119, 0xED71, 0xED72, 0xED73, 0x565D, 0xED75, 0x57A7,
    0xED77, 0xED78, 0x5234, 0xED7A, 0x35AD, 0x6C4A, 0x9D7C,
    /* Big5-HKSCS 0x9F40 .. 0x9F7E */
    0x7C56, 0x9B39, 0x57DE, 0xED81, 0x5C53, 0x64D3, 0xED84, 0xED85,
    0xED86, 0x86AD, 0xED88, 0xED89, 0xED8A, 0xED8B, 0xED8C, 0x51FE,
    0xED8E, 0x5D8E, 0x9703, 0xED91, 0x9E81, 0x904C, 0x7B1F, 0x9B02,
    0x5CD1, 0x7BA3, 0x6268, 0x6335, 0x9AFF, 0x7BCF, 0x9B2A, 0x7C7E,
    0x9B2E, 0x7C42, 0x7C86, 0x9C15, 0x7BFC, 0x9B09, 0x9F17, 0x9C1B,
    0xEDA6, 0x9F5A, 0x5573, 0x5BC3, 0x4FFD, 0x9E98, 0x4FF2, 0x5260,
    0x3E06, 0x52D1, 0x5767, 0x5056, 0x59B7, 0x5E12, 0x97C8, 0x9DAB,
    0x8F5C, 0x5469, 0x97B4, 0x9940, 0x97BA, 0x532C, 0x6130,
    /* Big5-HKSCS 0x9FA1 .. 0x9FFE */
            0x692C, 0x53DA, 0x9C0A, 0x9D02, 0x4C3B, 0x9641, 0x6980,
    0x50A6, 0x7546, 0xEDC6, 0x99DA, 0x5273, 0xEDC9, 0x9159, 0x9681,
    0x915C, 0xEDCD, 0x9151, 0xEDCF, 0x637F, 0xEDD1, 0x6ACA, 0x5611,
    0x918E, 0x757A, 0x6285, 0xEDD7, 0x734F, 0x7C70, 0xEDDA, 0xEDDB,
    0xEDDC, 0xEDDD, 0x76D6, 0x9B9D, 0x4E2A, 0xEDE1, 0x83BE, 0x8842,
    0xEDE4, 0x5C4A, 0x69C0, 0x50ED, 0x577A, 0x521F, 0x5DF5, 0x4ECE,
    0x6C31, 0xEDED, 0x4F39, 0x549C, 0x54DA, 0x529A, 0x8D82, 0x35FE,
    0x5F0C, 0x35F3, 0xEDF6, 0x6B52, 0x917C, 0x9FA5, 0x9B97, 0x982E,
    0x98B4, 0x9ABA, 0x9EA8, 0x9E84, 0x717A, 0x7B14, 0xEE02, 0x6BFA,
    0x8818, 0x7F78, 0xEE06, 0x5620, 0xEE08, 0x8E77, 0x9F53, 0xEE0B,
    0x8DD4, 0x8E4F, 0x9E1C, 0x8E01, 0x6282, 0xEE11, 0x8E28, 0x8E75,
    0x7AD3, 0xEE15, 0x7A3E, 0x78D8, 0x6CEA, 0x8A67, 0x7607,
    /* Big5-HKSCS 0xA040 .. 0xA07E */
    0xEE1B, 0x9F26, 0x6CCE, 0x87D6, 0x75C3, 0xEE20, 0x7853, 0xEE22,
    0x8D0C, 0x72E2, 0x7371, 0x8B2D, 0x7302, 0x74F1, 0x8CEB, 0xEE2A,
    0x862F, 0x5FBA, 0x88A0, 0x44B7, 0xEE2F, 0xEE30, 0xEE31, 0xEE32,
    0x8A7E, 0xEE34, 0xEE35, 0x60FD, 0x7667, 0x9AD7, 0x9D44, 0x936E,
    0x9B8F, 0x87F5, 0xEE3D, 0x880F, 0x8CF7, 0x732C, 0x9721, 0x9BB0,
    0x35D6, 0x72B2, 0x4C07, 0x7C51, 0x994A, 0xEE48, 0x6159, 0x4C04,
    0x9E96, 0x617D, 0xEE4D, 0x575F, 0x616F, 0x62A6, 0x6239, 0x62CE,
    0x3A5C, 0x61E2, 0x53AA, 0xEE56, 0x6364, 0x6802, 0x35D2,
    /* Big5-HKSCS 0xA0A1 .. 0xA0FE */
            0x5D57, 0xEE5B, 0x8FDA, 0xEE5D, 0xEE5E, 0x50D9, 0xEE60,
    0x7906, 0x5332, 0x9638, 0xEE64, 0x4065, 0xEE66, 0x77FE, 0xEE68,
    0x7CC2, 0xEE6A, 0x7CDA, 0x7A2D, 0x8066, 0x8063, 0x7D4D, 0x7505,
    0x74F2, 0x8994, 0x821A, 0x670C, 0x8062, 0xEE76, 0x805B, 0x74F0,
    0x8103, 0x7724, 0x8989, 0xEE7C, 0x7553, 0xEE7E, 0x87A9, 0x87CE,
    0x81C8, 0x878C, 0x8A49, 0x8CAD, 0x8B43, 0x772B, 0x74F8, 0x84DA,
    0x3635, 0x69B2, 0x8DA6, 0xEE8C, 0x89A9, 0x7468, 0x6DB9, 0x87C1,
    0xEE91, 0x74E7, 0x3DDB, 0x7176, 0x60A4, 0x619C, 0x3CD1, 0x7162,
    0x6077, 0xEE9A, 0x7F71, 0xEE9C, 0x7250, 0x60E9, 0x4B7E, 0x5220,
    0x3C18, 0xEEA2, 0xEEA3, 0xEEA4, 0xEEA5, 0xEEA6, 0xEEA7, 0xEEA8,
    0xEEA9, 0xEEAA, 0x5CC1, 0xEEAC, 0xEEAD, 0xEEAE, 0xEEAF, 0xEEB0,
    0xEEB1, 0x4562, 0x5B1F, 0xEEB4, 0x9F50, 0x9EA6, 0xEEB7,
    /* Big5-HKSCS 0xA140 .. 0xA17E */
    0x3000, 0xFF0C, 0x3001, 0x3002, 0xFF0E, 0x2027, 0xFF1B, 0xFF1A,
    0xFF1F, 0xFF01, 0xFE30, 0x2026, 0x2025, 0xFE50, 0xFE51, 0xFE52,
    0x00B7, 0xFE54, 0xFE55, 0xFE56, 0xFE57, 0xFF5C, 0x2013, 0xFE31,
    0x2014, 0xFE33, 0x2574, 0xFE34, 0xFE4F, 0xFF08, 0xFF09, 0xFE35,
    0xFE36, 0xFF5B, 0xFF5D, 0xFE37, 0xFE38, 0x3014, 0x3015, 0xFE39,
    0xFE3A, 0x3010, 0x3011, 0xFE3B, 0xFE3C, 0x300A, 0x300B, 0xFE3D,
    0xFE3E, 0x3008, 0x3009, 0xFE3F, 0xFE40, 0x300C, 0x300D, 0xFE41,
    0xFE42, 0x300E, 0x300F, 0xFE43, 0xFE44, 0xFE59, 0xFE5A,
    /* Big5-HKSCS 0xA1A1 .. 0xA1FE */
            0xFE5B, 0xFE5C, 0xFE5D, 0xFE5E, 0x2018, 0x2019, 0x201C,
    0x201D, 0x301D, 0x301E, 0x2035, 0x2032, 0xFF03, 0xFF06, 0xFF0A,
    0x203B, 0x00A7, 0x3003, 0x25CB, 0x25CF, 0x25B3, 0x25B2, 0x25CE,
    0x2606, 0x2605, 0x25C7, 0x25C6, 0x25A1, 0x25A0, 0x25BD, 0x25BC,
    0x32A3, 0x2105, 0x00AF, 0xFFE3, 0xFF3F, 0x02CD, 0xFE49, 0xFE4A,
    0xFE4D, 0xFE4E, 0xFE4B, 0xFE4C, 0xFE5F, 0xFE60, 0xFE61, 0xFF0B,
    0xFF0D, 0x00D7, 0x00F7, 0x00B1, 0x221A, 0xFF1C, 0xFF1E, 0xFF1D,
    0x2266, 0x2267, 0x2260, 0x221E, 0x2252, 0x2261, 0xFE62, 0xFE63,
    0xFE64, 0xFE65, 0xFE66, 0xFF5E, 0x2229, 0x222A, 0x22A5, 0x2220,
    0x221F, 0x22BF, 0x33D2, 0x33D1, 0x222B, 0x222E, 0x2235, 0x2234,
    0x2640, 0x2642, 0x2295, 0x2299, 0x2191, 0x2193, 0x2190, 0x2192,
    0x2196, 0x2197, 0x2199, 0x2198, 0x2225, 0x2223, 0xFF0F,
    /* Big5-HKSCS 0xA240 .. 0xA27E */
    0xFF3C, 0x2215, 0xFE68, 0xFF04, 0xFFE5, 0x3012, 0xFFE0, 0xFFE1,
    0xFF05, 0xFF20, 0x2103, 0x2109, 0xFE69, 0xFE6A, 0xFE6B, 0x33D5,
    0x339C, 0x339D, 0x339E, 0x33CE, 0x33A1, 0x338E, 0x338F, 0x33C4,
    0x00B0, 0x5159, 0x515B, 0x515E, 0x515D, 0x5161, 0x5163, 0x55E7,
    0x74E9, 0x7CCE, 0x2581, 0x2582, 0x2583, 0x2584, 0x2585, 0x2586,
    0x2587, 0x2588, 0x258F, 0x258E, 0x258D, 0x258C, 0x258B, 0x258A,
    0x2589, 0x253C, 0x2534, 0x252C, 0x2524, 0x251C, 0x2594, 0x2500,
    0x2502, 0x2595, 0x250C, 0x2510, 0x2514, 0x2518, 0x256D,
    /* Big5-HKSCS 0xA2A1 .. 0xA2FE */
            0x256E, 0x2570, 0x256F, 0x2550, 0x255E, 0x256A, 0x2561,
    0x25E2, 0x25E3, 0x25E5, 0x25E4, 0x2571, 0x2572, 0x2573, 0xFF10,
    0xFF11, 0xFF12, 0xFF13, 0xFF14, 0xFF15, 0xFF16, 0xFF17, 0xFF18,
    0xFF19, 0x2160, 0x2161, 0x2162, 0x2163, 0x2164, 0x2165, 0x2166,
    0x2167, 0x2168, 0x2169, 0x3021, 0x3022, 0x3023, 0x3024, 0x3025,
    0x3026, 0x3027, 0x3028, 0x3029, 0x5341, 0x5344, 0x5345, 0xFF21,
    0xFF22, 0xFF23, 0xFF24, 0xFF25, 0xFF26, 0xFF27, 0xFF28, 0xFF29,
    0xFF2A, 0xFF2B, 0xFF2C, 0xFF2D, 0xFF2E, 0xFF2F, 0xFF30, 0xFF31,
    0xFF32, 0xFF33, 0xFF34, 0xFF35, 0xFF36, 0xFF37, 0xFF38, 0xFF39,
    0xFF3A, 0xFF41, 0xFF42, 0xFF43, 0xFF44, 0xFF45, 0xFF46, 0xFF47,
    0xFF48, 0xFF49, 0xFF4A, 0xFF4B, 0xFF4C, 0xFF4D, 0xFF4E, 0xFF4F,
    0xFF50, 0xFF51, 0xFF52, 0xFF53, 0xFF54, 0xFF55, 0xFF56,
    /* Big5-HKSCS 0xA340 .. 0xA37E */
    0xFF57, 0xFF58, 0xFF59, 0xFF5A, 0x0391, 0x0392, 0x0393, 0x0394,
    0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 0x039A, 0x039B, 0x039C,
    0x039D, 0x039E, 0x039F, 0x03A0, 0x03A1, 0x03A3, 0x03A4, 0x03A5,
    0x03A6, 0x03A7, 0x03A8, 0x03A9, 0x03B1, 0x03B2, 0x03B3, 0x03B4,
    0x03B5, 0x03B6, 0x03B7, 0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC,
    0x03BD, 0x03BE, 0x03BF, 0x03C0, 0x03C1, 0x03C3, 0x03C4, 0x03C5,
    0x03C6, 0x03C7, 0x03C8, 0x03C9, 0x3105, 0x3106, 0x3107, 0x3108,
    0x3109, 0x310A, 0x310B, 0x310C, 0x310D, 0x310E, 0x310F,
    /* Big5-HKSCS 0xA3A1 .. 0xA3FE */
            0x3110, 0x3111, 0x3112, 0x3113, 0x3114, 0x3115, 0x3116,
    0x3117, 0x3118, 0x3119, 0x311A, 0x311B, 0x311C, 0x311D, 0x311E,
    0x311F, 0x3120, 0x3121, 0x3122, 0x3123, 0x3124, 0x3125, 0x3126,
    0x3127, 0x3128, 0x3129, 0x02D9, 0x02C9, 0x02CA, 0x02C7, 0x02CB,
    0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD,
    0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD,
    0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD,
    0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD,
    0xFFFD, 0x20AC, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD,
    0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD,
    0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD,
    0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD,
    /* Big5-HKSCS 0xA440 .. 0xA47E */
    0x4E00, 0x4E59, 0x4E01, 0x4E03, 0x4E43, 0x4E5D, 0x4E86, 0x4E8C,
    0x4EBA, 0x513F, 0x5165, 0x516B, 0x51E0, 0x5200, 0x5201, 0x529B,
    0x5315, 0x5341, 0x535C, 0x53C8, 0x4E09, 0x4E0B, 0x4E08, 0x4E0A,
    0x4E2B, 0x4E38, 0x51E1, 0x4E45, 0x4E48, 0x4E5F, 0x4E5E, 0x4E8E,
    0x4EA1, 0x5140, 0x5203, 0x52FA, 0x5343, 0x53C9, 0x53E3, 0x571F,
    0x58EB, 0x5915, 0x5927, 0x5973, 0x5B50, 0x5B51, 0x5B53, 0x5BF8,
    0x5C0F, 0x5C22, 0x5C38, 0x5C71, 0x5DDD, 0x5DE5, 0x5DF1, 0x5DF2,
    0x5DF3, 0x5DFE, 0x5E72, 0x5EFE, 0x5F0B, 0x5F13, 0x624D,
    /* Big5-HKSCS 0xA4A1 .. 0xA4FE */
            0x4E11, 0x4E10, 0x4E0D, 0x4E2D, 0x4E30, 0x4E39, 0x4E4B,
    0x5C39, 0x4E88, 0x4E91, 0x4E95, 0x4E92, 0x4E94, 0x4EA2, 0x4EC1,
    0x4EC0, 0x4EC3, 0x4EC6, 0x4EC7, 0x4ECD, 0x4ECA, 0x4ECB, 0x4EC4,
    0x5143, 0x5141, 0x5167, 0x516D, 0x516E, 0x516C, 0x5197, 0x51F6,
    0x5206, 0x5207, 0x5208, 0x52FB, 0x52FE, 0x52FF, 0x5316, 0x5339,
    0x5348, 0x5347, 0x5345, 0x535E, 0x5384, 0x53CB, 0x53CA, 0x53CD,
    0x58EC, 0x5929, 0x592B, 0x592A, 0x592D, 0x5B54, 0x5C11, 0x5C24,
    0x5C3A, 0x5C6F, 0x5DF4, 0x5E7B, 0x5EFF, 0x5F14, 0x5F15, 0x5FC3,
    0x6208, 0x6236, 0x624B, 0x624E, 0x652F, 0x6587, 0x6597, 0x65A4,
    0x65B9, 0x65E5, 0x66F0, 0x6708, 0x6728, 0x6B20, 0x6B62, 0x6B79,
    0x6BCB, 0x6BD4, 0x6BDB, 0x6C0F, 0x6C34, 0x706B, 0x722A, 0x7236,
    0x723B, 0x7247, 0x7259, 0x725B, 0x72AC, 0x738B, 0x4E19,
    /* Big5-HKSCS 0xA540 .. 0xA57E */
    0x4E16, 0x4E15, 0x4E14, 0x4E18, 0x4E3B, 0x4E4D, 0x4E4F, 0x4E4E,
    0x4EE5, 0x4ED8, 0x4ED4, 0x4ED5, 0x4ED6, 0x4ED7, 0x4EE3, 0x4EE4,
    0x4ED9, 0x4EDE, 0x5145, 0x5144, 0x5189, 0x518A, 0x51AC, 0x51F9,
    0x51FA, 0x51F8, 0x520A, 0x52A0, 0x529F, 0x5305, 0x5306, 0x5317,
    0x531D, 0x4EDF, 0x534A, 0x5349, 0x5361, 0x5360, 0x536F, 0x536E,
    0x53BB, 0x53EF, 0x53E4, 0x53F3, 0x53EC, 0x53EE, 0x53E9, 0x53E8,
    0x53FC, 0x53F8, 0x53F5, 0x53EB, 0x53E6, 0x53EA, 0x53F2, 0x53F1,
    0x53F0, 0x53E5, 0x53ED, 0x53FB, 0x56DB, 0x56DA, 0x5916,
    /* Big5-HKSCS 0xA5A1 .. 0xA5FE */
            0x592E, 0x5931, 0x5974, 0x5976, 0x5B55, 0x5B83, 0x5C3C,
    0x5DE8, 0x5DE7, 0x5DE6, 0x5E02, 0x5E03, 0x5E73, 0x5E7C, 0x5F01,
    0x5F18, 0x5F17, 0x5FC5, 0x620A, 0x6253, 0x6254, 0x6252, 0x6251,
    0x65A5, 0x65E6, 0x672E, 0x672C, 0x672A, 0x672B, 0x672D, 0x6B63,
    0x6BCD, 0x6C11, 0x6C10, 0x6C38, 0x6C41, 0x6C40, 0x6C3E, 0x72AF,
    0x7384, 0x7389, 0x74DC, 0x74E6, 0x7518, 0x751F, 0x7528, 0x7529,
    0x7530, 0x7531, 0x7532, 0x7533, 0x758B, 0x767D, 0x76AE, 0x76BF,
    0x76EE, 0x77DB, 0x77E2, 0x77F3, 0x793A, 0x79BE, 0x7A74, 0x7ACB,
    0x4E1E, 0x4E1F, 0x4E52, 0x4E53, 0x4E69, 0x4E99, 0x4EA4, 0x4EA6,
    0x4EA5, 0x4EFF, 0x4F09, 0x4F19, 0x4F0A, 0x4F15, 0x4F0D, 0x4F10,
    0x4F11, 0x4F0F, 0x4EF2, 0x4EF6, 0x4EFB, 0x4EF0, 0x4EF3, 0x4EFD,
    0x4F01, 0x4F0B, 0x5149, 0x5147, 0x5146, 0x5148, 0x5168,
    /* Big5-HKSCS 0xA640 .. 0xA67E */
    0x5171, 0x518D, 0x51B0, 0x5217, 0x5211, 0x5212, 0x520E, 0x5216,
    0x52A3, 0x5308, 0x5321, 0x5320, 0x5370, 0x5371, 0x5409, 0x540F,
    0x540C, 0x540A, 0x5410, 0x5401, 0x540B, 0x5404, 0x5411, 0x540D,
    0x5408, 0x5403, 0x540E, 0x5406, 0x5412, 0x56E0, 0x56DE, 0x56DD,
    0x5733, 0x5730, 0x5728, 0x572D, 0x572C, 0x572F, 0x5729, 0x5919,
    0x591A, 0x5937, 0x5938, 0x5984, 0x5978, 0x5983, 0x597D, 0x5979,
    0x5982, 0x5981, 0x5B57, 0x5B58, 0x5B87, 0x5B88, 0x5B85, 0x5B89,
    0x5BFA, 0x5C16, 0x5C79, 0x5DDE, 0x5E06, 0x5E76, 0x5E74,
    /* Big5-HKSCS 0xA6A1 .. 0xA6FE */
            0x5F0F, 0x5F1B, 0x5FD9, 0x5FD6, 0x620E, 0x620C, 0x620D,
    0x6210, 0x6263, 0x625B, 0x6258, 0x6536, 0x65E9, 0x65E8, 0x65EC,
    0x65ED, 0x66F2, 0x66F3, 0x6709, 0x673D, 0x6734, 0x6731, 0x6735,
    0x6B21, 0x6B64, 0x6B7B, 0x6C16, 0x6C5D, 0x6C57, 0x6C59, 0x6C5F,
    0x6C60, 0x6C50, 0x6C55, 0x6C61, 0x6C5B, 0x6C4D, 0x6C4E, 0x7070,
    0x725F, 0x725D, 0x767E, 0x7AF9, 0x7C73, 0x7CF8, 0x7F36, 0x7F8A,
    0x7FBD, 0x8001, 0x8003, 0x800C, 0x8012, 0x8033, 0x807F, 0x8089,
    0x808B, 0x808C, 0x81E3, 0x81EA, 0x81F3, 0x81FC, 0x820C, 0x821B,
    0x821F, 0x826E, 0x8272, 0x827E, 0x866B, 0x8840, 0x884C, 0x8863,
    0x897F, 0x9621, 0x4E32, 0x4EA8, 0x4F4D, 0x4F4F, 0x4F47, 0x4F57,
    0x4F5E, 0x4F34, 0x4F5B, 0x4F55, 0x4F30, 0x4F50, 0x4F51, 0x4F3D,
    0x4F3A, 0x4F38, 0x4F43, 0x4F54, 0x4F3C, 0x4F46, 0x4F63,
    /* Big5-HKSCS 0xA740 .. 0xA77E */
    0x4F5C, 0x4F60, 0x4F2F, 0x4F4E, 0x4F36, 0x4F59, 0x4F5D, 0x4F48,
    0x4F5A, 0x514C, 0x514B, 0x514D, 0x5175, 0x51B6, 0x51B7, 0x5225,
    0x5224, 0x5229, 0x522A, 0x5228, 0x52AB, 0x52A9, 0x52AA, 0x52AC,
    0x5323, 0x5373, 0x5375, 0x541D, 0x542D, 0x541E, 0x543E, 0x5426,
    0x544E, 0x5427, 0x5446, 0x5443, 0x5433, 0x5448, 0x5442, 0x541B,
    0x5429, 0x544A, 0x5439, 0x543B, 0x5438, 0x542E, 0x5435, 0x5436,
    0x5420, 0x543C, 0x5440, 0x5431, 0x542B, 0x541F, 0x542C, 0x56EA,
    0x56F0, 0x56E4, 0x56EB, 0x574A, 0x5751, 0x5740, 0x574D,
    /* Big5-HKSCS 0xA7A1 .. 0xA7FE */
            0x5747, 0x574E, 0x573E, 0x5750, 0x574F, 0x573B, 0x58EF,
    0x593E, 0x599D, 0x5992, 0x59A8, 0x599E, 0x59A3, 0x5999, 0x5996,
    0x598D, 0x59A4, 0x5993, 0x598A, 0x59A5, 0x5B5D, 0x5B5C, 0x5B5A,
    0x5B5B, 0x5B8C, 0x5B8B, 0x5B8F, 0x5C2C, 0x5C40, 0x5C41, 0x5C3F,
    0x5C3E, 0x5C90, 0x5C91, 0x5C94, 0x5C8C, 0x5DEB, 0x5E0C, 0x5E8F,
    0x5E87, 0x5E8A, 0x5EF7, 0x5F04, 0x5F1F, 0x5F64, 0x5F62, 0x5F77,
    0x5F79, 0x5FD8, 0x5FCC, 0x5FD7, 0x5FCD, 0x5FF1, 0x5FEB, 0x5FF8,
    0x5FEA, 0x6212, 0x6211, 0x6284, 0x6297, 0x6296, 0x6280, 0x6276,
    0x6289, 0x626D, 0x628A, 0x627C, 0x627E, 0x6279, 0x6273, 0x6292,
    0x626F, 0x6298, 0x626E, 0x6295, 0x6293, 0x6291, 0x6286, 0x6539,
    0x653B, 0x6538, 0x65F1, 0x66F4, 0x675F, 0x674E, 0x674F, 0x6750,
    0x6751, 0x675C, 0x6756, 0x675E, 0x6749, 0x6746, 0x6760,
    /* Big5-HKSCS 0xA840 .. 0xA87E */
    0x6753, 0x6757, 0x6B65, 0x6BCF, 0x6C42, 0x6C5E, 0x6C99, 0x6C81,
    0x6C88, 0x6C89, 0x6C85, 0x6C9B, 0x6C6A, 0x6C7A, 0x6C90, 0x6C70,
    0x6C8C, 0x6C68, 0x6C96, 0x6C92, 0x6C7D, 0x6C83, 0x6C72, 0x6C7E,
    0x6C74, 0x6C86, 0x6C76, 0x6C8D, 0x6C94, 0x6C98, 0x6C82, 0x7076,
    0x707C, 0x707D, 0x7078, 0x7262, 0x7261, 0x7260, 0x72C4, 0x72C2,
    0x7396, 0x752C, 0x752B, 0x7537, 0x7538, 0x7682, 0x76EF, 0x77E3,
    0x79C1, 0x79C0, 0x79BF, 0x7A76, 0x7CFB, 0x7F55, 0x8096, 0x8093,
    0x809D, 0x8098, 0x809B, 0x809A, 0x80B2, 0x826F, 0x8292,
    /* Big5-HKSCS 0xA8A1 .. 0xA8FE */
            0x828B, 0x828D, 0x898B, 0x89D2, 0x8A00, 0x8C37, 0x8C46,
    0x8C55, 0x8C9D, 0x8D64, 0x8D70, 0x8DB3, 0x8EAB, 0x8ECA, 0x8F9B,
    0x8FB0, 0x8FC2, 0x8FC6, 0x8FC5, 0x8FC4, 0x5DE1, 0x9091, 0x90A2,
    0x90AA, 0x90A6, 0x90A3, 0x9149, 0x91C6, 0x91CC, 0x9632, 0x962E,
    0x9631, 0x962A, 0x962C, 0x4E26, 0x4E56, 0x4E73, 0x4E8B, 0x4E9B,
    0x4E9E, 0x4EAB, 0x4EAC, 0x4F6F, 0x4F9D, 0x4F8D, 0x4F73, 0x4F7F,
    0x4F6C, 0x4F9B, 0x4F8B, 0x4F86, 0x4F83, 0x4F70, 0x4F75, 0x4F88,
    0x4F69, 0x4F7B, 0x4F96, 0x4F7E, 0x4F8F, 0x4F91, 0x4F7A, 0x5154,
    0x5152, 0x5155, 0x5169, 0x5177, 0x5176, 0x5178, 0x51BD, 0x51FD,
    0x523B, 0x5238, 0x5237, 0x523A, 0x5230, 0x522E, 0x5236, 0x5241,
    0x52BE, 0x52BB, 0x5352, 0x5354, 0x5353, 0x5351, 0x5366, 0x5377,
    0x5378, 0x5379, 0x53D6, 0x53D4, 0x53D7, 0x5473, 0x5475,
    /* Big5-HKSCS 0xA940 .. 0xA97E */
    0x5496, 0x5478, 0x5495, 0x5480, 0x547B, 0x5477, 0x5484, 0x5492,
    0x5486, 0x547C, 0x5490, 0x5471, 0x5476, 0x548C, 0x549A, 0x5462,
    0x5468, 0x548B, 0x547D, 0x548E, 0x56FA, 0x5783, 0x5777, 0x576A,
    0x5769, 0x5761, 0x5766, 0x5764, 0x577C, 0x591C, 0x5949, 0x5947,
    0x5948, 0x5944, 0x5954, 0x59BE, 0x59BB, 0x59D4, 0x59B9, 0x59AE,
    0x59D1, 0x59C6, 0x59D0, 0x59CD, 0x59CB, 0x59D3, 0x59CA, 0x59AF,
    0x59B3, 0x59D2, 0x59C5, 0x5B5F, 0x5B64, 0x5B63, 0x5B97, 0x5B9A,
    0x5B98, 0x5B9C, 0x5B99, 0x5B9B, 0x5C1A, 0x5C48, 0x5C45,
    /* Big5-HKSCS 0xA9A1 .. 0xA9FE */
            0x5C46, 0x5CB7, 0x5CA1, 0x5CB8, 0x5CA9, 0x5CAB, 0x5CB1,
    0x5CB3, 0x5E18, 0x5E1A, 0x5E16, 0x5E15, 0x5E1B, 0x5E11, 0x5E78,
    0x5E9A, 0x5E97, 0x5E9C, 0x5E95, 0x5E96, 0x5EF6, 0x5F26, 0x5F27,
    0x5F29, 0x5F80, 0x5F81, 0x5F7F, 0x5F7C, 0x5FDD, 0x5FE0, 0x5FFD,
    0x5FF5, 0x5FFF, 0x600F, 0x6014, 0x602F, 0x6035, 0x6016, 0x602A,
    0x6015, 0x6021, 0x6027, 0x6029, 0x602B, 0x601B, 0x6216, 0x6215,
    0x623F, 0x623E, 0x6240, 0x627F, 0x62C9, 0x62CC, 0x62C4, 0x62BF,
    0x62C2, 0x62B9, 0x62D2, 0x62DB, 0x62AB, 0x62D3, 0x62D4, 0x62CB,
    0x62C8, 0x62A8, 0x62BD, 0x62BC, 0x62D0, 0x62D9, 0x62C7, 0x62CD,
    0x62B5, 0x62DA, 0x62B1, 0x62D8, 0x62D6, 0x62D7, 0x62C6, 0x62AC,
    0x62CE, 0x653E, 0x65A7, 0x65BC, 0x65FA, 0x6614, 0x6613, 0x660C,
    0x6606, 0x6602, 0x660E, 0x6600, 0x660F, 0x6615, 0x660A,
    /* Big5-HKSCS 0xAA40 .. 0xAA7E */
    0x6607, 0x670D, 0x670B, 0x676D, 0x678B, 0x6795, 0x6771, 0x679C,
    0x6773, 0x6777, 0x6787, 0x679D, 0x6797, 0x676F, 0x6770, 0x677F,
    0x6789, 0x677E, 0x6790, 0x6775, 0x679A, 0x6793, 0x677C, 0x676A,
    0x6772, 0x6B23, 0x6B66, 0x6B67, 0x6B7F, 0x6C13, 0x6C1B, 0x6CE3,
    0x6CE8, 0x6CF3, 0x6CB1, 0x6CCC, 0x6CE5, 0x6CB3, 0x6CBD, 0x6CBE,
    0x6CBC, 0x6CE2, 0x6CAB, 0x6CD5, 0x6CD3, 0x6CB8, 0x6CC4, 0x6CB9,
    0x6CC1, 0x6CAE, 0x6CD7, 0x6CC5, 0x6CF1, 0x6CBF, 0x6CBB, 0x6CE1,
    0x6CDB, 0x6CCA, 0x6CAC, 0x6CEF, 0x6CDC, 0x6CD6, 0x6CE0,
    /* Big5-HKSCS 0xAAA1 .. 0xAAFE */
            0x7095, 0x708E, 0x7092, 0x708A, 0x7099, 0x722C, 0x722D,
    0x7238, 0x7248, 0x7267, 0x7269, 0x72C0, 0x72CE, 0x72D9, 0x72D7,
    0x72D0, 0x73A9, 0x73A8, 0x739F, 0x73AB, 0x73A5, 0x753D, 0x759D,
    0x7599, 0x759A, 0x7684, 0x76C2, 0x76F2, 0x76F4, 0x77E5, 0x77FD,
    0x793E, 0x7940, 0x7941, 0x79C9, 0x79C8, 0x7A7A, 0x7A79, 0x7AFA,
    0x7CFE, 0x7F54, 0x7F8C, 0x7F8B, 0x8005, 0x80BA, 0x80A5, 0x80A2,
    0x80B1, 0x80A1, 0x80AB, 0x80A9, 0x80B4, 0x80AA, 0x80AF, 0x81E5,
    0x81FE, 0x820D, 0x82B3, 0x829D, 0x8299, 0x82AD, 0x82BD, 0x829F,
    0x82B9, 0x82B1, 0x82AC, 0x82A5, 0x82AF, 0x82B8, 0x82A3, 0x82B0,
    0x82BE, 0x82B7, 0x864E, 0x8671, 0x521D, 0x8868, 0x8ECB, 0x8FCE,
    0x8FD4, 0x8FD1, 0x90B5, 0x90B8, 0x90B1, 0x90B6, 0x91C7, 0x91D1,
    0x9577, 0x9580, 0x961C, 0x9640, 0x963F, 0x963B, 0x9644,
    /* Big5-HKSCS 0xAB40 .. 0xAB7E */
    0x9642, 0x96B9, 0x96E8, 0x9752, 0x975E, 0x4E9F, 0x4EAD, 0x4EAE,
    0x4FE1, 0x4FB5, 0x4FAF, 0x4FBF, 0x4FE0, 0x4FD1, 0x4FCF, 0x4FDD,
    0x4FC3, 0x4FB6, 0x4FD8, 0x4FDF, 0x4FCA, 0x4FD7, 0x4FAE, 0x4FD0,
    0x4FC4, 0x4FC2, 0x4FDA, 0x4FCE, 0x4FDE, 0x4FB7, 0x5157, 0x5192,
    0x5191, 0x51A0, 0x524E, 0x5243, 0x524A, 0x524D, 0x524C, 0x524B,
    0x5247, 0x52C7, 0x52C9, 0x52C3, 0x52C1, 0x530D, 0x5357, 0x537B,
    0x539A, 0x53DB, 0x54AC, 0x54C0, 0x54A8, 0x54CE, 0x54C9, 0x54B8,
    0x54A6, 0x54B3, 0x54C7, 0x54C2, 0x54BD, 0x54AA, 0x54C1,
    /* Big5-HKSCS 0xABA1 .. 0xABFE */
            0x54C4, 0x54C8, 0x54AF, 0x54AB, 0x54B1, 0x54BB, 0x54A9,
    0x54A7, 0x54BF, 0x56FF, 0x5782, 0x578B, 0x57A0, 0x57A3, 0x57A2,
    0x57CE, 0x57AE, 0x5793, 0x5955, 0x5951, 0x594F, 0x594E, 0x5950,
    0x59DC, 0x59D8, 0x59FF, 0x59E3, 0x59E8, 0x5A03, 0x59E5, 0x59EA,
    0x59DA, 0x59E6, 0x5A01, 0x59FB, 0x5B69, 0x5BA3, 0x5BA6, 0x5BA4,
    0x5BA2, 0x5BA5, 0x5C01, 0x5C4E, 0x5C4F, 0x5C4D, 0x5C4B, 0x5CD9,
    0x5CD2, 0x5DF7, 0x5E1D, 0x5E25, 0x5E1F, 0x5E7D, 0x5EA0, 0x5EA6,
    0x5EFA, 0x5F08, 0x5F2D, 0x5F65, 0x5F88, 0x5F85, 0x5F8A, 0x5F8B,
    0x5F87, 0x5F8C, 0x5F89, 0x6012, 0x601D, 0x6020, 0x6025, 0x600E,
    0x6028, 0x604D, 0x6070, 0x6068, 0x6062, 0x6046, 0x6043, 0x606C,
    0x606B, 0x606A, 0x6064, 0x6241, 0x62DC, 0x6316, 0x6309, 0x62FC,
    0x62ED, 0x6301, 0x62EE, 0x62FD, 0x6307, 0x62F1, 0x62F7,
    /* Big5-HKSCS 0xAC40 .. 0xAC7E */
    0x62EF, 0x62EC, 0x62FE, 0x62F4, 0x6311, 0x6302, 0x653F, 0x6545,
    0x65AB, 0x65BD, 0x65E2, 0x6625, 0x662D, 0x6620, 0x6627, 0x662F,
    0x661F, 0x6628, 0x6631, 0x6624, 0x66F7, 0x67FF, 0x67D3, 0x67F1,
    0x67D4, 0x67D0, 0x67EC, 0x67B6, 0x67AF, 0x67F5, 0x67E9, 0x67EF,
    0x67C4, 0x67D1, 0x67B4, 0x67DA, 0x67E5, 0x67B8, 0x67CF, 0x67DE,
    0x67F3, 0x67B0, 0x67D9, 0x67E2, 0x67DD, 0x67D2, 0x6B6A, 0x6B83,
    0x6B86, 0x6BB5, 0x6BD2, 0x6BD7, 0x6C1F, 0x6CC9, 0x6D0B, 0x6D32,
    0x6D2A, 0x6D41, 0x6D25, 0x6D0C, 0x6D31, 0x6D1E, 0x6D17,
    /* Big5-HKSCS 0xACA1 .. 0xACFE */
            0x6D3B, 0x6D3D, 0x6D3E, 0x6D36, 0x6D1B, 0x6CF5, 0x6D39,
    0x6D27, 0x6D38, 0x6D29, 0x6D2E, 0x6D35, 0x6D0E, 0x6D2B, 0x70AB,
    0x70BA, 0x70B3, 0x70AC, 0x70AF, 0x70AD, 0x70B8, 0x70AE, 0x70A4,
    0x7230, 0x7272, 0x726F, 0x7274, 0x72E9, 0x72E0, 0x72E1, 0x73B7,
    0x73CA, 0x73BB, 0x73B2, 0x73CD, 0x73C0, 0x73B3, 0x751A, 0x752D,
    0x754F, 0x754C, 0x754E, 0x754B, 0x75AB, 0x75A4, 0x75A5, 0x75A2,
    0x75A3, 0x7678, 0x7686, 0x7687, 0x7688, 0x76C8, 0x76C6, 0x76C3,
    0x76C5, 0x7701, 0x76F9, 0x76F8, 0x7709, 0x770B, 0x76FE, 0x76FC,
    0x7707, 0x77DC, 0x7802, 0x7814, 0x780C, 0x780D, 0x7946, 0x7949,
    0x7948, 0x7947, 0x79B9, 0x79BA, 0x79D1, 0x79D2, 0x79CB, 0x7A7F,
    0x7A81, 0x7AFF, 0x7AFD, 0x7C7D, 0x7D02, 0x7D05, 0x7D00, 0x7D09,
    0x7D07, 0x7D04, 0x7D06, 0x7F38, 0x7F8E, 0x7FBF, 0x8004,
    /* Big5-HKSCS 0xAD40 .. 0xAD7E */
    0x8010, 0x800D, 0x8011, 0x8036, 0x80D6, 0x80E5, 0x80DA, 0x80C3,
    0x80C4, 0x80CC, 0x80E1, 0x80DB, 0x80CE, 0x80DE, 0x80E4, 0x80DD,
    0x81F4, 0x8222, 0x82E7, 0x8303, 0x8305, 0x82E3, 0x82DB, 0x82E6,
    0x8304, 0x82E5, 0x8302, 0x8309, 0x82D2, 0x82D7, 0x82F1, 0x8301,
    0x82DC, 0x82D4, 0x82D1, 0x82DE, 0x82D3, 0x82DF, 0x82EF, 0x8306,
    0x8650, 0x8679, 0x867B, 0x867A, 0x884D, 0x886B, 0x8981, 0x89D4,
    0x8A08, 0x8A02, 0x8A03, 0x8C9E, 0x8CA0, 0x8D74, 0x8D73, 0x8DB4,
    0x8ECD, 0x8ECC, 0x8FF0, 0x8FE6, 0x8FE2, 0x8FEA, 0x8FE5,
    /* Big5-HKSCS 0xADA1 .. 0xADFE */
            0x8FED, 0x8FEB, 0x8FE4, 0x8FE8, 0x90CA, 0x90CE, 0x90C1,
    0x90C3, 0x914B, 0x914A, 0x91CD, 0x9582, 0x9650, 0x964B, 0x964C,
    0x964D, 0x9762, 0x9769, 0x97CB, 0x97ED, 0x97F3, 0x9801, 0x98A8,
    0x98DB, 0x98DF, 0x9996, 0x9999, 0x4E58, 0x4EB3, 0x500C, 0x500D,
    0x5023, 0x4FEF, 0x5026, 0x5025, 0x4FF8, 0x5029, 0x5016, 0x5006,
    0x503C, 0x501F, 0x501A, 0x5012, 0x5011, 0x4FFA, 0x5000, 0x5014,
    0x5028, 0x4FF1, 0x5021, 0x500B, 0x5019, 0x5018, 0x4FF3, 0x4FEE,
    0x502D, 0x502A, 0x4FFE, 0x502B, 0x5009, 0x517C, 0x51A4, 0x51A5,
    0x51A2, 0x51CD, 0x51CC, 0x51C6, 0x51CB, 0x5256, 0x525C, 0x5254,
    0x525B, 0x525D, 0x532A, 0x537F, 0x539F, 0x539D, 0x53DF, 0x54E8,
    0x5510, 0x5501, 0x5537, 0x54FC, 0x54E5, 0x54F2, 0x5506, 0x54FA,
    0x5514, 0x54E9, 0x54ED, 0x54E1, 0x5509, 0x54EE, 0x54EA,
    /* Big5-HKSCS 0xAE40 .. 0xAE7E */
    0x54E6, 0x5527, 0x5507, 0x54FD, 0x550F, 0x5703, 0x5704, 0x57C2,
    0x57D4, 0x57CB, 0x57C3, 0x5809, 0x590F, 0x5957, 0x5958, 0x595A,
    0x5A11, 0x5A18, 0x5A1C, 0x5A1F, 0x5A1B, 0x5A13, 0x59EC, 0x5A20,
    0x5A23, 0x5A29, 0x5A25, 0x5A0C, 0x5A09, 0x5B6B, 0x5C58, 0x5BB0,
    0x5BB3, 0x5BB6, 0x5BB4, 0x5BAE, 0x5BB5, 0x5BB9, 0x5BB8, 0x5C04,
    0x5C51, 0x5C55, 0x5C50, 0x5CED, 0x5CFD, 0x5CFB, 0x5CEA, 0x5CE8,
    0x5CF0, 0x5CF6, 0x5D01, 0x5CF4, 0x5DEE, 0x5E2D, 0x5E2B, 0x5EAB,
    0x5EAD, 0x5EA7, 0x5F31, 0x5F92, 0x5F91, 0x5F90, 0x6059,
    /* Big5-HKSCS 0xAEA1 .. 0xAEFE */
            0x6063, 0x6065, 0x6050, 0x6055, 0x606D, 0x6069, 0x606F,
    0x6084, 0x609F, 0x609A, 0x608D, 0x6094, 0x608C, 0x6085, 0x6096,
    0x6247, 0x62F3, 0x6308, 0x62FF, 0x634E, 0x633E, 0x632F, 0x6355,
    0x6342, 0x6346, 0x634F, 0x6349, 0x633A, 0x6350, 0x633D, 0x632A,
    0x632B, 0x6328, 0x634D, 0x634C, 0x6548, 0x6549, 0x6599, 0x65C1,
    0x65C5, 0x6642, 0x6649, 0x664F, 0x6643, 0x6652, 0x664C, 0x6645,
    0x6641, 0x66F8, 0x6714, 0x6715, 0x6717, 0x6821, 0x6838, 0x6848,
    0x6846, 0x6853, 0x6839, 0x6842, 0x6854, 0x6829, 0x68B3, 0x6817,
    0x684C, 0x6851, 0x683D, 0x67F4, 0x6850, 0x6840, 0x683C, 0x6843,
    0x682A, 0x6845, 0x6813, 0x6818, 0x6841, 0x6B8A, 0x6B89, 0x6BB7,
    0x6C23, 0x6C27, 0x6C28, 0x6C26, 0x6C24, 0x6CF0, 0x6D6A, 0x6D95,
    0x6D88, 0x6D87, 0x6D66, 0x6D78, 0x6D77, 0x6D59, 0x6D93,
    /* Big5-HKSCS 0xAF40 .. 0xAF7E */
    0x6D6C, 0x6D89, 0x6D6E, 0x6D5A, 0x6D74, 0x6D69, 0x6D8C, 0x6D8A,
    0x6D79, 0x6D85, 0x6D65, 0x6D94, 0x70CA, 0x70D8, 0x70E4, 0x70D9,
    0x70C8, 0x70CF, 0x7239, 0x7279, 0x72FC, 0x72F9, 0x72FD, 0x72F8,
    0x72F7, 0x7386, 0x73ED, 0x7409, 0x73EE, 0x73E0, 0x73EA, 0x73DE,
    0x7554, 0x755D, 0x755C, 0x755A, 0x7559, 0x75BE, 0x75C5, 0x75C7,
    0x75B2, 0x75B3, 0x75BD, 0x75BC, 0x75B9, 0x75C2, 0x75B8, 0x768B,
    0x76B0, 0x76CA, 0x76CD, 0x76CE, 0x7729, 0x771F, 0x7720, 0x7728,
    0x77E9, 0x7830, 0x7827, 0x7838, 0x781D, 0x7834, 0x7837,
    /* Big5-HKSCS 0xAFA1 .. 0xAFFE */
            0x7825, 0x782D, 0x7820, 0x781F, 0x7832, 0x7955, 0x7950,
    0x7960, 0x795F, 0x7956, 0x795E, 0x795D, 0x7957, 0x795A, 0x79E4,
    0x79E3, 0x79E7, 0x79DF, 0x79E6, 0x79E9, 0x79D8, 0x7A84, 0x7A88,
    0x7AD9, 0x7B06, 0x7B11, 0x7C89, 0x7D21, 0x7D17, 0x7D0B, 0x7D0A,
    0x7D20, 0x7D22, 0x7D14, 0x7D10, 0x7D15, 0x7D1A, 0x7D1C, 0x7D0D,
    0x7D19, 0x7D1B, 0x7F3A, 0x7F5F, 0x7F94, 0x7FC5, 0x7FC1, 0x8006,
    0x8018, 0x8015, 0x8019, 0x8017, 0x803D, 0x803F, 0x80F1, 0x8102,
    0x80F0, 0x8105, 0x80ED, 0x80F4, 0x8106, 0x80F8, 0x80F3, 0x8108,
    0x80FD, 0x810A, 0x80FC, 0x80EF, 0x81ED, 0x81EC, 0x8200, 0x8210,
    0x822A, 0x822B, 0x8228, 0x822C, 0x82BB, 0x832B, 0x8352, 0x8354,
    0x834A, 0x8338, 0x8350, 0x8349, 0x8335, 0x8334, 0x834F, 0x8332,
    0x8339, 0x8336, 0x8317, 0x8340, 0x8331, 0x8328, 0x8343,
    /* Big5-HKSCS 0xB040 .. 0xB07E */
    0x8654, 0x868A, 0x86AA, 0x8693, 0x86A4, 0x86A9, 0x868C, 0x86A3,
    0x869C, 0x8870, 0x8877, 0x8881, 0x8882, 0x887D, 0x8879, 0x8A18,
    0x8A10, 0x8A0E, 0x8A0C, 0x8A15, 0x8A0A, 0x8A17, 0x8A13, 0x8A16,
    0x8A0F, 0x8A11, 0x8C48, 0x8C7A, 0x8C79, 0x8CA1, 0x8CA2, 0x8D77,
    0x8EAC, 0x8ED2, 0x8ED4, 0x8ECF, 0x8FB1, 0x9001, 0x9006, 0x8FF7,
    0x9000, 0x8FFA, 0x8FF4, 0x9003, 0x8FFD, 0x9005, 0x8FF8, 0x9095,
    0x90E1, 0x90DD, 0x90E2, 0x9152, 0x914D, 0x914C, 0x91D8, 0x91DD,
    0x91D7, 0x91DC, 0x91D9, 0x9583, 0x9662, 0x9663, 0x9661,
    /* Big5-HKSCS 0xB0A1 .. 0xB0FE */
            0x965B, 0x965D, 0x9664, 0x9658, 0x965E, 0x96BB, 0x98E2,
    0x99AC, 0x9AA8, 0x9AD8, 0x9B25, 0x9B32, 0x9B3C, 0x4E7E, 0x507A,
    0x507D, 0x505C, 0x5047, 0x5043, 0x504C, 0x505A, 0x5049, 0x5065,
    0x5076, 0x504E, 0x5055, 0x5075, 0x5074, 0x5077, 0x504F, 0x500F,
    0x506F, 0x506D, 0x515C, 0x5195, 0x51F0, 0x526A, 0x526F, 0x52D2,
    0x52D9, 0x52D8, 0x52D5, 0x5310, 0x530F, 0x5319, 0x533F, 0x5340,
    0x533E, 0x53C3, 0x66FC, 0x5546, 0x556A, 0x5566, 0x5544, 0x555E,
    0x5561, 0x5543, 0x554A, 0x5531, 0x5556, 0x554F, 0x5555, 0x552F,
    0x5564, 0x5538, 0x552E, 0x555C, 0x552C, 0x5563, 0x5533, 0x5541,
    0x5557, 0x5708, 0x570B, 0x5709, 0x57DF, 0x5805, 0x580A, 0x5806,
    0x57E0, 0x57E4, 0x57FA, 0x5802, 0x5835, 0x57F7, 0x57F9, 0x5920,
    0x5962, 0x5A36, 0x5A41, 0x5A49, 0x5A66, 0x5A6A, 0x5A40,
    /* Big5-HKSCS 0xB140 .. 0xB17E */
    0x5A3C, 0x5A62, 0x5A5A, 0x5A46, 0x5A4A, 0x5B70, 0x5BC7, 0x5BC5,
    0x5BC4, 0x5BC2, 0x5BBF, 0x5BC6, 0x5C09, 0x5C08, 0x5C07, 0x5C60,
    0x5C5C, 0x5C5D, 0x5D07, 0x5D06, 0x5D0E, 0x5D1B, 0x5D16, 0x5D22,
    0x5D11, 0x5D29, 0x5D14, 0x5D19, 0x5D24, 0x5D27, 0x5D17, 0x5DE2,
    0x5E38, 0x5E36, 0x5E33, 0x5E37, 0x5EB7, 0x5EB8, 0x5EB6, 0x5EB5,
    0x5EBE, 0x5F35, 0x5F37, 0x5F57, 0x5F6C, 0x5F69, 0x5F6B, 0x5F97,
    0x5F99, 0x5F9E, 0x5F98, 0x5FA1, 0x5FA0, 0x5F9C, 0x607F, 0x60A3,
    0x6089, 0x60A0, 0x60A8, 0x60CB, 0x60B4, 0x60E6, 0x60BD,
    /* Big5-HKSCS 0xB1A1 .. 0xB1FE */
            0x60C5, 0x60BB, 0x60B5, 0x60DC, 0x60BC, 0x60D8, 0x60D5,
    0x60C6, 0x60DF, 0x60B8, 0x60DA, 0x60C7, 0x621A, 0x621B, 0x6248,
    0x63A0, 0x63A7, 0x6372, 0x6396, 0x63A2, 0x63A5, 0x6377, 0x6367,
    0x6398, 0x63AA, 0x6371, 0x63A9, 0x6389, 0x6383, 0x639B, 0x636B,
    0x63A8, 0x6384, 0x6388, 0x6399, 0x63A1, 0x63AC, 0x6392, 0x638F,
    0x6380, 0x637B, 0x6369, 0x6368, 0x637A, 0x655D, 0x6556, 0x6551,
    0x6559, 0x6557, 0x555F, 0x654F, 0x6558, 0x6555, 0x6554, 0x659C,
    0x659B, 0x65AC, 0x65CF, 0x65CB, 0x65CC, 0x65CE, 0x665D, 0x665A,
    0x6664, 0x6668, 0x6666, 0x665E, 0x66F9, 0x52D7, 0x671B, 0x6881,
    0x68AF, 0x68A2, 0x6893, 0x68B5, 0x687F, 0x6876, 0x68B1, 0x68A7,
    0x6897, 0x68B0, 0x6883, 0x68C4, 0x68AD, 0x6886, 0x6885, 0x6894,
    0x689D, 0x68A8, 0x689F, 0x68A1, 0x6882, 0x6B32, 0x6BBA,
    /* Big5-HKSCS 0xB240 .. 0xB27E */
    0x6BEB, 0x6BEC, 0x6C2B, 0x6D8E, 0x6DBC, 0x6DF3, 0x6DD9, 0x6DB2,
    0x6DE1, 0x6DCC, 0x6DE4, 0x6DFB, 0x6DFA, 0x6E05, 0x6DC7, 0x6DCB,
    0x6DAF, 0x6DD1, 0x6DAE, 0x6DDE, 0x6DF9, 0x6DB8, 0x6DF7, 0x6DF5,
    0x6DC5, 0x6DD2, 0x6E1A, 0x6DB5, 0x6DDA, 0x6DEB, 0x6DD8, 0x6DEA,
    0x6DF1, 0x6DEE, 0x6DE8, 0x6DC6, 0x6DC4, 0x6DAA, 0x6DEC, 0x6DBF,
    0x6DE6, 0x70F9, 0x7109, 0x710A, 0x70FD, 0x70EF, 0x723D, 0x727D,
    0x7281, 0x731C, 0x731B, 0x7316, 0x7313, 0x7319, 0x7387, 0x7405,
    0x740A, 0x7403, 0x7406, 0x73FE, 0x740D, 0x74E0, 0x74F6,
    /* Big5-HKSCS 0xB2A1 .. 0xB2FE */
            0x74F7, 0x751C, 0x7522, 0x7565, 0x7566, 0x7562, 0x7570,
    0x758F, 0x75D4, 0x75D5, 0x75B5, 0x75CA, 0x75CD, 0x768E, 0x76D4,
    0x76D2, 0x76DB, 0x7737, 0x773E, 0x773C, 0x7736, 0x7738, 0x773A,
    0x786B, 0x7843, 0x784E, 0x7965, 0x7968, 0x796D, 0x79FB, 0x7A92,
    0x7A95, 0x7B20, 0x7B28, 0x7B1B, 0x7B2C, 0x7B26, 0x7B19, 0x7B1E,
    0x7B2E, 0x7C92, 0x7C97, 0x7C95, 0x7D46, 0x7D43, 0x7D71, 0x7D2E,
    0x7D39, 0x7D3C, 0x7D40, 0x7D30, 0x7D33, 0x7D44, 0x7D2F, 0x7D42,
    0x7D32, 0x7D31, 0x7F3D, 0x7F9E, 0x7F9A, 0x7FCC, 0x7FCE, 0x7FD2,
    0x801C, 0x804A, 0x8046, 0x812F, 0x8116, 0x8123, 0x812B, 0x8129,
    0x8130, 0x8124, 0x8202, 0x8235, 0x8237, 0x8236, 0x8239, 0x838E,
    0x839E, 0x8398, 0x8378, 0x83A2, 0x8396, 0x83BD, 0x83AB, 0x8392,
    0x838A, 0x8393, 0x8389, 0x83A0, 0x8377, 0x837B, 0x837C,
    /* Big5-HKSCS 0xB340 .. 0xB37E */
    0x8386, 0x83A7, 0x8655, 0x5F6A, 0x86C7, 0x86C0, 0x86B6, 0x86C4,
    0x86B5, 0x86C6, 0x86CB, 0x86B1, 0x86AF, 0x86C9, 0x8853, 0x889E,
    0x8888, 0x88AB, 0x8892, 0x8896, 0x888D, 0x888B, 0x8993, 0x898F,
    0x8A2A, 0x8A1D, 0x8A23, 0x8A25, 0x8A31, 0x8A2D, 0x8A1F, 0x8A1B,
    0x8A22, 0x8C49, 0x8C5A, 0x8CA9, 0x8CAC, 0x8CAB, 0x8CA8, 0x8CAA,
    0x8CA7, 0x8D67, 0x8D66, 0x8DBE, 0x8DBA, 0x8EDB, 0x8EDF, 0x9019,
    0x900D, 0x901A, 0x9017, 0x9023, 0x901F, 0x901D, 0x9010, 0x9015,
    0x901E, 0x9020, 0x900F, 0x9022, 0x9016, 0x901B, 0x9014,
    /* Big5-HKSCS 0xB3A1 .. 0xB3FE */
            0x90E8, 0x90ED, 0x90FD, 0x9157, 0x91CE, 0x91F5, 0x91E6,
    0x91E3, 0x91E7, 0x91ED, 0x91E9, 0x9589, 0x966A, 0x9675, 0x9673,
    0x9678, 0x9670, 0x9674, 0x9676, 0x9677, 0x966C, 0x96C0, 0x96EA,
    0x96E9, 0x7AE0, 0x7ADF, 0x9802, 0x9803, 0x9B5A, 0x9CE5, 0x9E75,
    0x9E7F, 0x9EA5, 0x9EBB, 0x50A2, 0x508D, 0x5085, 0x5099, 0x5091,
    0x5080, 0x5096, 0x5098, 0x509A, 0x6700, 0x51F1, 0x5272, 0x5274,
    0x5275, 0x5269, 0x52DE, 0x52DD, 0x52DB, 0x535A, 0x53A5, 0x557B,
    0x5580, 0x55A7, 0x557C, 0x558A, 0x559D, 0x5598, 0x5582, 0x559C,
    0x55AA, 0x5594, 0x5587, 0x558B, 0x5583, 0x55B3, 0x55AE, 0x559F,
    0x553E, 0x55B2, 0x559A, 0x55BB, 0x55AC, 0x55B1, 0x557E, 0x5589,
    0x55AB, 0x5599, 0x570D, 0x582F, 0x582A, 0x5834, 0x5824, 0x5830,
    0x5831, 0x5821, 0x581D, 0x5820, 0x58F9, 0x58FA, 0x5960,
    /* Big5-HKSCS 0xB440 .. 0xB47E */
    0x5A77, 0x5A9A, 0x5A7F, 0x5A92, 0x5A9B, 0x5AA7, 0x5B73, 0x5B71,
    0x5BD2, 0x5BCC, 0x5BD3, 0x5BD0, 0x5C0A, 0x5C0B, 0x5C31, 0x5D4C,
    0x5D50, 0x5D34, 0x5D47, 0x5DFD, 0x5E45, 0x5E3D, 0x5E40, 0x5E43,
    0x5E7E, 0x5ECA, 0x5EC1, 0x5EC2, 0x5EC4, 0x5F3C, 0x5F6D, 0x5FA9,
    0x5FAA, 0x5FA8, 0x60D1, 0x60E1, 0x60B2, 0x60B6, 0x60E0, 0x611C,
    0x6123, 0x60FA, 0x6115, 0x60F0, 0x60FB, 0x60F4, 0x6168, 0x60F1,
    0x610E, 0x60F6, 0x6109, 0x6100, 0x6112, 0x621F, 0x6249, 0x63A3,
    0x638C, 0x63CF, 0x63C0, 0x63E9, 0x63C9, 0x63C6, 0x63CD,
    /* Big5-HKSCS 0xB4A1 .. 0xB4FE */
            0x63D2, 0x63E3, 0x63D0, 0x63E1, 0x63D6, 0x63ED, 0x63EE,
    0x6376, 0x63F4, 0x63EA, 0x63DB, 0x6452, 0x63DA, 0x63F9, 0x655E,
    0x6566, 0x6562, 0x6563, 0x6591, 0x6590, 0x65AF, 0x666E, 0x6670,
    0x6674, 0x6676, 0x666F, 0x6691, 0x667A, 0x667E, 0x6677, 0x66FE,
    0x66FF, 0x671F, 0x671D, 0x68FA, 0x68D5, 0x68E0, 0x68D8, 0x68D7,
    0x6905, 0x68DF, 0x68F5, 0x68EE, 0x68E7, 0x68F9, 0x68D2, 0x68F2,
    0x68E3, 0x68CB, 0x68CD, 0x690D, 0x6912, 0x690E, 0x68C9, 0x68DA,
    0x696E, 0x68FB, 0x6B3E, 0x6B3A, 0x6B3D, 0x6B98, 0x6B96, 0x6BBC,
    0x6BEF, 0x6C2E, 0x6C2F, 0x6C2C, 0x6E2F, 0x6E38, 0x6E54, 0x6E21,
    0x6E32, 0x6E67, 0x6E4A, 0x6E20, 0x6E25, 0x6E23, 0x6E1B, 0x6E5B,
    0x6E58, 0x6E24, 0x6E56, 0x6E6E, 0x6E2D, 0x6E26, 0x6E6F, 0x6E34,
    0x6E4D, 0x6E3A, 0x6E2C, 0x6E43, 0x6E1D, 0x6E3E, 0x6ECB,
    /* Big5-HKSCS 0xB540 .. 0xB57E */
    0x6E89, 0x6E19, 0x6E4E, 0x6E63, 0x6E44, 0x6E72, 0x6E69, 0x6E5F,
    0x7119, 0x711A, 0x7126, 0x7130, 0x7121, 0x7136, 0x716E, 0x711C,
    0x724C, 0x7284, 0x7280, 0x7336, 0x7325, 0x7334, 0x7329, 0x743A,
    0x742A, 0x7433, 0x7422, 0x7425, 0x7435, 0x7436, 0x7434, 0x742F,
    0x741B, 0x7426, 0x7428, 0x7525, 0x7526, 0x756B, 0x756A, 0x75E2,
    0x75DB, 0x75E3, 0x75D9, 0x75D8, 0x75DE, 0x75E0, 0x767B, 0x767C,
    0x7696, 0x7693, 0x76B4, 0x76DC, 0x774F, 0x77ED, 0x785D, 0x786C,
    0x786F, 0x7A0D, 0x7A08, 0x7A0B, 0x7A05, 0x7A00, 0x7A98,
    /* Big5-HKSCS 0xB5A1 .. 0xB5FE */
            0x7A97, 0x7A96, 0x7AE5, 0x7AE3, 0x7B49, 0x7B56, 0x7B46,
    0x7B50, 0x7B52, 0x7B54, 0x7B4D, 0x7B4B, 0x7B4F, 0x7B51, 0x7C9F,
    0x7CA5, 0x7D5E, 0x7D50, 0x7D68, 0x7D55, 0x7D2B, 0x7D6E, 0x7D72,
    0x7D61, 0x7D66, 0x7D62, 0x7D70, 0x7D73, 0x5584, 0x7FD4, 0x7FD5,
    0x800B, 0x8052, 0x8085, 0x8155, 0x8154, 0x814B, 0x8151, 0x814E,
    0x8139, 0x8146, 0x813E, 0x814C, 0x8153, 0x8174, 0x8212, 0x821C,
    0x83E9, 0x8403, 0x83F8, 0x840D, 0x83E0, 0x83C5, 0x840B, 0x83C1,
    0x83EF, 0x83F1, 0x83F4, 0x8457, 0x840A, 0x83F0, 0x840C, 0x83CC,
    0x83FD, 0x83F2, 0x83CA, 0x8438, 0x840E, 0x8404, 0x83DC, 0x8407,
    0x83D4, 0x83DF, 0x865B, 0x86DF, 0x86D9, 0x86ED, 0x86D4, 0x86DB,
    0x86E4, 0x86D0, 0x86DE, 0x8857, 0x88C1, 0x88C2, 0x88B1, 0x8983,
    0x8996, 0x8A3B, 0x8A60, 0x8A55, 0x8A5E, 0x8A3C, 0x8A41,
    /* Big5-HKSCS 0xB640 .. 0xB67E */
    0x8A54, 0x8A5B, 0x8A50, 0x8A46, 0x8A34, 0x8A3A, 0x8A36, 0x8A56,
    0x8C61, 0x8C82, 0x8CAF, 0x8CBC, 0x8CB3, 0x8CBD, 0x8CC1, 0x8CBB,
    0x8CC0, 0x8CB4, 0x8CB7, 0x8CB6, 0x8CBF, 0x8CB8, 0x8D8A, 0x8D85,
    0x8D81, 0x8DCE, 0x8DDD, 0x8DCB, 0x8DDA, 0x8DD1, 0x8DCC, 0x8DDB,
    0x8DC6, 0x8EFB, 0x8EF8, 0x8EFC, 0x8F9C, 0x902E, 0x9035, 0x9031,
    0x9038, 0x9032, 0x9036, 0x9102, 0x90F5, 0x9109, 0x90FE, 0x9163,
    0x9165, 0x91CF, 0x9214, 0x9215, 0x9223, 0x9209, 0x921E, 0x920D,
    0x9210, 0x9207, 0x9211, 0x9594, 0x958F, 0x958B, 0x9591,
    /* Big5-HKSCS 0xB6A1 .. 0xB6FE */
            0x9593, 0x9592, 0x958E, 0x968A, 0x968E, 0x968B, 0x967D,
    0x9685, 0x9686, 0x968D, 0x9672, 0x9684, 0x96C1, 0x96C5, 0x96C4,
    0x96C6, 0x96C7, 0x96EF, 0x96F2, 0x97CC, 0x9805, 0x9806, 0x9808,
    0x98E7, 0x98EA, 0x98EF, 0x98E9, 0x98F2, 0x98ED, 0x99AE, 0x99AD,
    0x9EC3, 0x9ECD, 0x9ED1, 0x4E82, 0x50AD, 0x50B5, 0x50B2, 0x50B3,
    0x50C5, 0x50BE, 0x50AC, 0x50B7, 0x50BB, 0x50AF, 0x50C7, 0x527F,
    0x5277, 0x527D, 0x52DF, 0x52E6, 0x52E4, 0x52E2, 0x52E3, 0x532F,
    0x55DF, 0x55E8, 0x55D3, 0x55E6, 0x55CE, 0x55DC, 0x55C7, 0x55D1,
    0x55E3, 0x55E4, 0x55EF, 0x55DA, 0x55E1, 0x55C5, 0x55C6, 0x55E5,
    0x55C9, 0x5712, 0x5713, 0x585E, 0x5851, 0x5858, 0x5857, 0x585A,
    0x5854, 0x586B, 0x584C, 0x586D, 0x584A, 0x5862, 0x5852, 0x584B,
    0x5967, 0x5AC1, 0x5AC9, 0x5ACC, 0x5ABE, 0x5ABD, 0x5ABC,
    /* Big5-HKSCS 0xB740 .. 0xB77E */
    0x5AB3, 0x5AC2, 0x5AB2, 0x5D69, 0x5D6F, 0x5E4C, 0x5E79, 0x5EC9,
    0x5EC8, 0x5F12, 0x5F59, 0x5FAC, 0x5FAE, 0x611A, 0x610F, 0x6148,
    0x611F, 0x60F3, 0x611B, 0x60F9, 0x6101, 0x6108, 0x614E, 0x614C,
    0x6144, 0x614D, 0x613E, 0x6134, 0x6127, 0x610D, 0x6106, 0x6137,
    0x6221, 0x6222, 0x6413, 0x643E, 0x641E, 0x642A, 0x642D, 0x643D,
    0x642C, 0x640F, 0x641C, 0x6414, 0x640D, 0x6436, 0x6416, 0x6417,
    0x6406, 0x656C, 0x659F, 0x65B0, 0x6697, 0x6689, 0x6687, 0x6688,
    0x6696, 0x6684, 0x6698, 0x668D, 0x6703, 0x6994, 0x696D,
    /* Big5-HKSCS 0xB7A1 .. 0xB7FE */
            0x695A, 0x6977, 0x6960, 0x6954, 0x6975, 0x6930, 0x6982,
    0x694A, 0x6968, 0x696B, 0x695E, 0x6953, 0x6979, 0x6986, 0x695D,
    0x6963, 0x695B, 0x6B47, 0x6B72, 0x6BC0, 0x6BBF, 0x6BD3, 0x6BFD,
    0x6EA2, 0x6EAF, 0x6ED3, 0x6EB6, 0x6EC2, 0x6E90, 0x6E9D, 0x6EC7,
    0x6EC5, 0x6EA5, 0x6E98, 0x6EBC, 0x6EBA, 0x6EAB, 0x6ED1, 0x6E96,
    0x6E9C, 0x6EC4, 0x6ED4, 0x6EAA, 0x6EA7, 0x6EB4, 0x714E, 0x7159,
    0x7169, 0x7164, 0x7149, 0x7167, 0x715C, 0x716C, 0x7166, 0x714C,
    0x7165, 0x715E, 0x7146, 0x7168, 0x7156, 0x723A, 0x7252, 0x7337,
    0x7345, 0x733F, 0x733E, 0x746F, 0x745A, 0x7455, 0x745F, 0x745E,
    0x7441, 0x743F, 0x7459, 0x745B, 0x745C, 0x7576, 0x7578, 0x7600,
    0x75F0, 0x7601, 0x75F2, 0x75F1, 0x75FA, 0x75FF, 0x75F4, 0x75F3,
    0x76DE, 0x76DF, 0x775B, 0x776B, 0x7766, 0x775E, 0x7763,
    /* Big5-HKSCS 0xB840 .. 0xB87E */
    0x7779, 0x776A, 0x776C, 0x775C, 0x7765, 0x7768, 0x7762, 0x77EE,
    0x788E, 0x78B0, 0x7897, 0x7898, 0x788C, 0x7889, 0x787C, 0x7891,
    0x7893, 0x787F, 0x797A, 0x797F, 0x7981, 0x842C, 0x79BD, 0x7A1C,
    0x7A1A, 0x7A20, 0x7A14, 0x7A1F, 0x7A1E, 0x7A9F, 0x7AA0, 0x7B77,
    0x7BC0, 0x7B60, 0x7B6E, 0x7B67, 0x7CB1, 0x7CB3, 0x7CB5, 0x7D93,
    0x7D79, 0x7D91, 0x7D81, 0x7D8F, 0x7D5B, 0x7F6E, 0x7F69, 0x7F6A,
    0x7F72, 0x7FA9, 0x7FA8, 0x7FA4, 0x8056, 0x8058, 0x8086, 0x8084,
    0x8171, 0x8170, 0x8178, 0x8165, 0x816E, 0x8173, 0x816B,
    /* Big5-HKSCS 0xB8A1 .. 0xB8FE */
            0x8179, 0x817A, 0x8166, 0x8205, 0x8247, 0x8482, 0x8477,
    0x843D, 0x8431, 0x8475, 0x8466, 0x846B, 0x8449, 0x846C, 0x845B,
    0x843C, 0x8435, 0x8461, 0x8463, 0x8469, 0x846D, 0x8446, 0x865E,
    0x865C, 0x865F, 0x86F9, 0x8713, 0x8708, 0x8707, 0x8700, 0x86FE,
    0x86FB, 0x8702, 0x8703, 0x8706, 0x870A, 0x8859, 0x88DF, 0x88D4,
    0x88D9, 0x88DC, 0x88D8, 0x88DD, 0x88E1, 0x88CA, 0x88D5, 0x88D2,
    0x899C, 0x89E3, 0x8A6B, 0x8A72, 0x8A73, 0x8A66, 0x8A69, 0x8A70,
    0x8A87, 0x8A7C, 0x8A63, 0x8AA0, 0x8A71, 0x8A85, 0x8A6D, 0x8A62,
    0x8A6E, 0x8A6C, 0x8A79, 0x8A7B, 0x8A3E, 0x8A68, 0x8C62, 0x8C8A,
    0x8C89, 0x8CCA, 0x8CC7, 0x8CC8, 0x8CC4, 0x8CB2, 0x8CC3, 0x8CC2,
    0x8CC5, 0x8DE1, 0x8DDF, 0x8DE8, 0x8DEF, 0x8DF3, 0x8DFA, 0x8DEA,
    0x8DE4, 0x8DE6, 0x8EB2, 0x8F03, 0x8F09, 0x8EFE, 0x8F0A,
    /* Big5-HKSCS 0xB940 .. 0xB97E */
    0x8F9F, 0x8FB2, 0x904B, 0x904A, 0x9053, 0x9042, 0x9054, 0x903C,
    0x9055, 0x9050, 0x9047, 0x904F, 0x904E, 0x904D, 0x9051, 0x903E,
    0x9041, 0x9112, 0x9117, 0x916C, 0x916A, 0x9169, 0x91C9, 0x9237,
    0x9257, 0x9238, 0x923D, 0x9240, 0x923E, 0x925B, 0x924B, 0x9264,
    0x9251, 0x9234, 0x9249, 0x924D, 0x9245, 0x9239, 0x923F, 0x925A,
    0x9598, 0x9698, 0x9694, 0x9695, 0x96CD, 0x96CB, 0x96C9, 0x96CA,
    0x96F7, 0x96FB, 0x96F9, 0x96F6, 0x9756, 0x9774, 0x9776, 0x9810,
    0x9811, 0x9813, 0x980A, 0x9812, 0x980C, 0x98FC, 0x98F4,
    /* Big5-HKSCS 0xB9A1 .. 0xB9FE */
            0x98FD, 0x98FE, 0x99B3, 0x99B1, 0x99B4, 0x9AE1, 0x9CE9,
    0x9E82, 0x9F0E, 0x9F13, 0x9F20, 0x50E7, 0x50EE, 0x50E5, 0x50D6,
    0x50ED, 0x50DA, 0x50D5, 0x50CF, 0x50D1, 0x50F1, 0x50CE, 0x50E9,
    0x5162, 0x51F3, 0x5283, 0x5282, 0x5331, 0x53AD, 0x55FE, 0x5600,
    0x561B, 0x5617, 0x55FD, 0x5614, 0x5606, 0x5609, 0x560D, 0x560E,
    0x55F7, 0x5616, 0x561F, 0x5608, 0x5610, 0x55F6, 0x5718, 0x5716,
    0x5875, 0x587E, 0x5883, 0x5893, 0x588A, 0x5879, 0x5885, 0x587D,
    0x58FD, 0x5925, 0x5922, 0x5924, 0x596A, 0x5969, 0x5AE1, 0x5AE6,
    0x5AE9, 0x5AD7, 0x5AD6, 0x5AD8, 0x5AE3, 0x5B75, 0x5BDE, 0x5BE7,
    0x5BE1, 0x5BE5, 0x5BE6, 0x5BE8, 0x5BE2, 0x5BE4, 0x5BDF, 0x5C0D,
    0x5C62, 0x5D84, 0x5D87, 0x5E5B, 0x5E63, 0x5E55, 0x5E57, 0x5E54,
    0x5ED3, 0x5ED6, 0x5F0A, 0x5F46, 0x5F70, 0x5FB9, 0x6147,
    /* Big5-HKSCS 0xBA40 .. 0xBA7E */
    0x613F, 0x614B, 0x6177, 0x6162, 0x6163, 0x615F, 0x615A, 0x6158,
    0x6175, 0x622A, 0x6487, 0x6458, 0x6454, 0x64A4, 0x6478, 0x645F,
    0x647A, 0x6451, 0x6467, 0x6434, 0x646D, 0x647B, 0x6572, 0x65A1,
    0x65D7, 0x65D6, 0x66A2, 0x66A8, 0x669D, 0x699C, 0x69A8, 0x6995,
    0x69C1, 0x69AE, 0x69D3, 0x69CB, 0x699B, 0x69B7, 0x69BB, 0x69AB,
    0x69B4, 0x69D0, 0x69CD, 0x69AD, 0x69CC, 0x69A6, 0x69C3, 0x69A3,
    0x6B49, 0x6B4C, 0x6C33, 0x6F33, 0x6F14, 0x6EFE, 0x6F13, 0x6EF4,
    0x6F29, 0x6F3E, 0x6F20, 0x6F2C, 0x6F0F, 0x6F02, 0x6F22,
    /* Big5-HKSCS 0xBAA1 .. 0xBAFE */
            0x6EFF, 0x6EEF, 0x6F06, 0x6F31, 0x6F38, 0x6F32, 0x6F23,
    0x6F15, 0x6F2B, 0x6F2F, 0x6F88, 0x6F2A, 0x6EEC, 0x6F01, 0x6EF2,
    0x6ECC, 0x6EF7, 0x7194, 0x7199, 0x717D, 0x718A, 0x7184, 0x7192,
    0x723E, 0x7292, 0x7296, 0x7344, 0x7350, 0x7464, 0x7463, 0x746A,
    0x7470, 0x746D, 0x7504, 0x7591, 0x7627, 0x760D, 0x760B, 0x7609,
    0x7613, 0x76E1, 0x76E3, 0x7784, 0x777D, 0x777F, 0x7761, 0x78C1,
    0x789F, 0x78A7, 0x78B3, 0x78A9, 0x78A3, 0x798E, 0x798F, 0x798D,
    0x7A2E, 0x7A31, 0x7AAA, 0x7AA9, 0x7AED, 0x7AEF, 0x7BA1, 0x7B95,
    0x7B8B, 0x7B75, 0x7B97, 0x7B9D, 0x7B94, 0x7B8F, 0x7BB8, 0x7B87,
    0x7B84, 0x7CB9, 0x7CBD, 0x7CBE, 0x7DBB, 0x7DB0, 0x7D9C, 0x7DBD,
    0x7DBE, 0x7DA0, 0x7DCA, 0x7DB4, 0x7DB2, 0x7DB1, 0x7DBA, 0x7DA2,
    0x7DBF, 0x7DB5, 0x7DB8, 0x7DAD, 0x7DD2, 0x7DC7, 0x7DAC,
    /* Big5-HKSCS 0xBB40 .. 0xBB7E */
    0x7F70, 0x7FE0, 0x7FE1, 0x7FDF, 0x805E, 0x805A, 0x8087, 0x8150,
    0x8180, 0x818F, 0x8188, 0x818A, 0x817F, 0x8182, 0x81E7, 0x81FA,
    0x8207, 0x8214, 0x821E, 0x824B, 0x84C9, 0x84BF, 0x84C6, 0x84C4,
    0x8499, 0x849E, 0x84B2, 0x849C, 0x84CB, 0x84B8, 0x84C0, 0x84D3,
    0x8490, 0x84BC, 0x84D1, 0x84CA, 0x873F, 0x871C, 0x873B, 0x8722,
    0x8725, 0x8734, 0x8718, 0x8755, 0x8737, 0x8729, 0x88F3, 0x8902,
    0x88F4, 0x88F9, 0x88F8, 0x88FD, 0x88E8, 0x891A, 0x88EF, 0x8AA6,
    0x8A8C, 0x8A9E, 0x8AA3, 0x8A8D, 0x8AA1, 0x8A93, 0x8AA4,
    /* Big5-HKSCS 0xBBA1 .. 0xBBFE */
            0x8AAA, 0x8AA5, 0x8AA8, 0x8A98, 0x8A91, 0x8A9A, 0x8AA7,
    0x8C6A, 0x8C8D, 0x8C8C, 0x8CD3, 0x8CD1, 0x8CD2, 0x8D6B, 0x8D99,
    0x8D95, 0x8DFC, 0x8F14, 0x8F12, 0x8F15, 0x8F13, 0x8FA3, 0x9060,
    0x9058, 0x905C, 0x9063, 0x9059, 0x905E, 0x9062, 0x905D, 0x905B,
    0x9119, 0x9118, 0x911E, 0x9175, 0x9178, 0x9177, 0x9174, 0x9278,
    0x9280, 0x9285, 0x9298, 0x9296, 0x927B, 0x9293, 0x929C, 0x92A8,
    0x927C, 0x9291, 0x95A1, 0x95A8, 0x95A9, 0x95A3, 0x95A5, 0x95A4,
    0x9699, 0x969C, 0x969B, 0x96CC, 0x96D2, 0x9700, 0x977C, 0x9785,
    0x97F6, 0x9817, 0x9818, 0x98AF, 0x98B1, 0x9903, 0x9905, 0x990C,
    0x9909, 0x99C1, 0x9AAF, 0x9AB0, 0x9AE6, 0x9B41, 0x9B42, 0x9CF4,
    0x9CF6, 0x9CF3, 0x9EBC, 0x9F3B, 0x9F4A, 0x5104, 0x5100, 0x50FB,
    0x50F5, 0x50F9, 0x5102, 0x5108, 0x5109, 0x5105, 0x51DC,
    /* Big5-HKSCS 0xBC40 .. 0xBC7E */
    0x5287, 0x5288, 0x5289, 0x528D, 0x528A, 0x52F0, 0x53B2, 0x562E,
    0x563B, 0x5639, 0x5632, 0x563F, 0x5634, 0x5629, 0x5653, 0x564E,
    0x5657, 0x5674, 0x5636, 0x562F, 0x5630, 0x5880, 0x589F, 0x589E,
    0x58B3, 0x589C, 0x58AE, 0x58A9, 0x58A6, 0x596D, 0x5B09, 0x5AFB,
    0x5B0B, 0x5AF5, 0x5B0C, 0x5B08, 0x5BEE, 0x5BEC, 0x5BE9, 0x5BEB,
    0x5C64, 0x5C65, 0x5D9D, 0x5D94, 0x5E62, 0x5E5F, 0x5E61, 0x5EE2,
    0x5EDA, 0x5EDF, 0x5EDD, 0x5EE3, 0x5EE0, 0x5F48, 0x5F71, 0x5FB7,
    0x5FB5, 0x6176, 0x6167, 0x616E, 0x615D, 0x6155, 0x6182,
    /* Big5-HKSCS 0xBCA1 .. 0xBCFE */
            0x617C, 0x6170, 0x616B, 0x617E, 0x61A7, 0x6190, 0x61AB,
    0x618E, 0x61AC, 0x619A, 0x61A4, 0x6194, 0x61AE, 0x622E, 0x6469,
    0x646F, 0x6479, 0x649E, 0x64B2, 0x6488, 0x6490, 0x64B0, 0x64A5,
    0x6493, 0x6495, 0x64A9, 0x6492, 0x64AE, 0x64AD, 0x64AB, 0x649A,
    0x64AC, 0x6499, 0x64A2, 0x64B3, 0x6575, 0x6577, 0x6578, 0x66AE,
    0x66AB, 0x66B4, 0x66B1, 0x6A23, 0x6A1F, 0x69E8, 0x6A01, 0x6A1E,
    0x6A19, 0x69FD, 0x6A21, 0x6A13, 0x6A0A, 0x69F3, 0x6A02, 0x6A05,
    0x69ED, 0x6A11, 0x6B50, 0x6B4E, 0x6BA4, 0x6BC5, 0x6BC6, 0x6F3F,
    0x6F7C, 0x6F84, 0x6F51, 0x6F66, 0x6F54, 0x6F86, 0x6F6D, 0x6F5B,
    0x6F78, 0x6F6E, 0x6F8E, 0x6F7A, 0x6F70, 0x6F64, 0x6F97, 0x6F58,
    0x6ED5, 0x6F6F, 0x6F60, 0x6F5F, 0x719F, 0x71AC, 0x71B1, 0x71A8,
    0x7256, 0x729B, 0x734E, 0x7357, 0x7469, 0x748B, 0x7483,
    /* Big5-HKSCS 0xBD40 .. 0xBD7E */
    0x747E, 0x7480, 0x757F, 0x7620, 0x7629, 0x761F, 0x7624, 0x7626,
    0x7621, 0x7622, 0x769A, 0x76BA, 0x76E4, 0x778E, 0x7787, 0x778C,
    0x7791, 0x778B, 0x78CB, 0x78C5, 0x78BA, 0x78CA, 0x78BE, 0x78D5,
    0x78BC, 0x78D0, 0x7A3F, 0x7A3C, 0x7A40, 0x7A3D, 0x7A37, 0x7A3B,
    0x7AAF, 0x7AAE, 0x7BAD, 0x7BB1, 0x7BC4, 0x7BB4, 0x7BC6, 0x7BC7,
    0x7BC1, 0x7BA0, 0x7BCC, 0x7CCA, 0x7DE0, 0x7DF4, 0x7DEF, 0x7DFB,
    0x7DD8, 0x7DEC, 0x7DDD, 0x7DE8, 0x7DE3, 0x7DDA, 0x7DDE, 0x7DE9,
    0x7D9E, 0x7DD9, 0x7DF2, 0x7DF9, 0x7F75, 0x7F77, 0x7FAF,
    /* Big5-HKSCS 0xBDA1 .. 0xBDFE */
            0x7FE9, 0x8026, 0x819B, 0x819C, 0x819D, 0x81A0, 0x819A,
    0x8198, 0x8517, 0x853D, 0x851A, 0x84EE, 0x852C, 0x852D, 0x8513,
    0x8511, 0x8523, 0x8521, 0x8514, 0x84EC, 0x8525, 0x84FF, 0x8506,
    0x8782, 0x8774, 0x8776, 0x8760, 0x8766, 0x8778, 0x8768, 0x8759,
    0x8757, 0x874C, 0x8753, 0x885B, 0x885D, 0x8910, 0x8907, 0x8912,
    0x8913, 0x8915, 0x890A, 0x8ABC, 0x8AD2, 0x8AC7, 0x8AC4, 0x8A95,
    0x8ACB, 0x8AF8, 0x8AB2, 0x8AC9, 0x8AC2, 0x8ABF, 0x8AB0, 0x8AD6,
    0x8ACD, 0x8AB6, 0x8AB9, 0x8ADB, 0x8C4C, 0x8C4E, 0x8C6C, 0x8CE0,
    0x8CDE, 0x8CE6, 0x8CE4, 0x8CEC, 0x8CED, 0x8CE2, 0x8CE3, 0x8CDC,
    0x8CEA, 0x8CE1, 0x8D6D, 0x8D9F, 0x8DA3, 0x8E2B, 0x8E10, 0x8E1D,
    0x8E22, 0x8E0F, 0x8E29, 0x8E1F, 0x8E21, 0x8E1E, 0x8EBA, 0x8F1D,
    0x8F1B, 0x8F1F, 0x8F29, 0x8F26, 0x8F2A, 0x8F1C, 0x8F1E,
    /* Big5-HKSCS 0xBE40 .. 0xBE7E */
    0x8F25, 0x9069, 0x906E, 0x9068, 0x906D, 0x9077, 0x9130, 0x912D,
    0x9127, 0x9131, 0x9187, 0x9189, 0x918B, 0x9183, 0x92C5, 0x92BB,
    0x92B7, 0x92EA, 0x92AC, 0x92E4, 0x92C1, 0x92B3, 0x92BC, 0x92D2,
    0x92C7, 0x92F0, 0x92B2, 0x95AD, 0x95B1, 0x9704, 0x9706, 0x9707,
    0x9709, 0x9760, 0x978D, 0x978B, 0x978F, 0x9821, 0x982B, 0x981C,
    0x98B3, 0x990A, 0x9913, 0x9912, 0x9918, 0x99DD, 0x99D0, 0x99DF,
    0x99DB, 0x99D1, 0x99D5, 0x99D2, 0x99D9, 0x9AB7, 0x9AEE, 0x9AEF,
    0x9B27, 0x9B45, 0x9B44, 0x9B77, 0x9B6F, 0x9D06, 0x9D09,
    /* Big5-HKSCS 0xBEA1 .. 0xBEFE */
            0x9D03, 0x9EA9, 0x9EBE, 0x9ECE, 0x58A8, 0x9F52, 0x5112,
    0x5118, 0x5114, 0x5110, 0x5115, 0x5180, 0x51AA, 0x51DD, 0x5291,
    0x5293, 0x52F3, 0x5659, 0x566B, 0x5679, 0x5669, 0x5664, 0x5678,
    0x566A, 0x5668, 0x5665, 0x5671, 0x566F, 0x566C, 0x5662, 0x5676,
    0x58C1, 0x58BE, 0x58C7, 0x58C5, 0x596E, 0x5B1D, 0x5B34, 0x5B78,
    0x5BF0, 0x5C0E, 0x5F4A, 0x61B2, 0x6191, 0x61A9, 0x618A, 0x61CD,
    0x61B6, 0x61BE, 0x61CA, 0x61C8, 0x6230, 0x64C5, 0x64C1, 0x64CB,
    0x64BB, 0x64BC, 0x64DA, 0x64C4, 0x64C7, 0x64C2, 0x64CD, 0x64BF,
    0x64D2, 0x64D4, 0x64BE, 0x6574, 0x66C6, 0x66C9, 0x66B9, 0x66C4,
    0x66C7, 0x66B8, 0x6A3D, 0x6A38, 0x6A3A, 0x6A59, 0x6A6B, 0x6A58,
    0x6A39, 0x6A44, 0x6A62, 0x6A61, 0x6A4B, 0x6A47, 0x6A35, 0x6A5F,
    0x6A48, 0x6B59, 0x6B77, 0x6C05, 0x6FC2, 0x6FB1, 0x6FA1,
    /* Big5-HKSCS 0xBF40 .. 0xBF7E */
    0x6FC3, 0x6FA4, 0x6FC1, 0x6FA7, 0x6FB3, 0x6FC0, 0x6FB9, 0x6FB6,
    0x6FA6, 0x6FA0, 0x6FB4, 0x71BE, 0x71C9, 0x71D0, 0x71D2, 0x71C8,
    0x71D5, 0x71B9, 0x71CE, 0x71D9, 0x71DC, 0x71C3, 0x71C4, 0x7368,
    0x749C, 0x74A3, 0x7498, 0x749F, 0x749E, 0x74E2, 0x750C, 0x750D,
    0x7634, 0x7638, 0x763A, 0x76E7, 0x76E5, 0x77A0, 0x779E, 0x779F,
    0x77A5, 0x78E8, 0x78DA, 0x78EC, 0x78E7, 0x79A6, 0x7A4D, 0x7A4E,
    0x7A46, 0x7A4C, 0x7A4B, 0x7ABA, 0x7BD9, 0x7C11, 0x7BC9, 0x7BE4,
    0x7BDB, 0x7BE1, 0x7BE9, 0x7BE6, 0x7CD5, 0x7CD6, 0x7E0A,
    /* Big5-HKSCS 0xBFA1 .. 0xBFFE */
            0x7E11, 0x7E08, 0x7E1B, 0x7E23, 0x7E1E, 0x7E1D, 0x7E09,
    0x7E10, 0x7F79, 0x7FB2, 0x7FF0, 0x7FF1, 0x7FEE, 0x8028, 0x81B3,
    0x81A9, 0x81A8, 0x81FB, 0x8208, 0x8258, 0x8259, 0x854A, 0x8559,
    0x8548, 0x8568, 0x8569, 0x8543, 0x8549, 0x856D, 0x856A, 0x855E,
    0x8783, 0x879F, 0x879E, 0x87A2, 0x878D, 0x8861, 0x892A, 0x8932,
    0x8925, 0x892B, 0x8921, 0x89AA, 0x89A6, 0x8AE6, 0x8AFA, 0x8AEB,
    0x8AF1, 0x8B00, 0x8ADC, 0x8AE7, 0x8AEE, 0x8AFE, 0x8B01, 0x8B02,
    0x8AF7, 0x8AED, 0x8AF3, 0x8AF6, 0x8AFC, 0x8C6B, 0x8C6D, 0x8C93,
    0x8CF4, 0x8E44, 0x8E31, 0x8E34, 0x8E42, 0x8E39, 0x8E35, 0x8F3B,
    0x8F2F, 0x8F38, 0x8F33, 0x8FA8, 0x8FA6, 0x9075, 0x9074, 0x9078,
    0x9072, 0x907C, 0x907A, 0x9134, 0x9192, 0x9320, 0x9336, 0x92F8,
    0x9333, 0x932F, 0x9322, 0x92FC, 0x932B, 0x9304, 0x931A,
    /* Big5-HKSCS 0xC040 .. 0xC07E */
    0x9310, 0x9326, 0x9321, 0x9315, 0x932E, 0x9319, 0x95BB, 0x96A7,
    0x96A8, 0x96AA, 0x96D5, 0x970E, 0x9711, 0x9716, 0x970D, 0x9713,
    0x970F, 0x975B, 0x975C, 0x9766, 0x9798, 0x9830, 0x9838, 0x983B,
    0x9837, 0x982D, 0x9839, 0x9824, 0x9910, 0x9928, 0x991E, 0x991B,
    0x9921, 0x991A, 0x99ED, 0x99E2, 0x99F1, 0x9AB8, 0x9ABC, 0x9AFB,
    0x9AED, 0x9B28, 0x9B91, 0x9D15, 0x9D23, 0x9D26, 0x9D28, 0x9D12,
    0x9D1B, 0x9ED8, 0x9ED4, 0x9F8D, 0x9F9C, 0x512A, 0x511F, 0x5121,
    0x5132, 0x52F5, 0x568E, 0x5680, 0x5690, 0x5685, 0x5687,
    /* Big5-HKSCS 0xC0A1 .. 0xC0FE */
            0x568F, 0x58D5, 0x58D3, 0x58D1, 0x58CE, 0x5B30, 0x5B2A,
    0x5B24, 0x5B7A, 0x5C37, 0x5C68, 0x5DBC, 0x5DBA, 0x5DBD, 0x5DB8,
    0x5E6B, 0x5F4C, 0x5FBD, 0x61C9, 0x61C2, 0x61C7, 0x61E6, 0x61CB,
    0x6232, 0x6234, 0x64CE, 0x64CA, 0x64D8, 0x64E0, 0x64F0, 0x64E6,
    0x64EC, 0x64F1, 0x64E2, 0x64ED, 0x6582, 0x6583, 0x66D9, 0x66D6,
    0x6A80, 0x6A94, 0x6A84, 0x6AA2, 0x6A9C, 0x6ADB, 0x6AA3, 0x6A7E,
    0x6A97, 0x6A90, 0x6AA0, 0x6B5C, 0x6BAE, 0x6BDA, 0x6C08, 0x6FD8,
    0x6FF1, 0x6FDF, 0x6FE0, 0x6FDB, 0x6FE4, 0x6FEB, 0x6FEF, 0x6F80,
    0x6FEC, 0x6FE1, 0x6FE9, 0x6FD5, 0x6FEE, 0x6FF0, 0x71E7, 0x71DF,
    0x71EE, 0x71E6, 0x71E5, 0x71ED, 0x71EC, 0x71F4, 0x71E0, 0x7235,
    0x7246, 0x7370, 0x7372, 0x74A9, 0x74B0, 0x74A6, 0x74A8, 0x7646,
    0x7642, 0x764C, 0x76EA, 0x77B3, 0x77AA, 0x77B0, 0x77AC,
    /* Big5-HKSCS 0xC140 .. 0xC17E */
    0x77A7, 0x77AD, 0x77EF, 0x78F7, 0x78FA, 0x78F4, 0x78EF, 0x7901,
    0x79A7, 0x79AA, 0x7A57, 0x7ABF, 0x7C07, 0x7C0D, 0x7BFE, 0x7BF7,
    0x7C0C, 0x7BE0, 0x7CE0, 0x7CDC, 0x7CDE, 0x7CE2, 0x7CDF, 0x7CD9,
    0x7CDD, 0x7E2E, 0x7E3E, 0x7E46, 0x7E37, 0x7E32, 0x7E43, 0x7E2B,
    0x7E3D, 0x7E31, 0x7E45, 0x7E41, 0x7E34, 0x7E39, 0x7E48, 0x7E35,
    0x7E3F, 0x7E2F, 0x7F44, 0x7FF3, 0x7FFC, 0x8071, 0x8072, 0x8070,
    0x806F, 0x8073, 0x81C6, 0x81C3, 0x81BA, 0x81C2, 0x81C0, 0x81BF,
    0x81BD, 0x81C9, 0x81BE, 0x81E8, 0x8209, 0x8271, 0x85AA,
    /* Big5-HKSCS 0xC1A1 .. 0xC1FE */
            0x8584, 0x857E, 0x859C, 0x8591, 0x8594, 0x85AF, 0x859B,
    0x8587, 0x85A8, 0x858A, 0x8667, 0x87C0, 0x87D1, 0x87B3, 0x87D2,
    0x87C6, 0x87AB, 0x87BB, 0x87BA, 0x87C8, 0x87CB, 0x893B, 0x8936,
    0x8944, 0x8938, 0x893D, 0x89AC, 0x8B0E, 0x8B17, 0x8B19, 0x8B1B,
    0x8B0A, 0x8B20, 0x8B1D, 0x8B04, 0x8B10, 0x8C41, 0x8C3F, 0x8C73,
    0x8CFA, 0x8CFD, 0x8CFC, 0x8CF8, 0x8CFB, 0x8DA8, 0x8E49, 0x8E4B,
    0x8E48, 0x8E4A, 0x8F44, 0x8F3E, 0x8F42, 0x8F45, 0x8F3F, 0x907F,
    0x907D, 0x9084, 0x9081, 0x9082, 0x9080, 0x9139, 0x91A3, 0x919E,
    0x919C, 0x934D, 0x9382, 0x9328, 0x9375, 0x934A, 0x9365, 0x934B,
    0x9318, 0x937E, 0x936C, 0x935B, 0x9370, 0x935A, 0x9354, 0x95CA,
    0x95CB, 0x95CC, 0x95C8, 0x95C6, 0x96B1, 0x96B8, 0x96D6, 0x971C,
    0x971E, 0x97A0, 0x97D3, 0x9846, 0x98B6, 0x9935, 0x9A01,
    /* Big5-HKSCS 0xC240 .. 0xC27E */
    0x99FF, 0x9BAE, 0x9BAB, 0x9BAA, 0x9BAD, 0x9D3B, 0x9D3F, 0x9E8B,
    0x9ECF, 0x9EDE, 0x9EDC, 0x9EDD, 0x9EDB, 0x9F3E, 0x9F4B, 0x53E2,
    0x5695, 0x56AE, 0x58D9, 0x58D8, 0x5B38, 0x5F5D, 0x61E3, 0x6233,
    0x64F4, 0x64F2, 0x64FE, 0x6506, 0x64FA, 0x64FB, 0x64F7, 0x65B7,
    0x66DC, 0x6726, 0x6AB3, 0x6AAC, 0x6AC3, 0x6ABB, 0x6AB8, 0x6AC2,
    0x6AAE, 0x6AAF, 0x6B5F, 0x6B78, 0x6BAF, 0x7009, 0x700B, 0x6FFE,
    0x7006, 0x6FFA, 0x7011, 0x700F, 0x71FB, 0x71FC, 0x71FE, 0x71F8,
    0x7377, 0x7375, 0x74A7, 0x74BF, 0x7515, 0x7656, 0x7658,
    /* Big5-HKSCS 0xC2A1 .. 0xC2FE */
            0x7652, 0x77BD, 0x77BF, 0x77BB, 0x77BC, 0x790E, 0x79AE,
    0x7A61, 0x7A62, 0x7A60, 0x7AC4, 0x7AC5, 0x7C2B, 0x7C27, 0x7C2A,
    0x7C1E, 0x7C23, 0x7C21, 0x7CE7, 0x7E54, 0x7E55, 0x7E5E, 0x7E5A,
    0x7E61, 0x7E52, 0x7E59, 0x7F48, 0x7FF9, 0x7FFB, 0x8077, 0x8076,
    0x81CD, 0x81CF, 0x820A, 0x85CF, 0x85A9, 0x85CD, 0x85D0, 0x85C9,
    0x85B0, 0x85BA, 0x85B9, 0x85A6, 0x87EF, 0x87EC, 0x87F2, 0x87E0,
    0x8986, 0x89B2, 0x89F4, 0x8B28, 0x8B39, 0x8B2C, 0x8B2B, 0x8C50,
    0x8D05, 0x8E59, 0x8E63, 0x8E66, 0x8E64, 0x8E5F, 0x8E55, 0x8EC0,
    0x8F49, 0x8F4D, 0x9087, 0x9083, 0x9088, 0x91AB, 0x91AC, 0x91D0,
    0x9394, 0x938A, 0x9396, 0x93A2, 0x93B3, 0x93AE, 0x93AC, 0x93B0,
    0x9398, 0x939A, 0x9397, 0x95D4, 0x95D6, 0x95D0, 0x95D5, 0x96E2,
    0x96DC, 0x96D9, 0x96DB, 0x96DE, 0x9724, 0x97A3, 0x97A6,
    /* Big5-HKSCS 0xC340 .. 0xC37E */
    0x97AD, 0x97F9, 0x984D, 0x984F, 0x984C, 0x984E, 0x9853, 0x98BA,
    0x993E, 0x993F, 0x993D, 0x992E, 0x99A5, 0x9A0E, 0x9AC1, 0x9B03,
    0x9B06, 0x9B4F, 0x9B4E, 0x9B4D, 0x9BCA, 0x9BC9, 0x9BFD, 0x9BC8,
    0x9BC0, 0x9D51, 0x9D5D, 0x9D60, 0x9EE0, 0x9F15, 0x9F2C, 0x5133,
    0x56A5, 0x58DE, 0x58DF, 0x58E2, 0x5BF5, 0x9F90, 0x5EEC, 0x61F2,
    0x61F7, 0x61F6, 0x61F5, 0x6500, 0x650F, 0x66E0, 0x66DD, 0x6AE5,
    0x6ADD, 0x6ADA, 0x6AD3, 0x701B, 0x701F, 0x7028, 0x701A, 0x701D,
    0x7015, 0x7018, 0x7206, 0x720D, 0x7258, 0x72A2, 0x7378,
    /* Big5-HKSCS 0xC3A1 .. 0xC3FE */
            0x737A, 0x74BD, 0x74CA, 0x74E3, 0x7587, 0x7586, 0x765F,
    0x7661, 0x77C7, 0x7919, 0x79B1, 0x7A6B, 0x7A69, 0x7C3E, 0x7C3F,
    0x7C38, 0x7C3D, 0x7C37, 0x7C40, 0x7E6B, 0x7E6D, 0x7E79, 0x7E69,
    0x7E6A, 0x7F85, 0x7E73, 0x7FB6, 0x7FB9, 0x7FB8, 0x81D8, 0x85E9,
    0x85DD, 0x85EA, 0x85D5, 0x85E4, 0x85E5, 0x85F7, 0x87FB, 0x8805,
    0x880D, 0x87F9, 0x87FE, 0x8960, 0x895F, 0x8956, 0x895E, 0x8B41,
    0x8B5C, 0x8B58, 0x8B49, 0x8B5A, 0x8B4E, 0x8B4F, 0x8B46, 0x8B59,
    0x8D08, 0x8D0A, 0x8E7C, 0x8E72, 0x8E87, 0x8E76, 0x8E6C, 0x8E7A,
    0x8E74, 0x8F54, 0x8F4E, 0x8FAD, 0x908A, 0x908B, 0x91B1, 0x91AE,
    0x93E1, 0x93D1, 0x93DF, 0x93C3, 0x93C8, 0x93DC, 0x93DD, 0x93D6,
    0x93E2, 0x93CD, 0x93D8, 0x93E4, 0x93D7, 0x93E8, 0x95DC, 0x96B4,
    0x96E3, 0x972A, 0x9727, 0x9761, 0x97DC, 0x97FB, 0x985E,
    /* Big5-HKSCS 0xC440 .. 0xC47E */
    0x9858, 0x985B, 0x98BC, 0x9945, 0x9949, 0x9A16, 0x9A19, 0x9B0D,
    0x9BE8, 0x9BE7, 0x9BD6, 0x9BDB, 0x9D89, 0x9D61, 0x9D72, 0x9D6A,
    0x9D6C, 0x9E92, 0x9E97, 0x9E93, 0x9EB4, 0x52F8, 0x56A8, 0x56B7,
    0x56B6, 0x56B4, 0x56BC, 0x58E4, 0x5B40, 0x5B43, 0x5B7D, 0x5BF6,
    0x5DC9, 0x61F8, 0x61FA, 0x6518, 0x6514, 0x6519, 0x66E6, 0x6727,
    0x6AEC, 0x703E, 0x7030, 0x7032, 0x7210, 0x737B, 0x74CF, 0x7662,
    0x7665, 0x7926, 0x792A, 0x792C, 0x792B, 0x7AC7, 0x7AF6, 0x7C4C,
    0x7C43, 0x7C4D, 0x7CEF, 0x7CF0, 0x8FAE, 0x7E7D, 0x7E7C,
    /* Big5-HKSCS 0xC4A1 .. 0xC4FE */
            0x7E82, 0x7F4C, 0x8000, 0x81DA, 0x8266, 0x85FB, 0x85F9,
    0x8611, 0x85FA, 0x8606, 0x860B, 0x8607, 0x860A, 0x8814, 0x8815,
    0x8964, 0x89BA, 0x89F8, 0x8B70, 0x8B6C, 0x8B66, 0x8B6F, 0x8B5F,
    0x8B6B, 0x8D0F, 0x8D0D, 0x8E89, 0x8E81, 0x8E85, 0x8E82, 0x91B4,
    0x91CB, 0x9418, 0x9403, 0x93FD, 0x95E1, 0x9730, 0x98C4, 0x9952,
    0x9951, 0x99A8, 0x9A2B, 0x9A30, 0x9A37, 0x9A35, 0x9C13, 0x9C0D,
    0x9E79, 0x9EB5, 0x9EE8, 0x9F2F, 0x9F5F, 0x9F63, 0x9F61, 0x5137,
    0x5138, 0x56C1, 0x56C0, 0x56C2, 0x5914, 0x5C6C, 0x5DCD, 0x61FC,
    0x61FE, 0x651D, 0x651C, 0x6595, 0x66E9, 0x6AFB, 0x6B04, 0x6AFA,
    0x6BB2, 0x704C, 0x721B, 0x72A7, 0x74D6, 0x74D4, 0x7669, 0x77D3,
    0x7C50, 0x7E8F, 0x7E8C, 0x7FBC, 0x8617, 0x862D, 0x861A, 0x8823,
    0x8822, 0x8821, 0x881F, 0x896A, 0x896C, 0x89BD, 0x8B74,
    /* Big5-HKSCS 0xC540 .. 0xC57E */
    0x8B77, 0x8B7D, 0x8D13, 0x8E8A, 0x8E8D, 0x8E8B, 0x8F5F, 0x8FAF,
    0x91BA, 0x942E, 0x9433, 0x9435, 0x943A, 0x9438, 0x9432, 0x942B,
    0x95E2, 0x9738, 0x9739, 0x9732, 0x97FF, 0x9867, 0x9865, 0x9957,
    0x9A45, 0x9A43, 0x9A40, 0x9A3E, 0x9ACF, 0x9B54, 0x9B51, 0x9C2D,
    0x9C25, 0x9DAF, 0x9DB4, 0x9DC2, 0x9DB8, 0x9E9D, 0x9EEF, 0x9F19,
    0x9F5C, 0x9F66, 0x9F67, 0x513C, 0x513B, 0x56C8, 0x56CA, 0x56C9,
    0x5B7F, 0x5DD4, 0x5DD2, 0x5F4E, 0x61FF, 0x6524, 0x6B0A, 0x6B61,
    0x7051, 0x7058, 0x7380, 0x74E4, 0x758A, 0x766E, 0x766C,
    /* Big5-HKSCS 0xC5A1 .. 0xC5FE */
            0x79B3, 0x7C60, 0x7C5F, 0x807E, 0x807D, 0x81DF, 0x8972,
    0x896F, 0x89FC, 0x8B80, 0x8D16, 0x8D17, 0x8E91, 0x8E93, 0x8F61,
    0x9148, 0x9444, 0x9451, 0x9452, 0x973D, 0x973E, 0x97C3, 0x97C1,
    0x986B, 0x9955, 0x9A55, 0x9A4D, 0x9AD2, 0x9B1A, 0x9C49, 0x9C31,
    0x9C3E, 0x9C3B, 0x9DD3, 0x9DD7, 0x9F34, 0x9F6C, 0x9F6A, 0x9F94,
    0x56CC, 0x5DD6, 0x6200, 0x6523, 0x652B, 0x652A, 0x66EC, 0x6B10,
    0x74DA, 0x7ACA, 0x7C64, 0x7C63, 0x7C65, 0x7E93, 0x7E96, 0x7E94,
    0x81E2, 0x8638, 0x863F, 0x8831, 0x8B8A, 0x9090, 0x908F, 0x9463,
    0x9460, 0x9464, 0x9768, 0x986F, 0x995C, 0x9A5A, 0x9A5B, 0x9A57,
    0x9AD3, 0x9AD4, 0x9AD1, 0x9C54, 0x9C57, 0x9C56, 0x9DE5, 0x9E9F,
    0x9EF4, 0x56D1, 0x58E9, 0x652C, 0x705E, 0x7671, 0x7672, 0x77D7,
    0x7F50, 0x7F88, 0x8836, 0x8839, 0x8862, 0x8B93, 0x8B92,
    /* Big5-HKSCS 0xC640 .. 0xC67E */
    0x8B96, 0x8277, 0x8D1B, 0x91C0, 0x946A, 0x9742, 0x9748, 0x9744,
    0x97C6, 0x9870, 0x9A5F, 0x9B22, 0x9B58, 0x9C5F, 0x9DF9, 0x9DFA,
    0x9E7C, 0x9E7D, 0x9F07, 0x9F77, 0x9F72, 0x5EF3, 0x6B16, 0x7063,
    0x7C6C, 0x7C6E, 0x883B, 0x89C0, 0x8EA1, 0x91C1, 0x9472, 0x9470,
    0x9871, 0x995E, 0x9AD6, 0x9B23, 0x9ECC, 0x7064, 0x77DA, 0x8B9A,
    0x9477, 0x97C9, 0x9A62, 0x9A65, 0x7E9C, 0x8B9C, 0x8EAA, 0x91C5,
    0x947D, 0x947E, 0x947C, 0x9C77, 0x9C78, 0x9EF7, 0x8C54, 0x947F,
    0x9E1A, 0x7228, 0x9A6A, 0x9B31, 0x9E1B, 0x9E1E, 0x7C72,
    /* Big5-HKSCS 0xC6A1 .. 0xC6FE */
            0x2460, 0x2461, 0x2462, 0x2463, 0x2464, 0x2465, 0x2466,
    0x2467, 0x2468, 0x2469, 0x2474, 0x2475, 0x2476, 0x2477, 0x2478,
    0x2479, 0x247A, 0x247B, 0x247C, 0x247D, 0x2170, 0x2171, 0x2172,
    0x2173, 0x2174, 0x2175, 0x2176, 0x2177, 0x2178, 0x2179, 0x4E36,
    0x4E3F, 0x4E85, 0x4EA0, 0x5182, 0x5196, 0x51AB, 0x52F9, 0x5338,
    0x5369, 0x53B6, 0x590A, 0x5B80, 0x5DDB, 0x2F33, 0x5E7F, 0xF6DF,
    0x5F50, 0x5F61, 0x6534, 0xF6E3, 0x7592, 0xF6E5, 0x8FB5, 0xF6E7,
    0x00A8, 0x02C6, 0x30FD, 0x30FE, 0x309D, 0x309E, 0xF6EE, 0xF6EF,
    0x3005, 0x3006, 0x3007, 0x30FC, 0xFF3B, 0xFF3D, 0x273D, 0x3041,
    0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047, 0x3048, 0x3049,
    0x304A, 0x304B, 0x304C, 0x304D, 0x304E, 0x304F, 0x3050, 0x3051,
    0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3057, 0x3058,
    /* Big5-HKSCS 0xC740 .. 0xC77E */
    0x3059, 0x305A, 0x305B, 0x305C, 0x305D, 0x305E, 0x305F, 0x3060,
    0x3061, 0x3062, 0x3063, 0x3064, 0x3065, 0x3066, 0x3067, 0x3068,
    0x3069, 0x306A, 0x306B, 0x306C, 0x306D, 0x306E, 0x306F, 0x3070,
    0x3071, 0x3072, 0x3073, 0x3074, 0x3075, 0x3076, 0x3077, 0x3078,
    0x3079, 0x307A, 0x307B, 0x307C, 0x307D, 0x307E, 0x307F, 0x3080,
    0x3081, 0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087, 0x3088,
    0x3089, 0x308A, 0x308B, 0x308C, 0x308D, 0x308E, 0x308F, 0x3090,
    0x3091, 0x3092, 0x3093, 0x30A1, 0x30A2, 0x30A3, 0x30A4,
    /* Big5-HKSCS 0xC7A1 .. 0xC7FE */
            0x30A5, 0x30A6, 0x30A7, 0x30A8, 0x30A9, 0x30AA, 0x30AB,
    0x30AC, 0x30AD, 0x30AE, 0x30AF, 0x30B0, 0x30B1, 0x30B2, 0x30B3,
    0x30B4, 0x30B5, 0x30B6, 0x30B7, 0x30B8, 0x30B9, 0x30BA, 0x30BB,
    0x30BC, 0x30BD, 0x30BE, 0x30BF, 0x30C0, 0x30C1, 0x30C2, 0x30C3,
    0x30C4, 0x30C5, 0x30C6, 0x30C7, 0x30C8, 0x30C9, 0x30CA, 0x30CB,
    0x30CC, 0x30CD, 0x30CE, 0x30CF, 0x30D0, 0x30D1, 0x30D2, 0x30D3,
    0x30D4, 0x30D5, 0x30D6, 0x30D7, 0x30D8, 0x30D9, 0x30DA, 0x30DB,
    0x30DC, 0x30DD, 0x30DE, 0x30DF, 0x30E0, 0x30E1, 0x30E2, 0x30E3,
    0x30E4, 0x30E5, 0x30E6, 0x30E7, 0x30E8, 0x30E9, 0x30EA, 0x30EB,
    0x30EC, 0x30ED, 0x30EE, 0x30EF, 0x30F0, 0x30F1, 0x30F2, 0x30F3,
    0x30F4, 0x30F5, 0x30F6, 0x0410, 0x0411, 0x0412, 0x0413, 0x0414,
    0x0415, 0x0401, 0x0416, 0x0417, 0x0418, 0x0419, 0x041A,
    /* Big5-HKSCS 0xC840 .. 0xC87E */
    0x041B, 0x041C, 0x041D, 0x041E, 0x041F, 0x0420, 0x0421, 0x0422,
    0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042A,
    0x042B, 0x042C, 0x042D, 0x042E, 0x042F, 0x0430, 0x0431, 0x0432,
    0x0433, 0x0434, 0x0435, 0x0451, 0x0436, 0x0437, 0x0438, 0x0439,
    0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F, 0x0440, 0x0441,
    0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 0x0448, 0x0449,
    0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F, 0x21E7, 0x21B8,
    0x21B9, 0xF7E5, 0xF7E6, 0x4E5A, 0xF7E8, 0x5202, 0xF7EA,
    /* Big5-HKSCS 0xC8A1 .. 0xC8FE */
            0xF7EB, 0x5188, 0xF7ED, 0xF7EE, 0xF7EF, 0xF7F0, 0xF7F1,
    0xF7F2, 0xF7F3, 0xF7F4, 0xF7F5, 0xF7F6, 0xF7F7, 0xF7F8, 0xF7F9,
    0xF7FA, 0xF7FB, 0xF7FC, 0xF7FD, 0xF7FE, 0xF7FF, 0xF800, 0xF801,
    0xF802, 0xF803, 0xF804, 0xF805, 0xF806, 0xF807, 0xF808, 0xF809,
    0xF80A, 0xF80B, 0xF80C, 0xF80D, 0xF80E, 0xF80F, 0xF810, 0xF811,
    0xF812, 0xF813, 0xF814, 0xF815, 0xF816, 0xFFE2, 0xFFE4, 0xFF07,
    0xFF02, 0x3231, 0x2116, 0x2121, 0x309B, 0x309C, 0x2E80, 0x2E84,
    0x2E86, 0x2E87, 0x2E88, 0x2E8A, 0x2E8C, 0x2E8D, 0x2E95, 0x2E9C,
    0x2E9D, 0x2EA5, 0x2EA7, 0x2EAA, 0x2EAC, 0x2EAE, 0x2EB6, 0x2EBC,
    0x2EBE, 0x2EC6, 0x2ECA, 0x2ECC, 0x2ECD, 0x2ECF, 0x2ED6, 0x2ED7,
    0x2EDE, 0x2EE3, 0xF83C, 0xF83D, 0xF83E, 0x0283, 0x0250, 0x025B,
    0x0254, 0x0275, 0x0153, 0x00F8, 0x014B, 0x028A, 0x026A,
    /* Big5-HKSCS 0xC940 .. 0xC97E */
    0x4E42, 0x4E5C, 0x51F5, 0x531A, 0x5382, 0x4E07, 0x4E0C, 0x4E47,
    0x4E8D, 0x56D7, 0xFA0C, 0x5C6E, 0x5F73, 0x4E0F, 0x5187, 0x4E0E,
    0x4E2E, 0x4E93, 0x4EC2, 0x4EC9, 0x4EC8, 0x5198, 0x52FC, 0x536C,
    0x53B9, 0x5720, 0x5903, 0x592C, 0x5C10, 0x5DFF, 0x65E1, 0x6BB3,
    0x6BCC, 0x6C14, 0x723F, 0x4E31, 0x4E3C, 0x4EE8, 0x4EDC, 0x4EE9,
    0x4EE1, 0x4EDD, 0x4EDA, 0x520C, 0x531C, 0x534C, 0x5722, 0x5723,
    0x5917, 0x592F, 0x5B81, 0x5B84, 0x5C12, 0x5C3B, 0x5C74, 0x5C73,
    0x5E04, 0x5E80, 0x5E82, 0x5FC9, 0x6209, 0x6250, 0x6C15,
    /* Big5-HKSCS 0xC9A1 .. 0xC9FE */
            0x6C36, 0x6C43, 0x6C3F, 0x6C3B, 0x72AE, 0x72B0, 0x738A,
    0x79B8, 0x808A, 0x961E, 0x4F0E, 0x4F18, 0x4F2C, 0x4EF5, 0x4F14,
    0x4EF1, 0x4F00, 0x4EF7, 0x4F08, 0x4F1D, 0x4F02, 0x4F05, 0x4F22,
    0x4F13, 0x4F04, 0x4EF4, 0x4F12, 0x51B1, 0x5213, 0x5209, 0x5210,
    0x52A6, 0x5322, 0x531F, 0x534D, 0x538A, 0x5407, 0x56E1, 0x56DF,
    0x572E, 0x572A, 0x5734, 0x593C, 0x5980, 0x597C, 0x5985, 0x597B,
    0x597E, 0x5977, 0x597F, 0x5B56, 0x5C15, 0x5C25, 0x5C7C, 0x5C7A,
    0x5C7B, 0x5C7E, 0x5DDF, 0x5E75, 0x5E84, 0x5F02, 0x5F1A, 0x5F74,
    0x5FD5, 0x5FD4, 0x5FCF, 0x625C, 0x625E, 0x6264, 0x6261, 0x6266,
    0x6262, 0x6259, 0x6260, 0x625A, 0x6265, 0x65EF, 0x65EE, 0x673E,
    0x6739, 0x6738, 0x673B, 0x673A, 0x673F, 0x673C, 0x6733, 0x6C18,
    0x6C46, 0x6C52, 0x6C5C, 0x6C4F, 0x6C4A, 0x6C54, 0x6C4B,
    /* Big5-HKSCS 0xCA40 .. 0xCA7E */
    0x6C4C, 0x7071, 0x725E, 0x72B4, 0x72B5, 0x738E, 0x752A, 0x767F,
    0x7A75, 0x7F51, 0x8278, 0x827C, 0x8280, 0x827D, 0x827F, 0x864D,
    0x897E, 0x9099, 0x9097, 0x9098, 0x909B, 0x9094, 0x9622, 0x9624,
    0x9620, 0x9623, 0x4F56, 0x4F3B, 0x4F62, 0x4F49, 0x4F53, 0x4F64,
    0x4F3E, 0x4F67, 0x4F52, 0x4F5F, 0x4F41, 0x4F58, 0x4F2D, 0x4F33,
    0x4F3F, 0x4F61, 0x518F, 0x51B9, 0x521C, 0x521E, 0x5221, 0x52AD,
    0x52AE, 0x5309, 0x5363, 0x5372, 0x538E, 0x538F, 0x5430, 0x5437,
    0x542A, 0x5454, 0x5445, 0x5419, 0x541C, 0x5425, 0x5418,
    /* Big5-HKSCS 0xCAA1 .. 0xCAFE */
            0x543D, 0x544F, 0x5441, 0x5428, 0x5424, 0x5447, 0x56EE,
    0x56E7, 0x56E5, 0x5741, 0x5745, 0x574C, 0x5749, 0x574B, 0x5752,
    0x5906, 0x5940, 0x59A6, 0x5998, 0x59A0, 0x5997, 0x598E, 0x59A2,
    0x5990, 0x598F, 0x59A7, 0x59A1, 0x5B8E, 0x5B92, 0x5C28, 0x5C2A,
    0x5C8D, 0x5C8F, 0x5C88, 0x5C8B, 0x5C89, 0x5C92, 0x5C8A, 0x5C86,
    0x5C93, 0x5C95, 0x5DE0, 0x5E0A, 0x5E0E, 0x5E8B, 0x5E89, 0x5E8C,
    0x5E88, 0x5E8D, 0x5F05, 0x5F1D, 0x5F78, 0x5F76, 0x5FD2, 0x5FD1,
    0x5FD0, 0x5FED, 0x5FE8, 0x5FEE, 0x5FF3, 0x5FE1, 0x5FE4, 0x5FE3,
    0x5FFA, 0x5FEF, 0x5FF7, 0x5FFB, 0x6000, 0x5FF4, 0x623A, 0x6283,
    0x628C, 0x628E, 0x628F, 0x6294, 0x6287, 0x6271, 0x627B, 0x627A,
    0x6270, 0x6281, 0x6288, 0x6277, 0x627D, 0x6272, 0x6274, 0x6537,
    0x65F0, 0x65F4, 0x65F3, 0x65F2, 0x65F5, 0x6745, 0x6747,
    /* Big5-HKSCS 0xCB40 .. 0xCB7E */
    0x6759, 0x6755, 0x674C, 0x6748, 0x675D, 0x674D, 0x675A, 0x674B,
    0x6BD0, 0x6C19, 0x6C1A, 0x6C78, 0x6C67, 0x6C6B, 0x6C84, 0x6C8B,
    0x6C8F, 0x6C71, 0x6C6F, 0x6C69, 0x6C9A, 0x6C6D, 0x6C87, 0x6C95,
    0x6C9C, 0x6C66, 0x6C73, 0x6C65, 0x6C7B, 0x6C8E, 0x7074, 0x707A,
    0x7263, 0x72BF, 0x72BD, 0x72C3, 0x72C6, 0x72C1, 0x72BA, 0x72C5,
    0x7395, 0x7397, 0x7393, 0x7394, 0x7392, 0x753A, 0x7539, 0x7594,
    0x7595, 0x7681, 0x793D, 0x8034, 0x8095, 0x8099, 0x8090, 0x8092,
    0x809C, 0x8290, 0x828F, 0x8285, 0x828E, 0x8291, 0x8293,
    /* Big5-HKSCS 0xCBA1 .. 0xCBFE */
            0x828A, 0x8283, 0x8284, 0x8C78, 0x8FC9, 0x8FBF, 0x909F,
    0x90A1, 0x90A5, 0x909E, 0x90A7, 0x90A0, 0x9630, 0x9628, 0x962F,
    0x962D, 0x4E33, 0x4F98, 0x4F7C, 0x4F85, 0x4F7D, 0x4F80, 0x4F87,
    0x4F76, 0x4F74, 0x4F89, 0x4F84, 0x4F77, 0x4F4C, 0x4F97, 0x4F6A,
    0x4F9A, 0x4F79, 0x4F81, 0x4F78, 0x4F90, 0x4F9C, 0x4F94, 0x4F9E,
    0x4F92, 0x4F82, 0x4F95, 0x4F6B, 0x4F6E, 0x519E, 0x51BC, 0x51BE,
    0x5235, 0x5232, 0x5233, 0x5246, 0x5231, 0x52BC, 0x530A, 0x530B,
    0x533C, 0x5392, 0x5394, 0x5487, 0x547F, 0x5481, 0x5491, 0x5482,
    0x5488, 0x546B, 0x547A, 0x547E, 0x5465, 0x546C, 0x5474, 0x5466,
    0x548D, 0x546F, 0x5461, 0x5460, 0x5498, 0x5463, 0x5467, 0x5464,
    0x56F7, 0x56F9, 0x576F, 0x5772, 0x576D, 0x576B, 0x5771, 0x5770,
    0x5776, 0x5780, 0x5775, 0x577B, 0x5773, 0x5774, 0x5762,
    /* Big5-HKSCS 0xCC40 .. 0xCC7E */
    0x5768, 0x577D, 0x590C, 0x5945, 0x59B5, 0x59BA, 0x59CF, 0x59CE,
    0x59B2, 0x59CC, 0x59C1, 0x59B6, 0x59BC, 0x59C3, 0x59D6, 0x59B1,
    0x59BD, 0x59C0, 0x59C8, 0x59B4, 0x59C7, 0x5B62, 0x5B65, 0x5B93,
    0x5B95, 0x5C44, 0x5C47, 0x5CAE, 0x5CA4, 0x5CA0, 0x5CB5, 0x5CAF,
    0x5CA8, 0x5CAC, 0x5C9F, 0x5CA3, 0x5CAD, 0x5CA2, 0x5CAA, 0x5CA7,
    0x5C9D, 0x5CA5, 0x5CB6, 0x5CB0, 0x5CA6, 0x5E17, 0x5E14, 0x5E19,
    0x5F28, 0x5F22, 0x5F23, 0x5F24, 0x5F54, 0x5F82, 0x5F7E, 0x5F7D,
    0x5FDE, 0x5FE5, 0x602D, 0x6026, 0x6019, 0x6032, 0x600B,
    /* Big5-HKSCS 0xCCA1 .. 0xCCFE */
            0x6034, 0x600A, 0x6017, 0x6033, 0x601A, 0x601E, 0x602C,
    0x6022, 0x600D, 0x6010, 0x602E, 0x6013, 0x6011, 0x600C, 0x6009,
    0x601C, 0x6214, 0x623D, 0x62AD, 0x62B4, 0x62D1, 0x62BE, 0x62AA,
    0x62B6, 0x62CA, 0x62AE, 0x62B3, 0x62AF, 0x62BB, 0x62A9, 0x62B0,
    0x62B8, 0x653D, 0x65A8, 0x65BB, 0x6609, 0x65FC, 0x6604, 0x6612,
    0x6608, 0x65FB, 0x6603, 0x660B, 0x660D, 0x6605, 0x65FD, 0x6611,
    0x6610, 0x66F6, 0x670A, 0x6785, 0x676C, 0x678E, 0x6792, 0x6776,
    0x677B, 0x6798, 0x6786, 0x6784, 0x6774, 0x678D, 0x678C, 0x677A,
    0x679F, 0x6791, 0x6799, 0x6783, 0x677D, 0x6781, 0x6778, 0x6779,
    0x6794, 0x6B25, 0x6B80, 0x6B7E, 0x6BDE, 0x6C1D, 0x6C93, 0x6CEC,
    0x6CEB, 0x6CEE, 0x6CD9, 0x6CB6, 0x6CD4, 0x6CAD, 0x6CE7, 0x6CB7,
    0x6CD0, 0x6CC2, 0x6CBA, 0x6CC3, 0x6CC6, 0x6CED, 0x6CF2,
    /* Big5-HKSCS 0xCD40 .. 0xCD7E */
    0x6CD2, 0x6CDD, 0x6CB4, 0x6C8A, 0x6C9D, 0x6C80, 0x6CDE, 0x6CC0,
    0x6D30, 0x6CCD, 0x6CC7, 0x6CB0, 0x6CF9, 0x6CCF, 0x6CE9, 0x6CD1,
    0x7094, 0x7098, 0x7085, 0x7093, 0x7086, 0x7084, 0x7091, 0x7096,
    0x7082, 0x709A, 0x7083, 0x726A, 0x72D6, 0x72CB, 0x72D8, 0x72C9,
    0x72DC, 0x72D2, 0x72D4, 0x72DA, 0x72CC, 0x72D1, 0x73A4, 0x73A1,
    0x73AD, 0x73A6, 0x73A2, 0x73A0, 0x73AC, 0x739D, 0x74DD, 0x74E8,
    0x753F, 0x7540, 0x753E, 0x758C, 0x7598, 0x76AF, 0x76F3, 0x76F1,
    0x76F0, 0x76F5, 0x77F8, 0x77FC, 0x77F9, 0x77FB, 0x77FA,
    /* Big5-HKSCS 0xCDA1 .. 0xCDFE */
            0x77F7, 0x7942, 0x793F, 0x79C5, 0x7A78, 0x7A7B, 0x7AFB,
    0x7C75, 0x7CFD, 0x8035, 0x808F, 0x80AE, 0x80A3, 0x80B8, 0x80B5,
    0x80AD, 0x8220, 0x82A0, 0x82C0, 0x82AB, 0x829A, 0x8298, 0x829B,
    0x82B5, 0x82A7, 0x82AE, 0x82BC, 0x829E, 0x82BA, 0x82B4, 0x82A8,
    0x82A1, 0x82A9, 0x82C2, 0x82A4, 0x82C3, 0x82B6, 0x82A2, 0x8670,
    0x866F, 0x866D, 0x866E, 0x8C56, 0x8FD2, 0x8FCB, 0x8FD3, 0x8FCD,
    0x8FD6, 0x8FD5, 0x8FD7, 0x90B2, 0x90B4, 0x90AF, 0x90B3, 0x90B0,
    0x9639, 0x963D, 0x963C, 0x963A, 0x9643, 0x4FCD, 0x4FC5, 0x4FD3,
    0x4FB2, 0x4FC9, 0x4FCB, 0x4FC1, 0x4FD4, 0x4FDC, 0x4FD9, 0x4FBB,
    0x4FB3, 0x4FDB, 0x4FC7, 0x4FD6, 0x4FBA, 0x4FC0, 0x4FB9, 0x4FEC,
    0x5244, 0x5249, 0x52C0, 0x52C2, 0x533D, 0x537C, 0x5397, 0x5396,
    0x5399, 0x5398, 0x54BA, 0x54A1, 0x54AD, 0x54A5, 0x54CF,
    /* Big5-HKSCS 0xCE40 .. 0xCE7E */
    0x54C3, 0x830D, 0x54B7, 0x54AE, 0x54D6, 0x54B6, 0x54C5, 0x54C6,
    0x54A0, 0x5470, 0x54BC, 0x54A2, 0x54BE, 0x5472, 0x54DE, 0x54B0,
    0x57B5, 0x579E, 0x579F, 0x57A4, 0x578C, 0x5797, 0x579D, 0x579B,
    0x5794, 0x5798, 0x578F, 0x5799, 0x57A5, 0x579A, 0x5795, 0x58F4,
    0x590D, 0x5953, 0x59E1, 0x59DE, 0x59EE, 0x5A00, 0x59F1, 0x59DD,
    0x59FA, 0x59FD, 0x59FC, 0x59F6, 0x59E4, 0x59F2, 0x59F7, 0x59DB,
    0x59E9, 0x59F3, 0x59F5, 0x59E0, 0x59FE, 0x59F4, 0x59ED, 0x5BA8,
    0x5C4C, 0x5CD0, 0x5CD8, 0x5CCC, 0x5CD7, 0x5CCB, 0x5CDB,
    /* Big5-HKSCS 0xCEA1 .. 0xCEFE */
            0x5CDE, 0x5CDA, 0x5CC9, 0x5CC7, 0x5CCA, 0x5CD6, 0x5CD3,
    0x5CD4, 0x5CCF, 0x5CC8, 0x5CC6, 0x5CCE, 0x5CDF, 0x5CF8, 0x5DF9,
    0x5E21, 0x5E22, 0x5E23, 0x5E20, 0x5E24, 0x5EB0, 0x5EA4, 0x5EA2,
    0x5E9B, 0x5EA3, 0x5EA5, 0x5F07, 0x5F2E, 0x5F56, 0x5F86, 0x6037,
    0x6039, 0x6054, 0x6072, 0x605E, 0x6045, 0x6053, 0x6047, 0x6049,
    0x605B, 0x604C, 0x6040, 0x6042, 0x605F, 0x6024, 0x6044, 0x6058,
    0x6066, 0x606E, 0x6242, 0x6243, 0x62CF, 0x630D, 0x630B, 0x62F5,
    0x630E, 0x6303, 0x62EB, 0x62F9, 0x630F, 0x630C, 0x62F8, 0x62F6,
    0x6300, 0x6313, 0x6314, 0x62FA, 0x6315, 0x62FB, 0x62F0, 0x6541,
    0x6543, 0x65AA, 0x65BF, 0x6636, 0x6621, 0x6632, 0x6635, 0x661C,
    0x6626, 0x6622, 0x6633, 0x662B, 0x663A, 0x661D, 0x6634, 0x6639,
    0x662E, 0x670F, 0x6710, 0x67C1, 0x67F2, 0x67C8, 0x67BA,
    /* Big5-HKSCS 0xCF40 .. 0xCF7E */
    0x67DC, 0x67BB, 0x67F8, 0x67D8, 0x67C0, 0x67B7, 0x67C5, 0x67EB,
    0x67E4, 0x67DF, 0x67B5, 0x67CD, 0x67B3, 0x67F7, 0x67F6, 0x67EE,
    0x67E3, 0x67C2, 0x67B9, 0x67CE, 0x67E7, 0x67F0, 0x67B2, 0x67FC,
    0x67C6, 0x67ED, 0x67CC, 0x67AE, 0x67E6, 0x67DB, 0x67FA, 0x67C9,
    0x67CA, 0x67C3, 0x67EA, 0x67CB, 0x6B28, 0x6B82, 0x6B84, 0x6BB6,
    0x6BD6, 0x6BD8, 0x6BE0, 0x6C20, 0x6C21, 0x6D28, 0x6D34, 0x6D2D,
    0x6D1F, 0x6D3C, 0x6D3F, 0x6D12, 0x6D0A, 0x6CDA, 0x6D33, 0x6D04,
    0x6D19, 0x6D3A, 0x6D1A, 0x6D11, 0x6D00, 0x6D1D, 0x6D42,
    /* Big5-HKSCS 0xCFA1 .. 0xCFFE */
            0x6D01, 0x6D18, 0x6D37, 0x6D03, 0x6D0F, 0x6D40, 0x6D07,
    0x6D20, 0x6D2C, 0x6D08, 0x6D22, 0x6D09, 0x6D10, 0x70B7, 0x709F,
    0x70BE, 0x70B1, 0x70B0, 0x70A1, 0x70B4, 0x70B5, 0x70A9, 0x7241,
    0x7249, 0x724A, 0x726C, 0x7270, 0x7273, 0x726E, 0x72CA, 0x72E4,
    0x72E8, 0x72EB, 0x72DF, 0x72EA, 0x72E6, 0x72E3, 0x7385, 0x73CC,
    0x73C2, 0x73C8, 0x73C5, 0x73B9, 0x73B6, 0x73B5, 0x73B4, 0x73EB,
    0x73BF, 0x73C7, 0x73BE, 0x73C3, 0x73C6, 0x73B8, 0x73CB, 0x74EC,
    0x74EE, 0x752E, 0x7547, 0x7548, 0x75A7, 0x75AA, 0x7679, 0x76C4,
    0x7708, 0x7703, 0x7704, 0x7705, 0x770A, 0x76F7, 0x76FB, 0x76FA,
    0x77E7, 0x77E8, 0x7806, 0x7811, 0x7812, 0x7805, 0x7810, 0x780F,
    0x780E, 0x7809, 0x7803, 0x7813, 0x794A, 0x794C, 0x794B, 0x7945,
    0x7944, 0x79D5, 0x79CD, 0x79CF, 0x79D6, 0x79CE, 0x7A80,
    /* Big5-HKSCS 0xD040 .. 0xD07E */
    0x7A7E, 0x7AD1, 0x7B00, 0x7B01, 0x7C7A, 0x7C78, 0x7C79, 0x7C7F,
    0x7C80, 0x7C81, 0x7D03, 0x7D08, 0x7D01, 0x7F58, 0x7F91, 0x7F8D,
    0x7FBE, 0x8007, 0x800E, 0x800F, 0x8014, 0x8037, 0x80D8, 0x80C7,
    0x80E0, 0x80D1, 0x80C8, 0x80C2, 0x80D0, 0x80C5, 0x80E3, 0x80D9,
    0x80DC, 0x80CA, 0x80D5, 0x80C9, 0x80CF, 0x80D7, 0x80E6, 0x80CD,
    0x81FF, 0x8221, 0x8294, 0x82D9, 0x82FE, 0x82F9, 0x8307, 0x82E8,
    0x8300, 0x82D5, 0x833A, 0x82EB, 0x82D6, 0x82F4, 0x82EC, 0x82E1,
    0x82F2, 0x82F5, 0x830C, 0x82FB, 0x82F6, 0x82F0, 0x82EA,
    /* Big5-HKSCS 0xD0A1 .. 0xD0FE */
            0x82E4, 0x82E0, 0x82FA, 0x82F3, 0x82ED, 0x8677, 0x8674,
    0x867C, 0x8673, 0x8841, 0x884E, 0x8867, 0x886A, 0x8869, 0x89D3,
    0x8A04, 0x8A07, 0x8D72, 0x8FE3, 0x8FE1, 0x8FEE, 0x8FE0, 0x90F1,
    0x90BD, 0x90BF, 0x90D5, 0x90C5, 0x90BE, 0x90C7, 0x90CB, 0x90C8,
    0x91D4, 0x91D3, 0x9654, 0x964F, 0x9651, 0x9653, 0x964A, 0x964E,
    0x501E, 0x5005, 0x5007, 0x5013, 0x5022, 0x5030, 0x501B, 0x4FF5,
    0x4FF4, 0x5033, 0x5037, 0x502C, 0x4FF6, 0x4FF7, 0x5017, 0x501C,
    0x5020, 0x5027, 0x5035, 0x502F, 0x5031, 0x500E, 0x515A, 0x5194,
    0x5193, 0x51CA, 0x51C4, 0x51C5, 0x51C8, 0x51CE, 0x5261, 0x525A,
    0x5252, 0x525E, 0x525F, 0x5255, 0x5262, 0x52CD, 0x530E, 0x539E,
    0x5526, 0x54E2, 0x5517, 0x5512, 0x54E7, 0x54F3, 0x54E4, 0x551A,
    0x54FF, 0x5504, 0x5508, 0x54EB, 0x5511, 0x5505, 0x54F1,
    /* Big5-HKSCS 0xD140 .. 0xD17E */
    0x550A, 0x54FB, 0x54F7, 0x54F8, 0x54E0, 0x550E, 0x5503, 0x550B,
    0x5701, 0x5702, 0x57CC, 0x5832, 0x57D5, 0x57D2, 0x57BA, 0x57C6,
    0x57BD, 0x57BC, 0x57B8, 0x57B6, 0x57BF, 0x57C7, 0x57D0, 0x57B9,
    0x57C1, 0x590E, 0x594A, 0x5A19, 0x5A16, 0x5A2D, 0x5A2E, 0x5A15,
    0x5A0F, 0x5A17, 0x5A0A, 0x5A1E, 0x5A33, 0x5B6C, 0x5BA7, 0x5BAD,
    0x5BAC, 0x5C03, 0x5C56, 0x5C54, 0x5CEC, 0x5CFF, 0x5CEE, 0x5CF1,
    0x5CF7, 0x5D00, 0x5CF9, 0x5E29, 0x5E28, 0x5EA8, 0x5EAE, 0x5EAA,
    0x5EAC, 0x5F33, 0x5F30, 0x5F67, 0x605D, 0x605A, 0x6067,
    /* Big5-HKSCS 0xD1A1 .. 0xD1FE */
            0x6041, 0x60A2, 0x6088, 0x6080, 0x6092, 0x6081, 0x609D,
    0x6083, 0x6095, 0x609B, 0x6097, 0x6087, 0x609C, 0x608E, 0x6219,
    0x6246, 0x62F2, 0x6310, 0x6356, 0x632C, 0x6344, 0x6345, 0x6336,
    0x6343, 0x63E4, 0x6339, 0x634B, 0x634A, 0x633C, 0x6329, 0x6341,
    0x6334, 0x6358, 0x6354, 0x6359, 0x632D, 0x6347, 0x6333, 0x635A,
    0x6351, 0x6338, 0x6357, 0x6340, 0x6348, 0x654A, 0x6546, 0x65C6,
    0x65C3, 0x65C4, 0x65C2, 0x664A, 0x665F, 0x6647, 0x6651, 0x6712,
    0x6713, 0x681F, 0x681A, 0x6849, 0x6832, 0x6833, 0x683B, 0x684B,
    0x684F, 0x6816, 0x6831, 0x681C, 0x6835, 0x682B, 0x682D, 0x682F,
    0x684E, 0x6844, 0x6834, 0x681D, 0x6812, 0x6814, 0x6826, 0x6828,
    0x682E, 0x684D, 0x683A, 0x6825, 0x6820, 0x6B2C, 0x6B2F, 0x6B2D,
    0x6B31, 0x6B34, 0x6B6D, 0x8082, 0x6B88, 0x6BE6, 0x6BE4,
    /* Big5-HKSCS 0xD240 .. 0xD27E */
    0x6BE8, 0x6BE3, 0x6BE2, 0x6BE7, 0x6C25, 0x6D7A, 0x6D63, 0x6D64,
    0x6D76, 0x6D0D, 0x6D61, 0x6D92, 0x6D58, 0x6D62, 0x6D6D, 0x6D6F,
    0x6D91, 0x6D8D, 0x6DEF, 0x6D7F, 0x6D86, 0x6D5E, 0x6D67, 0x6D60,
    0x6D97, 0x6D70, 0x6D7C, 0x6D5F, 0x6D82, 0x6D98, 0x6D2F, 0x6D68,
    0x6D8B, 0x6D7E, 0x6D80, 0x6D84, 0x6D16, 0x6D83, 0x6D7B, 0x6D7D,
    0x6D75, 0x6D90, 0x70DC, 0x70D3, 0x70D1, 0x70DD, 0x70CB, 0x7F39,
    0x70E2, 0x70D7, 0x70D2, 0x70DE, 0x70E0, 0x70D4, 0x70CD, 0x70C5,
    0x70C6, 0x70C7, 0x70DA, 0x70CE, 0x70E1, 0x7242, 0x7278,
    /* Big5-HKSCS 0xD2A1 .. 0xD2FE */
            0x7277, 0x7276, 0x7300, 0x72FA, 0x72F4, 0x72FE, 0x72F6,
    0x72F3, 0x72FB, 0x7301, 0x73D3, 0x73D9, 0x73E5, 0x73D6, 0x73BC,
    0x73E7, 0x73E3, 0x73E9, 0x73DC, 0x73D2, 0x73DB, 0x73D4, 0x73DD,
    0x73DA, 0x73D7, 0x73D8, 0x73E8, 0x74DE, 0x74DF, 0x74F4, 0x74F5,
    0x7521, 0x755B, 0x755F, 0x75B0, 0x75C1, 0x75BB, 0x75C4, 0x75C0,
    0x75BF, 0x75B6, 0x75BA, 0x768A, 0x76C9, 0x771D, 0x771B, 0x7710,
    0x7713, 0x7712, 0x7723, 0x7711, 0x7715, 0x7719, 0x771A, 0x7722,
    0x7727, 0x7823, 0x782C, 0x7822, 0x7835, 0x782F, 0x7828, 0x782E,
    0x782B, 0x7821, 0x7829, 0x7833, 0x782A, 0x7831, 0x7954, 0x795B,
    0x794F, 0x795C, 0x7953, 0x7952, 0x7951, 0x79EB, 0x79EC, 0x79E0,
    0x79EE, 0x79ED, 0x79EA, 0x79DC, 0x79DE, 0x79DD, 0x7A86, 0x7A89,
    0x7A85, 0x7A8B, 0x7A8C, 0x7A8A, 0x7A87, 0x7AD8, 0x7B10,
    /* Big5-HKSCS 0xD340 .. 0xD37E */
    0x7B04, 0x7B13, 0x7B05, 0x7B0F, 0x7B08, 0x7B0A, 0x7B0E, 0x7B09,
    0x7B12, 0x7C84, 0x7C91, 0x7C8A, 0x7C8C, 0x7C88, 0x7C8D, 0x7C85,
    0x7D1E, 0x7D1D, 0x7D11, 0x7D0E, 0x7D18, 0x7D16, 0x7D13, 0x7D1F,
    0x7D12, 0x7D0F, 0x7D0C, 0x7F5C, 0x7F61, 0x7F5E, 0x7F60, 0x7F5D,
    0x7F5B, 0x7F96, 0x7F92, 0x7FC3, 0x7FC2, 0x7FC0, 0x8016, 0x803E,
    0x8039, 0x80FA, 0x80F2, 0x80F9, 0x80F5, 0x8101, 0x80FB, 0x8100,
    0x8201, 0x822F, 0x8225, 0x8333, 0x832D, 0x8344, 0x8319, 0x8351,
    0x8325, 0x8356, 0x833F, 0x8341, 0x8326, 0x831C, 0x8322,
    /* Big5-HKSCS 0xD3A1 .. 0xD3FE */
            0x8342, 0x834E, 0x831B, 0x832A, 0x8308, 0x833C, 0x834D,
    0x8316, 0x8324, 0x8320, 0x8337, 0x832F, 0x8329, 0x8347, 0x8345,
    0x834C, 0x8353, 0x831E, 0x832C, 0x834B, 0x8327, 0x8348, 0x8653,
    0x8652, 0x86A2, 0x86A8, 0x8696, 0x868D, 0x8691, 0x869E, 0x8687,
    0x8697, 0x8686, 0x868B, 0x869A, 0x8685, 0x86A5, 0x8699, 0x86A1,
    0x86A7, 0x8695, 0x8698, 0x868E, 0x869D, 0x8690, 0x8694, 0x8843,
    0x8844, 0x886D, 0x8875, 0x8876, 0x8872, 0x8880, 0x8871, 0x887F,
    0x886F, 0x8883, 0x887E, 0x8874, 0x887C, 0x8A12, 0x8C47, 0x8C57,
    0x8C7B, 0x8CA4, 0x8CA3, 0x8D76, 0x8D78, 0x8DB5, 0x8DB7, 0x8DB6,
    0x8ED1, 0x8ED3, 0x8FFE, 0x8FF5, 0x9002, 0x8FFF, 0x8FFB, 0x9004,
    0x8FFC, 0x8FF6, 0x90D6, 0x90E0, 0x90D9, 0x90DA, 0x90E3, 0x90DF,
    0x90E5, 0x90D8, 0x90DB, 0x90D7, 0x90DC, 0x90E4, 0x9150,
    /* Big5-HKSCS 0xD440 .. 0xD47E */
    0x914E, 0x914F, 0x91D5, 0x91E2, 0x91DA, 0x965C, 0x965F, 0x96BC,
    0x98E3, 0x9ADF, 0x9B2F, 0x4E7F, 0x5070, 0x506A, 0x5061, 0x505E,
    0x5060, 0x5053, 0x504B, 0x505D, 0x5072, 0x5048, 0x504D, 0x5041,
    0x505B, 0x504A, 0x5062, 0x5015, 0x5045, 0x505F, 0x5069, 0x506B,
    0x5063, 0x5064, 0x5046, 0x5040, 0x506E, 0x5073, 0x5057, 0x5051,
    0x51D0, 0x526B, 0x526D, 0x526C, 0x526E, 0x52D6, 0x52D3, 0x532D,
    0x539C, 0x5575, 0x5576, 0x553C, 0x554D, 0x5550, 0x5534, 0x552A,
    0x5551, 0x5562, 0x5536, 0x5535, 0x5530, 0x5552, 0x5545,
    /* Big5-HKSCS 0xD4A1 .. 0xD4FE */
            0x550C, 0x5532, 0x5565, 0x554E, 0x5539, 0x5548, 0x552D,
    0x553B, 0x5540, 0x554B, 0x570A, 0x5707, 0x57FB, 0x5814, 0x57E2,
    0x57F6, 0x57DC, 0x57F4, 0x5800, 0x57ED, 0x57FD, 0x5808, 0x57F8,
    0x580B, 0x57F3, 0x57CF, 0x5807, 0x57EE, 0x57E3, 0x57F2, 0x57E5,
    0x57EC, 0x57E1, 0x580E, 0x57FC, 0x5810, 0x57E7, 0x5801, 0x580C,
    0x57F1, 0x57E9, 0x57F0, 0x580D, 0x5804, 0x595C, 0x5A60, 0x5A58,
    0x5A55, 0x5A67, 0x5A5E, 0x5A38, 0x5A35, 0x5A6D, 0x5A50, 0x5A5F,
    0x5A65, 0x5A6C, 0x5A53, 0x5A64, 0x5A57, 0x5A43, 0x5A5D, 0x5A52,
    0x5A44, 0x5A5B, 0x5A48, 0x5A8E, 0x5A3E, 0x5A4D, 0x5A39, 0x5A4C,
    0x5A70, 0x5A69, 0x5A47, 0x5A51, 0x5A56, 0x5A42, 0x5A5C, 0x5B72,
    0x5B6E, 0x5BC1, 0x5BC0, 0x5C59, 0x5D1E, 0x5D0B, 0x5D1D, 0x5D1A,
    0x5D20, 0x5D0C, 0x5D28, 0x5D0D, 0x5D26, 0x5D25, 0x5D0F,
    /* Big5-HKSCS 0xD540 .. 0xD57E */
    0x5D30, 0x5D12, 0x5D23, 0x5D1F, 0x5D2E, 0x5E3E, 0x5E34, 0x5EB1,
    0x5EB4, 0x5EB9, 0x5EB2, 0x5EB3, 0x5F36, 0x5F38, 0x5F9B, 0x5F96,
    0x5F9F, 0x608A, 0x6090, 0x6086, 0x60BE, 0x60B0, 0x60BA, 0x60D3,
    0x60D4, 0x60CF, 0x60E4, 0x60D9, 0x60DD, 0x60C8, 0x60B1, 0x60DB,
    0x60B7, 0x60CA, 0x60BF, 0x60C3, 0x60CD, 0x60C0, 0x6332, 0x6365,
    0x638A, 0x6382, 0x637D, 0x63BD, 0x639E, 0x63AD, 0x639D, 0x6397,
    0x63AB, 0x638E, 0x636F, 0x6387, 0x6390, 0x636E, 0x63AF, 0x6375,
    0x639C, 0x636D, 0x63AE, 0x637C, 0x63A4, 0x633B, 0x639F,
    /* Big5-HKSCS 0xD5A1 .. 0xD5FE */
            0x6378, 0x6385, 0x6381, 0x6391, 0x638D, 0x6370, 0x6553,
    0x65CD, 0x6665, 0x6661, 0x665B, 0x6659, 0x665C, 0x6662, 0x6718,
    0x6879, 0x6887, 0x6890, 0x689C, 0x686D, 0x686E, 0x68AE, 0x68AB,
    0x6956, 0x686F, 0x68A3, 0x68AC, 0x68A9, 0x6875, 0x6874, 0x68B2,
    0x688F, 0x6877, 0x6892, 0x687C, 0x686B, 0x6872, 0x68AA, 0x6880,
    0x6871, 0x687E, 0x689B, 0x6896, 0x688B, 0x68A0, 0x6889, 0x68A4,
    0x6878, 0x687B, 0x6891, 0x688C, 0x688A, 0x687D, 0x6B36, 0x6B33,
    0x6B37, 0x6B38, 0x6B91, 0x6B8F, 0x6B8D, 0x6B8E, 0x6B8C, 0x6C2A,
    0x6DC0, 0x6DAB, 0x6DB4, 0x6DB3, 0x6E74, 0x6DAC, 0x6DE9, 0x6DE2,
    0x6DB7, 0x6DF6, 0x6DD4, 0x6E00, 0x6DC8, 0x6DE0, 0x6DDF, 0x6DD6,
    0x6DBE, 0x6DE5, 0x6DDC, 0x6DDD, 0x6DDB, 0x6DF4, 0x6DCA, 0x6DBD,
    0x6DED, 0x6DF0, 0x6DBA, 0x6DD5, 0x6DC2, 0x6DCF, 0x6DC9,
    /* Big5-HKSCS 0xD640 .. 0xD67E */
    0x6DD0, 0x6DF2, 0x6DD3, 0x6DFD, 0x6DD7, 0x6DCD, 0x6DE3, 0x6DBB,
    0x70FA, 0x710D, 0x70F7, 0x7117, 0x70F4, 0x710C, 0x70F0, 0x7104,
    0x70F3, 0x7110, 0x70FC, 0x70FF, 0x7106, 0x7113, 0x7100, 0x70F8,
    0x70F6, 0x710B, 0x7102, 0x710E, 0x727E, 0x727B, 0x727C, 0x727F,
    0x731D, 0x7317, 0x7307, 0x7311, 0x7318, 0x730A, 0x7308, 0x72FF,
    0x730F, 0x731E, 0x7388, 0x73F6, 0x73F8, 0x73F5, 0x7404, 0x7401,
    0x73FD, 0x7407, 0x7400, 0x73FA, 0x73FC, 0x73FF, 0x740C, 0x740B,
    0x73F4, 0x7408, 0x7564, 0x7563, 0x75CE, 0x75D2, 0x75CF,
    /* Big5-HKSCS 0xD6A1 .. 0xD6FE */
            0x75CB, 0x75CC, 0x75D1, 0x75D0, 0x768F, 0x7689, 0x76D3,
    0x7739, 0x772F, 0x772D, 0x7731, 0x7732, 0x7734, 0x7733, 0x773D,
    0x7725, 0x773B, 0x7735, 0x7848, 0x7852, 0x7849, 0x784D, 0x784A,
    0x784C, 0x7826, 0x7845, 0x7850, 0x7964, 0x7967, 0x7969, 0x796A,
    0x7963, 0x796B, 0x7961, 0x79BB, 0x79FA, 0x79F8, 0x79F6, 0x79F7,
    0x7A8F, 0x7A94, 0x7A90, 0x7B35, 0x7B47, 0x7B34, 0x7B25, 0x7B30,
    0x7B22, 0x7B24, 0x7B33, 0x7B18, 0x7B2A, 0x7B1D, 0x7B31, 0x7B2B,
    0x7B2D, 0x7B2F, 0x7B32, 0x7B38, 0x7B1A, 0x7B23, 0x7C94, 0x7C98,
    0x7C96, 0x7CA3, 0x7D35, 0x7D3D, 0x7D38, 0x7D36, 0x7D3A, 0x7D45,
    0x7D2C, 0x7D29, 0x7D41, 0x7D47, 0x7D3E, 0x7D3F, 0x7D4A, 0x7D3B,
    0x7D28, 0x7F63, 0x7F95, 0x7F9C, 0x7F9D, 0x7F9B, 0x7FCA, 0x7FCB,
    0x7FCD, 0x7FD0, 0x7FD1, 0x7FC7, 0x7FCF, 0x7FC9, 0x801F,
    /* Big5-HKSCS 0xD740 .. 0xD77E */
    0x801E, 0x801B, 0x8047, 0x8043, 0x8048, 0x8118, 0x8125, 0x8119,
    0x811B, 0x812D, 0x811F, 0x812C, 0x811E, 0x8121, 0x8115, 0x8127,
    0x811D, 0x8122, 0x8211, 0x8238, 0x8233, 0x823A, 0x8234, 0x8232,
    0x8274, 0x8390, 0x83A3, 0x83A8, 0x838D, 0x837A, 0x8373, 0x83A4,
    0x8374, 0x838F, 0x8381, 0x8395, 0x8399, 0x8375, 0x8394, 0x83A9,
    0x837D, 0x8383, 0x838C, 0x839D, 0x839B, 0x83AA, 0x838B, 0x837E,
    0x83A5, 0x83AF, 0x8388, 0x8397, 0x83B0, 0x837F, 0x83A6, 0x8387,
    0x83AE, 0x8376, 0x839A, 0x8659, 0x8656, 0x86BF, 0x86B7,
    /* Big5-HKSCS 0xD7A1 .. 0xD7FE */
            0x86C2, 0x86C1, 0x86C5, 0x86BA, 0x86B0, 0x86C8, 0x86B9,
    0x86B3, 0x86B8, 0x86CC, 0x86B4, 0x86BB, 0x86BC, 0x86C3, 0x86BD,
    0x86BE, 0x8852, 0x8889, 0x8895, 0x88A8, 0x88A2, 0x88AA, 0x889A,
    0x8891, 0x88A1, 0x889F, 0x8898, 0x88A7, 0x8899, 0x889B, 0x8897,
    0x88A4, 0x88AC, 0x888C, 0x8893, 0x888E, 0x8982, 0x89D6, 0x89D9,
    0x89D5, 0x8A30, 0x8A27, 0x8A2C, 0x8A1E, 0x8C39, 0x8C3B, 0x8C5C,
    0x8C5D, 0x8C7D, 0x8CA5, 0x8D7D, 0x8D7B, 0x8D79, 0x8DBC, 0x8DC2,
    0x8DB9, 0x8DBF, 0x8DC1, 0x8ED8, 0x8EDE, 0x8EDD, 0x8EDC, 0x8ED7,
    0x8EE0, 0x8EE1, 0x9024, 0x900B, 0x9011, 0x901C, 0x900C, 0x9021,
    0x90EF, 0x90EA, 0x90F0, 0x90F4, 0x90F2, 0x90F3, 0x90D4, 0x90EB,
    0x90EC, 0x90E9, 0x9156, 0x9158, 0x915A, 0x9153, 0x9155, 0x91EC,
    0x91F4, 0x91F1, 0x91F3, 0x91F8, 0x91E4, 0x91F9, 0x91EA,
    /* Big5-HKSCS 0xD840 .. 0xD87E */
    0x91EB, 0x91F7, 0x91E8, 0x91EE, 0x957A, 0x9586, 0x9588, 0x967C,
    0x966D, 0x966B, 0x9671, 0x966F, 0x96BF, 0x976A, 0x9804, 0x98E5,
    0x9997, 0x509B, 0x5095, 0x5094, 0x509E, 0x508B, 0x50A3, 0x5083,
    0x508C, 0x508E, 0x509D, 0x5068, 0x509C, 0x5092, 0x5082, 0x5087,
    0x515F, 0x51D4, 0x5312, 0x5311, 0x53A4, 0x53A7, 0x5591, 0x55A8,
    0x55A5, 0x55AD, 0x5577, 0x5645, 0x55A2, 0x5593, 0x5588, 0x558F,
    0x55B5, 0x5581, 0x55A3, 0x5592, 0x55A4, 0x557D, 0x558C, 0x55A6,
    0x557F, 0x5595, 0x55A1, 0x558E, 0x570C, 0x5829, 0x5837,
    /* Big5-HKSCS 0xD8A1 .. 0xD8FE */
            0x5819, 0x581E, 0x5827, 0x5823, 0x5828, 0x57F5, 0x5848,
    0x5825, 0x581C, 0x581B, 0x5833, 0x583F, 0x5836, 0x582E, 0x5839,
    0x5838, 0x582D, 0x582C, 0x583B, 0x5961, 0x5AAF, 0x5A94, 0x5A9F,
    0x5A7A, 0x5AA2, 0x5A9E, 0x5A78, 0x5AA6, 0x5A7C, 0x5AA5, 0x5AAC,
    0x5A95, 0x5AAE, 0x5A37, 0x5A84, 0x5A8A, 0x5A97, 0x5A83, 0x5A8B,
    0x5AA9, 0x5A7B, 0x5A7D, 0x5A8C, 0x5A9C, 0x5A8F, 0x5A93, 0x5A9D,
    0x5BEA, 0x5BCD, 0x5BCB, 0x5BD4, 0x5BD1, 0x5BCA, 0x5BCE, 0x5C0C,
    0x5C30, 0x5D37, 0x5D43, 0x5D6B, 0x5D41, 0x5D4B, 0x5D3F, 0x5D35,
    0x5D51, 0x5D4E, 0x5D55, 0x5D33, 0x5D3A, 0x5D52, 0x5D3D, 0x5D31,
    0x5D59, 0x5D42, 0x5D39, 0x5D49, 0x5D38, 0x5D3C, 0x5D32, 0x5D36,
    0x5D40, 0x5D45, 0x5E44, 0x5E41, 0x5F58, 0x5FA6, 0x5FA5, 0x5FAB,
    0x60C9, 0x60B9, 0x60CC, 0x60E2, 0x60CE, 0x60C4, 0x6114,
    /* Big5-HKSCS 0xD940 .. 0xD97E */
    0x60F2, 0x610A, 0x6116, 0x6105, 0x60F5, 0x6113, 0x60F8, 0x60FC,
    0x60FE, 0x60C1, 0x6103, 0x6118, 0x611D, 0x6110, 0x60FF, 0x6104,
    0x610B, 0x624A, 0x6394, 0x63B1, 0x63B0, 0x63CE, 0x63E5, 0x63E8,
    0x63EF, 0x63C3, 0x649D, 0x63F3, 0x63CA, 0x63E0, 0x63F6, 0x63D5,
    0x63F2, 0x63F5, 0x6461, 0x63DF, 0x63BE, 0x63DD, 0x63DC, 0x63C4,
    0x63D8, 0x63D3, 0x63C2, 0x63C7, 0x63CC, 0x63CB, 0x63C8, 0x63F0,
    0x63D7, 0x63D9, 0x6532, 0x6567, 0x656A, 0x6564, 0x655C, 0x6568,
    0x6565, 0x658C, 0x659D, 0x659E, 0x65AE, 0x65D0, 0x65D2,
    /* Big5-HKSCS 0xD9A1 .. 0xD9FE */
            0x667C, 0x666C, 0x667B, 0x6680, 0x6671, 0x6679, 0x666A,
    0x6672, 0x6701, 0x690C, 0x68D3, 0x6904, 0x68DC, 0x692A, 0x68EC,
    0x68EA, 0x68F1, 0x690F, 0x68D6, 0x68F7, 0x68EB, 0x68E4, 0x68F6,
    0x6913, 0x6910, 0x68F3, 0x68E1, 0x6907, 0x68CC, 0x6908, 0x6970,
    0x68B4, 0x6911, 0x68EF, 0x68C6, 0x6914, 0x68F8, 0x68D0, 0x68FD,
    0x68FC, 0x68E8, 0x690B, 0x690A, 0x6917, 0x68CE, 0x68C8, 0x68DD,
    0x68DE, 0x68E6, 0x68F4, 0x68D1, 0x6906, 0x68D4, 0x68E9, 0x6915,
    0x6925, 0x68C7, 0x6B39, 0x6B3B, 0x6B3F, 0x6B3C, 0x6B94, 0x6B97,
    0x6B99, 0x6B95, 0x6BBD, 0x6BF0, 0x6BF2, 0x6BF3, 0x6C30, 0x6DFC,
    0x6E46, 0x6E47, 0x6E1F, 0x6E49, 0x6E88, 0x6E3C, 0x6E3D, 0x6E45,
    0x6E62, 0x6E2B, 0x6E3F, 0x6E41, 0x6E5D, 0x6E73, 0x6E1C, 0x6E33,
    0x6E4B, 0x6E40, 0x6E51, 0x6E3B, 0x6E03, 0x6E2E, 0x6E5E,
    /* Big5-HKSCS 0xDA40 .. 0xDA7E */
    0x6E68, 0x6E5C, 0x6E61, 0x6E31, 0x6E28, 0x6E60, 0x6E71, 0x6E6B,
    0x6E39, 0x6E22, 0x6E30, 0x6E53, 0x6E65, 0x6E27, 0x6E78, 0x6E64,
    0x6E77, 0x6E55, 0x6E79, 0x6E52, 0x6E66, 0x6E35, 0x6E36, 0x6E5A,
    0x7120, 0x711E, 0x712F, 0x70FB, 0x712E, 0x7131, 0x7123, 0x7125,
    0x7122, 0x7132, 0x711F, 0x7128, 0x713A, 0x711B, 0x724B, 0x725A,
    0x7288, 0x7289, 0x7286, 0x7285, 0x728B, 0x7312, 0x730B, 0x7330,
    0x7322, 0x7331, 0x7333, 0x7327, 0x7332, 0x732D, 0x7326, 0x7323,
    0x7335, 0x730C, 0x742E, 0x742C, 0x7430, 0x742B, 0x7416,
    /* Big5-HKSCS 0xDAA1 .. 0xDAFE */
            0x741A, 0x7421, 0x742D, 0x7431, 0x7424, 0x7423, 0x741D,
    0x7429, 0x7420, 0x7432, 0x74FB, 0x752F, 0x756F, 0x756C, 0x75E7,
    0x75DA, 0x75E1, 0x75E6, 0x75DD, 0x75DF, 0x75E4, 0x75D7, 0x7695,
    0x7692, 0x76DA, 0x7746, 0x7747, 0x7744, 0x774D, 0x7745, 0x774A,
    0x774E, 0x774B, 0x774C, 0x77DE, 0x77EC, 0x7860, 0x7864, 0x7865,
    0x785C, 0x786D, 0x7871, 0x786A, 0x786E, 0x7870, 0x7869, 0x7868,
    0x785E, 0x7862, 0x7974, 0x7973, 0x7972, 0x7970, 0x7A02, 0x7A0A,
    0x7A03, 0x7A0C, 0x7A04, 0x7A99, 0x7AE6, 0x7AE4, 0x7B4A, 0x7B3B,
    0x7B44, 0x7B48, 0x7B4C, 0x7B4E, 0x7B40, 0x7B58, 0x7B45, 0x7CA2,
    0x7C9E, 0x7CA8, 0x7CA1, 0x7D58, 0x7D6F, 0x7D63, 0x7D53, 0x7D56,
    0x7D67, 0x7D6A, 0x7D4F, 0x7D6D, 0x7D5C, 0x7D6B, 0x7D52, 0x7D54,
    0x7D69, 0x7D51, 0x7D5F, 0x7D4E, 0x7F3E, 0x7F3F, 0x7F65,
    /* Big5-HKSCS 0xDB40 .. 0xDB7E */
    0x7F66, 0x7FA2, 0x7FA0, 0x7FA1, 0x7FD7, 0x8051, 0x804F, 0x8050,
    0x80FE, 0x80D4, 0x8143, 0x814A, 0x8152, 0x814F, 0x8147, 0x813D,
    0x814D, 0x813A, 0x81E6, 0x81EE, 0x81F7, 0x81F8, 0x81F9, 0x8204,
    0x823C, 0x823D, 0x823F, 0x8275, 0x833B, 0x83CF, 0x83F9, 0x8423,
    0x83C0, 0x83E8, 0x8412, 0x83E7, 0x83E4, 0x83FC, 0x83F6, 0x8410,
    0x83C6, 0x83C8, 0x83EB, 0x83E3, 0x83BF, 0x8401, 0x83DD, 0x83E5,
    0x83D8, 0x83FF, 0x83E1, 0x83CB, 0x83CE, 0x83D6, 0x83F5, 0x83C9,
    0x8409, 0x840F, 0x83DE, 0x8411, 0x8406, 0x83C2, 0x83F3,
    /* Big5-HKSCS 0xDBA1 .. 0xDBFE */
            0x83D5, 0x83FA, 0x83C7, 0x83D1, 0x83EA, 0x8413, 0x83C3,
    0x83EC, 0x83EE, 0x83C4, 0x83FB, 0x83D7, 0x83E2, 0x841B, 0x83DB,
    0x83FE, 0x86D8, 0x86E2, 0x86E6, 0x86D3, 0x86E3, 0x86DA, 0x86EA,
    0x86DD, 0x86EB, 0x86DC, 0x86EC, 0x86E9, 0x86D7, 0x86E8, 0x86D1,
    0x8848, 0x8856, 0x8855, 0x88BA, 0x88D7, 0x88B9, 0x88B8, 0x88C0,
    0x88BE, 0x88B6, 0x88BC, 0x88B7, 0x88BD, 0x88B2, 0x8901, 0x88C9,
    0x8995, 0x8998, 0x8997, 0x89DD, 0x89DA, 0x89DB, 0x8A4E, 0x8A4D,
    0x8A39, 0x8A59, 0x8A40, 0x8A57, 0x8A58, 0x8A44, 0x8A45, 0x8A52,
    0x8A48, 0x8A51, 0x8A4A, 0x8A4C, 0x8A4F, 0x8C5F, 0x8C81, 0x8C80,
    0x8CBA, 0x8CBE, 0x8CB0, 0x8CB9, 0x8CB5, 0x8D84, 0x8D80, 0x8D89,
    0x8DD8, 0x8DD3, 0x8DCD, 0x8DC7, 0x8DD6, 0x8DDC, 0x8DCF, 0x8DD5,
    0x8DD9, 0x8DC8, 0x8DD7, 0x8DC5, 0x8EEF, 0x8EF7, 0x8EFA,
    /* Big5-HKSCS 0xDC40 .. 0xDC7E */
    0x8EF9, 0x8EE6, 0x8EEE, 0x8EE5, 0x8EF5, 0x8EE7, 0x8EE8, 0x8EF6,
    0x8EEB, 0x8EF1, 0x8EEC, 0x8EF4, 0x8EE9, 0x902D, 0x9034, 0x902F,
    0x9106, 0x912C, 0x9104, 0x90FF, 0x90FC, 0x9108, 0x90F9, 0x90FB,
    0x9101, 0x9100, 0x9107, 0x9105, 0x9103, 0x9161, 0x9164, 0x915F,
    0x9162, 0x9160, 0x9201, 0x920A, 0x9225, 0x9203, 0x921A, 0x9226,
    0x920F, 0x920C, 0x9200, 0x9212, 0x91FF, 0x91FD, 0x9206, 0x9204,
    0x9227, 0x9202, 0x921C, 0x9224, 0x9219, 0x9217, 0x9205, 0x9216,
    0x957B, 0x958D, 0x958C, 0x9590, 0x9687, 0x967E, 0x9688,
    /* Big5-HKSCS 0xDCA1 .. 0xDCFE */
            0x9689, 0x9683, 0x9680, 0x96C2, 0x96C8, 0x96C3, 0x96F1,
    0x96F0, 0x976C, 0x9770, 0x976E, 0x9807, 0x98A9, 0x98EB, 0x9CE6,
    0x9EF9, 0x4E83, 0x4E84, 0x4EB6, 0x50BD, 0x50BF, 0x50C6, 0x50AE,
    0x50C4, 0x50CA, 0x50B4, 0x50C8, 0x50C2, 0x50B0, 0x50C1, 0x50BA,
    0x50B1, 0x50CB, 0x50C9, 0x50B6, 0x50B8, 0x51D7, 0x527A, 0x5278,
    0x527B, 0x527C, 0x55C3, 0x55DB, 0x55CC, 0x55D0, 0x55CB, 0x55CA,
    0x55DD, 0x55C0, 0x55D4, 0x55C4, 0x55E9, 0x55BF, 0x55D2, 0x558D,
    0x55CF, 0x55D5, 0x55E2, 0x55D6, 0x55C8, 0x55F2, 0x55CD, 0x55D9,
    0x55C2, 0x5714, 0x5853, 0x5868, 0x5864, 0x584F, 0x584D, 0x5849,
    0x586F, 0x5855, 0x584E, 0x585D, 0x5859, 0x5865, 0x585B, 0x583D,
    0x5863, 0x5871, 0x58FC, 0x5AC7, 0x5AC4, 0x5ACB, 0x5ABA, 0x5AB8,
    0x5AB1, 0x5AB5, 0x5AB0, 0x5ABF, 0x5AC8, 0x5ABB, 0x5AC6,
    /* Big5-HKSCS 0xDD40 .. 0xDD7E */
    0x5AB7, 0x5AC0, 0x5ACA, 0x5AB4, 0x5AB6, 0x5ACD, 0x5AB9, 0x5A90,
    0x5BD6, 0x5BD8, 0x5BD9, 0x5C1F, 0x5C33, 0x5D71, 0x5D63, 0x5D4A,
    0x5D65, 0x5D72, 0x5D6C, 0x5D5E, 0x5D68, 0x5D67, 0x5D62, 0x5DF0,
    0x5E4F, 0x5E4E, 0x5E4A, 0x5E4D, 0x5E4B, 0x5EC5, 0x5ECC, 0x5EC6,
    0x5ECB, 0x5EC7, 0x5F40, 0x5FAF, 0x5FAD, 0x60F7, 0x6149, 0x614A,
    0x612B, 0x6145, 0x6136, 0x6132, 0x612E, 0x6146, 0x612F, 0x614F,
    0x6129, 0x6140, 0x6220, 0x9168, 0x6223, 0x6225, 0x6224, 0x63C5,
    0x63F1, 0x63EB, 0x6410, 0x6412, 0x6409, 0x6420, 0x6424,
    /* Big5-HKSCS 0xDDA1 .. 0xDDFE */
            0x6433, 0x6443, 0x641F, 0x6415, 0x6418, 0x6439, 0x6437,
    0x6422, 0x6423, 0x640C, 0x6426, 0x6430, 0x6428, 0x6441, 0x6435,
    0x642F, 0x640A, 0x641A, 0x6440, 0x6425, 0x6427, 0x640B, 0x63E7,
    0x641B, 0x642E, 0x6421, 0x640E, 0x656F, 0x6592, 0x65D3, 0x6686,
    0x668C, 0x6695, 0x6690, 0x668B, 0x668A, 0x6699, 0x6694, 0x6678,
    0x6720, 0x6966, 0x695F, 0x6938, 0x694E, 0x6962, 0x6971, 0x693F,
    0x6945, 0x696A, 0x6939, 0x6942, 0x6957, 0x6959, 0x697A, 0x6948,
    0x6949, 0x6935, 0x696C, 0x6933, 0x693D, 0x6965, 0x68F0, 0x6978,
    0x6934, 0x6969, 0x6940, 0x696F, 0x6944, 0x6976, 0x6958, 0x6941,
    0x6974, 0x694C, 0x693B, 0x694B, 0x6937, 0x695C, 0x694F, 0x6951,
    0x6932, 0x6952, 0x692F, 0x697B, 0x693C, 0x6B46, 0x6B45, 0x6B43,
    0x6B42, 0x6B48, 0x6B41, 0x6B9B, 0xFA0D, 0x6BFB, 0x6BFC,
    /* Big5-HKSCS 0xDE40 .. 0xDE7E */
    0x6BF9, 0x6BF7, 0x6BF8, 0x6E9B, 0x6ED6, 0x6EC8, 0x6E8F, 0x6EC0,
    0x6E9F, 0x6E93, 0x6E94, 0x6EA0, 0x6EB1, 0x6EB9, 0x6EC6, 0x6ED2,
    0x6EBD, 0x6EC1, 0x6E9E, 0x6EC9, 0x6EB7, 0x6EB0, 0x6ECD, 0x6EA6,
    0x6ECF, 0x6EB2, 0x6EBE, 0x6EC3, 0x6EDC, 0x6ED8, 0x6E99, 0x6E92,
    0x6E8E, 0x6E8D, 0x6EA4, 0x6EA1, 0x6EBF, 0x6EB3, 0x6ED0, 0x6ECA,
    0x6E97, 0x6EAE, 0x6EA3, 0x7147, 0x7154, 0x7152, 0x7163, 0x7160,
    0x7141, 0x715D, 0x7162, 0x7172, 0x7178, 0x716A, 0x7161, 0x7142,
    0x7158, 0x7143, 0x714B, 0x7170, 0x715F, 0x7150, 0x7153,
    /* Big5-HKSCS 0xDEA1 .. 0xDEFE */
            0x7144, 0x714D, 0x715A, 0x724F, 0x728D, 0x728C, 0x7291,
    0x7290, 0x728E, 0x733C, 0x7342, 0x733B, 0x733A, 0x7340, 0x734A,
    0x7349, 0x7444, 0x744A, 0x744B, 0x7452, 0x7451, 0x7457, 0x7440,
    0x744F, 0x7450, 0x744E, 0x7442, 0x7446, 0x744D, 0x7454, 0x74E1,
    0x74FF, 0x74FE, 0x74FD, 0x751D, 0x7579, 0x7577, 0x6983, 0x75EF,
    0x760F, 0x7603, 0x75F7, 0x75FE, 0x75FC, 0x75F9, 0x75F8, 0x7610,
    0x75FB, 0x75F6, 0x75ED, 0x75F5, 0x75FD, 0x7699, 0x76B5, 0x76DD,
    0x7755, 0x775F, 0x7760, 0x7752, 0x7756, 0x775A, 0x7769, 0x7767,
    0x7754, 0x7759, 0x776D, 0x77E0, 0x7887, 0x789A, 0x7894, 0x788F,
    0x7884, 0x7895, 0x7885, 0x7886, 0x78A1, 0x7883, 0x7879, 0x7899,
    0x7880, 0x7896, 0x787B, 0x797C, 0x7982, 0x797D, 0x7979, 0x7A11,
    0x7A18, 0x7A19, 0x7A12, 0x7A17, 0x7A15, 0x7A22, 0x7A13,
    /* Big5-HKSCS 0xDF40 .. 0xDF7E */
    0x7A1B, 0x7A10, 0x7AA3, 0x7AA2, 0x7A9E, 0x7AEB, 0x7B66, 0x7B64,
    0x7B6D, 0x7B74, 0x7B69, 0x7B72, 0x7B65, 0x7B73, 0x7B71, 0x7B70,
    0x7B61, 0x7B78, 0x7B76, 0x7B63, 0x7CB2, 0x7CB4, 0x7CAF, 0x7D88,
    0x7D86, 0x7D80, 0x7D8D, 0x7D7F, 0x7D85, 0x7D7A, 0x7D8E, 0x7D7B,
    0x7D83, 0x7D7C, 0x7D8C, 0x7D94, 0x7D84, 0x7D7D, 0x7D92, 0x7F6D,
    0x7F6B, 0x7F67, 0x7F68, 0x7F6C, 0x7FA6, 0x7FA5, 0x7FA7, 0x7FDB,
    0x7FDC, 0x8021, 0x8164, 0x8160, 0x8177, 0x815C, 0x8169, 0x815B,
    0x8162, 0x8172, 0x6721, 0x815E, 0x8176, 0x8167, 0x816F,
    /* Big5-HKSCS 0xDFA1 .. 0xDFFE */
            0x8144, 0x8161, 0x821D, 0x8249, 0x8244, 0x8240, 0x8242,
    0x8245, 0x84F1, 0x843F, 0x8456, 0x8476, 0x8479, 0x848F, 0x848D,
    0x8465, 0x8451, 0x8440, 0x8486, 0x8467, 0x8430, 0x844D, 0x847D,
    0x845A, 0x8459, 0x8474, 0x8473, 0x845D, 0x8507, 0x845E, 0x8437,
    0x843A, 0x8434, 0x847A, 0x8443, 0x8478, 0x8432, 0x8445, 0x8429,
    0x83D9, 0x844B, 0x842F, 0x8442, 0x842D, 0x845F, 0x8470, 0x8439,
    0x844E, 0x844C, 0x8452, 0x846F, 0x84C5, 0x848E, 0x843B, 0x8447,
    0x8436, 0x8433, 0x8468, 0x847E, 0x8444, 0x842B, 0x8460, 0x8454,
    0x846E, 0x8450, 0x870B, 0x8704, 0x86F7, 0x870C, 0x86FA, 0x86D6,
    0x86F5, 0x874D, 0x86F8, 0x870E, 0x8709, 0x8701, 0x86F6, 0x870D,
    0x8705, 0x88D6, 0x88CB, 0x88CD, 0x88CE, 0x88DE, 0x88DB, 0x88DA,
    0x88CC, 0x88D0, 0x8985, 0x899B, 0x89DF, 0x89E5, 0x89E4,
    /* Big5-HKSCS 0xE040 .. 0xE07E */
    0x89E1, 0x89E0, 0x89E2, 0x89DC, 0x89E6, 0x8A76, 0x8A86, 0x8A7F,
    0x8A61, 0x8A3F, 0x8A77, 0x8A82, 0x8A84, 0x8A75, 0x8A83, 0x8A81,
    0x8A74, 0x8A7A, 0x8C3C, 0x8C4B, 0x8C4A, 0x8C65, 0x8C64, 0x8C66,
    0x8C86, 0x8C84, 0x8C85, 0x8CCC, 0x8D68, 0x8D69, 0x8D91, 0x8D8C,
    0x8D8E, 0x8D8F, 0x8D8D, 0x8D93, 0x8D94, 0x8D90, 0x8D92, 0x8DF0,
    0x8DE0, 0x8DEC, 0x8DF1, 0x8DEE, 0x8DD0, 0x8DE9, 0x8DE3, 0x8DE2,
    0x8DE7, 0x8DF2, 0x8DEB, 0x8DF4, 0x8F06, 0x8EFF, 0x8F01, 0x8F00,
    0x8F05, 0x8F07, 0x8F08, 0x8F02, 0x8F0B, 0x9052, 0x903F,
    /* Big5-HKSCS 0xE0A1 .. 0xE0FE */
            0x9044, 0x9049, 0x903D, 0x9110, 0x910D, 0x910F, 0x9111,
    0x9116, 0x9114, 0x910B, 0x910E, 0x916E, 0x916F, 0x9248, 0x9252,
    0x9230, 0x923A, 0x9266, 0x9233, 0x9265, 0x925E, 0x9283, 0x922E,
    0x924A, 0x9246, 0x926D, 0x926C, 0x924F, 0x9260, 0x9267, 0x926F,
    0x9236, 0x9261, 0x9270, 0x9231, 0x9254, 0x9263, 0x9250, 0x9272,
    0x924E, 0x9253, 0x924C, 0x9256, 0x9232, 0x959F, 0x959C, 0x959E,
    0x959B, 0x9692, 0x9693, 0x9691, 0x9697, 0x96CE, 0x96FA, 0x96FD,
    0x96F8, 0x96F5, 0x9773, 0x9777, 0x9778, 0x9772, 0x980F, 0x980D,
    0x980E, 0x98AC, 0x98F6, 0x98F9, 0x99AF, 0x99B2, 0x99B0, 0x99B5,
    0x9AAD, 0x9AAB, 0x9B5B, 0x9CEA, 0x9CED, 0x9CE7, 0x9E80, 0x9EFD,
    0x50E6, 0x50D4, 0x50D7, 0x50E8, 0x50F3, 0x50DB, 0x50EA, 0x50DD,
    0x50E4, 0x50D3, 0x50EC, 0x50F0, 0x50EF, 0x50E3, 0x50E0,
    /* Big5-HKSCS 0xE140 .. 0xE17E */
    0x51D8, 0x5280, 0x5281, 0x52E9, 0x52EB, 0x5330, 0x53AC, 0x5627,
    0x5615, 0x560C, 0x5612, 0x55FC, 0x560F, 0x561C, 0x5601, 0x5613,
    0x5602, 0x55FA, 0x561D, 0x5604, 0x55FF, 0x55F9, 0x5889, 0x587C,
    0x5890, 0x5898, 0x5886, 0x5881, 0x587F, 0x5874, 0x588B, 0x587A,
    0x5887, 0x5891, 0x588E, 0x5876, 0x5882, 0x5888, 0x587B, 0x5894,
    0x588F, 0x58FE, 0x596B, 0x5ADC, 0x5AEE, 0x5AE5, 0x5AD5, 0x5AEA,
    0x5ADA, 0x5AED, 0x5AEB, 0x5AF3, 0x5AE2, 0x5AE0, 0x5ADB, 0x5AEC,
    0x5ADE, 0x5ADD, 0x5AD9, 0x5AE8, 0x5ADF, 0x5B77, 0x5BE0,
    /* Big5-HKSCS 0xE1A1 .. 0xE1FE */
            0x5BE3, 0x5C63, 0x5D82, 0x5D80, 0x5D7D, 0x5D86, 0x5D7A,
    0x5D81, 0x5D77, 0x5D8A, 0x5D89, 0x5D88, 0x5D7E, 0x5D7C, 0x5D8D,
    0x5D79, 0x5D7F, 0x5E58, 0x5E59, 0x5E53, 0x5ED8, 0x5ED1, 0x5ED7,
    0x5ECE, 0x5EDC, 0x5ED5, 0x5ED9, 0x5ED2, 0x5ED4, 0x5F44, 0x5F43,
    0x5F6F, 0x5FB6, 0x612C, 0x6128, 0x6141, 0x615E, 0x6171, 0x6173,
    0x6152, 0x6153, 0x6172, 0x616C, 0x6180, 0x6174, 0x6154, 0x617A,
    0x615B, 0x6165, 0x613B, 0x616A, 0x6161, 0x6156, 0x6229, 0x6227,
    0x622B, 0x642B, 0x644D, 0x645B, 0x645D, 0x6474, 0x6476, 0x6472,
    0x6473, 0x647D, 0x6475, 0x6466, 0x64A6, 0x644E, 0x6482, 0x645E,
    0x645C, 0x644B, 0x6453, 0x6460, 0x6450, 0x647F, 0x643F, 0x646C,
    0x646B, 0x6459, 0x6465, 0x6477, 0x6573, 0x65A0, 0x66A1, 0x66A0,
    0x669F, 0x6705, 0x6704, 0x6722, 0x69B1, 0x69B6, 0x69C9,
    /* Big5-HKSCS 0xE240 .. 0xE27E */
    0x69A0, 0x69CE, 0x6996, 0x69B0, 0x69AC, 0x69BC, 0x6991, 0x6999,
    0x698E, 0x69A7, 0x698D, 0x69A9, 0x69BE, 0x69AF, 0x69BF, 0x69C4,
    0x69BD, 0x69A4, 0x69D4, 0x69B9, 0x69CA, 0x699A, 0x69CF, 0x69B3,
    0x6993, 0x69AA, 0x69A1, 0x699E, 0x69D9, 0x6997, 0x6990, 0x69C2,
    0x69B5, 0x69A5, 0x69C6, 0x6B4A, 0x6B4D, 0x6B4B, 0x6B9E, 0x6B9F,
    0x6BA0, 0x6BC3, 0x6BC4, 0x6BFE, 0x6ECE, 0x6EF5, 0x6EF1, 0x6F03,
    0x6F25, 0x6EF8, 0x6F37, 0x6EFB, 0x6F2E, 0x6F09, 0x6F4E, 0x6F19,
    0x6F1A, 0x6F27, 0x6F18, 0x6F3B, 0x6F12, 0x6EED, 0x6F0A,
    /* Big5-HKSCS 0xE2A1 .. 0xE2FE */
            0x6F36, 0x6F73, 0x6EF9, 0x6EEE, 0x6F2D, 0x6F40, 0x6F30,
    0x6F3C, 0x6F35, 0x6EEB, 0x6F07, 0x6F0E, 0x6F43, 0x6F05, 0x6EFD,
    0x6EF6, 0x6F39, 0x6F1C, 0x6EFC, 0x6F3A, 0x6F1F, 0x6F0D, 0x6F1E,
    0x6F08, 0x6F21, 0x7187, 0x7190, 0x7189, 0x7180, 0x7185, 0x7182,
    0x718F, 0x717B, 0x7186, 0x7181, 0x7197, 0x7244, 0x7253, 0x7297,
    0x7295, 0x7293, 0x7343, 0x734D, 0x7351, 0x734C, 0x7462, 0x7473,
    0x7471, 0x7475, 0x7472, 0x7467, 0x746E, 0x7500, 0x7502, 0x7503,
    0x757D, 0x7590, 0x7616, 0x7608, 0x760C, 0x7615, 0x7611, 0x760A,
    0x7614, 0x76B8, 0x7781, 0x777C, 0x7785, 0x7782, 0x776E, 0x7780,
    0x776F, 0x777E, 0x7783, 0x78B2, 0x78AA, 0x78B4, 0x78AD, 0x78A8,
    0x787E, 0x78AB, 0x789E, 0x78A5, 0x78A0, 0x78AC, 0x78A2, 0x78A4,
    0x7998, 0x798A, 0x798B, 0x7996, 0x7995, 0x7994, 0x7993,
    /* Big5-HKSCS 0xE340 .. 0xE37E */
    0x7997, 0x7988, 0x7992, 0x7990, 0x7A2B, 0x7A4A, 0x7A30, 0x7A2F,
    0x7A28, 0x7A26, 0x7AA8, 0x7AAB, 0x7AAC, 0x7AEE, 0x7B88, 0x7B9C,
    0x7B8A, 0x7B91, 0x7B90, 0x7B96, 0x7B8D, 0x7B8C, 0x7B9B, 0x7B8E,
    0x7B85, 0x7B98, 0x5284, 0x7B99, 0x7BA4, 0x7B82, 0x7CBB, 0x7CBF,
    0x7CBC, 0x7CBA, 0x7DA7, 0x7DB7, 0x7DC2, 0x7DA3, 0x7DAA, 0x7DC1,
    0x7DC0, 0x7DC5, 0x7D9D, 0x7DCE, 0x7DC4, 0x7DC6, 0x7DCB, 0x7DCC,
    0x7DAF, 0x7DB9, 0x7D96, 0x7DBC, 0x7D9F, 0x7DA6, 0x7DAE, 0x7DA9,
    0x7DA1, 0x7DC9, 0x7F73, 0x7FE2, 0x7FE3, 0x7FE5, 0x7FDE,
    /* Big5-HKSCS 0xE3A1 .. 0xE3FE */
            0x8024, 0x805D, 0x805C, 0x8189, 0x8186, 0x8183, 0x8187,
    0x818D, 0x818C, 0x818B, 0x8215, 0x8497, 0x84A4, 0x84A1, 0x849F,
    0x84BA, 0x84CE, 0x84C2, 0x84AC, 0x84AE, 0x84AB, 0x84B9, 0x84B4,
    0x84C1, 0x84CD, 0x84AA, 0x849A, 0x84B1, 0x84D0, 0x849D, 0x84A7,
    0x84BB, 0x84A2, 0x8494, 0x84C7, 0x84CC, 0x849B, 0x84A9, 0x84AF,
    0x84A8, 0x84D6, 0x8498, 0x84B6, 0x84CF, 0x84A0, 0x84D7, 0x84D4,
    0x84D2, 0x84DB, 0x84B0, 0x8491, 0x8661, 0x8733, 0x8723, 0x8728,
    0x876B, 0x8740, 0x872E, 0x871E, 0x8721, 0x8719, 0x871B, 0x8743,
    0x872C, 0x8741, 0x873E, 0x8746, 0x8720, 0x8732, 0x872A, 0x872D,
    0x873C, 0x8712, 0x873A, 0x8731, 0x8735, 0x8742, 0x8726, 0x8727,
    0x8738, 0x8724, 0x871A, 0x8730, 0x8711, 0x88F7, 0x88E7, 0x88F1,
    0x88F2, 0x88FA, 0x88FE, 0x88EE, 0x88FC, 0x88F6, 0x88FB,
    /* Big5-HKSCS 0xE440 .. 0xE47E */
    0x88F0, 0x88EC, 0x88EB, 0x899D, 0x89A1, 0x899F, 0x899E, 0x89E9,
    0x89EB, 0x89E8, 0x8AAB, 0x8A99, 0x8A8B, 0x8A92, 0x8A8F, 0x8A96,
    0x8C3D, 0x8C68, 0x8C69, 0x8CD5, 0x8CCF, 0x8CD7, 0x8D96, 0x8E09,
    0x8E02, 0x8DFF, 0x8E0D, 0x8DFD, 0x8E0A, 0x8E03, 0x8E07, 0x8E06,
    0x8E05, 0x8DFE, 0x8E00, 0x8E04, 0x8F10, 0x8F11, 0x8F0E, 0x8F0D,
    0x9123, 0x911C, 0x9120, 0x9122, 0x911F, 0x911D, 0x911A, 0x9124,
    0x9121, 0x911B, 0x917A, 0x9172, 0x9179, 0x9173, 0x92A5, 0x92A4,
    0x9276, 0x929B, 0x927A, 0x92A0, 0x9294, 0x92AA, 0x928D,
    /* Big5-HKSCS 0xE4A1 .. 0xE4FE */
            0x92A6, 0x929A, 0x92AB, 0x9279, 0x9297, 0x927F, 0x92A3,
    0x92EE, 0x928E, 0x9282, 0x9295, 0x92A2, 0x927D, 0x9288, 0x92A1,
    0x928A, 0x9286, 0x928C, 0x9299, 0x92A7, 0x927E, 0x9287, 0x92A9,
    0x929D, 0x928B, 0x922D, 0x969E, 0x96A1, 0x96FF, 0x9758, 0x977D,
    0x977A, 0x977E, 0x9783, 0x9780, 0x9782, 0x977B, 0x9784, 0x9781,
    0x977F, 0x97CE, 0x97CD, 0x9816, 0x98AD, 0x98AE, 0x9902, 0x9900,
    0x9907, 0x999D, 0x999C, 0x99C3, 0x99B9, 0x99BB, 0x99BA, 0x99C2,
    0x99BD, 0x99C7, 0x9AB1, 0x9AE3, 0x9AE7, 0x9B3E, 0x9B3F, 0x9B60,
    0x9B61, 0x9B5F, 0x9CF1, 0x9CF2, 0x9CF5, 0x9EA7, 0x50FF, 0x5103,
    0x5130, 0x50F8, 0x5106, 0x5107, 0x50F6, 0x50FE, 0x510B, 0x510C,
    0x50FD, 0x510A, 0x528B, 0x528C, 0x52F1, 0x52EF, 0x5648, 0x5642,
    0x564C, 0x5635, 0x5641, 0x564A, 0x5649, 0x5646, 0x5658,
    /* Big5-HKSCS 0xE540 .. 0xE57E */
    0x565A, 0x5640, 0x5633, 0x563D, 0x562C, 0x563E, 0x5638, 0x562A,
    0x563A, 0x571A, 0x58AB, 0x589D, 0x58B1, 0x58A0, 0x58A3, 0x58AF,
    0x58AC, 0x58A5, 0x58A1, 0x58FF, 0x5AFF, 0x5AF4, 0x5AFD, 0x5AF7,
    0x5AF6, 0x5B03, 0x5AF8, 0x5B02, 0x5AF9, 0x5B01, 0x5B07, 0x5B05,
    0x5B0F, 0x5C67, 0x5D99, 0x5D97, 0x5D9F, 0x5D92, 0x5DA2, 0x5D93,
    0x5D95, 0x5DA0, 0x5D9C, 0x5DA1, 0x5D9A, 0x5D9E, 0x5E69, 0x5E5D,
    0x5E60, 0x5E5C, 0x7DF3, 0x5EDB, 0x5EDE, 0x5EE1, 0x5F49, 0x5FB2,
    0x618B, 0x6183, 0x6179, 0x61B1, 0x61B0, 0x61A2, 0x6189,
    /* Big5-HKSCS 0xE5A1 .. 0xE5FE */
            0x619B, 0x6193, 0x61AF, 0x61AD, 0x619F, 0x6192, 0x61AA,
    0x61A1, 0x618D, 0x6166, 0x61B3, 0x622D, 0x646E, 0x6470, 0x6496,
    0x64A0, 0x6485, 0x6497, 0x649C, 0x648F, 0x648B, 0x648A, 0x648C,
    0x64A3, 0x649F, 0x6468, 0x64B1, 0x6498, 0x6576, 0x657A, 0x6579,
    0x657B, 0x65B2, 0x65B3, 0x66B5, 0x66B0, 0x66A9, 0x66B2, 0x66B7,
    0x66AA, 0x66AF, 0x6A00, 0x6A06, 0x6A17, 0x69E5, 0x69F8, 0x6A15,
    0x69F1, 0x69E4, 0x6A20, 0x69FF, 0x69EC, 0x69E2, 0x6A1B, 0x6A1D,
    0x69FE, 0x6A27, 0x69F2, 0x69EE, 0x6A14, 0x69F7, 0x69E7, 0x6A40,
    0x6A08, 0x69E6, 0x69FB, 0x6A0D, 0x69FC, 0x69EB, 0x6A09, 0x6A04,
    0x6A18, 0x6A25, 0x6A0F, 0x69F6, 0x6A26, 0x6A07, 0x69F4, 0x6A16,
    0x6B51, 0x6BA5, 0x6BA3, 0x6BA2, 0x6BA6, 0x6C01, 0x6C00, 0x6BFF,
    0x6C02, 0x6F41, 0x6F26, 0x6F7E, 0x6F87, 0x6FC6, 0x6F92,
    /* Big5-HKSCS 0xE640 .. 0xE67E */
    0x6F8D, 0x6F89, 0x6F8C, 0x6F62, 0x6F4F, 0x6F85, 0x6F5A, 0x6F96,
    0x6F76, 0x6F6C, 0x6F82, 0x6F55, 0x6F72, 0x6F52, 0x6F50, 0x6F57,
    0x6F94, 0x6F93, 0x6F5D, 0x6F00, 0x6F61, 0x6F6B, 0x6F7D, 0x6F67,
    0x6F90, 0x6F53, 0x6F8B, 0x6F69, 0x6F7F, 0x6F95, 0x6F63, 0x6F77,
    0x6F6A, 0x6F7B, 0x71B2, 0x71AF, 0x719B, 0x71B0, 0x71A0, 0x719A,
    0x71A9, 0x71B5, 0x719D, 0x71A5, 0x719E, 0x71A4, 0x71A1, 0x71AA,
    0x719C, 0x71A7, 0x71B3, 0x7298, 0x729A, 0x7358, 0x7352, 0x735E,
    0x735F, 0x7360, 0x735D, 0x735B, 0x7361, 0x735A, 0x7359,
    /* Big5-HKSCS 0xE6A1 .. 0xE6FE */
            0x7362, 0x7487, 0x7489, 0x748A, 0x7486, 0x7481, 0x747D,
    0x7485, 0x7488, 0x747C, 0x7479, 0x7508, 0x7507, 0x757E, 0x7625,
    0x761E, 0x7619, 0x761D, 0x761C, 0x7623, 0x761A, 0x7628, 0x761B,
    0x769C, 0x769D, 0x769E, 0x769B, 0x778D, 0x778F, 0x7789, 0x7788,
    0x78CD, 0x78BB, 0x78CF, 0x78CC, 0x78D1, 0x78CE, 0x78D4, 0x78C8,
    0x78C3, 0x78C4, 0x78C9, 0x799A, 0x79A1, 0x79A0, 0x799C, 0x79A2,
    0x799B, 0x6B76, 0x7A39, 0x7AB2, 0x7AB4, 0x7AB3, 0x7BB7, 0x7BCB,
    0x7BBE, 0x7BAC, 0x7BCE, 0x7BAF, 0x7BB9, 0x7BCA, 0x7BB5, 0x7CC5,
    0x7CC8, 0x7CCC, 0x7CCB, 0x7DF7, 0x7DDB, 0x7DEA, 0x7DE7, 0x7DD7,
    0x7DE1, 0x7E03, 0x7DFA, 0x7DE6, 0x7DF6, 0x7DF1, 0x7DF0, 0x7DEE,
    0x7DDF, 0x7F76, 0x7FAC, 0x7FB0, 0x7FAD, 0x7FED, 0x7FEB, 0x7FEA,
    0x7FEC, 0x7FE6, 0x7FE8, 0x8064, 0x8067, 0x81A3, 0x819F,
    /* Big5-HKSCS 0xE740 .. 0xE77E */
    0x819E, 0x8195, 0x81A2, 0x8199, 0x8197, 0x8216, 0x824F, 0x8253,
    0x8252, 0x8250, 0x824E, 0x8251, 0x8524, 0x853B, 0x850F, 0x8500,
    0x8529, 0x850E, 0x8509, 0x850D, 0x851F, 0x850A, 0x8527, 0x851C,
    0x84FB, 0x852B, 0x84FA, 0x8508, 0x850C, 0x84F4, 0x852A, 0x84F2,
    0x8515, 0x84F7, 0x84EB, 0x84F3, 0x84FC, 0x8512, 0x84EA, 0x84E9,
    0x8516, 0x84FE, 0x8528, 0x851D, 0x852E, 0x8502, 0x84FD, 0x851E,
    0x84F6, 0x8531, 0x8526, 0x84E7, 0x84E8, 0x84F0, 0x84EF, 0x84F9,
    0x8518, 0x8520, 0x8530, 0x850B, 0x8519, 0x852F, 0x8662,
    /* Big5-HKSCS 0xE7A1 .. 0xE7FE */
            0x8756, 0x8763, 0x8764, 0x8777, 0x87E1, 0x8773, 0x8758,
    0x8754, 0x875B, 0x8752, 0x8761, 0x875A, 0x8751, 0x875E, 0x876D,
    0x876A, 0x8750, 0x874E, 0x875F, 0x875D, 0x876F, 0x876C, 0x877A,
    0x876E, 0x875C, 0x8765, 0x874F, 0x877B, 0x8775, 0x8762, 0x8767,
    0x8769, 0x885A, 0x8905, 0x890C, 0x8914, 0x890B, 0x8917, 0x8918,
    0x8919, 0x8906, 0x8916, 0x8911, 0x890E, 0x8909, 0x89A2, 0x89A4,
    0x89A3, 0x89ED, 0x89F0, 0x89EC, 0x8ACF, 0x8AC6, 0x8AB8, 0x8AD3,
    0x8AD1, 0x8AD4, 0x8AD5, 0x8ABB, 0x8AD7, 0x8ABE, 0x8AC0, 0x8AC5,
    0x8AD8, 0x8AC3, 0x8ABA, 0x8ABD, 0x8AD9, 0x8C3E, 0x8C4D, 0x8C8F,
    0x8CE5, 0x8CDF, 0x8CD9, 0x8CE8, 0x8CDA, 0x8CDD, 0x8CE7, 0x8DA0,
    0x8D9C, 0x8DA1, 0x8D9B, 0x8E20, 0x8E23, 0x8E25, 0x8E24, 0x8E2E,
    0x8E15, 0x8E1B, 0x8E16, 0x8E11, 0x8E19, 0x8E26, 0x8E27,
    /* Big5-HKSCS 0xE840 .. 0xE87E */
    0x8E14, 0x8E12, 0x8E18, 0x8E13, 0x8E1C, 0x8E17, 0x8E1A, 0x8F2C,
    0x8F24, 0x8F18, 0x8F1A, 0x8F20, 0x8F23, 0x8F16, 0x8F17, 0x9073,
    0x9070, 0x906F, 0x9067, 0x906B, 0x912F, 0x912B, 0x9129, 0x912A,
    0x9132, 0x9126, 0x912E, 0x9185, 0x9186, 0x918A, 0x9181, 0x9182,
    0x9184, 0x9180, 0x92D0, 0x92C3, 0x92C4, 0x92C0, 0x92D9, 0x92B6,
    0x92CF, 0x92F1, 0x92DF, 0x92D8, 0x92E9, 0x92D7, 0x92DD, 0x92CC,
    0x92EF, 0x92C2, 0x92E8, 0x92CA, 0x92C8, 0x92CE, 0x92E6, 0x92CD,
    0x92D5, 0x92C9, 0x92E0, 0x92DE, 0x92E7, 0x92D1, 0x92D3,
    /* Big5-HKSCS 0xE8A1 .. 0xE8FE */
            0x92B5, 0x92E1, 0x92C6, 0x92B4, 0x957C, 0x95AC, 0x95AB,
    0x95AE, 0x95B0, 0x96A4, 0x96A2, 0x96D3, 0x9705, 0x9708, 0x9702,
    0x975A, 0x978A, 0x978E, 0x9788, 0x97D0, 0x97CF, 0x981E, 0x981D,
    0x9826, 0x9829, 0x9828, 0x9820, 0x981B, 0x9827, 0x98B2, 0x9908,
    0x98FA, 0x9911, 0x9914, 0x9916, 0x9917, 0x9915, 0x99DC, 0x99CD,
    0x99CF, 0x99D3, 0x99D4, 0x99CE, 0x99C9, 0x99D6, 0x99D8, 0x99CB,
    0x99D7, 0x99CC, 0x9AB3, 0x9AEC, 0x9AEB, 0x9AF3, 0x9AF2, 0x9AF1,
    0x9B46, 0x9B43, 0x9B67, 0x9B74, 0x9B71, 0x9B66, 0x9B76, 0x9B75,
    0x9B70, 0x9B68, 0x9B64, 0x9B6C, 0x9CFC, 0x9CFA, 0x9CFD, 0x9CFF,
    0x9CF7, 0x9D07, 0x9D00, 0x9CF9, 0x9CFB, 0x9D08, 0x9D05, 0x9D04,
    0x9E83, 0x9ED3, 0x9F0F, 0x9F10, 0x511C, 0x5113, 0x5117, 0x511A,
    0x5111, 0x51DE, 0x5334, 0x53E1, 0x5670, 0x5660, 0x566E,
    /* Big5-HKSCS 0xE940 .. 0xE97E */
    0x5673, 0x5666, 0x5663, 0x566D, 0x5672, 0x565E, 0x5677, 0x571C,
    0x571B, 0x58C8, 0x58BD, 0x58C9, 0x58BF, 0x58BA, 0x58C2, 0x58BC,
    0x58C6, 0x5B17, 0x5B19, 0x5B1B, 0x5B21, 0x5B14, 0x5B13, 0x5B10,
    0x5B16, 0x5B28, 0x5B1A, 0x5B20, 0x5B1E, 0x5BEF, 0x5DAC, 0x5DB1,
    0x5DA9, 0x5DA7, 0x5DB5, 0x5DB0, 0x5DAE, 0x5DAA, 0x5DA8, 0x5DB2,
    0x5DAD, 0x5DAF, 0x5DB4, 0x5E67, 0x5E68, 0x5E66, 0x5E6F, 0x5EE9,
    0x5EE7, 0x5EE6, 0x5EE8, 0x5EE5, 0x5F4B, 0x5FBC, 0x619D, 0x61A8,
    0x6196, 0x61C5, 0x61B4, 0x61C6, 0x61C1, 0x61CC, 0x61BA,
    /* Big5-HKSCS 0xE9A1 .. 0xE9FE */
            0x61BF, 0x61B8, 0x618C, 0x64D7, 0x64D6, 0x64D0, 0x64CF,
    0x64C9, 0x64BD, 0x6489, 0x64C3, 0x64DB, 0x64F3, 0x64D9, 0x6533,
    0x657F, 0x657C, 0x65A2, 0x66C8, 0x66BE, 0x66C0, 0x66CA, 0x66CB,
    0x66CF, 0x66BD, 0x66BB, 0x66BA, 0x66CC, 0x6723, 0x6A34, 0x6A66,
    0x6A49, 0x6A67, 0x6A32, 0x6A68, 0x6A3E, 0x6A5D, 0x6A6D, 0x6A76,
    0x6A5B, 0x6A51, 0x6A28, 0x6A5A, 0x6A3B, 0x6A3F, 0x6A41, 0x6A6A,
    0x6A64, 0x6A50, 0x6A4F, 0x6A54, 0x6A6F, 0x6A69, 0x6A60, 0x6A3C,
    0x6A5E, 0x6A56, 0x6A55, 0x6A4D, 0x6A4E, 0x6A46, 0x6B55, 0x6B54,
    0x6B56, 0x6BA7, 0x6BAA, 0x6BAB, 0x6BC8, 0x6BC7, 0x6C04, 0x6C03,
    0x6C06, 0x6FAD, 0x6FCB, 0x6FA3, 0x6FC7, 0x6FBC, 0x6FCE, 0x6FC8,
    0x6F5E, 0x6FC4, 0x6FBD, 0x6F9E, 0x6FCA, 0x6FA8, 0x7004, 0x6FA5,
    0x6FAE, 0x6FBA, 0x6FAC, 0x6FAA, 0x6FCF, 0x6FBF, 0x6FB8,
    /* Big5-HKSCS 0xEA40 .. 0xEA7E */
    0x6FA2, 0x6FC9, 0x6FAB, 0x6FCD, 0x6FAF, 0x6FB2, 0x6FB0, 0x71C5,
    0x71C2, 0x71BF, 0x71B8, 0x71D6, 0x71C0, 0x71C1, 0x71CB, 0x71D4,
    0x71CA, 0x71C7, 0x71CF, 0x71BD, 0x71D8, 0x71BC, 0x71C6, 0x71DA,
    0x71DB, 0x729D, 0x729E, 0x7369, 0x7366, 0x7367, 0x736C, 0x7365,
    0x736B, 0x736A, 0x747F, 0x749A, 0x74A0, 0x7494, 0x7492, 0x7495,
    0x74A1, 0x750B, 0x7580, 0x762F, 0x762D, 0x7631, 0x763D, 0x7633,
    0x763C, 0x7635, 0x7632, 0x7630, 0x76BB, 0x76E6, 0x779A, 0x779D,
    0x77A1, 0x779C, 0x779B, 0x77A2, 0x77A3, 0x7795, 0x7799,
    /* Big5-HKSCS 0xEAA1 .. 0xEAFE */
            0x7797, 0x78DD, 0x78E9, 0x78E5, 0x78EA, 0x78DE, 0x78E3,
    0x78DB, 0x78E1, 0x78E2, 0x78ED, 0x78DF, 0x78E0, 0x79A4, 0x7A44,
    0x7A48, 0x7A47, 0x7AB6, 0x7AB8, 0x7AB5, 0x7AB1, 0x7AB7, 0x7BDE,
    0x7BE3, 0x7BE7, 0x7BDD, 0x7BD5, 0x7BE5, 0x7BDA, 0x7BE8, 0x7BF9,
    0x7BD4, 0x7BEA, 0x7BE2, 0x7BDC, 0x7BEB, 0x7BD8, 0x7BDF, 0x7CD2,
    0x7CD4, 0x7CD7, 0x7CD0, 0x7CD1, 0x7E12, 0x7E21, 0x7E17, 0x7E0C,
    0x7E1F, 0x7E20, 0x7E13, 0x7E0E, 0x7E1C, 0x7E15, 0x7E1A, 0x7E22,
    0x7E0B, 0x7E0F, 0x7E16, 0x7E0D, 0x7E14, 0x7E25, 0x7E24, 0x7F43,
    0x7F7B, 0x7F7C, 0x7F7A, 0x7FB1, 0x7FEF, 0x802A, 0x8029, 0x806C,
    0x81B1, 0x81A6, 0x81AE, 0x81B9, 0x81B5, 0x81AB, 0x81B0, 0x81AC,
    0x81B4, 0x81B2, 0x81B7, 0x81A7, 0x81F2, 0x8255, 0x8256, 0x8257,
    0x8556, 0x8545, 0x856B, 0x854D, 0x8553, 0x8561, 0x8558,
    /* Big5-HKSCS 0xEB40 .. 0xEB7E */
    0x8540, 0x8546, 0x8564, 0x8541, 0x8562, 0x8544, 0x8551, 0x8547,
    0x8563, 0x853E, 0x855B, 0x8571, 0x854E, 0x856E, 0x8575, 0x8555,
    0x8567, 0x8560, 0x858C, 0x8566, 0x855D, 0x8554, 0x8565, 0x856C,
    0x8663, 0x8665, 0x8664, 0x879B, 0x878F, 0x8797, 0x8793, 0x8792,
    0x8788, 0x8781, 0x8796, 0x8798, 0x8779, 0x8787, 0x87A3, 0x8785,
    0x8790, 0x8791, 0x879D, 0x8784, 0x8794, 0x879C, 0x879A, 0x8789,
    0x891E, 0x8926, 0x8930, 0x892D, 0x892E, 0x8927, 0x8931, 0x8922,
    0x8929, 0x8923, 0x892F, 0x892C, 0x891F, 0x89F1, 0x8AE0,
    /* Big5-HKSCS 0xEBA1 .. 0xEBFE */
            0x8AE2, 0x8AF2, 0x8AF4, 0x8AF5, 0x8ADD, 0x8B14, 0x8AE4,
    0x8ADF, 0x8AF0, 0x8AC8, 0x8ADE, 0x8AE1, 0x8AE8, 0x8AFF, 0x8AEF,
    0x8AFB, 0x8C91, 0x8C92, 0x8C90, 0x8CF5, 0x8CEE, 0x8CF1, 0x8CF0,
    0x8CF3, 0x8D6C, 0x8D6E, 0x8DA5, 0x8DA7, 0x8E33, 0x8E3E, 0x8E38,
    0x8E40, 0x8E45, 0x8E36, 0x8E3C, 0x8E3D, 0x8E41, 0x8E30, 0x8E3F,
    0x8EBD, 0x8F36, 0x8F2E, 0x8F35, 0x8F32, 0x8F39, 0x8F37, 0x8F34,
    0x9076, 0x9079, 0x907B, 0x9086, 0x90FA, 0x9133, 0x9135, 0x9136,
    0x9193, 0x9190, 0x9191, 0x918D, 0x918F, 0x9327, 0x931E, 0x9308,
    0x931F, 0x9306, 0x930F, 0x937A, 0x9338, 0x933C, 0x931B, 0x9323,
    0x9312, 0x9301, 0x9346, 0x932D, 0x930E, 0x930D, 0x92CB, 0x931D,
    0x92FA, 0x9325, 0x9313, 0x92F9, 0x92F7, 0x9334, 0x9302, 0x9324,
    0x92FF, 0x9329, 0x9339, 0x9335, 0x932A, 0x9314, 0x930C,
    /* Big5-HKSCS 0xEC40 .. 0xEC7E */
    0x930B, 0x92FE, 0x9309, 0x9300, 0x92FB, 0x9316, 0x95BC, 0x95CD,
    0x95BE, 0x95B9, 0x95BA, 0x95B6, 0x95BF, 0x95B5, 0x95BD, 0x96A9,
    0x96D4, 0x970B, 0x9712, 0x9710, 0x9799, 0x9797, 0x9794, 0x97F0,
    0x97F8, 0x9835, 0x982F, 0x9832, 0x9924, 0x991F, 0x9927, 0x9929,
    0x999E, 0x99EE, 0x99EC, 0x99E5, 0x99E4, 0x99F0, 0x99E3, 0x99EA,
    0x99E9, 0x99E7, 0x9AB9, 0x9ABF, 0x9AB4, 0x9ABB, 0x9AF6, 0x9AFA,
    0x9AF9, 0x9AF7, 0x9B33, 0x9B80, 0x9B85, 0x9B87, 0x9B7C, 0x9B7E,
    0x9B7B, 0x9B82, 0x9B93, 0x9B92, 0x9B90, 0x9B7A, 0x9B95,
    /* Big5-HKSCS 0xECA1 .. 0xECFE */
            0x9B7D, 0x9B88, 0x9D25, 0x9D17, 0x9D20, 0x9D1E, 0x9D14,
    0x9D29, 0x9D1D, 0x9D18, 0x9D22, 0x9D10, 0x9D19, 0x9D1F, 0x9E88,
    0x9E86, 0x9E87, 0x9EAE, 0x9EAD, 0x9ED5, 0x9ED6, 0x9EFA, 0x9F12,
    0x9F3D, 0x5126, 0x5125, 0x5122, 0x5124, 0x5120, 0x5129, 0x52F4,
    0x5693, 0x568C, 0x568D, 0x5686, 0x5684, 0x5683, 0x567E, 0x5682,
    0x567F, 0x5681, 0x58D6, 0x58D4, 0x58CF, 0x58D2, 0x5B2D, 0x5B25,
    0x5B32, 0x5B23, 0x5B2C, 0x5B27, 0x5B26, 0x5B2F, 0x5B2E, 0x5B7B,
    0x5BF1, 0x5BF2, 0x5DB7, 0x5E6C, 0x5E6A, 0x5FBE, 0x5FBB, 0x61C3,
    0x61B5, 0x61BC, 0x61E7, 0x61E0, 0x61E5, 0x61E4, 0x61E8, 0x61DE,
    0x64EF, 0x64E9, 0x64E3, 0x64EB, 0x64E4, 0x64E8, 0x6581, 0x6580,
    0x65B6, 0x65DA, 0x66D2, 0x6A8D, 0x6A96, 0x6A81, 0x6AA5, 0x6A89,
    0x6A9F, 0x6A9B, 0x6AA1, 0x6A9E, 0x6A87, 0x6A93, 0x6A8E,
    /* Big5-HKSCS 0xED40 .. 0xED7E */
    0x6A95, 0x6A83, 0x6AA8, 0x6AA4, 0x6A91, 0x6A7F, 0x6AA6, 0x6A9A,
    0x6A85, 0x6A8C, 0x6A92, 0x6B5B, 0x6BAD, 0x6C09, 0x6FCC, 0x6FA9,
    0x6FF4, 0x6FD4, 0x6FE3, 0x6FDC, 0x6FED, 0x6FE7, 0x6FE6, 0x6FDE,
    0x6FF2, 0x6FDD, 0x6FE2, 0x6FE8, 0x71E1, 0x71F1, 0x71E8, 0x71F2,
    0x71E4, 0x71F0, 0x71E2, 0x7373, 0x736E, 0x736F, 0x7497, 0x74B2,
    0x74AB, 0x7490, 0x74AA, 0x74AD, 0x74B1, 0x74A5, 0x74AF, 0x7510,
    0x7511, 0x7512, 0x750F, 0x7584, 0x7643, 0x7648, 0x7649, 0x7647,
    0x76A4, 0x76E9, 0x77B5, 0x77AB, 0x77B2, 0x77B7, 0x77B6,
    /* Big5-HKSCS 0xEDA1 .. 0xEDFE */
            0x77B4, 0x77B1, 0x77A8, 0x77F0, 0x78F3, 0x78FD, 0x7902,
    0x78FB, 0x78FC, 0x78F2, 0x7905, 0x78F9, 0x78FE, 0x7904, 0x79AB,
    0x79A8, 0x7A5C, 0x7A5B, 0x7A56, 0x7A58, 0x7A54, 0x7A5A, 0x7ABE,
    0x7AC0, 0x7AC1, 0x7C05, 0x7C0F, 0x7BF2, 0x7C00, 0x7BFF, 0x7BFB,
    0x7C0E, 0x7BF4, 0x7C0B, 0x7BF3, 0x7C02, 0x7C09, 0x7C03, 0x7C01,
    0x7BF8, 0x7BFD, 0x7C06, 0x7BF0, 0x7BF1, 0x7C10, 0x7C0A, 0x7CE8,
    0x7E2D, 0x7E3C, 0x7E42, 0x7E33, 0x9848, 0x7E38, 0x7E2A, 0x7E49,
    0x7E40, 0x7E47, 0x7E29, 0x7E4C, 0x7E30, 0x7E3B, 0x7E36, 0x7E44,
    0x7E3A, 0x7F45, 0x7F7F, 0x7F7E, 0x7F7D, 0x7FF4, 0x7FF2, 0x802C,
    0x81BB, 0x81C4, 0x81CC, 0x81CA, 0x81C5, 0x81C7, 0x81BC, 0x81E9,
    0x825B, 0x825A, 0x825C, 0x8583, 0x8580, 0x858F, 0x85A7, 0x8595,
    0x85A0, 0x858B, 0x85A3, 0x857B, 0x85A4, 0x859A, 0x859E,
    /* Big5-HKSCS 0xEE40 .. 0xEE7E */
    0x8577, 0x857C, 0x8589, 0x85A1, 0x857A, 0x8578, 0x8557, 0x858E,
    0x8596, 0x8586, 0x858D, 0x8599, 0x859D, 0x8581, 0x85A2, 0x8582,
    0x8588, 0x8585, 0x8579, 0x8576, 0x8598, 0x8590, 0x859F, 0x8668,
    0x87BE, 0x87AA, 0x87AD, 0x87C5, 0x87B0, 0x87AC, 0x87B9, 0x87B5,
    0x87BC, 0x87AE, 0x87C9, 0x87C3, 0x87C2, 0x87CC, 0x87B7, 0x87AF,
    0x87C4, 0x87CA, 0x87B4, 0x87B6, 0x87BF, 0x87B8, 0x87BD, 0x87DE,
    0x87B2, 0x8935, 0x8933, 0x893C, 0x893E, 0x8941, 0x8952, 0x8937,
    0x8942, 0x89AD, 0x89AF, 0x89AE, 0x89F2, 0x89F3, 0x8B1E,
    /* Big5-HKSCS 0xEEA1 .. 0xEEFE */
            0x8B18, 0x8B16, 0x8B11, 0x8B05, 0x8B0B, 0x8B22, 0x8B0F,
    0x8B12, 0x8B15, 0x8B07, 0x8B0D, 0x8B08, 0x8B06, 0x8B1C, 0x8B13,
    0x8B1A, 0x8C4F, 0x8C70, 0x8C72, 0x8C71, 0x8C6F, 0x8C95, 0x8C94,
    0x8CF9, 0x8D6F, 0x8E4E, 0x8E4D, 0x8E53, 0x8E50, 0x8E4C, 0x8E47,
    0x8F43, 0x8F40, 0x9085, 0x907E, 0x9138, 0x919A, 0x91A2, 0x919B,
    0x9199, 0x919F, 0x91A1, 0x919D, 0x91A0, 0x93A1, 0x9383, 0x93AF,
    0x9364, 0x9356, 0x9347, 0x937C, 0x9358, 0x935C, 0x9376, 0x9349,
    0x9350, 0x9351, 0x9360, 0x936D, 0x938F, 0x934C, 0x936A, 0x9379,
    0x9357, 0x9355, 0x9352, 0x934F, 0x9371, 0x9377, 0x937B, 0x9361,
    0x935E, 0x9363, 0x9367, 0x9380, 0x934E, 0x9359, 0x95C7, 0x95C0,
    0x95C9, 0x95C3, 0x95C5, 0x95B7, 0x96AE, 0x96B0, 0x96AC, 0x9720,
    0x971F, 0x9718, 0x971D, 0x9719, 0x979A, 0x97A1, 0x979C,
    /* Big5-HKSCS 0xEF40 .. 0xEF7E */
    0x979E, 0x979D, 0x97D5, 0x97D4, 0x97F1, 0x9841, 0x9844, 0x984A,
    0x9849, 0x9845, 0x9843, 0x9925, 0x992B, 0x992C, 0x992A, 0x9933,
    0x9932, 0x992F, 0x992D, 0x9931, 0x9930, 0x9998, 0x99A3, 0x99A1,
    0x9A02, 0x99FA, 0x99F4, 0x99F7, 0x99F9, 0x99F8, 0x99F6, 0x99FB,
    0x99FD, 0x99FE, 0x99FC, 0x9A03, 0x9ABE, 0x9AFE, 0x9AFD, 0x9B01,
    0x9AFC, 0x9B48, 0x9B9A, 0x9BA8, 0x9B9E, 0x9B9B, 0x9BA6, 0x9BA1,
    0x9BA5, 0x9BA4, 0x9B86, 0x9BA2, 0x9BA0, 0x9BAF, 0x9D33, 0x9D41,
    0x9D67, 0x9D36, 0x9D2E, 0x9D2F, 0x9D31, 0x9D38, 0x9D30,
    /* Big5-HKSCS 0xEFA1 .. 0xEFFE */
            0x9D45, 0x9D42, 0x9D43, 0x9D3E, 0x9D37, 0x9D40, 0x9D3D,
    0x7FF5, 0x9D2D, 0x9E8A, 0x9E89, 0x9E8D, 0x9EB0, 0x9EC8, 0x9EDA,
    0x9EFB, 0x9EFF, 0x9F24, 0x9F23, 0x9F22, 0x9F54, 0x9FA0, 0x5131,
    0x512D, 0x512E, 0x5698, 0x569C, 0x5697, 0x569A, 0x569D, 0x5699,
    0x5970, 0x5B3C, 0x5C69, 0x5C6A, 0x5DC0, 0x5E6D, 0x5E6E, 0x61D8,
    0x61DF, 0x61ED, 0x61EE, 0x61F1, 0x61EA, 0x61F0, 0x61EB, 0x61D6,
    0x61E9, 0x64FF, 0x6504, 0x64FD, 0x64F8, 0x6501, 0x6503, 0x64FC,
    0x6594, 0x65DB, 0x66DA, 0x66DB, 0x66D8, 0x6AC5, 0x6AB9, 0x6ABD,
    0x6AE1, 0x6AC6, 0x6ABA, 0x6AB6, 0x6AB7, 0x6AC7, 0x6AB4, 0x6AAD,
    0x6B5E, 0x6BC9, 0x6C0B, 0x7007, 0x700C, 0x700D, 0x7001, 0x7005,
    0x7014, 0x700E, 0x6FFF, 0x7000, 0x6FFB, 0x7026, 0x6FFC, 0x6FF7,
    0x700A, 0x7201, 0x71FF, 0x71F9, 0x7203, 0x71FD, 0x7376,
    /* Big5-HKSCS 0xF040 .. 0xF07E */
    0x74B8, 0x74C0, 0x74B5, 0x74C1, 0x74BE, 0x74B6, 0x74BB, 0x74C2,
    0x7514, 0x7513, 0x765C, 0x7664, 0x7659, 0x7650, 0x7653, 0x7657,
    0x765A, 0x76A6, 0x76BD, 0x76EC, 0x77C2, 0x77BA, 0x78FF, 0x790C,
    0x7913, 0x7914, 0x7909, 0x7910, 0x7912, 0x7911, 0x79AD, 0x79AC,
    0x7A5F, 0x7C1C, 0x7C29, 0x7C19, 0x7C20, 0x7C1F, 0x7C2D, 0x7C1D,
    0x7C26, 0x7C28, 0x7C22, 0x7C25, 0x7C30, 0x7E5C, 0x7E50, 0x7E56,
    0x7E63, 0x7E58, 0x7E62, 0x7E5F, 0x7E51, 0x7E60, 0x7E57, 0x7E53,
    0x7FB5, 0x7FB3, 0x7FF7, 0x7FF8, 0x8075, 0x81D1, 0x81D2,
    /* Big5-HKSCS 0xF0A1 .. 0xF0FE */
            0x81D0, 0x825F, 0x825E, 0x85B4, 0x85C6, 0x85C0, 0x85C3,
    0x85C2, 0x85B3, 0x85B5, 0x85BD, 0x85C7, 0x85C4, 0x85BF, 0x85CB,
    0x85CE, 0x85C8, 0x85C5, 0x85B1, 0x85B6, 0x85D2, 0x8624, 0x85B8,
    0x85B7, 0x85BE, 0x8669, 0x87E7, 0x87E6, 0x87E2, 0x87DB, 0x87EB,
    0x87EA, 0x87E5, 0x87DF, 0x87F3, 0x87E4, 0x87D4, 0x87DC, 0x87D3,
    0x87ED, 0x87D8, 0x87E3, 0x87A4, 0x87D7, 0x87D9, 0x8801, 0x87F4,
    0x87E8, 0x87DD, 0x8953, 0x894B, 0x894F, 0x894C, 0x8946, 0x8950,
    0x8951, 0x8949, 0x8B2A, 0x8B27, 0x8B23, 0x8B33, 0x8B30, 0x8B35,
    0x8B47, 0x8B2F, 0x8B3C, 0x8B3E, 0x8B31, 0x8B25, 0x8B37, 0x8B26,
    0x8B36, 0x8B2E, 0x8B24, 0x8B3B, 0x8B3D, 0x8B3A, 0x8C42, 0x8C75,
    0x8C99, 0x8C98, 0x8C97, 0x8CFE, 0x8D04, 0x8D02, 0x8D00, 0x8E5C,
    0x8E62, 0x8E60, 0x8E57, 0x8E56, 0x8E5E, 0x8E65, 0x8E67,
    /* Big5-HKSCS 0xF140 .. 0xF17E */
    0x8E5B, 0x8E5A, 0x8E61, 0x8E5D, 0x8E69, 0x8E54, 0x8F46, 0x8F47,
    0x8F48, 0x8F4B, 0x9128, 0x913A, 0x913B, 0x913E, 0x91A8, 0x91A5,
    0x91A7, 0x91AF, 0x91AA, 0x93B5, 0x938C, 0x9392, 0x93B7, 0x939B,
    0x939D, 0x9389, 0x93A7, 0x938E, 0x93AA, 0x939E, 0x93A6, 0x9395,
    0x9388, 0x9399, 0x939F, 0x938D, 0x93B1, 0x9391, 0x93B2, 0x93A4,
    0x93A8, 0x93B4, 0x93A3, 0x93A5, 0x95D2, 0x95D3, 0x95D1, 0x96B3,
    0x96D7, 0x96DA, 0x5DC2, 0x96DF, 0x96D8, 0x96DD, 0x9723, 0x9722,
    0x9725, 0x97AC, 0x97AE, 0x97A8, 0x97AB, 0x97A4, 0x97AA,
    /* Big5-HKSCS 0xF1A1 .. 0xF1FE */
            0x97A2, 0x97A5, 0x97D7, 0x97D9, 0x97D6, 0x97D8, 0x97FA,
    0x9850, 0x9851, 0x9852, 0x98B8, 0x9941, 0x993C, 0x993A, 0x9A0F,
    0x9A0B, 0x9A09, 0x9A0D, 0x9A04, 0x9A11, 0x9A0A, 0x9A05, 0x9A07,
    0x9A06, 0x9AC0, 0x9ADC, 0x9B08, 0x9B04, 0x9B05, 0x9B29, 0x9B35,
    0x9B4A, 0x9B4C, 0x9B4B, 0x9BC7, 0x9BC6, 0x9BC3, 0x9BBF, 0x9BC1,
    0x9BB5, 0x9BB8, 0x9BD3, 0x9BB6, 0x9BC4, 0x9BB9, 0x9BBD, 0x9D5C,
    0x9D53, 0x9D4F, 0x9D4A, 0x9D5B, 0x9D4B, 0x9D59, 0x9D56, 0x9D4C,
    0x9D57, 0x9D52, 0x9D54, 0x9D5F, 0x9D58, 0x9D5A, 0x9E8E, 0x9E8C,
    0x9EDF, 0x9F01, 0x9F00, 0x9F16, 0x9F25, 0x9F2B, 0x9F2A, 0x9F29,
    0x9F28, 0x9F4C, 0x9F55, 0x5134, 0x5135, 0x5296, 0x52F7, 0x53B4,
    0x56AB, 0x56AD, 0x56A6, 0x56A7, 0x56AA, 0x56AC, 0x58DA, 0x58DD,
    0x58DB, 0x5912, 0x5B3D, 0x5B3E, 0x5B3F, 0x5DC3, 0x5E70,
    /* Big5-HKSCS 0xF240 .. 0xF27E */
    0x5FBF, 0x61FB, 0x6507, 0x6510, 0x650D, 0x6509, 0x650C, 0x650E,
    0x6584, 0x65DE, 0x65DD, 0x66DE, 0x6AE7, 0x6AE0, 0x6ACC, 0x6AD1,
    0x6AD9, 0x6ACB, 0x6ADF, 0x6ADC, 0x6AD0, 0x6AEB, 0x6ACF, 0x6ACD,
    0x6ADE, 0x6B60, 0x6BB0, 0x6C0C, 0x7019, 0x7027, 0x7020, 0x7016,
    0x702B, 0x7021, 0x7022, 0x7023, 0x7029, 0x7017, 0x7024, 0x701C,
    0x702A, 0x720C, 0x720A, 0x7207, 0x7202, 0x7205, 0x72A5, 0x72A6,
    0x72A4, 0x72A3, 0x72A1, 0x74CB, 0x74C5, 0x74B7, 0x74C3, 0x7516,
    0x7660, 0x77C9, 0x77CA, 0x77C4, 0x77F1, 0x791D, 0x791B,
    /* Big5-HKSCS 0xF2A1 .. 0xF2FE */
            0x7921, 0x791C, 0x7917, 0x791E, 0x79B0, 0x7A67, 0x7A68,
    0x7C33, 0x7C3C, 0x7C39, 0x7C2C, 0x7C3B, 0x7CEC, 0x7CEA, 0x7E76,
    0x7E75, 0x7E78, 0x7E70, 0x7E77, 0x7E6F, 0x7E7A, 0x7E72, 0x7E74,
    0x7E68, 0x7F4B, 0x7F4A, 0x7F83, 0x7F86, 0x7FB7, 0x7FFD, 0x7FFE,
    0x8078, 0x81D7, 0x81D5, 0x8264, 0x8261, 0x8263, 0x85EB, 0x85F1,
    0x85ED, 0x85D9, 0x85E1, 0x85E8, 0x85DA, 0x85D7, 0x85EC, 0x85F2,
    0x85F8, 0x85D8, 0x85DF, 0x85E3, 0x85DC, 0x85D1, 0x85F0, 0x85E6,
    0x85EF, 0x85DE, 0x85E2, 0x8800, 0x87FA, 0x8803, 0x87F6, 0x87F7,
    0x8809, 0x880C, 0x880B, 0x8806, 0x87FC, 0x8808, 0x87FF, 0x880A,
    0x8802, 0x8962, 0x895A, 0x895B, 0x8957, 0x8961, 0x895C, 0x8958,
    0x895D, 0x8959, 0x8988, 0x89B7, 0x89B6, 0x89F6, 0x8B50, 0x8B48,
    0x8B4A, 0x8B40, 0x8B53, 0x8B56, 0x8B54, 0x8B4B, 0x8B55,
    /* Big5-HKSCS 0xF340 .. 0xF37E */
    0x8B51, 0x8B42, 0x8B52, 0x8B57, 0x8C43, 0x8C77, 0x8C76, 0x8C9A,
    0x8D06, 0x8D07, 0x8D09, 0x8DAC, 0x8DAA, 0x8DAD, 0x8DAB, 0x8E6D,
    0x8E78, 0x8E73, 0x8E6A, 0x8E6F, 0x8E7B, 0x8EC2, 0x8F52, 0x8F51,
    0x8F4F, 0x8F50, 0x8F53, 0x8FB4, 0x9140, 0x913F, 0x91B0, 0x91AD,
    0x93DE, 0x93C7, 0x93CF, 0x93C2, 0x93DA, 0x93D0, 0x93F9, 0x93EC,
    0x93CC, 0x93D9, 0x93A9, 0x93E6, 0x93CA, 0x93D4, 0x93EE, 0x93E3,
    0x93D5, 0x93C4, 0x93CE, 0x93C0, 0x93D2, 0x93E7, 0x957D, 0x95DA,
    0x95DB, 0x96E1, 0x9729, 0x972B, 0x972C, 0x9728, 0x9726,
    /* Big5-HKSCS 0xF3A1 .. 0xF3FE */
            0x97B3, 0x97B7, 0x97B6, 0x97DD, 0x97DE, 0x97DF, 0x985C,
    0x9859, 0x985D, 0x9857, 0x98BF, 0x98BD, 0x98BB, 0x98BE, 0x9948,
    0x9947, 0x9943, 0x99A6, 0x99A7, 0x9A1A, 0x9A15, 0x9A25, 0x9A1D,
    0x9A24, 0x9A1B, 0x9A22, 0x9A20, 0x9A27, 0x9A23, 0x9A1E, 0x9A1C,
    0x9A14, 0x9AC2, 0x9B0B, 0x9B0A, 0x9B0E, 0x9B0C, 0x9B37, 0x9BEA,
    0x9BEB, 0x9BE0, 0x9BDE, 0x9BE4, 0x9BE6, 0x9BE2, 0x9BF0, 0x9BD4,
    0x9BD7, 0x9BEC, 0x9BDC, 0x9BD9, 0x9BE5, 0x9BD5, 0x9BE1, 0x9BDA,
    0x9D77, 0x9D81, 0x9D8A, 0x9D84, 0x9D88, 0x9D71, 0x9D80, 0x9D78,
    0x9D86, 0x9D8B, 0x9D8C, 0x9D7D, 0x9D6B, 0x9D74, 0x9D75, 0x9D70,
    0x9D69, 0x9D85, 0x9D73, 0x9D7B, 0x9D82, 0x9D6F, 0x9D79, 0x9D7F,
    0x9D87, 0x9D68, 0x9E94, 0x9E91, 0x9EC0, 0x9EFC, 0x9F2D, 0x9F40,
    0x9F41, 0x9F4D, 0x9F56, 0x9F57, 0x9F58, 0x5337, 0x56B2,
    /* Big5-HKSCS 0xF440 .. 0xF47E */
    0x56B5, 0x56B3, 0x58E3, 0x5B45, 0x5DC6, 0x5DC7, 0x5EEE, 0x5EEF,
    0x5FC0, 0x5FC1, 0x61F9, 0x6517, 0x6516, 0x6515, 0x6513, 0x65DF,
    0x66E8, 0x66E3, 0x66E4, 0x6AF3, 0x6AF0, 0x6AEA, 0x6AE8, 0x6AF9,
    0x6AF1, 0x6AEE, 0x6AEF, 0x703C, 0x7035, 0x702F, 0x7037, 0x7034,
    0x7031, 0x7042, 0x7038, 0x703F, 0x703A, 0x7039, 0x7040, 0x703B,
    0x7033, 0x7041, 0x7213, 0x7214, 0x72A8, 0x737D, 0x737C, 0x74BA,
    0x76AB, 0x76AA, 0x76BE, 0x76ED, 0x77CC, 0x77CE, 0x77CF, 0x77CD,
    0x77F2, 0x7925, 0x7923, 0x7927, 0x7928, 0x7924, 0x7929,
    /* Big5-HKSCS 0xF4A1 .. 0xF4FE */
            0x79B2, 0x7A6E, 0x7A6C, 0x7A6D, 0x7AF7, 0x7C49, 0x7C48,
    0x7C4A, 0x7C47, 0x7C45, 0x7CEE, 0x7E7B, 0x7E7E, 0x7E81, 0x7E80,
    0x7FBA, 0x7FFF, 0x8079, 0x81DB, 0x81D9, 0x820B, 0x8268, 0x8269,
    0x8622, 0x85FF, 0x8601, 0x85FE, 0x861B, 0x8600, 0x85F6, 0x8604,
    0x8609, 0x8605, 0x860C, 0x85FD, 0x8819, 0x8810, 0x8811, 0x8817,
    0x8813, 0x8816, 0x8963, 0x8966, 0x89B9, 0x89F7, 0x8B60, 0x8B6A,
    0x8B5D, 0x8B68, 0x8B63, 0x8B65, 0x8B67, 0x8B6D, 0x8DAE, 0x8E86,
    0x8E88, 0x8E84, 0x8F59, 0x8F56, 0x8F57, 0x8F55, 0x8F58, 0x8F5A,
    0x908D, 0x9143, 0x9141, 0x91B7, 0x91B5, 0x91B2, 0x91B3, 0x940B,
    0x9413, 0x93FB, 0x9420, 0x940F, 0x9414, 0x93FE, 0x9415, 0x9410,
    0x9428, 0x9419, 0x940D, 0x93F5, 0x9400, 0x93F7, 0x9407, 0x940E,
    0x9416, 0x9412, 0x93FA, 0x9409, 0x93F8, 0x940A, 0x93FF,
    /* Big5-HKSCS 0xF540 .. 0xF57E */
    0x93FC, 0x940C, 0x93F6, 0x9411, 0x9406, 0x95DE, 0x95E0, 0x95DF,
    0x972E, 0x972F, 0x97B9, 0x97BB, 0x97FD, 0x97FE, 0x9860, 0x9862,
    0x9863, 0x985F, 0x98C1, 0x98C2, 0x9950, 0x994E, 0x9959, 0x994C,
    0x994B, 0x9953, 0x9A32, 0x9A34, 0x9A31, 0x9A2C, 0x9A2A, 0x9A36,
    0x9A29, 0x9A2E, 0x9A38, 0x9A2D, 0x9AC7, 0x9ACA, 0x9AC6, 0x9B10,
    0x9B12, 0x9B11, 0x9C0B, 0x9C08, 0x9BF7, 0x9C05, 0x9C12, 0x9BF8,
    0x9C40, 0x9C07, 0x9C0E, 0x9C06, 0x9C17, 0x9C14, 0x9C09, 0x9D9F,
    0x9D99, 0x9DA4, 0x9D9D, 0x9D92, 0x9D98, 0x9D90, 0x9D9B,
    /* Big5-HKSCS 0xF5A1 .. 0xF5FE */
            0x9DA0, 0x9D94, 0x9D9C, 0x9DAA, 0x9D97, 0x9DA1, 0x9D9A,
    0x9DA2, 0x9DA8, 0x9D9E, 0x9DA3, 0x9DBF, 0x9DA9, 0x9D96, 0x9DA6,
    0x9DA7, 0x9E99, 0x9E9B, 0x9E9A, 0x9EE5, 0x9EE4, 0x9EE7, 0x9EE6,
    0x9F30, 0x9F2E, 0x9F5B, 0x9F60, 0x9F5E, 0x9F5D, 0x9F59, 0x9F91,
    0x513A, 0x5139, 0x5298, 0x5297, 0x56C3, 0x56BD, 0x56BE, 0x5B48,
    0x5B47, 0x5DCB, 0x5DCF, 0x5EF1, 0x61FD, 0x651B, 0x6B02, 0x6AFC,
    0x6B03, 0x6AF8, 0x6B00, 0x7043, 0x7044, 0x704A, 0x7048, 0x7049,
    0x7045, 0x7046, 0x721D, 0x721A, 0x7219, 0x737E, 0x7517, 0x766A,
    0x77D0, 0x792D, 0x7931, 0x792F, 0x7C54, 0x7C53, 0x7CF2, 0x7E8A,
    0x7E87, 0x7E88, 0x7E8B, 0x7E86, 0x7E8D, 0x7F4D, 0x7FBB, 0x8030,
    0x81DD, 0x8618, 0x862A, 0x8626, 0x861F, 0x8623, 0x861C, 0x8619,
    0x8627, 0x862E, 0x8621, 0x8620, 0x8629, 0x861E, 0x8625,
    /* Big5-HKSCS 0xF640 .. 0xF67E */
    0x8829, 0x881D, 0x881B, 0x8820, 0x8824, 0x881C, 0x882B, 0x884A,
    0x896D, 0x8969, 0x896E, 0x896B, 0x89FA, 0x8B79, 0x8B78, 0x8B45,
    0x8B7A, 0x8B7B, 0x8D10, 0x8D14, 0x8DAF, 0x8E8E, 0x8E8C, 0x8F5E,
    0x8F5B, 0x8F5D, 0x9146, 0x9144, 0x9145, 0x91B9, 0x943F, 0x943B,
    0x9436, 0x9429, 0x943D, 0x943C, 0x9430, 0x9439, 0x942A, 0x9437,
    0x942C, 0x9440, 0x9431, 0x95E5, 0x95E4, 0x95E3, 0x9735, 0x973A,
    0x97BF, 0x97E1, 0x9864, 0x98C9, 0x98C6, 0x98C0, 0x9958, 0x9956,
    0x9A39, 0x9A3D, 0x9A46, 0x9A44, 0x9A42, 0x9A41, 0x9A3A,
    /* Big5-HKSCS 0xF6A1 .. 0xF6FE */
            0x9A3F, 0x9ACD, 0x9B15, 0x9B17, 0x9B18, 0x9B16, 0x9B3A,
    0x9B52, 0x9C2B, 0x9C1D, 0x9C1C, 0x9C2C, 0x9C23, 0x9C28, 0x9C29,
    0x9C24, 0x9C21, 0x9DB7, 0x9DB6, 0x9DBC, 0x9DC1, 0x9DC7, 0x9DCA,
    0x9DCF, 0x9DBE, 0x9DC5, 0x9DC3, 0x9DBB, 0x9DB5, 0x9DCE, 0x9DB9,
    0x9DBA, 0x9DAC, 0x9DC8, 0x9DB1, 0x9DAD, 0x9DCC, 0x9DB3, 0x9DCD,
    0x9DB2, 0x9E7A, 0x9E9C, 0x9EEB, 0x9EEE, 0x9EED, 0x9F1B, 0x9F18,
    0x9F1A, 0x9F31, 0x9F4E, 0x9F65, 0x9F64, 0x9F92, 0x4EB9, 0x56C6,
    0x56C5, 0x56CB, 0x5971, 0x5B4B, 0x5B4C, 0x5DD5, 0x5DD1, 0x5EF2,
    0x6521, 0x6520, 0x6526, 0x6522, 0x6B0B, 0x6B08, 0x6B09, 0x6C0D,
    0x7055, 0x7056, 0x7057, 0x7052, 0x721E, 0x721F, 0x72A9, 0x737F,
    0x74D8, 0x74D5, 0x74D9, 0x74D7, 0x766D, 0x76AD, 0x7935, 0x79B4,
    0x7A70, 0x7A71, 0x7C57, 0x7C5C, 0x7C59, 0x7C5B, 0x7C5A,
    /* Big5-HKSCS 0xF740 .. 0xF77E */
    0x7CF4, 0x7CF1, 0x7E91, 0x7F4F, 0x7F87, 0x81DE, 0x826B, 0x8634,
    0x8635, 0x8633, 0x862C, 0x8632, 0x8636, 0x882C, 0x8828, 0x8826,
    0x882A, 0x8825, 0x8971, 0x89BF, 0x89BE, 0x89FB, 0x8B7E, 0x8B84,
    0x8B82, 0x8B86, 0x8B85, 0x8B7F, 0x8D15, 0x8E95, 0x8E94, 0x8E9A,
    0x8E92, 0x8E90, 0x8E96, 0x8E97, 0x8F60, 0x8F62, 0x9147, 0x944C,
    0x9450, 0x944A, 0x944B, 0x944F, 0x9447, 0x9445, 0x9448, 0x9449,
    0x9446, 0x973F, 0x97E3, 0x986A, 0x9869, 0x98CB, 0x9954, 0x995B,
    0x9A4E, 0x9A53, 0x9A54, 0x9A4C, 0x9A4F, 0x9A48, 0x9A4A,
    /* Big5-HKSCS 0xF7A1 .. 0xF7FE */
            0x9A49, 0x9A52, 0x9A50, 0x9AD0, 0x9B19, 0x9B2B, 0x9B3B,
    0x9B56, 0x9B55, 0x9C46, 0x9C48, 0x9C3F, 0x9C44, 0x9C39, 0x9C33,
    0x9C41, 0x9C3C, 0x9C37, 0x9C34, 0x9C32, 0x9C3D, 0x9C36, 0x9DDB,
    0x9DD2, 0x9DDE, 0x9DDA, 0x9DCB, 0x9DD0, 0x9DDC, 0x9DD1, 0x9DDF,
    0x9DE9, 0x9DD9, 0x9DD8, 0x9DD6, 0x9DF5, 0x9DD5, 0x9DDD, 0x9EB6,
    0x9EF0, 0x9F35, 0x9F33, 0x9F32, 0x9F42, 0x9F6B, 0x9F95, 0x9FA2,
    0x513D, 0x5299, 0x58E8, 0x58E7, 0x5972, 0x5B4D, 0x5DD8, 0x882F,
    0x5F4F, 0x6201, 0x6203, 0x6204, 0x6529, 0x6525, 0x6596, 0x66EB,
    0x6B11, 0x6B12, 0x6B0F, 0x6BCA, 0x705B, 0x705A, 0x7222, 0x7382,
    0x7381, 0x7383, 0x7670, 0x77D4, 0x7C67, 0x7C66, 0x7E95, 0x826C,
    0x863A, 0x8640, 0x8639, 0x863C, 0x8631, 0x863B, 0x863E, 0x8830,
    0x8832, 0x882E, 0x8833, 0x8976, 0x8974, 0x8973, 0x89FE,
    /* Big5-HKSCS 0xF840 .. 0xF87E */
    0x8B8C, 0x8B8E, 0x8B8B, 0x8B88, 0x8C45, 0x8D19, 0x8E98, 0x8F64,
    0x8F63, 0x91BC, 0x9462, 0x9455, 0x945D, 0x9457, 0x945E, 0x97C4,
    0x97C5, 0x9800, 0x9A56, 0x9A59, 0x9B1E, 0x9B1F, 0x9B20, 0x9C52,
    0x9C58, 0x9C50, 0x9C4A, 0x9C4D, 0x9C4B, 0x9C55, 0x9C59, 0x9C4C,
    0x9C4E, 0x9DFB, 0x9DF7, 0x9DEF, 0x9DE3, 0x9DEB, 0x9DF8, 0x9DE4,
    0x9DF6, 0x9DE1, 0x9DEE, 0x9DE6, 0x9DF2, 0x9DF0, 0x9DE2, 0x9DEC,
    0x9DF4, 0x9DF3, 0x9DE8, 0x9DED, 0x9EC2, 0x9ED0, 0x9EF2, 0x9EF3,
    0x9F06, 0x9F1C, 0x9F38, 0x9F37, 0x9F36, 0x9F43, 0x9F4F,
    /* Big5-HKSCS 0xF8A1 .. 0xF8FE */
            0x9F71, 0x9F70, 0x9F6E, 0x9F6F, 0x56D3, 0x56CD, 0x5B4E,
    0x5C6D, 0x652D, 0x66ED, 0x66EE, 0x6B13, 0x705F, 0x7061, 0x705D,
    0x7060, 0x7223, 0x74DB, 0x74E5, 0x77D5, 0x7938, 0x79B7, 0x79B6,
    0x7C6A, 0x7E97, 0x7F89, 0x826D, 0x8643, 0x8838, 0x8837, 0x8835,
    0x884B, 0x8B94, 0x8B95, 0x8E9E, 0x8E9F, 0x8EA0, 0x8E9D, 0x91BE,
    0x91BD, 0x91C2, 0x946B, 0x9468, 0x9469, 0x96E5, 0x9746, 0x9743,
    0x9747, 0x97C7, 0x97E5, 0x9A5E, 0x9AD5, 0x9B59, 0x9C63, 0x9C67,
    0x9C66, 0x9C62, 0x9C5E, 0x9C60, 0x9E02, 0x9DFE, 0x9E07, 0x9E03,
    0x9E06, 0x9E05, 0x9E00, 0x9E01, 0x9E09, 0x9DFF, 0x9DFD, 0x9E04,
    0x9EA0, 0x9F1E, 0x9F46, 0x9F74, 0x9F75, 0x9F76, 0x56D4, 0x652E,
    0x65B8, 0x6B18, 0x6B19, 0x6B17, 0x6B1A, 0x7062, 0x7226, 0x72AA,
    0x77D8, 0x77D9, 0x7939, 0x7C69, 0x7C6B, 0x7CF6, 0x7E9A,
    /* Big5-HKSCS 0xF940 .. 0xF97E */
    0x7E98, 0x7E9B, 0x7E99, 0x81E0, 0x81E1, 0x8646, 0x8647, 0x8648,
    0x8979, 0x897A, 0x897C, 0x897B, 0x89FF, 0x8B98, 0x8B99, 0x8EA5,
    0x8EA4, 0x8EA3, 0x946E, 0x946D, 0x946F, 0x9471, 0x9473, 0x9749,
    0x9872, 0x995F, 0x9C68, 0x9C6E, 0x9C6D, 0x9E0B, 0x9E0D, 0x9E10,
    0x9E0F, 0x9E12, 0x9E11, 0x9EA1, 0x9EF5, 0x9F09, 0x9F47, 0x9F78,
    0x9F7B, 0x9F7A, 0x9F79, 0x571E, 0x7066, 0x7C6F, 0x883C, 0x8DB2,
    0x8EA6, 0x91C3, 0x9474, 0x9478, 0x9476, 0x9475, 0x9A60, 0x9C74,
    0x9C73, 0x9C71, 0x9C75, 0x9E14, 0x9E13, 0x9EF6, 0x9F0A,
    /* Big5-HKSCS 0xF9A1 .. 0xF9FE */
            0x9FA4, 0x7068, 0x7065, 0x7CF7, 0x866A, 0x883E, 0x883D,
    0x883F, 0x8B9E, 0x8C9C, 0x8EA9, 0x8EC9, 0x974B, 0x9873, 0x9874,
    0x98CC, 0x9961, 0x99AB, 0x9A64, 0x9A66, 0x9A67, 0x9B24, 0x9E15,
    0x9E17, 0x9F48, 0x6207, 0x6B1E, 0x7227, 0x864C, 0x8EA8, 0x9482,
    0x9480, 0x9481, 0x9A69, 0x9A68, 0x9B2E, 0x9E19, 0x7229, 0x864B,
    0x8B9F, 0x9483, 0x9C79, 0x9EB7, 0x7675, 0x9A6B, 0x9C7A, 0x9E1D,
    0x7069, 0x706A, 0x9EA4, 0x9F7E, 0x9F49, 0x9F98, 0x7881, 0x92B9,
    0x88CF, 0x58BB, 0x6052, 0x7CA7, 0x5AFA, 0x2554, 0x2566, 0x2557,
    0x2560, 0x256C, 0x2563, 0x255A, 0x2569, 0x255D, 0x2552, 0x2564,
    0x2555, 0x255E, 0x256A, 0x2561, 0x2558, 0x2567, 0x255B, 0x2553,
    0x2565, 0x2556, 0x255F, 0x256B, 0x2562, 0x2559, 0x2568, 0x255C,
    0x2551, 0x2550, 0x256D, 0x256E, 0x2570, 0x256F, 0xFFED,
    /* Big5-HKSCS 0xFA40 .. 0xFA7E */
    0xE000, 0x92DB, 0xE002, 0xE003, 0x854C, 0x42B5, 0x73EF, 0x51B5,
    0x3649, 0xE009, 0xE00A, 0x9344, 0xE00C, 0x82EE, 0xE00E, 0x783C,
    0x6744, 0x62DF, 0xE012, 0xE013, 0xE014, 0xE015, 0xE016, 0x4FAB,
    0xE018, 0x5008, 0xE01A, 0xE01B, 0xE01C, 0xE01D, 0xE01E, 0x5029,
    0xE020, 0x5FA4, 0xE022, 0xE023, 0x6EDB, 0xE025, 0x507D, 0x5101,
    0x347A, 0x510E, 0x986C, 0x3743, 0x8416, 0xE02D, 0xE02E, 0x5160,
    0xE030, 0x516A, 0xE032, 0xE033, 0xE034, 0xE035, 0xE036, 0xE037,
    0xE038, 0x5B82, 0x877D, 0xE03B, 0xE03C, 0x51B2, 0x51B8,
    /* Big5-HKSCS 0xFAA1 .. 0xFAFE */
            0x9D34, 0x51C9, 0x51CF, 0x51D1, 0x3CDC, 0x51D3, 0xE045,
    0x51B3, 0x51E2, 0x5342, 0x51ED, 0x83CD, 0x693E, 0xE04C, 0x5F7B,
    0x520B, 0x5226, 0x523C, 0x52B5, 0x5257, 0x5294, 0x52B9, 0x52C5,
    0x7C15, 0x8542, 0x52E0, 0x860D, 0xE05A, 0x5305, 0xE05C, 0x5549,
    0x6ED9, 0xE05F, 0xE060, 0xE061, 0x5333, 0x5344, 0xE064, 0x6CCB,
    0xE066, 0x681B, 0x73D5, 0x604A, 0x3EAA, 0x38CC, 0xE06C, 0x71DD,
    0x44A2, 0x536D, 0x5374, 0xE071, 0x537E, 0x537F, 0xE074, 0xE075,
    0x77E6, 0x5393, 0xE078, 0x53A0, 0x53AB, 0x53AE, 0x73A7, 0xE07D,
    0x3F59, 0x739C, 0x53C1, 0x53C5, 0x6C49, 0x4E49, 0x57FE, 0x53D9,
    0x3AAB, 0xE087, 0x53E0, 0xE089, 0xE08A, 0x53F6, 0xE08C, 0x5413,
    0x7079, 0x552B, 0x6657, 0x6D5B, 0x546D, 0xE093, 0xE094, 0x555D,
    0x548F, 0x54A4, 0x47A6, 0xE099, 0xE09A, 0x3DB4, 0xE09C,
    /* Big5-HKSCS 0xFB40 .. 0xFB7E */
    0xE09D, 0xE09E, 0x5547, 0x4CED, 0x542F, 0x7417, 0x5586, 0x55A9,
    0x5605, 0xE0A6, 0xE0A7, 0x4552, 0xE0A9, 0x66B3, 0xE0AB, 0x5637,
    0x66CD, 0xE0AE, 0x66A4, 0x66AD, 0x564D, 0x564F, 0x78F1, 0x56F1,
    0x9787, 0x53FE, 0x5700, 0x56EF, 0x56ED, 0xE0BA, 0x3623, 0xE0BC,
    0x5746, 0xE0BE, 0x6C6E, 0x708B, 0x5742, 0x36B1, 0xE0C3, 0x57E6,
    0xE0C5, 0x5803, 0xE0C7, 0xE0C8, 0x5826, 0xE0CA, 0x585C, 0x58AA,
    0x3561, 0x58E0, 0x58DC, 0xE0D0, 0x58FB, 0x5BFF, 0x5743, 0xE0D4,
    0xE0D5, 0x93D3, 0x35A1, 0x591F, 0x68A6, 0x36C3, 0x6E59,
    /* Big5-HKSCS 0xFBA1 .. 0xFBFE */
            0xE0DC, 0x5A24, 0x5553, 0xE0DF, 0x8505, 0x59C9, 0xE0E2,
    0xE0E3, 0xE0E4, 0xE0E5, 0x59D9, 0xE0E7, 0xE0E8, 0xE0E9, 0x6D71,
    0xE0EB, 0xE0EC, 0x59F9, 0xE0EE, 0x5AAB, 0x5A63, 0x36E6, 0xE0F2,
    0x5A77, 0x3708, 0x5A96, 0x7465, 0x5AD3, 0xE0F8, 0xE0F9, 0x3D85,
    0xE0FB, 0x3732, 0xE0FD, 0x5E83, 0x52D0, 0x5B76, 0x6588, 0x5B7C,
    0xE103, 0x4004, 0x485D, 0xE106, 0x5BD5, 0x6160, 0xE109, 0xE10A,
    0xE10B, 0x5BF3, 0x5B9D, 0x4D10, 0x5C05, 0xE110, 0x5C13, 0x73CE,
    0x5C14, 0xE114, 0xE115, 0x5C49, 0x48DD, 0x5C85, 0x5CE9, 0x5CEF,
    0x5D8B, 0xE11C, 0xE11D, 0x5D10, 0x5D18, 0x5D46, 0xE121, 0x5CBA,
    0x5DD7, 0x82FC, 0x382D, 0xE126, 0xE127, 0xE128, 0x8287, 0x3836,
    0x3BC2, 0x5E2E, 0x6A8A, 0x5E75, 0x5E7A, 0xE130, 0xE131, 0x53A6,
    0x4EB7, 0x5ED0, 0x53A8, 0xE136, 0x5E09, 0x5EF4, 0xE139,
    /* Big5-HKSCS 0xFC40 .. 0xFC7E */
    0x5EF9, 0x5EFB, 0x38A0, 0x5EFC, 0x683E, 0x941B, 0x5F0D, 0xE141,
    0xE142, 0x3ADE, 0x48AE, 0xE145, 0x5F3A, 0xE147, 0xE148, 0x5F58,
    0xE14A, 0x5F63, 0x97BD, 0xE14D, 0x5F72, 0x9340, 0xE150, 0x5FA7,
    0x5DB6, 0x3D5F, 0xE154, 0xE155, 0xE156, 0xE157, 0x91D6, 0xE159,
    0xE15A, 0x6031, 0x6685, 0xE15D, 0x3963, 0x3DC7, 0x3639, 0x5790,
    0xE162, 0x7971, 0x3E40, 0x609E, 0x60A4, 0x60B3, 0xE168, 0xE169,
    0xE16A, 0x74A4, 0x50E1, 0x5AA0, 0x6164, 0x8424, 0x6142, 0xE171,
    0xE172, 0x6181, 0x51F4, 0xE175, 0x6187, 0x5BAA, 0xE178,
    /* Big5-HKSCS 0xFCA1 .. 0xFCFE */
            0xE179, 0x61D3, 0xE17B, 0xE17C, 0x61D0, 0x3932, 0xE17F,
    0xE180, 0x6023, 0x615C, 0x651E, 0x638B, 0xE185, 0x62C5, 0xE187,
    0x62D5, 0xE189, 0x636C, 0xE18B, 0x3A17, 0x6438, 0x63F8, 0xE18F,
    0xE190, 0x6490, 0x6F8A, 0xE193, 0x9814, 0xE195, 0xE196, 0x64E1,
    0x64E5, 0x947B, 0x3A66, 0x643A, 0x3A57, 0x654D, 0x6F16, 0xE19F,
    0xE1A0, 0x6585, 0x656D, 0x655F, 0xE1A4, 0x65B5, 0xE1A6, 0x4B37,
    0x65D1, 0x40D8, 0xE1AA, 0x65E0, 0x65E3, 0x5FDF, 0xE1AE, 0x6618,
    0xE1B0, 0xE1B1, 0x6644, 0xE1B3, 0xE1B4, 0x664B, 0xE1B6, 0x6667,
    0xE1B8, 0x6673, 0x6674, 0xE1BB, 0xE1BC, 0xE1BD, 0xE1BE, 0xE1BF,
    0x77C5, 0xE1C1, 0x99A4, 0x6702, 0xE1C4, 0xE1C5, 0x3B2B, 0x69FA,
    0xE1C8, 0x675E, 0x6767, 0x6762, 0xE1CC, 0xE1CD, 0x67D7, 0x44E9,
    0x6822, 0x6E50, 0x923C, 0x6801, 0xE1D4, 0xE1D5, 0x685D,
    /* Big5-HKSCS 0xFD40 .. 0xFD7E */
    0xE1D7, 0x69E1, 0x6A0B, 0xE1DA, 0x6973, 0x68C3, 0xE1DD, 0x6901,
    0x6900, 0x3D32, 0x3A01, 0xE1E2, 0x3B80, 0x67AC, 0x6961, 0xE1E6,
    0x42FC, 0x6936, 0x6998, 0x3BA1, 0xE1EB, 0x8363, 0x5090, 0x69F9,
    0xE1EF, 0xE1F0, 0x6A45, 0xE1F2, 0x6A9D, 0x3BF3, 0x67B1, 0x6AC8,
    0xE1F7, 0x3C0D, 0x6B1D, 0xE1FA, 0x60DE, 0x6B35, 0x6B74, 0xE1FE,
    0x6EB5, 0xE200, 0xE201, 0xE202, 0x3740, 0x5421, 0xE205, 0x6BE1,
    0xE207, 0x6BDC, 0x6C37, 0xE20A, 0xE20B, 0xE20C, 0x6C5A, 0x8226,
    0x6C79, 0xE210, 0x44C5, 0xE212, 0xE213, 0xE214, 0xE215,
    /* Big5-HKSCS 0xFDA1 .. 0xFDFE */
            0xE216, 0x36E5, 0x3CEB, 0xE219, 0x9B83, 0xE21B, 0xE21C,
    0x7F8F, 0x6837, 0xE21F, 0xE220, 0xE221, 0x6D96, 0x6D5C, 0x6E7C,
    0x6F04, 0xE226, 0xE227, 0xE228, 0x8533, 0xE22A, 0x51C7, 0x6C9C,
    0x6E1D, 0x842E, 0xE22F, 0x6E2F, 0xE231, 0x7453, 0xE233, 0x79CC,
    0x6E4F, 0x5A91, 0xE237, 0x6FF8, 0x370D, 0x6F9D, 0xE23B, 0x6EFA,
    0xE23D, 0xE23E, 0x4555, 0x93F0, 0x6F44, 0x6F5C, 0x3D4E, 0x6F74,
    0xE245, 0x3D3B, 0x6F9F, 0xE248, 0x6FD3, 0xE24A, 0xE24B, 0xE24C,
    0xE24D, 0xE24E, 0xE24F, 0x51DF, 0xE251, 0xE252, 0xE253, 0xE254,
    0x704B, 0x707E, 0x70A7, 0x7081, 0x70CC, 0x70D5, 0x70D6, 0x70DF,
    0x4104, 0x3DE8, 0x71B4, 0x7196, 0xE261, 0x712B, 0x7145, 0x5A88,
    0x714A, 0x716E, 0x5C9C, 0xE268, 0x714F, 0x9362, 0xE26B, 0x712C,
    0xE26D, 0xE26E, 0xE26F, 0x71BA, 0xE271, 0x70BD, 0x720E,
    /* Big5-HKSCS 0xFE40 .. 0xFE7E */
    0x9442, 0x7215, 0x5911, 0x9443, 0x7224, 0x9341, 0xE27A, 0x722E,
    0x7240, 0xE27D, 0x68BD, 0x7255, 0x7257, 0x3E55, 0xE282, 0x680D,
    0x6F3D, 0x7282, 0x732A, 0x732B, 0xE288, 0xE289, 0x48ED, 0xE28B,
    0x7328, 0x732E, 0x73CF, 0x73AA, 0xE290, 0xE291, 0x73C9, 0x7449,
    0xE294, 0xE295, 0xE296, 0x6623, 0x36C5, 0xE299, 0xE29A, 0xE29B,
    0x73F7, 0x7415, 0x6903, 0xE29F, 0x7439, 0xE2A1, 0x3ED7, 0x745C,
    0xE2A4, 0x7460, 0xE2A6, 0x7447, 0x73E4, 0x7476, 0x83B9, 0x746C,
    0x3730, 0x7474, 0x93F1, 0x6A2C, 0x7482, 0x4953, 0xE2B2,
    /* Big5-HKSCS 0xFEA1 .. 0xFEFE */
            0xE2B3, 0xE2B4, 0xE2B5, 0x5B46, 0xE2B7, 0xE2B8, 0x74C8,
    0xE2BA, 0x750E, 0x74E9, 0x751E, 0xE2BE, 0xE2BF, 0x5BD7, 0xE2C1,
    0x9385, 0x754D, 0x754A, 0x7567, 0x756E, 0xE2C7, 0x3F04, 0xE2C9,
    0x758E, 0x745D, 0x759E, 0x75B4, 0x7602, 0x762C, 0x7651, 0x764F,
    0x766F, 0x7676, 0xE2D4, 0x7690, 0x81EF, 0x37F8, 0xE2D8, 0xE2D9,
    0x76A1, 0x76A5, 0x76B7, 0x76CC, 0xE2DE, 0x8462, 0xE2E0, 0xE2E1,
    0xE2E2, 0x771E, 0x7726, 0x7740, 0x64AF, 0xE2E7, 0x7758, 0xE2E9,
    0x77AF, 0xE2EB, 0xE2EC, 0xE2ED, 0x77F4, 0x7809, 0xE2F0, 0xE2F1,
    0x68CA, 0x78AF, 0x78C7, 0x78D3, 0x96A5, 0x792E, 0xE2F8, 0x78D7,
    0x7934, 0x78B1, 0xE2FC, 0x8FB8, 0x8884, 0xE2FF, 0xE300, 0xE301,
    0x7986, 0x8900, 0x6902, 0x7980, 0xE306, 0x799D, 0xE308, 0x793C,
    0x79A9, 0x6E2A, 0xE30C, 0x3EA8, 0x79C6, 0xE30F, 0x79D4,
};


/* Returns the number of bytes of Bytes consumed. */
static int qt_Big5hkscsToUnicode(const uchar *s, uint *pwc)
{
    uchar c1 = s[0];
    if ((c1 >= 0x81 && c1 <= 0xfe)) {
        uchar c2 = s[1];
        if ((c2 >= 0x40 && c2 < 0x7f) || (c2 >= 0xa1 && c2 < 0xff)) {
            uint i = 157 * (c1 - 0x81) + (c2 - (c2 >= 0xa1 ? 0x62 : 0x40));
            ushort wc = 0xfffd;
            if (i < 19782)
                wc = big5hkscs_to_ucs[i];
            if (wc != 0xfffd) {
                *pwc = (uint) wc;
                return 2;
            }
        }
        return 0;
    } else if (c1 < 0x80) {
        *pwc = (uint) c1;
        return 1;
    }
    return 0;
}

//---------------------------------------------------------------------------

/*
 * ucs4 to big5hkscs convert routing
 */

typedef struct {
    ushort index; /* index into big table */
    ushort used;  /* bitmask of used entries */
} Summary16;

/* ISO-10646-UCS-4 to big5hkscs convert table */
static const uchar big5hkscs_to_charset[24908][2] = {
    {0x21,0x00}, {0xA2,0x46}, {0xA2,0x47}, {0xA2,0x44},
    {0x7C,0x00}, {0xA1,0xB1}, {0xC6,0xD8}, {0x63,0x00},
    {0x61,0x00}, {0x2D,0x00}, {0x52,0x00}, {0xA1,0xC2},
    {0xA2,0x58}, {0xA1,0xD3}, {0x32,0x00}, {0x33,0x00},
    {0xA1,0xA6}, {0xA3,0x67}, {0xA1,0x50}, {0xA1,0x4D},
    {0x31,0x00}, {0x6F,0x00}, {0x3F,0x00}, {0x88,0x59},
    {0x88,0x57}, {0x41,0x00}, {0x41,0x00}, {0x41,0x00},
    {0x41,0x00}, {0x41,0x00}, {0x43,0x00}, {0x88,0x5D},
    {0x88,0x5B}, {0x88,0x66}, {0x45,0x00}, {0x49,0x00},
    {0x49,0x00}, {0x49,0x00}, {0x49,0x00}, {0x44,0x00},
    {0x4E,0x00}, {0x88,0x61}, {0x88,0x5F}, {0x4F,0x00},
    {0x4F,0x00}, {0x4F,0x00}, {0xA1,0xD1}, {0x4F,0x00},
    {0x55,0x00}, {0x55,0x00}, {0x55,0x00}, {0x55,0x00},
    {0x59,0x00}, {0x54,0x00}, {0x73,0x00}, {0x88,0x6A},
    {0x88,0x68}, {0x61,0x00}, {0x61,0x00}, {0x61,0x00},
    {0x61,0x00}, {0x61,0x00}, {0x63,0x00}, {0x88,0x6F},
    {0x88,0x6D}, {0x88,0xA7}, {0x65,0x00}, {0x88,0x73},
    {0x88,0x71}, {0x69,0x00}, {0x69,0x00}, {0x65,0x00},
    {0x6E,0x00}, {0x88,0x77}, {0x88,0x75}, {0x6F,0x00},
    {0x6F,0x00}, {0x6F,0x00}, {0xA1,0xD2}, {0xC8,0xFB},
    {0x88,0x7B}, {0x88,0x79}, {0x75,0x00}, {0x88,0xA2},
    {0x79,0x00}, {0x74,0x00}, {0x79,0x00}, {0x88,0x56},
    {0x88,0x67}, {0x88,0x5A}, {0x88,0x6C}, {0x88,0x5C},
    {0x88,0x6E}, {0x88,0x70}, {0xC8,0xFC}, {0x88,0x5E},
    {0x88,0x74}, {0xC8,0xFA}, {0x88,0x78}, {0x88,0x58},
    {0x88,0x69}, {0x88,0x72}, {0x88,0x60}, {0x88,0x76},
    {0x88,0x7A}, {0x88,0x7C}, {0x88,0x7D}, {0x88,0x7E},
    {0x88,0xA1}, {0xC8,0xF6}, {0x88,0x6B}, {0xC8,0xF8},
    {0xC8,0xF7}, {0x88,0xA8}, {0xC8,0xFE}, {0xC8,0xF9},
    {0xC8,0xF5}, {0xC8,0xFD}, {0xC6,0xD9}, {0xA3,0xBE},
    {0xA3,0xBC}, {0xA3,0xBD}, {0xA3,0xBF}, {0xA1,0xC5},
    {0xA3,0xBB}, {0xA1,0xC2}, {0xA3,0x44}, {0xA3,0x45},
    {0xA3,0x46}, {0xA3,0x47}, {0xA3,0x48}, {0xA3,0x49},
    {0xA3,0x4A}, {0xA3,0x4B}, {0xA3,0x4C}, {0xA3,0x4D},
    {0xA3,0x4E}, {0xA3,0x4F}, {0xA3,0x50}, {0xA3,0x51},
    {0xA3,0x52}, {0xA3,0x53}, {0xA3,0x54}, {0xA3,0x55},
    {0xA3,0x56}, {0xA3,0x57}, {0xA3,0x58}, {0xA3,0x59},
    {0xA3,0x5A}, {0xA3,0x5B}, {0xA3,0x5C}, {0xA3,0x5D},
    {0xA3,0x5E}, {0xA3,0x5F}, {0xA3,0x60}, {0xA3,0x61},
    {0xA3,0x62}, {0xA3,0x63}, {0xA3,0x64}, {0xA3,0x65},
    {0xA3,0x66}, {0xA3,0x67}, {0xA3,0x68}, {0xA3,0x69},
    {0xA3,0x6A}, {0xA3,0x6B}, {0xA3,0x6C}, {0xA3,0x6D},
    {0xA3,0x6E}, {0xA3,0x6F}, {0xA3,0x70}, {0xA3,0x71},
    {0xA3,0x72}, {0xA3,0x73}, {0xC7,0xF9}, {0xC7,0xF3},
    {0xC7,0xF4}, {0xC7,0xF5}, {0xC7,0xF6}, {0xC7,0xF7},
    {0xC7,0xF8}, {0xC7,0xFA}, {0xC7,0xFB}, {0xC7,0xFC},
    {0xC7,0xFD}, {0xC7,0xFE}, {0xC8,0x40}, {0xC8,0x41},
    {0xC8,0x42}, {0xC8,0x43}, {0xC8,0x44}, {0xC8,0x45},
    {0xC8,0x46}, {0xC8,0x47}, {0xC8,0x48}, {0xC8,0x49},
    {0xC8,0x4A}, {0xC8,0x4B}, {0xC8,0x4C}, {0xC8,0x4D},
    {0xC8,0x4E}, {0xC8,0x4F}, {0xC8,0x50}, {0xC8,0x51},
    {0xC8,0x52}, {0xC8,0x53}, {0xC8,0x54}, {0xC8,0x55},
    {0xC8,0x56}, {0xC8,0x57}, {0xC8,0x58}, {0xC8,0x59},
    {0xC8,0x5A}, {0xC8,0x5C}, {0xC8,0x5D}, {0xC8,0x5E},
    {0xC8,0x5F}, {0xC8,0x60}, {0xC8,0x61}, {0xC8,0x62},
    {0xC8,0x63}, {0xC8,0x64}, {0xC8,0x65}, {0xC8,0x66},
    {0xC8,0x67}, {0xC8,0x68}, {0xC8,0x69}, {0xC8,0x6A},
    {0xC8,0x6B}, {0xC8,0x6C}, {0xC8,0x6D}, {0xC8,0x6E},
    {0xC8,0x6F}, {0xC8,0x70}, {0xC8,0x71}, {0xC8,0x72},
    {0xC8,0x73}, {0xC8,0x74}, {0xC8,0x75}, {0xC8,0x5B},
    {0x88,0x63}, {0x88,0xA4}, {0x88,0x65}, {0x88,0xA6},
    {0xA1,0x56}, {0xA1,0x58}, {0xA2,0x77}, {0xA1,0xFC},
    {0xA1,0xA5}, {0xA1,0xA6}, {0xA1,0xA7}, {0xA1,0xA8},
    {0xA1,0x45}, {0xA3,0xBB}, {0xA1,0x4C}, {0xA1,0x4B},
    {0xA1,0x45}, {0xA1,0xAC}, {0xA1,0xB2}, {0xA1,0xAB},
    {0xA1,0xB0}, {0xA1,0xC3}, {0xA3,0xE1}, {0xA2,0x4A},
    {0xA1,0xC1}, {0xA2,0x4B}, {0xC8,0xD2}, {0xC8,0xD3},
    {0xA2,0xB9}, {0xA2,0xBA}, {0xA2,0xBB}, {0xA2,0xBC},
    {0xA2,0xBD}, {0xA2,0xBE}, {0xA2,0xBF}, {0xA2,0xC0},
    {0xA2,0xC1}, {0xA2,0xC2}, {0xC6,0xB5}, {0xC6,0xB6},
    {0xC6,0xB7}, {0xC6,0xB8}, {0xC6,0xB9}, {0xC6,0xBA},
    {0xC6,0xBB}, {0xC6,0xBC}, {0xC6,0xBD}, {0xC6,0xBE},
    {0xA1,0xF6}, {0xA1,0xF4}, {0xA1,0xF7}, {0xA1,0xF5},
    {0xA1,0xF8}, {0xA1,0xF9}, {0xA1,0xFB}, {0xA1,0xFA},
    {0xC8,0x77}, {0xC8,0x78}, {0xC8,0x76}, {0xA2,0x41},
    {0xA2,0x42}, {0xA2,0x58}, {0xA1,0xD4}, {0xA1,0xDB},
    {0xA1,0xE8}, {0xA1,0xE7}, {0xA1,0xFD}, {0xA1,0xFC},
    {0xA1,0xE4}, {0xA1,0xE5}, {0xA1,0xEC}, {0xA1,0xED},
    {0xA1,0xEF}, {0xA1,0xEE}, {0xA1,0xDC}, {0xA1,0xDA},
    {0xA1,0xDD}, {0xA1,0xDD}, {0xA1,0xD8}, {0xA1,0xD9},
    {0xA1,0xF2}, {0xA1,0xF3}, {0xA1,0xE6}, {0xA1,0xE9},
    {0xA1,0x5B}, {0xC6,0xA1}, {0xC6,0xA2}, {0xC6,0xA3},
    {0xC6,0xA4}, {0xC6,0xA5}, {0xC6,0xA6}, {0xC6,0xA7},
    {0xC6,0xA8}, {0xC6,0xA9}, {0xC6,0xAA}, {0xC6,0xAB},
    {0xC6,0xAC}, {0xC6,0xAD}, {0xC6,0xAE}, {0xC6,0xAF},
    {0xC6,0xB0}, {0xC6,0xB1}, {0xC6,0xB2}, {0xC6,0xB3},
    {0xC6,0xB4}, {0xA2,0x77}, {0xA2,0x78}, {0xA2,0x7A},
    {0xA2,0x7B}, {0xA2,0x7C}, {0xA2,0x7D}, {0xA2,0x75},
    {0xA2,0x74}, {0xA2,0x73}, {0xA2,0x72}, {0xA2,0x71},
    {0xF9,0xF9}, {0xF9,0xF8}, {0xF9,0xE6}, {0xF9,0xEF},
    {0xF9,0xDD}, {0xF9,0xE8}, {0xF9,0xF1}, {0xF9,0xDF},
    {0xF9,0xEC}, {0xF9,0xF5}, {0xF9,0xE3}, {0xF9,0xEE},
    {0xF9,0xF7}, {0xF9,0xE5}, {0xF9,0xE9}, {0xF9,0xF2},
    {0xF9,0xE0}, {0xF9,0xEB}, {0xF9,0xF4}, {0xF9,0xE2},
    {0xF9,0xE7}, {0xF9,0xF0}, {0xF9,0xDE}, {0xF9,0xED},
    {0xF9,0xF6}, {0xF9,0xE4}, {0xF9,0xEA}, {0xF9,0xF3},
    {0xF9,0xE1}, {0xF9,0xFA}, {0xF9,0xFB}, {0xF9,0xFD},
    {0xF9,0xFC}, {0xA2,0xAC}, {0xA2,0xAD}, {0xA2,0xAE},
    {0xA1,0x5A}, {0xA2,0x62}, {0xA2,0x63}, {0xA2,0x64},
    {0xA2,0x65}, {0xA2,0x66}, {0xA2,0x67}, {0xA2,0x68},
    {0xA2,0x69}, {0xA2,0x70}, {0xA2,0x6F}, {0xA2,0x6E},
    {0xA2,0x6D}, {0xA2,0x6C}, {0xA2,0x6B}, {0xA2,0x6A},
    {0xF9,0xFE}, {0xA2,0x76}, {0xA2,0x79}, {0xA1,0xBD},
    {0xA1,0xBC}, {0xA1,0xB6}, {0xA1,0xB5}, {0xA1,0xBF},
    {0xA1,0xBE}, {0xA1,0xBB}, {0xA1,0xBA}, {0xA1,0xB3},
    {0xA1,0xB7}, {0xA1,0xB4}, {0xA2,0xA8}, {0xA2,0xA9},
    {0xA2,0xAB}, {0xA2,0xAA}, {0xA1,0xB9}, {0xA1,0xB8},
    {0xA1,0xF3}, {0xA1,0xF0}, {0xA1,0xF2}, {0xA1,0xF1},
    {0xC6,0xE6}, {0xC8,0xD6}, {0xC8,0xD7}, {0xC8,0xD8},
    {0xC8,0xD9}, {0xC8,0xDA}, {0xC8,0xDB}, {0xC8,0xDC},
    {0xC8,0xDD}, {0xC8,0xDE}, {0xC8,0xDF}, {0xC8,0xE0},
    {0xC8,0xE1}, {0xC8,0xE2}, {0xC8,0xE3}, {0xC8,0xE4},
    {0xC8,0xE5}, {0xC8,0xE6}, {0xC8,0xE7}, {0xC8,0xE8},
    {0xC8,0xE9}, {0xC8,0xEA}, {0xC8,0xEB}, {0xC8,0xEC},
    {0xC8,0xED}, {0xC8,0xEE}, {0xC8,0xEF}, {0xC8,0xF0},
    {0xC8,0xF1}, {0xC6,0xCD}, {0xA1,0x40}, {0xA1,0x42},
    {0xA1,0x43}, {0xA1,0xB2}, {0xC6,0xE0}, {0xC6,0xE1},
    {0xC6,0xE2}, {0xA1,0x71}, {0xA1,0x72}, {0xA1,0x6D},
    {0xA1,0x6E}, {0xA1,0x75}, {0xA1,0x76}, {0xA1,0x79},
    {0xA1,0x7A}, {0xA1,0x69}, {0xA1,0x6A}, {0xA2,0x45},
    {0xA1,0x65}, {0xA1,0x66}, {0xA1,0xE3}, {0xA1,0xA9},
    {0xA1,0xAA}, {0xA2,0xC3}, {0xA2,0xC4}, {0xA2,0xC5},
    {0xA2,0xC6}, {0xA2,0xC7}, {0xA2,0xC8}, {0xA2,0xC9},
    {0xA2,0xCA}, {0xA2,0xCB}, {0xA1,0xCA}, {0xC6,0xE7},
    {0xC6,0xE8}, {0xC6,0xE9}, {0xC6,0xEA}, {0xC6,0xEB},
    {0xC6,0xEC}, {0xC6,0xED}, {0xC6,0xEE}, {0xC6,0xEF},
    {0xC6,0xF0}, {0xC6,0xF1}, {0xC6,0xF2}, {0xC6,0xF3},
    {0xC6,0xF4}, {0xC6,0xF5}, {0xC6,0xF6}, {0xC6,0xF7},
    {0xC6,0xF8}, {0xC6,0xF9}, {0xC6,0xFA}, {0xC6,0xFB},
    {0xC6,0xFC}, {0xC6,0xFD}, {0xC6,0xFE}, {0xC7,0x40},
    {0xC7,0x41}, {0xC7,0x42}, {0xC7,0x43}, {0xC7,0x44},
    {0xC7,0x45}, {0xC7,0x46}, {0xC7,0x47}, {0xC7,0x48},
    {0xC7,0x49}, {0xC7,0x4A}, {0xC7,0x4B}, {0xC7,0x4C},
    {0xC7,0x4D}, {0xC7,0x4E}, {0xC7,0x4F}, {0xC7,0x50},
    {0xC7,0x51}, {0xC7,0x52}, {0xC7,0x53}, {0xC7,0x54},
    {0xC7,0x55}, {0xC7,0x56}, {0xC7,0x57}, {0xC7,0x58},
    {0xC7,0x59}, {0xC7,0x5A}, {0xC7,0x5B}, {0xC7,0x5C},
    {0xC7,0x5D}, {0xC7,0x5E}, {0xC7,0x5F}, {0xC7,0x60},
    {0xC7,0x61}, {0xC7,0x62}, {0xC7,0x63}, {0xC7,0x64},
    {0xC7,0x65}, {0xC7,0x66}, {0xC7,0x67}, {0xC7,0x68},
    {0xC7,0x69}, {0xC7,0x6A}, {0xC7,0x6B}, {0xC7,0x6C},
    {0xC7,0x6D}, {0xC7,0x6E}, {0xC7,0x6F}, {0xC7,0x70},
    {0xC7,0x71}, {0xC7,0x72}, {0xC7,0x73}, {0xC7,0x74},
    {0xC7,0x75}, {0xC7,0x76}, {0xC7,0x77}, {0xC7,0x78},
    {0xC7,0x79}, {0xC7,0x7A}, {0xC8,0xD4}, {0xC8,0xD5},
    {0xC6,0xDC}, {0xC6,0xDD}, {0xC7,0x7B}, {0xC7,0x7C},
    {0xC7,0x7D}, {0xC7,0x7E}, {0xC7,0xA1}, {0xC7,0xA2},
    {0xC7,0xA3}, {0xC7,0xA4}, {0xC7,0xA5}, {0xC7,0xA6},
    {0xC7,0xA7}, {0xC7,0xA8}, {0xC7,0xA9}, {0xC7,0xAA},
    {0xC7,0xAB}, {0xC7,0xAC}, {0xC7,0xAD}, {0xC7,0xAE},
    {0xC7,0xAF}, {0xC7,0xB0}, {0xC7,0xB1}, {0xC7,0xB2},
    {0xC7,0xB3}, {0xC7,0xB4}, {0xC7,0xB5}, {0xC7,0xB6},
    {0xC7,0xB7}, {0xC7,0xB8}, {0xC7,0xB9}, {0xC7,0xBA},
    {0xC7,0xBB}, {0xC7,0xBC}, {0xC7,0xBD}, {0xC7,0xBE},
    {0xC7,0xBF}, {0xC7,0xC0}, {0xC7,0xC1}, {0xC7,0xC2},
    {0xC7,0xC3}, {0xC7,0xC4}, {0xC7,0xC5}, {0xC7,0xC6},
    {0xC7,0xC7}, {0xC7,0xC8}, {0xC7,0xC9}, {0xC7,0xCA},
    {0xC7,0xCB}, {0xC7,0xCC}, {0xC7,0xCD}, {0xC7,0xCE},
    {0xC7,0xCF}, {0xC7,0xD0}, {0xC7,0xD1}, {0xC7,0xD2},
    {0xC7,0xD3}, {0xC7,0xD4}, {0xC7,0xD5}, {0xC7,0xD6},
    {0xC7,0xD7}, {0xC7,0xD8}, {0xC7,0xD9}, {0xC7,0xDA},
    {0xC7,0xDB}, {0xC7,0xDC}, {0xC7,0xDD}, {0xC7,0xDE},
    {0xC7,0xDF}, {0xC7,0xE0}, {0xC7,0xE1}, {0xC7,0xE2},
    {0xC7,0xE3}, {0xC7,0xE4}, {0xC7,0xE5}, {0xC7,0xE6},
    {0xC7,0xE7}, {0xC7,0xE8}, {0xC7,0xE9}, {0xC7,0xEA},
    {0xC7,0xEB}, {0xC7,0xEC}, {0xC7,0xED}, {0xC7,0xEE},
    {0xC7,0xEF}, {0xC7,0xF0}, {0xC7,0xF1}, {0xC7,0xF2},
    {0xC6,0xE3}, {0xC6,0xDA}, {0xC6,0xDB}, {0xA3,0x74},
    {0xA3,0x75}, {0xA3,0x76}, {0xA3,0x77}, {0xA3,0x78},
    {0xA3,0x79}, {0xA3,0x7A}, {0xA3,0x7B}, {0xA3,0x7C},
    {0xA3,0x7D}, {0xA3,0x7E}, {0xA3,0xA1}, {0xA3,0xA2},
    {0xA3,0xA3}, {0xA3,0xA4}, {0xA3,0xA5}, {0xA3,0xA6},
    {0xA3,0xA7}, {0xA3,0xA8}, {0xA3,0xA9}, {0xA3,0xAA},
    {0xA3,0xAB}, {0xA3,0xAC}, {0xA3,0xAD}, {0xA3,0xAE},
    {0xA3,0xAF}, {0xA3,0xB0}, {0xA3,0xB1}, {0xA3,0xB2},
    {0xA3,0xB3}, {0xA3,0xB4}, {0xA3,0xB5}, {0xA3,0xB6},
    {0xA3,0xB7}, {0xA3,0xB8}, {0xA3,0xB9}, {0xA3,0xBA},
    {0xA4,0x40}, {0xA4,0x47}, {0xA4,0x54}, {0xA5,0x7C},
    {0xA4,0x57}, {0xA4,0xA4}, {0xA4,0x55}, {0xA5,0xD2},
    {0xA4,0x41}, {0xA4,0xFE}, {0xA4,0x42}, {0xA4,0xD1},
    {0xA6,0x61}, {0xA4,0x48}, {0xA4,0x40}, {0xA4,0x47},
    {0xA4,0x54}, {0xA5,0x7C}, {0xA4,0xAD}, {0xA4,0xBB},
    {0xA4,0x43}, {0xA4,0x4B}, {0xA4,0x45}, {0xA4,0x51},
    {0xA4,0xEB}, {0xA4,0xF5}, {0xA4,0xF4}, {0xA4,0xEC},
    {0xAA,0xF7}, {0xA4,0x67}, {0xA4,0xE9}, {0xC8,0xD1},
    {0xA6,0xB3}, {0xAA,0xC0}, {0xA6,0x57}, {0xAF,0x53},
    {0xB0,0x5D}, {0xAF,0xAC}, {0xB3,0xD2}, {0xA5,0x4E},
    {0xA9,0x49}, {0xBE,0xC7}, {0xBA,0xCA}, {0xA5,0xF8},
    {0xB8,0xEA}, {0xA8,0xF3}, {0xB2,0xBD}, {0xA5,0xF0},
    {0xA6,0xDB}, {0xA6,0xDC}, {0xA4,0x40}, {0xA4,0x47},
    {0xA4,0x54}, {0xA5,0x7C}, {0xA4,0xAD}, {0xA4,0xBB},
    {0xA4,0x43}, {0xA4,0x4B}, {0xA4,0x45}, {0xA4,0x51},
    {0xA4,0xEB}, {0xA4,0xF5}, {0xA4,0xF4}, {0xA4,0xEC},
    {0xAA,0xF7}, {0xA4,0x67}, {0xA4,0xE9}, {0xAE,0xE8},
    {0xA6,0xB3}, {0xAA,0xC0}, {0xA6,0x57}, {0xAF,0x53},
    {0xB0,0x5D}, {0xAF,0xAC}, {0xB3,0xD2}, {0xAF,0xB5},
    {0xA8,0x6B}, {0xA4,0x6B}, {0xBE,0x41}, {0xC0,0x75},
    {0xA6,0x4C}, {0xAA,0x60}, {0xB6,0xB5}, {0xA5,0xF0},
    {0xBC,0x67}, {0xA1,0xC0}, {0xA4,0x57}, {0xA4,0xA4},
    {0xA4,0x55}, {0xA5,0xAA}, {0xA5,0x6B}, {0xC2,0xE5},
    {0xA9,0x76}, {0xBE,0xC7}, {0xBA,0xCA}, {0xA5,0xF8},
    {0xB8,0xEA}, {0xA8,0xF3}, {0xA9,0x5D}, {0xA2,0x55},
    {0xA2,0x56}, {0xA2,0x50}, {0xA2,0x51}, {0xA2,0x52},
    {0xA2,0x54}, {0xA2,0x57}, {0xA2,0x53}, {0xA1,0xEB},
    {0xA1,0xEA}, {0xA2,0x4F}, {0x92,0x77}, {0x96,0xDF},
    {0x89,0xD5}, {0x93,0xCD}, {0x9B,0xDF}, {0xFA,0x68},
    {0x89,0xDA}, {0x8F,0x59}, {0x89,0xDB}, {0x8F,0x5D},
    {0x89,0xDC}, {0x96,0xF7}, {0x8A,0xDA}, {0x8B,0xDC},
    {0x97,0xDB}, {0x9E,0x53}, {0x9D,0xAA}, {0x9B,0xEA},
    {0x8A,0x6E}, {0x8B,0xC8}, {0x89,0xE8}, {0x89,0xEA},
    {0x8C,0x4B}, {0xFB,0x70}, {0x89,0xED}, {0x94,0xDD},
    {0x89,0xEE}, {0x9E,0xB4}, {0x8A,0xD3}, {0x92,0xDB},
    {0x94,0xDB}, {0x89,0xF9}, {0xFB,0x7A}, {0x89,0xFB},
    {0x9E,0xFC}, {0x89,0xFC}, {0x89,0xBF}, {0x89,0xFE},
    {0x89,0xE6}, {0x9D,0x46}, {0x9D,0xEE}, {0xA0,0x7E},
    {0xA0,0x68}, {0x98,0xE9}, {0x8B,0x68}, {0x8D,0xFD},
    {0x8B,0xBE}, {0x9F,0xD9}, {0x8A,0xEB}, {0x9F,0xD7},
    {0x8B,0x6A}, {0x9C,0x5C}, {0x8B,0xB1}, {0xFB,0x5E},
    {0x9D,0xF3}, {0xA0,0xD0}, {0xFC,0x66}, {0x92,0xE9},
    {0x9A,0xEC}, {0x8F,0xAB}, {0xFA,0x48}, {0x8E,0x45},
    {0x9C,0x6F}, {0x9E,0xDE}, {0x89,0xEF}, {0x96,0xE9},
    {0x9E,0xBB}, {0x94,0xDE}, {0x9E,0xB8}, {0x97,0xBA},
    {0xFB,0x65}, {0x95,0xD6}, {0x9C,0xBB}, {0x97,0xDA},
    {0x8F,0x45}, {0xFB,0x7D}, {0x91,0x58}, {0xFE,0x64},
    {0x98,0x56}, {0x9B,0x4D}, {0x93,0x5B}, {0x95,0xC7},
    {0x97,0xE7}, {0x93,0x59}, {0x91,0xF5}, {0x97,0xB8},
    {0xFD,0xA2}, {0xFB,0xB6}, {0x92,0xFA}, {0x93,0x57},
    {0x8B,0xA6}, {0xFB,0xB9}, {0x97,0xB0}, {0xFD,0xC4},
    {0x9C,0xA1}, {0x91,0xF2}, {0x91,0xF9}, {0x8F,0xF1},
    {0x97,0x45}, {0x98,0x53}, {0xFE,0x78}, {0xFB,0xC1},
    {0x92,0x51}, {0x9D,0xAD}, {0xFD,0x6C}, {0xFA,0x6B},
    {0x9B,0xC2}, {0x9A,0x7B}, {0x8B,0x60}, {0x93,0x4B},
    {0x9A,0xBD}, {0x91,0xB7}, {0x95,0xB4}, {0xFE,0xC5},
    {0x9E,0xF0}, {0x8D,0x64}, {0x92,0x69}, {0x8D,0x67},
    {0xFB,0xEA}, {0xFB,0xEF}, {0x8D,0x68}, {0x93,0xEB},
    {0xFC,0x42}, {0x91,0x66}, {0xFA,0xCD}, {0x93,0xDD},
    {0x8B,0xCC}, {0x8D,0x6D}, {0x8D,0x6E}, {0x96,0xA8},
    {0xFC,0xA6}, {0x8D,0x6F}, {0x8D,0x70}, {0xFC,0x64},
    {0x90,0x60}, {0x8D,0x74}, {0x97,0xC3}, {0x8A,0xD0},
    {0x92,0x74}, {0x9B,0xBE}, {0x9C,0xC8}, {0x9C,0xBA},
    {0x8D,0x78}, {0x9E,0xB9}, {0x95,0x5A}, {0x91,0xB4},
    {0x8A,0x48}, {0x8D,0x7D}, {0x8A,0x7D}, {0x8A,0xC2},
    {0xFD,0x4A}, {0x8D,0xA1}, {0x8A,0xD1}, {0xFC,0xB4},
    {0x8B,0x47}, {0x93,0xA4}, {0x9E,0xDA}, {0x8A,0x51},
    {0x8D,0xA6}, {0x9E,0xC5}, {0xFC,0xC4}, {0xA0,0x78},
    {0x94,0xB5}, {0xFC,0xC2}, {0x8A,0x6B}, {0x8D,0xAB},
    {0xFA,0xE8}, {0x8D,0xAD}, {0xFC,0x49}, {0x93,0xC1},
    {0x90,0x6F}, {0x8D,0xB0}, {0x94,0x7E}, {0x90,0xFA},
    {0x94,0x79}, {0x8D,0xB2}, {0xFC,0xEE}, {0x99,0x7B},
    {0x8D,0xB4}, {0x8D,0xB7}, {0x91,0xB3}, {0x8D,0xBB},
    {0x8D,0xBA}, {0x8D,0xBC}, {0x90,0x44}, {0xFD,0x4C},
    {0x93,0xE4}, {0x93,0xE0}, {0xFD,0x53}, {0x8D,0xC3},
    {0x9B,0xB8}, {0xFB,0xF0}, {0x93,0xE9}, {0x93,0xF6},
    {0x8D,0xC5}, {0x8D,0xCA}, {0x8D,0xCC}, {0xFD,0x5D},
    {0x93,0xB5}, {0xFD,0x61}, {0x9C,0xF8}, {0x92,0x52},
    {0xA0,0xE8}, {0x9C,0xA5}, {0x8C,0x56}, {0x8D,0xD6},
    {0x97,0xC0}, {0xA0,0xDE}, {0x97,0xD2}, {0xFA,0xA5},
    {0xFD,0xA3}, {0x8D,0xDB}, {0x8E,0xAF}, {0x91,0xB5},
    {0xFD,0x49}, {0xFD,0xD1}, {0x8D,0xEB}, {0x97,0xC6},
    {0xFD,0xCE}, {0x90,0xFC}, {0xFC,0x59}, {0x96,0xD6},
    {0x97,0xC5}, {0x8D,0xEF}, {0x97,0xD7}, {0x8D,0xF0},
    {0x96,0xA6}, {0xFB,0xBF}, {0x8D,0xF3}, {0x94,0x49},
    {0x8D,0xF5}, {0x98,0x72}, {0x8E,0x6B}, {0xFA,0xFD},
    {0x8F,0x50}, {0x9D,0xCC}, {0xFC,0x65}, {0x8C,0x44},
    {0x99,0x6E}, {0x94,0xA1}, {0x8F,0x63}, {0xA0,0xDA},
    {0x92,0x53}, {0xFD,0xE9}, {0x9D,0xB5}, {0x98,0x79},
    {0x9D,0x5D}, {0x8D,0x63}, {0x96,0x69}, {0x9F,0x70},
    {0xFC,0x6A}, {0x8A,0xC7}, {0x89,0xD7}, {0xFE,0x4D},
    {0x9E,0xDD}, {0xFE,0xFB}, {0x98,0xBC}, {0xFA,0xCC},
    {0x95,0xB0}, {0x94,0x64}, {0x93,0x6F}, {0x94,0xB9},
    {0x95,0xEC}, {0x91,0xEE}, {0x98,0xC3}, {0x95,0xF6},
    {0x8F,0xFD}, {0x98,0xC5}, {0x97,0x66}, {0xFE,0x6E},
    {0x97,0xDD}, {0x8C,0xAA}, {0x92,0xD2}, {0x97,0x61},
    {0x98,0xCB}, {0x95,0xF0}, {0x97,0x5D}, {0x91,0xE3},
    {0x98,0xCC}, {0x94,0x69}, {0x98,0xCD}, {0x98,0xCE},
    {0x95,0xFC}, {0x94,0xA3}, {0x96,0x62}, {0xFE,0xB6},
    {0x94,0x63}, {0x98,0xD0}, {0x98,0xD1}, {0x94,0x75},
    {0xFA,0xE0}, {0x94,0x72}, {0x98,0xD6}, {0x8A,0xF0},
    {0x98,0xD9}, {0x98,0xDB}, {0x98,0xDD}, {0x98,0xA8},
    {0x8A,0x6D}, {0x8A,0xFB}, {0x8A,0xAE}, {0xFB,0xC9},
    {0x8C,0x5D}, {0x98,0xE4}, {0x98,0xE6}, {0x98,0xE8},
    {0x8A,0x4D}, {0x92,0x57}, {0x95,0xDF}, {0xA0,0xAC},
    {0x98,0xEB}, {0x98,0xEC}, {0x8C,0xC3}, {0x98,0xF4},
    {0x8A,0xB8}, {0x9E,0xE7}, {0x94,0xBC}, {0xFC,0xD1},
    {0x9C,0xC6}, {0x9E,0x7E}, {0x98,0xFE}, {0xFD,0xE8},
    {0x99,0x40}, {0x94,0xC9}, {0x94,0xD3}, {0x99,0x46},
    {0x90,0xC0}, {0x94,0xD1}, {0x95,0x73}, {0x93,0xC2},
    {0x99,0x48}, {0x99,0x4B}, {0x8E,0x55}, {0x99,0x4E},
    {0x8E,0xFE}, {0x8E,0x59}, {0x94,0xEC}, {0x94,0xEF},
    {0x8C,0x60}, {0x8F,0x74}, {0x99,0x55}, {0x95,0x44},
    {0x8C,0xCB}, {0x99,0x56}, {0x99,0x59}, {0x99,0x5B},
    {0x8C,0xC4}, {0xFA,0x45}, {0x90,0xB7}, {0x97,0x43},
    {0x95,0xCD}, {0x97,0xC9}, {0xFD,0x50}, {0x8E,0xB9},
    {0x95,0xC6}, {0x99,0x67}, {0x8A,0xB9}, {0x8D,0xFC},
    {0x8A,0x76}, {0x9D,0x51}, {0x99,0x73}, {0x9D,0x4F},
    {0x99,0x7A}, {0x95,0x64}, {0x99,0xA1}, {0x99,0xA5},
    {0x99,0xA7}, {0x8E,0xED}, {0x99,0xAD}, {0x94,0x6E},
    {0x8F,0x70}, {0xFA,0xD0}, {0x99,0xB3}, {0xA0,0x53},
    {0x96,0x5C}, {0xFD,0x7A}, {0x97,0xFE}, {0x92,0xBD},
    {0x97,0xFD}, {0x8F,0x64}, {0xFC,0xF7}, {0x95,0x62},
    {0x97,0xCD}, {0x9E,0x64}, {0x92,0x4C}, {0x8E,0xC9},
    {0x99,0xBC}, {0x9D,0xA5}, {0x8F,0x54}, {0x8F,0x7C},
    {0x8E,0xA2}, {0x8F,0x7A}, {0x97,0xAE}, {0x96,0xC8},
    {0x99,0xC3}, {0x90,0xD6}, {0x9C,0xBE}, {0x8F,0x76},
    {0x94,0x70}, {0xFB,0x4B}, {0xFD,0xCA}, {0x8E,0xC7},
    {0xA0,0xF9}, {0x8F,0xA9}, {0x99,0xC7}, {0x90,0xD7},
    {0x9E,0xDF}, {0x99,0xCE}, {0x8F,0xBA}, {0x8F,0xEB},
    {0x99,0xCF}, {0x8F,0xC2}, {0x92,0xC9}, {0x97,0xDC},
    {0x95,0xB3}, {0x9C,0x79}, {0x95,0xB2}, {0x8F,0xDB},
    {0x9B,0xE3}, {0x9E,0x7A}, {0x9B,0xEE}, {0x99,0xDE},
    {0xFA,0xFA}, {0x9E,0xE5}, {0x8A,0x52}, {0x99,0xE1},
    {0x8A,0x67}, {0x8B,0xB5}, {0x8A,0xAC}, {0x99,0xE9},
    {0xFB,0xCA}, {0x97,0xDE}, {0x95,0xD1}, {0x99,0xF5},
    {0xFC,0x4A}, {0x9B,0xA9}, {0xFB,0xDC}, {0xFE,0x56},
    {0x9E,0xA4}, {0x9D,0x49}, {0x95,0xDB}, {0x89,0xC5},
    {0x99,0xF8}, {0x96,0x64}, {0x90,0x55}, {0x96,0xD4},
    {0x97,0x7C}, {0x96,0x4D}, {0x97,0xE1}, {0x9A,0x48},
    {0x9A,0x49}, {0xFE,0x7D}, {0x90,0xAA}, {0x9A,0x50},
    {0x93,0x47}, {0x8E,0xD8}, {0x90,0xC9}, {0x9A,0x55},
    {0x90,0xBC}, {0x9A,0x58}, {0x8B,0xB8}, {0x90,0xD5},
    {0x96,0x41}, {0x9A,0x5A}, {0x9A,0x5C}, {0x97,0xC2},
    {0x8A,0xBB}, {0x9B,0xAA}, {0x90,0xF5}, {0x9A,0x60},
    {0x91,0x45}, {0x8C,0x58}, {0x9A,0x63}, {0x8C,0x49},
    {0x8B,0xB6}, {0xFC,0xCF}, {0x96,0x6B}, {0x9A,0x6E},
    {0x91,0x4F}, {0x97,0x46}, {0xA0,0xE6}, {0x92,0xD7},
    {0x96,0x75}, {0x93,0xD4}, {0x91,0xBB}, {0x96,0x79},
    {0x9A,0x70}, {0x96,0x78}, {0x91,0xCD}, {0x9C,0x4A},
    {0xA0,0x6F}, {0xA0,0x6A}, {0x91,0x5F}, {0x9F,0xA5},
    {0x89,0xBA}, {0x9E,0xCD}, {0x9A,0x79}, {0x9D,0xCE},
    {0x8C,0xD2}, {0x9D,0x73}, {0x96,0xB9}, {0x96,0xBC},
    {0x9C,0xD1}, {0x89,0xB7}, {0x9E,0xEE}, {0xFB,0x43},
    {0x9E,0xC9}, {0xFB,0xD3}, {0x91,0xAE}, {0x9D,0x78},
    {0x9D,0x7B}, {0xA4,0x40}, {0xA4,0x42}, {0xA4,0x43},
    {0x9E,0xB3}, {0xC9,0x45}, {0xA4,0x56}, {0xA4,0x54},
    {0xA4,0x57}, {0xA4,0x55}, {0xC9,0x46}, {0xA4,0xA3},
    {0xC9,0x4F}, {0xC9,0x4D}, {0xA4,0xA2}, {0xA4,0xA1},
    {0xA5,0x42}, {0xA5,0x41}, {0xA5,0x40}, {0xA5,0x43},
    {0xA4,0xFE}, {0x9E,0xB2}, {0x9D,0xD6}, {0xA5,0xE0},
    {0xA5,0xE1}, {0x99,0x4F}, {0x89,0xCE}, {0xA8,0xC3},
    {0x8B,0xC0}, {0x9F,0xC4}, {0xA4,0x58}, {0x8B,0xD4},
    {0xA4,0xA4}, {0xC9,0x50}, {0x8C,0x72}, {0xA4,0xA5},
    {0xC9,0x63}, {0xA6,0xEA}, {0xCB,0xB1}, {0xC6,0xBF},
    {0x8B,0xF9}, {0xA4,0x59}, {0xA4,0xA6}, {0xA5,0x44},
    {0xC9,0x64}, {0x89,0x46}, {0xC6,0xC0}, {0xC9,0x40},
    {0xA4,0x44}, {0xA4,0x5B}, {0xC9,0x47}, {0xA4,0x5C},
    {0xFA,0xE5}, {0xA4,0xA7}, {0xA5,0x45}, {0xA5,0x47},
    {0xA5,0x46}, {0xA5,0xE2}, {0xA5,0xE3}, {0xA8,0xC4},
    {0xAD,0xBC}, {0xA4,0x41}, {0xC8,0x7B}, {0x8B,0xC6},
    {0xC9,0x41}, {0xA4,0x45}, {0xA4,0x5E}, {0xA4,0x5D},
    {0xA5,0xE4}, {0x9C,0x57}, {0xA8,0xC5}, {0x9A,0xFB},
    {0xB0,0xAE}, {0xD4,0x4B}, {0x89,0xD0}, {0x89,0xCF},
    {0xB6,0xC3}, {0xDC,0xB1}, {0xDC,0xB2}, {0xC6,0xC1},
    {0xA4,0x46}, {0x89,0xD1}, {0xA4,0xA9}, {0x89,0xE2},
    {0xA8,0xC6}, {0xA4,0x47}, {0xC9,0x48}, {0xA4,0x5F},
    {0xA4,0xAA}, {0xA4,0xAC}, {0xC9,0x51}, {0xA4,0xAD},
    {0xA4,0xAB}, {0x92,0x7E}, {0xA5,0xE5}, {0x9D,0xBA},
    {0xA8,0xC7}, {0xA8,0xC8}, {0xAB,0x45}, {0xC6,0xC2},
    {0xA4,0x60}, {0xA4,0xAE}, {0x8C,0x6F}, {0xA5,0xE6},
    {0xA5,0xE8}, {0xA5,0xE7}, {0xA6,0xEB}, {0xA8,0xC9},
    {0xA8,0xCA}, {0xAB,0x46}, {0xAB,0x47}, {0xAD,0xBD},
    {0xDC,0xB3}, {0xFB,0xF8}, {0xF6,0xD6}, {0xA4,0x48},
    {0x8B,0xC7}, {0x92,0x6B}, {0x89,0xD2}, {0xA4,0xB0},
    {0xA4,0xAF}, {0xC9,0x52}, {0xA4,0xB1}, {0xA4,0xB7},
    {0xA4,0xB2}, {0xA4,0xB3}, {0xC9,0x54}, {0xC9,0x53},
    {0xA4,0xB5}, {0xA4,0xB6}, {0xA4,0xB4}, {0x9F,0xCF},
    {0xA5,0x4A}, {0xA5,0x4B}, {0xA5,0x4C}, {0xA5,0x4D},
    {0xA5,0x49}, {0xA5,0x50}, {0xC9,0x6A}, {0xC9,0x66},
    {0xC9,0x69}, {0xA5,0x51}, {0xA5,0x61}, {0xC9,0x68},
    {0xA5,0x4E}, {0xA5,0x4F}, {0xA5,0x48}, {0xC9,0x65},
    {0xC9,0x67}, {0x9D,0xA9}, {0x89,0xD3}, {0x99,0xE2},
    {0xA5,0xF5}, {0xC9,0xB0}, {0xA5,0xF2}, {0xA5,0xF6},
    {0xC9,0xBA}, {0xC9,0xAE}, {0xA5,0xF3}, {0xC9,0xB2},
    {0x92,0x67}, {0xA5,0xF4}, {0xA5,0xF7}, {0xA5,0xE9},
    {0xC9,0xB1}, {0xA5,0xF8}, {0xC9,0xB5}, {0x92,0xA4},
    {0xC9,0xB9}, {0xC9,0xB6}, {0xC9,0xB3}, {0xA5,0xEA},
    {0xA5,0xEC}, {0xA5,0xF9}, {0xA5,0xEE}, {0xC9,0xAB},
    {0xA5,0xF1}, {0xA5,0xEF}, {0xA5,0xF0}, {0xC9,0xBB},
    {0xC9,0xB8}, {0xC9,0xAF}, {0xA5,0xED}, {0x8C,0x73},
    {0xC9,0xAC}, {0xA5,0xEB}, {0x89,0x4E}, {0xC9,0xB4},
    {0xC9,0xB7}, {0x89,0x4F}, {0x92,0x78}, {0xC9,0xAD},
    {0xCA,0x66}, {0xA7,0x42}, {0xA6,0xF4}, {0x91,0xB6},
    {0xCA,0x67}, {0xA6,0xF1}, {0xA7,0x44}, {0x89,0xD4},
    {0xA6,0xF9}, {0x9F,0xD2}, {0xA6,0xF8}, {0xCA,0x5B},
    {0xA6,0xFC}, {0xA6,0xF7}, {0xCA,0x60}, {0xCA,0x68},
    {0xCA,0x64}, {0x92,0xA7}, {0xA6,0xFA}, {0x95,0xA2},
    {0xA6,0xFD}, {0xA6,0xEE}, {0xA7,0x47}, {0xCA,0x5D},
    {0x92,0x6E}, {0xCB,0xBD}, {0xA6,0xEC}, {0xA7,0x43},
    {0xA6,0xED}, {0xA6,0xF5}, {0xA6,0xF6}, {0xCA,0x62},
    {0xCA,0x5E}, {0xA6,0xFB}, {0xA6,0xF3}, {0xCA,0x5A},
    {0xA6,0xEF}, {0xCA,0x65}, {0xA7,0x45}, {0xA7,0x48},
    {0xA6,0xF2}, {0xA7,0x40}, {0xA7,0x46}, {0xA6,0xF0},
    {0xCA,0x63}, {0xA7,0x41}, {0xCA,0x69}, {0xCA,0x5C},
    {0xA6,0xFE}, {0xCA,0x5F}, {0xCA,0x61}, {0xA8,0xD8},
    {0xCB,0xBF}, {0xCB,0xCB}, {0xA8,0xD0}, {0xCB,0xCC},
    {0xA8,0xCB}, {0xA8,0xD5}, {0x96,0xEA}, {0xA8,0xCE},
    {0xCB,0xB9}, {0xA8,0xD6}, {0xCB,0xB8}, {0xCB,0xBC},
    {0xCB,0xC3}, {0xCB,0xC1}, {0xA8,0xDE}, {0xA8,0xD9},
    {0xCB,0xB3}, {0xCB,0xB5}, {0xA8,0xDB}, {0xA8,0xCF},
    {0xCB,0xB6}, {0xCB,0xC2}, {0xCB,0xC9}, {0xA8,0xD4},
    {0xCB,0xBB}, {0xCB,0xB4}, {0xA8,0xD3}, {0xCB,0xB7},
    {0xA8,0xD7}, {0xCB,0xBA}, {0x92,0x6F}, {0xA8,0xD2},
    {0xA8,0xCD}, {0xA8,0xDC}, {0xCB,0xC4}, {0xA8,0xDD},
    {0xCB,0xC8}, {0xCB,0xC6}, {0xCB,0xCA}, {0xA8,0xDA},
    {0xCB,0xBE}, {0xCB,0xB2}, {0xCB,0xC0}, {0xA8,0xD1},
    {0xCB,0xC5}, {0xA8,0xCC}, {0xCB,0xC7}, {0x92,0xA3},
    {0x89,0x50}, {0xFA,0x57}, {0xAB,0x56}, {0xAB,0x4A},
    {0x98,0x66}, {0xCD,0xE0}, {0xCD,0xE8}, {0xAB,0x49},
    {0xAB,0x51}, {0xAB,0x5D}, {0xCD,0xEE}, {0xCD,0xEC},
    {0xCD,0xE7}, {0x89,0xD6}, {0xAB,0x4B}, {0xCD,0xED},
    {0xCD,0xE3}, {0xAB,0x59}, {0xAB,0x50}, {0xAB,0x58},
    {0xCD,0xDE}, {0xCD,0xEA}, {0x98,0xB2}, {0xCD,0xE1},
    {0xAB,0x54}, {0xCD,0xE2}, {0x92,0xAB}, {0xCD,0xDD},
    {0xAB,0x5B}, {0xAB,0x4E}, {0xAB,0x57}, {0xAB,0x4D},
    {0xCD,0xDF}, {0xCD,0xE4}, {0xCD,0xEB}, {0xAB,0x55},
    {0xAB,0x52}, {0xCD,0xE6}, {0xAB,0x5A}, {0xCD,0xE9},
    {0xCD,0xE5}, {0xAB,0x4F}, {0xAB,0x5C}, {0xAB,0x53},
    {0xAB,0x4C}, {0xAB,0x48}, {0x96,0xDE}, {0x92,0xAC},
    {0xCD,0xEF}, {0xAD,0xD7}, {0xAD,0xC1}, {0x8C,0x70},
    {0xAD,0xD1}, {0x9F,0x6E}, {0xAD,0xD6}, {0xD0,0xD0},
    {0xD0,0xCF}, {0xD0,0xD4}, {0xD0,0xD5}, {0xAD,0xC4},
    {0x8E,0xF2}, {0xAD,0xCD}, {0x9F,0x6C}, {0xAD,0xDA},
    {0xAD,0xCE}, {0x89,0xD8}, {0xD0,0xC9}, {0xAD,0xC7},
    {0xD0,0xCA}, {0xFA,0x59}, {0xAD,0xDC}, {0xAD,0xD3},
    {0xAD,0xBE}, {0xAD,0xBF}, {0xD0,0xDD}, {0xB0,0xBF},
    {0xAD,0xCC}, {0xAD,0xCB}, {0xD0,0xCB}, {0xAD,0xCF},
    {0xD4,0x5B}, {0xAD,0xC6}, {0xD0,0xD6}, {0xAD,0xD5},
    {0xAD,0xD4}, {0xAD,0xCA}, {0xD0,0xCE}, {0xD0,0xD7},
    {0xD0,0xC8}, {0xAD,0xC9}, {0xD0,0xD8}, {0xAD,0xD2},
    {0xD0,0xCC}, {0xAD,0xC0}, {0xAD,0xC3}, {0xAD,0xC2},
    {0xD0,0xD9}, {0xAD,0xD0}, {0xAD,0xC5}, {0xAD,0xD9},
    {0xAD,0xDB}, {0xD0,0xD3}, {0xAD,0xD8}, {0x92,0xA8},
    {0xD0,0xDB}, {0xD0,0xCD}, {0xD0,0xDC}, {0xD0,0xD1},
    {0x91,0x63}, {0xD0,0xDA}, {0xD0,0xD2}, {0x8C,0x40},
    {0xAD,0xC8}, {0xD4,0x63}, {0xD4,0x57}, {0xB0,0xB3},
    {0xD4,0x5C}, {0xD4,0x62}, {0xB0,0xB2}, {0xD4,0x55},
    {0xB0,0xB6}, {0xD4,0x59}, {0xD4,0x52}, {0xB0,0xB4},
    {0xD4,0x56}, {0xB0,0xB9}, {0xB0,0xBE}, {0xD4,0x67},
    {0xD4,0x51}, {0xB0,0xBA}, {0x9F,0x73}, {0xD4,0x66},
    {0x92,0xAD}, {0xB0,0xB5}, {0xD4,0x58}, {0xB0,0xB1},
    {0xD4,0x53}, {0xD4,0x4F}, {0xD4,0x5D}, {0xD4,0x50},
    {0xD4,0x4E}, {0xD4,0x5A}, {0xD4,0x60}, {0xD4,0x61},
    {0xB0,0xB7}, {0x9B,0xE9}, {0xD8,0x5B}, {0xD4,0x5E},
    {0xD4,0x4D}, {0xD4,0x5F}, {0x92,0xA9}, {0xB0,0xC1},
    {0xD4,0x64}, {0xB0,0xC0}, {0xD4,0x4C}, {0xD4,0x54},
    {0xD4,0x65}, {0xB0,0xBC}, {0xB0,0xBB}, {0xB0,0xB8},
    {0xB0,0xBD}, {0xB0,0xAF}, {0xB0,0xB0}, {0xB3,0xC8},
    {0x92,0xAA}, {0xD8,0x5E}, {0xD8,0x57}, {0xB3,0xC5},
    {0xD8,0x5F}, {0x89,0xD9}, {0xD8,0x55}, {0xD8,0x58},
    {0xB3,0xC4}, {0xD8,0x59}, {0xFD,0x56}, {0xB3,0xC7},
    {0xD8,0x5D}, {0xD8,0x53}, {0xD8,0x52}, {0xB3,0xC9},
    {0xB3,0xCA}, {0xB3,0xC6}, {0xB3,0xCB}, {0xD8,0x51},
    {0xD8,0x5C}, {0xD8,0x5A}, {0xD8,0x54}, {0xB3,0xC3},
    {0xD8,0x56}, {0x9F,0xA8}, {0xB6,0xCA}, {0xB6,0xC4},
    {0xDC,0xB7}, {0xB6,0xCD}, {0xDC,0xBD}, {0xDC,0xC0},
    {0xB6,0xC6}, {0xB6,0xC7}, {0xDC,0xBA}, {0xB6,0xC5},
    {0xDC,0xC3}, {0xB6,0xCB}, {0xDC,0xC4}, {0xDC,0xBF},
    {0xB6,0xCC}, {0x8C,0x71}, {0xDC,0xB4}, {0xB6,0xC9},
    {0xDC,0xB5}, {0xDC,0xBE}, {0xDC,0xBC}, {0xDC,0xB8},
    {0xB6,0xC8}, {0xDC,0xB6}, {0xB6,0xCE}, {0xDC,0xBB},
    {0xDC,0xC2}, {0xDC,0xB9}, {0xDC,0xC1}, {0x92,0xA1},
    {0xB9,0xB6}, {0xB9,0xB3}, {0x90,0xE3}, {0xB9,0xB4},
    {0xE0,0xF9}, {0xE0,0xF1}, {0xB9,0xB2}, {0xB9,0xAF},
    {0xE0,0xF2}, {0xA0,0xA6}, {0xB9,0xB1}, {0xE0,0xF5},
    {0xE0,0xF7}, {0x94,0xAB}, {0xE0,0xFE}, {0xFC,0x72},
    {0xE0,0xFD}, {0xE0,0xF8}, {0xB9,0xAE}, {0xE0,0xF0},
    {0xB9,0xAC}, {0xE0,0xF3}, {0xB9,0xB7}, {0xE0,0xF6},
    {0xE0,0xFA}, {0xB9,0xB0}, {0xB9,0xAD}, {0xE0,0xFC},
    {0xE0,0xFB}, {0xB9,0xB5}, {0xE0,0xF4}, {0x97,0xC4},
    {0xBB,0xF8}, {0xE4,0xEC}, {0xE4,0xE9}, {0xBB,0xF9},
    {0xBB,0xF7}, {0x92,0xAE}, {0xE4,0xF0}, {0xE4,0xED},
    {0xE4,0xE6}, {0xBB,0xF6}, {0xFA,0x67}, {0xBB,0xFA},
    {0xE4,0xE7}, {0xBB,0xF5}, {0xBB,0xFD}, {0xE4,0xEA},
    {0xE4,0xEB}, {0xBB,0xFB}, {0xBB,0xFC}, {0xE4,0xF1},
    {0xE4,0xEE}, {0xE4,0xEF}, {0x92,0xA2}, {0xFA,0x69},
    {0xBE,0xAA}, {0xE8,0xF8}, {0xBE,0xA7}, {0xE8,0xF5},
    {0xBE,0xA9}, {0xBE,0xAB}, {0xE8,0xF6}, {0xBE,0xA8},
    {0xE8,0xF7}, {0xE8,0xF4}, {0xC0,0x76}, {0xEC,0xBD},
    {0xC0,0x77}, {0xEC,0xBB}, {0xEC,0xBC}, {0xEC,0xBA},
    {0xEC,0xB9}, {0xEC,0xBE}, {0xC0,0x75}, {0x92,0x68},
    {0xEF,0xB8}, {0xEF,0xB9}, {0xE4,0xE8}, {0xEF,0xB7},
    {0xC0,0x78}, {0xC3,0x5F}, {0xF1,0xEB}, {0xF1,0xEC},
    {0xC4,0xD7}, {0xC4,0xD8}, {0xF5,0xC1}, {0xF5,0xC0},
    {0xC5,0x6C}, {0xC5,0x6B}, {0xF7,0xD0}, {0xA4,0x49},
    {0xA4,0x61}, {0xA4,0xB9}, {0xA4,0xB8}, {0xA5,0x53},
    {0xA5,0x52}, {0xA5,0xFC}, {0xA5,0xFB}, {0xA5,0xFD},
    {0xA5,0xFA}, {0xA7,0x4A}, {0xA7,0x49}, {0xA7,0x4B},
    {0xA8,0xE0}, {0xA8,0xDF}, {0xA8,0xE1}, {0x89,0x51},
    {0xAB,0x5E}, {0xA2,0x59}, {0xD0,0xDE}, {0xA2,0x5A},
    {0xB0,0xC2}, {0xA2,0x5C}, {0xA2,0x5B}, {0xD8,0x60},
    {0xFA,0x6F}, {0xA2,0x5D}, {0xB9,0xB8}, {0xA2,0x5E},
    {0xA4,0x4A}, {0xA4,0xBA}, {0xA5,0xFE}, {0xA8,0xE2},
    {0xFA,0x71}, {0xA4,0x4B}, {0xA4,0xBD}, {0xA4,0xBB},
    {0xA4,0xBC}, {0xA6,0x40}, {0x89,0x52}, {0xA7,0x4C},
    {0xA8,0xE4}, {0xA8,0xE3}, {0xA8,0xE5}, {0x94,0x5A},
    {0xAD,0xDD}, {0xBE,0xAC}, {0xC6,0xC3}, {0x89,0xDD},
    {0xC9,0x4E}, {0xC8,0xA2}, {0xA5,0x54}, {0xA5,0x55},
    {0xA6,0x41}, {0xCA,0x6A}, {0xAB,0x60}, {0xAB,0x5F},
    {0xD0,0xE0}, {0xD0,0xDF}, {0xB0,0xC3}, {0xC6,0xC4},
    {0xA4,0xBE}, {0xC9,0x55}, {0x9E,0x52}, {0x89,0x53},
    {0xCB,0xCD}, {0xAB,0x61}, {0xAD,0xE0}, {0xAD,0xDE},
    {0xAD,0xDF}, {0x9E,0x55}, {0x92,0xBA}, {0xBE,0xAD},
    {0xC6,0xC5}, {0xA5,0x56}, {0x8C,0x5B}, {0xA6,0x42},
    {0xC9,0xBC}, {0xFA,0x7D}, {0xFA,0xA8}, {0x9A,0x68},
    {0xFA,0x47}, {0xA7,0x4D}, {0xA7,0x4E}, {0xFA,0x7E},
    {0xCA,0x6B}, {0xCB,0xCE}, {0xA8,0xE6}, {0xCB,0xCF},
    {0x92,0xBB}, {0xD0,0xE2}, {0xD0,0xE3}, {0xAD,0xE3},
    {0xFD,0xB6}, {0xD0,0xE4}, {0xFA,0xA2}, {0xD0,0xE1},
    {0xAD,0xE4}, {0xAD,0xE2}, {0xAD,0xE1}, {0xD0,0xE5},
    {0xFA,0xA3}, {0xD4,0x68}, {0xFA,0xA4}, {0x9B,0xB4},
    {0xFA,0xA6}, {0xD8,0x61}, {0xDC,0xC5}, {0xE1,0x40},
    {0x89,0xDF}, {0xBB,0xFE}, {0xBE,0xAE}, {0xE8,0xF9},
    {0xFD,0xDB}, {0xA4,0x4C}, {0xA4,0x5A}, {0xFA,0xA9},
    {0x89,0x54}, {0xFA,0xAB}, {0xB0,0xC4}, {0xB3,0xCD},
    {0xB9,0xB9}, {0xFC,0x7A}, {0xC9,0x42}, {0xA4,0xBF},
    {0xA5,0x59}, {0xA5,0x57}, {0xA5,0x58}, {0x89,0xE0},
    {0xA8,0xE7}, {0x9F,0x4F}, {0xA4,0x4D}, {0xA4,0x4E},
    {0xC8,0x7D}, {0xA4,0x62}, {0x89,0xE1}, {0xA4,0xC0},
    {0xA4,0xC1}, {0xA4,0xC2}, {0xC9,0xBE}, {0xA5,0x5A},
    {0xFA,0xB0}, {0xC9,0x6B}, {0xA6,0x46}, {0xC9,0xBF},
    {0xA6,0x44}, {0xA6,0x45}, {0xC9,0xBD}, {0xA6,0x47},
    {0xA6,0x43}, {0xCA,0x6C}, {0xAA,0xEC}, {0xCA,0x6D},
    {0x9F,0xCD}, {0xA0,0xE7}, {0xCA,0x6E}, {0xA7,0x50},
    {0xA7,0x4F}, {0xFA,0xB1}, {0x89,0xA6}, {0xA7,0x53},
    {0xA7,0x51}, {0xA7,0x52}, {0xA8,0xED}, {0xA8,0xEC},
    {0xCB,0xD4}, {0xCB,0xD1}, {0xCB,0xD2}, {0x9E,0xFA},
    {0xCB,0xD0}, {0xA8,0xEE}, {0xA8,0xEA}, {0xA8,0xE9},
    {0xA8,0xEB}, {0xA8,0xE8}, {0xFA,0xB2}, {0xA8,0xEF},
    {0xAB,0x63}, {0xCD,0xF0}, {0xCB,0xD3}, {0xAB,0x68},
    {0xCD,0xF1}, {0xAB,0x64}, {0xAB,0x67}, {0xAB,0x66},
    {0xAB,0x65}, {0xAB,0x62}, {0xD0,0xE8}, {0xAD,0xE7},
    {0xD0,0xEB}, {0xAD,0xE5}, {0xFA,0xB4}, {0x92,0xC4},
    {0xD0,0xE7}, {0xAD,0xE8}, {0xAD,0xE6}, {0xAD,0xE9},
    {0xD0,0xE9}, {0xD0,0xEA}, {0x9F,0x6F}, {0xD0,0xE6},
    {0xD0,0xEC}, {0x8B,0xB0}, {0xB3,0xD1}, {0xB0,0xC5},
    {0xD4,0x69}, {0xD4,0x6B}, {0xD4,0x6A}, {0xD4,0x6C},
    {0xB0,0xC6}, {0xB3,0xCE}, {0x9F,0xAC}, {0xB3,0xCF},
    {0xB3,0xD0}, {0xB6,0xD0}, {0xDC,0xC7}, {0x89,0xE3},
    {0xDC,0xC6}, {0xDC,0xC8}, {0xDC,0xC9}, {0xB6,0xD1},
    {0xB6,0xCF}, {0xE1,0x41}, {0xE1,0x42}, {0xB9,0xBB},
    {0xB9,0xBA}, {0xE3,0x5A}, {0xBC,0x40}, {0xBC,0x41},
    {0xBC,0x42}, {0xBC,0x44}, {0xE4,0xF2}, {0xE4,0xF3},
    {0xBC,0x43}, {0x9B,0xD3}, {0x89,0xE4}, {0xBE,0xAF},
    {0xBE,0xB0}, {0xFA,0xB5}, {0xF1,0xED}, {0xF5,0xC3},
    {0xF5,0xC2}, {0xF7,0xD1}, {0x9F,0xD5}, {0xA4,0x4F},
    {0xA5,0x5C}, {0xA5,0x5B}, {0x89,0x55}, {0xA6,0x48},
    {0x92,0xC5}, {0xC9,0xC0}, {0x89,0x56}, {0xA7,0x55},
    {0xA7,0x56}, {0xA7,0x54}, {0xA7,0x57}, {0xCA,0x6F},
    {0xCA,0x70}, {0xFA,0xB3}, {0xFA,0xB6}, {0xA8,0xF1},
    {0xCB,0xD5}, {0xA8,0xF0}, {0xCD,0xF2}, {0xAB,0x6C},
    {0xCD,0xF3}, {0xAB,0x6B}, {0xFA,0xB7}, {0xAB,0x69},
    {0xAB,0x6A}, {0x9E,0xDC}, {0xD0,0xED}, {0xFB,0xC4},
    {0x9F,0x71}, {0xB0,0xC7}, {0xD4,0x6E}, {0xB0,0xCA},
    {0xD4,0x6D}, {0xB1,0xE5}, {0xB0,0xC9}, {0xB0,0xC8},
    {0xB3,0xD4}, {0xB3,0xD3}, {0xB3,0xD2}, {0xB6,0xD2},
    {0xFA,0xBA}, {0x92,0xC7}, {0xB6,0xD5}, {0xB6,0xD6},
    {0xB6,0xD4}, {0xB6,0xD3}, {0xE1,0x43}, {0xE1,0x44},
    {0xE4,0xF5}, {0xBC,0x45}, {0xE4,0xF4}, {0xBE,0xB1},
    {0xEC,0xBF}, {0xC0,0x79}, {0xF1,0xEE}, {0xC4,0x55},
    {0xC6,0xC6}, {0xA4,0x63}, {0xA4,0xC3}, {0xC9,0x56},
    {0xA4,0xC4}, {0xA4,0xC5}, {0x9A,0x4C}, {0xA5,0x5D},
    {0xA5,0x5E}, {0xA6,0x49}, {0xCA,0x71}, {0xCB,0xD6},
    {0xCB,0xD7}, {0xAB,0x6D}, {0xD0,0xEE}, {0xB0,0xCC},
    {0xB0,0xCB}, {0xD8,0x63}, {0xD8,0x62}, {0xA4,0x50},
    {0xA4,0xC6}, {0xA5,0x5F}, {0xB0,0xCD}, {0xC9,0x43},
    {0xC9,0x6C}, {0xA5,0x60}, {0xC9,0xC2}, {0xA6,0x4B},
    {0xA6,0x4A}, {0xC9,0xC1}, {0xA7,0x58}, {0x8C,0x68},
    {0x89,0xE5}, {0xAD,0xEA}, {0x9F,0x7D}, {0xD4,0x6F},
    {0xB6,0xD7}, {0xE1,0x45}, {0xB9,0xBC}, {0xA0,0xA9},
    {0xFA,0xC4}, {0xE8,0xFA}, {0xF3,0xFD}, {0xC6,0xC7},
    {0xA4,0xC7}, {0x89,0x57}, {0xCB,0xD8}, {0xCD,0xF4},
    {0xB0,0xD0}, {0xB0,0xCE}, {0xB0,0xCF}, {0xA4,0x51},
    {0xFA,0xAA}, {0xA4,0x64}, {0xA2,0xCD}, {0xA4,0xCA},
    {0xA4,0xC9}, {0xA4,0xC8}, {0xA5,0x63}, {0xA5,0x62},
    {0xC9,0x6D}, {0xC9,0xC3}, {0x89,0x58}, {0xA8,0xF5},
    {0xA8,0xF2}, {0xA8,0xF4}, {0xA8,0xF3}, {0xAB,0x6E},
    {0xB3,0xD5}, {0xA4,0x52}, {0x8B,0xE3}, {0xA4,0xCB},
    {0x8B,0x61}, {0xA5,0x65}, {0xA5,0x64}, {0xCA,0x72},
    {0x9A,0xF1}, {0xA8,0xF6}, {0x9E,0xB7}, {0xC6,0xC8},
    {0xC9,0x57}, {0xFA,0xD1}, {0xA5,0x67}, {0xA5,0x66},
    {0xA6,0x4C}, {0xA6,0x4D}, {0xCA,0x73}, {0xA7,0x59},
    {0xFA,0xD2}, {0xA7,0x5A}, {0xA8,0xF7}, {0xA8,0xF8},
    {0xA8,0xF9}, {0xAB,0x6F}, {0xCD,0xF5}, {0x9E,0xBA},
    {0xFA,0xD4}, {0xAD,0xEB}, {0xC9,0x44}, {0xA4,0xCC},
    {0xC9,0xC4}, {0xCA,0x74}, {0xCA,0x75}, {0xCB,0xD9},
    {0xFA,0xD9}, {0xCB,0xDA}, {0xCD,0xF7}, {0xCD,0xF6},
    {0xCD,0xF9}, {0xCD,0xF8}, {0xAB,0x70}, {0xD4,0x70},
    {0xAD,0xED}, {0xD0,0xEF}, {0xAD,0xEC}, {0xFA,0xDB},
    {0x9C,0xE0}, {0xD8,0x64}, {0xB3,0xD6}, {0xFB,0xF7},
    {0xD8,0x65}, {0xFB,0xFA}, {0x89,0xE7}, {0xA0,0x7A},
    {0xFA,0xDC}, {0xE1,0x46}, {0xB9,0xBD}, {0xFA,0xDD},
    {0x89,0xE9}, {0xBC,0x46}, {0xF1,0xEF}, {0xC6,0xC9},
    {0xC9,0x58}, {0xA5,0x68}, {0xFA,0xE2}, {0x89,0xEB},
    {0xB0,0xD1}, {0xFA,0xE3}, {0xA4,0x53}, {0xA4,0x65},
    {0xA4,0xCE}, {0xA4,0xCD}, {0x90,0xC8}, {0xA4,0xCF},
    {0x92,0xDA}, {0x89,0x59}, {0x9C,0xF5}, {0xA8,0xFB},
    {0xA8,0xFA}, {0xA8,0xFC}, {0x89,0x5A}, {0xFA,0xE7},
    {0x9F,0xA2}, {0xAB,0x71}, {0xAD,0xEE}, {0xFA,0xEA},
    {0xE8,0xFB}, {0xC2,0x4F}, {0xA4,0x66}, {0xA5,0x6A},
    {0xA5,0x79}, {0xA5,0x74}, {0xA5,0x6F}, {0xA5,0x6E},
    {0xA5,0x75}, {0xA5,0x73}, {0xA5,0x6C}, {0xA5,0x7A},
    {0xA5,0x6D}, {0xA5,0x69}, {0xA5,0x78}, {0xA5,0x77},
    {0xA5,0x76}, {0xA5,0x6B}, {0xA5,0x72}, {0xFA,0xED},
    {0x8F,0xAD}, {0xA5,0x71}, {0xA5,0x7B}, {0xA5,0x70},
    {0xFB,0x59}, {0xA6,0x53}, {0xA6,0x59}, {0xA6,0x55},
    {0xA6,0x5B}, {0xC9,0xC5}, {0xA6,0x58}, {0xA6,0x4E},
    {0xA6,0x51}, {0xA6,0x54}, {0xA6,0x50}, {0xA6,0x57},
    {0xA6,0x5A}, {0xA6,0x4F}, {0xA6,0x52}, {0xA6,0x56},
    {0xA6,0x5C}, {0xFA,0xEF}, {0x96,0xEF}, {0x9D,0xEC},
    {0xCA,0x7E}, {0xCA,0x7B}, {0x9D,0xCA}, {0xA7,0x67},
    {0xCA,0x7C}, {0xA7,0x5B}, {0xA7,0x5D}, {0xA7,0x75},
    {0xA7,0x70}, {0xFD,0x6D}, {0x89,0xEC}, {0xCA,0xA5},
    {0xCA,0x7D}, {0xA7,0x5F}, {0xA7,0x61}, {0xCA,0xA4},
    {0xA7,0x68}, {0xCA,0x78}, {0xA7,0x74}, {0xA7,0x76},
    {0xA7,0x5C}, {0xA7,0x6D}, {0xFB,0x44}, {0xCA,0x76},
    {0xA7,0x73}, {0x9D,0xE2}, {0xA7,0x64}, {0x8C,0x75},
    {0xA7,0x6E}, {0xA7,0x6F}, {0xCA,0x77}, {0xA7,0x6C},
    {0xA7,0x6A}, {0xA7,0x6B}, {0xA7,0x71}, {0xCA,0xA1},
    {0xA7,0x5E}, {0xA7,0x72}, {0xCA,0xA3}, {0xA7,0x66},
    {0xA7,0x63}, {0xCA,0x7A}, {0xA7,0x62}, {0xCA,0xA6},
    {0xA7,0x65}, {0xA7,0x69}, {0x9E,0xC0}, {0x9E,0x56},
    {0xA7,0x60}, {0xCA,0xA2}, {0xCA,0x79}, {0xCB,0xEB},
    {0xCB,0xEA}, {0xA9,0x4F}, {0xCB,0xED}, {0xCB,0xEF},
    {0xCB,0xE4}, {0xCB,0xE7}, {0xCB,0xEE}, {0xA9,0x50},
    {0x9F,0x79}, {0x9A,0xC7}, {0xCB,0xE1}, {0xCB,0xE5},
    {0xFA,0xF4}, {0xCB,0xE9}, {0xCE,0x49}, {0xA9,0x4B},
    {0xCE,0x4D}, {0xA8,0xFD}, {0xCB,0xE6}, {0xA8,0xFE},
    {0xA9,0x4C}, {0xA9,0x45}, {0xA9,0x41}, {0xCB,0xE2},
    {0xA9,0x44}, {0xA9,0x49}, {0xA9,0x52}, {0xCB,0xE3},
    {0xCB,0xDC}, {0xA9,0x43}, {0xCB,0xDD}, {0xCB,0xDF},
    {0xA9,0x46}, {0x98,0xA1}, {0xA9,0x48}, {0xCB,0xDB},
    {0xCB,0xE0}, {0xA9,0x51}, {0xA9,0x4D}, {0xCB,0xE8},
    {0xA9,0x53}, {0xFA,0xF8}, {0xA9,0x4A}, {0xCB,0xDE},
    {0xA9,0x47}, {0x89,0xF0}, {0x9E,0x47}, {0xA9,0x42},
    {0xA9,0x40}, {0x9D,0xF7}, {0xCB,0xEC}, {0xA9,0x4E},
    {0x9F,0xD3}, {0x9A,0xCA}, {0xCE,0x48}, {0xCD,0xFB},
    {0xCE,0x4B}, {0x89,0xF1}, {0xFA,0xF9}, {0xCD,0xFD},
    {0xAB,0x78}, {0xAB,0xA8}, {0xAB,0x74}, {0xAB,0xA7},
    {0xAB,0x7D}, {0xAB,0xA4}, {0xAB,0x72}, {0xCD,0xFC},
    {0xCE,0x43}, {0xAB,0xA3}, {0xCE,0x4F}, {0xAB,0xA5},
    {0x8E,0x5A}, {0xAB,0x79}, {0x89,0xF2}, {0xCE,0x45},
    {0xCE,0x42}, {0xAB,0x77}, {0x89,0xF3}, {0xCD,0xFA},
    {0xAB,0xA6}, {0xCE,0x4A}, {0xAB,0x7C}, {0xCE,0x4C},
    {0xAB,0xA9}, {0xAB,0x73}, {0xAB,0x7E}, {0xAB,0x7B},
    {0xCE,0x40}, {0xAB,0xA1}, {0xCE,0x46}, {0xCE,0x47},
    {0xAB,0x7A}, {0xAB,0xA2}, {0xAB,0x76}, {0x92,0x5D},
    {0x8B,0x51}, {0x92,0xE0}, {0xAB,0x75}, {0xCD,0xFE},
    {0x89,0xF4}, {0xCE,0x44}, {0x9F,0xD4}, {0xCE,0x4E},
    {0xD1,0x44}, {0xAD,0xFB}, {0xD0,0xF1}, {0x8A,0x79},
    {0xD0,0xF6}, {0xAD,0xF4}, {0xAE,0x40}, {0xD0,0xF4},
    {0xAD,0xEF}, {0xAD,0xF9}, {0xAD,0xFE}, {0xD0,0xFB},
    {0xAD,0xFA}, {0xAD,0xFD}, {0x89,0xF5}, {0xD0,0xFE},
    {0xAD,0xF5}, {0xD0,0xF5}, {0xD1,0x42}, {0xD1,0x43},
    {0xAD,0xF7}, {0xD1,0x41}, {0xAD,0xF3}, {0xAE,0x43},
    {0xD0,0xF8}, {0xAD,0xF1}, {0x97,0xA7}, {0xD1,0x46},
    {0xD0,0xF9}, {0xD0,0xFD}, {0xAD,0xF6}, {0xAE,0x42},
    {0xD0,0xFA}, {0xAD,0xFC}, {0xD1,0x40}, {0xD1,0x47},
    {0xD4,0xA1}, {0x93,0xBA}, {0xD1,0x45}, {0xAE,0x44},
    {0xAD,0xF0}, {0xD0,0xFC}, {0xD0,0xF3}, {0x9E,0x58},
    {0xAD,0xF8}, {0xD0,0xF2}, {0x89,0xF6}, {0xD0,0xF7},
    {0x9E,0x57}, {0x89,0xF7}, {0x8A,0x41}, {0xD0,0xF0},
    {0xAE,0x41}, {0x89,0xF8}, {0xD4,0x77}, {0xFA,0xF1},
    {0xB0,0xE4}, {0xD4,0xA7}, {0xB0,0xE2}, {0xB0,0xDF},
    {0xD4,0x7C}, {0xB0,0xDB}, {0xD4,0xA2}, {0xB0,0xE6},
    {0xD4,0x76}, {0xD4,0x7B}, {0xD4,0x7A}, {0xAD,0xF2},
    {0xB0,0xE1}, {0xD4,0xA5}, {0xD4,0xA8}, {0xD4,0x73},
    {0xB3,0xE8}, {0x89,0xFA}, {0xD4,0xA9}, {0xB0,0xE7},
    {0xB0,0xD9}, {0xB0,0xD6}, {0xD4,0x7E}, {0xB0,0xD3},
    {0xFB,0x42}, {0xD4,0xA6}, {0xFA,0xBF}, {0xB0,0xDA},
    {0xD4,0xAA}, {0xD4,0x74}, {0xD4,0xA4}, {0xB0,0xDD},
    {0xD4,0x75}, {0xD4,0x78}, {0xD4,0x7D}, {0xFB,0xA3},
    {0xB0,0xDE}, {0xB0,0xDC}, {0xB0,0xE8}, {0xB0,0xE3},
    {0xFA,0xF7}, {0xB0,0xD7}, {0xB1,0xD2}, {0xB0,0xD8},
    {0xD4,0x79}, {0xB0,0xE5}, {0xB0,0xE0}, {0xD4,0xA3},
    {0xB0,0xD5}, {0x9E,0x4E}, {0xB0,0xD4}, {0x94,0xDC},
    {0x95,0xDA}, {0x9D,0xF8}, {0x9F,0x6A}, {0xD4,0x71},
    {0xD4,0x72}, {0xD8,0x6A}, {0x8A,0xB7}, {0xB3,0xD7},
    {0xB3,0xDA}, {0xD8,0x75}, {0xB3,0xEE}, {0xD8,0x78},
    {0xB3,0xD8}, {0xD8,0x71}, {0xB3,0xDE}, {0xB3,0xE4},
    {0xB5,0xBD}, {0xFB,0x46}, {0xB3,0xE2}, {0xD8,0x6E},
    {0xB3,0xEF}, {0xB3,0xDB}, {0xB3,0xE3}, {0xD8,0x76},
    {0xDC,0xD7}, {0xD8,0x7B}, {0xD8,0x6F}, {0x8A,0x46},
    {0xD8,0x66}, {0xD8,0x73}, {0xD8,0x6D}, {0xB3,0xE1},
    {0xD8,0x79}, {0xB3,0xDD}, {0xB3,0xF1}, {0xB3,0xEA},
    {0xB3,0xDF}, {0xB3,0xDC}, {0xB3,0xE7}, {0xD8,0x7A},
    {0xD8,0x6C}, {0xD8,0x72}, {0xD8,0x74}, {0xD8,0x68},
    {0xD8,0x77}, {0xB3,0xD9}, {0xD8,0x67}, {0xFB,0x47},
    {0xB3,0xE0}, {0xB3,0xF0}, {0xB3,0xEC}, {0xD8,0x69},
    {0xB3,0xE6}, {0x91,0x48}, {0xB3,0xED}, {0xB3,0xE9},
    {0xB3,0xE5}, {0x92,0xDE}, {0xD8,0x70}, {0x8B,0x53},
    {0x9D,0xF6}, {0xB3,0xEB}, {0x9B,0xDA}, {0xDC,0xD5},
    {0xDC,0xD1}, {0x9D,0x7E}, {0xDC,0xE0}, {0xDC,0xCA},
    {0xDC,0xD3}, {0xB6,0xE5}, {0xB6,0xE6}, {0xB6,0xDE},
    {0xDC,0xDC}, {0xB6,0xE8}, {0xDC,0xCF}, {0xDC,0xCE},
    {0xDC,0xCC}, {0xDC,0xDE}, {0xB6,0xDC}, {0xDC,0xD8},
    {0xDC,0xCD}, {0xB6,0xDF}, {0xDC,0xD6}, {0xB6,0xDA},
    {0xDC,0xD2}, {0xDC,0xD9}, {0xDC,0xDB}, {0x89,0xFD},
    {0x99,0xE4}, {0xDC,0xDF}, {0xB6,0xE3}, {0xDC,0xCB},
    {0xB6,0xDD}, {0xDC,0xD0}, {0x9E,0x43}, {0xB6,0xD8},
    {0xB6,0xE4}, {0xDC,0xDA}, {0xB6,0xE0}, {0xB6,0xE1},
    {0xB6,0xE7}, {0xB6,0xDB}, {0xA2,0x5F}, {0xB6,0xD9},
    {0xDC,0xD4}, {0x9D,0xE9}, {0x8F,0x52}, {0xB6,0xE2},
    {0x9D,0xF5}, {0x9D,0xF0}, {0xDC,0xDD}, {0x99,0xE7},
    {0xB9,0xCD}, {0xB9,0xC8}, {0xE1,0x55}, {0xE1,0x51},
    {0x8B,0xBD}, {0xE1,0x4B}, {0xB9,0xC2}, {0xB9,0xBE},
    {0xE1,0x54}, {0xB9,0xBF}, {0xE1,0x4E}, {0xE1,0x50},
    {0xE1,0x53}, {0x9D,0xEF}, {0xB9,0xC4}, {0xB9,0xCB},
    {0xB9,0xC5}, {0xE1,0x49}, {0xB9,0xC6}, {0xB9,0xC7},
    {0xE1,0x4C}, {0xB9,0xCC}, {0x9F,0xB7}, {0xE1,0x4A},
    {0xE1,0x4F}, {0xB9,0xC3}, {0xE1,0x48}, {0xB9,0xC9},
    {0xB9,0xC1}, {0xB9,0xC0}, {0xE1,0x4D}, {0xE1,0x52},
    {0x9D,0xD0}, {0xB9,0xCA}, {0x9F,0xEB}, {0x8D,0xA9},
    {0x9D,0xCF}, {0x98,0xE1}, {0x9D,0xE5}, {0xE1,0x47},
    {0xBC,0x4D}, {0xE5,0x47}, {0xE5,0x44}, {0x9D,0xC8},
    {0xBC,0x47}, {0xBC,0x53}, {0xBC,0x54}, {0xBC,0x4A},
    {0xE5,0x42}, {0xBC,0x4C}, {0xE4,0xF9}, {0xBC,0x52},
    {0xFB,0x4F}, {0xE5,0x46}, {0xBC,0x49}, {0xE5,0x48},
    {0xBC,0x48}, {0xE5,0x43}, {0xE5,0x45}, {0xBC,0x4B},
    {0xE5,0x41}, {0xE4,0xFA}, {0xE4,0xF7}, {0x9D,0xEB},
    {0xD8,0x6B}, {0xE4,0xFD}, {0xE4,0xF6}, {0xE4,0xFC},
    {0xE4,0xFB}, {0xE4,0xF8}, {0xFB,0x54}, {0xBC,0x4F},
    {0xFB,0x55}, {0x9A,0xA2}, {0x8A,0xD6}, {0xBC,0x4E},
    {0x9A,0x5F}, {0xBC,0x50}, {0xE4,0xFE}, {0xBE,0xB2},
    {0xE5,0x40}, {0x9E,0xF5}, {0xE9,0x45}, {0xE8,0xFD},
    {0x8F,0xB7}, {0xBE,0xBE}, {0xE9,0x42}, {0xBE,0xB6},
    {0xBE,0xBA}, {0xE9,0x41}, {0xBE,0xB9}, {0xBE,0xB5},
    {0xBE,0xB8}, {0xBE,0xB3}, {0xBE,0xBD}, {0xE9,0x43},
    {0xE8,0xFE}, {0xBE,0xBC}, {0xE8,0xFC}, {0xBE,0xBB},
    {0xE9,0x44}, {0xE9,0x40}, {0xBC,0x51}, {0xBE,0xBF},
    {0xE9,0x46}, {0xBE,0xB7}, {0xBE,0xB4}, {0x9A,0xD2},
    {0x9E,0x6A}, {0x9E,0xE8}, {0xEC,0xC6}, {0xEC,0xC8},
    {0xC0,0x7B}, {0xEC,0xC9}, {0xEC,0xC7}, {0xEC,0xC5},
    {0xEC,0xC4}, {0xC0,0x7D}, {0xEC,0xC3}, {0xC0,0x7E},
    {0x8B,0xBF}, {0x91,0xC2}, {0x9D,0x62}, {0xEC,0xC1},
    {0xEC,0xC2}, {0xC0,0x7A}, {0xC0,0xA1}, {0xC0,0x7C},
    {0x92,0x60}, {0xEC,0xC0}, {0xC2,0x50}, {0xEF,0xBC},
    {0xEF,0xBA}, {0xEF,0xBF}, {0xEF,0xBD}, {0xEF,0xBB},
    {0xEF,0xBE}, {0x92,0x5E}, {0x91,0xC1}, {0x8A,0xC5},
    {0x97,0xA3}, {0xC3,0x60}, {0xF1,0xF2}, {0xF1,0xF3},
    {0xC4,0x56}, {0xF1,0xF4}, {0xF1,0xF0}, {0xF1,0xF5},
    {0xF1,0xF1}, {0xC2,0x51}, {0x8B,0x6C}, {0x8D,0x7E},
    {0xF3,0xFE}, {0xF4,0x41}, {0xC4,0x59}, {0xF4,0x40},
    {0xC4,0x58}, {0xC4,0x57}, {0x9C,0x54}, {0xC4,0x5A},
    {0xF5,0xC5}, {0xF5,0xC6}, {0x9D,0xBD}, {0xC4,0xDA},
    {0xC4,0xD9}, {0xC4,0xDB}, {0xF5,0xC4}, {0xF6,0xD8},
    {0xF6,0xD7}, {0xC5,0x6D}, {0xC5,0x6F}, {0xC5,0x6E},
    {0xF6,0xD9}, {0xC5,0xC8}, {0xF8,0xA6}, {0xC5,0xF1},
    {0xF8,0xA5}, {0xF8,0xEE}, {0x9C,0xC5}, {0xC9,0x49},
    {0xA5,0x7D}, {0xA5,0x7C}, {0xA6,0x5F}, {0xA6,0x5E},
    {0xC9,0xC7}, {0xA6,0x5D}, {0xC9,0xC6}, {0x89,0x5B},
    {0xA7,0x79}, {0xCA,0xA9}, {0xCA,0xA8}, {0xA7,0x77},
    {0xA7,0x7A}, {0xFB,0x5C}, {0xCA,0xA7}, {0xFB,0x5B},
    {0xA7,0x78}, {0xFB,0x57}, {0xCB,0xF0}, {0xCB,0xF1},
    {0xA9,0x54}, {0x98,0xC7}, {0xAB,0xAA}, {0xFB,0x5A},
    {0xD1,0x48}, {0xD1,0x49}, {0xAE,0x45}, {0xAE,0x46},
    {0xD4,0xAC}, {0xB0,0xE9}, {0xB0,0xEB}, {0xD4,0xAB},
    {0xB0,0xEA}, {0xD8,0x7C}, {0xB3,0xF2}, {0xB6,0xE9},
    {0xB6,0xEA}, {0xDC,0xE1}, {0x9C,0xEE}, {0xB9,0xCF},
    {0xB9,0xCE}, {0xE5,0x49}, {0xE9,0x48}, {0xE9,0x47},
    {0x92,0xE2}, {0xF9,0x6B}, {0xA4,0x67}, {0xC9,0x59},
    {0xC9,0x6E}, {0xC9,0x6F}, {0xA6,0x62}, {0xA6,0x66},
    {0xC9,0xC9}, {0xA6,0x64}, {0xA6,0x63}, {0xC9,0xC8},
    {0xA6,0x65}, {0xA6,0x61}, {0x94,0xA7}, {0xA6,0x60},
    {0xC9,0xCA}, {0xA7,0xA6}, {0x8C,0xCC}, {0xA7,0xA3},
    {0x9B,0xD4}, {0xA7,0x7D}, {0xCA,0xAA}, {0xFB,0x64},
    {0xFB,0x76}, {0xCA,0xAB}, {0xFB,0x60}, {0xA7,0xA1},
    {0xCA,0xAD}, {0xA7,0x7B}, {0xCA,0xAE}, {0xCA,0xAC},
    {0xA7,0x7E}, {0xA7,0xA2}, {0xA7,0xA5}, {0xA7,0xA4},
    {0xA7,0x7C}, {0xCA,0xAF}, {0x99,0xE5}, {0x9A,0xC2},
    {0x91,0xFB}, {0xA0,0x73}, {0xA9,0x59}, {0xCB,0xFE},
    {0xA9,0x5B}, {0xA9,0x5A}, {0x9F,0x72}, {0xCC,0x40},
    {0xA9,0x58}, {0xA9,0x57}, {0xCB,0xF5}, {0xCB,0xF4},
    {0xCB,0xF2}, {0xCB,0xF7}, {0xCB,0xF6}, {0xCB,0xF3},
    {0xCB,0xFC}, {0xCB,0xFD}, {0xCB,0xFA}, {0xCB,0xF8},
    {0xA9,0x56}, {0x9F,0xCC}, {0xCB,0xFB}, {0xA9,0x5C},
    {0xCC,0x41}, {0x98,0xA5}, {0x92,0xE8}, {0xCB,0xF9},
    {0xAB,0xAB}, {0xA9,0x55}, {0x9B,0xBC}, {0x96,0xF3},
    {0xAB,0xAC}, {0xCE,0x54}, {0x92,0xE7}, {0xCE,0x5A},
    {0xFC,0x67}, {0xAB,0xB2}, {0xCE,0x58}, {0xCE,0x5E},
    {0xCE,0x55}, {0xCE,0x59}, {0xCE,0x5B}, {0xCE,0x5D},
    {0xCE,0x57}, {0x8B,0x7D}, {0xCE,0x56}, {0xCE,0x51},
    {0xCE,0x52}, {0xAB,0xAD}, {0x9B,0xF4}, {0xAB,0xAF},
    {0xAB,0xAE}, {0xCE,0x53}, {0xCE,0x5C}, {0x9E,0xF7},
    {0x9E,0xC1}, {0xAB,0xB1}, {0x99,0x6F}, {0xCE,0x50},
    {0xD1,0x53}, {0xD1,0x52}, {0xD1,0x57}, {0xD1,0x4E},
    {0x96,0xF1}, {0xD1,0x51}, {0xD1,0x50}, {0x8E,0x41},
    {0xD1,0x54}, {0xD1,0x58}, {0xAE,0x47}, {0xAE,0x4A},
    {0x95,0x4A}, {0xD1,0x4F}, {0xD1,0x55}, {0x97,0xE6},
    {0xAE,0x49}, {0xD1,0x4A}, {0xAB,0xB0}, {0xD4,0xBA},
    {0xD1,0x56}, {0xD1,0x4D}, {0xAE,0x48}, {0xD1,0x4C},
    {0x96,0xF5}, {0xD4,0xB1}, {0x92,0xE6}, {0x9F,0x42},
    {0xB0,0xEC}, {0xB0,0xF0}, {0xD4,0xC1}, {0xD4,0xAF},
    {0xD4,0xBD}, {0xB0,0xF1}, {0xD4,0xBF}, {0xFB,0x67},
    {0xD4,0xC5}, {0xD4,0xC9}, {0xD4,0xC0}, {0xD4,0xB4},
    {0xD4,0xBC}, {0x99,0xA9}, {0xD4,0xCA}, {0xD4,0xC8},
    {0xD4,0xBE}, {0xD4,0xB9}, {0xD4,0xB2}, {0xD8,0xA6},
    {0xD4,0xB0}, {0xB0,0xF5}, {0xD4,0xB7}, {0xB0,0xF6},
    {0xB0,0xF2}, {0xD4,0xAD}, {0xD4,0xC3}, {0xD4,0xB5},
    {0xFA,0xE6}, {0xD4,0xB3}, {0xD4,0xC6}, {0xB0,0xF3},
    {0xFB,0x69}, {0xD4,0xCC}, {0xB0,0xED}, {0xB0,0xEF},
    {0xD4,0xBB}, {0xD4,0xB6}, {0xAE,0x4B}, {0xB0,0xEE},
    {0xD4,0xB8}, {0xD4,0xC7}, {0xD4,0xCB}, {0xD4,0xC2},
    {0xD4,0xC4}, {0x97,0xE5}, {0xD4,0xAE}, {0xD8,0xA1},
    {0xD8,0xAA}, {0xD8,0xA9}, {0xB3,0xFA}, {0xD8,0xA2},
    {0xB3,0xFB}, {0xB3,0xF9}, {0x96,0x7D}, {0xD8,0xA4},
    {0xB3,0xF6}, {0xD8,0xA8}, {0xFB,0x6C}, {0xD8,0xA3},
    {0xD8,0xA5}, {0xD8,0x7D}, {0xB3,0xF4}, {0xD8,0xB2},
    {0xD8,0xB1}, {0xD8,0xAE}, {0xB3,0xF3}, {0xB3,0xF7},
    {0xB3,0xF8}, {0xD1,0x4B}, {0xD8,0xAB}, {0xB3,0xF5},
    {0xB0,0xF4}, {0xD8,0xAD}, {0xD8,0x7E}, {0xD8,0xB0},
    {0xD8,0xAF}, {0x99,0xA2}, {0xD8,0xB3}, {0xDC,0xEF},
    {0xD8,0xAC}, {0x9A,0xBB}, {0x9A,0x65}, {0x94,0x4E},
    {0xD8,0xA7}, {0xDC,0xE7}, {0xB6,0xF4}, {0xB6,0xF7},
    {0xB6,0xF2}, {0xDC,0xE6}, {0xDC,0xEA}, {0xDC,0xE5},
    {0xB6,0xEC}, {0xB6,0xF6}, {0xDC,0xE2}, {0xB6,0xF0},
    {0xDC,0xE9}, {0xB6,0xEE}, {0xB6,0xED}, {0xDC,0xEC},
    {0xB6,0xEF}, {0xDC,0xEE}, {0xFB,0x6E}, {0xDC,0xEB},
    {0xB6,0xEB}, {0x99,0xDF}, {0xB6,0xF5}, {0xDC,0xF0},
    {0xDC,0xE4}, {0xDC,0xED}, {0xDC,0xE3}, {0x98,0xE3},
    {0xB6,0xF1}, {0x92,0x54}, {0xB6,0xF3}, {0xDC,0xE8},
    {0xDC,0xF1}, {0x96,0x7B}, {0x8A,0xAF}, {0xE1,0x5D},
    {0xB9,0xD0}, {0xE1,0x63}, {0xB9,0xD5}, {0xE1,0x5F},
    {0xE1,0x66}, {0xE1,0x57}, {0xB9,0xD7}, {0xB9,0xD1},
    {0xE1,0x5C}, {0xBC,0x55}, {0xE1,0x5B}, {0xE1,0x64},
    {0xB9,0xD2}, {0xB9,0xD6}, {0xE1,0x5A}, {0xE1,0x60},
    {0xE1,0x65}, {0xE1,0x56}, {0xB9,0xD4}, {0xE1,0x5E},
    {0xE1,0x62}, {0xE1,0x68}, {0xE1,0x58}, {0xE1,0x61},
    {0x8C,0x77}, {0xB9,0xD3}, {0xE1,0x67}, {0xE1,0x59},
    {0x8B,0xAF}, {0x9E,0xBD}, {0xBC,0x59}, {0xE5,0x4B},
    {0xBC,0x57}, {0xBC,0x56}, {0xE5,0x4D}, {0xE5,0x52},
    {0xE5,0x4E}, {0xE5,0x51}, {0xBC,0x5C}, {0x9E,0xE6},
    {0xBE,0xA5}, {0xBC,0x5B}, {0xFB,0x6F}, {0xE5,0x4A},
    {0xE5,0x50}, {0xBC,0x5A}, {0xE5,0x4F}, {0x8E,0xE1},
    {0xE5,0x4C}, {0xBC,0x58}, {0x9B,0x7D}, {0x9C,0x7E},
    {0xE9,0x4D}, {0xF9,0xD9}, {0xE9,0x4F}, {0xE9,0x4A},
    {0xBE,0xC1}, {0xE9,0x4C}, {0xBE,0xC0}, {0xE9,0x4E},
    {0xBE,0xC3}, {0xE9,0x50}, {0xBE,0xC2}, {0xE9,0x49},
    {0xE9,0x4B}, {0x92,0xEA}, {0xC0,0xA5}, {0xEC,0xCC},
    {0x8C,0x78}, {0xC0,0xA4}, {0xEC,0xCD}, {0xC0,0xA3},
    {0xEC,0xCB}, {0xC0,0xA2}, {0xEC,0xCA}, {0xC2,0x53},
    {0xC2,0x52}, {0xF1,0xF6}, {0xF1,0xF8}, {0xFB,0x72},
    {0xF1,0xF7}, {0xC3,0x61}, {0xC3,0x62}, {0xFB,0x71},
    {0xC3,0x63}, {0xF4,0x42}, {0xC4,0x5B}, {0xF7,0xD3},
    {0xF7,0xD2}, {0xC5,0xF2}, {0xA4,0x68}, {0xA4,0xD0},
    {0xA7,0xA7}, {0x89,0x5C}, {0x98,0xF0}, {0x96,0xF2},
    {0xCE,0x5F}, {0xB3,0xFC}, {0xB3,0xFD}, {0xFB,0x74},
    {0xDC,0xF2}, {0xB9,0xD8}, {0xE1,0x69}, {0xE5,0x53},
    {0x8B,0xC1}, {0xC9,0x5A}, {0x89,0x5D}, {0x89,0xDE},
    {0xCA,0xB0}, {0x89,0x5E}, {0xC6,0xCA}, {0xCC,0x42},
    {0xCE,0x60}, {0xD1,0x59}, {0xAE,0x4C}, {0xFE,0x42},
    {0xF1,0xF9}, {0xC4,0xDC}, {0xA4,0x69}, {0xA5,0x7E},
    {0xC9,0x70}, {0xA6,0x67}, {0xA6,0x68}, {0xA9,0x5D},
    {0xFB,0x7B}, {0xB0,0xF7}, {0xB9,0xDA}, {0xB9,0xDB},
    {0xB9,0xD9}, {0xA4,0x6A}, {0xA4,0xD1}, {0xA4,0xD3},
    {0xA4,0xD2}, {0xC9,0x5B}, {0xA4,0xD4}, {0xA5,0xA1},
    {0xC9,0x71}, {0xA5,0xA2}, {0x89,0x5F}, {0x89,0x60},
    {0xA6,0x69}, {0xA6,0x6A}, {0xC9,0xCB}, {0xA7,0xA8},
    {0xCA,0xB1}, {0xA9,0x61}, {0xCC,0x43}, {0xA9,0x5F},
    {0xA9,0x60}, {0xA9,0x5E}, {0xD1,0x5A}, {0xAB,0xB6},
    {0xAB,0xB5}, {0xAB,0xB7}, {0xAB,0xB4}, {0xCE,0x61},
    {0xA9,0x62}, {0xAB,0xB3}, {0xAE,0x4D}, {0xAE,0x4E},
    {0xAE,0x4F}, {0xD4,0xCD}, {0xB3,0xFE}, {0xD8,0xB4},
    {0xB0,0xF8}, {0x9B,0xCD}, {0xB6,0xF8}, {0xB9,0xDD},
    {0xB9,0xDC}, {0xE1,0x6A}, {0xBC,0x5D}, {0xBE,0xC4},
    {0xEF,0xC0}, {0xF6,0xDA}, {0xF7,0xD4}, {0xA4,0x6B},
    {0xA5,0xA3}, {0x9D,0xD3}, {0xA5,0xA4}, {0xC9,0xD1},
    {0xA6,0x6C}, {0xA6,0x6F}, {0xC9,0xCF}, {0xC9,0xCD},
    {0xA6,0x6E}, {0xC9,0xD0}, {0xC9,0xD2}, {0xC9,0xCC},
    {0xA6,0x71}, {0xA6,0x70}, {0xA6,0x6D}, {0xA6,0x6B},
    {0xC9,0xCE}, {0x98,0x4C}, {0xA7,0xB3}, {0xA7,0xB0},
    {0xCA,0xB6}, {0xCA,0xB9}, {0xCA,0xB8}, {0xA7,0xAA},
    {0xA7,0xB2}, {0x97,0x52}, {0xA7,0xAF}, {0xCA,0xB5},
    {0xCA,0xB3}, {0xA7,0xAE}, {0x95,0xC3}, {0xA7,0xA9},
    {0xA7,0xAC}, {0x9B,0xB6}, {0xCA,0xB4}, {0xCA,0xBB},
    {0xCA,0xB7}, {0xA7,0xAD}, {0xA7,0xB1}, {0xA7,0xB4},
    {0xCA,0xB2}, {0xCA,0xBA}, {0xA7,0xAB}, {0x9A,0xB9},
    {0xA9,0x67}, {0xA9,0x6F}, {0x97,0xB3}, {0xCC,0x4F},
    {0xCC,0x48}, {0xA9,0x70}, {0xCC,0x53}, {0xCC,0x44},
    {0xCC,0x4B}, {0x9F,0x74}, {0x92,0xF1}, {0xA9,0x66},
    {0xCC,0x45}, {0xA9,0x64}, {0xCC,0x4C}, {0xCC,0x50},
    {0xA9,0x63}, {0xCC,0x51}, {0xCC,0x4A}, {0xCC,0x4D},
    {0x97,0xDF}, {0xA9,0x72}, {0xA9,0x69}, {0xCC,0x54},
    {0xCC,0x52}, {0xFB,0xA6}, {0xA9,0x6E}, {0xA9,0x6C},
    {0xCC,0x49}, {0xA9,0x6B}, {0xCC,0x47}, {0xCC,0x46},
    {0xA9,0x6A}, {0xA9,0x68}, {0xA9,0x71}, {0xA9,0x6D},
    {0xA9,0x65}, {0xCC,0x4E}, {0xAB,0xB9}, {0xFB,0xAB},
    {0xAB,0xC0}, {0xCE,0x6F}, {0xAB,0xB8}, {0xCE,0x67},
    {0xCE,0x63}, {0xCE,0x73}, {0xCE,0x62}, {0xAB,0xBB},
    {0xCE,0x6C}, {0xAB,0xBE}, {0xAB,0xC1}, {0xAB,0xBC},
    {0xCE,0x70}, {0xAB,0xBF}, {0x98,0x77}, {0xAE,0x56},
    {0xCE,0x76}, {0xCE,0x64}, {0x98,0x54}, {0x95,0xC5},
    {0xCE,0x66}, {0xCE,0x6D}, {0xCE,0x71}, {0xCE,0x75},
    {0xCE,0x72}, {0xCE,0x6B}, {0xCE,0x6E}, {0x9D,0x55},
    {0xFB,0xB2}, {0xCE,0x68}, {0xAB,0xC3}, {0xCE,0x6A},
    {0xCE,0x69}, {0xCE,0x74}, {0xAB,0xBA}, {0xCE,0x65},
    {0xAB,0xC2}, {0x95,0x7E}, {0xAB,0xBD}, {0xAE,0x5C},
    {0xD1,0x62}, {0x97,0x42}, {0xAE,0x5B}, {0x94,0xE6},
    {0xD1,0x60}, {0xAE,0x50}, {0x92,0xF5}, {0xAE,0x55},
    {0xD1,0x5F}, {0xD1,0x5C}, {0xD1,0x61}, {0xAE,0x51},
    {0xD1,0x5B}, {0x8C,0xC5}, {0xAE,0x54}, {0xAE,0x52},
    {0xD1,0x63}, {0xAE,0x53}, {0xAE,0x57}, {0x92,0xFD},
    {0xAE,0x58}, {0xFB,0xA2}, {0xAE,0x5A}, {0x9C,0x51},
    {0xAE,0x59}, {0x94,0xE9}, {0x98,0x5C}, {0x92,0xF0},
    {0xD1,0x5D}, {0xD1,0x5E}, {0xD1,0x64}, {0xD4,0xD4},
    {0xB0,0xF9}, {0xD8,0xC2}, {0xD4,0xD3}, {0xD4,0xE6},
    {0xB1,0x40}, {0x94,0x4C}, {0xD4,0xE4}, {0xB0,0xFE},
    {0xB0,0xFA}, {0xD4,0xED}, {0xD4,0xDD}, {0xD4,0xE0},
    {0x91,0x6B}, {0xB1,0x43}, {0xD4,0xEA}, {0xD4,0xE2},
    {0xB0,0xFB}, {0xB1,0x44}, {0xD4,0xE7}, {0xD4,0xE5},
    {0xD4,0xD6}, {0xD4,0xEB}, {0xD4,0xDF}, {0xD4,0xDA},
    {0x8B,0x78}, {0xD4,0xD0}, {0xD4,0xEC}, {0xD4,0xDC},
    {0xD4,0xCF}, {0x94,0xE2}, {0xB1,0x42}, {0xD4,0xE1},
    {0xD4,0xEE}, {0xD4,0xDE}, {0xD4,0xD2}, {0xD4,0xD7},
    {0xD4,0xCE}, {0x98,0x4F}, {0xB1,0x41}, {0xFB,0xB5},
    {0xD4,0xDB}, {0xD4,0xD8}, {0xB0,0xFC}, {0xD4,0xD1},
    {0x92,0x71}, {0xD4,0xE9}, {0xB0,0xFD}, {0x93,0x65},
    {0xD4,0xD9}, {0xD4,0xD5}, {0x98,0x5B}, {0xD4,0xE8},
    {0x98,0x50}, {0xB4,0x40}, {0xD8,0xBB}, {0x97,0xBC},
    {0xD8,0xB8}, {0xD8,0xC9}, {0xD8,0xBD}, {0xD8,0xCA},
    {0x92,0xF3}, {0xB4,0x42}, {0x93,0x40}, {0x98,0x4D},
    {0xD8,0xC6}, {0xD8,0xC3}, {0x95,0x72}, {0xFD,0xEF},
    {0xD8,0xC4}, {0xD8,0xC7}, {0xD8,0xCB}, {0xD4,0xE3},
    {0xD8,0xCD}, {0xDD,0x47}, {0xFD,0xC1}, {0xB4,0x43},
    {0xD8,0xCE}, {0xD8,0xB6}, {0xD8,0xC0}, {0xFB,0xBA},
    {0xD8,0xC5}, {0x92,0xEB}, {0xB4,0x41}, {0xB4,0x44},
    {0xD8,0xCC}, {0xD8,0xCF}, {0xD8,0xBA}, {0xD8,0xB7},
    {0xFC,0x73}, {0x97,0xB7}, {0xD8,0xB9}, {0xD8,0xBE},
    {0xD8,0xBC}, {0xB4,0x45}, {0xD8,0xC8}, {0xFB,0xB4},
    {0xD8,0xBF}, {0xD8,0xC1}, {0xD8,0xB5}, {0xDC,0xFA},
    {0xDC,0xF8}, {0xB7,0x42}, {0xB7,0x40}, {0xDD,0x43},
    {0xDC,0xF9}, {0xDD,0x44}, {0xDD,0x40}, {0xDC,0xF7},
    {0xDD,0x46}, {0xDC,0xF6}, {0xDC,0xFD}, {0xB6,0xFE},
    {0xB6,0xFD}, {0xB6,0xFC}, {0xDC,0xFB}, {0xDD,0x41},
    {0xB6,0xF9}, {0xB7,0x41}, {0x90,0xA7}, {0xDC,0xF4},
    {0xDC,0xFE}, {0xDC,0xF3}, {0xDC,0xFC}, {0xB6,0xFA},
    {0xDD,0x42}, {0xDC,0xF5}, {0xB6,0xFB}, {0xDD,0x45},
    {0x97,0x41}, {0x92,0xF4}, {0xFB,0xBC}, {0xE1,0x6E},
    {0xB9,0xE2}, {0xB9,0xE1}, {0xB9,0xE3}, {0xE1,0x7A},
    {0xE1,0x70}, {0xE1,0x76}, {0xE1,0x6B}, {0xE1,0x79},
    {0xE1,0x78}, {0xE1,0x7C}, {0xE1,0x75}, {0xB9,0xDE},
    {0xE1,0x74}, {0xB9,0xE4}, {0x95,0x77}, {0xE1,0x6D},
    {0xB9,0xDF}, {0xE1,0x7B}, {0xB9,0xE0}, {0xE1,0x6F},
    {0xE1,0x72}, {0xE1,0x77}, {0xE1,0x71}, {0xE1,0x6C},
    {0x9E,0xE2}, {0x8F,0x78}, {0xE1,0x73}, {0xE5,0x55},
    {0xBC,0x61}, {0xE5,0x58}, {0xE5,0x57}, {0xE5,0x5A},
    {0xE5,0x5C}, {0xF9,0xDC}, {0xBC,0x5F}, {0xE5,0x56},
    {0x96,0x72}, {0xE5,0x54}, {0xE5,0x5D}, {0xE5,0x5B},
    {0xE5,0x59}, {0xE5,0x5F}, {0xE5,0x5E}, {0xBC,0x63},
    {0xBC,0x5E}, {0xBC,0x60}, {0xBC,0x62}, {0x9E,0xB5},
    {0xE5,0x60}, {0xE9,0x57}, {0x96,0x4B}, {0xE9,0x56},
    {0xE9,0x55}, {0x8C,0xAC}, {0xE9,0x58}, {0xE9,0x51},
    {0xE9,0x52}, {0xE9,0x5A}, {0xE9,0x53}, {0xBE,0xC5},
    {0xE9,0x5C}, {0xA0,0xFA}, {0xE9,0x5B}, {0xE9,0x54},
    {0xEC,0xD1}, {0xC0,0xA8}, {0xEC,0xCF}, {0xEC,0xD4},
    {0xEC,0xD3}, {0xE9,0x59}, {0xC0,0xA7}, {0x95,0x75},
    {0xEC,0xD2}, {0xEC,0xCE}, {0xEC,0xD6}, {0xEC,0xD5},
    {0xC0,0xA6}, {0xEC,0xD0}, {0xBE,0xC6}, {0xC2,0x54},
    {0xEF,0xC1}, {0xF1,0xFA}, {0xF1,0xFB}, {0xF1,0xFC},
    {0xC4,0x5C}, {0x90,0xDA}, {0xC4,0x5D}, {0x93,0x67},
    {0xF4,0x43}, {0xFE,0xA4}, {0xF5,0xC8}, {0xF5,0xC7},
    {0x90,0xDF}, {0xF6,0xDB}, {0xF6,0xDC}, {0xF7,0xD5},
    {0xF8,0xA7}, {0x93,0x54}, {0xA4,0x6C}, {0xA4,0x6D},
    {0xA4,0x6E}, {0xA4,0xD5}, {0xA5,0xA5}, {0xC9,0xD3},
    {0xA6,0x72}, {0xA6,0x73}, {0xA7,0xB7}, {0xA7,0xB8},
    {0xA7,0xB6}, {0xA7,0xB5}, {0xA9,0x73}, {0xCC,0x55},
    {0xA9,0x75}, {0xA9,0x74}, {0xCC,0x56}, {0x89,0x61},
    {0x8B,0xB4}, {0xAB,0xC4}, {0xAE,0x5D}, {0xD1,0x65},
    {0x9D,0xC0}, {0xD4,0xF0}, {0xB1,0x45}, {0xB4,0x47},
    {0xD4,0xEF}, {0xB4,0x46}, {0x8E,0x48}, {0xB9,0xE5},
    {0xFB,0xC5}, {0xE1,0x7D}, {0xBE,0xC7}, {0xC0,0xA9},
    {0xEC,0xD7}, {0xFB,0xC7}, {0xC4,0x5E}, {0xC5,0x70},
    {0xC6,0xCB}, {0xC9,0x72}, {0xFA,0x79}, {0xA5,0xA6},
    {0xC9,0x73}, {0xA6,0x76}, {0xA6,0x74}, {0xA6,0x75},
    {0xA6,0x77}, {0xA7,0xBA}, {0xA7,0xB9}, {0xCA,0xBC},
    {0xA7,0xBB}, {0x9E,0x67}, {0xCA,0xBD}, {0xCC,0x57},
    {0xCC,0x58}, {0x8C,0xD9}, {0xA9,0x76}, {0xA9,0x78},
    {0xA9,0x7A}, {0xA9,0x77}, {0xA9,0x7B}, {0xA9,0x79},
    {0xFB,0xD2}, {0x89,0x62}, {0x89,0x63}, {0xAB,0xC8},
    {0xAB,0xC5}, {0xAB,0xC7}, {0xAB,0xC9}, {0xAB,0xC6},
    {0xD1,0x66}, {0xCE,0x77}, {0xFC,0x7D}, {0xD1,0x68},
    {0xD1,0x67}, {0xAE,0x63}, {0xAE,0x5F}, {0xAE,0x60},
    {0xAE,0x62}, {0xAE,0x64}, {0xAE,0x61}, {0xAE,0x66},
    {0xAE,0x65}, {0xB1,0x4A}, {0xD4,0xF2}, {0xD4,0xF1},
    {0xB1,0x49}, {0x9F,0x6B}, {0xB1,0x48}, {0xB1,0x47},
    {0xB1,0x4B}, {0xB1,0x46}, {0xD8,0xD5}, {0xD8,0xD2},
    {0xB4,0x49}, {0xD8,0xD1}, {0xD8,0xD6}, {0xB4,0x4B},
    {0xD8,0xD4}, {0xB4,0x48}, {0xB4,0x4A}, {0xD8,0xD3},
    {0xFB,0xCC}, {0xDD,0x48}, {0xFE,0xAE}, {0xDD,0x49},
    {0xDD,0x4A}, {0xB9,0xE6}, {0xB9,0xEE}, {0xE1,0x7E},
    {0xB9,0xE8}, {0xB9,0xEC}, {0xE1,0xA1}, {0xB9,0xED},
    {0xB9,0xE9}, {0xB9,0xEA}, {0xB9,0xE7}, {0xB9,0xEB},
    {0xBC,0x66}, {0xD8,0xD0}, {0xBC,0x67}, {0xBC,0x65},
    {0xBC,0x64}, {0xE9,0x5D}, {0xBE,0xC8}, {0xEC,0xD8},
    {0xEC,0xD9}, {0xFB,0xD1}, {0xC3,0x64}, {0xC4,0x5F},
    {0xA4,0x6F}, {0xA6,0x78}, {0xFB,0x75}, {0xAB,0xCA},
    {0xD1,0x69}, {0xAE,0x67}, {0xFB,0xD4}, {0xB1,0x4E},
    {0xB1,0x4D}, {0xB1,0x4C}, {0xB4,0x4C}, {0xB4,0x4D},
    {0xD8,0xD7}, {0xB9,0xEF}, {0xBE,0xC9}, {0xA4,0x70},
    {0xC9,0x5C}, {0xA4,0xD6}, {0xC9,0x74}, {0xFB,0xD6},
    {0xFB,0xD8}, {0xC9,0xD4}, {0xA6,0x79}, {0xA9,0x7C},
    {0x8B,0x5D}, {0x93,0x4C}, {0xDD,0x4B}, {0x9A,0xE2},
    {0xA4,0x71}, {0x8B,0xC9}, {0xA4,0xD7}, {0xC9,0xD5},
    {0xCA,0xBE}, {0xCA,0xBF}, {0xA7,0xBC}, {0xD8,0xD8},
    {0xB4,0x4E}, {0xDD,0x4C}, {0xC0,0xAA}, {0xA4,0x72},
    {0xA4,0xA8}, {0xA4,0xD8}, {0xC9,0x75}, {0xA5,0xA7},
    {0xA7,0xC0}, {0xA7,0xBF}, {0xA7,0xBD}, {0xA7,0xBE},
    {0xCC,0x59}, {0xA9,0x7E}, {0xA9,0xA1}, {0xCC,0x5A},
    {0xA9,0x7D}, {0xFB,0xDB}, {0x9F,0xC9}, {0xAB,0xCE},
    {0xCE,0x78}, {0xAB,0xCD}, {0xAB,0xCB}, {0xAB,0xCC},
    {0xAE,0x6A}, {0xAE,0x68}, {0x9F,0x44}, {0xD1,0x6B},
    {0xAE,0x69}, {0xD1,0x6A}, {0xAE,0x5E}, {0xD4,0xF3},
    {0xB1,0x50}, {0xB1,0x51}, {0x98,0xED}, {0xB1,0x4F},
    {0xB9,0xF0}, {0xE1,0xA2}, {0xBC,0x68}, {0xBC,0x69},
    {0xE5,0x61}, {0xC0,0xAB}, {0xEF,0xC2}, {0xEF,0xC3},
    {0xC4,0xDD}, {0xF8,0xA8}, {0xC9,0x4B}, {0xA4,0xD9},
    {0xA4,0x73}, {0xC9,0x77}, {0xC9,0x76}, {0xA6,0x7A},
    {0xC9,0xD7}, {0xC9,0xD8}, {0xC9,0xD6}, {0xC9,0xD9},
    {0xFB,0xDD}, {0xCA,0xC7}, {0xCA,0xC2}, {0xCA,0xC4},
    {0xCA,0xC6}, {0xCA,0xC3}, {0xA7,0xC4}, {0xCA,0xC0},
    {0xCA,0xC1}, {0xA7,0xC1}, {0xA7,0xC2}, {0xCA,0xC5},
    {0xCA,0xC8}, {0xA7,0xC3}, {0xCA,0xC9}, {0x8D,0xF2},
    {0x89,0x64}, {0xFD,0xF2}, {0xCC,0x68}, {0x93,0x4D},
    {0xCC,0x62}, {0xCC,0x5D}, {0xA9,0xA3}, {0xCC,0x65},
    {0xCC,0x63}, {0xCC,0x5C}, {0xCC,0x69}, {0xCC,0x6C},
    {0xCC,0x67}, {0xCC,0x60}, {0xA9,0xA5}, {0xCC,0x66},
    {0xA9,0xA6}, {0xCC,0x61}, {0xCC,0x64}, {0xCC,0x5B},
    {0xCC,0x5F}, {0xCC,0x6B}, {0xA9,0xA7}, {0xA9,0xA8},
    {0xCC,0x5E}, {0xCC,0x6A}, {0xA9,0xA2}, {0xA9,0xA4},
    {0xFB,0xE7}, {0xA0,0xF2}, {0x98,0x68}, {0xCE,0xAB},
    {0xCE,0xA4}, {0xCE,0xAA}, {0xCE,0xA3}, {0xCE,0xA5},
    {0xCE,0x7D}, {0xCE,0x7B}, {0xCE,0xAC}, {0xCE,0xA9},
    {0xCE,0x79}, {0x9F,0x58}, {0xAB,0xD0}, {0xCE,0xA7},
    {0xCE,0xA8}, {0xCE,0xA6}, {0xCE,0x7C}, {0xCE,0x7A},
    {0xAB,0xCF}, {0xCE,0xA2}, {0xCE,0x7E}, {0xCE,0xA1},
    {0xCE,0xAD}, {0x8D,0x73}, {0xAE,0x6F}, {0xFB,0xDE},
    {0xAE,0x6E}, {0xD1,0x6C}, {0xAE,0x6B}, {0xD1,0x6E},
    {0xFB,0xDF}, {0xAE,0x70}, {0xD1,0x6F}, {0xAE,0x73},
    {0x8C,0x48}, {0xAE,0x71}, {0xD1,0x70}, {0xCE,0xAE},
    {0xD1,0x72}, {0xAE,0x6D}, {0xAE,0x6C}, {0xD1,0x6D},
    {0xD1,0x71}, {0xAE,0x72}, {0xB1,0x53}, {0xB1,0x52},
    {0xD4,0xF5}, {0xD4,0xF9}, {0xD4,0xFB}, {0xB1,0x54},
    {0xD4,0xFE}, {0xFB,0xE3}, {0xB1,0x58}, {0xD5,0x41},
    {0xB1,0x5A}, {0x8D,0xA8}, {0xB1,0x56}, {0xB1,0x5E},
    {0xFB,0xE4}, {0xB1,0x5B}, {0xD4,0xF7}, {0xB1,0x55},
    {0xD4,0xF6}, {0xD4,0xF4}, {0xD5,0x43}, {0xD4,0xF8},
    {0xB1,0x57}, {0xD5,0x42}, {0xB1,0x5C}, {0xD4,0xFD},
    {0xD4,0xFC}, {0xB1,0x5D}, {0xD4,0xFA}, {0xB1,0x59},
    {0x9C,0x75}, {0xD5,0x44}, {0x98,0x78}, {0xD5,0x40},
    {0xD8,0xE7}, {0xD8,0xEE}, {0xD8,0xE3}, {0xB4,0x51},
    {0xD8,0xDF}, {0xD8,0xEF}, {0xD8,0xD9}, {0xD8,0xEC},
    {0xD8,0xEA}, {0xD8,0xE4}, {0xD8,0xED}, {0xD8,0xE6},
    {0x8D,0x60}, {0xD8,0xDE}, {0xD8,0xF0}, {0xD8,0xDC},
    {0xD8,0xE9}, {0xD8,0xDA}, {0xD8,0xF1}, {0xFB,0xE5},
    {0xB4,0x52}, {0x8D,0x61}, {0xD8,0xEB}, {0xDD,0x4F},
    {0xD8,0xDD}, {0xB4,0x4F}, {0xD8,0xE1}, {0xB4,0x50},
    {0xD8,0xE0}, {0xD8,0xE5}, {0xD8,0xE2}, {0x8D,0x62},
    {0xA0,0xA1}, {0xD8,0xE8}, {0x9C,0x40}, {0xDD,0x53},
    {0xDD,0x56}, {0xDD,0x4E}, {0xDD,0x50}, {0xDD,0x55},
    {0xDD,0x54}, {0xB7,0x43}, {0xD8,0xDB}, {0xDD,0x52},
    {0xB7,0x44}, {0x98,0xAD}, {0xDD,0x4D}, {0xDD,0x51},
    {0x9E,0xEA}, {0xE1,0xA9}, {0xE1,0xB0}, {0xE1,0xA7},
    {0x8C,0xD4}, {0xE1,0xAE}, {0xE1,0xA5}, {0xE1,0xAD},
    {0xE1,0xB1}, {0xE1,0xA4}, {0xE1,0xA8}, {0xE1,0xA3},
    {0xB9,0xF1}, {0x9C,0xEB}, {0xE1,0xA6}, {0xB9,0xF2},
    {0xE1,0xAC}, {0xE1,0xAB}, {0xE1,0xAA}, {0xFB,0xE0},
    {0xE1,0xAF}, {0x9F,0x51}, {0xE5,0x65}, {0xE5,0x67},
    {0xBC,0x6B}, {0xE5,0x68}, {0xE5,0x63}, {0xE5,0x62},
    {0xE5,0x6C}, {0xE5,0x6A}, {0xBC,0x6A}, {0xE5,0x6D},
    {0xE5,0x64}, {0xE5,0x69}, {0xE5,0x6B}, {0xE5,0x66},
    {0x8D,0x65}, {0xE9,0x61}, {0xE9,0x66}, {0xE9,0x60},
    {0xE9,0x65}, {0x9C,0xF1}, {0xE9,0x5E}, {0xE9,0x68},
    {0xE9,0x64}, {0xE9,0x69}, {0xE9,0x63}, {0xE9,0x5F},
    {0xE9,0x67}, {0xE9,0x6A}, {0xE9,0x62}, {0xFC,0x58},
    {0xEC,0xDA}, {0xC0,0xAF}, {0x8D,0x66}, {0xC0,0xAD},
    {0xC0,0xAC}, {0xC0,0xAE}, {0xEF,0xC4}, {0x96,0x54},
    {0xF1,0x72}, {0xF1,0xFD}, {0xF4,0x44}, {0xF4,0x45},
    {0xC4,0x60}, {0xF5,0xC9}, {0xC4,0xDE}, {0xF5,0xCA},
    {0xF6,0xDE}, {0xC5,0x72}, {0xC5,0x71}, {0xF6,0xDD},
    {0xC5,0xC9}, {0xFB,0xE8}, {0xF7,0xD6}, {0xC6,0xCC},
    {0xA4,0x74}, {0xA6,0x7B}, {0xC9,0xDA}, {0xCA,0xCA},
    {0xA8,0xB5}, {0xB1,0x5F}, {0xA4,0x75}, {0xA5,0xAA},
    {0xA5,0xA9}, {0xA5,0xA8}, {0xA7,0xC5}, {0xAE,0x74},
    {0xDD,0x57}, {0xA4,0x76}, {0xA4,0x77}, {0xA4,0x78},
    {0xA4,0xDA}, {0x9F,0xCE}, {0xAB,0xD1}, {0xCE,0xAF},
    {0xB4,0x53}, {0xA4,0x79}, {0xC9,0x5D}, {0xA5,0xAB},
    {0xA5,0xAC}, {0xC9,0x78}, {0xA6,0x7C}, {0xFB,0xFC},
    {0xCA,0xCB}, {0x9A,0xE4}, {0xA7,0xC6}, {0xCA,0xCC},
    {0xA9,0xAE}, {0x9F,0x75}, {0xCC,0x6E}, {0xA9,0xAC},
    {0xA9,0xAB}, {0xCC,0x6D}, {0xA9,0xA9}, {0xCC,0x6F},
    {0xA9,0xAA}, {0xA9,0xAD}, {0xAB,0xD2}, {0xAB,0xD4},
    {0xCE,0xB3}, {0xCE,0xB0}, {0xCE,0xB1}, {0xCE,0xB2},
    {0xCE,0xB4}, {0xAB,0xD3}, {0xD1,0x74}, {0xD1,0x73},
    {0xAE,0x76}, {0xAE,0x75}, {0xFB,0xF1}, {0xB1,0x62},
    {0xD5,0x46}, {0xB1,0x61}, {0xB1,0x63}, {0xB1,0x60},
    {0xB4,0x55}, {0xD5,0x45}, {0xB4,0x56}, {0xD8,0xF3},
    {0x8D,0x69}, {0xB4,0x57}, {0xD8,0xF2}, {0xB4,0x54},
    {0x93,0x4F}, {0xDD,0x5A}, {0xDD,0x5C}, {0xB7,0x45},
    {0xDD,0x5B}, {0xDD,0x59}, {0xDD,0x58}, {0xE1,0xB4},
    {0xB9,0xF7}, {0xB9,0xF5}, {0xB9,0xF6}, {0xE1,0xB2},
    {0xE1,0xB3}, {0xB9,0xF3}, {0xE5,0x71}, {0xE5,0x6F},
    {0x93,0x4E}, {0xBC,0x6D}, {0xE5,0x70}, {0xBC,0x6E},
    {0xBC,0x6C}, {0xB9,0xF4}, {0xE9,0x6D}, {0xE9,0x6B},
    {0xE9,0x6C}, {0xE5,0x6E}, {0xEC,0xDC}, {0xC0,0xB0},
    {0xEC,0xDB}, {0xEF,0xC5}, {0xEF,0xC6}, {0xE9,0x6E},
    {0xF1,0xFE}, {0xA4,0x7A}, {0xA5,0xAD}, {0xA6,0x7E},
    {0xC9,0xDB}, {0xA6,0x7D}, {0xA9,0xAF}, {0xB7,0x46},
    {0xFB,0xF4}, {0xA4,0xDB}, {0xA5,0xAE}, {0xAB,0xD5},
    {0xB4,0x58}, {0xC6,0xCE}, {0xC9,0x79}, {0xC9,0x7A},
    {0xFB,0xC3}, {0xC9,0xDC}, {0x89,0x65}, {0xA7,0xC8},
    {0xCA,0xD0}, {0xCA,0xCE}, {0xA7,0xC9}, {0xCA,0xCD},
    {0xCA,0xCF}, {0xCA,0xD1}, {0xA7,0xC7}, {0x8C,0x7A},
    {0xA9,0xB3}, {0xA9,0xB4}, {0xA9,0xB1}, {0x8C,0x7B},
    {0xA9,0xB0}, {0xCE,0xB8}, {0xA9,0xB2}, {0xAB,0xD6},
    {0xCE,0xB7}, {0xCE,0xB9}, {0xCE,0xB6}, {0xCE,0xBA},
    {0xAB,0xD7}, {0xAE,0x79}, {0xD1,0x75}, {0xD1,0x77},
    {0xAE,0x77}, {0xD1,0x78}, {0xAE,0x78}, {0xD1,0x76},
    {0xCE,0xB5}, {0xD5,0x47}, {0xD5,0x4A}, {0xD5,0x4B},
    {0xD5,0x48}, {0xB1,0x67}, {0xB1,0x66}, {0xB1,0x64},
    {0xB1,0x65}, {0xD5,0x49}, {0x8D,0x6A}, {0xB1,0x68},
    {0xB4,0x5A}, {0xB4,0x5B}, {0xB4,0x5C}, {0xDD,0x5D},
    {0xDD,0x5F}, {0xDD,0x61}, {0xB7,0x48}, {0xB7,0x47},
    {0xB4,0x59}, {0xDD,0x60}, {0xDD,0x5E}, {0x93,0x53},
    {0xE1,0xB8}, {0x9D,0xFB}, {0xE1,0xB6}, {0xE1,0xBC},
    {0xB9,0xF8}, {0xE1,0xBD}, {0xE1,0xBA}, {0xB9,0xF9},
    {0xE1,0xB7}, {0xE1,0xB5}, {0xE1,0xBB}, {0xBC,0x70},
    {0xE5,0x73}, {0xE1,0xB9}, {0xBC,0x72}, {0xE5,0x74},
    {0xBC,0x71}, {0xBC,0x74}, {0xE5,0x75}, {0xBC,0x6F},
    {0xBC,0x73}, {0xE9,0x73}, {0xE9,0x71}, {0xE9,0x70},
    {0xE9,0x72}, {0xE9,0x6F}, {0xC3,0x66}, {0xF4,0x46},
    {0xF4,0x47}, {0xF5,0xCB}, {0xF6,0xDF}, {0xC6,0x55},
    {0xFB,0xFD}, {0xA9,0xB5}, {0xA7,0xCA}, {0x90,0x59},
    {0xFC,0x40}, {0xAB,0xD8}, {0xFC,0x41}, {0xFC,0x43},
    {0xA4,0x7B}, {0xA4,0xDC}, {0xA5,0xAF}, {0xC9,0xDD},
    {0xA7,0xCB}, {0xCA,0xD2}, {0xCE,0xBB}, {0xAB,0xD9},
    {0xB9,0xFA}, {0xA4,0x7C}, {0x93,0x61}, {0xFC,0x46},
    {0x93,0x62}, {0xA6,0xA1}, {0xB7,0x49}, {0xA4,0x7D},
    {0xA4,0xDD}, {0xA4,0xDE}, {0xA5,0xB1}, {0xA5,0xB0},
    {0xC9,0xDE}, {0xA6,0xA2}, {0xCA,0xD3}, {0xA7,0xCC},
    {0xCC,0x71}, {0xCC,0x72}, {0xCC,0x73}, {0x8D,0x6B},
    {0xA9,0xB6}, {0xA9,0xB7}, {0xCC,0x70}, {0xA9,0xB8},
    {0xAB,0xDA}, {0xCE,0xBC}, {0xD1,0x7A}, {0xAE,0x7A},
    {0xD1,0x79}, {0xB1,0x69}, {0xD5,0x4C}, {0xB1,0x6A},
    {0xD5,0x4D}, {0xFC,0x4C}, {0xB4,0x5D}, {0xDD,0x62},
    {0xE1,0xBF}, {0xE1,0xBE}, {0xB9,0xFB}, {0xBC,0x75},
    {0xE5,0x76}, {0xBE,0xCA}, {0xE9,0x74}, {0xC0,0xB1},
    {0x95,0xB8}, {0xC5,0x73}, {0xF7,0xD8}, {0xC6,0xD0},
    {0x8B,0xCA}, {0xCC,0x74}, {0xCE,0xBD}, {0xB1,0x6B},
    {0xD8,0xF4}, {0xB7,0x4A}, {0x98,0x7A}, {0xC2,0x55},
    {0xC6,0xD1}, {0xA7,0xCE}, {0xFC,0x51}, {0xA7,0xCD},
    {0xAB,0xDB}, {0xD1,0x7B}, {0xB1,0x6D}, {0xB3,0x43},
    {0xB1,0x6E}, {0xB1,0x6C}, {0xB4,0x5E}, {0xE1,0xC0},
    {0xB9,0xFC}, {0xBC,0x76}, {0xFC,0x54}, {0xC9,0x4C},
    {0xC9,0xDF}, {0xCA,0xD5}, {0xA7,0xCF}, {0xCA,0xD4},
    {0xA7,0xD0}, {0xFA,0xAF}, {0xA9,0xBC}, {0xCC,0x77},
    {0xCC,0x76}, {0xA9,0xBB}, {0xA9,0xB9}, {0xA9,0xBA},
    {0xCC,0x75}, {0x8D,0x6C}, {0xAB,0xDD}, {0xCE,0xBE},
    {0xAB,0xE0}, {0xAB,0xDC}, {0xAB,0xE2}, {0xAB,0xDE},
    {0xAB,0xDF}, {0xAB,0xE1}, {0xAE,0x7D}, {0xAE,0x7C},
    {0xAE,0x7B}, {0xD5,0x4F}, {0xB1,0x6F}, {0xB1,0x72},
    {0xB1,0x70}, {0xD5,0x4E}, {0xB1,0x75}, {0xB1,0x71},
    {0xD5,0x50}, {0xB1,0x74}, {0xB1,0x73}, {0xFA,0x61},
    {0xD8,0xF6}, {0xD8,0xF5}, {0xFC,0x57}, {0xB4,0x61},
    {0xB4,0x5F}, {0xB4,0x60}, {0xD8,0xF7}, {0xB7,0x4B},
    {0xDD,0x64}, {0xB7,0x4C}, {0xDD,0x63}, {0x9B,0x70},
    {0xE5,0x77}, {0xBC,0x78}, {0xE1,0xC1}, {0xBC,0x77},
    {0xB9,0xFD}, {0xA0,0x51}, {0xEC,0xDE}, {0xE9,0x75},
    {0xC0,0xB2}, {0xEC,0xDD}, {0xF2,0x40}, {0xF4,0x48},
    {0xF4,0x49}, {0x8C,0x7C}, {0xA4,0xDF}, {0x8B,0xCB},
    {0xA5,0xB2}, {0xC9,0x7B}, {0xA7,0xD2}, {0xA7,0xD4},
    {0xC9,0xE2}, {0xCA,0xD8}, {0xCA,0xD7}, {0xCA,0xD6},
    {0xC9,0xE1}, {0xC9,0xE0}, {0xA6,0xA4}, {0xA7,0xD3},
    {0xA7,0xD1}, {0xA6,0xA3}, {0x93,0x6E}, {0xA9,0xBD},
    {0xCC,0x78}, {0xFC,0xD5}, {0xA9,0xBE}, {0xCA,0xDD},
    {0xCA,0xDF}, {0xCA,0xDE}, {0xCC,0x79}, {0xCA,0xDA},
    {0xA7,0xD8}, {0xA7,0xD6}, {0xCA,0xD9}, {0xCA,0xDB},
    {0xCA,0xE1}, {0xA7,0xD5}, {0xCA,0xDC}, {0xCA,0xE5},
    {0xA9,0xC0}, {0xCA,0xE2}, {0xA7,0xD7}, {0xCA,0xE0},
    {0xCA,0xE3}, {0xA9,0xBF}, {0xA9,0xC1}, {0xCA,0xE4},
    {0xCC,0xAF}, {0xCC,0xA2}, {0xCC,0x7E}, {0xCC,0xAE},
    {0xCC,0xA9}, {0xAB,0xE7}, {0xA9,0xC2}, {0xCC,0xAA},
    {0xCC,0xAD}, {0xAB,0xE3}, {0xCC,0xAC}, {0xA9,0xC3},
    {0xA9,0xC8}, {0xA9,0xC6}, {0xCC,0xA3}, {0xCC,0x7C},
    {0xCC,0xA5}, {0xA9,0xCD}, {0xCC,0xB0}, {0xAB,0xE4},
    {0xCC,0xA6}, {0xAB,0xE5}, {0xA9,0xC9}, {0xCC,0xA8},
    {0xFC,0xA9}, {0xCE,0xCD}, {0xAB,0xE6}, {0xCC,0x7B},
    {0xA9,0xCA}, {0xAB,0xE8}, {0xA9,0xCB}, {0xA9,0xC7},
    {0xA9,0xCC}, {0xCC,0xA7}, {0xCC,0x7A}, {0xCC,0xAB},
    {0xA9,0xC4}, {0xFC,0x61}, {0xCC,0x7D}, {0xCC,0xA4},
    {0xCC,0xA1}, {0xA9,0xC5}, {0xCE,0xBF}, {0xCE,0xC0},
    {0x89,0x66}, {0xCE,0xCA}, {0xD1,0xA1}, {0xCE,0xCB},
    {0xAB,0xEE}, {0xCE,0xCE}, {0xCE,0xC4}, {0xAB,0xED},
    {0xCE,0xC6}, {0xCE,0xC7}, {0xFA,0xCB}, {0xCE,0xC9},
    {0xAB,0xE9}, {0xAE,0xA3}, {0xF9,0xDA}, {0xCE,0xC5},
    {0xCE,0xC1}, {0xAE,0xA4}, {0xCE,0xCF}, {0xAE,0x7E},
    {0xD1,0x7D}, {0xCE,0xC8}, {0xD1,0x7C}, {0xCE,0xC3},
    {0xCE,0xCC}, {0xAB,0xEC}, {0xAE,0xA1}, {0xAB,0xF2},
    {0xAE,0xA2}, {0xCE,0xD0}, {0xD1,0x7E}, {0xAB,0xEB},
    {0xAE,0xA6}, {0xAB,0xF1}, {0xAB,0xF0}, {0xAB,0xEF},
    {0xAE,0xA5}, {0xCE,0xD1}, {0xAE,0xA7}, {0xAB,0xEA},
    {0xCE,0xC2}, {0x93,0x7A}, {0xA0,0xE0}, {0x93,0x6B},
    {0xB1,0x76}, {0xD1,0xA4}, {0xD1,0xA6}, {0xD1,0xA8},
    {0xAE,0xA8}, {0xAE,0xAE}, {0xD5,0x53}, {0xD1,0xAC},
    {0xD1,0xA3}, {0xB1,0x78}, {0xD5,0x51}, {0xAE,0xAD},
    {0xAE,0xAB}, {0xD1,0xAE}, {0xD5,0x52}, {0xD1,0xA5},
    {0xAE,0xAC}, {0xD1,0xA9}, {0xAE,0xAF}, {0xD1,0xAB},
    {0xAE,0xAA}, {0xD1,0xAA}, {0xD1,0xAD}, {0xD1,0xA7},
    {0xFC,0x6B}, {0xAE,0xA9}, {0xB1,0x79}, {0xD1,0xA2},
    {0xB1,0x77}, {0xA0,0xDC}, {0x94,0x68}, {0xB1,0x7A},
    {0xD5,0x55}, {0xD5,0x5E}, {0xB4,0x64}, {0xFC,0x6D},
    {0xB1,0x7C}, {0xB1,0xA3}, {0xB4,0x65}, {0xD5,0x60},
    {0xB1,0xAA}, {0xD8,0xF9}, {0xD5,0x56}, {0xB1,0xA2},
    {0xB1,0xA5}, {0xB1,0x7E}, {0xD5,0x54}, {0xD5,0x62},
    {0xD5,0x65}, {0xD9,0x49}, {0xD5,0x63}, {0xD8,0xFD},
    {0xB1,0xA1}, {0xB1,0xA8}, {0xB1,0xAC}, {0xD5,0x5D},
    {0xD8,0xF8}, {0xD5,0x61}, {0xB1,0x7B}, {0xD8,0xFA},
    {0xD5,0x64}, {0xD8,0xFC}, {0xD5,0x59}, {0xB4,0x62},
    {0xD5,0x57}, {0xD5,0x58}, {0xB1,0xA7}, {0x8D,0x71},
    {0xB1,0xA6}, {0xD5,0x5B}, {0xB1,0xAB}, {0xD5,0x5F},
    {0xB1,0xA4}, {0xD5,0x5C}, {0xFD,0x64}, {0xB1,0xA9},
    {0xB4,0x66}, {0xB4,0x63}, {0xD8,0xFB}, {0x99,0xBA},
    {0xD5,0x5A}, {0xB1,0x7D}, {0x9A,0xD0}, {0x9A,0x61},
    {0xA0,0xE5}, {0xB4,0x6B}, {0xB4,0x6F}, {0xD9,0x40},
    {0xB7,0x51}, {0xB4,0x6D}, {0xD9,0x44}, {0xB4,0x71},
    {0xDD,0x65}, {0xD9,0x46}, {0xB7,0x53}, {0xB4,0x69},
    {0xB4,0x6C}, {0xD9,0x47}, {0xA0,0x5B}, {0xD9,0x48},
    {0xD9,0x4E}, {0xB4,0x73}, {0xB7,0x54}, {0xD9,0x4A},
    {0xD9,0x4F}, {0xD9,0x43}, {0xB7,0x5E}, {0x96,0xAC},
    {0xB7,0x55}, {0xB4,0x72}, {0xD9,0x41}, {0xD9,0x50},
    {0x97,0x40}, {0xB7,0x5D}, {0xB4,0x70}, {0xB7,0x4E},
    {0xD9,0x4D}, {0xB4,0x74}, {0xD9,0x45}, {0xD8,0xFE},
    {0xB4,0x6A}, {0xD9,0x42}, {0xD9,0x4B}, {0x9E,0xF1},
    {0xB7,0x4D}, {0xB7,0x52}, {0xB4,0x67}, {0xD9,0x4C},
    {0xB7,0x50}, {0x8C,0x4D}, {0xB4,0x68}, {0xB7,0x5C},
    {0xE1,0xC3}, {0xDD,0x70}, {0xDD,0x68}, {0xE1,0xC2},
    {0xDD,0x6C}, {0xDD,0x6E}, {0x9F,0x7E}, {0xDD,0x6B},
    {0xB7,0x5B}, {0xDD,0x6A}, {0xB7,0x5F}, {0xE1,0xD2},
    {0x8D,0x72}, {0xB7,0x5A}, {0xBA,0x40}, {0xDD,0x71},
    {0xE1,0xC4}, {0xFC,0x76}, {0xB7,0x58}, {0xDD,0x69},
    {0xDD,0x6D}, {0xB9,0xFE}, {0xB7,0x4F}, {0xDD,0x66},
    {0xDD,0x67}, {0xBA,0x41}, {0xB7,0x57}, {0xB7,0x59},
    {0xB7,0x56}, {0xDD,0x6F}, {0x96,0xA9}, {0xE1,0xC8},
    {0xE1,0xC9}, {0xE1,0xCE}, {0xBC,0x7D}, {0xE1,0xD5},
    {0xBA,0x47}, {0xA0,0x6E}, {0xBA,0x46}, {0xE1,0xD0},
    {0xFC,0xAA}, {0xBC,0x7C}, {0xE1,0xC5}, {0xBA,0x45},
    {0xFB,0xCD}, {0xE1,0xD4}, {0xBA,0x43}, {0xBA,0x44},
    {0xFC,0x74}, {0xE1,0xD1}, {0xE5,0xAA}, {0xBC,0x7A},
    {0xB4,0x6E}, {0xE1,0xD3}, {0xBC,0xA3}, {0xE1,0xCB},
    {0xBC,0x7B}, {0xA0,0x74}, {0xBC,0xA2}, {0xE1,0xC6},
    {0xE1,0xCA}, {0xE1,0xC7}, {0xE1,0xCD}, {0xBA,0x48},
    {0xBC,0x79}, {0xBA,0x42}, {0xE5,0x7A}, {0xE1,0xCF},
    {0xBC,0xA1}, {0xA0,0x71}, {0xBC,0xA4}, {0xE1,0xCC},
    {0xFC,0x79}, {0xBC,0x7E}, {0xE5,0x79}, {0xFC,0x7C},
    {0xE5,0x7E}, {0xBE,0xCE}, {0xE5,0x78}, {0xE9,0xA3},
    {0xE5,0xA9}, {0xBC,0xA8}, {0xBC,0xA6}, {0xBE,0xCC},
    {0xE5,0xA6}, {0xE5,0xA2}, {0xBC,0xAC}, {0x9C,0x50},
    {0xE9,0x78}, {0x93,0x79}, {0x93,0x78}, {0xBC,0xAA},
    {0xE5,0xA1}, {0xA0,0xDD}, {0xE9,0x76}, {0xE5,0xA5},
    {0xE5,0xA8}, {0xE5,0x7D}, {0xBC,0xAB}, {0xBC,0xA5},
    {0xE9,0x77}, {0xBE,0xCD}, {0xE5,0xA7}, {0xBC,0xA7},
    {0xBC,0xA9}, {0xE5,0xA4}, {0xBC,0xAD}, {0xE5,0xA3},
    {0xE5,0x7C}, {0xE5,0x7B}, {0xBE,0xCB}, {0xE5,0xAB},
    {0xE9,0x7A}, {0xEC,0xE0}, {0xBE,0xD0}, {0x8D,0x75},
    {0xE9,0xA2}, {0x8D,0x76}, {0xE9,0x7E}, {0xEC,0xE1},
    {0xBE,0xD1}, {0xE9,0xA1}, {0x93,0x74}, {0xE9,0x7C},
    {0xC0,0xB4}, {0xEC,0xDF}, {0xE9,0x79}, {0xE9,0x7B},
    {0xC0,0xB5}, {0xBE,0xD3}, {0xC0,0xB3}, {0xBE,0xD2},
    {0xC0,0xB7}, {0xE9,0x7D}, {0xBE,0xCF}, {0x8D,0x77},
    {0xFC,0xA5}, {0xFC,0xA2}, {0xEF,0xCF}, {0xEF,0xC7},
    {0x90,0xC3}, {0xEC,0xE7}, {0xEF,0xC8}, {0xEC,0xE3},
    {0xA0,0x79}, {0xC2,0x56}, {0xEC,0xE5}, {0xEC,0xE4},
    {0xC0,0xB6}, {0xEC,0xE2}, {0xEC,0xE6}, {0xEF,0xD0},
    {0xEF,0xCC}, {0xEF,0xCE}, {0xEF,0xC9}, {0xEF,0xCA},
    {0xEF,0xCD}, {0xEF,0xCB}, {0xC3,0x67}, {0xC3,0x6A},
    {0xC3,0x69}, {0xC3,0x68}, {0xC4,0x61}, {0xF4,0x4A},
    {0xC4,0x62}, {0xF2,0x41}, {0xC4,0xDF}, {0xF5,0xCC},
    {0xC4,0xE0}, {0xC5,0x74}, {0xC5,0xCA}, {0xF7,0xD9},
    {0xF7,0xDA}, {0xF7,0xDB}, {0xF9,0xBA}, {0xA4,0xE0},
    {0xC9,0x7C}, {0xA5,0xB3}, {0xA6,0xA6}, {0xA6,0xA7},
    {0xA6,0xA5}, {0xA6,0xA8}, {0xA7,0xDA}, {0xA7,0xD9},
    {0xCC,0xB1}, {0xA9,0xCF}, {0xA9,0xCE}, {0xD1,0xAF},
    {0xB1,0xAD}, {0xB1,0xAE}, {0xB4,0x75}, {0xDD,0x72},
    {0xB7,0x60}, {0xB7,0x61}, {0xDD,0x74}, {0xDD,0x76},
    {0xDD,0x75}, {0xE1,0xD7}, {0xE1,0xD6}, {0xBA,0x49},
    {0xE1,0xD8}, {0x8D,0x79}, {0xE5,0xAC}, {0xBC,0xAE},
    {0xBE,0xD4}, {0xC0,0xB8}, {0xC2,0x57}, {0xC0,0xB9},
    {0xA4,0xE1}, {0x8B,0xFC}, {0xA0,0x76}, {0xCA,0xE6},
    {0xCC,0xB2}, {0xA9,0xD1}, {0xA9,0xD0}, {0xA9,0xD2},
    {0xAB,0xF3}, {0xCE,0xD2}, {0xCE,0xD3}, {0xD1,0xB0},
    {0xAE,0xB0}, {0xB1,0xAF}, {0xB4,0x76}, {0xD9,0x51},
    {0xA4,0xE2}, {0x8B,0xCD}, {0xA4,0x7E}, {0xA4,0xE3},
    {0xC9,0x7D}, {0xA5,0xB7}, {0xA5,0xB6}, {0xA5,0xB4},
    {0xA5,0xB5}, {0xA6,0xAB}, {0xC9,0xE9}, {0xC9,0xEB},
    {0xA6,0xAA}, {0xC9,0xE3}, {0xC9,0xE4}, {0xC9,0xEA},
    {0xC9,0xE6}, {0xC9,0xE8}, {0xA6,0xA9}, {0xC9,0xE5},
    {0xC9,0xEC}, {0xC9,0xE7}, {0x9F,0x5A}, {0xA7,0xE1},
    {0xA7,0xEA}, {0xA7,0xE8}, {0xCA,0xF0}, {0xCA,0xED},
    {0xCA,0xF5}, {0xA7,0xE6}, {0xCA,0xF6}, {0xA7,0xDF},
    {0xCA,0xF3}, {0xA7,0xE5}, {0xCA,0xEF}, {0xCA,0xEE},
    {0xA7,0xE3}, {0xCA,0xF4}, {0xA7,0xE4}, {0xA9,0xD3},
    {0xA7,0xDE}, {0xCA,0xF1}, {0x9F,0xF4}, {0xCA,0xE7},
    {0xA7,0xDB}, {0x9F,0xBA}, {0xA7,0xEE}, {0xCA,0xEC},
    {0xCA,0xF2}, {0xA7,0xE0}, {0xA7,0xE2}, {0xCA,0xE8},
    {0xCA,0xE9}, {0xCA,0xEA}, {0x8D,0x7A}, {0xA7,0xED},
    {0xA7,0xE7}, {0xA7,0xEC}, {0xCA,0xEB}, {0xA7,0xEB},
    {0xA7,0xDD}, {0xA7,0xDC}, {0xA7,0xE9}, {0x9E,0x45},
    {0x93,0xB0}, {0xA0,0x75}, {0xA9,0xE1}, {0xCC,0xBE},
    {0xCC,0xB7}, {0xA9,0xDC}, {0xA9,0xEF}, {0xCC,0xB3},
    {0xCC,0xBA}, {0xCC,0xBC}, {0xCC,0xBF}, {0xA9,0xEA},
    {0xCC,0xBB}, {0xCC,0xB4}, {0xA9,0xE8}, {0xCC,0xB8},
    {0xCC,0xC0}, {0xA9,0xD9}, {0xCC,0xBD}, {0xA9,0xE3},
    {0xA9,0xE2}, {0xCC,0xB6}, {0xA9,0xD7}, {0xA9,0xD8},
    {0x9B,0x46}, {0xA9,0xD6}, {0xFC,0xAE}, {0xA9,0xEE},
    {0xA9,0xE6}, {0xA9,0xE0}, {0xA9,0xD4}, {0xCC,0xB9},
    {0xA9,0xDF}, {0xA9,0xD5}, {0xA9,0xE7}, {0xA9,0xF0},
    {0xCE,0xD4}, {0xA9,0xE4}, {0xCC,0xB5}, {0xA9,0xDA},
    {0xA9,0xDD}, {0xA9,0xDE}, {0xFC,0xB0}, {0xA9,0xEC},
    {0xA9,0xED}, {0xA9,0xEB}, {0xA9,0xE5}, {0xA9,0xE9},
    {0xA9,0xDB}, {0xAB,0xF4}, {0xFA,0x51}, {0x8D,0x7B},
    {0xCE,0xDA}, {0xAC,0x41}, {0xAB,0xF8}, {0xAB,0xFA},
    {0xAC,0x40}, {0xCE,0xE6}, {0xAB,0xFD}, {0xD1,0xB1},
    {0xAE,0xB1}, {0xAC,0x43}, {0xCE,0xD7}, {0xCE,0xDF},
    {0xAB,0xFE}, {0xCE,0xDE}, {0xCE,0xDB}, {0xCE,0xE3},
    {0xCE,0xE5}, {0xAB,0xF7}, {0xAB,0xFB}, {0xAC,0x42},
    {0xAE,0xB3}, {0xCE,0xE0}, {0xAB,0xF9}, {0xAC,0x45},
    {0xCE,0xD9}, {0xAB,0xFC}, {0xAE,0xB2}, {0xAB,0xF6},
    {0xCE,0xD6}, {0xCE,0xDD}, {0xCE,0xD5}, {0xCE,0xD8},
    {0xCE,0xDC}, {0xD1,0xB2}, {0xAC,0x44}, {0xCE,0xE1},
    {0xCE,0xE2}, {0xCE,0xE4}, {0xAB,0xF5}, {0x8D,0x7C},
    {0xAE,0xC1}, {0xD1,0xBE}, {0xAE,0xBF}, {0xAE,0xC0},
    {0xD1,0xB4}, {0xD1,0xC4}, {0x9E,0xD6}, {0xAE,0xB6},
    {0x93,0xAC}, {0xD5,0x66}, {0xD1,0xC6}, {0xD1,0xC0},
    {0x9F,0x5B}, {0xD1,0xB7}, {0x93,0xA9}, {0xD1,0xC9},
    {0xD1,0xBA}, {0xAE,0xBC}, {0xD5,0x7D}, {0xD1,0xBD},
    {0xAE,0xBE}, {0xAE,0xB5}, {0xD1,0xCB}, {0xD1,0xBF},
    {0xAE,0xB8}, {0xD1,0xB8}, {0xD1,0xB5}, {0xD1,0xB6},
    {0xAE,0xB9}, {0xD1,0xC5}, {0xD1,0xCC}, {0xAE,0xBB},
    {0xD1,0xBC}, {0xD1,0xBB}, {0xAE,0xC3}, {0xAE,0xC2},
    {0xAE,0xB4}, {0xAE,0xBA}, {0xAE,0xBD}, {0xD1,0xC8},
    {0xD1,0xC2}, {0xAE,0xB7}, {0xD1,0xB3}, {0xD1,0xCA},
    {0xD1,0xC1}, {0xD1,0xC3}, {0xD1,0xC7}, {0xA0,0x7C},
    {0xD5,0x67}, {0xB1,0xB7}, {0xB1,0xCB}, {0xB1,0xCA},
    {0xB1,0xBF}, {0xFC,0xB2}, {0xD5,0x79}, {0xD5,0x75},
    {0xD5,0x72}, {0xD5,0xA6}, {0xB1,0xBA}, {0xB1,0xB2},
    {0xD5,0x77}, {0xB4,0xA8}, {0xB1,0xB6}, {0xD5,0xA1},
    {0x8A,0xC1}, {0xB1,0xCC}, {0xB1,0xC9}, {0xD5,0x7B},
    {0xD5,0x6A}, {0x9F,0xB4}, {0xB1,0xC8}, {0xD5,0xA3},
    {0xD5,0x69}, {0xB1,0xBD}, {0xB1,0xC1}, {0xD5,0xA2},
    {0xD5,0x73}, {0xB1,0xC2}, {0xB1,0xBC}, {0xD5,0x68},
    {0xFC,0xAC}, {0xB4,0x78}, {0xD5,0xA5}, {0xD5,0x71},
    {0xB1,0xC7}, {0xD5,0x74}, {0xD5,0xA4}, {0xB1,0xC6},
    {0xD9,0x52}, {0xB1,0xB3}, {0xD5,0x6F}, {0xB1,0xB8},
    {0xB1,0xC3}, {0xB1,0xBE}, {0xD5,0x78}, {0xD5,0x6E},
    {0xD5,0x6C}, {0xD5,0x7E}, {0xB1,0xB0}, {0xB1,0xC4},
    {0xB1,0xB4}, {0xB4,0x77}, {0xD5,0x7C}, {0xB1,0xB5},
    {0xB1,0xB1}, {0xB1,0xC0}, {0xB1,0xBB}, {0xB1,0xB9},
    {0xD5,0x70}, {0xB1,0xC5}, {0xD5,0x6D}, {0xD5,0x7A},
    {0xD5,0x76}, {0xD9,0x54}, {0xD9,0x53}, {0x9E,0x4C},
    {0xD5,0x6B}, {0xD9,0x64}, {0xB4,0x7A}, {0x8F,0xC5},
    {0xD9,0x6A}, {0xD9,0x59}, {0xD9,0x67}, {0xDD,0x77},
    {0xB4,0x7D}, {0xD9,0x6B}, {0xD9,0x6E}, {0xB4,0x7C},
    {0xD9,0x5C}, {0xD9,0x6D}, {0xD9,0x6C}, {0xB4,0x7E},
    {0xD9,0x55}, {0xB4,0x79}, {0xB4,0xA3}, {0x93,0xAD},
    {0xB4,0xA1}, {0xD9,0x69}, {0xD9,0x5F}, {0xB4,0xA5},
    {0xD9,0x70}, {0xD9,0x68}, {0xD9,0x71}, {0xB4,0xAD},
    {0xB4,0xAB}, {0xD9,0x66}, {0xD9,0x65}, {0x9D,0xC3},
    {0xD9,0x63}, {0xD9,0x5D}, {0xB4,0xA4}, {0x8D,0xA2},
    {0xB4,0xA2}, {0xD1,0xB9}, {0xD9,0x56}, {0x9D,0x4A},
    {0xDD,0xB7}, {0xD9,0x57}, {0xB4,0x7B}, {0xB4,0xAA},
    {0xDD,0x79}, {0xB4,0xA6}, {0xB4,0xA7}, {0xD9,0x58},
    {0xD9,0x6F}, {0xDD,0x78}, {0xD9,0x60}, {0xD9,0x5B},
    {0xB4,0xA9}, {0xD9,0x61}, {0xD9,0x5E}, {0xFC,0xB6},
    {0xB4,0xAE}, {0x8D,0xA3}, {0x9E,0x4B}, {0x9E,0x4D},
    {0xB7,0x70}, {0x8D,0xA4}, {0xDD,0x7C}, {0xDD,0xB1},
    {0xDD,0xB6}, {0xDD,0xAA}, {0xB7,0x6C}, {0xDD,0xBB},
    {0xB7,0x69}, {0xDD,0x7A}, {0xDD,0x7B}, {0xB7,0x62},
    {0xB7,0x6B}, {0xDD,0xA4}, {0xB7,0x6E}, {0xB7,0x6F},
    {0xDD,0xA5}, {0xDD,0xB2}, {0xDD,0xB8}, {0xB7,0x6A},
    {0xB7,0x64}, {0xDD,0xA3}, {0xDD,0x7D}, {0xDD,0xBA},
    {0xDD,0xA8}, {0xDD,0xA9}, {0xDD,0x7E}, {0xDD,0xB4},
    {0xDD,0xAB}, {0xDD,0xB5}, {0xDD,0xAD}, {0xB7,0x65},
    {0xE1,0xD9}, {0xB7,0x68}, {0xB7,0x66}, {0xDD,0xB9},
    {0xDD,0xB0}, {0xDD,0xAC}, {0x8A,0xFD}, {0xDD,0xA1},
    {0xBA,0x53}, {0xDD,0xAF}, {0xB7,0x6D}, {0xDD,0xA7},
    {0xFC,0xB5}, {0xDD,0xA6}, {0xFC,0xC3}, {0x93,0xB2},
    {0xB7,0x67}, {0xB7,0x63}, {0xE1,0xEE}, {0xDD,0xB3},
    {0xDD,0xAE}, {0xDD,0xA2}, {0xE1,0xE9}, {0xE1,0xDA},
    {0xE1,0xE5}, {0xE1,0xEC}, {0xBA,0x51}, {0xB4,0xAC},
    {0xE1,0xEA}, {0xBA,0x4C}, {0xBA,0x4B}, {0xE1,0xF1},
    {0x8D,0xA5}, {0xE1,0xDB}, {0xE1,0xE8}, {0xE1,0xDC},
    {0xE1,0xE7}, {0xBA,0x4F}, {0xE1,0xEB}, {0xD9,0x62},
    {0xE1,0xF2}, {0xE1,0xE3}, {0xBA,0x52}, {0xE5,0xBA},
    {0xBC,0xAF}, {0xE1,0xF0}, {0xE1,0xEF}, {0xBA,0x54},
    {0xE5,0xAD}, {0xBC,0xB0}, {0xE5,0xAE}, {0x93,0xA1},
    {0xE1,0xDF}, {0xE1,0xE0}, {0xE1,0xDD}, {0xE1,0xE2},
    {0xE1,0xDE}, {0xE1,0xF3}, {0xBA,0x4E}, {0xBC,0xB1},
    {0xBA,0x50}, {0xBA,0x55}, {0x8A,0xC6}, {0xE1,0xE1},
    {0xE1,0xED}, {0xE1,0xE6}, {0xE5,0xB1}, {0xBA,0x4A},
    {0xBC,0xB4}, {0xE9,0xAA}, {0xE5,0xB6}, {0xE5,0xB5},
    {0xE5,0xB7}, {0x8A,0x5B}, {0xE5,0xB4}, {0xBC,0xB5},
    {0x89,0x4D}, {0xBC,0xBB}, {0xBC,0xB8}, {0xBC,0xB9},
    {0xE5,0xAF}, {0xE5,0xB2}, {0xE5,0xBC}, {0xBC,0xC1},
    {0xBC,0xBF}, {0xE5,0xB3}, {0xD9,0x5A}, {0xBC,0xB2},
    {0xE5,0xB9}, {0xE5,0xB0}, {0xBC,0xC2}, {0xE5,0xB8},
    {0xBA,0x4D}, {0xBC,0xB7}, {0xE1,0xE4}, {0xBC,0xBA},
    {0xBC,0xBE}, {0xBC,0xC0}, {0xBC,0xBD}, {0xBC,0xBC},
    {0xFE,0xD4}, {0xBC,0xB6}, {0xE5,0xBB}, {0xBC,0xB3},
    {0xBC,0xC3}, {0x8A,0x78}, {0x93,0xAB}, {0xBE,0xD8},
    {0xBE,0xD9}, {0xE9,0xA9}, {0xBE,0xE2}, {0xBE,0xDF},
    {0x8D,0xA7}, {0xBE,0xD6}, {0xBE,0xDD}, {0xE9,0xAB},
    {0xBE,0xDB}, {0xBE,0xD5}, {0xBE,0xDC}, {0xE9,0xA8},
    {0xC0,0xBB}, {0xBE,0xD7}, {0xBE,0xDE}, {0xC0,0xBA},
    {0xE9,0xA7}, {0xE9,0xA6}, {0xBE,0xE0}, {0x9F,0x45},
    {0xBE,0xE1}, {0xE9,0xA5}, {0xE9,0xA4}, {0xC0,0xBC},
    {0xE9,0xAE}, {0xBE,0xDA}, {0xE9,0xAC}, {0x8A,0x56},
    {0xC0,0xBD}, {0xFC,0xBF}, {0xC0,0xC2}, {0xEC,0xEA},
    {0xEC,0xEC}, {0xFC,0xC0}, {0xC0,0xBF}, {0x8E,0xE6},
    {0xEC,0xED}, {0xEC,0xE9}, {0x8A,0xA4}, {0xEC,0xEB},
    {0xC0,0xC0}, {0xC0,0xC3}, {0xEC,0xE8}, {0xC0,0xBE},
    {0xC0,0xC1}, {0xC2,0x59}, {0xE9,0xAD}, {0xC2,0x58},
    {0xC2,0x5E}, {0xEF,0xD4}, {0xC2,0x5C}, {0xC2,0x5D},
    {0xEF,0xD7}, {0xEF,0xD3}, {0xC2,0x5A}, {0xEF,0xD1},
    {0xC3,0x6B}, {0xEF,0xD5}, {0xEF,0xD6}, {0xEF,0xD2},
    {0xC2,0x5B}, {0xF2,0x42}, {0xF2,0x45}, {0x89,0x43},
    {0xF2,0x46}, {0xF2,0x44}, {0xF2,0x47}, {0xC3,0x6C},
    {0xF2,0x43}, {0x93,0xF3}, {0xF4,0x4E}, {0xC4,0x64},
    {0xF4,0x4D}, {0xF4,0x4C}, {0xF4,0x4B}, {0xC4,0x63},
    {0xC4,0x65}, {0xF5,0xCD}, {0xC4,0xE2}, {0xC4,0xE1},
    {0xFC,0xAB}, {0x9E,0xA2}, {0xF6,0xE1}, {0xF6,0xE0},
    {0xF6,0xE3}, {0xC5,0xCB}, {0xC5,0x75}, {0xF7,0xDD},
    {0xF6,0xE2}, {0xF7,0xDC}, {0xC5,0xCD}, {0xC5,0xCC},
    {0xC5,0xF3}, {0xF8,0xA9}, {0xF8,0xEF}, {0xA4,0xE4},
    {0x9D,0xC7}, {0xD9,0x72}, {0xE9,0xAF}, {0xC6,0xD2},
    {0x8B,0xCE}, {0xA6,0xAC}, {0xCA,0xF7}, {0xA7,0xF1},
    {0xA7,0xEF}, {0xA7,0xF0}, {0xCC,0xC1}, {0xA9,0xF1},
    {0xAC,0x46}, {0xCE,0xE7}, {0xCE,0xE8}, {0xAC,0x47},
    {0xD1,0xCE}, {0xAE,0xC4}, {0xAE,0xC5}, {0xD1,0xCD},
    {0xFC,0xC5}, {0xB1,0xD3}, {0xB1,0xCF}, {0xD5,0xA7},
    {0xB1,0xD6}, {0xB1,0xD5}, {0xB1,0xCE}, {0xB1,0xD1},
    {0xB1,0xD4}, {0xB1,0xD0}, {0xD9,0x76}, {0xB1,0xCD},
    {0xB4,0xAF}, {0xFC,0xCB}, {0xB4,0xB1}, {0xB4,0xB2},
    {0xD9,0x75}, {0xD9,0x78}, {0xB4,0xB0}, {0xD9,0x73},
    {0xD9,0x77}, {0xD9,0x74}, {0x93,0xB3}, {0xB7,0x71},
    {0xFC,0xCA}, {0xDD,0xBC}, {0xBA,0x56}, {0xE1,0xF4},
    {0xBE,0xE3}, {0xBC,0xC4}, {0xE5,0xBD}, {0xBC,0xC5},
    {0xBC,0xC6}, {0xE5,0xBF}, {0xE5,0xBE}, {0xE5,0xC0},
    {0xE9,0xB1}, {0xE9,0xB0}, {0xEC,0xEF}, {0xEC,0xEE},
    {0xC0,0xC4}, {0xC0,0xC5}, {0xF2,0x48}, {0xFC,0xC9},
    {0x8D,0xAC}, {0xA4,0xE5}, {0xFB,0xC6}, {0x89,0x67},
    {0x8C,0x7E}, {0xD9,0x79}, {0xB4,0xB4}, {0xB4,0xB3},
    {0xDD,0xBD}, {0xEF,0xD8}, {0xC4,0xE3}, {0xF7,0xDE},
    {0xA4,0xE6}, {0xAE,0xC6}, {0xB1,0xD8}, {0xB1,0xD7},
    {0xD9,0x7A}, {0xD9,0x7B}, {0xB7,0x72}, {0xE1,0xF5},
    {0xBA,0x57}, {0xE9,0xB2}, {0xA4,0xE7}, {0xA5,0xB8},
    {0xA9,0xF2}, {0xCC,0xC2}, {0xCE,0xE9}, {0xAC,0x48},
    {0xB1,0xD9}, {0xD9,0x7C}, {0xB4,0xB5}, {0xB7,0x73},
    {0xE5,0xC1}, {0xE5,0xC2}, {0xFC,0xCD}, {0xEC,0xF0},
    {0xC2,0x5F}, {0xF8,0xF0}, {0xA4,0xE8}, {0xCC,0xC3},
    {0xA9,0xF3}, {0xAC,0x49}, {0x9C,0xF3}, {0xCE,0xEA},
    {0xAE,0xC7}, {0xD1,0xD2}, {0xD1,0xD0}, {0xD1,0xD1},
    {0xAE,0xC8}, {0xD1,0xCF}, {0xB1,0xDB}, {0xB1,0xDC},
    {0xD5,0xA8}, {0xB1,0xDD}, {0xB1,0xDA}, {0xD9,0x7D},
    {0xFC,0xD0}, {0xD9,0x7E}, {0xDD,0xBE}, {0x95,0xBB},
    {0xBA,0x59}, {0xBA,0x58}, {0xEC,0xF1}, {0xEF,0xD9},
    {0xF2,0x4A}, {0xF2,0x49}, {0xF4,0x4F}, {0xFC,0xD3},
    {0xC9,0x5E}, {0xAC,0x4A}, {0xFC,0xD4}, {0xA4,0xE9},
    {0xA5,0xB9}, {0xA6,0xAE}, {0xA6,0xAD}, {0xA6,0xAF},
    {0xA6,0xB0}, {0xC9,0xEE}, {0xC9,0xED}, {0xCA,0xF8},
    {0xA7,0xF2}, {0xCA,0xFB}, {0xCA,0xFA}, {0xCA,0xF9},
    {0xCA,0xFC}, {0xA9,0xF4}, {0xCC,0xC9}, {0xCC,0xC5},
    {0xCC,0xCE}, {0x8D,0xAE}, {0xA9,0xFB}, {0xA9,0xF9},
    {0xCC,0xCA}, {0xCC,0xC6}, {0xCC,0xCD}, {0xA9,0xF8},
    {0xAA,0x40}, {0xCC,0xC8}, {0xCC,0xC4}, {0xA9,0xFE},
    {0xCC,0xCB}, {0xA9,0xF7}, {0xCC,0xCC}, {0xA9,0xFA},
    {0xA9,0xFC}, {0xCC,0xD0}, {0xCC,0xCF}, {0xCC,0xC7},
    {0xA9,0xF6}, {0xA9,0xF5}, {0xA9,0xFD}, {0xFC,0xD7},
    {0xCE,0xEF}, {0xCE,0xF5}, {0x93,0xDB}, {0xAC,0x50},
    {0xAC,0x4D}, {0xCE,0xEC}, {0xCE,0xF1}, {0xFE,0x63},
    {0xAC,0x53}, {0xAC,0x4B}, {0xCE,0xF0}, {0xAC,0x4E},
    {0xAC,0x51}, {0xCE,0xF3}, {0xAC,0x4C}, {0xCE,0xF8},
    {0xAC,0x4F}, {0x93,0xD5}, {0xAC,0x52}, {0xCE,0xED},
    {0xCE,0xF2}, {0xCE,0xF6}, {0xCE,0xEE}, {0xCE,0xEB},
    {0xCE,0xF7}, {0xCE,0xF4}, {0xAE,0xD0}, {0xAE,0xC9},
    {0xAE,0xCC}, {0xFC,0xDA}, {0xAE,0xCF}, {0xD1,0xD5},
    {0x9B,0x71}, {0xAE,0xCA}, {0xD1,0xD3}, {0xFC,0xDD},
    {0xAE,0xCE}, {0xAE,0xCB}, {0xD1,0xD6}, {0xAE,0xCD},
    {0x8D,0xAF}, {0xFA,0xF2}, {0xD5,0xAC}, {0xB1,0xDF},
    {0xD5,0xAB}, {0xD5,0xAD}, {0xB1,0xDE}, {0xB1,0xE3},
    {0xD1,0xD4}, {0xD5,0xAA}, {0xD5,0xAE}, {0x93,0xD8},
    {0xB1,0xE0}, {0xD5,0xA9}, {0xB1,0xE2}, {0xFC,0xDF},
    {0xB1,0xE1}, {0xD9,0xA7}, {0x93,0xD3}, {0xD9,0xA2},
    {0xB4,0xB6}, {0xB4,0xBA}, {0xB4,0xB7}, {0xD9,0xA5},
    {0xD9,0xA8}, {0xFC,0xE1}, {0xB4,0xB8}, {0xB4,0xB9},
    {0xB4,0xBE}, {0xDD,0xC7}, {0xD9,0xA6}, {0xB4,0xBC},
    {0xD9,0xA3}, {0xD9,0xA1}, {0x8E,0x76}, {0xB4,0xBD},
    {0xD9,0xA4}, {0xB7,0x79}, {0xFC,0x62}, {0xDD,0xBF},
    {0xB7,0x76}, {0xB7,0x77}, {0xB7,0x75}, {0xDD,0xC4},
    {0xDD,0xC3}, {0xDD,0xC0}, {0xB7,0x7B}, {0x93,0xD1},
    {0xDD,0xC2}, {0xB4,0xBB}, {0x8D,0xB1}, {0xDD,0xC6},
    {0xDD,0xC1}, {0xB7,0x78}, {0xB7,0x74}, {0xB7,0x7A},
    {0xDD,0xC5}, {0x98,0x59}, {0xBA,0x5C}, {0xE1,0xF8},
    {0xE1,0xF7}, {0xE1,0xF6}, {0xBA,0x5A}, {0xFB,0x52},
    {0xBA,0x5B}, {0xE5,0xC5}, {0xE5,0xC8}, {0xBC,0xC8},
    {0xFB,0x53}, {0xBC,0xC7}, {0xE5,0xC9}, {0xE5,0xC4},
    {0xBC,0xCA}, {0xE5,0xC6}, {0xFB,0x4D}, {0xBC,0xC9},
    {0xE5,0xC3}, {0x9C,0xBF}, {0xE5,0xC7}, {0xBE,0xE9},
    {0xBE,0xE6}, {0xE9,0xBB}, {0xE9,0xBA}, {0xE9,0xB9},
    {0xE9,0xB4}, {0x9B,0x72}, {0xE9,0xB5}, {0xBE,0xE7},
    {0xBE,0xE4}, {0xBE,0xE8}, {0xE9,0xB3}, {0xBE,0xE5},
    {0xE9,0xB6}, {0xE9,0xB7}, {0xE9,0xBC}, {0xFB,0x50},
    {0x93,0xBE}, {0xE9,0xB8}, {0xEC,0xF2}, {0xC0,0xC7},
    {0xEF,0xDC}, {0xC0,0xC6}, {0xEF,0xDA}, {0xEF,0xDB},
    {0xC2,0x60}, {0xC3,0x6E}, {0xF2,0x4B}, {0xC3,0x6D},
    {0xF4,0x51}, {0xF4,0x52}, {0xC4,0x66}, {0xF4,0x50},
    {0xC4,0xE4}, {0xF7,0xDF}, {0xC5,0xCE}, {0xF8,0xAA},
    {0xF8,0xAB}, {0xA4,0xEA}, {0x9D,0xF1}, {0xA6,0xB1},
    {0xA6,0xB2}, {0xA7,0xF3}, {0xCC,0xD1}, {0xAC,0x54},
    {0xAE,0xD1}, {0xB1,0xE4}, {0xB0,0xD2}, {0xB4,0xBF},
    {0xB4,0xC0}, {0xB3,0xCC}, {0xD9,0xA9}, {0xFC,0xEB},
    {0xB7,0x7C}, {0xE1,0xFA}, {0xE1,0xF9}, {0xA4,0xEB},
    {0xA6,0xB3}, {0xCC,0xD2}, {0xAA,0x42}, {0xA0,0xBB},
    {0xAA,0x41}, {0x9B,0x7E}, {0xCE,0xF9}, {0xCE,0xFA},
    {0xD1,0xD7}, {0xD1,0xD8}, {0xAE,0xD2}, {0xAE,0xD3},
    {0x8D,0xB3}, {0xAE,0xD4}, {0xD5,0xAF}, {0x8C,0x52},
    {0xB1,0xE6}, {0xB4,0xC2}, {0x9A,0xE8}, {0xB4,0xC1},
    {0xDD,0xC8}, {0xDF,0x7A}, {0xE1,0xFB}, {0xE9,0xBD},
    {0x8E,0xDC}, {0xC2,0x61}, {0xC4,0x67}, {0xA4,0xEC},
    {0xA5,0xBC}, {0xA5,0xBD}, {0xA5,0xBB}, {0xA5,0xBE},
    {0xA5,0xBA}, {0xA6,0xB6}, {0xC9,0xF6}, {0xA6,0xB5},
    {0xA6,0xB7}, {0x9C,0xF9}, {0xC9,0xF1}, {0xC9,0xF0},
    {0xC9,0xF3}, {0xC9,0xF2}, {0xC9,0xF5}, {0xA6,0xB4},
    {0xC9,0xEF}, {0xC9,0xF4}, {0xFA,0x50}, {0xCA,0xFD},
    {0xA7,0xFD}, {0xCA,0xFE}, {0xCB,0x43}, {0xA7,0xFC},
    {0xCB,0x47}, {0xCB,0x42}, {0xCB,0x45}, {0xA7,0xF5},
    {0xA7,0xF6}, {0xA7,0xF7}, {0xA7,0xF8}, {0xA8,0x40},
    {0xCB,0x41}, {0xA7,0xFA}, {0xA8,0x41}, {0xCB,0x40},
    {0xCB,0x46}, {0xA7,0xF9}, {0xCB,0x44}, {0xA7,0xFB},
    {0xA7,0xF4}, {0xA7,0xFE}, {0x98,0xE7}, {0xFC,0xF3},
    {0xFC,0xF2}, {0xAA,0x57}, {0x8C,0xCA}, {0xCC,0xD4},
    {0xAA,0x43}, {0xAA,0x4D}, {0xAA,0x4E}, {0xAA,0x46},
    {0xAA,0x58}, {0xAA,0x48}, {0xCC,0xDC}, {0xAA,0x53},
    {0xCC,0xD7}, {0xAA,0x49}, {0xCC,0xE6}, {0xCC,0xE7},
    {0xCC,0xDF}, {0xCC,0xD8}, {0xAA,0x56}, {0xCC,0xE4},
    {0xAA,0x51}, {0xAA,0x4F}, {0xCC,0xE5}, {0xCC,0xE3},
    {0xCC,0xDB}, {0xCC,0xD3}, {0xCC,0xDA}, {0xAA,0x4A},
    {0xAA,0x50}, {0xAA,0x44}, {0xCC,0xDE}, {0xCC,0xDD},
    {0xCC,0xD5}, {0x93,0xE5}, {0xAA,0x52}, {0xCC,0xE1},
    {0xCC,0xD6}, {0xAA,0x55}, {0xCC,0xE8}, {0xAA,0x45},
    {0xAA,0x4C}, {0xCC,0xD9}, {0xCC,0xE2}, {0xAA,0x54},
    {0xAA,0x47}, {0xAA,0x4B}, {0xCC,0xE0}, {0x9A,0x59},
    {0x8D,0xB5}, {0xFD,0x4D}, {0xCF,0x5B}, {0xAC,0x5C},
    {0xAC,0x69}, {0xFD,0x5E}, {0xCF,0x56}, {0xCF,0x4C},
    {0xAC,0x62}, {0xCF,0x4A}, {0xAC,0x5B}, {0xCF,0x45},
    {0xAC,0x65}, {0xCF,0x52}, {0xCE,0xFE}, {0xCF,0x41},
    {0x8F,0x7D}, {0xCF,0x44}, {0xCE,0xFB}, {0xCF,0x51},
    {0xCF,0x61}, {0xAC,0x60}, {0xCF,0x46}, {0xCF,0x58},
    {0xCE,0xFD}, {0xCF,0x5F}, {0xCF,0x60}, {0xCF,0x63},
    {0xCF,0x5A}, {0xCF,0x4B}, {0xCF,0x53}, {0xAC,0x66},
    {0xAC,0x59}, {0xAC,0x61}, {0xAC,0x6D}, {0xAC,0x56},
    {0xAC,0x58}, {0x95,0x47}, {0xFC,0xF6}, {0xCF,0x43},
    {0xAC,0x6A}, {0xAC,0x63}, {0xCF,0x5D}, {0xCF,0x40},
    {0xAC,0x6C}, {0xAC,0x67}, {0xCF,0x49}, {0xAC,0x6B},
    {0xCF,0x50}, {0xCF,0x48}, {0xAC,0x64}, {0xCF,0x5C},
    {0xCF,0x54}, {0xAC,0x5E}, {0xCF,0x62}, {0xCF,0x47},
    {0xAC,0x5A}, {0xCF,0x59}, {0xCF,0x4F}, {0xAC,0x5F},
    {0xCF,0x55}, {0xAC,0x57}, {0xCE,0xFC}, {0xAC,0x68},
    {0xAE,0xE3}, {0xAC,0x5D}, {0xCF,0x4E}, {0xCF,0x4D},
    {0xCF,0x42}, {0x92,0x50}, {0xCF,0x5E}, {0xCF,0x57},
    {0x89,0x68}, {0xAC,0x55}, {0x8D,0xB6}, {0xFC,0xFB},
    {0xA0,0x7D}, {0x98,0xFC}, {0x89,0x69}, {0xFE,0x4F},
    {0x92,0x56}, {0xD1,0xEC}, {0xAE,0xEA}, {0xD1,0xED},
    {0xD1,0xE1}, {0xAE,0xDF}, {0xAE,0xEB}, {0xD1,0xDA},
    {0xFA,0xC9}, {0xD1,0xE3}, {0xD1,0xEB}, {0x93,0xE8},
    {0xD1,0xD9}, {0xD1,0xF4}, {0xAE,0xD5}, {0xFC,0xF8},
    {0xD1,0xF3}, {0xD1,0xEE}, {0xD1,0xEF}, {0xAE,0xDD},
    {0xAE,0xE8}, {0xD1,0xE5}, {0xD1,0xE6}, {0xD1,0xF0},
    {0xD1,0xE7}, {0xD1,0xE2}, {0xD1,0xDC}, {0xD1,0xDD},
    {0xD1,0xEA}, {0xD1,0xE4}, {0x9C,0xE3}, {0xFD,0xA9},
    {0xAE,0xD6}, {0xAE,0xDA}, {0xD1,0xF2}, {0xD1,0xDE},
    {0xAE,0xE6}, {0xAE,0xE2}, {0xFC,0x44}, {0xAE,0xE5},
    {0xAE,0xEC}, {0xAE,0xDB}, {0xAE,0xE7}, {0xD1,0xE9},
    {0xAE,0xE9}, {0xAE,0xD8}, {0x96,0x40}, {0xAE,0xD7},
    {0xD1,0xDB}, {0x8D,0xB8}, {0xD1,0xDF}, {0xAE,0xE0},
    {0xD1,0xF1}, {0xD1,0xE8}, {0xD1,0xE0}, {0xAE,0xE4},
    {0xAE,0xE1}, {0xAE,0xD9}, {0xAE,0xDC}, {0x9B,0x4A},
    {0x8F,0xB9}, {0xFC,0xFE}, {0x89,0x6A}, {0xD5,0xC4},
    {0xD5,0xB4}, {0xD5,0xB5}, {0xD5,0xB9}, {0xD5,0xC8},
    {0xD5,0xC5}, {0xD5,0xBE}, {0xD5,0xBD}, {0xB1,0xED},
    {0xD5,0xC1}, {0xD5,0xD0}, {0xD5,0xB0}, {0xD5,0xD1},
    {0xD5,0xC3}, {0xD5,0xD5}, {0xD5,0xC9}, {0xB1,0xEC},
    {0xD5,0xC7}, {0xB1,0xE7}, {0xB1,0xFC}, {0xB1,0xF2},
    {0x8D,0xB9}, {0xB1,0xF6}, {0xB1,0xF5}, {0xD5,0xB1},
    {0x91,0x7E}, {0xD5,0xCE}, {0xD5,0xD4}, {0xD5,0xCC},
    {0xD5,0xD3}, {0xD5,0xC0}, {0xD5,0xB2}, {0xD5,0xD2},
    {0xD5,0xC2}, {0xB1,0xEA}, {0xB1,0xF7}, {0xD5,0xCB},
    {0xB1,0xF0}, {0x93,0xF4}, {0xD5,0xCA}, {0xD5,0xB3},
    {0xB1,0xF8}, {0xB1,0xFA}, {0xD5,0xCD}, {0xB1,0xFB},
    {0xB1,0xE9}, {0xD5,0xBA}, {0xD5,0xCF}, {0xFB,0x7C},
    {0xB1,0xEF}, {0xB1,0xF9}, {0xD5,0xBC}, {0xD5,0xC6},
    {0xD5,0xB7}, {0xD5,0xBB}, {0xB1,0xF4}, {0xD5,0xB6},
    {0xB1,0xE8}, {0xB1,0xF1}, {0xB1,0xEE}, {0xD5,0xBF},
    {0xAE,0xDE}, {0xD9,0xC0}, {0xB1,0xEB}, {0x93,0xE7},
    {0x97,0xEF}, {0xFE,0x4A}, {0xFD,0x45}, {0xB1,0xF3},
    {0x96,0xA5}, {0xD9,0xC3}, {0xD9,0xD9}, {0xD9,0xCE},
    {0xB4,0xD6}, {0xFE,0xE0}, {0xB4,0xD1}, {0xD9,0xBD},
    {0xB4,0xD2}, {0xD9,0xCD}, {0xD9,0xC6}, {0xD9,0xD3},
    {0xB4,0xCE}, {0xD9,0xAB}, {0xD9,0xD5}, {0xB4,0xC4},
    {0xD9,0xB3}, {0xB4,0xC7}, {0xB4,0xC6}, {0xB4,0xD7},
    {0xD9,0xAD}, {0xD9,0xCF}, {0xD9,0xD0}, {0xB4,0xC9},
    {0xB4,0xC5}, {0xD9,0xBB}, {0xB4,0xD0}, {0xD9,0xB6},
    {0xD9,0xD1}, {0xB4,0xCC}, {0xD9,0xC9}, {0xD9,0xD6},
    {0xD9,0xB0}, {0xD9,0xB5}, {0xD9,0xAF}, {0xB4,0xCB},
    {0xD9,0xC2}, {0xDD,0xDE}, {0xD9,0xB1}, {0xB4,0xCF},
    {0xD9,0xBA}, {0xD9,0xD2}, {0xB4,0xCA}, {0xD9,0xB7},
    {0xD9,0xB4}, {0xD9,0xC5}, {0xB4,0xCD}, {0xB4,0xC3},
    {0xB4,0xD9}, {0xD9,0xC8}, {0xD9,0xC7}, {0xFD,0x48},
    {0xFD,0x47}, {0xFE,0xF2}, {0xFE,0x6A}, {0xD9,0xAC},
    {0xB4,0xC8}, {0xD9,0xD4}, {0xD9,0xBC}, {0xD9,0xBE},
    {0x8D,0xBD}, {0xD9,0xCB}, {0xD9,0xCA}, {0xD9,0xAA},
    {0xB4,0xD3}, {0xB4,0xD5}, {0xD9,0xB2}, {0xD9,0xB9},
    {0xD9,0xC1}, {0xB4,0xD4}, {0xD9,0xB8}, {0xD9,0xC4},
    {0xD9,0xD7}, {0xD9,0xCC}, {0x9B,0xA1}, {0x8C,0xA2},
    {0x9A,0xB7}, {0x8E,0xFC}, {0xD9,0xD8}, {0xD9,0xAE},
    {0x9F,0xA1}, {0xDD,0xF2}, {0xB7,0xA6}, {0xDD,0xF0},
    {0xDD,0xDB}, {0xDD,0xE0}, {0xDD,0xD9}, {0xFD,0x51},
    {0xDD,0xEC}, {0xDD,0xCB}, {0xDD,0xD2}, {0xDD,0xEA},
    {0xDD,0xF4}, {0xDD,0xDC}, {0xFA,0xAD}, {0xDD,0xCF},
    {0xDD,0xE2}, {0xDD,0xE7}, {0xDD,0xD3}, {0x8D,0xBE},
    {0xDD,0xE4}, {0xDD,0xD0}, {0x89,0xA4}, {0xDD,0xD7},
    {0xDD,0xD8}, {0xB7,0xA8}, {0xDD,0xEB}, {0xDD,0xE9},
    {0xDD,0xCC}, {0xDD,0xEE}, {0xDD,0xEF}, {0xDD,0xF1},
    {0xB7,0xAC}, {0xB7,0xA4}, {0x9A,0xD9}, {0xD5,0xB8},
    {0xDD,0xD4}, {0xDD,0xE6}, {0xDD,0xD5}, {0xB7,0xA1},
    {0xB7,0xB1}, {0xDD,0xED}, {0xB7,0xAF}, {0xB7,0xAB},
    {0xDD,0xCA}, {0xB7,0xA3}, {0xFD,0x4E}, {0xDD,0xCD},
    {0xB7,0xB0}, {0x8D,0xC0}, {0xDD,0xDD}, {0xDD,0xC9},
    {0x97,0xF0}, {0xB7,0xA9}, {0xDD,0xE1}, {0xDD,0xD1},
    {0xB7,0xAA}, {0xDD,0xDA}, {0xB7,0x7E}, {0xB4,0xD8},
    {0xDD,0xE3}, {0xD9,0xBF}, {0xDD,0xCE}, {0x93,0xB4},
    {0xFD,0x44}, {0xDD,0xE8}, {0xB7,0xA5}, {0xDD,0xE5},
    {0xB7,0xA2}, {0xDD,0xDF}, {0xB7,0xAD}, {0xDD,0xD6},
    {0xDD,0xF3}, {0x9F,0xA7}, {0xB7,0xA7}, {0xDE,0xC6},
    {0x8D,0xC2}, {0xB7,0xAE}, {0x99,0xB6}, {0xE2,0x4A},
    {0xE2,0x48}, {0xE2,0x5E}, {0xE2,0x46}, {0xE2,0x58},
    {0xB7,0x7D}, {0xBA,0x5F}, {0xE2,0x42}, {0xE2,0x5D},
    {0xFD,0x52}, {0xE2,0x47}, {0xE2,0x55}, {0xBA,0x64},
    {0xBA,0x5D}, {0xE2,0x5B}, {0x8D,0xC1}, {0xE2,0x40},
    {0xE2,0x5A}, {0x8E,0x46}, {0xBA,0x6F}, {0xE2,0x51},
    {0xE2,0x61}, {0xBA,0x6D}, {0xE2,0x49}, {0xBA,0x5E},
    {0xE2,0x4B}, {0xE2,0x59}, {0xBA,0x67}, {0xE2,0x44},
    {0xBA,0x6B}, {0xBA,0x61}, {0xE2,0x4D}, {0xE2,0x43},
    {0xE1,0xFC}, {0xA0,0xD1}, {0xE2,0x57}, {0xBA,0x68},
    {0xE2,0x60}, {0xE1,0xFD}, {0xBA,0x65}, {0xE2,0x53},
    {0xBA,0x66}, {0xE2,0x45}, {0xE2,0x50}, {0xE2,0x4C},
    {0xE2,0x4E}, {0x9F,0xCA}, {0xBA,0x60}, {0xE2,0x5F},
    {0xBA,0x6E}, {0xE2,0x4F}, {0xE2,0x62}, {0xE1,0xFE},
    {0xE2,0x54}, {0xBA,0x63}, {0xBA,0x6C}, {0xBA,0x6A},
    {0xE2,0x41}, {0xE2,0x56}, {0xBA,0x69}, {0x92,0xCF},
    {0xBA,0x62}, {0xE2,0x52}, {0x9C,0xF4}, {0x8D,0xC4},
    {0xE2,0x5C}, {0xFD,0x41}, {0xE5,0xD5}, {0xE5,0xD1},
    {0xE5,0xCD}, {0xE5,0xE1}, {0xE5,0xDE}, {0xBC,0xCD},
    {0x9B,0x4C}, {0xE5,0xE5}, {0xE5,0xD4}, {0xBC,0xD8},
    {0xE5,0xDB}, {0xE5,0xD0}, {0xE5,0xDA}, {0xBC,0xD5},
    {0xE5,0xEE}, {0xE5,0xEB}, {0xE5,0xDD}, {0xE5,0xCE},
    {0xFD,0x57}, {0xFC,0xEF}, {0xE5,0xE2}, {0xE5,0xE4},
    {0xBC,0xD1}, {0xE5,0xD8}, {0xE5,0xD3}, {0xE5,0xCA},
    {0xBC,0xCE}, {0xBC,0xD6}, {0x9C,0xDE}, {0xE5,0xE7},
    {0xBC,0xD7}, {0xE5,0xCB}, {0xE5,0xED}, {0xE5,0xE0},
    {0xE5,0xE6}, {0xBC,0xD4}, {0xFD,0x42}, {0x98,0x6C},
    {0xE5,0xE3}, {0xE5,0xEA}, {0xBC,0xD9}, {0xBC,0xD3},
    {0xE5,0xDC}, {0xE5,0xCF}, {0xE5,0xEF}, {0xE5,0xCC},
    {0xE5,0xE8}, {0xBC,0xD0}, {0x97,0xF9}, {0xE5,0xD6},
    {0x95,0x58}, {0xE5,0xD7}, {0xBC,0xCF}, {0xBC,0xCC},
    {0xE5,0xD2}, {0xBC,0xD2}, {0xBC,0xCB}, {0xE5,0xE9},
    {0xE5,0xEC}, {0xE5,0xD9}, {0xE9,0xCA}, {0x98,0x5E},
    {0xFE,0x7B}, {0x94,0xCD}, {0xE9,0xC2}, {0x93,0xEE},
    {0xE9,0xBE}, {0xBE,0xF6}, {0xBE,0xEB}, {0xBE,0xF0},
    {0xBE,0xEC}, {0xE9,0xCC}, {0xE9,0xD7}, {0xBE,0xEA},
    {0xE9,0xC4}, {0xE9,0xCD}, {0xE5,0xDF}, {0xE9,0xCE},
    {0x8C,0xA3}, {0xBE,0xF1}, {0xFD,0x5A}, {0xE9,0xDD},
    {0xBE,0xF5}, {0xBE,0xF8}, {0xE9,0xC0}, {0xBE,0xF4},
    {0x93,0xF5}, {0xE9,0xDB}, {0xE9,0xDC}, {0xE9,0xD2},
    {0xE9,0xD1}, {0xE9,0xC9}, {0x93,0xEF}, {0x8E,0xEA},
    {0xE9,0xD3}, {0xE9,0xDA}, {0xE9,0xD9}, {0x8F,0x5B},
    {0xBE,0xEF}, {0xBE,0xED}, {0xE9,0xCB}, {0xE9,0xC8},
    {0xE9,0xC5}, {0xE9,0xD8}, {0xBE,0xF7}, {0xE9,0xD6},
    {0xBE,0xF3}, {0xBE,0xF2}, {0x8C,0x5E}, {0xE9,0xD0},
    {0x8D,0xC6}, {0xE9,0xBF}, {0xE9,0xC1}, {0xE9,0xC3},
    {0xE9,0xD5}, {0xE9,0xCF}, {0xBE,0xEE}, {0xE9,0xC6},
    {0xE9,0xD4}, {0x8D,0xC8}, {0x8D,0xC7}, {0xE9,0xC7},
    {0x93,0xF7}, {0xC0,0xCF}, {0xED,0x45}, {0xC0,0xC8},
    {0xEC,0xF5}, {0x8D,0xC9}, {0xED,0x41}, {0xC0,0xCA},
    {0xED,0x48}, {0xEC,0xFC}, {0xEC,0xF7}, {0xFB,0xF2},
    {0xED,0x49}, {0xEC,0xF3}, {0xEC,0xFE}, {0x96,0x70},
    {0xC0,0xD1}, {0xED,0x44}, {0xED,0x4A}, {0xEC,0xFD},
    {0xC0,0xC9}, {0xED,0x40}, {0xEC,0xF4}, {0xC0,0xD0},
    {0x8D,0xCB}, {0xED,0x47}, {0xEC,0xF9}, {0xC0,0xCC},
    {0xFD,0x5C}, {0xEC,0xFB}, {0xEC,0xF8}, {0xC0,0xD2},
    {0xEC,0xFA}, {0xC0,0xCB}, {0xC0,0xCE}, {0xED,0x43},
    {0xEC,0xF6}, {0xED,0x46}, {0x8F,0x65}, {0xED,0x42},
    {0x8D,0xCD}, {0xC2,0x63}, {0xEF,0xE7}, {0xC2,0x68},
    {0xC2,0x69}, {0x9D,0xA8}, {0x94,0xF9}, {0xC2,0x62},
    {0xEF,0xE6}, {0x8D,0xCE}, {0xEF,0xE3}, {0xEF,0xE4},
    {0xC2,0x66}, {0xEF,0xDE}, {0xEF,0xE2}, {0xC2,0x65},
    {0xEF,0xDF}, {0x93,0xEA}, {0xC2,0x67}, {0xC2,0x64},
    {0xEF,0xDD}, {0xEF,0xE1}, {0xEF,0xE5}, {0xFD,0x5F},
    {0x93,0xF0}, {0x9F,0xB6}, {0xF2,0x51}, {0xF2,0x4E},
    {0xF2,0x57}, {0xF2,0x56}, {0xF2,0x54}, {0xF2,0x4F},
    {0xC3,0x72}, {0x8D,0xCF}, {0x97,0x63}, {0xF2,0x50},
    {0xC3,0x71}, {0xC0,0xCD}, {0xF2,0x53}, {0xC3,0x70},
    {0xF2,0x58}, {0xF2,0x52}, {0xF2,0x4D}, {0xEF,0xE0},
    {0xC3,0x6F}, {0xF2,0x4C}, {0xF4,0x56}, {0xF4,0x55},
    {0xF2,0x55}, {0xC4,0x68}, {0xF4,0x59}, {0xF4,0x5A},
    {0xF4,0x54}, {0xF4,0x58}, {0xF4,0x53}, {0x8D,0xD0},
    {0xF5,0xD1}, {0xF4,0x57}, {0xC4,0xE7}, {0xC4,0xE5},
    {0xF5,0xCF}, {0xF5,0xD2}, {0xF5,0xCE}, {0xF5,0xD0},
    {0xC4,0xE6}, {0x93,0xF1}, {0xF6,0xE5}, {0xF6,0xE6},
    {0xC5,0x76}, {0xF6,0xE4}, {0xF7,0xE2}, {0xC5,0xCF},
    {0xF7,0xE0}, {0xF7,0xE1}, {0xF8,0xAC}, {0xC6,0x56},
    {0xF8,0xF3}, {0xF8,0xF1}, {0xF8,0xF2}, {0xF8,0xF4},
    {0xFD,0x62}, {0xF9,0xBB}, {0xA4,0xED}, {0xA6,0xB8},
    {0xAA,0x59}, {0xCC,0xE9}, {0xCF,0x64}, {0xD1,0xF5},
    {0xD1,0xF7}, {0xD1,0xF6}, {0xD1,0xF8}, {0xB1,0xFD},
    {0xD5,0xD7}, {0xD1,0xF9}, {0xFD,0x65}, {0xD5,0xD6},
    {0xD5,0xD8}, {0xD5,0xD9}, {0xD9,0xDA}, {0xB4,0xDB},
    {0xD9,0xDB}, {0xD9,0xDD}, {0xB4,0xDC}, {0xB4,0xDA},
    {0xD9,0xDC}, {0xDD,0xFA}, {0xDD,0xF8}, {0xDD,0xF7},
    {0xDD,0xF6}, {0xDD,0xF5}, {0xB7,0xB2}, {0xDD,0xF9},
    {0xBA,0x70}, {0xE2,0x63}, {0xE2,0x65}, {0xBA,0x71},
    {0xE2,0x64}, {0xBC,0xDB}, {0xBC,0xDA}, {0xE5,0xF0},
    {0x9F,0xDB}, {0xE9,0xDF}, {0xE9,0xDE}, {0xE9,0xE0},
    {0x93,0xF8}, {0xBE,0xF9}, {0xED,0x4B}, {0xC0,0xD3},
    {0xEF,0xE8}, {0xC2,0x6A}, {0xF2,0x59}, {0xC5,0x77},
    {0xA4,0xEE}, {0xA5,0xBF}, {0xA6,0xB9}, {0xA8,0x42},
    {0xAA,0x5A}, {0xAA,0x5B}, {0xAC,0x6E}, {0xD1,0xFA},
    {0x8B,0xF7}, {0xB7,0xB3}, {0xFD,0x66}, {0xE6,0xD1},
    {0xBE,0xFA}, {0xC2,0x6B}, {0xA4,0xEF}, {0x8B,0xCF},
    {0xA6,0xBA}, {0xCC,0xEB}, {0xAA,0x5C}, {0xCC,0xEA},
    {0x8D,0xD1}, {0xCF,0x65}, {0xAC,0x6F}, {0xCF,0x66},
    {0xAC,0x70}, {0xD1,0xFC}, {0xAE,0xEE}, {0xAE,0xED},
    {0xD5,0xDE}, {0xD5,0xDC}, {0xD5,0xDD}, {0xD5,0xDB},
    {0xD5,0xDA}, {0xD9,0xDE}, {0xD9,0xE1}, {0xB4,0xDE},
    {0xD9,0xDF}, {0xB4,0xDD}, {0xD9,0xE0}, {0xDD,0xFB},
    {0xE2,0x66}, {0xE2,0x67}, {0xE2,0x68}, {0xE5,0xF3},
    {0xE5,0xF2}, {0xBC,0xDC}, {0xE5,0xF1}, {0xE5,0xF4},
    {0xE9,0xE1}, {0xE9,0xE2}, {0xE9,0xE3}, {0xED,0x4C},
    {0xC0,0xD4}, {0xC2,0x6C}, {0xF2,0x5A}, {0xC4,0xE8},
    {0xC9,0x5F}, {0xAC,0x71}, {0xCF,0x67}, {0xAE,0xEF},
    {0xB1,0xFE}, {0xB4,0xDF}, {0xD9,0xE2}, {0xB7,0xB5},
    {0xB7,0xB4}, {0x8D,0xD2}, {0xE2,0x69}, {0xE2,0x6A},
    {0xBC,0xDD}, {0xBC,0xDE}, {0xE9,0xE5}, {0xE9,0xE4},
    {0xEF,0xE9}, {0xF7,0xE3}, {0xA4,0xF0}, {0xC9,0x60},
    {0xA5,0xC0}, {0xA8,0x43}, {0xCB,0x48}, {0xAC,0x72},
    {0xB7,0xB6}, {0xA4,0xF1}, {0xCF,0x68}, {0xAC,0x73},
    {0xCF,0x69}, {0xC0,0xD5}, {0xA4,0xF2}, {0xFD,0x71},
    {0xCC,0xEC}, {0xCF,0x6A}, {0xFD,0x6F}, {0xD2,0x42},
    {0xD2,0x41}, {0xD1,0xFE}, {0xD1,0xFD}, {0xD2,0x43},
    {0xD2,0x40}, {0x8D,0xD3}, {0xB2,0x40}, {0xB2,0x41},
    {0xB4,0xE0}, {0xD9,0xE3}, {0xD9,0xE4}, {0xD9,0xE5},
    {0xDE,0x41}, {0xDE,0x42}, {0xDE,0x40}, {0x9F,0xE7},
    {0xDD,0xFD}, {0xDD,0xFE}, {0xB7,0xB7}, {0xE2,0x6B},
    {0xE5,0xF7}, {0xE5,0xF6}, {0xE5,0xF5}, {0xE5,0xF8},
    {0xE9,0xE7}, {0xE9,0xE6}, {0xBE,0xFB}, {0xE9,0xE8},
    {0xC0,0xD6}, {0xED,0x4D}, {0xEF,0xEA}, {0xF2,0x5B},
    {0xF6,0xE7}, {0xA4,0xF3}, {0xA5,0xC2}, {0xA5,0xC1},
    {0xAA,0x5D}, {0xC9,0x61}, {0xC9,0x7E}, {0xA6,0xBB},
    {0xC9,0xF7}, {0xCB,0x49}, {0xCB,0x4A}, {0xAA,0x5E},
    {0x90,0xBD}, {0xCC,0xED}, {0xAC,0x74}, {0xCF,0x6B},
    {0xCF,0x6C}, {0xAE,0xF0}, {0xAE,0xF4}, {0xD2,0x44},
    {0xAE,0xF3}, {0xAE,0xF1}, {0xAE,0xF2}, {0xD5,0xDF},
    {0xB2,0x42}, {0xB4,0xE3}, {0xB4,0xE1}, {0xB4,0xE2},
    {0xD9,0xE6}, {0x9F,0xD0}, {0xBA,0x72}, {0xA4,0xF4},
    {0x8B,0xD0}, {0xC9,0xA1}, {0xFD,0x72}, {0xA5,0xC3},
    {0x9C,0xAE}, {0x8B,0xD1}, {0xC9,0xA4}, {0x8A,0xDB},
    {0xA5,0xC6}, {0xC9,0xA3}, {0xA5,0xC5}, {0xA5,0xC4},
    {0xA8,0x44}, {0xC9,0xA2}, {0xC9,0xF8}, {0xFA,0xE4},
    {0xC9,0xFC}, {0xC9,0xFE}, {0xCA,0x40}, {0xA6,0xC5},
    {0xA6,0xC6}, {0xC9,0xFB}, {0xA6,0xC1}, {0xC9,0xF9},
    {0xC9,0xFD}, {0xA6,0xC2}, {0xA6,0xBD}, {0x95,0xCE},
    {0xA6,0xBE}, {0xFD,0x76}, {0xA6,0xC4}, {0xC9,0xFA},
    {0xA6,0xBC}, {0xA8,0x45}, {0xA6,0xBF}, {0xA6,0xC0},
    {0xA6,0xC3}, {0xCB,0x5B}, {0xCB,0x59}, {0xCB,0x4C},
    {0xA8,0x51}, {0xCB,0x53}, {0xA8,0x4C}, {0xCB,0x4D},
    {0xCB,0x55}, {0xFB,0x62}, {0xCB,0x52}, {0xA8,0x4F},
    {0xCB,0x51}, {0xA8,0x56}, {0xCB,0x5A}, {0xA8,0x58},
    {0x8D,0xD4}, {0xA8,0x5A}, {0xCB,0x4B}, {0xFD,0x78},
    {0xA8,0x4D}, {0xCB,0x5C}, {0xA8,0x54}, {0xA8,0x57},
    {0x8E,0xE3}, {0xCD,0x45}, {0xA8,0x47}, {0xA8,0x5E},
    {0xA8,0x55}, {0xCB,0x4E}, {0xA8,0x4A}, {0xA8,0x59},
    {0xCB,0x56}, {0xA8,0x48}, {0xA8,0x49}, {0xCD,0x43},
    {0xCB,0x4F}, {0xA8,0x50}, {0xA8,0x5B}, {0xCB,0x5D},
    {0xCB,0x50}, {0xA8,0x4E}, {0xA8,0x53}, {0xCC,0xEE},
    {0xA8,0x5C}, {0xCB,0x57}, {0xA8,0x52}, {0xA8,0x5D},
    {0xA8,0x46}, {0xCB,0x54}, {0xA8,0x4B}, {0xCB,0x58},
    {0xCD,0x44}, {0x90,0x76}, {0x98,0xC6}, {0x8D,0xD5},
    {0xAA,0x6A}, {0xAA,0x7A}, {0xCC,0xF5}, {0xAA,0x71},
    {0x97,0xD1}, {0xCD,0x4B}, {0xAA,0x62}, {0x9E,0xB6},
    {0xAA,0x65}, {0xCD,0x42}, {0xCC,0xF3}, {0xCC,0xF7},
    {0xAA,0x6D}, {0xAA,0x6F}, {0xCC,0xFA}, {0xAA,0x76},
    {0xAA,0x68}, {0xAA,0x66}, {0xAA,0x67}, {0xAA,0x75},
    {0xCD,0x47}, {0xAA,0x70}, {0xCC,0xF9}, {0xCC,0xFB},
    {0xAA,0x6E}, {0xAA,0x73}, {0xCC,0xFC}, {0xCD,0x4A},
    {0xAC,0x75}, {0xAA,0x79}, {0xFA,0xC7}, {0xAA,0x63},
    {0xCD,0x49}, {0xA0,0x42}, {0xCD,0x4D}, {0xCC,0xF8},
    {0xCD,0x4F}, {0xCD,0x40}, {0xAA,0x6C}, {0xCC,0xF4},
    {0xAA,0x6B}, {0xAA,0x7D}, {0xAA,0x72}, {0xCC,0xF2},
    {0xCF,0x75}, {0xAA,0x78}, {0xAA,0x7C}, {0xCD,0x41},
    {0xCD,0x46}, {0x98,0x73}, {0xAA,0x7E}, {0xAA,0x77},
    {0xAA,0x69}, {0xAA,0x5F}, {0xAA,0x64}, {0xCC,0xF6},
    {0xAA,0x60}, {0xCD,0x4E}, {0x9F,0xFC}, {0xCC,0xF0},
    {0xCC,0xEF}, {0xCC,0xFD}, {0xCC,0xF1}, {0xAA,0x7B},
    {0xAE,0xF5}, {0xAA,0x74}, {0xCC,0xFE}, {0xAA,0x61},
    {0xAC,0xA6}, {0xCD,0x4C}, {0x8C,0xA5}, {0xCF,0x7C},
    {0xCF,0xA1}, {0x8D,0xD7}, {0xCF,0xA4}, {0xCF,0x77},
    {0x92,0xFB}, {0x8D,0xD8}, {0xCF,0xA7}, {0xCF,0xAA},
    {0xCF,0xAC}, {0xCF,0x74}, {0xAC,0x76}, {0xAC,0x7B},
    {0xD2,0x49}, {0xAC,0xAD}, {0xCF,0xA5}, {0xCF,0xAD},
    {0xCF,0x7B}, {0xCF,0x73}, {0xD2,0x64}, {0xAC,0x7E},
    {0xCF,0xA2}, {0xCF,0x78}, {0xCF,0x7A}, {0xAC,0xA5},
    {0xCF,0x7D}, {0xAC,0x7D}, {0xCF,0x70}, {0xCF,0xA8},
    {0xCF,0xAB}, {0x94,0x4F}, {0xAC,0x7A}, {0x8D,0xD9},
    {0xAC,0xA8}, {0xCF,0x6D}, {0xAC,0xAA}, {0xAC,0x78},
    {0xAC,0xAE}, {0xCF,0xA9}, {0xCF,0x6F}, {0xAC,0xAB},
    {0xD2,0x5E}, {0xCD,0x48}, {0xAC,0x7C}, {0xAC,0x77},
    {0xCF,0x76}, {0xCF,0x6E}, {0xAC,0xAC}, {0xAC,0xA4},
    {0xCF,0xA3}, {0xAC,0xA9}, {0xAC,0xA7}, {0xCF,0x79},
    {0xAC,0xA1}, {0xCF,0x71}, {0xAC,0xA2}, {0xAC,0xA3},
    {0xCF,0x72}, {0xCF,0xA6}, {0xAC,0x79}, {0xCF,0x7E},
    {0x89,0x6B}, {0x97,0xCE}, {0xD2,0x4C}, {0xAE,0xFD},
    {0xAF,0x43}, {0xFA,0xF3}, {0xFD,0xAE}, {0xD2,0x55},
    {0xD2,0x5B}, {0xD2,0x57}, {0xD2,0x4A}, {0xD2,0x4D},
    {0xD2,0x46}, {0xD2,0x47}, {0xAF,0x4A}, {0xAE,0xFA},
    {0xD2,0x56}, {0xD2,0x5F}, {0xAF,0x45}, {0xAE,0xF6},
    {0xAF,0x40}, {0xD2,0x4E}, {0xAF,0x42}, {0xD2,0x4F},
    {0xD2,0x59}, {0xFB,0xAF}, {0x92,0xB7}, {0xAF,0x44},
    {0xD2,0x68}, {0xD2,0x48}, {0xAE,0xFC}, {0xAE,0xFB},
    {0xAF,0x48}, {0xD2,0x45}, {0xD2,0x66}, {0xD2,0x5A},
    {0xD2,0x67}, {0xD2,0x61}, {0xD2,0x53}, {0xD2,0x62},
    {0x8D,0xDA}, {0xD2,0x5C}, {0xD2,0x65}, {0xD2,0x63},
    {0xAF,0x49}, {0xD2,0x54}, {0xAE,0xF9}, {0xAE,0xF8},
    {0xAF,0x41}, {0xAF,0x47}, {0xD2,0x60}, {0xAF,0x46},
    {0xD2,0x51}, {0xB2,0x43}, {0x9C,0x5A}, {0xD2,0x69},
    {0xD2,0x50}, {0xD2,0x4B}, {0xAE,0xFE}, {0xAF,0x4B},
    {0xAE,0xF7}, {0xFD,0xAD}, {0xD2,0x58}, {0xD2,0x5D},
    {0x8D,0xDC}, {0x94,0x44}, {0xB2,0x65}, {0xD5,0xE1},
    {0xD5,0xE5}, {0xB2,0x52}, {0xB2,0x50}, {0x8D,0xDD},
    {0xB2,0x47}, {0xD5,0xE3}, {0xD5,0xE2}, {0xB2,0x5B},
    {0xD5,0xE8}, {0xB2,0x55}, {0xA0,0xD6}, {0xD5,0xFA},
    {0xD6,0x47}, {0xB2,0x44}, {0xD5,0xF7}, {0xD5,0xF0},
    {0xB2,0x67}, {0xD5,0xE0}, {0xD5,0xFC}, {0xB2,0x64},
    {0xB2,0x58}, {0xB2,0x63}, {0xB2,0x4E}, {0xD5,0xEC},
    {0xD5,0xFE}, {0xD5,0xF6}, {0xB2,0x4F}, {0xB2,0x49},
    {0xD6,0x45}, {0xD5,0xFD}, {0xD6,0x40}, {0xB2,0x51},
    {0xB2,0x59}, {0xD6,0x42}, {0xD5,0xEA}, {0xD5,0xFB},
    {0xD5,0xEF}, {0xD6,0x44}, {0xB2,0x5E}, {0xB2,0x46},
    {0xB2,0x5C}, {0xD5,0xF4}, {0xD5,0xF2}, {0xD5,0xF3},
    {0xB2,0x53}, {0xD5,0xEE}, {0xD5,0xED}, {0xB2,0x48},
    {0xD5,0xE7}, {0xD6,0x46}, {0xB2,0x4A}, {0xD5,0xF1},
    {0xB2,0x68}, {0xB2,0x62}, {0xD5,0xE6}, {0xB2,0x5F},
    {0xB2,0x5D}, {0xB2,0x66}, {0xD5,0xF8}, {0xB2,0x61},
    {0xD2,0x52}, {0xD5,0xF9}, {0xB2,0x60}, {0xD6,0x41},
    {0xB2,0x45}, {0xD5,0xF5}, {0xB2,0x57}, {0xD5,0xE9},
    {0xB2,0x56}, {0xB2,0x54}, {0xB2,0x4C}, {0xB2,0x4B},
    {0xD9,0xE7}, {0xD6,0x43}, {0x8C,0x41}, {0xD5,0xEB},
    {0x97,0xD5}, {0xD9,0xFC}, {0x94,0x4A}, {0xB2,0x4D},
    {0x94,0x4D}, {0x97,0xCB}, {0x8D,0xDE}, {0x8D,0xDF},
    {0xB5,0x41}, {0xB2,0x5A}, {0xB4,0xEE}, {0xD9,0xF6},
    {0xB4,0xFC}, {0xD9,0xEA}, {0xB4,0xEB}, {0xB4,0xE7},
    {0xDA,0x49}, {0xB4,0xED}, {0xB4,0xF1}, {0xB4,0xEC},
    {0xB4,0xF5}, {0xDA,0x4D}, {0xDA,0x44}, {0x8D,0xE0},
    {0xFE,0xF9}, {0xD9,0xF1}, {0xB4,0xFA}, {0xB4,0xF4},
    {0xD9,0xFD}, {0xB4,0xE4}, {0xDA,0x4A}, {0xDA,0x43},
    {0xB4,0xE8}, {0xD9,0xF7}, {0xB4,0xF7}, {0xDA,0x55},
    {0xDA,0x56}, {0xB4,0xE5}, {0xDA,0x48}, {0xB4,0xF9},
    {0xD9,0xFB}, {0xD9,0xED}, {0xD9,0xEE}, {0xB4,0xFD},
    {0xD9,0xF2}, {0xD9,0xF9}, {0xD9,0xF3}, {0xB4,0xFB},
    {0xB5,0x44}, {0xD9,0xEF}, {0xD9,0xE8}, {0xD9,0xE9},
    {0xD9,0xEB}, {0xB4,0xEA}, {0xD9,0xF8}, {0xB4,0xF8},
    {0xB5,0x42}, {0xFD,0xC0}, {0xFC,0xF9}, {0xD9,0xFA},
    {0xDA,0x53}, {0xDA,0x4B}, {0xB4,0xE6}, {0xDA,0x51},
    {0xB4,0xF2}, {0xB4,0xF0}, {0xFB,0x7E}, {0xDA,0x57},
    {0xB4,0xEF}, {0xDA,0x41}, {0xD9,0xF4}, {0xD9,0xFE},
    {0xB5,0x47}, {0xDA,0x45}, {0xDA,0x42}, {0xD9,0xF0},
    {0xB5,0x43}, {0xDA,0x4F}, {0xDA,0x4C}, {0xDA,0x54},
    {0xB4,0xE9}, {0xDA,0x40}, {0xB5,0x46}, {0xDA,0x47},
    {0xB4,0xF3}, {0xB4,0xF6}, {0xDA,0x46}, {0xB5,0x45},
    {0xD9,0xF5}, {0xD5,0xE4}, {0x92,0xB3}, {0xDA,0x50},
    {0xDA,0x4E}, {0xDA,0x52}, {0xFD,0xAF}, {0x8D,0xE1},
    {0xD9,0xEC}, {0xB5,0x40}, {0x95,0xD3}, {0xDE,0x61},
    {0xDE,0x60}, {0xDE,0x46}, {0xB7,0xBD}, {0xDE,0x5F},
    {0xDE,0x49}, {0xDE,0x4A}, {0xB7,0xC7}, {0xDE,0x68},
    {0xB7,0xC2}, {0xDE,0x5E}, {0x89,0xC1}, {0xDE,0x43},
    {0xB7,0xC8}, {0xB7,0xBE}, {0xDE,0x52}, {0xDE,0x48},
    {0xDE,0x4B}, {0xDE,0x63}, {0xB7,0xB8}, {0xDE,0x6A},
    {0xDE,0x62}, {0xB7,0xC1}, {0xDE,0x57}, {0xB7,0xCC},
    {0xB7,0xCB}, {0xB7,0xC5}, {0xDE,0x69}, {0xB7,0xB9},
    {0xDE,0x55}, {0xDE,0x4C}, {0xDE,0x59}, {0xDE,0x65},
    {0xB7,0xCD}, {0xFD,0x68}, {0xB7,0xBB}, {0xDE,0x54},
    {0x9C,0xB7}, {0xDE,0x4D}, {0xB7,0xC4}, {0x8D,0xE3},
    {0xB7,0xC3}, {0xDE,0x50}, {0xDE,0x5A}, {0xDE,0x64},
    {0xDE,0x47}, {0xDE,0x51}, {0xB7,0xBC}, {0xDE,0x5B},
    {0xB7,0xC9}, {0xB7,0xC0}, {0xDE,0x4E}, {0xB7,0xBF},
    {0xDE,0x45}, {0xDE,0x53}, {0xDE,0x67}, {0xB4,0xFE},
    {0xBA,0xB0}, {0xDE,0x56}, {0xE2,0x6C}, {0xDE,0x58},
    {0xDE,0x66}, {0xB7,0xC6}, {0xDE,0x4F}, {0xB7,0xBA},
    {0xB7,0xCA}, {0xBC,0xF0}, {0xDE,0x44}, {0xDE,0x5D},
    {0xFA,0xC0}, {0x8D,0xE5}, {0xFA,0x64}, {0xDE,0x5C},
    {0x89,0x47}, {0x8D,0xE4}, {0x8D,0xE7}, {0x8D,0xE8},
    {0xE2,0xAA}, {0xBA,0xAD}, {0xE2,0x7D}, {0xE2,0xA4},
    {0xBA,0xA2}, {0xE2,0x6E}, {0xBA,0xAF}, {0xBA,0x77},
    {0xE2,0x6D}, {0xE2,0xB0}, {0xBA,0xB1}, {0xE2,0x71},
    {0xE2,0xA3}, {0xFD,0xC7}, {0xE2,0x73}, {0xE2,0xB3},
    {0xE2,0xAF}, {0xBA,0x75}, {0xBA,0xA1}, {0xE6,0x53},
    {0xBA,0xAE}, {0xBA,0x7D}, {0xE2,0x6F}, {0xFD,0xB0},
    {0xE2,0xAE}, {0xBA,0xA3}, {0xE2,0xAB}, {0xE2,0xB8},
    {0xE2,0x75}, {0xE2,0x7E}, {0x94,0x45}, {0x97,0xD6},
    {0xE2,0xB6}, {0xE2,0xAC}, {0xBA,0x7C}, {0xE2,0x7C},
    {0xBA,0x76}, {0xBA,0x74}, {0xBA,0xA8}, {0xFC,0xC6},
    {0x98,0x44}, {0xE2,0x7A}, {0xE2,0x77}, {0xE2,0x78},
    {0xE2,0xB2}, {0xE2,0xB7}, {0xE2,0xB5}, {0xBA,0x7A},
    {0xE2,0xB9}, {0xBA,0x7E}, {0xBA,0xA7}, {0x8D,0xE9},
    {0xE2,0x70}, {0xE5,0xFA}, {0xE2,0x79}, {0xBA,0x78},
    {0xBA,0xAC}, {0xBA,0xA9}, {0xBA,0x7B}, {0xE2,0xA5},
    {0xE2,0x74}, {0xBA,0xAA}, {0xE2,0xA7}, {0xBA,0xA4},
    {0xBA,0xA6}, {0xBA,0x73}, {0x8D,0xEA}, {0xE2,0xA9},
    {0xE2,0xA1}, {0xE2,0x72}, {0xBA,0xA5}, {0xE2,0xB1},
    {0xE2,0xB4}, {0xE2,0x7B}, {0xE2,0xA8}, {0xFE,0x50},
    {0xBA,0x79}, {0xBC,0xDF}, {0xE2,0xA6}, {0xE5,0xF9},
    {0xE2,0xAD}, {0xFD,0xCC}, {0xE2,0x76}, {0xE6,0x44},
    {0xE6,0x4E}, {0xBC,0xE2}, {0xE6,0x4D}, {0xE6,0x59},
    {0xBC,0xE4}, {0xE6,0x4B}, {0x9D,0xA7}, {0xE6,0x4F},
    {0xBC,0xEF}, {0xE6,0x46}, {0xBC,0xE7}, {0xFD,0xCD},
    {0xE6,0x52}, {0xE9,0xF0}, {0xBC,0xF3}, {0xBC,0xF2},
    {0xE6,0x54}, {0xE6,0x43}, {0xE6,0x5E}, {0xBC,0xED},
    {0xBC,0xE3}, {0xE6,0x57}, {0xE6,0x5B}, {0xE6,0x60},
    {0xE6,0x55}, {0xE6,0x49}, {0xBC,0xE6}, {0xBC,0xE9},
    {0xBC,0xF1}, {0xBC,0xEC}, {0xE6,0x4C}, {0xE2,0xA2},
    {0xFD,0xCF}, {0xE6,0x48}, {0xE6,0x5F}, {0xBC,0xE8},
    {0x95,0xD2}, {0xBC,0xEB}, {0xE6,0x61}, {0xBC,0xE0},
    {0xE6,0x56}, {0xE5,0xFB}, {0xE6,0x5C}, {0xC0,0xDF},
    {0x8D,0xED}, {0xE6,0x4A}, {0xBC,0xE1}, {0xE6,0x45},
    {0xBC,0xE5}, {0xE5,0xFC}, {0xBA,0xAB}, {0xE6,0x41},
    {0xFC,0xBA}, {0xE6,0x5A}, {0xE6,0x42}, {0xE6,0x40},
    {0xBC,0xEA}, {0xE6,0x58}, {0xE5,0xFE}, {0xE6,0x51},
    {0xE6,0x50}, {0xE6,0x5D}, {0xE6,0x47}, {0xBC,0xEE},
    {0xFD,0xC5}, {0xE9,0xF3}, {0xFD,0xD2}, {0xBF,0x49},
    {0xBE,0xFE}, {0xEA,0x40}, {0xE9,0xEB}, {0xBF,0x41},
    {0xE9,0xF7}, {0xBF,0x48}, {0xBF,0x43}, {0xE9,0xF5},
    {0xED,0x4F}, {0xE9,0xFB}, {0xEA,0x42}, {0xE9,0xFA},
    {0xE9,0xE9}, {0xE9,0xF8}, {0xEA,0x44}, {0xEA,0x46},
    {0xBE,0xFD}, {0xEA,0x45}, {0xBF,0x44}, {0xBF,0x4A},
    {0x9C,0xDC}, {0xBF,0x47}, {0xE9,0xFE}, {0xBF,0x46},
    {0xE9,0xF9}, {0x95,0xCF}, {0xE9,0xED}, {0xE9,0xF2},
    {0x8D,0xEE}, {0xE9,0xFD}, {0xBF,0x45}, {0xBF,0x42},
    {0xBE,0xFC}, {0xBF,0x40}, {0xE9,0xF1}, {0xE5,0xFD},
    {0xE9,0xEC}, {0xE9,0xEF}, {0xEA,0x41}, {0xE9,0xF4},
    {0xE9,0xEA}, {0xED,0x4E}, {0xEA,0x43}, {0xE9,0xEE},
    {0xE9,0xFC}, {0xFD,0xD4}, {0xED,0x51}, {0xC0,0xE3},
    {0xC0,0xD7}, {0x96,0xEC}, {0x96,0xEB}, {0xC0,0xDB},
    {0xED,0x53}, {0xED,0x59}, {0xED,0x57}, {0xC0,0xD9},
    {0xC0,0xDA}, {0xC0,0xE1}, {0xED,0x5A}, {0xED,0x52},
    {0xC0,0xDC}, {0xED,0x56}, {0xED,0x55}, {0xED,0x5B},
    {0xC0,0xE2}, {0xC0,0xDD}, {0xC0,0xE0}, {0xED,0x54},
    {0xC0,0xE4}, {0xC0,0xDE}, {0xC0,0xE5}, {0xC0,0xD8},
    {0xED,0x58}, {0xED,0x50}, {0x90,0xB6}, {0xEF,0xF7},
    {0xFD,0xC3}, {0xC2,0x71}, {0xEF,0xF4}, {0xEF,0xF6},
    {0xC2,0x6F}, {0xEF,0xF2}, {0xEF,0xF3}, {0xEF,0xEE},
    {0x98,0xAB}, {0xE9,0xF6}, {0xEF,0xEF}, {0xC2,0x70},
    {0xEF,0xEB}, {0xC2,0x6D}, {0xEF,0xF8}, {0xC2,0x6E},
    {0xEF,0xEC}, {0xEF,0xED}, {0xEF,0xF1}, {0xC2,0x73},
    {0xC2,0x72}, {0xEF,0xF0}, {0xC3,0x78}, {0xF2,0x5F},
    {0xF2,0x65}, {0xC3,0x79}, {0xF2,0x5C}, {0xC3,0x76},
    {0xC3,0x73}, {0xF2,0x67}, {0xC3,0x77}, {0x96,0xEE},
    {0xC3,0x74}, {0xF2,0x5E}, {0xF2,0x61}, {0xF2,0x62},
    {0xF2,0x63}, {0xF2,0x66}, {0xEF,0xF5}, {0xF2,0x5D},
    {0xC3,0x75}, {0xF2,0x64}, {0xF2,0x68}, {0xF2,0x60},
    {0x8D,0xF4}, {0xF4,0x5D}, {0xC4,0x6A}, {0xF4,0x60},
    {0xC4,0x6B}, {0xF4,0x68}, {0xF4,0x5F}, {0xF4,0x5C},
    {0xF4,0x5E}, {0xF4,0x62}, {0xF4,0x65}, {0xF4,0x64},
    {0xF4,0x67}, {0xF4,0x5B}, {0xC4,0x69}, {0xF4,0x63},
    {0xF4,0x66}, {0xF4,0x69}, {0xF4,0x61}, {0xF5,0xD3},
    {0xF5,0xD4}, {0xF5,0xD8}, {0xF5,0xD9}, {0xF5,0xD6},
    {0xF5,0xD7}, {0xF5,0xD5}, {0xFD,0xE0}, {0xC4,0xE9},
    {0x8C,0x67}, {0x8D,0xF6}, {0xC5,0x78}, {0xF6,0xEB},
    {0x8D,0xF7}, {0xF6,0xE8}, {0xF6,0xE9}, {0xF6,0xEA},
    {0xC5,0x79}, {0xF7,0xE5}, {0xF7,0xE4}, {0x8F,0xFA},
    {0xF8,0xAF}, {0xC5,0xF4}, {0xF8,0xAD}, {0xF8,0xB0},
    {0xF8,0xAE}, {0xF8,0xF5}, {0xC6,0x57}, {0xC6,0x65},
    {0xF9,0xA3}, {0xF9,0x6C}, {0x97,0xD0}, {0xF9,0xA2},
    {0xF9,0xD0}, {0xF9,0xD1}, {0xA4,0xF5}, {0x8B,0xD2},
    {0x8D,0xF8}, {0xA6,0xC7}, {0xCA,0x41}, {0xCB,0x5E},
    {0x90,0xD9}, {0xA8,0x5F}, {0x8C,0x47}, {0xA8,0x62},
    {0xFA,0xF0}, {0xCB,0x5F}, {0xA8,0x60}, {0xA8,0x61},
    {0xFD,0xE1}, {0x8D,0xF9}, {0xFD,0xE3}, {0xCD,0x58},
    {0xCD,0x5A}, {0xCD,0x55}, {0xCD,0x52}, {0xCD,0x54},
    {0x8D,0xFA}, {0xAA,0xA4}, {0xFB,0x63}, {0xAA,0xA2},
    {0x90,0xA6}, {0xCD,0x56}, {0xAA,0xA3}, {0xCD,0x53},
    {0xCD,0x50}, {0xAA,0xA1}, {0xCD,0x57}, {0xCD,0x51},
    {0xAA,0xA5}, {0xCD,0x59}, {0xCF,0xAF}, {0x99,0x70},
    {0xCF,0xB3}, {0x91,0xEB}, {0xAC,0xB7}, {0x97,0x70},
    {0x98,0x6F}, {0xFD,0xE2}, {0xCF,0xB6}, {0xAC,0xAF},
    {0xAC,0xB2}, {0xAC,0xB4}, {0xAC,0xB6}, {0xAC,0xB3},
    {0xCF,0xB2}, {0xCF,0xB1}, {0xAC,0xB1}, {0xCF,0xB4},
    {0xCF,0xB5}, {0xCF,0xAE}, {0xAC,0xB5}, {0x98,0xF2},
    {0xAC,0xB0}, {0x9A,0xFC}, {0x89,0x6C}, {0xFD,0xFD},
    {0xCF,0xB0}, {0x99,0x5E}, {0x95,0xBD}, {0xD2,0x77},
    {0xD2,0x78}, {0xD2,0x79}, {0xAF,0x50}, {0xAF,0x4C},
    {0xD2,0x6E}, {0xFD,0xE4}, {0xD2,0x76}, {0xD2,0x7B},
    {0xAF,0x51}, {0x91,0xE6}, {0xD2,0x6C}, {0xD2,0x72},
    {0xD2,0x6B}, {0xD2,0x75}, {0xFD,0xE5}, {0xFD,0xE6},
    {0xD2,0x71}, {0xAF,0x4D}, {0xAF,0x4F}, {0xD2,0x7A},
    {0xD2,0x6A}, {0xD2,0x6D}, {0xD2,0x73}, {0xFD,0xE7},
    {0xD2,0x74}, {0xD2,0x7C}, {0xD2,0x70}, {0xAF,0x4E},
    {0xB2,0x6D}, {0xD6,0x4E}, {0x94,0x54}, {0xD6,0x50},
    {0xD6,0x4C}, {0x99,0xB8}, {0xD6,0x58}, {0xD6,0x4A},
    {0xD6,0x57}, {0xB2,0x69}, {0xD6,0x48}, {0xDA,0x5B},
    {0xD6,0x52}, {0xB2,0x6C}, {0x97,0xE9}, {0xD6,0x53},
    {0xD6,0x56}, {0xD6,0x5A}, {0xD6,0x4F}, {0x93,0x46},
    {0xD6,0x54}, {0xB2,0x6A}, {0xB2,0x6B}, {0xD6,0x59},
    {0xD6,0x4D}, {0xD6,0x49}, {0xD6,0x5B}, {0xD6,0x51},
    {0xD6,0x55}, {0xD6,0x4B}, {0xB5,0x48}, {0xB5,0x49},
    {0xDA,0x65}, {0xB5,0x4F}, {0x98,0x63}, {0xDA,0x59},
    {0xDA,0x62}, {0xDA,0x58}, {0xB5,0x4C}, {0xDA,0x60},
    {0xDA,0x5E}, {0xDA,0x5F}, {0xB5,0x4A}, {0xDA,0x63},
    {0x95,0xBC}, {0xFD,0xED}, {0xFD,0xF7}, {0xDA,0x5C},
    {0xDA,0x5A}, {0xB5,0x4B}, {0xDA,0x5D}, {0xDA,0x61},
    {0x98,0x70}, {0x96,0xF6}, {0x8E,0xA9}, {0xB5,0x4D},
    {0xDA,0x64}, {0x94,0x51}, {0x8E,0x43}, {0x8B,0x5A},
    {0xDE,0x70}, {0xDE,0x77}, {0xDE,0x79}, {0xDE,0xA1},
    {0xFD,0xEE}, {0xB7,0xDA}, {0xDE,0x6B}, {0xB7,0xD2},
    {0xFD,0xF0}, {0xDE,0x7A}, {0xB7,0xD7}, {0xDE,0xA2},
    {0xB7,0xCE}, {0xFD,0xF4}, {0xDE,0x7D}, {0x9B,0xF5},
    {0xDE,0x6D}, {0xDE,0x7E}, {0xDE,0x6C}, {0xB7,0xDC},
    {0xDE,0x78}, {0xB7,0xCF}, {0xDE,0xA3}, {0xB7,0xD4},
    {0xDE,0x71}, {0xB7,0xD9}, {0xDE,0x7C}, {0xDE,0x6F},
    {0xDE,0x76}, {0xDE,0x72}, {0xDE,0x6E}, {0xB7,0xD1},
    {0xB7,0xD8}, {0xB7,0xD6}, {0xB7,0xD3}, {0xB7,0xDB},
    {0xB7,0xD0}, {0xDE,0x75}, {0x97,0x7E}, {0xB7,0xD5},
    {0xB5,0x4E}, {0xDE,0x7B}, {0x9B,0xD5}, {0xDE,0x73},
    {0x9A,0xC3}, {0x97,0xC8}, {0xA0,0xDB}, {0x91,0xD0},
    {0xDE,0x74}, {0x9F,0xE4}, {0xE2,0xC1}, {0x8F,0xDD},
    {0xBA,0xB4}, {0x91,0xE9}, {0xE2,0xBD}, {0xE2,0xC3},
    {0xE2,0xBF}, {0xBA,0xB6}, {0xE2,0xBE}, {0xE2,0xC2},
    {0xE2,0xBA}, {0x98,0xE0}, {0xE2,0xBC}, {0xBA,0xB5},
    {0x92,0xCA}, {0x98,0x57}, {0xE2,0xC0}, {0xE2,0xBB},
    {0x8C,0x51}, {0xBA,0xB7}, {0xBA,0xB2}, {0xFD,0xEB},
    {0xE2,0xC4}, {0x9B,0x49}, {0xBA,0xB3}, {0xE6,0x67},
    {0xE6,0x64}, {0xE6,0x70}, {0xE6,0x6A}, {0xE6,0x6C},
    {0xBC,0xF4}, {0xE6,0x66}, {0xE6,0x6E}, {0x9D,0x76},
    {0x9E,0xAF}, {0xE6,0x6D}, {0xE6,0x6B}, {0xE6,0x71},
    {0xBC,0xF7}, {0xE6,0x68}, {0xE6,0x6F}, {0xBC,0xF5},
    {0x9C,0xCC}, {0xE6,0x63}, {0xE6,0x65}, {0xBC,0xF6},
    {0xE6,0x62}, {0xE6,0x72}, {0xFD,0xEA}, {0xE6,0x69},
    {0x8D,0xF1}, {0xEA,0x4A}, {0xBF,0x51}, {0xFD,0xFB},
    {0xEA,0x55}, {0xEA,0x53}, {0xBF,0x4B}, {0xEA,0x49},
    {0xEA,0x4C}, {0xEA,0x4D}, {0xEA,0x48}, {0xBF,0x55},
    {0xBF,0x56}, {0xEA,0x47}, {0xEA,0x56}, {0xEA,0x51},
    {0xBF,0x4F}, {0xBF,0x4C}, {0xEA,0x50}, {0xEA,0x4E},
    {0xBF,0x52}, {0xEA,0x52}, {0xBF,0x4D}, {0x8E,0x53},
    {0xBF,0x4E}, {0xEA,0x4F}, {0xBF,0x50}, {0xEA,0x4B},
    {0xEA,0x54}, {0xBF,0x53}, {0xEA,0x57}, {0xEA,0x58},
    {0xBF,0x54}, {0xFA,0xCF}, {0xC0,0xE7}, {0xC0,0xEE},
    {0xED,0x5C}, {0xED,0x62}, {0xED,0x60}, {0xC0,0xEA},
    {0xC0,0xE9}, {0xC0,0xE6}, {0xED,0x5E}, {0x96,0xF9},
    {0xC0,0xEC}, {0xC0,0xEB}, {0xC0,0xE8}, {0xED,0x61},
    {0xED,0x5D}, {0xED,0x5F}, {0xC0,0xED}, {0x98,0xBF},
    {0x9E,0x49}, {0xC2,0x77}, {0xEF,0xFB}, {0xC2,0x74},
    {0xC2,0x75}, {0xEF,0xFD}, {0xC2,0x76}, {0xEF,0xFA},
    {0x8C,0xA7}, {0xEF,0xF9}, {0xF2,0x6C}, {0xEF,0xFC},
    {0xF2,0x6D}, {0xC3,0x7A}, {0xF2,0x6B}, {0x9B,0xCA},
    {0xF2,0x6A}, {0xF2,0x69}, {0xC3,0x7B}, {0xFD,0xFE},
    {0x92,0xDC}, {0xC4,0x6C}, {0xF4,0x6A}, {0xF4,0x6B},
    {0xFE,0x41}, {0x91,0xCC}, {0x91,0xE2}, {0xF5,0xDC},
    {0xF5,0xDB}, {0xC4,0xEA}, {0xF5,0xDA}, {0xF6,0xEC},
    {0xF6,0xED}, {0xF7,0xE6}, {0xF8,0xB1}, {0xFE,0x44},
    {0xF8,0xF6}, {0xF9,0xBC}, {0xC6,0x79}, {0xF9,0xC6},
    {0xA4,0xF6}, {0x8B,0xD3}, {0xAA,0xA6}, {0xAA,0xA7},
    {0xFE,0x47}, {0xAC,0xB8}, {0xC0,0xEF}, {0xA4,0xF7},
    {0xAA,0xA8}, {0xAF,0x52}, {0xB7,0xDD}, {0xA4,0xF8},
    {0xB2,0x6E}, {0xBA,0xB8}, {0xC9,0x62}, {0xFE,0x48},
    {0xCF,0xB7}, {0xD2,0x7D}, {0xE2,0xC5}, {0xC0,0xF0},
    {0xA4,0xF9}, {0xAA,0xA9}, {0xCF,0xB8}, {0xCF,0xB9},
    {0xDA,0x66}, {0xB5,0x50}, {0xDE,0xA4}, {0x94,0x55},
    {0xB7,0xDE}, {0xE2,0xC6}, {0xFE,0x4B}, {0xBC,0xF8},
    {0xFE,0x4C}, {0xC3,0x7C}, {0xA4,0xFA}, {0xDA,0x67},
    {0xA4,0xFB}, {0x8D,0xBF}, {0xA6,0xC9}, {0xCA,0x42},
    {0xA6,0xC8}, {0xA8,0x65}, {0xA8,0x64}, {0xA8,0x63},
    {0xCB,0x60}, {0x9E,0x78}, {0xAA,0xAA}, {0xAA,0xAB},
    {0xCD,0x5B}, {0xCF,0xBA}, {0xCF,0xBD}, {0xAC,0xBA},
    {0xCF,0xBB}, {0xAC,0xB9}, {0xCF,0xBC}, {0xAC,0xBB},
    {0xD2,0xA2}, {0xD2,0xA1}, {0xD2,0x7E}, {0xAF,0x53},
    {0xD6,0x5D}, {0xD6,0x5E}, {0xB2,0x6F}, {0xD6,0x5C},
    {0xD6,0x5F}, {0xB5,0x52}, {0xB2,0x70}, {0xFE,0x51},
    {0xB5,0x51}, {0xDA,0x6B}, {0xDA,0x6A}, {0x94,0x56},
    {0xDA,0x68}, {0xDA,0x69}, {0xDA,0x6C}, {0xDE,0xA6},
    {0xDE,0xA5}, {0xDE,0xA9}, {0x9D,0x61}, {0xDE,0xA8},
    {0xDE,0xA7}, {0xBA,0xB9}, {0xE2,0xC9}, {0x94,0x57},
    {0xE2,0xC8}, {0xBA,0xBA}, {0xE2,0xC7}, {0xE6,0x73},
    {0xE6,0x74}, {0xBC,0xF9}, {0xEA,0x59}, {0xEA,0x5A},
    {0x99,0x66}, {0xF2,0x72}, {0xC3,0x7D}, {0xF2,0x71},
    {0xF2,0x70}, {0xF2,0x6E}, {0xF2,0x6F}, {0xC4,0xEB},
    {0xF4,0x6C}, {0xF6,0xEE}, {0xF8,0xF7}, {0xA4,0xFC},
    {0x8B,0xD5}, {0xC9,0xA5}, {0xA5,0xC7}, {0xC9,0xA6},
    {0xA0,0x69}, {0xCA,0x43}, {0xCA,0x44}, {0xCB,0x66},
    {0xCB,0x62}, {0xCB,0x61}, {0xAA,0xAC}, {0xCB,0x65},
    {0xA8,0x67}, {0xCB,0x63}, {0xA8,0x66}, {0xCB,0x67},
    {0xCB,0x64}, {0xCD,0x5F}, {0xCF,0xBE}, {0xCD,0x5D},
    {0xCD,0x64}, {0x98,0xB4}, {0xAA,0xAD}, {0xAA,0xB0},
    {0xCD,0x65}, {0xCD,0x61}, {0xCD,0x62}, {0xCD,0x5C},
    {0xAA,0xAF}, {0xCD,0x5E}, {0xAA,0xAE}, {0xCD,0x63},
    {0xCD,0x60}, {0xCF,0xC2}, {0xAC,0xBD}, {0xAC,0xBE},
    {0xA0,0x49}, {0xCF,0xC5}, {0xCF,0xBF}, {0xCF,0xC4},
    {0xCF,0xC0}, {0xAC,0xBC}, {0xCF,0xC3}, {0xCF,0xC1},
    {0xD2,0xA8}, {0xD2,0xA5}, {0xD2,0xA7}, {0xAF,0x58},
    {0xAF,0x57}, {0xAF,0x55}, {0xD2,0xA4}, {0xD2,0xA9},
    {0xAF,0x54}, {0xAF,0x56}, {0xD2,0xA6}, {0xD6,0x67},
    {0xD2,0xA3}, {0xD2,0xAA}, {0xA0,0x4C}, {0x9E,0x65},
    {0xD6,0x62}, {0xD6,0x66}, {0xD6,0x65}, {0xDA,0x6E},
    {0xDA,0x79}, {0xD6,0x68}, {0x98,0xB5}, {0xD6,0x63},
    {0xDA,0x6D}, {0xB2,0x74}, {0xB2,0x73}, {0xD6,0x61},
    {0xD6,0x64}, {0xB2,0x75}, {0xB2,0x72}, {0xB2,0x71},
    {0xD6,0x60}, {0xD6,0x69}, {0xDA,0x70}, {0xDA,0x77},
    {0xB5,0x54}, {0xDA,0x76}, {0xDA,0x73}, {0xFE,0x58},
    {0xB5,0x56}, {0x99,0x75}, {0xFE,0x53}, {0xA0,0x65},
    {0xDA,0x75}, {0xFE,0x59}, {0xDA,0x6F}, {0xDA,0x71},
    {0xDA,0x74}, {0xDA,0x72}, {0xB5,0x55}, {0xDA,0x78},
    {0xB5,0x53}, {0xB7,0xDF}, {0x98,0xB7}, {0x98,0xB8},
    {0xDE,0xAD}, {0xDE,0xAC}, {0xDE,0xAA}, {0xB7,0xE2},
    {0xB7,0xE1}, {0xDE,0xAE}, {0x98,0xBA}, {0xDE,0xAB},
    {0xE2,0xCA}, {0xBA,0xBB}, {0xB7,0xE0}, {0x98,0xBB},
    {0xDE,0xB0}, {0xDE,0xAF}, {0xE2,0xCD}, {0xE2,0xCB},
    {0xBC,0xFA}, {0x9F,0xBC}, {0xBA,0xBC}, {0xE2,0xCC},
    {0xE6,0x76}, {0xBC,0xFB}, {0xE6,0x75}, {0xE6,0x7E},
    {0xE6,0x7D}, {0xE6,0x7B}, {0xE6,0x7A}, {0xE6,0x77},
    {0xE6,0x78}, {0xE6,0x79}, {0xE6,0x7C}, {0xE6,0xA1},
    {0xEA,0x5F}, {0xEA,0x5C}, {0xEA,0x5D}, {0xBF,0x57},
    {0xEA,0x5B}, {0xEA,0x61}, {0xEA,0x60}, {0xEA,0x5E},
    {0xED,0x64}, {0xED,0x65}, {0xC0,0xF1}, {0xA0,0x4A},
    {0xC0,0xF2}, {0xED,0x63}, {0x9E,0xC7}, {0xC2,0x79},
    {0xEF,0xFE}, {0xC2,0x78}, {0xC3,0x7E}, {0xC3,0xA1},
    {0xC4,0x6D}, {0xF4,0x6E}, {0xF4,0x6D}, {0xF5,0xDD},
    {0xF6,0xEF}, {0xC5,0x7A}, {0xF7,0xE8}, {0xF7,0xE7},
    {0xF7,0xE9}, {0xA5,0xC8}, {0xCF,0xC6}, {0xAF,0x59},
    {0xB2,0x76}, {0xD6,0x6A}, {0xA5,0xC9}, {0xC9,0xA7},
    {0xA4,0xFD}, {0x8C,0xA9}, {0xCA,0x45}, {0x98,0xAE},
    {0xCB,0x6C}, {0xCB,0x6A}, {0xCB,0x6B}, {0xCB,0x68},
    {0xA8,0x68}, {0xCB,0x69}, {0x92,0xD6}, {0xFA,0xE1},
    {0xCD,0x6D}, {0x91,0xD4}, {0xAA,0xB3}, {0xCD,0x6B},
    {0xCD,0x67}, {0xCD,0x6A}, {0xCD,0x66}, {0xAA,0xB5},
    {0xCD,0x69}, {0xFA,0xDE}, {0xAA,0xB2}, {0xAA,0xB1},
    {0xFE,0x5B}, {0xAA,0xB4}, {0xCD,0x6C}, {0xCD,0x68},
    {0xAC,0xC2}, {0xAC,0xC5}, {0xCF,0xCE}, {0xCF,0xCD},
    {0xCF,0xCC}, {0xAC,0xBF}, {0xCF,0xD5}, {0xCF,0xCB},
    {0x8C,0x53}, {0xAC,0xC1}, {0xD2,0xAF}, {0xCF,0xD2},
    {0xCF,0xD0}, {0xAC,0xC4}, {0xCF,0xC8}, {0xCF,0xD3},
    {0xCF,0xCA}, {0xCF,0xD4}, {0xCF,0xD1}, {0xCF,0xC9},
    {0xFE,0x5E}, {0xAC,0xC0}, {0xCF,0xD6}, {0xCF,0xC7},
    {0xAC,0xC3}, {0xFB,0xD7}, {0xFE,0x5A}, {0x94,0xC5},
    {0xD2,0xB4}, {0xD2,0xAB}, {0xD2,0xB6}, {0xFA,0xCA},
    {0xD2,0xAE}, {0xD2,0xB9}, {0xD2,0xBA}, {0xD2,0xAC},
    {0xD2,0xB8}, {0xD2,0xB5}, {0xD2,0xB3}, {0xD2,0xB7},
    {0xAF,0x5F}, {0xAF,0x5D}, {0x98,0xC1}, {0x97,0x5C},
    {0xD2,0xB1}, {0xFE,0x74}, {0xD2,0xAD}, {0x97,0x73},
    {0xD2,0xB0}, {0xD2,0xBB}, {0xD2,0xB2}, {0xAF,0x5E},
    {0xCF,0xCF}, {0xAF,0x5A}, {0xAF,0x5C}, {0xFA,0x46},
    {0x97,0x64}, {0xD6,0x78}, {0xD6,0x6D}, {0xD6,0x6B},
    {0xFE,0x68}, {0xD6,0x6C}, {0x96,0x4E}, {0xD6,0x73},
    {0x97,0x65}, {0xD6,0x74}, {0xD6,0x70}, {0xB2,0x7B},
    {0xD6,0x75}, {0xD6,0x72}, {0xD6,0x6F}, {0x8C,0x5A},
    {0xB2,0x79}, {0xD6,0x6E}, {0xB2,0x77}, {0xB2,0x7A},
    {0xD6,0x71}, {0xD6,0x79}, {0xAF,0x5B}, {0xB2,0x78},
    {0xD6,0x77}, {0xD6,0x76}, {0xB2,0x7C}, {0x89,0xA1},
    {0x95,0xFA}, {0x92,0xD4}, {0xFE,0x69}, {0xDA,0x7E},
    {0xFB,0x45}, {0x98,0xC8}, {0xDA,0xA1}, {0xB5,0x60},
    {0x90,0xEF}, {0xDA,0xA7}, {0x98,0xC9}, {0x98,0xCA},
    {0xDA,0xA9}, {0xDA,0xA2}, {0xB5,0x5A}, {0xDA,0xA6},
    {0xDA,0xA5}, {0xB5,0x5B}, {0xB5,0x61}, {0xB5,0x62},
    {0xDA,0xA8}, {0xB5,0x58}, {0xDA,0x7D}, {0xDA,0x7B},
    {0xDA,0xA3}, {0xDA,0x7A}, {0xB5,0x5F}, {0xDA,0x7C},
    {0xDA,0xA4}, {0xDA,0xAA}, {0xB5,0x59}, {0xB5,0x5E},
    {0xB5,0x5C}, {0xB5,0x5D}, {0x94,0x6D}, {0x94,0xB7},
    {0xFE,0x6C}, {0xB5,0x57}, {0x94,0x6B}, {0xB7,0xE9},
    {0xDE,0xB7}, {0xB7,0xE8}, {0xDE,0xBB}, {0x92,0xFC},
    {0xDE,0xB1}, {0x95,0xEB}, {0xDE,0xBC}, {0xFE,0x73},
    {0x97,0x6E}, {0xFE,0x5F}, {0xDE,0xB2}, {0xDE,0xB3},
    {0xDE,0xBD}, {0xDE,0xBA}, {0xDE,0xB8}, {0xDE,0xB9},
    {0xDE,0xB5}, {0xDE,0xB4}, {0xFD,0xBD}, {0xDE,0xBE},
    {0xB7,0xE5}, {0x92,0xD5}, {0xDE,0xB6}, {0xB7,0xEA},
    {0xB7,0xE4}, {0xB7,0xEB}, {0xB7,0xEC}, {0xFE,0xB9},
    {0xB7,0xE7}, {0xB7,0xE6}, {0xFE,0x71}, {0xE2,0xCE},
    {0xBA,0xBE}, {0xBA,0xBD}, {0xFB,0xBB}, {0xE2,0xD3},
    {0x94,0x7A}, {0xBC,0xFC}, {0xBA,0xBF}, {0x95,0xFB},
    {0xFE,0x77}, {0xBA,0xC1}, {0xE2,0xD4}, {0xB7,0xE3},
    {0xBA,0xC0}, {0xE2,0xD0}, {0xE2,0xD2}, {0xE2,0xCF},
    {0xFE,0x79}, {0xE2,0xD1}, {0xFE,0x75}, {0xE6,0xAB},
    {0x94,0x5D}, {0xE6,0xAA}, {0xE6,0xA7}, {0xBD,0x40},
    {0xEA,0x62}, {0xBD,0x41}, {0xE6,0xA6}, {0xFE,0x7C},
    {0xBC,0xFE}, {0xE6,0xA8}, {0xE6,0xA5}, {0xE6,0xA2},
    {0xE6,0xA9}, {0xE6,0xA3}, {0xE6,0xA4}, {0xBC,0xFD},
    {0x93,0x44}, {0x8E,0xA6}, {0xED,0x69}, {0xEA,0x66},
    {0xEA,0x65}, {0xEA,0x67}, {0xED,0x66}, {0xBF,0x5A},
    {0x92,0xD3}, {0xEA,0x63}, {0x94,0xB8}, {0xBF,0x58},
    {0xBF,0x5C}, {0xBF,0x5B}, {0xEA,0x64}, {0xEA,0x68},
    {0xBF,0x59}, {0xFC,0x71}, {0xED,0x6D}, {0xC0,0xF5},
    {0xC2,0x7A}, {0xC0,0xF6}, {0xC0,0xF3}, {0xED,0x6A},
    {0xED,0x68}, {0xED,0x6B}, {0xED,0x6E}, {0xC0,0xF4},
    {0xED,0x6C}, {0xED,0x67}, {0x97,0x5E}, {0xF0,0x42},
    {0xF0,0x45}, {0xF2,0x75}, {0xF0,0x40}, {0x8C,0xAD},
    {0xF4,0x6F}, {0xF0,0x46}, {0xC3,0xA2}, {0xF0,0x44},
    {0xC2,0x7B}, {0xF0,0x41}, {0xF0,0x43}, {0xF0,0x47},
    {0xF2,0x76}, {0xF2,0x74}, {0xFE,0xA7}, {0xC3,0xA3},
    {0xF2,0x73}, {0x94,0x6A}, {0xC4,0x6E}, {0x93,0xE3},
    {0x98,0xCF}, {0xC4,0xED}, {0xF6,0xF1}, {0xC4,0xEC},
    {0xF6,0xF3}, {0xF6,0xF0}, {0xF6,0xF2}, {0xC5,0xD0},
    {0xF8,0xB2}, {0xA5,0xCA}, {0xCD,0x6E}, {0xD2,0xBC},
    {0xD2,0xBD}, {0xB2,0x7D}, {0xDE,0xBF}, {0xBF,0x5D},
    {0xC3,0xA4}, {0xC5,0x7B}, {0xF8,0xB3}, {0xA5,0xCB},
    {0xA0,0xD9}, {0xCD,0x6F}, {0xA2,0x60}, {0xCF,0xD7},
    {0xCF,0xD8}, {0xA0,0xBF}, {0xA0,0x4D}, {0xA0,0xB8},
    {0xD2,0xBE}, {0xD2,0xBF}, {0xB2,0x7E}, {0xB2,0xA1},
    {0xA0,0xCE}, {0xDA,0xAB}, {0xDE,0xC2}, {0xDE,0xC1},
    {0xDE,0xC0}, {0xE2,0xD5}, {0xE2,0xD6}, {0xE2,0xD7},
    {0xBA,0xC2}, {0xA0,0xB7}, {0xE6,0xAD}, {0xE6,0xAC},
    {0xEA,0x69}, {0xBF,0x5E}, {0xBF,0x5F}, {0xFE,0xA9},
    {0xED,0x72}, {0xED,0x6F}, {0xED,0x70}, {0xED,0x71},
    {0xF0,0x49}, {0xF0,0x48}, {0xC2,0x7C}, {0xF2,0x77},
    {0xF5,0xDE}, {0xA5,0xCC}, {0x89,0xC3}, {0xAC,0xC6},
    {0xB2,0xA2}, {0xDE,0xC3}, {0xFE,0xAB}, {0xA5,0xCD},
    {0xD2,0xC0}, {0xB2,0xA3}, {0xB5,0x63}, {0xB5,0x64},
    {0xA5,0xCE}, {0xA5,0xCF}, {0xCA,0x46}, {0xA8,0x6A},
    {0xA8,0x69}, {0xAC,0xC7}, {0xCF,0xD9}, {0xDA,0xAC},
    {0xA5,0xD0}, {0xA5,0xD1}, {0xA5,0xD2}, {0xA5,0xD3},
    {0x9D,0xF4}, {0x89,0x6D}, {0xA8,0x6B}, {0xA8,0x6C},
    {0xCB,0x6E}, {0xCB,0x6D}, {0x9C,0x7B}, {0xAA,0xB6},
    {0xCD,0x72}, {0xCD,0x70}, {0xCD,0x71}, {0x98,0xD2},
    {0x9F,0xA9}, {0xCF,0xDA}, {0xCF,0xDB}, {0xFE,0xB2},
    {0xAC,0xCB}, {0xAC,0xC9}, {0xFE,0xB1}, {0xAC,0xCA},
    {0xAC,0xC8}, {0x97,0xD9}, {0xA0,0xC4}, {0xAF,0x60},
    {0x94,0x76}, {0xAF,0x64}, {0xAF,0x63}, {0xD2,0xC1},
    {0xAF,0x62}, {0xAF,0x61}, {0xD2,0xC2}, {0x99,0x78},
    {0xB2,0xA6}, {0xD6,0x7B}, {0xD6,0x7A}, {0xB2,0xA4},
    {0xB2,0xA5}, {0xFE,0xB3}, {0xB5,0x66}, {0xB5,0x65},
    {0xDA,0xAE}, {0x98,0xD3}, {0xFE,0xB4}, {0xDA,0xAD},
    {0xB2,0xA7}, {0x98,0xD4}, {0xB7,0xED}, {0xDE,0xC5},
    {0xB7,0xEE}, {0xDE,0xC4}, {0x9F,0xB9}, {0xE2,0xD8},
    {0xE6,0xAE}, {0xBD,0x42}, {0xEA,0x6A}, {0x94,0x71},
    {0xED,0x73}, {0xC3,0xA6}, {0xC3,0xA5}, {0xC5,0x7C},
    {0xA5,0xD4}, {0xCD,0x73}, {0x98,0xD5}, {0xFE,0xB8},
    {0xB2,0xA8}, {0xE2,0xD9}, {0xBA,0xC3}, {0xC6,0xD4},
    {0xCB,0x6F}, {0xCB,0x70}, {0xCD,0x74}, {0xAA,0xB8},
    {0xAA,0xB9}, {0xAA,0xB7}, {0xFE,0xBA}, {0xAC,0xCF},
    {0xAC,0xD0}, {0xAC,0xCD}, {0xAC,0xCE}, {0xCF,0xDC},
    {0xCF,0xDD}, {0xAC,0xCC}, {0xD2,0xC3}, {0x9E,0x5C},
    {0xAF,0x68}, {0xAF,0x69}, {0xFE,0xBB}, {0xB2,0xAB},
    {0xD2,0xC9}, {0xAF,0x6E}, {0xAF,0x6C}, {0xD2,0xCA},
    {0xD2,0xC5}, {0xAF,0x6B}, {0xAF,0x6A}, {0xAF,0x65},
    {0xD2,0xC8}, {0xD2,0xC7}, {0xD2,0xC4}, {0xAF,0x6D},
    {0xA0,0x44}, {0xD2,0xC6}, {0xAF,0x66}, {0xAF,0x67},
    {0x98,0xD7}, {0xB2,0xAC}, {0xD6,0xA1}, {0xD6,0xA2},
    {0xB2,0xAD}, {0xD6,0x7C}, {0xD6,0x7E}, {0xD6,0xA4},
    {0xD6,0xA3}, {0xD6,0x7D}, {0xB2,0xA9}, {0xB2,0xAA},
    {0xDA,0xB6}, {0xB5,0x6B}, {0xB5,0x6A}, {0xDA,0xB0},
    {0xB5,0x68}, {0x98,0xD8}, {0xDA,0xB3}, {0xB5,0x6C},
    {0xDA,0xB4}, {0xB5,0x6D}, {0xDA,0xB1}, {0xB5,0x67},
    {0xB5,0x69}, {0xDA,0xB5}, {0xDA,0xB2}, {0xDA,0xAF},
    {0xDE,0xD2}, {0xDE,0xC7}, {0xB7,0xF0}, {0xB7,0xF3},
    {0xB7,0xF2}, {0xB7,0xF7}, {0xB7,0xF6}, {0xDE,0xD3},
    {0xDE,0xD1}, {0xDE,0xCA}, {0xDE,0xCE}, {0xDE,0xCD},
    {0xB7,0xF4}, {0xDE,0xD0}, {0xDE,0xCC}, {0xDE,0xD4},
    {0xDE,0xCB}, {0xB7,0xF5}, {0xB7,0xEF}, {0xB7,0xF1},
    {0xFE,0xBC}, {0xDE,0xC9}, {0x9F,0xFE}, {0xE2,0xDB},
    {0xBA,0xC7}, {0xE2,0xDF}, {0xBA,0xC6}, {0xE2,0xDC},
    {0xBA,0xC5}, {0xDE,0xC8}, {0xDE,0xCF}, {0xE2,0xDE},
    {0xBA,0xC8}, {0xE2,0xE0}, {0xE2,0xDD}, {0xE2,0xDA},
    {0xE6,0xB1}, {0xE6,0xB5}, {0xE6,0xB7}, {0xE6,0xB3},
    {0xE6,0xB2}, {0xE6,0xB0}, {0xBD,0x45}, {0xBD,0x43},
    {0xBD,0x48}, {0xBD,0x49}, {0xE6,0xB4}, {0xBD,0x46},
    {0xE6,0xAF}, {0xBD,0x47}, {0xBA,0xC4}, {0xE6,0xB6},
    {0xBD,0x44}, {0xFE,0xBD}, {0xEA,0x6C}, {0xEA,0x6B},
    {0xEA,0x73}, {0xEA,0x6D}, {0xEA,0x72}, {0xEA,0x6F},
    {0xBF,0x60}, {0xEA,0x71}, {0xBF,0x61}, {0xBF,0x62},
    {0x9D,0xDD}, {0xEA,0x70}, {0xEA,0x6E}, {0x9E,0xE1},
    {0xC0,0xF8}, {0xED,0x74}, {0xC0,0xF7}, {0xED,0x77},
    {0xED,0x75}, {0xED,0x76}, {0xC0,0xF9}, {0x98,0xDA},
    {0x9D,0xDF}, {0xFE,0xBF}, {0xF0,0x4D}, {0xFE,0xBE},
    {0xC2,0xA1}, {0xF0,0x4E}, {0x9E,0xEB}, {0xC2,0x7D},
    {0xF0,0x4F}, {0xC2,0x7E}, {0xF0,0x4C}, {0xF0,0x50},
    {0xF0,0x4A}, {0xC3,0xA7}, {0xF2,0x78}, {0xC3,0xA8},
    {0xC4,0x6F}, {0xF0,0x4B}, {0xC4,0x70}, {0x9E,0x59},
    {0xA0,0x5C}, {0xC4,0xEE}, {0xF5,0xDF}, {0xC5,0x7E},
    {0xF6,0xF4}, {0xC5,0x7D}, {0xFE,0xC0}, {0xF7,0xEA},
    {0xC5,0xF5}, {0xC5,0xF6}, {0x94,0x77}, {0x98,0xDC},
    {0xF9,0xCC}, {0xFE,0xC1}, {0xAC,0xD1}, {0xCF,0xDE},
    {0x98,0xDE}, {0xB5,0x6E}, {0xB5,0x6F}, {0xA5,0xD5},
    {0xA6,0xCA}, {0xCA,0x47}, {0xCB,0x71}, {0xA8,0x6D},
    {0xAA,0xBA}, {0xAC,0xD2}, {0xAC,0xD3}, {0xAC,0xD4},
    {0xD6,0xA6}, {0xD2,0xCB}, {0xAF,0x6F}, {0xB2,0xAE},
    {0xD6,0xA5}, {0xFE,0xC3}, {0xDA,0xB8}, {0xB5,0x71},
    {0xDA,0xB7}, {0xB5,0x70}, {0xDE,0xD5}, {0xBD,0x4A},
    {0xE6,0xBB}, {0xE6,0xB8}, {0xE6,0xB9}, {0xE6,0xBA},
    {0xFE,0xC8}, {0xED,0x78}, {0xFE,0xC9}, {0xF0,0x51},
    {0xF4,0x71}, {0xF4,0x70}, {0xF6,0xF5}, {0xA5,0xD6},
    {0xCD,0x75}, {0xAF,0x70}, {0xB5,0x72}, {0xDE,0xD6},
    {0xFE,0xCA}, {0xE2,0xE1}, {0xBD,0x4B}, {0xEA,0x74},
    {0xF0,0x52}, {0xF4,0x72}, {0xA5,0xD7}, {0xAA,0xBB},
    {0xAC,0xD7}, {0xCF,0xDF}, {0xAC,0xD8}, {0xAC,0xD6},
    {0xAC,0xD5}, {0xD2,0xCC}, {0xAF,0x71}, {0xFE,0xCB},
    {0xAF,0x72}, {0xAF,0x73}, {0xB2,0xB0}, {0xD6,0xA7},
    {0xB2,0xAF}, {0x9F,0xC2}, {0x8C,0x6B}, {0xDA,0xB9},
    {0xB2,0xB1}, {0xB5,0x73}, {0xDE,0xD7}, {0xB7,0xF8},
    {0xB7,0xF9}, {0xBA,0xC9}, {0xBA,0xCA}, {0xBD,0x4C},
    {0xBF,0x64}, {0xEA,0x75}, {0xBF,0x63}, {0xED,0x79},
    {0xC0,0xFA}, {0xF0,0x53}, {0xF4,0x73}, {0xA5,0xD8},
    {0xA8,0x6E}, {0xCD,0x78}, {0xCD,0x77}, {0xAA,0xBC},
    {0xCD,0x76}, {0xAA,0xBD}, {0xCD,0x79}, {0xCF,0xE5},
    {0xAC,0xDB}, {0xAC,0xDA}, {0xCF,0xE7}, {0xCF,0xE6},
    {0xAC,0xDF}, {0xAC,0xDE}, {0xAC,0xD9}, {0xCF,0xE1},
    {0xCF,0xE2}, {0xCF,0xE3}, {0xAC,0xE0}, {0xCF,0xE0},
    {0xAC,0xDC}, {0xCF,0xE4}, {0xAC,0xDD}, {0x98,0xC4},
    {0x94,0xB0}, {0x94,0xB1}, {0xD2,0xCF}, {0xD2,0xD3},
    {0xD2,0xD1}, {0xD2,0xD0}, {0xD2,0xD4}, {0xD2,0xD5},
    {0xD2,0xD6}, {0xD2,0xCE}, {0xD2,0xCD}, {0xFE,0xD1},
    {0xAF,0x75}, {0xAF,0x76}, {0xD2,0xD7}, {0xD2,0xD2},
    {0xA0,0xC1}, {0xD6,0xB0}, {0xFE,0xD2}, {0xD2,0xD8},
    {0xAF,0x77}, {0xAF,0x74}, {0xA0,0xCD}, {0xD6,0xAA},
    {0xD6,0xA9}, {0xD6,0xAB}, {0xD6,0xAC}, {0xD6,0xAE},
    {0xD6,0xAD}, {0xD6,0xB2}, {0xB2,0xB5}, {0xB2,0xB2},
    {0xB2,0xB6}, {0xD6,0xA8}, {0xB2,0xB7}, {0xD6,0xB1},
    {0xB2,0xB4}, {0xD6,0xAF}, {0xB2,0xB3}, {0xFE,0xD3},
    {0x98,0xE5}, {0xDA,0xBC}, {0xDA,0xBE}, {0xDA,0xBA},
    {0xDA,0xBB}, {0xDA,0xBF}, {0xDA,0xC1}, {0xDA,0xC2},
    {0xDA,0xBD}, {0xDA,0xC0}, {0xB5,0x74}, {0xDE,0xDB},
    {0xDE,0xE0}, {0xDE,0xD8}, {0xDE,0xDC}, {0xFE,0xD6},
    {0xDE,0xE1}, {0xDE,0xDD}, {0xB7,0xFA}, {0xB8,0x43},
    {0xB7,0xFD}, {0xDE,0xD9}, {0xDE,0xDA}, {0xBA,0xCE},
    {0xB8,0x46}, {0xB7,0xFE}, {0xB8,0x44}, {0xB7,0xFC},
    {0xDE,0xDF}, {0xB8,0x45}, {0xDE,0xDE}, {0xB8,0x41},
    {0xB7,0xFB}, {0xB8,0x42}, {0xDE,0xE2}, {0xE2,0xE6},
    {0xE2,0xE8}, {0x91,0xE4}, {0x8F,0xC7}, {0x94,0xAE},
    {0xB8,0x40}, {0x8A,0x4F}, {0x94,0xB2}, {0xE2,0xE3},
    {0xBA,0xCC}, {0xE2,0xE9}, {0xBA,0xCD}, {0xE2,0xE7},
    {0xE2,0xE2}, {0xE2,0xE5}, {0xE2,0xEA}, {0xBA,0xCB},
    {0xE2,0xE4}, {0xBD,0x4E}, {0xE6,0xBF}, {0xE6,0xBE},
    {0xBD,0x51}, {0xBD,0x4F}, {0xE6,0xBC}, {0xBD,0x4D},
    {0xE6,0xBD}, {0xBD,0x50}, {0x8F,0xD4}, {0xEA,0x7D},
    {0xEA,0xA1}, {0x98,0xEA}, {0xEA,0x7E}, {0xEA,0x76},
    {0xEA,0x7A}, {0xEA,0x79}, {0xEA,0x77}, {0xBF,0x66},
    {0xBF,0x67}, {0xBF,0x65}, {0xEA,0x78}, {0xEA,0x7B},
    {0xEA,0x7C}, {0xBF,0x68}, {0xC1,0x40}, {0xED,0xA3},
    {0xC0,0xFC}, {0xED,0x7B}, {0xC0,0xFE}, {0xC1,0x41},
    {0xFE,0xD8}, {0xC0,0xFD}, {0xED,0xA2}, {0xED,0x7C},
    {0xC0,0xFB}, {0xED,0xA1}, {0xED,0x7A}, {0xED,0x7E},
    {0xED,0x7D}, {0x9D,0xE0}, {0xF0,0x55}, {0xC2,0xA4},
    {0xC2,0xA5}, {0xC2,0xA2}, {0x98,0xEE}, {0xC2,0xA3},
    {0xF0,0x54}, {0x95,0xC4}, {0xF2,0x7B}, {0xFC,0xE8},
    {0xC3,0xA9}, {0xF2,0x79}, {0xF2,0x7A}, {0x98,0xEF},
    {0xF4,0x74}, {0xF4,0x77}, {0xF4,0x75}, {0xF4,0x76},
    {0xF5,0xE0}, {0xC4,0xEF}, {0xF7,0xEB}, {0xF8,0xB4},
    {0xC5,0xF7}, {0xF8,0xF8}, {0xF8,0xF9}, {0xC6,0x66},
    {0xA5,0xD9}, {0xAC,0xE1}, {0x8C,0x6E}, {0xDA,0xC3},
    {0xDE,0xE3}, {0xA5,0xDA}, {0xA8,0x6F}, {0xAA,0xBE},
    {0xFA,0xD8}, {0xCF,0xE8}, {0xCF,0xE9}, {0xAF,0x78},
    {0xDA,0xC4}, {0xB5,0x75}, {0xB8,0x47}, {0xC1,0x42},
    {0xED,0xA4}, {0xF2,0x7C}, {0xF4,0x78}, {0xA5,0xDB},
    {0xFE,0xDC}, {0xCD,0xA1}, {0xCD,0x7A}, {0xCD,0x7C},
    {0xCD,0x7E}, {0xCD,0x7D}, {0xCD,0x7B}, {0xAA,0xBF},
    {0xA0,0xAE}, {0xAC,0xE2}, {0xCF,0xF2}, {0xCF,0xED},
    {0xCF,0xEA}, {0x9D,0x4C}, {0xCF,0xF1}, {0xAC,0xE4},
    {0xAC,0xE5}, {0xCF,0xF0}, {0xCF,0xEF}, {0xCF,0xEE},
    {0xCF,0xEB}, {0xCF,0xEC}, {0xCF,0xF3}, {0xAC,0xE3},
    {0x98,0xF1}, {0x98,0xF3}, {0xAF,0x7C}, {0x94,0xC1},
    {0xAF,0xA4}, {0xAF,0xA3}, {0xD2,0xE1}, {0xD2,0xDB},
    {0xD2,0xD9}, {0xAF,0xA1}, {0xD6,0xB9}, {0xAF,0x7A},
    {0xD2,0xDE}, {0xD2,0xE2}, {0xD2,0xE4}, {0xD2,0xE0},
    {0xD2,0xDA}, {0xAF,0xA2}, {0xD2,0xDF}, {0xD2,0xDD},
    {0xAF,0x79}, {0xD2,0xE5}, {0xAF,0xA5}, {0xD2,0xE3},
    {0xAF,0x7D}, {0xD2,0xDC}, {0xAF,0x7E}, {0xAF,0x7B},
    {0x98,0xF5}, {0xFA,0x4F}, {0x96,0xE2}, {0x94,0x50},
    {0xB2,0xB9}, {0x96,0xA2}, {0xD6,0xBA}, {0x98,0xF6},
    {0xD6,0xB3}, {0xD6,0xB5}, {0xD6,0xB7}, {0x96,0xE5},
    {0xD6,0xB8}, {0xD6,0xB6}, {0xB2,0xBA}, {0xD6,0xBB},
    {0x98,0xF7}, {0xD6,0xB4}, {0xA0,0x46}, {0x96,0xE3},
    {0xDA,0xC8}, {0xB5,0x76}, {0xDA,0xD0}, {0xDA,0xC5},
    {0xDA,0xD1}, {0xDA,0xC6}, {0xDA,0xC7}, {0x98,0xF8},
    {0xDA,0xCF}, {0xDA,0xCE}, {0xDA,0xCB}, {0xB2,0xB8},
    {0xB5,0x77}, {0xDA,0xC9}, {0xDA,0xCC}, {0xB5,0x78},
    {0xDA,0xCD}, {0xDA,0xCA}, {0xDE,0xEE}, {0x9E,0xE4},
    {0xDE,0xF2}, {0xB8,0x4E}, {0xE2,0xF0}, {0xB8,0x51},
    {0xDE,0xF0}, {0xF9,0xD6}, {0xDE,0xED}, {0xDE,0xE8},
    {0xDE,0xEA}, {0xDE,0xEB}, {0xDE,0xE4}, {0x94,0xC3},
    {0xB8,0x4D}, {0xB8,0x4C}, {0x94,0xC2}, {0xB8,0x48},
    {0xDE,0xE7}, {0xB8,0x4F}, {0xB8,0x50}, {0xDE,0xE6},
    {0xDE,0xE9}, {0xDE,0xF1}, {0xB8,0x4A}, {0xB8,0x4B},
    {0xDE,0xEF}, {0xDE,0xE5}, {0xE2,0xF2}, {0xBA,0xD0},
    {0xE2,0xF4}, {0xDE,0xEC}, {0xE2,0xF6}, {0xBA,0xD4},
    {0xE2,0xF7}, {0xE2,0xF3}, {0xBA,0xD1}, {0xE2,0xEF},
    {0xBA,0xD3}, {0xE2,0xEC}, {0xE2,0xF1}, {0xE2,0xF5},
    {0xE2,0xEE}, {0xFE,0xE1}, {0xB8,0x49}, {0xFE,0xE9},
    {0xE2,0xEB}, {0xBA,0xD2}, {0xE2,0xED}, {0x96,0xE4},
    {0x89,0xAC}, {0x96,0xDB}, {0xBD,0x54}, {0xE6,0xC1},
    {0xBD,0x58}, {0xBD,0x56}, {0xBA,0xCF}, {0xE6,0xC8},
    {0xE6,0xC9}, {0xBD,0x53}, {0xFE,0xE2}, {0xE6,0xC7},
    {0xE6,0xCA}, {0xBD,0x55}, {0xBD,0x52}, {0xE6,0xC3},
    {0xE6,0xC0}, {0xE6,0xC5}, {0xE6,0xC2}, {0xBD,0x59},
    {0xE6,0xC4}, {0x94,0xC4}, {0xFE,0xE3}, {0xE6,0xC6},
    {0xBD,0x57}, {0xFE,0xE7}, {0x9F,0xFB}, {0xBF,0x6A},
    {0xEA,0xA8}, {0xEA,0xA2}, {0xEA,0xA6}, {0xEA,0xAC},
    {0xEA,0xAD}, {0xEA,0xA9}, {0xEA,0xAA}, {0xEA,0xA7},
    {0x8C,0x59}, {0xEA,0xA4}, {0xBF,0x6C}, {0xBF,0x69},
    {0xEA,0xA3}, {0xEA,0xA5}, {0xBF,0x6B}, {0xEA,0xAB},
    {0x93,0xC9}, {0xC1,0x46}, {0x94,0xE8}, {0xFB,0x56},
    {0xED,0xAA}, {0xED,0xA5}, {0xC1,0x45}, {0x90,0xC5},
    {0xC1,0x43}, {0xED,0xAC}, {0xC1,0x44}, {0xED,0xA8},
    {0xED,0xA9}, {0xED,0xA6}, {0xED,0xAD}, {0xF0,0x56},
    {0xC1,0x47}, {0xED,0xA7}, {0xED,0xAE}, {0xED,0xAB},
    {0xA0,0xA8}, {0xF0,0x5A}, {0xF0,0x57}, {0xC2,0xA6},
    {0xF0,0x5B}, {0xF0,0x5D}, {0xF0,0x5C}, {0xF0,0x58},
    {0xF0,0x59}, {0xF2,0xA3}, {0xC3,0xAA}, {0xF2,0x7E},
    {0xF2,0xA2}, {0xF2,0x7D}, {0xF2,0xA4}, {0xF2,0xA1},
    {0xF4,0x7A}, {0xF4,0x7D}, {0xF4,0x79}, {0xC4,0x71},
    {0xF4,0x7B}, {0xF4,0x7C}, {0xF4,0x7E}, {0xC4,0x72},
    {0xC4,0x74}, {0xC4,0x73}, {0xF5,0xE1}, {0xFE,0xE5},
    {0xF5,0xE3}, {0xF5,0xE2}, {0x98,0xFD}, {0x98,0xFB},
    {0xFE,0xE8}, {0xF6,0xF6}, {0x8E,0xBF}, {0xF8,0xB5},
    {0xF8,0xFA}, {0xA5,0xDC}, {0x8B,0xD8}, {0xFE,0xF7},
    {0xCB,0x72}, {0xAA,0xC0}, {0xCD,0xA3}, {0xAA,0xC1},
    {0xAA,0xC2}, {0xCD,0xA2}, {0xCF,0xF8}, {0xCF,0xF7},
    {0xAC,0xE6}, {0xAC,0xE9}, {0xAC,0xE8}, {0xAC,0xE7},
    {0xCF,0xF4}, {0xCF,0xF6}, {0xCF,0xF5}, {0xD2,0xE8},
    {0xAF,0xA7}, {0xD2,0xEC}, {0xD2,0xEB}, {0xD2,0xEA},
    {0xD2,0xE6}, {0xAF,0xA6}, {0xAF,0xAA}, {0xAF,0xAD},
    {0x8F,0x68}, {0x94,0xC6}, {0xAF,0xAE}, {0xD2,0xE7},
    {0xD2,0xE9}, {0xAF,0xAC}, {0xAF,0xAB}, {0xAF,0xA9},
    {0xAF,0xA8}, {0xD6,0xC2}, {0x9D,0xEA}, {0xD6,0xC0},
    {0xD6,0xBC}, {0xB2,0xBB}, {0xD6,0xBD}, {0xB2,0xBC},
    {0xD6,0xBE}, {0xD6,0xBF}, {0xD6,0xC1}, {0xB2,0xBD},
    {0xDA,0xD5}, {0xFC,0x69}, {0xDA,0xD4}, {0xDA,0xD3},
    {0xDA,0xD2}, {0xDE,0xF6}, {0xB8,0x52}, {0xDE,0xF3},
    {0xDE,0xF5}, {0x9C,0xDA}, {0xB8,0x53}, {0xFE,0xF3},
    {0xB8,0x54}, {0xDE,0xF4}, {0x9C,0x72}, {0xFE,0xF0},
    {0x89,0xC9}, {0xE3,0x41}, {0xE2,0xF9}, {0xE2,0xFA},
    {0xBA,0xD7}, {0xBA,0xD5}, {0xBA,0xD6}, {0xE3,0x43},
    {0x99,0x41}, {0xE3,0x42}, {0xE2,0xFE}, {0xE2,0xFD},
    {0xE2,0xFC}, {0xE2,0xFB}, {0xE3,0x40}, {0xE2,0xF8},
    {0x99,0x42}, {0xE6,0xCB}, {0xE6,0xD0}, {0xE6,0xCE},
    {0xFE,0xF5}, {0x91,0xD7}, {0xE6,0xCD}, {0xE6,0xCC},
    {0xE6,0xCF}, {0xEA,0xAE}, {0x94,0xCC}, {0xBF,0x6D},
    {0xC1,0x48}, {0xED,0xB0}, {0xFE,0xF8}, {0xC1,0x49},
    {0xED,0xAF}, {0xF0,0x5F}, {0xF0,0x5E}, {0xC2,0xA7},
    {0xF2,0xA5}, {0xC3,0xAB}, {0xF4,0xA1}, {0xC5,0xA1},
    {0xF6,0xF7}, {0xF8,0xB7}, {0xF8,0xB6}, {0xC9,0xA8},
    {0xAC,0xEA}, {0xAC,0xEB}, {0xD6,0xC3}, {0xB8,0x56},
    {0xA5,0xDD}, {0xA8,0x72}, {0xA8,0x71}, {0xA8,0x70},
    {0x97,0xA8}, {0xCD,0xA4}, {0xFE,0xFC}, {0xAA,0xC4},
    {0xAA,0xC3}, {0xAC,0xEE}, {0xFD,0xBF}, {0xCF,0xFA},
    {0xCF,0xFD}, {0xCF,0xFB}, {0xAC,0xEC}, {0xAC,0xED},
    {0xFE,0xFE}, {0xCF,0xF9}, {0xCF,0xFC}, {0xAF,0xB5},
    {0xD2,0xF3}, {0xD2,0xF5}, {0xD2,0xF4}, {0xAF,0xB2},
    {0xD2,0xEF}, {0x96,0xD1}, {0xAF,0xB0}, {0xAF,0xAF},
    {0xAF,0xB3}, {0xAF,0xB1}, {0xAF,0xB4}, {0xD2,0xF2},
    {0xD2,0xED}, {0xD2,0xEE}, {0xD2,0xF1}, {0xD2,0xF0},
    {0x94,0xD5}, {0x94,0xD0}, {0xD6,0xC6}, {0xD6,0xC7},
    {0xD6,0xC5}, {0xD6,0xC4}, {0xB2,0xBE}, {0xB5,0x7D},
    {0xDA,0xD6}, {0xDA,0xD8}, {0xDA,0xDA}, {0xB5,0x7C},
    {0x99,0x44}, {0xB5,0x7A}, {0xDA,0xD7}, {0xB5,0x7B},
    {0xDA,0xD9}, {0xB5,0x79}, {0xDF,0x41}, {0xDE,0xF7},
    {0xDE,0xFA}, {0xDE,0xFE}, {0xB8,0x5A}, {0xDE,0xFC},
    {0xDE,0xFB}, {0xDE,0xF8}, {0xDE,0xF9}, {0xB8,0x58},
    {0xDF,0x40}, {0xB8,0x57}, {0xB8,0x5C}, {0xB8,0x5B},
    {0xB8,0x59}, {0xDE,0xFD}, {0xE3,0x49}, {0xE3,0x48},
    {0x8C,0x63}, {0xE3,0x44}, {0xA0,0xB3}, {0xBA,0xD8},
    {0xE3,0x47}, {0xE3,0x46}, {0xBA,0xD9}, {0xBD,0x5E},
    {0xE6,0xD2}, {0x94,0xCF}, {0xBD,0x5F}, {0xBD,0x5B},
    {0xBD,0x5D}, {0x9F,0xFA}, {0xBD,0x5A}, {0xBD,0x5C},
    {0x91,0xE5}, {0xEA,0xAF}, {0x9C,0x6A}, {0xBF,0x70},
    {0xEA,0xB1}, {0xEA,0xB0}, {0x8E,0x49}, {0xE3,0x45},
    {0xBF,0x72}, {0xBF,0x71}, {0xBF,0x6E}, {0xBF,0x6F},
    {0xED,0xB5}, {0xED,0xB3}, {0xC1,0x4A}, {0xED,0xB4},
    {0xED,0xB6}, {0xED,0xB2}, {0xED,0xB1}, {0xF0,0x60},
    {0xC2,0xAA}, {0xC2,0xA8}, {0xC2,0xA9}, {0x8E,0x4C},
    {0xF2,0xA6}, {0xF2,0xA7}, {0xC3,0xAD}, {0xC3,0xAC},
    {0xF4,0xA3}, {0xF4,0xA4}, {0xF4,0xA2}, {0xF6,0xF8},
    {0xF6,0xF9}, {0xA5,0xDE}, {0xCA,0x48}, {0xA8,0x73},
    {0xCD,0xA5}, {0xAA,0xC6}, {0xAA,0xC5}, {0xCD,0xA6},
    {0x8E,0x4D}, {0xD0,0x40}, {0xAC,0xEF}, {0xCF,0xFE},
    {0xAC,0xF0}, {0x9A,0x73}, {0xAF,0xB6}, {0xD2,0xF8},
    {0xD2,0xF6}, {0xD2,0xFC}, {0xAF,0xB7}, {0xD2,0xF7},
    {0xD2,0xFB}, {0xD2,0xF9}, {0xD2,0xFA}, {0xD6,0xC8},
    {0xD6,0xCA}, {0x99,0x47}, {0xB2,0xBF}, {0x8C,0xB1},
    {0xD6,0xC9}, {0xB2,0xC0}, {0xB5,0xA2}, {0xB5,0xA1},
    {0xB5,0x7E}, {0xDA,0xDB}, {0xDF,0x44}, {0xB8,0x5D},
    {0xB8,0x5E}, {0xDF,0x43}, {0xDF,0x42}, {0xE3,0x4A},
    {0xBA,0xDB}, {0xBA,0xDA}, {0xE3,0x4B}, {0xE3,0x4C},
    {0xBD,0x61}, {0xBD,0x60}, {0x8E,0x50}, {0xEA,0xB5},
    {0xE6,0xD3}, {0xE6,0xD5}, {0xE6,0xD4}, {0xEA,0xB4},
    {0xEA,0xB2}, {0xEA,0xB6}, {0xEA,0xB3}, {0xBF,0x73},
    {0x8E,0x4F}, {0x99,0x49}, {0xED,0xB7}, {0xC1,0x4B},
    {0xED,0xB8}, {0xED,0xB9}, {0x8E,0x51}, {0x8E,0x52},
    {0xC2,0xAB}, {0xC2,0xAC}, {0xC4,0x75}, {0x9A,0xB2},
    {0x89,0xA5}, {0xC5,0xD1}, {0xA5,0xDF}, {0x99,0x4C},
    {0xD0,0x41}, {0x9F,0xF8}, {0xD2,0xFD}, {0xAF,0xB8},
    {0x8E,0x56}, {0x99,0x4D}, {0x91,0xCA}, {0x8E,0x57},
    {0xB3,0xBA}, {0xB3,0xB9}, {0x94,0xE1}, {0xB5,0xA4},
    {0xDA,0xDD}, {0xB5,0xA3}, {0xDA,0xDC}, {0x90,0x47},
    {0x8F,0xD8}, {0x8E,0x58}, {0xDF,0x45}, {0xBA,0xDC},
    {0xE3,0x4D}, {0xBA,0xDD}, {0xC4,0x76}, {0xF4,0xA5},
    {0xA6,0xCB}, {0xAA,0xC7}, {0xCD,0xA7}, {0xAC,0xF2},
    {0x94,0xEB}, {0xAC,0xF1}, {0xD0,0x42}, {0xD0,0x43},
    {0xD3,0x40}, {0xD3,0x42}, {0xAF,0xB9}, {0xD3,0x44},
    {0xD3,0x47}, {0xD3,0x45}, {0x8E,0x5C}, {0x95,0x53},
    {0xD3,0x46}, {0xD3,0x43}, {0xD2,0xFE}, {0xAF,0xBA},
    {0xD3,0x48}, {0xD3,0x41}, {0x9F,0xE5}, {0xD6,0xD3},
    {0xB2,0xC6}, {0xD6,0xDC}, {0xB2,0xC3}, {0xD6,0xD5},
    {0xB2,0xC7}, {0x9F,0x56}, {0xB2,0xC1}, {0xD6,0xD0},
    {0xD6,0xDD}, {0xD6,0xD1}, {0xD6,0xCE}, {0xB2,0xC5},
    {0x95,0x4F}, {0xB2,0xC2}, {0x8E,0x5E}, {0xD6,0xD4},
    {0xD6,0xD7}, {0xB2,0xC4}, {0xD6,0xD8}, {0xB2,0xC8},
    {0xD6,0xD9}, {0xD6,0xCF}, {0xD6,0xD6}, {0xD6,0xDA},
    {0xD6,0xD2}, {0xD6,0xCD}, {0xD6,0xCB}, {0xD6,0xDB},
    {0x99,0x6A}, {0xDA,0xDF}, {0xDA,0xE4}, {0x9C,0x64},
    {0x9C,0xD9}, {0xDA,0xE0}, {0xDA,0xE6}, {0xB5,0xA7},
    {0xD6,0xCC}, {0xDA,0xE1}, {0xB5,0xA5}, {0xDA,0xDE},
    {0xB5,0xAC}, {0xDA,0xE2}, {0xB5,0xAB}, {0xDA,0xE3},
    {0xB5,0xAD}, {0xB5,0xA8}, {0xB5,0xAE}, {0xB5,0xA9},
    {0xB5,0xAA}, {0x8E,0x5D}, {0xB5,0xA6}, {0xDA,0xE5},
    {0xB8,0x61}, {0xDF,0x50}, {0x99,0x50}, {0xDF,0x53},
    {0xDF,0x47}, {0xDF,0x4C}, {0xDF,0x46}, {0xB8,0x63},
    {0xDF,0x4A}, {0x99,0x51}, {0xDF,0x48}, {0xB8,0x62},
    {0x8E,0x62}, {0xDF,0x4F}, {0xDF,0x4E}, {0xDF,0x4B},
    {0xDF,0x4D}, {0xDF,0x49}, {0xBA,0xE1}, {0xDF,0x52},
    {0xB8,0x5F}, {0xDF,0x51}, {0x99,0x52}, {0xE3,0x5D},
    {0xBA,0xE8}, {0xE3,0x58}, {0xBA,0xE7}, {0xE3,0x4E},
    {0xE3,0x50}, {0xBA,0xE0}, {0xE3,0x55}, {0xE3,0x54},
    {0xE3,0x57}, {0xBA,0xE5}, {0xE3,0x52}, {0xE3,0x51},
    {0x8E,0x68}, {0xBA,0xE4}, {0xBA,0xDF}, {0xE3,0x53},
    {0xBA,0xE2}, {0xE3,0x59}, {0xE3,0x5B}, {0xE3,0x56},
    {0xE3,0x4F}, {0xBA,0xE3}, {0xBD,0x69}, {0xBA,0xDE},
    {0x8E,0x61}, {0x9F,0x59}, {0xE3,0x5C}, {0xE6,0xD9},
    {0xBD,0x62}, {0xE6,0xDB}, {0xBD,0x63}, {0x8B,0xB3},
    {0xBD,0x65}, {0xE6,0xDE}, {0xE6,0xD6}, {0xBA,0xE6},
    {0xE6,0xDC}, {0xE6,0xD8}, {0xB8,0x60}, {0xBD,0x68},
    {0xBD,0x64}, {0xBD,0x66}, {0xBD,0x67}, {0xBF,0x76},
    {0xE6,0xDD}, {0xE6,0xD7}, {0xBD,0x6A}, {0xE6,0xDA},
    {0x9F,0x5D}, {0x8E,0x66}, {0xEA,0xC0}, {0xEA,0xBB},
    {0xEA,0xC5}, {0xBF,0x74}, {0xEA,0xBD}, {0xBF,0x78},
    {0xEA,0xC3}, {0xEA,0xBA}, {0xEA,0xB7}, {0xEA,0xC6},
    {0xC1,0x51}, {0xBF,0x79}, {0xEA,0xC2}, {0xEA,0xB8},
    {0xBF,0x77}, {0xEA,0xBC}, {0xBF,0x7B}, {0xEA,0xB9},
    {0xEA,0xBE}, {0xBF,0x7A}, {0xEA,0xC1}, {0xEA,0xC4},
    {0x8C,0xB2}, {0xED,0xCB}, {0xED,0xCC}, {0xED,0xBC},
    {0xED,0xC3}, {0xED,0xC1}, {0xC1,0x4F}, {0xED,0xC8},
    {0xEA,0xBF}, {0x8E,0x6E}, {0xED,0xBF}, {0x9F,0x64},
    {0xED,0xC9}, {0xC1,0x4E}, {0xED,0xBE}, {0xED,0xBD},
    {0xED,0xC7}, {0xED,0xC4}, {0xED,0xC6}, {0xED,0xBA},
    {0xED,0xCA}, {0xC1,0x4C}, {0xED,0xC5}, {0xED,0xCE},
    {0xED,0xC2}, {0xC1,0x50}, {0xC1,0x4D}, {0xED,0xC0},
    {0xED,0xBB}, {0xED,0xCD}, {0xBF,0x75}, {0x99,0x53},
    {0xFA,0xB8}, {0xF0,0x63}, {0x99,0x54}, {0xF0,0x61},
    {0xF0,0x67}, {0xC2,0xB0}, {0xF0,0x65}, {0xF0,0x64},
    {0xC2,0xB2}, {0xF0,0x6A}, {0xC2,0xB1}, {0xF0,0x6B},
    {0xF0,0x68}, {0xC2,0xAE}, {0xF0,0x69}, {0xF0,0x62},
    {0xC2,0xAF}, {0xC2,0xAD}, {0xF2,0xAB}, {0xF0,0x66},
    {0xF0,0x6C}, {0xF2,0xA8}, {0x8E,0x70}, {0xC3,0xB2},
    {0xC3,0xB0}, {0xF2,0xAA}, {0xF2,0xAC}, {0xF2,0xA9},
    {0xC3,0xB1}, {0xC3,0xAE}, {0xC3,0xAF}, {0xC3,0xB3},
    {0x9F,0x61}, {0xC4,0x78}, {0x8E,0x72}, {0xF4,0xAA},
    {0xF4,0xA9}, {0xF4,0xA7}, {0xF4,0xA6}, {0xF4,0xA8},
    {0xC4,0x77}, {0xC4,0x79}, {0xC4,0xF0}, {0xA0,0x6B},
    {0xF5,0xE5}, {0xF5,0xE4}, {0x9F,0x40}, {0xF6,0xFA},
    {0xF6,0xFC}, {0xF6,0xFE}, {0xF6,0xFD}, {0xF6,0xFB},
    {0x94,0xED}, {0xC5,0xA3}, {0xC5,0xA2}, {0xC5,0xD3},
    {0xC5,0xD2}, {0xC5,0xD4}, {0xF7,0xED}, {0xF7,0xEC},
    {0xF8,0xFB}, {0xF8,0xB8}, {0xF8,0xFC}, {0xC6,0x58},
    {0x94,0xEE}, {0xC6,0x59}, {0xF9,0x6D}, {0x9F,0xBD},
    {0xC6,0x7E}, {0xA6,0xCC}, {0x8E,0x7B}, {0xCD,0xA8},
    {0xD0,0x45}, {0xD0,0x46}, {0xD0,0x44}, {0x99,0x57},
    {0x94,0xF7}, {0xAC,0xF3}, {0x9F,0x5F}, {0xD0,0x47},
    {0xD0,0x48}, {0xD0,0x49}, {0x8E,0x73}, {0xD3,0x49},
    {0xD3,0x4F}, {0x9F,0x62}, {0xD3,0x4D}, {0xAF,0xBB},
    {0xD3,0x4B}, {0xD3,0x4C}, {0xD3,0x4E}, {0x94,0xF6},
    {0xD3,0x4A}, {0xB2,0xC9}, {0xD6,0xDE}, {0xB2,0xCB},
    {0xD6,0xE0}, {0xB2,0xCA}, {0xD6,0xDF}, {0x99,0x58},
    {0xDA,0xE8}, {0xB5,0xAF}, {0xDA,0xEA}, {0xDA,0xE7},
    {0xD6,0xE1}, {0xB5,0xB0}, {0x8E,0x75}, {0xF9,0xDB},
    {0xDA,0xE9}, {0x90,0x72}, {0x94,0xF8}, {0xDF,0x56},
    {0xB8,0x64}, {0xDF,0x54}, {0xB8,0x65}, {0xDF,0x55},
    {0xB8,0x66}, {0x99,0x5A}, {0xBA,0xE9}, {0xE3,0x61},
    {0xE3,0x5E}, {0xE3,0x60}, {0xBA,0xEA}, {0xBA,0xEB},
    {0xE3,0x5F}, {0xA0,0xB0}, {0x8C,0xB3}, {0xE6,0xDF},
    {0x8E,0x79}, {0xE6,0xE0}, {0x8E,0x78}, {0xBD,0x6B},
    {0xE6,0xE2}, {0xE6,0xE1}, {0x94,0xF3}, {0xA2,0x61},
    {0xEA,0xCA}, {0xEA,0xCB}, {0xEA,0xC7}, {0x98,0xAF},
    {0xEA,0xC8}, {0xBF,0x7C}, {0xBF,0x7D}, {0xEA,0xC9},
    {0xC1,0x57}, {0xA0,0xB2}, {0xC1,0x53}, {0xC1,0x58},
    {0xC1,0x54}, {0xC1,0x56}, {0xC1,0x52}, {0xC1,0x55},
    {0x8E,0x7A}, {0xC2,0xB3}, {0xED,0xCF}, {0xF2,0xAE},
    {0xF2,0xAD}, {0x99,0x5C}, {0xF4,0xAB}, {0xC4,0x7A},
    {0xC4,0x7B}, {0xF7,0x41}, {0xF5,0xE6}, {0x8E,0x7C},
    {0xF7,0x40}, {0x8E,0x7D}, {0xF8,0xFD}, {0xF9,0xA4},
    {0xA6,0xCD}, {0x8B,0xD9}, {0xA8,0x74}, {0x89,0xA2},
    {0xCD,0xA9}, {0xAA,0xC8}, {0xAC,0xF6}, {0xD0,0x4C},
    {0xAC,0xF4}, {0xD0,0x4A}, {0xAC,0xF9}, {0xAC,0xF5},
    {0xAC,0xFA}, {0xAC,0xF8}, {0xD0,0x4B}, {0xAC,0xF7},
    {0xAF,0xBF}, {0xAF,0xBE}, {0xD3,0x5A}, {0xAF,0xC7},
    {0xD3,0x53}, {0xD3,0x59}, {0xAF,0xC3}, {0xD3,0x52},
    {0xD3,0x58}, {0xD3,0x56}, {0xAF,0xC2}, {0xAF,0xC4},
    {0xD3,0x55}, {0xAF,0xBD}, {0xD3,0x54}, {0xAF,0xC8},
    {0xAF,0xC5}, {0xAF,0xC9}, {0xAF,0xC6}, {0xD3,0x51},
    {0xD3,0x50}, {0xD3,0x57}, {0xAF,0xC0}, {0xAF,0xBC},
    {0xAF,0xC1}, {0x9E,0xD7}, {0xD6,0xF0}, {0xD6,0xE9},
    {0xB5,0xB5}, {0xD6,0xE8}, {0xB2,0xCF}, {0xB2,0xD6},
    {0xB2,0xD3}, {0xB2,0xD9}, {0xB2,0xD8}, {0xB2,0xD4},
    {0xD6,0xE2}, {0xD6,0xE5}, {0xD6,0xE4}, {0xB2,0xD0},
    {0xD6,0xE6}, {0xD6,0xEF}, {0xB2,0xD1}, {0xD6,0xE3},
    {0xD6,0xEC}, {0xD6,0xED}, {0xB2,0xD2}, {0xD6,0xEA},
    {0xB2,0xD7}, {0xB2,0xCD}, {0xB2,0xD5}, {0xD6,0xE7},
    {0xB2,0xCC}, {0xD6,0xEB}, {0xD6,0xEE}, {0xA0,0xB6},
    {0xDA,0xFB}, {0xDA,0xF2}, {0xB5,0xB2}, {0xDA,0xF9},
    {0xDA,0xF6}, {0xDA,0xEE}, {0xDA,0xF7}, {0xB5,0xB4},
    {0xDA,0xEF}, {0xDA,0xEB}, {0x9E,0x42}, {0xB8,0x6C},
    {0xDA,0xF4}, {0x8E,0xA4}, {0xB5,0xB1}, {0xDA,0xFA},
    {0xB5,0xB8}, {0xB5,0xBA}, {0xDA,0xED}, {0xB5,0xB9},
    {0xDA,0xF0}, {0xB5,0xB3}, {0xDA,0xF8}, {0xDA,0xF1},
    {0xDA,0xF5}, {0xDA,0xF3}, {0xB5,0xB6}, {0xDA,0xEC},
    {0xB5,0xBB}, {0xB2,0xCE}, {0xB5,0xB7}, {0xB5,0xBC},
    {0xB8,0x68}, {0xDF,0x5D}, {0xDF,0x5F}, {0xDF,0x61},
    {0xDF,0x65}, {0xDF,0x5B}, {0xDF,0x59}, {0xB8,0x6A},
    {0xDF,0x60}, {0xDF,0x64}, {0xDF,0x5C}, {0xDF,0x58},
    {0xDF,0x57}, {0x8E,0xA7}, {0x8C,0x76}, {0xDF,0x62},
    {0xDF,0x5A}, {0xDF,0x5E}, {0xB8,0x6B}, {0xB8,0x69},
    {0xDF,0x66}, {0xB8,0x67}, {0xDF,0x63}, {0xE3,0x72},
    {0x95,0x42}, {0xBA,0xEE}, {0xE3,0x6A}, {0xBD,0x78},
    {0xE3,0x74}, {0xBA,0xF1}, {0xE3,0x78}, {0xBA,0xF7},
    {0xE3,0x65}, {0x98,0x7D}, {0xE3,0x75}, {0xE3,0x62},
    {0x97,0x55}, {0xE3,0x77}, {0xE3,0x66}, {0x8E,0xA8},
    {0xBA,0xFE}, {0xBA,0xFB}, {0xE3,0x76}, {0xE3,0x70},
    {0xBA,0xED}, {0xBA,0xF5}, {0xBA,0xF4}, {0x8E,0xAA},
    {0xBA,0xF3}, {0xBA,0xF9}, {0xE3,0x63}, {0xBA,0xFA},
    {0xE3,0x71}, {0xBA,0xF6}, {0xBA,0xEC}, {0xE3,0x73},
    {0xBA,0xEF}, {0xBA,0xF0}, {0xBA,0xF8}, {0xE3,0x68},
    {0xE3,0x67}, {0xE3,0x64}, {0xE3,0x6C}, {0xE3,0x69},
    {0xE3,0x6D}, {0xBA,0xFD}, {0xE3,0x79}, {0xBA,0xF2},
    {0xE3,0x6E}, {0xE3,0x6F}, {0x89,0xA3}, {0xE3,0x6B},
    {0x99,0x60}, {0x99,0x62}, {0xBA,0xFC}, {0x94,0xFC},
    {0x99,0x61}, {0xE6,0xE7}, {0xBD,0x70}, {0xBD,0x79},
    {0xBD,0x75}, {0xE6,0xE4}, {0x94,0xFA}, {0xBD,0x72},
    {0xBD,0x76}, {0xE6,0xF0}, {0xBD,0x6C}, {0xE6,0xE8},
    {0xBD,0x74}, {0x8E,0xAE}, {0x8E,0xB2}, {0xE6,0xEB},
    {0xE6,0xE6}, {0xBD,0x73}, {0xBD,0x77}, {0xE6,0xE5},
    {0xBD,0x71}, {0xE6,0xEF}, {0xBD,0x6E}, {0xE6,0xEE},
    {0xE6,0xED}, {0xBD,0x7A}, {0xE5,0x72}, {0xBD,0x6D},
    {0x8E,0xB0}, {0xE6,0xEC}, {0xE6,0xE3}, {0xBD,0x7B},
    {0xE6,0xEA}, {0xBD,0x6F}, {0x99,0x63}, {0x97,0xAA},
    {0xE6,0xE9}, {0x94,0xFB}, {0xBF,0xA2}, {0xBF,0xA7},
    {0xBF,0x7E}, {0xEA,0xD8}, {0xEA,0xCF}, {0xEA,0xDB},
    {0xEA,0xD3}, {0xEA,0xD9}, {0xBF,0xA8}, {0xBF,0xA1},
    {0xEA,0xCC}, {0xEA,0xD2}, {0xEA,0xDC}, {0xEA,0xD5},
    {0xEA,0xDA}, {0xEA,0xCE}, {0xEA,0xD6}, {0xBF,0xA3},
    {0xEA,0xD4}, {0xBF,0xA6}, {0xBF,0xA5}, {0xEA,0xD0},
    {0xEA,0xD1}, {0xEA,0xCD}, {0xEA,0xD7}, {0xBF,0xA4},
    {0xEA,0xDE}, {0xEA,0xDD}, {0x8E,0xBB}, {0xED,0xDA},
    {0xED,0xD6}, {0xC1,0x5F}, {0xED,0xD0}, {0xC1,0x59},
    {0xC1,0x69}, {0xED,0xDC}, {0xC1,0x61}, {0xC1,0x5D},
    {0xED,0xD3}, {0xC1,0x64}, {0xC1,0x67}, {0xED,0xDE},
    {0xC1,0x5C}, {0xED,0xD5}, {0xC1,0x65}, {0xED,0xE0},
    {0xED,0xDD}, {0xED,0xD1}, {0xC1,0x60}, {0xC1,0x5A},
    {0xC1,0x68}, {0xED,0xD8}, {0xC1,0x63}, {0xED,0xD2},
    {0xC1,0x5E}, {0xED,0xDF}, {0xC1,0x62}, {0xC1,0x5B},
    {0xED,0xD9}, {0xC1,0x66}, {0xED,0xD7}, {0xED,0xDB},
    {0xF0,0x6E}, {0xF0,0x74}, {0xC2,0xB9}, {0xF0,0x77},
    {0xC2,0xB4}, {0xC2,0xB5}, {0xF0,0x6F}, {0xF0,0x76},
    {0xF0,0x71}, {0xC2,0xBA}, {0xC2,0xB7}, {0x8C,0xDC},
    {0xF0,0x6D}, {0xC2,0xB6}, {0xF0,0x73}, {0xF0,0x75},
    {0xC2,0xB8}, {0xF0,0x72}, {0xF0,0x70}, {0x98,0x76},
    {0x8E,0xA1}, {0xF2,0xB8}, {0xC3,0xB7}, {0xC3,0xB8},
    {0xC3,0xB4}, {0x8C,0xB4}, {0xC3,0xB5}, {0x8E,0xB7},
    {0xF2,0xB4}, {0xF2,0xB2}, {0xF2,0xB6}, {0xC3,0xBA},
    {0xF2,0xB7}, {0xF2,0xB0}, {0xF2,0xAF}, {0xF2,0xB3},
    {0xF2,0xB1}, {0xC3,0xB6}, {0xF2,0xB5}, {0xF4,0xAC},
    {0xC4,0x7E}, {0xC4,0x7D}, {0xF4,0xAD}, {0x9D,0xA6},
    {0xF4,0xAF}, {0xF4,0xAE}, {0xC4,0xA1}, {0xF5,0xEB},
    {0xF5,0xE8}, {0xF5,0xE9}, {0xF5,0xE7}, {0xF5,0xEA},
    {0xC4,0xF2}, {0xF5,0xEC}, {0x9E,0xB0}, {0xC4,0xF1},
    {0xF7,0x42}, {0x8E,0xB8}, {0xC5,0xD5}, {0xC5,0xD7},
    {0xF7,0xEE}, {0xC5,0xD6}, {0xF8,0xB9}, {0xF9,0x40},
    {0xF9,0x42}, {0xF8,0xFE}, {0xF9,0x41}, {0xC6,0x6C},
    {0x9D,0x70}, {0x89,0x6E}, {0x89,0x6F}, {0x89,0x70},
    {0x89,0x71}, {0x89,0x72}, {0x89,0x73}, {0x89,0x74},
    {0xA6,0xCE}, {0x89,0x75}, {0xAC,0xFB}, {0xD2,0x6F},
    {0xAF,0xCA}, {0xB2,0xDA}, {0xDA,0xFC}, {0xDA,0xFD},
    {0x8E,0xBC}, {0x8E,0xBD}, {0xEA,0xDF}, {0xC1,0x6A},
    {0xED,0xE1}, {0x8E,0xBE}, {0xC2,0xBB}, {0x9D,0xD1},
    {0xF2,0xBA}, {0xF2,0xB9}, {0xC4,0xA2}, {0xF5,0xED},
    {0x94,0xFD}, {0xF7,0x43}, {0xC5,0xF8}, {0xCA,0x49},
    {0x8B,0xD7}, {0x8B,0xDA}, {0xAA,0xC9}, {0xA8,0x75},
    {0xD0,0x4D}, {0xD3,0x60}, {0xD3,0x5B}, {0xD3,0x5F},
    {0xD3,0x5D}, {0xAF,0xCB}, {0xD3,0x5E}, {0xD3,0x5C},
    {0xD6,0xF1}, {0xDA,0xFE}, {0xDB,0x40}, {0xDF,0x69},
    {0xDF,0x6A}, {0xB8,0x6E}, {0xB8,0x6F}, {0xDF,0x68},
    {0xDF,0x6B}, {0xDF,0x67}, {0xB8,0x6D}, {0xBB,0x40},
    {0xA0,0xE2}, {0xB8,0x70}, {0xE3,0x7A}, {0xBD,0x7C},
    {0xE6,0xF1}, {0xBD,0x7D}, {0x9F,0xE9}, {0xBF,0xA9},
    {0xEA,0xE2}, {0xEA,0xE0}, {0xEA,0xE1}, {0xED,0xE4},
    {0xED,0xE3}, {0xED,0xE2}, {0xF2,0xBB}, {0xC3,0xB9},
    {0xF2,0xBC}, {0xF7,0x44}, {0xC5,0xF9}, {0xF8,0xBA},
    {0xA6,0xCF}, {0xAA,0xCB}, {0xAA,0xCA}, {0xD0,0x4F},
    {0xAC,0xFC}, {0xFD,0xA8}, {0xD0,0x4E}, {0xD3,0x62},
    {0x8A,0xE7}, {0xAF,0xCC}, {0xD6,0xF2}, {0xD3,0x61},
    {0x8E,0xC2}, {0xB2,0xDC}, {0xD6,0xF5}, {0xD6,0xF3},
    {0xD6,0xF4}, {0xB2,0xDB}, {0xDB,0x42}, {0xDB,0x43},
    {0xDB,0x41}, {0x8E,0xC4}, {0xB8,0x73}, {0xDF,0x6D},
    {0xDF,0x6C}, {0xDF,0x6E}, {0xB8,0x72}, {0xB8,0x71},
    {0xE6,0xF2}, {0xE6,0xF4}, {0x99,0x64}, {0xBD,0x7E},
    {0xE6,0xF3}, {0xEA,0xE3}, {0xBF,0xAA}, {0xF0,0x79},
    {0x99,0x65}, {0xF0,0x78}, {0xC3,0xBB}, {0xF2,0xBD},
    {0xC3,0xBD}, {0xC3,0xBC}, {0xF4,0xB0}, {0xF5,0xEE},
    {0xC4,0xF3}, {0xA6,0xD0}, {0xD0,0x50}, {0xAC,0xFD},
    {0xD3,0x65}, {0xAF,0xCE}, {0xD3,0x64}, {0xD3,0x63},
    {0xAF,0xCD}, {0xD6,0xFB}, {0xD6,0xFD}, {0xD6,0xF6},
    {0xD6,0xF7}, {0xB2,0xDD}, {0xD6,0xF8}, {0xB2,0xDE},
    {0xD6,0xFC}, {0xD6,0xF9}, {0xD6,0xFA}, {0xB2,0xDF},
    {0xB5,0xBE}, {0xB5,0xBF}, {0xDB,0x44}, {0xDF,0x6F},
    {0xDF,0x70}, {0x95,0x4E}, {0xE3,0x7E}, {0xBB,0x43},
    {0xBB,0x41}, {0xBB,0x42}, {0xE3,0x7B}, {0xE3,0x7C},
    {0xE3,0x7D}, {0xE6,0xF9}, {0x98,0xB3}, {0xE6,0xFA},
    {0xBD,0xA1}, {0xE6,0xF7}, {0xE6,0xF6}, {0xE6,0xF8},
    {0xE6,0xF5}, {0xBF,0xAD}, {0xEA,0xE4}, {0xBF,0xAB},
    {0xBF,0xAC}, {0xED,0xE6}, {0xC1,0x6B}, {0xED,0xE5},
    {0xEF,0xA8}, {0xF0,0x7A}, {0xF0,0x7B}, {0xC2,0xBC},
    {0x8E,0xCB}, {0xC2,0xBD}, {0xC1,0x6C}, {0xF2,0xBE},
    {0xF2,0xBF}, {0xF4,0xB1}, {0xC4,0xA3}, {0xA6,0xD1},
    {0x8B,0xDF}, {0xA6,0xD2}, {0xAC,0xFE}, {0xAA,0xCC},
    {0xAF,0xCF}, {0xD0,0x51}, {0x8E,0xCE}, {0xB5,0xC0},
    {0xA6,0xD3}, {0xAD,0x41}, {0xD0,0x52}, {0xD0,0x53},
    {0xAD,0x40}, {0xAD,0x42}, {0xA6,0xD4}, {0xD0,0x54},
    {0xAF,0xD1}, {0xD3,0x66}, {0xAF,0xD3}, {0xAF,0xD0},
    {0xAF,0xD2}, {0xD7,0x41}, {0xB2,0xE0}, {0x8E,0xCF},
    {0xD7,0x40}, {0xD6,0xFE}, {0x99,0x68}, {0xDF,0x71},
    {0xE3,0xA1}, {0x99,0x69}, {0xBD,0xA2}, {0xBF,0xAE},
    {0xEA,0xE6}, {0xEA,0xE5}, {0xED,0xE7}, {0x99,0x6B},
    {0x8E,0xD1}, {0xF5,0xEF}, {0x99,0x6C}, {0xA6,0xD5},
    {0xCB,0x73}, {0xCD,0xAA}, {0xAD,0x43}, {0xD0,0x55},
    {0xD3,0x68}, {0x8E,0xD4}, {0x8E,0xD5}, {0xAF,0xD4},
    {0xD3,0x67}, {0xAF,0xD5}, {0xD7,0x43}, {0xB2,0xE2},
    {0xD7,0x42}, {0xD7,0x44}, {0xB2,0xE1}, {0xDB,0x46},
    {0xDB,0x47}, {0xDB,0x45}, {0xB5,0xC1}, {0x99,0x6D},
    {0xB8,0x74}, {0xB8,0x75}, {0xBB,0x45}, {0xA0,0xBE},
    {0xE3,0xA3}, {0xE3,0xA2}, {0xBB,0x44}, {0x8E,0xD6},
    {0xA0,0xBC}, {0xA0,0xB5}, {0xE6,0xFB}, {0xA0,0xB4},
    {0xE6,0xFC}, {0xEA,0xE7}, {0xC1,0x70}, {0xC1,0x6F},
    {0xC1,0x6D}, {0xC1,0x6E}, {0xC1,0x71}, {0xF0,0x7C},
    {0xC2,0xBF}, {0xC2,0xBE}, {0xF2,0xC0}, {0xF4,0xB2},
    {0xC5,0xA5}, {0xC5,0xA4}, {0xA6,0xD6}, {0x8B,0xE0},
    {0xD1,0xFB}, {0xB8,0x77}, {0xB5,0xC2}, {0xB8,0x76},
    {0xBB,0x46}, {0xA6,0xD7}, {0xC9,0xA9}, {0xA6,0xD8},
    {0xA6,0xD9}, {0xCD,0xAB}, {0xCB,0x76}, {0xCB,0x77},
    {0xA8,0x77}, {0xCB,0x74}, {0xA8,0x76}, {0xA8,0x79},
    {0xCB,0x75}, {0xA8,0x7B}, {0xA8,0x7A}, {0xCB,0x78},
    {0xA8,0x78}, {0x89,0xB5}, {0xAA,0xD1}, {0xAA,0xCF},
    {0xCD,0xAD}, {0xAA,0xCE}, {0x8E,0xDD}, {0xAA,0xD3},
    {0xAA,0xD5}, {0xAA,0xD2}, {0xCD,0xB0}, {0xCD,0xAC},
    {0xAA,0xD6}, {0xAA,0xD0}, {0xA8,0x7C}, {0xAA,0xD4},
    {0xCD,0xAF}, {0x9E,0x5D}, {0x99,0x71}, {0xCD,0xAE},
    {0xAA,0xCD}, {0x89,0xAE}, {0x9D,0xE8}, {0xD0,0x5B},
    {0xAD,0x47}, {0xAD,0x48}, {0xD0,0x5D}, {0x95,0x65},
    {0xD0,0x57}, {0xD0,0x5A}, {0xD0,0x63}, {0xD0,0x61},
    {0xAD,0x49}, {0xD0,0x67}, {0xAD,0x4C}, {0xD0,0x64},
    {0xD0,0x5C}, {0xD0,0x59}, {0xDB,0x49}, {0xD0,0x62},
    {0xAD,0x44}, {0xD0,0x65}, {0xD0,0x56}, {0xD0,0x5F},
    {0xAD,0x46}, {0xAD,0x4B}, {0xD0,0x60}, {0xAD,0x4F},
    {0xAD,0x4D}, {0xD0,0x58}, {0xAD,0x4A}, {0xD0,0x5E},
    {0xAD,0x4E}, {0xAD,0x45}, {0xD0,0x66}, {0x99,0x72},
    {0x8B,0x5C}, {0xAF,0xDA}, {0xAF,0xE3}, {0xAF,0xD8},
    {0xAF,0xD6}, {0xD3,0x6A}, {0xAF,0xDE}, {0xAF,0xDB},
    {0xD3,0x6C}, {0x89,0xB1}, {0xAF,0xDD}, {0xD3,0x6B},
    {0xD3,0x69}, {0xD3,0x6E}, {0xAF,0xE2}, {0xAF,0xE0},
    {0xDB,0x48}, {0xD3,0x6F}, {0xD3,0x6D}, {0xAF,0xD7},
    {0xA0,0xC0}, {0xAF,0xD9}, {0xAF,0xDC}, {0x8E,0xDF},
    {0xAF,0xDF}, {0x95,0x66}, {0xAF,0xE1}, {0x99,0x74},
    {0x99,0x76}, {0x99,0x77}, {0x99,0x79}, {0xD7,0x4E},
    {0xB2,0xE4}, {0x9D,0xDA}, {0xD7,0x45}, {0xD7,0x47},
    {0x8E,0xE0}, {0xD7,0x48}, {0xD7,0x50}, {0xD7,0x4C},
    {0xD7,0x4A}, {0xD7,0x4D}, {0xD7,0x51}, {0xB2,0xE5},
    {0xB2,0xE9}, {0xD7,0x46}, {0xD7,0x4F}, {0xB2,0xE7},
    {0x93,0x5C}, {0xB2,0xE6}, {0xD7,0x4B}, {0xD7,0x49},
    {0xB2,0xE3}, {0xB2,0xE8}, {0x9D,0xE6}, {0x8B,0x5F},
    {0x95,0x63}, {0xB5,0xC8}, {0xDB,0x51}, {0xDB,0x4F},
    {0xB5,0xCA}, {0x95,0x67}, {0xDB,0x4A}, {0xDF,0xA1},
    {0xB5,0xC9}, {0xDB,0x4E}, {0x9D,0xE3}, {0xDB,0x4B},
    {0xB5,0xC5}, {0xB5,0xCB}, {0xDB,0x50}, {0xB5,0xC7},
    {0xDB,0x4D}, {0xBB,0x47}, {0xB5,0xC6}, {0xDB,0x4C},
    {0xB5,0xCC}, {0xB5,0xC4}, {0xB5,0xC3}, {0x99,0x7C},
    {0x99,0x7D}, {0x99,0x7E}, {0xDF,0x77}, {0xDF,0x75},
    {0xDF,0x7B}, {0xDF,0x73}, {0xDF,0xA2}, {0xDF,0x78},
    {0xDF,0x72}, {0xB8,0x7B}, {0xB8,0xA3}, {0xDF,0x7D},
    {0xDF,0x76}, {0xB8,0x7E}, {0x8B,0x5B}, {0xB8,0x7C},
    {0xDF,0x7E}, {0xB8,0x79}, {0xB8,0x78}, {0xDF,0x79},
    {0xB8,0x7D}, {0xB5,0xCD}, {0xDF,0x7C}, {0xDF,0x74},
    {0xB8,0x7A}, {0xB8,0xA1}, {0xB8,0xA2}, {0x99,0xA3},
    {0xBB,0x4C}, {0xBB,0x48}, {0xBB,0x4D}, {0xE3,0xA6},
    {0x99,0xA4}, {0xE3,0xA5}, {0xE3,0xA7}, {0xBB,0x4A},
    {0xE3,0xA4}, {0xBB,0x4B}, {0xE3,0xAA}, {0xE3,0xA9},
    {0xE3,0xA8}, {0xBB,0x49}, {0x99,0xA6}, {0xE7,0x41},
    {0xE7,0x44}, {0xBD,0xA8}, {0xE7,0x43}, {0xBD,0xA7},
    {0xBD,0xA3}, {0xBD,0xA4}, {0xBD,0xA5}, {0xE7,0x40},
    {0xE6,0xFE}, {0xBD,0xA6}, {0xE7,0x42}, {0xE6,0xFD},
    {0x99,0xA8}, {0xEA,0xE9}, {0xEA,0xF3}, {0xBF,0xB1},
    {0xBF,0xB0}, {0x8A,0xBE}, {0xEA,0xED}, {0xEA,0xEF},
    {0xEA,0xEA}, {0xEA,0xEE}, {0xEA,0xE8}, {0xEA,0xF1},
    {0xBF,0xAF}, {0xEA,0xF0}, {0xEA,0xEC}, {0x9E,0x61},
    {0xEA,0xF2}, {0xEA,0xEB}, {0xC1,0x74}, {0xED,0xE8},
    {0xED,0xEE}, {0xC1,0x78}, {0xC1,0x7A}, {0xC1,0x77},
    {0xC1,0x76}, {0x99,0xAA}, {0xC1,0x75}, {0xC1,0x73},
    {0xED,0xE9}, {0xED,0xEC}, {0xC1,0x72}, {0xED,0xED},
    {0xA0,0xC8}, {0xC1,0x79}, {0xED,0xEB}, {0xED,0xEA},
    {0xC2,0xC0}, {0xC2,0xC1}, {0xF0,0xA1}, {0xF0,0x7D},
    {0xF0,0x7E}, {0xF2,0xC2}, {0xF2,0xC1}, {0xC3,0xBE},
    {0xF4,0xB4}, {0xC4,0xA4}, {0xF4,0xB3}, {0xF5,0xF0},
    {0xF7,0x45}, {0xC5,0xA6}, {0xF9,0x43}, {0xF9,0x44},
    {0xC5,0xD8}, {0xA6,0xDA}, {0x99,0xAB}, {0xAA,0xD7},
    {0xDB,0x52}, {0xBB,0x4E}, {0xC1,0x7B}, {0xED,0xEF},
    {0xA6,0xDB}, {0xAF,0xE5}, {0xAF,0xE4}, {0xDB,0x53},
    {0xFE,0xC4}, {0xEA,0xF4}, {0xA6,0xDC}, {0xAD,0x50},
    {0x98,0xC2}, {0xDB,0x54}, {0xDB,0x55}, {0xDB,0x56},
    {0xBB,0x4F}, {0xBF,0xB2}, {0xA6,0xDD}, {0xAA,0xD8},
    {0xD0,0x68}, {0xAF,0xE6}, {0xD3,0x70}, {0xB2,0xEA},
    {0xDB,0x57}, {0xB8,0xA4}, {0xBB,0x50}, {0xBF,0xB3},
    {0xC1,0x7C}, {0xC2,0xC2}, {0xF4,0xB5}, {0xA6,0xDE},
    {0xAA,0xD9}, {0xAF,0xE7}, {0xD7,0x52}, {0xB5,0xCE},
    {0xBB,0x51}, {0xE3,0xAB}, {0xE7,0x45}, {0x8E,0xE8},
    {0xA0,0xBA}, {0xA6,0xDF}, {0xB5,0xCF}, {0xDF,0xA3},
    {0xBB,0x52}, {0xA6,0xE0}, {0xCD,0xB1}, {0xD0,0x69},
    {0xAD,0x51}, {0xD3,0x72}, {0xFD,0x77}, {0xAF,0xEA},
    {0x8E,0xEE}, {0xAF,0xE8}, {0xAF,0xE9}, {0xAF,0xEB},
    {0x9E,0xBF}, {0xD3,0x71}, {0xD7,0x57}, {0xD7,0x54},
    {0xD7,0x56}, {0xB2,0xEB}, {0xB2,0xED}, {0xB2,0xEC},
    {0xD7,0x53}, {0xB2,0xEE}, {0xD7,0x55}, {0xDB,0x58},
    {0xDB,0x59}, {0x89,0xC2}, {0xDB,0x5A}, {0xDF,0xA6},
    {0xDF,0xA7}, {0xDF,0xA5}, {0xDF,0xA8}, {0xB8,0xA5},
    {0xDF,0xA4}, {0xBB,0x53}, {0xE7,0x4A}, {0xE7,0x46},
    {0xE7,0x49}, {0xE7,0x4B}, {0xE7,0x48}, {0xE7,0x47},
    {0x99,0xAC}, {0xEA,0xF5}, {0xEA,0xF6}, {0xEA,0xF7},
    {0xBF,0xB4}, {0xBF,0xB5}, {0xED,0xF1}, {0xED,0xF0},
    {0xED,0xF2}, {0xF0,0xA3}, {0xF0,0xA2}, {0xF2,0xC4},
    {0x95,0x6B}, {0xF2,0xC5}, {0xF2,0xC3}, {0x95,0x6C},
    {0xC4,0xA5}, {0xF4,0xB6}, {0xF4,0xB7}, {0xF7,0x46},
    {0xF7,0xEF}, {0xF8,0xBB}, {0xA6,0xE1}, {0xA8,0x7D},
    {0xC1,0x7D}, {0xA6,0xE2}, {0xD7,0x58}, {0xDB,0x5B},
    {0x99,0xAF}, {0xC6,0x41}, {0xCA,0x4A}, {0x99,0x4A},
    {0x89,0x76}, {0x8F,0x48}, {0xCA,0x4B}, {0xCA,0x4D},
    {0xA6,0xE3}, {0xCA,0x4E}, {0xCA,0x4C}, {0xCB,0xA2},
    {0xCB,0xA3}, {0xCB,0x7B}, {0xFB,0xEE}, {0xCB,0xA1},
    {0xA8,0xA1}, {0xA8,0xA2}, {0xCB,0x7C}, {0xCB,0x7A},
    {0xCB,0x79}, {0xCB,0x7D}, {0xA8,0x7E}, {0xCB,0x7E},
    {0xD0,0x6A}, {0xCD,0xB6}, {0xAA,0xDC}, {0xCD,0xB5},
    {0xCD,0xB7}, {0xAA,0xDB}, {0xCD,0xBC}, {0xAA,0xDF},
    {0xCD,0xB2}, {0xCD,0xC0}, {0xCD,0xC6}, {0xAA,0xE6},
    {0xCD,0xC3}, {0xAA,0xE3}, {0x99,0xAE}, {0xCD,0xB9},
    {0xCD,0xBF}, {0xCD,0xC1}, {0x8E,0xFB}, {0xCD,0xB4},
    {0xAA,0xE2}, {0xAA,0xDD}, {0xCD,0xBA}, {0xAA,0xE4},
    {0xAA,0xE7}, {0xAA,0xE1}, {0xAA,0xDA}, {0xCD,0xBE},
    {0xCD,0xB8}, {0xCD,0xC5}, {0xAA,0xE9}, {0xAA,0xE5},
    {0xAA,0xE0}, {0xCD,0xBD}, {0xAF,0xEC}, {0xCD,0xBB},
    {0xAA,0xDE}, {0xAA,0xE8}, {0x8C,0xD0}, {0xCD,0xB3},
    {0xCD,0xC2}, {0xCD,0xC4}, {0x8B,0x52}, {0x99,0xB0},
    {0x89,0x77}, {0x8F,0x41}, {0xAD,0x62}, {0xAD,0x5C},
    {0xAD,0x64}, {0xAD,0x61}, {0xD0,0x71}, {0xD0,0x74},
    {0xAD,0x5D}, {0x99,0xB1}, {0xD0,0x6B}, {0xAD,0x56},
    {0xAD,0x60}, {0xAD,0x63}, {0xAD,0x65}, {0xD0,0xA2},
    {0xD0,0x77}, {0x8F,0x49}, {0xAD,0x55}, {0xD0,0xA1},
    {0xAD,0x59}, {0xAD,0x57}, {0xAD,0x52}, {0xD0,0x6F},
    {0xD0,0x7E}, {0xD0,0x73}, {0xD0,0x76}, {0xD0,0xA5},
    {0xFA,0x4D}, {0xAD,0x66}, {0xD0,0x7D}, {0xAD,0x5E},
    {0xD0,0x78}, {0xD0,0xA4}, {0xD0,0x75}, {0xD0,0x79},
    {0xD0,0x7C}, {0x9D,0xE4}, {0x8C,0xB5}, {0xD0,0x6D},
    {0xD0,0xA3}, {0xD0,0x7B}, {0xFB,0xE9}, {0x9B,0x54},
    {0xD0,0x6C}, {0x99,0xB2}, {0xD0,0x70}, {0xAD,0x5F},
    {0xAD,0x5A}, {0xAD,0x53}, {0xAD,0x58}, {0xAD,0x54},
    {0xAD,0x67}, {0xD0,0x6E}, {0xD3,0xA5}, {0xAD,0x5B},
    {0x9E,0x68}, {0xD0,0x7A}, {0xCE,0x41}, {0xD3,0xA8},
    {0xAF,0xFA}, {0x8F,0x4A}, {0xD3,0x76}, {0x8F,0x42},
    {0xD3,0xA3}, {0xD3,0x7D}, {0x8F,0x51}, {0xD3,0xB2},
    {0xD3,0xAA}, {0xD3,0x7E}, {0xD3,0xA9}, {0xD3,0x78},
    {0xD3,0x7C}, {0xD3,0xB5}, {0xAF,0xFD}, {0xD3,0xAD},
    {0xD3,0xA4}, {0xAF,0xED}, {0xD3,0xB3}, {0xD3,0x74},
    {0xD3,0xAC}, {0xAF,0xFC}, {0xAF,0xF7}, {0xD3,0x73},
    {0xAF,0xF5}, {0xAF,0xF4}, {0xAF,0xF9}, {0xD3,0xAB},
    {0xAF,0xF1}, {0xAF,0xF8}, {0xD0,0x72}, {0xDB,0x5C},
    {0xD3,0xA6}, {0x98,0x46}, {0xD3,0x7A}, {0xAF,0xFB},
    {0xD3,0x7B}, {0xD3,0xA1}, {0xAF,0xFE}, {0xD3,0x75},
    {0xD3,0xAF}, {0xD3,0xAE}, {0xD3,0xB6}, {0xAF,0xF3},
    {0xAF,0xF0}, {0xD3,0xB4}, {0xD3,0xB0}, {0xD3,0xA7},
    {0xD3,0xA2}, {0xAF,0xF6}, {0xAF,0xF2}, {0xD3,0x77},
    {0xAF,0xEE}, {0xD3,0xB1}, {0xAF,0xEF}, {0xD3,0x79},
    {0x99,0xB4}, {0x8E,0xF5}, {0xFD,0x55}, {0x9C,0xCD},
    {0x89,0x78}, {0xD7,0x5E}, {0xD7,0x60}, {0xD7,0x65},
    {0xD7,0x79}, {0xB2,0xFC}, {0xB2,0xF2}, {0xD7,0x5D},
    {0xB2,0xFD}, {0xB2,0xFE}, {0xD7,0x68}, {0xD7,0x6F},
    {0xD7,0x75}, {0xD7,0x62}, {0xD7,0x69}, {0x8F,0x53},
    {0xB3,0x40}, {0xD7,0x77}, {0xD7,0x72}, {0xB2,0xFA},
    {0xB2,0xF8}, {0xD7,0x6E}, {0xD7,0x6A}, {0xD7,0x5C},
    {0xB2,0xEF}, {0xD7,0x61}, {0xD7,0x59}, {0x8F,0x6F},
    {0xB2,0xF7}, {0xB2,0xF9}, {0xD7,0x66}, {0xD7,0x63},
    {0xB2,0xF4}, {0xD7,0x73}, {0xB2,0xF1}, {0xD7,0x64},
    {0xD7,0x7A}, {0xD7,0x6C}, {0x8E,0x63}, {0xD7,0x6B},
    {0xB2,0xF0}, {0xB2,0xFB}, {0xB2,0xF3}, {0xD7,0x5A},
    {0xD7,0x5F}, {0xD7,0x70}, {0xD7,0x76}, {0xB3,0x41},
    {0xD7,0x5B}, {0xD7,0x67}, {0xD7,0x6D}, {0xB2,0xF6},
    {0x8F,0x56}, {0xD7,0x78}, {0xD7,0x71}, {0xD7,0x74},
    {0xFE,0x76}, {0xB2,0xF5}, {0x9F,0xC6}, {0xDB,0x6C},
    {0xDB,0x60}, {0xB5,0xD7}, {0xDB,0x7D}, {0xDB,0xA7},
    {0xDB,0xAA}, {0xB5,0xD5}, {0xDB,0x68}, {0xDB,0xA3},
    {0xDB,0x69}, {0xDB,0x77}, {0xB5,0xE2}, {0xDB,0x73},
    {0xB5,0xDF}, {0xFA,0xAC}, {0xDB,0x74}, {0xDB,0x5D},
    {0xDB,0xA4}, {0x8F,0x58}, {0xB5,0xE8}, {0xDB,0xA1},
    {0xDB,0x75}, {0xDB,0xAC}, {0xDB,0x70}, {0xDF,0xC8},
    {0xDB,0xAF}, {0xB5,0xE6}, {0xDB,0x6E}, {0xDB,0x7A},
    {0xB5,0xE9}, {0xB5,0xD4}, {0xDB,0x72}, {0xDB,0xAD},
    {0xDB,0x6B}, {0xDB,0x64}, {0xDB,0x6F}, {0xDB,0x63},
    {0xDB,0x61}, {0xB5,0xD0}, {0xDB,0xA5}, {0xDB,0x6A},
    {0xDB,0xA8}, {0x98,0x48}, {0xDB,0xA9}, {0xB5,0xD8},
    {0xB5,0xDD}, {0xB5,0xD9}, {0xB5,0xE1}, {0xDB,0x7E},
    {0xB5,0xDA}, {0xDB,0x76}, {0xDB,0x66}, {0xB5,0xD2},
    {0xDB,0x5E}, {0xDB,0xA2}, {0xDB,0xAB}, {0xDB,0x65},
    {0xB5,0xE0}, {0xDB,0xB0}, {0xDB,0x71}, {0xDB,0x6D},
    {0xB5,0xD1}, {0xB5,0xE5}, {0x99,0xB7}, {0xDB,0x7C},
    {0xB5,0xE7}, {0xDB,0x78}, {0xB5,0xDC}, {0xB5,0xD6},
    {0xB5,0xDE}, {0xB5,0xD3}, {0xB5,0xE4}, {0xDB,0x79},
    {0xDB,0x67}, {0xDB,0x7B}, {0xDB,0x62}, {0xDB,0xA6},
    {0x96,0x65}, {0xFA,0x6C}, {0x9D,0xE7}, {0xDB,0xAE},
    {0x9E,0x62}, {0x96,0xCC}, {0x8E,0x67}, {0xDB,0x5F},
    {0xFC,0x75}, {0x98,0x7E}, {0xDF,0xC7}, {0xDF,0xDD},
    {0xB8,0x55}, {0xDF,0xCC}, {0xFD,0xB9}, {0xDF,0xCA},
    {0xDF,0xB5}, {0xB8,0xA9}, {0xDF,0xC5}, {0xDF,0xD9},
    {0xDF,0xC1}, {0xB8,0xB1}, {0xDF,0xD8}, {0xDF,0xBF},
    {0xB5,0xE3}, {0xDF,0xCF}, {0xDF,0xC0}, {0xDF,0xD6},
    {0xB8,0xB0}, {0xB8,0xA8}, {0x97,0xFC}, {0xDF,0xAA},
    {0xDF,0xB2}, {0xDF,0xCB}, {0xDF,0xC3}, {0xDF,0xDC},
    {0xDF,0xC6}, {0xB8,0xB6}, {0xDF,0xD7}, {0x98,0xF9},
    {0xB8,0xAD}, {0x8F,0x66}, {0xDF,0xC9}, {0xDF,0xD1},
    {0xDF,0xB6}, {0xDF,0xD0}, {0xDF,0xE1}, {0xDF,0xB1},
    {0xDF,0xD2}, {0x95,0x6E}, {0xDF,0xDF}, {0x92,0x45},
    {0xDF,0xAB}, {0xB5,0xDB}, {0x8F,0x60}, {0xDF,0xB9},
    {0xDF,0xB8}, {0xB8,0xAF}, {0x9E,0xD1}, {0xDF,0xBC},
    {0xDF,0xBE}, {0xDF,0xCD}, {0xDF,0xDE}, {0xB8,0xB2},
    {0xFE,0xCD}, {0xB8,0xB3}, {0x99,0xB9}, {0xDF,0xB0},
    {0xB8,0xAB}, {0xDF,0xB4}, {0xDF,0xDA}, {0xB8,0xB4},
    {0xB8,0xAC}, {0xB8,0xAE}, {0xB8,0xB5}, {0xDF,0xE0},
    {0xDF,0xD3}, {0xDF,0xCE}, {0x8F,0x62}, {0x97,0x4C},
    {0xDF,0xBB}, {0xDF,0xBA}, {0xB8,0xAA}, {0xDF,0xAC},
    {0xB8,0xA7}, {0xDF,0xC4}, {0xDF,0xAD}, {0xDF,0xC2},
    {0xDF,0xB7}, {0xDF,0xDB}, {0x91,0xC7}, {0x95,0x5F},
    {0xB8,0xA6}, {0xDF,0xB3}, {0x99,0xBB}, {0xDF,0xAF},
    {0xDF,0xD5}, {0xDF,0xAE}, {0xBB,0x60}, {0xE3,0xD3},
    {0x8E,0x6D}, {0x8F,0x71}, {0xE3,0xC2}, {0x94,0xCB},
    {0xE3,0xAC}, {0xE3,0xCA}, {0xBB,0x58}, {0xE3,0xBB},
    {0xE3,0xC5}, {0xBB,0x5B}, {0xE3,0xBE}, {0xBB,0x59},
    {0xE3,0xAF}, {0xE3,0xCD}, {0xE3,0xAE}, {0xE3,0xC1},
    {0x95,0xB1}, {0xE3,0xAD}, {0xE3,0xBF}, {0xE3,0xC8},
    {0xE3,0xC6}, {0xE3,0xBA}, {0xE3,0xB5}, {0xE3,0xB3},
    {0x9A,0xF2}, {0xE3,0xB4}, {0xE3,0xC7}, {0xE3,0xD2},
    {0xE3,0xBC}, {0xBB,0x5A}, {0xE3,0xB7}, {0xE3,0xCB},
    {0xBB,0x5D}, {0xE3,0xB6}, {0xE3,0xB0}, {0xE3,0xC0},
    {0xBB,0x61}, {0x96,0xC3}, {0x99,0xBD}, {0xBB,0x55},
    {0xBB,0x5E}, {0xE3,0xB8}, {0xE3,0xB2}, {0xBB,0x57},
    {0xDF,0xD4}, {0xBB,0x56}, {0xE3,0xC3}, {0xBB,0x54},
    {0xBB,0x63}, {0xBB,0x5C}, {0xE3,0xC4}, {0xE3,0xB9},
    {0xE3,0xB1}, {0xE3,0xCC}, {0xE3,0xBD}, {0xBB,0x62},
    {0xE3,0xD0}, {0xBB,0x5F}, {0xE3,0xCF}, {0xE3,0xC9},
    {0xE3,0xCE}, {0xA0,0xCF}, {0xE3,0xD1}, {0x8F,0x6D},
    {0x99,0xBE}, {0x8E,0xF4}, {0x8F,0x72}, {0x95,0xE4},
    {0xE7,0x73}, {0xE7,0x74}, {0xE7,0x67}, {0xE7,0x66},
    {0xE7,0x62}, {0xBD,0xB4}, {0xBD,0xAC}, {0xE7,0x76},
    {0xE7,0x75}, {0xDF,0xA9}, {0xE7,0x5F}, {0xE7,0x63},
    {0xE7,0x5D}, {0xE7,0x70}, {0xE7,0x61}, {0x99,0xBF},
    {0xE7,0x77}, {0xE7,0x5A}, {0xE7,0x58}, {0xE7,0x64},
    {0xE7,0x6E}, {0xE7,0x69}, {0xBD,0xB6}, {0xE7,0x4F},
    {0xE7,0x6D}, {0x92,0x42}, {0xFB,0xA5}, {0xBD,0xB7},
    {0xDF,0xBD}, {0xE7,0x5B}, {0xE7,0x52}, {0xE7,0x55},
    {0xE7,0x7B}, {0xE7,0x5C}, {0xE7,0x53}, {0xE7,0x51},
    {0xE7,0x4E}, {0x99,0xC0}, {0xBD,0xB0}, {0xE7,0x65},
    {0xBD,0xAF}, {0xBD,0xB3}, {0xE7,0x60}, {0xE7,0x68},
    {0xBD,0xA9}, {0xE7,0x78}, {0xE7,0x7C}, {0xBD,0xAB},
    {0xE7,0x57}, {0xE7,0x6B}, {0xE7,0x6F}, {0xE7,0x54},
    {0xE7,0x79}, {0xBD,0xB2}, {0xBD,0xB1}, {0xE7,0x4C},
    {0xBD,0xB5}, {0xE7,0x72}, {0xE7,0x56}, {0xE7,0x6A},
    {0xE7,0x50}, {0xE7,0x5E}, {0xE7,0x59}, {0xBD,0xAD},
    {0xBD,0xAE}, {0xE7,0x6C}, {0xE7,0x7D}, {0xE7,0x7A},
    {0xE7,0x71}, {0xFD,0xB4}, {0x8F,0x77}, {0x99,0xC1},
    {0xE7,0x4D}, {0xBD,0xAA}, {0xEB,0x49}, {0xEB,0x40},
    {0xEB,0x43}, {0xFA,0xB9}, {0xBF,0xBB}, {0xEB,0x45},
    {0xEA,0xF9}, {0xEB,0x41}, {0xEB,0x47}, {0xBF,0xB8},
    {0xBF,0xBC}, {0xBF,0xB6}, {0x8F,0x40}, {0xFA,0x44},
    {0xEA,0xFB}, {0xEB,0x4C}, {0xEB,0x46}, {0x99,0xC2},
    {0xEA,0xFC}, {0xEB,0x55}, {0xEB,0x4F}, {0xEA,0xF8},
    {0xEE,0x46}, {0xEA,0xFE}, {0xBF,0xB7}, {0x8F,0x5C},
    {0xEB,0x4A}, {0xEB,0x54}, {0xBF,0xBF}, {0x8C,0xBD},
    {0xEB,0x51}, {0xEA,0xFD}, {0xEB,0x44}, {0xEB,0x48},
    {0xEB,0x42}, {0xEB,0x56}, {0xEB,0x53}, {0xEB,0x50},
    {0xBF,0xB9}, {0xBF,0xBA}, {0xBF,0xBE}, {0xEA,0xFA},
    {0xEB,0x57}, {0xBF,0xBD}, {0xEB,0x4D}, {0x99,0xC4},
    {0x99,0xC5}, {0xEB,0x4B}, {0x8F,0x7B}, {0xEB,0x4E},
    {0xEE,0x53}, {0xEE,0x40}, {0xEE,0x45}, {0xEE,0x52},
    {0xEE,0x44}, {0xED,0xFB}, {0xEE,0x41}, {0xC1,0xA2},
    {0xED,0xF4}, {0xEE,0x4D}, {0xEE,0x4F}, {0xED,0xF3},
    {0xC1,0xA1}, {0xEE,0x51}, {0xEE,0x49}, {0xC1,0xA8},
    {0xEE,0x50}, {0xEE,0x42}, {0xC1,0xAA}, {0xED,0xF9},
    {0xEB,0x52}, {0xEE,0x4A}, {0xEE,0x47}, {0xED,0xF5},
    {0xEE,0x55}, {0xC1,0xA4}, {0xC1,0xA5}, {0xED,0xF7},
    {0xEE,0x48}, {0x8C,0xB6}, {0xEE,0x54}, {0xEE,0x4B},
    {0xED,0xFD}, {0xC1,0xA7}, {0xC1,0xA3}, {0xEE,0x4C},
    {0xED,0xFE}, {0xEE,0x56}, {0xED,0xF8}, {0xEE,0x43},
    {0xEE,0x4E}, {0xED,0xFA}, {0xED,0xFC}, {0xC2,0xCB},
    {0xED,0xF6}, {0xC1,0xA9}, {0xC2,0xC4}, {0xC1,0x7E},
    {0xC1,0xA6}, {0xC2,0xC8}, {0xF0,0xB3}, {0xF0,0xA9},
    {0xF0,0xA4}, {0xF0,0xAA}, {0xF0,0xB4}, {0xF0,0xB8},
    {0xF0,0xB7}, {0xC2,0xCA}, {0xC2,0xC9}, {0xF0,0xAB},
    {0xF0,0xB9}, {0xF0,0xAE}, {0xF0,0xA6}, {0x8F,0xA3},
    {0xF0,0xA8}, {0xF0,0xA7}, {0xF0,0xAD}, {0xF0,0xB2},
    {0xF0,0xA5}, {0xF0,0xAC}, {0xF0,0xB1}, {0xC2,0xC7},
    {0xF0,0xAF}, {0xC2,0xC5}, {0xF0,0xB0}, {0xC2,0xC3},
    {0xC2,0xC6}, {0xF2,0xD5}, {0xF0,0xB5}, {0xC3,0xC2},
    {0x8C,0xCE}, {0xF2,0xCD}, {0xF2,0xD1}, {0xF2,0xC9},
    {0xF2,0xCC}, {0xF2,0xD4}, {0xC3,0xC0}, {0xF2,0xD9},
    {0xF2,0xD2}, {0x99,0xC6}, {0xF2,0xCA}, {0xF2,0xDA},
    {0xF2,0xD3}, {0xC3,0xC3}, {0xC3,0xC4}, {0xF2,0xD7},
    {0xF2,0xCB}, {0xC3,0xBF}, {0xC3,0xC1}, {0xF2,0xC6},
    {0xF2,0xCE}, {0xF2,0xC8}, {0x96,0xCD}, {0xF2,0xD8},
    {0xF2,0xD6}, {0xF2,0xC7}, {0xF2,0xCF}, {0xF4,0xBE},
    {0xC3,0xC5}, {0xF2,0xD0}, {0xC4,0xA7}, {0xC4,0xA9},
    {0xC4,0xA6}, {0x96,0xC7}, {0xF4,0xC3}, {0xF4,0xBB},
    {0xF4,0xB9}, {0xF4,0xBD}, {0xF4,0xBA}, {0x8F,0xA5},
    {0xF4,0xBF}, {0xF4,0xC1}, {0xC4,0xAA}, {0xC4,0xAC},
    {0xF4,0xC0}, {0xC4,0xAD}, {0xC4,0xAB}, {0xF4,0xC2},
    {0xFA,0xBB}, {0x8C,0x61}, {0x95,0x70}, {0xC4,0xA8},
    {0x93,0x68}, {0x8F,0x7E}, {0xC4,0xF4}, {0xF5,0xF1},
    {0xF5,0xF7}, {0xC4,0xF6}, {0xF4,0xBC}, {0xF5,0xF6},
    {0xF5,0xFD}, {0xF5,0xF4}, {0xF5,0xFB}, {0xF5,0xFA},
    {0xF4,0xB8}, {0xF5,0xF5}, {0xF0,0xB6}, {0xF5,0xFE},
    {0xF5,0xF3}, {0xF5,0xF8}, {0x8F,0xAA}, {0xF5,0xFC},
    {0xF5,0xF2}, {0xF7,0x4A}, {0xC4,0xF5}, {0xF5,0xF9},
    {0xA0,0x50}, {0xF7,0xF4}, {0xF7,0x4B}, {0xF7,0x49},
    {0xF7,0x47}, {0xF7,0x48}, {0xF7,0x4C}, {0xC5,0xD9},
    {0xF7,0xF2}, {0xF7,0xF0}, {0xF7,0xF5}, {0xF7,0xF3},
    {0xF7,0xF6}, {0xC5,0xDA}, {0xF7,0xF1}, {0x90,0xD3},
    {0xF8,0xBC}, {0x95,0x56}, {0xF9,0x45}, {0xF9,0x46},
    {0xF9,0x47}, {0xF9,0xC7}, {0xF9,0xBD}, {0xCA,0x4F},
    {0xAA,0xEA}, {0xAD,0x68}, {0xD3,0xB8}, {0xD3,0xB7},
    {0xB0,0x40}, {0xB3,0x42}, {0xD7,0x7C}, {0xD7,0x7B},
    {0xB5,0xEA}, {0xB8,0xB8}, {0xB8,0xB7}, {0xB8,0xB9},
    {0xE3,0xD4}, {0xE7,0x7E}, {0xEB,0x58}, {0xEB,0x5A},
    {0xEB,0x59}, {0xC1,0xAB}, {0xEE,0x57}, {0xF0,0xBA},
    {0xF9,0xA5}, {0xA6,0xE4}, {0x8F,0xB8}, {0xCD,0xC9},
    {0xCD,0xCA}, {0xCD,0xC8}, {0xCD,0xC7}, {0xAA,0xEB},
    {0x99,0xC8}, {0xD0,0xA9}, {0xD0,0xA7}, {0xD0,0xA6},
    {0xAD,0x69}, {0xAD,0x6B}, {0xAD,0x6A}, {0xD0,0xA8},
    {0x8F,0xAF}, {0xD3,0xC4}, {0xD3,0xC1}, {0xD3,0xBF},
    {0xB0,0x41}, {0xD3,0xC2}, {0xB0,0x46}, {0xD3,0xBC},
    {0xD3,0xCB}, {0xD3,0xCD}, {0xD3,0xBD}, {0x99,0xC9},
    {0xB0,0x43}, {0xD3,0xCE}, {0xD3,0xC9}, {0xD3,0xBB},
    {0xD3,0xC0}, {0xD3,0xCA}, {0xD3,0xC6}, {0xD3,0xC3},
    {0xB0,0x48}, {0xD3,0xCC}, {0xD3,0xBE}, {0x95,0x79},
    {0xD3,0xC7}, {0xD3,0xB9}, {0xB0,0x47}, {0xB0,0x44},
    {0xD3,0xC5}, {0xD3,0xC8}, {0xD3,0xBA}, {0xB0,0x45},
    {0xB0,0x42}, {0x9F,0x49}, {0xB3,0x4C}, {0xD7,0xA5},
    {0xB3,0x4B}, {0x99,0xCA}, {0xD7,0xA8}, {0xD7,0xAB},
    {0xB3,0x48}, {0xB3,0x46}, {0xD7,0x7E}, {0xD7,0xA9},
    {0xD7,0xA7}, {0xD7,0xA4}, {0xD7,0xAC}, {0xD7,0xAD},
    {0xD7,0xAF}, {0xD7,0xB0}, {0xD7,0x7D}, {0xB3,0x45},
    {0xD7,0xA2}, {0xD7,0xA1}, {0xD7,0xAE}, {0xB3,0x47},
    {0xD7,0xA3}, {0xB3,0x49}, {0xB3,0x44}, {0xD7,0xA6},
    {0xB3,0x4D}, {0xB3,0x4A}, {0xD7,0xAA}, {0xB5,0xF1},
    {0xDB,0xBF}, {0xDB,0xB4}, {0xB5,0xEE}, {0xDF,0xE7},
    {0xDB,0xBD}, {0xDB,0xB1}, {0xB5,0xEC}, {0xDB,0xB6},
    {0xB5,0xEF}, {0xDB,0xBA}, {0xDB,0xB8}, {0xB5,0xF2},
    {0xB5,0xEB}, {0xDB,0xB2}, {0xDB,0xB5}, {0xB5,0xF0},
    {0xDB,0xB3}, {0xDB,0xBE}, {0xDB,0xBC}, {0xDB,0xB7},
    {0xDB,0xB9}, {0xDB,0xBB}, {0xB5,0xED}, {0x99,0xCB},
    {0xDF,0xE8}, {0xDF,0xEE}, {0xDF,0xE4}, {0xDF,0xEA},
    {0xB8,0xBA}, {0xDF,0xE6}, {0xB8,0xC0}, {0xB8,0xBF},
    {0xB8,0xBE}, {0xDF,0xED}, {0xB8,0xC1}, {0xB8,0xC2},
    {0xDF,0xE3}, {0xDF,0xF0}, {0xB8,0xC3}, {0xB8,0xBD},
    {0xB8,0xBC}, {0xDF,0xEC}, {0xB8,0xC4}, {0xDF,0xE2},
    {0xDF,0xE5}, {0xDF,0xEF}, {0xDF,0xEB}, {0xE3,0xF4},
    {0xE3,0xE9}, {0xB8,0xBB}, {0xBB,0x6A}, {0xE3,0xDD},
    {0xE3,0xF2}, {0xE3,0xDE}, {0xBB,0x65}, {0xE3,0xDB},
    {0xE3,0xE4}, {0xE3,0xDC}, {0xBB,0x67}, {0xE3,0xD6},
    {0xE3,0xF1}, {0xBB,0x68}, {0xE3,0xEE}, {0xE3,0xEF},
    {0xE3,0xD7}, {0xBB,0x6D}, {0xE3,0xE6}, {0xE3,0xE0},
    {0xE3,0xE7}, {0xE3,0xDA}, {0xE3,0xF3}, {0xE3,0xEB},
    {0xE3,0xE5}, {0xE3,0xD5}, {0xBB,0x69}, {0xE3,0xEC},
    {0xBB,0x6C}, {0xE3,0xF0}, {0xE3,0xEA}, {0xBB,0x66},
    {0xE3,0xE8}, {0xE3,0xE2}, {0xBB,0x64}, {0xE3,0xD9},
    {0xE3,0xE1}, {0xE3,0xED}, {0xE3,0xDF}, {0xE3,0xE3},
    {0xBD,0xC1}, {0xDF,0xE9}, {0xE7,0xB2}, {0xE7,0xBB},
    {0xE7,0xB1}, {0xE7,0xAD}, {0xE7,0xAA}, {0xBD,0xC2},
    {0xE7,0xA8}, {0xBB,0x6B}, {0xE7,0xA1}, {0xBD,0xC0},
    {0xE7,0xA7}, {0xBD,0xBF}, {0xE7,0xAC}, {0xE7,0xA9},
    {0xE7,0xB9}, {0xE7,0xB4}, {0xE7,0xAE}, {0xE7,0xB3},
    {0xBD,0xBB}, {0xE7,0xAB}, {0xE7,0xBE}, {0xE7,0xA2},
    {0xE7,0xA3}, {0xE7,0xBA}, {0xBD,0xBC}, {0xE7,0xBF},
    {0xBD,0xBE}, {0xE7,0xC0}, {0xE7,0xB0}, {0xE3,0xD8},
    {0xE7,0xB6}, {0xE7,0xAF}, {0xE7,0xB8}, {0xE7,0xB5},
    {0x9D,0xD5}, {0x8F,0xB0}, {0xE7,0xA6}, {0xBD,0xB9},
    {0xE7,0xBD}, {0xBD,0xBA}, {0xE7,0xA4}, {0xBD,0xBD},
    {0xEB,0x64}, {0xE7,0xB7}, {0xE7,0xBC}, {0xFA,0x7A},
    {0xEB,0x61}, {0xBD,0xB8}, {0xBF,0xC0}, {0xEB,0x6B},
    {0xEB,0x67}, {0x9E,0x5F}, {0xEB,0x65}, {0xEB,0x60},
    {0xEB,0x6F}, {0x99,0xCD}, {0xA0,0xC9}, {0xBF,0xC4},
    {0xEB,0x5C}, {0xEB,0x68}, {0xEB,0x69}, {0xEB,0x5F},
    {0xEB,0x5E}, {0xEB,0x6C}, {0xEB,0x62}, {0xEB,0x5D},
    {0xEB,0x63}, {0xEB,0x6E}, {0xEB,0x5B}, {0xEB,0x6D},
    {0xEB,0x6A}, {0xBF,0xC2}, {0xBF,0xC1}, {0xBF,0xC3},
    {0xEB,0x66}, {0xF0,0xCB}, {0x9A,0xDB}, {0xA0,0xC6},
    {0xEE,0x59}, {0xC1,0xB1}, {0xEE,0x5D}, {0xEE,0x5A},
    {0xEE,0x61}, {0xEE,0x67}, {0xEE,0x5C}, {0x8F,0xB4},
    {0xEE,0x70}, {0xC1,0xAE}, {0xEE,0x6A}, {0xEE,0x5F},
    {0xEE,0x6B}, {0xEE,0x66}, {0xEE,0x6D}, {0xEE,0x5E},
    {0xC1,0xB3}, {0xC1,0xB2}, {0xEE,0x60}, {0xEE,0x6E},
    {0xEE,0x58}, {0xEE,0x6C}, {0xC1,0xAC}, {0xA0,0xD7},
    {0xEE,0x64}, {0xEE,0x63}, {0xEE,0x68}, {0xEE,0x5B},
    {0xC1,0xB0}, {0xC1,0xB4}, {0xEE,0x62}, {0xEE,0x69},
    {0xC1,0xB5}, {0xEE,0x65}, {0xA0,0xC7}, {0xC1,0xAD},
    {0xC1,0xAF}, {0xF0,0xC7}, {0xF0,0xC5}, {0xA0,0x43},
    {0xF0,0xCC}, {0xF0,0xC9}, {0xF0,0xCD}, {0x8F,0xB5},
    {0xF0,0xBE}, {0xF0,0xC6}, {0xF0,0xD1}, {0xEE,0x6F},
    {0xF0,0xC2}, {0xC2,0xCF}, {0xE7,0xA5}, {0xF0,0xBD},
    {0xF0,0xCA}, {0xF0,0xC4}, {0xF0,0xC1}, {0xF0,0xBC},
    {0xF0,0xBB}, {0xF0,0xD0}, {0xF0,0xC0}, {0xF0,0xBF},
    {0xC2,0xCD}, {0xF0,0xC8}, {0x8F,0xB2}, {0xC2,0xCC},
    {0xC2,0xCE}, {0xF0,0xC3}, {0xF0,0xCF}, {0xA0,0x61},
    {0xF2,0xDE}, {0xF2,0xDF}, {0xC3,0xC9}, {0xF2,0xDC},
    {0xC3,0xC6}, {0xF2,0xE4}, {0xC3,0xCA}, {0xF2,0xE6},
    {0xF2,0xDB}, {0xF0,0xCE}, {0xF2,0xE8}, {0xF2,0xDD},
    {0x9E,0x5E}, {0xC3,0xC7}, {0xF2,0xE3}, {0xF2,0xE5},
    {0xF2,0xE0}, {0xF2,0xE7}, {0xF2,0xE2}, {0xF2,0xE1},
    {0xC3,0xC8}, {0x8F,0xB6}, {0xF4,0xC5}, {0xF4,0xC6},
    {0xF4,0xC8}, {0xC4,0xAE}, {0xC4,0xAF}, {0xF4,0xC9},
    {0xF4,0xC7}, {0x9F,0xE8}, {0xF4,0xC4}, {0xF6,0x42},
    {0xF6,0x45}, {0xF6,0x41}, {0xC4,0xFA}, {0xF6,0x43},
    {0xC4,0xF9}, {0xC4,0xF8}, {0xC4,0xF7}, {0xF6,0x44},
    {0xF7,0x51}, {0xF7,0x4F}, {0x9C,0xB2}, {0xF7,0x4E},
    {0xF6,0x40}, {0xF7,0x50}, {0xF6,0x46}, {0xF7,0x4D},
    {0x95,0x7C}, {0xF7,0xF9}, {0xF7,0xD7}, {0xF7,0xF7},
    {0xC5,0xDB}, {0xF7,0xF8}, {0xF7,0xFA}, {0xF8,0xBF},
    {0xC5,0xFA}, {0xF8,0xBE}, {0xF8,0xBD}, {0xC5,0xFB},
    {0xC6,0x5A}, {0xF9,0x6E}, {0xF9,0xA7}, {0xF9,0xA6},
    {0xF9,0xA8}, {0xA6,0xE5}, {0xD0,0xAA}, {0x9F,0xC7},
    {0xD3,0xCF}, {0xD3,0xD0}, {0x8F,0xBB}, {0x8F,0xBC},
    {0xDB,0xC0}, {0xF6,0x47}, {0xF8,0xC0}, {0xA6,0xE6},
    {0xAD,0x6C}, {0xD0,0xAB}, {0x8F,0xEC}, {0xD7,0xB1},
    {0xB3,0x4E}, {0xDB,0xC2}, {0xDB,0xC1}, {0xB5,0xF3},
    {0xB8,0xC5}, {0xE7,0xC1}, {0xBD,0xC3}, {0xBD,0xC4},
    {0x8F,0xC0}, {0x93,0x6A}, {0xBF,0xC5}, {0xC5,0xFC},
    {0xA6,0xE7}, {0x8B,0xE4}, {0x9C,0x7C}, {0xD0,0xAC},
    {0xAA,0xED}, {0xD0,0xAE}, {0xD0,0xAD}, {0xAD,0x6D},
    {0xD3,0xD1}, {0x95,0xA1}, {0xD3,0xD8}, {0xB0,0x49},
    {0xD3,0xD6}, {0xD3,0xD4}, {0xD3,0xDB}, {0xD3,0xD2},
    {0xD3,0xD3}, {0xB0,0x4A}, {0xB0,0x4E}, {0xD3,0xDC},
    {0xB0,0x4D}, {0xD3,0xDA}, {0xD3,0xD7}, {0xD3,0xD5},
    {0xB0,0x4B}, {0xB0,0x4C}, {0xD3,0xD9}, {0xFE,0xEC},
    {0x95,0xA3}, {0xB3,0x50}, {0xD7,0xB2}, {0xB3,0x55},
    {0xD7,0xC2}, {0xB3,0x54}, {0xD7,0xC4}, {0x8C,0x45},
    {0x8C,0xB8}, {0xD7,0xB8}, {0xB3,0x52}, {0xD7,0xC3},
    {0xD7,0xB3}, {0xB3,0x53}, {0xD7,0xBF}, {0xD7,0xBB},
    {0xD7,0xBD}, {0xD7,0xB7}, {0xD7,0xBE}, {0x8F,0xC1},
    {0xB3,0x4F}, {0xD7,0xBA}, {0xA0,0x52}, {0xD7,0xB9},
    {0xD7,0xB5}, {0xD7,0xC0}, {0xD7,0xBC}, {0xD7,0xB4},
    {0xD7,0xB6}, {0xB3,0x51}, {0xD7,0xC1}, {0x99,0xD0},
    {0xB5,0xF6}, {0xDB,0xCD}, {0x8F,0xC3}, {0x8F,0xC4},
    {0xDB,0xC9}, {0xDB,0xCB}, {0xDB,0xC6}, {0xDB,0xC5},
    {0xDB,0xC3}, {0xDB,0xCA}, {0xDB,0xCC}, {0xDB,0xC8},
    {0x95,0xA4}, {0xDB,0xC7}, {0xB5,0xF4}, {0xB5,0xF5},
    {0x8F,0xC6}, {0x9E,0x60}, {0xDB,0xCF}, {0xB8,0xCD},
    {0xDF,0xF2}, {0xDF,0xF8}, {0xDF,0xF3}, {0xDF,0xF4},
    {0xF9,0xD8}, {0xDF,0xF9}, {0xB8,0xCF}, {0xB8,0xC7},
    {0xB8,0xCE}, {0xDF,0xF1}, {0xDB,0xC4}, {0xB8,0xCA},
    {0xB8,0xC8}, {0xDF,0xF7}, {0xDF,0xF6}, {0xB8,0xC9},
    {0xB8,0xCB}, {0xDF,0xF5}, {0xB8,0xC6}, {0xB8,0xCC},
    {0x95,0xA5}, {0xE3,0xF6}, {0xBB,0x74}, {0xE4,0x42},
    {0xE4,0x41}, {0xE3,0xFB}, {0xBB,0x76}, {0xE4,0x40},
    {0xE3,0xF7}, {0xE3,0xF8}, {0xBB,0x6E}, {0xBB,0x70},
    {0x9C,0xB3}, {0xE3,0xFD}, {0xE3,0xF5}, {0xBB,0x72},
    {0xBB,0x71}, {0xE3,0xF9}, {0xE3,0xFE}, {0xE3,0xFC},
    {0xBB,0x73}, {0xE3,0xFA}, {0x99,0xD1}, {0xFE,0xF1},
    {0xDB,0xCE}, {0xBB,0x6F}, {0xE7,0xC2}, {0xE7,0xC9},
    {0xBD,0xC6}, {0xE7,0xCD}, {0xBD,0xCA}, {0xE7,0xC5},
    {0xE7,0xC3}, {0xE7,0xCC}, {0xBD,0xC5}, {0xE7,0xCB},
    {0xBD,0xC7}, {0xBD,0xC8}, {0xE7,0xC4}, {0xBD,0xC9},
    {0xE7,0xCA}, {0xE7,0xC6}, {0xE7,0xC7}, {0xE7,0xC8},
    {0xBB,0x75}, {0xEB,0x70}, {0xEB,0x7C}, {0xBF,0xCA},
    {0xEB,0x77}, {0xEB,0x79}, {0x99,0xD2}, {0xBF,0xC8},
    {0xEB,0x71}, {0xEB,0x75}, {0xEB,0x78}, {0xBF,0xC6},
    {0xBF,0xC9}, {0xEB,0x7B}, {0xEB,0x73}, {0xEB,0x74},
    {0xEB,0x7A}, {0xEB,0x72}, {0xEB,0x76}, {0xBF,0xC7},
    {0xEE,0x72}, {0xEE,0x71}, {0xC1,0xB7}, {0xEE,0x77},
    {0xC1,0xB9}, {0xC1,0xB6}, {0xEE,0x73}, {0xC1,0xBA},
    {0xEE,0x74}, {0xEE,0x75}, {0xEE,0x78}, {0x9C,0xC2},
    {0xC1,0xB8}, {0xF0,0xD6}, {0x99,0xD3}, {0xF0,0xD9},
    {0xF0,0xD3}, {0xF0,0xD5}, {0x95,0xA7}, {0xF0,0xD4},
    {0xF0,0xD7}, {0xF0,0xD8}, {0xEE,0x76}, {0xF0,0xD2},
    {0x95,0xA9}, {0xC3,0xCD}, {0xF2,0xEC}, {0xF2,0xEF},
    {0xF2,0xF1}, {0xF2,0xEA}, {0xF2,0xEB}, {0xF2,0xEE},
    {0xF2,0xF0}, {0xC3,0xCE}, {0xC3,0xCC}, {0xC3,0xCB},
    {0xF2,0xED}, {0xF2,0xE9}, {0xF4,0xCA}, {0xC4,0xB0},
    {0x95,0xA6}, {0xF4,0xCB}, {0xF6,0x49}, {0xC4,0xFB},
    {0xF6,0x4B}, {0xC4,0xFC}, {0xF6,0x48}, {0xF6,0x4A},
    {0xC5,0xA8}, {0xF7,0x52}, {0xC5,0xA7}, {0xF7,0xFD},
    {0xF7,0xFC}, {0xF7,0xFB}, {0x9C,0x5D}, {0xF9,0x48},
    {0xF9,0x49}, {0xF9,0x4B}, {0xF9,0x4A}, {0xCA,0x50},
    {0xA6,0xE8}, {0x98,0xE2}, {0xAD,0x6E}, {0xD7,0xC5},
    {0xB5,0xF7}, {0xDF,0xFA}, {0xC2,0xD0}, {0x8F,0xC9},
    {0xF2,0xF2}, {0xA0,0xC2}, {0x8F,0xCA}, {0xA8,0xA3},
    {0xB3,0x57}, {0x99,0xD4}, {0xB3,0x56}, {0xA0,0xB9},
    {0xDB,0xD0}, {0xB5,0xF8}, {0xDB,0xD2}, {0xDB,0xD1},
    {0xDF,0xFB}, {0xB8,0xD0}, {0xE4,0x43}, {0xE4,0x46},
    {0xE4,0x45}, {0xE4,0x44}, {0xE7,0xCE}, {0xE7,0xD0},
    {0xE7,0xCF}, {0x9B,0x58}, {0xBF,0xCC}, {0x8F,0xCD},
    {0xA0,0xD4}, {0xBF,0xCB}, {0xC1,0xBB}, {0xEE,0x79},
    {0xEE,0x7B}, {0xEE,0x7A}, {0xC2,0xD1}, {0xF2,0xF4},
    {0xF2,0xF3}, {0xF4,0xCC}, {0xC4,0xB1}, {0x8F,0xCE},
    {0xC4,0xFD}, {0xF7,0x54}, {0xF7,0x53}, {0xC6,0x5B},
    {0x8B,0xE5}, {0x89,0x79}, {0xA8,0xA4}, {0xD0,0xAF},
    {0xAD,0x6F}, {0xD7,0xC8}, {0xD7,0xC6}, {0xD7,0xC7},
    {0xDB,0xD4}, {0xDB,0xD5}, {0xE0,0x43}, {0xDB,0xD3},
    {0xDF,0xFC}, {0xE0,0x41}, {0xE0,0x40}, {0xE0,0x42},
    {0xB8,0xD1}, {0xDF,0xFE}, {0xDF,0xFD}, {0xE0,0x44},
    {0x8F,0xD0}, {0xE4,0x49}, {0xE4,0x47}, {0xE4,0x48},
    {0xE7,0xD3}, {0xE7,0xD1}, {0xE7,0xD2}, {0xEB,0x7D},
    {0xEE,0x7C}, {0xEE,0x7D}, {0xC2,0xD2}, {0xF2,0xF5},
    {0xF4,0xCD}, {0xC4,0xB2}, {0xF6,0x4C}, {0xF7,0x55},
    {0xC5,0xA9}, {0xF7,0xFE}, {0xF9,0x4C}, {0xA8,0xA5},
    {0xAD,0x71}, {0xAD,0x72}, {0xD0,0xB0}, {0xD0,0xB1},
    {0xAD,0x70}, {0xB0,0x54}, {0xB0,0x52}, {0xB0,0x51},
    {0xB0,0x58}, {0xB0,0x50}, {0xB0,0x59}, {0xD3,0xDD},
    {0xB0,0x56}, {0xB0,0x53}, {0xB0,0x57}, {0xB0,0x55},
    {0xB0,0x4F}, {0xB3,0x5F}, {0x95,0xB6}, {0xB3,0x59},
    {0xD7,0xCC}, {0xB3,0x5E}, {0xB3,0x60}, {0xB3,0x5A},
    {0xB3,0x5B}, {0xD7,0xCA}, {0x99,0xD6}, {0xB3,0x58},
    {0x95,0xE5}, {0xD7,0xCB}, {0xB3,0x5D}, {0xD7,0xC9},
    {0xB3,0x5C}, {0xB6,0x44}, {0xB6,0x46}, {0x99,0xD7},
    {0xDB,0xD8}, {0xB6,0x45}, {0xB5,0xF9}, {0xB5,0xFD},
    {0x95,0xB5}, {0xB8,0xE4}, {0xE0,0x49}, {0xDB,0xDA},
    {0xB5,0xFE}, {0xDB,0xDD}, {0xDB,0xDE}, {0xB6,0x43},
    {0xDB,0xE0}, {0xA0,0xCA}, {0xDB,0xE2}, {0xDB,0xE3},
    {0xDB,0xD7}, {0xDB,0xD6}, {0xDB,0xE4}, {0xB6,0x42},
    {0xDB,0xE1}, {0xDB,0xDF}, {0xB6,0x40}, {0xB5,0xFB},
    {0xB6,0x47}, {0xDB,0xDB}, {0xDB,0xDC}, {0xDB,0xD9},
    {0xB6,0x41}, {0xB5,0xFC}, {0xB5,0xFA}, {0xE0,0x48},
    {0xB8,0xDF}, {0xB8,0xDA}, {0xB8,0xD5}, {0x9F,0xFD},
    {0xB8,0xE5}, {0xB8,0xD6}, {0xB8,0xD2}, {0xB8,0xE1},
    {0xB8,0xDE}, {0xB8,0xE0}, {0xB8,0xD7}, {0xB8,0xDC},
    {0xB8,0xD3}, {0xB8,0xD4}, {0xE0,0x50}, {0xE0,0x4D},
    {0xE0,0x45}, {0xE0,0x4A}, {0xB8,0xE2}, {0xE0,0x51},
    {0xB8,0xE3}, {0xB8,0xD9}, {0xA0,0x58}, {0xE0,0x47},
    {0xE0,0x4F}, {0xE0,0x4B}, {0xE0,0x4E}, {0xE0,0x4C},
    {0xB8,0xDD}, {0xE0,0x46}, {0xB8,0xD8}, {0xE4,0x4C},
    {0xBB,0x78}, {0xBB,0x7B}, {0xE4,0x4E}, {0x8F,0xD6},
    {0xBB,0xA5}, {0xE4,0x4D}, {0xBB,0x7D}, {0x99,0xD8},
    {0xBD,0xCF}, {0xE4,0x4F}, {0xBB,0xA4}, {0xE4,0x4B},
    {0xBB,0xA6}, {0x8F,0xD3}, {0xBB,0x79}, {0xB8,0xDB},
    {0xBB,0x7C}, {0xBB,0x7A}, {0xBB,0x7E}, {0xBB,0xA2},
    {0xBB,0x77}, {0xBB,0xA7}, {0xBB,0xA3}, {0x8F,0xE5},
    {0xBB,0xA1}, {0xE4,0x4A}, {0x8F,0xE9}, {0xBD,0xD6},
    {0xBD,0xD2}, {0x99,0xD9}, {0xBD,0xD9}, {0xE7,0xD6},
    {0xBD,0xDA}, {0xE7,0xE2}, {0xE7,0xDB}, {0xBD,0xCB},
    {0xE7,0xE3}, {0xE7,0xDD}, {0xBD,0xD5}, {0xE7,0xDE},
    {0xBD,0xD4}, {0xE7,0xE1}, {0xBD,0xCE}, {0xE7,0xDF},
    {0xE7,0xD5}, {0xBD,0xCD}, {0xEB,0xAA}, {0xBD,0xD3},
    {0xBD,0xD0}, {0xBD,0xD8}, {0xE7,0xD4}, {0xE7,0xD8},
    {0xBD,0xCC}, {0xE7,0xD7}, {0xE7,0xD9}, {0xE7,0xDA},
    {0xBD,0xD7}, {0xE7,0xDC}, {0xE7,0xE0}, {0xE7,0xE4},
    {0x92,0x7C}, {0xBD,0xDB}, {0xBF,0xD2}, {0xEB,0xA5},
    {0xEB,0xAB}, {0xEB,0xA8}, {0xEB,0x7E}, {0xEB,0xAC},
    {0xEB,0xA1}, {0xEB,0xA7}, {0xBF,0xCD}, {0xBF,0xD3},
    {0xEB,0xAD}, {0x9C,0x45}, {0xBF,0xCF}, {0xBF,0xD9},
    {0xBF,0xD4}, {0xEB,0xAF}, {0xEB,0xA9}, {0xBF,0xD0},
    {0xEB,0xA2}, {0xBF,0xDA}, {0xEB,0xA3}, {0xEB,0xA4},
    {0xBF,0xDB}, {0xBF,0xD8}, {0xBD,0xD1}, {0xBF,0xCE},
    {0xEB,0xB0}, {0xBF,0xDC}, {0xBF,0xD5}, {0xEB,0xAE},
    {0xBF,0xD1}, {0xBF,0xD6}, {0xBF,0xD7}, {0xC1,0xC3},
    {0xEE,0xA4}, {0xEE,0xAD}, {0xEE,0xAA}, {0xEE,0xAC},
    {0xC1,0xC0}, {0xEE,0xA5}, {0x8F,0xDE}, {0xEE,0xAB},
    {0xC1,0xBC}, {0xEE,0xA7}, {0xC1,0xC4}, {0xEE,0xA3},
    {0xEE,0xA8}, {0xEE,0xAF}, {0xEB,0xA6}, {0xEE,0xA9},
    {0xEE,0xA2}, {0xC1,0xBD}, {0xEE,0xA1}, {0xC1,0xBE},
    {0xEE,0xB0}, {0xC1,0xBF}, {0xEE,0xAE}, {0xC1,0xC2},
    {0xEE,0x7E}, {0x8F,0xDF}, {0xC1,0xC1}, {0xEE,0xA6},
    {0xF0,0xDC}, {0xF0,0xEA}, {0xF0,0xE5}, {0xF0,0xE7},
    {0xF0,0xDB}, {0xC2,0xD3}, {0xF0,0xDA}, {0xC2,0xD6},
    {0xC2,0xD5}, {0xA0,0x4B}, {0xF0,0xE9}, {0xF0,0xE1},
    {0xF0,0xDE}, {0xF0,0xE4}, {0xF0,0xDD}, {0xF0,0xDF},
    {0xF0,0xE8}, {0xF0,0xE6}, {0xC2,0xD4}, {0xF0,0xED},
    {0xF0,0xEB}, {0xF0,0xE2}, {0xF0,0xEC}, {0xF0,0xE3},
    {0x8F,0xE2}, {0xF2,0xF9}, {0xC3,0xCF}, {0xF3,0x41},
    {0xA0,0xCC}, {0xF6,0x4F}, {0xC3,0xD6}, {0xF0,0xE0},
    {0xF2,0xF7}, {0xC3,0xD2}, {0xF2,0xF8}, {0xF2,0xFD},
    {0x8F,0xE3}, {0x8F,0xE4}, {0xC3,0xD4}, {0xC3,0xD5},
    {0xF2,0xF6}, {0xF3,0x40}, {0xF3,0x42}, {0xF2,0xFA},
    {0xF2,0xFC}, {0xF2,0xFE}, {0xF2,0xFB}, {0xF3,0x43},
    {0xC3,0xD1}, {0xC3,0xD7}, {0xC3,0xD3}, {0xC3,0xD0},
    {0xF4,0xD0}, {0x9B,0xC4}, {0xC4,0xB7}, {0xF4,0xCE},
    {0x9B,0xFC}, {0xF4,0xD2}, {0xF4,0xD3}, {0xC4,0xB5},
    {0xF4,0xD4}, {0xF4,0xD1}, {0x96,0x4C}, {0xF4,0xCF},
    {0xC4,0xB8}, {0xC4,0xB4}, {0xF4,0xD5}, {0xC4,0xB6},
    {0xC4,0xB3}, {0xC4,0xFE}, {0xC5,0x40}, {0xF6,0x4E},
    {0xF6,0x4D}, {0xF6,0x50}, {0xF6,0x51}, {0xC5,0x41},
    {0xF7,0x56}, {0xF7,0x5B}, {0xC5,0xAA}, {0x9A,0xF6},
    {0xF7,0x58}, {0x8C,0xAE}, {0xF7,0x57}, {0xF7,0x5A},
    {0xF7,0x59}, {0xF8,0x43}, {0xC5,0xDC}, {0xF8,0x42},
    {0xF8,0x40}, {0xF8,0x41}, {0x8F,0xE7}, {0xC5,0xFE},
    {0xC5,0xFD}, {0xF8,0xC1}, {0xF8,0xC2}, {0xC6,0x40},
    {0xF9,0x4D}, {0xF9,0x4E}, {0xC6,0x67}, {0x8F,0xE8},
    {0xC6,0x6D}, {0xF9,0xA9}, {0xF9,0xC8}, {0x8B,0xE7},
    {0x89,0x7A}, {0x89,0x7B}, {0xA8,0xA6}, {0xD7,0xCD},
    {0xD7,0xCE}, {0xE0,0x52}, {0xE4,0x50}, {0xE7,0xE5},
    {0xC1,0xC6}, {0xC1,0xC5}, {0xF0,0xEE}, {0xF3,0x44},
    {0xF8,0x44}, {0xA8,0xA7}, {0xD3,0xDE}, {0xB0,0x5A},
    {0xB3,0x61}, {0xE0,0x54}, {0xE0,0x53}, {0xBD,0xDC},
    {0xE7,0xE6}, {0xBD,0xDD}, {0xEE,0xB1}, {0xC2,0xD7},
    {0x99,0xDA}, {0xC6,0x76}, {0xA8,0xA8}, {0xCD,0xCB},
    {0xD3,0xDF}, {0xB3,0x62}, {0xD7,0xCF}, {0xD7,0xD0},
    {0xDB,0xE5}, {0xB6,0x48}, {0xB8,0xE6}, {0xE0,0x56},
    {0xE0,0x55}, {0xE0,0x57}, {0xE4,0x51}, {0xE4,0x52},
    {0xBB,0xA8}, {0xBF,0xDD}, {0xBD,0xDE}, {0xBF,0xDE},
    {0xEE,0xB5}, {0xEE,0xB2}, {0xEE,0xB4}, {0xEE,0xB3},
    {0xC1,0xC7}, {0xF0,0xEF}, {0xF3,0x46}, {0xF3,0x45},
    {0xCB,0xA4}, {0xB0,0x5C}, {0xB0,0x5B}, {0xD3,0xE0},
    {0xD7,0xD1}, {0xDB,0xE7}, {0xDB,0xE6}, {0xB6,0x49},
    {0xE0,0x59}, {0xE0,0x5A}, {0xE0,0x58}, {0xB8,0xE8},
    {0xB8,0xE7}, {0xBB,0xAA}, {0xBB,0xA9}, {0xE7,0xE7},
    {0xEB,0xB3}, {0xEB,0xB1}, {0xEB,0xB2}, {0xBF,0xDF},
    {0xEE,0xB7}, {0xEE,0xB6}, {0xF0,0xF2}, {0xF0,0xF1},
    {0xF0,0xF0}, {0xF3,0x47}, {0x8F,0xED}, {0xF9,0xAA},
    {0xA8,0xA9}, {0xAD,0x73}, {0x95,0xC0}, {0xAD,0x74},
    {0xB0,0x5D}, {0xB0,0x5E}, {0xD3,0xE2}, {0xD3,0xE1},
    {0xD7,0xD2}, {0xB3,0x68}, {0xB3,0x66}, {0xB3,0x63},
    {0xB3,0x67}, {0xB3,0x65}, {0xB3,0x64}, {0xA0,0xCB},
    {0xB6,0x4A}, {0xDB,0xEA}, {0xB8,0xED}, {0xB6,0x4C},
    {0xB6,0x51}, {0xDB,0xEC}, {0xB6,0x53}, {0xB6,0x52},
    {0xB6,0x55}, {0xDB,0xEB}, {0xDB,0xE8}, {0xB6,0x4F},
    {0xB6,0x4B}, {0xB6,0x4D}, {0xDB,0xE9}, {0xB6,0x54},
    {0xB6,0x50}, {0xB6,0x4E}, {0xB8,0xEF}, {0xB8,0xEE},
    {0xB8,0xEC}, {0xB8,0xF0}, {0xB8,0xEA}, {0xB8,0xEB},
    {0xB8,0xE9}, {0xE0,0x5B}, {0x9E,0x48}, {0xE4,0x54},
    {0xBB,0xAC}, {0xBB,0xAD}, {0xBB,0xAB}, {0x99,0xDB},
    {0xE4,0x53}, {0x8F,0xF3}, {0xE4,0x55}, {0xE7,0xEA},
    {0xE7,0xEC}, {0x8F,0xF9}, {0xBD,0xE7}, {0xE7,0xED},
    {0xBD,0xE0}, {0xE7,0xE9}, {0xBD,0xDF}, {0xBD,0xE9},
    {0xBD,0xE5}, {0xBD,0xE6}, {0xBD,0xE2}, {0xE7,0xE8},
    {0xBD,0xE1}, {0xE7,0xEE}, {0xE7,0xEB}, {0x95,0xC1},
    {0xBD,0xE8}, {0xA0,0x4E}, {0xBD,0xE3}, {0xBD,0xE4},
    {0xEB,0xB5}, {0xEB,0xB7}, {0xEB,0xB6}, {0x99,0xDC},
    {0xEB,0xB8}, {0xBF,0xE0}, {0xEB,0xB4}, {0xA0,0x64},
    {0xC1,0xCB}, {0xEE,0xB8}, {0xC1,0xC8}, {0xC1,0xCC},
    {0xC1,0xCA}, {0xC1,0xC9}, {0xF0,0xF3}, {0xF0,0xF6},
    {0xF0,0xF5}, {0x8F,0xF7}, {0xF0,0xF4}, {0xC2,0xD8},
    {0xF3,0x48}, {0xF3,0x49}, {0xC3,0xD8}, {0xF3,0x4A},
    {0xC3,0xD9}, {0x89,0xB0}, {0xA0,0x48}, {0xC4,0xBA},
    {0xC4,0xB9}, {0xF6,0x52}, {0x8F,0xFB}, {0x8F,0xF6},
    {0xC5,0x42}, {0xF6,0x53}, {0xF7,0x5C}, {0xC5,0xAB},
    {0xC5,0xAC}, {0x9D,0xDC}, {0xF8,0x45}, {0xC6,0x42},
    {0x99,0xDD}, {0x8B,0xE8}, {0xA8,0xAA}, {0xB3,0x6A},
    {0xB3,0x69}, {0xE0,0x5C}, {0xE0,0x5D}, {0xBB,0xAE},
    {0xEB,0xB9}, {0xBD,0xEA}, {0xEB,0xBA}, {0xEE,0xB9},
    {0xA8,0xAB}, {0xD0,0xB2}, {0xAD,0x76}, {0xAD,0x75},
    {0xD3,0xE3}, {0xB0,0x5F}, {0xD3,0xE4}, {0xD7,0xD5},
    {0x92,0xC1}, {0xD7,0xD4}, {0xD7,0xD3}, {0xDB,0xEE},
    {0xB6,0x58}, {0x9F,0xD6}, {0xDB,0xED}, {0xB6,0x57},
    {0xDB,0xEF}, {0xB6,0x56}, {0xE0,0x5F}, {0xE0,0x62},
    {0xE0,0x60}, {0xE0,0x61}, {0xE0,0x65}, {0xE0,0x5E},
    {0xE0,0x66}, {0xE0,0x63}, {0xE0,0x64}, {0xBB,0xB0},
    {0xE4,0x56}, {0xBB,0xAF}, {0xE7,0xF2}, {0xE7,0xF0},
    {0xBD,0xEB}, {0xE7,0xEF}, {0xE7,0xF1}, {0xBD,0xEC},
    {0xEB,0xBB}, {0xA0,0xD2}, {0xEB,0xBC}, {0xC1,0xCD},
    {0x90,0x40}, {0xF3,0x4C}, {0xF3,0x4E}, {0xF3,0x4B},
    {0xF3,0x4D}, {0xF4,0xD6}, {0xF6,0x54}, {0xF9,0x6F},
    {0xA8,0xAC}, {0xAD,0x77}, {0xD3,0xE5}, {0xD3,0xE7},
    {0xD3,0xE6}, {0xD7,0xD8}, {0xB3,0x6C}, {0xD7,0xD6},
    {0xB3,0x6B}, {0xD7,0xD9}, {0x8A,0xC4}, {0xD7,0xDA},
    {0xD7,0xD7}, {0x99,0xE0}, {0xDB,0xFB}, {0xB6,0x60},
    {0xDB,0xF3}, {0xDB,0xF9}, {0xB6,0x5B}, {0xB6,0x5E},
    {0xDB,0xF2}, {0xB6,0x59}, {0xDB,0xF6}, {0xE0,0x6C},
    {0xB6,0x5D}, {0xDB,0xF1}, {0x9F,0xF0}, {0xDB,0xF7},
    {0xDB,0xF4}, {0xDB,0xFA}, {0xDB,0xF0}, {0xDB,0xF8},
    {0xB6,0x5C}, {0xB6,0x5F}, {0xDB,0xF5}, {0xB6,0x5A},
    {0xB8,0xF2}, {0xE0,0x68}, {0xB8,0xF1}, {0xE0,0x6F},
    {0xE0,0x6E}, {0xB8,0xF8}, {0xB8,0xF9}, {0xE0,0x70},
    {0xB8,0xF3}, {0xE0,0x6D}, {0xB8,0xF7}, {0xE0,0x72},
    {0xE0,0x69}, {0xE0,0x6B}, {0xB8,0xF4}, {0xE0,0x67},
    {0xE0,0x6A}, {0xE0,0x71}, {0xB8,0xF5}, {0xE0,0x73},
    {0xB8,0xF6}, {0xBB,0xB1}, {0xE4,0x5B}, {0xE4,0x61},
    {0xE4,0x59}, {0xE4,0x62}, {0x9F,0xF3}, {0xE4,0x58},
    {0xE4,0x5D}, {0xE4,0x63}, {0xE4,0x60}, {0xE4,0x5F},
    {0xE4,0x5E}, {0xE4,0x57}, {0xE4,0x5C}, {0xE4,0x5A},
    {0x9D,0xBF}, {0xBD,0xF1}, {0xBD,0xEE}, {0xE7,0xFB},
    {0xE8,0x41}, {0xE8,0x43}, {0xE8,0x40}, {0xE7,0xF8},
    {0xE7,0xFA}, {0xE8,0x45}, {0xE8,0x42}, {0xE7,0xFC},
    {0xE8,0x46}, {0xE7,0xF9}, {0xE8,0x44}, {0xBD,0xEF},
    {0xBD,0xF5}, {0xBD,0xF3}, {0xE7,0xF3}, {0xBD,0xF4},
    {0xBD,0xF0}, {0xE7,0xF4}, {0xE7,0xF6}, {0xE7,0xF5},
    {0xE7,0xFD}, {0xE7,0xFE}, {0x9F,0xF6}, {0xBD,0xF2},
    {0x95,0xC8}, {0xBD,0xED}, {0x9E,0x5A}, {0xE7,0xF7},
    {0xEB,0xC6}, {0xBF,0xE2}, {0xEB,0xBD}, {0xBF,0xE3},
    {0xBF,0xE6}, {0xEB,0xC2}, {0xEB,0xBF}, {0xBF,0xE5},
    {0x99,0xE3}, {0xEB,0xC3}, {0xEB,0xC4}, {0xEB,0xBE},
    {0xEB,0xC7}, {0xEB,0xC0}, {0xEB,0xC5}, {0xBF,0xE4},
    {0xBF,0xE1}, {0xEB,0xC1}, {0x8A,0x4A}, {0xEE,0xBF},
    {0xC1,0xD0}, {0xC1,0xCE}, {0xC1,0xD1}, {0xC1,0xCF},
    {0xEE,0xBE}, {0xEE,0xBB}, {0xEE,0xBA}, {0x9F,0xF1},
    {0xEE,0xBD}, {0xEE,0xBC}, {0xF1,0x45}, {0xC2,0xDE},
    {0xF0,0xFB}, {0xF0,0xFA}, {0xC2,0xD9}, {0xF1,0x41},
    {0xF1,0x40}, {0xF0,0xF7}, {0xF1,0x43}, {0xF0,0xFC},
    {0xC2,0xDD}, {0xF0,0xF9}, {0xF1,0x42}, {0xF0,0xF8},
    {0xC2,0xDA}, {0xC2,0xDC}, {0xF0,0xFD}, {0xC2,0xDB},
    {0xF0,0xFE}, {0x8A,0xA7}, {0xF1,0x44}, {0xF3,0x52},
    {0xC3,0xDE}, {0xF3,0x4F}, {0xF3,0x53}, {0x99,0xE6},
    {0xC3,0xDB}, {0xF3,0x51}, {0xC3,0xE0}, {0x9F,0xF7},
    {0xC3,0xDD}, {0x9F,0xED}, {0xF3,0x50}, {0xC3,0xDF},
    {0xF3,0x54}, {0xC3,0xDA}, {0x8A,0x5C}, {0x9D,0xAE},
    {0xC4,0xBC}, {0xC4,0xBE}, {0xF4,0xD9}, {0xC4,0xBD},
    {0xF4,0xD7}, {0xC3,0xDC}, {0xF4,0xD8}, {0xC4,0xBB},
    {0xC5,0x43}, {0xC5,0x45}, {0xF6,0x56}, {0xC5,0x44},
    {0xF6,0x55}, {0xF7,0x61}, {0xC5,0xAD}, {0xF7,0x60},
    {0xC5,0xAE}, {0xF7,0x5E}, {0xF7,0x5D}, {0xF7,0x62},
    {0xF7,0x63}, {0xF8,0x46}, {0xF7,0x5F}, {0xF8,0xC6},
    {0xF8,0xC3}, {0xF8,0xC4}, {0xF8,0xC5}, {0xC6,0x5C},
    {0xF9,0x51}, {0xF9,0x50}, {0xF9,0x4F}, {0xF9,0x70},
    {0x95,0xC9}, {0xF9,0xBE}, {0xF9,0xAB}, {0xC6,0x6E},
    {0xA8,0xAD}, {0xB0,0x60}, {0x90,0x48}, {0x99,0xE8},
    {0xB8,0xFA}, {0x90,0x49}, {0x8C,0xBA}, {0xBD,0xF6},
    {0x90,0xB1}, {0xEB,0xC8}, {0xC2,0xDF}, {0xF3,0x55},
    {0x90,0x4A}, {0xF9,0xAC}, {0xA8,0xAE}, {0xAA,0xEE},
    {0xAD,0x79}, {0xAD,0x78}, {0x99,0xEA}, {0xB0,0x63},
    {0xD3,0xE8}, {0xB0,0x61}, {0xD3,0xE9}, {0xB0,0x62},
    {0xD7,0xDF}, {0xD7,0xDB}, {0x9B,0xD1}, {0xB3,0x6D},
    {0xD7,0xDE}, {0xD7,0xDD}, {0xD7,0xDC}, {0xB3,0x6E},
    {0xD7,0xE0}, {0xD7,0xE1}, {0x99,0xEB}, {0x99,0xEC},
    {0xDC,0x43}, {0xDC,0x41}, {0xDC,0x45}, {0xDC,0x46},
    {0xDC,0x4C}, {0xDC,0x48}, {0xDC,0x4A}, {0x99,0xED},
    {0xDC,0x42}, {0xDB,0xFC}, {0xDC,0x49}, {0x99,0xEE},
    {0xDC,0x4B}, {0xDC,0x44}, {0xDC,0x47}, {0xDB,0xFD},
    {0xB6,0x62}, {0xDC,0x40}, {0xDB,0xFE}, {0xB6,0x61},
    {0xB6,0x63}, {0xB8,0xFD}, {0xE0,0x75}, {0xE0,0x77},
    {0xE0,0x76}, {0xE0,0x7B}, {0xB8,0xFB}, {0xE0,0x78},
    {0xE0,0x74}, {0xE0,0x79}, {0xE0,0x7A}, {0xB8,0xFC},
    {0xB8,0xFE}, {0xE0,0x7C}, {0xE4,0x67}, {0xE4,0x66},
    {0xE4,0x64}, {0xE4,0x65}, {0xBB,0xB3}, {0xBB,0xB5},
    {0xBB,0xB2}, {0xBB,0xB4}, {0xE8,0x4D}, {0xE8,0x4E},
    {0xE8,0x49}, {0x90,0x4C}, {0xE8,0x4A}, {0xBD,0xF8},
    {0xBD,0xFD}, {0xBD,0xF7}, {0xBD,0xFE}, {0xBD,0xF9},
    {0xE8,0x4B}, {0xE8,0x4C}, {0xE8,0x48}, {0xBE,0x40},
    {0xBD,0xFB}, {0xBD,0xFA}, {0xBD,0xFC}, {0xE8,0x47},
    {0x90,0x4D}, {0xEB,0xCA}, {0xBF,0xE8}, {0x95,0xCB},
    {0xEB,0xCC}, {0xBF,0xEA}, {0xEB,0xCF}, {0xEB,0xCB},
    {0xEB,0xC9}, {0xEB,0xCE}, {0xBF,0xE9}, {0xEB,0xCD},
    {0xBF,0xE7}, {0xC1,0xD3}, {0xC1,0xD6}, {0xEE,0xC1},
    {0x97,0xE2}, {0xC1,0xD4}, {0xEE,0xC0}, {0xC1,0xD2},
    {0xC1,0xD5}, {0xF1,0x46}, {0xF1,0x47}, {0xF1,0x48},
    {0xC2,0xE0}, {0x95,0xCC}, {0xF1,0x49}, {0xC2,0xE1},
    {0xC3,0xE2}, {0xF3,0x58}, {0xF3,0x59}, {0xF3,0x57},
    {0xF3,0x56}, {0xF3,0x5A}, {0xC3,0xE1}, {0xF4,0xDD},
    {0xF4,0xDB}, {0xF4,0xDC}, {0xF4,0xDE}, {0xF4,0xDA},
    {0xF4,0xDF}, {0xF6,0x58}, {0x9F,0x78}, {0xF6,0x59},
    {0xF6,0x57}, {0xC5,0x46}, {0xF7,0x64}, {0xC5,0xAF},
    {0xF7,0x65}, {0xF8,0x48}, {0xF8,0x47}, {0x89,0x7C},
    {0x89,0x7D}, {0x89,0x7E}, {0x99,0x5D}, {0xA8,0xAF},
    {0xB6,0x64}, {0xB9,0x40}, {0x9B,0x5A}, {0xBB,0xB6},
    {0x90,0x50}, {0xBF,0xEC}, {0x8C,0x4F}, {0xBF,0xEB},
    {0xC3,0xE3}, {0xC4,0x7C}, {0xC5,0x47}, {0xA8,0xB0},
    {0xB0,0x64}, {0xB9,0x41}, {0x90,0x54}, {0xF3,0x5B},
    {0xC6,0xD6}, {0x9A,0xA8}, {0x99,0xEF}, {0xFE,0xEB},
    {0x9D,0xA3}, {0x9D,0xA1}, {0x99,0x43}, {0x99,0x45},
    {0x9D,0x7D}, {0xCB,0xA6}, {0x99,0xF0}, {0xA8,0xB1},
    {0xA8,0xB4}, {0xA8,0xB3}, {0xA8,0xB2}, {0xCB,0xA5},
    {0x99,0xF1}, {0xCD,0xCD}, {0x99,0xF2}, {0xCD,0xCF},
    {0xAA,0xEF}, {0x8C,0xBC}, {0x9D,0x60}, {0xAA,0xF1},
    {0xCD,0xCC}, {0xCD,0xCE}, {0xAA,0xF0}, {0xCD,0xD1},
    {0xCD,0xD0}, {0xCD,0xD2}, {0xA0,0xA3}, {0xD0,0xB6},
    {0xD0,0xB4}, {0xAD,0x7C}, {0xD0,0xB3}, {0xAD,0xA3},
    {0xAD,0x7E}, {0xAD,0x7B}, {0xAD,0xA4}, {0xAD,0x7D},
    {0xAD,0xA2}, {0xAD,0xA1}, {0xD0,0xB5}, {0xAD,0x7A},
    {0xB0,0x6A}, {0xD3,0xEB}, {0xD3,0xF1}, {0xB0,0x67},
    {0xB0,0x6E}, {0x90,0x5B}, {0xB0,0x69}, {0xD3,0xEE},
    {0xD3,0xF0}, {0xB0,0x6C}, {0xD3,0xEA}, {0xD3,0xED},
    {0xB0,0x68}, {0xB0,0x65}, {0xD3,0xEC}, {0xB0,0x6B},
    {0xD3,0xEF}, {0xB0,0x6D}, {0xB0,0x66}, {0x9E,0xDB},
    {0xD7,0xE3}, {0xD7,0xE6}, {0xB3,0x70}, {0xB3,0x7A},
    {0xB3,0x76}, {0xD7,0xE4}, {0x9D,0x79}, {0xB3,0x7E},
    {0xB3,0x77}, {0xB3,0x7C}, {0xB3,0x72}, {0xB3,0x6F},
    {0xB3,0x71}, {0xB3,0x7D}, {0xD7,0xE5}, {0xB3,0x75},
    {0xB3,0x78}, {0xB3,0x74}, {0xB3,0x79}, {0xD7,0xE7},
    {0xB3,0x7B}, {0xB3,0x73}, {0xD7,0xE2}, {0xDC,0x4D},
    {0xB6,0x65}, {0xDC,0x4F}, {0xB6,0x67}, {0xB6,0x69},
    {0x99,0xF3}, {0xDC,0x4E}, {0xB6,0x66}, {0xB6,0x6A},
    {0x90,0x62}, {0xB6,0x68}, {0xB9,0x47}, {0xE0,0xA3},
    {0xB9,0x4F}, {0xE0,0x7E}, {0xB9,0x50}, {0xB9,0x45},
    {0xE0,0xA1}, {0xB9,0x4A}, {0xE0,0xA2}, {0xB9,0x43},
    {0xB9,0x42}, {0x9F,0x55}, {0xB9,0x4D}, {0xB9,0x4C},
    {0xB9,0x4B}, {0xB9,0x49}, {0xB9,0x4E}, {0xE0,0x7D},
    {0xB9,0x44}, {0xB9,0x46}, {0xB9,0x48}, {0x9B,0xF9},
    {0xBB,0xB8}, {0xBB,0xBB}, {0xBB,0xBF}, {0xBB,0xB9},
    {0xBB,0xBE}, {0xBB,0xBC}, {0xBB,0xB7}, {0x90,0x65},
    {0xBB,0xBD}, {0xBB,0xBA}, {0x96,0xE0}, {0xE8,0x52},
    {0xBE,0x43}, {0xBE,0x41}, {0xE8,0x53}, {0x98,0xBE},
    {0xBE,0x44}, {0xBE,0x42}, {0xE8,0x51}, {0xE8,0x50},
    {0xBF,0xF0}, {0xE8,0x4F}, {0xBF,0xEE}, {0xBF,0xED},
    {0xEB,0xD0}, {0xBE,0x45}, {0xBF,0xEF}, {0xEB,0xD1},
    {0xBF,0xF2}, {0xEB,0xD2}, {0xBF,0xF1}, {0xC1,0xD8},
    {0xEE,0xC3}, {0xC1,0xD7}, {0xC1,0xDC}, {0xC1,0xDA},
    {0xC1,0xDB}, {0xC2,0xE3}, {0xC1,0xD9}, {0xEE,0xC2},
    {0xEB,0xD3}, {0xC2,0xE2}, {0xC2,0xE4}, {0xC3,0xE4},
    {0xC3,0xE5}, {0xF4,0xE0}, {0xC5,0xDE}, {0xC5,0xDD},
    {0xA8,0xB6}, {0xCA,0x55}, {0xB0,0x6F}, {0xCA,0x52},
    {0xCA,0x53}, {0xCA,0x51}, {0xCA,0x54}, {0xCB,0xAA},
    {0xCB,0xA7}, {0xCB,0xAC}, {0xCB,0xA8}, {0xA8,0xB7},
    {0xA8,0xBA}, {0xCB,0xA9}, {0xA8,0xB9}, {0xCB,0xAB},
    {0x90,0x68}, {0xA8,0xB8}, {0x90,0x6C}, {0xCD,0xD5},
    {0xCD,0xD7}, {0xAA,0xF4}, {0xCD,0xD3}, {0xCD,0xD6},
    {0xCD,0xD4}, {0xAA,0xF2}, {0xAA,0xF5}, {0xAA,0xF3},
    {0x95,0xD8}, {0xD0,0xB8}, {0xD0,0xBC}, {0xD0,0xB9},
    {0xAD,0xA7}, {0xAD,0xA8}, {0x90,0x6A}, {0xD0,0xBB},
    {0xD0,0xBD}, {0xD0,0xBF}, {0xAD,0xA5}, {0xD0,0xBE},
    {0xAD,0xA6}, {0xD7,0xEE}, {0xD0,0xBA}, {0xD3,0xF2},
    {0xD3,0xFB}, {0xD3,0xF9}, {0xD3,0xF4}, {0xD3,0xF5},
    {0xD3,0xFA}, {0xD3,0xFC}, {0xB0,0x71}, {0xD3,0xF7},
    {0xD3,0xF3}, {0xB0,0x70}, {0xB0,0x72}, {0xD3,0xF6},
    {0xD3,0xFD}, {0xD3,0xF8}, {0xB3,0xA1}, {0xD7,0xF1},
    {0xD7,0xE9}, {0xD7,0xEF}, {0xD7,0xF0}, {0xB3,0xA2},
    {0xD7,0xE8}, {0xD7,0xEA}, {0xD0,0xB7}, {0xD7,0xEC},
    {0xD7,0xED}, {0xD7,0xEB}, {0xB6,0x6C}, {0xDC,0x56},
    {0xEB,0xD4}, {0xDC,0x57}, {0xDC,0x54}, {0xB3,0xA3},
    {0xB6,0x6E}, {0xDC,0x53}, {0xDC,0x59}, {0xDC,0x58},
    {0xB6,0x6B}, {0xDC,0x5C}, {0xDC,0x52}, {0xDC,0x5B},
    {0xDC,0x50}, {0xDC,0x5A}, {0xDC,0x55}, {0xB6,0x6D},
    {0xE0,0xAA}, {0xE0,0xA5}, {0xE0,0xAB}, {0xE0,0xA6},
    {0xE0,0xA4}, {0xE0,0xA7}, {0xB9,0x51}, {0xE0,0xA9},
    {0xE0,0xA8}, {0xB9,0x52}, {0xBB,0xC1}, {0xBB,0xC0},
    {0xE4,0x6E}, {0xE4,0x71}, {0xE4,0x69}, {0xE4,0x6D},
    {0xBB,0xC2}, {0xE4,0x6C}, {0xE4,0x6A}, {0xE4,0x70},
    {0xE4,0x6B}, {0xE4,0x68}, {0xE4,0x6F}, {0xE8,0x59},
    {0xBE,0x48}, {0xF1,0x4A}, {0xE8,0x56}, {0xE8,0x57},
    {0xE8,0x55}, {0xDC,0x51}, {0xBE,0x47}, {0xE8,0x5A},
    {0xE8,0x54}, {0xBE,0x46}, {0xBE,0x49}, {0xE8,0x58},
    {0xEB,0xD5}, {0xBF,0xF3}, {0xEB,0xD6}, {0xEB,0xD7},
    {0xEE,0xC4}, {0xC1,0xDD}, {0xF1,0x4B}, {0xF1,0x4C},
    {0xF1,0x4D}, {0xF3,0x5D}, {0xF3,0x5C}, {0xF4,0xE2},
    {0xF4,0xE1}, {0xF6,0x5B}, {0xF6,0x5C}, {0xF6,0x5A},
    {0xF7,0x66}, {0xC5,0xB0}, {0xA8,0xBB}, {0xAD,0xAA},
    {0xAD,0xA9}, {0xB0,0x75}, {0xB0,0x74}, {0xD4,0x40},
    {0xD4,0x41}, {0xD3,0xFE}, {0x9F,0xB2}, {0xB0,0x73},
    {0xD7,0xF5}, {0xD7,0xF6}, {0xD7,0xF2}, {0xB3,0xA4},
    {0xD7,0xF3}, {0x9F,0xAE}, {0xD7,0xF4}, {0x9F,0xB0},
    {0x89,0xAD}, {0xDC,0x5F}, {0xDC,0x61}, {0xDC,0x5D},
    {0xDC,0x60}, {0xB6,0x6F}, {0xDC,0x5E}, {0xB6,0x70},
    {0x90,0x6E}, {0xDD,0x73}, {0xB9,0x55}, {0xB9,0x54},
    {0xB9,0x53}, {0xE0,0xAC}, {0xE0,0xAD}, {0x9E,0x71},
    {0xE4,0x73}, {0xE4,0x75}, {0xBB,0xC6}, {0xBB,0xC3},
    {0x9E,0x4A}, {0xBB,0xC5}, {0xBB,0xC4}, {0xE4,0x74},
    {0xE4,0x72}, {0x9F,0xDC}, {0xE8,0x61}, {0xE8,0x5E},
    {0xE8,0x5F}, {0xBE,0x4D}, {0xE8,0x60}, {0xE8,0x5B},
    {0xE8,0x5C}, {0xBE,0x4A}, {0xBE,0x4B}, {0xE8,0x5D},
    {0xBE,0x4C}, {0x89,0xAB}, {0xEB,0xDB}, {0x9F,0xB8},
    {0xEB,0xDC}, {0xEB,0xD9}, {0xEB,0xDA}, {0xBF,0xF4},
    {0xEB,0xD8}, {0xEE,0xC8}, {0xEE,0xC5}, {0xEE,0xC7},
    {0xC1,0xE0}, {0xEE,0xCB}, {0xC1,0xDF}, {0xEE,0xC9},
    {0xEE,0xCC}, {0xEE,0xCA}, {0xEE,0xC6}, {0xC1,0xDE},
    {0xF1,0x4F}, {0xF1,0x50}, {0xF1,0x4E}, {0x90,0x70},
    {0xF1,0x52}, {0xC2,0xE5}, {0xC2,0xE6}, {0xF3,0x5F},
    {0xC3,0xE7}, {0xF1,0x51}, {0xF3,0x5E}, {0xC3,0xE6},
    {0xF4,0xE5}, {0xF4,0xE6}, {0xC4,0xBF}, {0xF4,0xE4},
    {0x8B,0x63}, {0xF4,0xE3}, {0xF6,0x5D}, {0xC5,0x48},
    {0x95,0xDC}, {0xF8,0x49}, {0xF8,0xC8}, {0xF8,0xC7},
    {0xC6,0x43}, {0xC6,0x5D}, {0xF8,0xC9}, {0xF9,0x71},
    {0x90,0x71}, {0xC6,0x6F}, {0xA8,0xBC}, {0xAA,0xF6},
    {0xB9,0x56}, {0xC4,0xC0}, {0xA8,0xBD}, {0xAD,0xAB},
    {0xB3,0xA5}, {0xB6,0x71}, {0xC2,0xE7}, {0xAA,0xF7},
    {0xD0,0xC1}, {0xD0,0xC0}, {0xD4,0x42}, {0xFC,0x5E},
    {0xB0,0x78}, {0xB0,0x76}, {0xB0,0x7A}, {0xD4,0x44},
    {0xB0,0x79}, {0xB0,0x77}, {0x89,0x49}, {0xD4,0x43},
    {0xB3,0xA8}, {0xD7,0xFC}, {0x96,0x5B}, {0xB3,0xA7},
    {0xB3,0xA9}, {0xD8,0x42}, {0xB3,0xAB}, {0xD7,0xFE},
    {0xD8,0x40}, {0xD7,0xF7}, {0xB3,0xAA}, {0xD8,0x43},
    {0xD7,0xF9}, {0xD7,0xFA}, {0xD7,0xF8}, {0xB3,0xA6},
    {0x8C,0x50}, {0xD8,0x41}, {0xD7,0xFB}, {0xD7,0xFD},
    {0x94,0xA6}, {0xDC,0x6D}, {0x8F,0xD5}, {0xDC,0x6C},
    {0xDC,0x6A}, {0xDC,0x62}, {0xDC,0x71}, {0xDC,0x65},
    {0xDC,0x6F}, {0xDC,0x76}, {0xDC,0x6E}, {0xB6,0x79},
    {0x9E,0x73}, {0xB6,0x75}, {0xDC,0x63}, {0xDC,0x69},
    {0xB6,0x77}, {0x90,0x75}, {0xDC,0x68}, {0xB6,0x78},
    {0xB6,0x7A}, {0xDC,0x6B}, {0x99,0xF7}, {0xB6,0x72},
    {0xB6,0x73}, {0xDC,0x77}, {0xDC,0x75}, {0xDC,0x74},
    {0xDC,0x66}, {0xDC,0x72}, {0xB6,0x76}, {0x8C,0xBF},
    {0xB6,0x74}, {0xDC,0x73}, {0xDC,0x64}, {0xDC,0x67},
    {0xDC,0x70}, {0x99,0xF9}, {0x96,0x63}, {0x95,0xB9},
    {0xE4,0xBA}, {0xE0,0xB7}, {0xE0,0xB0}, {0xE0,0xC3},
    {0xE0,0xCC}, {0xE0,0xB3}, {0xB9,0x61}, {0x94,0xD4},
    {0xE0,0xC0}, {0xB9,0x57}, {0xB9,0x59}, {0xB9,0x65},
    {0xE0,0xB1}, {0xFC,0xFA}, {0xB9,0x5A}, {0xB9,0x5C},
    {0xB9,0x66}, {0xB9,0x5B}, {0x90,0x77}, {0x90,0xAB},
    {0xB9,0x64}, {0xE0,0xB9}, {0xE0,0xAE}, {0xB9,0x62},
    {0xE0,0xB8}, {0xB9,0x5E}, {0xE0,0xCA}, {0xB9,0x63},
    {0xE0,0xC8}, {0xE0,0xBC}, {0xE0,0xC6}, {0xB9,0x60},
    {0xE0,0xAF}, {0xE0,0xC9}, {0xE0,0xC4}, {0x9D,0x4D},
    {0xE0,0xCB}, {0xB9,0x58}, {0x99,0xFA}, {0xB9,0x67},
    {0xB9,0x5D}, {0x92,0xE3}, {0xE0,0xB5}, {0x97,0xBB},
    {0xE0,0xBD}, {0xE0,0xC1}, {0x90,0x78}, {0xE0,0xC5},
    {0xB9,0x5F}, {0xE0,0xB4}, {0xE0,0xB2}, {0xE0,0xBE},
    {0x99,0xFB}, {0xE0,0xBB}, {0xE0,0xBA}, {0x97,0xE0},
    {0xE0,0xBF}, {0xE0,0xC2}, {0xE0,0xC7}, {0xE4,0x78},
    {0x96,0xDC}, {0xBB,0xC7}, {0xE4,0xA4}, {0xE4,0x7A},
    {0xBB,0xCC}, {0xBB,0xD0}, {0xE4,0xAD}, {0xE4,0xB5},
    {0xE4,0xA6}, {0xBB,0xC8}, {0x9C,0xA8}, {0xE4,0xAA},
    {0xE0,0xB6}, {0x97,0x72}, {0xBB,0xC9}, {0xE4,0xB1},
    {0xE4,0xB6}, {0xE4,0xAE}, {0x94,0x40}, {0xE4,0xB0},
    {0xE4,0xB9}, {0xE4,0xB2}, {0xE4,0x7E}, {0xE4,0xA9},
    {0x92,0xF2}, {0xBB,0xD1}, {0xBB,0xCD}, {0xE4,0x7C},
    {0xE4,0xAB}, {0xBB,0xCB}, {0xE4,0xA5}, {0xBB,0xCA},
    {0xE4,0xB3}, {0xE4,0xA2}, {0xE4,0x79}, {0xBB,0xCE},
    {0xE4,0xB8}, {0xE4,0x7B}, {0xE4,0xAF}, {0xE4,0xAC},
    {0xE4,0xA7}, {0xE4,0x77}, {0xE4,0x76}, {0xE4,0xA1},
    {0xE4,0xB4}, {0xBB,0xCF}, {0xE4,0xB7}, {0xE4,0x7D},
    {0xE4,0xA3}, {0xBE,0x52}, {0x99,0xFD}, {0x99,0xFC},
    {0xBE,0x5A}, {0xBE,0x55}, {0xE8,0xA4}, {0xE8,0xA1},
    {0xE8,0x67}, {0xBE,0x50}, {0xF9,0xD7}, {0x96,0x4A},
    {0xBE,0x4F}, {0xBE,0x56}, {0x96,0xD8}, {0x99,0xFE},
    {0xE8,0x65}, {0xBE,0x54}, {0xE8,0x71}, {0xE8,0x63},
    {0xE8,0x64}, {0xBE,0x4E}, {0xE8,0xA3}, {0xBE,0x58},
    {0xE8,0x74}, {0xE8,0x79}, {0xE8,0x73}, {0xEB,0xEE},
    {0xE8,0x6F}, {0xE8,0x77}, {0xE8,0x75}, {0xE8,0x68},
    {0xE8,0x62}, {0xE8,0x7D}, {0xBE,0x57}, {0xE8,0x7E},
    {0x90,0x4B}, {0xE8,0x78}, {0xE8,0x6D}, {0xE8,0x6B},
    {0xE8,0x66}, {0xFA,0x41}, {0xE8,0x6E}, {0xE8,0x7B},
    {0xE8,0x6A}, {0xE8,0x7A}, {0xE8,0xA2}, {0x9A,0x40},
    {0xBE,0x53}, {0x97,0x5B}, {0xE8,0x76}, {0xE8,0x7C},
    {0xE8,0x72}, {0xE8,0x6C}, {0xBE,0x51}, {0x9A,0x41},
    {0x91,0xDD}, {0xE4,0xA8}, {0xE8,0x70}, {0xBE,0x59},
    {0xE8,0x69}, {0x93,0xFC}, {0x9A,0x42}, {0x9A,0x43},
    {0x96,0x59}, {0xEB,0xF4}, {0xBF,0xF7}, {0xEB,0xF3},
    {0xEB,0xF0}, {0xEC,0x44}, {0xBF,0xFB}, {0x9A,0x44},
    {0xEC,0x41}, {0xEB,0xF8}, {0xEC,0x43}, {0xEB,0xE9},
    {0xEB,0xF6}, {0x90,0x51}, {0xBF,0xFD}, {0xEB,0xE1},
    {0x94,0xBF}, {0xEB,0xDF}, {0xEC,0x42}, {0xEC,0x40},
    {0xEB,0xFE}, {0xEB,0xED}, {0xEB,0xEC}, {0xEB,0xE2},
    {0xC0,0x40}, {0xEB,0xE8}, {0xEB,0xF2}, {0xEB,0xFD},
    {0xC0,0x43}, {0xEC,0x45}, {0xC1,0xE8}, {0xC0,0x45},
    {0xBF,0xFE}, {0xEB,0xE6}, {0xEB,0xEF}, {0xEB,0xDE},
    {0xEB,0xE0}, {0xBF,0xF5}, {0xC0,0x42}, {0xBF,0xFA},
    {0xEB,0xE7}, {0xEB,0xF7}, {0xEB,0xF1}, {0xC0,0x41},
    {0xEB,0xDD}, {0xC1,0xE3}, {0xEB,0xF9}, {0xEB,0xFC},
    {0xBF,0xFC}, {0x90,0xA2}, {0xEB,0xEB}, {0xC0,0x44},
    {0xBF,0xF9}, {0x9C,0xAB}, {0x97,0x76}, {0xBF,0xF8},
    {0xEB,0xF5}, {0xEB,0xFB}, {0xBF,0xF6}, {0xEB,0xE4},
    {0xEB,0xFA}, {0xEB,0xE5}, {0xFC,0x55}, {0xFE,0x45},
    {0x94,0xA8}, {0x9A,0x45}, {0xFA,0x4B}, {0x9D,0xE1},
    {0xEB,0xEA}, {0xEE,0xD2}, {0x96,0xD9}, {0xEE,0xD7},
    {0xC1,0xE5}, {0xC1,0xE7}, {0xEE,0xDD}, {0xC1,0xE1},
    {0xEE,0xEC}, {0xEE,0xE3}, {0xEE,0xD8}, {0xEE,0xD9},
    {0xEE,0xE2}, {0xC1,0xEE}, {0xEE,0xE1}, {0xEE,0xD1},
    {0xEE,0xE0}, {0xEE,0xD4}, {0xEE,0xED}, {0xC1,0xED},
    {0xC1,0xEB}, {0xEE,0xD5}, {0xEE,0xE8}, {0x97,0x74},
    {0xEE,0xDA}, {0xEE,0xE7}, {0xFD,0xF5}, {0xEE,0xE9},
    {0xEE,0xD0}, {0xC1,0xE6}, {0x92,0xE5}, {0xEE,0xEA},
    {0x96,0x45}, {0x91,0xDA}, {0xEE,0xDE}, {0x90,0xA3},
    {0xC1,0xEA}, {0xEE,0xDB}, {0xA0,0x5F}, {0xC1,0xEC},
    {0xEE,0xE4}, {0x90,0xAF}, {0x97,0xBF}, {0xC1,0xE4},
    {0xEE,0xD6}, {0xEE,0xE5}, {0x91,0x4C}, {0xEE,0xDF},
    {0xEB,0xE3}, {0xEE,0xE6}, {0xEE,0xD3}, {0x96,0x7A},
    {0xC1,0xE9}, {0xEE,0xEB}, {0x91,0xDE}, {0xC1,0xE2},
    {0xEE,0xCE}, {0x9A,0x46}, {0xFE,0xB0}, {0x97,0x79},
    {0x94,0x6C}, {0xF1,0x60}, {0xF1,0x59}, {0xC2,0xE9},
    {0xF1,0x54}, {0xF1,0x63}, {0xF1,0x5B}, {0xEE,0xDC},
    {0x98,0x58}, {0xF1,0x65}, {0xF1,0x55}, {0xC2,0xE8},
    {0xF1,0x5F}, {0xC2,0xEA}, {0xC2,0xF2}, {0xC2,0xF0},
    {0xF1,0x61}, {0xC2,0xF1}, {0xF1,0x57}, {0x92,0x66},
    {0xF1,0x58}, {0xF1,0x5D}, {0xF1,0x62}, {0x93,0xFB},
    {0xEE,0xCD}, {0xC2,0xEB}, {0xF1,0x6A}, {0xF1,0x67},
    {0xF1,0x6B}, {0xF1,0x5E}, {0xF1,0x5A}, {0xF1,0x68},
    {0xF3,0x6A}, {0xF1,0x5C}, {0xC2,0xEE}, {0x9A,0x47},
    {0xC2,0xED}, {0xEE,0xCF}, {0xC2,0xEF}, {0xF1,0x64},
    {0xF1,0x66}, {0xC2,0xEC}, {0xF1,0x69}, {0xF1,0x53},
    {0xF1,0x56}, {0x97,0x49}, {0x97,0x48}, {0x93,0x4A},
    {0x9C,0xE2}, {0xF3,0x73}, {0xF3,0x63}, {0xC3,0xEB},
    {0xF3,0x71}, {0x92,0x64}, {0xF3,0x61}, {0xC3,0xEC},
    {0xF3,0x6C}, {0x91,0xDF}, {0xF3,0x68}, {0xC3,0xF1},
    {0xF3,0x72}, {0xF3,0x62}, {0xF3,0x65}, {0xC3,0xE9},
    {0xF3,0x74}, {0xFB,0x79}, {0xF3,0x6D}, {0xF3,0x70},
    {0xC3,0xEF}, {0xC3,0xF4}, {0xC3,0xF2}, {0xF3,0x69},
    {0xF3,0x64}, {0x96,0xD7}, {0xC3,0xED}, {0xC3,0xEE},
    {0xF3,0x60}, {0xC3,0xEA}, {0x93,0x43}, {0xC3,0xE8},
    {0xC3,0xF0}, {0xF3,0x6F}, {0xC3,0xF3}, {0xF3,0x6B},
    {0xF3,0x75}, {0xC3,0xF5}, {0xF3,0x67}, {0xF3,0x6E},
    {0xFD,0xCB}, {0xFE,0x7A}, {0x91,0xDB}, {0x8C,0x6A},
    {0xF4,0xF3}, {0xF5,0x42}, {0xF4,0xF5}, {0xF4,0xFC},
    {0xF3,0x66}, {0xF4,0xFA}, {0xF4,0xE9}, {0xF5,0x40},
    {0xC4,0xC3}, {0xF4,0xED}, {0xF4,0xFE}, {0xF4,0xF4},
    {0x97,0xAF}, {0xC4,0xC2}, {0x95,0xDD}, {0xF5,0x44},
    {0xF4,0xF6}, {0x93,0x48}, {0xF4,0xFB}, {0xF4,0xFD},
    {0xF4,0xE7}, {0xF5,0x41}, {0xF4,0xF2}, {0xF4,0xF7},
    {0xF4,0xEB}, {0xF4,0xEF}, {0xF5,0x43}, {0xF4,0xF9},
    {0xF4,0xE8}, {0xF4,0xEC}, {0xF4,0xEE}, {0xF4,0xF8},
    {0x9A,0x4B}, {0xC4,0xC1}, {0xF4,0xF1}, {0xFC,0x45},
    {0x9A,0x4D}, {0xF4,0xEA}, {0x91,0xBC}, {0x90,0xE2},
    {0x90,0xB4}, {0x95,0xE1}, {0xF4,0xF0}, {0xF6,0x61},
    {0xF6,0x66}, {0xC5,0x4F}, {0xF6,0x68}, {0x9A,0x4E},
    {0xC5,0x49}, {0xF6,0x64}, {0xF6,0x6A}, {0xC5,0x4E},
    {0xC5,0x4A}, {0xC5,0x4B}, {0xF6,0x60}, {0xF6,0x67},
    {0xC5,0x4D}, {0xF6,0x65}, {0xC5,0x4C}, {0xF6,0x5F},
    {0xF6,0x63}, {0xF6,0x62}, {0x9A,0x4F}, {0xF6,0x5E},
    {0xF6,0x69}, {0xFE,0x40}, {0xFE,0x43}, {0xC5,0xB1},
    {0xF7,0x6D}, {0xF7,0x70}, {0xF7,0x6C}, {0xF7,0x6E},
    {0xF7,0x6F}, {0xF7,0x69}, {0xF7,0x6A}, {0xF7,0x67},
    {0x96,0xDD}, {0xF7,0x6B}, {0xF7,0x68}, {0xC5,0xB2},
    {0xC5,0xB3}, {0x9A,0x51}, {0xF8,0x4B}, {0xF8,0x4D},
    {0x96,0xA7}, {0x90,0xB0}, {0xF8,0x4C}, {0xF8,0x4E},
    {0xC5,0xE0}, {0xF8,0x4A}, {0xC5,0xDF}, {0xC5,0xE1},
    {0x9C,0x4E}, {0x94,0x43}, {0xF8,0xCB}, {0xF8,0xCC},
    {0xC6,0x44}, {0xF8,0xCA}, {0x8E,0xBA}, {0xF9,0x53},
    {0xF9,0x52}, {0xF9,0x54}, {0xC6,0x5F}, {0xF9,0x55},
    {0xC6,0x5E}, {0xF9,0x56}, {0xF9,0x72}, {0xF9,0x75},
    {0xF9,0x74}, {0xC6,0x68}, {0xF9,0x73}, {0x9A,0x52},
    {0xFC,0xC1}, {0xC6,0x72}, {0xC6,0x70}, {0xC6,0x71},
    {0xC6,0x77}, {0xF9,0xC0}, {0xF9,0xC1}, {0xF9,0xBF},
    {0xF9,0xC9}, {0x8B,0xE9}, {0x9C,0xAF}, {0x8B,0xFD},
    {0x9A,0xBC}, {0x9A,0xB8}, {0x9A,0xAE}, {0x9A,0xA7},
    {0x9A,0x53}, {0x9D,0x74}, {0xAA,0xF8}, {0x8B,0xEA},
    {0xD8,0x44}, {0xDC,0x78}, {0xE8,0xA5}, {0xF3,0x76},
    {0x8B,0xEB}, {0xAA,0xF9}, {0xAD,0xAC}, {0xB0,0x7B},
    {0x90,0xB2}, {0xD8,0x45}, {0xD8,0x46}, {0xB3,0xAC},
    {0xB6,0x7D}, {0xDC,0x7A}, {0xDC,0x79}, {0xB6,0xA3},
    {0xB6,0x7C}, {0xDC,0x7B}, {0xB6,0x7E}, {0xB6,0xA2},
    {0xB6,0xA1}, {0xB6,0x7B}, {0x95,0xE9}, {0x95,0xE8},
    {0xB9,0x68}, {0x95,0xE6}, {0xE0,0xD0}, {0xE0,0xCE},
    {0xE0,0xCF}, {0xE0,0xCD}, {0x90,0xB5}, {0xBB,0xD2},
    {0x9A,0x54}, {0xBB,0xD5}, {0xBB,0xD7}, {0xBB,0xD6},
    {0x90,0xB3}, {0x95,0xE7}, {0xBB,0xD3}, {0xBB,0xD4},
    {0x8B,0x50}, {0xE8,0xA7}, {0xE8,0xA6}, {0xBE,0x5B},
    {0xE8,0xA8}, {0xE8,0xA9}, {0xBE,0x5C}, {0xEC,0x4D},
    {0xEC,0x4B}, {0xEE,0xF3}, {0xEC,0x49}, {0xEC,0x4A},
    {0xC0,0x46}, {0xEC,0x46}, {0xEC,0x4E}, {0xEC,0x48},
    {0xEC,0x4C}, {0xEE,0xEF}, {0xEE,0xF1}, {0xEE,0xF2},
    {0xC1,0xF3}, {0xEE,0xEE}, {0xC1,0xF2}, {0xEE,0xF0},
    {0xC1,0xEF}, {0xC1,0xF0}, {0xC1,0xF1}, {0xEC,0x47},
    {0xC2,0xF5}, {0xF1,0x6E}, {0xF1,0x6C}, {0xF1,0x6D},
    {0xC2,0xF3}, {0xC2,0xF6}, {0xC2,0xF4}, {0xF3,0x77},
    {0xF3,0x78}, {0xC3,0xF6}, {0xF5,0x45}, {0xF5,0x47},
    {0xF5,0x46}, {0xC4,0xC4}, {0xC5,0x50}, {0xF6,0x6D},
    {0xF6,0x6C}, {0xF6,0x6B}, {0x8B,0xEC}, {0x9A,0x56},
    {0xAA,0xFA}, {0x8B,0xFB}, {0xC9,0xAA}, {0xCA,0x58},
    {0xA6,0xE9}, {0xCA,0x56}, {0xCA,0x59}, {0xCA,0x57},
    {0xCB,0xAE}, {0xA8,0xC1}, {0xA8,0xC2}, {0xCB,0xB0},
    {0xA8,0xBF}, {0xCB,0xAF}, {0xCB,0xAD}, {0xA8,0xC0},
    {0xA8,0xBE}, {0x9A,0x57}, {0xA0,0xAA}, {0xCD,0xD8},
    {0xCD,0xDB}, {0xAA,0xFD}, {0xCD,0xDA}, {0xCD,0xD9},
    {0xAA,0xFC}, {0xAA,0xFB}, {0x9F,0xA6}, {0xAB,0x40},
    {0xCD,0xDC}, {0xAA,0xFE}, {0x99,0xCC}, {0xD0,0xC6},
    {0xAD,0xAE}, {0xAD,0xAF}, {0xAD,0xB0}, {0xD0,0xC7},
    {0xD0,0xC3}, {0xAD,0xAD}, {0xD0,0xC4}, {0xD0,0xC5},
    {0xD0,0xC2}, {0x9C,0x59}, {0xB0,0xA4}, {0xB0,0xA1},
    {0xD4,0x45}, {0xB0,0xA2}, {0xB0,0xA5}, {0xD4,0x46},
    {0xB0,0x7E}, {0xB0,0x7C}, {0xB0,0x7D}, {0xB0,0xA3},
    {0x99,0xB5}, {0xB3,0xAD}, {0xD8,0x49}, {0xB3,0xB5},
    {0xD8,0x48}, {0xD8,0x4B}, {0xB3,0xB1}, {0xD8,0x4A},
    {0xB6,0xAB}, {0xB3,0xAF}, {0xB3,0xB2}, {0xB3,0xAE},
    {0xB3,0xB3}, {0xB3,0xB4}, {0xB3,0xB0}, {0x90,0xBE},
    {0xD8,0x47}, {0xB6,0xA7}, {0xDC,0x7D}, {0xDC,0xA3},
    {0x9F,0xAF}, {0xDC,0xA2}, {0xB6,0xAC}, {0xB6,0xA8},
    {0xB6,0xA9}, {0xDC,0x7C}, {0xDC,0x7E}, {0xDC,0xA1},
    {0xB6,0xA4}, {0xB6,0xA6}, {0xB6,0xAA}, {0xB6,0xA5},
    {0x95,0xF2}, {0xE0,0xD3}, {0xE0,0xD1}, {0xE0,0xD2},
    {0xB9,0x6A}, {0xB9,0x6B}, {0x90,0xBF}, {0xE0,0xD4},
    {0xB9,0x69}, {0xBB,0xD8}, {0xBB,0xDA}, {0xBB,0xD9},
    {0xE4,0xBB}, {0xE4,0xBC}, {0xE8,0xAB}, {0x90,0xC1},
    {0xE8,0xAA}, {0xFE,0xE4}, {0xC0,0x47}, {0xC0,0x48},
    {0xEC,0x4F}, {0xC0,0x49}, {0xEE,0xF6}, {0xEE,0xF4},
    {0xEE,0xF5}, {0xC1,0xF4}, {0xF1,0x6F}, {0xC3,0xF7},
    {0x90,0xC4}, {0xC1,0xF5}, {0xAB,0x41}, {0xB0,0xA6},
    {0xD4,0x47}, {0x90,0xC7}, {0xD8,0x4C}, {0xB3,0xB6},
    {0xB6,0xAD}, {0xDC,0xA4}, {0xDC,0xA6}, {0xB6,0xAF},
    {0xB6,0xAE}, {0xB6,0xB0}, {0xB6,0xB1}, {0xDC,0xA5},
    {0xB9,0x6E}, {0xB9,0x6F}, {0xB9,0x6D}, {0xBB,0xDB},
    {0xB9,0x6C}, {0xE0,0xD5}, {0xBB,0xDC}, {0xE8,0xAC},
    {0xEC,0x50}, {0xC0,0x4A}, {0xC1,0xF6}, {0xF1,0x70},
    {0xF1,0x74}, {0xC2,0xF9}, {0xF1,0x71}, {0xC2,0xFA},
    {0xC2,0xF8}, {0xF1,0x75}, {0xC2,0xFB}, {0xF1,0x73},
    {0xF3,0x79}, {0xC2,0xF7}, {0xC3,0xF8}, {0xF8,0xCD},
    {0xAB,0x42}, {0xB3,0xB8}, {0xB3,0xB7}, {0xB6,0xB2},
    {0xDC,0xA8}, {0xDC,0xA7}, {0xB6,0xB3}, {0x92,0xE4},
    {0xE0,0xD9}, {0xB9,0x73}, {0xB9,0x70}, {0xE0,0xD8},
    {0xB9,0x72}, {0xE0,0xD6}, {0xB9,0x71}, {0xE0,0xD7},
    {0xE4,0xBD}, {0xBB,0xDD}, {0xE8,0xAF}, {0x9F,0x52},
    {0xBE,0x5D}, {0xE8,0xAD}, {0xBE,0x5E}, {0xBE,0x5F},
    {0xE8,0xAE}, {0xBE,0x60}, {0xEC,0x51}, {0xC0,0x4E},
    {0xC0,0x4B}, {0xC0,0x50}, {0xEC,0x53}, {0xC0,0x4C},
    {0xEC,0x52}, {0xC0,0x4F}, {0xC0,0x4D}, {0xEE,0xF9},
    {0xEE,0xFB}, {0x90,0xDB}, {0xC1,0xF7}, {0xEE,0xFA},
    {0xC1,0xF8}, {0xEE,0xF8}, {0xEE,0xF7}, {0xA0,0x66},
    {0xF1,0x77}, {0xF1,0x76}, {0xC2,0xFC}, {0xF1,0x78},
    {0xF3,0x7E}, {0xC3,0xFA}, {0xF3,0x7D}, {0xF3,0x7A},
    {0xC3,0xF9}, {0xF3,0x7B}, {0xF3,0x7C}, {0xF5,0x48},
    {0xF5,0x49}, {0xC4,0xC5}, {0x90,0xD2}, {0xC5,0x53},
    {0xF6,0x6E}, {0x90,0xD4}, {0xC5,0x51}, {0xC5,0x52},
    {0xF6,0x6F}, {0xC5,0xB4}, {0xC5,0xB5}, {0xF7,0x71},
    {0x9A,0x5B}, {0x95,0xFD}, {0xC6,0x45}, {0xF8,0xCF},
    {0xC6,0x47}, {0xF8,0xCE}, {0xF8,0xD0}, {0xC6,0x46},
    {0xF9,0x57}, {0xF9,0xAD}, {0x8B,0xC4}, {0xAB,0x43},
    {0x8C,0x66}, {0xB9,0x74}, {0x90,0xDE}, {0xE4,0xBE},
    {0xE8,0xB0}, {0xC0,0x51}, {0xC0,0x52}, {0x9C,0xE4},
    {0xAB,0x44}, {0x90,0xE1}, {0xBE,0x61}, {0xC3,0xFB},
    {0xAD,0xB1}, {0xC0,0x53}, {0xC5,0xE2}, {0xAD,0xB2},
    {0xD8,0x4D}, {0xDC,0xA9}, {0x9E,0x46}, {0xDC,0xAB},
    {0xDC,0xAA}, {0x96,0x51}, {0xE0,0xDD}, {0xE0,0xDA},
    {0xB9,0x75}, {0xB9,0x76}, {0xE0,0xDB}, {0xE0,0xDC},
    {0xE4,0xC0}, {0xE4,0xC5}, {0xBB,0xDE}, {0xE4,0xBF},
    {0xE4,0xC1}, {0xE4,0xC8}, {0xE4,0xC3}, {0xE4,0xC7},
    {0xE4,0xC4}, {0xE4,0xC2}, {0xE4,0xC6}, {0xBB,0xDF},
    {0xFB,0x58}, {0xE8,0xB3}, {0x90,0xE6}, {0xE8,0xB1},
    {0xBE,0x63}, {0xBE,0x62}, {0xE8,0xB2}, {0xBE,0x64},
    {0xEC,0x56}, {0xEC,0x55}, {0xC0,0x54}, {0xEC,0x54},
    {0xEE,0xFC}, {0x96,0x50}, {0xEE,0xFE}, {0xEF,0x41},
    {0xEF,0x40}, {0x90,0xE7}, {0xC1,0xF9}, {0xEE,0xFD},
    {0xF1,0xA1}, {0xC2,0xFD}, {0xF1,0x7D}, {0xF1,0xA2},
    {0xC2,0xFE}, {0xF1,0x7B}, {0xF1,0x7E}, {0xF1,0x7C},
    {0xF1,0x79}, {0xC3,0x40}, {0xF1,0x7A}, {0x90,0xE8},
    {0x9A,0x5D}, {0xF3,0xA1}, {0x9F,0x7A}, {0xF3,0xA3},
    {0xF3,0xA2}, {0x9B,0x5C}, {0xF5,0x4A}, {0x9F,0x7C},
    {0xF5,0x4B}, {0xFC,0x52}, {0x90,0xE9}, {0xF6,0x70},
    {0x90,0xEA}, {0xC5,0xB7}, {0x9A,0x5E}, {0xC5,0xB6},
    {0xF8,0x4F}, {0xF8,0x50}, {0xC6,0x48}, {0xF8,0xD1},
    {0x9F,0x76}, {0xC6,0x69}, {0xAD,0xB3}, {0xB6,0xB4},
    {0xE4,0xCA}, {0xE4,0xC9}, {0xE8,0xB5}, {0xE8,0xB4},
    {0x90,0xEB}, {0xC1,0xFA}, {0xEF,0x43}, {0xEF,0x42},
    {0xF1,0xA5}, {0xF1,0xA3}, {0xF1,0xA6}, {0xF1,0xA4},
    {0xC3,0xFC}, {0xF3,0xA4}, {0xF3,0xA5}, {0xF3,0xA6},
    {0x90,0xEC}, {0xF6,0x71}, {0xF7,0x72}, {0xF8,0xD2},
    {0x8B,0xEE}, {0xAD,0xB4}, {0x90,0xEE}, {0xEC,0x57},
    {0xEF,0x44}, {0x91,0xC6}, {0xAD,0xB5}, {0x90,0xF2},
    {0xBB,0xE0}, {0xEC,0x58}, {0xC3,0x41}, {0xF1,0xA7},
    {0xC3,0xFD}, {0xF5,0x4C}, {0xF5,0x4D}, {0xC5,0x54},
    {0xF8,0x51}, {0xAD,0xB6}, {0xB3,0xBB}, {0xB3,0xBC},
    {0xD8,0x4E}, {0xB6,0xB5}, {0xB6,0xB6}, {0xDC,0xAC},
    {0xB6,0xB7}, {0xB9,0x7A}, {0xB9,0x7C}, {0xE0,0xDF},
    {0xE0,0xE0}, {0xE0,0xDE}, {0xB9,0x77}, {0xB9,0x78},
    {0xB9,0x7B}, {0xB9,0x79}, {0xFC,0xBC}, {0x8A,0x74},
    {0xE4,0xCB}, {0xBB,0xE1}, {0xBB,0xE2}, {0xE8,0xBC},
    {0xBE,0x67}, {0xE8,0xB7}, {0xE8,0xB6}, {0x96,0x57},
    {0xE8,0xBB}, {0xBE,0x65}, {0x9C,0xEF}, {0xC0,0x5B},
    {0xE8,0xB8}, {0xE8,0xBD}, {0xE8,0xBA}, {0xE8,0xB9},
    {0xBE,0x66}, {0xC0,0x59}, {0x9F,0xDF}, {0xEC,0x5A},
    {0xC0,0x55}, {0xEC,0x5B}, {0x90,0xF7}, {0x90,0xF6},
    {0xEC,0x59}, {0xC0,0x58}, {0xC0,0x56}, {0xC0,0x5A},
    {0xC0,0x57}, {0xEF,0x45}, {0xEF,0x4A}, {0xEF,0x46},
    {0xEF,0x49}, {0xC1,0xFB}, {0x9B,0x5E}, {0xED,0xD4},
    {0xEF,0x48}, {0xEF,0x47}, {0x90,0xF8}, {0xC3,0x44},
    {0xC3,0x42}, {0xC3,0x45}, {0xC3,0x43}, {0xF1,0xA8},
    {0xF1,0xA9}, {0xF1,0xAA}, {0xC3,0x46}, {0xF3,0xAA},
    {0xC4,0x40}, {0xF3,0xA8}, {0xC4,0x41}, {0xF3,0xA7},
    {0xF3,0xA9}, {0xC3,0xFE}, {0xF5,0x51}, {0xF5,0x4E},
    {0xF5,0x4F}, {0xF5,0x50}, {0xF6,0x72}, {0xC5,0x56},
    {0x90,0xF9}, {0xC5,0x55}, {0x8C,0xC9}, {0xF7,0x74},
    {0xF7,0x73}, {0xC5,0xB8}, {0xFA,0x6A}, {0xC5,0xE3},
    {0xC6,0x49}, {0xC6,0x60}, {0xF9,0x58}, {0xF9,0xAE},
    {0xF9,0xAF}, {0x8B,0xEF}, {0xAD,0xB7}, {0xDC,0xAD},
    {0xE0,0xE1}, {0xE4,0xCC}, {0xE4,0xCD}, {0xBB,0xE3},
    {0xBB,0xE4}, {0xE8,0xBE}, {0xBE,0x68}, {0x9F,0xE0},
    {0xC1,0xFC}, {0x91,0x42}, {0xF1,0xAB}, {0x9A,0x62},
    {0xC3,0x47}, {0xF3,0xAD}, {0xC4,0x42}, {0xF3,0xAC},
    {0xF3,0xAE}, {0xF3,0xAB}, {0xF6,0x75}, {0xF5,0x52},
    {0xF5,0x53}, {0x95,0x69}, {0xC4,0xC6}, {0xF6,0x74},
    {0x91,0x44}, {0x91,0x43}, {0xF6,0x73}, {0x91,0x41},
    {0xF7,0x75}, {0xF9,0xB0}, {0x8B,0xF0}, {0xAD,0xB8},
    {0x96,0x60}, {0x8B,0xF1}, {0xAD,0xB9}, {0x99,0xF6},
    {0x91,0x49}, {0xB0,0xA7}, {0xD4,0x48}, {0xD8,0x4F},
    {0x91,0x4A}, {0xB6,0xB8}, {0xB6,0xBB}, {0xB6,0xB9},
    {0xDC,0xAE}, {0x91,0x4B}, {0xB6,0xBD}, {0xB6,0xBA},
    {0x9A,0x64}, {0xB6,0xBC}, {0xB9,0x7E}, {0x8A,0xBF},
    {0xE0,0xE2}, {0xE0,0xE3}, {0xE8,0xC0}, {0xB9,0x7D},
    {0xB9,0xA1}, {0xB9,0xA2}, {0xE4,0xCF}, {0xE4,0xCE},
    {0xBB,0xE5}, {0xBB,0xE6}, {0xE4,0xD0}, {0xE8,0xBF},
    {0xBB,0xE8}, {0xBE,0x69}, {0xBB,0xE7}, {0x9A,0x66},
    {0xC0,0x5C}, {0xE8,0xC1}, {0xBE,0x6B}, {0xBE,0x6A},
    {0xE8,0xC2}, {0xE8,0xC5}, {0xE8,0xC3}, {0xE8,0xC4},
    {0xBE,0x6C}, {0x9A,0x67}, {0xC0,0x61}, {0xC0,0x5F},
    {0x9A,0x69}, {0xC0,0x5E}, {0xEC,0x5D}, {0xC0,0x60},
    {0xEC,0x5C}, {0xEF,0x4B}, {0xEC,0x5E}, {0xC0,0x5D},
    {0xEC,0x5F}, {0xEF,0x4E}, {0xEF,0x4C}, {0xEF,0x4D},
    {0xEF,0x52}, {0xC3,0x4B}, {0xEF,0x51}, {0xEF,0x54},
    {0xEF,0x53}, {0xEF,0x50}, {0xEF,0x4F}, {0xC1,0xFD},
    {0x9A,0x6A}, {0x96,0x52}, {0x91,0x4D}, {0xF1,0xAE},
    {0x96,0x66}, {0xF1,0xAD}, {0xC3,0x4A}, {0xC3,0x48},
    {0xC3,0x49}, {0x9F,0x7B}, {0xF1,0xAC}, {0x9A,0x6B},
    {0xF3,0xB1}, {0xC4,0x43}, {0xF3,0xB0}, {0xF3,0xAF},
    {0xC4,0x44}, {0xA0,0x6C}, {0xF5,0x58}, {0xF5,0x57},
    {0x96,0x67}, {0xF5,0x55}, {0xF5,0x54}, {0xC4,0xC8},
    {0xC4,0xC7}, {0xF5,0x59}, {0xF7,0x76}, {0xC5,0xB9},
    {0xF6,0x77}, {0xC5,0x57}, {0xF6,0x76}, {0xF5,0x56},
    {0xF7,0x77}, {0xC5,0xE4}, {0x9A,0x6C}, {0xC6,0x61},
    {0xF9,0x59}, {0xF9,0xB1}, {0x9A,0x6D}, {0x8B,0xF2},
    {0xAD,0xBA}, {0xD8,0x50}, {0xEF,0x55}, {0xAD,0xBB},
    {0x96,0x6A}, {0xE4,0xD2}, {0xE4,0xD1}, {0xEC,0x60},
    {0xEF,0x57}, {0xEF,0x56}, {0xFC,0xEA}, {0xC3,0x4C},
    {0xF3,0xB2}, {0xF3,0xB3}, {0xC4,0xC9}, {0x96,0x6C},
    {0xF9,0xB2}, {0xB0,0xA8}, {0xB6,0xBF}, {0xB6,0xBE},
    {0xE0,0xE4}, {0xE0,0xE6}, {0xB9,0xA4}, {0xE0,0xE5},
    {0xB9,0xA3}, {0xB9,0xA5}, {0xE0,0xE7}, {0x91,0xC4},
    {0xE4,0xD4}, {0xE4,0xD6}, {0xE4,0xD5}, {0x96,0x77},
    {0xE4,0xD8}, {0xBB,0xE9}, {0xE4,0xD7}, {0xE4,0xD3},
    {0x99,0xF4}, {0x9A,0x6F}, {0xE4,0xD9}, {0xE8,0xCC},
    {0xE8,0xCF}, {0xE8,0xD1}, {0xE8,0xC7}, {0xE8,0xCB},
    {0xE8,0xC8}, {0xBE,0x6E}, {0xBE,0x71}, {0xBE,0x73},
    {0xE8,0xC9}, {0xE8,0xCA}, {0xBE,0x72}, {0xE8,0xCD},
    {0xE8,0xD0}, {0xE8,0xCE}, {0xBE,0x74}, {0x9F,0xAB},
    {0xBE,0x70}, {0xE8,0xC6}, {0xBE,0x6D}, {0xBE,0x6F},
    {0x8C,0xBE}, {0x8E,0xC1}, {0xC0,0x63}, {0xEC,0x66},
    {0xEC,0x64}, {0xEC,0x63}, {0x95,0x55}, {0xEC,0x69},
    {0xEC,0x68}, {0xEC,0x67}, {0xEC,0x62}, {0xC0,0x62},
    {0xEC,0x61}, {0xEC,0x65}, {0xC0,0x64}, {0xEF,0x5A},
    {0x91,0x52}, {0xEF,0x5E}, {0xEF,0x5B}, {0xEF,0x5D},
    {0xEF,0x5C}, {0xEF,0x59}, {0xEF,0x5F}, {0xEF,0x62},
    {0xEF,0x60}, {0xEF,0x61}, {0xC2,0x40}, {0xC1,0xFE},
    {0xEF,0x58}, {0xEF,0x63}, {0xF1,0xB3}, {0xF1,0xB6},
    {0xF1,0xB8}, {0xF1,0xB7}, {0xF1,0xB1}, {0xF1,0xB5},
    {0xF1,0xB0}, {0x91,0x53}, {0xF1,0xB2}, {0xC3,0x4D},
    {0xF1,0xAF}, {0x91,0x55}, {0xF1,0xB4}, {0xF3,0xC0},
    {0xF3,0xB5}, {0xC4,0x45}, {0xC4,0x46}, {0xF3,0xB4},
    {0xF3,0xB9}, {0xF3,0xBF}, {0xF3,0xB7}, {0xF3,0xBE},
    {0x95,0x5D}, {0xF3,0xBB}, {0x96,0x71}, {0xF3,0xBA},
    {0xF3,0xBD}, {0xF3,0xB8}, {0xF3,0xB6}, {0x9C,0x6D},
    {0xF3,0xBC}, {0xF5,0x60}, {0xF5,0x5E}, {0xC4,0xCA},
    {0xF5,0x5D}, {0xF5,0x63}, {0xF5,0x61}, {0x96,0x73},
    {0xC4,0xCB}, {0xF5,0x5C}, {0xF5,0x5A}, {0xF5,0x5B},
    {0xC4,0xCD}, {0xF5,0x5F}, {0xC4,0xCC}, {0xF5,0x62},
    {0xF6,0x78}, {0xF6,0x7E}, {0x91,0x54}, {0x9A,0x71},
    {0xF6,0x79}, {0xC5,0x5B}, {0xF6,0xA1}, {0xC5,0x5A},
    {0xF6,0x7D}, {0xF6,0x7C}, {0xC5,0x59}, {0xF6,0x7B},
    {0xC5,0x58}, {0xF6,0x7A}, {0xF7,0x7D}, {0xF7,0xA1},
    {0xF7,0x7E}, {0xF7,0x7B}, {0xC5,0xBB}, {0xF7,0x78},
    {0xF7,0x7C}, {0xF7,0xA3}, {0xF7,0xA2}, {0xF7,0x79},
    {0xF7,0x7A}, {0xC5,0xBA}, {0xF8,0x52}, {0xC5,0xE7},
    {0x91,0x56}, {0xF8,0x53}, {0xC5,0xE5}, {0xC5,0xE6},
    {0x96,0x6D}, {0xF8,0xD3}, {0xC6,0x4A}, {0xF9,0x76},
    {0xC6,0x6A}, {0x95,0x57}, {0xF9,0xB3}, {0xC6,0x6B},
    {0xF9,0xB4}, {0xF9,0xB5}, {0xF9,0xC3}, {0xF9,0xC2},
    {0xC6,0x7A}, {0xF9,0xCD}, {0x89,0xC6}, {0x89,0xC7},
    {0xB0,0xA9}, {0xE0,0xE9}, {0xE0,0xE8}, {0xBB,0xEA},
    {0xBB,0xEB}, {0xE4,0xDA}, {0x8A,0x6A}, {0xE8,0xD2},
    {0xEC,0x6C}, {0x8B,0x57}, {0xBE,0x75}, {0xC0,0x65},
    {0xEC,0x6A}, {0x9F,0xE1}, {0xEC,0x6D}, {0xC0,0x66},
    {0x9B,0x5F}, {0xEF,0x64}, {0xEC,0x6B}, {0xF1,0xB9},
    {0xC3,0x4E}, {0xF3,0xC1}, {0xF5,0x66}, {0xF5,0x64},
    {0xF5,0x65}, {0xF6,0xA2}, {0xC5,0x5C}, {0xF7,0xA4},
    {0xC5,0xEA}, {0xC5,0xBC}, {0xC5,0xE8}, {0xC5,0xE9},
    {0xF8,0xD4}, {0xC6,0x62}, {0xA0,0x5D}, {0xB0,0xAA},
    {0xF1,0xBA}, {0xD4,0x49}, {0x91,0x5B}, {0xB9,0xA6},
    {0x91,0x5C}, {0xE4,0xDB}, {0xBB,0xEC}, {0xE4,0xDC},
    {0xE8,0xD4}, {0xE8,0xD3}, {0xC0,0x68}, {0xBE,0x76},
    {0xBE,0x77}, {0xE8,0xD7}, {0xE8,0xD6}, {0xE8,0xD5},
    {0x91,0x5E}, {0xEC,0x6E}, {0xEC,0x71}, {0xEC,0x70},
    {0xEC,0x6F}, {0xC0,0x67}, {0xEF,0x68}, {0xEF,0x66},
    {0xEF,0x65}, {0x9F,0x5C}, {0xEF,0x67}, {0x9F,0x57},
    {0xC3,0x4F}, {0xF1,0xBC}, {0xF1,0xBD}, {0xC3,0x50},
    {0xF1,0xBB}, {0x9F,0x65}, {0xF3,0xC3}, {0xF3,0xC2},
    {0xF3,0xC5}, {0xC4,0x47}, {0xF3,0xC4}, {0x9A,0x72},
    {0xF5,0x67}, {0xF5,0x69}, {0xF5,0x68}, {0x91,0x60},
    {0xF6,0xA3}, {0xF6,0xA6}, {0xF6,0xA4}, {0xF6,0xA5},
    {0xF7,0xA5}, {0xC5,0xBD}, {0xF8,0x54}, {0xF8,0x55},
    {0xF8,0x56}, {0xC6,0x4B}, {0xC6,0x63}, {0xF9,0xB6},
    {0xB0,0xAB}, {0xBE,0x78}, {0xC0,0x69}, {0xF1,0xBE},
    {0x9F,0x5E}, {0xF7,0xA6}, {0x91,0x61}, {0xF9,0xC4},
    {0xD4,0x4A}, {0xC6,0x7B}, {0xB0,0xAC}, {0xEC,0x72},
    {0x91,0x64}, {0xF1,0xBF}, {0xF3,0xC6}, {0x9F,0x41},
    {0xF6,0xA7}, {0xF7,0xA7}, {0xB0,0xAD}, {0xE4,0xDD},
    {0xE4,0xDE}, {0x91,0x69}, {0xBB,0xED}, {0xBB,0xEE},
    {0xE8,0xD9}, {0xBE,0x7A}, {0xBE,0x79}, {0xE8,0xD8},
    {0xEF,0x69}, {0xF1,0xC0}, {0xF1,0xC2}, {0xF1,0xC1},
    {0xC3,0x53}, {0xC3,0x52}, {0xC3,0x51}, {0x91,0x68},
    {0xC5,0x5E}, {0xF6,0xA8}, {0xC5,0x5D}, {0xF7,0xA9},
    {0xF7,0xA8}, {0xC6,0x4C}, {0xF8,0xD5}, {0xB3,0xBD},
    {0xE0,0xEA}, {0xE4,0xE1}, {0xE4,0xDF}, {0xE4,0xE0},
    {0xE8,0xE2}, {0xE8,0xDD}, {0xE8,0xDA}, {0xE8,0xE1},
    {0x9A,0x74}, {0xE8,0xE3}, {0xBE,0x7C}, {0xE8,0xE0},
    {0xE8,0xDC}, {0xE8,0xDB}, {0xE8,0xDF}, {0xE8,0xDE},
    {0xBE,0x7B}, {0xEC,0x7D}, {0xEC,0x78}, {0xEC,0x76},
    {0xEC,0xA1}, {0xEC,0x77}, {0x96,0xB2}, {0xEC,0x73},
    {0x9A,0x75}, {0xEC,0x79}, {0xFD,0xA5}, {0xEC,0x74},
    {0xEF,0x72}, {0xEC,0x75}, {0xEC,0xA2}, {0x9E,0xE9},
    {0x8B,0xBA}, {0x91,0x6D}, {0xA0,0x60}, {0xEC,0x7C},
    {0xC0,0x6A}, {0xEC,0x7B}, {0xEC,0x7A}, {0xEC,0x7E},
    {0x9F,0xDE}, {0xEF,0x6A}, {0xEF,0x6D}, {0x9F,0xC3},
    {0xEF,0x6C}, {0x96,0xB5}, {0xEF,0x74}, {0xEF,0x6F},
    {0xEF,0x73}, {0xEF,0x71}, {0xEF,0x70}, {0xEF,0x6E},
    {0xEF,0x6B}, {0xC2,0x43}, {0xC2,0x42}, {0xC2,0x44},
    {0xC2,0x41}, {0xEF,0x75}, {0xA0,0x67}, {0xF1,0xC8},
    {0xF1,0xCB}, {0xF1,0xC9}, {0xF1,0xCD}, {0xF1,0xCE},
    {0xF1,0xC6}, {0xC3,0x58}, {0xF1,0xC7}, {0xF1,0xC5},
    {0xF1,0xCC}, {0xF1,0xC4}, {0xF1,0xC3}, {0xC3,0x57},
    {0xC3,0x55}, {0xC3,0x54}, {0x96,0xB3}, {0xF1,0xCA},
    {0xF3,0xCF}, {0xF3,0xD5}, {0xC4,0x4A}, {0xF3,0xD0},
    {0xF3,0xD3}, {0xF3,0xD7}, {0xC4,0x4B}, {0xF3,0xD2},
    {0x9A,0x76}, {0xF3,0xCA}, {0xF3,0xC9}, {0xF3,0xD6},
    {0xF3,0xCD}, {0xF3,0xCB}, {0xF3,0xD4}, {0xF3,0xCC},
    {0xC4,0x49}, {0xC4,0x48}, {0x95,0xD5}, {0xF3,0xC7},
    {0xF3,0xC8}, {0xF3,0xD1}, {0x9E,0xCA}, {0xF3,0xCE},
    {0x9A,0x77}, {0x9A,0x78}, {0xF5,0x6C}, {0xF5,0x6F},
    {0xC3,0x56}, {0x91,0x70}, {0x91,0x6F}, {0xF5,0x6D},
    {0xF5,0x73}, {0xF5,0x71}, {0xF5,0x6B}, {0xF5,0x76},
    {0x9F,0xA3}, {0xF5,0x6A}, {0x91,0x71}, {0xC4,0xCF},
    {0xF5,0x72}, {0x96,0xB1}, {0xF5,0x6E}, {0xC4,0xCE},
    {0xF5,0x75}, {0x9F,0x63}, {0xF5,0x74}, {0x9F,0x67},
    {0xF6,0xAB}, {0xF6,0xAA}, {0x8B,0xB9}, {0x9A,0x7A},
    {0xF6,0xB1}, {0xF6,0xAD}, {0xF6,0xB0}, {0xC5,0x60},
    {0x8B,0x56}, {0xF6,0xAE}, {0xF6,0xAF}, {0xF6,0xA9},
    {0xF6,0xAC}, {0xC5,0x5F}, {0x9A,0xDA}, {0xC5,0xBF},
    {0xF7,0xB4}, {0xF7,0xAF}, {0xF7,0xB3}, {0x96,0xB0},
    {0xF7,0xB6}, {0xF7,0xB2}, {0xF7,0xAE}, {0x9A,0x7E},
    {0xC5,0xC1}, {0xF7,0xB1}, {0xF7,0xB5}, {0xC5,0xC0},
    {0xF7,0xAC}, {0xF5,0x70}, {0xF7,0xB0}, {0xF7,0xAD},
    {0x9D,0xDE}, {0xF7,0xAA}, {0xF7,0xAB}, {0xC5,0xBE},
    {0xF8,0x5A}, {0xF8,0x5C}, {0xF8,0x5F}, {0xF8,0x5B},
    {0xF8,0x60}, {0x96,0xAD}, {0xF8,0x59}, {0xF8,0x57},
    {0x96,0xAE}, {0xC5,0xEB}, {0xF8,0x5D}, {0xC5,0xED},
    {0xC5,0xEC}, {0xF8,0x58}, {0xF8,0x5E}, {0x9E,0xA1},
    {0xF8,0xDA}, {0xC6,0x4D}, {0xF8,0xDB}, {0xF8,0xD9},
    {0xF8,0xD6}, {0xF8,0xD8}, {0xF8,0xD7}, {0xF9,0x5A},
    {0xF9,0x5C}, {0xF9,0x5B}, {0xF9,0x79}, {0x9E,0x50},
    {0xF9,0x78}, {0xF9,0x77}, {0xF9,0x7A}, {0xC6,0x73},
    {0xC6,0x74}, {0xF9,0xCA}, {0xF9,0xCE}, {0x96,0xAF},
    {0x8B,0xF4}, {0xB3,0xBE}, {0xDC,0xAF}, {0xE0,0xED},
    {0xB9,0xA7}, {0xE0,0xEB}, {0xE0,0xEC}, {0xE4,0xE2},
    {0xE4,0xE3}, {0xBB,0xF1}, {0xBB,0xEF}, {0xE4,0xE4},
    {0xBB,0xF0}, {0xE8,0xE8}, {0xE8,0xEB}, {0xE8,0xE5},
    {0xE8,0xEC}, {0xE8,0xE4}, {0xE8,0xE6}, {0xE8,0xE7},
    {0xE8,0xEA}, {0x9F,0xA4}, {0xBE,0xA1}, {0xE8,0xEF},
    {0xE8,0xEE}, {0xBE,0x7D}, {0xE8,0xE9}, {0xE8,0xED},
    {0xBE,0x7E}, {0x96,0xBD}, {0xEC,0xAC}, {0xC0,0x6F},
    {0xEC,0xA7}, {0xC0,0x6B}, {0x96,0xF4}, {0xEC,0xA4},
    {0xEC,0xAA}, {0xEC,0xAD}, {0xC0,0x70}, {0xEC,0xA9},
    {0xEC,0xA6}, {0xEC,0xAE}, {0xEC,0xA5}, {0x96,0xB8},
    {0xEC,0xAB}, {0xC0,0x6C}, {0xEC,0xA3}, {0xC0,0x6D},
    {0xC0,0x6E}, {0xEC,0xA8}, {0xEF,0xA9}, {0xEF,0x7A},
    {0xEF,0x7B}, {0xEF,0x7E}, {0xEF,0x7C}, {0xEF,0x76},
    {0xFA,0xA1}, {0xEF,0x79}, {0xEF,0xA5}, {0xEF,0x7D},
    {0x91,0xA7}, {0xC2,0x45}, {0xEF,0xA7}, {0xEF,0xA4},
    {0xC2,0x46}, {0xEF,0xA6}, {0xEF,0x77}, {0xEF,0xA2},
    {0xEF,0xA3}, {0xA0,0x5E}, {0xEF,0xA1}, {0x9A,0x7D},
    {0xF1,0xD2}, {0xF1,0xD4}, {0xF1,0xD7}, {0x89,0x48},
    {0xF1,0xD1}, {0x9E,0xB1}, {0xC3,0x59}, {0xF1,0xD9},
    {0xF1,0xD0}, {0xF1,0xDA}, {0xF1,0xD6}, {0xF1,0xD8},
    {0xF1,0xDC}, {0xF1,0xD5}, {0xF1,0xDD}, {0xF1,0xD3},
    {0xF1,0xCF}, {0xC3,0x5A}, {0x9D,0xDB}, {0xF1,0xDB},
    {0xC3,0x5B}, {0xC4,0x4D}, {0xEF,0x78}, {0xF3,0xF1},
    {0xF3,0xE8}, {0xC4,0x4F}, {0xF3,0xE4}, {0xC4,0x50},
    {0x95,0xBF}, {0x8A,0x73}, {0xF3,0xED}, {0xF3,0xE7},
    {0xF3,0xDD}, {0xC4,0x4E}, {0xF3,0xEA}, {0xF3,0xE5},
    {0xF3,0xE6}, {0xF3,0xD8}, {0xF3,0xDF}, {0xF3,0xEE},
    {0xF3,0xEB}, {0x9E,0xFE}, {0xF3,0xE3}, {0x91,0x7A},
    {0xF3,0xEF}, {0xF3,0xDE}, {0xF3,0xD9}, {0xF3,0xEC},
    {0x91,0x7B}, {0xF3,0xDB}, {0xF3,0xE9}, {0xF3,0xE0},
    {0xF3,0xF0}, {0xF3,0xDC}, {0xC4,0x4C}, {0xF3,0xDA},
    {0xF3,0xE1}, {0xF3,0xE2}, {0xF5,0x7D}, {0xF5,0x7B},
    {0x9A,0xA3}, {0xF5,0xA2}, {0xF5,0xAE}, {0xF5,0xA5},
    {0xF5,0x7C}, {0xF5,0x78}, {0xF5,0xA7}, {0xF5,0x7E},
    {0xF5,0xA3}, {0xF5,0x7A}, {0xF5,0xAA}, {0xF5,0x77},
    {0xF5,0xA1}, {0xF5,0xA6}, {0xF5,0xA8}, {0xF5,0xAB},
    {0xF5,0x79}, {0x96,0xC2}, {0xF5,0xAF}, {0xF5,0xB0},
    {0xF5,0xA9}, {0xF5,0xAD}, {0xF5,0xA4}, {0x9F,0x77},
    {0xF6,0xC1}, {0xF6,0xC4}, {0xC5,0x61}, {0xF6,0xC3},
    {0xF6,0xC8}, {0xF6,0xC6}, {0xC5,0x62}, {0xF6,0xBD},
    {0xF6,0xB3}, {0xF6,0xB2}, {0xC5,0x64}, {0xF6,0xBF},
    {0xF6,0xC0}, {0xF6,0xBC}, {0xF6,0xB4}, {0x9A,0xA4},
    {0xF6,0xB9}, {0xF5,0xAC}, {0x9A,0xA5}, {0xF6,0xB5},
    {0xC5,0x63}, {0xF6,0xBB}, {0x91,0xA1}, {0xF6,0xBA},
    {0xF6,0xB6}, {0xF6,0xC2}, {0x89,0xB8}, {0xF6,0xB7},
    {0xF7,0xBB}, {0xF6,0xC5}, {0xF6,0xC7}, {0xF6,0xBE},
    {0xF6,0xB8}, {0xF7,0xBC}, {0xF7,0xBE}, {0xF7,0xB8},
    {0xC5,0xC2}, {0x91,0x73}, {0xF7,0xC5}, {0xF7,0xC3},
    {0xC5,0xC3}, {0xF7,0xC2}, {0xF7,0xC1}, {0xF7,0xBA},
    {0xF7,0xB7}, {0xF7,0xBD}, {0xF7,0xC6}, {0xF7,0xB9},
    {0xF7,0xBF}, {0xF8,0x69}, {0xF8,0x6E}, {0xF8,0x64},
    {0xF8,0x67}, {0xC5,0xEE}, {0xF8,0x6B}, {0xF8,0x72},
    {0xF7,0xC0}, {0xF8,0x65}, {0xF8,0x6F}, {0xF8,0x73},
    {0xF8,0x6A}, {0xF8,0x63}, {0xF8,0x6D}, {0xF8,0x6C},
    {0xF8,0x71}, {0xF8,0x70}, {0xF7,0xC4}, {0xF8,0x68},
    {0xF8,0x62}, {0xF8,0x66}, {0xC6,0x4E}, {0xC6,0x4F},
    {0xF8,0x61}, {0x9A,0xA6}, {0xF8,0xE6}, {0xF8,0xDD},
    {0xF8,0xE5}, {0xF8,0xE2}, {0xF8,0xE3}, {0xF8,0xDC},
    {0xF8,0xDF}, {0xF8,0xE7}, {0xF8,0xE1}, {0xF8,0xE0},
    {0xF8,0xDE}, {0xF8,0xE4}, {0x89,0xBD}, {0xF9,0x5D},
    {0x89,0xB9}, {0xF9,0x5E}, {0x91,0x7D}, {0xF9,0x60},
    {0xF9,0x5F}, {0xF9,0x62}, {0xF9,0x61}, {0xF9,0x7C},
    {0xF9,0x7B}, {0xF9,0xB7}, {0xF9,0xB8}, {0x96,0xBB},
    {0xF9,0xC5}, {0xC6,0x78}, {0xC6,0x7C}, {0x9F,0xF2},
    {0xF9,0xCF}, {0xC6,0x7D}, {0x8B,0xF5}, {0xB3,0xBF},
    {0xC4,0xD0}, {0xF6,0xC9}, {0x9A,0xA9}, {0xC6,0x50},
    {0xC6,0x51}, {0xB3,0xC0}, {0xE0,0xEE}, {0x9F,0x54},
    {0xB9,0xA8}, {0xE8,0xF0}, {0x9F,0xE3}, {0x9E,0xED},
    {0xEC,0xB0}, {0xEC,0xB1}, {0xEC,0xAF}, {0xEF,0xAB},
    {0xEF,0xAA}, {0xC2,0x47}, {0xF1,0xDF}, {0xEF,0xAC},
    {0xF1,0xDE}, {0x91,0xAA}, {0xF3,0xF3}, {0xC4,0x51},
    {0xC4,0x53}, {0xF3,0xF2}, {0x91,0xAB}, {0xA0,0x70},
    {0xC4,0x52}, {0x9F,0x6D}, {0xF5,0xB1}, {0xF5,0xB3},
    {0xF5,0xB2}, {0xF6,0xCA}, {0xC5,0x65}, {0x91,0xAC},
    {0xC5,0xEF}, {0xF8,0xE8}, {0xF9,0x63}, {0x91,0xAD},
    {0xF9,0xD2}, {0xB3,0xC1}, {0xA0,0xFD}, {0xE4,0xE5},
    {0x9F,0xE2}, {0xBE,0xA2}, {0x91,0xAF}, {0x9E,0x41},
    {0x9A,0xAA}, {0xEC,0xB3}, {0xEC,0xB2}, {0x91,0xB0},
    {0xEF,0xAD}, {0x9A,0xAB}, {0xC4,0x54}, {0xC4,0xD1},
    {0xF7,0xC7}, {0xF9,0xCB}, {0xB3,0xC2}, {0xBB,0xF2},
    {0x9A,0xAC}, {0xBE,0xA3}, {0x9A,0x4A}, {0xF3,0xF4},
    {0x91,0xB2}, {0xF8,0x74}, {0xB6,0xC0}, {0x8B,0xF6},
    {0x9A,0xAD}, {0x89,0xB6}, {0xEF,0xAE}, {0xC6,0x64},
    {0xB6,0xC1}, {0xBE,0xA4}, {0xC2,0x48}, {0xF8,0x75},
    {0xB6,0xC2}, {0xE8,0xF1}, {0xC0,0x72}, {0xEC,0xB4},
    {0xEC,0xB5}, {0xC0,0x71}, {0xEF,0xAF}, {0xC2,0x4C},
    {0xC2,0x4A}, {0xC2,0x4B}, {0xC2,0x49}, {0xF1,0xE0},
    {0xC3,0x5C}, {0x9A,0xAF}, {0xF5,0xB5}, {0xF5,0xB4},
    {0xF5,0xB7}, {0xF5,0xB6}, {0xC4,0xD2}, {0xF6,0xCB},
    {0xF6,0xCD}, {0xF6,0xCC}, {0xC5,0x66}, {0xF7,0xC8},
    {0x9A,0xB0}, {0xF8,0x76}, {0xF8,0x77}, {0xC5,0xF0},
    {0xF9,0x64}, {0xF9,0x7D}, {0xC6,0x75}, {0x9A,0xB1},
    {0xDC,0xB0}, {0xEC,0xB6}, {0xEF,0xB0}, {0xF3,0xF5},
    {0xE0,0xEF}, {0x9A,0xA1}, {0xEF,0xB1}, {0xF1,0xE2},
    {0xF1,0xE1}, {0x91,0xB9}, {0xF8,0x78}, {0xC6,0x52},
    {0x91,0xBA}, {0xF9,0x65}, {0xF9,0x7E}, {0xB9,0xA9},
    {0xE8,0xF2}, {0xE8,0xF3}, {0xEC,0xB7}, {0xB9,0xAA},
    {0xC3,0x5D}, {0xF1,0xE3}, {0x91,0xBE}, {0xF6,0xCF},
    {0xC5,0x67}, {0xF6,0xD0}, {0xF6,0xCE}, {0xF8,0x79},
    {0xF8,0xE9}, {0xB9,0xAB}, {0xEF,0xB4}, {0xEF,0xB3},
    {0xEF,0xB2}, {0xF1,0xE4}, {0xA0,0x41}, {0x8B,0xB7},
    {0xF1,0xE8}, {0xF1,0xE7}, {0xF1,0xE6}, {0xF1,0xE5},
    {0xC3,0x5E}, {0xF3,0xF6}, {0xF5,0xB9}, {0xC4,0xD3},
    {0xF5,0xB8}, {0xF6,0xD1}, {0xF7,0xCB}, {0xF7,0xCA},
    {0xC5,0xC4}, {0xF7,0xC9}, {0xF8,0x7C}, {0xF8,0x7B},
    {0xF8,0x7A}, {0x91,0xC0}, {0xBB,0xF3}, {0xEC,0xB8},
    {0xC2,0x4D}, {0xF3,0xF7}, {0xF3,0xF8}, {0xF7,0xCC},
    {0xF8,0x7D}, {0x9A,0xB3}, {0x91,0xC3}, {0xF8,0xEA},
    {0xF9,0x66}, {0xF9,0xB9}, {0xF9,0xD4}, {0xBB,0xF4},
    {0xC2,0x4E}, {0xF1,0xE9}, {0xF3,0xF9}, {0xF6,0xD2},
    {0xF8,0x7E}, {0xA0,0xFC}, {0xBE,0xA6}, {0x9F,0xEE},
    {0xEF,0xB5}, {0xF1,0xEA}, {0xF3,0xFA}, {0xF3,0xFB},
    {0xF3,0xFC}, {0xF5,0xBE}, {0x9F,0x69}, {0xF5,0xBA},
    {0xC5,0x68}, {0xF5,0xBD}, {0xF5,0xBC}, {0xC4,0xD4},
    {0xF5,0xBB}, {0xC4,0xD6}, {0x91,0xC8}, {0xC4,0xD5},
    {0xF6,0xD4}, {0xF6,0xD3}, {0xC5,0x69}, {0xC5,0x6A},
    {0x91,0xC9}, {0xC5,0xC6}, {0xF7,0xCD}, {0xC5,0xC5},
    {0xF8,0xA3}, {0xF8,0xA4}, {0xF8,0xA2}, {0xF8,0xA1},
    {0xC6,0x54}, {0xF8,0xEB}, {0xF8,0xEC}, {0xF8,0xED},
    {0xC6,0x53}, {0xF9,0x67}, {0xF9,0x6A}, {0xF9,0x69},
    {0xF9,0x68}, {0xF9,0xD3}, {0x8D,0xE6}, {0xC0,0x73},
    {0x91,0xCB}, {0xC3,0x65}, {0xF5,0xBF}, {0xF6,0xD5},
    {0xC5,0xC7}, {0xF7,0xCE}, {0xF9,0xD5}, {0x89,0xC8},
    {0xC0,0x74}, {0x8D,0xAA}, {0xEF,0xB6}, {0xF7,0xCF},
    {0xF9,0xA1}, {0x9F,0xDD}, {0xFA,0x40}, {0xFA,0x41},
    {0xFA,0x42}, {0xFA,0x43}, {0xFA,0x44}, {0xFA,0x45},
    {0xFA,0x46}, {0xFA,0x47}, {0xFA,0x48}, {0xFA,0x49},
    {0xFA,0x4A}, {0xFA,0x4B}, {0xFA,0x4C}, {0xFA,0x4D},
    {0xFA,0x4E}, {0xFA,0x4F}, {0xFA,0x50}, {0xFA,0x51},
    {0xFA,0x52}, {0xFA,0x53}, {0xFA,0x54}, {0xFA,0x55},
    {0xFA,0x56}, {0xFA,0x57}, {0xFA,0x58}, {0xFA,0x59},
    {0xFA,0x5A}, {0xFA,0x5B}, {0xFA,0x5C}, {0xFA,0x5D},
    {0xFA,0x5E}, {0xAD,0xC5}, {0xFA,0x60}, {0xFA,0x61},
    {0xFA,0x62}, {0xFA,0x63}, {0xFA,0x64}, {0xFA,0x65},
    {0xB0,0xB0}, {0xFA,0x67}, {0xFA,0x68}, {0xFA,0x69},
    {0xFA,0x6A}, {0xFA,0x6B}, {0xFA,0x6C}, {0xFA,0x6D},
    {0xFA,0x6E}, {0xFA,0x6F}, {0xFA,0x70}, {0xFA,0x71},
    {0xFA,0x72}, {0xFA,0x73}, {0xFA,0x74}, {0xFA,0x75},
    {0xFA,0x76}, {0xFA,0x77}, {0xFA,0x78}, {0xFA,0x79},
    {0xFA,0x7A}, {0xFA,0x7B}, {0xFA,0x7C}, {0xFA,0x7D},
    {0xFA,0x7E}, {0xFA,0xA1}, {0xFA,0xA2}, {0xFA,0xA3},
    {0xFA,0xA4}, {0xFA,0xA5}, {0xFA,0xA6}, {0xFA,0xA7},
    {0xFA,0xA8}, {0xFA,0xA9}, {0xFA,0xAA}, {0xFA,0xAB},
    {0xFA,0xAC}, {0xFA,0xAD}, {0xFA,0xAE}, {0xFA,0xAF},
    {0xFA,0xB0}, {0xFA,0xB1}, {0xFA,0xB2}, {0xFA,0xB3},
    {0xFA,0xB4}, {0xFA,0xB5}, {0xFA,0xB6}, {0xFA,0xB7},
    {0xFA,0xB8}, {0xFA,0xB9}, {0xFA,0xBA}, {0xFA,0xBB},
    {0xFA,0xBC}, {0xA5,0x5D}, {0xFA,0xBE}, {0xFA,0xBF},
    {0xFA,0xC0}, {0xFA,0xC1}, {0xFA,0xC2}, {0xFA,0xC3},
    {0xFA,0xC4}, {0xA2,0xCD}, {0xFA,0xC6}, {0xFA,0xC7},
    {0xFA,0xC8}, {0xFA,0xC9}, {0xFA,0xCA}, {0xFA,0xCB},
    {0xFA,0xCC}, {0xFA,0xCD}, {0xFA,0xCE}, {0xFA,0xCF},
    {0xFA,0xD0}, {0xFA,0xD1}, {0xFA,0xD2}, {0xFA,0xD3},
    {0xFA,0xD4}, {0xAD,0xEB}, {0xFA,0xD6}, {0xFA,0xD7},
    {0xFA,0xD8}, {0xFA,0xD9}, {0xFA,0xDA}, {0xFA,0xDB},
    {0xFA,0xDC}, {0xFA,0xDD}, {0xFA,0xDE}, {0xFA,0xDF},
    {0xFA,0xE0}, {0xFA,0xE1}, {0xFA,0xE2}, {0xFA,0xE3},
    {0xFA,0xE4}, {0xFA,0xE5}, {0xFA,0xE6}, {0xFA,0xE7},
    {0xFA,0xE8}, {0xFA,0xE9}, {0xFA,0xEA}, {0xFA,0xEB},
    {0xFA,0xEC}, {0xFA,0xED}, {0xFA,0xEE}, {0xFA,0xEF},
    {0xFA,0xF0}, {0xFA,0xF1}, {0xFA,0xF2}, {0xFA,0xF3},
    {0xFA,0xF4}, {0xFA,0xF5}, {0xFA,0xF6}, {0xFA,0xF7},
    {0xFA,0xF8}, {0xFA,0xF9}, {0xFA,0xFA}, {0xFA,0xFB},
    {0xFA,0xFC}, {0xFA,0xFD}, {0xFA,0xFE}, {0xFB,0x40},
    {0xFB,0x41}, {0xFB,0x42}, {0xFB,0x43}, {0xFB,0x44},
    {0xFB,0x45}, {0xFB,0x46}, {0xFB,0x47}, {0x9D,0xEF},
    {0xFB,0x49}, {0xFB,0x4A}, {0xFB,0x4B}, {0xFB,0x4C},
    {0xFB,0x4D}, {0xFB,0x4E}, {0xFB,0x4F}, {0xFB,0x50},
    {0xFB,0x51}, {0xFB,0x52}, {0xFB,0x53}, {0xFB,0x54},
    {0xFB,0x55}, {0xFB,0x56}, {0xFB,0x57}, {0xFB,0x58},
    {0xFB,0x59}, {0xFB,0x5A}, {0xFB,0x5B}, {0xFB,0x5C},
    {0xFB,0x5D}, {0xFB,0x5E}, {0xFB,0x5F}, {0xFB,0x60},
    {0xFB,0x61}, {0xFB,0x62}, {0xFB,0x63}, {0xFB,0x64},
    {0xFB,0x65}, {0xFB,0x66}, {0xFB,0x67}, {0xFB,0x68},
    {0xFB,0x69}, {0xFB,0x6A}, {0xFB,0x6B}, {0xFB,0x6C},
    {0xFB,0x6D}, {0xFB,0x6E}, {0xFB,0x6F}, {0xFB,0x70},
    {0xFB,0x71}, {0xFB,0x72}, {0xFB,0x73}, {0xFB,0x74},
    {0xFB,0x75}, {0xFB,0x76}, {0xFB,0x77}, {0xFB,0x78},
    {0xFB,0x79}, {0xFB,0x7A}, {0xFB,0x7B}, {0xFB,0x7C},
    {0xFB,0x7D}, {0xFB,0x7E}, {0xFB,0xA1}, {0xFB,0xA2},
    {0xFB,0xA3}, {0xFB,0xA4}, {0xFB,0xA5}, {0xFB,0xA6},
    {0xFB,0xA7}, {0xFB,0xA8}, {0xFB,0xA9}, {0xFB,0xAA},
    {0xFB,0xAB}, {0xFB,0xAC}, {0xFB,0xAD}, {0xFB,0xAE},
    {0xFB,0xAF}, {0xFB,0xB0}, {0xFB,0xB1}, {0xFB,0xB2},
    {0xFB,0xB3}, {0xFB,0xB4}, {0xFB,0xB5}, {0xFB,0xB6},
    {0xFB,0xB7}, {0xB4,0x40}, {0xFB,0xB9}, {0xFB,0xBA},
    {0xFB,0xBB}, {0xFB,0xBC}, {0xFB,0xBD}, {0xFB,0xBE},
    {0xFB,0xBF}, {0xFB,0xC0}, {0xFB,0xC1}, {0xFB,0xC2},
    {0xFB,0xC3}, {0xFB,0xC4}, {0xFB,0xC5}, {0xFB,0xC6},
    {0xFB,0xC7}, {0xFB,0xC8}, {0xFB,0xC9}, {0xFB,0xCA},
    {0xFB,0xCB}, {0xFB,0xCC}, {0xFB,0xCD}, {0xFB,0xCE},
    {0xFB,0xCF}, {0xFB,0xD0}, {0xFB,0xD1}, {0xFB,0xD2},
    {0xFB,0xD3}, {0xFB,0xD4}, {0xFB,0xD5}, {0xFB,0xD6},
    {0xFB,0xD7}, {0xFB,0xD8}, {0xFB,0xD9}, {0xFB,0xDA},
    {0xFB,0xDB}, {0xFB,0xDC}, {0xFB,0xDD}, {0xFB,0xDE},
    {0xFB,0xDF}, {0xFB,0xE0}, {0xFB,0xE1}, {0xFB,0xE2},
    {0xFB,0xE3}, {0xFB,0xE4}, {0xFB,0xE5}, {0xFB,0xE6},
    {0xFB,0xE7}, {0xFB,0xE8}, {0xFB,0xE9}, {0xFB,0xEA},
    {0xFB,0xEB}, {0xFB,0xEC}, {0xFB,0xED}, {0xFB,0xEE},
    {0xFB,0xEF}, {0xFB,0xF0}, {0xFB,0xF1}, {0xFB,0xF2},
    {0xC9,0xDB}, {0xFB,0xF4}, {0xFB,0xF5}, {0xFB,0xF6},
    {0xFB,0xF7}, {0xFB,0xF8}, {0x9D,0xFB}, {0xFB,0xFA},
    {0xFB,0xFB}, {0xFB,0xFC}, {0xFB,0xFD}, {0xFB,0xFE},
    {0xFC,0x40}, {0xFC,0x41}, {0xFC,0x42}, {0xFC,0x43},
    {0xFC,0x44}, {0xFC,0x45}, {0xFC,0x46}, {0xFC,0x47},
    {0xFC,0x48}, {0xFC,0x49}, {0xFC,0x4A}, {0xFC,0x4B},
    {0xFC,0x4C}, {0xFC,0x4D}, {0xFC,0x4E}, {0xD8,0xF4},
    {0xFC,0x50}, {0xFC,0x51}, {0xFC,0x52}, {0xFC,0x53},
    {0xFC,0x54}, {0xFC,0x55}, {0xFC,0x56}, {0xFC,0x57},
    {0xFC,0x58}, {0xFC,0x59}, {0xFC,0x5A}, {0xFC,0x5B},
    {0xFC,0x5C}, {0xFC,0x5D}, {0xFC,0x5E}, {0xFC,0x5F},
    {0xFC,0x60}, {0xFC,0x61}, {0xFC,0x62}, {0xFC,0x63},
    {0xFC,0x64}, {0xFC,0x65}, {0xFC,0x66}, {0xFC,0x67},
    {0xFC,0x68}, {0xFC,0x69}, {0xFC,0x6A}, {0xFC,0x6B},
    {0xA0,0xDC}, {0xFC,0x6D}, {0xFC,0x6E}, {0xFC,0x6F},
    {0xFC,0x70}, {0xFC,0x71}, {0xFC,0x72}, {0xFC,0x73},
    {0xFC,0x74}, {0xFC,0x75}, {0xFC,0x76}, {0xFC,0x77},
    {0xFC,0x78}, {0xFC,0x79}, {0xFC,0x7A}, {0xFC,0x7B},
    {0xFC,0x7C}, {0xFC,0x7D}, {0xFC,0x7E}, {0xFC,0xA1},
    {0xFC,0xA2}, {0xFC,0xA3}, {0xFC,0xA4}, {0xFC,0xA5},
    {0xFC,0xA6}, {0xFC,0xA7}, {0xFC,0xA8}, {0xFC,0xA9},
    {0xFC,0xAA}, {0xFC,0xAB}, {0xFC,0xAC}, {0xFC,0xAD},
    {0xFC,0xAE}, {0xFC,0xAF}, {0xFC,0xB0}, {0xFC,0xB1},
    {0xFC,0xB2}, {0xFC,0xB3}, {0xFC,0xB4}, {0xFC,0xB5},
    {0xFC,0xB6}, {0xFC,0xB7}, {0xFC,0xB8}, {0xBC,0xB5},
    {0xFC,0xBA}, {0xFC,0xBB}, {0xFC,0xBC}, {0xFC,0xBD},
    {0xFC,0xBE}, {0xFC,0xBF}, {0xFC,0xC0}, {0xFC,0xC1},
    {0xFC,0xC2}, {0xFC,0xC3}, {0xFC,0xC4}, {0xFC,0xC5},
    {0xFC,0xC6}, {0xFC,0xC7}, {0xFC,0xC8}, {0xFC,0xC9},
    {0xFC,0xCA}, {0xFC,0xCB}, {0xFC,0xCC}, {0xFC,0xCD},
    {0xFC,0xCE}, {0xFC,0xCF}, {0xFC,0xD0}, {0xFC,0xD1},
    {0xFC,0xD2}, {0xFC,0xD3}, {0xFC,0xD4}, {0xFC,0xD5},
    {0xFC,0xD6}, {0xFC,0xD7}, {0xFC,0xD8}, {0xFC,0xD9},
    {0xFC,0xDA}, {0xFC,0xDB}, {0xFC,0xDC}, {0xFC,0xDD},
    {0xFC,0xDE}, {0xFC,0xDF}, {0xFC,0xE0}, {0xFC,0xE1},
    {0xB4,0xB8}, {0xFC,0xE3}, {0xFC,0xE4}, {0xFC,0xE5},
    {0xFC,0xE6}, {0xFC,0xE7}, {0xFC,0xE8}, {0xFC,0xE9},
    {0xFC,0xEA}, {0xFC,0xEB}, {0xFC,0xEC}, {0xFC,0xED},
    {0xFC,0xEE}, {0xFC,0xEF}, {0xFC,0xF0}, {0xA7,0xFB},
    {0xFC,0xF2}, {0xFC,0xF3}, {0xFC,0xF4}, {0xFC,0xF5},
    {0xFC,0xF6}, {0xFC,0xF7}, {0xFC,0xF8}, {0xFC,0xF9},
    {0xFC,0xFA}, {0xFC,0xFB}, {0xFC,0xFC}, {0xFC,0xFD},
    {0xFC,0xFE}, {0xFD,0x40}, {0xFD,0x41}, {0xFD,0x42},
    {0xFD,0x43}, {0xFD,0x44}, {0xFD,0x45}, {0xFD,0x46},
    {0xFD,0x47}, {0xFD,0x48}, {0xFD,0x49}, {0xFD,0x4A},
    {0xFD,0x4B}, {0xFD,0x4C}, {0xFD,0x4D}, {0xFD,0x4E},
    {0xFD,0x4F}, {0xFD,0x50}, {0xFD,0x51}, {0xFD,0x52},
    {0xFD,0x53}, {0xFD,0x54}, {0xFD,0x55}, {0xFD,0x56},
    {0xFD,0x57}, {0xFD,0x58}, {0xFD,0x59}, {0xFD,0x5A},
    {0xFD,0x5B}, {0xFD,0x5C}, {0xFD,0x5D}, {0xFD,0x5E},
    {0xFD,0x5F}, {0xFD,0x60}, {0xFD,0x61}, {0xFD,0x62},
    {0xFD,0x63}, {0xFD,0x64}, {0xFD,0x65}, {0xFD,0x66},
    {0xFD,0x67}, {0xFD,0x68}, {0xFD,0x69}, {0xFD,0x6A},
    {0xFD,0x6B}, {0xFD,0x6C}, {0xFD,0x6D}, {0xFD,0x6E},
    {0xFD,0x6F}, {0xFD,0x70}, {0xFD,0x71}, {0xFD,0x72},
    {0xFD,0x73}, {0xFD,0x74}, {0xFD,0x75}, {0xFD,0x76},
    {0xFD,0x77}, {0xFD,0x78}, {0xFD,0x79}, {0xFD,0x7A},
    {0xFD,0x7B}, {0xFD,0x7C}, {0xFD,0x7D}, {0xFD,0x7E},
    {0xFD,0xA1}, {0xFD,0xA2}, {0xFD,0xA3}, {0xFD,0xA4},
    {0xFD,0xA5}, {0xFD,0xA6}, {0xFD,0xA7}, {0xFD,0xA8},
    {0xFD,0xA9}, {0xFD,0xAA}, {0xFD,0xAB}, {0xFD,0xAC},
    {0xFD,0xAD}, {0xFD,0xAE}, {0xFD,0xAF}, {0xFD,0xB0},
    {0xFD,0xB1}, {0xFD,0xB2}, {0xFD,0xB3}, {0xFD,0xB4},
    {0xFD,0xB5}, {0xFD,0xB6}, {0xCB,0x58}, {0xB4,0xFC},
    {0xFD,0xB9}, {0xFD,0xBA}, {0xB4,0xE4}, {0xFD,0xBC},
    {0xFD,0xBD}, {0xFD,0xBE}, {0xFD,0xBF}, {0xFD,0xC0},
    {0xFD,0xC1}, {0xFD,0xC2}, {0xFD,0xC3}, {0xFD,0xC4},
    {0xFD,0xC5}, {0xFD,0xC6}, {0xFD,0xC7}, {0xFD,0xC8},
    {0xFD,0xC9}, {0xFD,0xCA}, {0xFD,0xCB}, {0xFD,0xCC},
    {0xFD,0xCD}, {0xFD,0xCE}, {0xFD,0xCF}, {0xFD,0xD0},
    {0xFD,0xD1}, {0xFD,0xD2}, {0xFD,0xD3}, {0xFD,0xD4},
    {0xFD,0xD5}, {0xFD,0xD6}, {0xFD,0xD7}, {0xFD,0xD8},
    {0xFD,0xD9}, {0xFD,0xDA}, {0xFD,0xDB}, {0xFD,0xDC},
    {0xFD,0xDD}, {0xFD,0xDE}, {0xFD,0xDF}, {0xFD,0xE0},
    {0xFD,0xE1}, {0xFD,0xE2}, {0xFD,0xE3}, {0xFD,0xE4},
    {0xFD,0xE5}, {0xFD,0xE6}, {0xFD,0xE7}, {0xFD,0xE8},
    {0xFD,0xE9}, {0xFD,0xEA}, {0xFD,0xEB}, {0xFD,0xEC},
    {0xFD,0xED}, {0xFD,0xEE}, {0xFD,0xEF}, {0xFD,0xF0},
    {0xB5,0x4E}, {0xFD,0xF2}, {0xFD,0xF3}, {0xFD,0xF4},
    {0xFD,0xF5}, {0xFD,0xF6}, {0xFD,0xF7}, {0xFD,0xF8},
    {0xFD,0xF9}, {0xFD,0xFA}, {0xFD,0xFB}, {0xFD,0xFC},
    {0xFD,0xFD}, {0xFD,0xFE}, {0xFE,0x40}, {0xFE,0x41},
    {0xFE,0x42}, {0xFE,0x43}, {0xFE,0x44}, {0xFE,0x45},
    {0xFE,0x46}, {0xFE,0x47}, {0xFE,0x48}, {0xFE,0x49},
    {0xFE,0x4A}, {0xFE,0x4B}, {0xFE,0x4C}, {0xFE,0x4D},
    {0xFE,0x4E}, {0xFE,0x4F}, {0xFE,0x50}, {0xFE,0x51},
    {0x99,0x75}, {0xFE,0x53}, {0xFE,0x54}, {0xFE,0x55},
    {0xFE,0x56}, {0xFE,0x57}, {0xFE,0x58}, {0xFE,0x59},
    {0xFE,0x5A}, {0xFE,0x5B}, {0xFE,0x5C}, {0xFE,0x5D},
    {0xFE,0x5E}, {0xFE,0x5F}, {0xFE,0x60}, {0xFE,0x61},
    {0xFE,0x62}, {0xFE,0x63}, {0xFE,0x64}, {0xFE,0x65},
    {0xFE,0x66}, {0xFE,0x67}, {0xFE,0x68}, {0xFE,0x69},
    {0xFE,0x6A}, {0xFE,0x6B}, {0xFE,0x6C}, {0xFE,0x6D},
    {0xFE,0x6E}, {0xB7,0xEC}, {0xFE,0x70}, {0xFE,0x71},
    {0xFE,0x72}, {0xFE,0x73}, {0xFE,0x74}, {0xFE,0x75},
    {0xFE,0x76}, {0xFE,0x77}, {0xFE,0x78}, {0xFE,0x79},
    {0xFE,0x7A}, {0xFE,0x7B}, {0xFE,0x7C}, {0xFE,0x7D},
    {0xFE,0x7E}, {0xFE,0xA1}, {0xFE,0xA2}, {0xFE,0xA3},
    {0xFE,0xA4}, {0xFE,0xA5}, {0xFE,0xA6}, {0xFE,0xA7},
    {0xFE,0xA8}, {0xFE,0xA9}, {0xA2,0x60}, {0xFE,0xAB},
    {0xFE,0xAC}, {0xFE,0xAD}, {0xFE,0xAE}, {0xFE,0xAF},
    {0xFE,0xB0}, {0xFE,0xB1}, {0xFE,0xB2}, {0xFE,0xB3},
    {0xFE,0xB4}, {0xFE,0xB5}, {0xFE,0xB6}, {0xFE,0xB7},
    {0xFE,0xB8}, {0xFE,0xB9}, {0xFE,0xBA}, {0xFE,0xBB},
    {0xFE,0xBC}, {0xFE,0xBD}, {0xFE,0xBE}, {0xFE,0xBF},
    {0xFE,0xC0}, {0xFE,0xC1}, {0xFE,0xC2}, {0xFE,0xC3},
    {0xFE,0xC4}, {0xFE,0xC5}, {0xFE,0xC6}, {0xFE,0xC7},
    {0xFE,0xC8}, {0xFE,0xC9}, {0xFE,0xCA}, {0xFE,0xCB},
    {0xFE,0xCC}, {0xFE,0xCD}, {0xFE,0xCE}, {0xFE,0xCF},
    {0xFE,0xD0}, {0xFE,0xD1}, {0xFE,0xD2}, {0xFE,0xD3},
    {0xFE,0xD4}, {0xFE,0xD5}, {0xFE,0xD6}, {0xFE,0xD7},
    {0xFE,0xD8}, {0xFE,0xD9}, {0xFE,0xDA}, {0xFE,0xDB},
    {0xFE,0xDC}, {0xCF,0xF1}, {0xFE,0xDE}, {0xFE,0xDF},
    {0xFE,0xE0}, {0xFE,0xE1}, {0xFE,0xE2}, {0xFE,0xE3},
    {0xFE,0xE4}, {0xFE,0xE5}, {0xFE,0xE6}, {0xFE,0xE7},
    {0xFE,0xE8}, {0xFE,0xE9}, {0xFE,0xEA}, {0xFE,0xEB},
    {0xFE,0xEC}, {0xFE,0xED}, {0xFE,0xEE}, {0xFE,0xEF},
    {0xFE,0xF0}, {0xFE,0xF1}, {0xFE,0xF2}, {0xFE,0xF3},
    {0xFE,0xF4}, {0xFE,0xF5}, {0xFE,0xF6}, {0xFE,0xF7},
    {0xFE,0xF8}, {0xFE,0xF9}, {0xFE,0xFA}, {0xFE,0xFB},
    {0xFE,0xFC}, {0xFE,0xFD}, {0xFE,0xFE}, {0x8E,0x40},
    {0x8E,0x41}, {0x8E,0x42}, {0x8E,0x43}, {0x8E,0x44},
    {0x8E,0x45}, {0x8E,0x46}, {0x8E,0x47}, {0x8E,0x48},
    {0x8E,0x49}, {0x8E,0x4A}, {0x8E,0x4B}, {0x8E,0x4C},
    {0x8E,0x4D}, {0x8E,0x4E}, {0x8E,0x4F}, {0x8E,0x50},
    {0x8E,0x51}, {0x8E,0x52}, {0x8E,0x53}, {0x8E,0x54},
    {0x8E,0x55}, {0x8E,0x56}, {0x8E,0x57}, {0x8E,0x58},
    {0x8E,0x59}, {0x8E,0x5A}, {0x8E,0x5B}, {0x8E,0x5C},
    {0x8E,0x5D}, {0x8E,0x5E}, {0x8E,0x5F}, {0x8E,0x60},
    {0x8E,0x61}, {0x8E,0x62}, {0x8E,0x63}, {0x8E,0x64},
    {0x8E,0x65}, {0x8E,0x66}, {0x8E,0x67}, {0x8E,0x68},
    {0xBA,0xE6}, {0x8E,0x6A}, {0x8E,0x6B}, {0x8E,0x6C},
    {0x8E,0x6D}, {0x8E,0x6E}, {0xED,0xCA}, {0x8E,0x70},
    {0x8E,0x71}, {0x8E,0x72}, {0x8E,0x73}, {0x8E,0x74},
    {0x8E,0x75}, {0x8E,0x76}, {0x8E,0x77}, {0x8E,0x78},
    {0x8E,0x79}, {0x8E,0x7A}, {0x8E,0x7B}, {0x8E,0x7C},
    {0x8E,0x7D}, {0xA2,0x61}, {0x8E,0xA1}, {0x8E,0xA2},
    {0x8E,0xA3}, {0x8E,0xA4}, {0x8E,0xA5}, {0x8E,0xA6},
    {0x8E,0xA7}, {0x8E,0xA8}, {0x8E,0xA9}, {0x8E,0xAA},
    {0xBA,0xFC}, {0x8E,0xAC}, {0x8E,0xAD}, {0x8E,0xAE},
    {0x8E,0xAF}, {0x8E,0xB0}, {0x8E,0xB1}, {0x8E,0xB2},
    {0x8E,0xB3}, {0xBF,0xA6}, {0x8E,0xB5}, {0x8E,0xB6},
    {0x8E,0xB7}, {0x8E,0xB8}, {0x8E,0xB9}, {0x8E,0xBA},
    {0x8E,0xBB}, {0x8E,0xBC}, {0x8E,0xBD}, {0x8E,0xBE},
    {0x8E,0xBF}, {0x8E,0xC0}, {0x8E,0xC1}, {0x8E,0xC2},
    {0x8E,0xC3}, {0x8E,0xC4}, {0x8E,0xC5}, {0x8E,0xC6},
    {0x8E,0xC7}, {0x8E,0xC8}, {0x8E,0xC9}, {0x8E,0xCA},
    {0x8E,0xCB}, {0x8E,0xCC}, {0xAA,0xCC}, {0x8E,0xCE},
    {0x8E,0xCF}, {0xBF,0xAE}, {0x8E,0xD1}, {0x8E,0xD2},
    {0x8E,0xD3}, {0x8E,0xD4}, {0x8E,0xD5}, {0x8E,0xD6},
    {0x8E,0xD7}, {0x8E,0xD8}, {0x8E,0xD9}, {0x8E,0xDA},
    {0x8E,0xDB}, {0x8E,0xDC}, {0x8E,0xDD}, {0x8E,0xDE},
    {0x8E,0xDF}, {0x8E,0xE0}, {0x8E,0xE1}, {0x8E,0xE2},
    {0x8E,0xE3}, {0x8E,0xE4}, {0x8E,0xE5}, {0x8E,0xE6},
    {0x8E,0xE7}, {0x8E,0xE8}, {0x8E,0xE9}, {0x8E,0xEA},
    {0x8E,0xEB}, {0x8E,0xEC}, {0x8E,0xED}, {0x8E,0xEE},
    {0x8E,0xEF}, {0x8E,0xF0}, {0x8E,0xF1}, {0x8E,0xF2},
    {0x8E,0xF3}, {0x8E,0xF4}, {0x8E,0xF5}, {0x8E,0xF6},
    {0x8E,0xF7}, {0x8E,0xF8}, {0x8E,0xF9}, {0x8E,0xFA},
    {0x8E,0xFB}, {0x8E,0xFC}, {0x8E,0xFD}, {0x8E,0xFE},
    {0x8F,0x40}, {0x8F,0x41}, {0x8F,0x42}, {0x8F,0x43},
    {0x8F,0x44}, {0x8F,0x45}, {0x8F,0x46}, {0x8F,0x47},
    {0x8F,0x48}, {0x8F,0x49}, {0x8F,0x4A}, {0x8F,0x4B},
    {0x8F,0x4C}, {0x8F,0x4D}, {0x8F,0x4E}, {0x8F,0x4F},
    {0x8F,0x50}, {0x8F,0x51}, {0x8F,0x52}, {0x8F,0x53},
    {0x8F,0x54}, {0x8F,0x55}, {0x8F,0x56}, {0xB5,0xD7},
    {0x8F,0x58}, {0x8F,0x59}, {0x8F,0x5A}, {0x8F,0x5B},
    {0x8F,0x5C}, {0x8F,0x5D}, {0x8F,0x5E}, {0x8F,0x5F},
    {0x8F,0x60}, {0x8F,0x61}, {0x8F,0x62}, {0x8F,0x63},
    {0x8F,0x64}, {0x8F,0x65}, {0x8F,0x66}, {0x8F,0x67},
    {0x8F,0x68}, {0xE3,0xC8}, {0x8F,0x6A}, {0x8F,0x6B},
    {0x8F,0x6C}, {0x8F,0x6D}, {0xDB,0x79}, {0x8F,0x6F},
    {0x8F,0x70}, {0x8F,0x71}, {0x8F,0x72}, {0x8F,0x73},
    {0x8F,0x74}, {0x8F,0x75}, {0x8F,0x76}, {0x8F,0x77},
    {0x8F,0x78}, {0x8F,0x79}, {0x8F,0x7A}, {0x8F,0x7B},
    {0x8F,0x7C}, {0x8F,0x7D}, {0x8F,0x7E}, {0x8F,0xA1},
    {0x8F,0xA2}, {0x8F,0xA3}, {0x8F,0xA4}, {0x8F,0xA5},
    {0x8F,0xA6}, {0x8F,0xA7}, {0x8F,0xA8}, {0x8F,0xA9},
    {0x8F,0xAA}, {0x8F,0xAB}, {0x8F,0xAC}, {0x8F,0xAD},
    {0x8F,0xAE}, {0x8F,0xAF}, {0x8F,0xB0}, {0x8F,0xB1},
    {0x8F,0xB2}, {0x8F,0xB3}, {0x8F,0xB4}, {0x8F,0xB5},
    {0x8F,0xB6}, {0x8F,0xB7}, {0x8F,0xB8}, {0x8F,0xB9},
    {0x8F,0xBA}, {0x8F,0xBB}, {0x8F,0xBC}, {0x8F,0xBD},
    {0x8F,0xBE}, {0x8F,0xBF}, {0x8F,0xC0}, {0x8F,0xC1},
    {0x8F,0xC2}, {0x8F,0xC3}, {0x8F,0xC4}, {0x8F,0xC5},
    {0x8F,0xC6}, {0x8F,0xC7}, {0x8F,0xC8}, {0x8F,0xC9},
    {0x8F,0xCA}, {0xBF,0xCC}, {0xA0,0xD4}, {0x8F,0xCD},
    {0x8F,0xCE}, {0x8F,0xCF}, {0x8F,0xD0}, {0x8F,0xD1},
    {0x8F,0xD2}, {0x8F,0xD3}, {0x8F,0xD4}, {0x8F,0xD5},
    {0x8F,0xD6}, {0x8F,0xD7}, {0x8F,0xD8}, {0x8F,0xD9},
    {0x8F,0xDA}, {0x8F,0xDB}, {0x8F,0xDC}, {0x8F,0xDD},
    {0x8F,0xDE}, {0x8F,0xDF}, {0x8F,0xE0}, {0x8F,0xE1},
    {0x8F,0xE2}, {0x8F,0xE3}, {0x8F,0xE4}, {0x8F,0xE5},
    {0x8F,0xE6}, {0x8F,0xE7}, {0x8F,0xE8}, {0x8F,0xE9},
    {0x8F,0xEA}, {0x8F,0xEB}, {0x8F,0xEC}, {0x8F,0xED},
    {0x8F,0xEE}, {0x8F,0xEF}, {0x8F,0xF0}, {0x8F,0xF1},
    {0x8F,0xF2}, {0x8F,0xF3}, {0x8F,0xF4}, {0x8F,0xF5},
    {0x8F,0xF6}, {0x8F,0xF7}, {0x8F,0xF8}, {0x8F,0xF9},
    {0x8F,0xFA}, {0x8F,0xFB}, {0x8F,0xFC}, {0x8F,0xFD},
    {0xB0,0x5F}, {0x90,0x40}, {0x90,0x41}, {0x90,0x42},
    {0x90,0x43}, {0x90,0x44}, {0x90,0x45}, {0x90,0x46},
    {0x90,0x47}, {0x90,0x48}, {0x90,0x49}, {0x90,0x4A},
    {0x90,0x4B}, {0x90,0x4C}, {0x90,0x4D}, {0x90,0x4E},
    {0x90,0x4F}, {0x90,0x50}, {0x90,0x51}, {0x90,0x52},
    {0x90,0x53}, {0x90,0x54}, {0x90,0x55}, {0x90,0x56},
    {0x90,0x57}, {0x90,0x58}, {0x90,0x59}, {0x90,0x5A},
    {0x90,0x5B}, {0x90,0x5C}, {0x90,0x5D}, {0x90,0x5E},
    {0x90,0x5F}, {0x90,0x60}, {0x90,0x61}, {0x90,0x62},
    {0x90,0x63}, {0x90,0x64}, {0x90,0x65}, {0x90,0x66},
    {0x90,0x67}, {0x90,0x68}, {0x90,0x69}, {0x90,0x6A},
    {0x90,0x6B}, {0x90,0x6C}, {0xB3,0xA3}, {0x90,0x6E},
    {0x90,0x6F}, {0x90,0x70}, {0x90,0x71}, {0x90,0x72},
    {0x90,0x73}, {0x90,0x74}, {0x90,0x75}, {0x90,0x76},
    {0x90,0x77}, {0x90,0x78}, {0x90,0x79}, {0xF9,0xD7},
    {0x90,0x7B}, {0x90,0x7C}, {0x90,0x7D}, {0x90,0x7E},
    {0x90,0xA1}, {0x90,0xA2}, {0x90,0xA3}, {0x90,0xA4},
    {0x90,0xA5}, {0x90,0xA6}, {0x90,0xA7}, {0x90,0xA8},
    {0x90,0xA9}, {0x90,0xAA}, {0x90,0xAB}, {0x90,0xAC},
    {0x90,0xAD}, {0x90,0xAE}, {0x90,0xAF}, {0x90,0xB0},
    {0x90,0xB1}, {0x90,0xB2}, {0x90,0xB3}, {0x90,0xB4},
    {0x90,0xB5}, {0x90,0xB6}, {0x90,0xB7}, {0x90,0xB8},
    {0x90,0xB9}, {0x90,0xBA}, {0x90,0xBB}, {0x90,0xBC},
    {0x90,0xBD}, {0x90,0xBE}, {0x90,0xBF}, {0x90,0xC0},
    {0x90,0xC1}, {0x90,0xC2}, {0x90,0xC3}, {0x90,0xC4},
    {0x90,0xC5}, {0x90,0xC6}, {0x90,0xC7}, {0x90,0xC8},
    {0x90,0xC9}, {0x90,0xCA}, {0x90,0xCB}, {0x90,0xCC},
    {0x90,0xCD}, {0x90,0xCE}, {0x90,0xCF}, {0x90,0xD0},
    {0x90,0xD1}, {0x90,0xD2}, {0x90,0xD3}, {0x90,0xD4},
    {0x90,0xD5}, {0x90,0xD6}, {0x90,0xD7}, {0x90,0xD8},
    {0x90,0xD9}, {0x90,0xDA}, {0x90,0xDB}, {0xC0,0x52},
    {0x90,0xDD}, {0x90,0xDE}, {0x90,0xDF}, {0x90,0xE0},
    {0x90,0xE1}, {0x90,0xE2}, {0x90,0xE3}, {0x90,0xE4},
    {0x90,0xE5}, {0x90,0xE6}, {0x90,0xE7}, {0x90,0xE8},
    {0x90,0xE9}, {0x90,0xEA}, {0x90,0xEB}, {0x90,0xEC},
    {0x90,0xED}, {0x90,0xEE}, {0x90,0xEF}, {0x90,0xF0},
    {0xC5,0x54}, {0x90,0xF2}, {0x90,0xF3}, {0x90,0xF4},
    {0x90,0xF5}, {0x90,0xF6}, {0x90,0xF7}, {0x90,0xF8},
    {0x90,0xF9}, {0x90,0xFA}, {0x90,0xFB}, {0x90,0xFC},
    {0x90,0xFD}, {0x90,0xFE}, {0x91,0x40}, {0x91,0x41},
    {0x91,0x42}, {0x91,0x43}, {0x91,0x44}, {0x91,0x45},
    {0x91,0x46}, {0x91,0x47}, {0x91,0x48}, {0x91,0x49},
    {0x91,0x4A}, {0x91,0x4B}, {0x91,0x4C}, {0x91,0x4D},
    {0x91,0x4E}, {0x91,0x4F}, {0x91,0x50}, {0x91,0x51},
    {0x91,0x52}, {0x91,0x53}, {0x91,0x54}, {0x91,0x55},
    {0x91,0x56}, {0x91,0x57}, {0x91,0x58}, {0x91,0x59},
    {0x91,0x5A}, {0x91,0x5B}, {0x91,0x5C}, {0x91,0x5D},
    {0x91,0x5E}, {0x91,0x5F}, {0x91,0x60}, {0x91,0x61},
    {0x91,0x62}, {0x91,0x63}, {0x91,0x64}, {0x91,0x65},
    {0x91,0x66}, {0x91,0x67}, {0x91,0x68}, {0x91,0x69},
    {0x91,0x6A}, {0x91,0x6B}, {0x91,0x6C}, {0x91,0x6D},
    {0x91,0x6E}, {0x91,0x6F}, {0x91,0x70}, {0x91,0x71},
    {0x91,0x72}, {0x91,0x73}, {0x91,0x74}, {0x91,0x75},
    {0x91,0x76}, {0x91,0x77}, {0x91,0x78}, {0x91,0x79},
    {0x91,0x7A}, {0x91,0x7B}, {0x91,0x7C}, {0x91,0x7D},
    {0x91,0x7E}, {0x91,0xA1}, {0x91,0xA2}, {0x91,0xA3},
    {0x91,0xA4}, {0x91,0xA5}, {0x91,0xA6}, {0x91,0xA7},
    {0x91,0xA8}, {0x91,0xA9}, {0x91,0xAA}, {0x91,0xAB},
    {0x91,0xAC}, {0x91,0xAD}, {0x91,0xAE}, {0x91,0xAF},
    {0x91,0xB0}, {0x91,0xB1}, {0x91,0xB2}, {0x91,0xB3},
    {0x91,0xB4}, {0x91,0xB5}, {0x91,0xB6}, {0x91,0xB7},
    {0x91,0xB8}, {0x91,0xB9}, {0x91,0xBA}, {0x91,0xBB},
    {0x91,0xBC}, {0x91,0xBD}, {0x91,0xBE}, {0xF1,0xE3},
    {0x91,0xC0}, {0x91,0xC1}, {0x91,0xC2}, {0x91,0xC3},
    {0x91,0xC4}, {0x91,0xC5}, {0x91,0xC6}, {0x91,0xC7},
    {0x91,0xC8}, {0x91,0xC9}, {0x91,0xCA}, {0x91,0xCB},
    {0x91,0xCC}, {0x91,0xCD}, {0x91,0xCE}, {0x91,0xCF},
    {0x91,0xD0}, {0x91,0xD1}, {0x91,0xD2}, {0x91,0xD3},
    {0x91,0xD4}, {0x91,0xD5}, {0x91,0xD6}, {0x91,0xD7},
    {0x91,0xD8}, {0x91,0xD9}, {0x91,0xDA}, {0x91,0xDB},
    {0x91,0xDC}, {0x91,0xDD}, {0x91,0xDE}, {0x91,0xDF},
    {0x91,0xE0}, {0x91,0xE1}, {0x91,0xE2}, {0x91,0xE3},
    {0x91,0xE4}, {0x91,0xE5}, {0x91,0xE6}, {0x91,0xE7},
    {0x91,0xE8}, {0x91,0xE9}, {0x91,0xEA}, {0x91,0xEB},
    {0x91,0xEC}, {0x91,0xED}, {0x91,0xEE}, {0x91,0xEF},
    {0x91,0xF0}, {0x91,0xF1}, {0x91,0xF2}, {0x91,0xF3},
    {0x91,0xF4}, {0x91,0xF5}, {0x91,0xF6}, {0x91,0xF7},
    {0x91,0xF8}, {0x91,0xF9}, {0x91,0xFA}, {0x91,0xFB},
    {0x91,0xFC}, {0x91,0xFD}, {0x91,0xFE}, {0x92,0x40},
    {0x92,0x41}, {0x92,0x42}, {0x92,0x43}, {0x92,0x42},
    {0x92,0x45}, {0x92,0x46}, {0x92,0x47}, {0x92,0x48},
    {0x92,0x49}, {0x92,0x4A}, {0x92,0x4B}, {0x92,0x4C},
    {0x92,0x4D}, {0x92,0x4E}, {0x92,0x4F}, {0x92,0x50},
    {0x92,0x51}, {0x92,0x52}, {0x92,0x53}, {0x92,0x54},
    {0x92,0x55}, {0x92,0x56}, {0x92,0x57}, {0x92,0x58},
    {0x92,0x59}, {0x92,0x5A}, {0x92,0x5B}, {0x92,0x5C},
    {0x92,0x5D}, {0x92,0x5E}, {0x92,0x5F}, {0x92,0x60},
    {0x92,0x61}, {0x92,0x62}, {0x92,0x63}, {0x92,0x64},
    {0x92,0x65}, {0x92,0x66}, {0x92,0x67}, {0x92,0x68},
    {0x92,0x69}, {0x92,0x6A}, {0x92,0x6B}, {0x92,0x6C},
    {0x92,0x6D}, {0x92,0x6E}, {0x92,0x6F}, {0x92,0x70},
    {0x92,0x71}, {0x92,0x72}, {0x92,0x73}, {0x92,0x74},
    {0x92,0x75}, {0x92,0x76}, {0x92,0x77}, {0x92,0x78},
    {0x92,0x79}, {0x92,0x7A}, {0x92,0x7B}, {0x92,0x7C},
    {0x92,0x7D}, {0x92,0x7E}, {0x92,0xA1}, {0x92,0xA2},
    {0x92,0xA3}, {0x92,0xA4}, {0x92,0xA5}, {0x92,0xA6},
    {0x92,0xA7}, {0x92,0xA8}, {0x92,0xA9}, {0x92,0xAA},
    {0x92,0xAB}, {0x92,0xAC}, {0x92,0xAD}, {0x92,0xAE},
    {0xA2,0x59}, {0xA2,0x5A}, {0xA2,0x5C}, {0xA2,0x5B},
    {0x92,0xB3}, {0x92,0xB4}, {0x92,0xB5}, {0x92,0xB6},
    {0x92,0xB7}, {0x92,0xB8}, {0x92,0xB9}, {0x92,0xBA},
    {0x92,0xBB}, {0x92,0xBC}, {0x92,0xBD}, {0x92,0xBE},
    {0x92,0xBF}, {0x92,0xC0}, {0x92,0xC1}, {0x92,0xC2},
    {0x92,0xC3}, {0x92,0xC4}, {0x92,0xC5}, {0x92,0xC6},
    {0x92,0xC7}, {0xA0,0x5F}, {0x92,0xC9}, {0x92,0xCA},
    {0x92,0xCB}, {0x92,0xCC}, {0x92,0xCD}, {0x92,0xCE},
    {0x92,0xCF}, {0x92,0xD0}, {0xE6,0xAB}, {0x92,0xD2},
    {0x92,0xD3}, {0x92,0xD4}, {0x92,0xD5}, {0x92,0xD6},
    {0x92,0xD7}, {0x92,0xD8}, {0x92,0xD9}, {0x92,0xDA},
    {0x92,0xDB}, {0x92,0xDC}, {0x92,0xDD}, {0x92,0xDE},
    {0x92,0xDF}, {0x92,0xE0}, {0x92,0xE1}, {0x92,0xE2},
    {0x92,0xE3}, {0x92,0xE4}, {0x92,0xE5}, {0x92,0xE6},
    {0x92,0xE7}, {0x92,0xE8}, {0x92,0xE9}, {0x92,0xEA},
    {0x92,0xEB}, {0x92,0xEC}, {0x92,0xED}, {0x92,0xEE},
    {0x92,0xEF}, {0x92,0xF0}, {0x92,0xF1}, {0x92,0xF2},
    {0x92,0xF3}, {0x92,0xF4}, {0x92,0xF5}, {0x92,0xF6},
    {0x92,0xF7}, {0x92,0xF8}, {0x92,0xF9}, {0x92,0xFA},
    {0x92,0xFB}, {0x92,0xFC}, {0x92,0xFD}, {0x92,0xFE},
    {0x93,0x40}, {0x93,0x41}, {0x93,0x42}, {0x93,0x43},
    {0x93,0x44}, {0x93,0x45}, {0x93,0x46}, {0x93,0x47},
    {0x93,0x48}, {0x93,0x49}, {0x93,0x4A}, {0x93,0x4B},
    {0x93,0x4C}, {0x93,0x4D}, {0x93,0x4E}, {0x93,0x4F},
    {0x93,0x50}, {0x93,0x51}, {0x93,0x52}, {0x93,0x53},
    {0x93,0x54}, {0x93,0x55}, {0x93,0x56}, {0x93,0x57},
    {0x93,0x58}, {0x93,0x59}, {0x93,0x5A}, {0x93,0x5B},
    {0x93,0x5C}, {0x93,0x5D}, {0x93,0x5E}, {0x93,0x5F},
    {0x93,0x60}, {0x93,0x61}, {0x93,0x62}, {0x93,0x63},
    {0x93,0x64}, {0x93,0x65}, {0x93,0x66}, {0x93,0x67},
    {0x93,0x68}, {0x93,0x69}, {0x93,0x6A}, {0x93,0x6B},
    {0x93,0x6C}, {0x93,0x6D}, {0x93,0x6E}, {0x93,0x6F},
    {0x93,0x70}, {0x93,0x71}, {0x93,0x72}, {0x93,0x73},
    {0x93,0x74}, {0x93,0x75}, {0x93,0x76}, {0x93,0x77},
    {0x93,0x78}, {0x93,0x79}, {0x93,0x7A}, {0x93,0x7B},
    {0x93,0x7C}, {0x93,0x7D}, {0x93,0x7E}, {0x93,0xA1},
    {0x93,0xA2}, {0x93,0xA3}, {0x93,0xA4}, {0x93,0xA5},
    {0x93,0xA6}, {0x93,0xA7}, {0x93,0xA8}, {0x93,0xA9},
    {0x93,0xAA}, {0x93,0xAB}, {0x93,0xAC}, {0x93,0xAD},
    {0x93,0xAE}, {0x93,0xAF}, {0x93,0xB0}, {0x93,0xB1},
    {0x93,0xB2}, {0x93,0xB3}, {0x93,0xB4}, {0x93,0xB5},
    {0x93,0xB6}, {0x93,0xB7}, {0x93,0xB8}, {0x93,0xB9},
    {0x93,0xBA}, {0x93,0xBB}, {0x93,0xBC}, {0x93,0xBD},
    {0x93,0xBE}, {0x93,0xBF}, {0x93,0xC0}, {0x93,0xC1},
    {0x93,0xC2}, {0x93,0xC3}, {0x93,0xC4}, {0x93,0xC5},
    {0x93,0xC6}, {0x93,0xC7}, {0x93,0xC8}, {0x93,0xC9},
    {0x93,0xCA}, {0x93,0xCB}, {0x93,0xCC}, {0x93,0xCD},
    {0x93,0xCE}, {0x93,0xCF}, {0x93,0xD0}, {0x93,0xD1},
    {0x93,0xD2}, {0x93,0xD3}, {0x93,0xD4}, {0x93,0xD5},
    {0x93,0xD6}, {0x93,0xD7}, {0x93,0xD8}, {0x93,0xD9},
    {0x93,0xDA}, {0x93,0xDB}, {0x93,0xDC}, {0x93,0xDD},
    {0x93,0xDE}, {0x93,0xDF}, {0x93,0xE0}, {0x93,0xE1},
    {0x93,0xE2}, {0x93,0xE3}, {0x93,0xE4}, {0x93,0xE5},
    {0x93,0xE6}, {0x93,0xE7}, {0x93,0xE8}, {0x93,0xE9},
    {0x93,0xEA}, {0x93,0xEB}, {0x93,0xEC}, {0x93,0xED},
    {0x93,0xEE}, {0x93,0xEF}, {0x93,0xF0}, {0x93,0xF1},
    {0x93,0xF2}, {0x93,0xF3}, {0x93,0xF4}, {0x93,0xF5},
    {0x93,0xF6}, {0x93,0xF7}, {0x93,0xF8}, {0x93,0xF9},
    {0x93,0xFA}, {0x93,0xFB}, {0x93,0xFC}, {0x93,0xFD},
    {0x93,0xFE}, {0x94,0x40}, {0x94,0x41}, {0x94,0x42},
    {0x94,0x43}, {0x94,0x44}, {0x94,0x45}, {0x94,0x46},
    {0xD2,0x56}, {0x94,0x48}, {0x94,0x49}, {0x94,0x4A},
    {0x94,0x4B}, {0x94,0x4C}, {0x94,0x4D}, {0x94,0x4E},
    {0x94,0x4F}, {0x94,0x50}, {0x94,0x51}, {0x94,0x52},
    {0x94,0x53}, {0x94,0x54}, {0x94,0x55}, {0x94,0x56},
    {0x94,0x57}, {0x94,0x58}, {0x94,0x59}, {0x94,0x5A},
    {0x94,0x5B}, {0x94,0x5C}, {0x94,0x5D}, {0x94,0x5E},
    {0x94,0x5F}, {0x94,0x60}, {0x94,0x61}, {0x94,0x62},
    {0x94,0x63}, {0x94,0x64}, {0x94,0x65}, {0x94,0x66},
    {0x94,0x67}, {0x94,0x68}, {0x94,0x69}, {0x94,0x6A},
    {0x94,0x6B}, {0x94,0x6C}, {0x94,0x6D}, {0x94,0x6E},
    {0x94,0x6F}, {0x94,0x70}, {0x94,0x71}, {0x94,0x72},
    {0x94,0x73}, {0x94,0x74}, {0x94,0x75}, {0x94,0x76},
    {0x94,0x77}, {0x94,0x78}, {0x94,0x79}, {0x94,0x7A},
    {0x94,0x7B}, {0x94,0x7C}, {0x94,0x7D}, {0x94,0x7E},
    {0x94,0xA1}, {0x94,0xA2}, {0x94,0xA3}, {0x94,0xA4},
    {0x94,0xA5}, {0x94,0xA6}, {0x94,0xA7}, {0x94,0xA8},
    {0x94,0xA9}, {0x94,0xAA}, {0x94,0xAB}, {0x94,0xAC},
    {0x94,0xAD}, {0x94,0xAE}, {0x94,0xAF}, {0x94,0xB0},
    {0x94,0xB1}, {0x94,0xB2}, {0x94,0xB3}, {0x94,0xB4},
    {0x94,0xB5}, {0x94,0xB6}, {0x94,0xB7}, {0x94,0xB8},
    {0x94,0xB9}, {0x94,0xBA}, {0x94,0xBB}, {0x94,0xBC},
    {0x94,0xBD}, {0x94,0xBE}, {0x94,0xBF}, {0x94,0xC0},
    {0x94,0xC1}, {0x94,0xC2}, {0x94,0xC3}, {0x94,0xC4},
    {0x94,0xC5}, {0x94,0xC6}, {0x94,0xC7}, {0x94,0xC8},
    {0x94,0xC9}, {0xE6,0xD0}, {0x94,0xCB}, {0x94,0xCC},
    {0x94,0xCD}, {0x94,0xCE}, {0x94,0xCF}, {0x94,0xD0},
    {0x94,0xD1}, {0x94,0xD2}, {0x94,0xD3}, {0x94,0xD4},
    {0x94,0xD5}, {0x94,0xD6}, {0x94,0xD7}, {0x94,0xD8},
    {0x94,0xD9}, {0x94,0xDA}, {0x94,0xDB}, {0x94,0xDC},
    {0x94,0xDD}, {0x94,0xDE}, {0x94,0xDF}, {0x94,0xE0},
    {0x94,0xE1}, {0x94,0xE2}, {0x94,0xE3}, {0x94,0xE4},
    {0x94,0xE5}, {0x94,0xE6}, {0x94,0xE7}, {0x94,0xE8},
    {0x94,0xE9}, {0x94,0xEA}, {0x94,0xEB}, {0x94,0xEC},
    {0x94,0xED}, {0x94,0xEE}, {0x94,0xEF}, {0x94,0xF0},
    {0x94,0xF1}, {0x94,0xF2}, {0x94,0xF3}, {0x94,0xF4},
    {0x94,0xF5}, {0x94,0xF6}, {0x94,0xF7}, {0x94,0xF8},
    {0x94,0xF9}, {0x94,0xFA}, {0x94,0xFB}, {0x94,0xFC},
    {0x94,0xFD}, {0x94,0xFE}, {0x95,0x40}, {0x95,0x41},
    {0x95,0x42}, {0x95,0x43}, {0x95,0x44}, {0x95,0x45},
    {0x95,0x46}, {0x95,0x47}, {0x95,0x48}, {0x95,0x49},
    {0x95,0x4A}, {0x95,0x4B}, {0x95,0x4C}, {0x95,0x4D},
    {0x95,0x4E}, {0x95,0x4F}, {0x95,0x50}, {0x95,0x51},
    {0x95,0x52}, {0x95,0x53}, {0x95,0x54}, {0x95,0x55},
    {0x95,0x56}, {0x95,0x57}, {0x95,0x58}, {0x95,0x59},
    {0x95,0x5A}, {0x95,0x5B}, {0x95,0x5C}, {0x95,0x5D},
    {0x95,0x5E}, {0x95,0x5F}, {0x95,0x60}, {0x95,0x61},
    {0x95,0x62}, {0x95,0x63}, {0x95,0x64}, {0x95,0x65},
    {0x95,0x66}, {0x95,0x67}, {0x95,0x68}, {0x95,0x69},
    {0x95,0x6A}, {0x95,0x6B}, {0x95,0x6C}, {0x95,0x6D},
    {0x95,0x6E}, {0x95,0x6F}, {0x95,0x70}, {0x95,0x71},
    {0x95,0x72}, {0x95,0x73}, {0x95,0x74}, {0x95,0x75},
    {0x95,0x76}, {0x95,0x77}, {0x95,0x78}, {0x95,0x79},
    {0x95,0x7A}, {0x95,0x7B}, {0x95,0x7C}, {0x95,0x7D},
    {0x95,0x7E}, {0x95,0xA1}, {0x95,0xA2}, {0x95,0xA3},
    {0x95,0xA4}, {0x95,0xA5}, {0x95,0xA6}, {0x95,0xA7},
    {0x95,0xA8}, {0x95,0xA9}, {0x95,0xAA}, {0x95,0xAB},
    {0x95,0xAC}, {0x95,0xAD}, {0x95,0xAE}, {0x95,0xAF},
    {0x95,0xB0}, {0x95,0xB1}, {0x95,0xB2}, {0x95,0xB3},
    {0x95,0xB4}, {0x95,0xB5}, {0x95,0xB6}, {0x95,0xB7},
    {0x95,0xB8}, {0x95,0xB9}, {0x95,0xBA}, {0x95,0xBB},
    {0x95,0xBC}, {0x95,0xBD}, {0x95,0xBE}, {0x95,0xBF},
    {0x95,0xC0}, {0x95,0xC1}, {0x95,0xC2}, {0x95,0xC3},
    {0x95,0xC4}, {0x95,0xC5}, {0x95,0xC6}, {0x95,0xC7},
    {0x95,0xC8}, {0x95,0xC9}, {0x95,0xCA}, {0x95,0xCB},
    {0x95,0xCC}, {0x95,0xCD}, {0x95,0xCE}, {0x95,0xCF},
    {0x95,0xD0}, {0x95,0xD1}, {0x95,0xD2}, {0x95,0xD3},
    {0x95,0xD4}, {0x95,0xD5}, {0x95,0xD6}, {0x95,0xD7},
    {0x95,0xD8}, {0xCA,0x52}, {0x95,0xDA}, {0x95,0xDB},
    {0x95,0xDC}, {0x95,0xDD}, {0x95,0xDE}, {0x95,0xDF},
    {0x95,0xE0}, {0x95,0xE1}, {0x95,0xE2}, {0x95,0xE3},
    {0x95,0xE4}, {0x95,0xE5}, {0x95,0xE6}, {0x95,0xE7},
    {0x95,0xE8}, {0x95,0xE9}, {0x95,0xEA}, {0x95,0xEB},
    {0x95,0xEC}, {0x95,0xED}, {0x95,0xEE}, {0x95,0xEF},
    {0x95,0xF0}, {0x95,0xF1}, {0x95,0xF2}, {0x95,0xF3},
    {0x95,0xF4}, {0x95,0xF5}, {0x95,0xF6}, {0x95,0xF7},
    {0x95,0xF8}, {0x95,0xF9}, {0x95,0xFA}, {0x95,0xFB},
    {0x95,0xFC}, {0x95,0xFD}, {0x95,0xFE}, {0x96,0x40},
    {0x96,0x41}, {0x96,0x42}, {0x96,0x43}, {0x9C,0xE4},
    {0x96,0x45}, {0x96,0x46}, {0x96,0x47}, {0x96,0x48},
    {0x96,0x49}, {0x96,0x4A}, {0x96,0x4B}, {0x96,0x4C},
    {0x96,0x4D}, {0x96,0x4E}, {0x96,0x4F}, {0x96,0x50},
    {0x96,0x51}, {0x96,0x52}, {0x96,0x53}, {0x96,0x54},
    {0x96,0x55}, {0x96,0x56}, {0x96,0x57}, {0x96,0x58},
    {0x96,0x59}, {0x96,0x5A}, {0x96,0x5B}, {0x96,0x5C},
    {0x96,0x5D}, {0x96,0x5E}, {0x96,0x5F}, {0x96,0x60},
    {0x96,0x61}, {0x96,0x62}, {0x96,0x63}, {0x96,0x64},
    {0x96,0x65}, {0x96,0x66}, {0x96,0x67}, {0x96,0x68},
    {0x96,0x69}, {0x96,0x6A}, {0x96,0x6B}, {0x96,0x6C},
    {0x96,0x6D}, {0x96,0x6E}, {0x96,0x6F}, {0x96,0x70},
    {0x96,0x71}, {0x96,0x72}, {0x96,0x73}, {0x96,0x74},
    {0x96,0x75}, {0x96,0x76}, {0x96,0x77}, {0x96,0x78},
    {0x96,0x79}, {0x96,0x7A}, {0x96,0x7B}, {0x96,0x7C},
    {0x96,0x7D}, {0x96,0x7E}, {0x96,0xA1}, {0x96,0xA2},
    {0x96,0xA3}, {0x96,0xA4}, {0x96,0xA5}, {0x96,0xA6},
    {0x96,0xA7}, {0x96,0xA8}, {0x96,0xA9}, {0x96,0xAA},
    {0x96,0xAB}, {0x96,0xAC}, {0x96,0xAD}, {0x96,0xAE},
    {0x96,0xAF}, {0x96,0xB0}, {0x96,0xB1}, {0x96,0xB2},
    {0x96,0xB3}, {0x96,0xB4}, {0x96,0xB5}, {0x96,0xB6},
    {0x96,0xB7}, {0x96,0xB8}, {0x96,0xB9}, {0x96,0xBA},
    {0x96,0xBB}, {0x96,0xBC}, {0x96,0xBD}, {0x96,0xBE},
    {0x96,0xBF}, {0x96,0xC0}, {0x96,0xC1}, {0x96,0xC2},
    {0x96,0xC3}, {0x96,0xC4}, {0x96,0xC5}, {0x96,0xC6},
    {0x96,0xC7}, {0x96,0xC8}, {0x96,0xC9}, {0x96,0xCA},
    {0x96,0xCB}, {0x96,0xCC}, {0x96,0xCD}, {0x96,0xCE},
    {0x96,0xCF}, {0x96,0xD0}, {0x96,0xD1}, {0x96,0xD2},
    {0x96,0xD3}, {0x96,0xD4}, {0x96,0xD5}, {0x96,0xD6},
    {0x96,0xD7}, {0x96,0xD8}, {0x96,0xD9}, {0x96,0xDA},
    {0x96,0xDB}, {0x96,0xDC}, {0x96,0xDD}, {0x96,0xDE},
    {0x96,0xDF}, {0x96,0xE0}, {0x96,0xE1}, {0x96,0xE2},
    {0x96,0xE3}, {0x96,0xE4}, {0x96,0xE5}, {0x96,0xE6},
    {0x96,0xE7}, {0x96,0xE8}, {0x96,0xE9}, {0x96,0xEA},
    {0x96,0xEB}, {0x96,0xEC}, {0x96,0xEE}, {0x96,0xEE},
    {0x96,0xEF}, {0x96,0xF0}, {0x96,0xF1}, {0x96,0xF2},
    {0x96,0xF3}, {0x96,0xF4}, {0x96,0xF5}, {0x96,0xF6},
    {0x96,0xF7}, {0x96,0xF8}, {0x96,0xF9}, {0x96,0xFA},
    {0x96,0xFB}, {0xE9,0x59}, {0x96,0xFD}, {0x96,0xFE},
    {0x97,0x40}, {0x97,0x41}, {0x97,0x42}, {0x97,0x43},
    {0x97,0x44}, {0x97,0x45}, {0x97,0x46}, {0x97,0x47},
    {0x97,0x48}, {0x97,0x49}, {0x97,0x4A}, {0x97,0x4B},
    {0x97,0x4C}, {0x97,0x4D}, {0x97,0x4E}, {0x97,0x4F},
    {0x97,0x50}, {0x97,0x51}, {0x97,0x52}, {0x97,0x53},
    {0x97,0x54}, {0x97,0x55}, {0x97,0x56}, {0x97,0x57},
    {0x97,0x58}, {0x97,0x59}, {0x97,0x5A}, {0x97,0x5B},
    {0x97,0x5C}, {0x97,0x5D}, {0x97,0x5E}, {0x97,0x5F},
    {0x97,0x60}, {0x97,0x61}, {0x97,0x62}, {0x97,0x63},
    {0x97,0x64}, {0x97,0x65}, {0x97,0x66}, {0x97,0x67},
    {0x97,0x68}, {0x97,0x69}, {0x97,0x6A}, {0x97,0x6B},
    {0x97,0x6C}, {0x97,0x6D}, {0x97,0x6E}, {0x97,0x6F},
    {0x97,0x70}, {0x97,0x71}, {0x97,0x72}, {0x97,0x73},
    {0x97,0x74}, {0x97,0x75}, {0x97,0x76}, {0x97,0x77},
    {0x97,0x78}, {0x97,0x79}, {0x97,0x7A}, {0x97,0x7B},
    {0x97,0x7C}, {0x97,0x7D}, {0x97,0x7E}, {0x97,0xA1},
    {0x97,0xA2}, {0x97,0xA3}, {0x97,0xA4}, {0x97,0xA5},
    {0x97,0xA6}, {0x97,0xA7}, {0x97,0xA8}, {0x97,0xA9},
    {0x97,0xAA}, {0x97,0xAB}, {0x97,0xAC}, {0x97,0xAD},
    {0x97,0xAE}, {0x97,0xAF}, {0x97,0xB0}, {0x97,0xB1},
    {0x97,0xB2}, {0x97,0xB3}, {0x97,0xB4}, {0x97,0xB5},
    {0x97,0xB6}, {0x97,0xB7}, {0x97,0xB8}, {0x97,0xB9},
    {0x97,0xBA}, {0x97,0xBB}, {0x97,0xBC}, {0x97,0xBD},
    {0x97,0xBE}, {0x97,0xBF}, {0x97,0xC0}, {0x97,0xC1},
    {0x97,0xC2}, {0x97,0xC3}, {0x97,0xC4}, {0x97,0xC5},
    {0x97,0xC6}, {0x97,0xC7}, {0x97,0xC8}, {0x97,0xC9},
    {0x97,0xCA}, {0x97,0xCB}, {0x97,0xCC}, {0x97,0xCD},
    {0x97,0xCE}, {0x97,0xCF}, {0x97,0xD0}, {0x97,0xD1},
    {0x97,0xD2}, {0x97,0xD3}, {0x97,0xD4}, {0x97,0xD5},
    {0x97,0xD6}, {0x97,0xD7}, {0x97,0xD8}, {0x97,0xD9},
    {0x97,0xDA}, {0x97,0xDB}, {0x97,0xDC}, {0x97,0xDD},
    {0x97,0xDE}, {0x97,0xDF}, {0x97,0xE0}, {0x97,0xE1},
    {0x97,0xE2}, {0x97,0xE3}, {0x97,0xE4}, {0x97,0xE5},
    {0x97,0xE6}, {0x97,0xE7}, {0x97,0xE8}, {0x97,0xE9},
    {0x97,0xEA}, {0x97,0xEB}, {0x97,0xEC}, {0x97,0xED},
    {0x97,0xEE}, {0x97,0xEF}, {0x97,0xF0}, {0x97,0xF1},
    {0x97,0xF2}, {0x97,0xF3}, {0x97,0xF4}, {0x97,0xF5},
    {0x97,0xF6}, {0x97,0xF7}, {0x97,0xF8}, {0x97,0xF9},
    {0x97,0xFA}, {0x97,0xFB}, {0x97,0xFC}, {0x97,0xFD},
    {0x97,0xFE}, {0x98,0x40}, {0x98,0x41}, {0x98,0x42},
    {0x98,0x43}, {0x98,0x44}, {0x98,0x45}, {0x98,0x46},
    {0x98,0x47}, {0x98,0x48}, {0x98,0x49}, {0x98,0x4A},
    {0x98,0x4B}, {0x98,0x4C}, {0x98,0x4D}, {0x98,0x4E},
    {0x98,0x4F}, {0x98,0x50}, {0x98,0x51}, {0x98,0x52},
    {0x98,0x53}, {0x98,0x54}, {0x98,0x55}, {0x98,0x56},
    {0x98,0x57}, {0x98,0x58}, {0x98,0x59}, {0x98,0x5A},
    {0x98,0x5B}, {0x98,0x5C}, {0x98,0x5D}, {0x98,0x5E},
    {0x98,0x5F}, {0x98,0x60}, {0x98,0x61}, {0x98,0x62},
    {0x98,0x63}, {0x98,0x64}, {0x98,0x65}, {0x98,0x66},
    {0x98,0x67}, {0x98,0x68}, {0x98,0x69}, {0x98,0x6A},
    {0x98,0x6B}, {0x98,0x6C}, {0x98,0x6D}, {0x98,0x6E},
    {0x98,0x6F}, {0x98,0x70}, {0x98,0x71}, {0x98,0x72},
    {0x98,0x73}, {0x98,0x74}, {0x98,0x75}, {0x98,0x76},
    {0x98,0x77}, {0x98,0x78}, {0x98,0x79}, {0x98,0x7A},
    {0x98,0x7B}, {0x98,0x7C}, {0x98,0x7D}, {0x98,0x7E},
    {0x98,0xA1}, {0x98,0xA2}, {0x98,0xA3}, {0x98,0xA4},
    {0x98,0xA5}, {0x98,0xA6}, {0x98,0xA7}, {0x98,0xA8},
    {0x98,0xA9}, {0x98,0xAA}, {0x98,0xAB}, {0x98,0xAC},
    {0x98,0xAD}, {0x98,0xAE}, {0x98,0xAF}, {0x98,0xB0},
    {0x98,0xB1}, {0x98,0xB2}, {0x98,0xB3}, {0x98,0xB4},
    {0x98,0xB5}, {0x98,0xB6}, {0x98,0xB7}, {0x98,0xB8},
    {0x98,0xB9}, {0x98,0xBA}, {0x98,0xBB}, {0x98,0xBC},
    {0x98,0xBD}, {0x98,0xBE}, {0x98,0xBF}, {0x98,0xC0},
    {0x98,0xC1}, {0x98,0xC2}, {0x98,0xC3}, {0x98,0xC4},
    {0x98,0xC5}, {0x98,0xC6}, {0x98,0xC7}, {0x98,0xC8},
    {0x98,0xC9}, {0x98,0xCA}, {0x98,0xCB}, {0x98,0xCC},
    {0x98,0xCD}, {0x98,0xCE}, {0x98,0xCF}, {0x98,0xD0},
    {0x98,0xD1}, {0x98,0xD2}, {0x98,0xD3}, {0x98,0xD4},
    {0x98,0xD5}, {0x98,0xD6}, {0x98,0xD7}, {0x98,0xD8},
    {0x98,0xD9}, {0x98,0xDA}, {0x98,0xDB}, {0x98,0xDC},
    {0x98,0xDD}, {0x98,0xDE}, {0x98,0xDF}, {0x98,0xE0},
    {0x98,0xE1}, {0x98,0xE2}, {0x98,0xE3}, {0x98,0xE4},
    {0x98,0xE5}, {0x98,0xE6}, {0x98,0xE7}, {0x98,0xE8},
    {0x98,0xE9}, {0x98,0xEA}, {0x98,0xEB}, {0x98,0xEC},
    {0x98,0xED}, {0x98,0xEE}, {0x98,0xEF}, {0x98,0xF0},
    {0x98,0xF1}, {0x98,0xF2}, {0x98,0xF3}, {0x98,0xF4},
    {0x98,0xF5}, {0x98,0xF6}, {0x98,0xF7}, {0x98,0xF8},
    {0x98,0xF9}, {0x98,0xFA}, {0x98,0xFB}, {0x98,0xFC},
    {0x98,0xFD}, {0x98,0xFE}, {0x99,0x40}, {0x99,0x41},
    {0x99,0x42}, {0x99,0x43}, {0x99,0x44}, {0x99,0x45},
    {0x99,0x46}, {0x99,0x47}, {0x99,0x48}, {0x99,0x49},
    {0x99,0x4A}, {0x99,0x4B}, {0x99,0x4C}, {0x99,0x4D},
    {0x99,0x4E}, {0x99,0x4F}, {0x99,0x50}, {0x99,0x51},
    {0x99,0x52}, {0x99,0x53}, {0x99,0x54}, {0x99,0x55},
    {0x99,0x56}, {0x99,0x57}, {0x99,0x58}, {0x99,0x59},
    {0x99,0x5A}, {0x99,0x5B}, {0x99,0x5C}, {0x99,0x5D},
    {0x99,0x5E}, {0x99,0x5F}, {0x99,0x60}, {0x99,0x61},
    {0x99,0x62}, {0x99,0x63}, {0x99,0x64}, {0x99,0x65},
    {0x99,0x66}, {0x99,0x67}, {0x99,0x68}, {0x99,0x69},
    {0x99,0x6A}, {0x99,0x6B}, {0x99,0x6C}, {0x99,0x6D},
    {0x99,0x6E}, {0x99,0x6F}, {0x99,0x70}, {0x99,0x71},
    {0x99,0x72}, {0x99,0x73}, {0x99,0x74}, {0x99,0x75},
    {0x99,0x76}, {0x99,0x77}, {0x99,0x78}, {0x99,0x79},
    {0x99,0x7A}, {0x99,0x7B}, {0x99,0x7C}, {0x99,0x7D},
    {0x99,0x7E}, {0x99,0xA1}, {0x99,0xA2}, {0x99,0xA3},
    {0x99,0xA4}, {0x99,0xA5}, {0x99,0xA6}, {0x99,0xA7},
    {0x99,0xA8}, {0x99,0xA9}, {0x99,0xAA}, {0x99,0xAB},
    {0x99,0xAC}, {0x99,0xAD}, {0x99,0xAE}, {0x99,0xAF},
    {0x99,0xB0}, {0x99,0xB1}, {0x99,0xB2}, {0x99,0xB3},
    {0x99,0xB4}, {0x99,0xB5}, {0x99,0xB6}, {0x99,0xB7},
    {0x99,0xB8}, {0x99,0xB9}, {0x99,0xBA}, {0x99,0xBB},
    {0x99,0xBC}, {0x99,0xBD}, {0x99,0xBE}, {0x99,0xBF},
    {0x99,0xC0}, {0x99,0xC1}, {0x99,0xC2}, {0x99,0xC3},
    {0x99,0xC4}, {0x99,0xC5}, {0x99,0xC6}, {0x99,0xC7},
    {0x99,0xC8}, {0x99,0xC9}, {0x99,0xCA}, {0x99,0xCB},
    {0x99,0xCC}, {0x99,0xCD}, {0x99,0xCE}, {0x99,0xCF},
    {0x99,0xD0}, {0x99,0xD1}, {0x99,0xD2}, {0x99,0xD3},
    {0x99,0xD4}, {0x99,0xD5}, {0x99,0xD6}, {0x99,0xD7},
    {0x99,0xD8}, {0x99,0xD9}, {0x99,0xDA}, {0x99,0xDB},
    {0x99,0xDC}, {0x99,0xDD}, {0x99,0xDE}, {0x99,0xDF},
    {0x99,0xE0}, {0x99,0xE1}, {0x99,0xE2}, {0x99,0xE3},
    {0x99,0xE4}, {0x99,0xE5}, {0x99,0xE6}, {0x99,0xE7},
    {0x99,0xE8}, {0x99,0xE9}, {0x99,0xEA}, {0x99,0xEB},
    {0x99,0xEC}, {0x99,0xED}, {0x99,0xEE}, {0x99,0xEF},
    {0x99,0xF0}, {0x99,0xF1}, {0x99,0xF2}, {0x99,0xF3},
    {0x99,0xF4}, {0x99,0xF5}, {0x99,0xF6}, {0x99,0xF7},
    {0x99,0xF8}, {0x99,0xF9}, {0x99,0xFA}, {0x99,0xFB},
    {0x99,0xFC}, {0x99,0xFD}, {0x99,0xFE}, {0x9A,0x40},
    {0x9A,0x41}, {0x9A,0x42}, {0x9A,0x43}, {0x9A,0x44},
    {0x9A,0x45}, {0x9A,0x46}, {0x9A,0x47}, {0x9A,0x48},
    {0x9A,0x49}, {0x9A,0x4A}, {0x9A,0x4B}, {0x9A,0x4C},
    {0x9A,0x4D}, {0x9A,0x4E}, {0x9A,0x4F}, {0x9A,0x50},
    {0x9A,0x51}, {0x9A,0x52}, {0x9A,0x53}, {0x9A,0x54},
    {0x9A,0x55}, {0x9A,0x56}, {0x9A,0x57}, {0x9A,0x58},
    {0x9A,0x59}, {0x9A,0x5A}, {0x9A,0x5B}, {0x9A,0x5C},
    {0x9A,0x5D}, {0x9A,0x5E}, {0x9A,0x5F}, {0x9A,0x60},
    {0x9A,0x61}, {0x9A,0x62}, {0x9A,0x63}, {0x9A,0x64},
    {0x9A,0x65}, {0x9A,0x66}, {0x9A,0x67}, {0x9A,0x68},
    {0x9A,0x69}, {0x9A,0x6A}, {0x9A,0x6B}, {0x9A,0x6C},
    {0x9A,0x6D}, {0x9A,0x6E}, {0x9A,0x6F}, {0x9A,0x70},
    {0x9A,0x71}, {0x9A,0x72}, {0x9A,0x73}, {0x9A,0x74},
    {0x9A,0x75}, {0x9A,0x76}, {0x9A,0x77}, {0x9A,0x78},
    {0x9A,0x79}, {0x9A,0x7A}, {0x9A,0x7B}, {0x9A,0x7C},
    {0x9A,0x7D}, {0x9A,0x7E}, {0x9A,0xA1}, {0x9A,0xA2},
    {0x9A,0xA3}, {0x9A,0xA4}, {0x9A,0xA5}, {0x9A,0xA6},
    {0x9A,0xA7}, {0x9A,0xA8}, {0x9A,0xA9}, {0x9A,0xAA},
    {0x9A,0xAB}, {0x9A,0xAC}, {0x9A,0xAD}, {0x9A,0xAE},
    {0x9A,0xAF}, {0x9A,0xB0}, {0x9A,0xB1}, {0x9A,0xB2},
    {0x9A,0xB3}, {0x9A,0xB4}, {0x9A,0xB5}, {0x9A,0xB6},
    {0x9A,0xB7}, {0x9A,0xB8}, {0x9A,0xB9}, {0x9A,0xBA},
    {0x9A,0xBB}, {0x9A,0xBC}, {0x9A,0xBD}, {0x9A,0xBE},
    {0x9A,0xBF}, {0x9A,0xC0}, {0x9A,0xC1}, {0x9A,0xC2},
    {0x9A,0xC3}, {0x9A,0xC4}, {0x9A,0xC5}, {0x9A,0xC6},
    {0x9A,0xC7}, {0x9A,0xC8}, {0x9A,0xC9}, {0x9A,0xCA},
    {0x9A,0xCB}, {0x9A,0xCC}, {0x9A,0xCD}, {0x9A,0xCE},
    {0x9A,0xCF}, {0x9A,0xD0}, {0x9A,0xD1}, {0x9A,0xD2},
    {0x9A,0xD3}, {0x9A,0xD4}, {0x9A,0xD5}, {0x9A,0xD6},
    {0x9A,0xD7}, {0x9A,0xD8}, {0x9A,0xD9}, {0x9A,0xDA},
    {0x9A,0xDB}, {0x9A,0xDC}, {0x9A,0xDD}, {0x9A,0xDE},
    {0x9A,0xDF}, {0x9A,0xE0}, {0x9A,0xE1}, {0x9A,0xE2},
    {0x9A,0xE3}, {0x9A,0xE4}, {0x9A,0xE5}, {0x9A,0xE6},
    {0x9A,0xE7}, {0x9A,0xE8}, {0x9A,0xE9}, {0x9A,0xEA},
    {0x9A,0xEB}, {0x9A,0xEC}, {0x9A,0xED}, {0x9A,0xEE},
    {0x9A,0xEF}, {0x9A,0xF0}, {0x9A,0xF1}, {0x9A,0xF2},
    {0x9A,0xF3}, {0x9A,0xF4}, {0x9A,0xF5}, {0x9A,0xF6},
    {0x9A,0xF7}, {0x9A,0xF8}, {0x9A,0xF9}, {0x9A,0xFA},
    {0x9A,0xFB}, {0x9A,0xFC}, {0x9A,0xFD}, {0x9A,0xFE},
    {0x9B,0x40}, {0x9B,0x41}, {0x9B,0x42}, {0x9B,0x43},
    {0x9B,0x44}, {0x9B,0x45}, {0x9B,0x46}, {0x9B,0x47},
    {0x9B,0x48}, {0x9B,0x49}, {0x9B,0x4A}, {0x9B,0x4B},
    {0x9B,0x4C}, {0x9B,0x4D}, {0x9B,0x4E}, {0x9B,0x4F},
    {0x9B,0x50}, {0x9B,0x51}, {0x9B,0x52}, {0x9B,0x53},
    {0x9B,0x54}, {0x9B,0x55}, {0x9B,0x56}, {0x9B,0x57},
    {0x9B,0x58}, {0x9B,0x59}, {0x9B,0x5A}, {0x9B,0x5B},
    {0x9B,0x5C}, {0x9B,0x5D}, {0x9B,0x5E}, {0x9B,0x5F},
    {0x9B,0x60}, {0x9B,0x61}, {0x9B,0x62}, {0x9B,0x63},
    {0x9B,0x64}, {0x9B,0x65}, {0x9B,0x66}, {0x9B,0x67},
    {0x9B,0x68}, {0x9B,0x69}, {0x9B,0x6A}, {0x9B,0x6B},
    {0x9B,0x6C}, {0x9B,0x6D}, {0x9B,0x6E}, {0x9B,0x6F},
    {0x9B,0x70}, {0x9B,0x71}, {0x9B,0x72}, {0x9B,0x73},
    {0x9B,0x74}, {0x9B,0x75}, {0xEF,0xF9}, {0x9B,0x77},
    {0xC5,0xF7}, {0x9B,0x79}, {0x9B,0x7A}, {0xF5,0xE8},
    {0x9B,0x7C}, {0x9B,0x7D}, {0x9B,0x7E}, {0x9B,0xA1},
    {0x9B,0xA2}, {0x9B,0xA3}, {0x9B,0xA4}, {0x9B,0xA5},
    {0x9B,0xA6}, {0x9B,0xA7}, {0x9B,0xA8}, {0x9B,0xA9},
    {0x9B,0xAA}, {0x9B,0xAB}, {0x9B,0xAC}, {0x9B,0xAD},
    {0x9B,0xAE}, {0x9B,0xAF}, {0x9B,0xB0}, {0x9B,0xB1},
    {0x9B,0xB2}, {0x9B,0xB3}, {0x9B,0xB4}, {0x9B,0xB5},
    {0x9B,0xB6}, {0x9B,0xB7}, {0x9B,0xB8}, {0x9B,0xB9},
    {0x9B,0xBA}, {0x9B,0xBB}, {0x9B,0xBC}, {0x9B,0xBD},
    {0x9B,0xBE}, {0x9B,0xBF}, {0x9B,0xC0}, {0x9B,0xC1},
    {0x9B,0xC2}, {0x9B,0xC3}, {0x9B,0xC4}, {0x9B,0xC5},
    {0xE8,0xCD}, {0x9B,0xC7}, {0x9B,0xC8}, {0x9B,0xC9},
    {0x9B,0xCA}, {0x9B,0xCB}, {0x9B,0xCC}, {0x9B,0xCD},
    {0x9B,0xCE}, {0x9B,0xCF}, {0x9B,0xD0}, {0x9B,0xD1},
    {0x9B,0xD2}, {0x9B,0xD3}, {0x9B,0xD4}, {0x9B,0xD5},
    {0x9B,0xD6}, {0x9B,0xD7}, {0x9B,0xD8}, {0x9B,0xD9},
    {0x9B,0xDA}, {0x9B,0xDB}, {0x9B,0xDC}, {0x9B,0xDD},
    {0xD0,0xC0}, {0x9B,0xDF}, {0x9B,0xE0}, {0x9B,0xE1},
    {0x9B,0xE2}, {0x9B,0xE3}, {0x9B,0xE4}, {0x9B,0xE5},
    {0x9B,0xE6}, {0x9B,0xE7}, {0x9B,0xE8}, {0x9B,0xE9},
    {0x9B,0xEA}, {0x9B,0xEB}, {0xFD,0x64}, {0x9B,0xED},
    {0x9B,0xEE}, {0x9B,0xEF}, {0x9B,0xF0}, {0x9B,0xF1},
    {0x9B,0xF2}, {0x9B,0xF3}, {0x9B,0xF4}, {0x9B,0xF5},
    {0xBF,0x47}, {0x9B,0xF7}, {0x9B,0xF8}, {0x9B,0xF9},
    {0x9B,0xFA}, {0x9B,0xFB}, {0x9B,0xFC}, {0x9B,0xFD},
    {0x9B,0xFE}, {0x9C,0x40}, {0x9C,0x41}, {0xEB,0xC9},
    {0x9C,0x43}, {0x9C,0x44}, {0x9C,0x45}, {0x9C,0x46},
    {0x9C,0x47}, {0x9C,0x48}, {0x9C,0x49}, {0x9C,0x4A},
    {0x9C,0x4B}, {0x9C,0x4C}, {0x9C,0x4D}, {0x9C,0x4E},
    {0x9C,0x4F}, {0x9C,0x50}, {0x9C,0x51}, {0x9C,0x52},
    {0xCD,0xE7}, {0x9C,0x54}, {0x9C,0x55}, {0x9C,0x56},
    {0x9C,0x57}, {0x9C,0x58}, {0x9C,0x59}, {0x9C,0x5A},
    {0x9C,0x5B}, {0x9C,0x5C}, {0x9C,0x5D}, {0x9C,0x5E},
    {0x9C,0x5F}, {0x9C,0x60}, {0x9C,0x61}, {0xC0,0xE7},
    {0x9C,0x63}, {0x9C,0x64}, {0x9C,0x65}, {0x9C,0x66},
    {0x9C,0x67}, {0xDC,0x52}, {0x9C,0x69}, {0x9C,0x6A},
    {0xF8,0x6D}, {0x9C,0x6C}, {0x9C,0x6D}, {0x9C,0x6E},
    {0x9C,0x6F}, {0x9C,0x70}, {0x9C,0x71}, {0x9C,0x72},
    {0x9C,0x73}, {0x9C,0x74}, {0x9C,0x75}, {0x9C,0x76},
    {0xDB,0x5D}, {0x9C,0x78}, {0x9C,0x79}, {0x9C,0x7A},
    {0x9C,0x7B}, {0x9C,0x7C}, {0x9C,0x7D}, {0x9C,0x7E},
    {0x9C,0xA1}, {0x9C,0xA2}, {0x9C,0xA3}, {0x9C,0xA4},
    {0x9C,0xA5}, {0x9C,0xA6}, {0x9C,0xA7}, {0x9C,0xA8},
    {0x9C,0xA9}, {0x9C,0xAA}, {0x9C,0xAB}, {0x9C,0xAC},
    {0x9C,0xAD}, {0x9C,0xAE}, {0x9C,0xAF}, {0x9C,0xB0},
    {0x9C,0xB1}, {0x9C,0xB2}, {0x9C,0xB3}, {0x9C,0xB4},
    {0x9C,0xB5}, {0x9C,0xB6}, {0x9C,0xB7}, {0x9C,0xB8},
    {0x9C,0xB9}, {0x9C,0xBA}, {0x9C,0xBB}, {0xC9,0x5C},
    {0xAF,0xB0}, {0x9C,0xBE}, {0x9C,0xBF}, {0x9C,0xC0},
    {0x9C,0xC1}, {0x9C,0xC2}, {0x9C,0xC3}, {0x9C,0xC4},
    {0x9C,0xC5}, {0x9C,0xC6}, {0x9C,0xC7}, {0x9C,0xC8},
    {0x9C,0xC9}, {0x9C,0xCA}, {0x9C,0xCB}, {0x9C,0xCC},
    {0x9C,0xCD}, {0x9C,0xCE}, {0x9C,0xCF}, {0xD4,0xD1},
    {0x9C,0xD1}, {0x9C,0xD2}, {0x9C,0xD3}, {0x9C,0xD4},
    {0x9C,0xD5}, {0x9C,0xD6}, {0x9C,0xD7}, {0x9C,0xD8},
    {0x9C,0xD9}, {0x9C,0xDA}, {0x9C,0xDB}, {0x9C,0xDC},
    {0x9C,0xDD}, {0x9C,0xDE}, {0x9C,0xDF}, {0x9C,0xE0},
    {0x9C,0xE1}, {0x9C,0xE2}, {0x9C,0xE3}, {0x9C,0xE4},
    {0x9C,0xE5}, {0x9C,0xE6}, {0x9C,0xE7}, {0x9C,0xE8},
    {0x9C,0xE9}, {0x9C,0xEA}, {0x9C,0xEB}, {0x9C,0xEC},
    {0x9C,0xED}, {0x9C,0xEE}, {0x9C,0xEF}, {0x9C,0xF0},
    {0x9C,0xF1}, {0x9C,0xF2}, {0x9C,0xF3}, {0x9C,0xF4},
    {0x9C,0xF5}, {0x9C,0xF6}, {0x9C,0xF7}, {0x9C,0xF8},
    {0x9C,0xF9}, {0x9C,0xFA}, {0x9C,0xFB}, {0x9C,0xFC},
    {0x9C,0xFD}, {0x9C,0xFE}, {0x9D,0x40}, {0x9D,0x41},
    {0x9D,0x42}, {0x9D,0x43}, {0x9D,0x44}, {0x9D,0x45},
    {0x9D,0x46}, {0x9D,0x47}, {0x9D,0x48}, {0x9D,0x49},
    {0x9D,0x4A}, {0x9D,0x4B}, {0x9D,0x4C}, {0x9D,0x4D},
    {0x9D,0x4E}, {0x9D,0x4F}, {0x9D,0x50}, {0x9D,0x51},
    {0x9D,0x52}, {0x9D,0x53}, {0x9D,0x54}, {0x9D,0x55},
    {0x9D,0x56}, {0xE0,0x7C}, {0x9D,0x58}, {0x9D,0x59},
    {0xB5,0xAE}, {0x9D,0x5B}, {0x9D,0x5C}, {0x9D,0x5D},
    {0x9D,0x5E}, {0x9D,0x5F}, {0x9D,0x60}, {0x9D,0x61},
    {0x9D,0x62}, {0x9D,0x63}, {0x9D,0x64}, {0x9D,0x65},
    {0x9D,0x66}, {0x9D,0x67}, {0x9D,0x68}, {0x9D,0x69},
    {0x9D,0x6A}, {0x9D,0x6B}, {0x9D,0x6C}, {0x9D,0x6D},
    {0x9D,0x6E}, {0x9D,0x6F}, {0x9D,0x70}, {0x9D,0x71},
    {0x9D,0x72}, {0x9D,0x73}, {0x9D,0x74}, {0x9D,0x75},
    {0x9D,0x76}, {0x9D,0x77}, {0x9D,0x78}, {0x9D,0x79},
    {0x9D,0x7A}, {0x9D,0x7B}, {0x9D,0x7C}, {0x9D,0x7D},
    {0x9D,0x7E}, {0x9D,0xA1}, {0x9D,0xA2}, {0x9D,0xA3},
    {0x9D,0xA4}, {0x9D,0xA5}, {0x9D,0xA6}, {0x9D,0xA7},
    {0x9D,0xA8}, {0x9D,0xA9}, {0x9D,0xAA}, {0x9D,0xAB},
    {0x9D,0xAC}, {0x9D,0xAD}, {0x9D,0xAE}, {0x9D,0xAF},
    {0x9D,0xB0}, {0x9D,0xB1}, {0x9D,0xB2}, {0x9D,0xB3},
    {0x9D,0xB4}, {0x9D,0xB5}, {0x9D,0xB6}, {0x9D,0xB7},
    {0x9D,0xB8}, {0x9D,0xB9}, {0x9D,0xBA}, {0x9D,0xBB},
    {0x9D,0xBC}, {0x9D,0xBD}, {0x9D,0xBE}, {0x9D,0xBF},
    {0x9D,0xC0}, {0x9D,0xC1}, {0x9D,0xC2}, {0x9D,0xC3},
    {0xA9,0xE4}, {0x9D,0xC5}, {0x9D,0xC6}, {0x9D,0xC7},
    {0x9D,0xC8}, {0x9D,0xC9}, {0x9D,0xCA}, {0x9D,0xCB},
    {0x9D,0xCC}, {0x9D,0xCD}, {0x9D,0xCE}, {0x9D,0xCF},
    {0x9D,0xD0}, {0x9D,0xD1}, {0x9D,0xD2}, {0x9D,0xD3},
    {0x9D,0xD4}, {0x9D,0xD5}, {0x9D,0xD6}, {0x9D,0xD7},
    {0x9D,0xD8}, {0x9D,0xD9}, {0x9D,0xDA}, {0x9D,0xDB},
    {0x9D,0xDC}, {0x9D,0xDD}, {0x9D,0xDE}, {0x9D,0xDF},
    {0x9D,0xE0}, {0x9D,0xE1}, {0x9D,0xE2}, {0x9D,0xE3},
    {0x9D,0xE4}, {0x9D,0xE5}, {0x9D,0xE6}, {0x9D,0xE7},
    {0x9D,0xE8}, {0x9D,0xE9}, {0x9D,0xEA}, {0x9D,0xEB},
    {0x9D,0xEC}, {0x9D,0xED}, {0x9D,0xEE}, {0x9D,0xEF},
    {0x9D,0xF0}, {0x9D,0xF1}, {0x9D,0xF2}, {0x9D,0xF3},
    {0x9D,0xF4}, {0x9D,0xF5}, {0x9D,0xF6}, {0x9D,0xF7},
    {0x9D,0xF8}, {0x9D,0xF9}, {0x9D,0xFA}, {0x9D,0xFB},
    {0x9D,0xFC}, {0x9D,0xFD}, {0x9D,0xFE}, {0x9E,0x40},
    {0x9E,0x41}, {0x9E,0x42}, {0x9E,0x43}, {0x9E,0x44},
    {0x9E,0x45}, {0x9E,0x46}, {0x9E,0x47}, {0x9E,0x48},
    {0x9E,0x49}, {0x9E,0x4A}, {0x9E,0x4B}, {0x9E,0x4C},
    {0x9E,0x4D}, {0x9E,0x4E}, {0x9E,0x4F}, {0x9E,0x50},
    {0x9E,0x51}, {0x9E,0x52}, {0x9E,0x53}, {0x9E,0x54},
    {0x9E,0x55}, {0x9E,0x56}, {0x9E,0x57}, {0x9E,0x58},
    {0x9E,0x59}, {0x9E,0x5A}, {0x9E,0x5B}, {0x9E,0x5C},
    {0x9E,0x5D}, {0x9E,0x5E}, {0x9E,0x5F}, {0x9E,0x60},
    {0x9E,0x61}, {0x9E,0x62}, {0x9E,0x63}, {0x9E,0x64},
    {0x9E,0x65}, {0x9E,0x66}, {0x9E,0x67}, {0x9E,0x68},
    {0x9E,0x69}, {0x9E,0x6A}, {0x9E,0x6B}, {0x9E,0x6C},
    {0x9E,0x6D}, {0x9E,0x6E}, {0x9E,0x6F}, {0x9E,0x70},
    {0x9E,0x71}, {0x9E,0x72}, {0x9E,0x73}, {0x9E,0x74},
    {0x9E,0x75}, {0x9E,0x76}, {0x9E,0x77}, {0x9E,0x78},
    {0x9E,0x79}, {0x9E,0x7A}, {0x9E,0x7B}, {0x9E,0x7C},
    {0x9E,0x7D}, {0x9E,0x7E}, {0x9E,0xA1}, {0x9E,0xA2},
    {0x9E,0xA3}, {0x9E,0xA4}, {0x9E,0xA5}, {0x9E,0xA6},
    {0x9E,0xA7}, {0x9E,0xA8}, {0xAB,0xEC}, {0x9E,0xAA},
    {0x9E,0xAB}, {0x9E,0xAC}, {0x9E,0xAD}, {0x9E,0xAE},
    {0x9E,0xAF}, {0x9E,0xB0}, {0x9E,0xB1}, {0x9E,0xB2},
    {0x9E,0xB3}, {0x9E,0xB4}, {0x9E,0xB5}, {0x9E,0xB6},
    {0x9E,0xB7}, {0x9E,0xB8}, {0x9E,0xB9}, {0x9E,0xBA},
    {0x9E,0xBB}, {0x9E,0xBC}, {0x9E,0xBD}, {0x9E,0xBE},
    {0x9E,0xBF}, {0x9E,0xC0}, {0x9E,0xC1}, {0x9E,0xC2},
    {0x9E,0xC3}, {0x9E,0xC4}, {0x9E,0xC5}, {0x9E,0xC6},
    {0x9E,0xC7}, {0x9E,0xC8}, {0x9E,0xC9}, {0x9E,0xCA},
    {0x9E,0xCB}, {0x9E,0xCC}, {0x9E,0xCD}, {0x9E,0xCE},
    {0x9E,0xCF}, {0x9E,0xD0}, {0x9E,0xD1}, {0x9E,0xD2},
    {0x9E,0xD3}, {0x9E,0xD4}, {0x9E,0xD5}, {0x9E,0xD6},
    {0x9E,0xD7}, {0x9E,0xD8}, {0x9E,0xD9}, {0x9E,0xDA},
    {0x9E,0xDB}, {0x9E,0xDC}, {0x9E,0xDD}, {0x9E,0xDE},
    {0x9E,0xDF}, {0x9E,0xE0}, {0x9E,0xE1}, {0x9E,0xE2},
    {0x9E,0xE3}, {0x9E,0xE4}, {0x9E,0xE5}, {0x9E,0xE6},
    {0x9E,0xE7}, {0x9E,0xE8}, {0x9E,0xE9}, {0x9E,0xEA},
    {0x9E,0xEB}, {0x9E,0xEC}, {0x9E,0xED}, {0x9E,0xEE},
    {0xDE,0xCD}, {0x9E,0xF0}, {0x9E,0xF1}, {0x9E,0xF2},
    {0x9E,0xF3}, {0x9E,0xF4}, {0x9E,0xF5}, {0x9E,0xF6},
    {0x9E,0xF7}, {0x9E,0xF8}, {0x9E,0xF9}, {0x9E,0xFA},
    {0x9E,0xFB}, {0x9E,0xFC}, {0xC9,0xFC}, {0x9E,0xFE},
    {0x9F,0x40}, {0x9F,0x41}, {0x9F,0x42}, {0x9F,0x43},
    {0x9F,0x44}, {0x9F,0x45}, {0x9F,0x46}, {0x9F,0x47},
    {0x9F,0x48}, {0x9F,0x49}, {0x9F,0x4A}, {0x9F,0x4B},
    {0x9F,0x4C}, {0x9F,0x4D}, {0x9F,0x4E}, {0x9F,0x4F},
    {0x9F,0x50}, {0x9F,0x51}, {0x9F,0x52}, {0x9F,0x53},
    {0x9F,0x54}, {0x9F,0x55}, {0x9F,0x56}, {0x9F,0x57},
    {0x9F,0x58}, {0x9F,0x59}, {0x9F,0x5A}, {0x9F,0x5B},
    {0x9F,0x5C}, {0x9F,0x5D}, {0x9F,0x5E}, {0x9F,0x5F},
    {0xF9,0xC4}, {0x9F,0x61}, {0x9F,0x62}, {0x9F,0x63},
    {0x9F,0x64}, {0x9F,0x65}, {0x91,0xBE}, {0x9F,0x67},
    {0x9F,0x68}, {0x9F,0x69}, {0x9F,0x6A}, {0x9F,0x6B},
    {0x9F,0x6C}, {0x9F,0x6D}, {0x9F,0x6E}, {0x9F,0x6F},
    {0x9F,0x70}, {0x9F,0x71}, {0x9F,0x72}, {0x9F,0x73},
    {0x9F,0x74}, {0x9F,0x75}, {0x9F,0x76}, {0x9F,0x77},
    {0x9F,0x78}, {0x9F,0x79}, {0x9F,0x7A}, {0x9F,0x7B},
    {0x9F,0x7C}, {0x9F,0x7D}, {0x9F,0x7E}, {0x9F,0xA1},
    {0x9F,0xA2}, {0x9F,0xA3}, {0x9F,0xA4}, {0x9F,0xA5},
    {0x9F,0xA6}, {0x9F,0xA7}, {0x9F,0xA8}, {0x9F,0xA9},
    {0x9F,0xAA}, {0x9F,0xAB}, {0x9F,0xAC}, {0x9F,0xAD},
    {0x9F,0xAE}, {0x9F,0xAF}, {0x9F,0xB0}, {0x9F,0xB1},
    {0x9F,0xB2}, {0x9F,0xB3}, {0x9F,0xB4}, {0x9F,0xB5},
    {0x9F,0xB6}, {0x9F,0xB7}, {0x9F,0xB8}, {0x9F,0xB9},
    {0x9F,0xBA}, {0x9F,0xBB}, {0x9F,0xBC}, {0x9F,0xBD},
    {0x9F,0xBE}, {0x9F,0xBF}, {0x9F,0xC0}, {0x9F,0xC1},
    {0x9F,0xC2}, {0x9F,0xC3}, {0x9F,0xC4}, {0x9F,0xC5},
    {0x9F,0xC6}, {0x9F,0xC7}, {0x9F,0xC8}, {0x9F,0xC9},
    {0x9F,0xCA}, {0xB9,0xB0}, {0x9F,0xCC}, {0x9F,0xCD},
    {0x9F,0xCE}, {0x9F,0xCF}, {0x9F,0xD0}, {0x9F,0xD1},
    {0x9F,0xD2}, {0x9F,0xD3}, {0x9F,0xD4}, {0x9F,0xD5},
    {0x9F,0xD6}, {0x9F,0xD7}, {0x93,0x61}, {0x9F,0xD9},
    {0x9F,0xDA}, {0x9F,0xDB}, {0x9F,0xDC}, {0x9F,0xDD},
    {0x9F,0xDE}, {0x9F,0xDF}, {0x9F,0xE0}, {0x9F,0xE1},
    {0x9F,0xE2}, {0x9F,0xE3}, {0x9F,0xE4}, {0x9F,0xE5},
    {0x9F,0xE6}, {0x9F,0xE7}, {0x9F,0xE8}, {0x9F,0xE9},
    {0x9F,0xEA}, {0x9F,0xEB}, {0x9F,0xEC}, {0x9F,0xED},
    {0x9F,0xEE}, {0x9F,0xEF}, {0x9F,0xF0}, {0x9F,0xF1},
    {0x9F,0xF2}, {0x9F,0xF3}, {0x9F,0xF4}, {0x9F,0xF5},
    {0x9F,0xF6}, {0x9F,0xF7}, {0x9F,0xF8}, {0x9F,0xF9},
    {0x9F,0xFA}, {0x9F,0xFB}, {0x9F,0xFC}, {0x9F,0xFD},
    {0x9F,0xFE}, {0xA0,0x40}, {0xA0,0x41}, {0xA0,0x42},
    {0xA0,0x43}, {0xA0,0x44}, {0xA0,0x45}, {0xA0,0x46},
    {0xA0,0x47}, {0xA0,0x48}, {0xA0,0x49}, {0xA0,0x4A},
    {0xA0,0x4B}, {0xA0,0x4C}, {0xA0,0x4D}, {0xA0,0x4E},
    {0xA0,0x4F}, {0xA0,0x50}, {0xA0,0x51}, {0xA0,0x52},
    {0xA0,0x53}, {0xA0,0x54}, {0xA0,0x55}, {0xA0,0x56},
    {0xA0,0x57}, {0xA0,0x58}, {0xA0,0x59}, {0xA0,0x5A},
    {0xA0,0x5B}, {0xA0,0x5C}, {0xA0,0x5D}, {0xA0,0x5E},
    {0xA0,0x5F}, {0xA0,0x60}, {0xA0,0x61}, {0xA0,0x62},
    {0x8F,0xB6}, {0xA0,0x64}, {0xA0,0x65}, {0xA0,0x66},
    {0xA0,0x67}, {0xA0,0x68}, {0xA0,0x69}, {0xA0,0x6A},
    {0xA0,0x6B}, {0xA0,0x6C}, {0xA0,0x6D}, {0xA0,0x6E},
    {0xA0,0x6F}, {0xA0,0x70}, {0xA0,0x71}, {0xA0,0x72},
    {0xA0,0x73}, {0xA0,0x74}, {0xA0,0x75}, {0xA0,0x76},
    {0xA9,0xF0}, {0xA0,0x78}, {0xA0,0x79}, {0xA0,0x7A},
    {0xA0,0x7B}, {0xA0,0x7C}, {0xA0,0x7D}, {0xA0,0x7E},
    {0xA0,0xA1}, {0xA0,0xA2}, {0xA0,0xA3}, {0xA0,0xA4},
    {0xA0,0xA5}, {0xA0,0xA6}, {0xA0,0xA7}, {0xA0,0xA8},
    {0xA0,0xA9}, {0xA0,0xAA}, {0xA0,0xAB}, {0xA0,0xAC},
    {0xA0,0xAD}, {0xA0,0xAE}, {0xA0,0xAF}, {0xA0,0xB0},
    {0xA0,0xB1}, {0xA0,0xB2}, {0xA0,0xB3}, {0xA0,0xB4},
    {0xA0,0xB5}, {0xA0,0xB6}, {0xA0,0xB7}, {0xA0,0xB8},
    {0xA0,0xB9}, {0xA0,0xBA}, {0xA0,0xBB}, {0xA0,0xBC},
    {0xA0,0xBD}, {0xA0,0xBE}, {0xA0,0xBF}, {0xA0,0xC0},
    {0xA0,0xC1}, {0xA0,0xC2}, {0xA0,0xC3}, {0xA0,0xC4},
    {0xA0,0xC5}, {0xA0,0xC6}, {0xA0,0xC7}, {0xA0,0xC8},
    {0xA0,0xC9}, {0xA0,0xCA}, {0xA0,0xCB}, {0xA0,0xCC},
    {0xA0,0xCD}, {0xA0,0xCE}, {0xA0,0xCF}, {0xA0,0xD0},
    {0xA0,0xD1}, {0xA0,0xD2}, {0xA0,0xD3}, {0xA0,0xD4},
    {0x94,0x7A}, {0xA0,0xD6}, {0xA0,0xD7}, {0xA0,0xD8},
    {0xA0,0xD9}, {0xA0,0xDA}, {0xA0,0xDB}, {0xA0,0xDC},
    {0xA0,0xDD}, {0xA0,0xDE}, {0xDE,0x72}, {0xA0,0xE0},
    {0xA0,0xE1}, {0xA0,0xE2}, {0xA0,0xE3}, {0x94,0x55},
    {0xA0,0xE5}, {0xA0,0xE6}, {0xA0,0xE7}, {0xA0,0xE8},
    {0xA0,0xE9}, {0xA0,0xEA}, {0xA0,0xEB}, {0xA0,0xEC},
    {0xA0,0xED}, {0xA0,0xEE}, {0xA0,0xEF}, {0xA0,0xF0},
    {0xA0,0xF1}, {0xA0,0xF2}, {0xA0,0xF3}, {0xA0,0xF4},
    {0xA0,0xF5}, {0xA0,0xF6}, {0xA0,0xF7}, {0xA0,0xF8},
    {0xA0,0xF9}, {0xA0,0xFA}, {0xA0,0xFB}, {0xA0,0xFC},
    {0xA0,0xFD}, {0xA0,0xFE}, {0x81,0x40}, {0x81,0x41},
    {0x81,0x42}, {0x81,0x43}, {0x81,0x44}, {0x81,0x45},
    {0x81,0x46}, {0x81,0x47}, {0x81,0x48}, {0x81,0x49},
    {0x81,0x4A}, {0x81,0x4B}, {0x81,0x4C}, {0x81,0x4D},
    {0x81,0x4E}, {0x81,0x4F}, {0x81,0x50}, {0x81,0x51},
    {0x81,0x52}, {0x81,0x53}, {0x81,0x54}, {0x81,0x55},
    {0x81,0x56}, {0x81,0x57}, {0x81,0x58}, {0x81,0x59},
    {0x81,0x5A}, {0x81,0x5B}, {0x81,0x5C}, {0x81,0x5D},
    {0x81,0x5E}, {0x81,0x5F}, {0x81,0x60}, {0x81,0x61},
    {0x81,0x62}, {0x81,0x63}, {0x81,0x64}, {0x81,0x65},
    {0x81,0x66}, {0x81,0x67}, {0x81,0x68}, {0x81,0x69},
    {0x81,0x6A}, {0x81,0x6B}, {0x81,0x6C}, {0x81,0x6D},
    {0x81,0x6E}, {0x81,0x6F}, {0x81,0x70}, {0x81,0x71},
    {0x81,0x72}, {0x81,0x73}, {0x81,0x74}, {0x81,0x75},
    {0x81,0x76}, {0x81,0x77}, {0x81,0x78}, {0x81,0x79},
    {0x81,0x7A}, {0x81,0x7B}, {0x81,0x7C}, {0x81,0x7D},
    {0x81,0x7E}, {0x81,0xA1}, {0x81,0xA2}, {0x81,0xA3},
    {0x81,0xA4}, {0x81,0xA5}, {0x81,0xA6}, {0x81,0xA7},
    {0x81,0xA8}, {0x81,0xA9}, {0x81,0xAA}, {0x81,0xAB},
    {0x81,0xAC}, {0x81,0xAD}, {0x81,0xAE}, {0x81,0xAF},
    {0x81,0xB0}, {0x81,0xB1}, {0x81,0xB2}, {0x81,0xB3},
    {0x81,0xB4}, {0x81,0xB5}, {0x81,0xB6}, {0x81,0xB7},
    {0x81,0xB8}, {0x81,0xB9}, {0x81,0xBA}, {0x81,0xBB},
    {0x81,0xBC}, {0x81,0xBD}, {0x81,0xBE}, {0x81,0xBF},
    {0x81,0xC0}, {0x81,0xC1}, {0x81,0xC2}, {0x81,0xC3},
    {0x81,0xC4}, {0x81,0xC5}, {0x81,0xC6}, {0x81,0xC7},
    {0x81,0xC8}, {0x81,0xC9}, {0x81,0xCA}, {0x81,0xCB},
    {0x81,0xCC}, {0x81,0xCD}, {0x81,0xCE}, {0x81,0xCF},
    {0x81,0xD0}, {0x81,0xD1}, {0x81,0xD2}, {0x81,0xD3},
    {0x81,0xD4}, {0x81,0xD5}, {0x81,0xD6}, {0x81,0xD7},
    {0x81,0xD8}, {0x81,0xD9}, {0x81,0xDA}, {0x81,0xDB},
    {0x81,0xDC}, {0x81,0xDD}, {0x81,0xDE}, {0x81,0xDF},
    {0x81,0xE0}, {0x81,0xE1}, {0x81,0xE2}, {0x81,0xE3},
    {0x81,0xE4}, {0x81,0xE5}, {0x81,0xE6}, {0x81,0xE7},
    {0x81,0xE8}, {0x81,0xE9}, {0x81,0xEA}, {0x81,0xEB},
    {0x81,0xEC}, {0x81,0xED}, {0x81,0xEE}, {0x81,0xEF},
    {0x81,0xF0}, {0x81,0xF1}, {0x81,0xF2}, {0x81,0xF3},
    {0x81,0xF4}, {0x81,0xF5}, {0x81,0xF6}, {0x81,0xF7},
    {0x81,0xF8}, {0x81,0xF9}, {0x81,0xFA}, {0x81,0xFB},
    {0x81,0xFC}, {0x81,0xFD}, {0x81,0xFE}, {0x82,0x40},
    {0x82,0x41}, {0x82,0x42}, {0x82,0x43}, {0x82,0x44},
    {0x82,0x45}, {0x82,0x46}, {0x82,0x47}, {0x82,0x48},
    {0x82,0x49}, {0x82,0x4A}, {0x82,0x4B}, {0x82,0x4C},
    {0x82,0x4D}, {0x82,0x4E}, {0x82,0x4F}, {0x82,0x50},
    {0x82,0x51}, {0x82,0x52}, {0x82,0x53}, {0x82,0x54},
    {0x82,0x55}, {0x82,0x56}, {0x82,0x57}, {0x82,0x58},
    {0x82,0x59}, {0x82,0x5A}, {0x82,0x5B}, {0x82,0x5C},
    {0x82,0x5D}, {0x82,0x5E}, {0x82,0x5F}, {0x82,0x60},
    {0x82,0x61}, {0x82,0x62}, {0x82,0x63}, {0x82,0x64},
    {0x82,0x65}, {0x82,0x66}, {0x82,0x67}, {0x82,0x68},
    {0x82,0x69}, {0x82,0x6A}, {0x82,0x6B}, {0x82,0x6C},
    {0x82,0x6D}, {0x82,0x6E}, {0x82,0x6F}, {0x82,0x70},
    {0x82,0x71}, {0x82,0x72}, {0x82,0x73}, {0x82,0x74},
    {0x82,0x75}, {0x82,0x76}, {0x82,0x77}, {0x82,0x78},
    {0x82,0x79}, {0x82,0x7A}, {0x82,0x7B}, {0x82,0x7C},
    {0x82,0x7D}, {0x82,0x7E}, {0x82,0xA1}, {0x82,0xA2},
    {0x82,0xA3}, {0x82,0xA4}, {0x82,0xA5}, {0x82,0xA6},
    {0x82,0xA7}, {0x82,0xA8}, {0x82,0xA9}, {0x82,0xAA},
    {0x82,0xAB}, {0x82,0xAC}, {0x82,0xAD}, {0x82,0xAE},
    {0x82,0xAF}, {0x82,0xB0}, {0x82,0xB1}, {0x82,0xB2},
    {0x82,0xB3}, {0x82,0xB4}, {0x82,0xB5}, {0x82,0xB6},
    {0x82,0xB7}, {0x82,0xB8}, {0x82,0xB9}, {0x82,0xBA},
    {0x82,0xBB}, {0x82,0xBC}, {0x82,0xBD}, {0x82,0xBE},
    {0x82,0xBF}, {0x82,0xC0}, {0x82,0xC1}, {0x82,0xC2},
    {0x82,0xC3}, {0x82,0xC4}, {0x82,0xC5}, {0x82,0xC6},
    {0x82,0xC7}, {0x82,0xC8}, {0x82,0xC9}, {0x82,0xCA},
    {0x82,0xCB}, {0x82,0xCC}, {0x82,0xCD}, {0x82,0xCE},
    {0x82,0xCF}, {0x82,0xD0}, {0x82,0xD1}, {0x82,0xD2},
    {0x82,0xD3}, {0x82,0xD4}, {0x82,0xD5}, {0x82,0xD6},
    {0x82,0xD7}, {0x82,0xD8}, {0x82,0xD9}, {0x82,0xDA},
    {0x82,0xDB}, {0x82,0xDC}, {0x82,0xDD}, {0x82,0xDE},
    {0x82,0xDF}, {0x82,0xE0}, {0x82,0xE1}, {0x82,0xE2},
    {0x82,0xE3}, {0x82,0xE4}, {0x82,0xE5}, {0x82,0xE6},
    {0x82,0xE7}, {0x82,0xE8}, {0x82,0xE9}, {0x82,0xEA},
    {0x82,0xEB}, {0x82,0xEC}, {0x82,0xED}, {0x82,0xEE},
    {0x82,0xEF}, {0x82,0xF0}, {0x82,0xF1}, {0x82,0xF2},
    {0x82,0xF3}, {0x82,0xF4}, {0x82,0xF5}, {0x82,0xF6},
    {0x82,0xF7}, {0x82,0xF8}, {0x82,0xF9}, {0x82,0xFA},
    {0x82,0xFB}, {0x82,0xFC}, {0x82,0xFD}, {0x82,0xFE},
    {0x83,0x40}, {0x83,0x41}, {0x83,0x42}, {0x83,0x43},
    {0x83,0x44}, {0x83,0x45}, {0x83,0x46}, {0x83,0x47},
    {0x83,0x48}, {0x83,0x49}, {0x83,0x4A}, {0x83,0x4B},
    {0x83,0x4C}, {0x83,0x4D}, {0x83,0x4E}, {0x83,0x4F},
    {0x83,0x50}, {0x83,0x51}, {0x83,0x52}, {0x83,0x53},
    {0x83,0x54}, {0x83,0x55}, {0x83,0x56}, {0x83,0x57},
    {0x83,0x58}, {0x83,0x59}, {0x83,0x5A}, {0x83,0x5B},
    {0x83,0x5C}, {0x83,0x5D}, {0x83,0x5E}, {0x83,0x5F},
    {0x83,0x60}, {0x83,0x61}, {0x83,0x62}, {0x83,0x63},
    {0x83,0x64}, {0x83,0x65}, {0x83,0x66}, {0x83,0x67},
    {0x83,0x68}, {0x83,0x69}, {0x83,0x6A}, {0x83,0x6B},
    {0x83,0x6C}, {0x83,0x6D}, {0x83,0x6E}, {0x83,0x6F},
    {0x83,0x70}, {0x83,0x71}, {0x83,0x72}, {0x83,0x73},
    {0x83,0x74}, {0x83,0x75}, {0x83,0x76}, {0x83,0x77},
    {0x83,0x78}, {0x83,0x79}, {0x83,0x7A}, {0x83,0x7B},
    {0x83,0x7C}, {0x83,0x7D}, {0x83,0x7E}, {0x83,0xA1},
    {0x83,0xA2}, {0x83,0xA3}, {0x83,0xA4}, {0x83,0xA5},
    {0x83,0xA6}, {0x83,0xA7}, {0x83,0xA8}, {0x83,0xA9},
    {0x83,0xAA}, {0x83,0xAB}, {0x83,0xAC}, {0x83,0xAD},
    {0x83,0xAE}, {0x83,0xAF}, {0x83,0xB0}, {0x83,0xB1},
    {0x83,0xB2}, {0x83,0xB3}, {0x83,0xB4}, {0x83,0xB5},
    {0x83,0xB6}, {0x83,0xB7}, {0x83,0xB8}, {0x83,0xB9},
    {0x83,0xBA}, {0x83,0xBB}, {0x83,0xBC}, {0x83,0xBD},
    {0x83,0xBE}, {0x83,0xBF}, {0x83,0xC0}, {0x83,0xC1},
    {0x83,0xC2}, {0x83,0xC3}, {0x83,0xC4}, {0x83,0xC5},
    {0x83,0xC6}, {0x83,0xC7}, {0x83,0xC8}, {0x83,0xC9},
    {0x83,0xCA}, {0x83,0xCB}, {0x83,0xCC}, {0x83,0xCD},
    {0x83,0xCE}, {0x83,0xCF}, {0x83,0xD0}, {0x83,0xD1},
    {0x83,0xD2}, {0x83,0xD3}, {0x83,0xD4}, {0x83,0xD5},
    {0x83,0xD6}, {0x83,0xD7}, {0x83,0xD8}, {0x83,0xD9},
    {0x83,0xDA}, {0x83,0xDB}, {0x83,0xDC}, {0x83,0xDD},
    {0x83,0xDE}, {0x83,0xDF}, {0x83,0xE0}, {0x83,0xE1},
    {0x83,0xE2}, {0x83,0xE3}, {0x83,0xE4}, {0x83,0xE5},
    {0x83,0xE6}, {0x83,0xE7}, {0x83,0xE8}, {0x83,0xE9},
    {0x83,0xEA}, {0x83,0xEB}, {0x83,0xEC}, {0x83,0xED},
    {0x83,0xEE}, {0x83,0xEF}, {0x83,0xF0}, {0x83,0xF1},
    {0x83,0xF2}, {0x83,0xF3}, {0x83,0xF4}, {0x83,0xF5},
    {0x83,0xF6}, {0x83,0xF7}, {0x83,0xF8}, {0x83,0xF9},
    {0x83,0xFA}, {0x83,0xFB}, {0x83,0xFC}, {0x83,0xFD},
    {0x83,0xFE}, {0x84,0x40}, {0x84,0x41}, {0x84,0x42},
    {0x84,0x43}, {0x84,0x44}, {0x84,0x45}, {0x84,0x46},
    {0x84,0x47}, {0x84,0x48}, {0x84,0x49}, {0x84,0x4A},
    {0x84,0x4B}, {0x84,0x4C}, {0x84,0x4D}, {0x84,0x4E},
    {0x84,0x4F}, {0x84,0x50}, {0x84,0x51}, {0x84,0x52},
    {0x84,0x53}, {0x84,0x54}, {0x84,0x55}, {0x84,0x56},
    {0x84,0x57}, {0x84,0x58}, {0x84,0x59}, {0x84,0x5A},
    {0x84,0x5B}, {0x84,0x5C}, {0x84,0x5D}, {0x84,0x5E},
    {0x84,0x5F}, {0x84,0x60}, {0x84,0x61}, {0x84,0x62},
    {0x84,0x63}, {0x84,0x64}, {0x84,0x65}, {0x84,0x66},
    {0x84,0x67}, {0x84,0x68}, {0x84,0x69}, {0x84,0x6A},
    {0x84,0x6B}, {0x84,0x6C}, {0x84,0x6D}, {0x84,0x6E},
    {0x84,0x6F}, {0x84,0x70}, {0x84,0x71}, {0x84,0x72},
    {0x84,0x73}, {0x84,0x74}, {0x84,0x75}, {0x84,0x76},
    {0x84,0x77}, {0x84,0x78}, {0x84,0x79}, {0x84,0x7A},
    {0x84,0x7B}, {0x84,0x7C}, {0x84,0x7D}, {0x84,0x7E},
    {0x84,0xA1}, {0x84,0xA2}, {0x84,0xA3}, {0x84,0xA4},
    {0x84,0xA5}, {0x84,0xA6}, {0x84,0xA7}, {0x84,0xA8},
    {0x84,0xA9}, {0x84,0xAA}, {0x84,0xAB}, {0x84,0xAC},
    {0x84,0xAD}, {0x84,0xAE}, {0x84,0xAF}, {0x84,0xB0},
    {0x84,0xB1}, {0x84,0xB2}, {0x84,0xB3}, {0x84,0xB4},
    {0x84,0xB5}, {0x84,0xB6}, {0x84,0xB7}, {0x84,0xB8},
    {0x84,0xB9}, {0x84,0xBA}, {0x84,0xBB}, {0x84,0xBC},
    {0x84,0xBD}, {0x84,0xBE}, {0x84,0xBF}, {0x84,0xC0},
    {0x84,0xC1}, {0x84,0xC2}, {0x84,0xC3}, {0x84,0xC4},
    {0x84,0xC5}, {0x84,0xC6}, {0x84,0xC7}, {0x84,0xC8},
    {0x84,0xC9}, {0x84,0xCA}, {0x84,0xCB}, {0x84,0xCC},
    {0x84,0xCD}, {0x84,0xCE}, {0x84,0xCF}, {0x84,0xD0},
    {0x84,0xD1}, {0x84,0xD2}, {0x84,0xD3}, {0x84,0xD4},
    {0x84,0xD5}, {0x84,0xD6}, {0x84,0xD7}, {0x84,0xD8},
    {0x84,0xD9}, {0x84,0xDA}, {0x84,0xDB}, {0x84,0xDC},
    {0x84,0xDD}, {0x84,0xDE}, {0x84,0xDF}, {0x84,0xE0},
    {0x84,0xE1}, {0x84,0xE2}, {0x84,0xE3}, {0x84,0xE4},
    {0x84,0xE5}, {0x84,0xE6}, {0x84,0xE7}, {0x84,0xE8},
    {0x84,0xE9}, {0x84,0xEA}, {0x84,0xEB}, {0x84,0xEC},
    {0x84,0xED}, {0x84,0xEE}, {0x84,0xEF}, {0x84,0xF0},
    {0x84,0xF1}, {0x84,0xF2}, {0x84,0xF3}, {0x84,0xF4},
    {0x84,0xF5}, {0x84,0xF6}, {0x84,0xF7}, {0x84,0xF8},
    {0x84,0xF9}, {0x84,0xFA}, {0x84,0xFB}, {0x84,0xFC},
    {0x84,0xFD}, {0x84,0xFE}, {0x85,0x40}, {0x85,0x41},
    {0x85,0x42}, {0x85,0x43}, {0x85,0x44}, {0x85,0x45},
    {0x85,0x46}, {0x85,0x47}, {0x85,0x48}, {0x85,0x49},
    {0x85,0x4A}, {0x85,0x4B}, {0x85,0x4C}, {0x85,0x4D},
    {0x85,0x4E}, {0x85,0x4F}, {0x85,0x50}, {0x85,0x51},
    {0x85,0x52}, {0x85,0x53}, {0x85,0x54}, {0x85,0x55},
    {0x85,0x56}, {0x85,0x57}, {0x85,0x58}, {0x85,0x59},
    {0x85,0x5A}, {0x85,0x5B}, {0x85,0x5C}, {0x85,0x5D},
    {0x85,0x5E}, {0x85,0x5F}, {0x85,0x60}, {0x85,0x61},
    {0x85,0x62}, {0x85,0x63}, {0x85,0x64}, {0x85,0x65},
    {0x85,0x66}, {0x85,0x67}, {0x85,0x68}, {0x85,0x69},
    {0x85,0x6A}, {0x85,0x6B}, {0x85,0x6C}, {0x85,0x6D},
    {0x85,0x6E}, {0x85,0x6F}, {0x85,0x70}, {0x85,0x71},
    {0x85,0x72}, {0x85,0x73}, {0x85,0x74}, {0x85,0x75},
    {0x85,0x76}, {0x85,0x77}, {0x85,0x78}, {0x85,0x79},
    {0x85,0x7A}, {0x85,0x7B}, {0x85,0x7C}, {0x85,0x7D},
    {0x85,0x7E}, {0x85,0xA1}, {0x85,0xA2}, {0x85,0xA3},
    {0x85,0xA4}, {0x85,0xA5}, {0x85,0xA6}, {0x85,0xA7},
    {0x85,0xA8}, {0x85,0xA9}, {0x85,0xAA}, {0x85,0xAB},
    {0x85,0xAC}, {0x85,0xAD}, {0x85,0xAE}, {0x85,0xAF},
    {0x85,0xB0}, {0x85,0xB1}, {0x85,0xB2}, {0x85,0xB3},
    {0x85,0xB4}, {0x85,0xB5}, {0x85,0xB6}, {0x85,0xB7},
    {0x85,0xB8}, {0x85,0xB9}, {0x85,0xBA}, {0x85,0xBB},
    {0x85,0xBC}, {0x85,0xBD}, {0x85,0xBE}, {0x85,0xBF},
    {0x85,0xC0}, {0x85,0xC1}, {0x85,0xC2}, {0x85,0xC3},
    {0x85,0xC4}, {0x85,0xC5}, {0x85,0xC6}, {0x85,0xC7},
    {0x85,0xC8}, {0x85,0xC9}, {0x85,0xCA}, {0x85,0xCB},
    {0x85,0xCC}, {0x85,0xCD}, {0x85,0xCE}, {0x85,0xCF},
    {0x85,0xD0}, {0x85,0xD1}, {0x85,0xD2}, {0x85,0xD3},
    {0x85,0xD4}, {0x85,0xD5}, {0x85,0xD6}, {0x85,0xD7},
    {0x85,0xD8}, {0x85,0xD9}, {0x85,0xDA}, {0x85,0xDB},
    {0x85,0xDC}, {0x85,0xDD}, {0x85,0xDE}, {0x85,0xDF},
    {0x85,0xE0}, {0x85,0xE1}, {0x85,0xE2}, {0x85,0xE3},
    {0x85,0xE4}, {0x85,0xE5}, {0x85,0xE6}, {0x85,0xE7},
    {0x85,0xE8}, {0x85,0xE9}, {0x85,0xEA}, {0x85,0xEB},
    {0x85,0xEC}, {0x85,0xED}, {0x85,0xEE}, {0x85,0xEF},
    {0x85,0xF0}, {0x85,0xF1}, {0x85,0xF2}, {0x85,0xF3},
    {0x85,0xF4}, {0x85,0xF5}, {0x85,0xF6}, {0x85,0xF7},
    {0x85,0xF8}, {0x85,0xF9}, {0x85,0xFA}, {0x85,0xFB},
    {0x85,0xFC}, {0x85,0xFD}, {0x85,0xFE}, {0x86,0x40},
    {0x86,0x41}, {0x86,0x42}, {0x86,0x43}, {0x86,0x44},
    {0x86,0x45}, {0x86,0x46}, {0x86,0x47}, {0x86,0x48},
    {0x86,0x49}, {0x86,0x4A}, {0x86,0x4B}, {0x86,0x4C},
    {0x86,0x4D}, {0x86,0x4E}, {0x86,0x4F}, {0x86,0x50},
    {0x86,0x51}, {0x86,0x52}, {0x86,0x53}, {0x86,0x54},
    {0x86,0x55}, {0x86,0x56}, {0x86,0x57}, {0x86,0x58},
    {0x86,0x59}, {0x86,0x5A}, {0x86,0x5B}, {0x86,0x5C},
    {0x86,0x5D}, {0x86,0x5E}, {0x86,0x5F}, {0x86,0x60},
    {0x86,0x61}, {0x86,0x62}, {0x86,0x63}, {0x86,0x64},
    {0x86,0x65}, {0x86,0x66}, {0x86,0x67}, {0x86,0x68},
    {0x86,0x69}, {0x86,0x6A}, {0x86,0x6B}, {0x86,0x6C},
    {0x86,0x6D}, {0x86,0x6E}, {0x86,0x6F}, {0x86,0x70},
    {0x86,0x71}, {0x86,0x72}, {0x86,0x73}, {0x86,0x74},
    {0x86,0x75}, {0x86,0x76}, {0x86,0x77}, {0x86,0x78},
    {0x86,0x79}, {0x86,0x7A}, {0x86,0x7B}, {0x86,0x7C},
    {0x86,0x7D}, {0x86,0x7E}, {0x86,0xA1}, {0x86,0xA2},
    {0x86,0xA3}, {0x86,0xA4}, {0x86,0xA5}, {0x86,0xA6},
    {0x86,0xA7}, {0x86,0xA8}, {0x86,0xA9}, {0x86,0xAA},
    {0x86,0xAB}, {0x86,0xAC}, {0x86,0xAD}, {0x86,0xAE},
    {0x86,0xAF}, {0x86,0xB0}, {0x86,0xB1}, {0x86,0xB2},
    {0x86,0xB3}, {0x86,0xB4}, {0x86,0xB5}, {0x86,0xB6},
    {0x86,0xB7}, {0x86,0xB8}, {0x86,0xB9}, {0x86,0xBA},
    {0x86,0xBB}, {0x86,0xBC}, {0x86,0xBD}, {0x86,0xBE},
    {0x86,0xBF}, {0x86,0xC0}, {0x86,0xC1}, {0x86,0xC2},
    {0x86,0xC3}, {0x86,0xC4}, {0x86,0xC5}, {0x86,0xC6},
    {0x86,0xC7}, {0x86,0xC8}, {0x86,0xC9}, {0x86,0xCA},
    {0x86,0xCB}, {0x86,0xCC}, {0x86,0xCD}, {0x86,0xCE},
    {0x86,0xCF}, {0x86,0xD0}, {0x86,0xD1}, {0x86,0xD2},
    {0x86,0xD3}, {0x86,0xD4}, {0x86,0xD5}, {0x86,0xD6},
    {0x86,0xD7}, {0x86,0xD8}, {0x86,0xD9}, {0x86,0xDA},
    {0x86,0xDB}, {0x86,0xDC}, {0x86,0xDD}, {0x86,0xDE},
    {0x86,0xDF}, {0x86,0xE0}, {0x86,0xE1}, {0x86,0xE2},
    {0x86,0xE3}, {0x86,0xE4}, {0x86,0xE5}, {0x86,0xE6},
    {0x86,0xE7}, {0x86,0xE8}, {0x86,0xE9}, {0x86,0xEA},
    {0x86,0xEB}, {0x86,0xEC}, {0x86,0xED}, {0x86,0xEE},
    {0x86,0xEF}, {0x86,0xF0}, {0x86,0xF1}, {0x86,0xF2},
    {0x86,0xF3}, {0x86,0xF4}, {0x86,0xF5}, {0x86,0xF6},
    {0x86,0xF7}, {0x86,0xF8}, {0x86,0xF9}, {0x86,0xFA},
    {0x86,0xFB}, {0x86,0xFC}, {0x86,0xFD}, {0x86,0xFE},
    {0x87,0x40}, {0x87,0x41}, {0x87,0x42}, {0x87,0x43},
    {0x87,0x44}, {0x87,0x45}, {0x87,0x46}, {0x87,0x47},
    {0x87,0x48}, {0x87,0x49}, {0x87,0x4A}, {0x87,0x4B},
    {0x87,0x4C}, {0x87,0x4D}, {0x87,0x4E}, {0x87,0x4F},
    {0x87,0x50}, {0x87,0x51}, {0x87,0x52}, {0x87,0x53},
    {0x87,0x54}, {0x87,0x55}, {0x87,0x56}, {0x87,0x57},
    {0x87,0x58}, {0x87,0x59}, {0x87,0x5A}, {0x87,0x5B},
    {0x87,0x5C}, {0x87,0x5D}, {0x87,0x5E}, {0x87,0x5F},
    {0x87,0x60}, {0x87,0x61}, {0x87,0x62}, {0x87,0x63},
    {0x87,0x64}, {0x87,0x65}, {0x87,0x66}, {0x87,0x67},
    {0x87,0x68}, {0x87,0x69}, {0x87,0x6A}, {0x87,0x6B},
    {0x87,0x6C}, {0x87,0x6D}, {0x87,0x6E}, {0x87,0x6F},
    {0x87,0x70}, {0x87,0x71}, {0x87,0x72}, {0x87,0x73},
    {0x87,0x74}, {0x87,0x75}, {0x87,0x76}, {0x87,0x77},
    {0x87,0x78}, {0x87,0x79}, {0x87,0x7A}, {0x87,0x7B},
    {0x87,0x7C}, {0x87,0x7D}, {0x87,0x7E}, {0x87,0xA1},
    {0x87,0xA2}, {0x87,0xA3}, {0x87,0xA4}, {0x87,0xA5},
    {0x87,0xA6}, {0x87,0xA7}, {0x87,0xA8}, {0x87,0xA9},
    {0x87,0xAA}, {0x87,0xAB}, {0x87,0xAC}, {0x87,0xAD},
    {0x87,0xAE}, {0x87,0xAF}, {0x87,0xB0}, {0x87,0xB1},
    {0x87,0xB2}, {0x87,0xB3}, {0x87,0xB4}, {0x87,0xB5},
    {0x87,0xB6}, {0x87,0xB7}, {0x87,0xB8}, {0x87,0xB9},
    {0x87,0xBA}, {0x87,0xBB}, {0x87,0xBC}, {0x87,0xBD},
    {0x87,0xBE}, {0x87,0xBF}, {0x87,0xC0}, {0x87,0xC1},
    {0x87,0xC2}, {0x87,0xC3}, {0x87,0xC4}, {0x87,0xC5},
    {0x87,0xC6}, {0x87,0xC7}, {0x87,0xC8}, {0x87,0xC9},
    {0x87,0xCA}, {0x87,0xCB}, {0x87,0xCC}, {0x87,0xCD},
    {0x87,0xCE}, {0x87,0xCF}, {0x87,0xD0}, {0x87,0xD1},
    {0x87,0xD2}, {0x87,0xD3}, {0x87,0xD4}, {0x87,0xD5},
    {0x87,0xD6}, {0x87,0xD7}, {0x87,0xD8}, {0x87,0xD9},
    {0x87,0xDA}, {0x87,0xDB}, {0x87,0xDC}, {0x87,0xDD},
    {0x87,0xDE}, {0x87,0xDF}, {0x87,0xE0}, {0x87,0xE1},
    {0x87,0xE2}, {0x87,0xE3}, {0x87,0xE4}, {0x87,0xE5},
    {0x87,0xE6}, {0x87,0xE7}, {0x87,0xE8}, {0x87,0xE9},
    {0x87,0xEA}, {0x87,0xEB}, {0x87,0xEC}, {0x87,0xED},
    {0x87,0xEE}, {0x87,0xEF}, {0x87,0xF0}, {0x87,0xF1},
    {0x87,0xF2}, {0x87,0xF3}, {0x87,0xF4}, {0x87,0xF5},
    {0x87,0xF6}, {0x87,0xF7}, {0x87,0xF8}, {0x87,0xF9},
    {0x87,0xFA}, {0x87,0xFB}, {0x87,0xFC}, {0x87,0xFD},
    {0x87,0xFE}, {0x88,0x40}, {0x88,0x41}, {0x88,0x42},
    {0x88,0x43}, {0x88,0x44}, {0x88,0x45}, {0x88,0x46},
    {0x88,0x47}, {0x88,0x48}, {0x88,0x49}, {0x88,0x4A},
    {0x88,0x4B}, {0x88,0x4C}, {0x88,0x4D}, {0x88,0x4E},
    {0x88,0x4F}, {0x88,0x50}, {0x88,0x51}, {0x88,0x52},
    {0x88,0x53}, {0x88,0x54}, {0x88,0x55}, {0x88,0x56},
    {0x88,0x57}, {0x88,0x58}, {0x88,0x59}, {0x88,0x5A},
    {0x88,0x5B}, {0x88,0x5C}, {0x88,0x5D}, {0x88,0x5E},
    {0x88,0x5F}, {0x88,0x60}, {0x88,0x61}, {0x88,0x62},
    {0x88,0x63}, {0x88,0x64}, {0x88,0x65}, {0x88,0x66},
    {0x88,0x67}, {0x88,0x68}, {0x88,0x69}, {0x88,0x6A},
    {0x88,0x6B}, {0x88,0x6C}, {0x88,0x6D}, {0x88,0x6E},
    {0x88,0x6F}, {0x88,0x70}, {0x88,0x71}, {0x88,0x72},
    {0x88,0x73}, {0x88,0x74}, {0x88,0x75}, {0x88,0x76},
    {0x88,0x77}, {0x88,0x78}, {0x88,0x79}, {0x88,0x7A},
    {0x88,0x7B}, {0x88,0x7C}, {0x88,0x7D}, {0x88,0x7E},
    {0x88,0xA1}, {0x88,0xA2}, {0x88,0xA3}, {0x88,0xA4},
    {0x88,0xA5}, {0x88,0xA6}, {0x88,0xA7}, {0x88,0xA8},
    {0x88,0xA9}, {0x88,0xAA}, {0x88,0xAB}, {0x88,0xAC},
    {0x88,0xAD}, {0x88,0xAE}, {0x88,0xAF}, {0x88,0xB0},
    {0x88,0xB1}, {0x88,0xB2}, {0x88,0xB3}, {0x88,0xB4},
    {0x88,0xB5}, {0x88,0xB6}, {0x88,0xB7}, {0x88,0xB8},
    {0x88,0xB9}, {0x88,0xBA}, {0x88,0xBB}, {0x88,0xBC},
    {0x88,0xBD}, {0x88,0xBE}, {0x88,0xBF}, {0x88,0xC0},
    {0x88,0xC1}, {0x88,0xC2}, {0x88,0xC3}, {0x88,0xC4},
    {0x88,0xC5}, {0x88,0xC6}, {0x88,0xC7}, {0x88,0xC8},
    {0x88,0xC9}, {0x88,0xCA}, {0x88,0xCB}, {0x88,0xCC},
    {0x88,0xCD}, {0x88,0xCE}, {0x88,0xCF}, {0x88,0xD0},
    {0x88,0xD1}, {0x88,0xD2}, {0x88,0xD3}, {0x88,0xD4},
    {0x88,0xD5}, {0x88,0xD6}, {0x88,0xD7}, {0x88,0xD8},
    {0x88,0xD9}, {0x88,0xDA}, {0x88,0xDB}, {0x88,0xDC},
    {0x88,0xDD}, {0x88,0xDE}, {0x88,0xDF}, {0x88,0xE0},
    {0x88,0xE1}, {0x88,0xE2}, {0x88,0xE3}, {0x88,0xE4},
    {0x88,0xE5}, {0x88,0xE6}, {0x88,0xE7}, {0x88,0xE8},
    {0x88,0xE9}, {0x88,0xEA}, {0x88,0xEB}, {0x88,0xEC},
    {0x88,0xED}, {0x88,0xEE}, {0x88,0xEF}, {0x88,0xF0},
    {0x88,0xF1}, {0x88,0xF2}, {0x88,0xF3}, {0x88,0xF4},
    {0x88,0xF5}, {0x88,0xF6}, {0x88,0xF7}, {0x88,0xF8},
    {0x88,0xF9}, {0x88,0xFA}, {0x88,0xFB}, {0x88,0xFC},
    {0x88,0xFD}, {0x88,0xFE}, {0x89,0x40}, {0x89,0x41},
    {0x89,0x42}, {0x89,0x43}, {0x89,0x44}, {0x89,0x45},
    {0x89,0x46}, {0x89,0x47}, {0x89,0x48}, {0x89,0x49},
    {0x89,0x4A}, {0x89,0x4B}, {0x89,0x4C}, {0x89,0x4D},
    {0x89,0x4E}, {0x89,0x4F}, {0x89,0x50}, {0x89,0x51},
    {0x89,0x52}, {0x89,0x53}, {0x89,0x54}, {0x89,0x55},
    {0x89,0x56}, {0x89,0x57}, {0x89,0x58}, {0x89,0x59},
    {0x89,0x5A}, {0x89,0x5B}, {0x89,0x5C}, {0x89,0x5D},
    {0x89,0x5E}, {0x89,0x5F}, {0x89,0x60}, {0x89,0x61},
    {0x89,0x62}, {0x89,0x63}, {0x89,0x64}, {0x89,0x65},
    {0x89,0x66}, {0x89,0x67}, {0x89,0x68}, {0x89,0x69},
    {0x89,0x6A}, {0x89,0x6B}, {0x89,0x6C}, {0x89,0x6D},
    {0x89,0x6E}, {0x89,0x6F}, {0x89,0x70}, {0x89,0x71},
    {0x89,0x72}, {0x89,0x73}, {0x89,0x74}, {0x89,0x75},
    {0x89,0x76}, {0x89,0x77}, {0x89,0x78}, {0x89,0x79},
    {0x89,0x7A}, {0x89,0x7B}, {0x89,0x7C}, {0x89,0x7D},
    {0x89,0x7E}, {0x89,0xA1}, {0x89,0xA2}, {0x89,0xA3},
    {0x89,0xA4}, {0x89,0xA5}, {0x89,0xA6}, {0x89,0xA7},
    {0x89,0xA8}, {0x89,0xA9}, {0x89,0xAA}, {0x89,0xAB},
    {0x89,0xAC}, {0x89,0xAD}, {0x89,0xAE}, {0x89,0xAF},
    {0x89,0xB0}, {0x89,0xB1}, {0x89,0xB2}, {0x89,0xB3},
    {0x89,0xB4}, {0x89,0xB5}, {0x89,0xB6}, {0x89,0xB7},
    {0x89,0xB8}, {0x89,0xB9}, {0x89,0xBA}, {0x89,0xBB},
    {0x89,0xBC}, {0x89,0xBD}, {0x89,0xBE}, {0x89,0xBF},
    {0x89,0xC0}, {0x89,0xC1}, {0x89,0xC2}, {0x89,0xC3},
    {0x89,0xC4}, {0x89,0xC5}, {0x89,0xC6}, {0x89,0xC7},
    {0x89,0xC8}, {0x89,0xC9}, {0x89,0xCA}, {0x89,0xCB},
    {0x89,0xCC}, {0x89,0xCD}, {0x89,0xCE}, {0x89,0xCF},
    {0x89,0xD0}, {0x89,0xD1}, {0x89,0xD2}, {0x89,0xD3},
    {0x89,0xD4}, {0x89,0xD5}, {0x89,0xD6}, {0x89,0xD7},
    {0x89,0xD8}, {0x89,0xD9}, {0x89,0xDA}, {0x89,0xDB},
    {0x89,0xDC}, {0x89,0xDD}, {0x89,0xDE}, {0x89,0xDF},
    {0x89,0xE0}, {0x89,0xE1}, {0x89,0xE2}, {0x89,0xE3},
    {0x89,0xE4}, {0x89,0xE5}, {0x89,0xE6}, {0x89,0xE7},
    {0x89,0xE8}, {0x89,0xE9}, {0x89,0xEA}, {0x89,0xEB},
    {0x89,0xEC}, {0x89,0xED}, {0x89,0xEE}, {0x89,0xEF},
    {0x89,0xF0}, {0x89,0xF1}, {0x89,0xF2}, {0x89,0xF3},
    {0x89,0xF4}, {0x89,0xF5}, {0x89,0xF6}, {0x89,0xF7},
    {0x89,0xF8}, {0x89,0xF9}, {0x89,0xFA}, {0x89,0xFB},
    {0x89,0xFC}, {0x89,0xFD}, {0x89,0xFE}, {0x8A,0x40},
    {0x8A,0x41}, {0x8A,0x42}, {0x8A,0x43}, {0x8A,0x44},
    {0x8A,0x45}, {0x8A,0x46}, {0x8A,0x47}, {0x8A,0x48},
    {0x8A,0x49}, {0x8A,0x4A}, {0x8A,0x4B}, {0x8A,0x4C},
    {0x8A,0x4D}, {0x8A,0x4E}, {0x8A,0x4F}, {0x8A,0x50},
    {0x8A,0x51}, {0x8A,0x52}, {0x8A,0x53}, {0x8A,0x54},
    {0x8A,0x55}, {0x8A,0x56}, {0x8A,0x57}, {0x8A,0x58},
    {0x8A,0x59}, {0x8A,0x5A}, {0x8A,0x5B}, {0x8A,0x5C},
    {0x8A,0x5D}, {0x8A,0x5E}, {0x8A,0x5F}, {0x8A,0x60},
    {0x8A,0x61}, {0x8A,0x62}, {0x8A,0x63}, {0x8A,0x64},
    {0x8A,0x65}, {0x8A,0x66}, {0x8A,0x67}, {0x8A,0x68},
    {0x8A,0x69}, {0x8A,0x6A}, {0x8A,0x6B}, {0x8A,0x6C},
    {0x8A,0x6D}, {0x8A,0x6E}, {0x8A,0x6F}, {0x8A,0x70},
    {0x8A,0x71}, {0x8A,0x72}, {0x8A,0x73}, {0x8A,0x74},
    {0x8A,0x75}, {0x8A,0x76}, {0x8A,0x77}, {0x8A,0x78},
    {0x8A,0x79}, {0x8A,0x7A}, {0x8A,0x7B}, {0x8A,0x7C},
    {0x8A,0x7D}, {0x8A,0x7E}, {0x8A,0xA1}, {0x8A,0xA2},
    {0x8A,0xA3}, {0x8A,0xA4}, {0x8A,0xA5}, {0x8A,0xA6},
    {0x8A,0xA7}, {0x8A,0xA8}, {0x8A,0xA9}, {0x8A,0xAA},
    {0x8A,0xAB}, {0x8A,0xAC}, {0x8A,0xAD}, {0x8A,0xAE},
    {0x8A,0xAF}, {0x8A,0xB0}, {0x8A,0xB1}, {0x8A,0xB2},
    {0x8A,0xB3}, {0x8A,0xB4}, {0x8A,0xB5}, {0x8A,0xB6},
    {0x8A,0xB7}, {0x8A,0xB8}, {0x8A,0xB9}, {0x8A,0xBA},
    {0x8A,0xBB}, {0x8A,0xBC}, {0x8A,0xBD}, {0x8A,0xBE},
    {0x8A,0xBF}, {0x8A,0xC0}, {0x8A,0xC1}, {0x8A,0xC2},
    {0x8A,0xC3}, {0x8A,0xC4}, {0x8A,0xC5}, {0x8A,0xC6},
    {0x8A,0xC7}, {0x8A,0xC8}, {0x8A,0xC9}, {0x8A,0xCA},
    {0x8A,0xCB}, {0x8A,0xCC}, {0x8A,0xCD}, {0x8A,0xCE},
    {0x8A,0xCF}, {0x8A,0xD0}, {0x8A,0xD1}, {0x8A,0xD2},
    {0x8A,0xD3}, {0x8A,0xD4}, {0x8A,0xD5}, {0x8A,0xD6},
    {0x8A,0xD7}, {0x8A,0xD8}, {0x8A,0xD9}, {0x8A,0xDA},
    {0x8A,0xDB}, {0x8A,0xDC}, {0x8A,0xDD}, {0x8A,0xDE},
    {0x8A,0xDF}, {0x8A,0xE0}, {0x8A,0xE1}, {0x8A,0xE2},
    {0x8A,0xE3}, {0x8A,0xE4}, {0x8A,0xE5}, {0x8A,0xE6},
    {0x8A,0xE7}, {0x8A,0xE8}, {0x8A,0xE9}, {0x8A,0xEA},
    {0x8A,0xEB}, {0x8A,0xEC}, {0x8A,0xED}, {0x8A,0xEE},
    {0x8A,0xEF}, {0x8A,0xF0}, {0x8A,0xF1}, {0x8A,0xF2},
    {0x8A,0xF3}, {0x8A,0xF4}, {0x8A,0xF5}, {0x8A,0xF6},
    {0x8A,0xF7}, {0x8A,0xF8}, {0x8A,0xF9}, {0x8A,0xFA},
    {0x8A,0xFB}, {0x8A,0xFC}, {0x8A,0xFD}, {0x8A,0xFE},
    {0x8B,0x40}, {0x8B,0x41}, {0x8B,0x42}, {0x8B,0x43},
    {0x8B,0x44}, {0x8B,0x45}, {0x8B,0x46}, {0x8B,0x47},
    {0x8B,0x48}, {0x8B,0x49}, {0x8B,0x4A}, {0x8B,0x4B},
    {0x8B,0x4C}, {0x8B,0x4D}, {0x8B,0x4E}, {0x8B,0x4F},
    {0x8B,0x50}, {0x8B,0x51}, {0x8B,0x52}, {0x8B,0x53},
    {0x8B,0x54}, {0x8B,0x55}, {0x8B,0x56}, {0x8B,0x57},
    {0x8B,0x58}, {0x8B,0x59}, {0x8B,0x5A}, {0x8B,0x5B},
    {0x8B,0x5C}, {0x8B,0x5D}, {0x8B,0x5E}, {0x8B,0x5F},
    {0x8B,0x60}, {0x8B,0x61}, {0x8B,0x62}, {0x8B,0x63},
    {0x8B,0x64}, {0x8B,0x65}, {0x8B,0x66}, {0x8B,0x67},
    {0x8B,0x68}, {0x8B,0x69}, {0x8B,0x6A}, {0x8B,0x6B},
    {0x8B,0x6C}, {0x8B,0x6D}, {0x8B,0x6E}, {0x8B,0x6F},
    {0x8B,0x70}, {0x8B,0x71}, {0x8B,0x72}, {0x8B,0x73},
    {0x8B,0x74}, {0x8B,0x75}, {0x8B,0x76}, {0x8B,0x77},
    {0x8B,0x78}, {0x8B,0x79}, {0x8B,0x7A}, {0x8B,0x7B},
    {0x8B,0x7C}, {0x8B,0x7D}, {0x8B,0x7E}, {0x8B,0xA1},
    {0x8B,0xA2}, {0x8B,0xA3}, {0x8B,0xA4}, {0x8B,0xA5},
    {0x8B,0xA6}, {0x8B,0xA7}, {0x8B,0xA8}, {0x8B,0xA9},
    {0x8B,0xAA}, {0x8B,0xAB}, {0x8B,0xAC}, {0x8B,0xAD},
    {0x8B,0xAE}, {0x8B,0xAF}, {0x8B,0xB0}, {0x8B,0xB1},
    {0x8B,0xB2}, {0x8B,0xB3}, {0x8B,0xB4}, {0x8B,0xB5},
    {0x8B,0xB6}, {0x8B,0xB7}, {0x8B,0xB8}, {0x8B,0xB9},
    {0x8B,0xBA}, {0x8B,0xBB}, {0x8B,0xBC}, {0x8B,0xBD},
    {0x8B,0xBE}, {0x8B,0xBF}, {0x8B,0xC0}, {0x8B,0xC1},
    {0x8B,0xC2}, {0x8B,0xC3}, {0x8B,0xC4}, {0x8B,0xC5},
    {0x8B,0xC6}, {0x8B,0xC7}, {0x8B,0xC8}, {0x8B,0xC9},
    {0x8B,0xCA}, {0x8B,0xCB}, {0x8B,0xCC}, {0x8B,0xCD},
    {0x8B,0xCE}, {0x8B,0xCF}, {0x8B,0xD0}, {0x8B,0xD1},
    {0x8B,0xD2}, {0x8B,0xD3}, {0x8B,0xD4}, {0x8B,0xD5},
    {0x8B,0xD6}, {0x8B,0xD7}, {0x8B,0xD8}, {0x8B,0xD9},
    {0x8B,0xDA}, {0x8B,0xDB}, {0x8B,0xDC}, {0x8B,0xDD},
    {0x8B,0xDE}, {0x8B,0xDF}, {0x8B,0xE0}, {0x8B,0xE1},
    {0x8B,0xE2}, {0x8B,0xE3}, {0x8B,0xE4}, {0x8B,0xE5},
    {0x8B,0xE6}, {0x8B,0xE7}, {0x8B,0xE8}, {0x8B,0xE9},
    {0x8B,0xEA}, {0x8B,0xEB}, {0x8B,0xEC}, {0x8B,0xED},
    {0x8B,0xEE}, {0x8B,0xEF}, {0x8B,0xF0}, {0x8B,0xF1},
    {0x8B,0xF2}, {0x8B,0xF3}, {0x8B,0xF4}, {0x8B,0xF5},
    {0x8B,0xF6}, {0x8B,0xF7}, {0x8B,0xF8}, {0x8B,0xF9},
    {0x8B,0xFA}, {0x8B,0xFB}, {0x8B,0xFC}, {0x8B,0xFD},
    {0x8B,0xFE}, {0x8C,0x40}, {0x8C,0x41}, {0x8C,0x42},
    {0x8C,0x43}, {0x8C,0x44}, {0x8C,0x45}, {0x8C,0x46},
    {0x8C,0x47}, {0x8C,0x48}, {0x8C,0x49}, {0x8C,0x4A},
    {0x8C,0x4B}, {0x8C,0x4C}, {0x8C,0x4D}, {0x8C,0x4E},
    {0x8C,0x4F}, {0x8C,0x50}, {0x8C,0x51}, {0x8C,0x52},
    {0x8C,0x53}, {0x8C,0x54}, {0x8C,0x55}, {0x8C,0x56},
    {0x8C,0x57}, {0x8C,0x58}, {0x8C,0x59}, {0x8C,0x5A},
    {0x8C,0x5B}, {0x8C,0x5C}, {0x8C,0x5D}, {0x8C,0x5E},
    {0x8C,0x5F}, {0x8C,0x60}, {0x8C,0x61}, {0x8C,0x62},
    {0x8C,0x63}, {0x8C,0x64}, {0x8C,0x65}, {0x8C,0x66},
    {0x8C,0x67}, {0x8C,0x68}, {0x8C,0x69}, {0x8C,0x6A},
    {0x8C,0x6B}, {0x8C,0x6C}, {0x8C,0x6D}, {0x8C,0x6E},
    {0x8C,0x6F}, {0x8C,0x70}, {0x8C,0x71}, {0x8C,0x72},
    {0x8C,0x73}, {0x8C,0x74}, {0x8C,0x75}, {0x8C,0x76},
    {0x8C,0x77}, {0x8C,0x78}, {0x8C,0x79}, {0x8C,0x7A},
    {0x8C,0x7B}, {0x8C,0x7C}, {0x8C,0x7D}, {0x8C,0x7E},
    {0x8C,0xA1}, {0x8C,0xA2}, {0x8C,0xA3}, {0x8C,0xA4},
    {0x8C,0xA5}, {0x8C,0xA6}, {0x8C,0xA7}, {0x8C,0xA8},
    {0x8C,0xA9}, {0x8C,0xAA}, {0x8C,0xAB}, {0x8C,0xAC},
    {0x8C,0xAD}, {0x8C,0xAE}, {0x8C,0xAF}, {0x8C,0xB0},
    {0x8C,0xB1}, {0x8C,0xB2}, {0x8C,0xB3}, {0x8C,0xB4},
    {0x8C,0xB5}, {0x8C,0xB6}, {0x8C,0xB7}, {0x8C,0xB8},
    {0x8C,0xB9}, {0x8C,0xBA}, {0x8C,0xBB}, {0x8C,0xBC},
    {0x8C,0xBD}, {0x8C,0xBE}, {0x8C,0xBF}, {0x8C,0xC0},
    {0x8C,0xC1}, {0x8C,0xC2}, {0x8C,0xC3}, {0x8C,0xC4},
    {0x8C,0xC5}, {0x8C,0xC6}, {0x8C,0xC7}, {0x8C,0xC8},
    {0x8C,0xC9}, {0x8C,0xCA}, {0x8C,0xCB}, {0x8C,0xCC},
    {0x8C,0xCD}, {0x8C,0xCE}, {0x8C,0xCF}, {0x8C,0xD0},
    {0x8C,0xD1}, {0x8C,0xD2}, {0x8C,0xD3}, {0x8C,0xD4},
    {0x8C,0xD5}, {0x8C,0xD6}, {0x8C,0xD7}, {0x8C,0xD8},
    {0x8C,0xD9}, {0x8C,0xDA}, {0x8C,0xDB}, {0x8C,0xDC},
    {0x8C,0xDD}, {0x8C,0xDE}, {0x8C,0xDF}, {0x8C,0xE0},
    {0x8C,0xE1}, {0x8C,0xE2}, {0x8C,0xE3}, {0x8C,0xE4},
    {0x8C,0xE5}, {0x8C,0xE6}, {0x8C,0xE7}, {0x8C,0xE8},
    {0x8C,0xE9}, {0x8C,0xEA}, {0x8C,0xEB}, {0x8C,0xEC},
    {0x8C,0xED}, {0x8C,0xEE}, {0x8C,0xEF}, {0x8C,0xF0},
    {0x8C,0xF1}, {0x8C,0xF2}, {0x8C,0xF3}, {0x8C,0xF4},
    {0x8C,0xF5}, {0x8C,0xF6}, {0x8C,0xF7}, {0x8C,0xF8},
    {0x8C,0xF9}, {0x8C,0xFA}, {0x8C,0xFB}, {0x8C,0xFC},
    {0x8C,0xFD}, {0x8C,0xFE}, {0x8D,0x40}, {0x8D,0x41},
    {0x8D,0x42}, {0x8D,0x43}, {0x8D,0x44}, {0x8D,0x45},
    {0x8D,0x46}, {0x8D,0x47}, {0x8D,0x48}, {0x8D,0x49},
    {0x8D,0x4A}, {0x8D,0x4B}, {0x8D,0x4C}, {0x8D,0x4D},
    {0x8D,0x4E}, {0x8D,0x4F}, {0x8D,0x50}, {0x8D,0x51},
    {0x8D,0x52}, {0x8D,0x53}, {0x8D,0x54}, {0x8D,0x55},
    {0x8D,0x56}, {0x8D,0x57}, {0x8D,0x58}, {0x8D,0x59},
    {0x8D,0x5A}, {0x8D,0x5B}, {0x8D,0x5C}, {0x8D,0x5D},
    {0x8D,0x5E}, {0x8D,0x5F}, {0x8D,0x60}, {0x8D,0x61},
    {0x8D,0x62}, {0x8D,0x63}, {0x8D,0x64}, {0x8D,0x65},
    {0x8D,0x66}, {0x8D,0x67}, {0x8D,0x68}, {0x8D,0x69},
    {0x8D,0x6A}, {0x8D,0x6B}, {0x8D,0x6C}, {0x8D,0x6D},
    {0x8D,0x6E}, {0x8D,0x6F}, {0x8D,0x70}, {0x8D,0x71},
    {0x8D,0x72}, {0x8D,0x73}, {0x8D,0x74}, {0x8D,0x75},
    {0x8D,0x76}, {0x8D,0x77}, {0x8D,0x78}, {0x8D,0x79},
    {0x8D,0x7A}, {0x8D,0x7B}, {0x8D,0x7C}, {0x8D,0x7D},
    {0x8D,0x7E}, {0x8D,0xA1}, {0x8D,0xA2}, {0x8D,0xA3},
    {0x8D,0xA4}, {0x8D,0xA5}, {0x8D,0xA6}, {0x8D,0xA7},
    {0x8D,0xA8}, {0x8D,0xA9}, {0x8D,0xAA}, {0x8D,0xAB},
    {0x8D,0xAC}, {0x8D,0xAD}, {0x8D,0xAE}, {0x8D,0xAF},
    {0x8D,0xB0}, {0x8D,0xB1}, {0x8D,0xB2}, {0x8D,0xB3},
    {0x8D,0xB4}, {0x8D,0xB5}, {0x8D,0xB6}, {0x8D,0xB7},
    {0x8D,0xB8}, {0x8D,0xB9}, {0x8D,0xBA}, {0x8D,0xBB},
    {0x8D,0xBC}, {0x8D,0xBD}, {0x8D,0xBE}, {0x8D,0xBF},
    {0x8D,0xC0}, {0x8D,0xC1}, {0x8D,0xC2}, {0x8D,0xC3},
    {0x8D,0xC4}, {0x8D,0xC5}, {0x8D,0xC6}, {0x8D,0xC7},
    {0x8D,0xC8}, {0x8D,0xC9}, {0x8D,0xCA}, {0x8D,0xCB},
    {0x8D,0xCC}, {0x8D,0xCD}, {0x8D,0xCE}, {0x8D,0xCF},
    {0x8D,0xD0}, {0x8D,0xD1}, {0x8D,0xD2}, {0x8D,0xD3},
    {0x8D,0xD4}, {0x8D,0xD5}, {0x8D,0xD6}, {0x8D,0xD7},
    {0x8D,0xD8}, {0x8D,0xD9}, {0x8D,0xDA}, {0x8D,0xDB},
    {0x8D,0xDC}, {0x8D,0xDD}, {0x8D,0xDE}, {0x8D,0xDF},
    {0x8D,0xE0}, {0x8D,0xE1}, {0x8D,0xE2}, {0x8D,0xE3},
    {0x8D,0xE4}, {0x8D,0xE5}, {0x8D,0xE6}, {0x8D,0xE7},
    {0x8D,0xE8}, {0x8D,0xE9}, {0x8D,0xEA}, {0x8D,0xEB},
    {0x8D,0xEC}, {0x8D,0xED}, {0x8D,0xEE}, {0x8D,0xEF},
    {0x8D,0xF0}, {0x8D,0xF1}, {0x8D,0xF2}, {0x8D,0xF3},
    {0x8D,0xF4}, {0x8D,0xF5}, {0x8D,0xF6}, {0x8D,0xF7},
    {0x8D,0xF8}, {0x8D,0xF9}, {0x8D,0xFA}, {0x8D,0xFB},
    {0x8D,0xFC}, {0x8D,0xFD}, {0x8D,0xFE}, {0xC6,0xA1},
    {0xC6,0xA2}, {0xC6,0xA3}, {0xC6,0xA4}, {0xC6,0xA5},
    {0xC6,0xA6}, {0xC6,0xA7}, {0xC6,0xA8}, {0xC6,0xA9},
    {0xC6,0xAA}, {0xC6,0xAB}, {0xC6,0xAC}, {0xC6,0xAD},
    {0xC6,0xAE}, {0xC6,0xAF}, {0xC6,0xB0}, {0xC6,0xB1},
    {0xC6,0xB2}, {0xC6,0xB3}, {0xC6,0xB4}, {0xC6,0xB5},
    {0xC6,0xB6}, {0xC6,0xB7}, {0xC6,0xB8}, {0xC6,0xB9},
    {0xC6,0xBA}, {0xC6,0xBB}, {0xC6,0xBC}, {0xC6,0xBD},
    {0xC6,0xBE}, {0xC6,0xBF}, {0xC6,0xC0}, {0xC6,0xC1},
    {0xC6,0xC2}, {0xC6,0xC3}, {0xC6,0xC4}, {0xC6,0xC5},
    {0xC6,0xC6}, {0xC6,0xC7}, {0xC6,0xC8}, {0xC6,0xC9},
    {0xC6,0xCA}, {0xC6,0xCB}, {0xC6,0xCC}, {0xC6,0xCD},
    {0xC6,0xCE}, {0xC6,0xCF}, {0xC6,0xD0}, {0xC6,0xD1},
    {0xC6,0xD2}, {0xC6,0xD3}, {0xC6,0xD4}, {0xC6,0xD5},
    {0xC6,0xD6}, {0xC6,0xD7}, {0xC6,0xD8}, {0xC6,0xD9},
    {0xC6,0xDA}, {0xC6,0xDB}, {0xC6,0xDC}, {0xC6,0xDD},
    {0xC6,0xDE}, {0xC6,0xDF}, {0xC6,0xE0}, {0xC6,0xE1},
    {0xC6,0xE2}, {0xC6,0xE3}, {0xC6,0xE4}, {0xC6,0xE5},
    {0xC6,0xE6}, {0xC6,0xE7}, {0xC6,0xE8}, {0xC6,0xE9},
    {0xC6,0xEA}, {0xC6,0xEB}, {0xC6,0xEC}, {0xC6,0xED},
    {0xC6,0xEE}, {0xC6,0xEF}, {0xC6,0xF0}, {0xC6,0xF1},
    {0xC6,0xF2}, {0xC6,0xF3}, {0xC6,0xF4}, {0xC6,0xF5},
    {0xC6,0xF6}, {0xC6,0xF7}, {0xC6,0xF8}, {0xC6,0xF9},
    {0xC6,0xFA}, {0xC6,0xFB}, {0xC6,0xFC}, {0xC6,0xFD},
    {0xC6,0xFE}, {0xC7,0x40}, {0xC7,0x41}, {0xC7,0x42},
    {0xC7,0x43}, {0xC7,0x44}, {0xC7,0x45}, {0xC7,0x46},
    {0xC7,0x47}, {0xC7,0x48}, {0xC7,0x49}, {0xC7,0x4A},
    {0xC7,0x4B}, {0xC7,0x4C}, {0xC7,0x4D}, {0xC7,0x4E},
    {0xC7,0x4F}, {0xC7,0x50}, {0xC7,0x51}, {0xC7,0x52},
    {0xC7,0x53}, {0xC7,0x54}, {0xC7,0x55}, {0xC7,0x56},
    {0xC7,0x57}, {0xC7,0x58}, {0xC7,0x59}, {0xC7,0x5A},
    {0xC7,0x5B}, {0xC7,0x5C}, {0xC7,0x5D}, {0xC7,0x5E},
    {0xC7,0x5F}, {0xC7,0x60}, {0xC7,0x61}, {0xC7,0x62},
    {0xC7,0x63}, {0xC7,0x64}, {0xC7,0x65}, {0xC7,0x66},
    {0xC7,0x67}, {0xC7,0x68}, {0xC7,0x69}, {0xC7,0x6A},
    {0xC7,0x6B}, {0xC7,0x6C}, {0xC7,0x6D}, {0xC7,0x6E},
    {0xC7,0x6F}, {0xC7,0x70}, {0xC7,0x71}, {0xC7,0x72},
    {0xC7,0x73}, {0xC7,0x74}, {0xC7,0x75}, {0xC7,0x76},
    {0xC7,0x77}, {0xC7,0x78}, {0xC7,0x79}, {0xC7,0x7A},
    {0xC7,0x7B}, {0xC7,0x7C}, {0xC7,0x7D}, {0xC7,0x7E},
    {0xC7,0xA1}, {0xC7,0xA2}, {0xC7,0xA3}, {0xC7,0xA4},
    {0xC7,0xA5}, {0xC7,0xA6}, {0xC7,0xA7}, {0xC7,0xA8},
    {0xC7,0xA9}, {0xC7,0xAA}, {0xC7,0xAB}, {0xC7,0xAC},
    {0xC7,0xAD}, {0xC7,0xAE}, {0xC7,0xAF}, {0xC7,0xB0},
    {0xC7,0xB1}, {0xC7,0xB2}, {0xC7,0xB3}, {0xC7,0xB4},
    {0xC7,0xB5}, {0xC7,0xB6}, {0xC7,0xB7}, {0xC7,0xB8},
    {0xC7,0xB9}, {0xC7,0xBA}, {0xC7,0xBB}, {0xC7,0xBC},
    {0xC7,0xBD}, {0xC7,0xBE}, {0xC7,0xBF}, {0xC7,0xC0},
    {0xC7,0xC1}, {0xC7,0xC2}, {0xC7,0xC3}, {0xC7,0xC4},
    {0xC7,0xC5}, {0xC7,0xC6}, {0xC7,0xC7}, {0xC7,0xC8},
    {0xC7,0xC9}, {0xC7,0xCA}, {0xC7,0xCB}, {0xC7,0xCC},
    {0xC7,0xCD}, {0xC7,0xCE}, {0xC7,0xCF}, {0xC7,0xD0},
    {0xC7,0xD1}, {0xC7,0xD2}, {0xC7,0xD3}, {0xC7,0xD4},
    {0xC7,0xD5}, {0xC7,0xD6}, {0xC7,0xD7}, {0xC7,0xD8},
    {0xC7,0xD9}, {0xC7,0xDA}, {0xC7,0xDB}, {0xC7,0xDC},
    {0xC7,0xDD}, {0xC7,0xDE}, {0xC7,0xDF}, {0xC7,0xE0},
    {0xC7,0xE1}, {0xC7,0xE2}, {0xC7,0xE3}, {0xC7,0xE4},
    {0xC7,0xE5}, {0xC7,0xE6}, {0xC7,0xE7}, {0xC7,0xE8},
    {0xC7,0xE9}, {0xC7,0xEA}, {0xC7,0xEB}, {0xC7,0xEC},
    {0xC7,0xED}, {0xC7,0xEE}, {0xC7,0xEF}, {0xC7,0xF0},
    {0xC7,0xF1}, {0xC7,0xF2}, {0xC7,0xF3}, {0xC7,0xF4},
    {0xC7,0xF5}, {0xC7,0xF6}, {0xC7,0xF7}, {0xC7,0xF8},
    {0xC7,0xF9}, {0xC7,0xFA}, {0xC7,0xFB}, {0xC7,0xFC},
    {0xC7,0xFD}, {0xC7,0xFE}, {0xC8,0x40}, {0xC8,0x41},
    {0xC8,0x42}, {0xC8,0x43}, {0xC8,0x44}, {0xC8,0x45},
    {0xC8,0x46}, {0xC8,0x47}, {0xC8,0x48}, {0xC8,0x49},
    {0xC8,0x4A}, {0xC8,0x4B}, {0xC8,0x4C}, {0xC8,0x4D},
    {0xC8,0x4E}, {0xC8,0x4F}, {0xC8,0x50}, {0xC8,0x51},
    {0xC8,0x52}, {0xC8,0x53}, {0xC8,0x54}, {0xC8,0x55},
    {0xC8,0x56}, {0xC8,0x57}, {0xC8,0x58}, {0xC8,0x59},
    {0xC8,0x5A}, {0xC8,0x5B}, {0xC8,0x5C}, {0xC8,0x5D},
    {0xC8,0x5E}, {0xC8,0x5F}, {0xC8,0x60}, {0xC8,0x61},
    {0xC8,0x62}, {0xC8,0x63}, {0xC8,0x64}, {0xC8,0x65},
    {0xC8,0x66}, {0xC8,0x67}, {0xC8,0x68}, {0xC8,0x69},
    {0xC8,0x6A}, {0xC8,0x6B}, {0xC8,0x6C}, {0xC8,0x6D},
    {0xC8,0x6E}, {0xC8,0x6F}, {0xC8,0x70}, {0xC8,0x71},
    {0xC8,0x72}, {0xC8,0x73}, {0xC8,0x74}, {0xC8,0x75},
    {0xC8,0x76}, {0xC8,0x77}, {0xC8,0x78}, {0xC8,0x79},
    {0xC8,0x7A}, {0xC8,0x7B}, {0xC8,0x7C}, {0xC8,0x7D},
    {0xC8,0x7E}, {0xC8,0xA1}, {0xC8,0xA2}, {0xC8,0xA3},
    {0xC8,0xA4}, {0xC8,0xA5}, {0xC8,0xA6}, {0xC8,0xA7},
    {0xC8,0xA8}, {0xC8,0xA9}, {0xC8,0xAA}, {0xC8,0xAB},
    {0xC8,0xAC}, {0xC8,0xAD}, {0xC8,0xAE}, {0xC8,0xAF},
    {0xC8,0xB0}, {0xC8,0xB1}, {0xC8,0xB2}, {0xC8,0xB3},
    {0xC8,0xB4}, {0xC8,0xB5}, {0xC8,0xB6}, {0xC8,0xB7},
    {0xC8,0xB8}, {0xC8,0xB9}, {0xC8,0xBA}, {0xC8,0xBB},
    {0xC8,0xBC}, {0xC8,0xBD}, {0xC8,0xBE}, {0xC8,0xBF},
    {0xC8,0xC0}, {0xC8,0xC1}, {0xC8,0xC2}, {0xC8,0xC3},
    {0xC8,0xC4}, {0xC8,0xC5}, {0xC8,0xC6}, {0xC8,0xC7},
    {0xC8,0xC8}, {0xC8,0xC9}, {0xC8,0xCA}, {0xC8,0xCB},
    {0xC8,0xCC}, {0xC8,0xCD}, {0xC8,0xCE}, {0xC8,0xCF},
    {0xC8,0xD0}, {0xC8,0xD1}, {0xC8,0xD2}, {0xC8,0xD3},
    {0xC8,0xD4}, {0xC8,0xD5}, {0xC8,0xD6}, {0xC8,0xD7},
    {0xC8,0xD8}, {0xC8,0xD9}, {0xC8,0xDA}, {0xC8,0xDB},
    {0xC8,0xDC}, {0xC8,0xDD}, {0xC8,0xDE}, {0xC8,0xDF},
    {0xC8,0xE0}, {0xC8,0xE1}, {0xC8,0xE2}, {0xC8,0xE3},
    {0xC8,0xE4}, {0xC8,0xE5}, {0xC8,0xE6}, {0xC8,0xE7},
    {0xC8,0xE8}, {0xC8,0xE9}, {0xC8,0xEA}, {0xC8,0xEB},
    {0xC8,0xEC}, {0xC8,0xED}, {0xC8,0xEE}, {0xC8,0xEF},
    {0xC8,0xF0}, {0xC8,0xF1}, {0xC8,0xF2}, {0xC8,0xF3},
    {0xC8,0xF4}, {0xC8,0xF5}, {0xC8,0xF6}, {0xC8,0xF7},
    {0xC8,0xF8}, {0xC8,0xF9}, {0xC8,0xFA}, {0xC8,0xFB},
    {0xC8,0xFC}, {0xC8,0xFD}, {0xC8,0xFE}, {0xFF,0x00},
    {0xB0,0x5A}, {0xA7,0xF3}, {0xA8,0xAE}, {0xB8,0xEB},
    {0xB7,0xC6}, {0xA6,0xEA}, {0xA5,0x79}, {0x8B,0xF8},
    {0xC0,0x74}, {0xAB,0xB4}, {0xAA,0xF7}, {0xB3,0xE2},
    {0xA9,0x60}, {0xC3,0x69}, {0xC4,0xEE}, {0xC3,0xB9},
    {0xC5,0xDA}, {0xC1,0xB3}, {0xBB,0x72}, {0xC5,0xDE},
    {0xBC,0xD6}, {0xAC,0xA5}, {0xAF,0x4F}, {0xAF,0x5F},
    {0xB8,0xA8}, {0xB9,0x54}, {0xC0,0x64}, {0xB6,0xC3},
    {0xA7,0x5A}, {0xC4,0xE6}, {0xC4,0xEA}, {0xC4,0xF5},
    {0xC6,0x7D}, {0xB4,0x50}, {0xC0,0xDD}, {0xC2,0xC5},
    {0xC4,0xB0}, {0xA9,0xD4}, {0xC3,0xBE}, {0xC4,0xFA},
    {0xB4,0x59}, {0xAE,0xD4}, {0xAE,0xF6}, {0xAF,0x54},
    {0xA8,0xD3}, {0xA7,0x4E}, {0xB3,0xD2}, {0xBE,0xDB},
    {0xC3,0x72}, {0xC4,0x6C}, {0xBF,0x63}, {0xA6,0xD1},
    {0xC4,0xAA}, {0xB8,0xB8}, {0xB8,0xF4}, {0xC5,0x53},
    {0xBE,0x7C}, {0xC6,0x4F}, {0xB8,0x4C}, {0xB8,0x53},
    {0xBA,0xF1}, {0xDB,0x77}, {0xBF,0xFD}, {0xB3,0xC0},
    {0xBD,0xD7}, {0xC3,0x62}, {0xA7,0xCB}, {0xC5,0xA2},
    {0xC5,0xA4}, {0xA8,0x63}, {0xBD,0x55}, {0xB8,0xEF},
    {0xB9,0x70}, {0xC2,0x53}, {0xB9,0xF0}, {0xBC,0xD3},
    {0xB2,0x5C}, {0xBA,0x7C}, {0xB2,0xD6}, {0xC1,0x5C},
    {0xAD,0xAE}, {0xB0,0xC7}, {0xA6,0xD8}, {0xBB,0xFE},
    {0xAD,0xE2}, {0xB8,0x57}, {0xBA,0xF0}, {0xB5,0xD9},
    {0xB3,0xAE}, {0xC5,0xAA}, {0xCE,0xD4}, {0xBC,0xD6},
    {0xBF,0xD5}, {0xA4,0xA6}, {0xB9,0xE7}, {0xAB,0xE3},
    {0xB2,0x76}, {0xB2,0xA7}, {0xA5,0x5F}, {0xED,0xA8},
    {0xAB,0x4B}, {0xB4,0x5F}, {0xA4,0xA3}, {0xAA,0x63},
    {0xBC,0xC6}, {0xAF,0xC1}, {0xB0,0xD1}, {0xB6,0xEB},
    {0xAC,0xD9}, {0xB8,0xAD}, {0xBB,0xA1}, {0xB1,0xFE},
    {0xA8,0xB0}, {0xA8,0x48}, {0xAC,0x42}, {0xAD,0x59},
    {0xB1,0xB0}, {0xB2,0xA4}, {0xAB,0x47}, {0xA8,0xE2},
    {0xB1,0xE7}, {0xC2,0xB3}, {0xA8,0x7D}, {0xBD,0xCC},
    {0xB6,0x71}, {0xC0,0x79}, {0xA7,0x66}, {0xA4,0x6B},
    {0xC3,0x66}, {0xAE,0xC8}, {0xC2,0x6F}, {0xC4,0x72},
    {0xBE,0x5B}, {0xC6,0x7A}, {0xC4,0x52}, {0xBE,0xA4},
    {0xA4,0x4F}, {0xBE,0xE4}, {0xBE,0xFA}, {0xF7,0x65},
    {0xA6,0x7E}, {0xBC,0xA6}, {0xC5,0xCA}, {0xBC,0xBF},
    {0xBA,0xA7}, {0xB7,0xD2}, {0xE6,0xA3}, {0xBD,0x6D},
    {0xC1,0x70}, {0xBD,0xFB}, {0xBD,0xAC}, {0xB3,0x73},
    {0xC1,0xE5}, {0xA6,0x43}, {0xA6,0x48}, {0xAB,0x7C},
    {0xAF,0x50}, {0xB5,0xF5}, {0xBB,0xA1}, {0xB7,0x47},
    {0xA9,0xC0}, {0xB1,0xC9}, {0xC0,0xD4}, {0xC3,0xAE},
    {0xC2,0x79}, {0xA5,0x4F}, {0xCB,0xF1}, {0xB9,0xE7},
    {0xC0,0xAD}, {0xCC,0xB0}, {0xAC,0xC2}, {0xBC,0xFC},
    {0xB2,0xDC}, {0xB2,0xE2}, {0xB9,0x61}, {0xB9,0x73},
    {0xC6,0x46}, {0xBB,0xE2}, {0xA8,0xD2}, {0xC2,0xA7},
    {0xC4,0xBF}, {0xC1,0xF5}, {0xB4,0x63}, {0xA4,0x46},
    {0xB9,0xB1}, {0xBC,0x64}, {0xA7,0xBF}, {0xAE,0xC6},
    {0xBC,0xD6}, {0xBF,0x52}, {0xC0,0xF8}, {0xE7,0x64},
    {0xBF,0xF1}, {0xC0,0x73}, {0xB7,0x77}, {0xA8,0xBF},
    {0xBC,0x42}, {0xCC,0xD8}, {0xAC,0x68}, {0xAC,0x79},
    {0xB7,0xC8}, {0xAF,0x5B}, {0xAF,0x64}, {0xB2,0xB8},
    {0xAF,0xC3}, {0xC3,0xFE}, {0xA4,0xBB}, {0xBC,0xAE},
    {0xB3,0xB0}, {0xAD,0xDB}, {0xB1,0x5B}, {0xB2,0x5F},
    {0xBD,0xFC}, {0xAB,0xDF}, {0xB7,0x58}, {0xAE,0xDF},
    {0xB2,0x76}, {0xB6,0xA9}, {0xA7,0x51}, {0xA6,0x4F},
    {0xBC,0x69}, {0xA9,0xF6}, {0xA7,0xF5}, {0xB1,0xF9},
    {0xAA,0x64}, {0xB2,0x7A}, {0xB5,0x67}, {0xBF,0xA9},
    {0xB8,0xCC}, {0xA8,0xBD}, {0xC2,0xF7}, {0xB0,0xCE},
    {0xB7,0xC4}, {0xA7,0x5B}, {0xBF,0x4D}, {0xBF,0x5A},
    {0xC4,0xA9}, {0xC5,0xEC}, {0xC5,0xEF}, {0xAA,0x4C},
    {0xB2,0x4F}, {0xC1,0x7B}, {0xA5,0xDF}, {0xB2,0xC1},
    {0xB2,0xC9}, {0xAA,0xAC}, {0xAA,0xA5}, {0xC3,0xD1},
    {0xA4,0xB0}, {0xAF,0xF9}, {0xA8,0xEB}, {0xA4,0xC1},
    {0xAB,0xD7}, {0xA9,0xDD}, {0xBF,0x7D}, {0xA6,0x76},
    {0xAC,0x7D}, {0xBC,0xC9}, {0xBF,0xE7}, {0xA6,0xE6},
    {0xAD,0xB0}, {0xA8,0xA3}, {0xB9,0xF8}, {0xC9,0x4A},
    {0xDD,0xFC}, {0xB6,0xEF}, {0xB4,0xB8}, {0xE8,0xF9},
    {0xBD,0xDE}, {0xAF,0x71}, {0xAF,0xAB}, {0xB2,0xBB},
    {0xBA,0xD6}, {0xB9,0x74}, {0xBA,0xEB}, {0xA6,0xD0},
    {0xBD,0xD1}, {0xB6,0x68}, {0xB3,0xA3}, {0xB6,0xBA},
    {0xB9,0x7D}, {0xC0,0x5D}, {0xC5,0x62}, {0xA1,0x4A},
    {0xA1,0x57}, {0xA1,0x59}, {0xA1,0x5B}, {0xA1,0x5F},
    {0xA1,0x60}, {0xA1,0x63}, {0xA1,0x64}, {0xA1,0x67},
    {0xA1,0x68}, {0xA1,0x6B}, {0xA1,0x6C}, {0xA1,0x6F},
    {0xA1,0x70}, {0xA1,0x73}, {0xA1,0x74}, {0xA1,0x77},
    {0xA1,0x78}, {0xA1,0x7B}, {0xA1,0x7C}, {0xA1,0xC6},
    {0xA1,0xC7}, {0xA1,0xCA}, {0xA1,0xCB}, {0xA1,0xC8},
    {0xA1,0xC9}, {0xA1,0x5C}, {0xA1,0x4D}, {0xA1,0x4E},
    {0xA1,0x4F}, {0xA1,0x51}, {0xA1,0x52}, {0xA1,0x53},
    {0xA1,0x54}, {0xA1,0x7D}, {0xA1,0x7E}, {0xA1,0xA1},
    {0xA1,0xA2}, {0xA1,0xA3}, {0xA1,0xA4}, {0xA1,0xCC},
    {0xA1,0xCD}, {0xA1,0xCE}, {0xA1,0xDE}, {0xA1,0xDF},
    {0xA1,0xE0}, {0xA1,0xE1}, {0xA1,0xE2}, {0xA2,0x42},
    {0xA2,0x4C}, {0xA2,0x4D}, {0xA2,0x4E}, {0xA1,0x49},
    {0xC8,0xD0}, {0xA1,0xAD}, {0xA2,0x43}, {0xA2,0x48},
    {0xA1,0xAE}, {0xC8,0xCF}, {0xA1,0x5D}, {0xA1,0x5E},
    {0xA1,0xAF}, {0xA1,0xCF}, {0xA1,0x41}, {0xA1,0xD0},
    {0xA1,0x44}, {0xA1,0xFE}, {0xA2,0xAF}, {0xA2,0xB0},
    {0xA2,0xB1}, {0xA2,0xB2}, {0xA2,0xB3}, {0xA2,0xB4},
    {0xA2,0xB5}, {0xA2,0xB6}, {0xA2,0xB7}, {0xA2,0xB8},
    {0xA1,0x47}, {0xA1,0x46}, {0xA1,0xD5}, {0xA1,0xD7},
    {0xA1,0xD6}, {0xA1,0x48}, {0xA2,0x49}, {0xA2,0xCF},
    {0xA2,0xD0}, {0xA2,0xD1}, {0xA2,0xD2}, {0xA2,0xD3},
    {0xA2,0xD4}, {0xA2,0xD5}, {0xA2,0xD6}, {0xA2,0xD7},
    {0xA2,0xD8}, {0xA2,0xD9}, {0xA2,0xDA}, {0xA2,0xDB},
    {0xA2,0xDC}, {0xA2,0xDD}, {0xA2,0xDE}, {0xA2,0xDF},
    {0xA2,0xE0}, {0xA2,0xE1}, {0xA2,0xE2}, {0xA2,0xE3},
    {0xA2,0xE4}, {0xA2,0xE5}, {0xA2,0xE6}, {0xA2,0xE7},
    {0xA2,0xE8}, {0xC6,0xE4}, {0xA2,0x40}, {0xC6,0xE5},
    {0xA1,0x73}, {0xA1,0xC4}, {0xA1,0xA5}, {0xA2,0xE9},
    {0xA2,0xEA}, {0xA2,0xEB}, {0xA2,0xEC}, {0xA2,0xED},
    {0xA2,0xEE}, {0xA2,0xEF}, {0xA2,0xF0}, {0xA2,0xF1},
    {0xA2,0xF2}, {0xA2,0xF3}, {0xA2,0xF4}, {0xA2,0xF5},
    {0xA2,0xF6}, {0xA2,0xF7}, {0xA2,0xF8}, {0xA2,0xF9},
    {0xA2,0xFA}, {0xA2,0xFB}, {0xA2,0xFC}, {0xA2,0xFD},
    {0xA2,0xFE}, {0xA3,0x40}, {0xA3,0x41}, {0xA3,0x42},
    {0xA3,0x43}, {0xA1,0x61}, {0xA1,0x55}, {0xA1,0x62},
    {0xA1,0xE3}, {0xA1,0x4E}, {0xA2,0x46}, {0xA2,0x47},
    {0xC8,0xCD}, {0xA1,0xC3}, {0xC8,0xCE}, {0xA2,0x44},
    {0xF9,0xFE}, {0x9C,0x71}, {0x93,0x75}, {0x93,0x76},
    {0x95,0x48}, {0x8E,0xC6}, {0x8B,0xC5}, {0x8B,0xFA},
    {0xC8,0x7C}, {0x9A,0xB4}, {0x88,0x4E}, {0x88,0x4B},
    {0xC8,0x7A}, {0x88,0x48}, {0x88,0x47}, {0xA0,0xF6},
    {0x88,0x45}, {0x88,0x53}, {0xFC,0xAD}, {0x8A,0xAD},
    {0x92,0x72}, {0xFC,0x47}, {0x94,0xDF}, {0x9F,0xD1},
    {0xFB,0xCB}, {0x92,0x7D}, {0x98,0xA4}, {0x94,0xE7},
    {0x90,0xCB}, {0x92,0x7B}, {0x94,0xD8}, {0xFC,0x5F},
    {0xFA,0x54}, {0x9A,0xB5}, {0x96,0xDA}, {0x92,0x79},
    {0xFA,0x74}, {0x92,0x75}, {0x8D,0xFB}, {0x8A,0x49},
    {0x92,0xDF}, {0x9B,0x7C}, {0xFA,0x63}, {0xFA,0x60},
    {0x92,0x6D}, {0xFA,0x62}, {0x9A,0xB6}, {0x97,0x6B},
    {0xFD,0x6A}, {0xFD,0x54}, {0x92,0x73}, {0x97,0xD8},
    {0x9F,0xBB}, {0x93,0x42}, {0x92,0x76}, {0xFA,0x65},
    {0x92,0x6C}, {0xFA,0x6E}, {0x9E,0xE0}, {0x92,0xC0},
    {0x92,0xBF}, {0x92,0xBE}, {0x9A,0xBA}, {0x8A,0xB3},
    {0x97,0x75}, {0xFA,0x40}, {0xFA,0x76}, {0xFB,0xD0},
    {0xFA,0x7B}, {0xFE,0x6D}, {0x9B,0xB3}, {0x89,0xCC},
    {0x9A,0xBE}, {0xFA,0x42}, {0x92,0xBC}, {0x94,0x5C},
    {0x9B,0xB5}, {0x9A,0xBF}, {0x98,0xA7}, {0x97,0xA4},
    {0x90,0xFD}, {0xFC,0x7B}, {0x9A,0xC0}, {0x92,0xC3},
    {0x8A,0xAA}, {0x9B,0xD0}, {0x95,0x50}, {0x92,0xC6},
    {0x98,0xA6}, {0x95,0x46}, {0xFD,0x63}, {0xFA,0xC2},
    {0x9E,0xC3}, {0x89,0xB2}, {0x9C,0x66}, {0x90,0x53},
    {0x97,0xC1}, {0x9A,0xC4}, {0x9A,0xC5}, {0x8E,0xEF},
    {0xFA,0xE9}, {0x92,0x62}, {0x8A,0xF7}, {0x9A,0xC6},
    {0x92,0xE1}, {0x9A,0xC9}, {0xFA,0xC6}, {0x97,0xA5},
    {0x9A,0xCB}, {0xFA,0x72}, {0x8A,0x5E}, {0x94,0xE0},
    {0x92,0xCC}, {0x8A,0xE5}, {0xFE,0x5C}, {0x9A,0xCC},
    {0x9D,0xF9}, {0x8A,0x43}, {0x8A,0xA6}, {0x9A,0xCD},
    {0x9A,0xCE}, {0xFA,0xEE}, {0x9B,0xCC}, {0x9A,0xCF},
    {0x9A,0xD1}, {0x9D,0xFA}, {0x9D,0x7C}, {0x9A,0xD3},
    {0x97,0xA6}, {0x99,0x5F}, {0xFB,0xF6}, {0x9F,0xC5},
    {0x8A,0x59}, {0x8B,0x6B}, {0x9A,0xD4}, {0x9A,0xD5},
    {0x97,0xA2}, {0x8A,0x44}, {0x9F,0x4A}, {0x90,0xA1},
    {0xFD,0xA4}, {0x8A,0x64}, {0x8A,0xF2}, {0x8A,0xF8},
    {0x9D,0xD8}, {0x94,0xD6}, {0xFA,0xFE}, {0xFB,0xA7},
    {0x9A,0xD6}, {0x9F,0x4D}, {0xFA,0xF6}, {0x8A,0x57},
    {0x8B,0x43}, {0x8B,0x44}, {0x8A,0xB6}, {0x8A,0xC0},
    {0x9E,0x54}, {0x9A,0xD7}, {0x9A,0xD8}, {0x9A,0xDC},
    {0x8A,0xCA}, {0x9E,0xA8}, {0x92,0x63}, {0x9A,0xDD},
    {0x8B,0x65}, {0x8B,0x6F}, {0x8B,0x7E}, {0x8F,0x43},
    {0x92,0xD0}, {0x8A,0xF4}, {0x9D,0xBE}, {0x9A,0xE1},
    {0xFC,0xDE}, {0x9D,0xFD}, {0x8B,0x66}, {0x8B,0x70},
    {0x8B,0x75}, {0x8A,0xE4}, {0x8B,0xA4}, {0x8A,0xED},
    {0x8A,0x5D}, {0x8B,0x48}, {0x9D,0xED}, {0x9E,0x40},
    {0x8A,0xEF}, {0x8A,0xF6}, {0x9E,0x76}, {0x9E,0xE3},
    {0x9A,0xDE}, {0x8D,0xFE}, {0xFA,0xFC}, {0x9C,0xB1},
    {0x9E,0x77}, {0x8B,0x64}, {0x8B,0x67}, {0x97,0x4B},
    {0x96,0x53}, {0x9A,0xE0}, {0x8B,0x4A}, {0x8A,0xF1},
    {0x8A,0xD7}, {0xA0,0xAB}, {0x8A,0xB5}, {0x8A,0x5F},
    {0x8A,0xEE}, {0x9A,0xDF}, {0x8A,0xFE}, {0x8A,0x58},
    {0x8B,0xA3}, {0x8B,0xA7}, {0x9A,0xE3}, {0x92,0x61},
    {0x9D,0xD7}, {0x9E,0x7D}, {0x9E,0xA7}, {0x9E,0xAB},
    {0x90,0x42}, {0x8B,0x79}, {0x8B,0x7A}, {0x9A,0xE6},
    {0x9A,0xE5}, {0x8A,0x7E}, {0x9E,0x44}, {0x9A,0xE7},
    {0x8A,0x7C}, {0x8B,0x71}, {0x9A,0xE9}, {0x9A,0xEA},
    {0x9A,0xEB}, {0x8A,0xBD}, {0xFB,0x4E}, {0x9A,0xED},
    {0x8A,0xF9}, {0x9E,0x63}, {0x8B,0x49}, {0x8A,0xCE},
    {0x8B,0x6E}, {0x8A,0xE8}, {0x9A,0xEE}, {0x92,0xCE},
    {0x8A,0x5A}, {0x8B,0x7B}, {0x8B,0x7C}, {0x9A,0xEF},
    {0x9A,0xF0}, {0x8A,0xFA}, {0x89,0x41}, {0x8B,0x72},
    {0x8A,0xF3}, {0x8B,0xA8}, {0x9E,0xAE}, {0x9E,0x72},
    {0xFB,0x73}, {0xFB,0x5F}, {0x90,0xBA}, {0x91,0xFE},
    {0x9E,0xF6}, {0x97,0xED}, {0x9A,0xF3}, {0xA0,0xEE},
    {0x96,0x7C}, {0x93,0x45}, {0x98,0x6E}, {0xFA,0x56},
    {0x9A,0xF5}, {0xFC,0x4B}, {0x9A,0xF4}, {0xFE,0xDE},
    {0xFC,0xB7}, {0x97,0xF1}, {0x97,0xC7}, {0x9C,0xCB},
    {0x92,0x40}, {0x9C,0xE8}, {0x91,0xFD}, {0x97,0x4E},
    {0xFB,0x68}, {0x97,0x6C}, {0x8C,0xC2}, {0x97,0xE8},
    {0xFB,0x6A}, {0x8B,0x74}, {0x8E,0xE7}, {0xFD,0xC8},
    {0x92,0x41}, {0x96,0xA1}, {0x8E,0xF3}, {0x9A,0xF7},
    {0x8F,0xA6}, {0xFA,0xD6}, {0x9C,0xC7}, {0xFA,0xD7},
    {0x9A,0xF8}, {0xFB,0xA1}, {0x8E,0xC5}, {0xFB,0xA4},
    {0xFB,0xC2}, {0x9A,0xC1}, {0x91,0xFA}, {0xFE,0xDB},
    {0x97,0xAB}, {0x91,0x47}, {0xFB,0xB1}, {0x8F,0xEA},
    {0x94,0xD2}, {0xFE,0x61}, {0xFA,0xCE}, {0x92,0xED},
    {0x91,0xF3}, {0x93,0xC6}, {0x93,0x5A}, {0xFA,0xFB},
    {0x92,0xEF}, {0xFA,0xC8}, {0x98,0x47}, {0x93,0x66},
    {0x98,0x55}, {0x96,0xE6}, {0x9F,0x43}, {0x9F,0xAA},
    {0x94,0xDA}, {0x92,0xEE}, {0xFC,0xAF}, {0xFB,0xFB},
    {0x8E,0xF9}, {0x91,0xF6}, {0x93,0x64}, {0x94,0xF5},
    {0x9C,0xB6}, {0xFB,0xAD}, {0x98,0x4E}, {0x8F,0x44},
    {0x96,0xFD}, {0x9A,0xF9}, {0x9A,0xFA}, {0x97,0x69},
    {0x95,0xD4}, {0x98,0x4B}, {0xFB,0xAA}, {0x98,0x7C},
    {0x91,0xEA}, {0x9D,0xAF}, {0x9D,0xC5}, {0x91,0xF1},
    {0x8E,0xB1}, {0x97,0xA9}, {0xFB,0xAC}, {0xFC,0xB8},
    {0x9C,0xB9}, {0xFB,0xB0}, {0xFC,0xD2}, {0x93,0xCB},
    {0x9A,0xFD}, {0x91,0xF4}, {0x8B,0xAC}, {0xA0,0x55},
    {0x95,0x74}, {0x95,0xBE}, {0x97,0xAD}, {0x8E,0xE9},
    {0x92,0xF8}, {0x97,0xBE}, {0x91,0x6C}, {0x94,0xAA},
    {0xFC,0x63}, {0x9D,0xC6}, {0x97,0xB5}, {0x92,0xB8},
    {0x91,0xEF}, {0xFE,0xA6}, {0x97,0x60}, {0x93,0x58},
    {0x95,0x76}, {0x8F,0xAC}, {0x91,0xEC}, {0x97,0xB4},
    {0x91,0xF7}, {0x97,0x4A}, {0xFB,0x49}, {0x95,0x78},
    {0x93,0xBC}, {0x91,0xD6}, {0x93,0x55}, {0x93,0x56},
    {0x98,0x51}, {0x8F,0xF8}, {0xFB,0xC0}, {0x93,0xF2},
    {0x90,0xD0}, {0x9C,0x44}, {0x92,0x55}, {0x93,0x63},
    {0x91,0xA5}, {0xA0,0xED}, {0xFD,0x6B}, {0x9A,0xFE},
    {0x93,0x51}, {0x8C,0x57}, {0xFA,0x78}, {0xFE,0xA8},
    {0x93,0x50}, {0xFA,0x4C}, {0x92,0xF7}, {0x9B,0x40},
    {0xFB,0xCE}, {0x9B,0x41}, {0xFE,0xAD}, {0xFB,0xD5},
    {0x8B,0xC2}, {0x9A,0x7C}, {0x9B,0x42}, {0x9B,0x43},
    {0x9E,0x79}, {0xFB,0xD9}, {0x9B,0x44}, {0xA0,0xA7},
    {0x9B,0xF3}, {0x8C,0x79}, {0x93,0x5E}, {0x89,0xCB},
    {0x9F,0x53}, {0x93,0xD7}, {0xFB,0xE1}, {0xFE,0xD0},
    {0xFB,0xE2}, {0xFC,0xE3}, {0x90,0x74}, {0xFB,0xE6},
    {0x9B,0xB7}, {0x9B,0x45}, {0x9B,0x47}, {0x9F,0x50},
    {0x9B,0x48}, {0xFC,0x5B}, {0x98,0xA9}, {0x9C,0xFD},
    {0x88,0x4C}, {0x9B,0x4B}, {0xFB,0xEC}, {0x8C,0x69},
    {0x9B,0xA8}, {0x8A,0xD5}, {0xFA,0x73}, {0xFD,0x59},
    {0x91,0xA2}, {0xFB,0xED}, {0x9C,0xA9}, {0x8A,0xA8},
    {0x9B,0xC3}, {0x8A,0xE1}, {0x9B,0x4E}, {0x95,0xD0},
    {0x90,0x5F}, {0x97,0xEE}, {0xFC,0x4E}, {0x9B,0x4F},
    {0x9B,0x50}, {0x9E,0xC6}, {0xFC,0x50}, {0xFD,0x73},
    {0xFD,0xA7}, {0x9D,0xA2}, {0xFA,0x58}, {0xFA,0x5E},
    {0xA0,0x59}, {0xFA,0x75}, {0xFB,0xBE}, {0x9C,0xA2},
    {0x93,0x70}, {0x93,0x71}, {0x93,0x77}, {0xFE,0xEF},
    {0x93,0x6D}, {0xFC,0x5D}, {0x90,0xB8}, {0x8A,0xFC},
    {0xFB,0x41}, {0x9E,0x6B}, {0x94,0xE3}, {0x8E,0xE2},
    {0x8C,0x7D}, {0x8E,0xD7}, {0x9C,0x4D}, {0x96,0xA3},
    {0x9B,0x51}, {0x8A,0xC3}, {0x96,0xAA}, {0xFC,0x68},
    {0x8B,0x6D}, {0xFD,0x67}, {0x8A,0xE9}, {0xFC,0xA1},
    {0x93,0x6C}, {0x9B,0x52}, {0xFE,0x70}, {0xFC,0xA8},
    {0xFC,0xE9}, {0x9C,0xB4}, {0x8A,0xEA}, {0x9B,0x53},
    {0x9B,0x55}, {0x96,0xAB}, {0xFC,0xA7}, {0x9B,0x56},
    {0x8A,0xBC}, {0x8A,0xCB}, {0x9B,0x57}, {0x89,0xCD},
    {0x9B,0x59}, {0x9B,0x5B}, {0x93,0xA5}, {0x9B,0x5D},
    {0x9E,0x4F}, {0x93,0xA3}, {0x8A,0x7B}, {0x8B,0x42},
    {0x97,0x50}, {0x8F,0xB3}, {0x8A,0x50}, {0x9B,0x60},
    {0x8B,0x45}, {0x8B,0x46}, {0x9D,0xFE}, {0x9B,0x62},
    {0x93,0x7B}, {0x93,0xB1}, {0x8A,0x60}, {0x8A,0xD8},
    {0x9B,0x63}, {0x8A,0x69}, {0x8A,0x47}, {0x8A,0xCC},
    {0x93,0x7C}, {0x9B,0x65}, {0x9B,0x66}, {0x8A,0x72},
    {0x8A,0x7A}, {0x93,0xAF}, {0x8A,0xB0}, {0x9B,0x68},
    {0x9E,0xA3}, {0xFA,0xEC}, {0x8B,0x77}, {0x9B,0x67},
    {0x8B,0x59}, {0xFC,0xB1}, {0xFC,0xBB}, {0x9B,0x69},
    {0x93,0xA8}, {0x8A,0xE0}, {0x9E,0x51}, {0x8F,0x5F},
    {0x9B,0x6A}, {0x9B,0x6B}, {0x97,0xEC}, {0x9B,0x6C},
    {0xFE,0x4E}, {0xFD,0xC2}, {0x9B,0x6D}, {0x91,0x67},
    {0xFC,0xCC}, {0x93,0xB6}, {0x90,0xE4}, {0x90,0xE5},
    {0x9E,0xF2}, {0x93,0xCA}, {0x8B,0xBC}, {0x8F,0x46},
    {0x93,0xCF}, {0xFC,0xDB}, {0xFC,0xDC}, {0x93,0xC0},
    {0xFC,0xE6}, {0x96,0xE7}, {0xFC,0xD8}, {0xFC,0xD9},
    {0xFD,0xA6}, {0x93,0xCE}, {0x95,0xF1}, {0x9C,0xE9},
    {0xFC,0xE4}, {0x94,0xAF}, {0xFA,0x77}, {0x93,0xCC},
    {0x90,0x5A}, {0x8C,0x54}, {0x93,0xBF}, {0xFB,0x51},
    {0x93,0xB9}, {0xFE,0xD7}, {0x93,0xB7}, {0x93,0xD9},
    {0x93,0xBB}, {0x93,0xDA}, {0x98,0xA3}, {0x90,0xD1},
    {0x9B,0x6E}, {0xFA,0x70}, {0x9B,0xEB}, {0x9B,0x6F},
    {0xFC,0xFC}, {0x8B,0x40}, {0xA0,0x7B}, {0x8C,0xA1},
    {0x97,0xF7}, {0x93,0xE2}, {0xFC,0xD6}, {0x95,0x59},
    {0x93,0xA6}, {0xFD,0x40}, {0x93,0x5F}, {0x97,0xF2},
    {0x9C,0x76}, {0x8E,0xF8}, {0x8F,0x47}, {0x9B,0x74},
    {0x92,0xB4}, {0x91,0xED}, {0x96,0xD2}, {0xFD,0x46},
    {0x8F,0x4F}, {0x95,0x49}, {0x9B,0x75}, {0xFA,0x5C},
    {0x9B,0x79}, {0xFD,0x4B}, {0x96,0xD3}, {0xFD,0x58},
    {0x94,0x5F}, {0xA0,0xF5}, {0x92,0x43}, {0x97,0xFA},
    {0x9D,0xD9}, {0x97,0xF4}, {0x92,0x4D}, {0xFD,0x5B},
    {0x9B,0x7A}, {0x9E,0xD5}, {0xFA,0xAE}, {0x9C,0xC9},
    {0x92,0x58}, {0x8E,0xC8}, {0x94,0xB4}, {0x93,0xE1},
    {0x93,0xDF}, {0xFC,0xF0}, {0x93,0xEC}, {0x97,0xF6},
    {0x96,0xCF}, {0x93,0xDE}, {0x8A,0xCF}, {0x9B,0xA2},
    {0xFD,0x69}, {0x93,0x52}, {0x98,0xA2}, {0xFD,0x6E},
    {0x8C,0xA4}, {0xFA,0x7C}, {0x93,0xFA}, {0x90,0x7C},
    {0x8F,0x67}, {0x9D,0xB7}, {0xA0,0xE9}, {0xFA,0x4E},
    {0xFD,0xA1}, {0x9E,0x74}, {0x9F,0xBF}, {0x9E,0xCB},
    {0x9B,0xB9}, {0x9D,0xD4}, {0x97,0xB9}, {0x8E,0xF1},
    {0x95,0x7B}, {0x9E,0xD2}, {0x97,0x53}, {0x96,0xA4},
    {0x8F,0xBE}, {0x94,0xD9}, {0x90,0x58}, {0xFD,0x79},
    {0xFD,0x7B}, {0x8E,0xDA}, {0x8E,0xFA}, {0x9B,0xA5},
    {0x9E,0xD9}, {0x97,0xD4}, {0x90,0xBB}, {0xFD,0xBC},
    {0xFD,0xC6}, {0x92,0x48}, {0x92,0xB5}, {0x9D,0xC1},
    {0x92,0xB9}, {0x92,0xA6}, {0x8F,0x4B}, {0x9B,0xA6},
    {0x92,0xB6}, {0x8E,0x40}, {0x9E,0xD8}, {0x94,0x5E},
    {0x98,0x5F}, {0x94,0xCE}, {0x92,0x4A}, {0xFD,0x70},
    {0x94,0x67}, {0x8D,0xEC}, {0x9B,0xD8}, {0x94,0x48},
    {0xFA,0xC1}, {0x9C,0xF7}, {0xFD,0xBE}, {0x8F,0xDA},
    {0xFD,0xD9}, {0xFC,0x7E}, {0x93,0xF9}, {0xFA,0x43},
    {0xFA,0xEB}, {0xFA,0xC3}, {0x97,0xD3}, {0x95,0xF9},
    {0x9C,0x48}, {0xFD,0xD8}, {0xA0,0xD8}, {0xFD,0xD7},
    {0xFB,0x4A}, {0x9B,0xAF}, {0x94,0x4B}, {0xFD,0xC9},
    {0x8E,0xAC}, {0xFD,0xB2}, {0x92,0x5A}, {0xFC,0xBD},
    {0x92,0xD9}, {0xFD,0xD5}, {0x92,0xDD}, {0x92,0x59},
    {0x96,0xBA}, {0x92,0x5B}, {0x9B,0xAB}, {0xFD,0xDA},
    {0xFD,0xDE}, {0xFD,0xD3}, {0x8C,0x46}, {0xFD,0xD6},
    {0xFD,0xDC}, {0xFD,0xDD}, {0x90,0xFE}, {0xFE,0xA1},
    {0x8B,0xAD}, {0x9C,0xD8}, {0x9E,0x6D}, {0xFD,0x7C},
    {0xFB,0x61}, {0x96,0xF8}, {0x96,0xF0}, {0xFC,0xF4},
    {0xFE,0x60}, {0x98,0x52}, {0x96,0x4F}, {0x91,0x6E},
    {0x98,0x6D}, {0x98,0x64}, {0x94,0x53}, {0xFD,0xEC},
    {0xFB,0x78}, {0x95,0xBA}, {0x98,0x5D}, {0x92,0xF9},
    {0x98,0x5A}, {0xFD,0xF6}, {0x93,0xD0}, {0x98,0x62},
    {0x9B,0xAD}, {0x97,0x4F}, {0x9B,0xAE}, {0x94,0x52},
    {0x9B,0xB0}, {0x91,0xD2}, {0x97,0xEA}, {0xFB,0x6B},
    {0x91,0xB1}, {0xFD,0xF3}, {0x92,0xCB}, {0x9B,0xB1},
    {0xFC,0xEC}, {0x98,0x6B}, {0x97,0x51}, {0x98,0x71},
    {0x95,0xEF}, {0x9E,0xF3}, {0x91,0xE8}, {0x9B,0xBA},
    {0xFB,0x4C}, {0x92,0x6A}, {0xFD,0xF8}, {0x98,0x61},
    {0x91,0xE7}, {0x93,0xED}, {0x97,0x44}, {0x91,0xE1},
    {0xFB,0xF5}, {0x98,0x69}, {0x8A,0x62}, {0x9B,0xBB},
    {0x8C,0xA8}, {0x9C,0x55}, {0x8E,0x77}, {0x8A,0xB2},
    {0x9E,0xBC}, {0x93,0xE6}, {0x93,0xA2}, {0x9B,0xBD},
    {0x94,0xB3}, {0x93,0x7D}, {0x9E,0x66}, {0x94,0x59},
    {0x9B,0xBF}, {0x94,0x58}, {0x9E,0xA5}, {0x9B,0xC7},
    {0xFE,0x54}, {0x8E,0x74}, {0x8B,0xD6}, {0x94,0xB6},
    {0xFD,0x74}, {0x98,0xC0}, {0x94,0xA5}, {0x9B,0xC8},
    {0x95,0xED}, {0xFD,0x7E}, {0xFB,0xEB}, {0xFD,0x7D},
    {0x97,0x6F}, {0x94,0x61}, {0x9F,0xC1}, {0x95,0xD7},
    {0xFA,0x52}, {0x9C,0x58}, {0x9F,0x68}, {0x9B,0xE7},
    {0xFC,0xCE}, {0x96,0xE8}, {0xFA,0x49}, {0x97,0xA1},
    {0x95,0x4D}, {0x9E,0xF8}, {0xFE,0x49}, {0x91,0xCE},
    {0x97,0x71}, {0x8C,0xCF}, {0xFD,0xB1}, {0xFC,0x6E},
    {0x9C,0xF2}, {0x93,0xB8}, {0x90,0x43}, {0x97,0x59},
    {0x94,0xD7}, {0xFE,0x66}, {0x94,0x7D}, {0xFC,0x6F},
    {0x92,0x46}, {0xFA,0x6D}, {0x8E,0xF7}, {0xFB,0xB7},
    {0x94,0x7C}, {0x92,0xCD}, {0x97,0xB2}, {0xFE,0x65},
    {0x96,0x7E}, {0x97,0x58}, {0x9B,0x77}, {0x91,0xCF},
    {0x94,0xA4}, {0x9C,0xAD}, {0x8B,0xAB}, {0x96,0xD5},
    {0xFC,0xB3}, {0x93,0xAE}, {0x97,0x6D}, {0x94,0x46},
    {0x95,0xF7}, {0x9C,0x46}, {0x95,0x5B}, {0x91,0xD1},
    {0x94,0xF4}, {0xFE,0x67}, {0x92,0xA5}, {0xFE,0xDF},
    {0x8C,0xAB}, {0x9B,0xC9}, {0xFC,0xED}, {0xFD,0xFA},
    {0xFC,0xC8}, {0xFE,0x62}, {0x91,0xFC}, {0xFE,0x6B},
    {0xFD,0xF9}, {0xFC,0xC7}, {0x91,0x4E}, {0x9C,0xB8},
    {0x97,0x67}, {0x95,0xEE}, {0x9B,0xB2}, {0x94,0x60},
    {0x94,0xA2}, {0x98,0x75}, {0x97,0xAC}, {0x91,0xD3},
    {0x98,0x7B}, {0x8E,0xEB}, {0x97,0x6A}, {0x96,0x5E},
    {0x97,0xEB}, {0x9F,0xF9}, {0x95,0xF8}, {0xFE,0xA2},
    {0x8F,0xE6}, {0xFE,0x7E}, {0x9D,0xA4}, {0x97,0x68},
    {0x8E,0xEC}, {0x94,0xBD}, {0x94,0x5B}, {0x9C,0xF6},
    {0xFA,0xA7}, {0x9B,0xD9}, {0xFA,0x5D}, {0x96,0x56},
    {0x97,0x62}, {0x94,0xBA}, {0xA0,0x4F}, {0x92,0xD8},
    {0x9B,0xCB}, {0x94,0xBB}, {0x9D,0x5F}, {0x90,0xCF},
    {0x94,0x65}, {0x9F,0x4C}, {0x90,0xD8}, {0x9E,0xBE},
    {0xFB,0x6D}, {0x95,0xCA}, {0x9D,0xC2}, {0x97,0xF8},
    {0x8F,0xFC}, {0x94,0x73}, {0x94,0x74}, {0xFE,0xB7},
    {0x8A,0x4B}, {0x8A,0x55}, {0x8B,0x69}, {0x8A,0xDC},
    {0x8B,0x76}, {0x9B,0xCE}, {0x8A,0x68}, {0xA0,0xF8},
    {0x98,0xDF}, {0xFE,0xB5}, {0x9B,0xCF}, {0x96,0xFB},
    {0x9B,0xFB}, {0x9E,0xCE}, {0x8E,0xE5}, {0x9E,0x7B},
    {0x9B,0xD2}, {0x8A,0xA5}, {0xFE,0xCE}, {0x8A,0x45},
    {0x9D,0xFC}, {0xFE,0xCF}, {0x8B,0xA5}, {0x8C,0x4A},
    {0x8A,0xEC}, {0xFC,0xE0}, {0x94,0xAD}, {0xFE,0xD5},
    {0x94,0xAC}, {0xFC,0x5A}, {0x9B,0xD6}, {0x8A,0x6F},
    {0x8B,0xA9}, {0x8E,0x5F}, {0x9D,0xCB}, {0xFC,0xE7},
    {0x9B,0xD7}, {0x93,0xC8}, {0x91,0xF0}, {0x8F,0xE0},
    {0x9B,0xDB}, {0x90,0xED}, {0x9B,0xDC}, {0xA0,0xEC},
    {0x98,0xFA}, {0x9B,0xE0}, {0x93,0xC7}, {0x92,0x49},
    {0x96,0xE1}, {0x9B,0xE2}, {0x9B,0xE4}, {0x8F,0xE1},
    {0x9B,0xE5}, {0x94,0xC0}, {0x93,0xC3}, {0x93,0xC5},
    {0x90,0x79}, {0x97,0x7B}, {0x90,0x7E}, {0xFE,0xE6},
    {0xFE,0x46}, {0x9D,0xB8}, {0x92,0x70}, {0x95,0xA8},
    {0x8C,0xB0}, {0x94,0xC8}, {0x98,0xB9}, {0x91,0x40},
    {0xFC,0xBE}, {0x91,0x57}, {0x8B,0xB2}, {0xFA,0xDF},
    {0x9B,0xE6}, {0x96,0x43}, {0x8E,0x44}, {0x9C,0x4F},
    {0xFE,0xF4}, {0x9B,0xE8}, {0x93,0xDC}, {0x96,0x6F},
    {0x8E,0x4A}, {0x9B,0xED}, {0x92,0xF6}, {0x9D,0xB9},
    {0x8E,0x4E}, {0xFB,0xCF}, {0x9E,0xC2}, {0x94,0xE5},
    {0x9B,0xF0}, {0x94,0xE4}, {0x95,0x51}, {0x8B,0xBB},
    {0x9B,0xF1}, {0x94,0xF0}, {0x8E,0x64}, {0x94,0xEA},
    {0x8F,0x61}, {0x9B,0x64}, {0x8E,0x5B}, {0x9B,0xF2},
    {0x9F,0xBE}, {0x9D,0xC9}, {0x8E,0x6C}, {0x8F,0x73},
    {0x8C,0xAF}, {0x8F,0x75}, {0x8E,0x71}, {0x8E,0x60},
    {0x8E,0x6A}, {0x8C,0x4C}, {0x95,0x52}, {0x95,0x54},
    {0x8A,0xD4}, {0x9D,0xBB}, {0x95,0x43}, {0x92,0xFE},
    {0x94,0xF2}, {0x94,0xF1}, {0xA0,0xEA}, {0x9D,0xD2},
    {0xA0,0xB1}, {0x91,0xF8}, {0x94,0x62}, {0x9B,0xA4},
    {0x8E,0xAD}, {0x9E,0xAD}, {0x96,0xD0}, {0xFE,0xEE},
    {0x8A,0xB4}, {0x97,0x57}, {0x8A,0x77}, {0x9B,0xF7},
    {0x8E,0xB5}, {0xA0,0x6D}, {0x8E,0xB6}, {0x97,0x56},
    {0x95,0x40}, {0xA0,0xF3}, {0x94,0xBE}, {0x9B,0xFA},
    {0xFD,0xDF}, {0x9D,0xBC}, {0x94,0xFE}, {0x8B,0xDB},
    {0xA0,0xFE}, {0x8E,0xC0}, {0x9F,0x47}, {0x8B,0xDE},
    {0xA0,0xFB}, {0x8E,0xC3}, {0x96,0x49}, {0xFE,0xC2},
    {0x95,0x4C}, {0x9B,0xFD}, {0x90,0xCC}, {0x9C,0x60},
    {0x95,0x4B}, {0x9B,0xFE}, {0x9C,0x70}, {0x9C,0x43},
    {0x9C,0x47}, {0x8E,0xCC}, {0x8E,0x54}, {0x8E,0xE4},
    {0x9C,0x49}, {0x8B,0x5E}, {0x95,0x5E}, {0x95,0x5C},
    {0x9C,0x4B}, {0x8B,0xE1}, {0x8E,0xD9}, {0x9D,0xB4},
    {0x92,0x5F}, {0x9C,0x4C}, {0x8A,0xA1}, {0x8E,0xDB},
    {0x9C,0x56}, {0x8A,0xA2}, {0x97,0x54}, {0x9C,0x5E},
    {0x9E,0xD4}, {0x95,0x68}, {0xA0,0xC3}, {0x8A,0xE6},
    {0xA0,0xF7}, {0x9C,0x61}, {0x9C,0x5F}, {0xFC,0x4D},
    {0x9E,0x5B}, {0x9E,0x69}, {0x9C,0x63}, {0xFE,0xC7},
    {0xFE,0xC6}, {0x9C,0x67}, {0x9C,0x69}, {0x8B,0xE2},
    {0x91,0x65}, {0x9C,0xE7}, {0x8A,0x54}, {0x9C,0x6C},
    {0x9C,0x6E}, {0xFE,0x5D}, {0x9C,0x73}, {0x95,0x6A},
    {0x95,0x6D}, {0x8E,0xF0}, {0x8F,0x4D}, {0x8E,0xF6},
    {0xFA,0xBC}, {0x8C,0xD5}, {0xFB,0xDA}, {0x8B,0x4C},
    {0xFD,0x75}, {0x9B,0xDD}, {0xFA,0xF5}, {0x9C,0x74},
    {0x95,0x45}, {0x96,0xC6}, {0x8F,0x6A}, {0x8F,0x4E},
    {0x9C,0x78}, {0xFA,0x55}, {0x97,0xE4}, {0x9C,0x41},
    {0x92,0x5C}, {0x96,0xFA}, {0xFB,0x66}, {0x8E,0x65},
    {0x98,0x49}, {0xFB,0xA8}, {0x98,0x42}, {0x9C,0x7A},
    {0x97,0xFB}, {0x90,0xCA}, {0x9C,0x5B}, {0x97,0x4D},
    {0x8E,0xD3}, {0x95,0x61}, {0x9F,0x4B}, {0x9F,0xB5},
    {0x93,0xD2}, {0xFD,0xAA}, {0x98,0x40}, {0x91,0x46},
    {0x98,0x67}, {0xFA,0x5A}, {0xFB,0xA9}, {0x98,0x41},
    {0x8C,0xD3}, {0xFC,0xFD}, {0xFD,0xAB}, {0x91,0xBD},
    {0x8F,0x4C}, {0x96,0xC9}, {0x8F,0x55}, {0xFB,0xAE},
    {0x95,0x6F}, {0x9C,0x7D}, {0xA0,0xF0}, {0x94,0x6F},
    {0xFD,0xAC}, {0x96,0xCB}, {0x96,0xCE}, {0xA0,0x56},
    {0x9C,0xE1}, {0x96,0xC4}, {0x8F,0x5E}, {0x8F,0x6C},
    {0x8E,0xA3}, {0xFB,0xB3}, {0xFC,0x53}, {0xFD,0xB3},
    {0x8F,0x6B}, {0x96,0xCA}, {0x8F,0x79}, {0x9E,0x6F},
    {0xA0,0xC5}, {0xFC,0x78}, {0x8E,0x42}, {0x8F,0x5A},
    {0x90,0xC2}, {0x8E,0xA5}, {0x90,0x61}, {0x92,0x4F},
    {0x93,0x73}, {0xFD,0xB5}, {0xFE,0xCC}, {0xFB,0xBD},
    {0x8C,0xD6}, {0x98,0x43}, {0x96,0xC5}, {0x89,0xBC},
    {0x9C,0xA3}, {0x92,0x4B}, {0x98,0x4A}, {0x8F,0xA4},
    {0xA0,0xF1}, {0x9E,0xFB}, {0x9C,0xD2}, {0x8F,0xA7},
    {0xFC,0x5C}, {0x98,0x45}, {0x90,0x46}, {0x8C,0xD1},
    {0xFE,0xFA}, {0x95,0x60}, {0x9F,0x48}, {0x92,0x47},
    {0x90,0xFB}, {0x9C,0xA4}, {0x95,0x71}, {0x9C,0xA6},
    {0x9C,0xA7}, {0x9C,0xAA}, {0x9E,0xD3}, {0x9E,0x70},
    {0x9C,0xAC}, {0x8F,0xAE}, {0x95,0x7D}, {0x9C,0xB0},
    {0x97,0xB6}, {0xA0,0xBD}, {0x8A,0xDF}, {0x9E,0xAA},
    {0x8F,0xBD}, {0x8F,0xBF}, {0x93,0x69}, {0x9B,0xA7},
    {0xC8,0xA4}, {0xFE,0xEA}, {0x9B,0xE1}, {0x8B,0x41},
    {0x9D,0xB6}, {0xA0,0xEB}, {0x9B,0xA3}, {0x8B,0xA1},
    {0x8F,0xC8}, {0x89,0x4C}, {0x98,0x60}, {0x94,0xC7},
    {0x8B,0x58}, {0x95,0xAB}, {0x95,0xAA}, {0x9C,0xC3},
    {0x9C,0xC4}, {0x93,0xD6}, {0x9D,0xAC}, {0x8B,0xE6},
    {0x8A,0x71}, {0x8F,0xD1}, {0x99,0xD5}, {0x90,0xF4},
    {0x8A,0xA3}, {0x9C,0xCE}, {0x9C,0xD4}, {0x9C,0xD5},
    {0xFB,0xC8}, {0x9D,0xB3}, {0xFC,0x70}, {0x8F,0xD7},
    {0x9B,0x73}, {0xFA,0x5B}, {0x8F,0xD2}, {0x90,0x64},
    {0x98,0xB6}, {0x96,0x68}, {0x9C,0xD6}, {0x98,0xBD},
    {0x8F,0xDC}, {0xFE,0xF6}, {0x8F,0xD9}, {0x95,0x41},
    {0x97,0xF3}, {0x9B,0xF8}, {0x9E,0x6C}, {0x8F,0xF2},
    {0x8F,0xEE}, {0x9C,0xD7}, {0x9E,0x6E}, {0x8A,0x40},
    {0x8F,0xEF}, {0x8F,0xF4}, {0x8F,0xF5}, {0x95,0xC2},
    {0x98,0x6A}, {0x97,0xCF}, {0x9E,0x7C}, {0x90,0x41},
    {0x9C,0xDB}, {0x94,0x41}, {0x9C,0xE6}, {0x9D,0xB0},
    {0x9C,0xEA}, {0x9C,0xED}, {0x9C,0xFA}, {0x8B,0x62},
    {0x8A,0x4E}, {0x9C,0xCA}, {0x8A,0x66}, {0x9C,0xFB},
    {0x9C,0xFC}, {0x9C,0xFE}, {0x8A,0x53}, {0x9C,0xE5},
    {0x9D,0x40}, {0x9D,0x41}, {0x90,0x45}, {0x8B,0x73},
    {0x97,0xCA}, {0x9D,0x42}, {0x8A,0x61}, {0x8B,0xAE},
    {0x8A,0xD2}, {0x8B,0xA2}, {0x9D,0xF2}, {0x9D,0x43},
    {0x9C,0xDF}, {0x9D,0x44}, {0x8E,0xCA}, {0x90,0x4E},
    {0x8E,0xB3}, {0x9F,0xF5}, {0x9D,0x45}, {0x90,0x4F},
    {0x9D,0x47}, {0x89,0xCA}, {0x9C,0xB5}, {0xFB,0xFE},
    {0x90,0x5E}, {0x90,0x63}, {0x90,0x57}, {0x90,0x66},
    {0x9B,0xC0}, {0xFC,0xE5}, {0x91,0x62}, {0x90,0x67},
    {0x8F,0xA1}, {0x8F,0xA2}, {0x9D,0x48}, {0xFA,0xD3},
    {0x90,0x5D}, {0x90,0xB9}, {0x90,0x6B}, {0x8C,0x5C},
    {0x90,0x69}, {0xFE,0x57}, {0xFE,0x55}, {0x90,0x73},
    {0x9B,0xEF}, {0x9C,0xF0}, {0x9D,0x4B}, {0xFE,0xD9},
    {0xFE,0xDA}, {0x91,0xE0}, {0x91,0xD8}, {0x96,0x46},
    {0x93,0x60}, {0xFA,0x53}, {0x9C,0xD3}, {0x9D,0x4E},
    {0xFB,0x40}, {0x8D,0xE2}, {0x94,0x42}, {0x90,0x56},
    {0x98,0x65}, {0x8C,0x6C}, {0xFA,0x4A}, {0x9D,0x50},
    {0x9D,0x52}, {0x95,0xAF}, {0x97,0x5A}, {0x93,0x49},
    {0x97,0x47}, {0xA0,0xF4}, {0x97,0x78}, {0x8F,0xCF},
    {0xFC,0x60}, {0x8C,0x4E}, {0xFC,0x56}, {0x91,0xDC},
    {0x96,0x61}, {0x92,0xEC}, {0x93,0x5D}, {0x8E,0xDE},
    {0x96,0xFE}, {0xFD,0x4F}, {0x95,0xDE}, {0x98,0xB0},
    {0xA0,0x40}, {0x97,0xBD}, {0x97,0x7D}, {0x97,0xF5},
    {0x9B,0xAC}, {0xFA,0xDA}, {0x92,0xC2}, {0x97,0xB1},
    {0x90,0x7B}, {0x93,0xFE}, {0x94,0x7B}, {0x97,0x77},
    {0xFA,0xBE}, {0xFD,0x43}, {0x90,0xC6}, {0x90,0xA4},
    {0x90,0xA8}, {0x94,0xA9}, {0x90,0xA9}, {0x8C,0x65},
    {0x95,0xE0}, {0x90,0x7D}, {0x92,0x65}, {0xFD,0xBA},
    {0x93,0xC4}, {0xFE,0xED}, {0x9D,0xAB}, {0xA0,0xE3},
    {0x96,0x48}, {0x9D,0x53}, {0x8A,0xA9}, {0x9B,0xC5},
    {0x96,0x5D}, {0x97,0x5F}, {0x96,0x5F}, {0x96,0x6E},
    {0xFB,0x5D}, {0x9D,0xB1}, {0xFE,0xA3}, {0x9D,0xB2},
    {0x95,0xAE}, {0xFC,0xA3}, {0xA0,0xA2}, {0x96,0x55},
    {0x9D,0x54}, {0x93,0x41}, {0x95,0xAD}, {0x91,0xD5},
    {0x97,0x7A}, {0xFD,0xFC}, {0x8E,0x47}, {0x93,0xFD},
    {0x90,0xA5}, {0x90,0xAC}, {0x95,0xAC}, {0x90,0xAE},
    {0xFE,0xA5}, {0x9D,0x56}, {0x97,0xE3}, {0x95,0xE2},
    {0x94,0x66}, {0x96,0x47}, {0x91,0xB8}, {0x9C,0xEC},
    {0x90,0xAD}, {0x95,0xE3}, {0x8B,0x4F}, {0x8A,0xE3},
    {0x8B,0x4D}, {0x95,0xEA}, {0x8B,0x4E}, {0x8C,0xC1},
    {0x8B,0xED}, {0x91,0xD9}, {0xA0,0xA4}, {0x95,0xF5},
    {0x95,0xF4}, {0x9F,0xB3}, {0xFE,0xAF}, {0xFE,0x72},
    {0x92,0x7A}, {0xFE,0xAC}, {0x95,0xF3}, {0x9D,0x58},
    {0x93,0x72}, {0x91,0xC5}, {0x96,0x42}, {0x90,0xCD},
    {0x95,0xFE}, {0x91,0x59}, {0x9C,0x65}, {0x97,0xCC},
    {0x90,0xCE}, {0x9D,0x59}, {0xFC,0xF5}, {0xFE,0xFD},
    {0x9D,0x5B}, {0x9D,0x5C}, {0x93,0x7E}, {0x98,0xAC},
    {0x9D,0x5E}, {0xFD,0xD0}, {0xFD,0x60}, {0x9C,0xCF},
    {0x90,0xDD}, {0x90,0xE0}, {0x90,0xF3}, {0x98,0xB1},
    {0x90,0xF0}, {0x93,0xBD}, {0x95,0xB7}, {0x9F,0x46},
    {0x8E,0x4B}, {0x96,0x58}, {0x8A,0x4C}, {0x9D,0x63},
    {0x9E,0xCF}, {0x9D,0x65}, {0x9D,0x66}, {0x96,0x5A},
    {0x9D,0x64}, {0x8A,0x6C}, {0x8A,0xD9}, {0x9D,0x67},
    {0x8A,0x70}, {0x8B,0xF3}, {0x91,0x50}, {0x9C,0xC1},
    {0x9D,0x68}, {0x93,0xA7}, {0x96,0x74}, {0xA0,0xEF},
    {0x91,0x51}, {0x96,0xC1}, {0x8C,0x64}, {0x96,0x76},
    {0x9D,0x69}, {0xFC,0xA4}, {0x9D,0x6A}, {0x92,0x4E},
    {0x9D,0x6B}, {0x9B,0xC1}, {0x9D,0x6C}, {0x8A,0x65},
    {0x91,0x5D}, {0x9D,0x6D}, {0x91,0x5A}, {0x8C,0x42},
    {0x9C,0xC0}, {0x91,0x6A}, {0x9D,0x6E}, {0x9E,0xA6},
    {0x9D,0xCD}, {0x9D,0x6F}, {0x89,0xBB}, {0x9E,0xF9},
    {0x96,0xB4}, {0x91,0x72}, {0x9E,0xC8}, {0x8B,0x55},
    {0x9D,0x71}, {0x9D,0x72}, {0x9E,0xCC}, {0x91,0x74},
    {0x9E,0xD0}, {0x90,0x5C}, {0x8E,0xD2}, {0x91,0xA8},
    {0x91,0x77}, {0x96,0xBF}, {0x96,0xC0}, {0x8F,0xB1},
    {0x96,0xB7}, {0x8C,0x55}, {0x91,0x78}, {0x89,0xBE},
    {0x91,0x7C}, {0xFB,0x77}, {0x91,0x75}, {0x91,0xA3},
    {0x91,0x76}, {0x96,0xBE}, {0x91,0x79}, {0x96,0xB6},
    {0x91,0xA4}, {0x91,0xA6}, {0x9D,0x75}, {0x90,0x52},
    {0xA0,0x45}, {0x91,0xA9}, {0x98,0xAA}, {0x8C,0x5F},
    {0x8B,0xAA}, {0x9C,0xDD}, {0x9D,0x77}, {0x89,0x40},
    {0x9E,0xEC}, {0x93,0xAA}, {0x94,0x78}, {0x9D,0x7A},
    {0x8A,0xC9}, {0x8B,0x4B}, {0x9F,0xEC}, {0x8A,0xE2},
    {0x9E,0x75}, {0x98,0x74}, {0x9A,0xC8}, {0xA0,0x47},
    {0x8B,0xC3}, {0xFC,0x48}, {0xFC,0x77}, {0x9C,0x52},
    {0x8E,0xFD}, {0x8F,0xA8}, {0x95,0x7A}, {0x8F,0xF0},
};

/* Index of the convert table */
static const Summary16 big5hkscs_uni2index_page00[70] = {
  /* 0x0000 */
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 },
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 },
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0xE7EE }, {   12, 0x87BF },
  {   23, 0xFFFF }, {   39, 0xFFFF }, {   55, 0xFFFF }, {   71, 0xFFFF },
  /* 0x0100 */
  {   87, 0x0003 }, {   89, 0x0C0C }, {   93, 0x0800 }, {   94, 0x0000 },
  {   94, 0x3800 }, {   97, 0x0008 }, {   98, 0x0800 }, {   99, 0x0000 },
  {   99, 0x0000 }, {   99, 0x0000 }, {   99, 0x0000 }, {   99, 0x0000 },
  {   99, 0x6000 }, {  101, 0x1557 }, {  109, 0x0000 }, {  109, 0x0000 },
  /* 0x0200 */
  {  109, 0x0000 }, {  109, 0x0000 }, {  109, 0x0000 }, {  109, 0x0000 },
  {  109, 0x0000 }, {  109, 0x0813 }, {  113, 0x0402 }, {  115, 0x0020 },
  {  116, 0x0408 }, {  118, 0x0000 }, {  118, 0x0000 }, {  118, 0x0000 },
  {  118, 0x2EC0 }, {  124, 0x0200 }, {  125, 0x0000 }, {  125, 0x0000 },
  /* 0x0300 */
  {  125, 0x0020 }, {  126, 0x0000 }, {  126, 0x0000 }, {  126, 0x0000 },
  {  126, 0x0000 }, {  126, 0x0000 }, {  126, 0x0000 }, {  126, 0x0000 },
  {  126, 0x0000 }, {  126, 0xFFFE }, {  141, 0x03FB }, {  150, 0xFFFE },
  {  165, 0x03FB }, {  174, 0x0000 }, {  174, 0x0000 }, {  174, 0x0000 },
  /* 0x0400 */
  {  174, 0x0002 }, {  175, 0xFFFF }, {  191, 0xFFFF }, {  207, 0xFFFF },
  {  223, 0xFFFF }, {  239, 0x0002 },
};
static const Summary16 big5hkscs_uni2index_page1e[13] = {
  /* 0x1E00 */
  {  240, 0x0000 }, {  240, 0x0000 }, {  240, 0x0000 }, {  240, 0x0000 },
  {  240, 0x0000 }, {  240, 0x0000 }, {  240, 0x0000 }, {  240, 0x0000 },
  {  240, 0x0000 }, {  240, 0x0000 }, {  240, 0x0000 }, {  240, 0xC000 },
  {  242, 0x0003 },
};
static const Summary16 big5hkscs_uni2index_page20[116] = {
  /* 0x2000 */
  {  244, 0x0000 }, {  244, 0x3378 }, {  252, 0x00F4 }, {  257, 0x482C },
  {  262, 0x0000 }, {  262, 0x0000 }, {  262, 0x0000 }, {  262, 0x0000 },
  {  262, 0x0000 }, {  262, 0x0000 }, {  262, 0x1000 }, {  263, 0x0000 },
  {  263, 0x0000 }, {  263, 0x0000 }, {  263, 0x0000 }, {  263, 0x0000 },
  /* 0x2100 */
  {  263, 0x0228 }, {  266, 0x0040 }, {  267, 0x0002 }, {  268, 0x0000 },
  {  268, 0x0000 }, {  268, 0x0000 }, {  268, 0x03FF }, {  278, 0x03FF },
  {  288, 0x0000 }, {  288, 0x03CF }, {  296, 0x0000 }, {  296, 0x0300 },
  {  298, 0x0000 }, {  298, 0x0000 }, {  298, 0x0080 }, {  299, 0x0000 },
  /* 0x2200 */
  {  299, 0x0000 }, {  299, 0xC560 }, {  305, 0x4E29 }, {  312, 0x0030 },
  {  314, 0x0000 }, {  314, 0x0004 }, {  315, 0x00CB }, {  320, 0x0000 },
  {  320, 0x0000 }, {  320, 0x0220 }, {  322, 0x0020 }, {  323, 0x8000 },
  {  324, 0x0000 }, {  324, 0x0000 }, {  324, 0x0000 }, {  324, 0x0000 },
  /* 0x2300 */
  {  324, 0x0080 }, {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 },
  {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 },
  {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 },
  {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 },
  /* 0x2400 */
  {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 },
  {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x03FF }, {  335, 0x3FF0 },
  {  345, 0x0000 }, {  345, 0x0000 }, {  345, 0x0000 }, {  345, 0x0000 },
  {  345, 0x0000 }, {  345, 0x0000 }, {  345, 0x0000 }, {  345, 0x0000 },
  /* 0x2500 */
  {  345, 0x1005 }, {  348, 0x1111 }, {  352, 0x1010 }, {  354, 0x1010 },
  {  356, 0x0000 }, {  356, 0xFFFF }, {  372, 0xFFFF }, {  388, 0x001F },
  {  393, 0xFFFE }, {  408, 0x0038 }, {  411, 0x0003 }, {  413, 0x300C },
  {  417, 0xC8C0 }, {  422, 0x0000 }, {  422, 0x003C }, {  426, 0x0000 },
  /* 0x2600 */
  {  426, 0x0260 }, {  429, 0x0000 }, {  429, 0x0000 }, {  429, 0x0000 },
  {  429, 0x0007 }, {  432, 0x0000 }, {  432, 0x0000 }, {  432, 0x0000 },
  {  432, 0x0000 }, {  432, 0x0000 }, {  432, 0x0000 }, {  432, 0x0000 },
  {  432, 0x0000 }, {  432, 0x0000 }, {  432, 0x0000 }, {  432, 0x0000 },
  /* 0x2700 */
  {  432, 0x0000 }, {  432, 0x0000 }, {  432, 0x0000 }, {  432, 0x2000 },
};
static const Summary16 big5hkscs_uni2index_page2e[1819] = {
  /* 0x2E00 */
  {  433, 0x0000 }, {  433, 0x0000 }, {  433, 0x0000 }, {  433, 0x0000 },
  {  433, 0x0000 }, {  433, 0x0000 }, {  433, 0x0000 }, {  433, 0x0000 },
  {  433, 0x35D1 }, {  441, 0x3020 }, {  444, 0x54A0 }, {  449, 0x5040 },
  {  452, 0xB440 }, {  457, 0x40C0 }, {  460, 0x0008 }, {  461, 0x0000 },
  /* 0x2F00 */
  {  461, 0x0000 }, {  461, 0x0000 }, {  461, 0x0000 }, {  461, 0x0008 },
  {  462, 0x0000 }, {  462, 0x0000 }, {  462, 0x0000 }, {  462, 0x0000 },
  {  462, 0x0000 }, {  462, 0x0000 }, {  462, 0x0000 }, {  462, 0x0000 },
  {  462, 0x0000 }, {  462, 0x0000 }, {  462, 0x0000 }, {  462, 0x0000 },
  /* 0x3000 */
  {  462, 0xFFEF }, {  477, 0x7037 }, {  485, 0x03FE }, {  494, 0x0001 },
  {  495, 0xFFFE }, {  510, 0xFFFF }, {  526, 0xFFFF }, {  542, 0xFFFF },
  {  558, 0xFFFF }, {  574, 0x780F }, {  582, 0xFFFE }, {  597, 0xFFFF },
  {  613, 0xFFFF }, {  629, 0xFFFF }, {  645, 0xFFFF }, {  661, 0x707F },
  /* 0x3100 */
  {  671, 0xFFE0 }, {  682, 0xFFFF }, {  698, 0x03FF }, {  708, 0x0000 },
  {  708, 0x0000 }, {  708, 0x0000 }, {  708, 0x0000 }, {  708, 0x0000 },
  {  708, 0x0000 }, {  708, 0xFFFC }, {  722, 0x0000 }, {  722, 0x0000 },
  {  722, 0x0000 }, {  722, 0x0000 }, {  722, 0x0000 }, {  722, 0x0000 },
  /* 0x3200 */
  {  722, 0x0000 }, {  722, 0x0000 }, {  722, 0xFFFF }, {  738, 0xFFFF },
  {  754, 0x000F }, {  758, 0x0000 }, {  758, 0x0000 }, {  758, 0x0000 },
  {  758, 0xFFFF }, {  774, 0xFFFF }, {  790, 0xFFFF }, {  806, 0x0001 },
  {  807, 0x0000 }, {  807, 0x0000 }, {  807, 0x0000 }, {  807, 0x0000 },
  /* 0x3300 */
  {  807, 0x0000 }, {  807, 0x0000 }, {  807, 0x0000 }, {  807, 0x0000 },
  {  807, 0x0000 }, {  807, 0x0000 }, {  807, 0x0000 }, {  807, 0x0000 },
  {  807, 0xC000 }, {  809, 0x7000 }, {  812, 0x0002 }, {  813, 0x0000 },
  {  813, 0x4010 }, {  815, 0x0026 }, {  818, 0x0000 }, {  818, 0x0000 },
  /* 0x3400 */
  {  818, 0x0000 }, {  818, 0x0000 }, {  818, 0x0000 }, {  818, 0x0020 },
  {  819, 0x1001 }, {  821, 0x0000 }, {  821, 0x0010 }, {  822, 0x6408 },
  {  826, 0x0000 }, {  826, 0x0048 }, {  828, 0x8020 }, {  830, 0x1000 },
  {  831, 0x0102 }, {  833, 0x8000 }, {  834, 0x0010 }, {  835, 0x0800 },
  /* 0x3500 */
  {  836, 0x0040 }, {  837, 0x0000 }, {  837, 0x0000 }, {  837, 0x4000 },
  {  838, 0x0000 }, {  838, 0x020A }, {  841, 0x2002 }, {  843, 0x0185 },
  {  847, 0x0010 }, {  848, 0x0180 }, {  850, 0x2022 }, {  853, 0x8000 },
  {  854, 0x44A2 }, {  859, 0x2844 }, {  863, 0x0000 }, {  863, 0x480E },
  /* 0x3600 */
  {  868, 0x0200 }, {  869, 0x0500 }, {  871, 0x2008 }, {  873, 0x4220 },
  {  876, 0x4380 }, {  880, 0x8000 }, {  881, 0x0000 }, {  881, 0x0400 },
  {  882, 0x0002 }, {  883, 0x0400 }, {  884, 0x1420 }, {  887, 0x1223 },
  {  892, 0x01BA }, {  898, 0x2058 }, {  902, 0x0066 }, {  906, 0x0020 },
  /* 0x3700 */
  {  907, 0x250A }, {  912, 0x1000 }, {  913, 0x302C }, {  918, 0x040D },
  {  922, 0x0009 }, {  924, 0x0000 }, {  924, 0x8004 }, {  926, 0x0000 },
  {  926, 0x0000 }, {  926, 0x0080 }, {  927, 0x0001 }, {  928, 0x4200 },
  {  930, 0x0000 }, {  930, 0x0000 }, {  930, 0x0000 }, {  930, 0x0904 },
  /* 0x3800 */
  {  933, 0x8000 }, {  934, 0x0200 }, {  935, 0x2001 }, {  937, 0x0140 },
  {  939, 0x0000 }, {  939, 0x0000 }, {  939, 0x0008 }, {  940, 0x0000 },
  {  940, 0x0000 }, {  940, 0x0000 }, {  940, 0x0001 }, {  941, 0x0000 },
  {  941, 0x1008 }, {  943, 0x0002 }, {  944, 0x0000 }, {  944, 0x0400 },
  /* 0x3900 */
  {  945, 0x0100 }, {  946, 0x0010 }, {  947, 0x0080 }, {  948, 0x8004 },
  {  950, 0x2000 }, {  951, 0x0000 }, {  951, 0x0008 }, {  952, 0x0000 },
  {  952, 0x0601 }, {  955, 0x0A04 }, {  958, 0x0012 }, {  960, 0x0100 },
  {  961, 0x0000 }, {  961, 0x1000 }, {  962, 0x1024 }, {  965, 0x4900 },
  /* 0x3A00 */
  {  968, 0x004A }, {  971, 0x0180 }, {  973, 0x0600 }, {  975, 0x0010 },
  {  976, 0x0800 }, {  977, 0x5084 }, {  981, 0x00C0 }, {  983, 0x0000 },
  {  983, 0x0000 }, {  983, 0x0080 }, {  984, 0x0800 }, {  985, 0x2000 },
  {  986, 0x0000 }, {  986, 0x4000 }, {  987, 0x0001 }, {  988, 0x0805 },
  /* 0x3B00 */
  {  991, 0x4000 }, {  992, 0x0200 }, {  993, 0x0804 }, {  995, 0x0200 },
  {  996, 0x0004 }, {  997, 0x0100 }, {  998, 0x0001 }, {  999, 0x1806 },
  { 1003, 0x0001 }, { 1004, 0x0240 }, { 1006, 0x0002 }, { 1007, 0x5000 },
  { 1009, 0x0014 }, { 1011, 0x2080 }, { 1013, 0x1000 }, { 1014, 0x001C },
  /* 0x3C00 */
  { 1017, 0x2000 }, { 1018, 0x0122 }, { 1021, 0x0000 }, { 1021, 0x0000 },
  { 1021, 0x0000 }, { 1021, 0x0010 }, { 1022, 0x0000 }, { 1022, 0x0000 },
  { 1022, 0x0800 }, { 1023, 0x0000 }, { 1023, 0x0000 }, { 1023, 0x0000 },
  { 1023, 0x2800 }, { 1025, 0x1042 }, { 1028, 0x8800 }, { 1030, 0x0000 },
  /* 0x3D00 */
  { 1030, 0x0000 }, { 1030, 0x2008 }, { 1032, 0x0000 }, { 1032, 0x0804 },
  { 1034, 0x5040 }, { 1037, 0x8002 }, { 1039, 0x8604 }, { 1043, 0x2020 },
  { 1045, 0x8420 }, { 1048, 0x0002 }, { 1049, 0x2020 }, { 1051, 0x8010 },
  { 1053, 0x32C0 }, { 1058, 0x0808 }, { 1060, 0x0980 }, { 1063, 0x3088 },
  /* 0x3E00 */
  { 1067, 0x0040 }, { 1068, 0x0000 }, { 1068, 0x0000 }, { 1068, 0x0000 },
  { 1068, 0x0109 }, { 1071, 0x0020 }, { 1072, 0x0000 }, { 1072, 0x0010 },
  { 1073, 0x0000 }, { 1073, 0x0000 }, { 1073, 0x2700 }, { 1077, 0x8102 },
  { 1080, 0x1484 }, { 1084, 0x4CC3 }, { 1091, 0x0A86 }, { 1096, 0x9419 },
  /* 0x3F00 */
  { 1102, 0x4051 }, { 1106, 0x0000 }, { 1106, 0x0000 }, { 1106, 0x0000 },
  { 1106, 0x0000 }, { 1106, 0x0308 }, { 1109, 0x0008 }, { 1110, 0x1000 },
  { 1111, 0x0000 }, { 1111, 0x0008 }, { 1112, 0x0000 }, { 1112, 0x0000 },
  { 1112, 0x0001 }, { 1113, 0x1080 }, { 1115, 0x2020 }, { 1117, 0x0600 },
  /* 0x4000 */
  { 1119, 0x0210 }, { 1121, 0x2000 }, { 1122, 0x0000 }, { 1122, 0x0200 },
  { 1123, 0x0020 }, { 1124, 0x0088 }, { 1126, 0x8424 }, { 1130, 0x0002 },
  { 1131, 0x0000 }, { 1131, 0x0000 }, { 1131, 0x0100 }, { 1132, 0x8800 },
  { 1134, 0x0100 }, { 1135, 0x8100 }, { 1137, 0x0000 }, { 1137, 0x0400 },
  /* 0x4100 */
  { 1138, 0x4218 }, { 1142, 0x0000 }, { 1142, 0x0000 }, { 1142, 0x0004 },
  { 1143, 0x0000 }, { 1143, 0x0000 }, { 1143, 0x5080 }, { 1146, 0x8000 },
  { 1147, 0x0000 }, { 1147, 0x0001 }, { 1148, 0x0000 }, { 1148, 0x0004 },
  { 1149, 0x8410 }, { 1152, 0x0800 }, { 1153, 0x8000 }, { 1154, 0x0200 },
  /* 0x4200 */
  { 1155, 0x0000 }, { 1155, 0x0002 }, { 1156, 0x0008 }, { 1157, 0x0000 },
  { 1157, 0x0001 }, { 1158, 0x0000 }, { 1158, 0x0401 }, { 1160, 0x0440 },
  { 1162, 0x1000 }, { 1163, 0x0010 }, { 1164, 0x0004 }, { 1165, 0x1220 },
  { 1168, 0x0000 }, { 1168, 0x0000 }, { 1168, 0x0000 }, { 1168, 0x1810 },
  /* 0x4300 */
  { 1171, 0x0000 }, { 1171, 0x0000 }, { 1171, 0x0800 }, { 1172, 0x0000 },
  { 1172, 0x0000 }, { 1172, 0x0000 }, { 1172, 0x4000 }, { 1173, 0x0000 },
  { 1173, 0x0000 }, { 1173, 0x0080 }, { 1174, 0x0000 }, { 1174, 0x0400 },
  { 1175, 0x0002 }, { 1176, 0x8200 }, { 1178, 0x2000 }, { 1179, 0x0004 },
  /* 0x4400 */
  { 1180, 0x0006 }, { 1182, 0x0008 }, { 1183, 0x2020 }, { 1185, 0x0000 },
  { 1185, 0x0000 }, { 1185, 0x0000 }, { 1185, 0x0000 }, { 1185, 0x0400 },
  { 1186, 0x8000 }, { 1187, 0x8000 }, { 1188, 0x0005 }, { 1190, 0x0081 },
  { 1192, 0x4021 }, { 1195, 0xA000 }, { 1197, 0x1E10 }, { 1202, 0x0010 },
  /* 0x4500 */
  { 1203, 0x0A18 }, { 1207, 0x2040 }, { 1209, 0x4080 }, { 1211, 0xA808 },
  { 1215, 0x0008 }, { 1216, 0x1026 }, { 1220, 0x0404 }, { 1222, 0x0080 },
  { 1223, 0x0020 }, { 1224, 0x0000 }, { 1224, 0x0000 }, { 1224, 0x0000 },
  { 1224, 0x0000 }, { 1224, 0x0000 }, { 1224, 0x0200 }, { 1225, 0x0000 },
  /* 0x4600 */
  { 1225, 0x8040 }, { 1227, 0x00A0 }, { 1229, 0x0000 }, { 1229, 0x0000 },
  { 1229, 0x0000 }, { 1229, 0x0800 }, { 1230, 0x0000 }, { 1230, 0x0400 },
  { 1231, 0x0001 }, { 1232, 0x0000 }, { 1232, 0x0000 }, { 1232, 0x0000 },
  { 1232, 0x8000 }, { 1233, 0x0001 }, { 1234, 0x0000 }, { 1234, 0x0020 },
  /* 0x4700 */
  { 1235, 0x0000 }, { 1235, 0x0108 }, { 1237, 0x0000 }, { 1237, 0x0000 },
  { 1237, 0x4000 }, { 1238, 0x0000 }, { 1238, 0x0000 }, { 1238, 0x1000 },
  { 1239, 0x0000 }, { 1239, 0x0100 }, { 1240, 0x0040 }, { 1241, 0x0040 },
  { 1242, 0x0000 }, { 1242, 0x0020 }, { 1243, 0x2000 }, { 1244, 0x0010 },
  /* 0x4800 */
  { 1245, 0x0801 }, { 1247, 0x0000 }, { 1247, 0x0000 }, { 1247, 0x0080 },
  { 1248, 0x0000 }, { 1248, 0x2000 }, { 1249, 0x0000 }, { 1249, 0x0002 },
  { 1250, 0x0000 }, { 1250, 0x0800 }, { 1251, 0x6000 }, { 1253, 0x0000 },
  { 1253, 0x0000 }, { 1253, 0x2001 }, { 1255, 0x2000 }, { 1256, 0x0408 },
  /* 0x4900 */
  { 1258, 0x0040 }, { 1259, 0x4002 }, { 1261, 0x2420 }, { 1264, 0x5020 },
  { 1267, 0x0020 }, { 1268, 0x000A }, { 1270, 0x0420 }, { 1272, 0x0004 },
  { 1273, 0x0200 }, { 1274, 0x0000 }, { 1274, 0x0082 }, { 1276, 0x0000 },
  { 1276, 0x0000 }, { 1276, 0x8000 }, { 1277, 0x00A0 }, { 1279, 0x0000 },
  /* 0x4A00 */
  { 1279, 0x8000 }, { 1280, 0x2000 }, { 1281, 0x0010 }, { 1282, 0x0020 },
  { 1283, 0x0000 }, { 1283, 0x0000 }, { 1283, 0x0000 }, { 1283, 0x0000 },
  { 1283, 0x0000 }, { 1283, 0x0040 }, { 1284, 0x0000 }, { 1284, 0x0110 },
  { 1286, 0x0000 }, { 1286, 0x0002 }, { 1287, 0x0010 }, { 1288, 0x8000 },
  /* 0x4B00 */
  { 1289, 0x0000 }, { 1289, 0x0201 }, { 1291, 0x1001 }, { 1293, 0x0080 },
  { 1294, 0x0000 }, { 1294, 0x0000 }, { 1294, 0x8000 }, { 1295, 0x4805 },
  { 1299, 0x4000 }, { 1300, 0x20C9 }, { 1305, 0x0000 }, { 1305, 0x6000 },
  { 1307, 0x0001 }, { 1308, 0x0000 }, { 1308, 0x0000 }, { 1308, 0x0000 },
  /* 0x4C00 */
  { 1308, 0x4090 }, { 1311, 0x0000 }, { 1311, 0x0000 }, { 1311, 0x4800 },
  { 1313, 0x0000 }, { 1313, 0x0800 }, { 1314, 0x2000 }, { 1315, 0x2000 },
  { 1316, 0x0002 }, { 1317, 0x0000 }, { 1317, 0x4010 }, { 1319, 0x0081 },
  { 1321, 0x2000 }, { 1322, 0x0000 }, { 1322, 0x2002 }, { 1324, 0x0000 },
  /* 0x4D00 */
  { 1324, 0x0200 }, { 1325, 0x0001 }, { 1326, 0x0000 }, { 1326, 0x0010 },
  { 1327, 0x0000 }, { 1327, 0x0000 }, { 1327, 0x0000 }, { 1327, 0x0000 },
  { 1327, 0x0000 }, { 1327, 0x1002 }, { 1329, 0x0000 }, { 1329, 0x0000 },
  { 1329, 0x0000 }, { 1329, 0x0000 }, { 1329, 0x0000 }, { 1329, 0x0000 },
  /* 0x4E00 */
  { 1329, 0xFF9B }, { 1342, 0xD773 }, { 1353, 0xFD52 }, { 1363, 0xBBCF },
  { 1375, 0xEBAC }, { 1385, 0xFF4C }, { 1396, 0x0600 }, { 1398, 0xC108 },
  { 1402, 0x7BFF }, { 1416, 0xCF3E }, { 1427, 0x797F }, { 1439, 0x9EC8 },
  { 1447, 0x6FDF }, { 1460, 0xF7F0 }, { 1471, 0x4F3A }, { 1480, 0xA9FF },
  /* 0x4F00 */
  { 1492, 0xEF3F }, { 1505, 0x27BF }, { 1516, 0xB304 }, { 1522, 0xFFDD },
  { 1536, 0xFBEE }, { 1549, 0xFFFF }, { 1565, 0xDE9F }, { 1577, 0xFFFD },
  { 1592, 0xAFFF }, { 1606, 0x7DF7 }, { 1619, 0xC904 }, { 1624, 0xAEED },
  { 1635, 0xFFBF }, { 1650, 0xFFDB }, { 1664, 0xD033 }, { 1671, 0x67FF },
  /* 0x5000 */
  { 1684, 0xFBE9 }, { 1696, 0xDFFE }, { 1710, 0xFFEF }, { 1725, 0x18BB },
  { 1733, 0xFFEB }, { 1747, 0xFDEA }, { 1759, 0xFF7F }, { 1774, 0x24FD },
  { 1783, 0x79AF }, { 1794, 0x7F77 }, { 1807, 0xF04C }, { 1814, 0xFDFF },
  { 1829, 0xEFF6 }, { 1842, 0xAEFB }, { 1854, 0xF7FB }, { 1868, 0xFB7B },
  /* 0x5100 */
  { 1881, 0x7FFF }, { 1896, 0x95BF }, { 1907, 0x6E77 }, { 1918, 0xBFBF },
  { 1932, 0x3BFB }, { 1944, 0xFEF4 }, { 1956, 0x7FAF }, { 1969, 0x13F2 },
  { 1977, 0xA7C5 }, { 1986, 0x55FE }, { 1997, 0x5DB5 }, { 2007, 0x73FF },
  { 2020, 0xFFF8 }, { 2033, 0xF99F }, { 2045, 0x2017 }, { 2050, 0x777B },
  /* 0x5200 */
  { 2062, 0x5FEF }, { 2075, 0xF0CF }, { 2085, 0x47F3 }, { 2095, 0x1DFF },
  { 2107, 0x7EDA }, { 2118, 0xFEF4 }, { 2130, 0xFF07 }, { 2141, 0xBFBC },
  { 2153, 0xBF9F }, { 2166, 0x8FDB }, { 2177, 0x7F5B }, { 2189, 0x5A20 },
  { 2194, 0x32AF }, { 2203, 0xEBEF }, { 2216, 0x8A5F }, { 2225, 0xDFBB },
  /* 0x5300 */
  { 2238, 0xEF62 }, { 2248, 0xB6E7 }, { 2259, 0xB49F }, { 2269, 0xFB9F },
  { 2282, 0x77BF }, { 2295, 0xF49E }, { 2305, 0xF2DB }, { 2316, 0xFBBF },
  { 2330, 0xC414 }, { 2335, 0xF7DC }, { 2347, 0x7FF5 }, { 2360, 0x0A55 },
  { 2366, 0x3F2E }, { 2376, 0x8FD7 }, { 2387, 0xFF7F }, { 2402, 0x59EF },
  /* 0x5400 */
  { 2413, 0xFFDA }, { 2426, 0xFF5F }, { 2440, 0xFFFB }, { 2455, 0x7BFF },
  { 2469, 0xEDEF }, { 2482, 0x0010 }, { 2483, 0xBFFF }, { 2498, 0xFDFF },
  { 2513, 0xF9F7 }, { 2526, 0x55FF }, { 2538, 0xFFFF }, { 2554, 0xFFDF },
  { 2569, 0xFBFF }, { 2584, 0x4441 }, { 2588, 0xEFFF }, { 2603, 0xBD8E },
  /* 0x5500 */
  { 2613, 0xFFFE }, { 2628, 0x459F }, { 2637, 0xFDE8 }, { 2648, 0xDBFF },
  { 2662, 0xEFFB }, { 2676, 0xF0EF }, { 2687, 0x0E7E }, { 2696, 0xFAEE },
  { 2708, 0xFFDF }, { 2723, 0xB73F }, { 2735, 0x7FFE }, { 2749, 0x9E3F },
  { 2760, 0xFFFF }, { 2776, 0xFFFF }, { 2792, 0x97FE }, { 2804, 0xFEE7 },
  /* 0x5600 */
  { 2817, 0xF377 }, { 2829, 0xF8FF }, { 2842, 0xF6AF }, { 2854, 0xEFFD },
  { 2868, 0xF76F }, { 2881, 0x679D }, { 2891, 0xFF7F }, { 2906, 0xDFDF },
  { 2920, 0xFEFF }, { 2935, 0xF7AD }, { 2947, 0xFDF2 }, { 2959, 0xF2FE },
  { 2971, 0x3F6F }, { 2983, 0xECDA }, { 2993, 0xECB7 }, { 3004, 0xA683 },
  /* 0x5700 */
  { 3011, 0x3F9F }, { 3023, 0xFD7C }, { 3035, 0xF70D }, { 3045, 0xE81D },
  { 3053, 0xFEEF }, { 3067, 0x8897 }, { 3074, 0xAFD6 }, { 3085, 0xFCFF },
  { 3099, 0xBD0D }, { 3108, 0xFFB9 }, { 3121, 0x44BF }, { 3130, 0xFF70 },
  { 3141, 0xD9DE }, { 3152, 0xF0B5 }, { 3161, 0xF2FF }, { 3174, 0x7FFF },
  /* 0x5800 */
  { 3189, 0x7FFF }, { 3204, 0x7A15 }, { 3212, 0xF7FF }, { 3227, 0xAFFF },
  { 3241, 0xFF91 }, { 3252, 0xFFBE }, { 3266, 0xBB3C }, { 3276, 0xFE7E },
  { 3289, 0xCFEF }, { 3302, 0xF71F }, { 3314, 0xDFEB }, { 3327, 0xFC6B },
  { 3338, 0xCBE6 }, { 3348, 0xFF7F }, { 3363, 0x9B9D }, { 3373, 0xFE1D },
  /* 0x5900 */
  { 3384, 0xF4FC }, { 3395, 0x96F6 }, { 3405, 0xFEB5 }, { 3417, 0x5196 },
  { 3424, 0xC7B1 }, { 3433, 0x15BB }, { 3442, 0x6EA7 }, { 3452, 0xFBFF },
  { 3467, 0xE63F }, { 3478, 0xE7DD }, { 3490, 0xD1FF }, { 3502, 0x7FFF },
  { 3517, 0xFFFB }, { 3532, 0x7F5F }, { 3545, 0xFF7B }, { 3559, 0xFFFF },
  /* 0x5A00 */
  { 3575, 0xBE0F }, { 3585, 0xDFEE }, { 3598, 0x7EBB }, { 3610, 0x73E8 },
  { 3619, 0x37FF }, { 3632, 0xFFFF }, { 3648, 0x7FFF }, { 3663, 0xFF83 },
  { 3674, 0xDD5E }, { 3685, 0xFEFF }, { 3700, 0xDAE7 }, { 3711, 0xFFFF },
  { 3727, 0xFFDF }, { 3742, 0xFFE8 }, { 3754, 0x7F7F }, { 3768, 0xEFFD },
  /* 0x5B00 */
  { 3782, 0xBBAE }, { 3793, 0xEEFB }, { 3806, 0xFDFB }, { 3820, 0xF115 },
  { 3828, 0xFDFB }, { 3842, 0xBDFB }, { 3855, 0x7B7C }, { 3866, 0xBDFF },
  { 3880, 0xDBBF }, { 3893, 0xFFED }, { 3907, 0x75FC }, { 3918, 0x8379 },
  { 3926, 0x7CFF }, { 3939, 0xC3FF }, { 3951, 0xDFFF }, { 3966, 0x856F },
  /* 0x5C00 */
  { 3975, 0xFFBA }, { 3988, 0xD47F }, { 3999, 0x153D }, { 4007, 0xDF8B },
  { 4018, 0xFFF3 }, { 4032, 0x737B }, { 4043, 0xF7BD }, { 4056, 0x5E1A },
  { 4064, 0xBF60 }, { 4073, 0xF63F }, { 4085, 0xFFFF }, { 4101, 0x05EB },
  { 4109, 0xDFC6 }, { 4120, 0xCFDF }, { 4133, 0xF720 }, { 4141, 0xABF3 },
  /* 0x5D00 */
  { 4152, 0xF8C3 }, { 4161, 0xEFF7 }, { 4175, 0xD3FD }, { 4187, 0xF7FF },
  { 4202, 0x5FEF }, { 4215, 0x4AE7 }, { 4224, 0x9BAC }, { 4233, 0xFE97 },
  { 4245, 0x6FF7 }, { 4258, 0xF6BC }, { 4269, 0xFF97 }, { 4282, 0x37F7 },
  { 4294, 0xAACF }, { 4304, 0xE9F6 }, { 4315, 0x49E7 }, { 4324, 0xE2BF },
  /* 0x5E00 */
  { 4335, 0x5E5C }, { 4344, 0xAFF6 }, { 4356, 0x6B3F }, { 4367, 0x61D8 },
  { 4374, 0xFD3F }, { 4387, 0xFBB8 }, { 4398, 0xFFCF }, { 4412, 0xFF7D },
  { 4426, 0xBFDD }, { 4439, 0x1EE4 }, { 4447, 0x7DFD }, { 4460, 0x63FF },
  { 4472, 0x7FF6 }, { 4485, 0xFFFF }, { 4501, 0xD3EF }, { 4513, 0xDFDE },
  /* 0x5F00 */
  { 4526, 0xFDB6 }, { 4538, 0xADBC }, { 4548, 0x63FC }, { 4558, 0x15EB },
  { 4567, 0xFF59 }, { 4579, 0x33D3 }, { 4588, 0xBEBE }, { 4600, 0xFBDF },
  { 4614, 0x1FEF }, { 4626, 0xDBC7 }, { 4637, 0xFFF3 }, { 4651, 0xFEE6 },
  { 4663, 0xB23F }, { 4673, 0xEBF7 }, { 4686, 0xED3B }, { 4697, 0xADBA },
  /* 0x6000 */
  { 4707, 0xFE01 }, { 4715, 0x7EFF }, { 4729, 0xFFFF }, { 4745, 0x0ABE },
  { 4753, 0x36FF }, { 4765, 0xEF3D }, { 4777, 0xFFFC }, { 4791, 0xC0A5 },
  { 4797, 0x77FB }, { 4810, 0xFCF5 }, { 4822, 0x019D }, { 4828, 0xFFFF },
  { 4844, 0xFFFB }, { 4859, 0xFFBA }, { 4872, 0x03DF }, { 4881, 0xFFFF },
  /* 0x6100 */
  { 4897, 0xFFFB }, { 4912, 0xBF7D }, { 4925, 0xDB8C }, { 4934, 0xE8D5 },
  { 4943, 0xFFF7 }, { 4958, 0xFF7D }, { 4972, 0xDDFF }, { 4986, 0x76FF },
  { 4999, 0x7E8F }, { 5010, 0xBF7F }, { 5024, 0xFF96 }, { 5036, 0xD7FF },
  { 5050, 0xBFEF }, { 5064, 0xC549 }, { 5071, 0x6FFD }, { 5084, 0xFFE7 },
  /* 0x6200 */
  { 5098, 0x779B }, { 5109, 0x8E77 }, { 5119, 0x7EBF }, { 5132, 0xE6DD },
  { 5143, 0x7FCF }, { 5156, 0x5F1F }, { 5167, 0xE17F }, { 5178, 0xFEDF },
  { 5192, 0xD7FF }, { 5206, 0x21FF }, { 5216, 0xFF50 }, { 5226, 0xFB7B },
  { 5239, 0xFFFC }, { 5253, 0x9FFF }, { 5267, 0xF820 }, { 5273, 0xFFFF },
  /* 0x6300 */
  { 5289, 0xFB8F }, { 5301, 0x017B }, { 5308, 0xFF00 }, { 5316, 0x7FFE },
  { 5330, 0xFFFF }, { 5346, 0x07F3 }, { 5355, 0xFBB0 }, { 5365, 0xBFE7 },
  { 5378, 0xFFBF }, { 5393, 0xFBD7 }, { 5406, 0xFFBF }, { 5421, 0x6203 },
  { 5426, 0xFFFF }, { 5442, 0xFFEF }, { 5457, 0xEFFF }, { 5472, 0x5B7F },
  /* 0x6400 */
  { 5484, 0xFEC0 }, { 5493, 0xDDFD }, { 5506, 0xFDFF }, { 5521, 0xEFFD },
  { 5535, 0x680B }, { 5541, 0xFF1F }, { 5554, 0xFBE3 }, { 5566, 0xBFFF },
  { 5581, 0xBFA4 }, { 5591, 0xF7EF }, { 5605, 0xFA7D }, { 5617, 0xF85F },
  { 5628, 0xEEBF }, { 5641, 0x2FDD }, { 5652, 0xBFFF }, { 5667, 0xFD9F },
  /* 0x6500 */
  { 5680, 0xF6DB }, { 5692, 0xFBFB }, { 5706, 0xFE7F }, { 5720, 0xEBFD },
  { 5733, 0xA76A }, { 5742, 0xF3FA }, { 5754, 0xBDFC }, { 5766, 0x9FFC },
  { 5778, 0x1BFF }, { 5790, 0xFAF7 }, { 5803, 0xDDB7 }, { 5815, 0xFBED },
  { 5828, 0xF87E }, { 5839, 0xECDF }, { 5851, 0xF36F }, { 5863, 0xBC3F },
  /* 0x6600 */
  { 5874, 0xFFFD }, { 5889, 0xF13F }, { 5900, 0xE9FF }, { 5913, 0x067F },
  { 5922, 0x9FBE }, { 5934, 0xFE8E }, { 5945, 0xDDFE }, { 5958, 0x7FDF },
  { 5972, 0x7FF1 }, { 5984, 0xA7F7 }, { 5996, 0xEF17 }, { 6007, 0xEFFF },
  { 6022, 0xFFD1 }, { 6034, 0x7F44 }, { 6043, 0x7B59 }, { 6053, 0xD3DF },
  /* 0x6700 */
  { 6065, 0xFF3F }, { 6079, 0xEBFD }, { 6092, 0x7DEF }, { 6105, 0xFF7A },
  { 6118, 0xFBF0 }, { 6129, 0xF6EB }, { 6141, 0xBC87 }, { 6150, 0xFFFF },
  { 6166, 0xFAFA }, { 6178, 0xB7BF }, { 6191, 0xD011 }, { 6196, 0x8FFF },
  { 6209, 0xFF7F }, { 6224, 0xFFDF }, { 6239, 0xFEFC }, { 6252, 0xD7FF },
  /* 0x6800 */
  { 6266, 0x201F }, { 6272, 0xFDDD }, { 6285, 0xEF67 }, { 6297, 0x7FFE },
  { 6311, 0xFFFF }, { 6327, 0x207B }, { 6334, 0xE820 }, { 6339, 0xFBF6 },
  { 6352, 0x9FFF }, { 6366, 0xB9DF }, { 6378, 0xFFDF }, { 6393, 0x227F },
  { 6402, 0x7FF8 }, { 6414, 0xF5FF }, { 6428, 0xDFDB }, { 6441, 0x3FFF },
  /* 0x6900 */
  { 6455, 0xFFFF }, { 6471, 0x0FBF }, { 6482, 0x9420 }, { 6486, 0xFBFD },
  { 6500, 0xDF7F }, { 6514, 0xFFFE }, { 6529, 0xFFFF }, { 6545, 0x0FFF },
  { 6557, 0x646D }, { 6565, 0xDFFB }, { 6579, 0xFFFF }, { 6595, 0xFAFF },
  { 6609, 0xFE5F }, { 6622, 0x027B }, { 6629, 0x7BF6 }, { 6641, 0xFFDE },
  /* 0x6A00 */
  { 6655, 0xBFFF }, { 6670, 0xFFFA }, { 6684, 0x39EB }, { 6694, 0xFF3C },
  { 6706, 0xFBFB }, { 6720, 0xEFFF }, { 6735, 0xAFFF }, { 6749, 0xC452 },
  { 6755, 0xF6BF }, { 6768, 0xFEFF }, { 6783, 0xF9FF }, { 6797, 0x6FFE },
  { 6810, 0xBFEC }, { 6822, 0xFF1B }, { 6834, 0xDDA3 }, { 6844, 0x1F4B },
  /* 0x6B00 */
  { 6853, 0x8F3D }, { 6863, 0x67CF }, { 6874, 0xB12B }, { 6882, 0xFFFE },
  { 6897, 0x7FEE }, { 6910, 0xDAF7 }, { 6922, 0xA4FF }, { 6933, 0xCFD4 },
  { 6943, 0xF75F }, { 6956, 0xCBF2 }, { 6966, 0xECFD }, { 6978, 0xB4ED },
  { 6988, 0xBFFB }, { 7002, 0x5DDD }, { 7013, 0x9DDF }, { 7025, 0xFF8D },
  /* 0x6C00 */
  { 7037, 0xBB7F }, { 7050, 0xBF7B }, { 7063, 0xDDFB }, { 7076, 0xEFFB },
  { 7090, 0xFE4F }, { 7102, 0xFFB5 }, { 7115, 0xEFE3 }, { 7127, 0xEF7F },
  { 7141, 0xFFFF }, { 7157, 0xBF7D }, { 7170, 0xFC04 }, { 7177, 0xFFDF },
  { 7192, 0xFEFF }, { 7207, 0xFEFF }, { 7222, 0xFFAF }, { 7236, 0x822F },
  /* 0x6D00 */
  { 7243, 0xFFFF }, { 7259, 0xEFC7 }, { 7271, 0xFFF5 }, { 7285, 0xFFFF },
  { 7301, 0x4007 }, { 7305, 0xDF80 }, { 7313, 0xF7FF }, { 7328, 0xFFF7 },
  { 7343, 0xFFFF }, { 7359, 0x01FF }, { 7368, 0xDC30 }, { 7375, 0xFFBE },
  { 7389, 0xBFF5 }, { 7402, 0xFFFF }, { 7418, 0xFF7F }, { 7433, 0x7EFF },
  /* 0x6E00 */
  { 7447, 0x843D }, { 7454, 0xBF20 }, { 7462, 0xFFFF }, { 7478, 0xFF7F },
  { 7493, 0xEEFB }, { 7506, 0xFF7F }, { 7521, 0xCBFF }, { 7534, 0x13DE },
  { 7543, 0xEB40 }, { 7550, 0xFFDD }, { 7564, 0xCCFF }, { 7576, 0xFFFF },
  { 7592, 0xFFFF }, { 7608, 0x3F7F }, { 7621, 0xFB04 }, { 7629, 0xFFF6 },
  /* 0x6F00 */
  { 7643, 0xFFFF }, { 7659, 0xD7FC }, { 7671, 0xFEFF }, { 7686, 0xFFFF },
  { 7702, 0xC01B }, { 7708, 0xFDFF }, { 7723, 0xFEDF }, { 7737, 0xFFDD },
  { 7751, 0x7FF7 }, { 7765, 0xE0FD }, { 7775, 0xFFFF }, { 7791, 0xFF7F },
  { 7806, 0xFFDF }, { 7821, 0xFF38 }, { 7832, 0xFBDF }, { 7846, 0xDDD7 },
  /* 0x7000 */
  { 7858, 0xFEFB }, { 7872, 0xFFF2 }, { 7885, 0x9FDF }, { 7898, 0xDFBF },
  { 7912, 0x3F7F }, { 7925, 0xFDF7 }, { 7939, 0x9FFF }, { 7953, 0xF7F3 },
  { 7966, 0xCE7E }, { 7977, 0x877E }, { 7987, 0xFAFB }, { 8000, 0x7FBB },
  { 8013, 0xFDF1 }, { 8025, 0xF7FF }, { 8040, 0x8017 }, { 8045, 0xFFFB },
  /* 0x7100 */
  { 8060, 0x7E75 }, { 8071, 0xFE89 }, { 8081, 0xDB6F }, { 8093, 0x4C7F },
  { 8103, 0xFEFF }, { 8118, 0xF75F }, { 8131, 0x5FFF }, { 8145, 0x7DEF },
  { 8158, 0xD7F7 }, { 8171, 0xFFD7 }, { 8185, 0xB7BF }, { 8198, 0xF7BF },
  { 8212, 0xCFFF }, { 8226, 0xBF77 }, { 8239, 0x79F7 }, { 8251, 0xFB77 },
  /* 0x7200 */
  { 8264, 0xF6EF }, { 8277, 0xEEF9 }, { 8289, 0x7FDC }, { 8301, 0xEF61 },
  { 8311, 0x9FD7 }, { 8323, 0xFFED }, { 8337, 0xD6CF }, { 8348, 0xFBDD },
  { 8361, 0xFBF7 }, { 8375, 0xEDFF }, { 8389, 0xF7FE }, { 8403, 0xA435 },
  { 8410, 0x7E7F }, { 8423, 0x97D7 }, { 8434, 0x0F5F }, { 8444, 0xFFD8 },
  /* 0x7300 */
  { 8456, 0x9D97 }, { 8466, 0x7BCF }, { 8478, 0x7FEC }, { 8490, 0xDFFF },
  { 8505, 0xF73F }, { 8518, 0xEF87 }, { 8529, 0xDFE7 }, { 8542, 0xFDFF },
  { 8557, 0xDFFF }, { 8572, 0xF1FC }, { 8583, 0x3FF7 }, { 8596, 0xDFFC },
  { 8609, 0xFFED }, { 8623, 0x7FFD }, { 8637, 0xEFFF }, { 8652, 0xFFF8 },
  /* 0x7400 */
  { 8665, 0x3FFF }, { 8679, 0xFEF6 }, { 8692, 0xFF7F }, { 8707, 0x97FF },
  { 8720, 0xEFFF }, { 8735, 0xFEFF }, { 8750, 0xFFBD }, { 8764, 0xF67F },
  { 8777, 0x3FEF }, { 8790, 0xDFB5 }, { 8802, 0xAFFB }, { 8815, 0xEFF7 },
  { 8829, 0x9D2F }, { 8839, 0xFFF9 }, { 8853, 0x53FF }, { 8865, 0xE9F7 },
  /* 0x7500 */
  { 8877, 0xF9BD }, { 8889, 0xF7FF }, { 8904, 0xFF66 }, { 8916, 0xEFBF },
  { 8930, 0xFDC5 }, { 8941, 0xBE3A }, { 8951, 0xFCFD }, { 8964, 0xE7C5 },
  { 8974, 0xFCD9 }, { 8985, 0x6737 }, { 8995, 0x0CBC }, { 9002, 0xFF7F },
  { 9017, 0xFDBF }, { 9031, 0xFFB7 }, { 9045, 0xA0DF }, { 9054, 0xFFFF },
  /* 0x7600 */
  { 9070, 0xBF8F }, { 9082, 0xFE7B }, { 9095, 0xB3FF }, { 9108, 0x3D3F },
  { 9119, 0xF3CD }, { 9130, 0x97DF }, { 9142, 0xF6F7 }, { 9155, 0xFF7F },
  { 9170, 0xCFD6 }, { 9181, 0x7E6D }, { 9192, 0xEC72 }, { 9201, 0xEDB1 },
  { 9211, 0x777C }, { 9222, 0xFE5C }, { 9233, 0xF6FA }, { 9245, 0x5FBF },
  /* 0x7700 */
  { 9258, 0xDFBA }, { 9270, 0xEE2F }, { 9281, 0xABFD }, { 9293, 0x7FFE },
  { 9307, 0xFCF9 }, { 9319, 0xDF74 }, { 9330, 0xFFEF }, { 9345, 0xFF84 },
  { 9355, 0xFBBF }, { 9369, 0xFFAA }, { 9381, 0xBDAF }, { 9393, 0xFEFF },
  { 9408, 0xFEBC }, { 9420, 0x7FB9 }, { 9432, 0xF3ED }, { 9444, 0x7F9F },
  /* 0x7800 */
  { 9457, 0xF36C }, { 9467, 0xF11F }, { 9477, 0xFFEF }, { 9492, 0x33BF },
  { 9503, 0x7FBC }, { 9515, 0x701F }, { 9523, 0xFF75 }, { 9536, 0xDE03 },
  { 9544, 0xF3FB }, { 9557, 0xC7FA }, { 9568, 0xBFBF }, { 9582, 0x5F5F },
  { 9594, 0xFFBA }, { 9607, 0xEDBF }, { 9620, 0xF7BF }, { 9634, 0xFEBF },
  /* 0x7900 */
  { 9648, 0x5276 }, { 9656, 0x7A9F }, { 9667, 0xFFFA }, { 9681, 0xFF7E },
  { 9695, 0x9FF7 }, { 9708, 0xFFFF }, { 9724, 0x2FBF }, { 9736, 0xF61F },
  { 9747, 0xEDCF }, { 9759, 0xBFFF }, { 9774, 0x7FF7 }, { 9788, 0xEFDF },
  { 9802, 0xFB73 }, { 9814, 0xF176 }, { 9824, 0x7EDD }, { 9836, 0x0DD2 },
  /* 0x7A00 */
  { 9843, 0x3D7D }, { 9854, 0xDFBF }, { 9868, 0xED45 }, { 9877, 0xFE83 },
  { 9887, 0x7FF9 }, { 9900, 0x9DD0 }, { 9908, 0x7BA7 }, { 9919, 0xEF73 },
  { 9931, 0x9FFB }, { 9944, 0xC3FF }, { 9956, 0xDF0D }, { 9966, 0xDDFF },
  { 9980, 0x8FBF }, { 9992, 0xBF0A }, { 10001, 0xEEFD }, { 10014, 0xEEC0 },
  /* 0x7B00 */
  { 10022, 0xDF73 }, { 10034, 0xEF1F }, { 10046, 0xFFFD }, { 10061, 0x0B3F },
  { 10070, 0xFFFD }, { 10085, 0x0177 }, { 10092, 0xF2FF }, { 10105, 0x09FF },
  { 10115, 0xFDB4 }, { 10126, 0x3BF7 }, { 10138, 0xB01F }, { 10146, 0x43B6 },
  { 10154, 0xDED3 }, { 10165, 0xFF31 }, { 10176, 0x1FFF }, { 10189, 0xFF9F },
  /* 0x7C00 */
  { 10203, 0xFEEF }, { 10217, 0xFA27 }, { 10227, 0x3FEF }, { 10240, 0xFBA9 },
  { 10251, 0x37BD }, { 10262, 0xBEDB }, { 10274, 0xFEF9 }, { 10287, 0xFF3D },
  { 10300, 0x777B }, { 10312, 0xD1F6 }, { 10322, 0xD1EE }, { 10332, 0xFF3E },
  { 10345, 0x7FAC }, { 10356, 0xF6FF }, { 10370, 0xF5C5 }, { 10380, 0x7BFF },
  /* 0x7D00 */
  { 10394, 0xFFFF }, { 10410, 0xFFFF }, { 10426, 0xDB27 }, { 10436, 0xFF6F },
  { 10450, 0xE4FF }, { 10462, 0xFD7F }, { 10476, 0xEFCE }, { 10488, 0xBE0F },
  { 10498, 0xFB7B }, { 10511, 0xF0DE }, { 10521, 0xFFDF }, { 10536, 0xFFBF },
  { 10551, 0xFEF7 }, { 10565, 0xFF9D }, { 10578, 0xD7FB }, { 10591, 0x6EFF },
  /* 0x7E00 */
  { 10604, 0xFF88 }, { 10614, 0xFCFF }, { 10628, 0xEEBF }, { 10641, 0xFFFF },
  { 10657, 0x13FF }, { 10668, 0xDFFF }, { 10683, 0xFFAF }, { 10697, 0xFFFD },
  { 10712, 0xFDC7 }, { 10724, 0x9FFE }, { 10737, 0x1010 }, { 10739, 0x0400 },
  { 10740, 0x8080 }, { 10742, 0x8000 }, { 10743, 0x0000 }, { 10743, 0x0000 },
  /* 0x7F00 */
  { 10743, 0x0040 }, { 10744, 0x0000 }, { 10744, 0x0000 }, { 10744, 0xE7C0 },
  { 10752, 0xFFBB }, { 10766, 0xF93F }, { 10778, 0x7FEB }, { 10791, 0xFFEF },
  { 10806, 0xFFE8 }, { 10818, 0x7CFE }, { 10830, 0xF3FF }, { 10844, 0xFFFF },
  { 10860, 0xFEAF }, { 10873, 0xF8B7 }, { 10884, 0xFFEF }, { 10899, 0xFFBF },
  /* 0x8000 */
  { 10914, 0xF9FF }, { 10928, 0xFBF7 }, { 10942, 0xD773 }, { 10953, 0xFAFB },
  { 10966, 0x85C8 }, { 10972, 0x7D57 }, { 10983, 0x90DE }, { 10991, 0xE3EF },
  { 11003, 0x9EF5 }, { 11014, 0xBF6D }, { 11026, 0xEEAE }, { 11037, 0x35F6 },
  { 11047, 0xF7FC }, { 11060, 0x7FF3 }, { 11073, 0xB27B }, { 11083, 0x7F7F },
  /* 0x8100 */
  { 11097, 0x57EF }, { 11109, 0xEFF4 }, { 11121, 0xBEBE }, { 11133, 0x6695 },
  { 11141, 0xFDDC }, { 11153, 0x5E7F }, { 11165, 0xEAF7 }, { 11177, 0x97DF },
  { 11189, 0xBFDD }, { 11202, 0xFFA8 }, { 11213, 0x5FED }, { 11225, 0xFEFF },
  { 11240, 0xB7FF }, { 11254, 0xEFA7 }, { 11266, 0xF7FF }, { 11281, 0xDFDC },
  /* 0x8200 */
  { 11293, 0x3FB7 }, { 11305, 0xFD77 }, { 11318, 0xBF67 }, { 11330, 0xF7FC },
  { 11343, 0xCAB5 }, { 11352, 0xDFFF }, { 11367, 0xFB7E }, { 11380, 0xFFF6 },
  { 11394, 0xECB9 }, { 11404, 0xEF1F }, { 11416, 0xFFFF }, { 11432, 0xFFFB },
  { 11447, 0x841D }, { 11453, 0xDBFF }, { 11467, 0xFDFF }, { 11482, 0xFFFF },
  /* 0x8300 */
  { 11498, 0x3BFF }, { 11511, 0x7FC0 }, { 11520, 0xBFF5 }, { 11533, 0xBFFE },
  { 11547, 0xFFBF }, { 11562, 0x00DF }, { 11569, 0x804C }, { 11573, 0xFDF8 },
  { 11585, 0xFFEA }, { 11598, 0x7FFF }, { 11613, 0xDFFD }, { 11627, 0xE201 },
  { 11632, 0xFFFF }, { 11648, 0xFBFA }, { 11661, 0xFFBF }, { 11676, 0xFF7F },
  /* 0x8400 */
  { 11691, 0xFEFA }, { 11704, 0x195F }, { 11713, 0xFA5B }, { 11724, 0xFFFF },
  { 11740, 0x7FFD }, { 11754, 0xFFFF }, { 11770, 0xFBFF }, { 11785, 0xE7FF },
  { 11799, 0xE145 }, { 11806, 0xFFDF }, { 11821, 0xFF9F }, { 11835, 0xFF57 },
  { 11848, 0xFEF7 }, { 11862, 0x4CDF }, { 11872, 0xDFB6 }, { 11884, 0xFFDF },
  /* 0x8500 */
  { 11899, 0xFFED }, { 11913, 0xF7FF }, { 11928, 0xFFFB }, { 11943, 0x691B },
  { 11951, 0x7FFF }, { 11966, 0xEFFE }, { 11980, 0xFFFF }, { 11996, 0x5FEB },
  { 12008, 0xFFFF }, { 12024, 0xFFF3 }, { 12038, 0x87DF }, { 12049, 0xE7FB },
  { 12062, 0xEBFF }, { 12076, 0xF7E7 }, { 12089, 0xFF7F }, { 12104, 0xFFC7 },
  /* 0x8600 */
  { 12117, 0xBEF7 }, { 12130, 0xDFD3 }, { 12142, 0xF7FF }, { 12157, 0xDF7E },
  { 12170, 0x79ED }, { 12181, 0xDA7D }, { 12192, 0xFFBE }, { 12206, 0x5E9F },
  { 12217, 0x7CE0 }, { 12225, 0x77FF }, { 12239, 0xA7BF }, { 12251, 0xFFFF },
  { 12267, 0x1BFF }, { 12279, 0xFFDB }, { 12293, 0xBF5C }, { 12304, 0x4FE0 },
  /* 0x8700 */
  { 12312, 0x7FFF }, { 12327, 0x5F0E }, { 12336, 0x77FF }, { 12350, 0xDDBF },
  { 12363, 0xF04F }, { 12372, 0xFFFF }, { 12388, 0xFFFF }, { 12404, 0x2FFB },
  { 12416, 0xBBFE }, { 12429, 0xFDDF }, { 12443, 0xFE3C }, { 12454, 0xFFFF },
  { 12470, 0x5F7F }, { 12483, 0xFFDE }, { 12497, 0xFDFF }, { 12512, 0xDEFC },
  /* 0x8800 */
  { 12524, 0xBF7F }, { 12538, 0xBBFB }, { 12551, 0xFFFF }, { 12567, 0xFBEF },
  { 12581, 0xFD7F }, { 12595, 0x6EEC }, { 12605, 0xEFBF }, { 12619, 0xF2F7 },
  { 12631, 0xFB9F }, { 12644, 0xDFEF }, { 12658, 0x5D97 }, { 12668, 0xF7F6 },
  { 12681, 0xFEA7 }, { 12693, 0xFFF5 }, { 12707, 0xD9C2 }, { 12715, 0xFFFF },
  /* 0x8900 */
  { 12731, 0x5EE7 }, { 12742, 0xC7FF }, { 12755, 0xFEFE }, { 12769, 0x79EF },
  { 12781, 0xBADE }, { 12792, 0xFFDF }, { 12807, 0xFE7F }, { 12821, 0xDEDE },
  { 12833, 0x8FEF }, { 12845, 0xF9FA }, { 12857, 0xF6FE }, { 12870, 0xF6C4 },
  { 12879, 0x0043 }, { 12882, 0xBE7C }, { 12893, 0x3BFF }, { 12906, 0xDDDF },
  /* 0x8A00 */
  { 12919, 0xD59D }, { 12929, 0xF9EF }, { 12942, 0x3EAC }, { 12951, 0xFF53 },
  { 12963, 0xF773 }, { 12975, 0x4BF7 }, { 12986, 0x7BCF }, { 12998, 0xDEFF },
  { 13012, 0xB8FE }, { 13023, 0x577F }, { 13035, 0x8FFB }, { 13047, 0xFF55 },
  { 13059, 0xABFD }, { 13071, 0xFFFE }, { 13086, 0xEDD7 }, { 13098, 0xDDFF },
  /* 0x8B00 */
  { 13112, 0xFDF7 }, { 13126, 0xFFFF }, { 13142, 0xFDFD }, { 13156, 0xFEEB },
  { 13169, 0xFFEF }, { 13184, 0xF7FF }, { 13199, 0xBFED }, { 13212, 0xEF91 },
  { 13222, 0x5D7F }, { 13234, 0xDF7D }, { 13247, 0x0001 }, { 13248, 0x4000 },
  { 13249, 0x0000 }, { 13249, 0x0000 }, { 13249, 0x0004 }, { 13250, 0x0000 },
  /* 0x8C00 */
  { 13250, 0x0000 }, { 13250, 0x0000 }, { 13250, 0x0000 }, { 13250, 0xFA80 },
  { 13257, 0xFFEE }, { 13271, 0xB4F3 }, { 13281, 0xBF76 }, { 13293, 0x2FEF },
  { 13305, 0xB677 }, { 13316, 0xFFBF }, { 13331, 0xBFBF }, { 13345, 0xFFFD },
  { 13360, 0xB5BF }, { 13372, 0xFEFE }, { 13386, 0x7FFF }, { 13401, 0x7FBF },
  /* 0x8D00 */
  { 13415, 0xBFFD }, { 13429, 0x3BFF }, { 13442, 0x0000 }, { 13442, 0x0000 },
  { 13442, 0x0000 }, { 13442, 0x0000 }, { 13442, 0xFBD0 }, { 13452, 0x2FDD },
  { 13463, 0xF637 }, { 13474, 0x9A7F }, { 13485, 0xFFEB }, { 13499, 0xD6FC },
  { 13510, 0xF9EF }, { 13523, 0xBFFB }, { 13537, 0xDFDF }, { 13551, 0xF41F },
  /* 0x8E00 */
  { 13561, 0xE6FF }, { 13574, 0xFFFF }, { 13590, 0x6FFF }, { 13604, 0xF77B },
  { 13617, 0xFFF7 }, { 13632, 0xFEF9 }, { 13645, 0xB7FF }, { 13659, 0x5DFE },
  { 13671, 0x7FF7 }, { 13685, 0xE5FF }, { 13698, 0x3FFB }, { 13711, 0x3645 },
  { 13718, 0xFE0D }, { 13728, 0xFD9E }, { 13740, 0xFBF7 }, { 13754, 0xDFF6 },
  /* 0x8F00 */
  { 13767, 0x6FEF }, { 13780, 0xFFFF }, { 13796, 0xF679 }, { 13807, 0xCBFD },
  { 13819, 0xEFFF }, { 13834, 0xFFFF }, { 13850, 0x40DF }, { 13858, 0x0000 },
  { 13858, 0x0000 }, { 13858, 0x9808 }, { 13862, 0xE1E9 }, { 13871, 0xDFFF },
  { 13886, 0xFE76 }, { 13898, 0x04FF }, { 13907, 0x6D7F }, { 13919, 0xFFF1 },
  /* 0x9000 */
  { 13932, 0xB97F }, { 13944, 0xFEF7 }, { 13958, 0xE01F }, { 13966, 0xF1FE },
  { 13978, 0xFE96 }, { 13989, 0x7B7F }, { 14002, 0xFB9F }, { 14015, 0xFFFD },
  { 14030, 0xADFF }, { 14043, 0xCBB3 }, { 14053, 0xC5EF }, { 14064, 0xE97F },
  { 14076, 0x4DBA }, { 14085, 0xBFF0 }, { 14096, 0xBF3F }, { 14109, 0xFE3F },
  /* 0x9100 */
  { 14122, 0xEBFF }, { 14136, 0xFFD7 }, { 14150, 0xFFDF }, { 14165, 0xCF7F },
  { 14178, 0xFFFB }, { 14193, 0xD7EF }, { 14206, 0xD7BF }, { 14219, 0x17FD },
  { 14230, 0xFEFF }, { 14245, 0xFE0F }, { 14256, 0xFFAF }, { 14270, 0x7EFF },
  { 14284, 0xFAFF }, { 14298, 0xB7FB }, { 14311, 0x7FFC }, { 14324, 0xE7FA },
  /* 0x9200 */
  { 14336, 0xF7FF }, { 14351, 0x56FF }, { 14363, 0x6DFA }, { 14374, 0xF7FF },
  { 14389, 0xFF73 }, { 14402, 0xEDFF }, { 14416, 0xF8FF }, { 14429, 0xFFC5 },
  { 14441, 0xFFFF }, { 14457, 0x3FFA }, { 14469, 0x5FFF }, { 14483, 0xDEFE },
  { 14496, 0xFFFF }, { 14512, 0xEBBF }, { 14525, 0xDFFB }, { 14539, 0xFFDF },
  /* 0x9300 */
  { 14554, 0xFBDF }, { 14568, 0xEF7D }, { 14581, 0xFFFF }, { 14597, 0x137B },
  { 14606, 0xFFFF }, { 14622, 0xDFF7 }, { 14636, 0x7FFF }, { 14651, 0x7FFB },
  { 14665, 0xF7FF }, { 14680, 0xFFF7 }, { 14695, 0xF7FF }, { 14710, 0xA9BF },
  { 14721, 0xFDDD }, { 14734, 0xFFFF }, { 14750, 0x51DF }, { 14760, 0xFFFB },
  /* 0x9400 */
  { 14775, 0xFFDB }, { 14789, 0x2BFF }, { 14801, 0x7FF1 }, { 14813, 0xFFEF },
  { 14828, 0xBFFD }, { 14842, 0x69B7 }, { 14852, 0xFFBD }, { 14866, 0xFBFF },
  { 14881, 0x002F }, { 14886, 0x8000 }, { 14887, 0x0004 }, { 14888, 0x0000 },
  { 14888, 0x000A }, { 14890, 0x1000 }, { 14891, 0x0000 }, { 14891, 0x0040 },
  /* 0x9500 */
  { 14892, 0x0000 }, { 14892, 0x0000 }, { 14892, 0x2000 }, { 14893, 0x0000 },
  { 14893, 0x0080 }, { 14894, 0x0000 }, { 14894, 0x0000 }, { 14894, 0xBD80 },
  { 14901, 0xFB6D }, { 14913, 0xDBDF }, { 14926, 0x7FFF }, { 14941, 0xFEE3 },
  { 14953, 0x3FE9 }, { 14964, 0xDC7F }, { 14976, 0x013F }, { 14983, 0x0010 },
  /* 0x9600 */
  { 14984, 0x0000 }, { 14984, 0x7000 }, { 14987, 0xF51F }, { 14998, 0xBF0F },
  { 15009, 0xFC3F }, { 15021, 0xF95B }, { 15032, 0xBE1E }, { 15042, 0x79FF },
  { 15055, 0xEFFB }, { 15069, 0x5BFE }, { 15081, 0x57BE }, { 15092, 0xBB5B },
  { 15103, 0x7FFF }, { 15118, 0xFFFC }, { 15132, 0x872E }, { 15140, 0xAFF7 },
  /* 0x9700 */
  { 15153, 0xEBFD }, { 15166, 0xFB4F }, { 15178, 0xDFFF }, { 15193, 0xE767 },
  { 15204, 0x0BDF }, { 15214, 0xFDE6 }, { 15226, 0x7747 }, { 15236, 0xFDDF },
  { 15250, 0xEFBF }, { 15264, 0xFF90 }, { 15274, 0x7D7F }, { 15287, 0xEFDE },
  { 15300, 0xFBFF }, { 15315, 0xF3FD }, { 15328, 0x606B }, { 15335, 0xEF6F },
  /* 0x9800 */
  { 15348, 0xF5FF }, { 15362, 0xF9FF }, { 15376, 0xEBDB }, { 15388, 0x0BBD },
  { 15397, 0xFFFA }, { 15411, 0xFB8F }, { 15423, 0x9FFD }, { 15436, 0x003F },
  { 15442, 0x0000 }, { 15442, 0x0000 }, { 15442, 0xF300 }, { 15448, 0xFFDE },
  { 15462, 0x5FDF }, { 15475, 0xD800 }, { 15479, 0xBEEF }, { 15492, 0x7676 },
  /* 0x9900 */
  { 15502, 0x57AD }, { 15512, 0xDFFF }, { 15527, 0xFFB2 }, { 15539, 0xFFAF },
  { 15553, 0x7FAF }, { 15566, 0xFBFF }, { 15581, 0x000E }, { 15584, 0x0000 },
  { 15584, 0x0000 }, { 15584, 0x7BC0 }, { 15592, 0xFDFA }, { 15605, 0x3F3F },
  { 15617, 0xFABE }, { 15629, 0xBFFF }, { 15644, 0x76FF }, { 15657, 0xFFF3 },
  /* 0x9A00 */
  { 15671, 0xFEFE }, { 15685, 0xFE73 }, { 15697, 0xFEFF }, { 15712, 0xFFF7 },
  { 15727, 0xF77F }, { 15741, 0xDFFD }, { 15755, 0x1FFD }, { 15767, 0x0000 },
  { 15767, 0x8000 }, { 15768, 0x0000 }, { 15768, 0xA900 }, { 15772, 0xFFDF },
  { 15787, 0xA4C7 }, { 15795, 0x91FF }, { 15806, 0xF8CF }, { 15817, 0xFEDE },
  /* 0x9B00 */
  { 15830, 0xFF7E }, { 15844, 0xC7F7 }, { 15856, 0xEFBD }, { 15869, 0xDEBE },
  { 15881, 0xFD7F }, { 15895, 0x8F77 }, { 15906, 0x93D3 }, { 15915, 0xFCF3 },
  { 15927, 0xE9EF }, { 15939, 0xECAF }, { 15950, 0xED77 }, { 15962, 0xA361 },
  { 15969, 0x87DB }, { 15979, 0x7EF8 }, { 15990, 0x3FF7 }, { 16003, 0xA193 },
  /* 0x9C00 */
  { 16010, 0x7FE4 }, { 16021, 0xB8BD }, { 16031, 0xBB7B }, { 16043, 0xFEFE },
  { 16057, 0xFF73 }, { 16070, 0xE3FD }, { 16082, 0x61CD }, { 16090, 0x1FBE },
  { 16101, 0x0000 }, { 16101, 0x0000 }, { 16101, 0x0000 }, { 16101, 0x0000 },
  { 16101, 0x0000 }, { 16101, 0x0000 }, { 16101, 0x26E0 }, { 16107, 0xBEFE },
  /* 0x9D00 */
  { 16120, 0x13FD }, { 16130, 0xEBF5 }, { 16142, 0xE36F }, { 16153, 0xEBDB },
  { 16165, 0xDE3F }, { 16177, 0xFFDF }, { 16192, 0xFF83 }, { 16203, 0xFBBF },
  { 16217, 0x1FFF }, { 16230, 0xFFDD }, { 16244, 0xBFFF }, { 16259, 0xFFFE },
  { 16274, 0xFFBF }, { 16289, 0xFFFF }, { 16305, 0xFB7E }, { 16318, 0xFFFD },
  /* 0x9E00 */
  { 16333, 0xFEFF }, { 16348, 0xFFBF }, { 16363, 0x0000 }, { 16363, 0x0000 },
  { 16363, 0x0000 }, { 16363, 0x0000 }, { 16363, 0x0000 }, { 16363, 0xBE20 },
  { 16370, 0x7FFF }, { 16385, 0xFFFF }, { 16401, 0xFFF7 }, { 16416, 0xF8F3 },
  { 16427, 0xF1DF }, { 16439, 0xFD7B }, { 16452, 0xE9F5 }, { 16463, 0xFFFF },
  /* 0x9F00 */
  { 16479, 0xC7C7 }, { 16489, 0x5FED }, { 16501, 0xFFFD }, { 16516, 0x6BFF },
  { 16529, 0xFFFF }, { 16545, 0xFFFD }, { 16560, 0xDEFF }, { 16574, 0xCFF7 },
  { 16587, 0x6000 }, { 16589, 0x9337 }, { 16598, 0x0035 },
};
static const Summary16 big5hkscs_uni2index_pagee0[419] = {
  /* 0xE000 */
  { 16602, 0xFFFF }, { 16618, 0xFFFF }, { 16634, 0xFFFF }, { 16650, 0xFFFF },
  { 16666, 0xFFFF }, { 16682, 0xFFFF }, { 16698, 0xFFFF }, { 16714, 0xFFFF },
  { 16730, 0xFFFF }, { 16746, 0xFFFF }, { 16762, 0xFFFF }, { 16778, 0xFFFF },
  { 16794, 0xFFFF }, { 16810, 0xFFFF }, { 16826, 0xFFFF }, { 16842, 0xFFFF },
  /* 0xE100 */
  { 16858, 0xFFFF }, { 16874, 0xFFFF }, { 16890, 0xFFFF }, { 16906, 0xFFFF },
  { 16922, 0xFFFF }, { 16938, 0xFFFF }, { 16954, 0xFFFF }, { 16970, 0xFFFF },
  { 16986, 0xFFFF }, { 17002, 0xFFFF }, { 17018, 0xFFFF }, { 17034, 0xFFFF },
  { 17050, 0xFFFF }, { 17066, 0xFFFF }, { 17082, 0xFFFF }, { 17098, 0xFFFF },
  /* 0xE200 */
  { 17114, 0xFFFF }, { 17130, 0xFFFF }, { 17146, 0xFFFF }, { 17162, 0xFFFF },
  { 17178, 0xFFFF }, { 17194, 0xFFFF }, { 17210, 0xFFFF }, { 17226, 0xFFFF },
  { 17242, 0xFFFF }, { 17258, 0xFFFF }, { 17274, 0xFFFF }, { 17290, 0xFFFF },
  { 17306, 0xFFFF }, { 17322, 0xFFFF }, { 17338, 0xFFFF }, { 17354, 0xFFFF },
  /* 0xE300 */
  { 17370, 0xFFFF }, { 17386, 0xFFFF }, { 17402, 0xFFFF }, { 17418, 0xFFFF },
  { 17434, 0xFFFF }, { 17450, 0xFFFF }, { 17466, 0xFFFF }, { 17482, 0xFFFF },
  { 17498, 0xFFFF }, { 17514, 0xFFFF }, { 17530, 0xFFFF }, { 17546, 0xFFFF },
  { 17562, 0xFFFF }, { 17578, 0xFFFF }, { 17594, 0xFFFF }, { 17610, 0xFFFF },
  /* 0xE400 */
  { 17626, 0xFFFF }, { 17642, 0xFFFF }, { 17658, 0xFFFF }, { 17674, 0xFFFF },
  { 17690, 0xFFFF }, { 17706, 0xFFFF }, { 17722, 0xFFFF }, { 17738, 0xFFFF },
  { 17754, 0xFFFF }, { 17770, 0xFFFF }, { 17786, 0xFFFF }, { 17802, 0xFFFF },
  { 17818, 0xFFFF }, { 17834, 0xFFFF }, { 17850, 0xFFFF }, { 17866, 0xFFFF },
  /* 0xE500 */
  { 17882, 0xFFFF }, { 17898, 0xFFFF }, { 17914, 0xFFFF }, { 17930, 0xFFFF },
  { 17946, 0xFFFF }, { 17962, 0xFFFF }, { 17978, 0xFFFF }, { 17994, 0xFFFF },
  { 18010, 0xFFFF }, { 18026, 0xFFFF }, { 18042, 0xFFFF }, { 18058, 0xFFFF },
  { 18074, 0xFFFF }, { 18090, 0xFFFF }, { 18106, 0xFFFF }, { 18122, 0xFFFF },
  /* 0xE600 */
  { 18138, 0xFFFF }, { 18154, 0xFFFF }, { 18170, 0xFFFF }, { 18186, 0xFFFF },
  { 18202, 0xFFFF }, { 18218, 0xFFFF }, { 18234, 0xFFFF }, { 18250, 0xFFFF },
  { 18266, 0xFFFF }, { 18282, 0xFFFF }, { 18298, 0xFFFF }, { 18314, 0xFFFF },
  { 18330, 0xFFFF }, { 18346, 0xFFFF }, { 18362, 0xFFFF }, { 18378, 0xFFFF },
  /* 0xE700 */
  { 18394, 0xFFFF }, { 18410, 0xFFFF }, { 18426, 0xFFFF }, { 18442, 0xFFFF },
  { 18458, 0xFFFF }, { 18474, 0xFFFF }, { 18490, 0xFFFF }, { 18506, 0xFFFF },
  { 18522, 0xFFFF }, { 18538, 0xFFFF }, { 18554, 0xFFFF }, { 18570, 0xFFFF },
  { 18586, 0xFFFF }, { 18602, 0xFFFF }, { 18618, 0xFFFF }, { 18634, 0xFFFF },
  /* 0xE800 */
  { 18650, 0xFFFF }, { 18666, 0xFFFF }, { 18682, 0xFFFF }, { 18698, 0xFFFF },
  { 18714, 0xFFFF }, { 18730, 0xFFFF }, { 18746, 0xFFFF }, { 18762, 0xFFFF },
  { 18778, 0xFFFF }, { 18794, 0xFFFF }, { 18810, 0xFFFF }, { 18826, 0xFFFF },
  { 18842, 0xFFFF }, { 18858, 0xFFFF }, { 18874, 0xFFFF }, { 18890, 0xFFFF },
  /* 0xE900 */
  { 18906, 0xFFFF }, { 18922, 0xFFFF }, { 18938, 0xFFFF }, { 18954, 0xFFFF },
  { 18970, 0xFFFF }, { 18986, 0xFFFF }, { 19002, 0xFFFF }, { 19018, 0xFFFF },
  { 19034, 0xFFFF }, { 19050, 0xFFFF }, { 19066, 0xFFFF }, { 19082, 0xFFFF },
  { 19098, 0xFFFF }, { 19114, 0xFFFF }, { 19130, 0xFFFF }, { 19146, 0xFFFF },
  /* 0xEA00 */
  { 19162, 0xFFFF }, { 19178, 0xFFFF }, { 19194, 0xFFFF }, { 19210, 0xFFFF },
  { 19226, 0xFFFF }, { 19242, 0xFFFF }, { 19258, 0xFFFF }, { 19274, 0xFFFF },
  { 19290, 0xFFFF }, { 19306, 0xFFFF }, { 19322, 0xFFFF }, { 19338, 0xFFFF },
  { 19354, 0xFFFF }, { 19370, 0xFFFF }, { 19386, 0xFFFF }, { 19402, 0xFFFF },
  /* 0xEB00 */
  { 19418, 0xFFFF }, { 19434, 0xFFFF }, { 19450, 0xFFFF }, { 19466, 0xFFFF },
  { 19482, 0xFFFF }, { 19498, 0xFFFF }, { 19514, 0xFFFF }, { 19530, 0xFFFF },
  { 19546, 0xFFFF }, { 19562, 0xFFFF }, { 19578, 0xFFFF }, { 19594, 0xFFFF },
  { 19610, 0xFFFF }, { 19626, 0xFFFF }, { 19642, 0xFFFF }, { 19658, 0xFFFF },
  /* 0xEC00 */
  { 19674, 0xFFFF }, { 19690, 0xFFFF }, { 19706, 0xFFFF }, { 19722, 0xFFFF },
  { 19738, 0xFFFF }, { 19754, 0xFFFF }, { 19770, 0xFFFF }, { 19786, 0xFFFF },
  { 19802, 0xFFFF }, { 19818, 0xFFFF }, { 19834, 0xFFFF }, { 19850, 0xFFFF },
  { 19866, 0xFFFF }, { 19882, 0xFFFF }, { 19898, 0xFFFF }, { 19914, 0xFFFF },
  /* 0xED00 */
  { 19930, 0xFFFF }, { 19946, 0xFFFF }, { 19962, 0xFFFF }, { 19978, 0xFFFF },
  { 19994, 0xFFFF }, { 20010, 0xFFFF }, { 20026, 0xFFFF }, { 20042, 0xFFFF },
  { 20058, 0xFFFF }, { 20074, 0xFFFF }, { 20090, 0xFFFF }, { 20106, 0xFFFF },
  { 20122, 0xFFFF }, { 20138, 0xFFFF }, { 20154, 0xFFFF }, { 20170, 0xFFFF },
  /* 0xEE00 */
  { 20186, 0xFFFF }, { 20202, 0xFFFF }, { 20218, 0xFFFF }, { 20234, 0xFFFF },
  { 20250, 0xFFFF }, { 20266, 0xFFFF }, { 20282, 0xFFFF }, { 20298, 0xFFFF },
  { 20314, 0xFFFF }, { 20330, 0xFFFF }, { 20346, 0xFFFF }, { 20362, 0xFFFF },
  { 20378, 0xFFFF }, { 20394, 0xFFFF }, { 20410, 0xFFFF }, { 20426, 0xFFFF },
  /* 0xEF00 */
  { 20442, 0xFFFF }, { 20458, 0xFFFF }, { 20474, 0xFFFF }, { 20490, 0xFFFF },
  { 20506, 0xFFFF }, { 20522, 0xFFFF }, { 20538, 0xFFFF }, { 20554, 0xFFFF },
  { 20570, 0xFFFF }, { 20586, 0xFFFF }, { 20602, 0xFFFF }, { 20618, 0xFFFF },
  { 20634, 0xFFFF }, { 20650, 0xFFFF }, { 20666, 0xFFFF }, { 20682, 0xFFFF },
  /* 0xF000 */
  { 20698, 0xFFFF }, { 20714, 0xFFFF }, { 20730, 0xFFFF }, { 20746, 0xFFFF },
  { 20762, 0xFFFF }, { 20778, 0xFFFF }, { 20794, 0xFFFF }, { 20810, 0xFFFF },
  { 20826, 0xFFFF }, { 20842, 0xFFFF }, { 20858, 0xFFFF }, { 20874, 0xFFFF },
  { 20890, 0xFFFF }, { 20906, 0xFFFF }, { 20922, 0xFFFF }, { 20938, 0xFFFF },
  /* 0xF100 */
  { 20954, 0xFFFF }, { 20970, 0xFFFF }, { 20986, 0xFFFF }, { 21002, 0xFFFF },
  { 21018, 0xFFFF }, { 21034, 0xFFFF }, { 21050, 0xFFFF }, { 21066, 0xFFFF },
  { 21082, 0xFFFF }, { 21098, 0xFFFF }, { 21114, 0xFFFF }, { 21130, 0xFFFF },
  { 21146, 0xFFFF }, { 21162, 0xFFFF }, { 21178, 0xFFFF }, { 21194, 0xFFFF },
  /* 0xF200 */
  { 21210, 0xFFFF }, { 21226, 0xFFFF }, { 21242, 0xFFFF }, { 21258, 0xFFFF },
  { 21274, 0xFFFF }, { 21290, 0xFFFF }, { 21306, 0xFFFF }, { 21322, 0xFFFF },
  { 21338, 0xFFFF }, { 21354, 0xFFFF }, { 21370, 0xFFFF }, { 21386, 0xFFFF },
  { 21402, 0xFFFF }, { 21418, 0xFFFF }, { 21434, 0xFFFF }, { 21450, 0xFFFF },
  /* 0xF300 */
  { 21466, 0xFFFF }, { 21482, 0xFFFF }, { 21498, 0xFFFF }, { 21514, 0xFFFF },
  { 21530, 0xFFFF }, { 21546, 0xFFFF }, { 21562, 0xFFFF }, { 21578, 0xFFFF },
  { 21594, 0xFFFF }, { 21610, 0xFFFF }, { 21626, 0xFFFF }, { 21642, 0xFFFF },
  { 21658, 0xFFFF }, { 21674, 0xFFFF }, { 21690, 0xFFFF }, { 21706, 0xFFFF },
  /* 0xF400 */
  { 21722, 0xFFFF }, { 21738, 0xFFFF }, { 21754, 0xFFFF }, { 21770, 0xFFFF },
  { 21786, 0xFFFF }, { 21802, 0xFFFF }, { 21818, 0xFFFF }, { 21834, 0xFFFF },
  { 21850, 0xFFFF }, { 21866, 0xFFFF }, { 21882, 0xFFFF }, { 21898, 0xFFFF },
  { 21914, 0xFFFF }, { 21930, 0xFFFF }, { 21946, 0xFFFF }, { 21962, 0xFFFF },
  /* 0xF500 */
  { 21978, 0xFFFF }, { 21994, 0xFFFF }, { 22010, 0xFFFF }, { 22026, 0xFFFF },
  { 22042, 0xFFFF }, { 22058, 0xFFFF }, { 22074, 0xFFFF }, { 22090, 0xFFFF },
  { 22106, 0xFFFF }, { 22122, 0xFFFF }, { 22138, 0xFFFF }, { 22154, 0xFFFF },
  { 22170, 0xFFFF }, { 22186, 0xFFFF }, { 22202, 0xFFFF }, { 22218, 0xFFFF },
  /* 0xF600 */
  { 22234, 0xFFFF }, { 22250, 0xFFFF }, { 22266, 0xFFFF }, { 22282, 0xFFFF },
  { 22298, 0xFFFF }, { 22314, 0xFFFF }, { 22330, 0xFFFF }, { 22346, 0xFFFF },
  { 22362, 0xFFFF }, { 22378, 0xFFFF }, { 22394, 0xFFFF }, { 22410, 0xFFFF },
  { 22426, 0xFFFF }, { 22442, 0xFFFF }, { 22458, 0xFFFF }, { 22474, 0xFFFF },
  /* 0xF700 */
  { 22490, 0xFFFF }, { 22506, 0xFFFF }, { 22522, 0xFFFF }, { 22538, 0xFFFF },
  { 22554, 0xFFFF }, { 22570, 0xFFFF }, { 22586, 0xFFFF }, { 22602, 0xFFFF },
  { 22618, 0xFFFF }, { 22634, 0xFFFF }, { 22650, 0xFFFF }, { 22666, 0xFFFF },
  { 22682, 0xFFFF }, { 22698, 0xFFFF }, { 22714, 0xFFFF }, { 22730, 0xFFFF },
  /* 0xF800 */
  { 22746, 0xFFFF }, { 22762, 0xFFFF }, { 22778, 0xFFFF }, { 22794, 0xFFFF },
  { 22810, 0x01FF }, { 22819, 0x0000 }, { 22819, 0x0000 }, { 22819, 0x0000 },
  { 22819, 0x0000 }, { 22819, 0x0000 }, { 22819, 0x0000 }, { 22819, 0x0000 },
  { 22819, 0x0000 }, { 22819, 0x0000 }, { 22819, 0x0000 }, { 22819, 0x0100 },
  /* 0xF900 */
  { 22820, 0xFFFF }, { 22836, 0xFFFF }, { 22852, 0xEFFF }, { 22867, 0xFFFF },
  { 22883, 0xFFFF }, { 22899, 0xFFFF }, { 22915, 0xFFFF }, { 22931, 0xFDFF },
  { 22946, 0xFFFF }, { 22962, 0xFFDF }, { 22977, 0xFFFF }, { 22993, 0xFFFF },
  { 23009, 0xFFFF }, { 23025, 0xFFFF }, { 23041, 0xFF7F }, { 23056, 0xFFFD },
  /* 0xFA00 */
  { 23071, 0x3FFF }, { 23085, 0x7EE5 }, { 23096, 0x3C64 },
};
static const Summary16 big5hkscs_uni2index_pagefe[31] = {
  /* 0xFE00 */
  { 23103, 0x0000 }, { 23103, 0x0000 }, { 23103, 0x0000 }, { 23103, 0xFFFB },
  { 23118, 0xFE1F }, { 23130, 0xFEF7 }, { 23144, 0x0F7F }, { 23155, 0x0000 },
  { 23155, 0x0000 }, { 23155, 0x0000 }, { 23155, 0x0000 }, { 23155, 0x0000 },
  { 23155, 0x0000 }, { 23155, 0x0000 }, { 23155, 0x0000 }, { 23155, 0x0000 },
  /* 0xFF00 */
  { 23155, 0xFFFE }, { 23170, 0xFFFF }, { 23186, 0xFFFF }, { 23202, 0xFFFF },
  { 23218, 0xFFFF }, { 23234, 0x7FFF }, { 23249, 0x0010 }, { 23250, 0x0000 },
  { 23250, 0x0000 }, { 23250, 0x0000 }, { 23250, 0x0000 }, { 23250, 0x0000 },
  { 23250, 0x0000 }, { 23250, 0x0000 }, { 23250, 0x203F },
};
static const Summary16 big5hkscs_uni2index_page200[2335] = {
  /* 0x20000 */
  { 23257, 0x0000 }, { 23257, 0x0000 }, { 23257, 0x0002 }, { 23258, 0x4000 },
  { 23259, 0x4040 }, { 23261, 0x0000 }, { 23261, 0x0100 }, { 23262, 0x0000 },
  { 23262, 0x04C0 }, { 23265, 0x0010 }, { 23266, 0x0000 }, { 23266, 0x0000 },
  { 23266, 0x3C00 }, { 23270, 0x0002 }, { 23271, 0x4000 }, { 23272, 0x0000 },
  /* 0x20100 */
  { 23272, 0x5000 }, { 23274, 0x0100 }, { 23275, 0x0000 }, { 23275, 0x0000 },
  { 23275, 0x0000 }, { 23275, 0x0000 }, { 23275, 0x0000 }, { 23275, 0x0000 },
  { 23275, 0x0000 }, { 23275, 0x0000 }, { 23275, 0x0A00 }, { 23277, 0x0000 },
  { 23277, 0x0002 }, { 23278, 0x0010 }, { 23279, 0x0000 }, { 23279, 0x0004 },
  /* 0x20200 */
  { 23280, 0x1010 }, { 23282, 0x0010 }, { 23283, 0x0000 }, { 23283, 0x0000 },
  { 23283, 0x0000 }, { 23283, 0x0800 }, { 23284, 0x0000 }, { 23284, 0x0030 },
  { 23286, 0x0000 }, { 23286, 0x4200 }, { 23288, 0x0001 }, { 23289, 0x8080 },
  { 23291, 0x0001 }, { 23292, 0x0000 }, { 23292, 0x0020 }, { 23293, 0x0000 },
  /* 0x20300 */
  { 23293, 0x0400 }, { 23294, 0x0000 }, { 23294, 0x0020 }, { 23295, 0x0000 },
  { 23295, 0x00E2 }, { 23299, 0x0000 }, { 23299, 0x0000 }, { 23299, 0xC000 },
  { 23301, 0x0001 }, { 23302, 0x0000 }, { 23302, 0x0081 }, { 23304, 0x0020 },
  { 23305, 0x0A00 }, { 23307, 0x0000 }, { 23307, 0x0000 }, { 23307, 0x1020 },
  /* 0x20400 */
  { 23309, 0x0000 }, { 23309, 0x8018 }, { 23312, 0x0000 }, { 23312, 0x0000 },
  { 23312, 0x0000 }, { 23312, 0x0000 }, { 23312, 0x0020 }, { 23313, 0x0000 },
  { 23313, 0x4080 }, { 23315, 0x0006 }, { 23317, 0x0008 }, { 23318, 0x0000 },
  { 23318, 0x0000 }, { 23318, 0x0080 }, { 23319, 0x0000 }, { 23319, 0x5000 },
  /* 0x20500 */
  { 23321, 0x0000 }, { 23321, 0x0000 }, { 23321, 0x0000 }, { 23321, 0x0000 },
  { 23321, 0x0080 }, { 23322, 0x0000 }, { 23322, 0x0000 }, { 23322, 0x0000 },
  { 23322, 0x4000 }, { 23323, 0x0000 }, { 23323, 0x0020 }, { 23324, 0x0008 },
  { 23325, 0x0408 }, { 23327, 0x8021 }, { 23330, 0x0801 }, { 23332, 0x0000 },
  /* 0x20600 */
  { 23332, 0x0000 }, { 23332, 0x0622 }, { 23336, 0x0000 }, { 23336, 0x0001 },
  { 23337, 0x0000 }, { 23337, 0x0040 }, { 23338, 0x0000 }, { 23338, 0x0040 },
  { 23339, 0x0000 }, { 23339, 0x0000 }, { 23339, 0x0000 }, { 23339, 0x0000 },
  { 23339, 0x0000 }, { 23339, 0x0000 }, { 23339, 0x0000 }, { 23339, 0x0000 },
  /* 0x20700 */
  { 23339, 0x4000 }, { 23340, 0x0000 }, { 23340, 0x0000 }, { 23340, 0x0002 },
  { 23341, 0x0000 }, { 23341, 0x0000 }, { 23341, 0x0000 }, { 23341, 0x0200 },
  { 23342, 0x0000 }, { 23342, 0x0000 }, { 23342, 0x0000 }, { 23342, 0x0000 },
  { 23342, 0x0000 }, { 23342, 0x0000 }, { 23342, 0x0000 }, { 23342, 0x0000 },
  /* 0x20800 */
  { 23342, 0x0000 }, { 23342, 0x0000 }, { 23342, 0x1000 }, { 23343, 0x0000 },
  { 23343, 0x0000 }, { 23343, 0x0000 }, { 23343, 0x0000 }, { 23343, 0x0008 },
  { 23344, 0x0000 }, { 23344, 0x0000 }, { 23344, 0x0000 }, { 23344, 0x0000 },
  { 23344, 0x0000 }, { 23344, 0x0020 }, { 23345, 0x0000 }, { 23345, 0x0000 },
  /* 0x20900 */
  { 23345, 0x0000 }, { 23345, 0x0040 }, { 23346, 0x0008 }, { 23347, 0x0000 },
  { 23347, 0x0000 }, { 23347, 0x0010 }, { 23348, 0x0000 }, { 23348, 0x0200 },
  { 23349, 0x0000 }, { 23349, 0x0000 }, { 23349, 0x0000 }, { 23349, 0x0000 },
  { 23349, 0x0000 }, { 23349, 0x0000 }, { 23349, 0x0080 }, { 23350, 0x0000 },
  /* 0x20A00 */
  { 23350, 0x0000 }, { 23350, 0x0002 }, { 23351, 0x0000 }, { 23351, 0x0000 },
  { 23351, 0x0000 }, { 23351, 0x0001 }, { 23352, 0x0000 }, { 23352, 0x0000 },
  { 23352, 0x0000 }, { 23352, 0x0000 }, { 23352, 0x0000 }, { 23352, 0x0010 },
  { 23353, 0x2004 }, { 23355, 0x0000 }, { 23355, 0x0000 }, { 23355, 0x0000 },
  /* 0x20B00 */
  { 23355, 0x2000 }, { 23356, 0x0000 }, { 23356, 0x0000 }, { 23356, 0x0000 },
  { 23356, 0x0000 }, { 23356, 0x0000 }, { 23356, 0x0000 }, { 23356, 0x0000 },
  { 23356, 0x8000 }, { 23357, 0x0000 }, { 23357, 0x0300 }, { 23359, 0x8000 },
  { 23360, 0x0840 }, { 23362, 0x0000 }, { 23362, 0x0804 }, { 23364, 0x8800 },
  /* 0x20C00 */
  { 23366, 0x2800 }, { 23368, 0x0000 }, { 23368, 0x0001 }, { 23369, 0x0C10 },
  { 23372, 0x000E }, { 23375, 0x0008 }, { 23376, 0x0020 }, { 23377, 0x1180 },
  { 23380, 0x2000 }, { 23381, 0x1040 }, { 23383, 0x0000 }, { 23383, 0x0120 },
  { 23385, 0x8000 }, { 23386, 0x2078 }, { 23391, 0x2000 }, { 23392, 0x8000 },
  /* 0x20D00 */
  { 23393, 0x0000 }, { 23393, 0x0020 }, { 23394, 0x0100 }, { 23395, 0x0006 },
  { 23397, 0x73C0 }, { 23404, 0x0000 }, { 23404, 0x8000 }, { 23405, 0xD012 },
  { 23410, 0x0000 }, { 23410, 0x1040 }, { 23412, 0x0080 }, { 23413, 0x0004 },
  { 23414, 0x0100 }, { 23415, 0x0000 }, { 23415, 0x0000 }, { 23415, 0x0000 },
  /* 0x20E00 */
  { 23415, 0xE610 }, { 23421, 0x2043 }, { 23425, 0x0000 }, { 23425, 0x0000 },
  { 23425, 0x1000 }, { 23426, 0x0000 }, { 23426, 0x2000 }, { 23427, 0x0FE8 },
  { 23435, 0x1000 }, { 23436, 0x2140 }, { 23439, 0x1C04 }, { 23443, 0x0040 },
  { 23444, 0x0000 }, { 23444, 0x2180 }, { 23447, 0x0000 }, { 23447, 0x0F00 },
  /* 0x20F00 */
  { 23451, 0x0000 }, { 23451, 0x2000 }, { 23452, 0x6040 }, { 23455, 0x0803 },
  { 23458, 0x1000 }, { 23459, 0x0000 }, { 23459, 0x0010 }, { 23460, 0x0000 },
  { 23460, 0x2000 }, { 23461, 0x0001 }, { 23462, 0x2000 }, { 23463, 0x1070 },
  { 23467, 0x0000 }, { 23467, 0x8000 }, { 23468, 0x3C00 }, { 23472, 0x0000 },
  /* 0x21000 */
  { 23472, 0x0000 }, { 23472, 0x6010 }, { 23475, 0x0000 }, { 23475, 0x0000 },
  { 23475, 0x8000 }, { 23476, 0x1000 }, { 23477, 0x8000 }, { 23478, 0x09E0 },
  { 23483, 0x0100 }, { 23484, 0x2040 }, { 23486, 0x0000 }, { 23486, 0x8010 },
  { 23488, 0x8383 }, { 23494, 0x0008 }, { 23495, 0x0010 }, { 23496, 0x0070 },
  /* 0x21100 */
  { 23499, 0x0000 }, { 23499, 0x0000 }, { 23499, 0x8000 }, { 23500, 0x2800 },
  { 23502, 0x8120 }, { 23505, 0x0000 }, { 23505, 0x0000 }, { 23505, 0x0000 },
  { 23505, 0x0081 }, { 23507, 0x0000 }, { 23507, 0x0000 }, { 23507, 0x0000 },
  { 23507, 0x0000 }, { 23507, 0x0200 }, { 23508, 0x0000 }, { 23508, 0x0000 },
  /* 0x21200 */
  { 23508, 0x0000 }, { 23508, 0x0000 }, { 23508, 0x0000 }, { 23508, 0x1000 },
  { 23509, 0x8000 }, { 23510, 0x0000 }, { 23510, 0x0000 }, { 23510, 0x1000 },
  { 23511, 0x0000 }, { 23511, 0x0000 }, { 23511, 0x0300 }, { 23513, 0x0001 },
  { 23514, 0x0000 }, { 23514, 0x0000 }, { 23514, 0x0008 }, { 23515, 0x4000 },
  /* 0x21300 */
  { 23516, 0x003C }, { 23520, 0x0000 }, { 23520, 0x0000 }, { 23520, 0x0440 },
  { 23522, 0x0000 }, { 23522, 0x0000 }, { 23522, 0x0000 }, { 23522, 0x0060 },
  { 23524, 0x4000 }, { 23525, 0x1100 }, { 23527, 0x0000 }, { 23527, 0x0000 },
  { 23527, 0x0060 }, { 23529, 0x0000 }, { 23529, 0x2000 }, { 23530, 0x4000 },
  /* 0x21400 */
  { 23531, 0x0000 }, { 23531, 0x0048 }, { 23533, 0x0010 }, { 23534, 0x8000 },
  { 23535, 0x0000 }, { 23535, 0x0034 }, { 23538, 0x0000 }, { 23538, 0x0000 },
  { 23538, 0x0400 }, { 23539, 0x0080 }, { 23540, 0x0000 }, { 23540, 0x0040 },
  { 23541, 0x0000 }, { 23541, 0x0000 }, { 23541, 0x0100 }, { 23542, 0x2000 },
  /* 0x21500 */
  { 23543, 0x0000 }, { 23543, 0x0000 }, { 23543, 0x0000 }, { 23543, 0x0000 },
  { 23543, 0x0000 }, { 23543, 0x0000 }, { 23543, 0x0000 }, { 23543, 0x0080 },
  { 23544, 0x0004 }, { 23545, 0x0040 }, { 23546, 0x0000 }, { 23546, 0x0000 },
  { 23546, 0x0000 }, { 23546, 0x0000 }, { 23546, 0x0000 }, { 23546, 0x0000 },
  /* 0x21600 */
  { 23546, 0x0400 }, { 23547, 0x0208 }, { 23549, 0x0000 }, { 23549, 0x4000 },
  { 23550, 0x0000 }, { 23550, 0x0000 }, { 23550, 0x0002 }, { 23551, 0x0000 },
  { 23551, 0x0000 }, { 23551, 0x0004 }, { 23552, 0x0000 }, { 23552, 0x0500 },
  { 23554, 0x0007 }, { 23557, 0x8028 }, { 23560, 0x01C0 }, { 23563, 0x5C00 },
  /* 0x21700 */
  { 23567, 0x2000 }, { 23568, 0x0001 }, { 23569, 0x0040 }, { 23570, 0x1C00 },
  { 23573, 0x0000 }, { 23573, 0x0080 }, { 23574, 0xF000 }, { 23578, 0x001B },
  { 23582, 0x0000 }, { 23582, 0x0000 }, { 23582, 0x0800 }, { 23583, 0x003F },
  { 23589, 0x0088 }, { 23591, 0x9E00 }, { 23596, 0x8000 }, { 23597, 0x1F60 },
  /* 0x21800 */
  { 23604, 0x0000 }, { 23604, 0x0000 }, { 23604, 0x2701 }, { 23609, 0x0E00 },
  { 23612, 0x0021 }, { 23614, 0x4004 }, { 23616, 0x001E }, { 23620, 0x0880 },
  { 23622, 0x0038 }, { 23625, 0xC000 }, { 23627, 0x0007 }, { 23630, 0xC000 },
  { 23632, 0x0000 }, { 23632, 0x03C2 }, { 23637, 0x0000 }, { 23637, 0x0400 },
  /* 0x21900 */
  { 23638, 0x0038 }, { 23641, 0x1027 }, { 23646, 0x0084 }, { 23648, 0x0800 },
  { 23649, 0x0010 }, { 23650, 0x0100 }, { 23651, 0x0400 }, { 23652, 0x1000 },
  { 23653, 0x0109 }, { 23656, 0x0040 }, { 23657, 0x0000 }, { 23657, 0x0000 },
  { 23657, 0x0000 }, { 23657, 0x0800 }, { 23658, 0x0000 }, { 23658, 0x0008 },
  /* 0x21A00 */
  { 23659, 0x0000 }, { 23659, 0x0000 }, { 23659, 0x2000 }, { 23660, 0x0010 },
  { 23661, 0x0820 }, { 23663, 0x0000 }, { 23663, 0x0000 }, { 23663, 0x0000 },
  { 23663, 0x0000 }, { 23663, 0x0000 }, { 23663, 0x0000 }, { 23663, 0x0000 },
  { 23663, 0x0000 }, { 23663, 0x0000 }, { 23663, 0x0000 }, { 23663, 0x0000 },
  /* 0x21B00 */
  { 23663, 0x0000 }, { 23663, 0x0000 }, { 23663, 0x0000 }, { 23663, 0x0000 },
  { 23663, 0x0010 }, { 23664, 0x0000 }, { 23664, 0x0000 }, { 23664, 0x0000 },
  { 23664, 0x0000 }, { 23664, 0x0000 }, { 23664, 0x0000 }, { 23664, 0x0000 },
  { 23664, 0x0006 }, { 23666, 0x0000 }, { 23666, 0x0000 }, { 23666, 0x0000 },
  /* 0x21C00 */
  { 23666, 0x0000 }, { 23666, 0x0000 }, { 23666, 0x0400 }, { 23667, 0x0000 },
  { 23667, 0x0000 }, { 23667, 0x0000 }, { 23667, 0x0000 }, { 23667, 0x0001 },
  { 23668, 0x0000 }, { 23668, 0x0000 }, { 23668, 0x1024 }, { 23671, 0x0000 },
  { 23671, 0x0000 }, { 23671, 0x0000 }, { 23671, 0x0000 }, { 23671, 0x0000 },
  /* 0x21D00 */
  { 23671, 0x0000 }, { 23671, 0x0000 }, { 23671, 0x0000 }, { 23671, 0x0000 },
  { 23671, 0x0040 }, { 23672, 0x0000 }, { 23672, 0x0000 }, { 23672, 0x0000 },
  { 23672, 0x0000 }, { 23672, 0x0001 }, { 23673, 0x0000 }, { 23673, 0x0440 },
  { 23675, 0x0400 }, { 23676, 0x0002 }, { 23677, 0x0800 }, { 23678, 0x0200 },
  /* 0x21E00 */
  { 23679, 0x0000 }, { 23679, 0x1000 }, { 23680, 0x0000 }, { 23680, 0x2080 },
  { 23682, 0x0000 }, { 23682, 0x0000 }, { 23682, 0x0000 }, { 23682, 0x0000 },
  { 23682, 0x0200 }, { 23683, 0x0000 }, { 23683, 0x0110 }, { 23685, 0x0000 },
  { 23685, 0x0100 }, { 23686, 0x0020 }, { 23687, 0x0000 }, { 23687, 0x0000 },
  /* 0x21F00 */
  { 23687, 0x8000 }, { 23688, 0x0020 }, { 23689, 0x0000 }, { 23689, 0x0000 },
  { 23689, 0x0000 }, { 23689, 0x0000 }, { 23689, 0x0400 }, { 23690, 0x0000 },
  { 23690, 0x0000 }, { 23690, 0x4000 }, { 23691, 0x0002 }, { 23692, 0x0000 },
  { 23692, 0x0000 }, { 23692, 0x0000 }, { 23692, 0x0100 }, { 23693, 0x0000 },
  /* 0x22000 */
  { 23693, 0x0000 }, { 23693, 0x0000 }, { 23693, 0x0000 }, { 23693, 0x0000 },
  { 23693, 0x0220 }, { 23695, 0x0000 }, { 23695, 0x0000 }, { 23695, 0x4000 },
  { 23696, 0x0000 }, { 23696, 0x0400 }, { 23697, 0x0000 }, { 23697, 0x0000 },
  { 23697, 0x0080 }, { 23698, 0x0000 }, { 23698, 0x0000 }, { 23698, 0x1000 },
  /* 0x22100 */
  { 23699, 0x0000 }, { 23699, 0x0000 }, { 23699, 0x0400 }, { 23700, 0x0000 },
  { 23700, 0x0000 }, { 23700, 0x0800 }, { 23701, 0x0000 }, { 23701, 0x0408 },
  { 23703, 0x0000 }, { 23703, 0x0000 }, { 23703, 0x0002 }, { 23704, 0x0000 },
  { 23704, 0x0008 }, { 23705, 0x0000 }, { 23705, 0x0000 }, { 23705, 0x0000 },
  /* 0x22200 */
  { 23705, 0x0100 }, { 23706, 0x0000 }, { 23706, 0x0000 }, { 23706, 0x0000 },
  { 23706, 0x0000 }, { 23706, 0x0000 }, { 23706, 0x0000 }, { 23706, 0x1000 },
  { 23707, 0x0000 }, { 23707, 0x0000 }, { 23707, 0x0000 }, { 23707, 0x0000 },
  { 23707, 0x0000 }, { 23707, 0x0000 }, { 23707, 0x0000 }, { 23707, 0x0000 },
  /* 0x22300 */
  { 23707, 0x0000 }, { 23707, 0x0000 }, { 23707, 0x0022 }, { 23709, 0x0000 },
  { 23709, 0x0000 }, { 23709, 0x0000 }, { 23709, 0x0000 }, { 23709, 0x0000 },
  { 23709, 0x0000 }, { 23709, 0x0000 }, { 23709, 0x0000 }, { 23709, 0x2000 },
  { 23710, 0x0000 }, { 23710, 0x0081 }, { 23712, 0x0000 }, { 23712, 0x0400 },
  /* 0x22400 */
  { 23713, 0x0000 }, { 23713, 0x0000 }, { 23713, 0x0000 }, { 23713, 0x0000 },
  { 23713, 0x0000 }, { 23713, 0x0000 }, { 23713, 0x0020 }, { 23714, 0x0002 },
  { 23715, 0x0800 }, { 23716, 0x0002 }, { 23717, 0x0000 }, { 23717, 0x0001 },
  { 23718, 0x0000 }, { 23718, 0x0000 }, { 23718, 0x2000 }, { 23719, 0x0000 },
  /* 0x22500 */
  { 23719, 0x0000 }, { 23719, 0x0808 }, { 23721, 0x0000 }, { 23721, 0x0001 },
  { 23722, 0x0000 }, { 23722, 0x0010 }, { 23723, 0x0000 }, { 23723, 0x0000 },
  { 23723, 0x2000 }, { 23724, 0x0000 }, { 23724, 0x8000 }, { 23725, 0x4000 },
  { 23726, 0x0000 }, { 23726, 0x0000 }, { 23726, 0x0000 }, { 23726, 0x0000 },
  /* 0x22600 */
  { 23726, 0x0000 }, { 23726, 0x1800 }, { 23728, 0x0800 }, { 23729, 0x0000 },
  { 23729, 0x0000 }, { 23729, 0x0000 }, { 23729, 0x0100 }, { 23730, 0x0400 },
  { 23731, 0x0000 }, { 23731, 0x0140 }, { 23733, 0x0000 }, { 23733, 0x0000 },
  { 23733, 0x0000 }, { 23733, 0x0000 }, { 23733, 0x0000 }, { 23733, 0x0070 },
  /* 0x22700 */
  { 23736, 0x0000 }, { 23736, 0x8814 }, { 23740, 0x0400 }, { 23741, 0x0000 },
  { 23741, 0x0000 }, { 23741, 0x0000 }, { 23741, 0x0000 }, { 23741, 0x0020 },
  { 23742, 0x0002 }, { 23743, 0x0000 }, { 23743, 0x0000 }, { 23743, 0x0030 },
  { 23745, 0x2000 }, { 23746, 0x0000 }, { 23746, 0x0000 }, { 23746, 0x0000 },
  /* 0x22800 */
  { 23746, 0x0008 }, { 23747, 0x0000 }, { 23747, 0x0000 }, { 23747, 0x0000 },
  { 23747, 0x0000 }, { 23747, 0x8000 }, { 23748, 0x0001 }, { 23749, 0x0002 },
  { 23750, 0x0000 }, { 23750, 0x0000 }, { 23750, 0x2000 }, { 23751, 0x0000 },
  { 23751, 0x0002 }, { 23752, 0x0000 }, { 23752, 0x0000 }, { 23752, 0x0080 },
  /* 0x22900 */
  { 23753, 0x0000 }, { 23753, 0x0000 }, { 23753, 0x0040 }, { 23754, 0x0200 },
  { 23755, 0x8000 }, { 23756, 0x0000 }, { 23756, 0x0880 }, { 23758, 0x0000 },
  { 23758, 0x0001 }, { 23759, 0x0008 }, { 23760, 0x0000 }, { 23760, 0x0000 },
  { 23760, 0x0000 }, { 23760, 0x0000 }, { 23760, 0x0000 }, { 23760, 0x0000 },
  /* 0x22A00 */
  { 23760, 0x0000 }, { 23760, 0x0000 }, { 23760, 0x0000 }, { 23760, 0x0000 },
  { 23760, 0x0000 }, { 23760, 0x0000 }, { 23760, 0x0040 }, { 23761, 0x0000 },
  { 23761, 0x0000 }, { 23761, 0x0000 }, { 23761, 0x0000 }, { 23761, 0x0000 },
  { 23761, 0x8000 }, { 23762, 0x0020 }, { 23763, 0x0140 }, { 23765, 0x0000 },
  /* 0x22B00 */
  { 23765, 0x4000 }, { 23766, 0x0000 }, { 23766, 0x0004 }, { 23767, 0x8000 },
  { 23768, 0x0008 }, { 23769, 0x0000 }, { 23769, 0x0400 }, { 23770, 0x0000 },
  { 23770, 0x0000 }, { 23770, 0x0000 }, { 23770, 0x0000 }, { 23770, 0x0000 },
  { 23770, 0x4400 }, { 23772, 0x0000 }, { 23772, 0x0000 }, { 23772, 0x0000 },
  /* 0x22C00 */
  { 23772, 0x0000 }, { 23772, 0x0000 }, { 23772, 0x00C0 }, { 23774, 0x0100 },
  { 23775, 0x1000 }, { 23776, 0x0022 }, { 23778, 0x0004 }, { 23779, 0x0000 },
  { 23779, 0x0100 }, { 23780, 0x0800 }, { 23781, 0x0202 }, { 23783, 0x0084 },
  { 23785, 0x0244 }, { 23788, 0x0000 }, { 23788, 0x0000 }, { 23788, 0x0000 },
  /* 0x22D00 */
  { 23788, 0x0180 }, { 23790, 0x0004 }, { 23791, 0x0000 }, { 23791, 0x0000 },
  { 23791, 0x1010 }, { 23793, 0x0000 }, { 23793, 0x0080 }, { 23794, 0x0000 },
  { 23794, 0x2000 }, { 23795, 0x0020 }, { 23796, 0x0019 }, { 23799, 0x0080 },
  { 23800, 0x0000 }, { 23800, 0x0000 }, { 23800, 0x4000 }, { 23801, 0x0000 },
  /* 0x22E00 */
  { 23801, 0x2000 }, { 23802, 0x0000 }, { 23802, 0x0000 }, { 23802, 0x0040 },
  { 23803, 0x0004 }, { 23804, 0x0000 }, { 23804, 0x0000 }, { 23804, 0x0100 },
  { 23805, 0x0800 }, { 23806, 0x0000 }, { 23806, 0x0000 }, { 23806, 0x0008 },
  { 23807, 0x0000 }, { 23807, 0x0000 }, { 23807, 0x8000 }, { 23808, 0x0000 },
  /* 0x22F00 */
  { 23808, 0x0000 }, { 23808, 0x0000 }, { 23808, 0x0000 }, { 23808, 0x0000 },
  { 23808, 0x0000 }, { 23808, 0x0000 }, { 23808, 0x0000 }, { 23808, 0x0010 },
  { 23809, 0x0000 }, { 23809, 0x0000 }, { 23809, 0x0000 }, { 23809, 0x0000 },
  { 23809, 0x1000 }, { 23810, 0x0000 }, { 23810, 0x0008 }, { 23811, 0x0000 },
  /* 0x23000 */
  { 23811, 0x0000 }, { 23811, 0x0000 }, { 23811, 0x0000 }, { 23811, 0x0008 },
  { 23812, 0x0810 }, { 23814, 0x0000 }, { 23814, 0x0040 }, { 23815, 0x6000 },
  { 23817, 0x4000 }, { 23818, 0x0000 }, { 23818, 0x0000 }, { 23818, 0x1080 },
  { 23820, 0x0000 }, { 23820, 0x0400 }, { 23821, 0x0000 }, { 23821, 0x0000 },
  /* 0x23100 */
  { 23821, 0x0008 }, { 23822, 0x0000 }, { 23822, 0x0000 }, { 23822, 0x2000 },
  { 23823, 0x0000 }, { 23823, 0x0000 }, { 23823, 0x0000 }, { 23823, 0x2000 },
  { 23824, 0x0004 }, { 23825, 0x0000 }, { 23825, 0x0030 }, { 23827, 0x0008 },
  { 23828, 0x0300 }, { 23830, 0x0000 }, { 23830, 0x0000 }, { 23830, 0x0380 },
  /* 0x23200 */
  { 23833, 0x8000 }, { 23834, 0x0000 }, { 23834, 0x8020 }, { 23836, 0x001E },
  { 23840, 0x0000 }, { 23840, 0x0000 }, { 23840, 0x0004 }, { 23841, 0x0000 },
  { 23841, 0x0602 }, { 23844, 0x0000 }, { 23844, 0x3800 }, { 23847, 0x0000 },
  { 23847, 0x0000 }, { 23847, 0x0004 }, { 23848, 0x0003 }, { 23850, 0x0000 },
  /* 0x23300 */
  { 23850, 0x0401 }, { 23852, 0x8000 }, { 23853, 0x0000 }, { 23853, 0x0000 },
  { 23853, 0x0000 }, { 23853, 0x0000 }, { 23853, 0x0000 }, { 23853, 0x0000 },
  { 23853, 0x0000 }, { 23853, 0x0000 }, { 23853, 0x0000 }, { 23853, 0x0010 },
  { 23854, 0x1000 }, { 23855, 0x4000 }, { 23856, 0x0040 }, { 23857, 0x4630 },
  /* 0x23400 */
  { 23862, 0x0001 }, { 23863, 0x0000 }, { 23863, 0x0000 }, { 23863, 0x8000 },
  { 23864, 0x0000 }, { 23864, 0x0001 }, { 23865, 0x8000 }, { 23866, 0x0004 },
  { 23867, 0x0000 }, { 23867, 0x0000 }, { 23867, 0x0000 }, { 23867, 0x0000 },
  { 23867, 0x0000 }, { 23867, 0x0000 }, { 23867, 0x0020 }, { 23868, 0x0000 },
  /* 0x23500 */
  { 23868, 0x0000 }, { 23868, 0x0200 }, { 23869, 0x0000 }, { 23869, 0x0001 },
  { 23870, 0x0000 }, { 23870, 0x0400 }, { 23871, 0x0080 }, { 23872, 0x0000 },
  { 23872, 0x0000 }, { 23872, 0x1220 }, { 23875, 0x0000 }, { 23875, 0x0000 },
  { 23875, 0xE000 }, { 23878, 0x0000 }, { 23878, 0x0000 }, { 23878, 0x0008 },
  /* 0x23600 */
  { 23879, 0x0001 }, { 23880, 0x0400 }, { 23881, 0x0000 }, { 23881, 0x1000 },
  { 23882, 0x0001 }, { 23883, 0x8200 }, { 23885, 0x0000 }, { 23885, 0x0080 },
  { 23886, 0x0000 }, { 23886, 0x0000 }, { 23886, 0x2040 }, { 23888, 0x0400 },
  { 23889, 0x0000 }, { 23889, 0x8000 }, { 23890, 0x4000 }, { 23891, 0x0000 },
  /* 0x23700 */
  { 23891, 0x0008 }, { 23892, 0x0040 }, { 23893, 0xA001 }, { 23896, 0x8000 },
  { 23897, 0x0000 }, { 23897, 0x0000 }, { 23897, 0x0040 }, { 23898, 0x0000 },
  { 23898, 0x0002 }, { 23899, 0x0000 }, { 23899, 0x0004 }, { 23900, 0x1000 },
  { 23901, 0x0004 }, { 23902, 0x00E0 }, { 23905, 0x0000 }, { 23905, 0x0000 },
  /* 0x23800 */
  { 23905, 0x0000 }, { 23905, 0x0000 }, { 23905, 0x0000 }, { 23905, 0x0400 },
  { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 },
  { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 },
  { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 },
  /* 0x23900 */
  { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 },
  { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 },
  { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 }, { 23906, 0x0000 },
  { 23906, 0x0004 }, { 23907, 0x0000 }, { 23907, 0x0000 }, { 23907, 0x0000 },
  /* 0x23A00 */
  { 23907, 0x0000 }, { 23907, 0x0000 }, { 23907, 0x0000 }, { 23907, 0x0000 },
  { 23907, 0x0000 }, { 23907, 0x0000 }, { 23907, 0x0000 }, { 23907, 0x0000 },
  { 23907, 0x0000 }, { 23907, 0x0000 }, { 23907, 0x0080 }, { 23908, 0x0000 },
  { 23908, 0x0000 }, { 23908, 0x0800 }, { 23909, 0x4000 }, { 23910, 0x0400 },
  /* 0x23B00 */
  { 23911, 0x0000 }, { 23911, 0x0000 }, { 23911, 0x0000 }, { 23911, 0x0000 },
  { 23911, 0x0000 }, { 23911, 0x0400 }, { 23912, 0x0000 }, { 23912, 0x0000 },
  { 23912, 0x0000 }, { 23912, 0x0000 }, { 23912, 0x0000 }, { 23912, 0x0000 },
  { 23912, 0x0000 }, { 23912, 0x0000 }, { 23912, 0x0000 }, { 23912, 0x0000 },
  /* 0x23C00 */
  { 23912, 0x0000 }, { 23912, 0x0000 }, { 23912, 0x0000 }, { 23912, 0x0000 },
  { 23912, 0x0000 }, { 23912, 0x0000 }, { 23912, 0x0008 }, { 23913, 0x0000 },
  { 23913, 0x0000 }, { 23913, 0x0E00 }, { 23916, 0x0000 }, { 23916, 0x00A0 },
  { 23918, 0x0380 }, { 23921, 0x0000 }, { 23921, 0x0000 }, { 23921, 0xF000 },
  /* 0x23D00 */
  { 23925, 0x0000 }, { 23925, 0x0000 }, { 23925, 0x0000 }, { 23925, 0x0000 },
  { 23925, 0x0001 }, { 23926, 0x0800 }, { 23927, 0x0000 }, { 23927, 0x4000 },
  { 23928, 0x8000 }, { 23929, 0x0000 }, { 23929, 0x0000 }, { 23929, 0x3FC0 },
  { 23937, 0x0000 }, { 23937, 0x0000 }, { 23937, 0x0008 }, { 23938, 0x0100 },
  /* 0x23E00 */
  { 23939, 0x0000 }, { 23939, 0x0002 }, { 23940, 0xF000 }, { 23944, 0x0203 },
  { 23947, 0x0000 }, { 23947, 0x0000 }, { 23947, 0x0000 }, { 23947, 0x0000 },
  { 23947, 0x0F00 }, { 23951, 0x0000 }, { 23951, 0x0000 }, { 23951, 0x8200 },
  { 23953, 0x0000 }, { 23953, 0x0080 }, { 23954, 0x0000 }, { 23954, 0x1F80 },
  /* 0x23F00 */
  { 23960, 0x0000 }, { 23960, 0x0000 }, { 23960, 0x0000 }, { 23960, 0x0020 },
  { 23961, 0x0402 }, { 23963, 0x0000 }, { 23963, 0x0000 }, { 23963, 0x8000 },
  { 23964, 0x8007 }, { 23968, 0x0000 }, { 23968, 0x0000 }, { 23968, 0x0090 },
  { 23970, 0x0021 }, { 23972, 0x0000 }, { 23972, 0xF800 }, { 23977, 0x0001 },
  /* 0x24000 */
  { 23978, 0x0000 }, { 23978, 0x0002 }, { 23979, 0x0000 }, { 23979, 0x3E00 },
  { 23984, 0x0000 }, { 23984, 0x0080 }, { 23985, 0x0000 }, { 23985, 0x0000 },
  { 23985, 0x3820 }, { 23989, 0x0002 }, { 23990, 0x0000 }, { 23990, 0x0000 },
  { 23990, 0x0200 }, { 23991, 0x0000 }, { 23991, 0x0002 }, { 23992, 0x0000 },
  /* 0x24100 */
  { 23992, 0x8010 }, { 23994, 0x0200 }, { 23995, 0x0000 }, { 23995, 0x8000 },
  { 23996, 0x4011 }, { 23999, 0x90E0 }, { 24004, 0x0000 }, { 24004, 0x0480 },
  { 24006, 0x0000 }, { 24006, 0x0000 }, { 24006, 0x1038 }, { 24010, 0x0020 },
  { 24011, 0x2000 }, { 24012, 0x0000 }, { 24012, 0x0004 }, { 24013, 0x1000 },
  /* 0x24200 */
  { 24014, 0x0000 }, { 24014, 0x0800 }, { 24015, 0x0000 }, { 24015, 0x0000 },
  { 24015, 0x0800 }, { 24016, 0x0240 }, { 24018, 0x0000 }, { 24018, 0x01C0 },
  { 24021, 0x0010 }, { 24022, 0x0028 }, { 24024, 0x0020 }, { 24025, 0x0000 },
  { 24025, 0x0602 }, { 24028, 0x0000 }, { 24028, 0x4000 }, { 24029, 0x0400 },
  /* 0x24300 */
  { 24030, 0x2000 }, { 24031, 0x0400 }, { 24032, 0x0000 }, { 24032, 0x0010 },
  { 24033, 0x0100 }, { 24034, 0x0000 }, { 24034, 0x003C }, { 24038, 0x0000 },
  { 24038, 0x1000 }, { 24039, 0x1040 }, { 24041, 0x0000 }, { 24041, 0x2000 },
  { 24042, 0x0002 }, { 24043, 0x0000 }, { 24043, 0x0600 }, { 24045, 0x0104 },
  /* 0x24400 */
  { 24047, 0x0010 }, { 24048, 0x0000 }, { 24048, 0x0000 }, { 24048, 0x0060 },
  { 24050, 0x0000 }, { 24050, 0x0C00 }, { 24052, 0x0000 }, { 24052, 0x0008 },
  { 24053, 0x0180 }, { 24055, 0x0000 }, { 24055, 0x0000 }, { 24055, 0x1200 },
  { 24057, 0x4000 }, { 24058, 0x0048 }, { 24060, 0x0000 }, { 24060, 0x0000 },
  /* 0x24500 */
  { 24060, 0x0020 }, { 24061, 0x0000 }, { 24061, 0x0002 }, { 24062, 0x0000 },
  { 24062, 0x0000 }, { 24062, 0x0000 }, { 24062, 0x0000 }, { 24062, 0x0100 },
  { 24063, 0x0000 }, { 24063, 0x0000 }, { 24063, 0x0000 }, { 24063, 0x0000 },
  { 24063, 0x0100 }, { 24064, 0x0000 }, { 24064, 0x0000 }, { 24064, 0x0000 },
  /* 0x24600 */
  { 24064, 0x0000 }, { 24064, 0x0100 }, { 24065, 0x0400 }, { 24066, 0x0000 },
  { 24066, 0x0000 }, { 24066, 0x0000 }, { 24066, 0x0020 }, { 24067, 0x0010 },
  { 24068, 0x0000 }, { 24068, 0x0080 }, { 24069, 0x0000 }, { 24069, 0x0000 },
  { 24069, 0x0000 }, { 24069, 0x0010 }, { 24070, 0x0000 }, { 24070, 0x0000 },
  /* 0x24700 */
  { 24070, 0x0040 }, { 24071, 0x0000 }, { 24071, 0x8020 }, { 24073, 0x0000 },
  { 24073, 0x0000 }, { 24073, 0x0000 }, { 24073, 0x0000 }, { 24073, 0x0000 },
  { 24073, 0x8000 }, { 24074, 0x0000 }, { 24074, 0x0000 }, { 24074, 0x0000 },
  { 24074, 0x0000 }, { 24074, 0x0000 }, { 24074, 0x0001 }, { 24075, 0x0000 },
  /* 0x24800 */
  { 24075, 0x0000 }, { 24075, 0x0004 }, { 24076, 0x0008 }, { 24077, 0x0000 },
  { 24077, 0x0000 }, { 24077, 0x0000 }, { 24077, 0x0000 }, { 24077, 0x0000 },
  { 24077, 0x0004 }, { 24078, 0x0000 }, { 24078, 0x0000 }, { 24078, 0x0000 },
  { 24078, 0x0000 }, { 24078, 0x0000 }, { 24078, 0x0200 }, { 24079, 0x880F },
  /* 0x24900 */
  { 24085, 0x1003 }, { 24088, 0x02C0 }, { 24091, 0x8000 }, { 24092, 0xC018 },
  { 24096, 0x000F }, { 24100, 0x0000 }, { 24100, 0x000C }, { 24102, 0x8870 },
  { 24107, 0xFF04 }, { 24116, 0x0010 }, { 24117, 0x3A90 }, { 24123, 0x0F80 },
  { 24128, 0x0020 }, { 24129, 0xC401 }, { 24133, 0x3028 }, { 24137, 0x0BC0 },
  /* 0x24A00 */
  { 24142, 0x4000 }, { 24143, 0x002C }, { 24146, 0x07FE }, { 24156, 0x4000 },
  { 24157, 0xC424 }, { 24162, 0x2003 }, { 24165, 0x00E0 }, { 24168, 0x0782 },
  { 24173, 0x1000 }, { 24174, 0x0078 }, { 24178, 0x00F0 }, { 24182, 0x1C0E },
  { 24188, 0x0481 }, { 24191, 0x8002 }, { 24193, 0x0204 }, { 24195, 0x0000 },
  /* 0x24B00 */
  { 24195, 0x0000 }, { 24195, 0x0000 }, { 24195, 0x0000 }, { 24195, 0x0000 },
  { 24195, 0x0000 }, { 24195, 0x0000 }, { 24195, 0x4000 }, { 24196, 0x0000 },
  { 24196, 0x0000 }, { 24196, 0x0000 }, { 24196, 0x0000 }, { 24196, 0x0000 },
  { 24196, 0x0000 }, { 24196, 0x0000 }, { 24196, 0x0000 }, { 24196, 0x0020 },
  /* 0x24C00 */
  { 24197, 0x0200 }, { 24198, 0x0000 }, { 24198, 0x0000 }, { 24198, 0x0000 },
  { 24198, 0x0000 }, { 24198, 0x0000 }, { 24198, 0x0000 }, { 24198, 0x0000 },
  { 24198, 0x0000 }, { 24198, 0xC000 }, { 24200, 0x0000 }, { 24200, 0x0000 },
  { 24200, 0x0200 }, { 24201, 0x0200 }, { 24202, 0x0000 }, { 24202, 0x0000 },
  /* 0x24D00 */
  { 24202, 0x0040 }, { 24203, 0x0008 }, { 24204, 0x0000 }, { 24204, 0x0000 },
  { 24204, 0x0000 }, { 24204, 0x0000 }, { 24204, 0x0000 }, { 24204, 0x0000 },
  { 24204, 0x0000 }, { 24204, 0x0000 }, { 24204, 0x0000 }, { 24204, 0x0100 },
  { 24205, 0x0000 }, { 24205, 0x0000 }, { 24205, 0x0C00 }, { 24207, 0x0000 },
  /* 0x24E00 */
  { 24207, 0x0000 }, { 24207, 0x0000 }, { 24207, 0x0000 }, { 24207, 0x0800 },
  { 24208, 0x0000 }, { 24208, 0x0001 }, { 24209, 0x0000 }, { 24209, 0x0000 },
  { 24209, 0x0000 }, { 24209, 0x0000 }, { 24209, 0x00A0 }, { 24211, 0x0000 },
  { 24211, 0x0000 }, { 24211, 0x0000 }, { 24211, 0x0000 }, { 24211, 0x0000 },
  /* 0x24F00 */
  { 24211, 0x4000 }, { 24212, 0x0000 }, { 24212, 0x0000 }, { 24212, 0x0000 },
  { 24212, 0x0000 }, { 24212, 0x1000 }, { 24213, 0x0000 }, { 24213, 0x0000 },
  { 24213, 0x0044 }, { 24215, 0x0480 }, { 24217, 0x0200 }, { 24218, 0x0100 },
  { 24219, 0x0004 }, { 24220, 0x0000 }, { 24220, 0x0000 }, { 24220, 0x0000 },
  /* 0x25000 */
  { 24220, 0x0000 }, { 24220, 0x0000 }, { 24220, 0x1000 }, { 24221, 0x0000 },
  { 24221, 0x0000 }, { 24221, 0x0004 }, { 24222, 0x0000 }, { 24222, 0x0000 },
  { 24222, 0x0000 }, { 24222, 0x2000 }, { 24223, 0x0000 }, { 24223, 0x0000 },
  { 24223, 0x0000 }, { 24223, 0x0000 }, { 24223, 0x0000 }, { 24223, 0x0000 },
  /* 0x25100 */
  { 24223, 0x0000 }, { 24223, 0x0000 }, { 24223, 0x0800 }, { 24224, 0x0000 },
  { 24224, 0x0100 }, { 24225, 0x0000 }, { 24225, 0x0000 }, { 24225, 0x6000 },
  { 24227, 0x0000 }, { 24227, 0x0000 }, { 24227, 0x0000 }, { 24227, 0x0000 },
  { 24227, 0x2000 }, { 24228, 0x0000 }, { 24228, 0x00C8 }, { 24231, 0x0000 },
  /* 0x25200 */
  { 24231, 0x0000 }, { 24231, 0x0000 }, { 24231, 0x0003 }, { 24233, 0x0000 },
  { 24233, 0x0000 }, { 24233, 0x0001 }, { 24234, 0x0000 }, { 24234, 0x0000 },
  { 24234, 0x0000 }, { 24234, 0x0200 }, { 24235, 0x0000 }, { 24235, 0x0000 },
  { 24235, 0x0080 }, { 24236, 0x0100 }, { 24237, 0x0000 }, { 24237, 0x0000 },
  /* 0x25300 */
  { 24237, 0x4000 }, { 24238, 0x000A }, { 24240, 0x0000 }, { 24240, 0x0000 },
  { 24240, 0x0000 }, { 24240, 0x0000 }, { 24240, 0x0000 }, { 24240, 0x0000 },
  { 24240, 0x0000 }, { 24240, 0x0000 }, { 24240, 0x0000 }, { 24240, 0x0000 },
  { 24240, 0x0000 }, { 24240, 0x0000 }, { 24240, 0x0000 }, { 24240, 0x0000 },
  /* 0x25400 */
  { 24240, 0x0000 }, { 24240, 0x0200 }, { 24241, 0x8020 }, { 24243, 0x0001 },
  { 24244, 0x0040 }, { 24245, 0x0000 }, { 24245, 0x5000 }, { 24247, 0x0000 },
  { 24247, 0x0000 }, { 24247, 0x0000 }, { 24247, 0x0000 }, { 24247, 0x0000 },
  { 24247, 0x0000 }, { 24247, 0x0000 }, { 24247, 0x0000 }, { 24247, 0x0000 },
  /* 0x25500 */
  { 24247, 0x0000 }, { 24247, 0x0000 }, { 24247, 0x0000 }, { 24247, 0x8022 },
  { 24250, 0x0000 }, { 24250, 0x7800 }, { 24254, 0x0064 }, { 24257, 0x0000 },
  { 24257, 0x8012 }, { 24260, 0x0000 }, { 24260, 0x0000 }, { 24260, 0x0200 },
  { 24261, 0x0000 }, { 24261, 0x0820 }, { 24263, 0x0001 }, { 24264, 0x0000 },
  /* 0x25600 */
  { 24264, 0x0020 }, { 24265, 0x0000 }, { 24265, 0x0000 }, { 24265, 0x0020 },
  { 24266, 0x0000 }, { 24266, 0x0002 }, { 24267, 0x0000 }, { 24267, 0x0000 },
  { 24267, 0x0008 }, { 24268, 0x0020 }, { 24269, 0x0000 }, { 24269, 0x0000 },
  { 24269, 0x0000 }, { 24269, 0x0000 }, { 24269, 0x0008 }, { 24270, 0x0040 },
  /* 0x25700 */
  { 24271, 0x0040 }, { 24272, 0x2000 }, { 24273, 0x0020 }, { 24274, 0x2000 },
  { 24275, 0x0000 }, { 24275, 0x0000 }, { 24275, 0x0000 }, { 24275, 0x0004 },
  { 24276, 0x0000 }, { 24276, 0x0000 }, { 24276, 0x0000 }, { 24276, 0x0000 },
  { 24276, 0x0080 }, { 24277, 0x8000 }, { 24278, 0x0003 }, { 24280, 0x0000 },
  /* 0x25800 */
  { 24280, 0x0000 }, { 24280, 0x0000 }, { 24280, 0x0000 }, { 24280, 0x0000 },
  { 24280, 0x0000 }, { 24280, 0x2080 }, { 24282, 0x0000 }, { 24282, 0x0004 },
  { 24283, 0x0000 }, { 24283, 0x0000 }, { 24283, 0x0000 }, { 24283, 0x0000 },
  { 24283, 0x0100 }, { 24284, 0x0000 }, { 24284, 0x0002 }, { 24285, 0x0000 },
  /* 0x25900 */
  { 24285, 0x0008 }, { 24286, 0x0000 }, { 24286, 0x0000 }, { 24286, 0x0000 },
  { 24286, 0x0040 }, { 24287, 0x0040 }, { 24288, 0x0000 }, { 24288, 0x0000 },
  { 24288, 0x0000 }, { 24288, 0x0000 }, { 24288, 0x1000 }, { 24289, 0x0000 },
  { 24289, 0x1000 }, { 24290, 0x0000 }, { 24290, 0x0000 }, { 24290, 0x0000 },
  /* 0x25A00 */
  { 24290, 0x0000 }, { 24290, 0x0000 }, { 24290, 0x0000 }, { 24290, 0x0000 },
  { 24290, 0x0000 }, { 24290, 0x0000 }, { 24290, 0x0000 }, { 24290, 0x0000 },
  { 24290, 0x0000 }, { 24290, 0x1020 }, { 24292, 0xC000 }, { 24294, 0x0000 },
  { 24294, 0x0000 }, { 24294, 0x0000 }, { 24294, 0x0200 }, { 24295, 0x0000 },
  /* 0x25B00 */
  { 24295, 0x0000 }, { 24295, 0x0000 }, { 24295, 0x0000 }, { 24295, 0x0000 },
  { 24295, 0x0000 }, { 24295, 0x0000 }, { 24295, 0x0000 }, { 24295, 0x0010 },
  { 24296, 0x0200 }, { 24297, 0x0000 }, { 24297, 0x0000 }, { 24297, 0x0018 },
  { 24299, 0x0040 }, { 24300, 0x0000 }, { 24300, 0x0110 }, { 24302, 0x0000 },
  /* 0x25C00 */
  { 24302, 0x0042 }, { 24304, 0x0000 }, { 24304, 0x0002 }, { 24305, 0x0000 },
  { 24305, 0x0400 }, { 24306, 0x0000 }, { 24306, 0x0020 }, { 24307, 0x0000 },
  { 24307, 0x0000 }, { 24307, 0x0002 }, { 24308, 0x0010 }, { 24309, 0x0000 },
  { 24309, 0x0003 }, { 24311, 0x0000 }, { 24311, 0x0000 }, { 24311, 0x4000 },
  /* 0x25D00 */
  { 24312, 0x0000 }, { 24312, 0x0000 }, { 24312, 0x0001 }, { 24313, 0x0001 },
  { 24314, 0x0008 }, { 24315, 0x0000 }, { 24315, 0x0000 }, { 24315, 0x0000 },
  { 24315, 0x0000 }, { 24315, 0x0000 }, { 24315, 0x0000 }, { 24315, 0x0000 },
  { 24315, 0x0000 }, { 24315, 0x0000 }, { 24315, 0x0000 }, { 24315, 0x0000 },
  /* 0x25E00 */
  { 24315, 0x4000 }, { 24316, 0x0000 }, { 24316, 0x0000 }, { 24316, 0x0000 },
  { 24316, 0x0200 }, { 24317, 0x0000 }, { 24317, 0x0000 }, { 24317, 0x0000 },
  { 24317, 0x000E }, { 24320, 0x0000 }, { 24320, 0x0040 }, { 24321, 0x1000 },
  { 24322, 0x0000 }, { 24322, 0x0180 }, { 24324, 0x0000 }, { 24324, 0x0000 },
  /* 0x25F00 */
  { 24324, 0x0000 }, { 24324, 0x0400 }, { 24325, 0x0000 }, { 24325, 0x0000 },
  { 24325, 0x0800 }, { 24326, 0x0000 }, { 24326, 0x0000 }, { 24326, 0x0000 },
  { 24326, 0x0000 }, { 24326, 0x0000 }, { 24326, 0x0000 }, { 24326, 0x0000 },
  { 24326, 0x0000 }, { 24326, 0x0000 }, { 24326, 0x0006 }, { 24328, 0x0000 },
  /* 0x26000 */
  { 24328, 0x0000 }, { 24328, 0x0000 }, { 24328, 0x0200 }, { 24329, 0x0000 },
  { 24329, 0x0100 }, { 24330, 0x0000 }, { 24330, 0x0010 }, { 24331, 0x0000 },
  { 24331, 0x0008 }, { 24332, 0x0080 }, { 24333, 0x0030 }, { 24335, 0x0000 },
  { 24335, 0x0000 }, { 24335, 0x0000 }, { 24335, 0x0000 }, { 24335, 0x0000 },
  /* 0x26100 */
  { 24335, 0x0004 }, { 24336, 0x0000 }, { 24336, 0x0002 }, { 24337, 0x0000 },
  { 24337, 0x0000 }, { 24337, 0x1E00 }, { 24341, 0x0000 }, { 24341, 0x0000 },
  { 24341, 0x0000 }, { 24341, 0x0000 }, { 24341, 0x6000 }, { 24343, 0x0004 },
  { 24344, 0x0000 }, { 24344, 0x2000 }, { 24345, 0x0000 }, { 24345, 0x0000 },
  /* 0x26200 */
  { 24345, 0x0000 }, { 24345, 0x0000 }, { 24345, 0x0000 }, { 24345, 0x0000 },
  { 24345, 0x0000 }, { 24345, 0x0100 }, { 24346, 0x0C02 }, { 24349, 0x0000 },
  { 24349, 0x0000 }, { 24349, 0x0000 }, { 24349, 0x0000 }, { 24349, 0x0000 },
  { 24349, 0x0000 }, { 24349, 0x0001 }, { 24350, 0x0000 }, { 24350, 0x0000 },
  /* 0x26300 */
  { 24350, 0x0000 }, { 24350, 0x0000 }, { 24350, 0x0000 }, { 24350, 0x0020 },
  { 24351, 0x1800 }, { 24353, 0x0002 }, { 24354, 0x0000 }, { 24354, 0x0000 },
  { 24354, 0x0000 }, { 24354, 0x0000 }, { 24354, 0x0000 }, { 24354, 0x4000 },
  { 24355, 0x0000 }, { 24355, 0x0000 }, { 24355, 0x0000 }, { 24355, 0x0120 },
  /* 0x26400 */
  { 24357, 0x0004 }, { 24358, 0x0007 }, { 24361, 0x0000 }, { 24361, 0x0000 },
  { 24361, 0x0400 }, { 24362, 0x0000 }, { 24362, 0x0200 }, { 24363, 0x0000 },
  { 24363, 0x2310 }, { 24367, 0x0100 }, { 24368, 0x0000 }, { 24368, 0x0000 },
  { 24368, 0x0000 }, { 24368, 0x0000 }, { 24368, 0x0000 }, { 24368, 0x0000 },
  /* 0x26500 */
  { 24368, 0x0000 }, { 24368, 0x0004 }, { 24369, 0x0000 }, { 24369, 0x0000 },
  { 24369, 0x0000 }, { 24369, 0x0000 }, { 24369, 0x0000 }, { 24369, 0x0004 },
  { 24370, 0x0000 }, { 24370, 0x0000 }, { 24370, 0x2001 }, { 24372, 0x8000 },
  { 24373, 0x0000 }, { 24373, 0x0000 }, { 24373, 0x0000 }, { 24373, 0x0000 },
  /* 0x26600 */
  { 24373, 0x0000 }, { 24373, 0x0004 }, { 24374, 0x0040 }, { 24375, 0x0000 },
  { 24375, 0x0000 }, { 24375, 0x0000 }, { 24375, 0x0000 }, { 24375, 0x0000 },
  { 24375, 0x0000 }, { 24375, 0x0000 }, { 24375, 0x8000 }, { 24376, 0x0022 },
  { 24378, 0x0000 }, { 24378, 0x0400 }, { 24379, 0x0100 }, { 24380, 0x1000 },
  /* 0x26700 */
  { 24381, 0x0000 }, { 24381, 0x0040 }, { 24382, 0x0000 }, { 24382, 0x0000 },
  { 24382, 0x0002 }, { 24383, 0x0000 }, { 24383, 0x0000 }, { 24383, 0x0000 },
  { 24383, 0x0000 }, { 24383, 0x0200 }, { 24384, 0x0000 }, { 24384, 0x0018 },
  { 24386, 0x1000 }, { 24387, 0x0000 }, { 24387, 0x0000 }, { 24387, 0x0000 },
  /* 0x26800 */
  { 24387, 0x0000 }, { 24387, 0x1000 }, { 24388, 0x0000 }, { 24388, 0x0000 },
  { 24388, 0x0040 }, { 24389, 0x4000 }, { 24390, 0x4000 }, { 24391, 0x0000 },
  { 24391, 0x0500 }, { 24393, 0x0008 }, { 24394, 0x0000 }, { 24394, 0x0000 },
  { 24394, 0x0080 }, { 24395, 0x0000 }, { 24395, 0x0000 }, { 24395, 0x0000 },
  /* 0x26900 */
  { 24395, 0x4000 }, { 24396, 0x0002 }, { 24397, 0x0040 }, { 24398, 0x0200 },
  { 24399, 0x0000 }, { 24399, 0x0002 }, { 24400, 0x0000 }, { 24400, 0x0000 },
  { 24400, 0x0000 }, { 24400, 0x0000 }, { 24400, 0x0100 }, { 24401, 0x0020 },
  { 24402, 0x0000 }, { 24402, 0x0000 }, { 24402, 0x0000 }, { 24402, 0x0404 },
  /* 0x26A00 */
  { 24404, 0x0000 }, { 24404, 0x0000 }, { 24404, 0x6000 }, { 24406, 0x0010 },
  { 24407, 0x0004 }, { 24408, 0x0006 }, { 24410, 0x0000 }, { 24410, 0x0000 },
  { 24410, 0x0000 }, { 24410, 0x0000 }, { 24410, 0x0000 }, { 24410, 0x0000 },
  { 24410, 0x0000 }, { 24410, 0x0000 }, { 24410, 0x0000 }, { 24410, 0x0000 },
  /* 0x26B00 */
  { 24410, 0x0420 }, { 24412, 0x0028 }, { 24414, 0x0100 }, { 24415, 0x0000 },
  { 24415, 0x0000 }, { 24415, 0x080F }, { 24420, 0x0000 }, { 24420, 0x0020 },
  { 24421, 0x0004 }, { 24422, 0x20C0 }, { 24425, 0x0000 }, { 24425, 0x0008 },
  { 24426, 0x0001 }, { 24427, 0x0000 }, { 24427, 0x0000 }, { 24427, 0x0080 },
  /* 0x26C00 */
  { 24428, 0x0000 }, { 24428, 0x0000 }, { 24428, 0x0002 }, { 24429, 0x0000 },
  { 24429, 0x0001 }, { 24430, 0x0000 }, { 24430, 0x0000 }, { 24430, 0xC000 },
  { 24432, 0x0007 }, { 24435, 0x0000 }, { 24435, 0x0010 }, { 24436, 0x2180 },
  { 24439, 0x0009 }, { 24441, 0x0002 }, { 24442, 0x0000 }, { 24442, 0x0000 },
  /* 0x26D00 */
  { 24442, 0x0000 }, { 24442, 0x0000 }, { 24442, 0x07FC }, { 24451, 0x0000 },
  { 24451, 0x0000 }, { 24451, 0x0002 }, { 24452, 0x0000 }, { 24452, 0x0010 },
  { 24453, 0x0000 }, { 24453, 0x0000 }, { 24453, 0x40FF }, { 24462, 0x0000 },
  { 24462, 0x0000 }, { 24462, 0x1000 }, { 24463, 0x0C00 }, { 24465, 0x0001 },
  /* 0x26E00 */
  { 24466, 0x00A1 }, { 24469, 0x0004 }, { 24470, 0x0000 }, { 24470, 0x0000 },
  { 24470, 0x003C }, { 24474, 0x0000 }, { 24474, 0x4000 }, { 24475, 0x0084 },
  { 24477, 0x0010 }, { 24478, 0x0200 }, { 24479, 0x0000 }, { 24479, 0x0000 },
  { 24479, 0x0000 }, { 24479, 0x00FF }, { 24487, 0x0000 }, { 24487, 0x0000 },
  /* 0x26F00 */
  { 24487, 0x0000 }, { 24487, 0x0000 }, { 24487, 0x0040 }, { 24488, 0x0000 },
  { 24488, 0x0000 }, { 24488, 0x0000 }, { 24488, 0x0000 }, { 24488, 0x0018 },
  { 24490, 0x0000 }, { 24490, 0x8000 }, { 24491, 0x0002 }, { 24492, 0x4000 },
  { 24493, 0x0000 }, { 24493, 0xC000 }, { 24495, 0x0000 }, { 24495, 0x0000 },
  /* 0x27000 */
  { 24495, 0x4000 }, { 24496, 0x0000 }, { 24496, 0x0000 }, { 24496, 0x0000 },
  { 24496, 0x0800 }, { 24497, 0x000C }, { 24499, 0x0000 }, { 24499, 0x0000 },
  { 24499, 0x0100 }, { 24500, 0x0000 }, { 24500, 0xE000 }, { 24503, 0x0000 },
  { 24503, 0x2000 }, { 24504, 0x0000 }, { 24504, 0x0000 }, { 24504, 0x0100 },
  /* 0x27100 */
  { 24505, 0x3200 }, { 24508, 0x0000 }, { 24508, 0x00C0 }, { 24510, 0x0000 },
  { 24510, 0x0000 }, { 24510, 0x0000 }, { 24510, 0x0030 }, { 24512, 0x0020 },
  { 24513, 0x0000 }, { 24513, 0x0000 }, { 24513, 0x0000 }, { 24513, 0x0000 },
  { 24513, 0x2000 }, { 24514, 0x0000 }, { 24514, 0x0000 }, { 24514, 0x0000 },
  /* 0x27200 */
  { 24514, 0x0000 }, { 24514, 0x0800 }, { 24515, 0x0000 }, { 24515, 0x0000 },
  { 24515, 0x0000 }, { 24515, 0x0000 }, { 24515, 0x0000 }, { 24515, 0x0000 },
  { 24515, 0x0821 }, { 24518, 0x0000 }, { 24518, 0x0000 }, { 24518, 0x0044 },
  { 24520, 0x0000 }, { 24520, 0x0000 }, { 24520, 0x0040 }, { 24521, 0x0000 },
  /* 0x27300 */
  { 24521, 0x0000 }, { 24521, 0x0000 }, { 24521, 0x0000 }, { 24521, 0x0000 },
  { 24521, 0x0000 }, { 24521, 0x0000 }, { 24521, 0x0000 }, { 24521, 0x0000 },
  { 24521, 0x0000 }, { 24521, 0x0400 }, { 24522, 0x0000 }, { 24522, 0x0000 },
  { 24522, 0x0000 }, { 24522, 0x0000 }, { 24522, 0x0000 }, { 24522, 0x0000 },
  /* 0x27400 */
  { 24522, 0x0000 }, { 24522, 0x0000 }, { 24522, 0x0004 }, { 24523, 0x0000 },
  { 24523, 0x0000 }, { 24523, 0x0001 }, { 24524, 0x0000 }, { 24524, 0x0000 },
  { 24524, 0x0050 }, { 24526, 0x0000 }, { 24526, 0x0000 }, { 24526, 0x0000 },
  { 24526, 0x0000 }, { 24526, 0x0000 }, { 24526, 0x0000 }, { 24526, 0x0000 },
  /* 0x27500 */
  { 24526, 0x0000 }, { 24526, 0x0000 }, { 24526, 0x0000 }, { 24526, 0x0000 },
  { 24526, 0x0000 }, { 24526, 0x0000 }, { 24526, 0x0000 }, { 24526, 0x0010 },
  { 24527, 0x0000 }, { 24527, 0x0000 }, { 24527, 0x0008 }, { 24528, 0x0000 },
  { 24528, 0x0000 }, { 24528, 0x0000 }, { 24528, 0x0011 }, { 24530, 0x6000 },
  /* 0x27600 */
  { 24532, 0x1080 }, { 24534, 0x0000 }, { 24534, 0x0000 }, { 24534, 0x0204 },
  { 24536, 0x0000 }, { 24536, 0x00E0 }, { 24539, 0x0000 }, { 24539, 0x0000 },
  { 24539, 0x0000 }, { 24539, 0x0010 }, { 24540, 0x0000 }, { 24540, 0x0000 },
  { 24540, 0x0000 }, { 24540, 0x0000 }, { 24540, 0x0000 }, { 24540, 0x0000 },
  /* 0x27700 */
  { 24540, 0x8000 }, { 24541, 0x0000 }, { 24541, 0x0000 }, { 24541, 0x0060 },
  { 24543, 0x0002 }, { 24544, 0x4000 }, { 24545, 0x0000 }, { 24545, 0x0000 },
  { 24545, 0x0030 }, { 24547, 0x0000 }, { 24547, 0x0000 }, { 24547, 0x0000 },
  { 24547, 0x1000 }, { 24548, 0x0000 }, { 24548, 0x0000 }, { 24548, 0x0000 },
  /* 0x27800 */
  { 24548, 0x0000 }, { 24548, 0x0000 }, { 24548, 0x0000 }, { 24548, 0x0000 },
  { 24548, 0x0000 }, { 24548, 0x0100 }, { 24549, 0x0000 }, { 24549, 0x0001 },
  { 24550, 0x0000 }, { 24550, 0x2000 }, { 24551, 0x0000 }, { 24551, 0x0004 },
  { 24552, 0x0100 }, { 24553, 0x0000 }, { 24553, 0x0000 }, { 24553, 0x0000 },
  /* 0x27900 */
  { 24553, 0x0000 }, { 24553, 0x0000 }, { 24553, 0x0010 }, { 24554, 0x0000 },
  { 24554, 0x0000 }, { 24554, 0x0000 }, { 24554, 0x0080 }, { 24555, 0x0400 },
  { 24556, 0x0000 }, { 24556, 0x0000 }, { 24556, 0x0001 }, { 24557, 0x0000 },
  { 24557, 0x0000 }, { 24557, 0x2000 }, { 24558, 0x0000 }, { 24558, 0x2000 },
  /* 0x27A00 */
  { 24559, 0x4400 }, { 24561, 0x0000 }, { 24561, 0x0000 }, { 24561, 0x4000 },
  { 24562, 0x0000 }, { 24562, 0x0208 }, { 24564, 0x0000 }, { 24564, 0x0200 },
  { 24565, 0x0010 }, { 24566, 0x0000 }, { 24566, 0x0000 }, { 24566, 0x6000 },
  { 24568, 0x0000 }, { 24568, 0x0000 }, { 24568, 0x0000 }, { 24568, 0x0010 },
  /* 0x27B00 */
  { 24569, 0x0840 }, { 24571, 0x0100 }, { 24572, 0x0000 }, { 24572, 0x0700 },
  { 24575, 0x0100 }, { 24576, 0x0000 }, { 24576, 0x0000 }, { 24576, 0x0000 },
  { 24576, 0x0000 }, { 24576, 0x0000 }, { 24576, 0x0000 }, { 24576, 0x0000 },
  { 24576, 0x0000 }, { 24576, 0x0000 }, { 24576, 0x0000 }, { 24576, 0x0010 },
  /* 0x27C00 */
  { 24577, 0x0000 }, { 24577, 0x0004 }, { 24578, 0x0000 }, { 24578, 0x0000 },
  { 24578, 0x0000 }, { 24578, 0x0000 }, { 24578, 0x0000 }, { 24578, 0x0000 },
  { 24578, 0x0000 }, { 24578, 0x0000 }, { 24578, 0x0000 }, { 24578, 0x0000 },
  { 24578, 0x0000 }, { 24578, 0x0000 }, { 24578, 0x0000 }, { 24578, 0x0000 },
  /* 0x27D00 */
  { 24578, 0x0000 }, { 24578, 0x0000 }, { 24578, 0x8000 }, { 24579, 0x0000 },
  { 24579, 0x0000 }, { 24579, 0x0018 }, { 24581, 0x0040 }, { 24582, 0x0008 },
  { 24583, 0x8010 }, { 24585, 0x0100 }, { 24586, 0x0000 }, { 24586, 0x2000 },
  { 24587, 0x0000 }, { 24587, 0x1000 }, { 24588, 0x0000 }, { 24588, 0x0000 },
  /* 0x27E00 */
  { 24588, 0x0000 }, { 24588, 0x0000 }, { 24588, 0x0000 }, { 24588, 0x0000 },
  { 24588, 0xA000 }, { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 },
  { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 },
  { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 },
  /* 0x27F00 */
  { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 },
  { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 },
  { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 },
  { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0000 }, { 24590, 0x0200 },
  /* 0x28000 */
  { 24591, 0x0204 }, { 24593, 0x4000 }, { 24594, 0x0018 }, { 24596, 0x0000 },
  { 24596, 0x0100 }, { 24597, 0x0000 }, { 24597, 0x0000 }, { 24597, 0x0000 },
  { 24597, 0x0008 }, { 24598, 0x0001 }, { 24599, 0x0000 }, { 24599, 0x6000 },
  { 24601, 0x0000 }, { 24601, 0x0000 }, { 24601, 0x0300 }, { 24603, 0x0010 },
  /* 0x28100 */
  { 24604, 0x0000 }, { 24604, 0x0000 }, { 24604, 0x4000 }, { 24605, 0x0000 },
  { 24605, 0x8000 }, { 24606, 0x2000 }, { 24607, 0x8000 }, { 24608, 0x0000 },
  { 24608, 0x0200 }, { 24609, 0x0000 }, { 24609, 0x8000 }, { 24610, 0x1000 },
  { 24611, 0x0000 }, { 24611, 0x0000 }, { 24611, 0x0000 }, { 24611, 0x0000 },
  /* 0x28200 */
  { 24611, 0x0080 }, { 24612, 0x0500 }, { 24614, 0x0000 }, { 24614, 0x0000 },
  { 24614, 0x0000 }, { 24614, 0x0040 }, { 24615, 0x0000 }, { 24615, 0x1000 },
  { 24616, 0x0000 }, { 24616, 0x0800 }, { 24617, 0x0000 }, { 24617, 0x0000 },
  { 24617, 0x2000 }, { 24618, 0x0000 }, { 24618, 0x0004 }, { 24619, 0x0000 },
  /* 0x28300 */
  { 24619, 0x0040 }, { 24620, 0x0100 }, { 24621, 0x8000 }, { 24622, 0x0400 },
  { 24623, 0x0000 }, { 24623, 0x0000 }, { 24623, 0x2020 }, { 24625, 0x2000 },
  { 24626, 0x0400 }, { 24627, 0x0000 }, { 24627, 0x0000 }, { 24627, 0x0000 },
  { 24627, 0x0000 }, { 24627, 0x0000 }, { 24627, 0x0000 }, { 24627, 0x0000 },
  /* 0x28400 */
  { 24627, 0x0000 }, { 24627, 0x0004 }, { 24628, 0x0000 }, { 24628, 0x0000 },
  { 24628, 0x0000 }, { 24628, 0x0000 }, { 24628, 0x1100 }, { 24630, 0x0008 },
  { 24631, 0x0004 }, { 24632, 0x0000 }, { 24632, 0x0000 }, { 24632, 0x0000 },
  { 24632, 0x0000 }, { 24632, 0x0000 }, { 24632, 0x0000 }, { 24632, 0x0000 },
  /* 0x28500 */
  { 24632, 0x0002 }, { 24633, 0x0000 }, { 24633, 0x0000 }, { 24633, 0x3000 },
  { 24635, 0x0000 }, { 24635, 0x0000 }, { 24635, 0x1000 }, { 24636, 0x0000 },
  { 24636, 0x0000 }, { 24636, 0x0000 }, { 24636, 0x0000 }, { 24636, 0x0000 },
  { 24636, 0x0000 }, { 24636, 0x0000 }, { 24636, 0x0100 }, { 24637, 0x0010 },
  /* 0x28600 */
  { 24638, 0x0801 }, { 24640, 0x0000 }, { 24640, 0x0020 }, { 24641, 0x0800 },
  { 24642, 0x0000 }, { 24642, 0x0000 }, { 24642, 0x0000 }, { 24642, 0x0000 },
  { 24642, 0x0000 }, { 24642, 0x0000 }, { 24642, 0x0C00 }, { 24644, 0x1000 },
  { 24645, 0x0000 }, { 24645, 0x0100 }, { 24646, 0x0040 }, { 24647, 0x0000 },
  /* 0x28700 */
  { 24647, 0x8000 }, { 24648, 0x0008 }, { 24649, 0x0000 }, { 24649, 0x0000 },
  { 24649, 0x0000 }, { 24649, 0x0000 }, { 24649, 0x0000 }, { 24649, 0x0000 },
  { 24649, 0x0000 }, { 24649, 0x0000 }, { 24649, 0x0000 }, { 24649, 0x0000 },
  { 24649, 0x0000 }, { 24649, 0x0000 }, { 24649, 0x0000 }, { 24649, 0x0000 },
  /* 0x28800 */
  { 24649, 0x0010 }, { 24650, 0x0000 }, { 24650, 0x0800 }, { 24651, 0x0000 },
  { 24651, 0x0000 }, { 24651, 0x0000 }, { 24651, 0x0000 }, { 24651, 0x0000 },
  { 24651, 0x0000 }, { 24651, 0x0000 }, { 24651, 0x0000 }, { 24651, 0x0000 },
  { 24651, 0x0000 }, { 24651, 0x0000 }, { 24651, 0x0000 }, { 24651, 0x0000 },
  /* 0x28900 */
  { 24651, 0x0000 }, { 24651, 0x0000 }, { 24651, 0x0000 }, { 24651, 0x0008 },
  { 24652, 0x0300 }, { 24654, 0x0040 }, { 24655, 0x1110 }, { 24658, 0x4000 },
  { 24659, 0x0200 }, { 24660, 0x0000 }, { 24660, 0x0D00 }, { 24663, 0x1100 },
  { 24665, 0x0001 }, { 24666, 0x5000 }, { 24668, 0x019A }, { 24673, 0x1E00 },
  /* 0x28A00 */
  { 24677, 0x8000 }, { 24678, 0x0040 }, { 24679, 0x0220 }, { 24681, 0x0044 },
  { 24683, 0x0FF0 }, { 24691, 0x0600 }, { 24693, 0x0000 }, { 24693, 0x0000 },
  { 24693, 0x000E }, { 24696, 0x1C00 }, { 24699, 0x0000 }, { 24699, 0x0000 },
  { 24699, 0x5841 }, { 24704, 0xC000 }, { 24706, 0x042F }, { 24712, 0x1000 },
  /* 0x28B00 */
  { 24713, 0x1000 }, { 24714, 0x0008 }, { 24715, 0xB806 }, { 24721, 0x0000 },
  { 24721, 0x5040 }, { 24724, 0x0001 }, { 24725, 0x1078 }, { 24730, 0x0000 },
  { 24730, 0x8000 }, { 24731, 0x3200 }, { 24734, 0x0000 }, { 24734, 0x0000 },
  { 24734, 0x0024 }, { 24736, 0x0690 }, { 24740, 0x1F80 }, { 24746, 0x8020 },
  /* 0x28C00 */
  { 24748, 0x0208 }, { 24750, 0x3000 }, { 24752, 0x0848 }, { 24755, 0x0A01 },
  { 24758, 0x0000 }, { 24758, 0x0000 }, { 24758, 0x0000 }, { 24758, 0x0000 },
  { 24758, 0x0000 }, { 24758, 0x0000 }, { 24758, 0x0000 }, { 24758, 0x0000 },
  { 24758, 0x2400 }, { 24760, 0x0004 }, { 24761, 0x0000 }, { 24761, 0x0000 },
  /* 0x28D00 */
  { 24761, 0x0000 }, { 24761, 0x0000 }, { 24761, 0x0000 }, { 24761, 0x0010 },
  { 24762, 0x0000 }, { 24762, 0x0000 }, { 24762, 0x0000 }, { 24762, 0x0000 },
  { 24762, 0x0000 }, { 24762, 0x0200 }, { 24763, 0x0000 }, { 24763, 0x0200 },
  { 24764, 0x0000 }, { 24764, 0x0000 }, { 24764, 0x0000 }, { 24764, 0x0000 },
  /* 0x28E00 */
  { 24764, 0x8000 }, { 24765, 0x0000 }, { 24765, 0x0000 }, { 24765, 0x0240 },
  { 24767, 0x0000 }, { 24767, 0x0000 }, { 24767, 0x0060 }, { 24769, 0x0000 },
  { 24769, 0x0000 }, { 24769, 0x0080 }, { 24770, 0x1000 }, { 24771, 0x000C },
  { 24773, 0x0000 }, { 24773, 0x0200 }, { 24774, 0x0080 }, { 24775, 0x0000 },
  /* 0x28F00 */
  { 24775, 0x0000 }, { 24775, 0x0000 }, { 24775, 0x0000 }, { 24775, 0x0000 },
  { 24775, 0x0000 }, { 24775, 0x0000 }, { 24775, 0x0000 }, { 24775, 0x0000 },
  { 24775, 0x0000 }, { 24775, 0x0000 }, { 24775, 0x0000 }, { 24775, 0x0000 },
  { 24775, 0x0020 }, { 24776, 0x0000 }, { 24776, 0x0000 }, { 24776, 0x0000 },
  /* 0x29000 */
  { 24776, 0x0000 }, { 24776, 0x0000 }, { 24776, 0x0000 }, { 24776, 0x0000 },
  { 24776, 0x0000 }, { 24776, 0x0000 }, { 24776, 0x0000 }, { 24776, 0x0000 },
  { 24776, 0x0900 }, { 24778, 0x0008 }, { 24779, 0x8000 }, { 24780, 0x0003 },
  { 24782, 0x0001 }, { 24783, 0x0000 }, { 24783, 0x3030 }, { 24787, 0x0000 },
  /* 0x29100 */
  { 24787, 0x2000 }, { 24788, 0x0001 }, { 24789, 0x0000 }, { 24789, 0x1000 },
  { 24790, 0x2000 }, { 24791, 0x4800 }, { 24793, 0x0000 }, { 24793, 0x0001 },
  { 24794, 0x0000 }, { 24794, 0x1000 }, { 24795, 0x0100 }, { 24796, 0x0000 },
  { 24796, 0x0000 }, { 24796, 0x0020 }, { 24797, 0x0800 },
};
static const Summary16 big5hkscs_uni2index_page294[32] = {
  /* 0x29400 */
  { 24798, 0x0000 }, { 24798, 0x2000 }, { 24799, 0x0001 }, { 24800, 0x8008 },
  { 24802, 0x0100 }, { 24803, 0x0000 }, { 24803, 0x0000 }, { 24803, 0x0000 },
  { 24803, 0x0000 }, { 24803, 0x0000 }, { 24803, 0x0000 }, { 24803, 0x0000 },
  { 24803, 0x0000 }, { 24803, 0x0601 }, { 24806, 0x00A0 }, { 24808, 0x0000 },
  /* 0x29500 */
  { 24808, 0x0000 }, { 24808, 0x0000 }, { 24808, 0x0000 }, { 24808, 0x0000 },
  { 24808, 0x0000 }, { 24808, 0x0000 }, { 24808, 0x0000 }, { 24808, 0x0000 },
  { 24808, 0x0000 }, { 24808, 0x4000 }, { 24809, 0x0000 }, { 24809, 0x0101 },
  { 24811, 0x0000 }, { 24811, 0x0080 }, { 24812, 0x0200 }, { 24813, 0x0010 },
};
static const Summary16 big5hkscs_uni2index_page297[251] = {
  /* 0x29700 */
  { 24814, 0x0000 }, { 24814, 0x0000 }, { 24814, 0x0001 }, { 24815, 0x0004 },
  { 24816, 0x0000 }, { 24816, 0x0000 }, { 24816, 0x0000 }, { 24816, 0x0000 },
  { 24816, 0x0000 }, { 24816, 0x0000 }, { 24816, 0x0000 }, { 24816, 0x0000 },
  { 24816, 0x0000 }, { 24816, 0x0010 }, { 24817, 0x0000 }, { 24817, 0x0000 },
  /* 0x29800 */
  { 24817, 0x0000 }, { 24817, 0x0001 }, { 24818, 0x0000 }, { 24818, 0x0000 },
  { 24818, 0x0000 }, { 24818, 0x0080 }, { 24819, 0x0000 }, { 24819, 0x0000 },
  { 24819, 0x0000 }, { 24819, 0x0000 }, { 24819, 0x0010 }, { 24820, 0x0000 },
  { 24820, 0x0000 }, { 24820, 0x0002 }, { 24821, 0x0400 }, { 24822, 0x0002 },
  /* 0x29900 */
  { 24823, 0x0028 }, { 24825, 0x0000 }, { 24825, 0x8000 }, { 24826, 0x0000 },
  { 24826, 0x0380 }, { 24829, 0x2000 }, { 24830, 0x0400 }, { 24831, 0x0000 },
  { 24831, 0x0000 }, { 24831, 0x2000 }, { 24832, 0x0000 }, { 24832, 0x0000 },
  { 24832, 0x0208 }, { 24834, 0x0000 }, { 24834, 0x0000 }, { 24834, 0x0000 },
  /* 0x29A00 */
  { 24834, 0x0000 }, { 24834, 0x0000 }, { 24834, 0x0100 }, { 24835, 0x0000 },
  { 24835, 0x2000 }, { 24836, 0x0000 }, { 24836, 0x0000 }, { 24836, 0x0000 },
  { 24836, 0x0000 }, { 24836, 0x0000 }, { 24836, 0x0000 }, { 24836, 0x0000 },
  { 24836, 0x0000 }, { 24836, 0x0000 }, { 24836, 0x0000 }, { 24836, 0x0000 },
  /* 0x29B00 */
  { 24836, 0x4020 }, { 24838, 0x0000 }, { 24838, 0x0000 }, { 24838, 0x0000 },
  { 24838, 0x0000 }, { 24838, 0x0000 }, { 24838, 0x0000 }, { 24838, 0x0000 },
  { 24838, 0x0000 }, { 24838, 0x0000 }, { 24838, 0x0000 }, { 24838, 0x0000 },
  { 24838, 0x0000 }, { 24838, 0x0020 }, { 24839, 0x0000 }, { 24839, 0x0000 },
  /* 0x29C00 */
  { 24839, 0x0000 }, { 24839, 0x0000 }, { 24839, 0x0000 }, { 24839, 0x0000 },
  { 24839, 0x0000 }, { 24839, 0x0000 }, { 24839, 0x0000 }, { 24839, 0x0008 },
  { 24840, 0x0000 }, { 24840, 0x0000 }, { 24840, 0x2000 }, { 24841, 0x0000 },
  { 24841, 0x0000 }, { 24841, 0x0000 }, { 24841, 0x0000 }, { 24841, 0x0000 },
  /* 0x29D00 */
  { 24841, 0x0000 }, { 24841, 0x0000 }, { 24841, 0x0000 }, { 24841, 0x4000 },
  { 24842, 0x0000 }, { 24842, 0x0400 }, { 24843, 0x0000 }, { 24843, 0x1000 },
  { 24844, 0x0000 }, { 24844, 0x0900 }, { 24846, 0x0000 }, { 24846, 0x0000 },
  { 24846, 0x0000 }, { 24846, 0x0000 }, { 24846, 0x0000 }, { 24846, 0x0040 },
  /* 0x29E00 */
  { 24847, 0x0040 }, { 24848, 0x0000 }, { 24848, 0x2000 }, { 24849, 0x0000 },
  { 24849, 0x0000 }, { 24849, 0x0000 }, { 24849, 0x0100 }, { 24850, 0x0000 },
  { 24850, 0x0000 }, { 24850, 0x0000 }, { 24850, 0x1000 }, { 24851, 0x0000 },
  { 24851, 0x0008 }, { 24852, 0x0000 }, { 24852, 0x0000 }, { 24852, 0x0100 },
  /* 0x29F00 */
  { 24853, 0x0000 }, { 24853, 0x0000 }, { 24853, 0x0008 }, { 24854, 0x0001 },
  { 24855, 0x0000 }, { 24855, 0x0000 }, { 24855, 0x0000 }, { 24855, 0x0000 },
  { 24855, 0x0000 }, { 24855, 0x0000 }, { 24855, 0x0000 }, { 24855, 0x0080 },
  { 24856, 0x0000 }, { 24856, 0x4000 }, { 24857, 0x0000 }, { 24857, 0x0000 },
  /* 0x2A000 */
  { 24857, 0x0000 }, { 24857, 0x0010 }, { 24858, 0x0000 }, { 24858, 0x0000 },
  { 24858, 0x0000 }, { 24858, 0x0000 }, { 24858, 0x0000 }, { 24858, 0x0000 },
  { 24858, 0x0080 }, { 24859, 0x0000 }, { 24859, 0x0000 }, { 24859, 0x0200 },
  { 24860, 0x0000 }, { 24860, 0x0000 }, { 24860, 0x2002 }, { 24862, 0x4108 },
  /* 0x2A100 */
  { 24865, 0x0080 }, { 24866, 0x0000 }, { 24866, 0x0008 }, { 24867, 0x0018 },
  { 24869, 0x0000 }, { 24869, 0x0001 }, { 24870, 0x0000 }, { 24870, 0x0000 },
  { 24870, 0x0000 }, { 24870, 0x000C }, { 24872, 0x0800 }, { 24873, 0x0010 },
  { 24874, 0x0000 }, { 24874, 0x8000 }, { 24875, 0x0000 }, { 24875, 0x0020 },
  /* 0x2A200 */
  { 24876, 0x0000 }, { 24876, 0x0000 }, { 24876, 0x0001 }, { 24877, 0x0008 },
  { 24878, 0x0000 }, { 24878, 0x0000 }, { 24878, 0x0000 }, { 24878, 0x0000 },
  { 24878, 0x0000 }, { 24878, 0x8008 }, { 24880, 0x0000 }, { 24880, 0x2454 },
  { 24885, 0x0000 }, { 24885, 0x8000 }, { 24886, 0x0000 }, { 24886, 0x8000 },
  /* 0x2A300 */
  { 24887, 0x0000 }, { 24887, 0x0000 }, { 24887, 0x0000 }, { 24887, 0x0000 },
  { 24887, 0x0000 }, { 24887, 0x0000 }, { 24887, 0x0000 }, { 24887, 0x0000 },
  { 24887, 0x0000 }, { 24887, 0x0000 }, { 24887, 0x0200 }, { 24888, 0x0000 },
  { 24888, 0x0000 }, { 24888, 0x0000 }, { 24888, 0x0000 }, { 24888, 0x0000 },
  /* 0x2A400 */
  { 24888, 0x0000 }, { 24888, 0x0000 }, { 24888, 0x0000 }, { 24888, 0x0010 },
  { 24889, 0x0000 }, { 24889, 0x0800 }, { 24890, 0x0000 }, { 24890, 0x0000 },
  { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 },
  { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 },
  /* 0x2A500 */
  { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 },
  { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 },
  { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 }, { 24890, 0x0000 },
  { 24890, 0x0840 }, { 24892, 0x0000 }, { 24892, 0x0000 }, { 24892, 0x0000 },
  /* 0x2A600 */
  { 24892, 0x0002 }, { 24893, 0x0000 }, { 24893, 0x0000 }, { 24893, 0x0004 },
  { 24894, 0x0400 }, { 24895, 0x0800 }, { 24896, 0x0000 }, { 24896, 0x0000 },
  { 24896, 0x0000 }, { 24896, 0x0000 }, { 24896, 0x0200 },
};
static const Summary16 big5hkscs_uni2index_page2f8[30] = {
  /* 0x2F800 */
  { 24897, 0x0000 }, { 24897, 0x0000 }, { 24897, 0x0020 }, { 24898, 0x0800 },
  { 24899, 0x0001 }, { 24900, 0x0000 }, { 24900, 0x0000 }, { 24900, 0x0100 },
  { 24901, 0x0000 }, { 24901, 0x0010 }, { 24902, 0x0040 }, { 24903, 0x0000 },
  { 24903, 0x2000 }, { 24904, 0x0000 }, { 24904, 0x0000 }, { 24904, 0x0000 },
  /* 0x2F900 */
  { 24904, 0x0000 }, { 24904, 0x0000 }, { 24904, 0x0000 }, { 24904, 0x0000 },
  { 24904, 0x0000 }, { 24904, 0x0000 }, { 24904, 0x0000 }, { 24904, 0x0000 },
  { 24904, 0x0000 }, { 24904, 0x0010 }, { 24905, 0x0000 }, { 24905, 0x1004 },
  { 24907, 0x0000 }, { 24907, 0x0010 },
};

int qt_UnicodeToBig5hkscs (uint wc, uchar *r)
{
    const Summary16 *summary = NULL;
    if (wc < 0x80) {
        r[0] = (uchar) wc;
        return 1;
    }
    if (wc < 0x0460)
        summary = &big5hkscs_uni2index_page00[(wc>>4)];
    else if (wc >= 0x1e00 && wc < 0x1ed0)
        summary = &big5hkscs_uni2index_page1e[(wc>>4)-0x1e0];
    else if (wc >= 0x2000 && wc < 0x2740)
        summary = &big5hkscs_uni2index_page20[(wc>>4)-0x200];
    else if (wc >= 0x2e00 && wc < 0x9fb0)
        summary = &big5hkscs_uni2index_page2e[(wc>>4)-0x2e0];
    else if (wc >= 0xe000 && wc < 0xfa30)
        summary = &big5hkscs_uni2index_pagee0[(wc>>4)-0xe00];
    else if (wc >= 0xfe00 && wc < 0xfff0)
        summary = &big5hkscs_uni2index_pagefe[(wc>>4)-0xfe0];
    else if (wc >= 0x20000 && wc < 0x291f0)
        summary = &big5hkscs_uni2index_page200[(wc>>4)-0x2000];
    else if (wc >= 0x29400 && wc < 0x29600)
        summary = &big5hkscs_uni2index_page294[(wc>>4)-0x2940];
    else if (wc >= 0x29700 && wc < 0x2a6b0)
        summary = &big5hkscs_uni2index_page297[(wc>>4)-0x2970];
    else if (wc >= 0x2f800 && wc < 0x2f9e0)
        summary = &big5hkscs_uni2index_page2f8[(wc>>4)-0x2f80];
    if (summary) {
        ushort used = summary->used;
        uint i = wc & 0x0f;
        if (used & ((ushort) 1 << i)) {
            const uchar *c;
            /* Keep in `used' only the bits 0..i-1. */
            used &= ((ushort) 1 << i) - 1;
            /* Add `summary->index' and the number of bits set in `used'. */
            used = (used & 0x5555) + ((used & 0xaaaa) >> 1);
            used = (used & 0x3333) + ((used & 0xcccc) >> 2);
            used = (used & 0x0f0f) + ((used & 0xf0f0) >> 4);
            used = (used & 0x00ff) + (used >> 8);
            c = big5hkscs_to_charset[summary->index + used];
            if (c [1] != 0) {
                r[0] = c[0];
                r[1] = c[1];
                return 2;
            } else {  // (c [1] == 0)
                r[0] = c[0];
                return 1;
            }
        }
    }
    return 0;
}


/* ====================================================================== */
#endif // QT_NO_TEXTCODEC

QT_END_NAMESPACE
