import sys
from PyQt4.QtGui import QApplication
from PyQt4.QtCore import QSize, SIGNAL
from qzion import QZionObject, QZionCanvas, QZionRectangle


def cb_size_changed(size):
    print "size changed: ", size


if __name__ == "__main__":
    app = QApplication(sys.argv)
    canvas = QZionCanvas()

    canvas.show()

    image = QZionRectangle(canvas)
    image.setAttribute(QZionObject.EmitSizeChanges)
    image.connect(image, SIGNAL("sizeChanged(QSize)"), cb_size_changed)
    image.show()

    image.setSize(QSize(30, 30))
    image.setAttribute(QZionObject.EmitSizeChanges, False)
    image.setSize(QSize(80, 80))
    image.setAttribute(QZionObject.EmitSizeChanges, True)
    image.setSize(QSize(90, 90))

    sys.exit(app.exec_())
