/* test-umockdev-record.c generated by valac 0.22.1, the Vala compiler
 * generated from test-umockdev-record.vala, do not modify */

/*
 * test-umockdev-record.vala
 *
 * Copyright (C) 2013 Canonical Ltd.
 * Author: Martin Pitt <martin.pitt@ubuntu.com>
 *
 * umockdev is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * umockdev is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <umockdev.h>
#include <unistd.h>
#include <pty.h>
#include <termios.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <gio/gio.h>
#include <gio/gunixsocketaddress.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);


extern gchar* umockdev_record_path;
gchar* umockdev_record_path = NULL;
extern gchar* umockdev_run_path;
gchar* umockdev_run_path = NULL;
extern gchar* rootdir;
gchar* rootdir = NULL;

void spawn (const gchar* command, gchar** sout, gchar** serr, gint* exit);
void assert_in (const gchar* needle, const gchar* haystack);
gchar* file_contents (const gchar* filename);
void t_testbed_all_empty (void);
void t_testbed_one (void);
void t_testbed_multiple (void);
void t_testbed_no_ioctl_record (void);
void t_system_single (void);
void t_system_all (void);
void t_system_invalid (void);
void t_system_ioctl_log (void);
void t_system_ioctl_log_append_dev_mismatch (void);
void t_system_script_log_simple (void);
void t_system_script_log_append_same_dev (void);
void t_system_script_log_append_dev_mismatch (void);
gchar* read_line_timeout (FILE* stream);
void t_system_script_log_chatter (void);
void t_system_script_log_chatter_socket_stream (void);
void t_system_evemu_log (void);
void t_run_invalid_args (void);
void t_gphoto2_record (void);
gint _vala_main (gchar** args, int args_length1);
static void _t_testbed_all_empty_gtest_func (void);
static void _t_testbed_one_gtest_func (void);
static void _t_testbed_multiple_gtest_func (void);
static void _t_testbed_no_ioctl_record_gtest_func (void);
static void _t_system_single_gtest_func (void);
static void _t_system_all_gtest_func (void);
static void _t_system_invalid_gtest_func (void);
static void _t_system_ioctl_log_gtest_func (void);
static void _t_system_ioctl_log_append_dev_mismatch_gtest_func (void);
static void _t_system_script_log_simple_gtest_func (void);
static void _t_system_script_log_append_same_dev_gtest_func (void);
static void _t_system_script_log_append_dev_mismatch_gtest_func (void);
static void _t_system_script_log_chatter_gtest_func (void);
static void _t_system_script_log_chatter_socket_stream_gtest_func (void);
static void _t_system_evemu_log_gtest_func (void);
static void _t_run_invalid_args_gtest_func (void);
static void _t_gphoto2_record_gtest_func (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


void spawn (const gchar* command, gchar** sout, gchar** serr, gint* exit) {
	gchar* _vala_sout = NULL;
	gchar* _vala_serr = NULL;
	gint _vala_exit = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (command != NULL);
	{
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gboolean _tmp5_ = FALSE;
		_tmp1_ = command;
		_tmp5_ = g_spawn_command_line_sync (_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_inner_error_);
		_g_free0 (_vala_sout);
		_vala_sout = _tmp2_;
		_g_free0 (_vala_serr);
		_vala_serr = _tmp3_;
		_vala_exit = _tmp4_;
		_tmp0_ = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_vala_assert (_tmp0_, "Process.spawn_command_line_sync (command, out sout, out serr, out exit)");
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = command;
		_tmp7_ = e->message;
		g_error ("test-umockdev-record.vala:34: Cannot call '%s': %s", _tmp6_, _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (sout) {
		*sout = _vala_sout;
	} else {
		_g_free0 (_vala_sout);
	}
	if (serr) {
		*serr = _vala_serr;
	} else {
		_g_free0 (_vala_serr);
	}
	if (exit) {
		*exit = _vala_exit;
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


void assert_in (const gchar* needle, const gchar* haystack) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (needle != NULL);
	g_return_if_fail (haystack != NULL);
	_tmp0_ = haystack;
	_tmp1_ = needle;
	_tmp2_ = string_contains (_tmp0_, _tmp1_);
	if (!_tmp2_) {
		FILE* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = needle;
		_tmp5_ = haystack;
		fprintf (_tmp3_, "'%s' not found in '%s'\n", _tmp4_, _tmp5_);
		abort ();
	}
}


gchar* file_contents (const gchar* filename) {
	gchar* result = NULL;
	gchar* contents = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	{
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = filename;
		_tmp3_ = g_file_get_contents (_tmp1_, &_tmp2_, NULL, &_inner_error_);
		_g_free0 (contents);
		contents = _tmp2_;
		_tmp0_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			_g_free0 (contents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_vala_assert (_tmp0_, "FileUtils.get_contents (filename, out contents)");
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = filename;
		_tmp5_ = e->message;
		g_error ("test-umockdev-record.vala:54: Cannot get contents of %s: %s", _tmp4_, _tmp5_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = contents;
	return result;
}


void t_testbed_all_empty (void) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_vala_assert (tb != NULL, "tb != null");
	_tmp1_ = umockdev_record_path;
	_tmp2_ = g_strconcat (_tmp1_, " --all", NULL);
	_tmp3_ = _tmp2_;
	spawn (_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	_g_free0 (sout);
	sout = _tmp4_;
	_g_free0 (serr);
	serr = _tmp5_;
	exit = _tmp6_;
	_g_free0 (_tmp3_);
	g_assert_cmpstr (serr, ==, "");
	g_assert_cmpstr (sout, ==, "");
	g_assert_cmpint (exit, ==, 0);
	_g_object_unref0 (tb);
	_g_free0 (serr);
	_g_free0 (sout);
}


void t_testbed_one (void) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_ = NULL;
	gchar* syspath = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	guint8* _tmp13_ = NULL;
	guint8* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = g_strdup ("simple_attr");
	_tmp2_ = g_strdup ("1");
	_tmp3_ = g_strdup ("multiline_attr");
	_tmp4_ = g_strdup ("a\\b\nc\\d\nlast");
	_tmp5_ = g_new0 (gchar*, 4 + 1);
	_tmp5_[0] = _tmp1_;
	_tmp5_[1] = _tmp2_;
	_tmp5_[2] = _tmp3_;
	_tmp5_[3] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 4;
	_tmp7_ = g_strdup ("SIMPLE_PROP");
	_tmp8_ = g_strdup ("1");
	_tmp9_ = g_new0 (gchar*, 2 + 1);
	_tmp9_[0] = _tmp7_;
	_tmp9_[1] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 2;
	_tmp11_ = umockdev_testbed_add_devicev (tb, "pci", "dev1", NULL, _tmp6_, _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	syspath = _tmp12_;
	_tmp13_ = g_new0 (guint8, 6);
	_tmp13_[0] = (guint8) 0x41;
	_tmp13_[1] = (guint8) 0xFF;
	_tmp13_[2] = (guint8) 0;
	_tmp13_[3] = (guint8) 5;
	_tmp13_[4] = (guint8) 0xFF;
	_tmp13_[5] = (guint8) 0;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 6;
	umockdev_testbed_set_attribute_binary (tb, syspath, "binary_attr", _tmp14_, 6);
	_tmp14_ = (g_free (_tmp14_), NULL);
	umockdev_testbed_set_attribute_link (tb, syspath, "driver", "../../drivers/foo");
	_tmp15_ = umockdev_record_path;
	_tmp16_ = g_strconcat (_tmp15_, " --all", NULL);
	_tmp17_ = _tmp16_;
	spawn (_tmp17_, &_tmp18_, &_tmp19_, &_tmp20_);
	_g_free0 (sout);
	sout = _tmp18_;
	_g_free0 (serr);
	serr = _tmp19_;
	exit = _tmp20_;
	_g_free0 (_tmp17_);
	g_assert_cmpstr (serr, ==, "");
	g_assert_cmpint (exit, ==, 0);
	g_assert_cmpstr (sout, ==, "P: /devices/dev1\n" \
"E: SIMPLE_PROP=1\n" \
"E: SUBSYSTEM=pci\n" \
"H: binary_attr=41FF0005FF00\n" \
"L: driver=../../drivers/foo\n" \
"A: multiline_attr=a\\\\b\\nc\\\\d\\nlast\n" \
"A: simple_attr=1\n" \
"\n");
	_g_free0 (syspath);
	_g_object_unref0 (tb);
	_g_free0 (serr);
	_g_free0 (sout);
}


void t_testbed_multiple (void) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_ = NULL;
	gchar* dev1 = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* subdev1 = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar** _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar** _tmp23_ = NULL;
	gchar** _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar** _tmp27_ = NULL;
	gchar** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	const gchar* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	const gchar* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gint _tmp49_ = 0;
	const gchar* _tmp50_ = NULL;
	gint _tmp51_ = 0;
	const gchar* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	gchar* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	const gchar* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	const gchar* _tmp61_ = NULL;
	gboolean _tmp62_ = FALSE;
	const gchar* _tmp63_ = NULL;
	gboolean _tmp64_ = FALSE;
	const gchar* _tmp65_ = NULL;
	gboolean _tmp66_ = FALSE;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = g_strdup ("dev1color");
	_tmp2_ = g_strdup ("green");
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = g_strdup ("DEV1COLOR");
	_tmp6_ = g_strdup ("GREEN");
	_tmp7_ = g_new0 (gchar*, 2 + 1);
	_tmp7_[0] = _tmp5_;
	_tmp7_[1] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 2;
	_tmp9_ = umockdev_testbed_add_devicev (tb, "pci", "dev1", NULL, _tmp4_, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	dev1 = _tmp10_;
	_tmp11_ = g_strdup ("subdev1color");
	_tmp12_ = g_strdup ("yellow");
	_tmp13_ = g_new0 (gchar*, 2 + 1);
	_tmp13_[0] = _tmp11_;
	_tmp13_[1] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 2;
	_tmp15_ = g_strdup ("SUBDEV1COLOR");
	_tmp16_ = g_strdup ("YELLOW");
	_tmp17_ = g_new0 (gchar*, 2 + 1);
	_tmp17_[0] = _tmp15_;
	_tmp17_[1] = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp18__length1 = 2;
	_tmp19_ = umockdev_testbed_add_devicev (tb, "pci", "subdev1", dev1, _tmp14_, _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	subdev1 = _tmp20_;
	_tmp21_ = g_strdup ("dev2color");
	_tmp22_ = g_strdup ("brown");
	_tmp23_ = g_new0 (gchar*, 2 + 1);
	_tmp23_[0] = _tmp21_;
	_tmp23_[1] = _tmp22_;
	_tmp24_ = _tmp23_;
	_tmp24__length1 = 2;
	_tmp25_ = g_strdup ("DEV2COLOR");
	_tmp26_ = g_strdup ("BROWN");
	_tmp27_ = g_new0 (gchar*, 2 + 1);
	_tmp27_[0] = _tmp25_;
	_tmp27_[1] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 2;
	_tmp29_ = umockdev_testbed_add_devicev (tb, "pci", "dev2", NULL, _tmp24_, _tmp28_);
	_tmp30_ = _tmp29_;
	_g_free0 (_tmp30_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
	_tmp31_ = umockdev_record_path;
	_tmp32_ = g_strconcat (_tmp31_, " ", NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strconcat (_tmp33_, subdev1, NULL);
	_tmp35_ = _tmp34_;
	spawn (_tmp35_, &_tmp36_, &_tmp37_, &_tmp38_);
	_g_free0 (sout);
	sout = _tmp36_;
	_g_free0 (serr);
	serr = _tmp37_;
	exit = _tmp38_;
	_g_free0 (_tmp35_);
	_g_free0 (_tmp33_);
	_tmp39_ = serr;
	g_assert_cmpstr (_tmp39_, ==, "");
	_tmp40_ = exit;
	g_assert_cmpint (_tmp40_, ==, 0);
	_tmp41_ = sout;
	g_assert_cmpstr (_tmp41_, ==, "P: /devices/dev1/subdev1\n" \
"E: SUBDEV1COLOR=YELLOW\n" \
"E: SUBSYSTEM=pci\n" \
"A: subdev1color=yellow\n" \
"\n" \
"P: /devices/dev1\n" \
"E: DEV1COLOR=GREEN\n" \
"E: SUBSYSTEM=pci\n" \
"A: dev1color=green\n" \
"\n");
	_tmp42_ = umockdev_record_path;
	_tmp43_ = g_strconcat (_tmp42_, " ", NULL);
	_tmp44_ = _tmp43_;
	_tmp45_ = g_strconcat (_tmp44_, dev1, NULL);
	_tmp46_ = _tmp45_;
	spawn (_tmp46_, &_tmp47_, &_tmp48_, &_tmp49_);
	_g_free0 (sout);
	sout = _tmp47_;
	_g_free0 (serr);
	serr = _tmp48_;
	exit = _tmp49_;
	_g_free0 (_tmp46_);
	_g_free0 (_tmp44_);
	_tmp50_ = serr;
	g_assert_cmpstr (_tmp50_, ==, "");
	_tmp51_ = exit;
	g_assert_cmpint (_tmp51_, ==, 0);
	_tmp52_ = sout;
	g_assert_cmpstr (_tmp52_, ==, "P: /devices/dev1\n" \
"E: DEV1COLOR=GREEN\n" \
"E: SUBSYSTEM=pci\n" \
"A: dev1color=green\n" \
"\n");
	_tmp53_ = umockdev_record_path;
	_tmp54_ = g_strconcat (_tmp53_, " --all", NULL);
	_tmp55_ = _tmp54_;
	spawn (_tmp55_, &_tmp56_, &_tmp57_, &_tmp58_);
	_g_free0 (sout);
	sout = _tmp56_;
	_g_free0 (serr);
	serr = _tmp57_;
	exit = _tmp58_;
	_g_free0 (_tmp55_);
	_tmp59_ = serr;
	g_assert_cmpstr (_tmp59_, ==, "");
	_tmp60_ = exit;
	g_assert_cmpint (_tmp60_, ==, 0);
	_tmp61_ = sout;
	_tmp62_ = string_contains (_tmp61_, "P: /devices/dev1/subdev1\n");
	_vala_assert (_tmp62_, "sout.contains (\"P: /devices/dev1/subdev1\\n\")");
	_tmp63_ = sout;
	_tmp64_ = string_contains (_tmp63_, "P: /devices/dev1\n");
	_vala_assert (_tmp64_, "sout.contains (\"P: /devices/dev1\\n\")");
	_tmp65_ = sout;
	_tmp66_ = string_contains (_tmp65_, "P: /devices/dev2\n");
	_vala_assert (_tmp66_, "sout.contains (\"P: /devices/dev2\\n\")");
	_g_free0 (subdev1);
	_g_free0 (dev1);
	_g_object_unref0 (tb);
	_g_free0 (serr);
	_g_free0 (sout);
}


void t_testbed_no_ioctl_record (void) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gboolean _tmp15_ = FALSE;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = g_strdup ("dev");
	_tmp2_ = g_strdup ("1:5");
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = g_new0 (gchar*, 0 + 1);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 0;
	_tmp7_ = umockdev_testbed_add_devicev (tb, "mem", "zero", NULL, _tmp4_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp8_);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp9_ = umockdev_record_path;
	_tmp10_ = g_strconcat (_tmp9_, " --ioctl /sys/devices/zero=/dev/stdout -- head -c1 /dev/zero", NULL);
	_tmp11_ = _tmp10_;
	spawn (_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_);
	_g_free0 (sout);
	sout = _tmp12_;
	_g_free0 (serr);
	serr = _tmp13_;
	exit = _tmp14_;
	_g_free0 (_tmp11_);
	g_assert_cmpint (exit, !=, 0);
	g_assert_cmpstr (sout, ==, "");
	_tmp15_ = string_contains (serr, "UMOCKDEV_DIR cannot be used");
	_vala_assert (_tmp15_, "serr.contains (\"UMOCKDEV_DIR cannot be used\")");
	_g_object_unref0 (tb);
	_g_free0 (serr);
	_g_free0 (sout);
}


void t_system_single (void) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	_tmp0_ = g_file_test ("/sys/dev/char/1:3", G_FILE_TEST_EXISTS);
	if (!_tmp0_) {
		FILE* _tmp1_ = NULL;
		_tmp1_ = stderr;
		fprintf (_tmp1_, "[SKIP: no real /sys on this system] ");
		_g_free0 (serr);
		_g_free0 (sout);
		return;
	}
	_tmp2_ = g_file_test ("/sys/block/loop0", G_FILE_TEST_EXISTS);
	if (!_tmp2_) {
		FILE* _tmp3_ = NULL;
		_tmp3_ = stderr;
		fprintf (_tmp3_, "[SKIP: no /sys/block/loop0 on this system] ");
		_g_free0 (serr);
		_g_free0 (sout);
		return;
	}
	_tmp4_ = umockdev_record_path;
	_tmp5_ = g_strconcat (_tmp4_, " /dev/null /dev/loop0", NULL);
	_tmp6_ = _tmp5_;
	spawn (_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_);
	_g_free0 (sout);
	sout = _tmp7_;
	_g_free0 (serr);
	serr = _tmp8_;
	exit = _tmp9_;
	_g_free0 (_tmp6_);
	_tmp10_ = serr;
	g_assert_cmpstr (_tmp10_, ==, "");
	_tmp11_ = exit;
	g_assert_cmpint (_tmp11_, ==, 0);
	_tmp12_ = sout;
	assert_in ("E: DEVNAME=/dev/null", _tmp12_);
	_tmp13_ = sout;
	assert_in ("P: /devices/virtual/block/loop0", _tmp13_);
	_tmp14_ = sout;
	assert_in ("E: DEVNAME=/dev/loop0", _tmp14_);
	_g_free0 (serr);
	_g_free0 (sout);
}


void t_system_all (void) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_file_test ("/sys/dev/char", G_FILE_TEST_EXISTS);
	if (!_tmp0_) {
		FILE* _tmp1_ = NULL;
		_tmp1_ = stderr;
		fprintf (_tmp1_, "[SKIP: no real /sys on this system] ");
		_g_free0 (serr);
		_g_free0 (sout);
		return;
	}
	_tmp2_ = umockdev_record_path;
	_tmp3_ = g_strconcat (_tmp2_, " --all", NULL);
	_tmp4_ = _tmp3_;
	spawn (_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
	_g_free0 (sout);
	sout = _tmp5_;
	_g_free0 (serr);
	serr = _tmp6_;
	exit = _tmp7_;
	_g_free0 (_tmp4_);
	_tmp8_ = serr;
	g_assert_cmpstr (_tmp8_, ==, "");
	_tmp9_ = exit;
	g_assert_cmpint (_tmp9_, ==, 0);
	_tmp10_ = sout;
	_tmp11_ = g_str_has_prefix (_tmp10_, "P:");
	_vala_assert (_tmp11_, "sout.has_prefix (\"P:\")");
	_tmp12_ = sout;
	_tmp13_ = strlen (_tmp12_);
	_tmp14_ = _tmp13_;
	g_assert_cmpint (_tmp14_, >=, 100);
	_tmp15_ = umockdev_testbed_new ();
	tb = _tmp15_;
	{
		gboolean _tmp16_ = FALSE;
		UMockdevTestbed* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		_tmp17_ = tb;
		_tmp18_ = sout;
		_tmp19_ = umockdev_testbed_add_from_string (_tmp17_, _tmp18_, &_inner_error_);
		_tmp16_ = _tmp19_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == UMOCKDEV_ERROR) {
				goto __catch2_umockdev_error;
			}
			_g_object_unref0 (tb);
			_g_free0 (serr);
			_g_free0 (sout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_vala_assert (_tmp16_, "tb.add_from_string (sout)");
	}
	goto __finally2;
	__catch2_umockdev_error:
	{
		GError* e = NULL;
		const gchar* _tmp20_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = e->message;
		g_error ("test-umockdev-record.vala:221: Error when adding system dump to testbe" \
"d: %s", _tmp20_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (tb);
		_g_free0 (serr);
		_g_free0 (sout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (tb);
	_g_free0 (serr);
	_g_free0 (sout);
}


void t_system_invalid (void) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	_tmp0_ = g_file_test ("/sys/block/loop0", G_FILE_TEST_EXISTS);
	if (!_tmp0_) {
		FILE* _tmp1_ = NULL;
		_tmp1_ = stderr;
		fprintf (_tmp1_, "[SKIP: no real /sys on this system] ");
		_g_free0 (serr);
		_g_free0 (sout);
		return;
	}
	_tmp2_ = umockdev_record_path;
	_tmp3_ = g_strconcat (_tmp2_, " /sys/class", NULL);
	_tmp4_ = _tmp3_;
	spawn (_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
	_g_free0 (sout);
	sout = _tmp5_;
	_g_free0 (serr);
	serr = _tmp6_;
	exit = _tmp7_;
	_g_free0 (_tmp4_);
	_tmp8_ = serr;
	g_assert_cmpstr (_tmp8_, ==, "Invalid device /sys/class, has no uevent attribute\n");
	_tmp9_ = sout;
	g_assert_cmpstr (_tmp9_, ==, "");
	_tmp10_ = exit;
	g_assert_cmpint (_tmp10_, !=, 0);
	_tmp11_ = umockdev_record_path;
	_tmp12_ = g_strconcat (_tmp11_, " /sys/block/loop0/size", NULL);
	_tmp13_ = _tmp12_;
	spawn (_tmp13_, &_tmp14_, &_tmp15_, &_tmp16_);
	_g_free0 (sout);
	sout = _tmp14_;
	_g_free0 (serr);
	serr = _tmp15_;
	exit = _tmp16_;
	_g_free0 (_tmp13_);
	_tmp17_ = serr;
	g_assert_cmpstr (_tmp17_, ==, "Invalid device /sys/devices/virtual/block/loop0/size, has no uevent at" \
"tribute\n");
	_tmp18_ = sout;
	g_assert_cmpstr (_tmp18_, ==, "");
	_tmp19_ = exit;
	g_assert_cmpint (_tmp19_, !=, 0);
	_g_free0 (serr);
	_g_free0 (sout);
}


void t_system_ioctl_log (void) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* workdir = NULL;
	gchar* log = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	const gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	const gchar* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	const gchar* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	const gchar* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	const gchar* _tmp43_ = NULL;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp45_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_dir_make_tmp ("ioctl_log_test.XXXXXX", &_inner_error_);
		_tmp0_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_g_free0 (workdir);
		workdir = _tmp0_;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		abort ();
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_free0 (workdir);
		_g_free0 (serr);
		_g_free0 (sout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = g_build_filename (workdir, "log", NULL);
	log = _tmp2_;
	_tmp3_ = umockdev_record_path;
	_tmp4_ = g_strconcat (_tmp3_, " --ioctl=/dev/null=", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, log, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, " -- head -c1 /dev/zero", NULL);
	_tmp9_ = _tmp8_;
	spawn (_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
	_g_free0 (sout);
	sout = _tmp10_;
	_g_free0 (serr);
	serr = _tmp11_;
	exit = _tmp12_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp13_ = serr;
	g_assert_cmpstr (_tmp13_, ==, "");
	_tmp14_ = exit;
	g_assert_cmpint (_tmp14_, ==, 0);
	_tmp15_ = sout;
	g_assert_cmpstr (_tmp15_, ==, "\0");
	_tmp16_ = g_file_test (log, G_FILE_TEST_EXISTS);
	_vala_assert (!_tmp16_, "!FileUtils.test (log, FileTest.EXISTS)");
	_tmp17_ = umockdev_record_path;
	_tmp18_ = g_strconcat (_tmp17_, " --ioctl /dev/zero=", NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp19_, log, NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp21_, " -- head -c1 /dev/zero", NULL);
	_tmp23_ = _tmp22_;
	spawn (_tmp23_, &_tmp24_, &_tmp25_, &_tmp26_);
	_g_free0 (sout);
	sout = _tmp24_;
	_g_free0 (serr);
	serr = _tmp25_;
	exit = _tmp26_;
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_tmp27_ = serr;
	g_assert_cmpstr (_tmp27_, ==, "");
	_tmp28_ = exit;
	g_assert_cmpint (_tmp28_, ==, 0);
	_tmp29_ = sout;
	g_assert_cmpstr (_tmp29_, ==, "\0");
	_tmp30_ = g_file_test (log, G_FILE_TEST_EXISTS);
	_vala_assert (_tmp30_, "FileUtils.test (log, FileTest.EXISTS)");
	_tmp31_ = file_contents (log);
	_tmp32_ = _tmp31_;
	g_assert_cmpstr (_tmp32_, ==, "@DEV /dev/zero\n");
	_g_free0 (_tmp32_);
	g_remove (log);
	_tmp33_ = umockdev_record_path;
	_tmp34_ = g_strconcat (_tmp33_, " --ioctl /dev/null -- head -c1 /dev/zero", NULL);
	_tmp35_ = _tmp34_;
	spawn (_tmp35_, &_tmp36_, &_tmp37_, &_tmp38_);
	_g_free0 (sout);
	sout = _tmp36_;
	_g_free0 (serr);
	serr = _tmp37_;
	exit = _tmp38_;
	_g_free0 (_tmp35_);
	_tmp39_ = exit;
	g_assert_cmpint (_tmp39_, !=, 1);
	_tmp40_ = sout;
	g_assert_cmpstr (_tmp40_, ==, "");
	_tmp41_ = serr;
	_tmp42_ = string_contains (_tmp41_, "--ioctl");
	_vala_assert (_tmp42_, "serr.contains (\"--ioctl\")");
	_tmp43_ = serr;
	_tmp44_ = string_contains (_tmp43_, "=");
	_vala_assert (_tmp44_, "serr.contains (\"=\")");
	_tmp45_ = g_file_test (log, G_FILE_TEST_EXISTS);
	_vala_assert (!_tmp45_, "!FileUtils.test (log, FileTest.EXISTS)");
	g_rmdir (workdir);
	_g_free0 (log);
	_g_free0 (workdir);
	_g_free0 (serr);
	_g_free0 (sout);
}


void t_system_ioctl_log_append_dev_mismatch (void) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* log = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	const gchar* _tmp15_ = NULL;
	gchar* orig_contents = NULL;
	gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	const gchar* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	gint _tmp29_ = 0;
	const gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp2_ = g_file_open_tmp ("ioctl_log_test.XXXXXX", &_tmp1_, &_inner_error_);
		_g_free0 (log);
		log = _tmp1_;
		_tmp0_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		close (_tmp0_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		abort ();
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (log);
		_g_free0 (serr);
		_g_free0 (sout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp3_ = umockdev_record_path;
	_tmp4_ = g_strconcat (_tmp3_, " -i /dev/zero=", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, log, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, " -- head -c1 /dev/zero", NULL);
	_tmp9_ = _tmp8_;
	spawn (_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
	_g_free0 (sout);
	sout = _tmp10_;
	_g_free0 (serr);
	serr = _tmp11_;
	exit = _tmp12_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp13_ = serr;
	g_assert_cmpstr (_tmp13_, ==, "");
	_tmp14_ = exit;
	g_assert_cmpint (_tmp14_, ==, 0);
	_tmp15_ = sout;
	g_assert_cmpstr (_tmp15_, ==, "\0");
	_tmp16_ = file_contents (log);
	orig_contents = _tmp16_;
	_tmp17_ = umockdev_record_path;
	_tmp18_ = g_strconcat (_tmp17_, " -i /dev/null=", NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp19_, log, NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp21_, " -- head -c1 /dev/null", NULL);
	_tmp23_ = _tmp22_;
	spawn (_tmp23_, &_tmp24_, &_tmp25_, &_tmp26_);
	_g_free0 (sout);
	sout = _tmp24_;
	_g_free0 (serr);
	serr = _tmp25_;
	exit = _tmp26_;
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_tmp27_ = serr;
	_tmp28_ = string_contains (_tmp27_, "two different devices");
	_vala_assert (_tmp28_, "serr.contains (\"two different devices\")");
	_tmp29_ = exit;
	g_assert_cmpint (_tmp29_, ==, 256);
	_tmp30_ = sout;
	g_assert_cmpstr (_tmp30_, ==, "\0");
	_tmp31_ = file_contents (log);
	_tmp32_ = _tmp31_;
	g_assert_cmpstr (_tmp32_, ==, orig_contents);
	_g_free0 (_tmp32_);
	g_remove (log);
	_g_free0 (orig_contents);
	_g_free0 (log);
	_g_free0 (serr);
	_g_free0 (sout);
}


void t_system_script_log_simple (void) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* log = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	const gchar* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	const gchar* _tmp30_ = NULL;
	gchar** loglines = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar** _tmp33_ = NULL;
	gchar** _tmp34_ = NULL;
	gchar** _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	gint loglines_length1 = 0;
	gint _loglines_size_ = 0;
	const gchar* _tmp36_ = NULL;
	gchar** logwords = NULL;
	const gchar* _tmp37_ = NULL;
	gchar** _tmp38_ = NULL;
	gchar** _tmp39_ = NULL;
	gint logwords_length1 = 0;
	gint _logwords_size_ = 0;
	const gchar* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	const gchar* _tmp43_ = NULL;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp2_ = g_file_open_tmp ("test_script_log.XXXXXX", &_tmp1_, &_inner_error_);
		_g_free0 (log);
		log = _tmp1_;
		_tmp0_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		close (_tmp0_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		abort ();
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_free0 (log);
		_g_free0 (serr);
		_g_free0 (sout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp3_ = umockdev_record_path;
	_tmp4_ = g_strconcat (_tmp3_, " --script=/dev/null=", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, log, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, " -- head -c1 /dev/zero", NULL);
	_tmp9_ = _tmp8_;
	spawn (_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
	_g_free0 (sout);
	sout = _tmp10_;
	_g_free0 (serr);
	serr = _tmp11_;
	exit = _tmp12_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp13_ = serr;
	g_assert_cmpstr (_tmp13_, ==, "");
	_tmp14_ = exit;
	g_assert_cmpint (_tmp14_, ==, 0);
	_tmp15_ = sout;
	g_assert_cmpstr (_tmp15_, ==, "\0");
	_tmp16_ = file_contents (log);
	_tmp17_ = _tmp16_;
	g_assert_cmpstr (_tmp17_, ==, "");
	_g_free0 (_tmp17_);
	_tmp18_ = umockdev_record_path;
	_tmp19_ = g_strconcat (_tmp18_, " --script=/dev/zero=", NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat (_tmp20_, log, NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat (_tmp22_, " -- head -c1 /dev/zero", NULL);
	_tmp24_ = _tmp23_;
	spawn (_tmp24_, &_tmp25_, &_tmp26_, &_tmp27_);
	_g_free0 (sout);
	sout = _tmp25_;
	_g_free0 (serr);
	serr = _tmp26_;
	exit = _tmp27_;
	_g_free0 (_tmp24_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_tmp28_ = serr;
	g_assert_cmpstr (_tmp28_, ==, "");
	_tmp29_ = exit;
	g_assert_cmpint (_tmp29_, ==, 0);
	_tmp30_ = sout;
	g_assert_cmpstr (_tmp30_, ==, "\0");
	_tmp31_ = file_contents (log);
	_tmp32_ = _tmp31_;
	_tmp34_ = _tmp33_ = g_strsplit (_tmp32_, "\n", 0);
	_tmp35_ = _tmp34_;
	_tmp35__length1 = _vala_array_length (_tmp33_);
	_g_free0 (_tmp32_);
	loglines = _tmp35_;
	loglines_length1 = _tmp35__length1;
	_loglines_size_ = loglines_length1;
	g_assert_cmpuint ((guint) loglines_length1, ==, (guint) 2);
	_tmp36_ = loglines[0];
	g_assert_cmpstr (_tmp36_, ==, "d 0 /dev/zero");
	_tmp37_ = loglines[1];
	_tmp39_ = _tmp38_ = g_strsplit (_tmp37_, " ", 0);
	logwords = _tmp39_;
	logwords_length1 = _vala_array_length (_tmp38_);
	_logwords_size_ = logwords_length1;
	g_assert_cmpuint ((guint) logwords_length1, ==, (guint) 3);
	_tmp40_ = logwords[0];
	g_assert_cmpstr (_tmp40_, ==, "r");
	_tmp41_ = logwords[1];
	_tmp42_ = atoi (_tmp41_);
	g_assert_cmpint (_tmp42_, <=, 5);
	_tmp43_ = logwords[2];
	g_assert_cmpstr (_tmp43_, ==, "^@");
	g_remove (log);
	logwords = (_vala_array_free (logwords, logwords_length1, (GDestroyNotify) g_free), NULL);
	loglines = (_vala_array_free (loglines, loglines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (log);
	_g_free0 (serr);
	_g_free0 (sout);
}


void t_system_script_log_append_same_dev (void) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* log = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	const gchar* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	const gchar* _tmp28_ = NULL;
	gchar** loglines = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar** _tmp31_ = NULL;
	gchar** _tmp32_ = NULL;
	gchar** _tmp33_ = NULL;
	gint _tmp33__length1 = 0;
	gint loglines_length1 = 0;
	gint _loglines_size_ = 0;
	const gchar* _tmp34_ = NULL;
	gchar** logwords = NULL;
	const gchar* _tmp35_ = NULL;
	gchar** _tmp36_ = NULL;
	gchar** _tmp37_ = NULL;
	gint logwords_length1 = 0;
	gint _logwords_size_ = 0;
	gchar** _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	gchar** _tmp39_ = NULL;
	gint _tmp39__length1 = 0;
	const gchar* _tmp40_ = NULL;
	gchar** _tmp41_ = NULL;
	gint _tmp41__length1 = 0;
	const gchar* _tmp42_ = NULL;
	gint _tmp43_ = 0;
	gchar** _tmp44_ = NULL;
	gint _tmp44__length1 = 0;
	const gchar* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	gchar** _tmp47_ = NULL;
	gchar** _tmp48_ = NULL;
	gchar** _tmp49_ = NULL;
	gint _tmp49__length1 = 0;
	gchar** _tmp50_ = NULL;
	gint _tmp50__length1 = 0;
	const gchar* _tmp51_ = NULL;
	gchar** _tmp52_ = NULL;
	gint _tmp52__length1 = 0;
	const gchar* _tmp53_ = NULL;
	gint _tmp54_ = 0;
	gchar** _tmp55_ = NULL;
	gint _tmp55__length1 = 0;
	const gchar* _tmp56_ = NULL;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp2_ = g_file_open_tmp ("test_script_log.XXXXXX", &_tmp1_, &_inner_error_);
		_g_free0 (log);
		log = _tmp1_;
		_tmp0_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		close (_tmp0_);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		abort ();
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_free0 (log);
		_g_free0 (serr);
		_g_free0 (sout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp3_ = umockdev_record_path;
	_tmp4_ = g_strconcat (_tmp3_, " --script=/dev/zero=", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, log, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, " -- head -c1 /dev/zero", NULL);
	_tmp9_ = _tmp8_;
	spawn (_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
	_g_free0 (sout);
	sout = _tmp10_;
	_g_free0 (serr);
	serr = _tmp11_;
	exit = _tmp12_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp13_ = serr;
	g_assert_cmpstr (_tmp13_, ==, "");
	_tmp14_ = exit;
	g_assert_cmpint (_tmp14_, ==, 0);
	_tmp15_ = sout;
	g_assert_cmpstr (_tmp15_, ==, "\0");
	_tmp16_ = umockdev_record_path;
	_tmp17_ = g_strconcat (_tmp16_, " --script=/dev/zero=", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp18_, log, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat (_tmp20_, " -- head -c1 /dev/zero", NULL);
	_tmp22_ = _tmp21_;
	spawn (_tmp22_, &_tmp23_, &_tmp24_, &_tmp25_);
	_g_free0 (sout);
	sout = _tmp23_;
	_g_free0 (serr);
	serr = _tmp24_;
	exit = _tmp25_;
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_tmp26_ = serr;
	g_assert_cmpstr (_tmp26_, ==, "");
	_tmp27_ = exit;
	g_assert_cmpint (_tmp27_, ==, 0);
	_tmp28_ = sout;
	g_assert_cmpstr (_tmp28_, ==, "\0");
	_tmp29_ = file_contents (log);
	_tmp30_ = _tmp29_;
	_tmp32_ = _tmp31_ = g_strsplit (_tmp30_, "\n", 0);
	_tmp33_ = _tmp32_;
	_tmp33__length1 = _vala_array_length (_tmp31_);
	_g_free0 (_tmp30_);
	loglines = _tmp33_;
	loglines_length1 = _tmp33__length1;
	_loglines_size_ = loglines_length1;
	g_assert_cmpuint ((guint) loglines_length1, ==, (guint) 3);
	_tmp34_ = loglines[0];
	g_assert_cmpstr (_tmp34_, ==, "d 0 /dev/zero");
	_tmp35_ = loglines[1];
	_tmp37_ = _tmp36_ = g_strsplit (_tmp35_, " ", 0);
	logwords = _tmp37_;
	logwords_length1 = _vala_array_length (_tmp36_);
	_logwords_size_ = logwords_length1;
	_tmp38_ = logwords;
	_tmp38__length1 = logwords_length1;
	g_assert_cmpuint ((guint) _tmp38__length1, ==, (guint) 3);
	_tmp39_ = logwords;
	_tmp39__length1 = logwords_length1;
	_tmp40_ = _tmp39_[0];
	g_assert_cmpstr (_tmp40_, ==, "r");
	_tmp41_ = logwords;
	_tmp41__length1 = logwords_length1;
	_tmp42_ = _tmp41_[1];
	_tmp43_ = atoi (_tmp42_);
	g_assert_cmpint (_tmp43_, <=, 5);
	_tmp44_ = logwords;
	_tmp44__length1 = logwords_length1;
	_tmp45_ = _tmp44_[2];
	g_assert_cmpstr (_tmp45_, ==, "^@");
	_tmp46_ = loglines[2];
	_tmp48_ = _tmp47_ = g_strsplit (_tmp46_, " ", 0);
	logwords = (_vala_array_free (logwords, logwords_length1, (GDestroyNotify) g_free), NULL);
	logwords = _tmp48_;
	logwords_length1 = _vala_array_length (_tmp47_);
	_logwords_size_ = logwords_length1;
	_tmp49_ = logwords;
	_tmp49__length1 = logwords_length1;
	g_assert_cmpuint ((guint) _tmp49__length1, ==, (guint) 3);
	_tmp50_ = logwords;
	_tmp50__length1 = logwords_length1;
	_tmp51_ = _tmp50_[0];
	g_assert_cmpstr (_tmp51_, ==, "r");
	_tmp52_ = logwords;
	_tmp52__length1 = logwords_length1;
	_tmp53_ = _tmp52_[1];
	_tmp54_ = atoi (_tmp53_);
	g_assert_cmpint (_tmp54_, <=, 5);
	_tmp55_ = logwords;
	_tmp55__length1 = logwords_length1;
	_tmp56_ = _tmp55_[2];
	g_assert_cmpstr (_tmp56_, ==, "^@");
	g_remove (log);
	logwords = (_vala_array_free (logwords, logwords_length1, (GDestroyNotify) g_free), NULL);
	loglines = (_vala_array_free (loglines, loglines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (log);
	_g_free0 (serr);
	_g_free0 (sout);
}


void t_system_script_log_append_dev_mismatch (void) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* log = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	const gchar* _tmp15_ = NULL;
	gchar* orig_contents = NULL;
	gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	const gchar* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	gint _tmp29_ = 0;
	const gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp2_ = g_file_open_tmp ("test_script_log.XXXXXX", &_tmp1_, &_inner_error_);
		_g_free0 (log);
		log = _tmp1_;
		_tmp0_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		close (_tmp0_);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		abort ();
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_free0 (log);
		_g_free0 (serr);
		_g_free0 (sout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp3_ = umockdev_record_path;
	_tmp4_ = g_strconcat (_tmp3_, " --script=/dev/zero=", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, log, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, " -- head -c1 /dev/zero", NULL);
	_tmp9_ = _tmp8_;
	spawn (_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
	_g_free0 (sout);
	sout = _tmp10_;
	_g_free0 (serr);
	serr = _tmp11_;
	exit = _tmp12_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp13_ = serr;
	g_assert_cmpstr (_tmp13_, ==, "");
	_tmp14_ = exit;
	g_assert_cmpint (_tmp14_, ==, 0);
	_tmp15_ = sout;
	g_assert_cmpstr (_tmp15_, ==, "\0");
	_tmp16_ = file_contents (log);
	orig_contents = _tmp16_;
	_tmp17_ = umockdev_record_path;
	_tmp18_ = g_strconcat (_tmp17_, " --script=/dev/null=", NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp19_, log, NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp21_, " -- head -c1 /dev/null", NULL);
	_tmp23_ = _tmp22_;
	spawn (_tmp23_, &_tmp24_, &_tmp25_, &_tmp26_);
	_g_free0 (sout);
	sout = _tmp24_;
	_g_free0 (serr);
	serr = _tmp25_;
	exit = _tmp26_;
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_tmp27_ = serr;
	_tmp28_ = string_contains (_tmp27_, "two different devices");
	_vala_assert (_tmp28_, "serr.contains (\"two different devices\")");
	_tmp29_ = exit;
	g_assert_cmpint (_tmp29_, ==, 256);
	_tmp30_ = sout;
	g_assert_cmpstr (_tmp30_, ==, "\0");
	_tmp31_ = file_contents (log);
	_tmp32_ = _tmp31_;
	g_assert_cmpstr (_tmp32_, ==, orig_contents);
	_g_free0 (_tmp32_);
	g_remove (log);
	_g_free0 (orig_contents);
	_g_free0 (log);
	_g_free0 (serr);
	_g_free0 (sout);
}


gchar* read_line_timeout (FILE* stream) {
	gchar* result = NULL;
	gchar* line = NULL;
	gchar buffer[1000] = {0};
	gint timeout = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	g_return_val_if_fail (stream != NULL, NULL);
	line = NULL;
	timeout = 50;
	while (TRUE) {
		gint _tmp0_ = 0;
		FILE* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp0_ = timeout;
		if (!(_tmp0_ > 0)) {
			break;
		}
		_tmp1_ = stream;
		_tmp2_ = fgets (buffer, 1000, _tmp1_);
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (line);
		line = _tmp3_;
		_tmp4_ = line;
		if (_tmp4_ != NULL) {
			result = line;
			return result;
		}
		g_usleep ((gulong) 100000);
		_tmp5_ = timeout;
		timeout = _tmp5_ - 1;
	}
	_tmp6_ = timeout;
	_vala_assert (_tmp6_ > 0, "timeout > 0");
	_tmp7_ = g_strdup ("<timeout>");
	result = _tmp7_;
	_g_free0 (line);
	return result;
}


void t_system_script_log_chatter (void) {
	gchar* log = NULL;
	gchar* ptyname = NULL;
	gchar* _tmp3_ = NULL;
	gint ptyname_length1 = 0;
	gint _ptyname_size_ = 0;
	gint ptym = 0;
	gint ptys = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	struct termios ios = {0};
	struct termios _tmp7_ = {0};
	gint _tmp8_ = 0;
	tcflag_t _tmp9_ = {0};
	tcflag_t _tmp10_ = {0};
	tcflag_t _tmp11_ = {0};
	struct termios _tmp12_ = {0};
	gint _tmp13_ = 0;
	GPid chatter_pid = 0;
	FILE* chatter_stream = NULL;
	FILE* _tmp31_ = NULL;
	FILE* _tmp32_ = NULL;
	FILE* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	FILE* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	FILE* _tmp39_ = NULL;
	FILE* _tmp45_ = NULL;
	FILE* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gint status = 0;
	gint _tmp49_ = 0;
	pid_t _tmp50_ = 0;
	FILE* log_stream = NULL;
	FILE* _tmp51_ = NULL;
	gchar* buf = NULL;
	gchar* _tmp52_ = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	gint time = 0;
	gint _tmp53_ = 0;
	gint _tmp54_ = 0;
	gint _tmp55_ = 0;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	gint _tmp58_ = 0;
	gint _tmp59_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp2_ = g_file_open_tmp ("test_script_log.XXXXXX", &_tmp1_, &_inner_error_);
		_g_free0 (log);
		log = _tmp1_;
		_tmp0_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		close (_tmp0_);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		abort ();
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_free0 (log);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp3_ = g_new0 (gchar, 8192);
	ptyname = _tmp3_;
	ptyname_length1 = 8192;
	_ptyname_size_ = ptyname_length1;
	_tmp6_ = openpty (&_tmp4_, &_tmp5_, ptyname, NULL, NULL);
	ptym = _tmp4_;
	ptys = _tmp5_;
	_vala_assert (_tmp6_ == 0, "Linux.openpty (out ptym, out ptys, ptyname, null, null) == 0");
	close (ptys);
	_tmp8_ = tcgetattr (ptym, &_tmp7_);
	ios = _tmp7_;
	_vala_assert (_tmp8_ == 0, "Posix.tcgetattr (ptym, out ios) == 0");
	_tmp9_ = ios.c_iflag;
	ios.c_iflag = _tmp9_ & (~((IGNCR | INLCR) | ICRNL));
	_tmp10_ = ios.c_oflag;
	ios.c_oflag = _tmp10_ & (~(ONLCR | OCRNL));
	_tmp11_ = ios.c_lflag;
	ios.c_lflag = _tmp11_ & (~(ICANON | ECHO));
	_tmp12_ = ios;
	_tmp13_ = tcsetattr (ptym, TCSANOW, &_tmp12_);
	_vala_assert (_tmp13_ == 0, "Posix.tcsetattr (ptym, Posix.TCSANOW, ios) == 0");
	{
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar** _tmp25_ = NULL;
		gchar** _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
		GPid _tmp27_ = 0;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		_tmp15_ = umockdev_record_path;
		_tmp16_ = g_strdup (_tmp15_);
		_tmp17_ = g_strdup ("--script");
		_tmp18_ = g_strconcat ((const gchar*) ptyname, "=", NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp19_, log, NULL);
		_tmp21_ = g_strdup ("--");
		_tmp22_ = rootdir;
		_tmp23_ = g_build_filename (_tmp22_, "tests", "chatter", NULL);
		_tmp24_ = g_strdup ((const gchar*) ptyname);
		_tmp25_ = g_new0 (gchar*, 6 + 1);
		_tmp25_[0] = _tmp16_;
		_tmp25_[1] = _tmp17_;
		_tmp25_[2] = _tmp20_;
		_tmp25_[3] = _tmp21_;
		_tmp25_[4] = _tmp23_;
		_tmp25_[5] = _tmp24_;
		_tmp26_ = _tmp25_;
		_tmp26__length1 = 6;
		_tmp28_ = g_spawn_async_with_pipes (NULL, _tmp26_, NULL, (G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_STDOUT_TO_DEV_NULL, NULL, NULL, &_tmp27_, NULL, NULL, NULL, &_inner_error_);
		chatter_pid = _tmp27_;
		_tmp29_ = _tmp28_;
		_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp19_);
		_tmp14_ = _tmp29_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch9_g_spawn_error;
			}
			ptyname = (g_free (ptyname), NULL);
			_g_free0 (log);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_vala_assert (_tmp14_, "Process.spawn_async_with_pipes (null,             {umockdev_record_path, \"--script\", (string) ptyname + \"=\" + log, \"--\",              Path.build_filename (rootdir, \"tests\", \"chatter\"), (string) ptyname},             null, SpawnFlags.SEARCH_PATH | SpawnFlags.DO_NOT_REAP_CHILD | SpawnFlags.STDOUT_TO_DEV_NULL,             null, out chatter_pid, null, null, null)");
	}
	goto __finally9;
	__catch9_g_spawn_error:
	{
		GError* e = NULL;
		const gchar* _tmp30_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = e->message;
		g_error ("test-umockdev-record.vala:512: Cannot call umockdev-record: %s", _tmp30_);
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		ptyname = (g_free (ptyname), NULL);
		_g_free0 (log);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp31_ = fdopen (ptym, "r+");
	chatter_stream = _tmp31_;
	_tmp32_ = chatter_stream;
	_vala_assert (_tmp32_ != NULL, "chatter_stream != null");
	_tmp33_ = chatter_stream;
	_tmp34_ = read_line_timeout (_tmp33_);
	_tmp35_ = _tmp34_;
	g_assert_cmpstr (_tmp35_, ==, "Hello world!\n");
	_g_free0 (_tmp35_);
	_tmp36_ = chatter_stream;
	_tmp37_ = read_line_timeout (_tmp36_);
	_tmp38_ = _tmp37_;
	g_assert_cmpstr (_tmp38_, ==, "What is your name?\n");
	_g_free0 (_tmp38_);
	g_usleep ((gulong) 500000);
	_tmp39_ = chatter_stream;
	fputs ("John\n", _tmp39_);
	while (TRUE) {
		FILE* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gboolean _tmp43_ = FALSE;
		gboolean _tmp44_ = FALSE;
		_tmp40_ = chatter_stream;
		_tmp41_ = read_line_timeout (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = string_contains (_tmp42_, "line break in one write");
		_tmp44_ = !(!_tmp43_);
		_g_free0 (_tmp42_);
		if (_tmp44_) {
			break;
		}
	}
	g_usleep ((gulong) 300000);
	_tmp45_ = chatter_stream;
	fputs ("foo ☹ bar ^!\n", _tmp45_);
	_tmp46_ = chatter_stream;
	_tmp47_ = read_line_timeout (_tmp46_);
	_tmp48_ = _tmp47_;
	g_assert_cmpstr (_tmp48_, ==, "bye!\n");
	_g_free0 (_tmp48_);
	_tmp50_ = waitpid ((pid_t) chatter_pid, &_tmp49_, 0);
	status = _tmp49_;
	g_assert_cmpint ((gint) _tmp50_, ==, (gint) chatter_pid);
	g_assert_cmpint (status, ==, 0);
	_tmp51_ = g_fopen (log, "r");
	log_stream = _tmp51_;
	_tmp52_ = g_new0 (gchar, 8192);
	buf = _tmp52_;
	buf_length1 = 8192;
	_buf_size_ = buf_length1;
	time = 0;
	_tmp53_ = fscanf (log_stream, "d 0 %s\n", buf);
	g_assert_cmpint (_tmp53_, ==, 1);
	g_assert_cmpstr ((const gchar*) buf, ==, (const gchar*) ptyname);
	_tmp54_ = fscanf (log_stream, "w %d Hello world!^JWhat is your name?^J\n", &time);
	g_assert_cmpint (_tmp54_, ==, 1);
	g_assert_cmpint (time, <=, 20);
	_tmp55_ = fscanf (log_stream, "r %d John^J\n", &time);
	g_assert_cmpint (_tmp55_, ==, 1);
	g_assert_cmpint (time, >=, 450);
	g_assert_cmpint (time, <=, 800);
	_tmp56_ = fscanf (log_stream, "w %d I ♥ John^Ja^I tab and a^J line break in one write^J\n", &time);
	g_assert_cmpint (_tmp56_, ==, 1);
	g_assert_cmpint (time, <=, 20);
	_tmp57_ = fscanf (log_stream, "r %d foo ☹ bar ^`!^J\n", &time);
	g_assert_cmpint (_tmp57_, ==, 1);
	g_assert_cmpint (time, >=, 250);
	g_assert_cmpint (time, <=, 450);
	_tmp58_ = fscanf (log_stream, "w %d bye!^J\n", &time);
	g_assert_cmpint (_tmp58_, ==, 1);
	g_assert_cmpint (time, <=, 20);
	_tmp59_ = fscanf (log_stream, "%*c");
	g_assert_cmpint (_tmp59_, ==, -1);
	g_remove (log);
	buf = (g_free (buf), NULL);
	_fclose0 (log_stream);
	_fclose0 (chatter_stream);
	ptyname = (g_free (ptyname), NULL);
	_g_free0 (log);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


void t_system_script_log_chatter_socket_stream (void) {
	gchar* log = NULL;
	gchar* spath = NULL;
	gchar* _tmp0_ = NULL;
	GPid chatter_pid = 0;
	const gchar* _tmp81_ = NULL;
	gint status = 0;
	GPid _tmp82_ = 0;
	gint _tmp83_ = 0;
	pid_t _tmp84_ = 0;
	GPid _tmp85_ = 0;
	FILE* log_stream = NULL;
	const gchar* _tmp86_ = NULL;
	FILE* _tmp87_ = NULL;
	gint time = 0;
	gint _tmp88_ = 0;
	gint _tmp89_ = 0;
	gint _tmp90_ = 0;
	gint _tmp91_ = 0;
	gint _tmp92_ = 0;
	const gchar* _tmp93_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_strdup ("/tmp/umockdev_test");
	spath = _tmp0_;
	{
		gint _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		GSocket* s = NULL;
		GSocket* _tmp4_ = NULL;
		GSocket* _tmp5_ = NULL;
		GSocket* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		GSocket* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GUnixSocketAddress* _tmp10_ = NULL;
		GUnixSocketAddress* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		GSocket* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		gint timeout = 0;
		GSocket* conn = NULL;
		GSocket* _tmp45_ = NULL;
		guint8* buf = NULL;
		guint8* _tmp46_ = NULL;
		gint buf_length1 = 0;
		gint _buf_size_ = 0;
		gssize len = 0L;
		GSocket* _tmp47_ = NULL;
		guint8* _tmp48_ = NULL;
		gint _tmp48__length1 = 0;
		gssize _tmp49_ = 0L;
		gssize _tmp50_ = 0L;
		guint8* _tmp51_ = NULL;
		gint _tmp51__length1 = 0;
		gssize _tmp52_ = 0L;
		guint8 _tmp53_ = 0U;
		guint8* _tmp54_ = NULL;
		gint _tmp54__length1 = 0;
		GSocket* _tmp55_ = NULL;
		guint8* _tmp56_ = NULL;
		gint _tmp56__length1 = 0;
		guint8* _tmp57_ = NULL;
		gint _tmp57__length1 = 0;
		gssize _tmp58_ = 0L;
		GSocket* _tmp59_ = NULL;
		guint8* _tmp60_ = NULL;
		gint _tmp60__length1 = 0;
		gssize _tmp61_ = 0L;
		gssize _tmp62_ = 0L;
		guint8* _tmp63_ = NULL;
		gint _tmp63__length1 = 0;
		gssize _tmp64_ = 0L;
		guint8 _tmp65_ = 0U;
		guint8* _tmp66_ = NULL;
		gint _tmp66__length1 = 0;
		gssize _tmp67_ = 0L;
		GSocket* _tmp68_ = NULL;
		guint8* _tmp69_ = NULL;
		gint _tmp69__length1 = 0;
		gssize _tmp70_ = 0L;
		gssize _tmp71_ = 0L;
		guint8* _tmp72_ = NULL;
		gint _tmp72__length1 = 0;
		gssize _tmp73_ = 0L;
		guint8 _tmp74_ = 0U;
		guint8* _tmp75_ = NULL;
		gint _tmp75__length1 = 0;
		GSocket* _tmp76_ = NULL;
		guint8* _tmp77_ = NULL;
		gint _tmp77__length1 = 0;
		guint8* _tmp78_ = NULL;
		gint _tmp78__length1 = 0;
		_tmp3_ = g_file_open_tmp ("test_script_log.XXXXXX", &_tmp2_, &_inner_error_);
		_g_free0 (log);
		log = _tmp2_;
		_tmp1_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		close (_tmp1_);
		_tmp4_ = g_socket_new (G_SOCKET_FAMILY_UNIX, G_SOCKET_TYPE_STREAM, G_SOCKET_PROTOCOL_DEFAULT, &_inner_error_);
		s = _tmp4_;
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		_tmp5_ = s;
		_vala_assert (_tmp5_ != NULL, "s != null");
		_tmp6_ = s;
		g_socket_set_blocking (_tmp6_, FALSE);
		_tmp8_ = s;
		_tmp9_ = spath;
		_tmp10_ = (GUnixSocketAddress*) g_unix_socket_address_new (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_socket_bind (_tmp8_, (GSocketAddress*) _tmp11_, TRUE, &_inner_error_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		_tmp7_ = _tmp13_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (s);
			goto __catch10_g_error;
		}
		_vala_assert (_tmp7_, "s.bind (new UnixSocketAddress (spath), true)");
		_tmp15_ = s;
		_tmp16_ = g_socket_listen (_tmp15_, &_inner_error_);
		_tmp14_ = _tmp16_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (s);
			goto __catch10_g_error;
		}
		_vala_assert (_tmp14_, "s.listen ()");
		{
			gboolean _tmp17_ = FALSE;
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			gchar** _tmp31_ = NULL;
			gchar** _tmp32_ = NULL;
			gint _tmp32__length1 = 0;
			GPid _tmp33_ = 0;
			gboolean _tmp34_ = FALSE;
			gboolean _tmp35_ = FALSE;
			_tmp18_ = umockdev_record_path;
			_tmp19_ = g_strdup (_tmp18_);
			_tmp20_ = g_strdup ("--script");
			_tmp21_ = spath;
			_tmp22_ = g_strconcat (_tmp21_, "=", NULL);
			_tmp23_ = _tmp22_;
			_tmp24_ = log;
			_tmp25_ = g_strconcat (_tmp23_, _tmp24_, NULL);
			_tmp26_ = g_strdup ("--");
			_tmp27_ = rootdir;
			_tmp28_ = g_build_filename (_tmp27_, "tests", "chatter-socket-stream", NULL);
			_tmp29_ = spath;
			_tmp30_ = g_strdup (_tmp29_);
			_tmp31_ = g_new0 (gchar*, 6 + 1);
			_tmp31_[0] = _tmp19_;
			_tmp31_[1] = _tmp20_;
			_tmp31_[2] = _tmp25_;
			_tmp31_[3] = _tmp26_;
			_tmp31_[4] = _tmp28_;
			_tmp31_[5] = _tmp30_;
			_tmp32_ = _tmp31_;
			_tmp32__length1 = 6;
			_tmp34_ = g_spawn_async_with_pipes (NULL, _tmp32_, NULL, (G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_STDOUT_TO_DEV_NULL, NULL, NULL, &_tmp33_, NULL, NULL, NULL, &_inner_error_);
			chatter_pid = _tmp33_;
			_tmp35_ = _tmp34_;
			_tmp32_ = (_vala_array_free (_tmp32_, _tmp32__length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_tmp23_);
			_tmp17_ = _tmp35_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch11_g_spawn_error;
				}
				_g_object_unref0 (s);
				_g_free0 (spath);
				_g_free0 (log);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_vala_assert (_tmp17_, "Process.spawn_async_with_pipes (null,                 {umockdev_record_path, \"--script\", spath + \"=\" + log, \"--\",                  Path.build_filename (rootdir, \"tests\", \"chatter-socket-stream\"), spath},                 null, SpawnFlags.SEARCH_PATH | SpawnFlags.DO_NOT_REAP_CHILD | SpawnFlags.STDOUT_TO_DEV_NULL,                 null, out chatter_pid, null, null, null)");
		}
		goto __finally11;
		__catch11_g_spawn_error:
		{
			GError* e = NULL;
			const gchar* _tmp36_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp36_ = e->message;
			g_error ("test-umockdev-record.vala:591: Cannot call umockdev-record: %s", _tmp36_);
			_g_error_free0 (e);
		}
		__finally11:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (s);
			goto __catch10_g_error;
		}
		timeout = 20;
		conn = NULL;
		while (TRUE) {
			gint _tmp37_ = 0;
			_tmp37_ = timeout;
			if (!(_tmp37_ > 0)) {
				break;
			}
			{
				GSocket* _tmp38_ = NULL;
				GSocket* _tmp39_ = NULL;
				GSocket* _tmp40_ = NULL;
				_tmp39_ = s;
				_tmp40_ = g_socket_accept (_tmp39_, NULL, &_inner_error_);
				_tmp38_ = _tmp40_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_IO_ERROR) {
						goto __catch12_g_io_error;
					}
					goto __finally12;
				}
				_g_object_unref0 (conn);
				conn = _tmp38_;
				break;
			}
			goto __finally12;
			__catch12_g_io_error:
			{
				GError* e = NULL;
				GError* _tmp41_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp41_ = e;
				if (g_error_matches (_tmp41_, G_IO_ERROR, G_IO_ERROR_WOULD_BLOCK)) {
					gint _tmp42_ = 0;
					_tmp42_ = timeout;
					timeout = _tmp42_ - 1;
					g_usleep ((gulong) 10000);
				} else {
					GError* _tmp43_ = NULL;
					GError* _tmp44_ = NULL;
					_tmp43_ = e;
					_tmp44_ = _g_error_copy0 (_tmp43_);
					_inner_error_ = _tmp44_;
					_g_error_free0 (e);
					goto __finally12;
				}
				_g_error_free0 (e);
			}
			__finally12:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (conn);
				_g_object_unref0 (s);
				goto __catch10_g_error;
			}
		}
		_tmp45_ = conn;
		_vala_assert (_tmp45_ != NULL, "conn != null");
		_tmp46_ = g_new0 (guint8, 1000);
		buf = _tmp46_;
		buf_length1 = 1000;
		_buf_size_ = buf_length1;
		_tmp47_ = conn;
		_tmp48_ = buf;
		_tmp48__length1 = buf_length1;
		_tmp49_ = g_socket_receive (_tmp47_, _tmp48_, (gsize) _tmp48__length1, NULL, &_inner_error_);
		len = _tmp49_;
		if (_inner_error_ != NULL) {
			buf = (g_free (buf), NULL);
			_g_object_unref0 (conn);
			_g_object_unref0 (s);
			goto __catch10_g_error;
		}
		_tmp50_ = len;
		_vala_assert (_tmp50_ > ((gssize) 0), "len > 0");
		_tmp51_ = buf;
		_tmp51__length1 = buf_length1;
		_tmp52_ = len;
		_tmp51_[_tmp52_] = (guint8) 0;
		_tmp53_ = _tmp51_[_tmp52_];
		_tmp54_ = buf;
		_tmp54__length1 = buf_length1;
		g_assert_cmpstr ((const gchar*) _tmp54_, ==, "What is your name?\n");
		g_usleep ((gulong) 300000);
		_tmp55_ = conn;
		_tmp56_ = string_get_data ("John\n", &_tmp56__length1);
		_tmp57_ = _tmp56_;
		_tmp57__length1 = _tmp56__length1;
		g_socket_send (_tmp55_, _tmp57_, (gsize) _tmp57__length1, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			buf = (g_free (buf), NULL);
			_g_object_unref0 (conn);
			_g_object_unref0 (s);
			goto __catch10_g_error;
		}
		g_usleep ((gulong) 10000);
		_tmp59_ = conn;
		_tmp60_ = buf;
		_tmp60__length1 = buf_length1;
		_tmp61_ = g_socket_receive (_tmp59_, _tmp60_, (gsize) _tmp60__length1, NULL, &_inner_error_);
		_tmp58_ = _tmp61_;
		if (_inner_error_ != NULL) {
			buf = (g_free (buf), NULL);
			_g_object_unref0 (conn);
			_g_object_unref0 (s);
			goto __catch10_g_error;
		}
		len = _tmp58_;
		_tmp62_ = len;
		_vala_assert (_tmp62_ > ((gssize) 0), "len > 0");
		_tmp63_ = buf;
		_tmp63__length1 = buf_length1;
		_tmp64_ = len;
		_tmp63_[_tmp64_] = (guint8) 0;
		_tmp65_ = _tmp63_[_tmp64_];
		_tmp66_ = buf;
		_tmp66__length1 = buf_length1;
		g_assert_cmpstr ((const gchar*) _tmp66_, ==, "hello John\n");
		g_usleep ((gulong) 20000);
		_tmp68_ = conn;
		_tmp69_ = buf;
		_tmp69__length1 = buf_length1;
		_tmp70_ = g_socket_receive (_tmp68_, _tmp69_, (gsize) _tmp69__length1, NULL, &_inner_error_);
		_tmp67_ = _tmp70_;
		if (_inner_error_ != NULL) {
			buf = (g_free (buf), NULL);
			_g_object_unref0 (conn);
			_g_object_unref0 (s);
			goto __catch10_g_error;
		}
		len = _tmp67_;
		_tmp71_ = len;
		_vala_assert (_tmp71_ > ((gssize) 0), "len > 0");
		_tmp72_ = buf;
		_tmp72__length1 = buf_length1;
		_tmp73_ = len;
		_tmp72_[_tmp73_] = (guint8) 0;
		_tmp74_ = _tmp72_[_tmp73_];
		_tmp75_ = buf;
		_tmp75__length1 = buf_length1;
		g_assert_cmpstr ((const gchar*) _tmp75_, ==, "send()");
		g_usleep ((gulong) 20000);
		_tmp76_ = conn;
		_tmp77_ = string_get_data ("recv()", &_tmp77__length1);
		_tmp78_ = _tmp77_;
		_tmp78__length1 = _tmp77__length1;
		g_socket_send (_tmp76_, _tmp78_, (gsize) _tmp78__length1, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			buf = (g_free (buf), NULL);
			_g_object_unref0 (conn);
			_g_object_unref0 (s);
			goto __catch10_g_error;
		}
		buf = (g_free (buf), NULL);
		_g_object_unref0 (conn);
		_g_object_unref0 (s);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp79_ = NULL;
		const gchar* _tmp80_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp79_ = spath;
		g_remove (_tmp79_);
		_tmp80_ = e->message;
		g_error ("test-umockdev-record.vala:642: Error: %s", _tmp80_);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_free0 (spath);
		_g_free0 (log);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp81_ = spath;
	g_remove (_tmp81_);
	_tmp82_ = chatter_pid;
	_tmp84_ = waitpid ((pid_t) _tmp82_, &_tmp83_, 0);
	status = _tmp83_;
	_tmp85_ = chatter_pid;
	g_assert_cmpint ((gint) _tmp84_, ==, (gint) _tmp85_);
	g_assert_cmpint (status, ==, 0);
	_tmp86_ = log;
	_tmp87_ = g_fopen (_tmp86_, "r");
	log_stream = _tmp87_;
	time = 0;
	_tmp88_ = fscanf (log_stream, "w %d What is your name?^J\n", &time);
	g_assert_cmpint (_tmp88_, ==, 1);
	g_assert_cmpint (time, <=, 20);
	_tmp89_ = fscanf (log_stream, "r %d John^J\n", &time);
	g_assert_cmpint (_tmp89_, ==, 1);
	g_assert_cmpint (time, >=, 250);
	g_assert_cmpint (time, <=, 400);
	_tmp90_ = fscanf (log_stream, "w %d hello John^J\n", &time);
	g_assert_cmpint (_tmp90_, ==, 1);
	g_assert_cmpint (time, <=, 20);
	_tmp91_ = fscanf (log_stream, "w %d send()\n", &time);
	g_assert_cmpint (_tmp91_, ==, 1);
	g_assert_cmpint (time, >=, 10);
	_tmp92_ = fscanf (log_stream, "r %d recv()\n", &time);
	g_assert_cmpint (_tmp92_, ==, 1);
	g_assert_cmpint (time, >=, 20);
	g_assert_cmpint (time, <=, 60);
	_tmp93_ = log;
	g_remove (_tmp93_);
	_fclose0 (log_stream);
	_g_free0 (spath);
	_g_free0 (log);
}


void t_system_evemu_log (void) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* workdir = NULL;
	gchar* log = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	const gchar* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	const gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	const gchar* _tmp43_ = NULL;
	gboolean _tmp44_ = FALSE;
	gint _tmp45_ = 0;
	const gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	gint _tmp54_ = 0;
	gint _tmp55_ = 0;
	const gchar* _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	gboolean _tmp58_ = FALSE;
	const gchar* _tmp59_ = NULL;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_dir_make_tmp ("evemu_log_test.XXXXXX", &_inner_error_);
		_tmp0_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
		_g_free0 (workdir);
		workdir = _tmp0_;
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		abort ();
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_free0 (workdir);
		_g_free0 (serr);
		_g_free0 (sout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = g_build_filename (workdir, "log", NULL);
	log = _tmp2_;
	_tmp3_ = umockdev_record_path;
	_tmp4_ = g_strconcat (_tmp3_, " --evemu-events=/dev/null=", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, log, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, " -- head -c1 /dev/null", NULL);
	_tmp9_ = _tmp8_;
	spawn (_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
	_g_free0 (sout);
	sout = _tmp10_;
	_g_free0 (serr);
	serr = _tmp11_;
	exit = _tmp12_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp13_ = serr;
	g_assert_cmpstr (_tmp13_, ==, "");
	_tmp14_ = exit;
	g_assert_cmpint (_tmp14_, ==, 0);
	_tmp15_ = sout;
	g_assert_cmpstr (_tmp15_, ==, "\0");
	_tmp16_ = file_contents (log);
	_tmp17_ = _tmp16_;
	g_assert_cmpstr (_tmp17_, ==, "# EVEMU 1.2\n# device /dev/null\n");
	_g_free0 (_tmp17_);
	_tmp18_ = umockdev_record_path;
	_tmp19_ = g_strconcat (_tmp18_, " --evemu-events=/dev/null=", NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat (_tmp20_, log, NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat (_tmp22_, " -- head -c1 /dev/null", NULL);
	_tmp24_ = _tmp23_;
	spawn (_tmp24_, &_tmp25_, &_tmp26_, &_tmp27_);
	_g_free0 (sout);
	sout = _tmp25_;
	_g_free0 (serr);
	serr = _tmp26_;
	exit = _tmp27_;
	_g_free0 (_tmp24_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_tmp28_ = serr;
	g_assert_cmpstr (_tmp28_, ==, "");
	_tmp29_ = exit;
	g_assert_cmpint (_tmp29_, ==, 0);
	_tmp30_ = sout;
	g_assert_cmpstr (_tmp30_, ==, "\0");
	_tmp31_ = file_contents (log);
	_tmp32_ = _tmp31_;
	g_assert_cmpstr (_tmp32_, ==, "# EVEMU 1.2\n# device /dev/null\n\n");
	_g_free0 (_tmp32_);
	_tmp33_ = umockdev_record_path;
	_tmp34_ = g_strconcat (_tmp33_, " --evemu-events=/dev/zero=", NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strconcat (_tmp35_, log, NULL);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_strconcat (_tmp37_, " -- head -c1 /dev/zero", NULL);
	_tmp39_ = _tmp38_;
	spawn (_tmp39_, &_tmp40_, &_tmp41_, &_tmp42_);
	_g_free0 (sout);
	sout = _tmp40_;
	_g_free0 (serr);
	serr = _tmp41_;
	exit = _tmp42_;
	_g_free0 (_tmp39_);
	_g_free0 (_tmp37_);
	_g_free0 (_tmp35_);
	_tmp43_ = serr;
	_tmp44_ = string_contains (_tmp43_, "two different devices");
	_vala_assert (_tmp44_, "serr.contains (\"two different devices\")");
	_tmp45_ = exit;
	g_assert_cmpint (_tmp45_, ==, 256);
	_tmp46_ = sout;
	g_assert_cmpstr (_tmp46_, ==, "\0");
	_tmp47_ = file_contents (log);
	_tmp48_ = _tmp47_;
	g_assert_cmpstr (_tmp48_, ==, "# EVEMU 1.2\n# device /dev/null\n\n");
	_g_free0 (_tmp48_);
	g_remove (log);
	_tmp49_ = umockdev_record_path;
	_tmp50_ = g_strconcat (_tmp49_, " --evemu-events /dev/null -- true", NULL);
	_tmp51_ = _tmp50_;
	spawn (_tmp51_, &_tmp52_, &_tmp53_, &_tmp54_);
	_g_free0 (sout);
	sout = _tmp52_;
	_g_free0 (serr);
	serr = _tmp53_;
	exit = _tmp54_;
	_g_free0 (_tmp51_);
	_tmp55_ = exit;
	g_assert_cmpint (_tmp55_, !=, 1);
	_tmp56_ = sout;
	g_assert_cmpstr (_tmp56_, ==, "");
	_tmp57_ = serr;
	_tmp58_ = string_contains (_tmp57_, "--ioctl");
	_vala_assert (_tmp58_, "serr.contains (\"--ioctl\")");
	_tmp59_ = serr;
	_tmp60_ = string_contains (_tmp59_, "=");
	_vala_assert (_tmp60_, "serr.contains (\"=\")");
	_tmp61_ = g_file_test (log, G_FILE_TEST_EXISTS);
	_vala_assert (!_tmp61_, "!FileUtils.test (log, FileTest.EXISTS)");
	g_rmdir (workdir);
	_g_free0 (log);
	_g_free0 (workdir);
	_g_free0 (serr);
	_g_free0 (sout);
}


void t_run_invalid_args (void) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	_tmp0_ = umockdev_record_path;
	_tmp1_ = g_strconcat (_tmp0_, " /dev/no/such/device", NULL);
	_tmp2_ = _tmp1_;
	spawn (_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	_g_free0 (sout);
	sout = _tmp3_;
	_g_free0 (serr);
	serr = _tmp4_;
	exit = _tmp5_;
	_g_free0 (_tmp2_);
	assert_in ("Cannot access device /dev/no/such/device: No such file", serr);
	g_assert_cmpstr (sout, ==, "");
	g_assert_cmpint (exit, !=, 0);
	_g_free0 (serr);
	_g_free0 (sout);
}


void t_gphoto2_record (void) {
	gchar* sout = NULL;
	gchar* sout_record = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GRegex* port_re = NULL;
	GMatchInfo* match = NULL;
	GRegex* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GMatchInfo* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	gchar* busnum = NULL;
	GMatchInfo* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* devnum = NULL;
	GMatchInfo* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	const gchar* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	gchar* cmd = NULL;
	gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	const gchar* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	const gchar* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	gint _tmp57_ = 0;
	const gchar* _tmp58_ = NULL;
	gint _tmp59_ = 0;
	const gchar* _tmp60_ = NULL;
	const gchar* _tmp61_ = NULL;
	GError * _inner_error_ = NULL;
	spawn ("which gphoto2", &_tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (sout);
	sout = _tmp0_;
	_g_free0 (serr);
	serr = _tmp1_;
	exit = _tmp2_;
	_tmp3_ = exit;
	if (_tmp3_ != 0) {
		FILE* _tmp4_ = NULL;
		_tmp4_ = stderr;
		fprintf (_tmp4_, "[SKIP: gphoto2 not installed] ");
		_g_free0 (serr);
		_g_free0 (sout_record);
		_g_free0 (sout);
		return;
	}
	spawn ("gphoto2 --auto-detect", &_tmp5_, &_tmp6_, &_tmp7_);
	_g_free0 (sout);
	sout = _tmp5_;
	_g_free0 (serr);
	serr = _tmp6_;
	exit = _tmp7_;
	_tmp8_ = exit;
	if (_tmp8_ != 0) {
		FILE* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp9_ = stdout;
		_tmp10_ = sout;
		_tmp11_ = serr;
		_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		fprintf (_tmp9_, "[SKIP: gphoto2 --auto-detect failed: %s] ", _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (serr);
		_g_free0 (sout_record);
		_g_free0 (sout);
		return;
	}
	{
		GRegex* _tmp14_ = NULL;
		GRegex* _tmp15_ = NULL;
		_tmp15_ = g_regex_new ("usb:([0-9]+),([0-9]+)", 0, 0, &_inner_error_);
		_tmp14_ = _tmp15_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch14_g_regex_error;
			}
			_g_regex_unref0 (port_re);
			_g_free0 (serr);
			_g_free0 (sout_record);
			_g_free0 (sout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_regex_unref0 (port_re);
		port_re = _tmp14_;
	}
	goto __finally14;
	__catch14_g_regex_error:
	{
		GError* e = NULL;
		const gchar* _tmp16_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e->message;
		g_error ("test-umockdev-record.vala:766: Internal error building regex: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (port_re);
		_g_free0 (serr);
		_g_free0 (sout_record);
		_g_free0 (sout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp17_ = port_re;
	_tmp18_ = sout;
	_tmp20_ = g_regex_match (_tmp17_, _tmp18_, 0, &_tmp19_);
	_g_match_info_unref0 (match);
	match = _tmp19_;
	if (!_tmp20_) {
		FILE* _tmp21_ = NULL;
		_tmp21_ = stdout;
		fprintf (_tmp21_, "[SKIP: no gphoto2 compatible camera attached] ");
		_g_match_info_unref0 (match);
		_g_regex_unref0 (port_re);
		_g_free0 (serr);
		_g_free0 (sout_record);
		_g_free0 (sout);
		return;
	}
	_tmp22_ = match;
	_tmp23_ = g_match_info_fetch (_tmp22_, 1);
	busnum = _tmp23_;
	_tmp24_ = match;
	_tmp25_ = g_match_info_fetch (_tmp24_, 2);
	devnum = _tmp25_;
	_tmp26_ = umockdev_record_path;
	_tmp27_ = busnum;
	_tmp28_ = devnum;
	_tmp29_ = g_strdup_printf ("sh -c '%s /dev/bus/usb/%s/%s > gphoto-test.umockdev'", _tmp26_, _tmp27_, _tmp28_);
	_tmp30_ = _tmp29_;
	spawn (_tmp30_, &_tmp31_, &_tmp32_, &_tmp33_);
	_g_free0 (sout);
	sout = _tmp31_;
	_g_free0 (serr);
	serr = _tmp32_;
	exit = _tmp33_;
	_g_free0 (_tmp30_);
	_tmp34_ = serr;
	g_assert_cmpstr (_tmp34_, ==, "");
	_tmp35_ = sout;
	g_assert_cmpstr (_tmp35_, ==, "");
	_tmp36_ = exit;
	g_assert_cmpint (_tmp36_, ==, 0);
	_tmp37_ = g_strdup ("sh -c 'gphoto2 -l; gphoto2 -L'");
	cmd = _tmp37_;
	_tmp38_ = umockdev_record_path;
	_tmp39_ = busnum;
	_tmp40_ = devnum;
	_tmp41_ = cmd;
	_tmp42_ = g_strdup_printf ("%s -i /dev/bus/usb/%s/%s=gphoto-test.ioctl -- %s", _tmp38_, _tmp39_, _tmp40_, _tmp41_);
	_tmp43_ = _tmp42_;
	spawn (_tmp43_, &_tmp44_, &_tmp45_, &_tmp46_);
	_g_free0 (sout_record);
	sout_record = _tmp44_;
	_g_free0 (serr);
	serr = _tmp45_;
	exit = _tmp46_;
	_g_free0 (_tmp43_);
	_tmp47_ = serr;
	g_assert_cmpstr (_tmp47_, ==, "");
	_tmp48_ = exit;
	g_assert_cmpint (_tmp48_, ==, 0);
	_tmp49_ = umockdev_run_path;
	_tmp50_ = busnum;
	_tmp51_ = devnum;
	_tmp52_ = cmd;
	_tmp53_ = g_strdup_printf ("%s -d gphoto-test.umockdev -i /dev/bus/usb/%s/%s=gphoto-test.ioctl -- " \
"%s", _tmp49_, _tmp50_, _tmp51_, _tmp52_);
	_tmp54_ = _tmp53_;
	spawn (_tmp54_, &_tmp55_, &_tmp56_, &_tmp57_);
	_g_free0 (sout);
	sout = _tmp55_;
	_g_free0 (serr);
	serr = _tmp56_;
	exit = _tmp57_;
	_g_free0 (_tmp54_);
	_tmp58_ = serr;
	g_assert_cmpstr (_tmp58_, ==, "");
	_tmp59_ = exit;
	g_assert_cmpint (_tmp59_, ==, 0);
	_tmp60_ = sout;
	_tmp61_ = sout_record;
	g_assert_cmpstr (_tmp60_, ==, _tmp61_);
	g_remove ("gphoto-test.umockdev");
	g_remove ("gphoto-test.ioctl");
	_g_free0 (cmd);
	_g_free0 (devnum);
	_g_free0 (busnum);
	_g_match_info_unref0 (match);
	_g_regex_unref0 (port_re);
	_g_free0 (serr);
	_g_free0 (sout_record);
	_g_free0 (sout);
}


static void _t_testbed_all_empty_gtest_func (void) {
	t_testbed_all_empty ();
}


static void _t_testbed_one_gtest_func (void) {
	t_testbed_one ();
}


static void _t_testbed_multiple_gtest_func (void) {
	t_testbed_multiple ();
}


static void _t_testbed_no_ioctl_record_gtest_func (void) {
	t_testbed_no_ioctl_record ();
}


static void _t_system_single_gtest_func (void) {
	t_system_single ();
}


static void _t_system_all_gtest_func (void) {
	t_system_all ();
}


static void _t_system_invalid_gtest_func (void) {
	t_system_invalid ();
}


static void _t_system_ioctl_log_gtest_func (void) {
	t_system_ioctl_log ();
}


static void _t_system_ioctl_log_append_dev_mismatch_gtest_func (void) {
	t_system_ioctl_log_append_dev_mismatch ();
}


static void _t_system_script_log_simple_gtest_func (void) {
	t_system_script_log_simple ();
}


static void _t_system_script_log_append_same_dev_gtest_func (void) {
	t_system_script_log_append_same_dev ();
}


static void _t_system_script_log_append_dev_mismatch_gtest_func (void) {
	t_system_script_log_append_dev_mismatch ();
}


static void _t_system_script_log_chatter_gtest_func (void) {
	t_system_script_log_chatter ();
}


static void _t_system_script_log_chatter_socket_stream_gtest_func (void) {
	t_system_script_log_chatter_socket_stream ();
}


static void _t_system_evemu_log_gtest_func (void) {
	t_system_evemu_log ();
}


static void _t_run_invalid_args_gtest_func (void) {
	t_run_invalid_args ();
}


static void _t_gphoto2_record_gtest_func (void) {
	t_gphoto2_record ();
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gchar* r = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_getenv ("TOP_BUILDDIR");
	_tmp1_ = g_strdup (_tmp0_);
	r = _tmp1_;
	_tmp2_ = r;
	if (_tmp2_ == NULL) {
		gchar** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp3_ = args;
		_tmp3__length1 = args_length1;
		_tmp4_ = _tmp3_[0];
		_tmp5_ = realpath (_tmp4_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_path_get_dirname (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_path_get_dirname (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_path_get_dirname (_tmp10_);
		_g_free0 (rootdir);
		rootdir = _tmp11_;
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
	} else {
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp12_ = r;
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (rootdir);
		rootdir = _tmp13_;
	}
	_tmp14_ = rootdir;
	_tmp15_ = g_build_filename (_tmp14_, "src", "umockdev-record", NULL);
	_g_free0 (umockdev_record_path);
	umockdev_record_path = _tmp15_;
	_tmp16_ = rootdir;
	_tmp17_ = g_build_filename (_tmp16_, "src", "umockdev-run", NULL);
	_g_free0 (umockdev_run_path);
	umockdev_run_path = _tmp17_;
	g_test_add_func ("/umockdev-record/testbed-all-empty", _t_testbed_all_empty_gtest_func);
	g_test_add_func ("/umockdev-record/testbed-one", _t_testbed_one_gtest_func);
	g_test_add_func ("/umockdev-record/testbed-multiple", _t_testbed_multiple_gtest_func);
	g_test_add_func ("/umockdev-record/testbed-no-ioctl-record", _t_testbed_no_ioctl_record_gtest_func);
	g_test_add_func ("/umockdev-record/system-single", _t_system_single_gtest_func);
	g_test_add_func ("/umockdev-record/system-all", _t_system_all_gtest_func);
	g_test_add_func ("/umockdev-record/system-invalid", _t_system_invalid_gtest_func);
	g_test_add_func ("/umockdev-record/ioctl-log", _t_system_ioctl_log_gtest_func);
	g_test_add_func ("/umockdev-record/ioctl-log-append-dev-mismatch", _t_system_ioctl_log_append_dev_mismatch_gtest_func);
	g_test_add_func ("/umockdev-record/script-log-simple", _t_system_script_log_simple_gtest_func);
	g_test_add_func ("/umockdev-record/script-log-append-same-dev", _t_system_script_log_append_same_dev_gtest_func);
	g_test_add_func ("/umockdev-record/script-log-append-dev-mismatch", _t_system_script_log_append_dev_mismatch_gtest_func);
	g_test_add_func ("/umockdev-record/script-log-chatter", _t_system_script_log_chatter_gtest_func);
	g_test_add_func ("/umockdev-record/script-log-socket", _t_system_script_log_chatter_socket_stream_gtest_func);
	g_test_add_func ("/umockdev-record/evemu-log", _t_system_evemu_log_gtest_func);
	g_test_add_func ("/umockdev-record/invalid-args", _t_run_invalid_args_gtest_func);
	g_test_add_func ("/umockdev-record/gphoto2-record", _t_gphoto2_record_gtest_func);
	_tmp18_ = g_test_run ();
	result = _tmp18_;
	_g_free0 (r);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



