/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_ORDEREDMEMBEROFBIOSCOLLECTIONACCESS_H_
#define OPENDRIM_ORDEREDMEMBEROFBIOSCOLLECTIONACCESS_H_

#include "BIOS_Common.h"

#include "OpenDRIM_OrderedMemberOfBIOSCollection.h"
#include "assocOpenDRIM_OrderedMemberOfBIOSCollection.h"

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_load(const CMPIBroker* broker, string& errorMessage);

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_unload(string& errorMessage);

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_OrderedMemberOfBIOSCollection>& instances, const char** properties, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_OrderedMemberOfBIOSCollection& instance, const char** properties, string& errorMessage);

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OrderedMemberOfBIOSCollection& newInstance, const OpenDRIM_OrderedMemberOfBIOSCollection& oldInstance, const char** properties, string& errorMessage);

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OrderedMemberOfBIOSCollection& instance, string& errorMessage);

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OrderedMemberOfBIOSCollection& instance, string& errorMessage);

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_associatorMemberToCollection(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Member_instance, const char** properties, vector<Instance>& Collection_associatedInstances, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_associatorCollectionToMember(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Collection_instance, const char** properties, vector<Instance>& Member_associatedInstances, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_referenceMemberToCollection(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Member_instance, const vector<Instance>& Collection_instances, vector<OpenDRIM_OrderedMemberOfBIOSCollection>& OpenDRIM_OrderedMemberOfBIOSCollection_instances, const char** properties, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_referenceCollectionToMember(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Collection_instance, const vector<Instance>& Member_instances, vector<OpenDRIM_OrderedMemberOfBIOSCollection>& OpenDRIM_OrderedMemberOfBIOSCollection_instances, const char** properties, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_OrderedMemberOfBIOSCollection_populate(OpenDRIM_OrderedMemberOfBIOSCollection& instance, string& errorMessage);

#endif /*OPENDRIM_ORDEREDMEMBEROFBIOSCOLLECTIONACCESS_H_*/
