/*###############################################################################
# Linux Management Providers (LMP), Power Management provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_ASSOCIATEDPOWERMANAGEMENTSERVICE_H_
#define OPENDRIM_ASSOCIATEDPOWERMANAGEMENTSERVICE_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_ManagedElement.h"
#include "CIM_ManagedElementAccess.h"
#include "cmpiCIM_PowerManagementService.h"
#include "CIM_PowerManagementServiceAccess.h"
*/

const static char* OpenDRIM_AssociatedPowerManagementService_classnames[] = {"OpenDRIM_AssociatedPowerManagementService"};
static string OpenDRIM_AssociatedPowerManagementService_NAMESPACE = _NAMESPACE;
const static string UserOfService_role = "UserOfService";
const static char* UserOfService_classnames[] = {"OpenDRIM_ComputerSystem"};
const static string UserOfService_NAMESPACE = _NAMESPACE;

const static string ServiceProvided_role = "ServiceProvided";
const static char* ServiceProvided_classnames[] = {"OpenDRIM_PowerManagementService"};
const static string ServiceProvided_NAMESPACE = _NAMESPACE;

class OpenDRIM_AssociatedPowerManagementService {

public:
	
	Objectpath ServiceProvided;
	bool ServiceProvided_isNULL;
	
	Objectpath UserOfService;
	bool UserOfService_isNULL;
	
	unsigned short PowerState;
	bool PowerState_isNULL;
	
	string OtherPowerState;
	bool OtherPowerState_isNULL;
	
	unsigned short RequestedPowerState;
	bool RequestedPowerState_isNULL;
	
	string OtherRequestedPowerState;
	bool OtherRequestedPowerState_isNULL;
	
	string PowerOnTime;
	bool PowerOnTime_isNULL;
	
	OpenDRIM_AssociatedPowerManagementService() {
		ServiceProvided_isNULL = true;
		UserOfService_isNULL = true;
		PowerState_isNULL = true;
		OtherPowerState_isNULL = true;
		RequestedPowerState_isNULL = true;
		OtherRequestedPowerState_isNULL = true;
		PowerOnTime_isNULL = true;
	}
	
	~OpenDRIM_AssociatedPowerManagementService() {}
	
	string getKeys() const {
		return CF_toLowCase(".ServiceProvided=\"" + CF_quoteString(ServiceProvided.toString()) + "\""".UserOfService=\"" + CF_quoteString(UserOfService.toString()) + "\"");
	}

	int getServiceProvided(Objectpath& value) const {
		if (ServiceProvided_isNULL==true)
			return NOT_FOUND;
		value = ServiceProvided;
		return OK;
	}
	
	int setServiceProvided(const Objectpath& newValue) {
		ServiceProvided = newValue;
		ServiceProvided.setNamespace(ServiceProvided_NAMESPACE);
		ServiceProvided_isNULL = false;
		return OK;
	}

	int getUserOfService(Objectpath& value) const {
		if (UserOfService_isNULL==true)
			return NOT_FOUND;
		value = UserOfService;
		return OK;
	}
	
	int setUserOfService(const Objectpath& newValue) {
		UserOfService = newValue;
		UserOfService.setNamespace(UserOfService_NAMESPACE);
		UserOfService_isNULL = false;
		return OK;
	}

	int getPowerState(unsigned short& value) const {
		if (PowerState_isNULL==true)
			return NOT_FOUND;
		value = PowerState;
		return OK;
	}
	
	int setPowerState(const unsigned short& newValue) {
		PowerState = newValue;
		PowerState_isNULL = false;
		return OK;
	}

	int getOtherPowerState(string& value) const {
		if (OtherPowerState_isNULL==true)
			return NOT_FOUND;
		value = OtherPowerState;
		return OK;
	}
	
	int setOtherPowerState(const string& newValue) {
		OtherPowerState = newValue;
		OtherPowerState_isNULL = false;
		return OK;
	}

	int getRequestedPowerState(unsigned short& value) const {
		if (RequestedPowerState_isNULL==true)
			return NOT_FOUND;
		value = RequestedPowerState;
		return OK;
	}
	
	int setRequestedPowerState(const unsigned short& newValue) {
		RequestedPowerState = newValue;
		RequestedPowerState_isNULL = false;
		return OK;
	}

	int getOtherRequestedPowerState(string& value) const {
		if (OtherRequestedPowerState_isNULL==true)
			return NOT_FOUND;
		value = OtherRequestedPowerState;
		return OK;
	}
	
	int setOtherRequestedPowerState(const string& newValue) {
		OtherRequestedPowerState = newValue;
		OtherRequestedPowerState_isNULL = false;
		return OK;
	}

	int getPowerOnTime(string& value) const {
		if (PowerOnTime_isNULL==true)
			return NOT_FOUND;
		value = PowerOnTime;
		return OK;
	}
	
	int setPowerOnTime(const string& newValue) {
		PowerOnTime = newValue;
		PowerOnTime_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_ASSOCIATEDPOWERMANAGEMENTSERVICE_H_*/
