/*###############################################################################
# Linux Management Providers (LMP), Sensors provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_PROCESSORVOLTAGESENSORACCESS_H_
#define OPENDRIM_PROCESSORVOLTAGESENSORACCESS_H_

#include "Sensors_Common.h"
#include <SMBIOS.h>

#include "OpenDRIM_ProcessorVoltageSensor.h"

int Sensors_OpenDRIM_ProcessorVoltageSensor_load(const CMPIBroker* broker, string& errorMessage);

int Sensors_OpenDRIM_ProcessorVoltageSensor_unload(string& errorMessage);

int Sensors_OpenDRIM_ProcessorVoltageSensor_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ProcessorVoltageSensor>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Sensors_OpenDRIM_ProcessorVoltageSensor_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ProcessorVoltageSensor& instance, const char** properties, string& errorMessage);

int Sensors_OpenDRIM_ProcessorVoltageSensor_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& newInstance, const OpenDRIM_ProcessorVoltageSensor& oldInstance, const char** properties, string& errorMessage);

int Sensors_OpenDRIM_ProcessorVoltageSensor_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, string& errorMessage);

int Sensors_OpenDRIM_ProcessorVoltageSensor_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, string& errorMessage);

int Sensors_OpenDRIM_ProcessorVoltageSensor_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, const OpenDRIM_ProcessorVoltageSensor_RequestStateChange_In& in, OpenDRIM_ProcessorVoltageSensor_RequestStateChange_Out& out, string& errorMessage);

int Sensors_OpenDRIM_ProcessorVoltageSensor_SetPowerState(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, const OpenDRIM_ProcessorVoltageSensor_SetPowerState_In& in, string& errorMessage);

int Sensors_OpenDRIM_ProcessorVoltageSensor_Reset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, string& errorMessage);

int Sensors_OpenDRIM_ProcessorVoltageSensor_EnableDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, const OpenDRIM_ProcessorVoltageSensor_EnableDevice_In& in, string& errorMessage);

int Sensors_OpenDRIM_ProcessorVoltageSensor_OnlineDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, const OpenDRIM_ProcessorVoltageSensor_OnlineDevice_In& in, string& errorMessage);

int Sensors_OpenDRIM_ProcessorVoltageSensor_QuiesceDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, const OpenDRIM_ProcessorVoltageSensor_QuiesceDevice_In& in, string& errorMessage);

int Sensors_OpenDRIM_ProcessorVoltageSensor_SaveProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, string& errorMessage);

int Sensors_OpenDRIM_ProcessorVoltageSensor_RestoreProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, string& errorMessage);

int Sensors_OpenDRIM_ProcessorVoltageSensor_RestoreDefaultThresholds(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, string& errorMessage);

int Sensors_OpenDRIM_ProcessorVoltageSensor_GetNonLinearFactors(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, const OpenDRIM_ProcessorVoltageSensor_GetNonLinearFactors_In& in, OpenDRIM_ProcessorVoltageSensor_GetNonLinearFactors_Out& out, string& errorMessage);

int Sensors_OpenDRIM_ProcessorVoltageSensor_populate(OpenDRIM_ProcessorVoltageSensor& instance, int num, string& errorMessage);

#endif /*OPENDRIM_PROCESSORVOLTAGESENSORACCESS_H_*/
