(defconst *bob* (get-var 'bob *users*))

(defun encrypted? (msg)
  (and
   (message-p msg)
   (let ((body (message-body msg)))
     (and 
      (listp body)
      (listp (car body))
      (equal (caar body)
	     'encrypted)))))

(defthm encrypt-message-makes-encrypted
 (implies
  (and
   (message-p msg)
   (symbolp key)
   (email-p (recipient msg))
   )
  (encrypted?
   (encrypt-message msg key nonce)))
 :hints (("Goal" :in-theory (enable encrypt-message encrypt-headers
				    encrypt-headers-helper))))

(defthm encrypt-headers-leaves-sender-same
 (implies
  (and
   (message-p msg)
   )
  (let ((new-msg
	(encrypt-headers msg key)))
    (equal
     (message-sender msg)
     (message-sender new-msg)))))

(defthm encrypt-message-leaves-sender-same
 (implies
  (and
   (message-p msg)
   )
  (let ((new-msg
	(encrypt-message msg key nonce)))
    (equal
     (message-sender msg)
     (message-sender new-msg)))))

(defthm encrypt-message-leaves-recips-same
 (implies
  (and
   (message-p msg)
   )
  (let ((new-msg
	(encrypt-message msg key nonce)))
    (equal
     (message-recips msg)
     (message-recips new-msg)))))

(defthm encrypt-headers-leaves-recips-same
 (implies
  (and
   (message-p msg)
   )
  (let ((new-msg
	(encrypt-headers msg key )))
    (equal
     (message-recips msg)
     (message-recips new-msg)))))


(make-*/mail-returns-symbol-alistp-thm email-encrypt-incoming)
(make-*/mail-returns-same-env-thm      email-encrypt-incoming)
(make-*/mail-returns-same-message-thm  email-encrypt-incoming)
(make-*/mail-returns-symbolp-thm       email-encrypt-incoming)
(make-*/mail-returns-symbols-thm       email-encrypt-incoming
				       '(comment))

(make-*/mail-returns-symbolp-thm       email-encrypt-outgoing)
(make-*/mail-returns-symbols-thm       email-encrypt-outgoing
				       '(mail))

(make-*/init-add-and-changes-only-x-variables-thm email-encrypt-init 
       '(e-corrs nonce-counter))

(DEFTHM THM-EMAIL-ENCRYPT-COMMAND-ADDS-AND-CHANGES-ONLY-X-VARIABLES
  (IMPLIES (AND (NOT (MEMBER KEY '(E-CORRS CORRESPONDENT-KEY))))
	   (LET ((NEW-ENV (EMAIL-ENCRYPT-COMMAND CMD ARGS ENV)))
		(EQUAL (GET-VAR KEY NEW-ENV) 
		       (GET-VAR KEY ENV))))
;		     (AND (HAS-VAR 'E-CORRS NEW-ENV)
;			  (HAS-VAR 'CORRESPONDENT-KEY NEW-ENV))
  :HINTS
  (("Goal" :IN-THEORY
    (ENABLE EMAIL-ENCRYPT-COMMAND))))

(make-f/comm-returns-superset-of-user-thm email-encrypt-command)

(defthm encrypt-headers-helper-returns-symbol-alistp
  (implies
   (symbol-alistp headers)
   (symbol-alistp (encrypt-headers-helper headers key))))

(defthm encrypt-message-returns-message-p
 (implies
  (message-p msg)
  (message-p (encrypt-message msg key nonce))))

(make-*/mail-returns-message-p-thm email-encrypt-outgoing)

(make-*/mail-returns-superset-of-user-thm email-encrypt-incoming)
(make-*/mail-returns-superset-of-user-thm email-encrypt-outgoing)

(defthm THM-EMAIL-ENCRYPT-OUTGOING-RETURNS-same-message-if-not-e-corrs
 (implies
  (and
   (not (member-equal (recipient msg) (lookup 'e-corrs)))
   )
  (equal
   (mv-msg (email-encrypt-outgoing msg env))
   msg))
  :HINTS
  (("Goal" :IN-THEORY
    (ENABLE EMAIL-ENCRYPT-OUTGOING))))


(defthm THM-EMAIL-ENCRYPT-OUTGOING-RETURNS-same-env-if-not-e-corrs
 (implies
  (and
   (not (member-equal (recipient msg) (lookup 'e-corrs)))
   )
  (equal
   (mv-env (email-encrypt-outgoing msg env))
   env))
  :HINTS
  (("Goal" :IN-THEORY
    (ENABLE EMAIL-ENCRYPT-OUTGOING))))

(defthm email-encrypt-outgoing-returns-encrypted-message
 (implies
  (and
   (message-p msg)
   (member-equal (recipient msg) (get-var 'e-corrs env))
   )
  (encrypted? 
   (mv-msg (email-encrypt-outgoing msg env)))))

(defthm email-encrypt-outgoing-returns-encrypted-message
 (implies
  (and
   (message-p msg)
   (member-equal (recipient msg) (get-var 'e-corrs env))
   )
  (encrypted? 
   (mv-msg (email-encrypt-outgoing msg env)))))

(defthm email-encrypt-outgoing-returns-same-message-if-not-encrypted
 (implies
  (and
   (message-p msg)
   (not (member-equal (recipient msg) (get-var 'e-corrs env)))
   )
  (let ((new-msg
	 (mv-msg (email-encrypt-outgoing msg env))))
    (equal new-msg msg)))
 :hints (("Goal" :in-theory (enable email-encrypt-outgoing))))

(defthm email-encrypt-outgoing-returns-same-message-if-encrypted
 (implies
  (and
   (message-p msg)
   (member-equal (recipient msg) (get-var 'e-corrs env))
   )
  (let ((new-msg
	 (mv-msg (email-encrypt-outgoing msg env))))
    (equal new-msg msg)))
 :hints (("Goal" :in-theory (enable email-encrypt-outgoing))))



(defthm email-encrypt-outgoing-returns-same-sender
 (implies
  (and
   (message-p msg)
;   (message-sender msg)
   )
    (equal (message-sender (mv-msg (email-encrypt-outgoing msg env)))
	 (message-sender msg)))
 :hints (("Goal" :hands-off encrypt-headers
	  :in-theory (enable email-encrypt-outgoing))))
	 ("Subgoal 2" 	  :use encrypt-headers-leaves-sender-same)))


(defthm email-encrypt-outgoing-returns-same-recips
 (implies
  (and
   (message-p msg)
;   (message-recips msg)
   )
    (equal (message-recips (mv-msg (email-encrypt-outgoing msg env)))
	   (message-recips msg)))
 :hints (("Goal" :in-theory (enable email-encrypt-outgoing))))


(defconst *action* 
  (mk-action
   'mail
   'bob
   *msg*
   ))
