# How to use DNS API

If your DNS provider doesn't provide API access, you can use our [DNS alias mode](https://github.com/acmesh-official/acme.sh/wiki/DNS-alias-mode)


* [1. CloudFlare](#dns_cf)
* [2. DNSPod.cn Option:](#dns_dp)
* [4. Use GoDaddy.com domain API to automatically issue cert](#dns_gd)
* [5. Use PowerDNS embedded API to automatically issue cert](#dns_pdns)
* [6. Use OVH, Kimsufi, So you Start API to automatically issue cert](#dns_ovh)
* [7. Use nsupdate to automatically issue cert](#dns_nsupdate)
* [8. Use LuaDNS domain API](#dns_lua)
* [9. Use DNSMadeEasy domain API](#dns_me)
* [10. Use Amazon Route53 domain API](#dns_aws)
* [11. Use Aliyun domain API to automatically issue cert](#dns_ali)
* [12. Use ISPConfig 3.1 API](#dns_ispconfig)
* [13. Use Alwaysdata domain API](#dns_ad)
* [14. Use Linode domain API](#dns_linode_v4)
* [15. Use FreeDNS](#dns_freedns)
* [16. Use cyon.ch](#dns_cyon)
* [18. Use Gandi LiveDNS API](#dns_gandi_livedns)
* [19. Use Knot (knsupdate) DNS API to automatically issue cert](#dns_knot)
* [20. Use DigitalOcean API (native)](#dns_dgon)
* [21. Use ClouDNS.net API](#dns_cloudns)
* [22. Use Infoblox API](#dns_infoblox)
* [23. Use VSCALE API](#dns_vscale)
* [24. Use Dynu API](#dns_dynu)
* [25. Use DNSimple API](#dns_dnsimple)
* [26. Use NS1.com API](#dns_nsone)
* [27. Use DuckDNS.org API](#dns_duckdns)
* [28. Use Name.com API](#dns_namecom)
* [29. Use Dyn Managed DNS API to automatically issue cert](#dns_dyn)
* [30. Use pdd.yandex.ru API](#dns_yandex)
* [31. Use Hurricane Electric](#dns_he)
* [33. Use INWX](#dns_inwx)
* [35. Use Namesilo.com API](#dns_namesilo)
* [36. Use autoDNS (InternetX)](#dns_autodns)
* [37. Use Azure DNS](#dns_azure)
* [38. Use selectel.com(selectel.ru) domain API to automatically issue cert](#dns_selectel)
* [39. Use zonomi.com domain API to automatically issue cert](#dns_zonomi)
* [40. Use DreamHost DNS API](#dns_dreamhost)
* [41. Use DirectAdmin API](#dns_da)
* [42. Use KingHost DNS API](#dns_zilore)
* [43. Use Zilore DNS API](#dns_zilore)
* [44. Use Loopia API](#dns_loopia)
* [45. Use ACME DNS API](#dns_acmedns)
* [47. Use Euserv.eu API](#dns_euserv)
* [48. Use DNSPod.com domain API to automatically issue cert](#dns_dpi)
* [49. Use Google Cloud DNS API to automatically issue cert](#dns_gcloud)
* [50. Use ConoHa API](#dns_conoha)
* [51. Use Netcup API](#dns_netcup)
* [53. Use Namecheap](#dns_namecheap)
* [54. Use MyDNS.JP API](#dns_mydnsjp)
* [55. Use hosting.de API](#dns_hostingde)
* [56. Use Neodigit.net API](#dns_neodigit)
* [57. Use Exoscale API](#dns_exoscale)
* [58. Using PointHQ API to issue certs](#dns_pointhq)
* [59. Use Active24 API](#dns_active24)
* [60. Use do.de API](#dns_doapi)
* [61. Use Nexcess API](#dns_nw)
* [62. Use Thermo.io API](#dns_nw)
* [63. Use Futurehosting API](#dns_nw)
* [65. Use Online API](#dns_online)
* [66. Use MyDevil.net](#dns_mydevil)
* [67. Use Core-Networks API to automatically issue cert](#dns_cn)
* [70. Use UltraDNS API](#dns_ultra)
* [71. Use deSEC.io](#dns_desec)
* [72. Use OpenProvider API](#dns_openprovider)
* [73. Use MaraDNS API](#dns_maradns)
* [74. Use Hetzner API](#dns_hetzner)
* [75. Use DDNSS.de API](#dns_ddnss)
* [76. Use NLnetLabs NSD](#dns_nsd)
<!-- dnsapi2 page -->
- <a name="dns_schlundtech"/> [76. Use Schlundtech](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_schlundtech)
- <a name="dns_one"/> [77. Use your one.com credentials as you would login into the control panel.](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_one)
- <a name="dns_acmeproxy"/> [78. Use AcmeProxy DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_acmeproxy)
- <a name="dns_internetbs"/> [79. Use internetbs.net API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_internetbs)
- <a name="dns_durabledns"/> [80. Use durabledns.com API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_durabledns)
- <a name="dns_regru"/> [81. Use reg.ru API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_regru)
- <a name="dns_vultr"/> [82. Use Vultr DNS API to automatically issue cert](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_vultr)
- <a name="dns_jd"/> [83. Use jdcloud.com DNS API to automatically issue cert](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_jd)
- <a name="dns_hexonet"/> [84. Use hexonet.com DNS API to automatically issue a cert](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_hexonet)
- <a name="dns_domeneshop"/> [85. Use Domeneshop DNS API to automatically issue a cert](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_domeneshop)
- <a name="dns_opnsense"/> [86. Use OPNsense embedded API to automatically issue cert](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_opnsense)
- <a name="dns_rcode0"/> [87. Use the RcodeZero API to automatically issue cert](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_rcode0)
- <a name="dns_miab"/> [88. Use MailinaBox](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_miab)
- <a name="dns_nic"/> [89. Use nic.ru DNS](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_nic)
- <a name="dns_leaseweb"/> [90. Use Leaseweb.com domain API to automatically issue cert](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_leaseweb)
- <a name="dns_variomedia"/> [91. Use variomedia.de domain API to automatically issue cert](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_variomedia)
- <a name="dns_pleskxml"/> [92. Use Plesk XML API to automatically issue cert](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_pleskxml)
- <a name="dns_pdnsmanager"/> [93. Use PDNS Manager API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_pdnsmanager)
- <a name="dns_misaka"/> [94. Use Misaka.io domain API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_misaka)
- <a name="dns_easydns"/> [95. Use easyDNS.net API to automatically issue a cert](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_easydns)
- <a name="dns_clouddns"/> [96. Use CloudDNS API to automatically issue a cert](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_clouddns)
- <a name="dns_dynv6"/> [97. Use dynv6 API to automatically issue a cert](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_dynv6)
- <a name="dns_kas"/> [98. Use All-Inkl.com domain API to automatically issue cert](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_kas)
- <a name="dns_constellix"/> [99. Use Constellix domain API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_constellix)
- <a name="dns_nm"/> [100. Use Namemaster domain API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_nm)
- <a name="dns_hostingukraine"/> [101. Use HostingUkraine domain API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_hostingukraine)
- <a name="dns_arvan"/> [102. Use ArvanCloud domain API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_arvan)
- <a name="dns_joker"/> [103. Use Joker.com domain API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_joker)
- <a name="dns_1984hosting"/> [104. Use 1984Hosting domain API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_1984hosting)
- <a name="dns_aruba"/> [105. Use Aruba domain API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_aruba)
- <a name="dns_transip"/> [106. Use TransIP domain API:](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_transip)
- <a name="dns_df"/> [107. Use dyndnsfree.de API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_df)
- <a name="dns_njalla"/> [108. Use Njalla API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_njalla)
- <a name="dns_vercel"/> [109. Use Vercel API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_vercel)
- <a name="dns_hetzner"/> [110. Use Hetzner DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_hetzner)
- <a name="dns_kappernet"/> [111. Use kapper.net DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_kappernet)
- <a name="dns_wedos"/> [112. Use Wedos API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_wedos)
- <a name="dns_shellrent"/> [113. Use Shellrent API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_shellrent)
- <a name="dns_openstack"/> [114. Use OpenStack domain API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_openstack)
- <a name="dns_netlify"/> [115. Use Netlify API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_netlify)
- <a name="dns_edgedns"/> [116. Use Akamai Edge DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_edgedns)
- <a name="dns_wedos"/> [117. Use WEDOS DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_wedos)
- <a name="dns_websupport"/> [118. Use Websupport DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_websupport)
- <a name="dns_infomaniak"/> [119. Use infomaniak.com API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_infomaniak)
- <a name="dns_bookmyname"/> [120. Use bookmyname.com API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_bookmyname)
- <a name="dns_anx"/> [121. Use anexia.com CloudDNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_anx)
- <a name="dns_synology_dsm"/> [122. Use Synology DSM Synology DNS Server API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_synology_dsm)
- <a name="dns_huaweicloud"/> [123. Use HuaweiCloud API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_huaweicloud)
- <a name="dns_simply"/> [124. Use Simply.com API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_simply)
- <a name="dns_world4you"/> [125. Use World4You API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_world4you)
- <a name="dns_scaleway"/> [126. Use Scaleway API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_scaleway)
- <a name="dns_rackcorp"/> [128. Use RackCorp API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_rackcorp)
- <a name="dns_ionos"/> [129. Using the IONOS domain API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_ionos)
- <a name="dns_porkbun"/> [130. Using the Porkbun API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_porkbun)
- <a name="dns_aurora"/> [131. Using the Aurora API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_aurora)
- <a name="dns_azion"/> [132. Using the Azion DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_azion)
- <a name="dns_oci"/> [133. Using Oracle Cloud Infrastructure DNS](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_oci)
- <a name="dns_hostline"/> [134. Utilisation de l'API DNS Hostline Hébergement VPS](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_hostline)
- <a name="dns_veesp"/> [135. Use Veesp domain API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_veesp)
- <a name="dns_cpanel"/> [136. Use cPanel DNS systems](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_cpanel)
- <a name="dns_ispman"/> [137. Use ISPMan domain API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_ispman)
- <a name="dns_dnshome"/> [138. Use dnsHome.de DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_dnshome)
- <a name="dns_mythic_beasts"/> [139. Use mythic-beasts.com DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_mythic_beasts)
- <a name="dns_sdns"/> [140. Use s-dns.de API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_sdns)
- <a name="dns_udr"/> [141. Using the united-domains reselling DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_udr)
- <a name="dns_curanet"/> [142. Using the curanet DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_curanet)
- <a name="dns_artfiles"/> [143. Use ArtFiles.de DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_artfiles)
- <a name="dns_geoscaling"/> [144. Use Geoscaling.com DNS2](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_geoscaling)
- <a name="dns_fornex"/> [145. Use fornex.com API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_fornex)
- <a name="dns_dnsservices"/> [146. Use DNS.Services API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_dnsservices)
- <a name="dns_nodion"/> [147. Use Nodion DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_nodion)
- <a name="dns_la"/> [148. Use dns.la API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_la)
- <a name="dns_yc"/> [149. Use Yandex Cloud DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_yc)
- <a name="dns_bunny"/> [150. Use Bunny DNS API to automatically issue cert](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_bunny)
- <a name="dns_selfhost"/> [151. Use Selfhost DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_selfhost)
- <a name="dns_rage4"/> [152. Use rage4 DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_rage4)
- <a name="dns_gcore"/> [153. Use GCore DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_gcore)
- <a name="dns_dynadot"/> [154. Use dynadot DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_dynadot)
- <a name="dns_ipv64"/> [155. Use IPv64 DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_ipv64)
- <a name="dns_nanelo"/> [156. Use Nanelo DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_nanelo)
- <a name="dns_googledomains"/> [157. Use Google Domains DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_googledomains)
- <a name="dns_dnsexit"/> [158. Use DNSExit API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_dnsexit)
- <a name="dns_limacity"/> [159. Use Lima-City API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_limacity)
- <a name="dns_tencent"/> [160. Use TencentCloud (DNSPod) API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_tencent)
- <a name="dns_samba"/> [161. Use Samba AD DC API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_samba)
- <a name="dns_west_cn"/> [162. Use West.cn API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_west_cn)
- <a name="dns_hosttech"/> [163. Use Hosttech API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_hosttech)
- <a name="dns_alviy"/> [164. Use Alviy.com DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_alviy)
- <a name="dns_timeweb"/> [165. Use Timeweb Cloud DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_timeweb)
- <a name="dns_myloc"/> [166. Use myLoc.de / webtropia.com DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_myloc)
- <a name="dns_yandex360"/> [167. Use Yandex 360 for Business DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_yandex360)
- <a name="dns_he_ddns"/> [168. Use HE DDNS DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_he_ddns)
- <a name="dns_ionos_cloud"/> [169. Using the IONOS Cloud DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_ionos_cloud)
- <a name="dns_omglol"/> [170. Using the Omg.lol DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_omglol)
- <a name="dns_pmiab"/> [171. Use Power-Mailinabox](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_pmiab)
- <a name="dns_technitium"/> [172. Use Technitium DNS Server API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_technitium)
- <a name="dns_zoneedit"/> [173. Use ZoneEdit DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_zoneedit)
- <a name="dns_anikeen"/> [174. Use Anikeen Cloud DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_anikeen)
- <a name="dns_mijnhost"/> [175. Use mijn.host DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_mijnhost)
- <a name="dns_openprovider_rest"/> [176. Use OpenProvider (REST) DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_openprovider_rest)
- <a name="dns_beget"/> [177. Use Beget.com DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_beget)
- <a name="dns_myapi"/> [Use custom API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_myapi)
- <a name="dns_lexicon"/> [Use lexicon DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_lexicon)



<a name="dns_cf" />

## 1. CloudFlare Option:

Cloudflare Domain API offers two methods to automatically issue certs:

(a) creating a restrictive API token with specific permissions; or  
(b) using the global API key associated with your Cloudflare account, which has all permissions.

Using method (b) is strongly NOT recommended as leakage of the global API token will completely compromise your account, though the key can be reset if this occurs. By contrast, method (a) is recommended because if a restrictive API token is leaked, the attack surface is small, it can simply be deleted/revoked, and its permissions can also be changed at any time via your Cloudflare profile settings.

### (a) Using a restrictive API token

You will need to create an API token which either:

(i) has permissions to edit a single specific DNS zone; or  
(ii) has permissions to edit multiple DNS zones.

You can do this via your Cloudflare profile page, under the [API Tokens section](https://dash.cloudflare.com/profile/api-tokens). When your create the token, under Permissions, select Zone > DNS > Edit, and under Zone Resources, only include the specific DNS zones within which you need to perform ACME DNS challenges.

The API token is a 40-character string that may contain uppercase letters, lowercase letters, numbers, and underscores. You must provide it to acme.sh by setting the environment variable `CF_Token` to its value, e.g. run `export CF_Token="Y_jpG9AnfQmuX5Ss9M_qaNab6SQwme3HWXNDzRWs"`.

#### (i) Single DNS zone

You must give acme.sh the *zone ID* of the DNS zone it needs to edit. This is a 32-character hexadecimal string (e.g. `763eac4f1bcebd8b5c95e9fc50d010b4`), and should not be confused with the *zone name* (e.g. `example.com`). This zone ID can be found via the Cloudflare dashboard, on the zone's Overview page, in the right-hand sidebar.

You provide this info by setting the environment variable `CF_Zone_ID` to this zone ID, e.g. run `export CF_Zone_ID="763eac4f1bcebd8b5c95e9fc50d010b4"`.

#### (ii) Multiple DNS zones

You must give acme.sh the *account ID* of the Cloudflare account to which the relevant DNS zones belong. This is a 32-character hexadecimal string, and should not be confused with other account identifiers, such as the account email address (e.g. `alice@example.com`) or global API key (which is also a 32-character hexadecimal string). This account ID can be found via the Cloudflare dashboard, as the end of the URL when logged in, or on the Overview page of any of your zones, in the right-hand sidebar, beneath the zone ID.

You provide this info by setting the environment variable `CF_Account_ID` to this account ID, e.g. run `export CF_Account_ID="763eac4f1bcebd8b5c95e9fc50d010b4"`.

### (b) Using the global API key

You can get your global API key from your Cloudflare profile page, under the [API tokens section](https://dash.cloudflare.com/profile/api-tokens). Click "View" next to Global API key, verify your Cloudflare password, and it will be revealed to you. It is a 32-character hexadecimal string that you must provide to acme.sh by setting the environment variable `CF_Key` to its value. You must also set `CF_Email` to the email address that is associated with your Cloudflare account; this is the email address you enter when logging in to Cloudflare. For example:

```sh
export CF_Key="763eac4f1bcebd8b5c95e9fc50d010b4"
export CF_Email="alice@example.com"
```

### Getting a certificate

Ok, let's issue a cert now:

```sh
./acme.sh --issue --dns dns_cf -d example.com -d '*.example.com'
```

Any environment variables that were set and used when issuing the certificate will be saved in `~/.acme.sh/account.conf` so that they can be automatically reused in future when issuing new certificates or renewing existing certificates using `dns_cf`.

<a name="dns_dp" />

## 2. DNSPod.cn Option:

The DNSPod.cn Domain API option requires that you first login to your account to get a DNSPod API Key and ID.
> The DNSPod API Key refers to the `DNSPod Token` found under `API Keys` in my account settings on the https://dnspod.cn.

```sh
export DP_Id=<id>
export DP_Key=<key>
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_dp -d example.com -d *.example.com
```

The `DP_Id` and `DP_Key` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


## 3. CloudXNS.com

~~Removed~~


<a name="dns_gd" />

## 4. Use GoDaddy.com domain API to automatically issue cert

Only possible if you have more than 10 domains or a Discount Domain Club subscription! See [Reddit](https://www.reddit.com/r/godaddy/comments/1chs1j8/godaddy_access_denied_via_apicall/) 

First you need to login to your GoDaddy account to get your API Key and Secret.

https://developer.godaddy.com/keys/

Please create a Production key, instead of a Test key.

```sh
export GD_Key="<key>"
export GD_Secret="<secret>"
```

Ok, let's issue a cert now. For GoDaddy, it is recommended that you specify a 600 second dnssleep.
```sh
./acme.sh --issue --dns dns_gd --dnssleep 600 -d example.com -d *.example.com
```

The `GD_Key` and `GD_Secret` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_pdns" />

## 5. Use PowerDNS embedded API to automatically issue cert

First you need to login to your PowerDNS account to enable the API and set your API-Token in the configuration.

https://doc.powerdns.com/md/httpapi/README/

```sh
export PDNS_Url="http://ns.example.com:8081"
export PDNS_ServerId="localhost"
export PDNS_Token="0123456789ABCDEF"
export PDNS_Ttl=60
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_pdns -d example.com -d *.example.com
```

The `PDNS_Url`, `PDNS_ServerId`, `PDNS_Token` and `PDNS_Ttl` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_ovh" />

## 6. Use OVH, Kimsufi, So you Start API to automatically issue cert

See [How to use OVH domain API](https://github.com/acmesh-official/acme.sh/wiki/How-to-use-OVH-domain-api)


<a name="dns_nsupdate" />

## 7. Use nsupdate to automatically issue cert
ncupdate is [RFC 2136 Dynamic DNS Update](https://datatracker.ietf.org/doc/html/rfc2136.html) client.
[Man page](https://bind9.readthedocs.io/en/v9.18.19/manpages.html#nsupdate-dynamic-dns-update-utility)

First, generate a key for updating the zone
```sh
b=$(dnssec-keygen -a hmac-sha512 -b 512 -n USER -K /tmp foo)
cat > /etc/named/keys/update.key <<EOF
key "update" {
    algorithm hmac-sha512;
    secret "$(awk '/^Key/{print $2}' /tmp/$b.private)";
};
EOF
rm -f /tmp/$b.{private,key}
```

Include this key in your named configuration
```sh
include "/etc/named/keys/update.key";
```

Next, configure your zone to allow dynamic updates.

Depending on your named version, use either
```sh
zone "example.com" {
    type master;
    allow-update { key "update"; };
};
```
or
```sh
zone "example.com" {
    type master;
    update-policy {
        grant update subdomain example.com.;
    };
}
```
Notes on BIND 9.16.1-Ubuntu 20.04.3 LTS

```sh
# dnssec-keygen no longer do tsig algorithm, so tsig-keygen (came with bind9)
tsig-keygen -a hmac-sha512 acme | sudo tee /etc/bind/acme.key
# as nsupdate need creation of *.jnl where zone file resides, read /var/log/syslog for error details
sudo chmod g+w /etc/bind
# similar to above steps: include key, allow-update with key on target zone
# echo 'include "/etc/bind/acme.key";' | sudo tee --append /etc/bind/named.conf.local
```

Finally, make the DNS server and update Key available to `acme.sh`

```sh
export NSUPDATE_SERVER="dns.example.com"
export NSUPDATE_KEY="/path/to/your/nsupdate.key"
```
and optionally (depending on DNS server)
```sh
export NSUPDATE_ZONE="example.com"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_nsupdate -d example.com -d *.example.com
```

The `NSUPDATE_SERVER`, `NSUPDATE_KEY`, and `NSUPDATE_ZONE` settings will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_lua" />

## 8. Use LuaDNS domain API

Get your API token at https://api.luadns.com/settings

```sh
export LUA_Key="<key>"
export LUA_Email="youremail@example.com"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_lua -d example.com -d *.example.com
```

The `LUA_Key` and `LUA_Email` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_me" />

## 9. Use DNSMadeEasy domain API

Get your API credentials at https://cp.dnsmadeeasy.com/account/info

```sh
export ME_Key="<key>"
export ME_Secret="<secret>"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_me -d example.com -d *.example.com
```

The `ME_Key` and `ME_Secret` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_aws" />

## 10. Use Amazon Route53 domain API

See [How to use Amazon Route53 API](https://github.com/acmesh-official/acme.sh/wiki/How-to-use-Amazon-Route53-API)

```sh
export  AWS_ACCESS_KEY_ID="<key id>"
export  AWS_SECRET_ACCESS_KEY="<secret>"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_aws -d example.com -d *.example.com
```

If you get an `AWS Route53 rate exceeded` error, you can add a sleep time between api requests:

```sh
export  AWS_DNS_SLOWRATE=1 (sleep between API requests in seconds)
```

The `AWS_ACCESS_KEY_ID`, `AWS_SECRET_ACCESS_KEY` and `AWS_DNS_SLOWRATE` will be saved in `~/.acme.sh/account.conf` and will be reused when needed. The `AWS_DNS_SLOWRATE` will enable the sleep between API requests to AWS servers. It will help to mitigate the AWS rate limit


<a name="dns_ali" />

## 11. Use Aliyun domain API to automatically issue cert

First you need to login to your Aliyun account to get your RAM API key.
[https://ram.console.aliyun.com/users](https://ram.console.aliyun.com/users)

```sh
export Ali_Key="<key>"
export Ali_Secret="<secret>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_ali -d example.com -d *.example.com
```

The `Ali_Key` and `Ali_Secret` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_ispconfig" />

## 12. Use ISPConfig 3.1 API

This only works for ISPConfig 3.1 (and newer).

Create a Remote User in the ISPConfig Control Panel. The Remote User must have access to at least `DNS zone functions`, `DNS txt functions` and `Client functions`.

```sh
export ISPC_User="xxx"
export ISPC_Password="xxx"
export ISPC_Api="https://ispc.domain.tld:8080/remote/json.php"
export ISPC_Api_Insecure=1
```
If you have installed ISPConfig on a different port, then alter the 8080 accordingly.
Leave ISPC_Api_Insecure set to 1 if you have no valid ssl cert for your installation. Change it to 0 if you have a valid ssl cert.

To issue a cert:
```sh
./acme.sh --issue --dns dns_ispconfig -d example.com -d *.example.com
```

The `ISPC_User`, `ISPC_Password`, `ISPC_Api`and `ISPC_Api_Insecure` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_ad" />

## 13. Use Alwaysdata domain API

First you need to login to your Alwaysdata account to get your API Key.

```sh
export AD_API_KEY="<myalwaysdataapikey>"
```

Ok, let's issue a cert now:

```sh
./acme.sh --issue --dns dns_ad -d example.com -d *.example.com
```

The `AD_API_KEY` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_linode_v4" />

## 14. Use Linode domain API

### Cloud Manager ###

Cloud Manager: https://cloud.linode.com/profile/tokens

First you need to login to your Linode account to get your API Key.

1. Click on "Add a Personal Access Token".
2. Give the new key a "Label" (we recommend *ACME*)
3. Give it Read/Write access to "Domains"
4. "Submit" and copy the new key into the `LINODE_V4_API_KEY` command below.

```sh
export LINODE_V4_API_KEY="..."
```

Due to the reload time of any changes in the DNS records, we have to use the
`dnssleep` option to wait at least 15 minutes for the changes to take effect.

Ok, let's issue a cert now:

```sh
./acme.sh --issue --dns dns_linode_v4 -d example.com -d *.example.com --dnssleep 900
```

The `LINODE_V4_API_KEY` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_freedns" />

## 15. Use FreeDNS

[FreeDNS](https://freedns.afraid.org/) does not provide an API to update DNS records (other than IPv4 and IPv6
dynamic DNS addresses).  The acme.sh plugin therefore retrieves and updates domain TXT records by logging
into the FreeDNS website to read the HTML and posting updates as HTTP.  The plugin needs to know your
userid and password for the FreeDNS website.

```sh
export FREEDNS_User="..."
export FREEDNS_Password="..."
```

You need only provide this the first time you run the acme.sh client with FreeDNS validation and then again
whenever you change your password at the FreeDNS site.  The acme.sh FreeDNS plugin does not store your userid
or password but rather saves an authentication token returned by FreeDNS in `~/.acme.sh/account.conf` and
reuses that when needed.

Now you can issue a certificate.

```sh
./acme.sh --issue --dns dns_freedns -d example.com -d *.example.com
```

Note that you cannot use acme.sh automatic DNS validation for FreeDNS public domains or for a subdomain that
you create under a FreeDNS public domain.  You must own the top level domain in order to automatically
validate with acme.sh at FreeDNS.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2305)


<a name="dns_cyon" />

## 16. Use cyon.ch

You only need to set your cyon.ch login credentials.
If you also have 2 Factor Authentication (OTP) enabled, you need to set your secret token too and have `oathtool` installed.

```sh
export CY_Username="your_cyon_username"
export CY_Password="your_cyon_password"
export CY_OTP_Secret="your_otp_secret" # Only required if using 2FA
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_cyon -d example.com -d *.example.com
```

The `CY_Username`, `CY_Password` and `CY_OTP_Secret` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


## 17. Use Domain-Offensive/Resellerinterface/Domainrobot API

~~Removed~~  
See [60. Use do.de API](#dns_doapi) instead


<a name="dns_gandi_livedns" />

## 18. Use Gandi LiveDNS API

You must enable the new Gandi LiveDNS API first and then create your Personal Access Token (PAT) or api key (deprecated), See: https://api.gandi.net/docs/livedns/ and https://docs.gandi.net/en/managing_an_organization/organizations/personal_access_token.html

```sh
export GANDI_LIVEDNS_TOKEN="<key>"
```

or (deprecated): 

```sh
export GANDI_LIVEDNS_KEY="<key>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_gandi_livedns -d example.com -d *.example.com
```


<a name="dns_knot" />

## 19. Use Knot (knsupdate) DNS API to automatically issue cert

First, generate a TSIG key for updating the zone.

```sh
keymgr tsig generate -t acme_key hmac-sha512 > /etc/knot/acme.key
```

Include this key in your knot configuration file.

```sh
include: /etc/knot/acme.key
```

Next, configure your zone to allow dynamic updates.

Dynamic updates for the zone are allowed via proper ACL rule with the `update` action.
For in-depth instructions, please see [Knot DNS's documentation](https://www.knot-dns.cz/documentation/).

```sh
acl:
  - id: acme_acl
    address: 192.168.1.0/24
    key: acme_key
    action: update

zone:
  - domain: example.com
    file: example.com.zone
    acl: acme_acl
```

Finally, make the DNS server and TSIG Key available to `acme.sh`

```sh
export KNOT_SERVER='dns.example.com'
export KNOT_KEY='/etc/knot/acme.key'
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_knot -d example.com -d *.example.com
```

The `KNOT_SERVER` and `KNOT_KEY` settings will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_dgon" />

## 20. Use DigitalOcean API (native)

You need to obtain a read and write capable API key from your DigitalOcean account. See: https://www.digitalocean.com/help/api/

```sh
export DO_API_KEY="<key>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_dgon -d example.com -d *.example.com
```


<a name="dns_cloudns" />

## 21. Use ClouDNS.net API

You need to set the HTTP API user ID and password credentials. See: https://www.cloudns.net/wiki/article/42/.
For security reasons, it's recommended to use a sub user ID that only has access to the necessary zones, as a regular API user has access to your entire account.

```sh
# Use this for a sub auth ID
export CLOUDNS_SUB_AUTH_ID="<Auth ID>"
# Use this for a regular auth ID
#export CLOUDNS_AUTH_ID="Auth ID"
export CLOUDNS_AUTH_PASSWORD="<password>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_cloudns -d example.com -d *.example.com
```
The `CLOUDNS_AUTH_ID` and `CLOUDNS_AUTH_PASSWORD` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_infoblox" />

## 22. Use Infoblox API

First you need to create/obtain API credentials on your Infoblox appliance.

```sh
export Infoblox_Creds="username:password"
export Infoblox_Server="ip or fqdn of infoblox appliance"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_infoblox -d example.com -d *.example.com
```

Note: This script will automatically create and delete the ephemeral txt record.
The `Infoblox_Creds` and `Infoblox_Server` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_vscale" />

## 23. Use VSCALE API

First you need to create/obtain API tokens on your [settings panel](https://vscale.io/panel/settings/tokens/).

```sh
export VSCALE_API_KEY="<api key>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_vscale -d example.com -d *.example.com
```


<a name="dns_dynu" />

##  24. Use Dynu API

First you need to create/obtain API credentials from your Dynu account. See: https://www.dynu.com/resources/api/documentation

```sh
export Dynu_ClientId="<client id>"
export Dynu_Secret="<secret>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_dynu -d example.com -d *.example.com
```

The `Dynu_ClientId` and `Dynu_Secret` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_dnsimple" />

## 25. Use DNSimple API

First you need to login to your [DNSimple.com](https://dnsimple.com) account and generate a new oauth token.

`https://dnsimple.com/a/{your account id}/account/automation`

**Note:** This is an _account_ token and not a user token.
The account token is needed to infer the `account_id` used in requests.

A user token will not be able to determine the correct account to use.
You may check tokens at https://dnsimple.com/a/<your account id>/account/access_tokens

```sh
export DNSimple_OAUTH_TOKEN="<token>"
```

To issue the cert just specify the `dns_dnsimple` API.

```sh
./acme.sh --issue --dns dns_dnsimple -d example.com -d *.example.com
```

The `DNSimple_OAUTH_TOKEN` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/pho3nixf1re/acme.sh/issues)


<a name="dns_nsone" />

## 26. Use NS1.com API

```sh
export NS1_Key="<key>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_nsone -d example.com -d *.example.com
```


<a name="dns_duckdns" />

## 27. Use DuckDNS.org API

[DuckDNS.org](https://www.duckdns.org/) is a popular free DDNS provider.
You can get your own subdomain like `mydomain.duckdns.org`.

To configure it visit the DuckDNS and get your API token:

```sh
export DuckDNS_Token="<token>"
```

Ok, let's issue a cert now:
```
acme.sh --issue --dns dns_duckdns -d mydomain.duckdns.org
```


<a name="dns_namecom" />

## 28. Use Name.com API

Create your API token here: https://www.name.com/account/settings/api

Note: `Namecom_Username` should be your Name.com username and not the token name.  If you accidentally run the script with the token name as the username see `~/.acme.sh/account.conf` to fix the issue

```sh
export Namecom_Username="<youruser>"
export Namecom_Token="<token>"
```

And now you can issue certs with:

```sh
./acme.sh --issue --dns dns_namecom -d example.com -d *.example.com
```
If you had Two-step Authentication enabled, make sure to change your security setting, read this guide for help: [Using API with Two-step Authentication](https://www.name.com/support/articles/360007989433-Using-API-with-Two-step-Authentication)

Report any bugs or issues [here](https://github.com/raidenii/acme.sh/issues)


<a name="dns_dyn" />

## 29. Use Dyn Managed DNS API to automatically issue cert

First, login to your Dyn Managed DNS account: https://portal.dynect.net/login/

It is recommended to add a new user specific for API access.

The minimum "Zones & Records Permissions" required are:
```
RecordAdd
RecordUpdate
RecordDelete
RecordGet
ZoneGet
ZoneAddNode
ZoneRemoveNode
ZonePublish
```

Pass the API user credentials to the environment:
```sh
export DYN_Customer="<customer>"
export DYN_Username="<apiuser>"
export DYN_Password="<secret>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_dyn -d example.com -d *.example.com
```

The `DYN_Customer`, `DYN_Username` and `DYN_Password` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_yandex" />

## 30. Use pdd.yandex.ru API

[The Yandex DNS API is no longer supported.](https://github.com/acmesh-official/acme.sh/issues/4555)

pdd.yandex.ru API was discontinued and superseded by the Yandex 360 for Business DNS API.

[How to use the Yandex 360 for Business DNS API](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_yandex360)

<a name="dns_he" />

## 31. Use Hurricane Electric

[Hurricane Electric he.net](https://dns.he.net/) doesn't have an API so just set your login credentials like so:

```sh
export HE_Username="<yourusername>"
export HE_Password="<password>"
```

Then you can issue your certificate:

```sh
./acme.sh --issue --dns dns_he -d example.com -d *.example.com
```

The `HE_Username` and `HE_Password` settings will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/angel333/acme.sh) or to <me@ondrejsimek.com>.


## 32. Use UnoEuro API to automatically issue cert
**UPD** The UnoEuro is now [Simply.com](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2#dns_simply)


<a name="dns_inwx" />

## 33. Use INWX

[INWX.de](https://www.inwx.de/) offers a [xmlrpc api](https://www.inwx.de/de/help/apidoc)  with your standard login credentials, set them like so:

```sh
export INWX_User="<yourusername>"
export INWX_Password="<password>"
```

Then you can issue your certificates with:

```sh
./acme.sh --issue --dns dns_inwx -d example.com -d *.example.com
```

The `INWX_User` and `INWX_Password` settings will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

If your account is secured by mobile tan you have also defined the shared secret.

```sh
export INWX_Shared_Secret="<shared secret>"
```

You may need to re-enable the mobile tan to gain the shared secret.


<a name="dns_servercow" />

## 34. User Servercow API v1

Create a new user from the Servercow control center. Don't forget to activate **DNS API** for this user.

```sh
export SERVERCOW_API_Username="<username>"
export SERVERCOW_API_Password="<password>"
```

Now you cann issue a cert:

```sh
./acme.sh --issue --dns dns_servercow -d example.com -d *.example.com
```
Both, `SERVERCOW_API_Username` and `SERVERCOW_API_Password` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_namesilo" />

## 35. Use Namesilo.com API

You'll need to generate an API key at https://www.namesilo.com/account/api-manager
Optionally you may restrict the access to an IP range there.

```sh
export Namesilo_Key="<key>"
```

And now you can issue certs with:

```sh
./acme.sh --issue --dns dns_namesilo -d example.com -d *.example.com --dnssleep 900
```

<a name="dns_autodns" />

## 36. Use autoDNS (InternetX)

[InternetX](https://www.internetx.com/) offers a [xml api](https://help.internetx.com/display/API/AutoDNS+XML-API)  with your standard login credentials, set them like so:

```sh
export AUTODNS_USER="yourusername"
export AUTODNS_PASSWORD="password"
export AUTODNS_CONTEXT="context"
```

Then you can issue your certificates with:

```sh
./acme.sh --issue --dns dns_autodns -d example.com -d *.example.com
```

The `AUTODNS_USER`, `AUTODNS_PASSWORD` and `AUTODNS_CONTEXT` settings will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_azure" />

## 37. Use Azure DNS

You have three options with Azure DNS:
1. Create and use a Service Principal with client secrets (recommended)
2. Using a Managed Identity (has to run on a resource in Azure)
3. Use a provided Bearer token (advanced scenarios only, the Bearer token has a limited lifetime) 

### Use Service Principal 
You have to create a service principal first. See: [How to use Azure DNS](https://github.com/acmesh-official/acme.sh/wiki/How-to-use-Azure-DNS)

```sh
export AZUREDNS_SUBSCRIPTIONID="<SUBSCRIPTIONID>"
export AZUREDNS_TENANTID="<TENANTID>"
export AZUREDNS_APPID="<APPID>"
export AZUREDNS_CLIENTSECRET="<CLIENTSECRET>"
```

Then you can issue your certificates with:

```sh
./acme.sh --issue --dns dns_azure -d example.com -d *.example.com
```

`AZUREDNS_SUBSCRIPTIONID`, `AZUREDNS_TENANTID`,`AZUREDNS_APPID` and `AZUREDNS_CLIENTSECRET` settings will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

### Use Managed Identity
You have to assign a managed identity to your resource, usually a VM, as described [here](https://docs.microsoft.com/en-us/azure/active-directory/managed-identities-azure-resources/overview).
This identity requires [DNS Zone Contributor role](https://docs.microsoft.com/en-us/azure/role-based-access-control/built-in-roles#dns-zone-contributor).

Before running acme.sh following variables need to be set:
`export AZUREDNS_SUBSCRIPTIONID="12345678-9abc-def0-1234-567890abcdef"`
`export AZUREDNS_MANAGEDIDENTITY=true`

Issuing certificates using managed identity clears previously set settings: `AZUREDNS_TENANTID`, `AZUREDNS_APPID`, `AZUREDNS_CLIENTSECRET`.
`AZUREDNS_SUBSCRIPTIONID` and `AZUREDNS_MANAGEDIDENTITY` will be saved in ~/.acme.sh/account.conf for future use.

### Use provided Bearer token
If you want to use Entra Workload ID in a GitHub Action or similar CI/CD scenarios, you have to use a provided Bearer token.

The identity has to have Azure RBAC to be able to add and delete TXT records in the Azure DNS zone.

You need to extract the token earlier in your CI/CD, for example with this command:
```sh 
az account get-access-token --query accessToken --output tsv
```
And then pass it to acme.sh with the environment variable `AZUREDNS_BEARERTOKEN`:
```sh
export AZUREDNS_BEARERTOKEN="<BEARER TOKEN>"
```

Finally, you need to set the tenant ID and subscription ID in the environment variables `AZUREDNS_TENANTID` and `AZUREDNS_SUBSCRIPTIONID`:
```sh
export AZUREDNS_SUBSCRIPTIONID="<SUBSCRIPTIONID>"
export AZUREDNS_TENANTID="<TENANTID>"
```

Then you can issue the certificate with acme.sh, for example:
```sh
./acme.sh --issue --dns dns_azure -d example.com -d *.example.com
```

<a name="dns_selectel" />

## 38. Use selectel.com(selectel.ru) domain API to automatically issue cert
The provider currently supports two API versions: v1 (legacy) and v2 (actual).
Legacy version is supported in a limited way and will be disabled from 09.2025.

The module supports both API versions.

The **SL_Ver** variable is used to determine the API version,
the value must be either 'v1' or 'v2'. By default, 'v1'.

**_For old installations using the API version 'v1' (legacy), everything remains the same:_**

First you need to login to your account to get your API key from: https://my.selectel.ru/profile/apikeys.

```sh
export SL_Key="<key>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_selectel -d example.com -d *.example.com
```

The `SL_Key` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

**_If you are using API version 'v2' (actual), you need to define the following variables:_**

```sh
export SL_Ver=v2                        # version API
export SL_Expire=60                     # token lifetime in minutes (0-1440). Default: 1400 minutes
export SL_Login_ID=<account_id>         # account number
export SL_Project_Name=<project_name>   # project name
export SL_Login_Name=<login_name>       # service user name
export SL_Pswd=<pswd>                   # user password
```

The account number in the control panel can be seen in the upper right corner on the provider's website

The service user name can be seen in the control panel: https://my.selectel.ru/iam/users_management/users?type=service

The user password can only be viewed when creating a user, or only changed to a new one.

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_selectel -d example.com -d *.example.com
```


<a name="dns_zonomi" />

## 39. Use zonomi.com domain API to automatically issue cert

First you need to login to your account to find your API key from: http://zonomi.com/app/dns/dyndns.jsp

Your will find your api key in the example urls:

```sh
https://zonomi.com/app/dns/dyndns.jsp?host=example.com&api_key=1063364558943540954358668888888888
```

```sh
export ZM_Key="<key>"

```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_zonomi -d example.com -d *.example.com
```

The `ZM_Key` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_dreamhost" />

## 40. Use DreamHost DNS API

DNS API keys may be created at https://panel.dreamhost.com/?tree=home.api.
Ensure the created key has `add` and `remove` privileges.

```sh
export DH_API_KEY="<api key>"
./acme.sh --issue --dns dns_dreamhost -d example.com -d *.example.com
```

The `DH_API_KEY` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_da" />

## 41. Use DirectAdmin API
The DirectAdmin interface has its own Let's encrypt functionality, but this
script can be used to generate certificates for names which are not hosted on DirectAdmin.

User must provide login data and URL to the DirectAdmin incl. port.
You can create a user which only has access to

- CMD_API_DNS_CONTROL
- CMD_API_SHOW_DOMAINS

By using the Login Keys function.
See also https://www.directadmin.com/api.php and https://www.directadmin.com/features.php?id=1298

```sh
export DA_Api="https://remoteUser:remotePassword@da.domain.tld:8443"
export DA_Api_Insecure=1
```
Set `DA_Api_Insecure` to 1 for insecure and 0 for secure -> difference is whether ssl cert is checked for validity (0) or whether it is just accepted (1)

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_da -d example.com -d *.example.com
```

The `DA_Api` and `DA_Api_Insecure` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_zilore" />

## 42. Use KingHost DNS API

API access must be enabled at https://painel.kinghost.com.br/painel.api.php

```sh
export KINGHOST_Username="yourusername"
export KINGHOST_Password="yourpassword"
./acme.sh --issue --dns dns_kinghost -d example.com -d *.example.com
```

The `KINGHOST_username` and `KINGHOST_Password` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_zilore" />

## 43. Use Zilore DNS API

First, get your API key at https://my.zilore.com/account/api

```sh
export Zilore_Key="<key>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_zilore -d example.com -d *.example.com
```

The `Zilore_Key` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_loopia" />

## 44. Use Loopia API

User must provide login credentials to the Loopia API.
The user needs the following permissions:

- getDomains
- getSubdomains
- addSubdomain
- removeSubdomain
- getZoneRecords
- addZoneRecord

Set the API endpoint:

```sh
export LOOPIA_Api="https://api.loopia.<TLD>/RPCSERV"
```

Depending on your hosting location, `<TLD>` is one of: `com`, `no`,
`rs`, `se`. The default endpoint is `se` TLD.

Set the login credentials:

```sh
export LOOPIA_User="user@loopiaapi"
export LOOPIA_Password="password"
```

And to issue a cert run:

```sh
./acme.sh --issue --dns dns_loopia -d example.com -d *.example.com
```

The exported variables will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_acmedns" />

## 45. Use ACME DNS API

ACME DNS is a limited DNS server with RESTful HTTP API to handle ACME DNS challenges easily and securely.
https://github.com/joohoi/acme-dns

```sh
# Usage:
# export ACMEDNS_BASE_URL="https://auth.acme-dns.io"
#
# You can optionally define an already existing account:
#
# export ACMEDNS_USERNAME="<username>"
# export ACMEDNS_PASSWORD="<password>"
# export ACMEDNS_SUBDOMAIN="<subdomain>"

./acme.sh --issue --dns dns_acmedns -d example.com -d *.example.com
```

The credentials will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Note:
There's another acme-dns client, whih is not shell only, but supports multi-domain and multiple acme-dns server with a single certificate.
If Python is no issue for acme.sh setup, the have a look at https://github.com/maddes-b/acme-dns-client-2

<a name="dns_tele3" />

## 46. Use TELE3 API

First you need to login to your TELE3 account to set your API-KEY.
https://www.tele3.cz/system-acme-api.html

```sh
export TELE3_Key="<key>"
export TELE3_Secret="<secret>"

./acme.sh --issue --dns dns_tele3 -d example.com -d *.example.com
```

The TELE3_Key and TELE3_Secret will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_euserv" />

## 47. Use EUserv.eu API

First you need to login to your euserv.eu account and activate your API Administration (API Verwaltung).
[https://support.euserv.com](https://support.euserv.com)

Once you've activated, login to your API Admin Interface and create an API account.
Please specify the scope (active groups: domain) and assign the allowed IPs.

```sh
export EUSERV_Username="99999.user123"
export EUSERV_Password="<password>"
```

Ok, let's issue a cert now: (Be aware to use the `--insecure` flag, because the euserv.eu is still using self-signed certificates!)
```sh
./acme.sh --issue --dns dns_euserv -d example.com -d *.example.com --insecure
```

The `EUSERV_Username` and `EUSERV_Password` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues to <github@initit.de>


<a name="dns_dpi" />

## 48. Use DNSPod.com domain API to automatically issue cert

First you need to get your API Key and ID by this [get-the-user-token](https://www.dnspod.com/docs/info.html#get-the-user-token).

```sh
export DPI_Id="<id>"
export DPI_Key="<key>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_dpi -d example.com -d *.example.com
```

The `DPI_Id` and `DPI_Key` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_gcloud" />

## 49. Use Google Cloud DNS API to automatically issue cert

First you need to authenticate to gcloud.

```
gcloud init
```

**The `dns_gcloud` script uses the active gcloud configuration and credentials.**
There is no logic inside `dns_gcloud` to override the project and other settings.
If needed, create additional [gcloud configurations](https://cloud.google.com/sdk/gcloud/reference/topic/configurations).
You can change the configuration being used without *activating* it; simply set the `CLOUDSDK_ACTIVE_CONFIG_NAME` environment variable.

To issue a certificate you can:
```sh
export CLOUDSDK_ACTIVE_CONFIG_NAME=default  # see the note above
./acme.sh --issue --dns dns_gcloud -d example.com -d *.example.com
```

`dns_gcloud` also supports [DNS alias mode](https://github.com/acmesh-official/acme.sh/wiki/DNS-alias-mode).


<a name="dns_conoha" />

## 50. Use ConoHa API

First you need to login to your ConoHa account to get your API credentials.

```sh
export CONOHA_Username="xxxxxx"
export CONOHA_Password="xxxxxx"
export CONOHA_TenantId="xxxxxx"
export CONOHA_IdentityServiceApi="https://identity.xxxx.conoha.io/v2.0"
```

To issue a cert:
```sh
./acme.sh --issue --dns dns_conoha -d example.com -d *.example.com
```

The `CONOHA_Username`, `CONOHA_Password`, `CONOHA_TenantId` and `CONOHA_IdentityServiceApi` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_netcup" />

## 51. Use netcup DNS API to automatically issue cert

First you need to login in your CCP account to get your API Key and API Password.
```sh
export NC_Apikey="<Apikey>"
export NC_Apipw="<Apipassword>"
export NC_CID="<Customernumber>"
```

Now, let's issue a cert:
```sh
./acme.sh --issue --dns dns_netcup -d example.com -d *.example.com
```

The `NC_Apikey`,`NC_Apipw` and `NC_CID` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


## 52. Use GratisDNS.dk

[Removed](https://github.com/acmesh-official/acme.sh/pull/4049)


<a name="dns_namecheap" />

## 53. Use Namecheap

You will need your namecheap username, API KEY (https://www.namecheap.com/support/api/intro.aspx) and your
external IP address (or a URL to get it), this IP will need to be whitelisted at Namecheap.
Due to Namecheap's API limitation all the records of your domain will be read and re applied,
make sure to have a backup of your records you could apply if any issue would arise.

```sh
export NAMECHEAP_USERNAME="..."
export NAMECHEAP_API_KEY="..."
export NAMECHEAP_SOURCEIP="..."
```

The `NAMECHEAP_SOURCEIP` can either be an IP address or a URL to provide it (e.g. https://ifconfig.co/ip).

The username and password will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Now you can issue a certificate.

```sh
./acme.sh --issue --dns dns_namecheap -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2107)


<a name="dns_mydnsjp" />

## 54. Use MyDNS.JP API

First, register to MyDNS.JP and get MasterID and Password.

```sh
export MYDNSJP_MasterID="<MasterID>"
export MYDNSJP_Password="<Password>"
```

To issue a certificate:

```sh
./acme.sh --issue --dns dns_mydnsjp -d example.com -d *.example.com
```
The `MYDNSJP_MasterID` and `MYDNSJP_Password` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_hostingde" />

## 55. Use hosting.de API

Create an API key in your hosting.de account here: https://secure.hosting.de

The key needs the following rights:
- DNS_ZONES_EDIT
- DNS_ZONES_LIST

Set your API Key and endpoint:

```sh
export HOSTINGDE_APIKEY='xxx'
export HOSTINGDE_ENDPOINT='https://secure.hosting.de'
```

The plugin can also be used for the http.net API. http.net customers have to set endpoint to https://partner.http.net.

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_hostingde -d example.com -d *.example.com
```

The hosting.de API key and endpoint will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2058)


<a name="dns_neodigit" />

## 56. Use Neodigit.net API

```sh
export NEODIGIT_API_TOKEN="<token>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_neodigit -d example.com -d *.example.com
```

Neodigit API Token will be saved in `~/.acme.sh/account.conf` and will be used when needed.


<a name="dns_exoscale" />

## 57. Use Exoscale API

Create an API key and secret key in the Exoscale account section

Set your API and secret key:

```sh
export EXOSCALE_API_KEY='<api key>'
export EXOSCALE_SECRET_KEY='<secret key>'
```

Now, let's issue a cert:
```sh
./acme.sh --issue --dns dns_exoscale -d example.com -d *.example.com
```

The `EXOSCALE_API_KEY` and `EXOSCALE_SECRET_KEY` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


<a name="dns_pointhq" />

## 58. Using PointHQ API to issue certs

Log into [PointHQ account management](https://app.pointhq.com/profile) and copy the API key from the page there.

```
export PointHQ_Key="apikeystringgoeshere"
exportPointHQ_Email="accountemail@yourdomain.com"
```

You can then issue certs by using:
```
./acme.sh --issue --dns dns_pointhq -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2060)


<a name="dns_active24" />

## 59. Use Active24 API

Create API credentials in the Active24 Admin [Security and login/API Authentication & Dynamic DNS](https://admin.active24.cz/en/auth/security-settings)

Set your API credntials:

```sh
export Active24_ApiKey='<Identifier>'
export Active24_ApiSecret='<Secret>'
```

Now, let's issue a cert, set `dnssleep` for propagation new DNS record:
```sh
./acme.sh --issue --dns dns_active24 -d example.com -d *.example.com --dnssleep 120
```
`120` is usually fine, had success with even lower values like `60`

`Active24_ApiKey` and `Active24_ApiSecret` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2059)


<a name="dns_doapi" />

## 60. Use do.de API

Create an API token in your do.de account ([Create token here](https://www.do.de/account/letsencrypt/) | [Documentation](https://www.do.de/wiki/LetsEncrypt_-_Entwickler)).

Set your API token:
```sh
export DO_LETOKEN="<token>"
```

To issue a certificate run:
```sh
./acme.sh --issue --dns dns_doapi -d example.com -d *.example.com
```

The API token will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2057)


<a name="dns_nw" />

## 61. Use Nexcess API

First, you'll need to login to the [Nexcess.net Client Portal](https://portal.nexcess.net) and [generate a new API token](https://portal.nexcess.net/api-token).

Once you have a token, set it in your system's environment:

```sh
export NW_API_TOKEN="YOUR_TOKEN_HERE"
export NW_API_ENDPOINT="https://portal.nexcess.net"
```

Finally, we'll issue the certificate: (Nexcess DNS publishes at max every 15 minutes, we recommend setting a 900 second `--dnssleep`)

```sh
./acme.sh --issue --dns dns_nw -d example.com -d *.example.com --dnssleep 900
```

The `NW_API_TOKEN` and `NW_API_ENDPOINT` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2088)


<a name="dns_nw" />

## 62. Use Thermo.io API

First, you'll need to login to the [Thermo.io Client Portal](https://core.thermo.io) and [generate a new API token](https://core.thermo.io/api-token).

Once you have a token, set it in your system's environment:

```sh
export NW_API_TOKEN="YOUR_TOKEN_HERE"
export NW_API_ENDPOINT="https://core.thermo.io"
```

Finally, we'll issue the certificate: (Thermo DNS publishes at max every 15 minutes, we recommend setting a 900 second `--dnssleep`)

```sh
./acme.sh --issue --dns dns_nw -d example.com -d *.example.com --dnssleep 900
```

The `NW_API_TOKEN` and `NW_API_ENDPOINT` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2088)


<a name="dns_nw" />

## 63. Use Futurehosting API

First, you'll need to login to the [Futurehosting Client Portal](https://my.futurehosting.com) and [generate a new API token](https://my.futurehosting.com/api-token).

Once you have a token, set it in your system's environment:

```sh
export NW_API_TOKEN="<YOUR_TOKEN_HERE>"
export NW_API_ENDPOINT="https://my.futurehosting.com"
```

Finally, we'll issue the certificate: (Futurehosting DNS publishes at max every 15 minutes, we recommend setting a 900 second `--dnssleep`)

```sh
./acme.sh --issue --dns dns_nw -d example.com -d *.example.com --dnssleep 900
```

The `NW_API_TOKEN` and `NW_API_ENDPOINT` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2088)


<a name="dns_rackspace" />

## 64. Use Rackspace API

Set username and API key, which is available under "My Profile & Settings"

```sh
export RACKSPACE_Username="<username>"
export RACKSPACE_Apikey="<key>"
```

Now, let's issue a cert:

```sh
./acme.sh --issue --dns dns_rackspace -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2091)


<a name="dns_online" />

## 65. Use Online API
**Note:** the online.net was renamed to scaleway.com and is the same as one.com

First, you'll need to retrieve your online.net API key, which is available under https://console.online.net/en/api/access

```sh
export ONLINE_API_KEY='<key>'
```

To issue a cert run:

```sh
./acme.sh --issue --dns dns_online -d example.com -d *.example.com
```

`ONLINE_API_KEY` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2093)


<a name="dns_mydevil" />

## 66. Use MyDevil.net

Make sure that you can execute own binaries:

```sh
devil binexec on
```

Install acme.sh, or simply `git clone` it into some directory on your MyDevil host account
(in which case you should link to it from your `~/bin` directory).

If you're not using private IP and depend on default IP provided by host, you may want to edit `crontab` too,
and make sure that `acme.sh --cron` is run also after reboot (you can find out how to do that on their wiki pages).

To issue a new certificate, run:

```sh
./acme.sh --issue --dns dns_mydevil -d example.com -d *.example.com
```

After certificate is ready, you can install it with [deploy command](https://github.com/acmesh-official/acme.sh/wiki/deployhooks#14-deploy-your-cert-on-mydevilnet).

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2079)


<a name="dns_cn" />

## 67. Use Core-Networks API to automatically issue cert

First you need to login to your Core-Networks.de account to set up an API-User.
Then export username and password to use these credentials.

```sh
export CN_User="<user>"
export CN_Password="<password>"
```

Ok, let's issue a cert now:
```sh
./acme.sh --issue --dns dns_cn -d example.com -d *.example.com
```

The `CN_User` and `CN_Password` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2142)


<a name="dns_nederhost" />

## 68. Use NederHost API

Create an API token in Mijn NederHost.

Set your API key:
```sh
export NederHost_Key='xxx'
```

To issue a certificate run:
```sh
./acme.sh --issue --dns dns_nederhost -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2089)


<a name="dns_zone" />

## 69. Use Zone.ee DNS API

First, you'll need to retrieve your API key. Estonian instructions https://help.zone.eu/kb/zoneid-api-v2/

```sh
export ZONE_Username=yourusername
export ZONE_Key=keygoeshere
```

To issue a cert run:

```sh
./acme.sh --issue --dns dns_zone -d example.com -d *.example.com
```

`ZONE_Username` and `ZONE_Key` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2146)


<a name="dns_ultra" />

## 70. Use UltraDNS API

UltraDNS is a paid for service that provides DNS, as well as Web and Mail forwarding (as well as reporting, auditing, and advanced tools).

More information can be found here: https://www.security.neustar/lp/ultra20/index.html

The REST API documentation for this service is found here: https://portal.ultradns.com/static/docs/REST-API_User_Guide.pdf

Set your UltraDNS username, and password; these would be the same you would use here:

https://portal.ultradns.com/ - or if you create an API only user, that username and password would be better utilized.

```sh
export ULTRA_USR="<username>"
export ULTRA_PWD="<password>"
```
To issue a cert run:
```sh
./acme.sh --issue --dns dns_ultra -d example.com -d *.example.com
```

`ULTRA_USR` and `ULTRA_PWD` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2118)


<a name="dns_desec" />

## 71. Use deSEC.io

Sign up for deSEC.io dynDNS at https://desec.io first.

Set your API token (password) by generating one from your account on desec.io.
It's also a good idea to restrict the IPv4 / IPv6 address(es) it can be used from.

```sh
export DEDYN_TOKEN="<token>"
```
To issue a certificate run:
```sh
./acme.sh --issue --dns dns_desec -d foobar.dedyn.io -d *.foobar.dedyn.io
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2180)


<a name="dns_openprovider" />

## 72. Use OpenProvider API

First, you need to enable API access and retrieve your password hash on https://rcp.openprovider.eu/account/dashboard.php

```sh
export OPENPROVIDER_USER="<username>"
export OPENPROVIDER_PASSWORDHASH="<hash>"

./acme.sh --issue --dns dns_openprovider -d example.com -d *.example.com
```

`OPENPROVIDER_USER` and `OPENPROVIDER_PASSWORDHASH` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2104)


<a name="dns_maradns" />

## 73. Use MaraDNS API

Make sure you've configured MaraDNS properly and set up a zone file for your domain.
See [`csv2(5)`](https://manpages.debian.org/stretch/maradns/csv2.5.en.html).

Set the path to your zone file, and path to duende's pid file.
See, [`duende(8)`](https://manpages.debian.org/stretch/duende/duende.8.en.html) or `ps -C duende o pid,cmd`).
The pid file is used to ask duende to reload the configuration automatically after DNS records are added.
```sh
export MARA_ZONE_FILE="/etc/maradns/db.domain.com"
export MARA_DUENDE_PID_PATH="/run/maradns/etc_maradns_mararc.pid"
```

Ensure that the acme.sh process has write access to the zone file and read access to the pid file.

Issuing a certificate:
```sh
./acme.sh --issue --dns dns_maradns -d example.com -d *.example.com
```

`MARA_ZONE_FILE` and `MARA_DUENDE_PID_PATH` will be saved in `~/.acme.sh/account.conf` and will be reused when needed.


Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2072)


<a name="dns_hetzner" />

## 74. Use Hetzner API

Get the API Token:
Use [dnsConsole](https://dns.hetzner.com/) to create your hetzner api token.

Issuing a certificate (using LetsEncrypt):
```sh
export HETZNER_Token="<token>" 
./acme.sh --issue --dns dns_hetzner -d example.com -d *.example.com --server letsencrypt
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2943)


<a name="dns_ddnss" />

## 75. Use DDNSS.de API

First create an account at https://ddnss.de. After that create a new host record.
In the definition for the host make sure to set the checkbox for "Wildcard" and for "TXT".

Note your Api Key (aka "Update Key") displayed at ddnss.de and export in DDNSS_Token variable
```sh
export DDNSS_Token="<token>"
```
**Note: Every Cert needs it own Update Key, if you already use the Update Key please generate a new one and export to DDNSS_Token before issue a new Cert. **


After that you can issue a new certificate:
```sh
./acme.sh --issue --dns dns_ddnss -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2230)


<a name="dns_nsd" />

## 76. Use NLnetLabs NSD

You need to export two variables. Your zonefile which the script will automatically edit:
```sh
export Nsd_ZoneFile="/etc/nsd/zones/example.com.zone"
```
And something that calls the nsd-control reload command, either via a script:
```sh
export Nsd_Command="/usr/local/bin/sign-and-update.sh example.com"
```
or directly:
```sh
export Nsd_Command="sudo nsd-control reload example.com"
```
The variables are saved per-domain, not per-account.

To issue a new certificate, run:
```sh
./acme.sh --issue --dns dns_nsd -d example.com -d *.example.com
```

Report any bugs or issues [here](https://github.com/acmesh-official/acme.sh/issues/2245)


-----------------------------------

**[More APIs see here...](https://github.com/acmesh-official/acme.sh/wiki/dnsapi2)**
