/*
	OSMesa LDG loader

	Copyright (C) 2004	Patrice Mandin

	This software is provided 'as-is', without any express or implied
	warranty.  In no event will the authors be held liable for any damages
	arising from the use of this software.

	Permission is granted to anyone to use this software for any purpose,
	including commercial applications, and to alter it and redistribute it
	freely, subject to the following restrictions:

	1. The origin of this software must not be misrepresented; you must not
	   claim that you wrote the original software. If you use this software
	   in a product, an acknowledgment in the product documentation would be
	   appreciated but is not required.
	2. Altered source versions must be plainly marked as such, and must not be
	   misrepresented as being the original software.
	3. This notice may not be removed or altered from any source distribution.
*/

/*--- Includes ---*/

#include <GL/gl.h>

#include "lib-osmesa.h"
#include "nfosmesa_nfapi.h"

/* Generated by lib-gen.pl from /usr/local/include/GL/glext.h */

void APIENTRY glBlendColor (GLclampf a, GLclampf b, GLclampf c, GLclampf d)
{
	(*HostCall_p)(NFOSMESA_GLBLENDCOLOR,cur_context,&a);
}

void APIENTRY glBlendEquation (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLBLENDEQUATION,cur_context,&a);
}

void APIENTRY glDrawRangeElements (GLenum a, GLuint b, GLuint c, GLsizei d, GLenum e, const GLvoid * f)
{
	(*HostCall_p)(NFOSMESA_GLDRAWRANGEELEMENTS,cur_context,&a);
}

void APIENTRY glColorTable (GLenum a, GLenum b, GLsizei c, GLenum d, GLenum e, const GLvoid * f)
{
	(*HostCall_p)(NFOSMESA_GLCOLORTABLE,cur_context,&a);
}

void APIENTRY glColorTableParameterfv (GLenum a, GLenum b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLCOLORTABLEPARAMETERFV,cur_context,&a);
}

void APIENTRY glColorTableParameteriv (GLenum a, GLenum b, const GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLCOLORTABLEPARAMETERIV,cur_context,&a);
}

void APIENTRY glCopyColorTable (GLenum a, GLenum b, GLint c, GLint d, GLsizei e)
{
	(*HostCall_p)(NFOSMESA_GLCOPYCOLORTABLE,cur_context,&a);
}

void APIENTRY glGetColorTable (GLenum a, GLenum b, GLenum c, GLvoid * d)
{
	(*HostCall_p)(NFOSMESA_GLGETCOLORTABLE,cur_context,&a);
}

void APIENTRY glGetColorTableParameterfv (GLenum a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETCOLORTABLEPARAMETERFV,cur_context,&a);
}

void APIENTRY glGetColorTableParameteriv (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETCOLORTABLEPARAMETERIV,cur_context,&a);
}

void APIENTRY glColorSubTable (GLenum a, GLsizei b, GLsizei c, GLenum d, GLenum e, const GLvoid * f)
{
	(*HostCall_p)(NFOSMESA_GLCOLORSUBTABLE,cur_context,&a);
}

void APIENTRY glCopyColorSubTable (GLenum a, GLsizei b, GLint c, GLint d, GLsizei e)
{
	(*HostCall_p)(NFOSMESA_GLCOPYCOLORSUBTABLE,cur_context,&a);
}

void APIENTRY glConvolutionFilter1D (GLenum a, GLenum b, GLsizei c, GLenum d, GLenum e, const GLvoid * f)
{
	(*HostCall_p)(NFOSMESA_GLCONVOLUTIONFILTER1D,cur_context,&a);
}

void APIENTRY glConvolutionFilter2D (GLenum a, GLenum b, GLsizei c, GLsizei d, GLenum e, GLenum f, const GLvoid * g)
{
	(*HostCall_p)(NFOSMESA_GLCONVOLUTIONFILTER2D,cur_context,&a);
}

void APIENTRY glConvolutionParameterf (GLenum a, GLenum b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLCONVOLUTIONPARAMETERF,cur_context,&a);
}

void APIENTRY glConvolutionParameterfv (GLenum a, GLenum b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLCONVOLUTIONPARAMETERFV,cur_context,&a);
}

void APIENTRY glConvolutionParameteri (GLenum a, GLenum b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLCONVOLUTIONPARAMETERI,cur_context,&a);
}

void APIENTRY glConvolutionParameteriv (GLenum a, GLenum b, const GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLCONVOLUTIONPARAMETERIV,cur_context,&a);
}

void APIENTRY glCopyConvolutionFilter1D (GLenum a, GLenum b, GLint c, GLint d, GLsizei e)
{
	(*HostCall_p)(NFOSMESA_GLCOPYCONVOLUTIONFILTER1D,cur_context,&a);
}

void APIENTRY glCopyConvolutionFilter2D (GLenum a, GLenum b, GLint c, GLint d, GLsizei e, GLsizei f)
{
	(*HostCall_p)(NFOSMESA_GLCOPYCONVOLUTIONFILTER2D,cur_context,&a);
}

void APIENTRY glGetConvolutionFilter (GLenum a, GLenum b, GLenum c, GLvoid * d)
{
	(*HostCall_p)(NFOSMESA_GLGETCONVOLUTIONFILTER,cur_context,&a);
}

void APIENTRY glGetConvolutionParameterfv (GLenum a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETCONVOLUTIONPARAMETERFV,cur_context,&a);
}

void APIENTRY glGetConvolutionParameteriv (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETCONVOLUTIONPARAMETERIV,cur_context,&a);
}

void APIENTRY glGetSeparableFilter (GLenum a, GLenum b, GLenum c, GLvoid * d, GLvoid * e, GLvoid * f)
{
	(*HostCall_p)(NFOSMESA_GLGETSEPARABLEFILTER,cur_context,&a);
}

void APIENTRY glSeparableFilter2D (GLenum a, GLenum b, GLsizei c, GLsizei d, GLenum e, GLenum f, const GLvoid * g, const GLvoid * h)
{
	(*HostCall_p)(NFOSMESA_GLSEPARABLEFILTER2D,cur_context,&a);
}

void APIENTRY glGetHistogram (GLenum a, GLboolean b, GLenum c, GLenum d, GLvoid * e)
{
	(*HostCall_p)(NFOSMESA_GLGETHISTOGRAM,cur_context,&a);
}

void APIENTRY glGetHistogramParameterfv (GLenum a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETHISTOGRAMPARAMETERFV,cur_context,&a);
}

void APIENTRY glGetHistogramParameteriv (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETHISTOGRAMPARAMETERIV,cur_context,&a);
}

void APIENTRY glGetMinmax (GLenum a, GLboolean b, GLenum c, GLenum d, GLvoid * e)
{
	(*HostCall_p)(NFOSMESA_GLGETMINMAX,cur_context,&a);
}

void APIENTRY glGetMinmaxParameterfv (GLenum a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETMINMAXPARAMETERFV,cur_context,&a);
}

void APIENTRY glGetMinmaxParameteriv (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETMINMAXPARAMETERIV,cur_context,&a);
}

void APIENTRY glHistogram (GLenum a, GLsizei b, GLenum c, GLboolean d)
{
	(*HostCall_p)(NFOSMESA_GLHISTOGRAM,cur_context,&a);
}

void APIENTRY glMinmax (GLenum a, GLenum b, GLboolean c)
{
	(*HostCall_p)(NFOSMESA_GLMINMAX,cur_context,&a);
}

void APIENTRY glResetHistogram (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLRESETHISTOGRAM,cur_context,&a);
}

void APIENTRY glResetMinmax (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLRESETMINMAX,cur_context,&a);
}

void APIENTRY glTexImage3D (GLenum a, GLint b, GLint c, GLsizei d, GLsizei e, GLsizei f, GLint g, GLenum h, GLenum i, const GLvoid * j)
{
	(*HostCall_p)(NFOSMESA_GLTEXIMAGE3D,cur_context,&a);
}

void APIENTRY glTexSubImage3D (GLenum a, GLint b, GLint c, GLint d, GLint e, GLsizei f, GLsizei g, GLsizei h, GLenum i, GLenum j, const GLvoid * k)
{
	(*HostCall_p)(NFOSMESA_GLTEXSUBIMAGE3D,cur_context,&a);
}

void APIENTRY glCopyTexSubImage3D (GLenum a, GLint b, GLint c, GLint d, GLint e, GLint f, GLint g, GLsizei h, GLsizei i)
{
	(*HostCall_p)(NFOSMESA_GLCOPYTEXSUBIMAGE3D,cur_context,&a);
}

void APIENTRY glActiveTexture (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLACTIVETEXTURE,cur_context,&a);
}

void APIENTRY glClientActiveTexture (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLCLIENTACTIVETEXTURE,cur_context,&a);
}

void APIENTRY glMultiTexCoord1d (GLenum a, GLdouble b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD1D,cur_context,&a);
}

void APIENTRY glMultiTexCoord1dv (GLenum a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD1DV,cur_context,&a);
}

void APIENTRY glMultiTexCoord1f (GLenum a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD1F,cur_context,&a);
}

void APIENTRY glMultiTexCoord1fv (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD1FV,cur_context,&a);
}

void APIENTRY glMultiTexCoord1i (GLenum a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD1I,cur_context,&a);
}

void APIENTRY glMultiTexCoord1iv (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD1IV,cur_context,&a);
}

void APIENTRY glMultiTexCoord1s (GLenum a, GLshort b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD1S,cur_context,&a);
}

void APIENTRY glMultiTexCoord1sv (GLenum a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD1SV,cur_context,&a);
}

void APIENTRY glMultiTexCoord2d (GLenum a, GLdouble b, GLdouble c)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD2D,cur_context,&a);
}

void APIENTRY glMultiTexCoord2dv (GLenum a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD2DV,cur_context,&a);
}

void APIENTRY glMultiTexCoord2f (GLenum a, GLfloat b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD2F,cur_context,&a);
}

void APIENTRY glMultiTexCoord2fv (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD2FV,cur_context,&a);
}

void APIENTRY glMultiTexCoord2i (GLenum a, GLint b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD2I,cur_context,&a);
}

void APIENTRY glMultiTexCoord2iv (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD2IV,cur_context,&a);
}

void APIENTRY glMultiTexCoord2s (GLenum a, GLshort b, GLshort c)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD2S,cur_context,&a);
}

void APIENTRY glMultiTexCoord2sv (GLenum a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD2SV,cur_context,&a);
}

void APIENTRY glMultiTexCoord3d (GLenum a, GLdouble b, GLdouble c, GLdouble d)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD3D,cur_context,&a);
}

void APIENTRY glMultiTexCoord3dv (GLenum a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD3DV,cur_context,&a);
}

void APIENTRY glMultiTexCoord3f (GLenum a, GLfloat b, GLfloat c, GLfloat d)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD3F,cur_context,&a);
}

void APIENTRY glMultiTexCoord3fv (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD3FV,cur_context,&a);
}

void APIENTRY glMultiTexCoord3i (GLenum a, GLint b, GLint c, GLint d)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD3I,cur_context,&a);
}

void APIENTRY glMultiTexCoord3iv (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD3IV,cur_context,&a);
}

void APIENTRY glMultiTexCoord3s (GLenum a, GLshort b, GLshort c, GLshort d)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD3S,cur_context,&a);
}

void APIENTRY glMultiTexCoord3sv (GLenum a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD3SV,cur_context,&a);
}

void APIENTRY glMultiTexCoord4d (GLenum a, GLdouble b, GLdouble c, GLdouble d, GLdouble e)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD4D,cur_context,&a);
}

void APIENTRY glMultiTexCoord4dv (GLenum a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD4DV,cur_context,&a);
}

void APIENTRY glMultiTexCoord4f (GLenum a, GLfloat b, GLfloat c, GLfloat d, GLfloat e)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD4F,cur_context,&a);
}

void APIENTRY glMultiTexCoord4fv (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD4FV,cur_context,&a);
}

void APIENTRY glMultiTexCoord4i (GLenum a, GLint b, GLint c, GLint d, GLint e)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD4I,cur_context,&a);
}

void APIENTRY glMultiTexCoord4iv (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD4IV,cur_context,&a);
}

void APIENTRY glMultiTexCoord4s (GLenum a, GLshort b, GLshort c, GLshort d, GLshort e)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD4S,cur_context,&a);
}

void APIENTRY glMultiTexCoord4sv (GLenum a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD4SV,cur_context,&a);
}

void APIENTRY glLoadTransposeMatrixf (const GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLLOADTRANSPOSEMATRIXF,cur_context,&a);
}

void APIENTRY glLoadTransposeMatrixd (const GLdouble * a)
{
	(*HostCall_p)(NFOSMESA_GLLOADTRANSPOSEMATRIXD,cur_context,&a);
}

void APIENTRY glMultTransposeMatrixf (const GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLMULTTRANSPOSEMATRIXF,cur_context,&a);
}

void APIENTRY glMultTransposeMatrixd (const GLdouble * a)
{
	(*HostCall_p)(NFOSMESA_GLMULTTRANSPOSEMATRIXD,cur_context,&a);
}

void APIENTRY glSampleCoverage (GLclampf a, GLboolean b)
{
	(*HostCall_p)(NFOSMESA_GLSAMPLECOVERAGE,cur_context,&a);
}

void APIENTRY glCompressedTexImage3D (GLenum a, GLint b, GLenum c, GLsizei d, GLsizei e, GLsizei f, GLint g, GLsizei h, const GLvoid * i)
{
	(*HostCall_p)(NFOSMESA_GLCOMPRESSEDTEXIMAGE3D,cur_context,&a);
}

void APIENTRY glCompressedTexImage2D (GLenum a, GLint b, GLenum c, GLsizei d, GLsizei e, GLint f, GLsizei g, const GLvoid * h)
{
	(*HostCall_p)(NFOSMESA_GLCOMPRESSEDTEXIMAGE2D,cur_context,&a);
}

void APIENTRY glCompressedTexImage1D (GLenum a, GLint b, GLenum c, GLsizei d, GLint e, GLsizei f, const GLvoid * g)
{
	(*HostCall_p)(NFOSMESA_GLCOMPRESSEDTEXIMAGE1D,cur_context,&a);
}

void APIENTRY glCompressedTexSubImage3D (GLenum a, GLint b, GLint c, GLint d, GLint e, GLsizei f, GLsizei g, GLsizei h, GLenum i, GLsizei j, const GLvoid * k)
{
	(*HostCall_p)(NFOSMESA_GLCOMPRESSEDTEXSUBIMAGE3D,cur_context,&a);
}

void APIENTRY glCompressedTexSubImage2D (GLenum a, GLint b, GLint c, GLint d, GLsizei e, GLsizei f, GLenum g, GLsizei h, const GLvoid * i)
{
	(*HostCall_p)(NFOSMESA_GLCOMPRESSEDTEXSUBIMAGE2D,cur_context,&a);
}

void APIENTRY glCompressedTexSubImage1D (GLenum a, GLint b, GLint c, GLsizei d, GLenum e, GLsizei f, const GLvoid * g)
{
	(*HostCall_p)(NFOSMESA_GLCOMPRESSEDTEXSUBIMAGE1D,cur_context,&a);
}

void APIENTRY glGetCompressedTexImage (GLenum a, GLint b, GLvoid * c)
{
	(*HostCall_p)(NFOSMESA_GLGETCOMPRESSEDTEXIMAGE,cur_context,&a);
}

void APIENTRY glBlendFuncSeparate (GLenum a, GLenum b, GLenum c, GLenum d)
{
	(*HostCall_p)(NFOSMESA_GLBLENDFUNCSEPARATE,cur_context,&a);
}

void APIENTRY glFogCoordf (GLfloat a)
{
	(*HostCall_p)(NFOSMESA_GLFOGCOORDF,cur_context,&a);
}

void APIENTRY glFogCoordfv (const GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLFOGCOORDFV,cur_context,&a);
}

void APIENTRY glFogCoordd (GLdouble a)
{
	(*HostCall_p)(NFOSMESA_GLFOGCOORDD,cur_context,&a);
}

void APIENTRY glFogCoorddv (const GLdouble * a)
{
	(*HostCall_p)(NFOSMESA_GLFOGCOORDDV,cur_context,&a);
}

void APIENTRY glFogCoordPointer (GLenum a, GLsizei b, const GLvoid * c)
{
	(*HostCall_p)(NFOSMESA_GLFOGCOORDPOINTER,cur_context,&a);
}

void APIENTRY glMultiDrawArrays (GLenum a, GLint * b, GLsizei * c, GLsizei d)
{
	(*HostCall_p)(NFOSMESA_GLMULTIDRAWARRAYS,cur_context,&a);
}

void APIENTRY glMultiDrawElements (GLenum a, const GLsizei * b, GLenum c, const GLvoid* * d, GLsizei e)
{
	(*HostCall_p)(NFOSMESA_GLMULTIDRAWELEMENTS,cur_context,&a);
}

void APIENTRY glPointParameterf (GLenum a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLPOINTPARAMETERF,cur_context,&a);
}

void APIENTRY glPointParameterfv (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLPOINTPARAMETERFV,cur_context,&a);
}

void APIENTRY glPointParameteri (GLenum a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLPOINTPARAMETERI,cur_context,&a);
}

void APIENTRY glPointParameteriv (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLPOINTPARAMETERIV,cur_context,&a);
}

void APIENTRY glSecondaryColor3b (GLbyte a, GLbyte b, GLbyte c)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3B,cur_context,&a);
}

void APIENTRY glSecondaryColor3bv (const GLbyte * a)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3BV,cur_context,&a);
}

void APIENTRY glSecondaryColor3d (GLdouble a, GLdouble b, GLdouble c)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3D,cur_context,&a);
}

void APIENTRY glSecondaryColor3dv (const GLdouble * a)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3DV,cur_context,&a);
}

void APIENTRY glSecondaryColor3f (GLfloat a, GLfloat b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3F,cur_context,&a);
}

void APIENTRY glSecondaryColor3fv (const GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3FV,cur_context,&a);
}

void APIENTRY glSecondaryColor3i (GLint a, GLint b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3I,cur_context,&a);
}

void APIENTRY glSecondaryColor3iv (const GLint * a)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3IV,cur_context,&a);
}

void APIENTRY glSecondaryColor3s (GLshort a, GLshort b, GLshort c)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3S,cur_context,&a);
}

void APIENTRY glSecondaryColor3sv (const GLshort * a)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3SV,cur_context,&a);
}

void APIENTRY glSecondaryColor3ub (GLubyte a, GLubyte b, GLubyte c)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3UB,cur_context,&a);
}

void APIENTRY glSecondaryColor3ubv (const GLubyte * a)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3UBV,cur_context,&a);
}

void APIENTRY glSecondaryColor3ui (GLuint a, GLuint b, GLuint c)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3UI,cur_context,&a);
}

void APIENTRY glSecondaryColor3uiv (const GLuint * a)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3UIV,cur_context,&a);
}

void APIENTRY glSecondaryColor3us (GLushort a, GLushort b, GLushort c)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3US,cur_context,&a);
}

void APIENTRY glSecondaryColor3usv (const GLushort * a)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3USV,cur_context,&a);
}

void APIENTRY glSecondaryColorPointer (GLint a, GLenum b, GLsizei c, const GLvoid * d)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLORPOINTER,cur_context,&a);
}

void APIENTRY glWindowPos2d (GLdouble a, GLdouble b)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2D,cur_context,&a);
}

void APIENTRY glWindowPos2dv (const GLdouble * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2DV,cur_context,&a);
}

void APIENTRY glWindowPos2f (GLfloat a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2F,cur_context,&a);
}

void APIENTRY glWindowPos2fv (const GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2FV,cur_context,&a);
}

void APIENTRY glWindowPos2i (GLint a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2I,cur_context,&a);
}

void APIENTRY glWindowPos2iv (const GLint * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2IV,cur_context,&a);
}

void APIENTRY glWindowPos2s (GLshort a, GLshort b)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2S,cur_context,&a);
}

void APIENTRY glWindowPos2sv (const GLshort * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2SV,cur_context,&a);
}

void APIENTRY glWindowPos3d (GLdouble a, GLdouble b, GLdouble c)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3D,cur_context,&a);
}

void APIENTRY glWindowPos3dv (const GLdouble * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3DV,cur_context,&a);
}

void APIENTRY glWindowPos3f (GLfloat a, GLfloat b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3F,cur_context,&a);
}

void APIENTRY glWindowPos3fv (const GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3FV,cur_context,&a);
}

void APIENTRY glWindowPos3i (GLint a, GLint b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3I,cur_context,&a);
}

void APIENTRY glWindowPos3iv (const GLint * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3IV,cur_context,&a);
}

void APIENTRY glWindowPos3s (GLshort a, GLshort b, GLshort c)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3S,cur_context,&a);
}

void APIENTRY glWindowPos3sv (const GLshort * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3SV,cur_context,&a);
}

void APIENTRY glGenQueries (GLsizei a, GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLGENQUERIES,cur_context,&a);
}

void APIENTRY glDeleteQueries (GLsizei a, const GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLDELETEQUERIES,cur_context,&a);
}

GLboolean APIENTRY glIsQuery (GLuint a)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLISQUERY,cur_context,&a);
}

void APIENTRY glBeginQuery (GLenum a, GLuint b)
{
	(*HostCall_p)(NFOSMESA_GLBEGINQUERY,cur_context,&a);
}

void APIENTRY glEndQuery (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLENDQUERY,cur_context,&a);
}

void APIENTRY glGetQueryiv (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETQUERYIV,cur_context,&a);
}

void APIENTRY glGetQueryObjectiv (GLuint a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETQUERYOBJECTIV,cur_context,&a);
}

void APIENTRY glGetQueryObjectuiv (GLuint a, GLenum b, GLuint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETQUERYOBJECTUIV,cur_context,&a);
}

void APIENTRY glBindBuffer (GLenum a, GLuint b)
{
	(*HostCall_p)(NFOSMESA_GLBINDBUFFER,cur_context,&a);
}

void APIENTRY glDeleteBuffers (GLsizei a, const GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLDELETEBUFFERS,cur_context,&a);
}

void APIENTRY glGenBuffers (GLsizei a, GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLGENBUFFERS,cur_context,&a);
}

GLboolean APIENTRY glIsBuffer (GLuint a)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLISBUFFER,cur_context,&a);
}

void APIENTRY glBufferData (GLenum a, GLsizeiptr b, const GLvoid * c, GLenum d)
{
	(*HostCall_p)(NFOSMESA_GLBUFFERDATA,cur_context,&a);
}

void APIENTRY glBufferSubData (GLenum a, GLintptr b, GLsizeiptr c, const GLvoid * d)
{
	(*HostCall_p)(NFOSMESA_GLBUFFERSUBDATA,cur_context,&a);
}

void APIENTRY glGetBufferSubData (GLenum a, GLintptr b, GLsizeiptr c, GLvoid * d)
{
	(*HostCall_p)(NFOSMESA_GLGETBUFFERSUBDATA,cur_context,&a);
}

GLvoid* APIENTRY glMapBuffer (GLenum a, GLenum b)
{
	return (GLvoid *)(*HostCall_p)(NFOSMESA_GLMAPBUFFER,cur_context,&a);
}

GLboolean APIENTRY glUnmapBuffer (GLenum a)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLUNMAPBUFFER,cur_context,&a);
}

void APIENTRY glGetBufferParameteriv (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETBUFFERPARAMETERIV,cur_context,&a);
}

void APIENTRY glGetBufferPointerv (GLenum a, GLenum b, GLvoid* * c)
{
	(*HostCall_p)(NFOSMESA_GLGETBUFFERPOINTERV,cur_context,&a);
}

void APIENTRY glActiveTextureARB (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLACTIVETEXTUREARB,cur_context,&a);
}

void APIENTRY glClientActiveTextureARB (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLCLIENTACTIVETEXTUREARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord1dARB (GLenum a, GLdouble b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD1DARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord1dvARB (GLenum a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD1DVARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord1fARB (GLenum a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD1FARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord1fvARB (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD1FVARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord1iARB (GLenum a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD1IARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord1ivARB (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD1IVARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord1sARB (GLenum a, GLshort b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD1SARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord1svARB (GLenum a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD1SVARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord2dARB (GLenum a, GLdouble b, GLdouble c)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD2DARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord2dvARB (GLenum a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD2DVARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord2fARB (GLenum a, GLfloat b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD2FARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord2fvARB (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD2FVARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord2iARB (GLenum a, GLint b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD2IARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord2ivARB (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD2IVARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord2sARB (GLenum a, GLshort b, GLshort c)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD2SARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord2svARB (GLenum a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD2SVARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord3dARB (GLenum a, GLdouble b, GLdouble c, GLdouble d)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD3DARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord3dvARB (GLenum a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD3DVARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord3fARB (GLenum a, GLfloat b, GLfloat c, GLfloat d)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD3FARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord3fvARB (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD3FVARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord3iARB (GLenum a, GLint b, GLint c, GLint d)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD3IARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord3ivARB (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD3IVARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord3sARB (GLenum a, GLshort b, GLshort c, GLshort d)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD3SARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord3svARB (GLenum a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD3SVARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord4dARB (GLenum a, GLdouble b, GLdouble c, GLdouble d, GLdouble e)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD4DARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord4dvARB (GLenum a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD4DVARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord4fARB (GLenum a, GLfloat b, GLfloat c, GLfloat d, GLfloat e)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD4FARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord4fvARB (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD4FVARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord4iARB (GLenum a, GLint b, GLint c, GLint d, GLint e)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD4IARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord4ivARB (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD4IVARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord4sARB (GLenum a, GLshort b, GLshort c, GLshort d, GLshort e)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD4SARB,cur_context,&a);
}

void APIENTRY glMultiTexCoord4svARB (GLenum a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD4SVARB,cur_context,&a);
}

void APIENTRY glLoadTransposeMatrixfARB (const GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLLOADTRANSPOSEMATRIXFARB,cur_context,&a);
}

void APIENTRY glLoadTransposeMatrixdARB (const GLdouble * a)
{
	(*HostCall_p)(NFOSMESA_GLLOADTRANSPOSEMATRIXDARB,cur_context,&a);
}

void APIENTRY glMultTransposeMatrixfARB (const GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLMULTTRANSPOSEMATRIXFARB,cur_context,&a);
}

void APIENTRY glMultTransposeMatrixdARB (const GLdouble * a)
{
	(*HostCall_p)(NFOSMESA_GLMULTTRANSPOSEMATRIXDARB,cur_context,&a);
}

void APIENTRY glSampleCoverageARB (GLclampf a, GLboolean b)
{
	(*HostCall_p)(NFOSMESA_GLSAMPLECOVERAGEARB,cur_context,&a);
}

void APIENTRY glCompressedTexImage3DARB (GLenum a, GLint b, GLenum c, GLsizei d, GLsizei e, GLsizei f, GLint g, GLsizei h, const GLvoid * i)
{
	(*HostCall_p)(NFOSMESA_GLCOMPRESSEDTEXIMAGE3DARB,cur_context,&a);
}

void APIENTRY glCompressedTexImage2DARB (GLenum a, GLint b, GLenum c, GLsizei d, GLsizei e, GLint f, GLsizei g, const GLvoid * h)
{
	(*HostCall_p)(NFOSMESA_GLCOMPRESSEDTEXIMAGE2DARB,cur_context,&a);
}

void APIENTRY glCompressedTexImage1DARB (GLenum a, GLint b, GLenum c, GLsizei d, GLint e, GLsizei f, const GLvoid * g)
{
	(*HostCall_p)(NFOSMESA_GLCOMPRESSEDTEXIMAGE1DARB,cur_context,&a);
}

void APIENTRY glCompressedTexSubImage3DARB (GLenum a, GLint b, GLint c, GLint d, GLint e, GLsizei f, GLsizei g, GLsizei h, GLenum i, GLsizei j, const GLvoid * k)
{
	(*HostCall_p)(NFOSMESA_GLCOMPRESSEDTEXSUBIMAGE3DARB,cur_context,&a);
}

void APIENTRY glCompressedTexSubImage2DARB (GLenum a, GLint b, GLint c, GLint d, GLsizei e, GLsizei f, GLenum g, GLsizei h, const GLvoid * i)
{
	(*HostCall_p)(NFOSMESA_GLCOMPRESSEDTEXSUBIMAGE2DARB,cur_context,&a);
}

void APIENTRY glCompressedTexSubImage1DARB (GLenum a, GLint b, GLint c, GLsizei d, GLenum e, GLsizei f, const GLvoid * g)
{
	(*HostCall_p)(NFOSMESA_GLCOMPRESSEDTEXSUBIMAGE1DARB,cur_context,&a);
}

void APIENTRY glGetCompressedTexImageARB (GLenum a, GLint b, GLvoid * c)
{
	(*HostCall_p)(NFOSMESA_GLGETCOMPRESSEDTEXIMAGEARB,cur_context,&a);
}

void APIENTRY glPointParameterfARB (GLenum a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLPOINTPARAMETERFARB,cur_context,&a);
}

void APIENTRY glPointParameterfvARB (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLPOINTPARAMETERFVARB,cur_context,&a);
}

void APIENTRY glWeightbvARB (GLint a, const GLbyte * b)
{
	(*HostCall_p)(NFOSMESA_GLWEIGHTBVARB,cur_context,&a);
}

void APIENTRY glWeightsvARB (GLint a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLWEIGHTSVARB,cur_context,&a);
}

void APIENTRY glWeightivARB (GLint a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLWEIGHTIVARB,cur_context,&a);
}

void APIENTRY glWeightfvARB (GLint a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLWEIGHTFVARB,cur_context,&a);
}

void APIENTRY glWeightdvARB (GLint a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLWEIGHTDVARB,cur_context,&a);
}

void APIENTRY glWeightubvARB (GLint a, const GLubyte * b)
{
	(*HostCall_p)(NFOSMESA_GLWEIGHTUBVARB,cur_context,&a);
}

void APIENTRY glWeightusvARB (GLint a, const GLushort * b)
{
	(*HostCall_p)(NFOSMESA_GLWEIGHTUSVARB,cur_context,&a);
}

void APIENTRY glWeightuivARB (GLint a, const GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLWEIGHTUIVARB,cur_context,&a);
}

void APIENTRY glWeightPointerARB (GLint a, GLenum b, GLsizei c, const GLvoid * d)
{
	(*HostCall_p)(NFOSMESA_GLWEIGHTPOINTERARB,cur_context,&a);
}

void APIENTRY glVertexBlendARB (GLint a)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXBLENDARB,cur_context,&a);
}

void APIENTRY glCurrentPaletteMatrixARB (GLint a)
{
	(*HostCall_p)(NFOSMESA_GLCURRENTPALETTEMATRIXARB,cur_context,&a);
}

void APIENTRY glMatrixIndexubvARB (GLint a, const GLubyte * b)
{
	(*HostCall_p)(NFOSMESA_GLMATRIXINDEXUBVARB,cur_context,&a);
}

void APIENTRY glMatrixIndexusvARB (GLint a, const GLushort * b)
{
	(*HostCall_p)(NFOSMESA_GLMATRIXINDEXUSVARB,cur_context,&a);
}

void APIENTRY glMatrixIndexuivARB (GLint a, const GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLMATRIXINDEXUIVARB,cur_context,&a);
}

void APIENTRY glMatrixIndexPointerARB (GLint a, GLenum b, GLsizei c, const GLvoid * d)
{
	(*HostCall_p)(NFOSMESA_GLMATRIXINDEXPOINTERARB,cur_context,&a);
}

void APIENTRY glWindowPos2dARB (GLdouble a, GLdouble b)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2DARB,cur_context,&a);
}

void APIENTRY glWindowPos2dvARB (const GLdouble * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2DVARB,cur_context,&a);
}

void APIENTRY glWindowPos2fARB (GLfloat a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2FARB,cur_context,&a);
}

void APIENTRY glWindowPos2fvARB (const GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2FVARB,cur_context,&a);
}

void APIENTRY glWindowPos2iARB (GLint a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2IARB,cur_context,&a);
}

void APIENTRY glWindowPos2ivARB (const GLint * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2IVARB,cur_context,&a);
}

void APIENTRY glWindowPos2sARB (GLshort a, GLshort b)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2SARB,cur_context,&a);
}

void APIENTRY glWindowPos2svARB (const GLshort * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2SVARB,cur_context,&a);
}

void APIENTRY glWindowPos3dARB (GLdouble a, GLdouble b, GLdouble c)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3DARB,cur_context,&a);
}

void APIENTRY glWindowPos3dvARB (const GLdouble * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3DVARB,cur_context,&a);
}

void APIENTRY glWindowPos3fARB (GLfloat a, GLfloat b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3FARB,cur_context,&a);
}

void APIENTRY glWindowPos3fvARB (const GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3FVARB,cur_context,&a);
}

void APIENTRY glWindowPos3iARB (GLint a, GLint b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3IARB,cur_context,&a);
}

void APIENTRY glWindowPos3ivARB (const GLint * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3IVARB,cur_context,&a);
}

void APIENTRY glWindowPos3sARB (GLshort a, GLshort b, GLshort c)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3SARB,cur_context,&a);
}

void APIENTRY glWindowPos3svARB (const GLshort * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3SVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib1dARB (GLuint a, GLdouble b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB1DARB,cur_context,&a);
}

void APIENTRY glVertexAttrib1dvARB (GLuint a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB1DVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib1fARB (GLuint a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB1FARB,cur_context,&a);
}

void APIENTRY glVertexAttrib1fvARB (GLuint a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB1FVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib1sARB (GLuint a, GLshort b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB1SARB,cur_context,&a);
}

void APIENTRY glVertexAttrib1svARB (GLuint a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB1SVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib2dARB (GLuint a, GLdouble b, GLdouble c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB2DARB,cur_context,&a);
}

void APIENTRY glVertexAttrib2dvARB (GLuint a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB2DVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib2fARB (GLuint a, GLfloat b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB2FARB,cur_context,&a);
}

void APIENTRY glVertexAttrib2fvARB (GLuint a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB2FVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib2sARB (GLuint a, GLshort b, GLshort c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB2SARB,cur_context,&a);
}

void APIENTRY glVertexAttrib2svARB (GLuint a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB2SVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib3dARB (GLuint a, GLdouble b, GLdouble c, GLdouble d)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB3DARB,cur_context,&a);
}

void APIENTRY glVertexAttrib3dvARB (GLuint a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB3DVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib3fARB (GLuint a, GLfloat b, GLfloat c, GLfloat d)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB3FARB,cur_context,&a);
}

void APIENTRY glVertexAttrib3fvARB (GLuint a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB3FVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib3sARB (GLuint a, GLshort b, GLshort c, GLshort d)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB3SARB,cur_context,&a);
}

void APIENTRY glVertexAttrib3svARB (GLuint a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB3SVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib4NbvARB (GLuint a, const GLbyte * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4NBVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib4NivARB (GLuint a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4NIVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib4NsvARB (GLuint a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4NSVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib4NubARB (GLuint a, GLubyte b, GLubyte c, GLubyte d, GLubyte e)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4NUBARB,cur_context,&a);
}

void APIENTRY glVertexAttrib4NubvARB (GLuint a, const GLubyte * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4NUBVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib4NuivARB (GLuint a, const GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4NUIVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib4NusvARB (GLuint a, const GLushort * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4NUSVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib4bvARB (GLuint a, const GLbyte * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4BVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib4dARB (GLuint a, GLdouble b, GLdouble c, GLdouble d, GLdouble e)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4DARB,cur_context,&a);
}

void APIENTRY glVertexAttrib4dvARB (GLuint a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4DVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib4fARB (GLuint a, GLfloat b, GLfloat c, GLfloat d, GLfloat e)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4FARB,cur_context,&a);
}

void APIENTRY glVertexAttrib4fvARB (GLuint a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4FVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib4ivARB (GLuint a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4IVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib4sARB (GLuint a, GLshort b, GLshort c, GLshort d, GLshort e)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4SARB,cur_context,&a);
}

void APIENTRY glVertexAttrib4svARB (GLuint a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4SVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib4ubvARB (GLuint a, const GLubyte * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4UBVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib4uivARB (GLuint a, const GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4UIVARB,cur_context,&a);
}

void APIENTRY glVertexAttrib4usvARB (GLuint a, const GLushort * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4USVARB,cur_context,&a);
}

void APIENTRY glVertexAttribPointerARB (GLuint a, GLint b, GLenum c, GLboolean d, GLsizei e, const GLvoid * f)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBPOINTERARB,cur_context,&a);
}

void APIENTRY glEnableVertexAttribArrayARB (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLENABLEVERTEXATTRIBARRAYARB,cur_context,&a);
}

void APIENTRY glDisableVertexAttribArrayARB (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLDISABLEVERTEXATTRIBARRAYARB,cur_context,&a);
}

void APIENTRY glProgramStringARB (GLenum a, GLenum b, GLsizei c, const GLvoid * d)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMSTRINGARB,cur_context,&a);
}

void APIENTRY glBindProgramARB (GLenum a, GLuint b)
{
	(*HostCall_p)(NFOSMESA_GLBINDPROGRAMARB,cur_context,&a);
}

void APIENTRY glDeleteProgramsARB (GLsizei a, const GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLDELETEPROGRAMSARB,cur_context,&a);
}

void APIENTRY glGenProgramsARB (GLsizei a, GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLGENPROGRAMSARB,cur_context,&a);
}

void APIENTRY glProgramEnvParameter4dARB (GLenum a, GLuint b, GLdouble c, GLdouble d, GLdouble e, GLdouble f)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMENVPARAMETER4DARB,cur_context,&a);
}

void APIENTRY glProgramEnvParameter4dvARB (GLenum a, GLuint b, const GLdouble * c)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMENVPARAMETER4DVARB,cur_context,&a);
}

void APIENTRY glProgramEnvParameter4fARB (GLenum a, GLuint b, GLfloat c, GLfloat d, GLfloat e, GLfloat f)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMENVPARAMETER4FARB,cur_context,&a);
}

void APIENTRY glProgramEnvParameter4fvARB (GLenum a, GLuint b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMENVPARAMETER4FVARB,cur_context,&a);
}

void APIENTRY glProgramLocalParameter4dARB (GLenum a, GLuint b, GLdouble c, GLdouble d, GLdouble e, GLdouble f)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMLOCALPARAMETER4DARB,cur_context,&a);
}

void APIENTRY glProgramLocalParameter4dvARB (GLenum a, GLuint b, const GLdouble * c)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMLOCALPARAMETER4DVARB,cur_context,&a);
}

void APIENTRY glProgramLocalParameter4fARB (GLenum a, GLuint b, GLfloat c, GLfloat d, GLfloat e, GLfloat f)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMLOCALPARAMETER4FARB,cur_context,&a);
}

void APIENTRY glProgramLocalParameter4fvARB (GLenum a, GLuint b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMLOCALPARAMETER4FVARB,cur_context,&a);
}

void APIENTRY glGetProgramEnvParameterdvARB (GLenum a, GLuint b, GLdouble * c)
{
	(*HostCall_p)(NFOSMESA_GLGETPROGRAMENVPARAMETERDVARB,cur_context,&a);
}

void APIENTRY glGetProgramEnvParameterfvARB (GLenum a, GLuint b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETPROGRAMENVPARAMETERFVARB,cur_context,&a);
}

void APIENTRY glGetProgramLocalParameterdvARB (GLenum a, GLuint b, GLdouble * c)
{
	(*HostCall_p)(NFOSMESA_GLGETPROGRAMLOCALPARAMETERDVARB,cur_context,&a);
}

void APIENTRY glGetProgramLocalParameterfvARB (GLenum a, GLuint b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETPROGRAMLOCALPARAMETERFVARB,cur_context,&a);
}

void APIENTRY glGetProgramivARB (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETPROGRAMIVARB,cur_context,&a);
}

void APIENTRY glGetProgramStringARB (GLenum a, GLenum b, GLvoid * c)
{
	(*HostCall_p)(NFOSMESA_GLGETPROGRAMSTRINGARB,cur_context,&a);
}

void APIENTRY glGetVertexAttribdvARB (GLuint a, GLenum b, GLdouble * c)
{
	(*HostCall_p)(NFOSMESA_GLGETVERTEXATTRIBDVARB,cur_context,&a);
}

void APIENTRY glGetVertexAttribfvARB (GLuint a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETVERTEXATTRIBFVARB,cur_context,&a);
}

void APIENTRY glGetVertexAttribivARB (GLuint a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETVERTEXATTRIBIVARB,cur_context,&a);
}

void APIENTRY glGetVertexAttribPointervARB (GLuint a, GLenum b, GLvoid* * c)
{
	(*HostCall_p)(NFOSMESA_GLGETVERTEXATTRIBPOINTERVARB,cur_context,&a);
}

GLboolean APIENTRY glIsProgramARB (GLuint a)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLISPROGRAMARB,cur_context,&a);
}

void APIENTRY glBindBufferARB (GLenum a, GLuint b)
{
	(*HostCall_p)(NFOSMESA_GLBINDBUFFERARB,cur_context,&a);
}

void APIENTRY glDeleteBuffersARB (GLsizei a, const GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLDELETEBUFFERSARB,cur_context,&a);
}

void APIENTRY glGenBuffersARB (GLsizei a, GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLGENBUFFERSARB,cur_context,&a);
}

GLboolean APIENTRY glIsBufferARB (GLuint a)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLISBUFFERARB,cur_context,&a);
}

void APIENTRY glBufferDataARB (GLenum a, GLsizeiptrARB b, const GLvoid * c, GLenum d)
{
	(*HostCall_p)(NFOSMESA_GLBUFFERDATAARB,cur_context,&a);
}

void APIENTRY glBufferSubDataARB (GLenum a, GLintptrARB b, GLsizeiptrARB c, const GLvoid * d)
{
	(*HostCall_p)(NFOSMESA_GLBUFFERSUBDATAARB,cur_context,&a);
}

void APIENTRY glGetBufferSubDataARB (GLenum a, GLintptrARB b, GLsizeiptrARB c, GLvoid * d)
{
	(*HostCall_p)(NFOSMESA_GLGETBUFFERSUBDATAARB,cur_context,&a);
}

GLvoid* APIENTRY glMapBufferARB (GLenum a, GLenum b)
{
	return (GLvoid *)(*HostCall_p)(NFOSMESA_GLMAPBUFFERARB,cur_context,&a);
}

GLboolean APIENTRY glUnmapBufferARB (GLenum a)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLUNMAPBUFFERARB,cur_context,&a);
}

void APIENTRY glGetBufferParameterivARB (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETBUFFERPARAMETERIVARB,cur_context,&a);
}

void APIENTRY glGetBufferPointervARB (GLenum a, GLenum b, GLvoid* * c)
{
	(*HostCall_p)(NFOSMESA_GLGETBUFFERPOINTERVARB,cur_context,&a);
}

void APIENTRY glGenQueriesARB (GLsizei a, GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLGENQUERIESARB,cur_context,&a);
}

void APIENTRY glDeleteQueriesARB (GLsizei a, const GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLDELETEQUERIESARB,cur_context,&a);
}

GLboolean APIENTRY glIsQueryARB (GLuint a)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLISQUERYARB,cur_context,&a);
}

void APIENTRY glBeginQueryARB (GLenum a, GLuint b)
{
	(*HostCall_p)(NFOSMESA_GLBEGINQUERYARB,cur_context,&a);
}

void APIENTRY glEndQueryARB (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLENDQUERYARB,cur_context,&a);
}

void APIENTRY glGetQueryivARB (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETQUERYIVARB,cur_context,&a);
}

void APIENTRY glGetQueryObjectivARB (GLuint a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETQUERYOBJECTIVARB,cur_context,&a);
}

void APIENTRY glGetQueryObjectuivARB (GLuint a, GLenum b, GLuint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETQUERYOBJECTUIVARB,cur_context,&a);
}

void APIENTRY glDeleteObjectARB (GLhandleARB a)
{
	(*HostCall_p)(NFOSMESA_GLDELETEOBJECTARB,cur_context,&a);
}

GLhandleARB APIENTRY glGetHandleARB (GLenum a)
{
	return (GLhandleARB)(*HostCall_p)(NFOSMESA_GLGETHANDLEARB,cur_context,&a);
}

void APIENTRY glDetachObjectARB (GLhandleARB a, GLhandleARB b)
{
	(*HostCall_p)(NFOSMESA_GLDETACHOBJECTARB,cur_context,&a);
}

GLhandleARB APIENTRY glCreateShaderObjectARB (GLenum a)
{
	return (GLhandleARB)(*HostCall_p)(NFOSMESA_GLCREATESHADEROBJECTARB,cur_context,&a);
}

void APIENTRY glShaderSourceARB (GLhandleARB a, GLsizei b, const GLcharARB* * c, const GLint * d)
{
	(*HostCall_p)(NFOSMESA_GLSHADERSOURCEARB,cur_context,&a);
}

void APIENTRY glCompileShaderARB (GLhandleARB a)
{
	(*HostCall_p)(NFOSMESA_GLCOMPILESHADERARB,cur_context,&a);
}

GLhandleARB APIENTRY glCreateProgramObjectARB (void)
{
	return (GLhandleARB)(*HostCall_p)(NFOSMESA_GLCREATEPROGRAMOBJECTARB,cur_context,NULL);
}

void APIENTRY glAttachObjectARB (GLhandleARB a, GLhandleARB b)
{
	(*HostCall_p)(NFOSMESA_GLATTACHOBJECTARB,cur_context,&a);
}

void APIENTRY glLinkProgramARB (GLhandleARB a)
{
	(*HostCall_p)(NFOSMESA_GLLINKPROGRAMARB,cur_context,&a);
}

void APIENTRY glUseProgramObjectARB (GLhandleARB a)
{
	(*HostCall_p)(NFOSMESA_GLUSEPROGRAMOBJECTARB,cur_context,&a);
}

void APIENTRY glValidateProgramARB (GLhandleARB a)
{
	(*HostCall_p)(NFOSMESA_GLVALIDATEPROGRAMARB,cur_context,&a);
}

void APIENTRY glUniform1fARB (GLint a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORM1FARB,cur_context,&a);
}

void APIENTRY glUniform2fARB (GLint a, GLfloat b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORM2FARB,cur_context,&a);
}

void APIENTRY glUniform3fARB (GLint a, GLfloat b, GLfloat c, GLfloat d)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORM3FARB,cur_context,&a);
}

void APIENTRY glUniform4fARB (GLint a, GLfloat b, GLfloat c, GLfloat d, GLfloat e)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORM4FARB,cur_context,&a);
}

void APIENTRY glUniform1iARB (GLint a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORM1IARB,cur_context,&a);
}

void APIENTRY glUniform2iARB (GLint a, GLint b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORM2IARB,cur_context,&a);
}

void APIENTRY glUniform3iARB (GLint a, GLint b, GLint c, GLint d)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORM3IARB,cur_context,&a);
}

void APIENTRY glUniform4iARB (GLint a, GLint b, GLint c, GLint d, GLint e)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORM4IARB,cur_context,&a);
}

void APIENTRY glUniform1fvARB (GLint a, GLsizei b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORM1FVARB,cur_context,&a);
}

void APIENTRY glUniform2fvARB (GLint a, GLsizei b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORM2FVARB,cur_context,&a);
}

void APIENTRY glUniform3fvARB (GLint a, GLsizei b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORM3FVARB,cur_context,&a);
}

void APIENTRY glUniform4fvARB (GLint a, GLsizei b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORM4FVARB,cur_context,&a);
}

void APIENTRY glUniform1ivARB (GLint a, GLsizei b, const GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORM1IVARB,cur_context,&a);
}

void APIENTRY glUniform2ivARB (GLint a, GLsizei b, const GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORM2IVARB,cur_context,&a);
}

void APIENTRY glUniform3ivARB (GLint a, GLsizei b, const GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORM3IVARB,cur_context,&a);
}

void APIENTRY glUniform4ivARB (GLint a, GLsizei b, const GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORM4IVARB,cur_context,&a);
}

void APIENTRY glUniformMatrix2fvARB (GLint a, GLsizei b, GLboolean c, const GLfloat * d)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORMMATRIX2FVARB,cur_context,&a);
}

void APIENTRY glUniformMatrix3fvARB (GLint a, GLsizei b, GLboolean c, const GLfloat * d)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORMMATRIX3FVARB,cur_context,&a);
}

void APIENTRY glUniformMatrix4fvARB (GLint a, GLsizei b, GLboolean c, const GLfloat * d)
{
	(*HostCall_p)(NFOSMESA_GLUNIFORMMATRIX4FVARB,cur_context,&a);
}

void APIENTRY glGetObjectParameterfvARB (GLhandleARB a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETOBJECTPARAMETERFVARB,cur_context,&a);
}

void APIENTRY glGetObjectParameterivARB (GLhandleARB a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETOBJECTPARAMETERIVARB,cur_context,&a);
}

void APIENTRY glGetInfoLogARB (GLhandleARB a, GLsizei b, GLsizei * c, GLcharARB * d)
{
	(*HostCall_p)(NFOSMESA_GLGETINFOLOGARB,cur_context,&a);
}

void APIENTRY glGetAttachedObjectsARB (GLhandleARB a, GLsizei b, GLsizei * c, GLhandleARB * d)
{
	(*HostCall_p)(NFOSMESA_GLGETATTACHEDOBJECTSARB,cur_context,&a);
}

GLint APIENTRY glGetUniformLocationARB (GLhandleARB a, const GLcharARB * b)
{
	return (GLint)(*HostCall_p)(NFOSMESA_GLGETUNIFORMLOCATIONARB,cur_context,&a);
}

void APIENTRY glGetActiveUniformARB (GLhandleARB a, GLuint b, GLsizei c, GLsizei * d, GLint * e, GLenum * f, GLcharARB * g)
{
	(*HostCall_p)(NFOSMESA_GLGETACTIVEUNIFORMARB,cur_context,&a);
}

void APIENTRY glGetUniformfvARB (GLhandleARB a, GLint b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETUNIFORMFVARB,cur_context,&a);
}

void APIENTRY glGetUniformivARB (GLhandleARB a, GLint b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETUNIFORMIVARB,cur_context,&a);
}

void APIENTRY glGetShaderSourceARB (GLhandleARB a, GLsizei b, GLsizei * c, GLcharARB * d)
{
	(*HostCall_p)(NFOSMESA_GLGETSHADERSOURCEARB,cur_context,&a);
}

void APIENTRY glBindAttribLocationARB (GLhandleARB a, GLuint b, const GLcharARB * c)
{
	(*HostCall_p)(NFOSMESA_GLBINDATTRIBLOCATIONARB,cur_context,&a);
}

void APIENTRY glGetActiveAttribARB (GLhandleARB a, GLuint b, GLsizei c, GLsizei * d, GLint * e, GLenum * f, GLcharARB * g)
{
	(*HostCall_p)(NFOSMESA_GLGETACTIVEATTRIBARB,cur_context,&a);
}

GLint APIENTRY glGetAttribLocationARB (GLhandleARB a, const GLcharARB * b)
{
	return (GLint)(*HostCall_p)(NFOSMESA_GLGETATTRIBLOCATIONARB,cur_context,&a);
}

void APIENTRY glDrawBuffersARB (GLsizei a, const GLenum * b)
{
	(*HostCall_p)(NFOSMESA_GLDRAWBUFFERSARB,cur_context,&a);
}

void APIENTRY glBlendColorEXT (GLclampf a, GLclampf b, GLclampf c, GLclampf d)
{
	(*HostCall_p)(NFOSMESA_GLBLENDCOLOREXT,cur_context,&a);
}

void APIENTRY glPolygonOffsetEXT (GLfloat a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLPOLYGONOFFSETEXT,cur_context,&a);
}

void APIENTRY glTexImage3DEXT (GLenum a, GLint b, GLenum c, GLsizei d, GLsizei e, GLsizei f, GLint g, GLenum h, GLenum i, const GLvoid * j)
{
	(*HostCall_p)(NFOSMESA_GLTEXIMAGE3DEXT,cur_context,&a);
}

void APIENTRY glTexSubImage3DEXT (GLenum a, GLint b, GLint c, GLint d, GLint e, GLsizei f, GLsizei g, GLsizei h, GLenum i, GLenum j, const GLvoid * k)
{
	(*HostCall_p)(NFOSMESA_GLTEXSUBIMAGE3DEXT,cur_context,&a);
}

void APIENTRY glGetTexFilterFuncSGIS (GLenum a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETTEXFILTERFUNCSGIS,cur_context,&a);
}

void APIENTRY glTexFilterFuncSGIS (GLenum a, GLenum b, GLsizei c, const GLfloat * d)
{
	(*HostCall_p)(NFOSMESA_GLTEXFILTERFUNCSGIS,cur_context,&a);
}

void APIENTRY glTexSubImage1DEXT (GLenum a, GLint b, GLint c, GLsizei d, GLenum e, GLenum f, const GLvoid * g)
{
	(*HostCall_p)(NFOSMESA_GLTEXSUBIMAGE1DEXT,cur_context,&a);
}

void APIENTRY glTexSubImage2DEXT (GLenum a, GLint b, GLint c, GLint d, GLsizei e, GLsizei f, GLenum g, GLenum h, const GLvoid * i)
{
	(*HostCall_p)(NFOSMESA_GLTEXSUBIMAGE2DEXT,cur_context,&a);
}

void APIENTRY glCopyTexImage1DEXT (GLenum a, GLint b, GLenum c, GLint d, GLint e, GLsizei f, GLint g)
{
	(*HostCall_p)(NFOSMESA_GLCOPYTEXIMAGE1DEXT,cur_context,&a);
}

void APIENTRY glCopyTexImage2DEXT (GLenum a, GLint b, GLenum c, GLint d, GLint e, GLsizei f, GLsizei g, GLint h)
{
	(*HostCall_p)(NFOSMESA_GLCOPYTEXIMAGE2DEXT,cur_context,&a);
}

void APIENTRY glCopyTexSubImage1DEXT (GLenum a, GLint b, GLint c, GLint d, GLint e, GLsizei f)
{
	(*HostCall_p)(NFOSMESA_GLCOPYTEXSUBIMAGE1DEXT,cur_context,&a);
}

void APIENTRY glCopyTexSubImage2DEXT (GLenum a, GLint b, GLint c, GLint d, GLint e, GLint f, GLsizei g, GLsizei h)
{
	(*HostCall_p)(NFOSMESA_GLCOPYTEXSUBIMAGE2DEXT,cur_context,&a);
}

void APIENTRY glCopyTexSubImage3DEXT (GLenum a, GLint b, GLint c, GLint d, GLint e, GLint f, GLint g, GLsizei h, GLsizei i)
{
	(*HostCall_p)(NFOSMESA_GLCOPYTEXSUBIMAGE3DEXT,cur_context,&a);
}

void APIENTRY glGetHistogramEXT (GLenum a, GLboolean b, GLenum c, GLenum d, GLvoid * e)
{
	(*HostCall_p)(NFOSMESA_GLGETHISTOGRAMEXT,cur_context,&a);
}

void APIENTRY glGetHistogramParameterfvEXT (GLenum a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETHISTOGRAMPARAMETERFVEXT,cur_context,&a);
}

void APIENTRY glGetHistogramParameterivEXT (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETHISTOGRAMPARAMETERIVEXT,cur_context,&a);
}

void APIENTRY glGetMinmaxEXT (GLenum a, GLboolean b, GLenum c, GLenum d, GLvoid * e)
{
	(*HostCall_p)(NFOSMESA_GLGETMINMAXEXT,cur_context,&a);
}

void APIENTRY glGetMinmaxParameterfvEXT (GLenum a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETMINMAXPARAMETERFVEXT,cur_context,&a);
}

void APIENTRY glGetMinmaxParameterivEXT (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETMINMAXPARAMETERIVEXT,cur_context,&a);
}

void APIENTRY glHistogramEXT (GLenum a, GLsizei b, GLenum c, GLboolean d)
{
	(*HostCall_p)(NFOSMESA_GLHISTOGRAMEXT,cur_context,&a);
}

void APIENTRY glMinmaxEXT (GLenum a, GLenum b, GLboolean c)
{
	(*HostCall_p)(NFOSMESA_GLMINMAXEXT,cur_context,&a);
}

void APIENTRY glResetHistogramEXT (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLRESETHISTOGRAMEXT,cur_context,&a);
}

void APIENTRY glResetMinmaxEXT (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLRESETMINMAXEXT,cur_context,&a);
}

void APIENTRY glConvolutionFilter1DEXT (GLenum a, GLenum b, GLsizei c, GLenum d, GLenum e, const GLvoid * f)
{
	(*HostCall_p)(NFOSMESA_GLCONVOLUTIONFILTER1DEXT,cur_context,&a);
}

void APIENTRY glConvolutionFilter2DEXT (GLenum a, GLenum b, GLsizei c, GLsizei d, GLenum e, GLenum f, const GLvoid * g)
{
	(*HostCall_p)(NFOSMESA_GLCONVOLUTIONFILTER2DEXT,cur_context,&a);
}

void APIENTRY glConvolutionParameterfEXT (GLenum a, GLenum b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLCONVOLUTIONPARAMETERFEXT,cur_context,&a);
}

void APIENTRY glConvolutionParameterfvEXT (GLenum a, GLenum b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLCONVOLUTIONPARAMETERFVEXT,cur_context,&a);
}

void APIENTRY glConvolutionParameteriEXT (GLenum a, GLenum b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLCONVOLUTIONPARAMETERIEXT,cur_context,&a);
}

void APIENTRY glConvolutionParameterivEXT (GLenum a, GLenum b, const GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLCONVOLUTIONPARAMETERIVEXT,cur_context,&a);
}

void APIENTRY glCopyConvolutionFilter1DEXT (GLenum a, GLenum b, GLint c, GLint d, GLsizei e)
{
	(*HostCall_p)(NFOSMESA_GLCOPYCONVOLUTIONFILTER1DEXT,cur_context,&a);
}

void APIENTRY glCopyConvolutionFilter2DEXT (GLenum a, GLenum b, GLint c, GLint d, GLsizei e, GLsizei f)
{
	(*HostCall_p)(NFOSMESA_GLCOPYCONVOLUTIONFILTER2DEXT,cur_context,&a);
}

void APIENTRY glGetConvolutionFilterEXT (GLenum a, GLenum b, GLenum c, GLvoid * d)
{
	(*HostCall_p)(NFOSMESA_GLGETCONVOLUTIONFILTEREXT,cur_context,&a);
}

void APIENTRY glGetConvolutionParameterfvEXT (GLenum a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETCONVOLUTIONPARAMETERFVEXT,cur_context,&a);
}

void APIENTRY glGetConvolutionParameterivEXT (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETCONVOLUTIONPARAMETERIVEXT,cur_context,&a);
}

void APIENTRY glGetSeparableFilterEXT (GLenum a, GLenum b, GLenum c, GLvoid * d, GLvoid * e, GLvoid * f)
{
	(*HostCall_p)(NFOSMESA_GLGETSEPARABLEFILTEREXT,cur_context,&a);
}

void APIENTRY glSeparableFilter2DEXT (GLenum a, GLenum b, GLsizei c, GLsizei d, GLenum e, GLenum f, const GLvoid * g, const GLvoid * h)
{
	(*HostCall_p)(NFOSMESA_GLSEPARABLEFILTER2DEXT,cur_context,&a);
}

void APIENTRY glColorTableSGI (GLenum a, GLenum b, GLsizei c, GLenum d, GLenum e, const GLvoid * f)
{
	(*HostCall_p)(NFOSMESA_GLCOLORTABLESGI,cur_context,&a);
}

void APIENTRY glColorTableParameterfvSGI (GLenum a, GLenum b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLCOLORTABLEPARAMETERFVSGI,cur_context,&a);
}

void APIENTRY glColorTableParameterivSGI (GLenum a, GLenum b, const GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLCOLORTABLEPARAMETERIVSGI,cur_context,&a);
}

void APIENTRY glCopyColorTableSGI (GLenum a, GLenum b, GLint c, GLint d, GLsizei e)
{
	(*HostCall_p)(NFOSMESA_GLCOPYCOLORTABLESGI,cur_context,&a);
}

void APIENTRY glGetColorTableSGI (GLenum a, GLenum b, GLenum c, GLvoid * d)
{
	(*HostCall_p)(NFOSMESA_GLGETCOLORTABLESGI,cur_context,&a);
}

void APIENTRY glGetColorTableParameterfvSGI (GLenum a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETCOLORTABLEPARAMETERFVSGI,cur_context,&a);
}

void APIENTRY glGetColorTableParameterivSGI (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETCOLORTABLEPARAMETERIVSGI,cur_context,&a);
}

void APIENTRY glPixelTexGenSGIX (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLPIXELTEXGENSGIX,cur_context,&a);
}

void APIENTRY glPixelTexGenParameteriSGIS (GLenum a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLPIXELTEXGENPARAMETERISGIS,cur_context,&a);
}

void APIENTRY glPixelTexGenParameterivSGIS (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLPIXELTEXGENPARAMETERIVSGIS,cur_context,&a);
}

void APIENTRY glPixelTexGenParameterfSGIS (GLenum a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLPIXELTEXGENPARAMETERFSGIS,cur_context,&a);
}

void APIENTRY glPixelTexGenParameterfvSGIS (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLPIXELTEXGENPARAMETERFVSGIS,cur_context,&a);
}

void APIENTRY glGetPixelTexGenParameterivSGIS (GLenum a, GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLGETPIXELTEXGENPARAMETERIVSGIS,cur_context,&a);
}

void APIENTRY glGetPixelTexGenParameterfvSGIS (GLenum a, GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLGETPIXELTEXGENPARAMETERFVSGIS,cur_context,&a);
}

void APIENTRY glTexImage4DSGIS (GLenum a, GLint b, GLenum c, GLsizei d, GLsizei e, GLsizei f, GLsizei g, GLint h, GLenum i, GLenum j, const GLvoid * k)
{
	(*HostCall_p)(NFOSMESA_GLTEXIMAGE4DSGIS,cur_context,&a);
}

void APIENTRY glTexSubImage4DSGIS (GLenum a, GLint b, GLint c, GLint d, GLint e, GLint f, GLsizei g, GLsizei h, GLsizei i, GLsizei j, GLenum k, GLenum l, const GLvoid * m)
{
	(*HostCall_p)(NFOSMESA_GLTEXSUBIMAGE4DSGIS,cur_context,&a);
}

GLboolean APIENTRY glAreTexturesResidentEXT (GLsizei a, const GLuint * b, GLboolean * c)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLARETEXTURESRESIDENTEXT,cur_context,&a);
}

void APIENTRY glBindTextureEXT (GLenum a, GLuint b)
{
	(*HostCall_p)(NFOSMESA_GLBINDTEXTUREEXT,cur_context,&a);
}

void APIENTRY glDeleteTexturesEXT (GLsizei a, const GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLDELETETEXTURESEXT,cur_context,&a);
}

void APIENTRY glGenTexturesEXT (GLsizei a, GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLGENTEXTURESEXT,cur_context,&a);
}

GLboolean APIENTRY glIsTextureEXT (GLuint a)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLISTEXTUREEXT,cur_context,&a);
}

void APIENTRY glPrioritizeTexturesEXT (GLsizei a, const GLuint * b, const GLclampf * c)
{
	(*HostCall_p)(NFOSMESA_GLPRIORITIZETEXTURESEXT,cur_context,&a);
}

void APIENTRY glDetailTexFuncSGIS (GLenum a, GLsizei b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLDETAILTEXFUNCSGIS,cur_context,&a);
}

void APIENTRY glGetDetailTexFuncSGIS (GLenum a, GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLGETDETAILTEXFUNCSGIS,cur_context,&a);
}

void APIENTRY glSharpenTexFuncSGIS (GLenum a, GLsizei b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLSHARPENTEXFUNCSGIS,cur_context,&a);
}

void APIENTRY glGetSharpenTexFuncSGIS (GLenum a, GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLGETSHARPENTEXFUNCSGIS,cur_context,&a);
}

void APIENTRY glSampleMaskSGIS (GLclampf a, GLboolean b)
{
	(*HostCall_p)(NFOSMESA_GLSAMPLEMASKSGIS,cur_context,&a);
}

void APIENTRY glSamplePatternSGIS (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLSAMPLEPATTERNSGIS,cur_context,&a);
}

void APIENTRY glArrayElementEXT (GLint a)
{
	(*HostCall_p)(NFOSMESA_GLARRAYELEMENTEXT,cur_context,&a);
}

void APIENTRY glColorPointerEXT (GLint a, GLenum b, GLsizei c, GLsizei d, const GLvoid * e)
{
	(*HostCall_p)(NFOSMESA_GLCOLORPOINTEREXT,cur_context,&a);
}

void APIENTRY glDrawArraysEXT (GLenum a, GLint b, GLsizei c)
{
	(*HostCall_p)(NFOSMESA_GLDRAWARRAYSEXT,cur_context,&a);
}

void APIENTRY glEdgeFlagPointerEXT (GLsizei a, GLsizei b, const GLboolean * c)
{
	(*HostCall_p)(NFOSMESA_GLEDGEFLAGPOINTEREXT,cur_context,&a);
}

void APIENTRY glGetPointervEXT (GLenum a, GLvoid* * b)
{
	(*HostCall_p)(NFOSMESA_GLGETPOINTERVEXT,cur_context,&a);
}

void APIENTRY glIndexPointerEXT (GLenum a, GLsizei b, GLsizei c, const GLvoid * d)
{
	(*HostCall_p)(NFOSMESA_GLINDEXPOINTEREXT,cur_context,&a);
}

void APIENTRY glNormalPointerEXT (GLenum a, GLsizei b, GLsizei c, const GLvoid * d)
{
	(*HostCall_p)(NFOSMESA_GLNORMALPOINTEREXT,cur_context,&a);
}

void APIENTRY glTexCoordPointerEXT (GLint a, GLenum b, GLsizei c, GLsizei d, const GLvoid * e)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORDPOINTEREXT,cur_context,&a);
}

void APIENTRY glVertexPointerEXT (GLint a, GLenum b, GLsizei c, GLsizei d, const GLvoid * e)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXPOINTEREXT,cur_context,&a);
}

void APIENTRY glBlendEquationEXT (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLBLENDEQUATIONEXT,cur_context,&a);
}

void APIENTRY glSpriteParameterfSGIX (GLenum a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLSPRITEPARAMETERFSGIX,cur_context,&a);
}

void APIENTRY glSpriteParameterfvSGIX (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLSPRITEPARAMETERFVSGIX,cur_context,&a);
}

void APIENTRY glSpriteParameteriSGIX (GLenum a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLSPRITEPARAMETERISGIX,cur_context,&a);
}

void APIENTRY glSpriteParameterivSGIX (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLSPRITEPARAMETERIVSGIX,cur_context,&a);
}

void APIENTRY glPointParameterfEXT (GLenum a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLPOINTPARAMETERFEXT,cur_context,&a);
}

void APIENTRY glPointParameterfvEXT (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLPOINTPARAMETERFVEXT,cur_context,&a);
}

void APIENTRY glPointParameterfSGIS (GLenum a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLPOINTPARAMETERFSGIS,cur_context,&a);
}

void APIENTRY glPointParameterfvSGIS (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLPOINTPARAMETERFVSGIS,cur_context,&a);
}

GLint APIENTRY glGetInstrumentsSGIX (void)
{
	return (GLint)(*HostCall_p)(NFOSMESA_GLGETINSTRUMENTSSGIX,cur_context,NULL);
}

void APIENTRY glInstrumentsBufferSGIX (GLsizei a, GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLINSTRUMENTSBUFFERSGIX,cur_context,&a);
}

GLint APIENTRY glPollInstrumentsSGIX (GLint * a)
{
	return (GLint)(*HostCall_p)(NFOSMESA_GLPOLLINSTRUMENTSSGIX,cur_context,&a);
}

void APIENTRY glReadInstrumentsSGIX (GLint a)
{
	(*HostCall_p)(NFOSMESA_GLREADINSTRUMENTSSGIX,cur_context,&a);
}

void APIENTRY glStartInstrumentsSGIX (void)
{
	(*HostCall_p)(NFOSMESA_GLSTARTINSTRUMENTSSGIX,cur_context,NULL);
}

void APIENTRY glStopInstrumentsSGIX (GLint a)
{
	(*HostCall_p)(NFOSMESA_GLSTOPINSTRUMENTSSGIX,cur_context,&a);
}

void APIENTRY glFrameZoomSGIX (GLint a)
{
	(*HostCall_p)(NFOSMESA_GLFRAMEZOOMSGIX,cur_context,&a);
}

void APIENTRY glTagSampleBufferSGIX (void)
{
	(*HostCall_p)(NFOSMESA_GLTAGSAMPLEBUFFERSGIX,cur_context,NULL);
}

void APIENTRY glDeformationMap3dSGIX (GLenum a, GLdouble b, GLdouble c, GLint d, GLint e, GLdouble f, GLdouble g, GLint h, GLint i, GLdouble j, GLdouble k, GLint l, GLint m, const GLdouble * n)
{
	(*HostCall_p)(NFOSMESA_GLDEFORMATIONMAP3DSGIX,cur_context,&a);
}

void APIENTRY glDeformationMap3fSGIX (GLenum a, GLfloat b, GLfloat c, GLint d, GLint e, GLfloat f, GLfloat g, GLint h, GLint i, GLfloat j, GLfloat k, GLint l, GLint m, const GLfloat * n)
{
	(*HostCall_p)(NFOSMESA_GLDEFORMATIONMAP3FSGIX,cur_context,&a);
}

void APIENTRY glDeformSGIX (GLbitfield a)
{
	(*HostCall_p)(NFOSMESA_GLDEFORMSGIX,cur_context,&a);
}

void APIENTRY glLoadIdentityDeformationMapSGIX (GLbitfield a)
{
	(*HostCall_p)(NFOSMESA_GLLOADIDENTITYDEFORMATIONMAPSGIX,cur_context,&a);
}

void APIENTRY glReferencePlaneSGIX (const GLdouble * a)
{
	(*HostCall_p)(NFOSMESA_GLREFERENCEPLANESGIX,cur_context,&a);
}

void APIENTRY glFlushRasterSGIX (void)
{
	(*HostCall_p)(NFOSMESA_GLFLUSHRASTERSGIX,cur_context,NULL);
}

void APIENTRY glFogFuncSGIS (GLsizei a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLFOGFUNCSGIS,cur_context,&a);
}

void APIENTRY glGetFogFuncSGIS (GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLGETFOGFUNCSGIS,cur_context,&a);
}

void APIENTRY glImageTransformParameteriHP (GLenum a, GLenum b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLIMAGETRANSFORMPARAMETERIHP,cur_context,&a);
}

void APIENTRY glImageTransformParameterfHP (GLenum a, GLenum b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLIMAGETRANSFORMPARAMETERFHP,cur_context,&a);
}

void APIENTRY glImageTransformParameterivHP (GLenum a, GLenum b, const GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLIMAGETRANSFORMPARAMETERIVHP,cur_context,&a);
}

void APIENTRY glImageTransformParameterfvHP (GLenum a, GLenum b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLIMAGETRANSFORMPARAMETERFVHP,cur_context,&a);
}

void APIENTRY glGetImageTransformParameterivHP (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETIMAGETRANSFORMPARAMETERIVHP,cur_context,&a);
}

void APIENTRY glGetImageTransformParameterfvHP (GLenum a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETIMAGETRANSFORMPARAMETERFVHP,cur_context,&a);
}

void APIENTRY glColorSubTableEXT (GLenum a, GLsizei b, GLsizei c, GLenum d, GLenum e, const GLvoid * f)
{
	(*HostCall_p)(NFOSMESA_GLCOLORSUBTABLEEXT,cur_context,&a);
}

void APIENTRY glCopyColorSubTableEXT (GLenum a, GLsizei b, GLint c, GLint d, GLsizei e)
{
	(*HostCall_p)(NFOSMESA_GLCOPYCOLORSUBTABLEEXT,cur_context,&a);
}

void APIENTRY glHintPGI (GLenum a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLHINTPGI,cur_context,&a);
}

void APIENTRY glColorTableEXT (GLenum a, GLenum b, GLsizei c, GLenum d, GLenum e, const GLvoid * f)
{
	(*HostCall_p)(NFOSMESA_GLCOLORTABLEEXT,cur_context,&a);
}

void APIENTRY glGetColorTableEXT (GLenum a, GLenum b, GLenum c, GLvoid * d)
{
	(*HostCall_p)(NFOSMESA_GLGETCOLORTABLEEXT,cur_context,&a);
}

void APIENTRY glGetColorTableParameterivEXT (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETCOLORTABLEPARAMETERIVEXT,cur_context,&a);
}

void APIENTRY glGetColorTableParameterfvEXT (GLenum a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETCOLORTABLEPARAMETERFVEXT,cur_context,&a);
}

void APIENTRY glGetListParameterfvSGIX (GLuint a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETLISTPARAMETERFVSGIX,cur_context,&a);
}

void APIENTRY glGetListParameterivSGIX (GLuint a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETLISTPARAMETERIVSGIX,cur_context,&a);
}

void APIENTRY glListParameterfSGIX (GLuint a, GLenum b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLLISTPARAMETERFSGIX,cur_context,&a);
}

void APIENTRY glListParameterfvSGIX (GLuint a, GLenum b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLLISTPARAMETERFVSGIX,cur_context,&a);
}

void APIENTRY glListParameteriSGIX (GLuint a, GLenum b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLLISTPARAMETERISGIX,cur_context,&a);
}

void APIENTRY glListParameterivSGIX (GLuint a, GLenum b, const GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLLISTPARAMETERIVSGIX,cur_context,&a);
}

void APIENTRY glIndexMaterialEXT (GLenum a, GLenum b)
{
	(*HostCall_p)(NFOSMESA_GLINDEXMATERIALEXT,cur_context,&a);
}

void APIENTRY glIndexFuncEXT (GLenum a, GLclampf b)
{
	(*HostCall_p)(NFOSMESA_GLINDEXFUNCEXT,cur_context,&a);
}

void APIENTRY glLockArraysEXT (GLint a, GLsizei b)
{
	(*HostCall_p)(NFOSMESA_GLLOCKARRAYSEXT,cur_context,&a);
}

void APIENTRY glUnlockArraysEXT (void)
{
	(*HostCall_p)(NFOSMESA_GLUNLOCKARRAYSEXT,cur_context,NULL);
}

void APIENTRY glCullParameterdvEXT (GLenum a, GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLCULLPARAMETERDVEXT,cur_context,&a);
}

void APIENTRY glCullParameterfvEXT (GLenum a, GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLCULLPARAMETERFVEXT,cur_context,&a);
}

void APIENTRY glFragmentColorMaterialSGIX (GLenum a, GLenum b)
{
	(*HostCall_p)(NFOSMESA_GLFRAGMENTCOLORMATERIALSGIX,cur_context,&a);
}

void APIENTRY glFragmentLightfSGIX (GLenum a, GLenum b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLFRAGMENTLIGHTFSGIX,cur_context,&a);
}

void APIENTRY glFragmentLightfvSGIX (GLenum a, GLenum b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLFRAGMENTLIGHTFVSGIX,cur_context,&a);
}

void APIENTRY glFragmentLightiSGIX (GLenum a, GLenum b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLFRAGMENTLIGHTISGIX,cur_context,&a);
}

void APIENTRY glFragmentLightivSGIX (GLenum a, GLenum b, const GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLFRAGMENTLIGHTIVSGIX,cur_context,&a);
}

void APIENTRY glFragmentLightModelfSGIX (GLenum a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLFRAGMENTLIGHTMODELFSGIX,cur_context,&a);
}

void APIENTRY glFragmentLightModelfvSGIX (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLFRAGMENTLIGHTMODELFVSGIX,cur_context,&a);
}

void APIENTRY glFragmentLightModeliSGIX (GLenum a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLFRAGMENTLIGHTMODELISGIX,cur_context,&a);
}

void APIENTRY glFragmentLightModelivSGIX (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLFRAGMENTLIGHTMODELIVSGIX,cur_context,&a);
}

void APIENTRY glFragmentMaterialfSGIX (GLenum a, GLenum b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLFRAGMENTMATERIALFSGIX,cur_context,&a);
}

void APIENTRY glFragmentMaterialfvSGIX (GLenum a, GLenum b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLFRAGMENTMATERIALFVSGIX,cur_context,&a);
}

void APIENTRY glFragmentMaterialiSGIX (GLenum a, GLenum b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLFRAGMENTMATERIALISGIX,cur_context,&a);
}

void APIENTRY glFragmentMaterialivSGIX (GLenum a, GLenum b, const GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLFRAGMENTMATERIALIVSGIX,cur_context,&a);
}

void APIENTRY glGetFragmentLightfvSGIX (GLenum a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETFRAGMENTLIGHTFVSGIX,cur_context,&a);
}

void APIENTRY glGetFragmentLightivSGIX (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETFRAGMENTLIGHTIVSGIX,cur_context,&a);
}

void APIENTRY glGetFragmentMaterialfvSGIX (GLenum a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETFRAGMENTMATERIALFVSGIX,cur_context,&a);
}

void APIENTRY glGetFragmentMaterialivSGIX (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETFRAGMENTMATERIALIVSGIX,cur_context,&a);
}

void APIENTRY glLightEnviSGIX (GLenum a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLLIGHTENVISGIX,cur_context,&a);
}

void APIENTRY glDrawRangeElementsEXT (GLenum a, GLuint b, GLuint c, GLsizei d, GLenum e, const GLvoid * f)
{
	(*HostCall_p)(NFOSMESA_GLDRAWRANGEELEMENTSEXT,cur_context,&a);
}

void APIENTRY glApplyTextureEXT (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLAPPLYTEXTUREEXT,cur_context,&a);
}

void APIENTRY glTextureLightEXT (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLTEXTURELIGHTEXT,cur_context,&a);
}

void APIENTRY glTextureMaterialEXT (GLenum a, GLenum b)
{
	(*HostCall_p)(NFOSMESA_GLTEXTUREMATERIALEXT,cur_context,&a);
}

void APIENTRY glAsyncMarkerSGIX (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLASYNCMARKERSGIX,cur_context,&a);
}

GLint APIENTRY glFinishAsyncSGIX (GLuint * a)
{
	return (GLint)(*HostCall_p)(NFOSMESA_GLFINISHASYNCSGIX,cur_context,&a);
}

GLint APIENTRY glPollAsyncSGIX (GLuint * a)
{
	return (GLint)(*HostCall_p)(NFOSMESA_GLPOLLASYNCSGIX,cur_context,&a);
}

GLuint APIENTRY glGenAsyncMarkersSGIX (GLsizei a)
{
	return (GLuint)(*HostCall_p)(NFOSMESA_GLGENASYNCMARKERSSGIX,cur_context,&a);
}

void APIENTRY glDeleteAsyncMarkersSGIX (GLuint a, GLsizei b)
{
	(*HostCall_p)(NFOSMESA_GLDELETEASYNCMARKERSSGIX,cur_context,&a);
}

GLboolean APIENTRY glIsAsyncMarkerSGIX (GLuint a)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLISASYNCMARKERSGIX,cur_context,&a);
}

void APIENTRY glVertexPointervINTEL (GLint a, GLenum b, const GLvoid* * c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXPOINTERVINTEL,cur_context,&a);
}

void APIENTRY glNormalPointervINTEL (GLenum a, const GLvoid* * b)
{
	(*HostCall_p)(NFOSMESA_GLNORMALPOINTERVINTEL,cur_context,&a);
}

void APIENTRY glColorPointervINTEL (GLint a, GLenum b, const GLvoid* * c)
{
	(*HostCall_p)(NFOSMESA_GLCOLORPOINTERVINTEL,cur_context,&a);
}

void APIENTRY glTexCoordPointervINTEL (GLint a, GLenum b, const GLvoid* * c)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORDPOINTERVINTEL,cur_context,&a);
}

void APIENTRY glPixelTransformParameteriEXT (GLenum a, GLenum b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLPIXELTRANSFORMPARAMETERIEXT,cur_context,&a);
}

void APIENTRY glPixelTransformParameterfEXT (GLenum a, GLenum b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLPIXELTRANSFORMPARAMETERFEXT,cur_context,&a);
}

void APIENTRY glPixelTransformParameterivEXT (GLenum a, GLenum b, const GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLPIXELTRANSFORMPARAMETERIVEXT,cur_context,&a);
}

void APIENTRY glPixelTransformParameterfvEXT (GLenum a, GLenum b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLPIXELTRANSFORMPARAMETERFVEXT,cur_context,&a);
}

void APIENTRY glSecondaryColor3bEXT (GLbyte a, GLbyte b, GLbyte c)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3BEXT,cur_context,&a);
}

void APIENTRY glSecondaryColor3bvEXT (const GLbyte * a)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3BVEXT,cur_context,&a);
}

void APIENTRY glSecondaryColor3dEXT (GLdouble a, GLdouble b, GLdouble c)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3DEXT,cur_context,&a);
}

void APIENTRY glSecondaryColor3dvEXT (const GLdouble * a)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3DVEXT,cur_context,&a);
}

void APIENTRY glSecondaryColor3fEXT (GLfloat a, GLfloat b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3FEXT,cur_context,&a);
}

void APIENTRY glSecondaryColor3fvEXT (const GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3FVEXT,cur_context,&a);
}

void APIENTRY glSecondaryColor3iEXT (GLint a, GLint b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3IEXT,cur_context,&a);
}

void APIENTRY glSecondaryColor3ivEXT (const GLint * a)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3IVEXT,cur_context,&a);
}

void APIENTRY glSecondaryColor3sEXT (GLshort a, GLshort b, GLshort c)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3SEXT,cur_context,&a);
}

void APIENTRY glSecondaryColor3svEXT (const GLshort * a)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3SVEXT,cur_context,&a);
}

void APIENTRY glSecondaryColor3ubEXT (GLubyte a, GLubyte b, GLubyte c)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3UBEXT,cur_context,&a);
}

void APIENTRY glSecondaryColor3ubvEXT (const GLubyte * a)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3UBVEXT,cur_context,&a);
}

void APIENTRY glSecondaryColor3uiEXT (GLuint a, GLuint b, GLuint c)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3UIEXT,cur_context,&a);
}

void APIENTRY glSecondaryColor3uivEXT (const GLuint * a)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3UIVEXT,cur_context,&a);
}

void APIENTRY glSecondaryColor3usEXT (GLushort a, GLushort b, GLushort c)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3USEXT,cur_context,&a);
}

void APIENTRY glSecondaryColor3usvEXT (const GLushort * a)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3USVEXT,cur_context,&a);
}

void APIENTRY glSecondaryColorPointerEXT (GLint a, GLenum b, GLsizei c, const GLvoid * d)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLORPOINTEREXT,cur_context,&a);
}

void APIENTRY glTextureNormalEXT (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLTEXTURENORMALEXT,cur_context,&a);
}

void APIENTRY glMultiDrawArraysEXT (GLenum a, GLint * b, GLsizei * c, GLsizei d)
{
	(*HostCall_p)(NFOSMESA_GLMULTIDRAWARRAYSEXT,cur_context,&a);
}

void APIENTRY glMultiDrawElementsEXT (GLenum a, const GLsizei * b, GLenum c, const GLvoid* * d, GLsizei e)
{
	(*HostCall_p)(NFOSMESA_GLMULTIDRAWELEMENTSEXT,cur_context,&a);
}

void APIENTRY glFogCoordfEXT (GLfloat a)
{
	(*HostCall_p)(NFOSMESA_GLFOGCOORDFEXT,cur_context,&a);
}

void APIENTRY glFogCoordfvEXT (const GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLFOGCOORDFVEXT,cur_context,&a);
}

void APIENTRY glFogCoorddEXT (GLdouble a)
{
	(*HostCall_p)(NFOSMESA_GLFOGCOORDDEXT,cur_context,&a);
}

void APIENTRY glFogCoorddvEXT (const GLdouble * a)
{
	(*HostCall_p)(NFOSMESA_GLFOGCOORDDVEXT,cur_context,&a);
}

void APIENTRY glFogCoordPointerEXT (GLenum a, GLsizei b, const GLvoid * c)
{
	(*HostCall_p)(NFOSMESA_GLFOGCOORDPOINTEREXT,cur_context,&a);
}

void APIENTRY glTangent3bEXT (GLbyte a, GLbyte b, GLbyte c)
{
	(*HostCall_p)(NFOSMESA_GLTANGENT3BEXT,cur_context,&a);
}

void APIENTRY glTangent3bvEXT (const GLbyte * a)
{
	(*HostCall_p)(NFOSMESA_GLTANGENT3BVEXT,cur_context,&a);
}

void APIENTRY glTangent3dEXT (GLdouble a, GLdouble b, GLdouble c)
{
	(*HostCall_p)(NFOSMESA_GLTANGENT3DEXT,cur_context,&a);
}

void APIENTRY glTangent3dvEXT (const GLdouble * a)
{
	(*HostCall_p)(NFOSMESA_GLTANGENT3DVEXT,cur_context,&a);
}

void APIENTRY glTangent3fEXT (GLfloat a, GLfloat b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLTANGENT3FEXT,cur_context,&a);
}

void APIENTRY glTangent3fvEXT (const GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLTANGENT3FVEXT,cur_context,&a);
}

void APIENTRY glTangent3iEXT (GLint a, GLint b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLTANGENT3IEXT,cur_context,&a);
}

void APIENTRY glTangent3ivEXT (const GLint * a)
{
	(*HostCall_p)(NFOSMESA_GLTANGENT3IVEXT,cur_context,&a);
}

void APIENTRY glTangent3sEXT (GLshort a, GLshort b, GLshort c)
{
	(*HostCall_p)(NFOSMESA_GLTANGENT3SEXT,cur_context,&a);
}

void APIENTRY glTangent3svEXT (const GLshort * a)
{
	(*HostCall_p)(NFOSMESA_GLTANGENT3SVEXT,cur_context,&a);
}

void APIENTRY glBinormal3bEXT (GLbyte a, GLbyte b, GLbyte c)
{
	(*HostCall_p)(NFOSMESA_GLBINORMAL3BEXT,cur_context,&a);
}

void APIENTRY glBinormal3bvEXT (const GLbyte * a)
{
	(*HostCall_p)(NFOSMESA_GLBINORMAL3BVEXT,cur_context,&a);
}

void APIENTRY glBinormal3dEXT (GLdouble a, GLdouble b, GLdouble c)
{
	(*HostCall_p)(NFOSMESA_GLBINORMAL3DEXT,cur_context,&a);
}

void APIENTRY glBinormal3dvEXT (const GLdouble * a)
{
	(*HostCall_p)(NFOSMESA_GLBINORMAL3DVEXT,cur_context,&a);
}

void APIENTRY glBinormal3fEXT (GLfloat a, GLfloat b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLBINORMAL3FEXT,cur_context,&a);
}

void APIENTRY glBinormal3fvEXT (const GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLBINORMAL3FVEXT,cur_context,&a);
}

void APIENTRY glBinormal3iEXT (GLint a, GLint b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLBINORMAL3IEXT,cur_context,&a);
}

void APIENTRY glBinormal3ivEXT (const GLint * a)
{
	(*HostCall_p)(NFOSMESA_GLBINORMAL3IVEXT,cur_context,&a);
}

void APIENTRY glBinormal3sEXT (GLshort a, GLshort b, GLshort c)
{
	(*HostCall_p)(NFOSMESA_GLBINORMAL3SEXT,cur_context,&a);
}

void APIENTRY glBinormal3svEXT (const GLshort * a)
{
	(*HostCall_p)(NFOSMESA_GLBINORMAL3SVEXT,cur_context,&a);
}

void APIENTRY glTangentPointerEXT (GLenum a, GLsizei b, const GLvoid * c)
{
	(*HostCall_p)(NFOSMESA_GLTANGENTPOINTEREXT,cur_context,&a);
}

void APIENTRY glBinormalPointerEXT (GLenum a, GLsizei b, const GLvoid * c)
{
	(*HostCall_p)(NFOSMESA_GLBINORMALPOINTEREXT,cur_context,&a);
}

void APIENTRY glFinishTextureSUNX (void)
{
	(*HostCall_p)(NFOSMESA_GLFINISHTEXTURESUNX,cur_context,NULL);
}

void APIENTRY glGlobalAlphaFactorbSUN (GLbyte a)
{
	(*HostCall_p)(NFOSMESA_GLGLOBALALPHAFACTORBSUN,cur_context,&a);
}

void APIENTRY glGlobalAlphaFactorsSUN (GLshort a)
{
	(*HostCall_p)(NFOSMESA_GLGLOBALALPHAFACTORSSUN,cur_context,&a);
}

void APIENTRY glGlobalAlphaFactoriSUN (GLint a)
{
	(*HostCall_p)(NFOSMESA_GLGLOBALALPHAFACTORISUN,cur_context,&a);
}

void APIENTRY glGlobalAlphaFactorfSUN (GLfloat a)
{
	(*HostCall_p)(NFOSMESA_GLGLOBALALPHAFACTORFSUN,cur_context,&a);
}

void APIENTRY glGlobalAlphaFactordSUN (GLdouble a)
{
	(*HostCall_p)(NFOSMESA_GLGLOBALALPHAFACTORDSUN,cur_context,&a);
}

void APIENTRY glGlobalAlphaFactorubSUN (GLubyte a)
{
	(*HostCall_p)(NFOSMESA_GLGLOBALALPHAFACTORUBSUN,cur_context,&a);
}

void APIENTRY glGlobalAlphaFactorusSUN (GLushort a)
{
	(*HostCall_p)(NFOSMESA_GLGLOBALALPHAFACTORUSSUN,cur_context,&a);
}

void APIENTRY glGlobalAlphaFactoruiSUN (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLGLOBALALPHAFACTORUISUN,cur_context,&a);
}

void APIENTRY glReplacementCodeuiSUN (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUISUN,cur_context,&a);
}

void APIENTRY glReplacementCodeusSUN (GLushort a)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUSSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeubSUN (GLubyte a)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUBSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeuivSUN (const GLuint * a)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUIVSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeusvSUN (const GLushort * a)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUSVSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeubvSUN (const GLubyte * a)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUBVSUN,cur_context,&a);
}

void APIENTRY glReplacementCodePointerSUN (GLenum a, GLsizei b, const GLvoid* * c)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEPOINTERSUN,cur_context,&a);
}

void APIENTRY glColor4ubVertex2fSUN (GLubyte a, GLubyte b, GLubyte c, GLubyte d, GLfloat e, GLfloat f)
{
	(*HostCall_p)(NFOSMESA_GLCOLOR4UBVERTEX2FSUN,cur_context,&a);
}

void APIENTRY glColor4ubVertex2fvSUN (const GLubyte * a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLCOLOR4UBVERTEX2FVSUN,cur_context,&a);
}

void APIENTRY glColor4ubVertex3fSUN (GLubyte a, GLubyte b, GLubyte c, GLubyte d, GLfloat e, GLfloat f, GLfloat g)
{
	(*HostCall_p)(NFOSMESA_GLCOLOR4UBVERTEX3FSUN,cur_context,&a);
}

void APIENTRY glColor4ubVertex3fvSUN (const GLubyte * a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLCOLOR4UBVERTEX3FVSUN,cur_context,&a);
}

void APIENTRY glColor3fVertex3fSUN (GLfloat a, GLfloat b, GLfloat c, GLfloat d, GLfloat e, GLfloat f)
{
	(*HostCall_p)(NFOSMESA_GLCOLOR3FVERTEX3FSUN,cur_context,&a);
}

void APIENTRY glColor3fVertex3fvSUN (const GLfloat * a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLCOLOR3FVERTEX3FVSUN,cur_context,&a);
}

void APIENTRY glNormal3fVertex3fSUN (GLfloat a, GLfloat b, GLfloat c, GLfloat d, GLfloat e, GLfloat f)
{
	(*HostCall_p)(NFOSMESA_GLNORMAL3FVERTEX3FSUN,cur_context,&a);
}

void APIENTRY glNormal3fVertex3fvSUN (const GLfloat * a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLNORMAL3FVERTEX3FVSUN,cur_context,&a);
}

void APIENTRY glColor4fNormal3fVertex3fSUN (GLfloat a, GLfloat b, GLfloat c, GLfloat d, GLfloat e, GLfloat f, GLfloat g, GLfloat h, GLfloat i, GLfloat j)
{
	(*HostCall_p)(NFOSMESA_GLCOLOR4FNORMAL3FVERTEX3FSUN,cur_context,&a);
}

void APIENTRY glColor4fNormal3fVertex3fvSUN (const GLfloat * a, const GLfloat * b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLCOLOR4FNORMAL3FVERTEX3FVSUN,cur_context,&a);
}

void APIENTRY glTexCoord2fVertex3fSUN (GLfloat a, GLfloat b, GLfloat c, GLfloat d, GLfloat e)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD2FVERTEX3FSUN,cur_context,&a);
}

void APIENTRY glTexCoord2fVertex3fvSUN (const GLfloat * a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD2FVERTEX3FVSUN,cur_context,&a);
}

void APIENTRY glTexCoord4fVertex4fSUN (GLfloat a, GLfloat b, GLfloat c, GLfloat d, GLfloat e, GLfloat f, GLfloat g, GLfloat h)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD4FVERTEX4FSUN,cur_context,&a);
}

void APIENTRY glTexCoord4fVertex4fvSUN (const GLfloat * a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD4FVERTEX4FVSUN,cur_context,&a);
}

void APIENTRY glTexCoord2fColor4ubVertex3fSUN (GLfloat a, GLfloat b, GLubyte c, GLubyte d, GLubyte e, GLubyte f, GLfloat g, GLfloat h, GLfloat i)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD2FCOLOR4UBVERTEX3FSUN,cur_context,&a);
}

void APIENTRY glTexCoord2fColor4ubVertex3fvSUN (const GLfloat * a, const GLubyte * b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD2FCOLOR4UBVERTEX3FVSUN,cur_context,&a);
}

void APIENTRY glTexCoord2fColor3fVertex3fSUN (GLfloat a, GLfloat b, GLfloat c, GLfloat d, GLfloat e, GLfloat f, GLfloat g, GLfloat h)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD2FCOLOR3FVERTEX3FSUN,cur_context,&a);
}

void APIENTRY glTexCoord2fColor3fVertex3fvSUN (const GLfloat * a, const GLfloat * b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD2FCOLOR3FVERTEX3FVSUN,cur_context,&a);
}

void APIENTRY glTexCoord2fNormal3fVertex3fSUN (GLfloat a, GLfloat b, GLfloat c, GLfloat d, GLfloat e, GLfloat f, GLfloat g, GLfloat h)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD2FNORMAL3FVERTEX3FSUN,cur_context,&a);
}

void APIENTRY glTexCoord2fNormal3fVertex3fvSUN (const GLfloat * a, const GLfloat * b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD2FNORMAL3FVERTEX3FVSUN,cur_context,&a);
}

void APIENTRY glTexCoord2fColor4fNormal3fVertex3fSUN (GLfloat a, GLfloat b, GLfloat c, GLfloat d, GLfloat e, GLfloat f, GLfloat g, GLfloat h, GLfloat i, GLfloat j, GLfloat k, GLfloat l)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUN,cur_context,&a);
}

void APIENTRY glTexCoord2fColor4fNormal3fVertex3fvSUN (const GLfloat * a, const GLfloat * b, const GLfloat * c, const GLfloat * d)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUN,cur_context,&a);
}

void APIENTRY glTexCoord4fColor4fNormal3fVertex4fSUN (GLfloat a, GLfloat b, GLfloat c, GLfloat d, GLfloat e, GLfloat f, GLfloat g, GLfloat h, GLfloat i, GLfloat j, GLfloat k, GLfloat l, GLfloat m, GLfloat n, GLfloat o)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FSUN,cur_context,&a);
}

void APIENTRY glTexCoord4fColor4fNormal3fVertex4fvSUN (const GLfloat * a, const GLfloat * b, const GLfloat * c, const GLfloat * d)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FVSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeuiVertex3fSUN (GLuint a, GLfloat b, GLfloat c, GLfloat d)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUIVERTEX3FSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeuiVertex3fvSUN (const GLuint * a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUIVERTEX3FVSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeuiColor4ubVertex3fSUN (GLuint a, GLubyte b, GLubyte c, GLubyte d, GLubyte e, GLfloat f, GLfloat g, GLfloat h)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUICOLOR4UBVERTEX3FSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeuiColor4ubVertex3fvSUN (const GLuint * a, const GLubyte * b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUICOLOR4UBVERTEX3FVSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeuiColor3fVertex3fSUN (GLuint a, GLfloat b, GLfloat c, GLfloat d, GLfloat e, GLfloat f, GLfloat g)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUICOLOR3FVERTEX3FSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeuiColor3fVertex3fvSUN (const GLuint * a, const GLfloat * b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUICOLOR3FVERTEX3FVSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeuiNormal3fVertex3fSUN (GLuint a, GLfloat b, GLfloat c, GLfloat d, GLfloat e, GLfloat f, GLfloat g)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUINORMAL3FVERTEX3FSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeuiNormal3fVertex3fvSUN (const GLuint * a, const GLfloat * b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUINORMAL3FVERTEX3FVSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeuiColor4fNormal3fVertex3fSUN (GLuint a, GLfloat b, GLfloat c, GLfloat d, GLfloat e, GLfloat f, GLfloat g, GLfloat h, GLfloat i, GLfloat j, GLfloat k)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeuiColor4fNormal3fVertex3fvSUN (const GLuint * a, const GLfloat * b, const GLfloat * c, const GLfloat * d)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FVSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeuiTexCoord2fVertex3fSUN (GLuint a, GLfloat b, GLfloat c, GLfloat d, GLfloat e, GLfloat f)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUITEXCOORD2FVERTEX3FSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeuiTexCoord2fVertex3fvSUN (const GLuint * a, const GLfloat * b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUITEXCOORD2FVERTEX3FVSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN (GLuint a, GLfloat b, GLfloat c, GLfloat d, GLfloat e, GLfloat f, GLfloat g, GLfloat h, GLfloat i)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN (const GLuint * a, const GLfloat * b, const GLfloat * c, const GLfloat * d)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FVSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN (GLuint a, GLfloat b, GLfloat c, GLfloat d, GLfloat e, GLfloat f, GLfloat g, GLfloat h, GLfloat i, GLfloat j, GLfloat k, GLfloat l, GLfloat m)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUN,cur_context,&a);
}

void APIENTRY glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN (const GLuint * a, const GLfloat * b, const GLfloat * c, const GLfloat * d, const GLfloat * e)
{
	(*HostCall_p)(NFOSMESA_GLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUN,cur_context,&a);
}

void APIENTRY glBlendFuncSeparateEXT (GLenum a, GLenum b, GLenum c, GLenum d)
{
	(*HostCall_p)(NFOSMESA_GLBLENDFUNCSEPARATEEXT,cur_context,&a);
}

void APIENTRY glBlendFuncSeparateINGR (GLenum a, GLenum b, GLenum c, GLenum d)
{
	(*HostCall_p)(NFOSMESA_GLBLENDFUNCSEPARATEINGR,cur_context,&a);
}

void APIENTRY glVertexWeightfEXT (GLfloat a)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXWEIGHTFEXT,cur_context,&a);
}

void APIENTRY glVertexWeightfvEXT (const GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXWEIGHTFVEXT,cur_context,&a);
}

void APIENTRY glVertexWeightPointerEXT (GLsizei a, GLenum b, GLsizei c, const GLvoid * d)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXWEIGHTPOINTEREXT,cur_context,&a);
}

void APIENTRY glFlushVertexArrayRangeNV (void)
{
	(*HostCall_p)(NFOSMESA_GLFLUSHVERTEXARRAYRANGENV,cur_context,NULL);
}

void APIENTRY glVertexArrayRangeNV (GLsizei a, const GLvoid * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXARRAYRANGENV,cur_context,&a);
}

void APIENTRY glCombinerParameterfvNV (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLCOMBINERPARAMETERFVNV,cur_context,&a);
}

void APIENTRY glCombinerParameterfNV (GLenum a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLCOMBINERPARAMETERFNV,cur_context,&a);
}

void APIENTRY glCombinerParameterivNV (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLCOMBINERPARAMETERIVNV,cur_context,&a);
}

void APIENTRY glCombinerParameteriNV (GLenum a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLCOMBINERPARAMETERINV,cur_context,&a);
}

void APIENTRY glCombinerInputNV (GLenum a, GLenum b, GLenum c, GLenum d, GLenum e, GLenum f)
{
	(*HostCall_p)(NFOSMESA_GLCOMBINERINPUTNV,cur_context,&a);
}

void APIENTRY glCombinerOutputNV (GLenum a, GLenum b, GLenum c, GLenum d, GLenum e, GLenum f, GLenum g, GLboolean h, GLboolean i, GLboolean j)
{
	(*HostCall_p)(NFOSMESA_GLCOMBINEROUTPUTNV,cur_context,&a);
}

void APIENTRY glFinalCombinerInputNV (GLenum a, GLenum b, GLenum c, GLenum d)
{
	(*HostCall_p)(NFOSMESA_GLFINALCOMBINERINPUTNV,cur_context,&a);
}

void APIENTRY glGetCombinerInputParameterfvNV (GLenum a, GLenum b, GLenum c, GLenum d, GLfloat * e)
{
	(*HostCall_p)(NFOSMESA_GLGETCOMBINERINPUTPARAMETERFVNV,cur_context,&a);
}

void APIENTRY glGetCombinerInputParameterivNV (GLenum a, GLenum b, GLenum c, GLenum d, GLint * e)
{
	(*HostCall_p)(NFOSMESA_GLGETCOMBINERINPUTPARAMETERIVNV,cur_context,&a);
}

void APIENTRY glGetCombinerOutputParameterfvNV (GLenum a, GLenum b, GLenum c, GLfloat * d)
{
	(*HostCall_p)(NFOSMESA_GLGETCOMBINEROUTPUTPARAMETERFVNV,cur_context,&a);
}

void APIENTRY glGetCombinerOutputParameterivNV (GLenum a, GLenum b, GLenum c, GLint * d)
{
	(*HostCall_p)(NFOSMESA_GLGETCOMBINEROUTPUTPARAMETERIVNV,cur_context,&a);
}

void APIENTRY glGetFinalCombinerInputParameterfvNV (GLenum a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETFINALCOMBINERINPUTPARAMETERFVNV,cur_context,&a);
}

void APIENTRY glGetFinalCombinerInputParameterivNV (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETFINALCOMBINERINPUTPARAMETERIVNV,cur_context,&a);
}

void APIENTRY glResizeBuffersMESA (void)
{
	(*HostCall_p)(NFOSMESA_GLRESIZEBUFFERSMESA,cur_context,NULL);
}

void APIENTRY glWindowPos2dMESA (GLdouble a, GLdouble b)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2DMESA,cur_context,&a);
}

void APIENTRY glWindowPos2dvMESA (const GLdouble * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2DVMESA,cur_context,&a);
}

void APIENTRY glWindowPos2fMESA (GLfloat a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2FMESA,cur_context,&a);
}

void APIENTRY glWindowPos2fvMESA (const GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2FVMESA,cur_context,&a);
}

void APIENTRY glWindowPos2iMESA (GLint a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2IMESA,cur_context,&a);
}

void APIENTRY glWindowPos2ivMESA (const GLint * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2IVMESA,cur_context,&a);
}

void APIENTRY glWindowPos2sMESA (GLshort a, GLshort b)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2SMESA,cur_context,&a);
}

void APIENTRY glWindowPos2svMESA (const GLshort * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS2SVMESA,cur_context,&a);
}

void APIENTRY glWindowPos3dMESA (GLdouble a, GLdouble b, GLdouble c)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3DMESA,cur_context,&a);
}

void APIENTRY glWindowPos3dvMESA (const GLdouble * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3DVMESA,cur_context,&a);
}

void APIENTRY glWindowPos3fMESA (GLfloat a, GLfloat b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3FMESA,cur_context,&a);
}

void APIENTRY glWindowPos3fvMESA (const GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3FVMESA,cur_context,&a);
}

void APIENTRY glWindowPos3iMESA (GLint a, GLint b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3IMESA,cur_context,&a);
}

void APIENTRY glWindowPos3ivMESA (const GLint * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3IVMESA,cur_context,&a);
}

void APIENTRY glWindowPos3sMESA (GLshort a, GLshort b, GLshort c)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3SMESA,cur_context,&a);
}

void APIENTRY glWindowPos3svMESA (const GLshort * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS3SVMESA,cur_context,&a);
}

void APIENTRY glWindowPos4dMESA (GLdouble a, GLdouble b, GLdouble c, GLdouble d)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS4DMESA,cur_context,&a);
}

void APIENTRY glWindowPos4dvMESA (const GLdouble * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS4DVMESA,cur_context,&a);
}

void APIENTRY glWindowPos4fMESA (GLfloat a, GLfloat b, GLfloat c, GLfloat d)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS4FMESA,cur_context,&a);
}

void APIENTRY glWindowPos4fvMESA (const GLfloat * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS4FVMESA,cur_context,&a);
}

void APIENTRY glWindowPos4iMESA (GLint a, GLint b, GLint c, GLint d)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS4IMESA,cur_context,&a);
}

void APIENTRY glWindowPos4ivMESA (const GLint * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS4IVMESA,cur_context,&a);
}

void APIENTRY glWindowPos4sMESA (GLshort a, GLshort b, GLshort c, GLshort d)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS4SMESA,cur_context,&a);
}

void APIENTRY glWindowPos4svMESA (const GLshort * a)
{
	(*HostCall_p)(NFOSMESA_GLWINDOWPOS4SVMESA,cur_context,&a);
}

void APIENTRY glMultiModeDrawArraysIBM (const GLenum * a, const GLint * b, const GLsizei * c, GLsizei d, GLint e)
{
	(*HostCall_p)(NFOSMESA_GLMULTIMODEDRAWARRAYSIBM,cur_context,&a);
}

void APIENTRY glMultiModeDrawElementsIBM (const GLenum * a, const GLsizei * b, GLenum c, const GLvoid* const * f, GLsizei d, GLint e)
{
	(*HostCall_p)(NFOSMESA_GLMULTIMODEDRAWELEMENTSIBM,cur_context,&a);
}

void APIENTRY glColorPointerListIBM (GLint a, GLenum b, GLint c, const GLvoid* * d, GLint e)
{
	(*HostCall_p)(NFOSMESA_GLCOLORPOINTERLISTIBM,cur_context,&a);
}

void APIENTRY glSecondaryColorPointerListIBM (GLint a, GLenum b, GLint c, const GLvoid* * d, GLint e)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLORPOINTERLISTIBM,cur_context,&a);
}

void APIENTRY glEdgeFlagPointerListIBM (GLint a, const GLboolean* * b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLEDGEFLAGPOINTERLISTIBM,cur_context,&a);
}

void APIENTRY glFogCoordPointerListIBM (GLenum a, GLint b, const GLvoid* * c, GLint d)
{
	(*HostCall_p)(NFOSMESA_GLFOGCOORDPOINTERLISTIBM,cur_context,&a);
}

void APIENTRY glIndexPointerListIBM (GLenum a, GLint b, const GLvoid* * c, GLint d)
{
	(*HostCall_p)(NFOSMESA_GLINDEXPOINTERLISTIBM,cur_context,&a);
}

void APIENTRY glNormalPointerListIBM (GLenum a, GLint b, const GLvoid* * c, GLint d)
{
	(*HostCall_p)(NFOSMESA_GLNORMALPOINTERLISTIBM,cur_context,&a);
}

void APIENTRY glTexCoordPointerListIBM (GLint a, GLenum b, GLint c, const GLvoid* * d, GLint e)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORDPOINTERLISTIBM,cur_context,&a);
}

void APIENTRY glVertexPointerListIBM (GLint a, GLenum b, GLint c, const GLvoid* * d, GLint e)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXPOINTERLISTIBM,cur_context,&a);
}

void APIENTRY glTbufferMask3DFX (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLTBUFFERMASK3DFX,cur_context,&a);
}

void APIENTRY glSampleMaskEXT (GLclampf a, GLboolean b)
{
	(*HostCall_p)(NFOSMESA_GLSAMPLEMASKEXT,cur_context,&a);
}

void APIENTRY glSamplePatternEXT (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLSAMPLEPATTERNEXT,cur_context,&a);
}

void APIENTRY glTextureColorMaskSGIS (GLboolean a, GLboolean b, GLboolean c, GLboolean d)
{
	(*HostCall_p)(NFOSMESA_GLTEXTURECOLORMASKSGIS,cur_context,&a);
}

void APIENTRY glIglooInterfaceSGIX (GLenum a, const GLvoid * b)
{
	(*HostCall_p)(NFOSMESA_GLIGLOOINTERFACESGIX,cur_context,&a);
}

void APIENTRY glDeleteFencesNV (GLsizei a, const GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLDELETEFENCESNV,cur_context,&a);
}

void APIENTRY glGenFencesNV (GLsizei a, GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLGENFENCESNV,cur_context,&a);
}

GLboolean APIENTRY glIsFenceNV (GLuint a)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLISFENCENV,cur_context,&a);
}

GLboolean APIENTRY glTestFenceNV (GLuint a)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLTESTFENCENV,cur_context,&a);
}

void APIENTRY glGetFenceivNV (GLuint a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETFENCEIVNV,cur_context,&a);
}

void APIENTRY glFinishFenceNV (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLFINISHFENCENV,cur_context,&a);
}

void APIENTRY glSetFenceNV (GLuint a, GLenum b)
{
	(*HostCall_p)(NFOSMESA_GLSETFENCENV,cur_context,&a);
}

void APIENTRY glMapControlPointsNV (GLenum a, GLuint b, GLenum c, GLsizei d, GLsizei e, GLint f, GLint g, GLboolean h, const GLvoid * i)
{
	(*HostCall_p)(NFOSMESA_GLMAPCONTROLPOINTSNV,cur_context,&a);
}

void APIENTRY glMapParameterivNV (GLenum a, GLenum b, const GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLMAPPARAMETERIVNV,cur_context,&a);
}

void APIENTRY glMapParameterfvNV (GLenum a, GLenum b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLMAPPARAMETERFVNV,cur_context,&a);
}

void APIENTRY glGetMapControlPointsNV (GLenum a, GLuint b, GLenum c, GLsizei d, GLsizei e, GLboolean f, GLvoid * g)
{
	(*HostCall_p)(NFOSMESA_GLGETMAPCONTROLPOINTSNV,cur_context,&a);
}

void APIENTRY glGetMapParameterivNV (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETMAPPARAMETERIVNV,cur_context,&a);
}

void APIENTRY glGetMapParameterfvNV (GLenum a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETMAPPARAMETERFVNV,cur_context,&a);
}

void APIENTRY glGetMapAttribParameterivNV (GLenum a, GLuint b, GLenum c, GLint * d)
{
	(*HostCall_p)(NFOSMESA_GLGETMAPATTRIBPARAMETERIVNV,cur_context,&a);
}

void APIENTRY glGetMapAttribParameterfvNV (GLenum a, GLuint b, GLenum c, GLfloat * d)
{
	(*HostCall_p)(NFOSMESA_GLGETMAPATTRIBPARAMETERFVNV,cur_context,&a);
}

void APIENTRY glEvalMapsNV (GLenum a, GLenum b)
{
	(*HostCall_p)(NFOSMESA_GLEVALMAPSNV,cur_context,&a);
}

void APIENTRY glCombinerStageParameterfvNV (GLenum a, GLenum b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLCOMBINERSTAGEPARAMETERFVNV,cur_context,&a);
}

void APIENTRY glGetCombinerStageParameterfvNV (GLenum a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETCOMBINERSTAGEPARAMETERFVNV,cur_context,&a);
}

GLboolean APIENTRY glAreProgramsResidentNV (GLsizei a, const GLuint * b, GLboolean * c)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLAREPROGRAMSRESIDENTNV,cur_context,&a);
}

void APIENTRY glBindProgramNV (GLenum a, GLuint b)
{
	(*HostCall_p)(NFOSMESA_GLBINDPROGRAMNV,cur_context,&a);
}

void APIENTRY glDeleteProgramsNV (GLsizei a, const GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLDELETEPROGRAMSNV,cur_context,&a);
}

void APIENTRY glExecuteProgramNV (GLenum a, GLuint b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLEXECUTEPROGRAMNV,cur_context,&a);
}

void APIENTRY glGenProgramsNV (GLsizei a, GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLGENPROGRAMSNV,cur_context,&a);
}

void APIENTRY glGetProgramParameterdvNV (GLenum a, GLuint b, GLenum c, GLdouble * d)
{
	(*HostCall_p)(NFOSMESA_GLGETPROGRAMPARAMETERDVNV,cur_context,&a);
}

void APIENTRY glGetProgramParameterfvNV (GLenum a, GLuint b, GLenum c, GLfloat * d)
{
	(*HostCall_p)(NFOSMESA_GLGETPROGRAMPARAMETERFVNV,cur_context,&a);
}

void APIENTRY glGetProgramivNV (GLuint a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETPROGRAMIVNV,cur_context,&a);
}

void APIENTRY glGetProgramStringNV (GLuint a, GLenum b, GLubyte * c)
{
	(*HostCall_p)(NFOSMESA_GLGETPROGRAMSTRINGNV,cur_context,&a);
}

void APIENTRY glGetTrackMatrixivNV (GLenum a, GLuint b, GLenum c, GLint * d)
{
	(*HostCall_p)(NFOSMESA_GLGETTRACKMATRIXIVNV,cur_context,&a);
}

void APIENTRY glGetVertexAttribdvNV (GLuint a, GLenum b, GLdouble * c)
{
	(*HostCall_p)(NFOSMESA_GLGETVERTEXATTRIBDVNV,cur_context,&a);
}

void APIENTRY glGetVertexAttribfvNV (GLuint a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETVERTEXATTRIBFVNV,cur_context,&a);
}

void APIENTRY glGetVertexAttribivNV (GLuint a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETVERTEXATTRIBIVNV,cur_context,&a);
}

void APIENTRY glGetVertexAttribPointervNV (GLuint a, GLenum b, GLvoid* * c)
{
	(*HostCall_p)(NFOSMESA_GLGETVERTEXATTRIBPOINTERVNV,cur_context,&a);
}

GLboolean APIENTRY glIsProgramNV (GLuint a)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLISPROGRAMNV,cur_context,&a);
}

void APIENTRY glLoadProgramNV (GLenum a, GLuint b, GLsizei c, const GLubyte * d)
{
	(*HostCall_p)(NFOSMESA_GLLOADPROGRAMNV,cur_context,&a);
}

void APIENTRY glProgramParameter4dNV (GLenum a, GLuint b, GLdouble c, GLdouble d, GLdouble e, GLdouble f)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMPARAMETER4DNV,cur_context,&a);
}

void APIENTRY glProgramParameter4dvNV (GLenum a, GLuint b, const GLdouble * c)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMPARAMETER4DVNV,cur_context,&a);
}

void APIENTRY glProgramParameter4fNV (GLenum a, GLuint b, GLfloat c, GLfloat d, GLfloat e, GLfloat f)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMPARAMETER4FNV,cur_context,&a);
}

void APIENTRY glProgramParameter4fvNV (GLenum a, GLuint b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMPARAMETER4FVNV,cur_context,&a);
}

void APIENTRY glProgramParameters4dvNV (GLenum a, GLuint b, GLuint c, const GLdouble * d)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMPARAMETERS4DVNV,cur_context,&a);
}

void APIENTRY glProgramParameters4fvNV (GLenum a, GLuint b, GLuint c, const GLfloat * d)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMPARAMETERS4FVNV,cur_context,&a);
}

void APIENTRY glRequestResidentProgramsNV (GLsizei a, const GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLREQUESTRESIDENTPROGRAMSNV,cur_context,&a);
}

void APIENTRY glTrackMatrixNV (GLenum a, GLuint b, GLenum c, GLenum d)
{
	(*HostCall_p)(NFOSMESA_GLTRACKMATRIXNV,cur_context,&a);
}

void APIENTRY glVertexAttribPointerNV (GLuint a, GLint b, GLenum c, GLsizei d, const GLvoid * e)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBPOINTERNV,cur_context,&a);
}

void APIENTRY glVertexAttrib1dNV (GLuint a, GLdouble b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB1DNV,cur_context,&a);
}

void APIENTRY glVertexAttrib1dvNV (GLuint a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB1DVNV,cur_context,&a);
}

void APIENTRY glVertexAttrib1fNV (GLuint a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB1FNV,cur_context,&a);
}

void APIENTRY glVertexAttrib1fvNV (GLuint a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB1FVNV,cur_context,&a);
}

void APIENTRY glVertexAttrib1sNV (GLuint a, GLshort b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB1SNV,cur_context,&a);
}

void APIENTRY glVertexAttrib1svNV (GLuint a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB1SVNV,cur_context,&a);
}

void APIENTRY glVertexAttrib2dNV (GLuint a, GLdouble b, GLdouble c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB2DNV,cur_context,&a);
}

void APIENTRY glVertexAttrib2dvNV (GLuint a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB2DVNV,cur_context,&a);
}

void APIENTRY glVertexAttrib2fNV (GLuint a, GLfloat b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB2FNV,cur_context,&a);
}

void APIENTRY glVertexAttrib2fvNV (GLuint a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB2FVNV,cur_context,&a);
}

void APIENTRY glVertexAttrib2sNV (GLuint a, GLshort b, GLshort c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB2SNV,cur_context,&a);
}

void APIENTRY glVertexAttrib2svNV (GLuint a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB2SVNV,cur_context,&a);
}

void APIENTRY glVertexAttrib3dNV (GLuint a, GLdouble b, GLdouble c, GLdouble d)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB3DNV,cur_context,&a);
}

void APIENTRY glVertexAttrib3dvNV (GLuint a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB3DVNV,cur_context,&a);
}

void APIENTRY glVertexAttrib3fNV (GLuint a, GLfloat b, GLfloat c, GLfloat d)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB3FNV,cur_context,&a);
}

void APIENTRY glVertexAttrib3fvNV (GLuint a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB3FVNV,cur_context,&a);
}

void APIENTRY glVertexAttrib3sNV (GLuint a, GLshort b, GLshort c, GLshort d)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB3SNV,cur_context,&a);
}

void APIENTRY glVertexAttrib3svNV (GLuint a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB3SVNV,cur_context,&a);
}

void APIENTRY glVertexAttrib4dNV (GLuint a, GLdouble b, GLdouble c, GLdouble d, GLdouble e)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4DNV,cur_context,&a);
}

void APIENTRY glVertexAttrib4dvNV (GLuint a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4DVNV,cur_context,&a);
}

void APIENTRY glVertexAttrib4fNV (GLuint a, GLfloat b, GLfloat c, GLfloat d, GLfloat e)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4FNV,cur_context,&a);
}

void APIENTRY glVertexAttrib4fvNV (GLuint a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4FVNV,cur_context,&a);
}

void APIENTRY glVertexAttrib4sNV (GLuint a, GLshort b, GLshort c, GLshort d, GLshort e)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4SNV,cur_context,&a);
}

void APIENTRY glVertexAttrib4svNV (GLuint a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4SVNV,cur_context,&a);
}

void APIENTRY glVertexAttrib4ubNV (GLuint a, GLubyte b, GLubyte c, GLubyte d, GLubyte e)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4UBNV,cur_context,&a);
}

void APIENTRY glVertexAttrib4ubvNV (GLuint a, const GLubyte * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4UBVNV,cur_context,&a);
}

void APIENTRY glVertexAttribs1dvNV (GLuint a, GLsizei b, const GLdouble * c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBS1DVNV,cur_context,&a);
}

void APIENTRY glVertexAttribs1fvNV (GLuint a, GLsizei b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBS1FVNV,cur_context,&a);
}

void APIENTRY glVertexAttribs1svNV (GLuint a, GLsizei b, const GLshort * c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBS1SVNV,cur_context,&a);
}

void APIENTRY glVertexAttribs2dvNV (GLuint a, GLsizei b, const GLdouble * c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBS2DVNV,cur_context,&a);
}

void APIENTRY glVertexAttribs2fvNV (GLuint a, GLsizei b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBS2FVNV,cur_context,&a);
}

void APIENTRY glVertexAttribs2svNV (GLuint a, GLsizei b, const GLshort * c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBS2SVNV,cur_context,&a);
}

void APIENTRY glVertexAttribs3dvNV (GLuint a, GLsizei b, const GLdouble * c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBS3DVNV,cur_context,&a);
}

void APIENTRY glVertexAttribs3fvNV (GLuint a, GLsizei b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBS3FVNV,cur_context,&a);
}

void APIENTRY glVertexAttribs3svNV (GLuint a, GLsizei b, const GLshort * c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBS3SVNV,cur_context,&a);
}

void APIENTRY glVertexAttribs4dvNV (GLuint a, GLsizei b, const GLdouble * c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBS4DVNV,cur_context,&a);
}

void APIENTRY glVertexAttribs4fvNV (GLuint a, GLsizei b, const GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBS4FVNV,cur_context,&a);
}

void APIENTRY glVertexAttribs4svNV (GLuint a, GLsizei b, const GLshort * c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBS4SVNV,cur_context,&a);
}

void APIENTRY glVertexAttribs4ubvNV (GLuint a, GLsizei b, const GLubyte * c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBS4UBVNV,cur_context,&a);
}

void APIENTRY glTexBumpParameterivATI (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLTEXBUMPPARAMETERIVATI,cur_context,&a);
}

void APIENTRY glTexBumpParameterfvATI (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLTEXBUMPPARAMETERFVATI,cur_context,&a);
}

void APIENTRY glGetTexBumpParameterivATI (GLenum a, GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLGETTEXBUMPPARAMETERIVATI,cur_context,&a);
}

void APIENTRY glGetTexBumpParameterfvATI (GLenum a, GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLGETTEXBUMPPARAMETERFVATI,cur_context,&a);
}

GLuint APIENTRY glGenFragmentShadersATI (GLuint a)
{
	return (GLuint)(*HostCall_p)(NFOSMESA_GLGENFRAGMENTSHADERSATI,cur_context,&a);
}

void APIENTRY glBindFragmentShaderATI (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLBINDFRAGMENTSHADERATI,cur_context,&a);
}

void APIENTRY glDeleteFragmentShaderATI (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLDELETEFRAGMENTSHADERATI,cur_context,&a);
}

void APIENTRY glBeginFragmentShaderATI (void)
{
	(*HostCall_p)(NFOSMESA_GLBEGINFRAGMENTSHADERATI,cur_context,NULL);
}

void APIENTRY glEndFragmentShaderATI (void)
{
	(*HostCall_p)(NFOSMESA_GLENDFRAGMENTSHADERATI,cur_context,NULL);
}

void APIENTRY glPassTexCoordATI (GLuint a, GLuint b, GLenum c)
{
	(*HostCall_p)(NFOSMESA_GLPASSTEXCOORDATI,cur_context,&a);
}

void APIENTRY glSampleMapATI (GLuint a, GLuint b, GLenum c)
{
	(*HostCall_p)(NFOSMESA_GLSAMPLEMAPATI,cur_context,&a);
}

void APIENTRY glColorFragmentOp1ATI (GLenum a, GLuint b, GLuint c, GLuint d, GLuint e, GLuint f, GLuint g)
{
	(*HostCall_p)(NFOSMESA_GLCOLORFRAGMENTOP1ATI,cur_context,&a);
}

void APIENTRY glColorFragmentOp2ATI (GLenum a, GLuint b, GLuint c, GLuint d, GLuint e, GLuint f, GLuint g, GLuint h, GLuint i, GLuint j)
{
	(*HostCall_p)(NFOSMESA_GLCOLORFRAGMENTOP2ATI,cur_context,&a);
}

void APIENTRY glColorFragmentOp3ATI (GLenum a, GLuint b, GLuint c, GLuint d, GLuint e, GLuint f, GLuint g, GLuint h, GLuint i, GLuint j, GLuint k, GLuint l, GLuint m)
{
	(*HostCall_p)(NFOSMESA_GLCOLORFRAGMENTOP3ATI,cur_context,&a);
}

void APIENTRY glAlphaFragmentOp1ATI (GLenum a, GLuint b, GLuint c, GLuint d, GLuint e, GLuint f)
{
	(*HostCall_p)(NFOSMESA_GLALPHAFRAGMENTOP1ATI,cur_context,&a);
}

void APIENTRY glAlphaFragmentOp2ATI (GLenum a, GLuint b, GLuint c, GLuint d, GLuint e, GLuint f, GLuint g, GLuint h, GLuint i)
{
	(*HostCall_p)(NFOSMESA_GLALPHAFRAGMENTOP2ATI,cur_context,&a);
}

void APIENTRY glAlphaFragmentOp3ATI (GLenum a, GLuint b, GLuint c, GLuint d, GLuint e, GLuint f, GLuint g, GLuint h, GLuint i, GLuint j, GLuint k, GLuint l)
{
	(*HostCall_p)(NFOSMESA_GLALPHAFRAGMENTOP3ATI,cur_context,&a);
}

void APIENTRY glSetFragmentShaderConstantATI (GLuint a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLSETFRAGMENTSHADERCONSTANTATI,cur_context,&a);
}

void APIENTRY glPNTrianglesiATI (GLenum a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLPNTRIANGLESIATI,cur_context,&a);
}

void APIENTRY glPNTrianglesfATI (GLenum a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLPNTRIANGLESFATI,cur_context,&a);
}

GLuint APIENTRY glNewObjectBufferATI (GLsizei a, const GLvoid * b, GLenum c)
{
	return (GLuint)(*HostCall_p)(NFOSMESA_GLNEWOBJECTBUFFERATI,cur_context,&a);
}

GLboolean APIENTRY glIsObjectBufferATI (GLuint a)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLISOBJECTBUFFERATI,cur_context,&a);
}

void APIENTRY glUpdateObjectBufferATI (GLuint a, GLuint b, GLsizei c, const GLvoid * d, GLenum e)
{
	(*HostCall_p)(NFOSMESA_GLUPDATEOBJECTBUFFERATI,cur_context,&a);
}

void APIENTRY glGetObjectBufferfvATI (GLuint a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETOBJECTBUFFERFVATI,cur_context,&a);
}

void APIENTRY glGetObjectBufferivATI (GLuint a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETOBJECTBUFFERIVATI,cur_context,&a);
}

void APIENTRY glFreeObjectBufferATI (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLFREEOBJECTBUFFERATI,cur_context,&a);
}

void APIENTRY glArrayObjectATI (GLenum a, GLint b, GLenum c, GLsizei d, GLuint e, GLuint f)
{
	(*HostCall_p)(NFOSMESA_GLARRAYOBJECTATI,cur_context,&a);
}

void APIENTRY glGetArrayObjectfvATI (GLenum a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETARRAYOBJECTFVATI,cur_context,&a);
}

void APIENTRY glGetArrayObjectivATI (GLenum a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETARRAYOBJECTIVATI,cur_context,&a);
}

void APIENTRY glVariantArrayObjectATI (GLuint a, GLenum b, GLsizei c, GLuint d, GLuint e)
{
	(*HostCall_p)(NFOSMESA_GLVARIANTARRAYOBJECTATI,cur_context,&a);
}

void APIENTRY glGetVariantArrayObjectfvATI (GLuint a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETVARIANTARRAYOBJECTFVATI,cur_context,&a);
}

void APIENTRY glGetVariantArrayObjectivATI (GLuint a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETVARIANTARRAYOBJECTIVATI,cur_context,&a);
}

void APIENTRY glBeginVertexShaderEXT (void)
{
	(*HostCall_p)(NFOSMESA_GLBEGINVERTEXSHADEREXT,cur_context,NULL);
}

void APIENTRY glEndVertexShaderEXT (void)
{
	(*HostCall_p)(NFOSMESA_GLENDVERTEXSHADEREXT,cur_context,NULL);
}

void APIENTRY glBindVertexShaderEXT (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLBINDVERTEXSHADEREXT,cur_context,&a);
}

GLuint APIENTRY glGenVertexShadersEXT (GLuint a)
{
	return (GLuint)(*HostCall_p)(NFOSMESA_GLGENVERTEXSHADERSEXT,cur_context,&a);
}

void APIENTRY glDeleteVertexShaderEXT (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLDELETEVERTEXSHADEREXT,cur_context,&a);
}

void APIENTRY glShaderOp1EXT (GLenum a, GLuint b, GLuint c)
{
	(*HostCall_p)(NFOSMESA_GLSHADEROP1EXT,cur_context,&a);
}

void APIENTRY glShaderOp2EXT (GLenum a, GLuint b, GLuint c, GLuint d)
{
	(*HostCall_p)(NFOSMESA_GLSHADEROP2EXT,cur_context,&a);
}

void APIENTRY glShaderOp3EXT (GLenum a, GLuint b, GLuint c, GLuint d, GLuint e)
{
	(*HostCall_p)(NFOSMESA_GLSHADEROP3EXT,cur_context,&a);
}

void APIENTRY glSwizzleEXT (GLuint a, GLuint b, GLenum c, GLenum d, GLenum e, GLenum f)
{
	(*HostCall_p)(NFOSMESA_GLSWIZZLEEXT,cur_context,&a);
}

void APIENTRY glWriteMaskEXT (GLuint a, GLuint b, GLenum c, GLenum d, GLenum e, GLenum f)
{
	(*HostCall_p)(NFOSMESA_GLWRITEMASKEXT,cur_context,&a);
}

void APIENTRY glInsertComponentEXT (GLuint a, GLuint b, GLuint c)
{
	(*HostCall_p)(NFOSMESA_GLINSERTCOMPONENTEXT,cur_context,&a);
}

void APIENTRY glExtractComponentEXT (GLuint a, GLuint b, GLuint c)
{
	(*HostCall_p)(NFOSMESA_GLEXTRACTCOMPONENTEXT,cur_context,&a);
}

GLuint APIENTRY glGenSymbolsEXT (GLenum a, GLenum b, GLenum c, GLuint d)
{
	return (GLuint)(*HostCall_p)(NFOSMESA_GLGENSYMBOLSEXT,cur_context,&a);
}

void APIENTRY glSetInvariantEXT (GLuint a, GLenum b, const GLvoid * c)
{
	(*HostCall_p)(NFOSMESA_GLSETINVARIANTEXT,cur_context,&a);
}

void APIENTRY glSetLocalConstantEXT (GLuint a, GLenum b, const GLvoid * c)
{
	(*HostCall_p)(NFOSMESA_GLSETLOCALCONSTANTEXT,cur_context,&a);
}

void APIENTRY glVariantbvEXT (GLuint a, const GLbyte * b)
{
	(*HostCall_p)(NFOSMESA_GLVARIANTBVEXT,cur_context,&a);
}

void APIENTRY glVariantsvEXT (GLuint a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLVARIANTSVEXT,cur_context,&a);
}

void APIENTRY glVariantivEXT (GLuint a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLVARIANTIVEXT,cur_context,&a);
}

void APIENTRY glVariantfvEXT (GLuint a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLVARIANTFVEXT,cur_context,&a);
}

void APIENTRY glVariantdvEXT (GLuint a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLVARIANTDVEXT,cur_context,&a);
}

void APIENTRY glVariantubvEXT (GLuint a, const GLubyte * b)
{
	(*HostCall_p)(NFOSMESA_GLVARIANTUBVEXT,cur_context,&a);
}

void APIENTRY glVariantusvEXT (GLuint a, const GLushort * b)
{
	(*HostCall_p)(NFOSMESA_GLVARIANTUSVEXT,cur_context,&a);
}

void APIENTRY glVariantuivEXT (GLuint a, const GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLVARIANTUIVEXT,cur_context,&a);
}

void APIENTRY glVariantPointerEXT (GLuint a, GLenum b, GLuint c, const GLvoid * d)
{
	(*HostCall_p)(NFOSMESA_GLVARIANTPOINTEREXT,cur_context,&a);
}

void APIENTRY glEnableVariantClientStateEXT (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLENABLEVARIANTCLIENTSTATEEXT,cur_context,&a);
}

void APIENTRY glDisableVariantClientStateEXT (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLDISABLEVARIANTCLIENTSTATEEXT,cur_context,&a);
}

GLuint APIENTRY glBindLightParameterEXT (GLenum a, GLenum b)
{
	return (GLuint)(*HostCall_p)(NFOSMESA_GLBINDLIGHTPARAMETEREXT,cur_context,&a);
}

GLuint APIENTRY glBindMaterialParameterEXT (GLenum a, GLenum b)
{
	return (GLuint)(*HostCall_p)(NFOSMESA_GLBINDMATERIALPARAMETEREXT,cur_context,&a);
}

GLuint APIENTRY glBindTexGenParameterEXT (GLenum a, GLenum b, GLenum c)
{
	return (GLuint)(*HostCall_p)(NFOSMESA_GLBINDTEXGENPARAMETEREXT,cur_context,&a);
}

GLuint APIENTRY glBindTextureUnitParameterEXT (GLenum a, GLenum b)
{
	return (GLuint)(*HostCall_p)(NFOSMESA_GLBINDTEXTUREUNITPARAMETEREXT,cur_context,&a);
}

GLuint APIENTRY glBindParameterEXT (GLenum a)
{
	return (GLuint)(*HostCall_p)(NFOSMESA_GLBINDPARAMETEREXT,cur_context,&a);
}

GLboolean APIENTRY glIsVariantEnabledEXT (GLuint a, GLenum b)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLISVARIANTENABLEDEXT,cur_context,&a);
}

void APIENTRY glGetVariantBooleanvEXT (GLuint a, GLenum b, GLboolean * c)
{
	(*HostCall_p)(NFOSMESA_GLGETVARIANTBOOLEANVEXT,cur_context,&a);
}

void APIENTRY glGetVariantIntegervEXT (GLuint a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETVARIANTINTEGERVEXT,cur_context,&a);
}

void APIENTRY glGetVariantFloatvEXT (GLuint a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETVARIANTFLOATVEXT,cur_context,&a);
}

void APIENTRY glGetVariantPointervEXT (GLuint a, GLenum b, GLvoid* * c)
{
	(*HostCall_p)(NFOSMESA_GLGETVARIANTPOINTERVEXT,cur_context,&a);
}

void APIENTRY glGetInvariantBooleanvEXT (GLuint a, GLenum b, GLboolean * c)
{
	(*HostCall_p)(NFOSMESA_GLGETINVARIANTBOOLEANVEXT,cur_context,&a);
}

void APIENTRY glGetInvariantIntegervEXT (GLuint a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETINVARIANTINTEGERVEXT,cur_context,&a);
}

void APIENTRY glGetInvariantFloatvEXT (GLuint a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETINVARIANTFLOATVEXT,cur_context,&a);
}

void APIENTRY glGetLocalConstantBooleanvEXT (GLuint a, GLenum b, GLboolean * c)
{
	(*HostCall_p)(NFOSMESA_GLGETLOCALCONSTANTBOOLEANVEXT,cur_context,&a);
}

void APIENTRY glGetLocalConstantIntegervEXT (GLuint a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETLOCALCONSTANTINTEGERVEXT,cur_context,&a);
}

void APIENTRY glGetLocalConstantFloatvEXT (GLuint a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETLOCALCONSTANTFLOATVEXT,cur_context,&a);
}

void APIENTRY glVertexStream1sATI (GLenum a, GLshort b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM1SATI,cur_context,&a);
}

void APIENTRY glVertexStream1svATI (GLenum a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM1SVATI,cur_context,&a);
}

void APIENTRY glVertexStream1iATI (GLenum a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM1IATI,cur_context,&a);
}

void APIENTRY glVertexStream1ivATI (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM1IVATI,cur_context,&a);
}

void APIENTRY glVertexStream1fATI (GLenum a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM1FATI,cur_context,&a);
}

void APIENTRY glVertexStream1fvATI (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM1FVATI,cur_context,&a);
}

void APIENTRY glVertexStream1dATI (GLenum a, GLdouble b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM1DATI,cur_context,&a);
}

void APIENTRY glVertexStream1dvATI (GLenum a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM1DVATI,cur_context,&a);
}

void APIENTRY glVertexStream2sATI (GLenum a, GLshort b, GLshort c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM2SATI,cur_context,&a);
}

void APIENTRY glVertexStream2svATI (GLenum a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM2SVATI,cur_context,&a);
}

void APIENTRY glVertexStream2iATI (GLenum a, GLint b, GLint c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM2IATI,cur_context,&a);
}

void APIENTRY glVertexStream2ivATI (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM2IVATI,cur_context,&a);
}

void APIENTRY glVertexStream2fATI (GLenum a, GLfloat b, GLfloat c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM2FATI,cur_context,&a);
}

void APIENTRY glVertexStream2fvATI (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM2FVATI,cur_context,&a);
}

void APIENTRY glVertexStream2dATI (GLenum a, GLdouble b, GLdouble c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM2DATI,cur_context,&a);
}

void APIENTRY glVertexStream2dvATI (GLenum a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM2DVATI,cur_context,&a);
}

void APIENTRY glVertexStream3sATI (GLenum a, GLshort b, GLshort c, GLshort d)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM3SATI,cur_context,&a);
}

void APIENTRY glVertexStream3svATI (GLenum a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM3SVATI,cur_context,&a);
}

void APIENTRY glVertexStream3iATI (GLenum a, GLint b, GLint c, GLint d)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM3IATI,cur_context,&a);
}

void APIENTRY glVertexStream3ivATI (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM3IVATI,cur_context,&a);
}

void APIENTRY glVertexStream3fATI (GLenum a, GLfloat b, GLfloat c, GLfloat d)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM3FATI,cur_context,&a);
}

void APIENTRY glVertexStream3fvATI (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM3FVATI,cur_context,&a);
}

void APIENTRY glVertexStream3dATI (GLenum a, GLdouble b, GLdouble c, GLdouble d)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM3DATI,cur_context,&a);
}

void APIENTRY glVertexStream3dvATI (GLenum a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM3DVATI,cur_context,&a);
}

void APIENTRY glVertexStream4sATI (GLenum a, GLshort b, GLshort c, GLshort d, GLshort e)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM4SATI,cur_context,&a);
}

void APIENTRY glVertexStream4svATI (GLenum a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM4SVATI,cur_context,&a);
}

void APIENTRY glVertexStream4iATI (GLenum a, GLint b, GLint c, GLint d, GLint e)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM4IATI,cur_context,&a);
}

void APIENTRY glVertexStream4ivATI (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM4IVATI,cur_context,&a);
}

void APIENTRY glVertexStream4fATI (GLenum a, GLfloat b, GLfloat c, GLfloat d, GLfloat e)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM4FATI,cur_context,&a);
}

void APIENTRY glVertexStream4fvATI (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM4FVATI,cur_context,&a);
}

void APIENTRY glVertexStream4dATI (GLenum a, GLdouble b, GLdouble c, GLdouble d, GLdouble e)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM4DATI,cur_context,&a);
}

void APIENTRY glVertexStream4dvATI (GLenum a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXSTREAM4DVATI,cur_context,&a);
}

void APIENTRY glNormalStream3bATI (GLenum a, GLbyte b, GLbyte c, GLbyte d)
{
	(*HostCall_p)(NFOSMESA_GLNORMALSTREAM3BATI,cur_context,&a);
}

void APIENTRY glNormalStream3bvATI (GLenum a, const GLbyte * b)
{
	(*HostCall_p)(NFOSMESA_GLNORMALSTREAM3BVATI,cur_context,&a);
}

void APIENTRY glNormalStream3sATI (GLenum a, GLshort b, GLshort c, GLshort d)
{
	(*HostCall_p)(NFOSMESA_GLNORMALSTREAM3SATI,cur_context,&a);
}

void APIENTRY glNormalStream3svATI (GLenum a, const GLshort * b)
{
	(*HostCall_p)(NFOSMESA_GLNORMALSTREAM3SVATI,cur_context,&a);
}

void APIENTRY glNormalStream3iATI (GLenum a, GLint b, GLint c, GLint d)
{
	(*HostCall_p)(NFOSMESA_GLNORMALSTREAM3IATI,cur_context,&a);
}

void APIENTRY glNormalStream3ivATI (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLNORMALSTREAM3IVATI,cur_context,&a);
}

void APIENTRY glNormalStream3fATI (GLenum a, GLfloat b, GLfloat c, GLfloat d)
{
	(*HostCall_p)(NFOSMESA_GLNORMALSTREAM3FATI,cur_context,&a);
}

void APIENTRY glNormalStream3fvATI (GLenum a, const GLfloat * b)
{
	(*HostCall_p)(NFOSMESA_GLNORMALSTREAM3FVATI,cur_context,&a);
}

void APIENTRY glNormalStream3dATI (GLenum a, GLdouble b, GLdouble c, GLdouble d)
{
	(*HostCall_p)(NFOSMESA_GLNORMALSTREAM3DATI,cur_context,&a);
}

void APIENTRY glNormalStream3dvATI (GLenum a, const GLdouble * b)
{
	(*HostCall_p)(NFOSMESA_GLNORMALSTREAM3DVATI,cur_context,&a);
}

void APIENTRY glClientActiveVertexStreamATI (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLCLIENTACTIVEVERTEXSTREAMATI,cur_context,&a);
}

void APIENTRY glVertexBlendEnviATI (GLenum a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXBLENDENVIATI,cur_context,&a);
}

void APIENTRY glVertexBlendEnvfATI (GLenum a, GLfloat b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXBLENDENVFATI,cur_context,&a);
}

void APIENTRY glElementPointerATI (GLenum a, const GLvoid * b)
{
	(*HostCall_p)(NFOSMESA_GLELEMENTPOINTERATI,cur_context,&a);
}

void APIENTRY glDrawElementArrayATI (GLenum a, GLsizei b)
{
	(*HostCall_p)(NFOSMESA_GLDRAWELEMENTARRAYATI,cur_context,&a);
}

void APIENTRY glDrawRangeElementArrayATI (GLenum a, GLuint b, GLuint c, GLsizei d)
{
	(*HostCall_p)(NFOSMESA_GLDRAWRANGEELEMENTARRAYATI,cur_context,&a);
}

void APIENTRY glDrawMeshArraysSUN (GLenum a, GLint b, GLsizei c, GLsizei d)
{
	(*HostCall_p)(NFOSMESA_GLDRAWMESHARRAYSSUN,cur_context,&a);
}

void APIENTRY glGenOcclusionQueriesNV (GLsizei a, GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLGENOCCLUSIONQUERIESNV,cur_context,&a);
}

void APIENTRY glDeleteOcclusionQueriesNV (GLsizei a, const GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLDELETEOCCLUSIONQUERIESNV,cur_context,&a);
}

GLboolean APIENTRY glIsOcclusionQueryNV (GLuint a)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLISOCCLUSIONQUERYNV,cur_context,&a);
}

void APIENTRY glBeginOcclusionQueryNV (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLBEGINOCCLUSIONQUERYNV,cur_context,&a);
}

void APIENTRY glEndOcclusionQueryNV (void)
{
	(*HostCall_p)(NFOSMESA_GLENDOCCLUSIONQUERYNV,cur_context,NULL);
}

void APIENTRY glGetOcclusionQueryivNV (GLuint a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETOCCLUSIONQUERYIVNV,cur_context,&a);
}

void APIENTRY glGetOcclusionQueryuivNV (GLuint a, GLenum b, GLuint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETOCCLUSIONQUERYUIVNV,cur_context,&a);
}

void APIENTRY glPointParameteriNV (GLenum a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLPOINTPARAMETERINV,cur_context,&a);
}

void APIENTRY glPointParameterivNV (GLenum a, const GLint * b)
{
	(*HostCall_p)(NFOSMESA_GLPOINTPARAMETERIVNV,cur_context,&a);
}

void APIENTRY glActiveStencilFaceEXT (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLACTIVESTENCILFACEEXT,cur_context,&a);
}

void APIENTRY glElementPointerAPPLE (GLenum a, const GLvoid * b)
{
	(*HostCall_p)(NFOSMESA_GLELEMENTPOINTERAPPLE,cur_context,&a);
}

void APIENTRY glDrawElementArrayAPPLE (GLenum a, GLint b, GLsizei c)
{
	(*HostCall_p)(NFOSMESA_GLDRAWELEMENTARRAYAPPLE,cur_context,&a);
}

void APIENTRY glDrawRangeElementArrayAPPLE (GLenum a, GLuint b, GLuint c, GLint d, GLsizei e)
{
	(*HostCall_p)(NFOSMESA_GLDRAWRANGEELEMENTARRAYAPPLE,cur_context,&a);
}

void APIENTRY glMultiDrawElementArrayAPPLE (GLenum a, const GLint * b, const GLsizei * c, GLsizei d)
{
	(*HostCall_p)(NFOSMESA_GLMULTIDRAWELEMENTARRAYAPPLE,cur_context,&a);
}

void APIENTRY glMultiDrawRangeElementArrayAPPLE (GLenum a, GLuint b, GLuint c, const GLint * d, const GLsizei * e, GLsizei f)
{
	(*HostCall_p)(NFOSMESA_GLMULTIDRAWRANGEELEMENTARRAYAPPLE,cur_context,&a);
}

void APIENTRY glGenFencesAPPLE (GLsizei a, GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLGENFENCESAPPLE,cur_context,&a);
}

void APIENTRY glDeleteFencesAPPLE (GLsizei a, const GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLDELETEFENCESAPPLE,cur_context,&a);
}

void APIENTRY glSetFenceAPPLE (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLSETFENCEAPPLE,cur_context,&a);
}

GLboolean APIENTRY glIsFenceAPPLE (GLuint a)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLISFENCEAPPLE,cur_context,&a);
}

GLboolean APIENTRY glTestFenceAPPLE (GLuint a)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLTESTFENCEAPPLE,cur_context,&a);
}

void APIENTRY glFinishFenceAPPLE (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLFINISHFENCEAPPLE,cur_context,&a);
}

GLboolean APIENTRY glTestObjectAPPLE (GLenum a, GLuint b)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLTESTOBJECTAPPLE,cur_context,&a);
}

void APIENTRY glFinishObjectAPPLE (GLenum a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLFINISHOBJECTAPPLE,cur_context,&a);
}

void APIENTRY glBindVertexArrayAPPLE (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLBINDVERTEXARRAYAPPLE,cur_context,&a);
}

void APIENTRY glDeleteVertexArraysAPPLE (GLsizei a, const GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLDELETEVERTEXARRAYSAPPLE,cur_context,&a);
}

void APIENTRY glGenVertexArraysAPPLE (GLsizei a, const GLuint * b)
{
	(*HostCall_p)(NFOSMESA_GLGENVERTEXARRAYSAPPLE,cur_context,&a);
}

GLboolean APIENTRY glIsVertexArrayAPPLE (GLuint a)
{
	return (GLboolean)(*HostCall_p)(NFOSMESA_GLISVERTEXARRAYAPPLE,cur_context,&a);
}

void APIENTRY glVertexArrayRangeAPPLE (GLsizei a, GLvoid * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXARRAYRANGEAPPLE,cur_context,&a);
}

void APIENTRY glFlushVertexArrayRangeAPPLE (GLsizei a, GLvoid * b)
{
	(*HostCall_p)(NFOSMESA_GLFLUSHVERTEXARRAYRANGEAPPLE,cur_context,&a);
}

void APIENTRY glVertexArrayParameteriAPPLE (GLenum a, GLint b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXARRAYPARAMETERIAPPLE,cur_context,&a);
}

void APIENTRY glDrawBuffersATI (GLsizei a, const GLenum * b)
{
	(*HostCall_p)(NFOSMESA_GLDRAWBUFFERSATI,cur_context,&a);
}

void APIENTRY glProgramNamedParameter4fNV (GLuint a, GLsizei b, const GLubyte * c, GLfloat d, GLfloat e, GLfloat f, GLfloat g)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMNAMEDPARAMETER4FNV,cur_context,&a);
}

void APIENTRY glProgramNamedParameter4dNV (GLuint a, GLsizei b, const GLubyte * c, GLdouble d, GLdouble e, GLdouble f, GLdouble g)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMNAMEDPARAMETER4DNV,cur_context,&a);
}

void APIENTRY glProgramNamedParameter4fvNV (GLuint a, GLsizei b, const GLubyte * c, const GLfloat * d)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMNAMEDPARAMETER4FVNV,cur_context,&a);
}

void APIENTRY glProgramNamedParameter4dvNV (GLuint a, GLsizei b, const GLubyte * c, const GLdouble * d)
{
	(*HostCall_p)(NFOSMESA_GLPROGRAMNAMEDPARAMETER4DVNV,cur_context,&a);
}

void APIENTRY glGetProgramNamedParameterfvNV (GLuint a, GLsizei b, const GLubyte * c, GLfloat * d)
{
	(*HostCall_p)(NFOSMESA_GLGETPROGRAMNAMEDPARAMETERFVNV,cur_context,&a);
}

void APIENTRY glGetProgramNamedParameterdvNV (GLuint a, GLsizei b, const GLubyte * c, GLdouble * d)
{
	(*HostCall_p)(NFOSMESA_GLGETPROGRAMNAMEDPARAMETERDVNV,cur_context,&a);
}

void APIENTRY glVertex2hNV (GLhalfNV a, GLhalfNV b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEX2HNV,cur_context,&a);
}

void APIENTRY glVertex2hvNV (const GLhalfNV * a)
{
	(*HostCall_p)(NFOSMESA_GLVERTEX2HVNV,cur_context,&a);
}

void APIENTRY glVertex3hNV (GLhalfNV a, GLhalfNV b, GLhalfNV c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEX3HNV,cur_context,&a);
}

void APIENTRY glVertex3hvNV (const GLhalfNV * a)
{
	(*HostCall_p)(NFOSMESA_GLVERTEX3HVNV,cur_context,&a);
}

void APIENTRY glVertex4hNV (GLhalfNV a, GLhalfNV b, GLhalfNV c, GLhalfNV d)
{
	(*HostCall_p)(NFOSMESA_GLVERTEX4HNV,cur_context,&a);
}

void APIENTRY glVertex4hvNV (const GLhalfNV * a)
{
	(*HostCall_p)(NFOSMESA_GLVERTEX4HVNV,cur_context,&a);
}

void APIENTRY glNormal3hNV (GLhalfNV a, GLhalfNV b, GLhalfNV c)
{
	(*HostCall_p)(NFOSMESA_GLNORMAL3HNV,cur_context,&a);
}

void APIENTRY glNormal3hvNV (const GLhalfNV * a)
{
	(*HostCall_p)(NFOSMESA_GLNORMAL3HVNV,cur_context,&a);
}

void APIENTRY glColor3hNV (GLhalfNV a, GLhalfNV b, GLhalfNV c)
{
	(*HostCall_p)(NFOSMESA_GLCOLOR3HNV,cur_context,&a);
}

void APIENTRY glColor3hvNV (const GLhalfNV * a)
{
	(*HostCall_p)(NFOSMESA_GLCOLOR3HVNV,cur_context,&a);
}

void APIENTRY glColor4hNV (GLhalfNV a, GLhalfNV b, GLhalfNV c, GLhalfNV d)
{
	(*HostCall_p)(NFOSMESA_GLCOLOR4HNV,cur_context,&a);
}

void APIENTRY glColor4hvNV (const GLhalfNV * a)
{
	(*HostCall_p)(NFOSMESA_GLCOLOR4HVNV,cur_context,&a);
}

void APIENTRY glTexCoord1hNV (GLhalfNV a)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD1HNV,cur_context,&a);
}

void APIENTRY glTexCoord1hvNV (const GLhalfNV * a)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD1HVNV,cur_context,&a);
}

void APIENTRY glTexCoord2hNV (GLhalfNV a, GLhalfNV b)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD2HNV,cur_context,&a);
}

void APIENTRY glTexCoord2hvNV (const GLhalfNV * a)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD2HVNV,cur_context,&a);
}

void APIENTRY glTexCoord3hNV (GLhalfNV a, GLhalfNV b, GLhalfNV c)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD3HNV,cur_context,&a);
}

void APIENTRY glTexCoord3hvNV (const GLhalfNV * a)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD3HVNV,cur_context,&a);
}

void APIENTRY glTexCoord4hNV (GLhalfNV a, GLhalfNV b, GLhalfNV c, GLhalfNV d)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD4HNV,cur_context,&a);
}

void APIENTRY glTexCoord4hvNV (const GLhalfNV * a)
{
	(*HostCall_p)(NFOSMESA_GLTEXCOORD4HVNV,cur_context,&a);
}

void APIENTRY glMultiTexCoord1hNV (GLenum a, GLhalfNV b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD1HNV,cur_context,&a);
}

void APIENTRY glMultiTexCoord1hvNV (GLenum a, const GLhalfNV * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD1HVNV,cur_context,&a);
}

void APIENTRY glMultiTexCoord2hNV (GLenum a, GLhalfNV b, GLhalfNV c)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD2HNV,cur_context,&a);
}

void APIENTRY glMultiTexCoord2hvNV (GLenum a, const GLhalfNV * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD2HVNV,cur_context,&a);
}

void APIENTRY glMultiTexCoord3hNV (GLenum a, GLhalfNV b, GLhalfNV c, GLhalfNV d)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD3HNV,cur_context,&a);
}

void APIENTRY glMultiTexCoord3hvNV (GLenum a, const GLhalfNV * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD3HVNV,cur_context,&a);
}

void APIENTRY glMultiTexCoord4hNV (GLenum a, GLhalfNV b, GLhalfNV c, GLhalfNV d, GLhalfNV e)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD4HNV,cur_context,&a);
}

void APIENTRY glMultiTexCoord4hvNV (GLenum a, const GLhalfNV * b)
{
	(*HostCall_p)(NFOSMESA_GLMULTITEXCOORD4HVNV,cur_context,&a);
}

void APIENTRY glFogCoordhNV (GLhalfNV a)
{
	(*HostCall_p)(NFOSMESA_GLFOGCOORDHNV,cur_context,&a);
}

void APIENTRY glFogCoordhvNV (const GLhalfNV * a)
{
	(*HostCall_p)(NFOSMESA_GLFOGCOORDHVNV,cur_context,&a);
}

void APIENTRY glSecondaryColor3hNV (GLhalfNV a, GLhalfNV b, GLhalfNV c)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3HNV,cur_context,&a);
}

void APIENTRY glSecondaryColor3hvNV (const GLhalfNV * a)
{
	(*HostCall_p)(NFOSMESA_GLSECONDARYCOLOR3HVNV,cur_context,&a);
}

void APIENTRY glVertexWeighthNV (GLhalfNV a)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXWEIGHTHNV,cur_context,&a);
}

void APIENTRY glVertexWeighthvNV (const GLhalfNV * a)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXWEIGHTHVNV,cur_context,&a);
}

void APIENTRY glVertexAttrib1hNV (GLuint a, GLhalfNV b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB1HNV,cur_context,&a);
}

void APIENTRY glVertexAttrib1hvNV (GLuint a, const GLhalfNV * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB1HVNV,cur_context,&a);
}

void APIENTRY glVertexAttrib2hNV (GLuint a, GLhalfNV b, GLhalfNV c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB2HNV,cur_context,&a);
}

void APIENTRY glVertexAttrib2hvNV (GLuint a, const GLhalfNV * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB2HVNV,cur_context,&a);
}

void APIENTRY glVertexAttrib3hNV (GLuint a, GLhalfNV b, GLhalfNV c, GLhalfNV d)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB3HNV,cur_context,&a);
}

void APIENTRY glVertexAttrib3hvNV (GLuint a, const GLhalfNV * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB3HVNV,cur_context,&a);
}

void APIENTRY glVertexAttrib4hNV (GLuint a, GLhalfNV b, GLhalfNV c, GLhalfNV d, GLhalfNV e)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4HNV,cur_context,&a);
}

void APIENTRY glVertexAttrib4hvNV (GLuint a, const GLhalfNV * b)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIB4HVNV,cur_context,&a);
}

void APIENTRY glVertexAttribs1hvNV (GLuint a, GLsizei b, const GLhalfNV * c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBS1HVNV,cur_context,&a);
}

void APIENTRY glVertexAttribs2hvNV (GLuint a, GLsizei b, const GLhalfNV * c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBS2HVNV,cur_context,&a);
}

void APIENTRY glVertexAttribs3hvNV (GLuint a, GLsizei b, const GLhalfNV * c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBS3HVNV,cur_context,&a);
}

void APIENTRY glVertexAttribs4hvNV (GLuint a, GLsizei b, const GLhalfNV * c)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBS4HVNV,cur_context,&a);
}

void APIENTRY glPixelDataRangeNV (GLenum a, GLsizei b, GLvoid * c)
{
	(*HostCall_p)(NFOSMESA_GLPIXELDATARANGENV,cur_context,&a);
}

void APIENTRY glFlushPixelDataRangeNV (GLenum a)
{
	(*HostCall_p)(NFOSMESA_GLFLUSHPIXELDATARANGENV,cur_context,&a);
}

void APIENTRY glPrimitiveRestartNV (void)
{
	(*HostCall_p)(NFOSMESA_GLPRIMITIVERESTARTNV,cur_context,NULL);
}

void APIENTRY glPrimitiveRestartIndexNV (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLPRIMITIVERESTARTINDEXNV,cur_context,&a);
}

GLvoid* APIENTRY glMapObjectBufferATI (GLuint a)
{
	return (GLvoid *)(*HostCall_p)(NFOSMESA_GLMAPOBJECTBUFFERATI,cur_context,&a);
}

void APIENTRY glUnmapObjectBufferATI (GLuint a)
{
	(*HostCall_p)(NFOSMESA_GLUNMAPOBJECTBUFFERATI,cur_context,&a);
}

void APIENTRY glStencilOpSeparateATI (GLenum a, GLenum b, GLenum c, GLenum d)
{
	(*HostCall_p)(NFOSMESA_GLSTENCILOPSEPARATEATI,cur_context,&a);
}

void APIENTRY glStencilFuncSeparateATI (GLenum a, GLenum b, GLint c, GLuint d)
{
	(*HostCall_p)(NFOSMESA_GLSTENCILFUNCSEPARATEATI,cur_context,&a);
}

void APIENTRY glVertexAttribArrayObjectATI (GLuint a, GLint b, GLenum c, GLboolean d, GLsizei e, GLuint f, GLuint g)
{
	(*HostCall_p)(NFOSMESA_GLVERTEXATTRIBARRAYOBJECTATI,cur_context,&a);
}

void APIENTRY glGetVertexAttribArrayObjectfvATI (GLuint a, GLenum b, GLfloat * c)
{
	(*HostCall_p)(NFOSMESA_GLGETVERTEXATTRIBARRAYOBJECTFVATI,cur_context,&a);
}

void APIENTRY glGetVertexAttribArrayObjectivATI (GLuint a, GLenum b, GLint * c)
{
	(*HostCall_p)(NFOSMESA_GLGETVERTEXATTRIBARRAYOBJECTIVATI,cur_context,&a);
}

void APIENTRY glDepthBoundsEXT (GLclampd a, GLclampd b)
{
	(*HostCall_p)(NFOSMESA_GLDEPTHBOUNDSEXT,cur_context,&a);
}

void APIENTRY glBlendEquationSeparateEXT (GLenum a, GLenum b)
{
	(*HostCall_p)(NFOSMESA_GLBLENDEQUATIONSEPARATEEXT,cur_context,&a);
}

/* Functions generated: 974 */
