# Find macro for OpenBabel2
# Once done this will define
#
#  OPENBABEL2_FOUND - system has OpenBabel2
#  OPENBABEL2_INCLUDE_DIRS - the OpenBabel2 include directory
#  OPENBABEL2_LIBRARIES - Link these to use OpenBabel2


FIND_PACKAGE(PkgConfig QUIET)

IF(PKG_CONFIG_FOUND)
	PKG_CHECK_MODULES(OPENBABEL2 QUIET openbabel-2.0)
ENDIF()

FIND_PATH(OPENBABEL2_INCLUDE_DIR NAMES openbabel/obconversion.h
	PATHS ${OPENBABEL2_INCLUDE_DIRS}
	PATH_SUFFIXES openbabel-2.0
)

FIND_LIBRARY(OPENBABEL2_LIBRARY NAMES openbabel openbabel-2
	PATHS ${OPENBABEL2_LIBRARY_DIRS}
	PATH_SUFFIXES bin
)

SET(OPENBABEL2_INCLUDE_DIRS ${OPENBABEL2_INCLUDE_DIR})
SET(OPENBABEL2_LIBRARIES ${OPENBABEL2_LIBRARY})

IF(OPENBABEL2_INCLUDE_DIRS AND EXISTS "${OPENBABEL2_INCLUDE_DIRS}/openbabel/babelconfig.h")
	file(STRINGS "${OPENBABEL2_INCLUDE_DIRS}/openbabel/babelconfig.h" OPENBABEL2_VERSION_TMP REGEX "#define BABEL_VERSION \"([0-9.]+)\"")
	string(REGEX REPLACE "#define BABEL_VERSION \"([0-9.]+)\"" "\\1" OPENBABEL2_VERSION_STRING "${OPENBABEL2_VERSION_TMP}")
	MESSAGE(STATUS "Found OpenBabel: ${OPENBABEL2_VERSION_STRING}")
ENDIF()

INCLUDE(FindPackageHandleStandardArgs)

FIND_PACKAGE_HANDLE_STANDARD_ARGS(OpenBabel2 DEFAULT_MSG OPENBABEL2_INCLUDE_DIRS OPENBABEL2_LIBRARIES OPENBABEL2_VERSION_STRING)
