;          TRUNCATE.ASM                                          Agner Fog 2004

;  2003 GNU General Public License www.gnu.org/copyleft/gpl.html

.686
.xmm
.model flat

extrn instrset:dword, InstructionSet:near

PublicAlias MACRO MangledName ; macro for giving a function alias public names
        MangledName label near
        public MangledName
ENDM

.code

; ********** Truncate function **********
; C++ prototype:
; extern "C" int Truncate (double x);

; This function converts a double precision floating point number to
; an integer, rounding towards zero.

; This function is faster than the default conversion method in C++.
; Uses SSE2 instruction set if possible.

; For the sake of speed, there is no special overflow check. In case of 
; overflow, you may get an exception or an invalid result.

Truncate PROC NEAR
PUBLIC Truncate
PublicAlias _Truncate               ; Underscore needed when called from Windows
        cmp     [instrset], 4       ; can we use XMM instructions?
        jl      NO_SSE2
        ; SSE2 (XMM) instruction set:
        cvttsd2si eax, [esp+4]      ; use truncation instruction
        ret

NO_SSE2:cmp     [instrset], 0
        jl      DETECT_INSTRUCTIONSET
        ; default instruction set:
        fld     qword ptr [esp+4]   ; x
        sub     esp, 12             ; space for local variables
        fist    dword ptr [esp]     ; rounded value
        fst     dword ptr [esp+4]   ; float value
        fisub   dword ptr [esp]     ; subtract rounded value
        fstp    dword ptr [esp+8]   ; difference
        pop     eax                 ; rounded value
        pop     ecx                 ; float value
        pop     edx                 ; difference (float)
        test    ecx, ecx            ; test sign of x
        js      SHORT NEGATIVE
        add     edx, 7FFFFFFFH      ; produce carry if difference < -0
        sbb     eax, 0              ; subtract 1 if x-round(x) < -0
        ret
NEGATIVE:
        xor     ecx, ecx
        test    edx, edx
        setg    cl                  ; 1 if difference > 0
        add     eax, ecx            ; add 1 if x-round(x) > 0
        ret

DETECT_INSTRUCTIONSET:              ; first time call. detect instruction set
        call    InstructionSet
        jmp     Truncate        
Truncate ENDP

END
