#ifndef H_CDW_WIDGETS
#define H_CDW_WIDGETS





#include <stddef.h> /* size_t */

#include "main.h"
#include "cdw_colors.h"
#include "cdw_ncurses.h"
#include "cdw_dropdown.h"
#include "cdw_button.h"
#include "cdw_checkbox.h"
#include "cdw_safe_input_line.h"
#include "cdw_dialog.h"
#include "cdw_dynamic_label.h"





/* Widget IDs, useful e.g. for selecting constructors
   when building form with many widgets. */
enum {
	CDW_WIDGET_ID_INIT              = 0,

	CDW_WIDGET_ID_STATIC_LABEL      = 1,
	CDW_WIDGET_ID_CHECKBOX          = 2,
	CDW_WIDGET_ID_DROPDOWN          = 3,
	CDW_WIDGET_ID_BUTTON            = 4,
	CDW_WIDGET_ID_TEXT              = 5,  /* Like label, but larger, and with special requirements. */
	CDW_WIDGET_ID_SAFE_INPUT_LINE   = 6,  /* With built-in checking for insecure characters. */
	CDW_WIDGET_ID_DYNAMIC_LABEL     = 7,
	CDW_WIDGET_ID_FILE_SELECTOR     = 8
};





const char *cdw_widgets_widget_type_label(cdw_id_t widget_type);
bool        cdw_widget_is_valid_widget_id(cdw_id_t widget_type);


void cdw_widget_init(cdw_widget_t *widget);
void cdw_widget_add_return_key(cdw_widget_t *widget, int key);
void cdw_widget_add_return_keys(cdw_widget_t *widget, ...);
void cdw_widget_add_return_keys_pointer(cdw_widget_t *widget, ...);
bool cdw_widget_is_return_key(cdw_widget_t const * widget, int key);





#endif /* ifndef H_CDW_WIDGETS */
