/*
 * Copyright 2002 Sun Microsystems, Inc.  All rights reserved.
 *
 * Use is subject to the GNU General Public License, Version 2,
 * June 1991, which is contained in the read-me file named
 * "README_GNU_GPL." This program is free software; you can
 * redistribute it and/or modify it under the terms of the GNU
 * General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your
 * option) any later version. This library is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "lcdutils.h"

int main(int argc, char **argv) {
	void *lcd;
	int silent;
	
	silent = (((argc > 1) && strcmp(argv[1], "-s") == 0)) ? 1 : 0; 
	
	lcd_setlocale();
	if (!silent && (lcd_lock() < 0)) {
		printf(_("LCD in use... try again later\n"));
		exit(0);
	}
	
	if (argc <= 1 + silent) {
		printf(_("Please pass text to display\n"));
		lcd_unlock();
		exit(0);
	}
	
	if ((lcd = lcd_open(O_RDWR)) == NULL) {
		printf(_("LCD is not present\n"));
	} else {
		lcd_reset(lcd);
		lcd_spin(lcd, argv[1 + silent], (argc > 2 + silent) ? argv[2 + silent] : NULL);
	}
	lcd_close(lcd);
	if (!silent)
		lcd_unlock();
	exit(0);
}
