/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.charcode.UnicodeCharacterSet;
import net.sf.saxon.event.HTMLURIEscaper;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class EscapeURI
extends SystemFunction {
    public static final int ENCODE_FOR_URI = 1;
    public static final int IRI_TO_URI = 2;
    public static final int HTML_URI = 3;
    private static final String hex = "0123456789ABCDEF";

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.argument[0].evaluateItem(xPathContext);
        if (item == null) {
            return StringValue.EMPTY_STRING;
        }
        CharSequence charSequence = item.getStringValueCS();
        switch (this.operation) {
            case 1: {
                return StringValue.makeStringValue(EscapeURI.escape(charSequence, "-_.~"));
            }
            case 2: {
                return StringValue.makeStringValue(EscapeURI.iriToUri(charSequence));
            }
            case 3: {
                return StringValue.makeStringValue(HTMLURIEscaper.escapeURL(charSequence, false));
            }
        }
        throw new UnsupportedOperationException("Unknown escape operation");
    }

    public static CharSequence iriToUri(CharSequence charSequence) {
        if (EscapeURI.allAscii(charSequence)) {
            return charSequence;
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length() + 20);
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c <= ' ' || c >= '\u007f') {
                EscapeURI.escapeChar(c, i + 1 < charSequence.length() ? charSequence.charAt(i + 1) : (char)' ', fastStringBuffer);
                continue;
            }
            fastStringBuffer.append(c);
        }
        return fastStringBuffer;
    }

    private static boolean allAscii(CharSequence charSequence) {
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c > ' ' && c < '\u007f') continue;
            return false;
        }
        return true;
    }

    public static CharSequence escape(CharSequence charSequence, String string) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                fastStringBuffer.append(c);
                continue;
            }
            if (c <= ' ' || c >= '\u007f') {
                EscapeURI.escapeChar(c, i + 1 < charSequence.length() ? charSequence.charAt(i + 1) : (char)' ', fastStringBuffer);
                continue;
            }
            if (string.indexOf(c) >= 0) {
                fastStringBuffer.append(c);
                continue;
            }
            EscapeURI.escapeChar(c, ' ', fastStringBuffer);
        }
        return fastStringBuffer;
    }

    private static void escapeChar(char c, char c2, FastStringBuffer fastStringBuffer) {
        byte[] byArray = new byte[4];
        int n = UnicodeCharacterSet.getUTF8Encoding(c, c2, byArray);
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            fastStringBuffer.append('%');
            fastStringBuffer.append(hex.charAt(n2 / 16));
            fastStringBuffer.append(hex.charAt(n2 % 16));
        }
    }
}

