/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.instruct.ResultDocument;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class Serialize
extends SystemFunction
implements XSLTFunction {
    Properties outputProperties;
    private transient boolean checked = false;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.checked) {
            return;
        }
        this.checked = true;
        super.checkArguments(staticContext);
        if (this.argument[1] instanceof StringValue) {
            if (staticContext instanceof ExpressionContext) {
                String string = ((StringValue)this.argument[1]).getStringValue();
                int n = -1;
                if (!string.equals("") && (n = ((ExpressionContext)staticContext).getFingerprint(string, false)) == -1) {
                    throw new StaticError("Output format '" + string + "' has not been defined");
                }
                this.outputProperties = ((ExpressionContext)staticContext).getXSLStylesheet().gatherOutputProperties(n);
            } else {
                this.outputProperties = new Properties();
                this.outputProperties.setProperty("method", ((StringValue)this.argument[1]).getStringValue());
            }
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Object object;
        NodeInfo nodeInfo = (NodeInfo)this.argument[0].evaluateItem(xPathContext);
        if (nodeInfo == null) {
            return StringValue.EMPTY_STRING;
        }
        Properties properties = this.outputProperties;
        if (properties == null) {
            object = this.argument[1].evaluateItem(xPathContext);
            if (!(object instanceof NodeInfo) || ((NodeInfo)object).getNodeKind() != 1 || ((NodeInfo)object).getFingerprint() != 165) {
                DynamicError dynamicError = new DynamicError("The second argument of saxon:serialize must either be a string literal, or an xsl:output element");
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
            properties = this.processXslOutputElement((NodeInfo)object, xPathContext);
        }
        try {
            object = new StringWriter();
            XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
            xPathContext.setOriginatingConstructType(2053);
            xPathContextMinor.changeOutputDestination(properties, new StreamResult((Writer)object), false, this.getHostLanguage(), 3, null);
            SequenceReceiver sequenceReceiver = xPathContextMinor.getReceiver();
            sequenceReceiver.open();
            nodeInfo.copy(sequenceReceiver, 2, true, this.locationId);
            sequenceReceiver.close();
            return new StringValue(((StringWriter)object).toString());
        }
        catch (XPathException xPathException) {
            throw new DynamicError(xPathException);
        }
    }

    private Properties processXslOutputElement(NodeInfo nodeInfo, XPathContext xPathContext) throws XPathException {
        NodeInfo nodeInfo2;
        Properties properties = new Properties();
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)2);
        NameChecker nameChecker = xPathContext.getConfiguration().getNameChecker();
        InscopeNamespaceResolver inscopeNamespaceResolver = new InscopeNamespaceResolver(nodeInfo);
        while ((nodeInfo2 = (NodeInfo)axisIterator.next()) != null) {
            String string = nodeInfo2.getURI();
            String string2 = nodeInfo2.getLocalPart();
            String string3 = nodeInfo2.getStringValue().trim();
            ResultDocument.setSerializationProperty(properties, string, string2, string3, inscopeNamespaceResolver, false, nameChecker);
        }
        return properties;
    }
}

