/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import net.sf.saxon.Err;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class UnparsedText
extends SystemFunction
implements XSLTFunction {
    String expressionBaseURI = null;
    public static final int UNPARSED_TEXT = 0;
    public static final int UNPARSED_TEXT_AVAILABLE = 1;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(staticContext);
            this.expressionBaseURI = staticContext.getBaseURI();
        }
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        StringValue stringValue;
        try {
            StringValue stringValue2 = (StringValue)this.argument[0].evaluateItem(xPathContext);
            if (stringValue2 == null) {
                return null;
            }
            String string = stringValue2.getStringValue();
            String string2 = null;
            if (this.getNumberOfArguments() == 2) {
                string2 = this.argument[1].evaluateItem(xPathContext).getStringValue();
            }
            stringValue = new StringValue(this.readFile(string, this.expressionBaseURI, string2, xPathContext.getConfiguration().getNameChecker()));
        }
        catch (XPathException xPathException) {
            if (this.operation == 1) {
                return BooleanValue.FALSE;
            }
            throw xPathException;
        }
        if (this.operation == 1) {
            return BooleanValue.TRUE;
        }
        return stringValue;
    }

    private CharSequence readFile(String string, String string2, String string3, NameChecker nameChecker) throws XPathException {
        URL uRL;
        if (string2 == null) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                DynamicError dynamicError = new DynamicError("Cannot resolve absolute URI", malformedURLException);
                dynamicError.setErrorCode("XTDE1170");
                throw dynamicError;
            }
        }
        try {
            uRL = new URL(new URL(string2), string);
        }
        catch (MalformedURLException malformedURLException) {
            DynamicError dynamicError = new DynamicError("Cannot resolve relative URI", malformedURLException);
            dynamicError.setErrorCode("XTDE1170");
            throw dynamicError;
        }
        try {
            int n;
            Object object;
            Object object2;
            InputStream inputStream;
            if (string3 != null) {
                inputStream = uRL.openStream();
            } else {
                object2 = uRL.openConnection();
                ((URLConnection)object2).connect();
                inputStream = ((URLConnection)object2).getInputStream();
                try {
                    int n2;
                    if (!inputStream.markSupported()) {
                        inputStream = new BufferedInputStream(inputStream);
                    }
                    if (!"file".equals(((URLConnection)object2).getURL().getProtocol()) && (object = ((URLConnection)object2).getContentType()) != null && (n2 = ((String)object).indexOf("charset")) >= 0) {
                        if ((n2 = ((String)object).indexOf(61, n2 + 7)) >= 0) {
                            object = ((String)object).substring(n2 + 1);
                        }
                        if ((n2 = ((String)object).indexOf(59)) > 0) {
                            object = ((String)object).substring(0, n2);
                        }
                        if ((n2 = ((String)object).indexOf(40)) > 0) {
                            object = ((String)object).substring(0, n2);
                        }
                        if ((n2 = ((String)object).indexOf(34)) > 0) {
                            object = ((String)object).substring(n2 + 1, ((String)object).indexOf(34, n2 + 2));
                        }
                        string3 = ((String)object).trim();
                    }
                    if (string3 == null) {
                        inputStream.mark(100);
                        byte[] byArray = new byte[100];
                        int n3 = inputStream.read(byArray, 0, 100);
                        inputStream.reset();
                        string3 = this.inferEncoding(byArray, n3);
                    }
                }
                catch (IOException iOException) {
                    string3 = "UTF-8";
                }
            }
            object2 = Charset.forName(string3);
            object = ((Charset)object2).newDecoder();
            object = ((CharsetDecoder)object).onMalformedInput(CodingErrorAction.REPORT);
            object = ((CharsetDecoder)object).onUnmappableCharacter(CodingErrorAction.REPORT);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, (CharsetDecoder)object));
            FastStringBuffer fastStringBuffer = new FastStringBuffer(2048);
            char[] cArray = new char[2048];
            boolean bl = true;
            int n4 = 1;
            int n5 = 1;
            while ((n = ((Reader)bufferedReader).read(cArray, 0, 2048)) >= 0) {
                int n6 = 0;
                while (n6 < n) {
                    int n7;
                    if ((n7 = cArray[n6++]) == 10) {
                        ++n4;
                        n5 = 0;
                    }
                    ++n5;
                    if (XMLChar.isHighSurrogate(n7)) {
                        if (n6 == n) {
                            n = ((Reader)bufferedReader).read(cArray, 0, 2048);
                            n6 = 0;
                        }
                        char c = cArray[n6++];
                        n7 = XMLChar.supplemental((char)n7, c);
                    }
                    if (nameChecker.isValidChar(n7)) continue;
                    DynamicError dynamicError = new DynamicError("The unparsed-text file contains a character illegal in XML (line=" + n4 + " column=" + n5 + " value=hex " + Integer.toHexString(n7) + ')');
                    dynamicError.setErrorCode("XTDE1190");
                    throw dynamicError;
                }
                if (bl) {
                    bl = false;
                    if (cArray[0] == '\ufeff') {
                        fastStringBuffer.append(cArray, 1, n - 1);
                        continue;
                    }
                    fastStringBuffer.append(cArray, 0, n);
                    continue;
                }
                fastStringBuffer.append(cArray, 0, n);
            }
            ((Reader)bufferedReader).close();
            return fastStringBuffer.condense();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            DynamicError dynamicError = new DynamicError("Unknown encoding " + Err.wrap(string3), unsupportedEncodingException);
            dynamicError.setErrorCode("XTDE1190");
            throw dynamicError;
        }
        catch (IOException iOException) {
            String string4 = "Failed to read input file";
            if (!iOException.getMessage().equals(uRL.toString())) {
                string4 = string4 + ' ' + uRL.toString();
            }
            string4 = string4 + " (" + iOException.getClass().getName() + ')';
            DynamicError dynamicError = new DynamicError(string4, iOException);
            String string5 = iOException instanceof MalformedInputException ? "XTDE1200" : (iOException instanceof CharacterCodingException ? "XTDE1200" : (iOException instanceof UnmappableCharacterException ? "XTDE1190" : "XTDE1170"));
            dynamicError.setErrorCode(string5);
            dynamicError.setLocator(this);
            throw dynamicError;
        }
    }

    private String inferEncoding(byte[] byArray, int n) {
        if (n >= 2) {
            if (this.ch(byArray[0]) == 254 && this.ch(byArray[1]) == 255) {
                return "UTF-16";
            }
            if (this.ch(byArray[0]) == 255 && this.ch(byArray[1]) == 254) {
                return "UTF-16LE";
            }
        }
        if (n >= 3 && this.ch(byArray[0]) == 239 && this.ch(byArray[1]) == 187 && this.ch(byArray[2]) == 191) {
            return "UTF-8";
        }
        if (n >= 4) {
            if (this.ch(byArray[0]) == 60 && this.ch(byArray[1]) == 63 && this.ch(byArray[2]) == 120 && this.ch(byArray[3]) == 109 && this.ch(byArray[4]) == 108) {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(n);
                for (int i = 0; i < n; ++i) {
                    fastStringBuffer.append((char)byArray[i]);
                }
                String string = fastStringBuffer.toString();
                int n2 = string.indexOf("encoding");
                if (n2 >= 0) {
                    n2 += 8;
                    while (n2 < string.length() && " \n\r\t=\"'".indexOf(string.charAt(n2)) >= 0) {
                        ++n2;
                    }
                    fastStringBuffer.setLength(0);
                    while (n2 < string.length() && string.charAt(n2) != '\"' && string.charAt(n2) != '\'') {
                        fastStringBuffer.append(string.charAt(n2++));
                    }
                    return fastStringBuffer.toString();
                }
            }
        } else {
            if (n > 0 && byArray[0] == 0 && byArray[2] == 0 && byArray[4] == 0 && byArray[6] == 0) {
                return "UTF-16";
            }
            if (n > 1 && byArray[1] == 0 && byArray[3] == 0 && byArray[5] == 0 && byArray[7] == 0) {
                return "UTF-16LE";
            }
        }
        return "UTF-8";
    }

    private int ch(byte by) {
        return by & 0xFF;
    }

    public static void main(String[] stringArray) throws Exception {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        FastStringBuffer fastStringBuffer2 = new FastStringBuffer(100);
        File file = new File(stringArray[0]);
        FileInputStream fileInputStream = new FileInputStream(file);
        while (true) {
            int n;
            if ((n = ((InputStream)fileInputStream).read()) < 0) break;
            fastStringBuffer.append(Integer.toHexString(n) + " ");
            fastStringBuffer2.append((char)n + " ");
            if (fastStringBuffer.length() <= 80) continue;
            System.out.println(fastStringBuffer.toString());
            System.out.println(fastStringBuffer2.toString());
            fastStringBuffer = new FastStringBuffer(100);
            fastStringBuffer2 = new FastStringBuffer(100);
        }
        System.out.println(fastStringBuffer.toString());
        System.out.println(fastStringBuffer2.toString());
    }
}

