FIND_PROGRAM(INTLTOOL_MERGE_EXECUTABLE intltool-merge)
FIND_PROGRAM(INTLTOOL_MSGFMT_EXECUTABLE msgfmt)

MACRO(INTLTOOL_MO _domain _lang)
	SET(_files)
	FOREACH(_curLang ${_lang} ${ARGN})
		SET(_source      "${CMAKE_CURRENT_SOURCE_DIR}/${_curLang}.po")
		SET(_destination "${CMAKE_CURRENT_BINARY_DIR}/${_curLang}.mo")
		ADD_CUSTOM_COMMAND(
			OUTPUT ${_destination}
			COMMAND ${INTLTOOL_MSGFMT_EXECUTABLE} -o ${_destination} ${_source}
			DEPENDS ${_source}
			WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}
			COMMENT "compile message catalog ${_domain}/${_curLang}.mo"
			VERBATIM
		)

		INSTALL(
			FILES ${_destination}
			DESTINATION ${DIRS_LOCALEDIR}/${_curLang}/LC_MESSAGES
			RENAME "${_domain}.mo"
		)

		SET(_files ${_files} ${_destination})
	ENDFOREACH(_curLang)

	ADD_CUSTOM_TARGET("intltool-${_domain}-mo"
	                  ALL
	                  DEPENDS ${_files})
ENDMACRO(INTLTOOL_MO)


MACRO(INTLTOOL_MERGE _po _source _target)
	ADD_CUSTOM_COMMAND(
		OUTPUT ${_target}
		COMMAND ${INTLTOOL_MERGE_EXECUTABLE} -d ../${_po} ${_source} ${CMAKE_CURRENT_BINARY_DIR}/${_target}
		DEPENDS ${_source}
		WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}
		COMMENT "merge ${_source}"
		VERBATIM
	)

	ADD_CUSTOM_TARGET(
		"intltool-merge-${_target}"
		ALL
		DEPENDS ${_target}
	)
ENDMACRO(INTLTOOL_MERGE)


IF (INTLTOOL_MERGE_EXECUTABLE AND INTLTOOL_MSGFMT_EXECUTABLE)
   SET(INTLTOOL_FOUND TRUE)
ELSE (INTLTOOL_MERGE_EXECUTABLE AND INTLTOOL_MSGFMT_EXECUTABLE)
   SET(INTLTOOL_FOUND FALSE)
   IF (Intltools_REQUIRED)
      MESSAGE(FATAL_ERROR "Intltools not found")
   ENDIF (Intltools_REQUIRED)
ENDIF (INTLTOOL_MERGE_EXECUTABLE AND INTLTOOL_MSGFMT_EXECUTABLE)
