/* $Id: e2_dialog.h 874 2008-05-07 14:47:27Z tpgww $

Copyright (C) 2003-2008 tooar <tooar@gmx.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

/**
@file  src/dialogs/e2_dialog.h
@brief  dialog utilities header file

This file is the header for the dialog utility functions.
*/

#ifndef __E2_DIALOG_H__
#define __E2_DIALOG_H__

#include "emelfm2.h"
#include "e2_about_dialog.h"
#include "e2_config_dialog.h"
//#include "e2_mkdir_dialog.h"
#include "e2_select_image_dialog.h"
#include "e2_view_dialog.h"
//button signals from here
#include "e2_button.h"
#include "e2_fileview.h"

//this supports one-time dialog setup (not yet implemented)
//#define LATESHOW

typedef enum
{
	E2_DIALOG_RUNMODAL     =1,
	E2_DIALOG_NONMODAL     =1<<1,	//not implemented
	E2_DIALOG_FREE         =1<<2,
	E2_DIALOG_DONT_SHOW_ALL=1<<3,
	E2_DIALOG_THREADED     =1<<4,	//set to do threads_enter/leave around showing the dialog
} E2_DialogFlags;

typedef enum
{
	OK          = 1,
	CANCEL      = 1 << 1,
	APPLY       = 1 << 2,
	APPLY_TO_ALL= 1 << 3,
	YES         = 1 << 4,
	YES_TO_ALL  = 1 << 5,
	NO          = 1 << 6,
	NO_TO_ALL   = 1 << 7
} DialogButtons;

typedef enum
{
	NONE   = 0,
	YESALL = 1,
	NOALL  = 1 << 1,
	BOTHALL= 1 << 2
} OW_ButtonFlags;

enum { E2_TYPE_CANCELLED, E2_TYPE_HANDLED, E2_TYPE_NOTHANDLED };

void e2_dialog_response_decode_cb (GtkDialog *dialog, gint response,
	DialogButtons *dialog_result);
gboolean e2_dialog_cancel_cb (GtkWidget *widget, GtkWidget *dialog);
gboolean e2_dialog_key_neg_cb
	(GtkWidget *widget, GdkEventKey *event, gpointer data);
gboolean e2_dialog_key_press_cb
	(GtkWidget *widget, GdkEventKey *event, GtkWidget *dialog);
void e2_dialog_show_cb (GtkWidget *dialog, GtkScrolledWindow *scrolled);
void e2_dialog_show_notebook_cb (GtkWidget *dialog, GtkNotebook *book);
/* tag PASSWORDINPUT
DialogButtons e2_dialog_password_input (gchar* window_title, gchar *prompt,
	gchar **input); */
//generic dialog for line input
DialogButtons e2_dialog_line_input (gchar* window_title, gchar *prompt,
	gchar *suggestion, OW_ButtonFlags extras, gboolean select_text,
	gchar **input);
DialogButtons e2_dialog_combo_input (gchar* window_title, gchar *prompt,
	gchar *suggestion, OW_ButtonFlags extras, GList **history_list, gchar **input);
//overwrite check dialog
DialogButtons e2_dialog_ow_check (gchar *slocal, gchar *dlocal, OW_ButtonFlags extras);
DialogButtons e2_dialog_warning (gchar *prompt);
GtkWidget *e2_dialog_slow (gchar *prompt_type, gchar *tip_type,
	gpointer response_func, gpointer data);
void e2_dialog_setup_chooser (GtkWidget *dialog, const gchar *title,
	const gchar *startpath, GtkFileChooserAction action, gboolean showhidden,
	gboolean multi, gint defresponse);

//extern gboolean e2_dialog_key_cb (GtkWidget *widget, GdkEventKey *event, gpointer data);
void e2_dialog_setup (GtkWidget *dialog, GtkWidget *parent);
gint e2_dialog_show (GtkWidget *dialog, GtkWidget *parent, E2_DialogFlags flags,
	E2_Button *button, ...);
gint e2_dialog_run (GtkWidget *dialog, GtkWidget *parent, E2_DialogFlags flags);
//GtkWidget *get_dialog (GtkWidget *parent, GtkMessageType type, gchar *label_text);
GtkWidget *e2_dialog_create (const gchar *stock, const gchar *label_text,
	const gchar *title, gpointer callback, gpointer data);
GtkWidget *e2_dialog_add_sw (GtkWidget *dialog);
GtkWidget *e2_dialog_add_defined_button (GtkWidget *dialog, E2_Button *button);
GtkWidget *e2_dialog_add_undefined_button (GtkWidget *dialog, gchar *stock,
	gchar *label, gint response);
GtkWidget *e2_dialog_add_button_custom ( GtkWidget *dialog, gboolean is_default,
	E2_Button *buttontype, gchar *tip, void *callback, void *data);
GtkWidget *e2_dialog_add_undefined_button_custom ( GtkWidget *dialog, gboolean is_default,
	guint response, gchar *label, gchar *stock, gchar *tip, void *callback, void *data);
GtkWidget *e2_dialog_add_toggle_button (GtkWidget *dialog, gboolean value,
	gchar *label, gchar *tip, gint response);
GtkWidget *e2_dialog_add_check_button (GtkWidget *dialog, gboolean value,
	gchar *label, gchar *tip, gint response);
void e2_dialog_attach_menu (GtkWidget *dialog, GtkWidget *menu);
//void e2_dialog_set_positive_response (GtkWidget *dialog, gint response);
void e2_dialog_set_negative_response (GtkWidget *dialog, gint response);
//void e2_dialog_set_responses (GtkWidget *dialog, gint pos, gint neg);
void e2_dialog_resize (GtkWidget *dialog, gfloat factor);
void e2_dialog_resize_with_sw (GtkWidget *dialog, GtkWidget *scrolled);
void e2_dialog_set_cursor (GtkWidget *dialog, GdkCursorType type);
void e2_dialog_options_register (void);

//dialog setup functions from other files
void e2_name_filter_dialog_create_cb (GtkWidget *item, ViewInfo *view);
void e2_size_filter_dialog_create_cb (GtkWidget *item, ViewInfo *view);
void e2_date_filter_dialog_create_cb (GtkWidget *item, ViewInfo *view);
void e2_select_items_byname_dialog_create (GtkWidget *item);
gint e2_filetype_dialog_create (VPATH *localpath, gboolean text,
	gboolean ambig, gboolean newtype);
DialogButtons e2_file_info_dialog_run (VPATH *localpath, gboolean multi);
void e2_filetype_dialog_edit_create (gchar *category);
void e2_opendir_dialog_create (ViewInfo *view, gchar *oldpath, gchar **newpath);
#endif //ndef __E2_DIALOG_H__
