/* $Id: er_main.h,v 1.14 2012/03/09 17:29:54 kbanse Exp $
 *
 *   This file is part of the ESO Common Pipeline Library
 *   Copyright (C) 2001-2008 European Southern Observatory
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: kbanse $
 * $Date: 2012/03/09 17:29:54 $
 * $Revision: 1.14 $
 * $Name: esorex-3_10 $
 */

#ifndef ER_MAIN_H
#define ER_MAIN_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cpl.h>

/* choose one section for en/disabling tracing ...

#   define ER_TRACEFLAG         1
#   define ER_TRACE(x)  printf("=> %s()\n",x); 
#   define ER_TRACEX(x)  printf("*** %s\n",x);

#   define ER_TRACEFLAG         0
#   define ER_TRACE(x)   ;
#   define ER_TRACEX(x)  ;
*/

#   define ER_TRACEFLAG         0
#   define ER_TRACE(x)   ;
#   define ER_TRACEX(x)  ;


#define MAXSTRLENCONF     1024

#define ForceNull(x)  if (*x == '\0') x = NULL;

#if defined HAVE_DECL___FUNC__ && HAVE_DECL___FUNC__
#define er_func __func__
#else
#define er_func ""
#endif

/*
 * Global resource files. Uncomment to allow the automatic detection and 
 * use of global configuration files.
 */

#define USE_GLOBAL_ESOREX_RC
#define USE_GLOBAL_PLUGIN_RC

#define GLOBAL_RC_DIR           "." PACKAGE
#define GLOBAL_RC_NAME          PACKAGE
#define GLOBAL_RC_EXTENSION     ".rc"
#define GLOBAL_RC_BACKUP        ".bak"

/*
 * Uncomment to use "local" local configuration files. Note that the code
 * for these may not be fully implemented.
 */

/* #define USE_LOCAL_ESOREX_RC */
/* #define USE_LOCAL_PLUGIN_RC */

#define LOCAL_RC_PATH           "."


/*
 * Name of resource-prefix to be used in EsoRex configuration files.
 */

#define PACKAGE_RESOURCE   PACKAGE ".caller"

/* 
 * Prefix to use for environment variables containing configuration settings 
 */ 

#define PACKAGE_ENV     "ESOREX"

/*
 * Presentation definitions
 */

#define COMMENT_TAB_POSITION   24
#define COMMAND_LINE_PREFIX    "--"

CPL_BEGIN_DECLS

/* No function declarations */

CPL_END_DECLS

/* needed because of the er_fileutils replace functions  */

#define PATHSET_MAX     1024

#endif /* ER_MAIN_H */


/* End of file */
