// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file dds_xtypes_typeobject.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__EPROSIMA_FASTDDS_DDS_XTYPES_DDS_XTYPES_TYPEOBJECT_HPP
#define FAST_DDS_GENERATED__EPROSIMA_FASTDDS_DDS_XTYPES_DDS_XTYPES_TYPEOBJECT_HPP

#include <array>
#include <cstdint>
#include <functional>
#include <string>
#include <utility>
#include <vector>

#include <fastcdr/cdr/fixed_size_string.hpp>
#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastcdr/exceptions/BadParamException.h>


#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(DDS_XTYPES_TYPEOBJECT_SOURCE)
#define DDS_XTYPES_TYPEOBJECT_DllAPI __declspec( dllexport )
#else
#define DDS_XTYPES_TYPEOBJECT_DllAPI __declspec( dllimport )
#endif // DDS_XTYPES_TYPEOBJECT_SOURCE
#else
#define DDS_XTYPES_TYPEOBJECT_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define DDS_XTYPES_TYPEOBJECT_DllAPI
#endif // _WIN32

namespace eprosima {

namespace fastdds {

namespace dds {


namespace xtypes {


typedef uint8_t EquivalenceKind;

const uint8_t EK_MINIMAL = 0xF1;
const uint8_t EK_COMPLETE = 0xF2;
const uint8_t EK_BOTH = 0xF3;
typedef uint8_t TypeKind;

const uint8_t TK_NONE = 0x00;
const uint8_t TK_BOOLEAN = 0x01;
const uint8_t TK_BYTE = 0x02;
const uint8_t TK_INT16 = 0x03;
const uint8_t TK_INT32 = 0x04;
const uint8_t TK_INT64 = 0x05;
const uint8_t TK_UINT16 = 0x06;
const uint8_t TK_UINT32 = 0x07;
const uint8_t TK_UINT64 = 0x08;
const uint8_t TK_FLOAT32 = 0x09;
const uint8_t TK_FLOAT64 = 0x0A;
const uint8_t TK_FLOAT128 = 0x0B;
const uint8_t TK_INT8 = 0x0C;
const uint8_t TK_UINT8 = 0x0D;
const uint8_t TK_CHAR8 = 0x10;
const uint8_t TK_CHAR16 = 0x11;
const uint8_t TK_STRING8 = 0x20;
const uint8_t TK_STRING16 = 0x21;
const uint8_t TK_ALIAS = 0x30;
const uint8_t TK_ENUM = 0x40;
const uint8_t TK_BITMASK = 0x41;
const uint8_t TK_ANNOTATION = 0x50;
const uint8_t TK_STRUCTURE = 0x51;
const uint8_t TK_UNION = 0x52;
const uint8_t TK_BITSET = 0x53;
const uint8_t TK_SEQUENCE = 0x60;
const uint8_t TK_ARRAY = 0x61;
const uint8_t TK_MAP = 0x62;
typedef uint8_t TypeIdentiferKind;

const uint8_t TI_STRING8_SMALL = 0x70;
const uint8_t TI_STRING8_LARGE = 0x71;
const uint8_t TI_STRING16_SMALL = 0x72;
const uint8_t TI_STRING16_LARGE = 0x73;
const uint8_t TI_PLAIN_SEQUENCE_SMALL = 0x80;
const uint8_t TI_PLAIN_SEQUENCE_LARGE = 0x81;
const uint8_t TI_PLAIN_ARRAY_SMALL = 0x90;
const uint8_t TI_PLAIN_ARRAY_LARGE = 0x91;
const uint8_t TI_PLAIN_MAP_SMALL = 0xA0;
const uint8_t TI_PLAIN_MAP_LARGE = 0xA1;
const uint8_t TI_STRONGLY_CONNECTED_COMPONENT = 0xB0;
const int32_t MEMBER_NAME_MAX_LENGTH = 256;
typedef eprosima::fastcdr::fixed_string<MEMBER_NAME_MAX_LENGTH> MemberName;

const int32_t TYPE_NAME_MAX_LENGTH = 256;
typedef eprosima::fastcdr::fixed_string<TYPE_NAME_MAX_LENGTH> QualifiedTypeName;

typedef uint8_t PrimitiveTypeId;

typedef std::array<uint8_t, 14> EquivalenceHash;

typedef std::array<uint8_t, 4> NameHash;

typedef uint32_t LBound;

typedef std::vector<LBound> LBoundSeq;

const LBound INVALID_LBOUND = 0;
typedef uint8_t SBound;

typedef std::vector<SBound> SBoundSeq;

const SBound INVALID_SBOUND = 0;
/*!
 * @brief This class represents the union TypeObjectHashId defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class TypeObjectHashId
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeObjectHashId()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeObjectHashId()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeObjectHashId that will be copied.
     */
    eProsima_user_DllExport TypeObjectHashId(
            const TypeObjectHashId& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            hash_() = x.m_hash;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeObjectHashId that will be copied.
     */
    eProsima_user_DllExport TypeObjectHashId(
            TypeObjectHashId&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            hash_() = std::move(x.m_hash);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeObjectHashId that will be copied.
     */
    eProsima_user_DllExport TypeObjectHashId& operator =(
            const TypeObjectHashId& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            hash_() = x.m_hash;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeObjectHashId that will be copied.
     */
    eProsima_user_DllExport TypeObjectHashId& operator =(
            TypeObjectHashId&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            hash_() = std::move(x.m_hash);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeObjectHashId object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeObjectHashId& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_hash == m_hash);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeObjectHashId object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeObjectHashId& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            uint8_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case EK_COMPLETE:
                        case EK_MINIMAL:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport uint8_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member hash
     * @param _hash New value to be copied in member hash
     */
    eProsima_user_DllExport void hash(
            const EquivalenceHash& _hash)
    {
        hash_() = _hash;
        m__d = EK_COMPLETE;
    }

    /*!
     * @brief This function moves the value in member hash
     * @param _hash New value to be moved in member hash
     */
    eProsima_user_DllExport void hash(
            EquivalenceHash&& _hash)
    {
        hash_() = _hash;
        m__d = EK_COMPLETE;
    }

    /*!
     * @brief This function returns a constant reference to member hash
     * @return Constant reference to member hash
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const EquivalenceHash& hash() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_hash;
    }

    /*!
     * @brief This function returns a reference to member hash
     * @return Reference to member hash
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport EquivalenceHash& hash()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_hash;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            EquivalenceHash& hash_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        using namespace eprosima::fastdds::dds::xtypes;
                        m_hash.~EquivalenceHash();
                    };
                    new(&m_hash) EquivalenceHash();

                }

                return m_hash;
            }


    uint8_t m__d {127};

    union
    {
        EquivalenceHash m_hash;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This enumeration represents the MemberFlag bitflags defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
enum MemberFlagBits : uint16_t
{
    TRY_CONSTRUCT1 = 0x01ull << 0,
    TRY_CONSTRUCT2 = 0x01ull << 1,
    IS_EXTERNAL = 0x01ull << 2,
    IS_OPTIONAL = 0x01ull << 3,
    IS_MUST_UNDERSTAND = 0x01ull << 4,
    IS_KEY = 0x01ull << 5,
    IS_DEFAULT = 0x01ull << 6
};
typedef uint16_t MemberFlag;
typedef MemberFlag CollectionElementFlag;

typedef MemberFlag StructMemberFlag;

typedef MemberFlag UnionMemberFlag;

typedef MemberFlag UnionDiscriminatorFlag;

typedef MemberFlag EnumeratedLiteralFlag;

typedef MemberFlag AnnotationParameterFlag;

typedef MemberFlag AliasMemberFlag;

typedef MemberFlag BitflagFlag;

typedef MemberFlag BitsetMemberFlag;

const uint16_t MemberFlagMinimalMask = 0x003f;
/*!
 * @brief This enumeration represents the TypeFlag bitflags defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
enum TypeFlagBits : uint16_t
{
    IS_FINAL = 0x01ull << 0,
    IS_APPENDABLE = 0x01ull << 1,
    IS_MUTABLE = 0x01ull << 2,
    IS_NESTED = 0x01ull << 3,
    IS_AUTOID_HASH = 0x01ull << 4
};
typedef uint16_t TypeFlag;
typedef TypeFlag StructTypeFlag;

typedef TypeFlag UnionTypeFlag;

typedef TypeFlag CollectionTypeFlag;

typedef TypeFlag AnnotationTypeFlag;

typedef TypeFlag AliasTypeFlag;

typedef TypeFlag EnumTypeFlag;

typedef TypeFlag BitmaskTypeFlag;

typedef TypeFlag BitsetTypeFlag;

const uint16_t TypeFlagMinimalMask = 0x0007;
class TypeIdentifier;

/*!
 * @brief This class represents the structure StringSTypeDefn defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class StringSTypeDefn
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StringSTypeDefn()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StringSTypeDefn()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StringSTypeDefn that will be copied.
     */
    eProsima_user_DllExport StringSTypeDefn(
            const StringSTypeDefn& x)
    {
                    m_bound = x.m_bound;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StringSTypeDefn that will be copied.
     */
    eProsima_user_DllExport StringSTypeDefn(
            StringSTypeDefn&& x) noexcept
    {
        m_bound = x.m_bound;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StringSTypeDefn that will be copied.
     */
    eProsima_user_DllExport StringSTypeDefn& operator =(
            const StringSTypeDefn& x)
    {

                    m_bound = x.m_bound;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StringSTypeDefn that will be copied.
     */
    eProsima_user_DllExport StringSTypeDefn& operator =(
            StringSTypeDefn&& x) noexcept
    {

        m_bound = x.m_bound;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StringSTypeDefn object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StringSTypeDefn& x) const
    {
        return (m_bound == x.m_bound);
    }

    /*!
     * @brief Comparison operator.
     * @param x StringSTypeDefn object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StringSTypeDefn& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member bound
     * @param _bound New value for member bound
     */
    eProsima_user_DllExport void bound(
            SBound _bound)
    {
        m_bound = _bound;
    }

    /*!
     * @brief This function returns the value of member bound
     * @return Value of member bound
     */
    eProsima_user_DllExport SBound bound() const
    {
        return m_bound;
    }

    /*!
     * @brief This function returns a reference to member bound
     * @return Reference to member bound
     */
    eProsima_user_DllExport SBound& bound()
    {
        return m_bound;
    }



private:

    SBound m_bound{0};

};
/*!
 * @brief This class represents the structure StringLTypeDefn defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class StringLTypeDefn
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StringLTypeDefn()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StringLTypeDefn()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StringLTypeDefn that will be copied.
     */
    eProsima_user_DllExport StringLTypeDefn(
            const StringLTypeDefn& x)
    {
                    m_bound = x.m_bound;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StringLTypeDefn that will be copied.
     */
    eProsima_user_DllExport StringLTypeDefn(
            StringLTypeDefn&& x) noexcept
    {
        m_bound = x.m_bound;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StringLTypeDefn that will be copied.
     */
    eProsima_user_DllExport StringLTypeDefn& operator =(
            const StringLTypeDefn& x)
    {

                    m_bound = x.m_bound;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StringLTypeDefn that will be copied.
     */
    eProsima_user_DllExport StringLTypeDefn& operator =(
            StringLTypeDefn&& x) noexcept
    {

        m_bound = x.m_bound;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StringLTypeDefn object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StringLTypeDefn& x) const
    {
        return (m_bound == x.m_bound);
    }

    /*!
     * @brief Comparison operator.
     * @param x StringLTypeDefn object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StringLTypeDefn& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member bound
     * @param _bound New value for member bound
     */
    eProsima_user_DllExport void bound(
            LBound _bound)
    {
        m_bound = _bound;
    }

    /*!
     * @brief This function returns the value of member bound
     * @return Value of member bound
     */
    eProsima_user_DllExport LBound bound() const
    {
        return m_bound;
    }

    /*!
     * @brief This function returns a reference to member bound
     * @return Reference to member bound
     */
    eProsima_user_DllExport LBound& bound()
    {
        return m_bound;
    }



private:

    LBound m_bound{0};

};
/*!
 * @brief This class represents the structure PlainCollectionHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class PlainCollectionHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport PlainCollectionHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~PlainCollectionHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object PlainCollectionHeader that will be copied.
     */
    eProsima_user_DllExport PlainCollectionHeader(
            const PlainCollectionHeader& x)
    {
                    m_equiv_kind = x.m_equiv_kind;

                    m_element_flags = x.m_element_flags;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object PlainCollectionHeader that will be copied.
     */
    eProsima_user_DllExport PlainCollectionHeader(
            PlainCollectionHeader&& x) noexcept
    {
        m_equiv_kind = x.m_equiv_kind;
        m_element_flags = std::move(x.m_element_flags);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object PlainCollectionHeader that will be copied.
     */
    eProsima_user_DllExport PlainCollectionHeader& operator =(
            const PlainCollectionHeader& x)
    {

                    m_equiv_kind = x.m_equiv_kind;

                    m_element_flags = x.m_element_flags;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object PlainCollectionHeader that will be copied.
     */
    eProsima_user_DllExport PlainCollectionHeader& operator =(
            PlainCollectionHeader&& x) noexcept
    {

        m_equiv_kind = x.m_equiv_kind;
        m_element_flags = std::move(x.m_element_flags);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x PlainCollectionHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const PlainCollectionHeader& x) const
    {
        return (m_equiv_kind == x.m_equiv_kind &&
           m_element_flags == x.m_element_flags);
    }

    /*!
     * @brief Comparison operator.
     * @param x PlainCollectionHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const PlainCollectionHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member equiv_kind
     * @param _equiv_kind New value for member equiv_kind
     */
    eProsima_user_DllExport void equiv_kind(
            EquivalenceKind _equiv_kind)
    {
        m_equiv_kind = _equiv_kind;
    }

    /*!
     * @brief This function returns the value of member equiv_kind
     * @return Value of member equiv_kind
     */
    eProsima_user_DllExport EquivalenceKind equiv_kind() const
    {
        return m_equiv_kind;
    }

    /*!
     * @brief This function returns a reference to member equiv_kind
     * @return Reference to member equiv_kind
     */
    eProsima_user_DllExport EquivalenceKind& equiv_kind()
    {
        return m_equiv_kind;
    }


    /*!
     * @brief This function copies the value in member element_flags
     * @param _element_flags New value to be copied in member element_flags
     */
    eProsima_user_DllExport void element_flags(
            const CollectionElementFlag& _element_flags)
    {
        m_element_flags = _element_flags;
    }

    /*!
     * @brief This function moves the value in member element_flags
     * @param _element_flags New value to be moved in member element_flags
     */
    eProsima_user_DllExport void element_flags(
            CollectionElementFlag&& _element_flags)
    {
        m_element_flags = std::move(_element_flags);
    }

    /*!
     * @brief This function returns a constant reference to member element_flags
     * @return Constant reference to member element_flags
     */
    eProsima_user_DllExport const CollectionElementFlag& element_flags() const
    {
        return m_element_flags;
    }

    /*!
     * @brief This function returns a reference to member element_flags
     * @return Reference to member element_flags
     */
    eProsima_user_DllExport CollectionElementFlag& element_flags()
    {
        return m_element_flags;
    }



private:

    EquivalenceKind m_equiv_kind{0};
    CollectionElementFlag m_element_flags{0};

};
/*!
 * @brief This class represents the structure PlainSequenceSElemDefn defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class PlainSequenceSElemDefn
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport PlainSequenceSElemDefn()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~PlainSequenceSElemDefn()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object PlainSequenceSElemDefn that will be copied.
     */
    eProsima_user_DllExport PlainSequenceSElemDefn(
            const PlainSequenceSElemDefn& x)
    {
                    m_header = x.m_header;

                    m_bound = x.m_bound;

                    m_element_identifier = x.m_element_identifier;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object PlainSequenceSElemDefn that will be copied.
     */
    eProsima_user_DllExport PlainSequenceSElemDefn(
            PlainSequenceSElemDefn&& x) noexcept
    {
        m_header = std::move(x.m_header);
        m_bound = x.m_bound;
        m_element_identifier = std::move(x.m_element_identifier);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object PlainSequenceSElemDefn that will be copied.
     */
    eProsima_user_DllExport PlainSequenceSElemDefn& operator =(
            const PlainSequenceSElemDefn& x)
    {

                    m_header = x.m_header;

                    m_bound = x.m_bound;

                    m_element_identifier = x.m_element_identifier;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object PlainSequenceSElemDefn that will be copied.
     */
    eProsima_user_DllExport PlainSequenceSElemDefn& operator =(
            PlainSequenceSElemDefn&& x) noexcept
    {

        m_header = std::move(x.m_header);
        m_bound = x.m_bound;
        m_element_identifier = std::move(x.m_element_identifier);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x PlainSequenceSElemDefn object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const PlainSequenceSElemDefn& x) const
    {
        return (m_header == x.m_header &&
           m_bound == x.m_bound &&
           m_element_identifier == x.m_element_identifier);
    }

    /*!
     * @brief Comparison operator.
     * @param x PlainSequenceSElemDefn object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const PlainSequenceSElemDefn& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const PlainCollectionHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            PlainCollectionHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const PlainCollectionHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport PlainCollectionHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function sets a value in member bound
     * @param _bound New value for member bound
     */
    eProsima_user_DllExport void bound(
            SBound _bound)
    {
        m_bound = _bound;
    }

    /*!
     * @brief This function returns the value of member bound
     * @return Value of member bound
     */
    eProsima_user_DllExport SBound bound() const
    {
        return m_bound;
    }

    /*!
     * @brief This function returns a reference to member bound
     * @return Reference to member bound
     */
    eProsima_user_DllExport SBound& bound()
    {
        return m_bound;
    }


    /*!
     * @brief This function copies the value in member element_identifier
     * @param _element_identifier New value to be copied in member element_identifier
     */
    eProsima_user_DllExport void element_identifier(
            const eprosima::fastcdr::external<TypeIdentifier>& _element_identifier)
    {
        m_element_identifier = _element_identifier;
    }

    /*!
     * @brief This function moves the value in member element_identifier
     * @param _element_identifier New value to be moved in member element_identifier
     */
    eProsima_user_DllExport void element_identifier(
            eprosima::fastcdr::external<TypeIdentifier>&& _element_identifier)
    {
        m_element_identifier = std::move(_element_identifier);
    }

    /*!
     * @brief This function returns a constant reference to member element_identifier
     * @return Constant reference to member element_identifier
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<TypeIdentifier>& element_identifier() const
    {
        return m_element_identifier;
    }

    /*!
     * @brief This function returns a reference to member element_identifier
     * @return Reference to member element_identifier
     */
    eProsima_user_DllExport eprosima::fastcdr::external<TypeIdentifier>& element_identifier()
    {
        return m_element_identifier;
    }



private:

    PlainCollectionHeader m_header;
    SBound m_bound{0};
    eprosima::fastcdr::external<TypeIdentifier> m_element_identifier;

};
/*!
 * @brief This class represents the structure PlainSequenceLElemDefn defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class PlainSequenceLElemDefn
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport PlainSequenceLElemDefn()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~PlainSequenceLElemDefn()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object PlainSequenceLElemDefn that will be copied.
     */
    eProsima_user_DllExport PlainSequenceLElemDefn(
            const PlainSequenceLElemDefn& x)
    {
                    m_header = x.m_header;

                    m_bound = x.m_bound;

                    m_element_identifier = x.m_element_identifier;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object PlainSequenceLElemDefn that will be copied.
     */
    eProsima_user_DllExport PlainSequenceLElemDefn(
            PlainSequenceLElemDefn&& x) noexcept
    {
        m_header = std::move(x.m_header);
        m_bound = x.m_bound;
        m_element_identifier = std::move(x.m_element_identifier);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object PlainSequenceLElemDefn that will be copied.
     */
    eProsima_user_DllExport PlainSequenceLElemDefn& operator =(
            const PlainSequenceLElemDefn& x)
    {

                    m_header = x.m_header;

                    m_bound = x.m_bound;

                    m_element_identifier = x.m_element_identifier;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object PlainSequenceLElemDefn that will be copied.
     */
    eProsima_user_DllExport PlainSequenceLElemDefn& operator =(
            PlainSequenceLElemDefn&& x) noexcept
    {

        m_header = std::move(x.m_header);
        m_bound = x.m_bound;
        m_element_identifier = std::move(x.m_element_identifier);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x PlainSequenceLElemDefn object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const PlainSequenceLElemDefn& x) const
    {
        return (m_header == x.m_header &&
           m_bound == x.m_bound &&
           m_element_identifier == x.m_element_identifier);
    }

    /*!
     * @brief Comparison operator.
     * @param x PlainSequenceLElemDefn object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const PlainSequenceLElemDefn& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const PlainCollectionHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            PlainCollectionHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const PlainCollectionHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport PlainCollectionHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function sets a value in member bound
     * @param _bound New value for member bound
     */
    eProsima_user_DllExport void bound(
            LBound _bound)
    {
        m_bound = _bound;
    }

    /*!
     * @brief This function returns the value of member bound
     * @return Value of member bound
     */
    eProsima_user_DllExport LBound bound() const
    {
        return m_bound;
    }

    /*!
     * @brief This function returns a reference to member bound
     * @return Reference to member bound
     */
    eProsima_user_DllExport LBound& bound()
    {
        return m_bound;
    }


    /*!
     * @brief This function copies the value in member element_identifier
     * @param _element_identifier New value to be copied in member element_identifier
     */
    eProsima_user_DllExport void element_identifier(
            const eprosima::fastcdr::external<TypeIdentifier>& _element_identifier)
    {
        m_element_identifier = _element_identifier;
    }

    /*!
     * @brief This function moves the value in member element_identifier
     * @param _element_identifier New value to be moved in member element_identifier
     */
    eProsima_user_DllExport void element_identifier(
            eprosima::fastcdr::external<TypeIdentifier>&& _element_identifier)
    {
        m_element_identifier = std::move(_element_identifier);
    }

    /*!
     * @brief This function returns a constant reference to member element_identifier
     * @return Constant reference to member element_identifier
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<TypeIdentifier>& element_identifier() const
    {
        return m_element_identifier;
    }

    /*!
     * @brief This function returns a reference to member element_identifier
     * @return Reference to member element_identifier
     */
    eProsima_user_DllExport eprosima::fastcdr::external<TypeIdentifier>& element_identifier()
    {
        return m_element_identifier;
    }



private:

    PlainCollectionHeader m_header;
    LBound m_bound{0};
    eprosima::fastcdr::external<TypeIdentifier> m_element_identifier;

};
/*!
 * @brief This class represents the structure PlainArraySElemDefn defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class PlainArraySElemDefn
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport PlainArraySElemDefn()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~PlainArraySElemDefn()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object PlainArraySElemDefn that will be copied.
     */
    eProsima_user_DllExport PlainArraySElemDefn(
            const PlainArraySElemDefn& x)
    {
                    m_header = x.m_header;

                    m_array_bound_seq = x.m_array_bound_seq;

                    m_element_identifier = x.m_element_identifier;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object PlainArraySElemDefn that will be copied.
     */
    eProsima_user_DllExport PlainArraySElemDefn(
            PlainArraySElemDefn&& x) noexcept
    {
        m_header = std::move(x.m_header);
        m_array_bound_seq = std::move(x.m_array_bound_seq);
        m_element_identifier = std::move(x.m_element_identifier);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object PlainArraySElemDefn that will be copied.
     */
    eProsima_user_DllExport PlainArraySElemDefn& operator =(
            const PlainArraySElemDefn& x)
    {

                    m_header = x.m_header;

                    m_array_bound_seq = x.m_array_bound_seq;

                    m_element_identifier = x.m_element_identifier;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object PlainArraySElemDefn that will be copied.
     */
    eProsima_user_DllExport PlainArraySElemDefn& operator =(
            PlainArraySElemDefn&& x) noexcept
    {

        m_header = std::move(x.m_header);
        m_array_bound_seq = std::move(x.m_array_bound_seq);
        m_element_identifier = std::move(x.m_element_identifier);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x PlainArraySElemDefn object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const PlainArraySElemDefn& x) const
    {
        return (m_header == x.m_header &&
           m_array_bound_seq == x.m_array_bound_seq &&
           m_element_identifier == x.m_element_identifier);
    }

    /*!
     * @brief Comparison operator.
     * @param x PlainArraySElemDefn object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const PlainArraySElemDefn& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const PlainCollectionHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            PlainCollectionHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const PlainCollectionHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport PlainCollectionHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member array_bound_seq
     * @param _array_bound_seq New value to be copied in member array_bound_seq
     */
    eProsima_user_DllExport void array_bound_seq(
            const SBoundSeq& _array_bound_seq)
    {
        m_array_bound_seq = _array_bound_seq;
    }

    /*!
     * @brief This function moves the value in member array_bound_seq
     * @param _array_bound_seq New value to be moved in member array_bound_seq
     */
    eProsima_user_DllExport void array_bound_seq(
            SBoundSeq&& _array_bound_seq)
    {
        m_array_bound_seq = std::move(_array_bound_seq);
    }

    /*!
     * @brief This function returns a constant reference to member array_bound_seq
     * @return Constant reference to member array_bound_seq
     */
    eProsima_user_DllExport const SBoundSeq& array_bound_seq() const
    {
        return m_array_bound_seq;
    }

    /*!
     * @brief This function returns a reference to member array_bound_seq
     * @return Reference to member array_bound_seq
     */
    eProsima_user_DllExport SBoundSeq& array_bound_seq()
    {
        return m_array_bound_seq;
    }


    /*!
     * @brief This function copies the value in member element_identifier
     * @param _element_identifier New value to be copied in member element_identifier
     */
    eProsima_user_DllExport void element_identifier(
            const eprosima::fastcdr::external<TypeIdentifier>& _element_identifier)
    {
        m_element_identifier = _element_identifier;
    }

    /*!
     * @brief This function moves the value in member element_identifier
     * @param _element_identifier New value to be moved in member element_identifier
     */
    eProsima_user_DllExport void element_identifier(
            eprosima::fastcdr::external<TypeIdentifier>&& _element_identifier)
    {
        m_element_identifier = std::move(_element_identifier);
    }

    /*!
     * @brief This function returns a constant reference to member element_identifier
     * @return Constant reference to member element_identifier
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<TypeIdentifier>& element_identifier() const
    {
        return m_element_identifier;
    }

    /*!
     * @brief This function returns a reference to member element_identifier
     * @return Reference to member element_identifier
     */
    eProsima_user_DllExport eprosima::fastcdr::external<TypeIdentifier>& element_identifier()
    {
        return m_element_identifier;
    }



private:

    PlainCollectionHeader m_header;
    SBoundSeq m_array_bound_seq;
    eprosima::fastcdr::external<TypeIdentifier> m_element_identifier;

};
/*!
 * @brief This class represents the structure PlainArrayLElemDefn defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class PlainArrayLElemDefn
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport PlainArrayLElemDefn()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~PlainArrayLElemDefn()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object PlainArrayLElemDefn that will be copied.
     */
    eProsima_user_DllExport PlainArrayLElemDefn(
            const PlainArrayLElemDefn& x)
    {
                    m_header = x.m_header;

                    m_array_bound_seq = x.m_array_bound_seq;

                    m_element_identifier = x.m_element_identifier;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object PlainArrayLElemDefn that will be copied.
     */
    eProsima_user_DllExport PlainArrayLElemDefn(
            PlainArrayLElemDefn&& x) noexcept
    {
        m_header = std::move(x.m_header);
        m_array_bound_seq = std::move(x.m_array_bound_seq);
        m_element_identifier = std::move(x.m_element_identifier);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object PlainArrayLElemDefn that will be copied.
     */
    eProsima_user_DllExport PlainArrayLElemDefn& operator =(
            const PlainArrayLElemDefn& x)
    {

                    m_header = x.m_header;

                    m_array_bound_seq = x.m_array_bound_seq;

                    m_element_identifier = x.m_element_identifier;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object PlainArrayLElemDefn that will be copied.
     */
    eProsima_user_DllExport PlainArrayLElemDefn& operator =(
            PlainArrayLElemDefn&& x) noexcept
    {

        m_header = std::move(x.m_header);
        m_array_bound_seq = std::move(x.m_array_bound_seq);
        m_element_identifier = std::move(x.m_element_identifier);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x PlainArrayLElemDefn object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const PlainArrayLElemDefn& x) const
    {
        return (m_header == x.m_header &&
           m_array_bound_seq == x.m_array_bound_seq &&
           m_element_identifier == x.m_element_identifier);
    }

    /*!
     * @brief Comparison operator.
     * @param x PlainArrayLElemDefn object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const PlainArrayLElemDefn& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const PlainCollectionHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            PlainCollectionHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const PlainCollectionHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport PlainCollectionHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member array_bound_seq
     * @param _array_bound_seq New value to be copied in member array_bound_seq
     */
    eProsima_user_DllExport void array_bound_seq(
            const LBoundSeq& _array_bound_seq)
    {
        m_array_bound_seq = _array_bound_seq;
    }

    /*!
     * @brief This function moves the value in member array_bound_seq
     * @param _array_bound_seq New value to be moved in member array_bound_seq
     */
    eProsima_user_DllExport void array_bound_seq(
            LBoundSeq&& _array_bound_seq)
    {
        m_array_bound_seq = std::move(_array_bound_seq);
    }

    /*!
     * @brief This function returns a constant reference to member array_bound_seq
     * @return Constant reference to member array_bound_seq
     */
    eProsima_user_DllExport const LBoundSeq& array_bound_seq() const
    {
        return m_array_bound_seq;
    }

    /*!
     * @brief This function returns a reference to member array_bound_seq
     * @return Reference to member array_bound_seq
     */
    eProsima_user_DllExport LBoundSeq& array_bound_seq()
    {
        return m_array_bound_seq;
    }


    /*!
     * @brief This function copies the value in member element_identifier
     * @param _element_identifier New value to be copied in member element_identifier
     */
    eProsima_user_DllExport void element_identifier(
            const eprosima::fastcdr::external<TypeIdentifier>& _element_identifier)
    {
        m_element_identifier = _element_identifier;
    }

    /*!
     * @brief This function moves the value in member element_identifier
     * @param _element_identifier New value to be moved in member element_identifier
     */
    eProsima_user_DllExport void element_identifier(
            eprosima::fastcdr::external<TypeIdentifier>&& _element_identifier)
    {
        m_element_identifier = std::move(_element_identifier);
    }

    /*!
     * @brief This function returns a constant reference to member element_identifier
     * @return Constant reference to member element_identifier
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<TypeIdentifier>& element_identifier() const
    {
        return m_element_identifier;
    }

    /*!
     * @brief This function returns a reference to member element_identifier
     * @return Reference to member element_identifier
     */
    eProsima_user_DllExport eprosima::fastcdr::external<TypeIdentifier>& element_identifier()
    {
        return m_element_identifier;
    }



private:

    PlainCollectionHeader m_header;
    LBoundSeq m_array_bound_seq;
    eprosima::fastcdr::external<TypeIdentifier> m_element_identifier;

};
/*!
 * @brief This class represents the structure PlainMapSTypeDefn defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class PlainMapSTypeDefn
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport PlainMapSTypeDefn()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~PlainMapSTypeDefn()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object PlainMapSTypeDefn that will be copied.
     */
    eProsima_user_DllExport PlainMapSTypeDefn(
            const PlainMapSTypeDefn& x)
    {
                    m_header = x.m_header;

                    m_bound = x.m_bound;

                    m_element_identifier = x.m_element_identifier;

                    m_key_flags = x.m_key_flags;

                    m_key_identifier = x.m_key_identifier;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object PlainMapSTypeDefn that will be copied.
     */
    eProsima_user_DllExport PlainMapSTypeDefn(
            PlainMapSTypeDefn&& x) noexcept
    {
        m_header = std::move(x.m_header);
        m_bound = x.m_bound;
        m_element_identifier = std::move(x.m_element_identifier);
        m_key_flags = std::move(x.m_key_flags);
        m_key_identifier = std::move(x.m_key_identifier);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object PlainMapSTypeDefn that will be copied.
     */
    eProsima_user_DllExport PlainMapSTypeDefn& operator =(
            const PlainMapSTypeDefn& x)
    {

                    m_header = x.m_header;

                    m_bound = x.m_bound;

                    m_element_identifier = x.m_element_identifier;

                    m_key_flags = x.m_key_flags;

                    m_key_identifier = x.m_key_identifier;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object PlainMapSTypeDefn that will be copied.
     */
    eProsima_user_DllExport PlainMapSTypeDefn& operator =(
            PlainMapSTypeDefn&& x) noexcept
    {

        m_header = std::move(x.m_header);
        m_bound = x.m_bound;
        m_element_identifier = std::move(x.m_element_identifier);
        m_key_flags = std::move(x.m_key_flags);
        m_key_identifier = std::move(x.m_key_identifier);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x PlainMapSTypeDefn object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const PlainMapSTypeDefn& x) const
    {
        return (m_header == x.m_header &&
           m_bound == x.m_bound &&
           m_element_identifier == x.m_element_identifier &&
           m_key_flags == x.m_key_flags &&
           m_key_identifier == x.m_key_identifier);
    }

    /*!
     * @brief Comparison operator.
     * @param x PlainMapSTypeDefn object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const PlainMapSTypeDefn& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const PlainCollectionHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            PlainCollectionHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const PlainCollectionHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport PlainCollectionHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function sets a value in member bound
     * @param _bound New value for member bound
     */
    eProsima_user_DllExport void bound(
            SBound _bound)
    {
        m_bound = _bound;
    }

    /*!
     * @brief This function returns the value of member bound
     * @return Value of member bound
     */
    eProsima_user_DllExport SBound bound() const
    {
        return m_bound;
    }

    /*!
     * @brief This function returns a reference to member bound
     * @return Reference to member bound
     */
    eProsima_user_DllExport SBound& bound()
    {
        return m_bound;
    }


    /*!
     * @brief This function copies the value in member element_identifier
     * @param _element_identifier New value to be copied in member element_identifier
     */
    eProsima_user_DllExport void element_identifier(
            const eprosima::fastcdr::external<TypeIdentifier>& _element_identifier)
    {
        m_element_identifier = _element_identifier;
    }

    /*!
     * @brief This function moves the value in member element_identifier
     * @param _element_identifier New value to be moved in member element_identifier
     */
    eProsima_user_DllExport void element_identifier(
            eprosima::fastcdr::external<TypeIdentifier>&& _element_identifier)
    {
        m_element_identifier = std::move(_element_identifier);
    }

    /*!
     * @brief This function returns a constant reference to member element_identifier
     * @return Constant reference to member element_identifier
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<TypeIdentifier>& element_identifier() const
    {
        return m_element_identifier;
    }

    /*!
     * @brief This function returns a reference to member element_identifier
     * @return Reference to member element_identifier
     */
    eProsima_user_DllExport eprosima::fastcdr::external<TypeIdentifier>& element_identifier()
    {
        return m_element_identifier;
    }


    /*!
     * @brief This function copies the value in member key_flags
     * @param _key_flags New value to be copied in member key_flags
     */
    eProsima_user_DllExport void key_flags(
            const CollectionElementFlag& _key_flags)
    {
        m_key_flags = _key_flags;
    }

    /*!
     * @brief This function moves the value in member key_flags
     * @param _key_flags New value to be moved in member key_flags
     */
    eProsima_user_DllExport void key_flags(
            CollectionElementFlag&& _key_flags)
    {
        m_key_flags = std::move(_key_flags);
    }

    /*!
     * @brief This function returns a constant reference to member key_flags
     * @return Constant reference to member key_flags
     */
    eProsima_user_DllExport const CollectionElementFlag& key_flags() const
    {
        return m_key_flags;
    }

    /*!
     * @brief This function returns a reference to member key_flags
     * @return Reference to member key_flags
     */
    eProsima_user_DllExport CollectionElementFlag& key_flags()
    {
        return m_key_flags;
    }


    /*!
     * @brief This function copies the value in member key_identifier
     * @param _key_identifier New value to be copied in member key_identifier
     */
    eProsima_user_DllExport void key_identifier(
            const eprosima::fastcdr::external<TypeIdentifier>& _key_identifier)
    {
        m_key_identifier = _key_identifier;
    }

    /*!
     * @brief This function moves the value in member key_identifier
     * @param _key_identifier New value to be moved in member key_identifier
     */
    eProsima_user_DllExport void key_identifier(
            eprosima::fastcdr::external<TypeIdentifier>&& _key_identifier)
    {
        m_key_identifier = std::move(_key_identifier);
    }

    /*!
     * @brief This function returns a constant reference to member key_identifier
     * @return Constant reference to member key_identifier
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<TypeIdentifier>& key_identifier() const
    {
        return m_key_identifier;
    }

    /*!
     * @brief This function returns a reference to member key_identifier
     * @return Reference to member key_identifier
     */
    eProsima_user_DllExport eprosima::fastcdr::external<TypeIdentifier>& key_identifier()
    {
        return m_key_identifier;
    }



private:

    PlainCollectionHeader m_header;
    SBound m_bound{0};
    eprosima::fastcdr::external<TypeIdentifier> m_element_identifier;
    CollectionElementFlag m_key_flags{0};
    eprosima::fastcdr::external<TypeIdentifier> m_key_identifier;

};
/*!
 * @brief This class represents the structure PlainMapLTypeDefn defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class PlainMapLTypeDefn
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport PlainMapLTypeDefn()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~PlainMapLTypeDefn()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object PlainMapLTypeDefn that will be copied.
     */
    eProsima_user_DllExport PlainMapLTypeDefn(
            const PlainMapLTypeDefn& x)
    {
                    m_header = x.m_header;

                    m_bound = x.m_bound;

                    m_element_identifier = x.m_element_identifier;

                    m_key_flags = x.m_key_flags;

                    m_key_identifier = x.m_key_identifier;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object PlainMapLTypeDefn that will be copied.
     */
    eProsima_user_DllExport PlainMapLTypeDefn(
            PlainMapLTypeDefn&& x) noexcept
    {
        m_header = std::move(x.m_header);
        m_bound = x.m_bound;
        m_element_identifier = std::move(x.m_element_identifier);
        m_key_flags = std::move(x.m_key_flags);
        m_key_identifier = std::move(x.m_key_identifier);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object PlainMapLTypeDefn that will be copied.
     */
    eProsima_user_DllExport PlainMapLTypeDefn& operator =(
            const PlainMapLTypeDefn& x)
    {

                    m_header = x.m_header;

                    m_bound = x.m_bound;

                    m_element_identifier = x.m_element_identifier;

                    m_key_flags = x.m_key_flags;

                    m_key_identifier = x.m_key_identifier;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object PlainMapLTypeDefn that will be copied.
     */
    eProsima_user_DllExport PlainMapLTypeDefn& operator =(
            PlainMapLTypeDefn&& x) noexcept
    {

        m_header = std::move(x.m_header);
        m_bound = x.m_bound;
        m_element_identifier = std::move(x.m_element_identifier);
        m_key_flags = std::move(x.m_key_flags);
        m_key_identifier = std::move(x.m_key_identifier);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x PlainMapLTypeDefn object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const PlainMapLTypeDefn& x) const
    {
        return (m_header == x.m_header &&
           m_bound == x.m_bound &&
           m_element_identifier == x.m_element_identifier &&
           m_key_flags == x.m_key_flags &&
           m_key_identifier == x.m_key_identifier);
    }

    /*!
     * @brief Comparison operator.
     * @param x PlainMapLTypeDefn object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const PlainMapLTypeDefn& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const PlainCollectionHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            PlainCollectionHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const PlainCollectionHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport PlainCollectionHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function sets a value in member bound
     * @param _bound New value for member bound
     */
    eProsima_user_DllExport void bound(
            LBound _bound)
    {
        m_bound = _bound;
    }

    /*!
     * @brief This function returns the value of member bound
     * @return Value of member bound
     */
    eProsima_user_DllExport LBound bound() const
    {
        return m_bound;
    }

    /*!
     * @brief This function returns a reference to member bound
     * @return Reference to member bound
     */
    eProsima_user_DllExport LBound& bound()
    {
        return m_bound;
    }


    /*!
     * @brief This function copies the value in member element_identifier
     * @param _element_identifier New value to be copied in member element_identifier
     */
    eProsima_user_DllExport void element_identifier(
            const eprosima::fastcdr::external<TypeIdentifier>& _element_identifier)
    {
        m_element_identifier = _element_identifier;
    }

    /*!
     * @brief This function moves the value in member element_identifier
     * @param _element_identifier New value to be moved in member element_identifier
     */
    eProsima_user_DllExport void element_identifier(
            eprosima::fastcdr::external<TypeIdentifier>&& _element_identifier)
    {
        m_element_identifier = std::move(_element_identifier);
    }

    /*!
     * @brief This function returns a constant reference to member element_identifier
     * @return Constant reference to member element_identifier
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<TypeIdentifier>& element_identifier() const
    {
        return m_element_identifier;
    }

    /*!
     * @brief This function returns a reference to member element_identifier
     * @return Reference to member element_identifier
     */
    eProsima_user_DllExport eprosima::fastcdr::external<TypeIdentifier>& element_identifier()
    {
        return m_element_identifier;
    }


    /*!
     * @brief This function copies the value in member key_flags
     * @param _key_flags New value to be copied in member key_flags
     */
    eProsima_user_DllExport void key_flags(
            const CollectionElementFlag& _key_flags)
    {
        m_key_flags = _key_flags;
    }

    /*!
     * @brief This function moves the value in member key_flags
     * @param _key_flags New value to be moved in member key_flags
     */
    eProsima_user_DllExport void key_flags(
            CollectionElementFlag&& _key_flags)
    {
        m_key_flags = std::move(_key_flags);
    }

    /*!
     * @brief This function returns a constant reference to member key_flags
     * @return Constant reference to member key_flags
     */
    eProsima_user_DllExport const CollectionElementFlag& key_flags() const
    {
        return m_key_flags;
    }

    /*!
     * @brief This function returns a reference to member key_flags
     * @return Reference to member key_flags
     */
    eProsima_user_DllExport CollectionElementFlag& key_flags()
    {
        return m_key_flags;
    }


    /*!
     * @brief This function copies the value in member key_identifier
     * @param _key_identifier New value to be copied in member key_identifier
     */
    eProsima_user_DllExport void key_identifier(
            const eprosima::fastcdr::external<TypeIdentifier>& _key_identifier)
    {
        m_key_identifier = _key_identifier;
    }

    /*!
     * @brief This function moves the value in member key_identifier
     * @param _key_identifier New value to be moved in member key_identifier
     */
    eProsima_user_DllExport void key_identifier(
            eprosima::fastcdr::external<TypeIdentifier>&& _key_identifier)
    {
        m_key_identifier = std::move(_key_identifier);
    }

    /*!
     * @brief This function returns a constant reference to member key_identifier
     * @return Constant reference to member key_identifier
     */
    eProsima_user_DllExport const eprosima::fastcdr::external<TypeIdentifier>& key_identifier() const
    {
        return m_key_identifier;
    }

    /*!
     * @brief This function returns a reference to member key_identifier
     * @return Reference to member key_identifier
     */
    eProsima_user_DllExport eprosima::fastcdr::external<TypeIdentifier>& key_identifier()
    {
        return m_key_identifier;
    }



private:

    PlainCollectionHeader m_header;
    LBound m_bound{0};
    eprosima::fastcdr::external<TypeIdentifier> m_element_identifier;
    CollectionElementFlag m_key_flags{0};
    eprosima::fastcdr::external<TypeIdentifier> m_key_identifier;

};
/*!
 * @brief This class represents the structure StronglyConnectedComponentId defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class StronglyConnectedComponentId
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StronglyConnectedComponentId()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StronglyConnectedComponentId()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StronglyConnectedComponentId that will be copied.
     */
    eProsima_user_DllExport StronglyConnectedComponentId(
            const StronglyConnectedComponentId& x)
    {
                    m_sc_component_id = x.m_sc_component_id;

                    m_scc_length = x.m_scc_length;

                    m_scc_index = x.m_scc_index;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StronglyConnectedComponentId that will be copied.
     */
    eProsima_user_DllExport StronglyConnectedComponentId(
            StronglyConnectedComponentId&& x) noexcept
    {
        m_sc_component_id = std::move(x.m_sc_component_id);
        m_scc_length = x.m_scc_length;
        m_scc_index = x.m_scc_index;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StronglyConnectedComponentId that will be copied.
     */
    eProsima_user_DllExport StronglyConnectedComponentId& operator =(
            const StronglyConnectedComponentId& x)
    {

                    m_sc_component_id = x.m_sc_component_id;

                    m_scc_length = x.m_scc_length;

                    m_scc_index = x.m_scc_index;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StronglyConnectedComponentId that will be copied.
     */
    eProsima_user_DllExport StronglyConnectedComponentId& operator =(
            StronglyConnectedComponentId&& x) noexcept
    {

        m_sc_component_id = std::move(x.m_sc_component_id);
        m_scc_length = x.m_scc_length;
        m_scc_index = x.m_scc_index;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StronglyConnectedComponentId object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StronglyConnectedComponentId& x) const
    {
        return (m_sc_component_id == x.m_sc_component_id &&
           m_scc_length == x.m_scc_length &&
           m_scc_index == x.m_scc_index);
    }

    /*!
     * @brief Comparison operator.
     * @param x StronglyConnectedComponentId object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StronglyConnectedComponentId& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member sc_component_id
     * @param _sc_component_id New value to be copied in member sc_component_id
     */
    eProsima_user_DllExport void sc_component_id(
            const TypeObjectHashId& _sc_component_id)
    {
        m_sc_component_id = _sc_component_id;
    }

    /*!
     * @brief This function moves the value in member sc_component_id
     * @param _sc_component_id New value to be moved in member sc_component_id
     */
    eProsima_user_DllExport void sc_component_id(
            TypeObjectHashId&& _sc_component_id)
    {
        m_sc_component_id = std::move(_sc_component_id);
    }

    /*!
     * @brief This function returns a constant reference to member sc_component_id
     * @return Constant reference to member sc_component_id
     */
    eProsima_user_DllExport const TypeObjectHashId& sc_component_id() const
    {
        return m_sc_component_id;
    }

    /*!
     * @brief This function returns a reference to member sc_component_id
     * @return Reference to member sc_component_id
     */
    eProsima_user_DllExport TypeObjectHashId& sc_component_id()
    {
        return m_sc_component_id;
    }


    /*!
     * @brief This function sets a value in member scc_length
     * @param _scc_length New value for member scc_length
     */
    eProsima_user_DllExport void scc_length(
            int32_t _scc_length)
    {
        m_scc_length = _scc_length;
    }

    /*!
     * @brief This function returns the value of member scc_length
     * @return Value of member scc_length
     */
    eProsima_user_DllExport int32_t scc_length() const
    {
        return m_scc_length;
    }

    /*!
     * @brief This function returns a reference to member scc_length
     * @return Reference to member scc_length
     */
    eProsima_user_DllExport int32_t& scc_length()
    {
        return m_scc_length;
    }


    /*!
     * @brief This function sets a value in member scc_index
     * @param _scc_index New value for member scc_index
     */
    eProsima_user_DllExport void scc_index(
            int32_t _scc_index)
    {
        m_scc_index = _scc_index;
    }

    /*!
     * @brief This function returns the value of member scc_index
     * @return Value of member scc_index
     */
    eProsima_user_DllExport int32_t scc_index() const
    {
        return m_scc_index;
    }

    /*!
     * @brief This function returns a reference to member scc_index
     * @return Reference to member scc_index
     */
    eProsima_user_DllExport int32_t& scc_index()
    {
        return m_scc_index;
    }



private:

    TypeObjectHashId m_sc_component_id;
    int32_t m_scc_length{0};
    int32_t m_scc_index{0};

};
/*!
 * @brief This class represents the structure ExtendedTypeDefn defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class ExtendedTypeDefn
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ExtendedTypeDefn()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ExtendedTypeDefn()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ExtendedTypeDefn that will be copied.
     */
    eProsima_user_DllExport ExtendedTypeDefn(
            const ExtendedTypeDefn& x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ExtendedTypeDefn that will be copied.
     */
    eProsima_user_DllExport ExtendedTypeDefn(
            ExtendedTypeDefn&& x) noexcept
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ExtendedTypeDefn that will be copied.
     */
    eProsima_user_DllExport ExtendedTypeDefn& operator =(
            const ExtendedTypeDefn& x)
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ExtendedTypeDefn that will be copied.
     */
    eProsima_user_DllExport ExtendedTypeDefn& operator =(
            ExtendedTypeDefn&& x) noexcept
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ExtendedTypeDefn object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ExtendedTypeDefn& x) const
    {
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x ExtendedTypeDefn object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ExtendedTypeDefn& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the structure Dummy defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class Dummy
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Dummy()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Dummy()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Dummy that will be copied.
     */
    eProsima_user_DllExport Dummy(
            const Dummy& x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Dummy that will be copied.
     */
    eProsima_user_DllExport Dummy(
            Dummy&& x) noexcept
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Dummy that will be copied.
     */
    eProsima_user_DllExport Dummy& operator =(
            const Dummy& x)
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Dummy that will be copied.
     */
    eProsima_user_DllExport Dummy& operator =(
            Dummy&& x) noexcept
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Dummy object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Dummy& x) const
    {
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x Dummy object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Dummy& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the union TypeIdentifier defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class TypeIdentifier
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeIdentifier()
    {
        selected_member_ = 0x00000001;
        member_destructor_ = [&]()
        {
            m_no_value.~Dummy();
        };
        new(&m_no_value) Dummy();

    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeIdentifier()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeIdentifier that will be copied.
     */
    eProsima_user_DllExport TypeIdentifier(
            const TypeIdentifier& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            no_value_() = x.m_no_value;
                            break;

                        case 0x00000002:
                            string_sdefn_() = x.m_string_sdefn;
                            break;

                        case 0x00000003:
                            string_ldefn_() = x.m_string_ldefn;
                            break;

                        case 0x00000004:
                            seq_sdefn_() = x.m_seq_sdefn;
                            break;

                        case 0x00000005:
                            seq_ldefn_() = x.m_seq_ldefn;
                            break;

                        case 0x00000006:
                            array_sdefn_() = x.m_array_sdefn;
                            break;

                        case 0x00000007:
                            array_ldefn_() = x.m_array_ldefn;
                            break;

                        case 0x00000008:
                            map_sdefn_() = x.m_map_sdefn;
                            break;

                        case 0x00000009:
                            map_ldefn_() = x.m_map_ldefn;
                            break;

                        case 0x0000000a:
                            sc_component_id_() = x.m_sc_component_id;
                            break;

                        case 0x0000000b:
                            equivalence_hash_() = x.m_equivalence_hash;
                            break;

                        case 0x0000000c:
                            extended_defn_() = x.m_extended_defn;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeIdentifier that will be copied.
     */
    eProsima_user_DllExport TypeIdentifier(
            TypeIdentifier&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            no_value_() = std::move(x.m_no_value);
                            break;

                        case 0x00000002:
                            string_sdefn_() = std::move(x.m_string_sdefn);
                            break;

                        case 0x00000003:
                            string_ldefn_() = std::move(x.m_string_ldefn);
                            break;

                        case 0x00000004:
                            seq_sdefn_() = std::move(x.m_seq_sdefn);
                            break;

                        case 0x00000005:
                            seq_ldefn_() = std::move(x.m_seq_ldefn);
                            break;

                        case 0x00000006:
                            array_sdefn_() = std::move(x.m_array_sdefn);
                            break;

                        case 0x00000007:
                            array_ldefn_() = std::move(x.m_array_ldefn);
                            break;

                        case 0x00000008:
                            map_sdefn_() = std::move(x.m_map_sdefn);
                            break;

                        case 0x00000009:
                            map_ldefn_() = std::move(x.m_map_ldefn);
                            break;

                        case 0x0000000a:
                            sc_component_id_() = std::move(x.m_sc_component_id);
                            break;

                        case 0x0000000b:
                            equivalence_hash_() = std::move(x.m_equivalence_hash);
                            break;

                        case 0x0000000c:
                            extended_defn_() = std::move(x.m_extended_defn);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeIdentifier that will be copied.
     */
    eProsima_user_DllExport TypeIdentifier& operator =(
            const TypeIdentifier& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            no_value_() = x.m_no_value;
                            break;

                        case 0x00000002:
                            string_sdefn_() = x.m_string_sdefn;
                            break;

                        case 0x00000003:
                            string_ldefn_() = x.m_string_ldefn;
                            break;

                        case 0x00000004:
                            seq_sdefn_() = x.m_seq_sdefn;
                            break;

                        case 0x00000005:
                            seq_ldefn_() = x.m_seq_ldefn;
                            break;

                        case 0x00000006:
                            array_sdefn_() = x.m_array_sdefn;
                            break;

                        case 0x00000007:
                            array_ldefn_() = x.m_array_ldefn;
                            break;

                        case 0x00000008:
                            map_sdefn_() = x.m_map_sdefn;
                            break;

                        case 0x00000009:
                            map_ldefn_() = x.m_map_ldefn;
                            break;

                        case 0x0000000a:
                            sc_component_id_() = x.m_sc_component_id;
                            break;

                        case 0x0000000b:
                            equivalence_hash_() = x.m_equivalence_hash;
                            break;

                        case 0x0000000c:
                            extended_defn_() = x.m_extended_defn;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeIdentifier that will be copied.
     */
    eProsima_user_DllExport TypeIdentifier& operator =(
            TypeIdentifier&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            no_value_() = std::move(x.m_no_value);
                            break;

                        case 0x00000002:
                            string_sdefn_() = std::move(x.m_string_sdefn);
                            break;

                        case 0x00000003:
                            string_ldefn_() = std::move(x.m_string_ldefn);
                            break;

                        case 0x00000004:
                            seq_sdefn_() = std::move(x.m_seq_sdefn);
                            break;

                        case 0x00000005:
                            seq_ldefn_() = std::move(x.m_seq_ldefn);
                            break;

                        case 0x00000006:
                            array_sdefn_() = std::move(x.m_array_sdefn);
                            break;

                        case 0x00000007:
                            array_ldefn_() = std::move(x.m_array_ldefn);
                            break;

                        case 0x00000008:
                            map_sdefn_() = std::move(x.m_map_sdefn);
                            break;

                        case 0x00000009:
                            map_ldefn_() = std::move(x.m_map_ldefn);
                            break;

                        case 0x0000000a:
                            sc_component_id_() = std::move(x.m_sc_component_id);
                            break;

                        case 0x0000000b:
                            equivalence_hash_() = std::move(x.m_equivalence_hash);
                            break;

                        case 0x0000000c:
                            extended_defn_() = std::move(x.m_extended_defn);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeIdentifier object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeIdentifier& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_no_value == m_no_value);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_string_sdefn == m_string_sdefn);
                                                        break;

                                                    case 0x00000003:
                                                        ret_value = (x.m_string_ldefn == m_string_ldefn);
                                                        break;

                                                    case 0x00000004:
                                                        ret_value = (x.m_seq_sdefn == m_seq_sdefn);
                                                        break;

                                                    case 0x00000005:
                                                        ret_value = (x.m_seq_ldefn == m_seq_ldefn);
                                                        break;

                                                    case 0x00000006:
                                                        ret_value = (x.m_array_sdefn == m_array_sdefn);
                                                        break;

                                                    case 0x00000007:
                                                        ret_value = (x.m_array_ldefn == m_array_ldefn);
                                                        break;

                                                    case 0x00000008:
                                                        ret_value = (x.m_map_sdefn == m_map_sdefn);
                                                        break;

                                                    case 0x00000009:
                                                        ret_value = (x.m_map_ldefn == m_map_ldefn);
                                                        break;

                                                    case 0x0000000a:
                                                        ret_value = (x.m_sc_component_id == m_sc_component_id);
                                                        break;

                                                    case 0x0000000b:
                                                        ret_value = (x.m_equivalence_hash == m_equivalence_hash);
                                                        break;

                                                    case 0x0000000c:
                                                        ret_value = (x.m_extended_defn == m_extended_defn);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeIdentifier object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeIdentifier& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            uint8_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case TK_NONE:
                        case TK_BOOLEAN:
                        case TK_BYTE:
                        case TK_INT8:
                        case TK_INT16:
                        case TK_INT32:
                        case TK_INT64:
                        case TK_UINT8:
                        case TK_UINT16:
                        case TK_UINT32:
                        case TK_UINT64:
                        case TK_FLOAT32:
                        case TK_FLOAT64:
                        case TK_FLOAT128:
                        case TK_CHAR8:
                        case TK_CHAR16:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TI_STRING8_SMALL:
                        case TI_STRING16_SMALL:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TI_STRING8_LARGE:
                        case TI_STRING16_LARGE:
                            if (0x00000003 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TI_PLAIN_SEQUENCE_SMALL:
                            if (0x00000004 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TI_PLAIN_SEQUENCE_LARGE:
                            if (0x00000005 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TI_PLAIN_ARRAY_SMALL:
                            if (0x00000006 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TI_PLAIN_ARRAY_LARGE:
                            if (0x00000007 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TI_PLAIN_MAP_SMALL:
                            if (0x00000008 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TI_PLAIN_MAP_LARGE:
                            if (0x00000009 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TI_STRONGLY_CONNECTED_COMPONENT:
                            if (0x0000000a == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case EK_COMPLETE:
                        case EK_MINIMAL:
                            if (0x0000000b == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        default:
                            if (0x0000000c == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport uint8_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member no_value
     * @param _no_value New value to be copied in member no_value
     */
    eProsima_user_DllExport void no_value(
            const Dummy& _no_value)
    {
        no_value_() = _no_value;
        m__d = TK_NONE;
    }

    /*!
     * @brief This function moves the value in member no_value
     * @param _no_value New value to be moved in member no_value
     */
    eProsima_user_DllExport void no_value(
            Dummy&& _no_value)
    {
        no_value_() = _no_value;
        m__d = TK_NONE;
    }

    /*!
     * @brief This function returns a constant reference to member no_value
     * @return Constant reference to member no_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const Dummy& no_value() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_no_value;
    }

    /*!
     * @brief This function returns a reference to member no_value
     * @return Reference to member no_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport Dummy& no_value()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_no_value;
    }


    /*!
     * @brief This function copies the value in member string_sdefn
     * @param _string_sdefn New value to be copied in member string_sdefn
     */
    eProsima_user_DllExport void string_sdefn(
            const StringSTypeDefn& _string_sdefn)
    {
        string_sdefn_() = _string_sdefn;
        m__d = TI_STRING8_SMALL;
    }

    /*!
     * @brief This function moves the value in member string_sdefn
     * @param _string_sdefn New value to be moved in member string_sdefn
     */
    eProsima_user_DllExport void string_sdefn(
            StringSTypeDefn&& _string_sdefn)
    {
        string_sdefn_() = _string_sdefn;
        m__d = TI_STRING8_SMALL;
    }

    /*!
     * @brief This function returns a constant reference to member string_sdefn
     * @return Constant reference to member string_sdefn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const StringSTypeDefn& string_sdefn() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_string_sdefn;
    }

    /*!
     * @brief This function returns a reference to member string_sdefn
     * @return Reference to member string_sdefn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport StringSTypeDefn& string_sdefn()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_string_sdefn;
    }


    /*!
     * @brief This function copies the value in member string_ldefn
     * @param _string_ldefn New value to be copied in member string_ldefn
     */
    eProsima_user_DllExport void string_ldefn(
            const StringLTypeDefn& _string_ldefn)
    {
        string_ldefn_() = _string_ldefn;
        m__d = TI_STRING8_LARGE;
    }

    /*!
     * @brief This function moves the value in member string_ldefn
     * @param _string_ldefn New value to be moved in member string_ldefn
     */
    eProsima_user_DllExport void string_ldefn(
            StringLTypeDefn&& _string_ldefn)
    {
        string_ldefn_() = _string_ldefn;
        m__d = TI_STRING8_LARGE;
    }

    /*!
     * @brief This function returns a constant reference to member string_ldefn
     * @return Constant reference to member string_ldefn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const StringLTypeDefn& string_ldefn() const
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_string_ldefn;
    }

    /*!
     * @brief This function returns a reference to member string_ldefn
     * @return Reference to member string_ldefn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport StringLTypeDefn& string_ldefn()
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_string_ldefn;
    }


    /*!
     * @brief This function copies the value in member seq_sdefn
     * @param _seq_sdefn New value to be copied in member seq_sdefn
     */
    eProsima_user_DllExport void seq_sdefn(
            const PlainSequenceSElemDefn& _seq_sdefn)
    {
        seq_sdefn_() = _seq_sdefn;
        m__d = TI_PLAIN_SEQUENCE_SMALL;
    }

    /*!
     * @brief This function moves the value in member seq_sdefn
     * @param _seq_sdefn New value to be moved in member seq_sdefn
     */
    eProsima_user_DllExport void seq_sdefn(
            PlainSequenceSElemDefn&& _seq_sdefn)
    {
        seq_sdefn_() = _seq_sdefn;
        m__d = TI_PLAIN_SEQUENCE_SMALL;
    }

    /*!
     * @brief This function returns a constant reference to member seq_sdefn
     * @return Constant reference to member seq_sdefn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const PlainSequenceSElemDefn& seq_sdefn() const
    {
        if (0x00000004 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_seq_sdefn;
    }

    /*!
     * @brief This function returns a reference to member seq_sdefn
     * @return Reference to member seq_sdefn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport PlainSequenceSElemDefn& seq_sdefn()
    {
        if (0x00000004 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_seq_sdefn;
    }


    /*!
     * @brief This function copies the value in member seq_ldefn
     * @param _seq_ldefn New value to be copied in member seq_ldefn
     */
    eProsima_user_DllExport void seq_ldefn(
            const PlainSequenceLElemDefn& _seq_ldefn)
    {
        seq_ldefn_() = _seq_ldefn;
        m__d = TI_PLAIN_SEQUENCE_LARGE;
    }

    /*!
     * @brief This function moves the value in member seq_ldefn
     * @param _seq_ldefn New value to be moved in member seq_ldefn
     */
    eProsima_user_DllExport void seq_ldefn(
            PlainSequenceLElemDefn&& _seq_ldefn)
    {
        seq_ldefn_() = _seq_ldefn;
        m__d = TI_PLAIN_SEQUENCE_LARGE;
    }

    /*!
     * @brief This function returns a constant reference to member seq_ldefn
     * @return Constant reference to member seq_ldefn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const PlainSequenceLElemDefn& seq_ldefn() const
    {
        if (0x00000005 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_seq_ldefn;
    }

    /*!
     * @brief This function returns a reference to member seq_ldefn
     * @return Reference to member seq_ldefn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport PlainSequenceLElemDefn& seq_ldefn()
    {
        if (0x00000005 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_seq_ldefn;
    }


    /*!
     * @brief This function copies the value in member array_sdefn
     * @param _array_sdefn New value to be copied in member array_sdefn
     */
    eProsima_user_DllExport void array_sdefn(
            const PlainArraySElemDefn& _array_sdefn)
    {
        array_sdefn_() = _array_sdefn;
        m__d = TI_PLAIN_ARRAY_SMALL;
    }

    /*!
     * @brief This function moves the value in member array_sdefn
     * @param _array_sdefn New value to be moved in member array_sdefn
     */
    eProsima_user_DllExport void array_sdefn(
            PlainArraySElemDefn&& _array_sdefn)
    {
        array_sdefn_() = _array_sdefn;
        m__d = TI_PLAIN_ARRAY_SMALL;
    }

    /*!
     * @brief This function returns a constant reference to member array_sdefn
     * @return Constant reference to member array_sdefn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const PlainArraySElemDefn& array_sdefn() const
    {
        if (0x00000006 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_array_sdefn;
    }

    /*!
     * @brief This function returns a reference to member array_sdefn
     * @return Reference to member array_sdefn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport PlainArraySElemDefn& array_sdefn()
    {
        if (0x00000006 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_array_sdefn;
    }


    /*!
     * @brief This function copies the value in member array_ldefn
     * @param _array_ldefn New value to be copied in member array_ldefn
     */
    eProsima_user_DllExport void array_ldefn(
            const PlainArrayLElemDefn& _array_ldefn)
    {
        array_ldefn_() = _array_ldefn;
        m__d = TI_PLAIN_ARRAY_LARGE;
    }

    /*!
     * @brief This function moves the value in member array_ldefn
     * @param _array_ldefn New value to be moved in member array_ldefn
     */
    eProsima_user_DllExport void array_ldefn(
            PlainArrayLElemDefn&& _array_ldefn)
    {
        array_ldefn_() = _array_ldefn;
        m__d = TI_PLAIN_ARRAY_LARGE;
    }

    /*!
     * @brief This function returns a constant reference to member array_ldefn
     * @return Constant reference to member array_ldefn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const PlainArrayLElemDefn& array_ldefn() const
    {
        if (0x00000007 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_array_ldefn;
    }

    /*!
     * @brief This function returns a reference to member array_ldefn
     * @return Reference to member array_ldefn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport PlainArrayLElemDefn& array_ldefn()
    {
        if (0x00000007 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_array_ldefn;
    }


    /*!
     * @brief This function copies the value in member map_sdefn
     * @param _map_sdefn New value to be copied in member map_sdefn
     */
    eProsima_user_DllExport void map_sdefn(
            const PlainMapSTypeDefn& _map_sdefn)
    {
        map_sdefn_() = _map_sdefn;
        m__d = TI_PLAIN_MAP_SMALL;
    }

    /*!
     * @brief This function moves the value in member map_sdefn
     * @param _map_sdefn New value to be moved in member map_sdefn
     */
    eProsima_user_DllExport void map_sdefn(
            PlainMapSTypeDefn&& _map_sdefn)
    {
        map_sdefn_() = _map_sdefn;
        m__d = TI_PLAIN_MAP_SMALL;
    }

    /*!
     * @brief This function returns a constant reference to member map_sdefn
     * @return Constant reference to member map_sdefn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const PlainMapSTypeDefn& map_sdefn() const
    {
        if (0x00000008 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_map_sdefn;
    }

    /*!
     * @brief This function returns a reference to member map_sdefn
     * @return Reference to member map_sdefn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport PlainMapSTypeDefn& map_sdefn()
    {
        if (0x00000008 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_map_sdefn;
    }


    /*!
     * @brief This function copies the value in member map_ldefn
     * @param _map_ldefn New value to be copied in member map_ldefn
     */
    eProsima_user_DllExport void map_ldefn(
            const PlainMapLTypeDefn& _map_ldefn)
    {
        map_ldefn_() = _map_ldefn;
        m__d = TI_PLAIN_MAP_LARGE;
    }

    /*!
     * @brief This function moves the value in member map_ldefn
     * @param _map_ldefn New value to be moved in member map_ldefn
     */
    eProsima_user_DllExport void map_ldefn(
            PlainMapLTypeDefn&& _map_ldefn)
    {
        map_ldefn_() = _map_ldefn;
        m__d = TI_PLAIN_MAP_LARGE;
    }

    /*!
     * @brief This function returns a constant reference to member map_ldefn
     * @return Constant reference to member map_ldefn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const PlainMapLTypeDefn& map_ldefn() const
    {
        if (0x00000009 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_map_ldefn;
    }

    /*!
     * @brief This function returns a reference to member map_ldefn
     * @return Reference to member map_ldefn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport PlainMapLTypeDefn& map_ldefn()
    {
        if (0x00000009 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_map_ldefn;
    }


    /*!
     * @brief This function copies the value in member sc_component_id
     * @param _sc_component_id New value to be copied in member sc_component_id
     */
    eProsima_user_DllExport void sc_component_id(
            const StronglyConnectedComponentId& _sc_component_id)
    {
        sc_component_id_() = _sc_component_id;
        m__d = TI_STRONGLY_CONNECTED_COMPONENT;
    }

    /*!
     * @brief This function moves the value in member sc_component_id
     * @param _sc_component_id New value to be moved in member sc_component_id
     */
    eProsima_user_DllExport void sc_component_id(
            StronglyConnectedComponentId&& _sc_component_id)
    {
        sc_component_id_() = _sc_component_id;
        m__d = TI_STRONGLY_CONNECTED_COMPONENT;
    }

    /*!
     * @brief This function returns a constant reference to member sc_component_id
     * @return Constant reference to member sc_component_id
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const StronglyConnectedComponentId& sc_component_id() const
    {
        if (0x0000000a != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_sc_component_id;
    }

    /*!
     * @brief This function returns a reference to member sc_component_id
     * @return Reference to member sc_component_id
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport StronglyConnectedComponentId& sc_component_id()
    {
        if (0x0000000a != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_sc_component_id;
    }


    /*!
     * @brief This function copies the value in member equivalence_hash
     * @param _equivalence_hash New value to be copied in member equivalence_hash
     */
    eProsima_user_DllExport void equivalence_hash(
            const EquivalenceHash& _equivalence_hash)
    {
        equivalence_hash_() = _equivalence_hash;
        m__d = EK_COMPLETE;
    }

    /*!
     * @brief This function moves the value in member equivalence_hash
     * @param _equivalence_hash New value to be moved in member equivalence_hash
     */
    eProsima_user_DllExport void equivalence_hash(
            EquivalenceHash&& _equivalence_hash)
    {
        equivalence_hash_() = _equivalence_hash;
        m__d = EK_COMPLETE;
    }

    /*!
     * @brief This function returns a constant reference to member equivalence_hash
     * @return Constant reference to member equivalence_hash
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const EquivalenceHash& equivalence_hash() const
    {
        if (0x0000000b != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_equivalence_hash;
    }

    /*!
     * @brief This function returns a reference to member equivalence_hash
     * @return Reference to member equivalence_hash
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport EquivalenceHash& equivalence_hash()
    {
        if (0x0000000b != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_equivalence_hash;
    }


    /*!
     * @brief This function copies the value in member extended_defn
     * @param _extended_defn New value to be copied in member extended_defn
     */
    eProsima_user_DllExport void extended_defn(
            const ExtendedTypeDefn& _extended_defn)
    {
        extended_defn_() = _extended_defn;
        m__d = 127;
    }

    /*!
     * @brief This function moves the value in member extended_defn
     * @param _extended_defn New value to be moved in member extended_defn
     */
    eProsima_user_DllExport void extended_defn(
            ExtendedTypeDefn&& _extended_defn)
    {
        extended_defn_() = _extended_defn;
        m__d = 127;
    }

    /*!
     * @brief This function returns a constant reference to member extended_defn
     * @return Constant reference to member extended_defn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const ExtendedTypeDefn& extended_defn() const
    {
        if (0x0000000c != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_extended_defn;
    }

    /*!
     * @brief This function returns a reference to member extended_defn
     * @return Reference to member extended_defn
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport ExtendedTypeDefn& extended_defn()
    {
        if (0x0000000c != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_extended_defn;
    }



private:

            Dummy& no_value_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        m_no_value.~Dummy();
                    };
                    new(&m_no_value) Dummy();

                }

                return m_no_value;
            }

            StringSTypeDefn& string_sdefn_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = [&]()
                    {
                        m_string_sdefn.~StringSTypeDefn();
                    };
                    new(&m_string_sdefn) StringSTypeDefn();

                }

                return m_string_sdefn;
            }

            StringLTypeDefn& string_ldefn_()
            {
                if (0x00000003 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000003;
                    member_destructor_ = [&]()
                    {
                        m_string_ldefn.~StringLTypeDefn();
                    };
                    new(&m_string_ldefn) StringLTypeDefn();

                }

                return m_string_ldefn;
            }

            PlainSequenceSElemDefn& seq_sdefn_()
            {
                if (0x00000004 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000004;
                    member_destructor_ = [&]()
                    {
                        m_seq_sdefn.~PlainSequenceSElemDefn();
                    };
                    new(&m_seq_sdefn) PlainSequenceSElemDefn();

                }

                return m_seq_sdefn;
            }

            PlainSequenceLElemDefn& seq_ldefn_()
            {
                if (0x00000005 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000005;
                    member_destructor_ = [&]()
                    {
                        m_seq_ldefn.~PlainSequenceLElemDefn();
                    };
                    new(&m_seq_ldefn) PlainSequenceLElemDefn();

                }

                return m_seq_ldefn;
            }

            PlainArraySElemDefn& array_sdefn_()
            {
                if (0x00000006 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000006;
                    member_destructor_ = [&]()
                    {
                        m_array_sdefn.~PlainArraySElemDefn();
                    };
                    new(&m_array_sdefn) PlainArraySElemDefn();

                }

                return m_array_sdefn;
            }

            PlainArrayLElemDefn& array_ldefn_()
            {
                if (0x00000007 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000007;
                    member_destructor_ = [&]()
                    {
                        m_array_ldefn.~PlainArrayLElemDefn();
                    };
                    new(&m_array_ldefn) PlainArrayLElemDefn();

                }

                return m_array_ldefn;
            }

            PlainMapSTypeDefn& map_sdefn_()
            {
                if (0x00000008 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000008;
                    member_destructor_ = [&]()
                    {
                        m_map_sdefn.~PlainMapSTypeDefn();
                    };
                    new(&m_map_sdefn) PlainMapSTypeDefn();

                }

                return m_map_sdefn;
            }

            PlainMapLTypeDefn& map_ldefn_()
            {
                if (0x00000009 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000009;
                    member_destructor_ = [&]()
                    {
                        m_map_ldefn.~PlainMapLTypeDefn();
                    };
                    new(&m_map_ldefn) PlainMapLTypeDefn();

                }

                return m_map_ldefn;
            }

            StronglyConnectedComponentId& sc_component_id_()
            {
                if (0x0000000a != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x0000000a;
                    member_destructor_ = [&]()
                    {
                        m_sc_component_id.~StronglyConnectedComponentId();
                    };
                    new(&m_sc_component_id) StronglyConnectedComponentId();

                }

                return m_sc_component_id;
            }

            EquivalenceHash& equivalence_hash_()
            {
                if (0x0000000b != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x0000000b;
                    member_destructor_ = [&]()
                    {
                        using namespace eprosima::fastdds::dds::xtypes;
                        m_equivalence_hash.~EquivalenceHash();
                    };
                    new(&m_equivalence_hash) EquivalenceHash();

                }

                return m_equivalence_hash;
            }

            ExtendedTypeDefn& extended_defn_()
            {
                if (0x0000000c != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x0000000c;
                    member_destructor_ = [&]()
                    {
                        m_extended_defn.~ExtendedTypeDefn();
                    };
                    new(&m_extended_defn) ExtendedTypeDefn();

                }

                return m_extended_defn;
            }


    uint8_t m__d {TK_NONE};

    union
    {
        Dummy m_no_value;
        StringSTypeDefn m_string_sdefn;
        StringLTypeDefn m_string_ldefn;
        PlainSequenceSElemDefn m_seq_sdefn;
        PlainSequenceLElemDefn m_seq_ldefn;
        PlainArraySElemDefn m_array_sdefn;
        PlainArrayLElemDefn m_array_ldefn;
        PlainMapSTypeDefn m_map_sdefn;
        PlainMapLTypeDefn m_map_ldefn;
        StronglyConnectedComponentId m_sc_component_id;
        EquivalenceHash m_equivalence_hash;
        ExtendedTypeDefn m_extended_defn;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
typedef std::vector<TypeIdentifier> TypeIdentifierSeq;

typedef uint32_t MemberId;

const uint32_t ANNOTATION_STR_VALUE_MAX_LEN = 128;
const uint32_t ANNOTATION_OCTETSEC_VALUE_MAX_LEN = 128;
/*!
 * @brief This class represents the structure ExtendedAnnotationParameterValue defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class ExtendedAnnotationParameterValue
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ExtendedAnnotationParameterValue()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ExtendedAnnotationParameterValue()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ExtendedAnnotationParameterValue that will be copied.
     */
    eProsima_user_DllExport ExtendedAnnotationParameterValue(
            const ExtendedAnnotationParameterValue& x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ExtendedAnnotationParameterValue that will be copied.
     */
    eProsima_user_DllExport ExtendedAnnotationParameterValue(
            ExtendedAnnotationParameterValue&& x) noexcept
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ExtendedAnnotationParameterValue that will be copied.
     */
    eProsima_user_DllExport ExtendedAnnotationParameterValue& operator =(
            const ExtendedAnnotationParameterValue& x)
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ExtendedAnnotationParameterValue that will be copied.
     */
    eProsima_user_DllExport ExtendedAnnotationParameterValue& operator =(
            ExtendedAnnotationParameterValue&& x) noexcept
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ExtendedAnnotationParameterValue object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ExtendedAnnotationParameterValue& x) const
    {
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x ExtendedAnnotationParameterValue object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ExtendedAnnotationParameterValue& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the union AnnotationParameterValue defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class AnnotationParameterValue
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AnnotationParameterValue()
    {
        selected_member_ = 0x00000013;
        member_destructor_ = [&]()
        {
            m_extended_value.~ExtendedAnnotationParameterValue();
        };
        new(&m_extended_value) ExtendedAnnotationParameterValue();

    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AnnotationParameterValue()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AnnotationParameterValue that will be copied.
     */
    eProsima_user_DllExport AnnotationParameterValue(
            const AnnotationParameterValue& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            boolean_value_() = x.m_boolean_value;
                            break;

                        case 0x00000002:
                            byte_value_() = x.m_byte_value;
                            break;

                        case 0x00000003:
                            int8_value_() = x.m_int8_value;
                            break;

                        case 0x00000004:
                            uint8_value_() = x.m_uint8_value;
                            break;

                        case 0x00000005:
                            int16_value_() = x.m_int16_value;
                            break;

                        case 0x00000006:
                            uint_16_value_() = x.m_uint_16_value;
                            break;

                        case 0x00000007:
                            int32_value_() = x.m_int32_value;
                            break;

                        case 0x00000008:
                            uint32_value_() = x.m_uint32_value;
                            break;

                        case 0x00000009:
                            int64_value_() = x.m_int64_value;
                            break;

                        case 0x0000000a:
                            uint64_value_() = x.m_uint64_value;
                            break;

                        case 0x0000000b:
                            float32_value_() = x.m_float32_value;
                            break;

                        case 0x0000000c:
                            float64_value_() = x.m_float64_value;
                            break;

                        case 0x0000000d:
                            float128_value_() = x.m_float128_value;
                            break;

                        case 0x0000000e:
                            char_value_() = x.m_char_value;
                            break;

                        case 0x0000000f:
                            wchar_value_() = x.m_wchar_value;
                            break;

                        case 0x00000010:
                            enumerated_value_() = x.m_enumerated_value;
                            break;

                        case 0x00000011:
                            string8_value_() = x.m_string8_value;
                            break;

                        case 0x00000012:
                            string16_value_() = x.m_string16_value;
                            break;

                        case 0x00000013:
                            extended_value_() = x.m_extended_value;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AnnotationParameterValue that will be copied.
     */
    eProsima_user_DllExport AnnotationParameterValue(
            AnnotationParameterValue&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            boolean_value_() = std::move(x.m_boolean_value);
                            break;

                        case 0x00000002:
                            byte_value_() = std::move(x.m_byte_value);
                            break;

                        case 0x00000003:
                            int8_value_() = std::move(x.m_int8_value);
                            break;

                        case 0x00000004:
                            uint8_value_() = std::move(x.m_uint8_value);
                            break;

                        case 0x00000005:
                            int16_value_() = std::move(x.m_int16_value);
                            break;

                        case 0x00000006:
                            uint_16_value_() = std::move(x.m_uint_16_value);
                            break;

                        case 0x00000007:
                            int32_value_() = std::move(x.m_int32_value);
                            break;

                        case 0x00000008:
                            uint32_value_() = std::move(x.m_uint32_value);
                            break;

                        case 0x00000009:
                            int64_value_() = std::move(x.m_int64_value);
                            break;

                        case 0x0000000a:
                            uint64_value_() = std::move(x.m_uint64_value);
                            break;

                        case 0x0000000b:
                            float32_value_() = std::move(x.m_float32_value);
                            break;

                        case 0x0000000c:
                            float64_value_() = std::move(x.m_float64_value);
                            break;

                        case 0x0000000d:
                            float128_value_() = std::move(x.m_float128_value);
                            break;

                        case 0x0000000e:
                            char_value_() = std::move(x.m_char_value);
                            break;

                        case 0x0000000f:
                            wchar_value_() = std::move(x.m_wchar_value);
                            break;

                        case 0x00000010:
                            enumerated_value_() = std::move(x.m_enumerated_value);
                            break;

                        case 0x00000011:
                            string8_value_() = std::move(x.m_string8_value);
                            break;

                        case 0x00000012:
                            string16_value_() = std::move(x.m_string16_value);
                            break;

                        case 0x00000013:
                            extended_value_() = std::move(x.m_extended_value);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AnnotationParameterValue that will be copied.
     */
    eProsima_user_DllExport AnnotationParameterValue& operator =(
            const AnnotationParameterValue& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            boolean_value_() = x.m_boolean_value;
                            break;

                        case 0x00000002:
                            byte_value_() = x.m_byte_value;
                            break;

                        case 0x00000003:
                            int8_value_() = x.m_int8_value;
                            break;

                        case 0x00000004:
                            uint8_value_() = x.m_uint8_value;
                            break;

                        case 0x00000005:
                            int16_value_() = x.m_int16_value;
                            break;

                        case 0x00000006:
                            uint_16_value_() = x.m_uint_16_value;
                            break;

                        case 0x00000007:
                            int32_value_() = x.m_int32_value;
                            break;

                        case 0x00000008:
                            uint32_value_() = x.m_uint32_value;
                            break;

                        case 0x00000009:
                            int64_value_() = x.m_int64_value;
                            break;

                        case 0x0000000a:
                            uint64_value_() = x.m_uint64_value;
                            break;

                        case 0x0000000b:
                            float32_value_() = x.m_float32_value;
                            break;

                        case 0x0000000c:
                            float64_value_() = x.m_float64_value;
                            break;

                        case 0x0000000d:
                            float128_value_() = x.m_float128_value;
                            break;

                        case 0x0000000e:
                            char_value_() = x.m_char_value;
                            break;

                        case 0x0000000f:
                            wchar_value_() = x.m_wchar_value;
                            break;

                        case 0x00000010:
                            enumerated_value_() = x.m_enumerated_value;
                            break;

                        case 0x00000011:
                            string8_value_() = x.m_string8_value;
                            break;

                        case 0x00000012:
                            string16_value_() = x.m_string16_value;
                            break;

                        case 0x00000013:
                            extended_value_() = x.m_extended_value;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AnnotationParameterValue that will be copied.
     */
    eProsima_user_DllExport AnnotationParameterValue& operator =(
            AnnotationParameterValue&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            boolean_value_() = std::move(x.m_boolean_value);
                            break;

                        case 0x00000002:
                            byte_value_() = std::move(x.m_byte_value);
                            break;

                        case 0x00000003:
                            int8_value_() = std::move(x.m_int8_value);
                            break;

                        case 0x00000004:
                            uint8_value_() = std::move(x.m_uint8_value);
                            break;

                        case 0x00000005:
                            int16_value_() = std::move(x.m_int16_value);
                            break;

                        case 0x00000006:
                            uint_16_value_() = std::move(x.m_uint_16_value);
                            break;

                        case 0x00000007:
                            int32_value_() = std::move(x.m_int32_value);
                            break;

                        case 0x00000008:
                            uint32_value_() = std::move(x.m_uint32_value);
                            break;

                        case 0x00000009:
                            int64_value_() = std::move(x.m_int64_value);
                            break;

                        case 0x0000000a:
                            uint64_value_() = std::move(x.m_uint64_value);
                            break;

                        case 0x0000000b:
                            float32_value_() = std::move(x.m_float32_value);
                            break;

                        case 0x0000000c:
                            float64_value_() = std::move(x.m_float64_value);
                            break;

                        case 0x0000000d:
                            float128_value_() = std::move(x.m_float128_value);
                            break;

                        case 0x0000000e:
                            char_value_() = std::move(x.m_char_value);
                            break;

                        case 0x0000000f:
                            wchar_value_() = std::move(x.m_wchar_value);
                            break;

                        case 0x00000010:
                            enumerated_value_() = std::move(x.m_enumerated_value);
                            break;

                        case 0x00000011:
                            string8_value_() = std::move(x.m_string8_value);
                            break;

                        case 0x00000012:
                            string16_value_() = std::move(x.m_string16_value);
                            break;

                        case 0x00000013:
                            extended_value_() = std::move(x.m_extended_value);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AnnotationParameterValue object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AnnotationParameterValue& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_boolean_value == m_boolean_value);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_byte_value == m_byte_value);
                                                        break;

                                                    case 0x00000003:
                                                        ret_value = (x.m_int8_value == m_int8_value);
                                                        break;

                                                    case 0x00000004:
                                                        ret_value = (x.m_uint8_value == m_uint8_value);
                                                        break;

                                                    case 0x00000005:
                                                        ret_value = (x.m_int16_value == m_int16_value);
                                                        break;

                                                    case 0x00000006:
                                                        ret_value = (x.m_uint_16_value == m_uint_16_value);
                                                        break;

                                                    case 0x00000007:
                                                        ret_value = (x.m_int32_value == m_int32_value);
                                                        break;

                                                    case 0x00000008:
                                                        ret_value = (x.m_uint32_value == m_uint32_value);
                                                        break;

                                                    case 0x00000009:
                                                        ret_value = (x.m_int64_value == m_int64_value);
                                                        break;

                                                    case 0x0000000a:
                                                        ret_value = (x.m_uint64_value == m_uint64_value);
                                                        break;

                                                    case 0x0000000b:
                                                        ret_value = (x.m_float32_value == m_float32_value);
                                                        break;

                                                    case 0x0000000c:
                                                        ret_value = (x.m_float64_value == m_float64_value);
                                                        break;

                                                    case 0x0000000d:
                                                        ret_value = (x.m_float128_value == m_float128_value);
                                                        break;

                                                    case 0x0000000e:
                                                        ret_value = (x.m_char_value == m_char_value);
                                                        break;

                                                    case 0x0000000f:
                                                        ret_value = (x.m_wchar_value == m_wchar_value);
                                                        break;

                                                    case 0x00000010:
                                                        ret_value = (x.m_enumerated_value == m_enumerated_value);
                                                        break;

                                                    case 0x00000011:
                                                        ret_value = (x.m_string8_value == m_string8_value);
                                                        break;

                                                    case 0x00000012:
                                                        ret_value = (x.m_string16_value == m_string16_value);
                                                        break;

                                                    case 0x00000013:
                                                        ret_value = (x.m_extended_value == m_extended_value);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x AnnotationParameterValue object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AnnotationParameterValue& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            uint8_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case TK_BOOLEAN:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_BYTE:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_INT8:
                            if (0x00000003 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_UINT8:
                            if (0x00000004 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_INT16:
                            if (0x00000005 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_UINT16:
                            if (0x00000006 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_INT32:
                            if (0x00000007 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_UINT32:
                            if (0x00000008 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_INT64:
                            if (0x00000009 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_UINT64:
                            if (0x0000000a == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_FLOAT32:
                            if (0x0000000b == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_FLOAT64:
                            if (0x0000000c == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_FLOAT128:
                            if (0x0000000d == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_CHAR8:
                            if (0x0000000e == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_CHAR16:
                            if (0x0000000f == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_ENUM:
                            if (0x00000010 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_STRING8:
                            if (0x00000011 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_STRING16:
                            if (0x00000012 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        default:
                            if (0x00000013 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport uint8_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function sets a value in member boolean_value
     * @param _boolean_value New value for member boolean_value
     */
    eProsima_user_DllExport void boolean_value(
            bool _boolean_value)
    {
        boolean_value_() = _boolean_value;
        m__d = TK_BOOLEAN;
    }

    /*!
     * @brief This function returns the value of member boolean_value
     * @return Value of member boolean_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport bool boolean_value() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_boolean_value;
    }

    /*!
     * @brief This function returns a reference to member boolean_value
     * @return Reference to member boolean_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport bool& boolean_value()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_boolean_value;
    }


    /*!
     * @brief This function sets a value in member byte_value
     * @param _byte_value New value for member byte_value
     */
    eProsima_user_DllExport void byte_value(
            uint8_t _byte_value)
    {
        byte_value_() = _byte_value;
        m__d = TK_BYTE;
    }

    /*!
     * @brief This function returns the value of member byte_value
     * @return Value of member byte_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint8_t byte_value() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_byte_value;
    }

    /*!
     * @brief This function returns a reference to member byte_value
     * @return Reference to member byte_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint8_t& byte_value()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_byte_value;
    }


    /*!
     * @brief This function sets a value in member int8_value
     * @param _int8_value New value for member int8_value
     */
    eProsima_user_DllExport void int8_value(
            int8_t _int8_value)
    {
        int8_value_() = _int8_value;
        m__d = TK_INT8;
    }

    /*!
     * @brief This function returns the value of member int8_value
     * @return Value of member int8_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int8_t int8_value() const
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_int8_value;
    }

    /*!
     * @brief This function returns a reference to member int8_value
     * @return Reference to member int8_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int8_t& int8_value()
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_int8_value;
    }


    /*!
     * @brief This function sets a value in member uint8_value
     * @param _uint8_value New value for member uint8_value
     */
    eProsima_user_DllExport void uint8_value(
            uint8_t _uint8_value)
    {
        uint8_value_() = _uint8_value;
        m__d = TK_UINT8;
    }

    /*!
     * @brief This function returns the value of member uint8_value
     * @return Value of member uint8_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint8_t uint8_value() const
    {
        if (0x00000004 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_uint8_value;
    }

    /*!
     * @brief This function returns a reference to member uint8_value
     * @return Reference to member uint8_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint8_t& uint8_value()
    {
        if (0x00000004 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_uint8_value;
    }


    /*!
     * @brief This function sets a value in member int16_value
     * @param _int16_value New value for member int16_value
     */
    eProsima_user_DllExport void int16_value(
            int16_t _int16_value)
    {
        int16_value_() = _int16_value;
        m__d = TK_INT16;
    }

    /*!
     * @brief This function returns the value of member int16_value
     * @return Value of member int16_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int16_t int16_value() const
    {
        if (0x00000005 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_int16_value;
    }

    /*!
     * @brief This function returns a reference to member int16_value
     * @return Reference to member int16_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int16_t& int16_value()
    {
        if (0x00000005 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_int16_value;
    }


    /*!
     * @brief This function sets a value in member uint_16_value
     * @param _uint_16_value New value for member uint_16_value
     */
    eProsima_user_DllExport void uint_16_value(
            uint16_t _uint_16_value)
    {
        uint_16_value_() = _uint_16_value;
        m__d = TK_UINT16;
    }

    /*!
     * @brief This function returns the value of member uint_16_value
     * @return Value of member uint_16_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint16_t uint_16_value() const
    {
        if (0x00000006 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_uint_16_value;
    }

    /*!
     * @brief This function returns a reference to member uint_16_value
     * @return Reference to member uint_16_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint16_t& uint_16_value()
    {
        if (0x00000006 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_uint_16_value;
    }


    /*!
     * @brief This function sets a value in member int32_value
     * @param _int32_value New value for member int32_value
     */
    eProsima_user_DllExport void int32_value(
            int32_t _int32_value)
    {
        int32_value_() = _int32_value;
        m__d = TK_INT32;
    }

    /*!
     * @brief This function returns the value of member int32_value
     * @return Value of member int32_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t int32_value() const
    {
        if (0x00000007 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_int32_value;
    }

    /*!
     * @brief This function returns a reference to member int32_value
     * @return Reference to member int32_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& int32_value()
    {
        if (0x00000007 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_int32_value;
    }


    /*!
     * @brief This function sets a value in member uint32_value
     * @param _uint32_value New value for member uint32_value
     */
    eProsima_user_DllExport void uint32_value(
            uint32_t _uint32_value)
    {
        uint32_value_() = _uint32_value;
        m__d = TK_UINT32;
    }

    /*!
     * @brief This function returns the value of member uint32_value
     * @return Value of member uint32_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint32_t uint32_value() const
    {
        if (0x00000008 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_uint32_value;
    }

    /*!
     * @brief This function returns a reference to member uint32_value
     * @return Reference to member uint32_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint32_t& uint32_value()
    {
        if (0x00000008 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_uint32_value;
    }


    /*!
     * @brief This function sets a value in member int64_value
     * @param _int64_value New value for member int64_value
     */
    eProsima_user_DllExport void int64_value(
            int64_t _int64_value)
    {
        int64_value_() = _int64_value;
        m__d = TK_INT64;
    }

    /*!
     * @brief This function returns the value of member int64_value
     * @return Value of member int64_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t int64_value() const
    {
        if (0x00000009 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_int64_value;
    }

    /*!
     * @brief This function returns a reference to member int64_value
     * @return Reference to member int64_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int64_t& int64_value()
    {
        if (0x00000009 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_int64_value;
    }


    /*!
     * @brief This function sets a value in member uint64_value
     * @param _uint64_value New value for member uint64_value
     */
    eProsima_user_DllExport void uint64_value(
            uint64_t _uint64_value)
    {
        uint64_value_() = _uint64_value;
        m__d = TK_UINT64;
    }

    /*!
     * @brief This function returns the value of member uint64_value
     * @return Value of member uint64_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint64_t uint64_value() const
    {
        if (0x0000000a != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_uint64_value;
    }

    /*!
     * @brief This function returns a reference to member uint64_value
     * @return Reference to member uint64_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport uint64_t& uint64_value()
    {
        if (0x0000000a != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_uint64_value;
    }


    /*!
     * @brief This function sets a value in member float32_value
     * @param _float32_value New value for member float32_value
     */
    eProsima_user_DllExport void float32_value(
            float _float32_value)
    {
        float32_value_() = _float32_value;
        m__d = TK_FLOAT32;
    }

    /*!
     * @brief This function returns the value of member float32_value
     * @return Value of member float32_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport float float32_value() const
    {
        if (0x0000000b != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_float32_value;
    }

    /*!
     * @brief This function returns a reference to member float32_value
     * @return Reference to member float32_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport float& float32_value()
    {
        if (0x0000000b != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_float32_value;
    }


    /*!
     * @brief This function sets a value in member float64_value
     * @param _float64_value New value for member float64_value
     */
    eProsima_user_DllExport void float64_value(
            double _float64_value)
    {
        float64_value_() = _float64_value;
        m__d = TK_FLOAT64;
    }

    /*!
     * @brief This function returns the value of member float64_value
     * @return Value of member float64_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport double float64_value() const
    {
        if (0x0000000c != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_float64_value;
    }

    /*!
     * @brief This function returns a reference to member float64_value
     * @return Reference to member float64_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport double& float64_value()
    {
        if (0x0000000c != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_float64_value;
    }


    /*!
     * @brief This function sets a value in member float128_value
     * @param _float128_value New value for member float128_value
     */
    eProsima_user_DllExport void float128_value(
            long double _float128_value)
    {
        float128_value_() = _float128_value;
        m__d = TK_FLOAT128;
    }

    /*!
     * @brief This function returns the value of member float128_value
     * @return Value of member float128_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport long double float128_value() const
    {
        if (0x0000000d != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_float128_value;
    }

    /*!
     * @brief This function returns a reference to member float128_value
     * @return Reference to member float128_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport long double& float128_value()
    {
        if (0x0000000d != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_float128_value;
    }


    /*!
     * @brief This function sets a value in member char_value
     * @param _char_value New value for member char_value
     */
    eProsima_user_DllExport void char_value(
            char _char_value)
    {
        char_value_() = _char_value;
        m__d = TK_CHAR8;
    }

    /*!
     * @brief This function returns the value of member char_value
     * @return Value of member char_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport char char_value() const
    {
        if (0x0000000e != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_char_value;
    }

    /*!
     * @brief This function returns a reference to member char_value
     * @return Reference to member char_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport char& char_value()
    {
        if (0x0000000e != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_char_value;
    }


    /*!
     * @brief This function sets a value in member wchar_value
     * @param _wchar_value New value for member wchar_value
     */
    eProsima_user_DllExport void wchar_value(
            wchar_t _wchar_value)
    {
        wchar_value_() = _wchar_value;
        m__d = TK_CHAR16;
    }

    /*!
     * @brief This function returns the value of member wchar_value
     * @return Value of member wchar_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport wchar_t wchar_value() const
    {
        if (0x0000000f != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_wchar_value;
    }

    /*!
     * @brief This function returns a reference to member wchar_value
     * @return Reference to member wchar_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport wchar_t& wchar_value()
    {
        if (0x0000000f != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_wchar_value;
    }


    /*!
     * @brief This function sets a value in member enumerated_value
     * @param _enumerated_value New value for member enumerated_value
     */
    eProsima_user_DllExport void enumerated_value(
            int32_t _enumerated_value)
    {
        enumerated_value_() = _enumerated_value;
        m__d = TK_ENUM;
    }

    /*!
     * @brief This function returns the value of member enumerated_value
     * @return Value of member enumerated_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t enumerated_value() const
    {
        if (0x00000010 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_enumerated_value;
    }

    /*!
     * @brief This function returns a reference to member enumerated_value
     * @return Reference to member enumerated_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport int32_t& enumerated_value()
    {
        if (0x00000010 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_enumerated_value;
    }


    /*!
     * @brief This function copies the value in member string8_value
     * @param _string8_value New value to be copied in member string8_value
     */
    eProsima_user_DllExport void string8_value(
            const eprosima::fastcdr::fixed_string<ANNOTATION_STR_VALUE_MAX_LEN>& _string8_value)
    {
        string8_value_() = _string8_value;
        m__d = TK_STRING8;
    }

    /*!
     * @brief This function moves the value in member string8_value
     * @param _string8_value New value to be moved in member string8_value
     */
    eProsima_user_DllExport void string8_value(
            eprosima::fastcdr::fixed_string<ANNOTATION_STR_VALUE_MAX_LEN>&& _string8_value)
    {
        string8_value_() = _string8_value;
        m__d = TK_STRING8;
    }

    /*!
     * @brief This function returns a constant reference to member string8_value
     * @return Constant reference to member string8_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const eprosima::fastcdr::fixed_string<ANNOTATION_STR_VALUE_MAX_LEN>& string8_value() const
    {
        if (0x00000011 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_string8_value;
    }

    /*!
     * @brief This function returns a reference to member string8_value
     * @return Reference to member string8_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport eprosima::fastcdr::fixed_string<ANNOTATION_STR_VALUE_MAX_LEN>& string8_value()
    {
        if (0x00000011 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_string8_value;
    }


    /*!
     * @brief This function copies the value in member string16_value
     * @param _string16_value New value to be copied in member string16_value
     */
    eProsima_user_DllExport void string16_value(
            const std::wstring& _string16_value)
    {
        string16_value_() = _string16_value;
        m__d = TK_STRING16;
    }

    /*!
     * @brief This function moves the value in member string16_value
     * @param _string16_value New value to be moved in member string16_value
     */
    eProsima_user_DllExport void string16_value(
            std::wstring&& _string16_value)
    {
        string16_value_() = _string16_value;
        m__d = TK_STRING16;
    }

    /*!
     * @brief This function returns a constant reference to member string16_value
     * @return Constant reference to member string16_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const std::wstring& string16_value() const
    {
        if (0x00000012 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_string16_value;
    }

    /*!
     * @brief This function returns a reference to member string16_value
     * @return Reference to member string16_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport std::wstring& string16_value()
    {
        if (0x00000012 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_string16_value;
    }


    /*!
     * @brief This function copies the value in member extended_value
     * @param _extended_value New value to be copied in member extended_value
     */
    eProsima_user_DllExport void extended_value(
            const ExtendedAnnotationParameterValue& _extended_value)
    {
        extended_value_() = _extended_value;
        m__d = 127;
    }

    /*!
     * @brief This function moves the value in member extended_value
     * @param _extended_value New value to be moved in member extended_value
     */
    eProsima_user_DllExport void extended_value(
            ExtendedAnnotationParameterValue&& _extended_value)
    {
        extended_value_() = _extended_value;
        m__d = 127;
    }

    /*!
     * @brief This function returns a constant reference to member extended_value
     * @return Constant reference to member extended_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const ExtendedAnnotationParameterValue& extended_value() const
    {
        if (0x00000013 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_extended_value;
    }

    /*!
     * @brief This function returns a reference to member extended_value
     * @return Reference to member extended_value
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport ExtendedAnnotationParameterValue& extended_value()
    {
        if (0x00000013 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_extended_value;
    }



private:

            bool& boolean_value_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = nullptr;
                    m_boolean_value = {false};

                }

                return m_boolean_value;
            }

            uint8_t& byte_value_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = nullptr;
                    m_byte_value = {0};

                }

                return m_byte_value;
            }

            int8_t& int8_value_()
            {
                if (0x00000003 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000003;
                    member_destructor_ = nullptr;
                    m_int8_value = {0};

                }

                return m_int8_value;
            }

            uint8_t& uint8_value_()
            {
                if (0x00000004 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000004;
                    member_destructor_ = nullptr;
                    m_uint8_value = {0};

                }

                return m_uint8_value;
            }

            int16_t& int16_value_()
            {
                if (0x00000005 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000005;
                    member_destructor_ = nullptr;
                    m_int16_value = {0};

                }

                return m_int16_value;
            }

            uint16_t& uint_16_value_()
            {
                if (0x00000006 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000006;
                    member_destructor_ = nullptr;
                    m_uint_16_value = {0};

                }

                return m_uint_16_value;
            }

            int32_t& int32_value_()
            {
                if (0x00000007 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000007;
                    member_destructor_ = nullptr;
                    m_int32_value = {0};

                }

                return m_int32_value;
            }

            uint32_t& uint32_value_()
            {
                if (0x00000008 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000008;
                    member_destructor_ = nullptr;
                    m_uint32_value = {0};

                }

                return m_uint32_value;
            }

            int64_t& int64_value_()
            {
                if (0x00000009 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000009;
                    member_destructor_ = nullptr;
                    m_int64_value = {0};

                }

                return m_int64_value;
            }

            uint64_t& uint64_value_()
            {
                if (0x0000000a != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x0000000a;
                    member_destructor_ = nullptr;
                    m_uint64_value = {0};

                }

                return m_uint64_value;
            }

            float& float32_value_()
            {
                if (0x0000000b != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x0000000b;
                    member_destructor_ = nullptr;
                    m_float32_value = {0.0};

                }

                return m_float32_value;
            }

            double& float64_value_()
            {
                if (0x0000000c != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x0000000c;
                    member_destructor_ = nullptr;
                    m_float64_value = {0.0};

                }

                return m_float64_value;
            }

            long double& float128_value_()
            {
                if (0x0000000d != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x0000000d;
                    member_destructor_ = nullptr;
                    m_float128_value = {0.0};

                }

                return m_float128_value;
            }

            char& char_value_()
            {
                if (0x0000000e != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x0000000e;
                    member_destructor_ = nullptr;
                    m_char_value = {0};

                }

                return m_char_value;
            }

            wchar_t& wchar_value_()
            {
                if (0x0000000f != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x0000000f;
                    member_destructor_ = nullptr;
                    m_wchar_value = {0};

                }

                return m_wchar_value;
            }

            int32_t& enumerated_value_()
            {
                if (0x00000010 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000010;
                    member_destructor_ = nullptr;
                    m_enumerated_value = {0};

                }

                return m_enumerated_value;
            }

            eprosima::fastcdr::fixed_string<ANNOTATION_STR_VALUE_MAX_LEN>& string8_value_()
            {
                if (0x00000011 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000011;
                    member_destructor_ = [&]()
                    {
                        m_string8_value.~fixed_string();
                    };
                    new(&m_string8_value) eprosima::fastcdr::fixed_string<ANNOTATION_STR_VALUE_MAX_LEN>();

                }

                return m_string8_value;
            }

            std::wstring& string16_value_()
            {
                if (0x00000012 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000012;
                    member_destructor_ = [&]()
                    {
                        m_string16_value.~basic_string();
                    };
                    new(&m_string16_value) std::wstring();

                }

                return m_string16_value;
            }

            ExtendedAnnotationParameterValue& extended_value_()
            {
                if (0x00000013 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000013;
                    member_destructor_ = [&]()
                    {
                        m_extended_value.~ExtendedAnnotationParameterValue();
                    };
                    new(&m_extended_value) ExtendedAnnotationParameterValue();

                }

                return m_extended_value;
            }


    uint8_t m__d {127};

    union
    {
        bool m_boolean_value;
        uint8_t m_byte_value;
        int8_t m_int8_value;
        uint8_t m_uint8_value;
        int16_t m_int16_value;
        uint16_t m_uint_16_value;
        int32_t m_int32_value;
        uint32_t m_uint32_value;
        int64_t m_int64_value;
        uint64_t m_uint64_value;
        float m_float32_value;
        double m_float64_value;
        long double m_float128_value;
        char m_char_value;
        wchar_t m_wchar_value;
        int32_t m_enumerated_value;
        eprosima::fastcdr::fixed_string<ANNOTATION_STR_VALUE_MAX_LEN> m_string8_value;
        std::wstring m_string16_value;
        ExtendedAnnotationParameterValue m_extended_value;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the structure AppliedAnnotationParameter defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class AppliedAnnotationParameter
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppliedAnnotationParameter()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppliedAnnotationParameter()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppliedAnnotationParameter that will be copied.
     */
    eProsima_user_DllExport AppliedAnnotationParameter(
            const AppliedAnnotationParameter& x)
    {
                    m_paramname_hash = x.m_paramname_hash;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppliedAnnotationParameter that will be copied.
     */
    eProsima_user_DllExport AppliedAnnotationParameter(
            AppliedAnnotationParameter&& x) noexcept
    {
        m_paramname_hash = std::move(x.m_paramname_hash);
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppliedAnnotationParameter that will be copied.
     */
    eProsima_user_DllExport AppliedAnnotationParameter& operator =(
            const AppliedAnnotationParameter& x)
    {

                    m_paramname_hash = x.m_paramname_hash;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppliedAnnotationParameter that will be copied.
     */
    eProsima_user_DllExport AppliedAnnotationParameter& operator =(
            AppliedAnnotationParameter&& x) noexcept
    {

        m_paramname_hash = std::move(x.m_paramname_hash);
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppliedAnnotationParameter object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppliedAnnotationParameter& x) const
    {
        return (m_paramname_hash == x.m_paramname_hash &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppliedAnnotationParameter object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppliedAnnotationParameter& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member paramname_hash
     * @param _paramname_hash New value to be copied in member paramname_hash
     */
    eProsima_user_DllExport void paramname_hash(
            const NameHash& _paramname_hash)
    {
        m_paramname_hash = _paramname_hash;
    }

    /*!
     * @brief This function moves the value in member paramname_hash
     * @param _paramname_hash New value to be moved in member paramname_hash
     */
    eProsima_user_DllExport void paramname_hash(
            NameHash&& _paramname_hash)
    {
        m_paramname_hash = std::move(_paramname_hash);
    }

    /*!
     * @brief This function returns a constant reference to member paramname_hash
     * @return Constant reference to member paramname_hash
     */
    eProsima_user_DllExport const NameHash& paramname_hash() const
    {
        return m_paramname_hash;
    }

    /*!
     * @brief This function returns a reference to member paramname_hash
     * @return Reference to member paramname_hash
     */
    eProsima_user_DllExport NameHash& paramname_hash()
    {
        return m_paramname_hash;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const AnnotationParameterValue& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            AnnotationParameterValue&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const AnnotationParameterValue& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport AnnotationParameterValue& value()
    {
        return m_value;
    }



private:

    NameHash m_paramname_hash{0};
    AnnotationParameterValue m_value;

};
typedef std::vector<AppliedAnnotationParameter> AppliedAnnotationParameterSeq;

/*!
 * @brief This class represents the structure AppliedAnnotation defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class AppliedAnnotation
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppliedAnnotation()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppliedAnnotation()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppliedAnnotation that will be copied.
     */
    eProsima_user_DllExport AppliedAnnotation(
            const AppliedAnnotation& x)
    {
                    m_annotation_typeid = x.m_annotation_typeid;

                    m_param_seq = x.m_param_seq;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppliedAnnotation that will be copied.
     */
    eProsima_user_DllExport AppliedAnnotation(
            AppliedAnnotation&& x) noexcept
    {
        m_annotation_typeid = std::move(x.m_annotation_typeid);
        m_param_seq = std::move(x.m_param_seq);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppliedAnnotation that will be copied.
     */
    eProsima_user_DllExport AppliedAnnotation& operator =(
            const AppliedAnnotation& x)
    {

                    m_annotation_typeid = x.m_annotation_typeid;

                    m_param_seq = x.m_param_seq;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppliedAnnotation that will be copied.
     */
    eProsima_user_DllExport AppliedAnnotation& operator =(
            AppliedAnnotation&& x) noexcept
    {

        m_annotation_typeid = std::move(x.m_annotation_typeid);
        m_param_seq = std::move(x.m_param_seq);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppliedAnnotation object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppliedAnnotation& x) const
    {
        return (m_annotation_typeid == x.m_annotation_typeid &&
           m_param_seq == x.m_param_seq);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppliedAnnotation object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppliedAnnotation& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member annotation_typeid
     * @param _annotation_typeid New value to be copied in member annotation_typeid
     */
    eProsima_user_DllExport void annotation_typeid(
            const TypeIdentifier& _annotation_typeid)
    {
        m_annotation_typeid = _annotation_typeid;
    }

    /*!
     * @brief This function moves the value in member annotation_typeid
     * @param _annotation_typeid New value to be moved in member annotation_typeid
     */
    eProsima_user_DllExport void annotation_typeid(
            TypeIdentifier&& _annotation_typeid)
    {
        m_annotation_typeid = std::move(_annotation_typeid);
    }

    /*!
     * @brief This function returns a constant reference to member annotation_typeid
     * @return Constant reference to member annotation_typeid
     */
    eProsima_user_DllExport const TypeIdentifier& annotation_typeid() const
    {
        return m_annotation_typeid;
    }

    /*!
     * @brief This function returns a reference to member annotation_typeid
     * @return Reference to member annotation_typeid
     */
    eProsima_user_DllExport TypeIdentifier& annotation_typeid()
    {
        return m_annotation_typeid;
    }


    /*!
     * @brief This function copies the value in member param_seq
     * @param _param_seq New value to be copied in member param_seq
     */
    eProsima_user_DllExport void param_seq(
            const eprosima::fastcdr::optional<AppliedAnnotationParameterSeq>& _param_seq)
    {
        m_param_seq = _param_seq;
    }

    /*!
     * @brief This function moves the value in member param_seq
     * @param _param_seq New value to be moved in member param_seq
     */
    eProsima_user_DllExport void param_seq(
            eprosima::fastcdr::optional<AppliedAnnotationParameterSeq>&& _param_seq)
    {
        m_param_seq = std::move(_param_seq);
    }

    /*!
     * @brief This function returns a constant reference to member param_seq
     * @return Constant reference to member param_seq
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<AppliedAnnotationParameterSeq>& param_seq() const
    {
        return m_param_seq;
    }

    /*!
     * @brief This function returns a reference to member param_seq
     * @return Reference to member param_seq
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<AppliedAnnotationParameterSeq>& param_seq()
    {
        return m_param_seq;
    }



private:

    TypeIdentifier m_annotation_typeid;
    eprosima::fastcdr::optional<AppliedAnnotationParameterSeq> m_param_seq;

};
typedef std::vector<AppliedAnnotation> AppliedAnnotationSeq;

/*!
 * @brief This class represents the structure AppliedVerbatimAnnotation defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class AppliedVerbatimAnnotation
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppliedVerbatimAnnotation()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppliedVerbatimAnnotation()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppliedVerbatimAnnotation that will be copied.
     */
    eProsima_user_DllExport AppliedVerbatimAnnotation(
            const AppliedVerbatimAnnotation& x)
    {
                    m_placement = x.m_placement;

                    m_language = x.m_language;

                    m_text = x.m_text;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppliedVerbatimAnnotation that will be copied.
     */
    eProsima_user_DllExport AppliedVerbatimAnnotation(
            AppliedVerbatimAnnotation&& x) noexcept
    {
        m_placement = std::move(x.m_placement);
        m_language = std::move(x.m_language);
        m_text = std::move(x.m_text);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppliedVerbatimAnnotation that will be copied.
     */
    eProsima_user_DllExport AppliedVerbatimAnnotation& operator =(
            const AppliedVerbatimAnnotation& x)
    {

                    m_placement = x.m_placement;

                    m_language = x.m_language;

                    m_text = x.m_text;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppliedVerbatimAnnotation that will be copied.
     */
    eProsima_user_DllExport AppliedVerbatimAnnotation& operator =(
            AppliedVerbatimAnnotation&& x) noexcept
    {

        m_placement = std::move(x.m_placement);
        m_language = std::move(x.m_language);
        m_text = std::move(x.m_text);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppliedVerbatimAnnotation object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppliedVerbatimAnnotation& x) const
    {
        return (m_placement == x.m_placement &&
           m_language == x.m_language &&
           m_text == x.m_text);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppliedVerbatimAnnotation object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppliedVerbatimAnnotation& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member placement
     * @param _placement New value to be copied in member placement
     */
    eProsima_user_DllExport void placement(
            const eprosima::fastcdr::fixed_string<32>& _placement)
    {
        m_placement = _placement;
    }

    /*!
     * @brief This function moves the value in member placement
     * @param _placement New value to be moved in member placement
     */
    eProsima_user_DllExport void placement(
            eprosima::fastcdr::fixed_string<32>&& _placement)
    {
        m_placement = std::move(_placement);
    }

    /*!
     * @brief This function returns a constant reference to member placement
     * @return Constant reference to member placement
     */
    eProsima_user_DllExport const eprosima::fastcdr::fixed_string<32>& placement() const
    {
        return m_placement;
    }

    /*!
     * @brief This function returns a reference to member placement
     * @return Reference to member placement
     */
    eProsima_user_DllExport eprosima::fastcdr::fixed_string<32>& placement()
    {
        return m_placement;
    }


    /*!
     * @brief This function copies the value in member language
     * @param _language New value to be copied in member language
     */
    eProsima_user_DllExport void language(
            const eprosima::fastcdr::fixed_string<32>& _language)
    {
        m_language = _language;
    }

    /*!
     * @brief This function moves the value in member language
     * @param _language New value to be moved in member language
     */
    eProsima_user_DllExport void language(
            eprosima::fastcdr::fixed_string<32>&& _language)
    {
        m_language = std::move(_language);
    }

    /*!
     * @brief This function returns a constant reference to member language
     * @return Constant reference to member language
     */
    eProsima_user_DllExport const eprosima::fastcdr::fixed_string<32>& language() const
    {
        return m_language;
    }

    /*!
     * @brief This function returns a reference to member language
     * @return Reference to member language
     */
    eProsima_user_DllExport eprosima::fastcdr::fixed_string<32>& language()
    {
        return m_language;
    }


    /*!
     * @brief This function copies the value in member text
     * @param _text New value to be copied in member text
     */
    eProsima_user_DllExport void text(
            const std::string& _text)
    {
        m_text = _text;
    }

    /*!
     * @brief This function moves the value in member text
     * @param _text New value to be moved in member text
     */
    eProsima_user_DllExport void text(
            std::string&& _text)
    {
        m_text = std::move(_text);
    }

    /*!
     * @brief This function returns a constant reference to member text
     * @return Constant reference to member text
     */
    eProsima_user_DllExport const std::string& text() const
    {
        return m_text;
    }

    /*!
     * @brief This function returns a reference to member text
     * @return Reference to member text
     */
    eProsima_user_DllExport std::string& text()
    {
        return m_text;
    }



private:

    eprosima::fastcdr::fixed_string<32> m_placement;
    eprosima::fastcdr::fixed_string<32> m_language;
    std::string m_text;

};
/*!
 * @brief This class represents the structure AppliedBuiltinMemberAnnotations defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class AppliedBuiltinMemberAnnotations
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppliedBuiltinMemberAnnotations()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppliedBuiltinMemberAnnotations()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppliedBuiltinMemberAnnotations that will be copied.
     */
    eProsima_user_DllExport AppliedBuiltinMemberAnnotations(
            const AppliedBuiltinMemberAnnotations& x)
    {
                    m_unit = x.m_unit;

                    m_min = x.m_min;

                    m_max = x.m_max;

                    m_hash_id = x.m_hash_id;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppliedBuiltinMemberAnnotations that will be copied.
     */
    eProsima_user_DllExport AppliedBuiltinMemberAnnotations(
            AppliedBuiltinMemberAnnotations&& x) noexcept
    {
        m_unit = std::move(x.m_unit);
        m_min = std::move(x.m_min);
        m_max = std::move(x.m_max);
        m_hash_id = std::move(x.m_hash_id);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppliedBuiltinMemberAnnotations that will be copied.
     */
    eProsima_user_DllExport AppliedBuiltinMemberAnnotations& operator =(
            const AppliedBuiltinMemberAnnotations& x)
    {

                    m_unit = x.m_unit;

                    m_min = x.m_min;

                    m_max = x.m_max;

                    m_hash_id = x.m_hash_id;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppliedBuiltinMemberAnnotations that will be copied.
     */
    eProsima_user_DllExport AppliedBuiltinMemberAnnotations& operator =(
            AppliedBuiltinMemberAnnotations&& x) noexcept
    {

        m_unit = std::move(x.m_unit);
        m_min = std::move(x.m_min);
        m_max = std::move(x.m_max);
        m_hash_id = std::move(x.m_hash_id);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppliedBuiltinMemberAnnotations object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppliedBuiltinMemberAnnotations& x) const
    {
        return (m_unit == x.m_unit &&
           m_min == x.m_min &&
           m_max == x.m_max &&
           m_hash_id == x.m_hash_id);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppliedBuiltinMemberAnnotations object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppliedBuiltinMemberAnnotations& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member unit
     * @param _unit New value to be copied in member unit
     */
    eProsima_user_DllExport void unit(
            const eprosima::fastcdr::optional<std::string>& _unit)
    {
        m_unit = _unit;
    }

    /*!
     * @brief This function moves the value in member unit
     * @param _unit New value to be moved in member unit
     */
    eProsima_user_DllExport void unit(
            eprosima::fastcdr::optional<std::string>&& _unit)
    {
        m_unit = std::move(_unit);
    }

    /*!
     * @brief This function returns a constant reference to member unit
     * @return Constant reference to member unit
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<std::string>& unit() const
    {
        return m_unit;
    }

    /*!
     * @brief This function returns a reference to member unit
     * @return Reference to member unit
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<std::string>& unit()
    {
        return m_unit;
    }


    /*!
     * @brief This function copies the value in member min
     * @param _min New value to be copied in member min
     */
    eProsima_user_DllExport void min(
            const eprosima::fastcdr::optional<AnnotationParameterValue>& _min)
    {
        m_min = _min;
    }

    /*!
     * @brief This function moves the value in member min
     * @param _min New value to be moved in member min
     */
    eProsima_user_DllExport void min(
            eprosima::fastcdr::optional<AnnotationParameterValue>&& _min)
    {
        m_min = std::move(_min);
    }

    /*!
     * @brief This function returns a constant reference to member min
     * @return Constant reference to member min
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<AnnotationParameterValue>& min() const
    {
        return m_min;
    }

    /*!
     * @brief This function returns a reference to member min
     * @return Reference to member min
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<AnnotationParameterValue>& min()
    {
        return m_min;
    }


    /*!
     * @brief This function copies the value in member max
     * @param _max New value to be copied in member max
     */
    eProsima_user_DllExport void max(
            const eprosima::fastcdr::optional<AnnotationParameterValue>& _max)
    {
        m_max = _max;
    }

    /*!
     * @brief This function moves the value in member max
     * @param _max New value to be moved in member max
     */
    eProsima_user_DllExport void max(
            eprosima::fastcdr::optional<AnnotationParameterValue>&& _max)
    {
        m_max = std::move(_max);
    }

    /*!
     * @brief This function returns a constant reference to member max
     * @return Constant reference to member max
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<AnnotationParameterValue>& max() const
    {
        return m_max;
    }

    /*!
     * @brief This function returns a reference to member max
     * @return Reference to member max
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<AnnotationParameterValue>& max()
    {
        return m_max;
    }


    /*!
     * @brief This function copies the value in member hash_id
     * @param _hash_id New value to be copied in member hash_id
     */
    eProsima_user_DllExport void hash_id(
            const eprosima::fastcdr::optional<std::string>& _hash_id)
    {
        m_hash_id = _hash_id;
    }

    /*!
     * @brief This function moves the value in member hash_id
     * @param _hash_id New value to be moved in member hash_id
     */
    eProsima_user_DllExport void hash_id(
            eprosima::fastcdr::optional<std::string>&& _hash_id)
    {
        m_hash_id = std::move(_hash_id);
    }

    /*!
     * @brief This function returns a constant reference to member hash_id
     * @return Constant reference to member hash_id
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<std::string>& hash_id() const
    {
        return m_hash_id;
    }

    /*!
     * @brief This function returns a reference to member hash_id
     * @return Reference to member hash_id
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<std::string>& hash_id()
    {
        return m_hash_id;
    }



private:

    eprosima::fastcdr::optional<std::string> m_unit;
    eprosima::fastcdr::optional<AnnotationParameterValue> m_min;
    eprosima::fastcdr::optional<AnnotationParameterValue> m_max;
    eprosima::fastcdr::optional<std::string> m_hash_id;

};
/*!
 * @brief This class represents the structure CommonStructMember defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CommonStructMember
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CommonStructMember()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CommonStructMember()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CommonStructMember that will be copied.
     */
    eProsima_user_DllExport CommonStructMember(
            const CommonStructMember& x)
    {
                    m_member_id = x.m_member_id;

                    m_member_flags = x.m_member_flags;

                    m_member_type_id = x.m_member_type_id;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CommonStructMember that will be copied.
     */
    eProsima_user_DllExport CommonStructMember(
            CommonStructMember&& x) noexcept
    {
        m_member_id = x.m_member_id;
        m_member_flags = std::move(x.m_member_flags);
        m_member_type_id = std::move(x.m_member_type_id);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CommonStructMember that will be copied.
     */
    eProsima_user_DllExport CommonStructMember& operator =(
            const CommonStructMember& x)
    {

                    m_member_id = x.m_member_id;

                    m_member_flags = x.m_member_flags;

                    m_member_type_id = x.m_member_type_id;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CommonStructMember that will be copied.
     */
    eProsima_user_DllExport CommonStructMember& operator =(
            CommonStructMember&& x) noexcept
    {

        m_member_id = x.m_member_id;
        m_member_flags = std::move(x.m_member_flags);
        m_member_type_id = std::move(x.m_member_type_id);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonStructMember object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CommonStructMember& x) const
    {
        return (m_member_id == x.m_member_id &&
           m_member_flags == x.m_member_flags &&
           m_member_type_id == x.m_member_type_id);
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonStructMember object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CommonStructMember& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member member_id
     * @param _member_id New value for member member_id
     */
    eProsima_user_DllExport void member_id(
            MemberId _member_id)
    {
        m_member_id = _member_id;
    }

    /*!
     * @brief This function returns the value of member member_id
     * @return Value of member member_id
     */
    eProsima_user_DllExport MemberId member_id() const
    {
        return m_member_id;
    }

    /*!
     * @brief This function returns a reference to member member_id
     * @return Reference to member member_id
     */
    eProsima_user_DllExport MemberId& member_id()
    {
        return m_member_id;
    }


    /*!
     * @brief This function copies the value in member member_flags
     * @param _member_flags New value to be copied in member member_flags
     */
    eProsima_user_DllExport void member_flags(
            const StructMemberFlag& _member_flags)
    {
        m_member_flags = _member_flags;
    }

    /*!
     * @brief This function moves the value in member member_flags
     * @param _member_flags New value to be moved in member member_flags
     */
    eProsima_user_DllExport void member_flags(
            StructMemberFlag&& _member_flags)
    {
        m_member_flags = std::move(_member_flags);
    }

    /*!
     * @brief This function returns a constant reference to member member_flags
     * @return Constant reference to member member_flags
     */
    eProsima_user_DllExport const StructMemberFlag& member_flags() const
    {
        return m_member_flags;
    }

    /*!
     * @brief This function returns a reference to member member_flags
     * @return Reference to member member_flags
     */
    eProsima_user_DllExport StructMemberFlag& member_flags()
    {
        return m_member_flags;
    }


    /*!
     * @brief This function copies the value in member member_type_id
     * @param _member_type_id New value to be copied in member member_type_id
     */
    eProsima_user_DllExport void member_type_id(
            const TypeIdentifier& _member_type_id)
    {
        m_member_type_id = _member_type_id;
    }

    /*!
     * @brief This function moves the value in member member_type_id
     * @param _member_type_id New value to be moved in member member_type_id
     */
    eProsima_user_DllExport void member_type_id(
            TypeIdentifier&& _member_type_id)
    {
        m_member_type_id = std::move(_member_type_id);
    }

    /*!
     * @brief This function returns a constant reference to member member_type_id
     * @return Constant reference to member member_type_id
     */
    eProsima_user_DllExport const TypeIdentifier& member_type_id() const
    {
        return m_member_type_id;
    }

    /*!
     * @brief This function returns a reference to member member_type_id
     * @return Reference to member member_type_id
     */
    eProsima_user_DllExport TypeIdentifier& member_type_id()
    {
        return m_member_type_id;
    }



private:

    MemberId m_member_id{0};
    StructMemberFlag m_member_flags{0};
    TypeIdentifier m_member_type_id;

};
/*!
 * @brief This class represents the structure CompleteMemberDetail defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteMemberDetail
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteMemberDetail()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteMemberDetail()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteMemberDetail that will be copied.
     */
    eProsima_user_DllExport CompleteMemberDetail(
            const CompleteMemberDetail& x)
    {
                    m_name = x.m_name;

                    m_ann_builtin = x.m_ann_builtin;

                    m_ann_custom = x.m_ann_custom;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteMemberDetail that will be copied.
     */
    eProsima_user_DllExport CompleteMemberDetail(
            CompleteMemberDetail&& x) noexcept
    {
        m_name = std::move(x.m_name);
        m_ann_builtin = std::move(x.m_ann_builtin);
        m_ann_custom = std::move(x.m_ann_custom);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteMemberDetail that will be copied.
     */
    eProsima_user_DllExport CompleteMemberDetail& operator =(
            const CompleteMemberDetail& x)
    {

                    m_name = x.m_name;

                    m_ann_builtin = x.m_ann_builtin;

                    m_ann_custom = x.m_ann_custom;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteMemberDetail that will be copied.
     */
    eProsima_user_DllExport CompleteMemberDetail& operator =(
            CompleteMemberDetail&& x) noexcept
    {

        m_name = std::move(x.m_name);
        m_ann_builtin = std::move(x.m_ann_builtin);
        m_ann_custom = std::move(x.m_ann_custom);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteMemberDetail object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteMemberDetail& x) const
    {
        return (m_name == x.m_name &&
           m_ann_builtin == x.m_ann_builtin &&
           m_ann_custom == x.m_ann_custom);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteMemberDetail object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteMemberDetail& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member name
     * @param _name New value to be copied in member name
     */
    eProsima_user_DllExport void name(
            const MemberName& _name)
    {
        m_name = _name;
    }

    /*!
     * @brief This function moves the value in member name
     * @param _name New value to be moved in member name
     */
    eProsima_user_DllExport void name(
            MemberName&& _name)
    {
        m_name = std::move(_name);
    }

    /*!
     * @brief This function returns a constant reference to member name
     * @return Constant reference to member name
     */
    eProsima_user_DllExport const MemberName& name() const
    {
        return m_name;
    }

    /*!
     * @brief This function returns a reference to member name
     * @return Reference to member name
     */
    eProsima_user_DllExport MemberName& name()
    {
        return m_name;
    }


    /*!
     * @brief This function copies the value in member ann_builtin
     * @param _ann_builtin New value to be copied in member ann_builtin
     */
    eProsima_user_DllExport void ann_builtin(
            const eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations>& _ann_builtin)
    {
        m_ann_builtin = _ann_builtin;
    }

    /*!
     * @brief This function moves the value in member ann_builtin
     * @param _ann_builtin New value to be moved in member ann_builtin
     */
    eProsima_user_DllExport void ann_builtin(
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations>&& _ann_builtin)
    {
        m_ann_builtin = std::move(_ann_builtin);
    }

    /*!
     * @brief This function returns a constant reference to member ann_builtin
     * @return Constant reference to member ann_builtin
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations>& ann_builtin() const
    {
        return m_ann_builtin;
    }

    /*!
     * @brief This function returns a reference to member ann_builtin
     * @return Reference to member ann_builtin
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations>& ann_builtin()
    {
        return m_ann_builtin;
    }


    /*!
     * @brief This function copies the value in member ann_custom
     * @param _ann_custom New value to be copied in member ann_custom
     */
    eProsima_user_DllExport void ann_custom(
            const eprosima::fastcdr::optional<AppliedAnnotationSeq>& _ann_custom)
    {
        m_ann_custom = _ann_custom;
    }

    /*!
     * @brief This function moves the value in member ann_custom
     * @param _ann_custom New value to be moved in member ann_custom
     */
    eProsima_user_DllExport void ann_custom(
            eprosima::fastcdr::optional<AppliedAnnotationSeq>&& _ann_custom)
    {
        m_ann_custom = std::move(_ann_custom);
    }

    /*!
     * @brief This function returns a constant reference to member ann_custom
     * @return Constant reference to member ann_custom
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<AppliedAnnotationSeq>& ann_custom() const
    {
        return m_ann_custom;
    }

    /*!
     * @brief This function returns a reference to member ann_custom
     * @return Reference to member ann_custom
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<AppliedAnnotationSeq>& ann_custom()
    {
        return m_ann_custom;
    }



private:

    MemberName m_name;
    eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> m_ann_builtin;
    eprosima::fastcdr::optional<AppliedAnnotationSeq> m_ann_custom;

};
/*!
 * @brief This class represents the structure MinimalMemberDetail defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalMemberDetail
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalMemberDetail()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalMemberDetail()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalMemberDetail that will be copied.
     */
    eProsima_user_DllExport MinimalMemberDetail(
            const MinimalMemberDetail& x)
    {
                    m_name_hash = x.m_name_hash;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalMemberDetail that will be copied.
     */
    eProsima_user_DllExport MinimalMemberDetail(
            MinimalMemberDetail&& x) noexcept
    {
        m_name_hash = std::move(x.m_name_hash);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalMemberDetail that will be copied.
     */
    eProsima_user_DllExport MinimalMemberDetail& operator =(
            const MinimalMemberDetail& x)
    {

                    m_name_hash = x.m_name_hash;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalMemberDetail that will be copied.
     */
    eProsima_user_DllExport MinimalMemberDetail& operator =(
            MinimalMemberDetail&& x) noexcept
    {

        m_name_hash = std::move(x.m_name_hash);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalMemberDetail object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalMemberDetail& x) const
    {
        return (m_name_hash == x.m_name_hash);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalMemberDetail object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalMemberDetail& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member name_hash
     * @param _name_hash New value to be copied in member name_hash
     */
    eProsima_user_DllExport void name_hash(
            const NameHash& _name_hash)
    {
        m_name_hash = _name_hash;
    }

    /*!
     * @brief This function moves the value in member name_hash
     * @param _name_hash New value to be moved in member name_hash
     */
    eProsima_user_DllExport void name_hash(
            NameHash&& _name_hash)
    {
        m_name_hash = std::move(_name_hash);
    }

    /*!
     * @brief This function returns a constant reference to member name_hash
     * @return Constant reference to member name_hash
     */
    eProsima_user_DllExport const NameHash& name_hash() const
    {
        return m_name_hash;
    }

    /*!
     * @brief This function returns a reference to member name_hash
     * @return Reference to member name_hash
     */
    eProsima_user_DllExport NameHash& name_hash()
    {
        return m_name_hash;
    }



private:

    NameHash m_name_hash{0};

};
/*!
 * @brief This class represents the structure CompleteStructMember defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteStructMember
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteStructMember()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteStructMember()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteStructMember that will be copied.
     */
    eProsima_user_DllExport CompleteStructMember(
            const CompleteStructMember& x)
    {
                    m_common = x.m_common;

                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteStructMember that will be copied.
     */
    eProsima_user_DllExport CompleteStructMember(
            CompleteStructMember&& x) noexcept
    {
        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteStructMember that will be copied.
     */
    eProsima_user_DllExport CompleteStructMember& operator =(
            const CompleteStructMember& x)
    {

                    m_common = x.m_common;

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteStructMember that will be copied.
     */
    eProsima_user_DllExport CompleteStructMember& operator =(
            CompleteStructMember&& x) noexcept
    {

        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteStructMember object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteStructMember& x) const
    {
        return (m_common == x.m_common &&
           m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteStructMember object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteStructMember& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonStructMember& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonStructMember&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonStructMember& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonStructMember& common()
    {
        return m_common;
    }


    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const CompleteMemberDetail& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            CompleteMemberDetail&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const CompleteMemberDetail& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport CompleteMemberDetail& detail()
    {
        return m_detail;
    }



private:

    CommonStructMember m_common;
    CompleteMemberDetail m_detail;

};
typedef std::vector<CompleteStructMember> CompleteStructMemberSeq;

/*!
 * @brief This class represents the structure MinimalStructMember defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalStructMember
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalStructMember()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalStructMember()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalStructMember that will be copied.
     */
    eProsima_user_DllExport MinimalStructMember(
            const MinimalStructMember& x)
    {
                    m_common = x.m_common;

                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalStructMember that will be copied.
     */
    eProsima_user_DllExport MinimalStructMember(
            MinimalStructMember&& x) noexcept
    {
        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalStructMember that will be copied.
     */
    eProsima_user_DllExport MinimalStructMember& operator =(
            const MinimalStructMember& x)
    {

                    m_common = x.m_common;

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalStructMember that will be copied.
     */
    eProsima_user_DllExport MinimalStructMember& operator =(
            MinimalStructMember&& x) noexcept
    {

        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalStructMember object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalStructMember& x) const
    {
        return (m_common == x.m_common &&
           m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalStructMember object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalStructMember& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonStructMember& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonStructMember&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonStructMember& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonStructMember& common()
    {
        return m_common;
    }


    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const MinimalMemberDetail& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            MinimalMemberDetail&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const MinimalMemberDetail& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport MinimalMemberDetail& detail()
    {
        return m_detail;
    }



private:

    CommonStructMember m_common;
    MinimalMemberDetail m_detail;

};
typedef std::vector<MinimalStructMember> MinimalStructMemberSeq;

/*!
 * @brief This class represents the structure AppliedBuiltinTypeAnnotations defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class AppliedBuiltinTypeAnnotations
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppliedBuiltinTypeAnnotations()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppliedBuiltinTypeAnnotations()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppliedBuiltinTypeAnnotations that will be copied.
     */
    eProsima_user_DllExport AppliedBuiltinTypeAnnotations(
            const AppliedBuiltinTypeAnnotations& x)
    {
                    m_verbatim = x.m_verbatim;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppliedBuiltinTypeAnnotations that will be copied.
     */
    eProsima_user_DllExport AppliedBuiltinTypeAnnotations(
            AppliedBuiltinTypeAnnotations&& x) noexcept
    {
        m_verbatim = std::move(x.m_verbatim);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppliedBuiltinTypeAnnotations that will be copied.
     */
    eProsima_user_DllExport AppliedBuiltinTypeAnnotations& operator =(
            const AppliedBuiltinTypeAnnotations& x)
    {

                    m_verbatim = x.m_verbatim;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppliedBuiltinTypeAnnotations that will be copied.
     */
    eProsima_user_DllExport AppliedBuiltinTypeAnnotations& operator =(
            AppliedBuiltinTypeAnnotations&& x) noexcept
    {

        m_verbatim = std::move(x.m_verbatim);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppliedBuiltinTypeAnnotations object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppliedBuiltinTypeAnnotations& x) const
    {
        return (m_verbatim == x.m_verbatim);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppliedBuiltinTypeAnnotations object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppliedBuiltinTypeAnnotations& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member verbatim
     * @param _verbatim New value to be copied in member verbatim
     */
    eProsima_user_DllExport void verbatim(
            const eprosima::fastcdr::optional<AppliedVerbatimAnnotation>& _verbatim)
    {
        m_verbatim = _verbatim;
    }

    /*!
     * @brief This function moves the value in member verbatim
     * @param _verbatim New value to be moved in member verbatim
     */
    eProsima_user_DllExport void verbatim(
            eprosima::fastcdr::optional<AppliedVerbatimAnnotation>&& _verbatim)
    {
        m_verbatim = std::move(_verbatim);
    }

    /*!
     * @brief This function returns a constant reference to member verbatim
     * @return Constant reference to member verbatim
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<AppliedVerbatimAnnotation>& verbatim() const
    {
        return m_verbatim;
    }

    /*!
     * @brief This function returns a reference to member verbatim
     * @return Reference to member verbatim
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<AppliedVerbatimAnnotation>& verbatim()
    {
        return m_verbatim;
    }



private:

    eprosima::fastcdr::optional<AppliedVerbatimAnnotation> m_verbatim;

};
/*!
 * @brief This class represents the structure MinimalTypeDetail defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalTypeDetail
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalTypeDetail()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalTypeDetail()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalTypeDetail that will be copied.
     */
    eProsima_user_DllExport MinimalTypeDetail(
            const MinimalTypeDetail& x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalTypeDetail that will be copied.
     */
    eProsima_user_DllExport MinimalTypeDetail(
            MinimalTypeDetail&& x) noexcept
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalTypeDetail that will be copied.
     */
    eProsima_user_DllExport MinimalTypeDetail& operator =(
            const MinimalTypeDetail& x)
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalTypeDetail that will be copied.
     */
    eProsima_user_DllExport MinimalTypeDetail& operator =(
            MinimalTypeDetail&& x) noexcept
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalTypeDetail object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalTypeDetail& x) const
    {
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalTypeDetail object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalTypeDetail& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the structure CompleteTypeDetail defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteTypeDetail
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteTypeDetail()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteTypeDetail()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteTypeDetail that will be copied.
     */
    eProsima_user_DllExport CompleteTypeDetail(
            const CompleteTypeDetail& x)
    {
                    m_ann_builtin = x.m_ann_builtin;

                    m_ann_custom = x.m_ann_custom;

                    m_type_name = x.m_type_name;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteTypeDetail that will be copied.
     */
    eProsima_user_DllExport CompleteTypeDetail(
            CompleteTypeDetail&& x) noexcept
    {
        m_ann_builtin = std::move(x.m_ann_builtin);
        m_ann_custom = std::move(x.m_ann_custom);
        m_type_name = std::move(x.m_type_name);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteTypeDetail that will be copied.
     */
    eProsima_user_DllExport CompleteTypeDetail& operator =(
            const CompleteTypeDetail& x)
    {

                    m_ann_builtin = x.m_ann_builtin;

                    m_ann_custom = x.m_ann_custom;

                    m_type_name = x.m_type_name;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteTypeDetail that will be copied.
     */
    eProsima_user_DllExport CompleteTypeDetail& operator =(
            CompleteTypeDetail&& x) noexcept
    {

        m_ann_builtin = std::move(x.m_ann_builtin);
        m_ann_custom = std::move(x.m_ann_custom);
        m_type_name = std::move(x.m_type_name);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteTypeDetail object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteTypeDetail& x) const
    {
        return (m_ann_builtin == x.m_ann_builtin &&
           m_ann_custom == x.m_ann_custom &&
           m_type_name == x.m_type_name);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteTypeDetail object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteTypeDetail& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member ann_builtin
     * @param _ann_builtin New value to be copied in member ann_builtin
     */
    eProsima_user_DllExport void ann_builtin(
            const eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations>& _ann_builtin)
    {
        m_ann_builtin = _ann_builtin;
    }

    /*!
     * @brief This function moves the value in member ann_builtin
     * @param _ann_builtin New value to be moved in member ann_builtin
     */
    eProsima_user_DllExport void ann_builtin(
            eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations>&& _ann_builtin)
    {
        m_ann_builtin = std::move(_ann_builtin);
    }

    /*!
     * @brief This function returns a constant reference to member ann_builtin
     * @return Constant reference to member ann_builtin
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations>& ann_builtin() const
    {
        return m_ann_builtin;
    }

    /*!
     * @brief This function returns a reference to member ann_builtin
     * @return Reference to member ann_builtin
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations>& ann_builtin()
    {
        return m_ann_builtin;
    }


    /*!
     * @brief This function copies the value in member ann_custom
     * @param _ann_custom New value to be copied in member ann_custom
     */
    eProsima_user_DllExport void ann_custom(
            const eprosima::fastcdr::optional<AppliedAnnotationSeq>& _ann_custom)
    {
        m_ann_custom = _ann_custom;
    }

    /*!
     * @brief This function moves the value in member ann_custom
     * @param _ann_custom New value to be moved in member ann_custom
     */
    eProsima_user_DllExport void ann_custom(
            eprosima::fastcdr::optional<AppliedAnnotationSeq>&& _ann_custom)
    {
        m_ann_custom = std::move(_ann_custom);
    }

    /*!
     * @brief This function returns a constant reference to member ann_custom
     * @return Constant reference to member ann_custom
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<AppliedAnnotationSeq>& ann_custom() const
    {
        return m_ann_custom;
    }

    /*!
     * @brief This function returns a reference to member ann_custom
     * @return Reference to member ann_custom
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<AppliedAnnotationSeq>& ann_custom()
    {
        return m_ann_custom;
    }


    /*!
     * @brief This function copies the value in member type_name
     * @param _type_name New value to be copied in member type_name
     */
    eProsima_user_DllExport void type_name(
            const QualifiedTypeName& _type_name)
    {
        m_type_name = _type_name;
    }

    /*!
     * @brief This function moves the value in member type_name
     * @param _type_name New value to be moved in member type_name
     */
    eProsima_user_DllExport void type_name(
            QualifiedTypeName&& _type_name)
    {
        m_type_name = std::move(_type_name);
    }

    /*!
     * @brief This function returns a constant reference to member type_name
     * @return Constant reference to member type_name
     */
    eProsima_user_DllExport const QualifiedTypeName& type_name() const
    {
        return m_type_name;
    }

    /*!
     * @brief This function returns a reference to member type_name
     * @return Reference to member type_name
     */
    eProsima_user_DllExport QualifiedTypeName& type_name()
    {
        return m_type_name;
    }



private:

    eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> m_ann_builtin;
    eprosima::fastcdr::optional<AppliedAnnotationSeq> m_ann_custom;
    QualifiedTypeName m_type_name;

};
/*!
 * @brief This class represents the structure CompleteStructHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteStructHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteStructHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteStructHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteStructHeader that will be copied.
     */
    eProsima_user_DllExport CompleteStructHeader(
            const CompleteStructHeader& x)
    {
                    m_base_type = x.m_base_type;

                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteStructHeader that will be copied.
     */
    eProsima_user_DllExport CompleteStructHeader(
            CompleteStructHeader&& x) noexcept
    {
        m_base_type = std::move(x.m_base_type);
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteStructHeader that will be copied.
     */
    eProsima_user_DllExport CompleteStructHeader& operator =(
            const CompleteStructHeader& x)
    {

                    m_base_type = x.m_base_type;

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteStructHeader that will be copied.
     */
    eProsima_user_DllExport CompleteStructHeader& operator =(
            CompleteStructHeader&& x) noexcept
    {

        m_base_type = std::move(x.m_base_type);
        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteStructHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteStructHeader& x) const
    {
        return (m_base_type == x.m_base_type &&
           m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteStructHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteStructHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member base_type
     * @param _base_type New value to be copied in member base_type
     */
    eProsima_user_DllExport void base_type(
            const TypeIdentifier& _base_type)
    {
        m_base_type = _base_type;
    }

    /*!
     * @brief This function moves the value in member base_type
     * @param _base_type New value to be moved in member base_type
     */
    eProsima_user_DllExport void base_type(
            TypeIdentifier&& _base_type)
    {
        m_base_type = std::move(_base_type);
    }

    /*!
     * @brief This function returns a constant reference to member base_type
     * @return Constant reference to member base_type
     */
    eProsima_user_DllExport const TypeIdentifier& base_type() const
    {
        return m_base_type;
    }

    /*!
     * @brief This function returns a reference to member base_type
     * @return Reference to member base_type
     */
    eProsima_user_DllExport TypeIdentifier& base_type()
    {
        return m_base_type;
    }


    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const CompleteTypeDetail& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            CompleteTypeDetail&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const CompleteTypeDetail& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport CompleteTypeDetail& detail()
    {
        return m_detail;
    }



private:

    TypeIdentifier m_base_type;
    CompleteTypeDetail m_detail;

};
/*!
 * @brief This class represents the structure MinimalStructHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalStructHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalStructHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalStructHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalStructHeader that will be copied.
     */
    eProsima_user_DllExport MinimalStructHeader(
            const MinimalStructHeader& x)
    {
                    m_base_type = x.m_base_type;

                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalStructHeader that will be copied.
     */
    eProsima_user_DllExport MinimalStructHeader(
            MinimalStructHeader&& x) noexcept
    {
        m_base_type = std::move(x.m_base_type);
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalStructHeader that will be copied.
     */
    eProsima_user_DllExport MinimalStructHeader& operator =(
            const MinimalStructHeader& x)
    {

                    m_base_type = x.m_base_type;

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalStructHeader that will be copied.
     */
    eProsima_user_DllExport MinimalStructHeader& operator =(
            MinimalStructHeader&& x) noexcept
    {

        m_base_type = std::move(x.m_base_type);
        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalStructHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalStructHeader& x) const
    {
        return (m_base_type == x.m_base_type &&
           m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalStructHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalStructHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member base_type
     * @param _base_type New value to be copied in member base_type
     */
    eProsima_user_DllExport void base_type(
            const TypeIdentifier& _base_type)
    {
        m_base_type = _base_type;
    }

    /*!
     * @brief This function moves the value in member base_type
     * @param _base_type New value to be moved in member base_type
     */
    eProsima_user_DllExport void base_type(
            TypeIdentifier&& _base_type)
    {
        m_base_type = std::move(_base_type);
    }

    /*!
     * @brief This function returns a constant reference to member base_type
     * @return Constant reference to member base_type
     */
    eProsima_user_DllExport const TypeIdentifier& base_type() const
    {
        return m_base_type;
    }

    /*!
     * @brief This function returns a reference to member base_type
     * @return Reference to member base_type
     */
    eProsima_user_DllExport TypeIdentifier& base_type()
    {
        return m_base_type;
    }


    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const MinimalTypeDetail& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            MinimalTypeDetail&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const MinimalTypeDetail& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport MinimalTypeDetail& detail()
    {
        return m_detail;
    }



private:

    TypeIdentifier m_base_type;
    MinimalTypeDetail m_detail;

};
/*!
 * @brief This class represents the structure CompleteStructType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteStructType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteStructType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteStructType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteStructType that will be copied.
     */
    eProsima_user_DllExport CompleteStructType(
            const CompleteStructType& x)
    {
                    m_struct_flags = x.m_struct_flags;

                    m_header = x.m_header;

                    m_member_seq = x.m_member_seq;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteStructType that will be copied.
     */
    eProsima_user_DllExport CompleteStructType(
            CompleteStructType&& x) noexcept
    {
        m_struct_flags = std::move(x.m_struct_flags);
        m_header = std::move(x.m_header);
        m_member_seq = std::move(x.m_member_seq);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteStructType that will be copied.
     */
    eProsima_user_DllExport CompleteStructType& operator =(
            const CompleteStructType& x)
    {

                    m_struct_flags = x.m_struct_flags;

                    m_header = x.m_header;

                    m_member_seq = x.m_member_seq;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteStructType that will be copied.
     */
    eProsima_user_DllExport CompleteStructType& operator =(
            CompleteStructType&& x) noexcept
    {

        m_struct_flags = std::move(x.m_struct_flags);
        m_header = std::move(x.m_header);
        m_member_seq = std::move(x.m_member_seq);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteStructType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteStructType& x) const
    {
        return (m_struct_flags == x.m_struct_flags &&
           m_header == x.m_header &&
           m_member_seq == x.m_member_seq);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteStructType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteStructType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member struct_flags
     * @param _struct_flags New value to be copied in member struct_flags
     */
    eProsima_user_DllExport void struct_flags(
            const StructTypeFlag& _struct_flags)
    {
        m_struct_flags = _struct_flags;
    }

    /*!
     * @brief This function moves the value in member struct_flags
     * @param _struct_flags New value to be moved in member struct_flags
     */
    eProsima_user_DllExport void struct_flags(
            StructTypeFlag&& _struct_flags)
    {
        m_struct_flags = std::move(_struct_flags);
    }

    /*!
     * @brief This function returns a constant reference to member struct_flags
     * @return Constant reference to member struct_flags
     */
    eProsima_user_DllExport const StructTypeFlag& struct_flags() const
    {
        return m_struct_flags;
    }

    /*!
     * @brief This function returns a reference to member struct_flags
     * @return Reference to member struct_flags
     */
    eProsima_user_DllExport StructTypeFlag& struct_flags()
    {
        return m_struct_flags;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const CompleteStructHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            CompleteStructHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const CompleteStructHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport CompleteStructHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member member_seq
     * @param _member_seq New value to be copied in member member_seq
     */
    eProsima_user_DllExport void member_seq(
            const CompleteStructMemberSeq& _member_seq)
    {
        m_member_seq = _member_seq;
    }

    /*!
     * @brief This function moves the value in member member_seq
     * @param _member_seq New value to be moved in member member_seq
     */
    eProsima_user_DllExport void member_seq(
            CompleteStructMemberSeq&& _member_seq)
    {
        m_member_seq = std::move(_member_seq);
    }

    /*!
     * @brief This function returns a constant reference to member member_seq
     * @return Constant reference to member member_seq
     */
    eProsima_user_DllExport const CompleteStructMemberSeq& member_seq() const
    {
        return m_member_seq;
    }

    /*!
     * @brief This function returns a reference to member member_seq
     * @return Reference to member member_seq
     */
    eProsima_user_DllExport CompleteStructMemberSeq& member_seq()
    {
        return m_member_seq;
    }



private:

    StructTypeFlag m_struct_flags{0};
    CompleteStructHeader m_header;
    CompleteStructMemberSeq m_member_seq;

};
/*!
 * @brief This class represents the structure MinimalStructType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalStructType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalStructType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalStructType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalStructType that will be copied.
     */
    eProsima_user_DllExport MinimalStructType(
            const MinimalStructType& x)
    {
                    m_struct_flags = x.m_struct_flags;

                    m_header = x.m_header;

                    m_member_seq = x.m_member_seq;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalStructType that will be copied.
     */
    eProsima_user_DllExport MinimalStructType(
            MinimalStructType&& x) noexcept
    {
        m_struct_flags = std::move(x.m_struct_flags);
        m_header = std::move(x.m_header);
        m_member_seq = std::move(x.m_member_seq);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalStructType that will be copied.
     */
    eProsima_user_DllExport MinimalStructType& operator =(
            const MinimalStructType& x)
    {

                    m_struct_flags = x.m_struct_flags;

                    m_header = x.m_header;

                    m_member_seq = x.m_member_seq;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalStructType that will be copied.
     */
    eProsima_user_DllExport MinimalStructType& operator =(
            MinimalStructType&& x) noexcept
    {

        m_struct_flags = std::move(x.m_struct_flags);
        m_header = std::move(x.m_header);
        m_member_seq = std::move(x.m_member_seq);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalStructType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalStructType& x) const
    {
        return (m_struct_flags == x.m_struct_flags &&
           m_header == x.m_header &&
           m_member_seq == x.m_member_seq);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalStructType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalStructType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member struct_flags
     * @param _struct_flags New value to be copied in member struct_flags
     */
    eProsima_user_DllExport void struct_flags(
            const StructTypeFlag& _struct_flags)
    {
        m_struct_flags = _struct_flags;
    }

    /*!
     * @brief This function moves the value in member struct_flags
     * @param _struct_flags New value to be moved in member struct_flags
     */
    eProsima_user_DllExport void struct_flags(
            StructTypeFlag&& _struct_flags)
    {
        m_struct_flags = std::move(_struct_flags);
    }

    /*!
     * @brief This function returns a constant reference to member struct_flags
     * @return Constant reference to member struct_flags
     */
    eProsima_user_DllExport const StructTypeFlag& struct_flags() const
    {
        return m_struct_flags;
    }

    /*!
     * @brief This function returns a reference to member struct_flags
     * @return Reference to member struct_flags
     */
    eProsima_user_DllExport StructTypeFlag& struct_flags()
    {
        return m_struct_flags;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const MinimalStructHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            MinimalStructHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const MinimalStructHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport MinimalStructHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member member_seq
     * @param _member_seq New value to be copied in member member_seq
     */
    eProsima_user_DllExport void member_seq(
            const MinimalStructMemberSeq& _member_seq)
    {
        m_member_seq = _member_seq;
    }

    /*!
     * @brief This function moves the value in member member_seq
     * @param _member_seq New value to be moved in member member_seq
     */
    eProsima_user_DllExport void member_seq(
            MinimalStructMemberSeq&& _member_seq)
    {
        m_member_seq = std::move(_member_seq);
    }

    /*!
     * @brief This function returns a constant reference to member member_seq
     * @return Constant reference to member member_seq
     */
    eProsima_user_DllExport const MinimalStructMemberSeq& member_seq() const
    {
        return m_member_seq;
    }

    /*!
     * @brief This function returns a reference to member member_seq
     * @return Reference to member member_seq
     */
    eProsima_user_DllExport MinimalStructMemberSeq& member_seq()
    {
        return m_member_seq;
    }



private:

    StructTypeFlag m_struct_flags{0};
    MinimalStructHeader m_header;
    MinimalStructMemberSeq m_member_seq;

};
typedef std::vector<int32_t> UnionCaseLabelSeq;

/*!
 * @brief This class represents the structure CommonUnionMember defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CommonUnionMember
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CommonUnionMember()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CommonUnionMember()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CommonUnionMember that will be copied.
     */
    eProsima_user_DllExport CommonUnionMember(
            const CommonUnionMember& x)
    {
                    m_member_id = x.m_member_id;

                    m_member_flags = x.m_member_flags;

                    m_type_id = x.m_type_id;

                    m_label_seq = x.m_label_seq;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CommonUnionMember that will be copied.
     */
    eProsima_user_DllExport CommonUnionMember(
            CommonUnionMember&& x) noexcept
    {
        m_member_id = x.m_member_id;
        m_member_flags = std::move(x.m_member_flags);
        m_type_id = std::move(x.m_type_id);
        m_label_seq = std::move(x.m_label_seq);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CommonUnionMember that will be copied.
     */
    eProsima_user_DllExport CommonUnionMember& operator =(
            const CommonUnionMember& x)
    {

                    m_member_id = x.m_member_id;

                    m_member_flags = x.m_member_flags;

                    m_type_id = x.m_type_id;

                    m_label_seq = x.m_label_seq;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CommonUnionMember that will be copied.
     */
    eProsima_user_DllExport CommonUnionMember& operator =(
            CommonUnionMember&& x) noexcept
    {

        m_member_id = x.m_member_id;
        m_member_flags = std::move(x.m_member_flags);
        m_type_id = std::move(x.m_type_id);
        m_label_seq = std::move(x.m_label_seq);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonUnionMember object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CommonUnionMember& x) const
    {
        return (m_member_id == x.m_member_id &&
           m_member_flags == x.m_member_flags &&
           m_type_id == x.m_type_id &&
           m_label_seq == x.m_label_seq);
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonUnionMember object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CommonUnionMember& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member member_id
     * @param _member_id New value for member member_id
     */
    eProsima_user_DllExport void member_id(
            MemberId _member_id)
    {
        m_member_id = _member_id;
    }

    /*!
     * @brief This function returns the value of member member_id
     * @return Value of member member_id
     */
    eProsima_user_DllExport MemberId member_id() const
    {
        return m_member_id;
    }

    /*!
     * @brief This function returns a reference to member member_id
     * @return Reference to member member_id
     */
    eProsima_user_DllExport MemberId& member_id()
    {
        return m_member_id;
    }


    /*!
     * @brief This function copies the value in member member_flags
     * @param _member_flags New value to be copied in member member_flags
     */
    eProsima_user_DllExport void member_flags(
            const UnionMemberFlag& _member_flags)
    {
        m_member_flags = _member_flags;
    }

    /*!
     * @brief This function moves the value in member member_flags
     * @param _member_flags New value to be moved in member member_flags
     */
    eProsima_user_DllExport void member_flags(
            UnionMemberFlag&& _member_flags)
    {
        m_member_flags = std::move(_member_flags);
    }

    /*!
     * @brief This function returns a constant reference to member member_flags
     * @return Constant reference to member member_flags
     */
    eProsima_user_DllExport const UnionMemberFlag& member_flags() const
    {
        return m_member_flags;
    }

    /*!
     * @brief This function returns a reference to member member_flags
     * @return Reference to member member_flags
     */
    eProsima_user_DllExport UnionMemberFlag& member_flags()
    {
        return m_member_flags;
    }


    /*!
     * @brief This function copies the value in member type_id
     * @param _type_id New value to be copied in member type_id
     */
    eProsima_user_DllExport void type_id(
            const TypeIdentifier& _type_id)
    {
        m_type_id = _type_id;
    }

    /*!
     * @brief This function moves the value in member type_id
     * @param _type_id New value to be moved in member type_id
     */
    eProsima_user_DllExport void type_id(
            TypeIdentifier&& _type_id)
    {
        m_type_id = std::move(_type_id);
    }

    /*!
     * @brief This function returns a constant reference to member type_id
     * @return Constant reference to member type_id
     */
    eProsima_user_DllExport const TypeIdentifier& type_id() const
    {
        return m_type_id;
    }

    /*!
     * @brief This function returns a reference to member type_id
     * @return Reference to member type_id
     */
    eProsima_user_DllExport TypeIdentifier& type_id()
    {
        return m_type_id;
    }


    /*!
     * @brief This function copies the value in member label_seq
     * @param _label_seq New value to be copied in member label_seq
     */
    eProsima_user_DllExport void label_seq(
            const UnionCaseLabelSeq& _label_seq)
    {
        m_label_seq = _label_seq;
    }

    /*!
     * @brief This function moves the value in member label_seq
     * @param _label_seq New value to be moved in member label_seq
     */
    eProsima_user_DllExport void label_seq(
            UnionCaseLabelSeq&& _label_seq)
    {
        m_label_seq = std::move(_label_seq);
    }

    /*!
     * @brief This function returns a constant reference to member label_seq
     * @return Constant reference to member label_seq
     */
    eProsima_user_DllExport const UnionCaseLabelSeq& label_seq() const
    {
        return m_label_seq;
    }

    /*!
     * @brief This function returns a reference to member label_seq
     * @return Reference to member label_seq
     */
    eProsima_user_DllExport UnionCaseLabelSeq& label_seq()
    {
        return m_label_seq;
    }



private:

    MemberId m_member_id{0};
    UnionMemberFlag m_member_flags{0};
    TypeIdentifier m_type_id;
    UnionCaseLabelSeq m_label_seq;

};
/*!
 * @brief This class represents the structure CompleteUnionMember defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteUnionMember
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteUnionMember()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteUnionMember()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteUnionMember that will be copied.
     */
    eProsima_user_DllExport CompleteUnionMember(
            const CompleteUnionMember& x)
    {
                    m_common = x.m_common;

                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteUnionMember that will be copied.
     */
    eProsima_user_DllExport CompleteUnionMember(
            CompleteUnionMember&& x) noexcept
    {
        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteUnionMember that will be copied.
     */
    eProsima_user_DllExport CompleteUnionMember& operator =(
            const CompleteUnionMember& x)
    {

                    m_common = x.m_common;

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteUnionMember that will be copied.
     */
    eProsima_user_DllExport CompleteUnionMember& operator =(
            CompleteUnionMember&& x) noexcept
    {

        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteUnionMember object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteUnionMember& x) const
    {
        return (m_common == x.m_common &&
           m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteUnionMember object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteUnionMember& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonUnionMember& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonUnionMember&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonUnionMember& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonUnionMember& common()
    {
        return m_common;
    }


    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const CompleteMemberDetail& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            CompleteMemberDetail&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const CompleteMemberDetail& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport CompleteMemberDetail& detail()
    {
        return m_detail;
    }



private:

    CommonUnionMember m_common;
    CompleteMemberDetail m_detail;

};
typedef std::vector<CompleteUnionMember> CompleteUnionMemberSeq;

/*!
 * @brief This class represents the structure MinimalUnionMember defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalUnionMember
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalUnionMember()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalUnionMember()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalUnionMember that will be copied.
     */
    eProsima_user_DllExport MinimalUnionMember(
            const MinimalUnionMember& x)
    {
                    m_common = x.m_common;

                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalUnionMember that will be copied.
     */
    eProsima_user_DllExport MinimalUnionMember(
            MinimalUnionMember&& x) noexcept
    {
        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalUnionMember that will be copied.
     */
    eProsima_user_DllExport MinimalUnionMember& operator =(
            const MinimalUnionMember& x)
    {

                    m_common = x.m_common;

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalUnionMember that will be copied.
     */
    eProsima_user_DllExport MinimalUnionMember& operator =(
            MinimalUnionMember&& x) noexcept
    {

        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalUnionMember object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalUnionMember& x) const
    {
        return (m_common == x.m_common &&
           m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalUnionMember object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalUnionMember& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonUnionMember& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonUnionMember&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonUnionMember& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonUnionMember& common()
    {
        return m_common;
    }


    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const MinimalMemberDetail& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            MinimalMemberDetail&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const MinimalMemberDetail& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport MinimalMemberDetail& detail()
    {
        return m_detail;
    }



private:

    CommonUnionMember m_common;
    MinimalMemberDetail m_detail;

};
typedef std::vector<MinimalUnionMember> MinimalUnionMemberSeq;

/*!
 * @brief This class represents the structure CommonDiscriminatorMember defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CommonDiscriminatorMember
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CommonDiscriminatorMember()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CommonDiscriminatorMember()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CommonDiscriminatorMember that will be copied.
     */
    eProsima_user_DllExport CommonDiscriminatorMember(
            const CommonDiscriminatorMember& x)
    {
                    m_member_flags = x.m_member_flags;

                    m_type_id = x.m_type_id;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CommonDiscriminatorMember that will be copied.
     */
    eProsima_user_DllExport CommonDiscriminatorMember(
            CommonDiscriminatorMember&& x) noexcept
    {
        m_member_flags = std::move(x.m_member_flags);
        m_type_id = std::move(x.m_type_id);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CommonDiscriminatorMember that will be copied.
     */
    eProsima_user_DllExport CommonDiscriminatorMember& operator =(
            const CommonDiscriminatorMember& x)
    {

                    m_member_flags = x.m_member_flags;

                    m_type_id = x.m_type_id;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CommonDiscriminatorMember that will be copied.
     */
    eProsima_user_DllExport CommonDiscriminatorMember& operator =(
            CommonDiscriminatorMember&& x) noexcept
    {

        m_member_flags = std::move(x.m_member_flags);
        m_type_id = std::move(x.m_type_id);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonDiscriminatorMember object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CommonDiscriminatorMember& x) const
    {
        return (m_member_flags == x.m_member_flags &&
           m_type_id == x.m_type_id);
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonDiscriminatorMember object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CommonDiscriminatorMember& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member member_flags
     * @param _member_flags New value to be copied in member member_flags
     */
    eProsima_user_DllExport void member_flags(
            const UnionDiscriminatorFlag& _member_flags)
    {
        m_member_flags = _member_flags;
    }

    /*!
     * @brief This function moves the value in member member_flags
     * @param _member_flags New value to be moved in member member_flags
     */
    eProsima_user_DllExport void member_flags(
            UnionDiscriminatorFlag&& _member_flags)
    {
        m_member_flags = std::move(_member_flags);
    }

    /*!
     * @brief This function returns a constant reference to member member_flags
     * @return Constant reference to member member_flags
     */
    eProsima_user_DllExport const UnionDiscriminatorFlag& member_flags() const
    {
        return m_member_flags;
    }

    /*!
     * @brief This function returns a reference to member member_flags
     * @return Reference to member member_flags
     */
    eProsima_user_DllExport UnionDiscriminatorFlag& member_flags()
    {
        return m_member_flags;
    }


    /*!
     * @brief This function copies the value in member type_id
     * @param _type_id New value to be copied in member type_id
     */
    eProsima_user_DllExport void type_id(
            const TypeIdentifier& _type_id)
    {
        m_type_id = _type_id;
    }

    /*!
     * @brief This function moves the value in member type_id
     * @param _type_id New value to be moved in member type_id
     */
    eProsima_user_DllExport void type_id(
            TypeIdentifier&& _type_id)
    {
        m_type_id = std::move(_type_id);
    }

    /*!
     * @brief This function returns a constant reference to member type_id
     * @return Constant reference to member type_id
     */
    eProsima_user_DllExport const TypeIdentifier& type_id() const
    {
        return m_type_id;
    }

    /*!
     * @brief This function returns a reference to member type_id
     * @return Reference to member type_id
     */
    eProsima_user_DllExport TypeIdentifier& type_id()
    {
        return m_type_id;
    }



private:

    UnionDiscriminatorFlag m_member_flags{0};
    TypeIdentifier m_type_id;

};
/*!
 * @brief This class represents the structure CompleteDiscriminatorMember defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteDiscriminatorMember
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteDiscriminatorMember()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteDiscriminatorMember()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteDiscriminatorMember that will be copied.
     */
    eProsima_user_DllExport CompleteDiscriminatorMember(
            const CompleteDiscriminatorMember& x)
    {
                    m_common = x.m_common;

                    m_ann_builtin = x.m_ann_builtin;

                    m_ann_custom = x.m_ann_custom;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteDiscriminatorMember that will be copied.
     */
    eProsima_user_DllExport CompleteDiscriminatorMember(
            CompleteDiscriminatorMember&& x) noexcept
    {
        m_common = std::move(x.m_common);
        m_ann_builtin = std::move(x.m_ann_builtin);
        m_ann_custom = std::move(x.m_ann_custom);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteDiscriminatorMember that will be copied.
     */
    eProsima_user_DllExport CompleteDiscriminatorMember& operator =(
            const CompleteDiscriminatorMember& x)
    {

                    m_common = x.m_common;

                    m_ann_builtin = x.m_ann_builtin;

                    m_ann_custom = x.m_ann_custom;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteDiscriminatorMember that will be copied.
     */
    eProsima_user_DllExport CompleteDiscriminatorMember& operator =(
            CompleteDiscriminatorMember&& x) noexcept
    {

        m_common = std::move(x.m_common);
        m_ann_builtin = std::move(x.m_ann_builtin);
        m_ann_custom = std::move(x.m_ann_custom);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteDiscriminatorMember object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteDiscriminatorMember& x) const
    {
        return (m_common == x.m_common &&
           m_ann_builtin == x.m_ann_builtin &&
           m_ann_custom == x.m_ann_custom);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteDiscriminatorMember object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteDiscriminatorMember& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonDiscriminatorMember& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonDiscriminatorMember&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonDiscriminatorMember& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonDiscriminatorMember& common()
    {
        return m_common;
    }


    /*!
     * @brief This function copies the value in member ann_builtin
     * @param _ann_builtin New value to be copied in member ann_builtin
     */
    eProsima_user_DllExport void ann_builtin(
            const eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations>& _ann_builtin)
    {
        m_ann_builtin = _ann_builtin;
    }

    /*!
     * @brief This function moves the value in member ann_builtin
     * @param _ann_builtin New value to be moved in member ann_builtin
     */
    eProsima_user_DllExport void ann_builtin(
            eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations>&& _ann_builtin)
    {
        m_ann_builtin = std::move(_ann_builtin);
    }

    /*!
     * @brief This function returns a constant reference to member ann_builtin
     * @return Constant reference to member ann_builtin
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations>& ann_builtin() const
    {
        return m_ann_builtin;
    }

    /*!
     * @brief This function returns a reference to member ann_builtin
     * @return Reference to member ann_builtin
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations>& ann_builtin()
    {
        return m_ann_builtin;
    }


    /*!
     * @brief This function copies the value in member ann_custom
     * @param _ann_custom New value to be copied in member ann_custom
     */
    eProsima_user_DllExport void ann_custom(
            const eprosima::fastcdr::optional<AppliedAnnotationSeq>& _ann_custom)
    {
        m_ann_custom = _ann_custom;
    }

    /*!
     * @brief This function moves the value in member ann_custom
     * @param _ann_custom New value to be moved in member ann_custom
     */
    eProsima_user_DllExport void ann_custom(
            eprosima::fastcdr::optional<AppliedAnnotationSeq>&& _ann_custom)
    {
        m_ann_custom = std::move(_ann_custom);
    }

    /*!
     * @brief This function returns a constant reference to member ann_custom
     * @return Constant reference to member ann_custom
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<AppliedAnnotationSeq>& ann_custom() const
    {
        return m_ann_custom;
    }

    /*!
     * @brief This function returns a reference to member ann_custom
     * @return Reference to member ann_custom
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<AppliedAnnotationSeq>& ann_custom()
    {
        return m_ann_custom;
    }



private:

    CommonDiscriminatorMember m_common;
    eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> m_ann_builtin;
    eprosima::fastcdr::optional<AppliedAnnotationSeq> m_ann_custom;

};
/*!
 * @brief This class represents the structure MinimalDiscriminatorMember defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalDiscriminatorMember
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalDiscriminatorMember()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalDiscriminatorMember()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalDiscriminatorMember that will be copied.
     */
    eProsima_user_DllExport MinimalDiscriminatorMember(
            const MinimalDiscriminatorMember& x)
    {
                    m_common = x.m_common;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalDiscriminatorMember that will be copied.
     */
    eProsima_user_DllExport MinimalDiscriminatorMember(
            MinimalDiscriminatorMember&& x) noexcept
    {
        m_common = std::move(x.m_common);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalDiscriminatorMember that will be copied.
     */
    eProsima_user_DllExport MinimalDiscriminatorMember& operator =(
            const MinimalDiscriminatorMember& x)
    {

                    m_common = x.m_common;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalDiscriminatorMember that will be copied.
     */
    eProsima_user_DllExport MinimalDiscriminatorMember& operator =(
            MinimalDiscriminatorMember&& x) noexcept
    {

        m_common = std::move(x.m_common);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalDiscriminatorMember object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalDiscriminatorMember& x) const
    {
        return (m_common == x.m_common);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalDiscriminatorMember object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalDiscriminatorMember& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonDiscriminatorMember& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonDiscriminatorMember&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonDiscriminatorMember& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonDiscriminatorMember& common()
    {
        return m_common;
    }



private:

    CommonDiscriminatorMember m_common;

};
/*!
 * @brief This class represents the structure CompleteUnionHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteUnionHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteUnionHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteUnionHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteUnionHeader that will be copied.
     */
    eProsima_user_DllExport CompleteUnionHeader(
            const CompleteUnionHeader& x)
    {
                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteUnionHeader that will be copied.
     */
    eProsima_user_DllExport CompleteUnionHeader(
            CompleteUnionHeader&& x) noexcept
    {
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteUnionHeader that will be copied.
     */
    eProsima_user_DllExport CompleteUnionHeader& operator =(
            const CompleteUnionHeader& x)
    {

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteUnionHeader that will be copied.
     */
    eProsima_user_DllExport CompleteUnionHeader& operator =(
            CompleteUnionHeader&& x) noexcept
    {

        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteUnionHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteUnionHeader& x) const
    {
        return (m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteUnionHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteUnionHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const CompleteTypeDetail& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            CompleteTypeDetail&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const CompleteTypeDetail& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport CompleteTypeDetail& detail()
    {
        return m_detail;
    }



private:

    CompleteTypeDetail m_detail;

};
/*!
 * @brief This class represents the structure MinimalUnionHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalUnionHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalUnionHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalUnionHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalUnionHeader that will be copied.
     */
    eProsima_user_DllExport MinimalUnionHeader(
            const MinimalUnionHeader& x)
    {
                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalUnionHeader that will be copied.
     */
    eProsima_user_DllExport MinimalUnionHeader(
            MinimalUnionHeader&& x) noexcept
    {
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalUnionHeader that will be copied.
     */
    eProsima_user_DllExport MinimalUnionHeader& operator =(
            const MinimalUnionHeader& x)
    {

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalUnionHeader that will be copied.
     */
    eProsima_user_DllExport MinimalUnionHeader& operator =(
            MinimalUnionHeader&& x) noexcept
    {

        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalUnionHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalUnionHeader& x) const
    {
        return (m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalUnionHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalUnionHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const MinimalTypeDetail& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            MinimalTypeDetail&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const MinimalTypeDetail& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport MinimalTypeDetail& detail()
    {
        return m_detail;
    }



private:

    MinimalTypeDetail m_detail;

};
/*!
 * @brief This class represents the structure CompleteUnionType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteUnionType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteUnionType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteUnionType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteUnionType that will be copied.
     */
    eProsima_user_DllExport CompleteUnionType(
            const CompleteUnionType& x)
    {
                    m_union_flags = x.m_union_flags;

                    m_header = x.m_header;

                    m_discriminator = x.m_discriminator;

                    m_member_seq = x.m_member_seq;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteUnionType that will be copied.
     */
    eProsima_user_DllExport CompleteUnionType(
            CompleteUnionType&& x) noexcept
    {
        m_union_flags = std::move(x.m_union_flags);
        m_header = std::move(x.m_header);
        m_discriminator = std::move(x.m_discriminator);
        m_member_seq = std::move(x.m_member_seq);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteUnionType that will be copied.
     */
    eProsima_user_DllExport CompleteUnionType& operator =(
            const CompleteUnionType& x)
    {

                    m_union_flags = x.m_union_flags;

                    m_header = x.m_header;

                    m_discriminator = x.m_discriminator;

                    m_member_seq = x.m_member_seq;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteUnionType that will be copied.
     */
    eProsima_user_DllExport CompleteUnionType& operator =(
            CompleteUnionType&& x) noexcept
    {

        m_union_flags = std::move(x.m_union_flags);
        m_header = std::move(x.m_header);
        m_discriminator = std::move(x.m_discriminator);
        m_member_seq = std::move(x.m_member_seq);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteUnionType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteUnionType& x) const
    {
        return (m_union_flags == x.m_union_flags &&
           m_header == x.m_header &&
           m_discriminator == x.m_discriminator &&
           m_member_seq == x.m_member_seq);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteUnionType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteUnionType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member union_flags
     * @param _union_flags New value to be copied in member union_flags
     */
    eProsima_user_DllExport void union_flags(
            const UnionTypeFlag& _union_flags)
    {
        m_union_flags = _union_flags;
    }

    /*!
     * @brief This function moves the value in member union_flags
     * @param _union_flags New value to be moved in member union_flags
     */
    eProsima_user_DllExport void union_flags(
            UnionTypeFlag&& _union_flags)
    {
        m_union_flags = std::move(_union_flags);
    }

    /*!
     * @brief This function returns a constant reference to member union_flags
     * @return Constant reference to member union_flags
     */
    eProsima_user_DllExport const UnionTypeFlag& union_flags() const
    {
        return m_union_flags;
    }

    /*!
     * @brief This function returns a reference to member union_flags
     * @return Reference to member union_flags
     */
    eProsima_user_DllExport UnionTypeFlag& union_flags()
    {
        return m_union_flags;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const CompleteUnionHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            CompleteUnionHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const CompleteUnionHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport CompleteUnionHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member discriminator
     * @param _discriminator New value to be copied in member discriminator
     */
    eProsima_user_DllExport void discriminator(
            const CompleteDiscriminatorMember& _discriminator)
    {
        m_discriminator = _discriminator;
    }

    /*!
     * @brief This function moves the value in member discriminator
     * @param _discriminator New value to be moved in member discriminator
     */
    eProsima_user_DllExport void discriminator(
            CompleteDiscriminatorMember&& _discriminator)
    {
        m_discriminator = std::move(_discriminator);
    }

    /*!
     * @brief This function returns a constant reference to member discriminator
     * @return Constant reference to member discriminator
     */
    eProsima_user_DllExport const CompleteDiscriminatorMember& discriminator() const
    {
        return m_discriminator;
    }

    /*!
     * @brief This function returns a reference to member discriminator
     * @return Reference to member discriminator
     */
    eProsima_user_DllExport CompleteDiscriminatorMember& discriminator()
    {
        return m_discriminator;
    }


    /*!
     * @brief This function copies the value in member member_seq
     * @param _member_seq New value to be copied in member member_seq
     */
    eProsima_user_DllExport void member_seq(
            const CompleteUnionMemberSeq& _member_seq)
    {
        m_member_seq = _member_seq;
    }

    /*!
     * @brief This function moves the value in member member_seq
     * @param _member_seq New value to be moved in member member_seq
     */
    eProsima_user_DllExport void member_seq(
            CompleteUnionMemberSeq&& _member_seq)
    {
        m_member_seq = std::move(_member_seq);
    }

    /*!
     * @brief This function returns a constant reference to member member_seq
     * @return Constant reference to member member_seq
     */
    eProsima_user_DllExport const CompleteUnionMemberSeq& member_seq() const
    {
        return m_member_seq;
    }

    /*!
     * @brief This function returns a reference to member member_seq
     * @return Reference to member member_seq
     */
    eProsima_user_DllExport CompleteUnionMemberSeq& member_seq()
    {
        return m_member_seq;
    }



private:

    UnionTypeFlag m_union_flags{0};
    CompleteUnionHeader m_header;
    CompleteDiscriminatorMember m_discriminator;
    CompleteUnionMemberSeq m_member_seq;

};
/*!
 * @brief This class represents the structure MinimalUnionType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalUnionType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalUnionType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalUnionType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalUnionType that will be copied.
     */
    eProsima_user_DllExport MinimalUnionType(
            const MinimalUnionType& x)
    {
                    m_union_flags = x.m_union_flags;

                    m_header = x.m_header;

                    m_discriminator = x.m_discriminator;

                    m_member_seq = x.m_member_seq;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalUnionType that will be copied.
     */
    eProsima_user_DllExport MinimalUnionType(
            MinimalUnionType&& x) noexcept
    {
        m_union_flags = std::move(x.m_union_flags);
        m_header = std::move(x.m_header);
        m_discriminator = std::move(x.m_discriminator);
        m_member_seq = std::move(x.m_member_seq);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalUnionType that will be copied.
     */
    eProsima_user_DllExport MinimalUnionType& operator =(
            const MinimalUnionType& x)
    {

                    m_union_flags = x.m_union_flags;

                    m_header = x.m_header;

                    m_discriminator = x.m_discriminator;

                    m_member_seq = x.m_member_seq;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalUnionType that will be copied.
     */
    eProsima_user_DllExport MinimalUnionType& operator =(
            MinimalUnionType&& x) noexcept
    {

        m_union_flags = std::move(x.m_union_flags);
        m_header = std::move(x.m_header);
        m_discriminator = std::move(x.m_discriminator);
        m_member_seq = std::move(x.m_member_seq);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalUnionType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalUnionType& x) const
    {
        return (m_union_flags == x.m_union_flags &&
           m_header == x.m_header &&
           m_discriminator == x.m_discriminator &&
           m_member_seq == x.m_member_seq);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalUnionType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalUnionType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member union_flags
     * @param _union_flags New value to be copied in member union_flags
     */
    eProsima_user_DllExport void union_flags(
            const UnionTypeFlag& _union_flags)
    {
        m_union_flags = _union_flags;
    }

    /*!
     * @brief This function moves the value in member union_flags
     * @param _union_flags New value to be moved in member union_flags
     */
    eProsima_user_DllExport void union_flags(
            UnionTypeFlag&& _union_flags)
    {
        m_union_flags = std::move(_union_flags);
    }

    /*!
     * @brief This function returns a constant reference to member union_flags
     * @return Constant reference to member union_flags
     */
    eProsima_user_DllExport const UnionTypeFlag& union_flags() const
    {
        return m_union_flags;
    }

    /*!
     * @brief This function returns a reference to member union_flags
     * @return Reference to member union_flags
     */
    eProsima_user_DllExport UnionTypeFlag& union_flags()
    {
        return m_union_flags;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const MinimalUnionHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            MinimalUnionHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const MinimalUnionHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport MinimalUnionHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member discriminator
     * @param _discriminator New value to be copied in member discriminator
     */
    eProsima_user_DllExport void discriminator(
            const MinimalDiscriminatorMember& _discriminator)
    {
        m_discriminator = _discriminator;
    }

    /*!
     * @brief This function moves the value in member discriminator
     * @param _discriminator New value to be moved in member discriminator
     */
    eProsima_user_DllExport void discriminator(
            MinimalDiscriminatorMember&& _discriminator)
    {
        m_discriminator = std::move(_discriminator);
    }

    /*!
     * @brief This function returns a constant reference to member discriminator
     * @return Constant reference to member discriminator
     */
    eProsima_user_DllExport const MinimalDiscriminatorMember& discriminator() const
    {
        return m_discriminator;
    }

    /*!
     * @brief This function returns a reference to member discriminator
     * @return Reference to member discriminator
     */
    eProsima_user_DllExport MinimalDiscriminatorMember& discriminator()
    {
        return m_discriminator;
    }


    /*!
     * @brief This function copies the value in member member_seq
     * @param _member_seq New value to be copied in member member_seq
     */
    eProsima_user_DllExport void member_seq(
            const MinimalUnionMemberSeq& _member_seq)
    {
        m_member_seq = _member_seq;
    }

    /*!
     * @brief This function moves the value in member member_seq
     * @param _member_seq New value to be moved in member member_seq
     */
    eProsima_user_DllExport void member_seq(
            MinimalUnionMemberSeq&& _member_seq)
    {
        m_member_seq = std::move(_member_seq);
    }

    /*!
     * @brief This function returns a constant reference to member member_seq
     * @return Constant reference to member member_seq
     */
    eProsima_user_DllExport const MinimalUnionMemberSeq& member_seq() const
    {
        return m_member_seq;
    }

    /*!
     * @brief This function returns a reference to member member_seq
     * @return Reference to member member_seq
     */
    eProsima_user_DllExport MinimalUnionMemberSeq& member_seq()
    {
        return m_member_seq;
    }



private:

    UnionTypeFlag m_union_flags{0};
    MinimalUnionHeader m_header;
    MinimalDiscriminatorMember m_discriminator;
    MinimalUnionMemberSeq m_member_seq;

};
/*!
 * @brief This class represents the structure CommonAnnotationParameter defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CommonAnnotationParameter
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CommonAnnotationParameter()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CommonAnnotationParameter()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CommonAnnotationParameter that will be copied.
     */
    eProsima_user_DllExport CommonAnnotationParameter(
            const CommonAnnotationParameter& x)
    {
                    m_member_flags = x.m_member_flags;

                    m_member_type_id = x.m_member_type_id;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CommonAnnotationParameter that will be copied.
     */
    eProsima_user_DllExport CommonAnnotationParameter(
            CommonAnnotationParameter&& x) noexcept
    {
        m_member_flags = std::move(x.m_member_flags);
        m_member_type_id = std::move(x.m_member_type_id);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CommonAnnotationParameter that will be copied.
     */
    eProsima_user_DllExport CommonAnnotationParameter& operator =(
            const CommonAnnotationParameter& x)
    {

                    m_member_flags = x.m_member_flags;

                    m_member_type_id = x.m_member_type_id;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CommonAnnotationParameter that will be copied.
     */
    eProsima_user_DllExport CommonAnnotationParameter& operator =(
            CommonAnnotationParameter&& x) noexcept
    {

        m_member_flags = std::move(x.m_member_flags);
        m_member_type_id = std::move(x.m_member_type_id);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonAnnotationParameter object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CommonAnnotationParameter& x) const
    {
        return (m_member_flags == x.m_member_flags &&
           m_member_type_id == x.m_member_type_id);
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonAnnotationParameter object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CommonAnnotationParameter& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member member_flags
     * @param _member_flags New value to be copied in member member_flags
     */
    eProsima_user_DllExport void member_flags(
            const AnnotationParameterFlag& _member_flags)
    {
        m_member_flags = _member_flags;
    }

    /*!
     * @brief This function moves the value in member member_flags
     * @param _member_flags New value to be moved in member member_flags
     */
    eProsima_user_DllExport void member_flags(
            AnnotationParameterFlag&& _member_flags)
    {
        m_member_flags = std::move(_member_flags);
    }

    /*!
     * @brief This function returns a constant reference to member member_flags
     * @return Constant reference to member member_flags
     */
    eProsima_user_DllExport const AnnotationParameterFlag& member_flags() const
    {
        return m_member_flags;
    }

    /*!
     * @brief This function returns a reference to member member_flags
     * @return Reference to member member_flags
     */
    eProsima_user_DllExport AnnotationParameterFlag& member_flags()
    {
        return m_member_flags;
    }


    /*!
     * @brief This function copies the value in member member_type_id
     * @param _member_type_id New value to be copied in member member_type_id
     */
    eProsima_user_DllExport void member_type_id(
            const TypeIdentifier& _member_type_id)
    {
        m_member_type_id = _member_type_id;
    }

    /*!
     * @brief This function moves the value in member member_type_id
     * @param _member_type_id New value to be moved in member member_type_id
     */
    eProsima_user_DllExport void member_type_id(
            TypeIdentifier&& _member_type_id)
    {
        m_member_type_id = std::move(_member_type_id);
    }

    /*!
     * @brief This function returns a constant reference to member member_type_id
     * @return Constant reference to member member_type_id
     */
    eProsima_user_DllExport const TypeIdentifier& member_type_id() const
    {
        return m_member_type_id;
    }

    /*!
     * @brief This function returns a reference to member member_type_id
     * @return Reference to member member_type_id
     */
    eProsima_user_DllExport TypeIdentifier& member_type_id()
    {
        return m_member_type_id;
    }



private:

    AnnotationParameterFlag m_member_flags{0};
    TypeIdentifier m_member_type_id;

};
/*!
 * @brief This class represents the structure CompleteAnnotationParameter defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteAnnotationParameter
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteAnnotationParameter()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteAnnotationParameter()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteAnnotationParameter that will be copied.
     */
    eProsima_user_DllExport CompleteAnnotationParameter(
            const CompleteAnnotationParameter& x)
    {
                    m_common = x.m_common;

                    m_name = x.m_name;

                    m_default_value = x.m_default_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteAnnotationParameter that will be copied.
     */
    eProsima_user_DllExport CompleteAnnotationParameter(
            CompleteAnnotationParameter&& x) noexcept
    {
        m_common = std::move(x.m_common);
        m_name = std::move(x.m_name);
        m_default_value = std::move(x.m_default_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteAnnotationParameter that will be copied.
     */
    eProsima_user_DllExport CompleteAnnotationParameter& operator =(
            const CompleteAnnotationParameter& x)
    {

                    m_common = x.m_common;

                    m_name = x.m_name;

                    m_default_value = x.m_default_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteAnnotationParameter that will be copied.
     */
    eProsima_user_DllExport CompleteAnnotationParameter& operator =(
            CompleteAnnotationParameter&& x) noexcept
    {

        m_common = std::move(x.m_common);
        m_name = std::move(x.m_name);
        m_default_value = std::move(x.m_default_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteAnnotationParameter object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteAnnotationParameter& x) const
    {
        return (m_common == x.m_common &&
           m_name == x.m_name &&
           m_default_value == x.m_default_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteAnnotationParameter object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteAnnotationParameter& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonAnnotationParameter& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonAnnotationParameter&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonAnnotationParameter& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonAnnotationParameter& common()
    {
        return m_common;
    }


    /*!
     * @brief This function copies the value in member name
     * @param _name New value to be copied in member name
     */
    eProsima_user_DllExport void name(
            const MemberName& _name)
    {
        m_name = _name;
    }

    /*!
     * @brief This function moves the value in member name
     * @param _name New value to be moved in member name
     */
    eProsima_user_DllExport void name(
            MemberName&& _name)
    {
        m_name = std::move(_name);
    }

    /*!
     * @brief This function returns a constant reference to member name
     * @return Constant reference to member name
     */
    eProsima_user_DllExport const MemberName& name() const
    {
        return m_name;
    }

    /*!
     * @brief This function returns a reference to member name
     * @return Reference to member name
     */
    eProsima_user_DllExport MemberName& name()
    {
        return m_name;
    }


    /*!
     * @brief This function copies the value in member default_value
     * @param _default_value New value to be copied in member default_value
     */
    eProsima_user_DllExport void default_value(
            const AnnotationParameterValue& _default_value)
    {
        m_default_value = _default_value;
    }

    /*!
     * @brief This function moves the value in member default_value
     * @param _default_value New value to be moved in member default_value
     */
    eProsima_user_DllExport void default_value(
            AnnotationParameterValue&& _default_value)
    {
        m_default_value = std::move(_default_value);
    }

    /*!
     * @brief This function returns a constant reference to member default_value
     * @return Constant reference to member default_value
     */
    eProsima_user_DllExport const AnnotationParameterValue& default_value() const
    {
        return m_default_value;
    }

    /*!
     * @brief This function returns a reference to member default_value
     * @return Reference to member default_value
     */
    eProsima_user_DllExport AnnotationParameterValue& default_value()
    {
        return m_default_value;
    }



private:

    CommonAnnotationParameter m_common;
    MemberName m_name;
    AnnotationParameterValue m_default_value;

};
typedef std::vector<CompleteAnnotationParameter> CompleteAnnotationParameterSeq;

/*!
 * @brief This class represents the structure MinimalAnnotationParameter defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalAnnotationParameter
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalAnnotationParameter()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalAnnotationParameter()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalAnnotationParameter that will be copied.
     */
    eProsima_user_DllExport MinimalAnnotationParameter(
            const MinimalAnnotationParameter& x)
    {
                    m_common = x.m_common;

                    m_name_hash = x.m_name_hash;

                    m_default_value = x.m_default_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalAnnotationParameter that will be copied.
     */
    eProsima_user_DllExport MinimalAnnotationParameter(
            MinimalAnnotationParameter&& x) noexcept
    {
        m_common = std::move(x.m_common);
        m_name_hash = std::move(x.m_name_hash);
        m_default_value = std::move(x.m_default_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalAnnotationParameter that will be copied.
     */
    eProsima_user_DllExport MinimalAnnotationParameter& operator =(
            const MinimalAnnotationParameter& x)
    {

                    m_common = x.m_common;

                    m_name_hash = x.m_name_hash;

                    m_default_value = x.m_default_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalAnnotationParameter that will be copied.
     */
    eProsima_user_DllExport MinimalAnnotationParameter& operator =(
            MinimalAnnotationParameter&& x) noexcept
    {

        m_common = std::move(x.m_common);
        m_name_hash = std::move(x.m_name_hash);
        m_default_value = std::move(x.m_default_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalAnnotationParameter object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalAnnotationParameter& x) const
    {
        return (m_common == x.m_common &&
           m_name_hash == x.m_name_hash &&
           m_default_value == x.m_default_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalAnnotationParameter object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalAnnotationParameter& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonAnnotationParameter& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonAnnotationParameter&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonAnnotationParameter& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonAnnotationParameter& common()
    {
        return m_common;
    }


    /*!
     * @brief This function copies the value in member name_hash
     * @param _name_hash New value to be copied in member name_hash
     */
    eProsima_user_DllExport void name_hash(
            const NameHash& _name_hash)
    {
        m_name_hash = _name_hash;
    }

    /*!
     * @brief This function moves the value in member name_hash
     * @param _name_hash New value to be moved in member name_hash
     */
    eProsima_user_DllExport void name_hash(
            NameHash&& _name_hash)
    {
        m_name_hash = std::move(_name_hash);
    }

    /*!
     * @brief This function returns a constant reference to member name_hash
     * @return Constant reference to member name_hash
     */
    eProsima_user_DllExport const NameHash& name_hash() const
    {
        return m_name_hash;
    }

    /*!
     * @brief This function returns a reference to member name_hash
     * @return Reference to member name_hash
     */
    eProsima_user_DllExport NameHash& name_hash()
    {
        return m_name_hash;
    }


    /*!
     * @brief This function copies the value in member default_value
     * @param _default_value New value to be copied in member default_value
     */
    eProsima_user_DllExport void default_value(
            const AnnotationParameterValue& _default_value)
    {
        m_default_value = _default_value;
    }

    /*!
     * @brief This function moves the value in member default_value
     * @param _default_value New value to be moved in member default_value
     */
    eProsima_user_DllExport void default_value(
            AnnotationParameterValue&& _default_value)
    {
        m_default_value = std::move(_default_value);
    }

    /*!
     * @brief This function returns a constant reference to member default_value
     * @return Constant reference to member default_value
     */
    eProsima_user_DllExport const AnnotationParameterValue& default_value() const
    {
        return m_default_value;
    }

    /*!
     * @brief This function returns a reference to member default_value
     * @return Reference to member default_value
     */
    eProsima_user_DllExport AnnotationParameterValue& default_value()
    {
        return m_default_value;
    }



private:

    CommonAnnotationParameter m_common;
    NameHash m_name_hash{0};
    AnnotationParameterValue m_default_value;

};
typedef std::vector<MinimalAnnotationParameter> MinimalAnnotationParameterSeq;

/*!
 * @brief This class represents the structure CompleteAnnotationHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteAnnotationHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteAnnotationHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteAnnotationHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteAnnotationHeader that will be copied.
     */
    eProsima_user_DllExport CompleteAnnotationHeader(
            const CompleteAnnotationHeader& x)
    {
                    m_annotation_name = x.m_annotation_name;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteAnnotationHeader that will be copied.
     */
    eProsima_user_DllExport CompleteAnnotationHeader(
            CompleteAnnotationHeader&& x) noexcept
    {
        m_annotation_name = std::move(x.m_annotation_name);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteAnnotationHeader that will be copied.
     */
    eProsima_user_DllExport CompleteAnnotationHeader& operator =(
            const CompleteAnnotationHeader& x)
    {

                    m_annotation_name = x.m_annotation_name;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteAnnotationHeader that will be copied.
     */
    eProsima_user_DllExport CompleteAnnotationHeader& operator =(
            CompleteAnnotationHeader&& x) noexcept
    {

        m_annotation_name = std::move(x.m_annotation_name);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteAnnotationHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteAnnotationHeader& x) const
    {
        return (m_annotation_name == x.m_annotation_name);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteAnnotationHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteAnnotationHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member annotation_name
     * @param _annotation_name New value to be copied in member annotation_name
     */
    eProsima_user_DllExport void annotation_name(
            const QualifiedTypeName& _annotation_name)
    {
        m_annotation_name = _annotation_name;
    }

    /*!
     * @brief This function moves the value in member annotation_name
     * @param _annotation_name New value to be moved in member annotation_name
     */
    eProsima_user_DllExport void annotation_name(
            QualifiedTypeName&& _annotation_name)
    {
        m_annotation_name = std::move(_annotation_name);
    }

    /*!
     * @brief This function returns a constant reference to member annotation_name
     * @return Constant reference to member annotation_name
     */
    eProsima_user_DllExport const QualifiedTypeName& annotation_name() const
    {
        return m_annotation_name;
    }

    /*!
     * @brief This function returns a reference to member annotation_name
     * @return Reference to member annotation_name
     */
    eProsima_user_DllExport QualifiedTypeName& annotation_name()
    {
        return m_annotation_name;
    }



private:

    QualifiedTypeName m_annotation_name;

};
/*!
 * @brief This class represents the structure MinimalAnnotationHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalAnnotationHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalAnnotationHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalAnnotationHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalAnnotationHeader that will be copied.
     */
    eProsima_user_DllExport MinimalAnnotationHeader(
            const MinimalAnnotationHeader& x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalAnnotationHeader that will be copied.
     */
    eProsima_user_DllExport MinimalAnnotationHeader(
            MinimalAnnotationHeader&& x) noexcept
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalAnnotationHeader that will be copied.
     */
    eProsima_user_DllExport MinimalAnnotationHeader& operator =(
            const MinimalAnnotationHeader& x)
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalAnnotationHeader that will be copied.
     */
    eProsima_user_DllExport MinimalAnnotationHeader& operator =(
            MinimalAnnotationHeader&& x) noexcept
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalAnnotationHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalAnnotationHeader& x) const
    {
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalAnnotationHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalAnnotationHeader& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the structure CompleteAnnotationType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteAnnotationType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteAnnotationType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteAnnotationType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteAnnotationType that will be copied.
     */
    eProsima_user_DllExport CompleteAnnotationType(
            const CompleteAnnotationType& x)
    {
                    m_annotation_flag = x.m_annotation_flag;

                    m_header = x.m_header;

                    m_member_seq = x.m_member_seq;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteAnnotationType that will be copied.
     */
    eProsima_user_DllExport CompleteAnnotationType(
            CompleteAnnotationType&& x) noexcept
    {
        m_annotation_flag = std::move(x.m_annotation_flag);
        m_header = std::move(x.m_header);
        m_member_seq = std::move(x.m_member_seq);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteAnnotationType that will be copied.
     */
    eProsima_user_DllExport CompleteAnnotationType& operator =(
            const CompleteAnnotationType& x)
    {

                    m_annotation_flag = x.m_annotation_flag;

                    m_header = x.m_header;

                    m_member_seq = x.m_member_seq;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteAnnotationType that will be copied.
     */
    eProsima_user_DllExport CompleteAnnotationType& operator =(
            CompleteAnnotationType&& x) noexcept
    {

        m_annotation_flag = std::move(x.m_annotation_flag);
        m_header = std::move(x.m_header);
        m_member_seq = std::move(x.m_member_seq);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteAnnotationType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteAnnotationType& x) const
    {
        return (m_annotation_flag == x.m_annotation_flag &&
           m_header == x.m_header &&
           m_member_seq == x.m_member_seq);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteAnnotationType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteAnnotationType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member annotation_flag
     * @param _annotation_flag New value to be copied in member annotation_flag
     */
    eProsima_user_DllExport void annotation_flag(
            const AnnotationTypeFlag& _annotation_flag)
    {
        m_annotation_flag = _annotation_flag;
    }

    /*!
     * @brief This function moves the value in member annotation_flag
     * @param _annotation_flag New value to be moved in member annotation_flag
     */
    eProsima_user_DllExport void annotation_flag(
            AnnotationTypeFlag&& _annotation_flag)
    {
        m_annotation_flag = std::move(_annotation_flag);
    }

    /*!
     * @brief This function returns a constant reference to member annotation_flag
     * @return Constant reference to member annotation_flag
     */
    eProsima_user_DllExport const AnnotationTypeFlag& annotation_flag() const
    {
        return m_annotation_flag;
    }

    /*!
     * @brief This function returns a reference to member annotation_flag
     * @return Reference to member annotation_flag
     */
    eProsima_user_DllExport AnnotationTypeFlag& annotation_flag()
    {
        return m_annotation_flag;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const CompleteAnnotationHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            CompleteAnnotationHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const CompleteAnnotationHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport CompleteAnnotationHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member member_seq
     * @param _member_seq New value to be copied in member member_seq
     */
    eProsima_user_DllExport void member_seq(
            const CompleteAnnotationParameterSeq& _member_seq)
    {
        m_member_seq = _member_seq;
    }

    /*!
     * @brief This function moves the value in member member_seq
     * @param _member_seq New value to be moved in member member_seq
     */
    eProsima_user_DllExport void member_seq(
            CompleteAnnotationParameterSeq&& _member_seq)
    {
        m_member_seq = std::move(_member_seq);
    }

    /*!
     * @brief This function returns a constant reference to member member_seq
     * @return Constant reference to member member_seq
     */
    eProsima_user_DllExport const CompleteAnnotationParameterSeq& member_seq() const
    {
        return m_member_seq;
    }

    /*!
     * @brief This function returns a reference to member member_seq
     * @return Reference to member member_seq
     */
    eProsima_user_DllExport CompleteAnnotationParameterSeq& member_seq()
    {
        return m_member_seq;
    }



private:

    AnnotationTypeFlag m_annotation_flag{0};
    CompleteAnnotationHeader m_header;
    CompleteAnnotationParameterSeq m_member_seq;

};
/*!
 * @brief This class represents the structure MinimalAnnotationType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalAnnotationType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalAnnotationType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalAnnotationType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalAnnotationType that will be copied.
     */
    eProsima_user_DllExport MinimalAnnotationType(
            const MinimalAnnotationType& x)
    {
                    m_annotation_flag = x.m_annotation_flag;

                    m_header = x.m_header;

                    m_member_seq = x.m_member_seq;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalAnnotationType that will be copied.
     */
    eProsima_user_DllExport MinimalAnnotationType(
            MinimalAnnotationType&& x) noexcept
    {
        m_annotation_flag = std::move(x.m_annotation_flag);
        m_header = std::move(x.m_header);
        m_member_seq = std::move(x.m_member_seq);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalAnnotationType that will be copied.
     */
    eProsima_user_DllExport MinimalAnnotationType& operator =(
            const MinimalAnnotationType& x)
    {

                    m_annotation_flag = x.m_annotation_flag;

                    m_header = x.m_header;

                    m_member_seq = x.m_member_seq;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalAnnotationType that will be copied.
     */
    eProsima_user_DllExport MinimalAnnotationType& operator =(
            MinimalAnnotationType&& x) noexcept
    {

        m_annotation_flag = std::move(x.m_annotation_flag);
        m_header = std::move(x.m_header);
        m_member_seq = std::move(x.m_member_seq);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalAnnotationType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalAnnotationType& x) const
    {
        return (m_annotation_flag == x.m_annotation_flag &&
           m_header == x.m_header &&
           m_member_seq == x.m_member_seq);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalAnnotationType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalAnnotationType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member annotation_flag
     * @param _annotation_flag New value to be copied in member annotation_flag
     */
    eProsima_user_DllExport void annotation_flag(
            const AnnotationTypeFlag& _annotation_flag)
    {
        m_annotation_flag = _annotation_flag;
    }

    /*!
     * @brief This function moves the value in member annotation_flag
     * @param _annotation_flag New value to be moved in member annotation_flag
     */
    eProsima_user_DllExport void annotation_flag(
            AnnotationTypeFlag&& _annotation_flag)
    {
        m_annotation_flag = std::move(_annotation_flag);
    }

    /*!
     * @brief This function returns a constant reference to member annotation_flag
     * @return Constant reference to member annotation_flag
     */
    eProsima_user_DllExport const AnnotationTypeFlag& annotation_flag() const
    {
        return m_annotation_flag;
    }

    /*!
     * @brief This function returns a reference to member annotation_flag
     * @return Reference to member annotation_flag
     */
    eProsima_user_DllExport AnnotationTypeFlag& annotation_flag()
    {
        return m_annotation_flag;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const MinimalAnnotationHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            MinimalAnnotationHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const MinimalAnnotationHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport MinimalAnnotationHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member member_seq
     * @param _member_seq New value to be copied in member member_seq
     */
    eProsima_user_DllExport void member_seq(
            const MinimalAnnotationParameterSeq& _member_seq)
    {
        m_member_seq = _member_seq;
    }

    /*!
     * @brief This function moves the value in member member_seq
     * @param _member_seq New value to be moved in member member_seq
     */
    eProsima_user_DllExport void member_seq(
            MinimalAnnotationParameterSeq&& _member_seq)
    {
        m_member_seq = std::move(_member_seq);
    }

    /*!
     * @brief This function returns a constant reference to member member_seq
     * @return Constant reference to member member_seq
     */
    eProsima_user_DllExport const MinimalAnnotationParameterSeq& member_seq() const
    {
        return m_member_seq;
    }

    /*!
     * @brief This function returns a reference to member member_seq
     * @return Reference to member member_seq
     */
    eProsima_user_DllExport MinimalAnnotationParameterSeq& member_seq()
    {
        return m_member_seq;
    }



private:

    AnnotationTypeFlag m_annotation_flag{0};
    MinimalAnnotationHeader m_header;
    MinimalAnnotationParameterSeq m_member_seq;

};
/*!
 * @brief This class represents the structure CommonAliasBody defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CommonAliasBody
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CommonAliasBody()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CommonAliasBody()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CommonAliasBody that will be copied.
     */
    eProsima_user_DllExport CommonAliasBody(
            const CommonAliasBody& x)
    {
                    m_related_flags = x.m_related_flags;

                    m_related_type = x.m_related_type;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CommonAliasBody that will be copied.
     */
    eProsima_user_DllExport CommonAliasBody(
            CommonAliasBody&& x) noexcept
    {
        m_related_flags = std::move(x.m_related_flags);
        m_related_type = std::move(x.m_related_type);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CommonAliasBody that will be copied.
     */
    eProsima_user_DllExport CommonAliasBody& operator =(
            const CommonAliasBody& x)
    {

                    m_related_flags = x.m_related_flags;

                    m_related_type = x.m_related_type;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CommonAliasBody that will be copied.
     */
    eProsima_user_DllExport CommonAliasBody& operator =(
            CommonAliasBody&& x) noexcept
    {

        m_related_flags = std::move(x.m_related_flags);
        m_related_type = std::move(x.m_related_type);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonAliasBody object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CommonAliasBody& x) const
    {
        return (m_related_flags == x.m_related_flags &&
           m_related_type == x.m_related_type);
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonAliasBody object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CommonAliasBody& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member related_flags
     * @param _related_flags New value to be copied in member related_flags
     */
    eProsima_user_DllExport void related_flags(
            const AliasMemberFlag& _related_flags)
    {
        m_related_flags = _related_flags;
    }

    /*!
     * @brief This function moves the value in member related_flags
     * @param _related_flags New value to be moved in member related_flags
     */
    eProsima_user_DllExport void related_flags(
            AliasMemberFlag&& _related_flags)
    {
        m_related_flags = std::move(_related_flags);
    }

    /*!
     * @brief This function returns a constant reference to member related_flags
     * @return Constant reference to member related_flags
     */
    eProsima_user_DllExport const AliasMemberFlag& related_flags() const
    {
        return m_related_flags;
    }

    /*!
     * @brief This function returns a reference to member related_flags
     * @return Reference to member related_flags
     */
    eProsima_user_DllExport AliasMemberFlag& related_flags()
    {
        return m_related_flags;
    }


    /*!
     * @brief This function copies the value in member related_type
     * @param _related_type New value to be copied in member related_type
     */
    eProsima_user_DllExport void related_type(
            const TypeIdentifier& _related_type)
    {
        m_related_type = _related_type;
    }

    /*!
     * @brief This function moves the value in member related_type
     * @param _related_type New value to be moved in member related_type
     */
    eProsima_user_DllExport void related_type(
            TypeIdentifier&& _related_type)
    {
        m_related_type = std::move(_related_type);
    }

    /*!
     * @brief This function returns a constant reference to member related_type
     * @return Constant reference to member related_type
     */
    eProsima_user_DllExport const TypeIdentifier& related_type() const
    {
        return m_related_type;
    }

    /*!
     * @brief This function returns a reference to member related_type
     * @return Reference to member related_type
     */
    eProsima_user_DllExport TypeIdentifier& related_type()
    {
        return m_related_type;
    }



private:

    AliasMemberFlag m_related_flags{0};
    TypeIdentifier m_related_type;

};
/*!
 * @brief This class represents the structure CompleteAliasBody defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteAliasBody
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteAliasBody()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteAliasBody()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteAliasBody that will be copied.
     */
    eProsima_user_DllExport CompleteAliasBody(
            const CompleteAliasBody& x)
    {
                    m_common = x.m_common;

                    m_ann_builtin = x.m_ann_builtin;

                    m_ann_custom = x.m_ann_custom;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteAliasBody that will be copied.
     */
    eProsima_user_DllExport CompleteAliasBody(
            CompleteAliasBody&& x) noexcept
    {
        m_common = std::move(x.m_common);
        m_ann_builtin = std::move(x.m_ann_builtin);
        m_ann_custom = std::move(x.m_ann_custom);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteAliasBody that will be copied.
     */
    eProsima_user_DllExport CompleteAliasBody& operator =(
            const CompleteAliasBody& x)
    {

                    m_common = x.m_common;

                    m_ann_builtin = x.m_ann_builtin;

                    m_ann_custom = x.m_ann_custom;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteAliasBody that will be copied.
     */
    eProsima_user_DllExport CompleteAliasBody& operator =(
            CompleteAliasBody&& x) noexcept
    {

        m_common = std::move(x.m_common);
        m_ann_builtin = std::move(x.m_ann_builtin);
        m_ann_custom = std::move(x.m_ann_custom);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteAliasBody object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteAliasBody& x) const
    {
        return (m_common == x.m_common &&
           m_ann_builtin == x.m_ann_builtin &&
           m_ann_custom == x.m_ann_custom);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteAliasBody object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteAliasBody& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonAliasBody& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonAliasBody&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonAliasBody& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonAliasBody& common()
    {
        return m_common;
    }


    /*!
     * @brief This function copies the value in member ann_builtin
     * @param _ann_builtin New value to be copied in member ann_builtin
     */
    eProsima_user_DllExport void ann_builtin(
            const eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations>& _ann_builtin)
    {
        m_ann_builtin = _ann_builtin;
    }

    /*!
     * @brief This function moves the value in member ann_builtin
     * @param _ann_builtin New value to be moved in member ann_builtin
     */
    eProsima_user_DllExport void ann_builtin(
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations>&& _ann_builtin)
    {
        m_ann_builtin = std::move(_ann_builtin);
    }

    /*!
     * @brief This function returns a constant reference to member ann_builtin
     * @return Constant reference to member ann_builtin
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations>& ann_builtin() const
    {
        return m_ann_builtin;
    }

    /*!
     * @brief This function returns a reference to member ann_builtin
     * @return Reference to member ann_builtin
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations>& ann_builtin()
    {
        return m_ann_builtin;
    }


    /*!
     * @brief This function copies the value in member ann_custom
     * @param _ann_custom New value to be copied in member ann_custom
     */
    eProsima_user_DllExport void ann_custom(
            const eprosima::fastcdr::optional<AppliedAnnotationSeq>& _ann_custom)
    {
        m_ann_custom = _ann_custom;
    }

    /*!
     * @brief This function moves the value in member ann_custom
     * @param _ann_custom New value to be moved in member ann_custom
     */
    eProsima_user_DllExport void ann_custom(
            eprosima::fastcdr::optional<AppliedAnnotationSeq>&& _ann_custom)
    {
        m_ann_custom = std::move(_ann_custom);
    }

    /*!
     * @brief This function returns a constant reference to member ann_custom
     * @return Constant reference to member ann_custom
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<AppliedAnnotationSeq>& ann_custom() const
    {
        return m_ann_custom;
    }

    /*!
     * @brief This function returns a reference to member ann_custom
     * @return Reference to member ann_custom
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<AppliedAnnotationSeq>& ann_custom()
    {
        return m_ann_custom;
    }



private:

    CommonAliasBody m_common;
    eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> m_ann_builtin;
    eprosima::fastcdr::optional<AppliedAnnotationSeq> m_ann_custom;

};
/*!
 * @brief This class represents the structure MinimalAliasBody defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalAliasBody
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalAliasBody()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalAliasBody()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalAliasBody that will be copied.
     */
    eProsima_user_DllExport MinimalAliasBody(
            const MinimalAliasBody& x)
    {
                    m_common = x.m_common;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalAliasBody that will be copied.
     */
    eProsima_user_DllExport MinimalAliasBody(
            MinimalAliasBody&& x) noexcept
    {
        m_common = std::move(x.m_common);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalAliasBody that will be copied.
     */
    eProsima_user_DllExport MinimalAliasBody& operator =(
            const MinimalAliasBody& x)
    {

                    m_common = x.m_common;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalAliasBody that will be copied.
     */
    eProsima_user_DllExport MinimalAliasBody& operator =(
            MinimalAliasBody&& x) noexcept
    {

        m_common = std::move(x.m_common);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalAliasBody object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalAliasBody& x) const
    {
        return (m_common == x.m_common);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalAliasBody object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalAliasBody& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonAliasBody& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonAliasBody&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonAliasBody& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonAliasBody& common()
    {
        return m_common;
    }



private:

    CommonAliasBody m_common;

};
/*!
 * @brief This class represents the structure CompleteAliasHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteAliasHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteAliasHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteAliasHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteAliasHeader that will be copied.
     */
    eProsima_user_DllExport CompleteAliasHeader(
            const CompleteAliasHeader& x)
    {
                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteAliasHeader that will be copied.
     */
    eProsima_user_DllExport CompleteAliasHeader(
            CompleteAliasHeader&& x) noexcept
    {
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteAliasHeader that will be copied.
     */
    eProsima_user_DllExport CompleteAliasHeader& operator =(
            const CompleteAliasHeader& x)
    {

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteAliasHeader that will be copied.
     */
    eProsima_user_DllExport CompleteAliasHeader& operator =(
            CompleteAliasHeader&& x) noexcept
    {

        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteAliasHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteAliasHeader& x) const
    {
        return (m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteAliasHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteAliasHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const CompleteTypeDetail& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            CompleteTypeDetail&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const CompleteTypeDetail& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport CompleteTypeDetail& detail()
    {
        return m_detail;
    }



private:

    CompleteTypeDetail m_detail;

};
/*!
 * @brief This class represents the structure MinimalAliasHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalAliasHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalAliasHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalAliasHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalAliasHeader that will be copied.
     */
    eProsima_user_DllExport MinimalAliasHeader(
            const MinimalAliasHeader& x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalAliasHeader that will be copied.
     */
    eProsima_user_DllExport MinimalAliasHeader(
            MinimalAliasHeader&& x) noexcept
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalAliasHeader that will be copied.
     */
    eProsima_user_DllExport MinimalAliasHeader& operator =(
            const MinimalAliasHeader& x)
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalAliasHeader that will be copied.
     */
    eProsima_user_DllExport MinimalAliasHeader& operator =(
            MinimalAliasHeader&& x) noexcept
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalAliasHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalAliasHeader& x) const
    {
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalAliasHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalAliasHeader& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the structure CompleteAliasType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteAliasType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteAliasType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteAliasType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteAliasType that will be copied.
     */
    eProsima_user_DllExport CompleteAliasType(
            const CompleteAliasType& x)
    {
                    m_alias_flags = x.m_alias_flags;

                    m_header = x.m_header;

                    m_body = x.m_body;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteAliasType that will be copied.
     */
    eProsima_user_DllExport CompleteAliasType(
            CompleteAliasType&& x) noexcept
    {
        m_alias_flags = std::move(x.m_alias_flags);
        m_header = std::move(x.m_header);
        m_body = std::move(x.m_body);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteAliasType that will be copied.
     */
    eProsima_user_DllExport CompleteAliasType& operator =(
            const CompleteAliasType& x)
    {

                    m_alias_flags = x.m_alias_flags;

                    m_header = x.m_header;

                    m_body = x.m_body;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteAliasType that will be copied.
     */
    eProsima_user_DllExport CompleteAliasType& operator =(
            CompleteAliasType&& x) noexcept
    {

        m_alias_flags = std::move(x.m_alias_flags);
        m_header = std::move(x.m_header);
        m_body = std::move(x.m_body);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteAliasType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteAliasType& x) const
    {
        return (m_alias_flags == x.m_alias_flags &&
           m_header == x.m_header &&
           m_body == x.m_body);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteAliasType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteAliasType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member alias_flags
     * @param _alias_flags New value to be copied in member alias_flags
     */
    eProsima_user_DllExport void alias_flags(
            const AliasTypeFlag& _alias_flags)
    {
        m_alias_flags = _alias_flags;
    }

    /*!
     * @brief This function moves the value in member alias_flags
     * @param _alias_flags New value to be moved in member alias_flags
     */
    eProsima_user_DllExport void alias_flags(
            AliasTypeFlag&& _alias_flags)
    {
        m_alias_flags = std::move(_alias_flags);
    }

    /*!
     * @brief This function returns a constant reference to member alias_flags
     * @return Constant reference to member alias_flags
     */
    eProsima_user_DllExport const AliasTypeFlag& alias_flags() const
    {
        return m_alias_flags;
    }

    /*!
     * @brief This function returns a reference to member alias_flags
     * @return Reference to member alias_flags
     */
    eProsima_user_DllExport AliasTypeFlag& alias_flags()
    {
        return m_alias_flags;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const CompleteAliasHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            CompleteAliasHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const CompleteAliasHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport CompleteAliasHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member body
     * @param _body New value to be copied in member body
     */
    eProsima_user_DllExport void body(
            const CompleteAliasBody& _body)
    {
        m_body = _body;
    }

    /*!
     * @brief This function moves the value in member body
     * @param _body New value to be moved in member body
     */
    eProsima_user_DllExport void body(
            CompleteAliasBody&& _body)
    {
        m_body = std::move(_body);
    }

    /*!
     * @brief This function returns a constant reference to member body
     * @return Constant reference to member body
     */
    eProsima_user_DllExport const CompleteAliasBody& body() const
    {
        return m_body;
    }

    /*!
     * @brief This function returns a reference to member body
     * @return Reference to member body
     */
    eProsima_user_DllExport CompleteAliasBody& body()
    {
        return m_body;
    }



private:

    AliasTypeFlag m_alias_flags{0};
    CompleteAliasHeader m_header;
    CompleteAliasBody m_body;

};
/*!
 * @brief This class represents the structure MinimalAliasType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalAliasType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalAliasType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalAliasType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalAliasType that will be copied.
     */
    eProsima_user_DllExport MinimalAliasType(
            const MinimalAliasType& x)
    {
                    m_alias_flags = x.m_alias_flags;

                    m_header = x.m_header;

                    m_body = x.m_body;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalAliasType that will be copied.
     */
    eProsima_user_DllExport MinimalAliasType(
            MinimalAliasType&& x) noexcept
    {
        m_alias_flags = std::move(x.m_alias_flags);
        m_header = std::move(x.m_header);
        m_body = std::move(x.m_body);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalAliasType that will be copied.
     */
    eProsima_user_DllExport MinimalAliasType& operator =(
            const MinimalAliasType& x)
    {

                    m_alias_flags = x.m_alias_flags;

                    m_header = x.m_header;

                    m_body = x.m_body;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalAliasType that will be copied.
     */
    eProsima_user_DllExport MinimalAliasType& operator =(
            MinimalAliasType&& x) noexcept
    {

        m_alias_flags = std::move(x.m_alias_flags);
        m_header = std::move(x.m_header);
        m_body = std::move(x.m_body);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalAliasType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalAliasType& x) const
    {
        return (m_alias_flags == x.m_alias_flags &&
           m_header == x.m_header &&
           m_body == x.m_body);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalAliasType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalAliasType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member alias_flags
     * @param _alias_flags New value to be copied in member alias_flags
     */
    eProsima_user_DllExport void alias_flags(
            const AliasTypeFlag& _alias_flags)
    {
        m_alias_flags = _alias_flags;
    }

    /*!
     * @brief This function moves the value in member alias_flags
     * @param _alias_flags New value to be moved in member alias_flags
     */
    eProsima_user_DllExport void alias_flags(
            AliasTypeFlag&& _alias_flags)
    {
        m_alias_flags = std::move(_alias_flags);
    }

    /*!
     * @brief This function returns a constant reference to member alias_flags
     * @return Constant reference to member alias_flags
     */
    eProsima_user_DllExport const AliasTypeFlag& alias_flags() const
    {
        return m_alias_flags;
    }

    /*!
     * @brief This function returns a reference to member alias_flags
     * @return Reference to member alias_flags
     */
    eProsima_user_DllExport AliasTypeFlag& alias_flags()
    {
        return m_alias_flags;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const MinimalAliasHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            MinimalAliasHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const MinimalAliasHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport MinimalAliasHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member body
     * @param _body New value to be copied in member body
     */
    eProsima_user_DllExport void body(
            const MinimalAliasBody& _body)
    {
        m_body = _body;
    }

    /*!
     * @brief This function moves the value in member body
     * @param _body New value to be moved in member body
     */
    eProsima_user_DllExport void body(
            MinimalAliasBody&& _body)
    {
        m_body = std::move(_body);
    }

    /*!
     * @brief This function returns a constant reference to member body
     * @return Constant reference to member body
     */
    eProsima_user_DllExport const MinimalAliasBody& body() const
    {
        return m_body;
    }

    /*!
     * @brief This function returns a reference to member body
     * @return Reference to member body
     */
    eProsima_user_DllExport MinimalAliasBody& body()
    {
        return m_body;
    }



private:

    AliasTypeFlag m_alias_flags{0};
    MinimalAliasHeader m_header;
    MinimalAliasBody m_body;

};
/*!
 * @brief This class represents the structure CompleteElementDetail defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteElementDetail
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteElementDetail()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteElementDetail()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteElementDetail that will be copied.
     */
    eProsima_user_DllExport CompleteElementDetail(
            const CompleteElementDetail& x)
    {
                    m_ann_builtin = x.m_ann_builtin;

                    m_ann_custom = x.m_ann_custom;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteElementDetail that will be copied.
     */
    eProsima_user_DllExport CompleteElementDetail(
            CompleteElementDetail&& x) noexcept
    {
        m_ann_builtin = std::move(x.m_ann_builtin);
        m_ann_custom = std::move(x.m_ann_custom);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteElementDetail that will be copied.
     */
    eProsima_user_DllExport CompleteElementDetail& operator =(
            const CompleteElementDetail& x)
    {

                    m_ann_builtin = x.m_ann_builtin;

                    m_ann_custom = x.m_ann_custom;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteElementDetail that will be copied.
     */
    eProsima_user_DllExport CompleteElementDetail& operator =(
            CompleteElementDetail&& x) noexcept
    {

        m_ann_builtin = std::move(x.m_ann_builtin);
        m_ann_custom = std::move(x.m_ann_custom);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteElementDetail object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteElementDetail& x) const
    {
        return (m_ann_builtin == x.m_ann_builtin &&
           m_ann_custom == x.m_ann_custom);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteElementDetail object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteElementDetail& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member ann_builtin
     * @param _ann_builtin New value to be copied in member ann_builtin
     */
    eProsima_user_DllExport void ann_builtin(
            const eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations>& _ann_builtin)
    {
        m_ann_builtin = _ann_builtin;
    }

    /*!
     * @brief This function moves the value in member ann_builtin
     * @param _ann_builtin New value to be moved in member ann_builtin
     */
    eProsima_user_DllExport void ann_builtin(
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations>&& _ann_builtin)
    {
        m_ann_builtin = std::move(_ann_builtin);
    }

    /*!
     * @brief This function returns a constant reference to member ann_builtin
     * @return Constant reference to member ann_builtin
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations>& ann_builtin() const
    {
        return m_ann_builtin;
    }

    /*!
     * @brief This function returns a reference to member ann_builtin
     * @return Reference to member ann_builtin
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations>& ann_builtin()
    {
        return m_ann_builtin;
    }


    /*!
     * @brief This function copies the value in member ann_custom
     * @param _ann_custom New value to be copied in member ann_custom
     */
    eProsima_user_DllExport void ann_custom(
            const eprosima::fastcdr::optional<AppliedAnnotationSeq>& _ann_custom)
    {
        m_ann_custom = _ann_custom;
    }

    /*!
     * @brief This function moves the value in member ann_custom
     * @param _ann_custom New value to be moved in member ann_custom
     */
    eProsima_user_DllExport void ann_custom(
            eprosima::fastcdr::optional<AppliedAnnotationSeq>&& _ann_custom)
    {
        m_ann_custom = std::move(_ann_custom);
    }

    /*!
     * @brief This function returns a constant reference to member ann_custom
     * @return Constant reference to member ann_custom
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<AppliedAnnotationSeq>& ann_custom() const
    {
        return m_ann_custom;
    }

    /*!
     * @brief This function returns a reference to member ann_custom
     * @return Reference to member ann_custom
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<AppliedAnnotationSeq>& ann_custom()
    {
        return m_ann_custom;
    }



private:

    eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> m_ann_builtin;
    eprosima::fastcdr::optional<AppliedAnnotationSeq> m_ann_custom;

};
/*!
 * @brief This class represents the structure CommonCollectionElement defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CommonCollectionElement
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CommonCollectionElement()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CommonCollectionElement()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CommonCollectionElement that will be copied.
     */
    eProsima_user_DllExport CommonCollectionElement(
            const CommonCollectionElement& x)
    {
                    m_element_flags = x.m_element_flags;

                    m_type = x.m_type;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CommonCollectionElement that will be copied.
     */
    eProsima_user_DllExport CommonCollectionElement(
            CommonCollectionElement&& x) noexcept
    {
        m_element_flags = std::move(x.m_element_flags);
        m_type = std::move(x.m_type);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CommonCollectionElement that will be copied.
     */
    eProsima_user_DllExport CommonCollectionElement& operator =(
            const CommonCollectionElement& x)
    {

                    m_element_flags = x.m_element_flags;

                    m_type = x.m_type;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CommonCollectionElement that will be copied.
     */
    eProsima_user_DllExport CommonCollectionElement& operator =(
            CommonCollectionElement&& x) noexcept
    {

        m_element_flags = std::move(x.m_element_flags);
        m_type = std::move(x.m_type);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonCollectionElement object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CommonCollectionElement& x) const
    {
        return (m_element_flags == x.m_element_flags &&
           m_type == x.m_type);
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonCollectionElement object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CommonCollectionElement& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member element_flags
     * @param _element_flags New value to be copied in member element_flags
     */
    eProsima_user_DllExport void element_flags(
            const CollectionElementFlag& _element_flags)
    {
        m_element_flags = _element_flags;
    }

    /*!
     * @brief This function moves the value in member element_flags
     * @param _element_flags New value to be moved in member element_flags
     */
    eProsima_user_DllExport void element_flags(
            CollectionElementFlag&& _element_flags)
    {
        m_element_flags = std::move(_element_flags);
    }

    /*!
     * @brief This function returns a constant reference to member element_flags
     * @return Constant reference to member element_flags
     */
    eProsima_user_DllExport const CollectionElementFlag& element_flags() const
    {
        return m_element_flags;
    }

    /*!
     * @brief This function returns a reference to member element_flags
     * @return Reference to member element_flags
     */
    eProsima_user_DllExport CollectionElementFlag& element_flags()
    {
        return m_element_flags;
    }


    /*!
     * @brief This function copies the value in member type
     * @param _type New value to be copied in member type
     */
    eProsima_user_DllExport void type(
            const TypeIdentifier& _type)
    {
        m_type = _type;
    }

    /*!
     * @brief This function moves the value in member type
     * @param _type New value to be moved in member type
     */
    eProsima_user_DllExport void type(
            TypeIdentifier&& _type)
    {
        m_type = std::move(_type);
    }

    /*!
     * @brief This function returns a constant reference to member type
     * @return Constant reference to member type
     */
    eProsima_user_DllExport const TypeIdentifier& type() const
    {
        return m_type;
    }

    /*!
     * @brief This function returns a reference to member type
     * @return Reference to member type
     */
    eProsima_user_DllExport TypeIdentifier& type()
    {
        return m_type;
    }



private:

    CollectionElementFlag m_element_flags{0};
    TypeIdentifier m_type;

};
/*!
 * @brief This class represents the structure CompleteCollectionElement defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteCollectionElement
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteCollectionElement()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteCollectionElement()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteCollectionElement that will be copied.
     */
    eProsima_user_DllExport CompleteCollectionElement(
            const CompleteCollectionElement& x)
    {
                    m_common = x.m_common;

                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteCollectionElement that will be copied.
     */
    eProsima_user_DllExport CompleteCollectionElement(
            CompleteCollectionElement&& x) noexcept
    {
        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteCollectionElement that will be copied.
     */
    eProsima_user_DllExport CompleteCollectionElement& operator =(
            const CompleteCollectionElement& x)
    {

                    m_common = x.m_common;

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteCollectionElement that will be copied.
     */
    eProsima_user_DllExport CompleteCollectionElement& operator =(
            CompleteCollectionElement&& x) noexcept
    {

        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteCollectionElement object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteCollectionElement& x) const
    {
        return (m_common == x.m_common &&
           m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteCollectionElement object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteCollectionElement& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonCollectionElement& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonCollectionElement&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonCollectionElement& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonCollectionElement& common()
    {
        return m_common;
    }


    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const CompleteElementDetail& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            CompleteElementDetail&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const CompleteElementDetail& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport CompleteElementDetail& detail()
    {
        return m_detail;
    }



private:

    CommonCollectionElement m_common;
    CompleteElementDetail m_detail;

};
/*!
 * @brief This class represents the structure MinimalCollectionElement defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalCollectionElement
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalCollectionElement()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalCollectionElement()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalCollectionElement that will be copied.
     */
    eProsima_user_DllExport MinimalCollectionElement(
            const MinimalCollectionElement& x)
    {
                    m_common = x.m_common;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalCollectionElement that will be copied.
     */
    eProsima_user_DllExport MinimalCollectionElement(
            MinimalCollectionElement&& x) noexcept
    {
        m_common = std::move(x.m_common);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalCollectionElement that will be copied.
     */
    eProsima_user_DllExport MinimalCollectionElement& operator =(
            const MinimalCollectionElement& x)
    {

                    m_common = x.m_common;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalCollectionElement that will be copied.
     */
    eProsima_user_DllExport MinimalCollectionElement& operator =(
            MinimalCollectionElement&& x) noexcept
    {

        m_common = std::move(x.m_common);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalCollectionElement object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalCollectionElement& x) const
    {
        return (m_common == x.m_common);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalCollectionElement object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalCollectionElement& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonCollectionElement& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonCollectionElement&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonCollectionElement& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonCollectionElement& common()
    {
        return m_common;
    }



private:

    CommonCollectionElement m_common;

};
/*!
 * @brief This class represents the structure CommonCollectionHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CommonCollectionHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CommonCollectionHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CommonCollectionHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CommonCollectionHeader that will be copied.
     */
    eProsima_user_DllExport CommonCollectionHeader(
            const CommonCollectionHeader& x)
    {
                    m_bound = x.m_bound;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CommonCollectionHeader that will be copied.
     */
    eProsima_user_DllExport CommonCollectionHeader(
            CommonCollectionHeader&& x) noexcept
    {
        m_bound = x.m_bound;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CommonCollectionHeader that will be copied.
     */
    eProsima_user_DllExport CommonCollectionHeader& operator =(
            const CommonCollectionHeader& x)
    {

                    m_bound = x.m_bound;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CommonCollectionHeader that will be copied.
     */
    eProsima_user_DllExport CommonCollectionHeader& operator =(
            CommonCollectionHeader&& x) noexcept
    {

        m_bound = x.m_bound;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonCollectionHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CommonCollectionHeader& x) const
    {
        return (m_bound == x.m_bound);
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonCollectionHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CommonCollectionHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member bound
     * @param _bound New value for member bound
     */
    eProsima_user_DllExport void bound(
            LBound _bound)
    {
        m_bound = _bound;
    }

    /*!
     * @brief This function returns the value of member bound
     * @return Value of member bound
     */
    eProsima_user_DllExport LBound bound() const
    {
        return m_bound;
    }

    /*!
     * @brief This function returns a reference to member bound
     * @return Reference to member bound
     */
    eProsima_user_DllExport LBound& bound()
    {
        return m_bound;
    }



private:

    LBound m_bound{0};

};
/*!
 * @brief This class represents the structure CompleteCollectionHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteCollectionHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteCollectionHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteCollectionHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteCollectionHeader that will be copied.
     */
    eProsima_user_DllExport CompleteCollectionHeader(
            const CompleteCollectionHeader& x)
    {
                    m_common = x.m_common;

                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteCollectionHeader that will be copied.
     */
    eProsima_user_DllExport CompleteCollectionHeader(
            CompleteCollectionHeader&& x) noexcept
    {
        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteCollectionHeader that will be copied.
     */
    eProsima_user_DllExport CompleteCollectionHeader& operator =(
            const CompleteCollectionHeader& x)
    {

                    m_common = x.m_common;

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteCollectionHeader that will be copied.
     */
    eProsima_user_DllExport CompleteCollectionHeader& operator =(
            CompleteCollectionHeader&& x) noexcept
    {

        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteCollectionHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteCollectionHeader& x) const
    {
        return (m_common == x.m_common &&
           m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteCollectionHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteCollectionHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonCollectionHeader& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonCollectionHeader&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonCollectionHeader& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonCollectionHeader& common()
    {
        return m_common;
    }


    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const eprosima::fastcdr::optional<CompleteTypeDetail>& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            eprosima::fastcdr::optional<CompleteTypeDetail>&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<CompleteTypeDetail>& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<CompleteTypeDetail>& detail()
    {
        return m_detail;
    }



private:

    CommonCollectionHeader m_common;
    eprosima::fastcdr::optional<CompleteTypeDetail> m_detail;

};
/*!
 * @brief This class represents the structure MinimalCollectionHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalCollectionHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalCollectionHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalCollectionHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalCollectionHeader that will be copied.
     */
    eProsima_user_DllExport MinimalCollectionHeader(
            const MinimalCollectionHeader& x)
    {
                    m_common = x.m_common;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalCollectionHeader that will be copied.
     */
    eProsima_user_DllExport MinimalCollectionHeader(
            MinimalCollectionHeader&& x) noexcept
    {
        m_common = std::move(x.m_common);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalCollectionHeader that will be copied.
     */
    eProsima_user_DllExport MinimalCollectionHeader& operator =(
            const MinimalCollectionHeader& x)
    {

                    m_common = x.m_common;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalCollectionHeader that will be copied.
     */
    eProsima_user_DllExport MinimalCollectionHeader& operator =(
            MinimalCollectionHeader&& x) noexcept
    {

        m_common = std::move(x.m_common);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalCollectionHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalCollectionHeader& x) const
    {
        return (m_common == x.m_common);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalCollectionHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalCollectionHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonCollectionHeader& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonCollectionHeader&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonCollectionHeader& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonCollectionHeader& common()
    {
        return m_common;
    }



private:

    CommonCollectionHeader m_common;

};
/*!
 * @brief This class represents the structure CompleteSequenceType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteSequenceType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteSequenceType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteSequenceType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteSequenceType that will be copied.
     */
    eProsima_user_DllExport CompleteSequenceType(
            const CompleteSequenceType& x)
    {
                    m_collection_flag = x.m_collection_flag;

                    m_header = x.m_header;

                    m_element = x.m_element;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteSequenceType that will be copied.
     */
    eProsima_user_DllExport CompleteSequenceType(
            CompleteSequenceType&& x) noexcept
    {
        m_collection_flag = std::move(x.m_collection_flag);
        m_header = std::move(x.m_header);
        m_element = std::move(x.m_element);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteSequenceType that will be copied.
     */
    eProsima_user_DllExport CompleteSequenceType& operator =(
            const CompleteSequenceType& x)
    {

                    m_collection_flag = x.m_collection_flag;

                    m_header = x.m_header;

                    m_element = x.m_element;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteSequenceType that will be copied.
     */
    eProsima_user_DllExport CompleteSequenceType& operator =(
            CompleteSequenceType&& x) noexcept
    {

        m_collection_flag = std::move(x.m_collection_flag);
        m_header = std::move(x.m_header);
        m_element = std::move(x.m_element);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteSequenceType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteSequenceType& x) const
    {
        return (m_collection_flag == x.m_collection_flag &&
           m_header == x.m_header &&
           m_element == x.m_element);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteSequenceType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteSequenceType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member collection_flag
     * @param _collection_flag New value to be copied in member collection_flag
     */
    eProsima_user_DllExport void collection_flag(
            const CollectionTypeFlag& _collection_flag)
    {
        m_collection_flag = _collection_flag;
    }

    /*!
     * @brief This function moves the value in member collection_flag
     * @param _collection_flag New value to be moved in member collection_flag
     */
    eProsima_user_DllExport void collection_flag(
            CollectionTypeFlag&& _collection_flag)
    {
        m_collection_flag = std::move(_collection_flag);
    }

    /*!
     * @brief This function returns a constant reference to member collection_flag
     * @return Constant reference to member collection_flag
     */
    eProsima_user_DllExport const CollectionTypeFlag& collection_flag() const
    {
        return m_collection_flag;
    }

    /*!
     * @brief This function returns a reference to member collection_flag
     * @return Reference to member collection_flag
     */
    eProsima_user_DllExport CollectionTypeFlag& collection_flag()
    {
        return m_collection_flag;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const CompleteCollectionHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            CompleteCollectionHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const CompleteCollectionHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport CompleteCollectionHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member element
     * @param _element New value to be copied in member element
     */
    eProsima_user_DllExport void element(
            const CompleteCollectionElement& _element)
    {
        m_element = _element;
    }

    /*!
     * @brief This function moves the value in member element
     * @param _element New value to be moved in member element
     */
    eProsima_user_DllExport void element(
            CompleteCollectionElement&& _element)
    {
        m_element = std::move(_element);
    }

    /*!
     * @brief This function returns a constant reference to member element
     * @return Constant reference to member element
     */
    eProsima_user_DllExport const CompleteCollectionElement& element() const
    {
        return m_element;
    }

    /*!
     * @brief This function returns a reference to member element
     * @return Reference to member element
     */
    eProsima_user_DllExport CompleteCollectionElement& element()
    {
        return m_element;
    }



private:

    CollectionTypeFlag m_collection_flag{0};
    CompleteCollectionHeader m_header;
    CompleteCollectionElement m_element;

};
/*!
 * @brief This class represents the structure MinimalSequenceType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalSequenceType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalSequenceType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalSequenceType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalSequenceType that will be copied.
     */
    eProsima_user_DllExport MinimalSequenceType(
            const MinimalSequenceType& x)
    {
                    m_collection_flag = x.m_collection_flag;

                    m_header = x.m_header;

                    m_element = x.m_element;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalSequenceType that will be copied.
     */
    eProsima_user_DllExport MinimalSequenceType(
            MinimalSequenceType&& x) noexcept
    {
        m_collection_flag = std::move(x.m_collection_flag);
        m_header = std::move(x.m_header);
        m_element = std::move(x.m_element);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalSequenceType that will be copied.
     */
    eProsima_user_DllExport MinimalSequenceType& operator =(
            const MinimalSequenceType& x)
    {

                    m_collection_flag = x.m_collection_flag;

                    m_header = x.m_header;

                    m_element = x.m_element;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalSequenceType that will be copied.
     */
    eProsima_user_DllExport MinimalSequenceType& operator =(
            MinimalSequenceType&& x) noexcept
    {

        m_collection_flag = std::move(x.m_collection_flag);
        m_header = std::move(x.m_header);
        m_element = std::move(x.m_element);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalSequenceType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalSequenceType& x) const
    {
        return (m_collection_flag == x.m_collection_flag &&
           m_header == x.m_header &&
           m_element == x.m_element);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalSequenceType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalSequenceType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member collection_flag
     * @param _collection_flag New value to be copied in member collection_flag
     */
    eProsima_user_DllExport void collection_flag(
            const CollectionTypeFlag& _collection_flag)
    {
        m_collection_flag = _collection_flag;
    }

    /*!
     * @brief This function moves the value in member collection_flag
     * @param _collection_flag New value to be moved in member collection_flag
     */
    eProsima_user_DllExport void collection_flag(
            CollectionTypeFlag&& _collection_flag)
    {
        m_collection_flag = std::move(_collection_flag);
    }

    /*!
     * @brief This function returns a constant reference to member collection_flag
     * @return Constant reference to member collection_flag
     */
    eProsima_user_DllExport const CollectionTypeFlag& collection_flag() const
    {
        return m_collection_flag;
    }

    /*!
     * @brief This function returns a reference to member collection_flag
     * @return Reference to member collection_flag
     */
    eProsima_user_DllExport CollectionTypeFlag& collection_flag()
    {
        return m_collection_flag;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const MinimalCollectionHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            MinimalCollectionHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const MinimalCollectionHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport MinimalCollectionHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member element
     * @param _element New value to be copied in member element
     */
    eProsima_user_DllExport void element(
            const MinimalCollectionElement& _element)
    {
        m_element = _element;
    }

    /*!
     * @brief This function moves the value in member element
     * @param _element New value to be moved in member element
     */
    eProsima_user_DllExport void element(
            MinimalCollectionElement&& _element)
    {
        m_element = std::move(_element);
    }

    /*!
     * @brief This function returns a constant reference to member element
     * @return Constant reference to member element
     */
    eProsima_user_DllExport const MinimalCollectionElement& element() const
    {
        return m_element;
    }

    /*!
     * @brief This function returns a reference to member element
     * @return Reference to member element
     */
    eProsima_user_DllExport MinimalCollectionElement& element()
    {
        return m_element;
    }



private:

    CollectionTypeFlag m_collection_flag{0};
    MinimalCollectionHeader m_header;
    MinimalCollectionElement m_element;

};
/*!
 * @brief This class represents the structure CommonArrayHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CommonArrayHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CommonArrayHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CommonArrayHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CommonArrayHeader that will be copied.
     */
    eProsima_user_DllExport CommonArrayHeader(
            const CommonArrayHeader& x)
    {
                    m_bound_seq = x.m_bound_seq;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CommonArrayHeader that will be copied.
     */
    eProsima_user_DllExport CommonArrayHeader(
            CommonArrayHeader&& x) noexcept
    {
        m_bound_seq = std::move(x.m_bound_seq);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CommonArrayHeader that will be copied.
     */
    eProsima_user_DllExport CommonArrayHeader& operator =(
            const CommonArrayHeader& x)
    {

                    m_bound_seq = x.m_bound_seq;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CommonArrayHeader that will be copied.
     */
    eProsima_user_DllExport CommonArrayHeader& operator =(
            CommonArrayHeader&& x) noexcept
    {

        m_bound_seq = std::move(x.m_bound_seq);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonArrayHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CommonArrayHeader& x) const
    {
        return (m_bound_seq == x.m_bound_seq);
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonArrayHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CommonArrayHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member bound_seq
     * @param _bound_seq New value to be copied in member bound_seq
     */
    eProsima_user_DllExport void bound_seq(
            const LBoundSeq& _bound_seq)
    {
        m_bound_seq = _bound_seq;
    }

    /*!
     * @brief This function moves the value in member bound_seq
     * @param _bound_seq New value to be moved in member bound_seq
     */
    eProsima_user_DllExport void bound_seq(
            LBoundSeq&& _bound_seq)
    {
        m_bound_seq = std::move(_bound_seq);
    }

    /*!
     * @brief This function returns a constant reference to member bound_seq
     * @return Constant reference to member bound_seq
     */
    eProsima_user_DllExport const LBoundSeq& bound_seq() const
    {
        return m_bound_seq;
    }

    /*!
     * @brief This function returns a reference to member bound_seq
     * @return Reference to member bound_seq
     */
    eProsima_user_DllExport LBoundSeq& bound_seq()
    {
        return m_bound_seq;
    }



private:

    LBoundSeq m_bound_seq;

};
/*!
 * @brief This class represents the structure CompleteArrayHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteArrayHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteArrayHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteArrayHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteArrayHeader that will be copied.
     */
    eProsima_user_DllExport CompleteArrayHeader(
            const CompleteArrayHeader& x)
    {
                    m_common = x.m_common;

                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteArrayHeader that will be copied.
     */
    eProsima_user_DllExport CompleteArrayHeader(
            CompleteArrayHeader&& x) noexcept
    {
        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteArrayHeader that will be copied.
     */
    eProsima_user_DllExport CompleteArrayHeader& operator =(
            const CompleteArrayHeader& x)
    {

                    m_common = x.m_common;

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteArrayHeader that will be copied.
     */
    eProsima_user_DllExport CompleteArrayHeader& operator =(
            CompleteArrayHeader&& x) noexcept
    {

        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteArrayHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteArrayHeader& x) const
    {
        return (m_common == x.m_common &&
           m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteArrayHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteArrayHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonArrayHeader& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonArrayHeader&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonArrayHeader& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonArrayHeader& common()
    {
        return m_common;
    }


    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const CompleteTypeDetail& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            CompleteTypeDetail&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const CompleteTypeDetail& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport CompleteTypeDetail& detail()
    {
        return m_detail;
    }



private:

    CommonArrayHeader m_common;
    CompleteTypeDetail m_detail;

};
/*!
 * @brief This class represents the structure MinimalArrayHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalArrayHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalArrayHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalArrayHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalArrayHeader that will be copied.
     */
    eProsima_user_DllExport MinimalArrayHeader(
            const MinimalArrayHeader& x)
    {
                    m_common = x.m_common;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalArrayHeader that will be copied.
     */
    eProsima_user_DllExport MinimalArrayHeader(
            MinimalArrayHeader&& x) noexcept
    {
        m_common = std::move(x.m_common);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalArrayHeader that will be copied.
     */
    eProsima_user_DllExport MinimalArrayHeader& operator =(
            const MinimalArrayHeader& x)
    {

                    m_common = x.m_common;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalArrayHeader that will be copied.
     */
    eProsima_user_DllExport MinimalArrayHeader& operator =(
            MinimalArrayHeader&& x) noexcept
    {

        m_common = std::move(x.m_common);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalArrayHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalArrayHeader& x) const
    {
        return (m_common == x.m_common);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalArrayHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalArrayHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonArrayHeader& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonArrayHeader&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonArrayHeader& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonArrayHeader& common()
    {
        return m_common;
    }



private:

    CommonArrayHeader m_common;

};
/*!
 * @brief This class represents the structure CompleteArrayType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteArrayType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteArrayType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteArrayType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteArrayType that will be copied.
     */
    eProsima_user_DllExport CompleteArrayType(
            const CompleteArrayType& x)
    {
                    m_collection_flag = x.m_collection_flag;

                    m_header = x.m_header;

                    m_element = x.m_element;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteArrayType that will be copied.
     */
    eProsima_user_DllExport CompleteArrayType(
            CompleteArrayType&& x) noexcept
    {
        m_collection_flag = std::move(x.m_collection_flag);
        m_header = std::move(x.m_header);
        m_element = std::move(x.m_element);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteArrayType that will be copied.
     */
    eProsima_user_DllExport CompleteArrayType& operator =(
            const CompleteArrayType& x)
    {

                    m_collection_flag = x.m_collection_flag;

                    m_header = x.m_header;

                    m_element = x.m_element;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteArrayType that will be copied.
     */
    eProsima_user_DllExport CompleteArrayType& operator =(
            CompleteArrayType&& x) noexcept
    {

        m_collection_flag = std::move(x.m_collection_flag);
        m_header = std::move(x.m_header);
        m_element = std::move(x.m_element);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteArrayType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteArrayType& x) const
    {
        return (m_collection_flag == x.m_collection_flag &&
           m_header == x.m_header &&
           m_element == x.m_element);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteArrayType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteArrayType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member collection_flag
     * @param _collection_flag New value to be copied in member collection_flag
     */
    eProsima_user_DllExport void collection_flag(
            const CollectionTypeFlag& _collection_flag)
    {
        m_collection_flag = _collection_flag;
    }

    /*!
     * @brief This function moves the value in member collection_flag
     * @param _collection_flag New value to be moved in member collection_flag
     */
    eProsima_user_DllExport void collection_flag(
            CollectionTypeFlag&& _collection_flag)
    {
        m_collection_flag = std::move(_collection_flag);
    }

    /*!
     * @brief This function returns a constant reference to member collection_flag
     * @return Constant reference to member collection_flag
     */
    eProsima_user_DllExport const CollectionTypeFlag& collection_flag() const
    {
        return m_collection_flag;
    }

    /*!
     * @brief This function returns a reference to member collection_flag
     * @return Reference to member collection_flag
     */
    eProsima_user_DllExport CollectionTypeFlag& collection_flag()
    {
        return m_collection_flag;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const CompleteArrayHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            CompleteArrayHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const CompleteArrayHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport CompleteArrayHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member element
     * @param _element New value to be copied in member element
     */
    eProsima_user_DllExport void element(
            const CompleteCollectionElement& _element)
    {
        m_element = _element;
    }

    /*!
     * @brief This function moves the value in member element
     * @param _element New value to be moved in member element
     */
    eProsima_user_DllExport void element(
            CompleteCollectionElement&& _element)
    {
        m_element = std::move(_element);
    }

    /*!
     * @brief This function returns a constant reference to member element
     * @return Constant reference to member element
     */
    eProsima_user_DllExport const CompleteCollectionElement& element() const
    {
        return m_element;
    }

    /*!
     * @brief This function returns a reference to member element
     * @return Reference to member element
     */
    eProsima_user_DllExport CompleteCollectionElement& element()
    {
        return m_element;
    }



private:

    CollectionTypeFlag m_collection_flag{0};
    CompleteArrayHeader m_header;
    CompleteCollectionElement m_element;

};
/*!
 * @brief This class represents the structure MinimalArrayType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalArrayType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalArrayType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalArrayType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalArrayType that will be copied.
     */
    eProsima_user_DllExport MinimalArrayType(
            const MinimalArrayType& x)
    {
                    m_collection_flag = x.m_collection_flag;

                    m_header = x.m_header;

                    m_element = x.m_element;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalArrayType that will be copied.
     */
    eProsima_user_DllExport MinimalArrayType(
            MinimalArrayType&& x) noexcept
    {
        m_collection_flag = std::move(x.m_collection_flag);
        m_header = std::move(x.m_header);
        m_element = std::move(x.m_element);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalArrayType that will be copied.
     */
    eProsima_user_DllExport MinimalArrayType& operator =(
            const MinimalArrayType& x)
    {

                    m_collection_flag = x.m_collection_flag;

                    m_header = x.m_header;

                    m_element = x.m_element;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalArrayType that will be copied.
     */
    eProsima_user_DllExport MinimalArrayType& operator =(
            MinimalArrayType&& x) noexcept
    {

        m_collection_flag = std::move(x.m_collection_flag);
        m_header = std::move(x.m_header);
        m_element = std::move(x.m_element);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalArrayType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalArrayType& x) const
    {
        return (m_collection_flag == x.m_collection_flag &&
           m_header == x.m_header &&
           m_element == x.m_element);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalArrayType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalArrayType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member collection_flag
     * @param _collection_flag New value to be copied in member collection_flag
     */
    eProsima_user_DllExport void collection_flag(
            const CollectionTypeFlag& _collection_flag)
    {
        m_collection_flag = _collection_flag;
    }

    /*!
     * @brief This function moves the value in member collection_flag
     * @param _collection_flag New value to be moved in member collection_flag
     */
    eProsima_user_DllExport void collection_flag(
            CollectionTypeFlag&& _collection_flag)
    {
        m_collection_flag = std::move(_collection_flag);
    }

    /*!
     * @brief This function returns a constant reference to member collection_flag
     * @return Constant reference to member collection_flag
     */
    eProsima_user_DllExport const CollectionTypeFlag& collection_flag() const
    {
        return m_collection_flag;
    }

    /*!
     * @brief This function returns a reference to member collection_flag
     * @return Reference to member collection_flag
     */
    eProsima_user_DllExport CollectionTypeFlag& collection_flag()
    {
        return m_collection_flag;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const MinimalArrayHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            MinimalArrayHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const MinimalArrayHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport MinimalArrayHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member element
     * @param _element New value to be copied in member element
     */
    eProsima_user_DllExport void element(
            const MinimalCollectionElement& _element)
    {
        m_element = _element;
    }

    /*!
     * @brief This function moves the value in member element
     * @param _element New value to be moved in member element
     */
    eProsima_user_DllExport void element(
            MinimalCollectionElement&& _element)
    {
        m_element = std::move(_element);
    }

    /*!
     * @brief This function returns a constant reference to member element
     * @return Constant reference to member element
     */
    eProsima_user_DllExport const MinimalCollectionElement& element() const
    {
        return m_element;
    }

    /*!
     * @brief This function returns a reference to member element
     * @return Reference to member element
     */
    eProsima_user_DllExport MinimalCollectionElement& element()
    {
        return m_element;
    }



private:

    CollectionTypeFlag m_collection_flag{0};
    MinimalArrayHeader m_header;
    MinimalCollectionElement m_element;

};
/*!
 * @brief This class represents the structure CompleteMapType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteMapType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteMapType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteMapType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteMapType that will be copied.
     */
    eProsima_user_DllExport CompleteMapType(
            const CompleteMapType& x)
    {
                    m_collection_flag = x.m_collection_flag;

                    m_header = x.m_header;

                    m_key = x.m_key;

                    m_element = x.m_element;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteMapType that will be copied.
     */
    eProsima_user_DllExport CompleteMapType(
            CompleteMapType&& x) noexcept
    {
        m_collection_flag = std::move(x.m_collection_flag);
        m_header = std::move(x.m_header);
        m_key = std::move(x.m_key);
        m_element = std::move(x.m_element);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteMapType that will be copied.
     */
    eProsima_user_DllExport CompleteMapType& operator =(
            const CompleteMapType& x)
    {

                    m_collection_flag = x.m_collection_flag;

                    m_header = x.m_header;

                    m_key = x.m_key;

                    m_element = x.m_element;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteMapType that will be copied.
     */
    eProsima_user_DllExport CompleteMapType& operator =(
            CompleteMapType&& x) noexcept
    {

        m_collection_flag = std::move(x.m_collection_flag);
        m_header = std::move(x.m_header);
        m_key = std::move(x.m_key);
        m_element = std::move(x.m_element);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteMapType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteMapType& x) const
    {
        return (m_collection_flag == x.m_collection_flag &&
           m_header == x.m_header &&
           m_key == x.m_key &&
           m_element == x.m_element);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteMapType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteMapType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member collection_flag
     * @param _collection_flag New value to be copied in member collection_flag
     */
    eProsima_user_DllExport void collection_flag(
            const CollectionTypeFlag& _collection_flag)
    {
        m_collection_flag = _collection_flag;
    }

    /*!
     * @brief This function moves the value in member collection_flag
     * @param _collection_flag New value to be moved in member collection_flag
     */
    eProsima_user_DllExport void collection_flag(
            CollectionTypeFlag&& _collection_flag)
    {
        m_collection_flag = std::move(_collection_flag);
    }

    /*!
     * @brief This function returns a constant reference to member collection_flag
     * @return Constant reference to member collection_flag
     */
    eProsima_user_DllExport const CollectionTypeFlag& collection_flag() const
    {
        return m_collection_flag;
    }

    /*!
     * @brief This function returns a reference to member collection_flag
     * @return Reference to member collection_flag
     */
    eProsima_user_DllExport CollectionTypeFlag& collection_flag()
    {
        return m_collection_flag;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const CompleteCollectionHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            CompleteCollectionHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const CompleteCollectionHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport CompleteCollectionHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member key
     * @param _key New value to be copied in member key
     */
    eProsima_user_DllExport void key(
            const CompleteCollectionElement& _key)
    {
        m_key = _key;
    }

    /*!
     * @brief This function moves the value in member key
     * @param _key New value to be moved in member key
     */
    eProsima_user_DllExport void key(
            CompleteCollectionElement&& _key)
    {
        m_key = std::move(_key);
    }

    /*!
     * @brief This function returns a constant reference to member key
     * @return Constant reference to member key
     */
    eProsima_user_DllExport const CompleteCollectionElement& key() const
    {
        return m_key;
    }

    /*!
     * @brief This function returns a reference to member key
     * @return Reference to member key
     */
    eProsima_user_DllExport CompleteCollectionElement& key()
    {
        return m_key;
    }


    /*!
     * @brief This function copies the value in member element
     * @param _element New value to be copied in member element
     */
    eProsima_user_DllExport void element(
            const CompleteCollectionElement& _element)
    {
        m_element = _element;
    }

    /*!
     * @brief This function moves the value in member element
     * @param _element New value to be moved in member element
     */
    eProsima_user_DllExport void element(
            CompleteCollectionElement&& _element)
    {
        m_element = std::move(_element);
    }

    /*!
     * @brief This function returns a constant reference to member element
     * @return Constant reference to member element
     */
    eProsima_user_DllExport const CompleteCollectionElement& element() const
    {
        return m_element;
    }

    /*!
     * @brief This function returns a reference to member element
     * @return Reference to member element
     */
    eProsima_user_DllExport CompleteCollectionElement& element()
    {
        return m_element;
    }



private:

    CollectionTypeFlag m_collection_flag{0};
    CompleteCollectionHeader m_header;
    CompleteCollectionElement m_key;
    CompleteCollectionElement m_element;

};
/*!
 * @brief This class represents the structure MinimalMapType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalMapType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalMapType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalMapType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalMapType that will be copied.
     */
    eProsima_user_DllExport MinimalMapType(
            const MinimalMapType& x)
    {
                    m_collection_flag = x.m_collection_flag;

                    m_header = x.m_header;

                    m_key = x.m_key;

                    m_element = x.m_element;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalMapType that will be copied.
     */
    eProsima_user_DllExport MinimalMapType(
            MinimalMapType&& x) noexcept
    {
        m_collection_flag = std::move(x.m_collection_flag);
        m_header = std::move(x.m_header);
        m_key = std::move(x.m_key);
        m_element = std::move(x.m_element);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalMapType that will be copied.
     */
    eProsima_user_DllExport MinimalMapType& operator =(
            const MinimalMapType& x)
    {

                    m_collection_flag = x.m_collection_flag;

                    m_header = x.m_header;

                    m_key = x.m_key;

                    m_element = x.m_element;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalMapType that will be copied.
     */
    eProsima_user_DllExport MinimalMapType& operator =(
            MinimalMapType&& x) noexcept
    {

        m_collection_flag = std::move(x.m_collection_flag);
        m_header = std::move(x.m_header);
        m_key = std::move(x.m_key);
        m_element = std::move(x.m_element);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalMapType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalMapType& x) const
    {
        return (m_collection_flag == x.m_collection_flag &&
           m_header == x.m_header &&
           m_key == x.m_key &&
           m_element == x.m_element);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalMapType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalMapType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member collection_flag
     * @param _collection_flag New value to be copied in member collection_flag
     */
    eProsima_user_DllExport void collection_flag(
            const CollectionTypeFlag& _collection_flag)
    {
        m_collection_flag = _collection_flag;
    }

    /*!
     * @brief This function moves the value in member collection_flag
     * @param _collection_flag New value to be moved in member collection_flag
     */
    eProsima_user_DllExport void collection_flag(
            CollectionTypeFlag&& _collection_flag)
    {
        m_collection_flag = std::move(_collection_flag);
    }

    /*!
     * @brief This function returns a constant reference to member collection_flag
     * @return Constant reference to member collection_flag
     */
    eProsima_user_DllExport const CollectionTypeFlag& collection_flag() const
    {
        return m_collection_flag;
    }

    /*!
     * @brief This function returns a reference to member collection_flag
     * @return Reference to member collection_flag
     */
    eProsima_user_DllExport CollectionTypeFlag& collection_flag()
    {
        return m_collection_flag;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const MinimalCollectionHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            MinimalCollectionHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const MinimalCollectionHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport MinimalCollectionHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member key
     * @param _key New value to be copied in member key
     */
    eProsima_user_DllExport void key(
            const MinimalCollectionElement& _key)
    {
        m_key = _key;
    }

    /*!
     * @brief This function moves the value in member key
     * @param _key New value to be moved in member key
     */
    eProsima_user_DllExport void key(
            MinimalCollectionElement&& _key)
    {
        m_key = std::move(_key);
    }

    /*!
     * @brief This function returns a constant reference to member key
     * @return Constant reference to member key
     */
    eProsima_user_DllExport const MinimalCollectionElement& key() const
    {
        return m_key;
    }

    /*!
     * @brief This function returns a reference to member key
     * @return Reference to member key
     */
    eProsima_user_DllExport MinimalCollectionElement& key()
    {
        return m_key;
    }


    /*!
     * @brief This function copies the value in member element
     * @param _element New value to be copied in member element
     */
    eProsima_user_DllExport void element(
            const MinimalCollectionElement& _element)
    {
        m_element = _element;
    }

    /*!
     * @brief This function moves the value in member element
     * @param _element New value to be moved in member element
     */
    eProsima_user_DllExport void element(
            MinimalCollectionElement&& _element)
    {
        m_element = std::move(_element);
    }

    /*!
     * @brief This function returns a constant reference to member element
     * @return Constant reference to member element
     */
    eProsima_user_DllExport const MinimalCollectionElement& element() const
    {
        return m_element;
    }

    /*!
     * @brief This function returns a reference to member element
     * @return Reference to member element
     */
    eProsima_user_DllExport MinimalCollectionElement& element()
    {
        return m_element;
    }



private:

    CollectionTypeFlag m_collection_flag{0};
    MinimalCollectionHeader m_header;
    MinimalCollectionElement m_key;
    MinimalCollectionElement m_element;

};
typedef uint16_t BitBound;

/*!
 * @brief This class represents the structure CommonEnumeratedLiteral defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CommonEnumeratedLiteral
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CommonEnumeratedLiteral()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CommonEnumeratedLiteral()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CommonEnumeratedLiteral that will be copied.
     */
    eProsima_user_DllExport CommonEnumeratedLiteral(
            const CommonEnumeratedLiteral& x)
    {
                    m_value = x.m_value;

                    m_flags = x.m_flags;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CommonEnumeratedLiteral that will be copied.
     */
    eProsima_user_DllExport CommonEnumeratedLiteral(
            CommonEnumeratedLiteral&& x) noexcept
    {
        m_value = x.m_value;
        m_flags = std::move(x.m_flags);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CommonEnumeratedLiteral that will be copied.
     */
    eProsima_user_DllExport CommonEnumeratedLiteral& operator =(
            const CommonEnumeratedLiteral& x)
    {

                    m_value = x.m_value;

                    m_flags = x.m_flags;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CommonEnumeratedLiteral that will be copied.
     */
    eProsima_user_DllExport CommonEnumeratedLiteral& operator =(
            CommonEnumeratedLiteral&& x) noexcept
    {

        m_value = x.m_value;
        m_flags = std::move(x.m_flags);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonEnumeratedLiteral object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CommonEnumeratedLiteral& x) const
    {
        return (m_value == x.m_value &&
           m_flags == x.m_flags);
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonEnumeratedLiteral object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CommonEnumeratedLiteral& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member value
     * @param _value New value for member value
     */
    eProsima_user_DllExport void value(
            int32_t _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function returns the value of member value
     * @return Value of member value
     */
    eProsima_user_DllExport int32_t value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport int32_t& value()
    {
        return m_value;
    }


    /*!
     * @brief This function copies the value in member flags
     * @param _flags New value to be copied in member flags
     */
    eProsima_user_DllExport void flags(
            const EnumeratedLiteralFlag& _flags)
    {
        m_flags = _flags;
    }

    /*!
     * @brief This function moves the value in member flags
     * @param _flags New value to be moved in member flags
     */
    eProsima_user_DllExport void flags(
            EnumeratedLiteralFlag&& _flags)
    {
        m_flags = std::move(_flags);
    }

    /*!
     * @brief This function returns a constant reference to member flags
     * @return Constant reference to member flags
     */
    eProsima_user_DllExport const EnumeratedLiteralFlag& flags() const
    {
        return m_flags;
    }

    /*!
     * @brief This function returns a reference to member flags
     * @return Reference to member flags
     */
    eProsima_user_DllExport EnumeratedLiteralFlag& flags()
    {
        return m_flags;
    }



private:

    int32_t m_value{0};
    EnumeratedLiteralFlag m_flags{0};

};
/*!
 * @brief This class represents the structure CompleteEnumeratedLiteral defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteEnumeratedLiteral
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteEnumeratedLiteral()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteEnumeratedLiteral()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteEnumeratedLiteral that will be copied.
     */
    eProsima_user_DllExport CompleteEnumeratedLiteral(
            const CompleteEnumeratedLiteral& x)
    {
                    m_common = x.m_common;

                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteEnumeratedLiteral that will be copied.
     */
    eProsima_user_DllExport CompleteEnumeratedLiteral(
            CompleteEnumeratedLiteral&& x) noexcept
    {
        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteEnumeratedLiteral that will be copied.
     */
    eProsima_user_DllExport CompleteEnumeratedLiteral& operator =(
            const CompleteEnumeratedLiteral& x)
    {

                    m_common = x.m_common;

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteEnumeratedLiteral that will be copied.
     */
    eProsima_user_DllExport CompleteEnumeratedLiteral& operator =(
            CompleteEnumeratedLiteral&& x) noexcept
    {

        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteEnumeratedLiteral object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteEnumeratedLiteral& x) const
    {
        return (m_common == x.m_common &&
           m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteEnumeratedLiteral object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteEnumeratedLiteral& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonEnumeratedLiteral& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonEnumeratedLiteral&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonEnumeratedLiteral& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonEnumeratedLiteral& common()
    {
        return m_common;
    }


    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const CompleteMemberDetail& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            CompleteMemberDetail&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const CompleteMemberDetail& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport CompleteMemberDetail& detail()
    {
        return m_detail;
    }



private:

    CommonEnumeratedLiteral m_common;
    CompleteMemberDetail m_detail;

};
typedef std::vector<CompleteEnumeratedLiteral> CompleteEnumeratedLiteralSeq;

/*!
 * @brief This class represents the structure MinimalEnumeratedLiteral defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalEnumeratedLiteral
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalEnumeratedLiteral()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalEnumeratedLiteral()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalEnumeratedLiteral that will be copied.
     */
    eProsima_user_DllExport MinimalEnumeratedLiteral(
            const MinimalEnumeratedLiteral& x)
    {
                    m_common = x.m_common;

                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalEnumeratedLiteral that will be copied.
     */
    eProsima_user_DllExport MinimalEnumeratedLiteral(
            MinimalEnumeratedLiteral&& x) noexcept
    {
        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalEnumeratedLiteral that will be copied.
     */
    eProsima_user_DllExport MinimalEnumeratedLiteral& operator =(
            const MinimalEnumeratedLiteral& x)
    {

                    m_common = x.m_common;

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalEnumeratedLiteral that will be copied.
     */
    eProsima_user_DllExport MinimalEnumeratedLiteral& operator =(
            MinimalEnumeratedLiteral&& x) noexcept
    {

        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalEnumeratedLiteral object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalEnumeratedLiteral& x) const
    {
        return (m_common == x.m_common &&
           m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalEnumeratedLiteral object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalEnumeratedLiteral& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonEnumeratedLiteral& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonEnumeratedLiteral&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonEnumeratedLiteral& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonEnumeratedLiteral& common()
    {
        return m_common;
    }


    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const MinimalMemberDetail& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            MinimalMemberDetail&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const MinimalMemberDetail& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport MinimalMemberDetail& detail()
    {
        return m_detail;
    }



private:

    CommonEnumeratedLiteral m_common;
    MinimalMemberDetail m_detail;

};
typedef std::vector<MinimalEnumeratedLiteral> MinimalEnumeratedLiteralSeq;

/*!
 * @brief This class represents the structure CommonEnumeratedHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CommonEnumeratedHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CommonEnumeratedHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CommonEnumeratedHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CommonEnumeratedHeader that will be copied.
     */
    eProsima_user_DllExport CommonEnumeratedHeader(
            const CommonEnumeratedHeader& x)
    {
                    m_bit_bound = x.m_bit_bound;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CommonEnumeratedHeader that will be copied.
     */
    eProsima_user_DllExport CommonEnumeratedHeader(
            CommonEnumeratedHeader&& x) noexcept
    {
        m_bit_bound = x.m_bit_bound;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CommonEnumeratedHeader that will be copied.
     */
    eProsima_user_DllExport CommonEnumeratedHeader& operator =(
            const CommonEnumeratedHeader& x)
    {

                    m_bit_bound = x.m_bit_bound;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CommonEnumeratedHeader that will be copied.
     */
    eProsima_user_DllExport CommonEnumeratedHeader& operator =(
            CommonEnumeratedHeader&& x) noexcept
    {

        m_bit_bound = x.m_bit_bound;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonEnumeratedHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CommonEnumeratedHeader& x) const
    {
        return (m_bit_bound == x.m_bit_bound);
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonEnumeratedHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CommonEnumeratedHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member bit_bound
     * @param _bit_bound New value for member bit_bound
     */
    eProsima_user_DllExport void bit_bound(
            BitBound _bit_bound)
    {
        m_bit_bound = _bit_bound;
    }

    /*!
     * @brief This function returns the value of member bit_bound
     * @return Value of member bit_bound
     */
    eProsima_user_DllExport BitBound bit_bound() const
    {
        return m_bit_bound;
    }

    /*!
     * @brief This function returns a reference to member bit_bound
     * @return Reference to member bit_bound
     */
    eProsima_user_DllExport BitBound& bit_bound()
    {
        return m_bit_bound;
    }



private:

    BitBound m_bit_bound{0};

};
/*!
 * @brief This class represents the structure CompleteEnumeratedHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteEnumeratedHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteEnumeratedHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteEnumeratedHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteEnumeratedHeader that will be copied.
     */
    eProsima_user_DllExport CompleteEnumeratedHeader(
            const CompleteEnumeratedHeader& x)
    {
                    m_common = x.m_common;

                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteEnumeratedHeader that will be copied.
     */
    eProsima_user_DllExport CompleteEnumeratedHeader(
            CompleteEnumeratedHeader&& x) noexcept
    {
        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteEnumeratedHeader that will be copied.
     */
    eProsima_user_DllExport CompleteEnumeratedHeader& operator =(
            const CompleteEnumeratedHeader& x)
    {

                    m_common = x.m_common;

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteEnumeratedHeader that will be copied.
     */
    eProsima_user_DllExport CompleteEnumeratedHeader& operator =(
            CompleteEnumeratedHeader&& x) noexcept
    {

        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteEnumeratedHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteEnumeratedHeader& x) const
    {
        return (m_common == x.m_common &&
           m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteEnumeratedHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteEnumeratedHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonEnumeratedHeader& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonEnumeratedHeader&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonEnumeratedHeader& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonEnumeratedHeader& common()
    {
        return m_common;
    }


    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const CompleteTypeDetail& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            CompleteTypeDetail&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const CompleteTypeDetail& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport CompleteTypeDetail& detail()
    {
        return m_detail;
    }



private:

    CommonEnumeratedHeader m_common;
    CompleteTypeDetail m_detail;

};
/*!
 * @brief This class represents the structure MinimalEnumeratedHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalEnumeratedHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalEnumeratedHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalEnumeratedHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalEnumeratedHeader that will be copied.
     */
    eProsima_user_DllExport MinimalEnumeratedHeader(
            const MinimalEnumeratedHeader& x)
    {
                    m_common = x.m_common;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalEnumeratedHeader that will be copied.
     */
    eProsima_user_DllExport MinimalEnumeratedHeader(
            MinimalEnumeratedHeader&& x) noexcept
    {
        m_common = std::move(x.m_common);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalEnumeratedHeader that will be copied.
     */
    eProsima_user_DllExport MinimalEnumeratedHeader& operator =(
            const MinimalEnumeratedHeader& x)
    {

                    m_common = x.m_common;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalEnumeratedHeader that will be copied.
     */
    eProsima_user_DllExport MinimalEnumeratedHeader& operator =(
            MinimalEnumeratedHeader&& x) noexcept
    {

        m_common = std::move(x.m_common);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalEnumeratedHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalEnumeratedHeader& x) const
    {
        return (m_common == x.m_common);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalEnumeratedHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalEnumeratedHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonEnumeratedHeader& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonEnumeratedHeader&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonEnumeratedHeader& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonEnumeratedHeader& common()
    {
        return m_common;
    }



private:

    CommonEnumeratedHeader m_common;

};
/*!
 * @brief This class represents the structure CompleteEnumeratedType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteEnumeratedType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteEnumeratedType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteEnumeratedType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteEnumeratedType that will be copied.
     */
    eProsima_user_DllExport CompleteEnumeratedType(
            const CompleteEnumeratedType& x)
    {
                    m_enum_flags = x.m_enum_flags;

                    m_header = x.m_header;

                    m_literal_seq = x.m_literal_seq;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteEnumeratedType that will be copied.
     */
    eProsima_user_DllExport CompleteEnumeratedType(
            CompleteEnumeratedType&& x) noexcept
    {
        m_enum_flags = std::move(x.m_enum_flags);
        m_header = std::move(x.m_header);
        m_literal_seq = std::move(x.m_literal_seq);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteEnumeratedType that will be copied.
     */
    eProsima_user_DllExport CompleteEnumeratedType& operator =(
            const CompleteEnumeratedType& x)
    {

                    m_enum_flags = x.m_enum_flags;

                    m_header = x.m_header;

                    m_literal_seq = x.m_literal_seq;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteEnumeratedType that will be copied.
     */
    eProsima_user_DllExport CompleteEnumeratedType& operator =(
            CompleteEnumeratedType&& x) noexcept
    {

        m_enum_flags = std::move(x.m_enum_flags);
        m_header = std::move(x.m_header);
        m_literal_seq = std::move(x.m_literal_seq);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteEnumeratedType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteEnumeratedType& x) const
    {
        return (m_enum_flags == x.m_enum_flags &&
           m_header == x.m_header &&
           m_literal_seq == x.m_literal_seq);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteEnumeratedType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteEnumeratedType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member enum_flags
     * @param _enum_flags New value to be copied in member enum_flags
     */
    eProsima_user_DllExport void enum_flags(
            const EnumTypeFlag& _enum_flags)
    {
        m_enum_flags = _enum_flags;
    }

    /*!
     * @brief This function moves the value in member enum_flags
     * @param _enum_flags New value to be moved in member enum_flags
     */
    eProsima_user_DllExport void enum_flags(
            EnumTypeFlag&& _enum_flags)
    {
        m_enum_flags = std::move(_enum_flags);
    }

    /*!
     * @brief This function returns a constant reference to member enum_flags
     * @return Constant reference to member enum_flags
     */
    eProsima_user_DllExport const EnumTypeFlag& enum_flags() const
    {
        return m_enum_flags;
    }

    /*!
     * @brief This function returns a reference to member enum_flags
     * @return Reference to member enum_flags
     */
    eProsima_user_DllExport EnumTypeFlag& enum_flags()
    {
        return m_enum_flags;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const CompleteEnumeratedHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            CompleteEnumeratedHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const CompleteEnumeratedHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport CompleteEnumeratedHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member literal_seq
     * @param _literal_seq New value to be copied in member literal_seq
     */
    eProsima_user_DllExport void literal_seq(
            const CompleteEnumeratedLiteralSeq& _literal_seq)
    {
        m_literal_seq = _literal_seq;
    }

    /*!
     * @brief This function moves the value in member literal_seq
     * @param _literal_seq New value to be moved in member literal_seq
     */
    eProsima_user_DllExport void literal_seq(
            CompleteEnumeratedLiteralSeq&& _literal_seq)
    {
        m_literal_seq = std::move(_literal_seq);
    }

    /*!
     * @brief This function returns a constant reference to member literal_seq
     * @return Constant reference to member literal_seq
     */
    eProsima_user_DllExport const CompleteEnumeratedLiteralSeq& literal_seq() const
    {
        return m_literal_seq;
    }

    /*!
     * @brief This function returns a reference to member literal_seq
     * @return Reference to member literal_seq
     */
    eProsima_user_DllExport CompleteEnumeratedLiteralSeq& literal_seq()
    {
        return m_literal_seq;
    }



private:

    EnumTypeFlag m_enum_flags{0};
    CompleteEnumeratedHeader m_header;
    CompleteEnumeratedLiteralSeq m_literal_seq;

};
/*!
 * @brief This class represents the structure MinimalEnumeratedType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalEnumeratedType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalEnumeratedType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalEnumeratedType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalEnumeratedType that will be copied.
     */
    eProsima_user_DllExport MinimalEnumeratedType(
            const MinimalEnumeratedType& x)
    {
                    m_enum_flags = x.m_enum_flags;

                    m_header = x.m_header;

                    m_literal_seq = x.m_literal_seq;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalEnumeratedType that will be copied.
     */
    eProsima_user_DllExport MinimalEnumeratedType(
            MinimalEnumeratedType&& x) noexcept
    {
        m_enum_flags = std::move(x.m_enum_flags);
        m_header = std::move(x.m_header);
        m_literal_seq = std::move(x.m_literal_seq);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalEnumeratedType that will be copied.
     */
    eProsima_user_DllExport MinimalEnumeratedType& operator =(
            const MinimalEnumeratedType& x)
    {

                    m_enum_flags = x.m_enum_flags;

                    m_header = x.m_header;

                    m_literal_seq = x.m_literal_seq;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalEnumeratedType that will be copied.
     */
    eProsima_user_DllExport MinimalEnumeratedType& operator =(
            MinimalEnumeratedType&& x) noexcept
    {

        m_enum_flags = std::move(x.m_enum_flags);
        m_header = std::move(x.m_header);
        m_literal_seq = std::move(x.m_literal_seq);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalEnumeratedType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalEnumeratedType& x) const
    {
        return (m_enum_flags == x.m_enum_flags &&
           m_header == x.m_header &&
           m_literal_seq == x.m_literal_seq);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalEnumeratedType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalEnumeratedType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member enum_flags
     * @param _enum_flags New value to be copied in member enum_flags
     */
    eProsima_user_DllExport void enum_flags(
            const EnumTypeFlag& _enum_flags)
    {
        m_enum_flags = _enum_flags;
    }

    /*!
     * @brief This function moves the value in member enum_flags
     * @param _enum_flags New value to be moved in member enum_flags
     */
    eProsima_user_DllExport void enum_flags(
            EnumTypeFlag&& _enum_flags)
    {
        m_enum_flags = std::move(_enum_flags);
    }

    /*!
     * @brief This function returns a constant reference to member enum_flags
     * @return Constant reference to member enum_flags
     */
    eProsima_user_DllExport const EnumTypeFlag& enum_flags() const
    {
        return m_enum_flags;
    }

    /*!
     * @brief This function returns a reference to member enum_flags
     * @return Reference to member enum_flags
     */
    eProsima_user_DllExport EnumTypeFlag& enum_flags()
    {
        return m_enum_flags;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const MinimalEnumeratedHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            MinimalEnumeratedHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const MinimalEnumeratedHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport MinimalEnumeratedHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member literal_seq
     * @param _literal_seq New value to be copied in member literal_seq
     */
    eProsima_user_DllExport void literal_seq(
            const MinimalEnumeratedLiteralSeq& _literal_seq)
    {
        m_literal_seq = _literal_seq;
    }

    /*!
     * @brief This function moves the value in member literal_seq
     * @param _literal_seq New value to be moved in member literal_seq
     */
    eProsima_user_DllExport void literal_seq(
            MinimalEnumeratedLiteralSeq&& _literal_seq)
    {
        m_literal_seq = std::move(_literal_seq);
    }

    /*!
     * @brief This function returns a constant reference to member literal_seq
     * @return Constant reference to member literal_seq
     */
    eProsima_user_DllExport const MinimalEnumeratedLiteralSeq& literal_seq() const
    {
        return m_literal_seq;
    }

    /*!
     * @brief This function returns a reference to member literal_seq
     * @return Reference to member literal_seq
     */
    eProsima_user_DllExport MinimalEnumeratedLiteralSeq& literal_seq()
    {
        return m_literal_seq;
    }



private:

    EnumTypeFlag m_enum_flags{0};
    MinimalEnumeratedHeader m_header;
    MinimalEnumeratedLiteralSeq m_literal_seq;

};
/*!
 * @brief This class represents the structure CommonBitflag defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CommonBitflag
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CommonBitflag()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CommonBitflag()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CommonBitflag that will be copied.
     */
    eProsima_user_DllExport CommonBitflag(
            const CommonBitflag& x)
    {
                    m_position = x.m_position;

                    m_flags = x.m_flags;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CommonBitflag that will be copied.
     */
    eProsima_user_DllExport CommonBitflag(
            CommonBitflag&& x) noexcept
    {
        m_position = x.m_position;
        m_flags = std::move(x.m_flags);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CommonBitflag that will be copied.
     */
    eProsima_user_DllExport CommonBitflag& operator =(
            const CommonBitflag& x)
    {

                    m_position = x.m_position;

                    m_flags = x.m_flags;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CommonBitflag that will be copied.
     */
    eProsima_user_DllExport CommonBitflag& operator =(
            CommonBitflag&& x) noexcept
    {

        m_position = x.m_position;
        m_flags = std::move(x.m_flags);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonBitflag object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CommonBitflag& x) const
    {
        return (m_position == x.m_position &&
           m_flags == x.m_flags);
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonBitflag object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CommonBitflag& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member position
     * @param _position New value for member position
     */
    eProsima_user_DllExport void position(
            uint16_t _position)
    {
        m_position = _position;
    }

    /*!
     * @brief This function returns the value of member position
     * @return Value of member position
     */
    eProsima_user_DllExport uint16_t position() const
    {
        return m_position;
    }

    /*!
     * @brief This function returns a reference to member position
     * @return Reference to member position
     */
    eProsima_user_DllExport uint16_t& position()
    {
        return m_position;
    }


    /*!
     * @brief This function copies the value in member flags
     * @param _flags New value to be copied in member flags
     */
    eProsima_user_DllExport void flags(
            const BitflagFlag& _flags)
    {
        m_flags = _flags;
    }

    /*!
     * @brief This function moves the value in member flags
     * @param _flags New value to be moved in member flags
     */
    eProsima_user_DllExport void flags(
            BitflagFlag&& _flags)
    {
        m_flags = std::move(_flags);
    }

    /*!
     * @brief This function returns a constant reference to member flags
     * @return Constant reference to member flags
     */
    eProsima_user_DllExport const BitflagFlag& flags() const
    {
        return m_flags;
    }

    /*!
     * @brief This function returns a reference to member flags
     * @return Reference to member flags
     */
    eProsima_user_DllExport BitflagFlag& flags()
    {
        return m_flags;
    }



private:

    uint16_t m_position{0};
    BitflagFlag m_flags{0};

};
/*!
 * @brief This class represents the structure CompleteBitflag defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteBitflag
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteBitflag()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteBitflag()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteBitflag that will be copied.
     */
    eProsima_user_DllExport CompleteBitflag(
            const CompleteBitflag& x)
    {
                    m_common = x.m_common;

                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteBitflag that will be copied.
     */
    eProsima_user_DllExport CompleteBitflag(
            CompleteBitflag&& x) noexcept
    {
        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteBitflag that will be copied.
     */
    eProsima_user_DllExport CompleteBitflag& operator =(
            const CompleteBitflag& x)
    {

                    m_common = x.m_common;

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteBitflag that will be copied.
     */
    eProsima_user_DllExport CompleteBitflag& operator =(
            CompleteBitflag&& x) noexcept
    {

        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteBitflag object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteBitflag& x) const
    {
        return (m_common == x.m_common &&
           m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteBitflag object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteBitflag& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonBitflag& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonBitflag&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonBitflag& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonBitflag& common()
    {
        return m_common;
    }


    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const CompleteMemberDetail& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            CompleteMemberDetail&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const CompleteMemberDetail& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport CompleteMemberDetail& detail()
    {
        return m_detail;
    }



private:

    CommonBitflag m_common;
    CompleteMemberDetail m_detail;

};
typedef std::vector<CompleteBitflag> CompleteBitflagSeq;

/*!
 * @brief This class represents the structure MinimalBitflag defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalBitflag
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalBitflag()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalBitflag()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalBitflag that will be copied.
     */
    eProsima_user_DllExport MinimalBitflag(
            const MinimalBitflag& x)
    {
                    m_common = x.m_common;

                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalBitflag that will be copied.
     */
    eProsima_user_DllExport MinimalBitflag(
            MinimalBitflag&& x) noexcept
    {
        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalBitflag that will be copied.
     */
    eProsima_user_DllExport MinimalBitflag& operator =(
            const MinimalBitflag& x)
    {

                    m_common = x.m_common;

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalBitflag that will be copied.
     */
    eProsima_user_DllExport MinimalBitflag& operator =(
            MinimalBitflag&& x) noexcept
    {

        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalBitflag object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalBitflag& x) const
    {
        return (m_common == x.m_common &&
           m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalBitflag object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalBitflag& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonBitflag& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonBitflag&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonBitflag& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonBitflag& common()
    {
        return m_common;
    }


    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const MinimalMemberDetail& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            MinimalMemberDetail&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const MinimalMemberDetail& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport MinimalMemberDetail& detail()
    {
        return m_detail;
    }



private:

    CommonBitflag m_common;
    MinimalMemberDetail m_detail;

};
typedef std::vector<MinimalBitflag> MinimalBitflagSeq;

/*!
 * @brief This class represents the structure CommonBitmaskHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CommonBitmaskHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CommonBitmaskHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CommonBitmaskHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CommonBitmaskHeader that will be copied.
     */
    eProsima_user_DllExport CommonBitmaskHeader(
            const CommonBitmaskHeader& x)
    {
                    m_bit_bound = x.m_bit_bound;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CommonBitmaskHeader that will be copied.
     */
    eProsima_user_DllExport CommonBitmaskHeader(
            CommonBitmaskHeader&& x) noexcept
    {
        m_bit_bound = x.m_bit_bound;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CommonBitmaskHeader that will be copied.
     */
    eProsima_user_DllExport CommonBitmaskHeader& operator =(
            const CommonBitmaskHeader& x)
    {

                    m_bit_bound = x.m_bit_bound;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CommonBitmaskHeader that will be copied.
     */
    eProsima_user_DllExport CommonBitmaskHeader& operator =(
            CommonBitmaskHeader&& x) noexcept
    {

        m_bit_bound = x.m_bit_bound;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonBitmaskHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CommonBitmaskHeader& x) const
    {
        return (m_bit_bound == x.m_bit_bound);
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonBitmaskHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CommonBitmaskHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member bit_bound
     * @param _bit_bound New value for member bit_bound
     */
    eProsima_user_DllExport void bit_bound(
            BitBound _bit_bound)
    {
        m_bit_bound = _bit_bound;
    }

    /*!
     * @brief This function returns the value of member bit_bound
     * @return Value of member bit_bound
     */
    eProsima_user_DllExport BitBound bit_bound() const
    {
        return m_bit_bound;
    }

    /*!
     * @brief This function returns a reference to member bit_bound
     * @return Reference to member bit_bound
     */
    eProsima_user_DllExport BitBound& bit_bound()
    {
        return m_bit_bound;
    }



private:

    BitBound m_bit_bound{0};

};
typedef CompleteEnumeratedHeader CompleteBitmaskHeader;

typedef MinimalEnumeratedHeader MinimalBitmaskHeader;

/*!
 * @brief This class represents the structure CompleteBitmaskType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteBitmaskType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteBitmaskType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteBitmaskType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteBitmaskType that will be copied.
     */
    eProsima_user_DllExport CompleteBitmaskType(
            const CompleteBitmaskType& x)
    {
                    m_bitmask_flags = x.m_bitmask_flags;

                    m_header = x.m_header;

                    m_flag_seq = x.m_flag_seq;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteBitmaskType that will be copied.
     */
    eProsima_user_DllExport CompleteBitmaskType(
            CompleteBitmaskType&& x) noexcept
    {
        m_bitmask_flags = std::move(x.m_bitmask_flags);
        m_header = std::move(x.m_header);
        m_flag_seq = std::move(x.m_flag_seq);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteBitmaskType that will be copied.
     */
    eProsima_user_DllExport CompleteBitmaskType& operator =(
            const CompleteBitmaskType& x)
    {

                    m_bitmask_flags = x.m_bitmask_flags;

                    m_header = x.m_header;

                    m_flag_seq = x.m_flag_seq;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteBitmaskType that will be copied.
     */
    eProsima_user_DllExport CompleteBitmaskType& operator =(
            CompleteBitmaskType&& x) noexcept
    {

        m_bitmask_flags = std::move(x.m_bitmask_flags);
        m_header = std::move(x.m_header);
        m_flag_seq = std::move(x.m_flag_seq);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteBitmaskType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteBitmaskType& x) const
    {
        return (m_bitmask_flags == x.m_bitmask_flags &&
           m_header == x.m_header &&
           m_flag_seq == x.m_flag_seq);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteBitmaskType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteBitmaskType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member bitmask_flags
     * @param _bitmask_flags New value to be copied in member bitmask_flags
     */
    eProsima_user_DllExport void bitmask_flags(
            const BitmaskTypeFlag& _bitmask_flags)
    {
        m_bitmask_flags = _bitmask_flags;
    }

    /*!
     * @brief This function moves the value in member bitmask_flags
     * @param _bitmask_flags New value to be moved in member bitmask_flags
     */
    eProsima_user_DllExport void bitmask_flags(
            BitmaskTypeFlag&& _bitmask_flags)
    {
        m_bitmask_flags = std::move(_bitmask_flags);
    }

    /*!
     * @brief This function returns a constant reference to member bitmask_flags
     * @return Constant reference to member bitmask_flags
     */
    eProsima_user_DllExport const BitmaskTypeFlag& bitmask_flags() const
    {
        return m_bitmask_flags;
    }

    /*!
     * @brief This function returns a reference to member bitmask_flags
     * @return Reference to member bitmask_flags
     */
    eProsima_user_DllExport BitmaskTypeFlag& bitmask_flags()
    {
        return m_bitmask_flags;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const CompleteBitmaskHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            CompleteBitmaskHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const CompleteBitmaskHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport CompleteBitmaskHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member flag_seq
     * @param _flag_seq New value to be copied in member flag_seq
     */
    eProsima_user_DllExport void flag_seq(
            const CompleteBitflagSeq& _flag_seq)
    {
        m_flag_seq = _flag_seq;
    }

    /*!
     * @brief This function moves the value in member flag_seq
     * @param _flag_seq New value to be moved in member flag_seq
     */
    eProsima_user_DllExport void flag_seq(
            CompleteBitflagSeq&& _flag_seq)
    {
        m_flag_seq = std::move(_flag_seq);
    }

    /*!
     * @brief This function returns a constant reference to member flag_seq
     * @return Constant reference to member flag_seq
     */
    eProsima_user_DllExport const CompleteBitflagSeq& flag_seq() const
    {
        return m_flag_seq;
    }

    /*!
     * @brief This function returns a reference to member flag_seq
     * @return Reference to member flag_seq
     */
    eProsima_user_DllExport CompleteBitflagSeq& flag_seq()
    {
        return m_flag_seq;
    }



private:

    BitmaskTypeFlag m_bitmask_flags{0};
    CompleteBitmaskHeader m_header;
    CompleteBitflagSeq m_flag_seq;

};
/*!
 * @brief This class represents the structure MinimalBitmaskType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalBitmaskType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalBitmaskType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalBitmaskType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalBitmaskType that will be copied.
     */
    eProsima_user_DllExport MinimalBitmaskType(
            const MinimalBitmaskType& x)
    {
                    m_bitmask_flags = x.m_bitmask_flags;

                    m_header = x.m_header;

                    m_flag_seq = x.m_flag_seq;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalBitmaskType that will be copied.
     */
    eProsima_user_DllExport MinimalBitmaskType(
            MinimalBitmaskType&& x) noexcept
    {
        m_bitmask_flags = std::move(x.m_bitmask_flags);
        m_header = std::move(x.m_header);
        m_flag_seq = std::move(x.m_flag_seq);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalBitmaskType that will be copied.
     */
    eProsima_user_DllExport MinimalBitmaskType& operator =(
            const MinimalBitmaskType& x)
    {

                    m_bitmask_flags = x.m_bitmask_flags;

                    m_header = x.m_header;

                    m_flag_seq = x.m_flag_seq;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalBitmaskType that will be copied.
     */
    eProsima_user_DllExport MinimalBitmaskType& operator =(
            MinimalBitmaskType&& x) noexcept
    {

        m_bitmask_flags = std::move(x.m_bitmask_flags);
        m_header = std::move(x.m_header);
        m_flag_seq = std::move(x.m_flag_seq);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalBitmaskType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalBitmaskType& x) const
    {
        return (m_bitmask_flags == x.m_bitmask_flags &&
           m_header == x.m_header &&
           m_flag_seq == x.m_flag_seq);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalBitmaskType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalBitmaskType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member bitmask_flags
     * @param _bitmask_flags New value to be copied in member bitmask_flags
     */
    eProsima_user_DllExport void bitmask_flags(
            const BitmaskTypeFlag& _bitmask_flags)
    {
        m_bitmask_flags = _bitmask_flags;
    }

    /*!
     * @brief This function moves the value in member bitmask_flags
     * @param _bitmask_flags New value to be moved in member bitmask_flags
     */
    eProsima_user_DllExport void bitmask_flags(
            BitmaskTypeFlag&& _bitmask_flags)
    {
        m_bitmask_flags = std::move(_bitmask_flags);
    }

    /*!
     * @brief This function returns a constant reference to member bitmask_flags
     * @return Constant reference to member bitmask_flags
     */
    eProsima_user_DllExport const BitmaskTypeFlag& bitmask_flags() const
    {
        return m_bitmask_flags;
    }

    /*!
     * @brief This function returns a reference to member bitmask_flags
     * @return Reference to member bitmask_flags
     */
    eProsima_user_DllExport BitmaskTypeFlag& bitmask_flags()
    {
        return m_bitmask_flags;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const MinimalBitmaskHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            MinimalBitmaskHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const MinimalBitmaskHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport MinimalBitmaskHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member flag_seq
     * @param _flag_seq New value to be copied in member flag_seq
     */
    eProsima_user_DllExport void flag_seq(
            const MinimalBitflagSeq& _flag_seq)
    {
        m_flag_seq = _flag_seq;
    }

    /*!
     * @brief This function moves the value in member flag_seq
     * @param _flag_seq New value to be moved in member flag_seq
     */
    eProsima_user_DllExport void flag_seq(
            MinimalBitflagSeq&& _flag_seq)
    {
        m_flag_seq = std::move(_flag_seq);
    }

    /*!
     * @brief This function returns a constant reference to member flag_seq
     * @return Constant reference to member flag_seq
     */
    eProsima_user_DllExport const MinimalBitflagSeq& flag_seq() const
    {
        return m_flag_seq;
    }

    /*!
     * @brief This function returns a reference to member flag_seq
     * @return Reference to member flag_seq
     */
    eProsima_user_DllExport MinimalBitflagSeq& flag_seq()
    {
        return m_flag_seq;
    }



private:

    BitmaskTypeFlag m_bitmask_flags{0};
    MinimalBitmaskHeader m_header;
    MinimalBitflagSeq m_flag_seq;

};
/*!
 * @brief This class represents the structure CommonBitfield defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CommonBitfield
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CommonBitfield()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CommonBitfield()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CommonBitfield that will be copied.
     */
    eProsima_user_DllExport CommonBitfield(
            const CommonBitfield& x)
    {
                    m_position = x.m_position;

                    m_flags = x.m_flags;

                    m_bitcount = x.m_bitcount;

                    m_holder_type = x.m_holder_type;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CommonBitfield that will be copied.
     */
    eProsima_user_DllExport CommonBitfield(
            CommonBitfield&& x) noexcept
    {
        m_position = x.m_position;
        m_flags = std::move(x.m_flags);
        m_bitcount = x.m_bitcount;
        m_holder_type = x.m_holder_type;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CommonBitfield that will be copied.
     */
    eProsima_user_DllExport CommonBitfield& operator =(
            const CommonBitfield& x)
    {

                    m_position = x.m_position;

                    m_flags = x.m_flags;

                    m_bitcount = x.m_bitcount;

                    m_holder_type = x.m_holder_type;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CommonBitfield that will be copied.
     */
    eProsima_user_DllExport CommonBitfield& operator =(
            CommonBitfield&& x) noexcept
    {

        m_position = x.m_position;
        m_flags = std::move(x.m_flags);
        m_bitcount = x.m_bitcount;
        m_holder_type = x.m_holder_type;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonBitfield object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CommonBitfield& x) const
    {
        return (m_position == x.m_position &&
           m_flags == x.m_flags &&
           m_bitcount == x.m_bitcount &&
           m_holder_type == x.m_holder_type);
    }

    /*!
     * @brief Comparison operator.
     * @param x CommonBitfield object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CommonBitfield& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member position
     * @param _position New value for member position
     */
    eProsima_user_DllExport void position(
            uint16_t _position)
    {
        m_position = _position;
    }

    /*!
     * @brief This function returns the value of member position
     * @return Value of member position
     */
    eProsima_user_DllExport uint16_t position() const
    {
        return m_position;
    }

    /*!
     * @brief This function returns a reference to member position
     * @return Reference to member position
     */
    eProsima_user_DllExport uint16_t& position()
    {
        return m_position;
    }


    /*!
     * @brief This function copies the value in member flags
     * @param _flags New value to be copied in member flags
     */
    eProsima_user_DllExport void flags(
            const BitsetMemberFlag& _flags)
    {
        m_flags = _flags;
    }

    /*!
     * @brief This function moves the value in member flags
     * @param _flags New value to be moved in member flags
     */
    eProsima_user_DllExport void flags(
            BitsetMemberFlag&& _flags)
    {
        m_flags = std::move(_flags);
    }

    /*!
     * @brief This function returns a constant reference to member flags
     * @return Constant reference to member flags
     */
    eProsima_user_DllExport const BitsetMemberFlag& flags() const
    {
        return m_flags;
    }

    /*!
     * @brief This function returns a reference to member flags
     * @return Reference to member flags
     */
    eProsima_user_DllExport BitsetMemberFlag& flags()
    {
        return m_flags;
    }


    /*!
     * @brief This function sets a value in member bitcount
     * @param _bitcount New value for member bitcount
     */
    eProsima_user_DllExport void bitcount(
            uint8_t _bitcount)
    {
        m_bitcount = _bitcount;
    }

    /*!
     * @brief This function returns the value of member bitcount
     * @return Value of member bitcount
     */
    eProsima_user_DllExport uint8_t bitcount() const
    {
        return m_bitcount;
    }

    /*!
     * @brief This function returns a reference to member bitcount
     * @return Reference to member bitcount
     */
    eProsima_user_DllExport uint8_t& bitcount()
    {
        return m_bitcount;
    }


    /*!
     * @brief This function sets a value in member holder_type
     * @param _holder_type New value for member holder_type
     */
    eProsima_user_DllExport void holder_type(
            TypeKind _holder_type)
    {
        m_holder_type = _holder_type;
    }

    /*!
     * @brief This function returns the value of member holder_type
     * @return Value of member holder_type
     */
    eProsima_user_DllExport TypeKind holder_type() const
    {
        return m_holder_type;
    }

    /*!
     * @brief This function returns a reference to member holder_type
     * @return Reference to member holder_type
     */
    eProsima_user_DllExport TypeKind& holder_type()
    {
        return m_holder_type;
    }



private:

    uint16_t m_position{0};
    BitsetMemberFlag m_flags{0};
    uint8_t m_bitcount{0};
    TypeKind m_holder_type{0};

};
/*!
 * @brief This class represents the structure CompleteBitfield defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteBitfield
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteBitfield()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteBitfield()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteBitfield that will be copied.
     */
    eProsima_user_DllExport CompleteBitfield(
            const CompleteBitfield& x)
    {
                    m_common = x.m_common;

                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteBitfield that will be copied.
     */
    eProsima_user_DllExport CompleteBitfield(
            CompleteBitfield&& x) noexcept
    {
        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteBitfield that will be copied.
     */
    eProsima_user_DllExport CompleteBitfield& operator =(
            const CompleteBitfield& x)
    {

                    m_common = x.m_common;

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteBitfield that will be copied.
     */
    eProsima_user_DllExport CompleteBitfield& operator =(
            CompleteBitfield&& x) noexcept
    {

        m_common = std::move(x.m_common);
        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteBitfield object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteBitfield& x) const
    {
        return (m_common == x.m_common &&
           m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteBitfield object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteBitfield& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonBitfield& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonBitfield&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonBitfield& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonBitfield& common()
    {
        return m_common;
    }


    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const CompleteMemberDetail& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            CompleteMemberDetail&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const CompleteMemberDetail& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport CompleteMemberDetail& detail()
    {
        return m_detail;
    }



private:

    CommonBitfield m_common;
    CompleteMemberDetail m_detail;

};
typedef std::vector<CompleteBitfield> CompleteBitfieldSeq;

/*!
 * @brief This class represents the structure MinimalBitfield defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalBitfield
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalBitfield()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalBitfield()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalBitfield that will be copied.
     */
    eProsima_user_DllExport MinimalBitfield(
            const MinimalBitfield& x)
    {
                    m_common = x.m_common;

                    m_name_hash = x.m_name_hash;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalBitfield that will be copied.
     */
    eProsima_user_DllExport MinimalBitfield(
            MinimalBitfield&& x) noexcept
    {
        m_common = std::move(x.m_common);
        m_name_hash = std::move(x.m_name_hash);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalBitfield that will be copied.
     */
    eProsima_user_DllExport MinimalBitfield& operator =(
            const MinimalBitfield& x)
    {

                    m_common = x.m_common;

                    m_name_hash = x.m_name_hash;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalBitfield that will be copied.
     */
    eProsima_user_DllExport MinimalBitfield& operator =(
            MinimalBitfield&& x) noexcept
    {

        m_common = std::move(x.m_common);
        m_name_hash = std::move(x.m_name_hash);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalBitfield object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalBitfield& x) const
    {
        return (m_common == x.m_common &&
           m_name_hash == x.m_name_hash);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalBitfield object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalBitfield& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member common
     * @param _common New value to be copied in member common
     */
    eProsima_user_DllExport void common(
            const CommonBitfield& _common)
    {
        m_common = _common;
    }

    /*!
     * @brief This function moves the value in member common
     * @param _common New value to be moved in member common
     */
    eProsima_user_DllExport void common(
            CommonBitfield&& _common)
    {
        m_common = std::move(_common);
    }

    /*!
     * @brief This function returns a constant reference to member common
     * @return Constant reference to member common
     */
    eProsima_user_DllExport const CommonBitfield& common() const
    {
        return m_common;
    }

    /*!
     * @brief This function returns a reference to member common
     * @return Reference to member common
     */
    eProsima_user_DllExport CommonBitfield& common()
    {
        return m_common;
    }


    /*!
     * @brief This function copies the value in member name_hash
     * @param _name_hash New value to be copied in member name_hash
     */
    eProsima_user_DllExport void name_hash(
            const NameHash& _name_hash)
    {
        m_name_hash = _name_hash;
    }

    /*!
     * @brief This function moves the value in member name_hash
     * @param _name_hash New value to be moved in member name_hash
     */
    eProsima_user_DllExport void name_hash(
            NameHash&& _name_hash)
    {
        m_name_hash = std::move(_name_hash);
    }

    /*!
     * @brief This function returns a constant reference to member name_hash
     * @return Constant reference to member name_hash
     */
    eProsima_user_DllExport const NameHash& name_hash() const
    {
        return m_name_hash;
    }

    /*!
     * @brief This function returns a reference to member name_hash
     * @return Reference to member name_hash
     */
    eProsima_user_DllExport NameHash& name_hash()
    {
        return m_name_hash;
    }



private:

    CommonBitfield m_common;
    NameHash m_name_hash{0};

};
typedef std::vector<MinimalBitfield> MinimalBitfieldSeq;

/*!
 * @brief This class represents the structure CompleteBitsetHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteBitsetHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteBitsetHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteBitsetHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteBitsetHeader that will be copied.
     */
    eProsima_user_DllExport CompleteBitsetHeader(
            const CompleteBitsetHeader& x)
    {
                    m_detail = x.m_detail;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteBitsetHeader that will be copied.
     */
    eProsima_user_DllExport CompleteBitsetHeader(
            CompleteBitsetHeader&& x) noexcept
    {
        m_detail = std::move(x.m_detail);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteBitsetHeader that will be copied.
     */
    eProsima_user_DllExport CompleteBitsetHeader& operator =(
            const CompleteBitsetHeader& x)
    {

                    m_detail = x.m_detail;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteBitsetHeader that will be copied.
     */
    eProsima_user_DllExport CompleteBitsetHeader& operator =(
            CompleteBitsetHeader&& x) noexcept
    {

        m_detail = std::move(x.m_detail);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteBitsetHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteBitsetHeader& x) const
    {
        return (m_detail == x.m_detail);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteBitsetHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteBitsetHeader& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member detail
     * @param _detail New value to be copied in member detail
     */
    eProsima_user_DllExport void detail(
            const CompleteTypeDetail& _detail)
    {
        m_detail = _detail;
    }

    /*!
     * @brief This function moves the value in member detail
     * @param _detail New value to be moved in member detail
     */
    eProsima_user_DllExport void detail(
            CompleteTypeDetail&& _detail)
    {
        m_detail = std::move(_detail);
    }

    /*!
     * @brief This function returns a constant reference to member detail
     * @return Constant reference to member detail
     */
    eProsima_user_DllExport const CompleteTypeDetail& detail() const
    {
        return m_detail;
    }

    /*!
     * @brief This function returns a reference to member detail
     * @return Reference to member detail
     */
    eProsima_user_DllExport CompleteTypeDetail& detail()
    {
        return m_detail;
    }



private:

    CompleteTypeDetail m_detail;

};
/*!
 * @brief This class represents the structure MinimalBitsetHeader defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalBitsetHeader
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalBitsetHeader()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalBitsetHeader()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalBitsetHeader that will be copied.
     */
    eProsima_user_DllExport MinimalBitsetHeader(
            const MinimalBitsetHeader& x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalBitsetHeader that will be copied.
     */
    eProsima_user_DllExport MinimalBitsetHeader(
            MinimalBitsetHeader&& x) noexcept
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalBitsetHeader that will be copied.
     */
    eProsima_user_DllExport MinimalBitsetHeader& operator =(
            const MinimalBitsetHeader& x)
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalBitsetHeader that will be copied.
     */
    eProsima_user_DllExport MinimalBitsetHeader& operator =(
            MinimalBitsetHeader&& x) noexcept
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalBitsetHeader object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalBitsetHeader& x) const
    {
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalBitsetHeader object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalBitsetHeader& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the structure CompleteBitsetType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteBitsetType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteBitsetType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteBitsetType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteBitsetType that will be copied.
     */
    eProsima_user_DllExport CompleteBitsetType(
            const CompleteBitsetType& x)
    {
                    m_bitset_flags = x.m_bitset_flags;

                    m_header = x.m_header;

                    m_field_seq = x.m_field_seq;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteBitsetType that will be copied.
     */
    eProsima_user_DllExport CompleteBitsetType(
            CompleteBitsetType&& x) noexcept
    {
        m_bitset_flags = std::move(x.m_bitset_flags);
        m_header = std::move(x.m_header);
        m_field_seq = std::move(x.m_field_seq);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteBitsetType that will be copied.
     */
    eProsima_user_DllExport CompleteBitsetType& operator =(
            const CompleteBitsetType& x)
    {

                    m_bitset_flags = x.m_bitset_flags;

                    m_header = x.m_header;

                    m_field_seq = x.m_field_seq;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteBitsetType that will be copied.
     */
    eProsima_user_DllExport CompleteBitsetType& operator =(
            CompleteBitsetType&& x) noexcept
    {

        m_bitset_flags = std::move(x.m_bitset_flags);
        m_header = std::move(x.m_header);
        m_field_seq = std::move(x.m_field_seq);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteBitsetType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteBitsetType& x) const
    {
        return (m_bitset_flags == x.m_bitset_flags &&
           m_header == x.m_header &&
           m_field_seq == x.m_field_seq);
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteBitsetType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteBitsetType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member bitset_flags
     * @param _bitset_flags New value to be copied in member bitset_flags
     */
    eProsima_user_DllExport void bitset_flags(
            const BitsetTypeFlag& _bitset_flags)
    {
        m_bitset_flags = _bitset_flags;
    }

    /*!
     * @brief This function moves the value in member bitset_flags
     * @param _bitset_flags New value to be moved in member bitset_flags
     */
    eProsima_user_DllExport void bitset_flags(
            BitsetTypeFlag&& _bitset_flags)
    {
        m_bitset_flags = std::move(_bitset_flags);
    }

    /*!
     * @brief This function returns a constant reference to member bitset_flags
     * @return Constant reference to member bitset_flags
     */
    eProsima_user_DllExport const BitsetTypeFlag& bitset_flags() const
    {
        return m_bitset_flags;
    }

    /*!
     * @brief This function returns a reference to member bitset_flags
     * @return Reference to member bitset_flags
     */
    eProsima_user_DllExport BitsetTypeFlag& bitset_flags()
    {
        return m_bitset_flags;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const CompleteBitsetHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            CompleteBitsetHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const CompleteBitsetHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport CompleteBitsetHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member field_seq
     * @param _field_seq New value to be copied in member field_seq
     */
    eProsima_user_DllExport void field_seq(
            const CompleteBitfieldSeq& _field_seq)
    {
        m_field_seq = _field_seq;
    }

    /*!
     * @brief This function moves the value in member field_seq
     * @param _field_seq New value to be moved in member field_seq
     */
    eProsima_user_DllExport void field_seq(
            CompleteBitfieldSeq&& _field_seq)
    {
        m_field_seq = std::move(_field_seq);
    }

    /*!
     * @brief This function returns a constant reference to member field_seq
     * @return Constant reference to member field_seq
     */
    eProsima_user_DllExport const CompleteBitfieldSeq& field_seq() const
    {
        return m_field_seq;
    }

    /*!
     * @brief This function returns a reference to member field_seq
     * @return Reference to member field_seq
     */
    eProsima_user_DllExport CompleteBitfieldSeq& field_seq()
    {
        return m_field_seq;
    }



private:

    BitsetTypeFlag m_bitset_flags{0};
    CompleteBitsetHeader m_header;
    CompleteBitfieldSeq m_field_seq;

};
/*!
 * @brief This class represents the structure MinimalBitsetType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalBitsetType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalBitsetType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalBitsetType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalBitsetType that will be copied.
     */
    eProsima_user_DllExport MinimalBitsetType(
            const MinimalBitsetType& x)
    {
                    m_bitset_flags = x.m_bitset_flags;

                    m_header = x.m_header;

                    m_field_seq = x.m_field_seq;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalBitsetType that will be copied.
     */
    eProsima_user_DllExport MinimalBitsetType(
            MinimalBitsetType&& x) noexcept
    {
        m_bitset_flags = std::move(x.m_bitset_flags);
        m_header = std::move(x.m_header);
        m_field_seq = std::move(x.m_field_seq);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalBitsetType that will be copied.
     */
    eProsima_user_DllExport MinimalBitsetType& operator =(
            const MinimalBitsetType& x)
    {

                    m_bitset_flags = x.m_bitset_flags;

                    m_header = x.m_header;

                    m_field_seq = x.m_field_seq;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalBitsetType that will be copied.
     */
    eProsima_user_DllExport MinimalBitsetType& operator =(
            MinimalBitsetType&& x) noexcept
    {

        m_bitset_flags = std::move(x.m_bitset_flags);
        m_header = std::move(x.m_header);
        m_field_seq = std::move(x.m_field_seq);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalBitsetType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalBitsetType& x) const
    {
        return (m_bitset_flags == x.m_bitset_flags &&
           m_header == x.m_header &&
           m_field_seq == x.m_field_seq);
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalBitsetType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalBitsetType& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member bitset_flags
     * @param _bitset_flags New value to be copied in member bitset_flags
     */
    eProsima_user_DllExport void bitset_flags(
            const BitsetTypeFlag& _bitset_flags)
    {
        m_bitset_flags = _bitset_flags;
    }

    /*!
     * @brief This function moves the value in member bitset_flags
     * @param _bitset_flags New value to be moved in member bitset_flags
     */
    eProsima_user_DllExport void bitset_flags(
            BitsetTypeFlag&& _bitset_flags)
    {
        m_bitset_flags = std::move(_bitset_flags);
    }

    /*!
     * @brief This function returns a constant reference to member bitset_flags
     * @return Constant reference to member bitset_flags
     */
    eProsima_user_DllExport const BitsetTypeFlag& bitset_flags() const
    {
        return m_bitset_flags;
    }

    /*!
     * @brief This function returns a reference to member bitset_flags
     * @return Reference to member bitset_flags
     */
    eProsima_user_DllExport BitsetTypeFlag& bitset_flags()
    {
        return m_bitset_flags;
    }


    /*!
     * @brief This function copies the value in member header
     * @param _header New value to be copied in member header
     */
    eProsima_user_DllExport void header(
            const MinimalBitsetHeader& _header)
    {
        m_header = _header;
    }

    /*!
     * @brief This function moves the value in member header
     * @param _header New value to be moved in member header
     */
    eProsima_user_DllExport void header(
            MinimalBitsetHeader&& _header)
    {
        m_header = std::move(_header);
    }

    /*!
     * @brief This function returns a constant reference to member header
     * @return Constant reference to member header
     */
    eProsima_user_DllExport const MinimalBitsetHeader& header() const
    {
        return m_header;
    }

    /*!
     * @brief This function returns a reference to member header
     * @return Reference to member header
     */
    eProsima_user_DllExport MinimalBitsetHeader& header()
    {
        return m_header;
    }


    /*!
     * @brief This function copies the value in member field_seq
     * @param _field_seq New value to be copied in member field_seq
     */
    eProsima_user_DllExport void field_seq(
            const MinimalBitfieldSeq& _field_seq)
    {
        m_field_seq = _field_seq;
    }

    /*!
     * @brief This function moves the value in member field_seq
     * @param _field_seq New value to be moved in member field_seq
     */
    eProsima_user_DllExport void field_seq(
            MinimalBitfieldSeq&& _field_seq)
    {
        m_field_seq = std::move(_field_seq);
    }

    /*!
     * @brief This function returns a constant reference to member field_seq
     * @return Constant reference to member field_seq
     */
    eProsima_user_DllExport const MinimalBitfieldSeq& field_seq() const
    {
        return m_field_seq;
    }

    /*!
     * @brief This function returns a reference to member field_seq
     * @return Reference to member field_seq
     */
    eProsima_user_DllExport MinimalBitfieldSeq& field_seq()
    {
        return m_field_seq;
    }



private:

    BitsetTypeFlag m_bitset_flags{0};
    MinimalBitsetHeader m_header;
    MinimalBitfieldSeq m_field_seq;

};
/*!
 * @brief This class represents the structure CompleteExtendedType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteExtendedType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteExtendedType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteExtendedType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteExtendedType that will be copied.
     */
    eProsima_user_DllExport CompleteExtendedType(
            const CompleteExtendedType& x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteExtendedType that will be copied.
     */
    eProsima_user_DllExport CompleteExtendedType(
            CompleteExtendedType&& x) noexcept
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteExtendedType that will be copied.
     */
    eProsima_user_DllExport CompleteExtendedType& operator =(
            const CompleteExtendedType& x)
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteExtendedType that will be copied.
     */
    eProsima_user_DllExport CompleteExtendedType& operator =(
            CompleteExtendedType&& x) noexcept
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteExtendedType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteExtendedType& x) const
    {
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteExtendedType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteExtendedType& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the union CompleteTypeObject defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class CompleteTypeObject
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport CompleteTypeObject()
    {
        selected_member_ = 0x0000000b;
        member_destructor_ = [&]()
        {
            m_extended_type.~CompleteExtendedType();
        };
        new(&m_extended_type) CompleteExtendedType();

    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~CompleteTypeObject()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object CompleteTypeObject that will be copied.
     */
    eProsima_user_DllExport CompleteTypeObject(
            const CompleteTypeObject& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            alias_type_() = x.m_alias_type;
                            break;

                        case 0x00000002:
                            annotation_type_() = x.m_annotation_type;
                            break;

                        case 0x00000003:
                            struct_type_() = x.m_struct_type;
                            break;

                        case 0x00000004:
                            union_type_() = x.m_union_type;
                            break;

                        case 0x00000005:
                            bitset_type_() = x.m_bitset_type;
                            break;

                        case 0x00000006:
                            sequence_type_() = x.m_sequence_type;
                            break;

                        case 0x00000007:
                            array_type_() = x.m_array_type;
                            break;

                        case 0x00000008:
                            map_type_() = x.m_map_type;
                            break;

                        case 0x00000009:
                            enumerated_type_() = x.m_enumerated_type;
                            break;

                        case 0x0000000a:
                            bitmask_type_() = x.m_bitmask_type;
                            break;

                        case 0x0000000b:
                            extended_type_() = x.m_extended_type;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object CompleteTypeObject that will be copied.
     */
    eProsima_user_DllExport CompleteTypeObject(
            CompleteTypeObject&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            alias_type_() = std::move(x.m_alias_type);
                            break;

                        case 0x00000002:
                            annotation_type_() = std::move(x.m_annotation_type);
                            break;

                        case 0x00000003:
                            struct_type_() = std::move(x.m_struct_type);
                            break;

                        case 0x00000004:
                            union_type_() = std::move(x.m_union_type);
                            break;

                        case 0x00000005:
                            bitset_type_() = std::move(x.m_bitset_type);
                            break;

                        case 0x00000006:
                            sequence_type_() = std::move(x.m_sequence_type);
                            break;

                        case 0x00000007:
                            array_type_() = std::move(x.m_array_type);
                            break;

                        case 0x00000008:
                            map_type_() = std::move(x.m_map_type);
                            break;

                        case 0x00000009:
                            enumerated_type_() = std::move(x.m_enumerated_type);
                            break;

                        case 0x0000000a:
                            bitmask_type_() = std::move(x.m_bitmask_type);
                            break;

                        case 0x0000000b:
                            extended_type_() = std::move(x.m_extended_type);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object CompleteTypeObject that will be copied.
     */
    eProsima_user_DllExport CompleteTypeObject& operator =(
            const CompleteTypeObject& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            alias_type_() = x.m_alias_type;
                            break;

                        case 0x00000002:
                            annotation_type_() = x.m_annotation_type;
                            break;

                        case 0x00000003:
                            struct_type_() = x.m_struct_type;
                            break;

                        case 0x00000004:
                            union_type_() = x.m_union_type;
                            break;

                        case 0x00000005:
                            bitset_type_() = x.m_bitset_type;
                            break;

                        case 0x00000006:
                            sequence_type_() = x.m_sequence_type;
                            break;

                        case 0x00000007:
                            array_type_() = x.m_array_type;
                            break;

                        case 0x00000008:
                            map_type_() = x.m_map_type;
                            break;

                        case 0x00000009:
                            enumerated_type_() = x.m_enumerated_type;
                            break;

                        case 0x0000000a:
                            bitmask_type_() = x.m_bitmask_type;
                            break;

                        case 0x0000000b:
                            extended_type_() = x.m_extended_type;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object CompleteTypeObject that will be copied.
     */
    eProsima_user_DllExport CompleteTypeObject& operator =(
            CompleteTypeObject&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            alias_type_() = std::move(x.m_alias_type);
                            break;

                        case 0x00000002:
                            annotation_type_() = std::move(x.m_annotation_type);
                            break;

                        case 0x00000003:
                            struct_type_() = std::move(x.m_struct_type);
                            break;

                        case 0x00000004:
                            union_type_() = std::move(x.m_union_type);
                            break;

                        case 0x00000005:
                            bitset_type_() = std::move(x.m_bitset_type);
                            break;

                        case 0x00000006:
                            sequence_type_() = std::move(x.m_sequence_type);
                            break;

                        case 0x00000007:
                            array_type_() = std::move(x.m_array_type);
                            break;

                        case 0x00000008:
                            map_type_() = std::move(x.m_map_type);
                            break;

                        case 0x00000009:
                            enumerated_type_() = std::move(x.m_enumerated_type);
                            break;

                        case 0x0000000a:
                            bitmask_type_() = std::move(x.m_bitmask_type);
                            break;

                        case 0x0000000b:
                            extended_type_() = std::move(x.m_extended_type);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteTypeObject object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const CompleteTypeObject& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_alias_type == m_alias_type);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_annotation_type == m_annotation_type);
                                                        break;

                                                    case 0x00000003:
                                                        ret_value = (x.m_struct_type == m_struct_type);
                                                        break;

                                                    case 0x00000004:
                                                        ret_value = (x.m_union_type == m_union_type);
                                                        break;

                                                    case 0x00000005:
                                                        ret_value = (x.m_bitset_type == m_bitset_type);
                                                        break;

                                                    case 0x00000006:
                                                        ret_value = (x.m_sequence_type == m_sequence_type);
                                                        break;

                                                    case 0x00000007:
                                                        ret_value = (x.m_array_type == m_array_type);
                                                        break;

                                                    case 0x00000008:
                                                        ret_value = (x.m_map_type == m_map_type);
                                                        break;

                                                    case 0x00000009:
                                                        ret_value = (x.m_enumerated_type == m_enumerated_type);
                                                        break;

                                                    case 0x0000000a:
                                                        ret_value = (x.m_bitmask_type == m_bitmask_type);
                                                        break;

                                                    case 0x0000000b:
                                                        ret_value = (x.m_extended_type == m_extended_type);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x CompleteTypeObject object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const CompleteTypeObject& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            uint8_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case TK_ALIAS:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_ANNOTATION:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_STRUCTURE:
                            if (0x00000003 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_UNION:
                            if (0x00000004 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_BITSET:
                            if (0x00000005 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_SEQUENCE:
                            if (0x00000006 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_ARRAY:
                            if (0x00000007 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_MAP:
                            if (0x00000008 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_ENUM:
                            if (0x00000009 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_BITMASK:
                            if (0x0000000a == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        default:
                            if (0x0000000b == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport uint8_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member alias_type
     * @param _alias_type New value to be copied in member alias_type
     */
    eProsima_user_DllExport void alias_type(
            const CompleteAliasType& _alias_type)
    {
        alias_type_() = _alias_type;
        m__d = TK_ALIAS;
    }

    /*!
     * @brief This function moves the value in member alias_type
     * @param _alias_type New value to be moved in member alias_type
     */
    eProsima_user_DllExport void alias_type(
            CompleteAliasType&& _alias_type)
    {
        alias_type_() = _alias_type;
        m__d = TK_ALIAS;
    }

    /*!
     * @brief This function returns a constant reference to member alias_type
     * @return Constant reference to member alias_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const CompleteAliasType& alias_type() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_alias_type;
    }

    /*!
     * @brief This function returns a reference to member alias_type
     * @return Reference to member alias_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport CompleteAliasType& alias_type()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_alias_type;
    }


    /*!
     * @brief This function copies the value in member annotation_type
     * @param _annotation_type New value to be copied in member annotation_type
     */
    eProsima_user_DllExport void annotation_type(
            const CompleteAnnotationType& _annotation_type)
    {
        annotation_type_() = _annotation_type;
        m__d = TK_ANNOTATION;
    }

    /*!
     * @brief This function moves the value in member annotation_type
     * @param _annotation_type New value to be moved in member annotation_type
     */
    eProsima_user_DllExport void annotation_type(
            CompleteAnnotationType&& _annotation_type)
    {
        annotation_type_() = _annotation_type;
        m__d = TK_ANNOTATION;
    }

    /*!
     * @brief This function returns a constant reference to member annotation_type
     * @return Constant reference to member annotation_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const CompleteAnnotationType& annotation_type() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_annotation_type;
    }

    /*!
     * @brief This function returns a reference to member annotation_type
     * @return Reference to member annotation_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport CompleteAnnotationType& annotation_type()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_annotation_type;
    }


    /*!
     * @brief This function copies the value in member struct_type
     * @param _struct_type New value to be copied in member struct_type
     */
    eProsima_user_DllExport void struct_type(
            const CompleteStructType& _struct_type)
    {
        struct_type_() = _struct_type;
        m__d = TK_STRUCTURE;
    }

    /*!
     * @brief This function moves the value in member struct_type
     * @param _struct_type New value to be moved in member struct_type
     */
    eProsima_user_DllExport void struct_type(
            CompleteStructType&& _struct_type)
    {
        struct_type_() = _struct_type;
        m__d = TK_STRUCTURE;
    }

    /*!
     * @brief This function returns a constant reference to member struct_type
     * @return Constant reference to member struct_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const CompleteStructType& struct_type() const
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_struct_type;
    }

    /*!
     * @brief This function returns a reference to member struct_type
     * @return Reference to member struct_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport CompleteStructType& struct_type()
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_struct_type;
    }


    /*!
     * @brief This function copies the value in member union_type
     * @param _union_type New value to be copied in member union_type
     */
    eProsima_user_DllExport void union_type(
            const CompleteUnionType& _union_type)
    {
        union_type_() = _union_type;
        m__d = TK_UNION;
    }

    /*!
     * @brief This function moves the value in member union_type
     * @param _union_type New value to be moved in member union_type
     */
    eProsima_user_DllExport void union_type(
            CompleteUnionType&& _union_type)
    {
        union_type_() = _union_type;
        m__d = TK_UNION;
    }

    /*!
     * @brief This function returns a constant reference to member union_type
     * @return Constant reference to member union_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const CompleteUnionType& union_type() const
    {
        if (0x00000004 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_union_type;
    }

    /*!
     * @brief This function returns a reference to member union_type
     * @return Reference to member union_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport CompleteUnionType& union_type()
    {
        if (0x00000004 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_union_type;
    }


    /*!
     * @brief This function copies the value in member bitset_type
     * @param _bitset_type New value to be copied in member bitset_type
     */
    eProsima_user_DllExport void bitset_type(
            const CompleteBitsetType& _bitset_type)
    {
        bitset_type_() = _bitset_type;
        m__d = TK_BITSET;
    }

    /*!
     * @brief This function moves the value in member bitset_type
     * @param _bitset_type New value to be moved in member bitset_type
     */
    eProsima_user_DllExport void bitset_type(
            CompleteBitsetType&& _bitset_type)
    {
        bitset_type_() = _bitset_type;
        m__d = TK_BITSET;
    }

    /*!
     * @brief This function returns a constant reference to member bitset_type
     * @return Constant reference to member bitset_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const CompleteBitsetType& bitset_type() const
    {
        if (0x00000005 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_bitset_type;
    }

    /*!
     * @brief This function returns a reference to member bitset_type
     * @return Reference to member bitset_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport CompleteBitsetType& bitset_type()
    {
        if (0x00000005 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_bitset_type;
    }


    /*!
     * @brief This function copies the value in member sequence_type
     * @param _sequence_type New value to be copied in member sequence_type
     */
    eProsima_user_DllExport void sequence_type(
            const CompleteSequenceType& _sequence_type)
    {
        sequence_type_() = _sequence_type;
        m__d = TK_SEQUENCE;
    }

    /*!
     * @brief This function moves the value in member sequence_type
     * @param _sequence_type New value to be moved in member sequence_type
     */
    eProsima_user_DllExport void sequence_type(
            CompleteSequenceType&& _sequence_type)
    {
        sequence_type_() = _sequence_type;
        m__d = TK_SEQUENCE;
    }

    /*!
     * @brief This function returns a constant reference to member sequence_type
     * @return Constant reference to member sequence_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const CompleteSequenceType& sequence_type() const
    {
        if (0x00000006 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_sequence_type;
    }

    /*!
     * @brief This function returns a reference to member sequence_type
     * @return Reference to member sequence_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport CompleteSequenceType& sequence_type()
    {
        if (0x00000006 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_sequence_type;
    }


    /*!
     * @brief This function copies the value in member array_type
     * @param _array_type New value to be copied in member array_type
     */
    eProsima_user_DllExport void array_type(
            const CompleteArrayType& _array_type)
    {
        array_type_() = _array_type;
        m__d = TK_ARRAY;
    }

    /*!
     * @brief This function moves the value in member array_type
     * @param _array_type New value to be moved in member array_type
     */
    eProsima_user_DllExport void array_type(
            CompleteArrayType&& _array_type)
    {
        array_type_() = _array_type;
        m__d = TK_ARRAY;
    }

    /*!
     * @brief This function returns a constant reference to member array_type
     * @return Constant reference to member array_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const CompleteArrayType& array_type() const
    {
        if (0x00000007 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_array_type;
    }

    /*!
     * @brief This function returns a reference to member array_type
     * @return Reference to member array_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport CompleteArrayType& array_type()
    {
        if (0x00000007 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_array_type;
    }


    /*!
     * @brief This function copies the value in member map_type
     * @param _map_type New value to be copied in member map_type
     */
    eProsima_user_DllExport void map_type(
            const CompleteMapType& _map_type)
    {
        map_type_() = _map_type;
        m__d = TK_MAP;
    }

    /*!
     * @brief This function moves the value in member map_type
     * @param _map_type New value to be moved in member map_type
     */
    eProsima_user_DllExport void map_type(
            CompleteMapType&& _map_type)
    {
        map_type_() = _map_type;
        m__d = TK_MAP;
    }

    /*!
     * @brief This function returns a constant reference to member map_type
     * @return Constant reference to member map_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const CompleteMapType& map_type() const
    {
        if (0x00000008 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_map_type;
    }

    /*!
     * @brief This function returns a reference to member map_type
     * @return Reference to member map_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport CompleteMapType& map_type()
    {
        if (0x00000008 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_map_type;
    }


    /*!
     * @brief This function copies the value in member enumerated_type
     * @param _enumerated_type New value to be copied in member enumerated_type
     */
    eProsima_user_DllExport void enumerated_type(
            const CompleteEnumeratedType& _enumerated_type)
    {
        enumerated_type_() = _enumerated_type;
        m__d = TK_ENUM;
    }

    /*!
     * @brief This function moves the value in member enumerated_type
     * @param _enumerated_type New value to be moved in member enumerated_type
     */
    eProsima_user_DllExport void enumerated_type(
            CompleteEnumeratedType&& _enumerated_type)
    {
        enumerated_type_() = _enumerated_type;
        m__d = TK_ENUM;
    }

    /*!
     * @brief This function returns a constant reference to member enumerated_type
     * @return Constant reference to member enumerated_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const CompleteEnumeratedType& enumerated_type() const
    {
        if (0x00000009 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_enumerated_type;
    }

    /*!
     * @brief This function returns a reference to member enumerated_type
     * @return Reference to member enumerated_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport CompleteEnumeratedType& enumerated_type()
    {
        if (0x00000009 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_enumerated_type;
    }


    /*!
     * @brief This function copies the value in member bitmask_type
     * @param _bitmask_type New value to be copied in member bitmask_type
     */
    eProsima_user_DllExport void bitmask_type(
            const CompleteBitmaskType& _bitmask_type)
    {
        bitmask_type_() = _bitmask_type;
        m__d = TK_BITMASK;
    }

    /*!
     * @brief This function moves the value in member bitmask_type
     * @param _bitmask_type New value to be moved in member bitmask_type
     */
    eProsima_user_DllExport void bitmask_type(
            CompleteBitmaskType&& _bitmask_type)
    {
        bitmask_type_() = _bitmask_type;
        m__d = TK_BITMASK;
    }

    /*!
     * @brief This function returns a constant reference to member bitmask_type
     * @return Constant reference to member bitmask_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const CompleteBitmaskType& bitmask_type() const
    {
        if (0x0000000a != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_bitmask_type;
    }

    /*!
     * @brief This function returns a reference to member bitmask_type
     * @return Reference to member bitmask_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport CompleteBitmaskType& bitmask_type()
    {
        if (0x0000000a != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_bitmask_type;
    }


    /*!
     * @brief This function copies the value in member extended_type
     * @param _extended_type New value to be copied in member extended_type
     */
    eProsima_user_DllExport void extended_type(
            const CompleteExtendedType& _extended_type)
    {
        extended_type_() = _extended_type;
        m__d = 127;
    }

    /*!
     * @brief This function moves the value in member extended_type
     * @param _extended_type New value to be moved in member extended_type
     */
    eProsima_user_DllExport void extended_type(
            CompleteExtendedType&& _extended_type)
    {
        extended_type_() = _extended_type;
        m__d = 127;
    }

    /*!
     * @brief This function returns a constant reference to member extended_type
     * @return Constant reference to member extended_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const CompleteExtendedType& extended_type() const
    {
        if (0x0000000b != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_extended_type;
    }

    /*!
     * @brief This function returns a reference to member extended_type
     * @return Reference to member extended_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport CompleteExtendedType& extended_type()
    {
        if (0x0000000b != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_extended_type;
    }



private:

            CompleteAliasType& alias_type_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        m_alias_type.~CompleteAliasType();
                    };
                    new(&m_alias_type) CompleteAliasType();

                }

                return m_alias_type;
            }

            CompleteAnnotationType& annotation_type_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = [&]()
                    {
                        m_annotation_type.~CompleteAnnotationType();
                    };
                    new(&m_annotation_type) CompleteAnnotationType();

                }

                return m_annotation_type;
            }

            CompleteStructType& struct_type_()
            {
                if (0x00000003 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000003;
                    member_destructor_ = [&]()
                    {
                        m_struct_type.~CompleteStructType();
                    };
                    new(&m_struct_type) CompleteStructType();

                }

                return m_struct_type;
            }

            CompleteUnionType& union_type_()
            {
                if (0x00000004 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000004;
                    member_destructor_ = [&]()
                    {
                        m_union_type.~CompleteUnionType();
                    };
                    new(&m_union_type) CompleteUnionType();

                }

                return m_union_type;
            }

            CompleteBitsetType& bitset_type_()
            {
                if (0x00000005 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000005;
                    member_destructor_ = [&]()
                    {
                        m_bitset_type.~CompleteBitsetType();
                    };
                    new(&m_bitset_type) CompleteBitsetType();

                }

                return m_bitset_type;
            }

            CompleteSequenceType& sequence_type_()
            {
                if (0x00000006 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000006;
                    member_destructor_ = [&]()
                    {
                        m_sequence_type.~CompleteSequenceType();
                    };
                    new(&m_sequence_type) CompleteSequenceType();

                }

                return m_sequence_type;
            }

            CompleteArrayType& array_type_()
            {
                if (0x00000007 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000007;
                    member_destructor_ = [&]()
                    {
                        m_array_type.~CompleteArrayType();
                    };
                    new(&m_array_type) CompleteArrayType();

                }

                return m_array_type;
            }

            CompleteMapType& map_type_()
            {
                if (0x00000008 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000008;
                    member_destructor_ = [&]()
                    {
                        m_map_type.~CompleteMapType();
                    };
                    new(&m_map_type) CompleteMapType();

                }

                return m_map_type;
            }

            CompleteEnumeratedType& enumerated_type_()
            {
                if (0x00000009 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000009;
                    member_destructor_ = [&]()
                    {
                        m_enumerated_type.~CompleteEnumeratedType();
                    };
                    new(&m_enumerated_type) CompleteEnumeratedType();

                }

                return m_enumerated_type;
            }

            CompleteBitmaskType& bitmask_type_()
            {
                if (0x0000000a != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x0000000a;
                    member_destructor_ = [&]()
                    {
                        m_bitmask_type.~CompleteBitmaskType();
                    };
                    new(&m_bitmask_type) CompleteBitmaskType();

                }

                return m_bitmask_type;
            }

            CompleteExtendedType& extended_type_()
            {
                if (0x0000000b != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x0000000b;
                    member_destructor_ = [&]()
                    {
                        m_extended_type.~CompleteExtendedType();
                    };
                    new(&m_extended_type) CompleteExtendedType();

                }

                return m_extended_type;
            }


    uint8_t m__d {TK_NONE};

    union
    {
        CompleteAliasType m_alias_type;
        CompleteAnnotationType m_annotation_type;
        CompleteStructType m_struct_type;
        CompleteUnionType m_union_type;
        CompleteBitsetType m_bitset_type;
        CompleteSequenceType m_sequence_type;
        CompleteArrayType m_array_type;
        CompleteMapType m_map_type;
        CompleteEnumeratedType m_enumerated_type;
        CompleteBitmaskType m_bitmask_type;
        CompleteExtendedType m_extended_type;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the structure MinimalExtendedType defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalExtendedType
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalExtendedType()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalExtendedType()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalExtendedType that will be copied.
     */
    eProsima_user_DllExport MinimalExtendedType(
            const MinimalExtendedType& x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalExtendedType that will be copied.
     */
    eProsima_user_DllExport MinimalExtendedType(
            MinimalExtendedType&& x) noexcept
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalExtendedType that will be copied.
     */
    eProsima_user_DllExport MinimalExtendedType& operator =(
            const MinimalExtendedType& x)
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalExtendedType that will be copied.
     */
    eProsima_user_DllExport MinimalExtendedType& operator =(
            MinimalExtendedType&& x) noexcept
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalExtendedType object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalExtendedType& x) const
    {
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalExtendedType object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalExtendedType& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the union MinimalTypeObject defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class MinimalTypeObject
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MinimalTypeObject()
    {
        selected_member_ = 0x0000000b;
        member_destructor_ = [&]()
        {
            m_extended_type.~MinimalExtendedType();
        };
        new(&m_extended_type) MinimalExtendedType();

    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MinimalTypeObject()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MinimalTypeObject that will be copied.
     */
    eProsima_user_DllExport MinimalTypeObject(
            const MinimalTypeObject& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            alias_type_() = x.m_alias_type;
                            break;

                        case 0x00000002:
                            annotation_type_() = x.m_annotation_type;
                            break;

                        case 0x00000003:
                            struct_type_() = x.m_struct_type;
                            break;

                        case 0x00000004:
                            union_type_() = x.m_union_type;
                            break;

                        case 0x00000005:
                            bitset_type_() = x.m_bitset_type;
                            break;

                        case 0x00000006:
                            sequence_type_() = x.m_sequence_type;
                            break;

                        case 0x00000007:
                            array_type_() = x.m_array_type;
                            break;

                        case 0x00000008:
                            map_type_() = x.m_map_type;
                            break;

                        case 0x00000009:
                            enumerated_type_() = x.m_enumerated_type;
                            break;

                        case 0x0000000a:
                            bitmask_type_() = x.m_bitmask_type;
                            break;

                        case 0x0000000b:
                            extended_type_() = x.m_extended_type;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MinimalTypeObject that will be copied.
     */
    eProsima_user_DllExport MinimalTypeObject(
            MinimalTypeObject&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            alias_type_() = std::move(x.m_alias_type);
                            break;

                        case 0x00000002:
                            annotation_type_() = std::move(x.m_annotation_type);
                            break;

                        case 0x00000003:
                            struct_type_() = std::move(x.m_struct_type);
                            break;

                        case 0x00000004:
                            union_type_() = std::move(x.m_union_type);
                            break;

                        case 0x00000005:
                            bitset_type_() = std::move(x.m_bitset_type);
                            break;

                        case 0x00000006:
                            sequence_type_() = std::move(x.m_sequence_type);
                            break;

                        case 0x00000007:
                            array_type_() = std::move(x.m_array_type);
                            break;

                        case 0x00000008:
                            map_type_() = std::move(x.m_map_type);
                            break;

                        case 0x00000009:
                            enumerated_type_() = std::move(x.m_enumerated_type);
                            break;

                        case 0x0000000a:
                            bitmask_type_() = std::move(x.m_bitmask_type);
                            break;

                        case 0x0000000b:
                            extended_type_() = std::move(x.m_extended_type);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MinimalTypeObject that will be copied.
     */
    eProsima_user_DllExport MinimalTypeObject& operator =(
            const MinimalTypeObject& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            alias_type_() = x.m_alias_type;
                            break;

                        case 0x00000002:
                            annotation_type_() = x.m_annotation_type;
                            break;

                        case 0x00000003:
                            struct_type_() = x.m_struct_type;
                            break;

                        case 0x00000004:
                            union_type_() = x.m_union_type;
                            break;

                        case 0x00000005:
                            bitset_type_() = x.m_bitset_type;
                            break;

                        case 0x00000006:
                            sequence_type_() = x.m_sequence_type;
                            break;

                        case 0x00000007:
                            array_type_() = x.m_array_type;
                            break;

                        case 0x00000008:
                            map_type_() = x.m_map_type;
                            break;

                        case 0x00000009:
                            enumerated_type_() = x.m_enumerated_type;
                            break;

                        case 0x0000000a:
                            bitmask_type_() = x.m_bitmask_type;
                            break;

                        case 0x0000000b:
                            extended_type_() = x.m_extended_type;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MinimalTypeObject that will be copied.
     */
    eProsima_user_DllExport MinimalTypeObject& operator =(
            MinimalTypeObject&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            alias_type_() = std::move(x.m_alias_type);
                            break;

                        case 0x00000002:
                            annotation_type_() = std::move(x.m_annotation_type);
                            break;

                        case 0x00000003:
                            struct_type_() = std::move(x.m_struct_type);
                            break;

                        case 0x00000004:
                            union_type_() = std::move(x.m_union_type);
                            break;

                        case 0x00000005:
                            bitset_type_() = std::move(x.m_bitset_type);
                            break;

                        case 0x00000006:
                            sequence_type_() = std::move(x.m_sequence_type);
                            break;

                        case 0x00000007:
                            array_type_() = std::move(x.m_array_type);
                            break;

                        case 0x00000008:
                            map_type_() = std::move(x.m_map_type);
                            break;

                        case 0x00000009:
                            enumerated_type_() = std::move(x.m_enumerated_type);
                            break;

                        case 0x0000000a:
                            bitmask_type_() = std::move(x.m_bitmask_type);
                            break;

                        case 0x0000000b:
                            extended_type_() = std::move(x.m_extended_type);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalTypeObject object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MinimalTypeObject& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_alias_type == m_alias_type);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_annotation_type == m_annotation_type);
                                                        break;

                                                    case 0x00000003:
                                                        ret_value = (x.m_struct_type == m_struct_type);
                                                        break;

                                                    case 0x00000004:
                                                        ret_value = (x.m_union_type == m_union_type);
                                                        break;

                                                    case 0x00000005:
                                                        ret_value = (x.m_bitset_type == m_bitset_type);
                                                        break;

                                                    case 0x00000006:
                                                        ret_value = (x.m_sequence_type == m_sequence_type);
                                                        break;

                                                    case 0x00000007:
                                                        ret_value = (x.m_array_type == m_array_type);
                                                        break;

                                                    case 0x00000008:
                                                        ret_value = (x.m_map_type == m_map_type);
                                                        break;

                                                    case 0x00000009:
                                                        ret_value = (x.m_enumerated_type == m_enumerated_type);
                                                        break;

                                                    case 0x0000000a:
                                                        ret_value = (x.m_bitmask_type == m_bitmask_type);
                                                        break;

                                                    case 0x0000000b:
                                                        ret_value = (x.m_extended_type == m_extended_type);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x MinimalTypeObject object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MinimalTypeObject& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            uint8_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case TK_ALIAS:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_ANNOTATION:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_STRUCTURE:
                            if (0x00000003 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_UNION:
                            if (0x00000004 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_BITSET:
                            if (0x00000005 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_SEQUENCE:
                            if (0x00000006 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_ARRAY:
                            if (0x00000007 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_MAP:
                            if (0x00000008 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_ENUM:
                            if (0x00000009 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case TK_BITMASK:
                            if (0x0000000a == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        default:
                            if (0x0000000b == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport uint8_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member alias_type
     * @param _alias_type New value to be copied in member alias_type
     */
    eProsima_user_DllExport void alias_type(
            const MinimalAliasType& _alias_type)
    {
        alias_type_() = _alias_type;
        m__d = TK_ALIAS;
    }

    /*!
     * @brief This function moves the value in member alias_type
     * @param _alias_type New value to be moved in member alias_type
     */
    eProsima_user_DllExport void alias_type(
            MinimalAliasType&& _alias_type)
    {
        alias_type_() = _alias_type;
        m__d = TK_ALIAS;
    }

    /*!
     * @brief This function returns a constant reference to member alias_type
     * @return Constant reference to member alias_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const MinimalAliasType& alias_type() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_alias_type;
    }

    /*!
     * @brief This function returns a reference to member alias_type
     * @return Reference to member alias_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport MinimalAliasType& alias_type()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_alias_type;
    }


    /*!
     * @brief This function copies the value in member annotation_type
     * @param _annotation_type New value to be copied in member annotation_type
     */
    eProsima_user_DllExport void annotation_type(
            const MinimalAnnotationType& _annotation_type)
    {
        annotation_type_() = _annotation_type;
        m__d = TK_ANNOTATION;
    }

    /*!
     * @brief This function moves the value in member annotation_type
     * @param _annotation_type New value to be moved in member annotation_type
     */
    eProsima_user_DllExport void annotation_type(
            MinimalAnnotationType&& _annotation_type)
    {
        annotation_type_() = _annotation_type;
        m__d = TK_ANNOTATION;
    }

    /*!
     * @brief This function returns a constant reference to member annotation_type
     * @return Constant reference to member annotation_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const MinimalAnnotationType& annotation_type() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_annotation_type;
    }

    /*!
     * @brief This function returns a reference to member annotation_type
     * @return Reference to member annotation_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport MinimalAnnotationType& annotation_type()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_annotation_type;
    }


    /*!
     * @brief This function copies the value in member struct_type
     * @param _struct_type New value to be copied in member struct_type
     */
    eProsima_user_DllExport void struct_type(
            const MinimalStructType& _struct_type)
    {
        struct_type_() = _struct_type;
        m__d = TK_STRUCTURE;
    }

    /*!
     * @brief This function moves the value in member struct_type
     * @param _struct_type New value to be moved in member struct_type
     */
    eProsima_user_DllExport void struct_type(
            MinimalStructType&& _struct_type)
    {
        struct_type_() = _struct_type;
        m__d = TK_STRUCTURE;
    }

    /*!
     * @brief This function returns a constant reference to member struct_type
     * @return Constant reference to member struct_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const MinimalStructType& struct_type() const
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_struct_type;
    }

    /*!
     * @brief This function returns a reference to member struct_type
     * @return Reference to member struct_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport MinimalStructType& struct_type()
    {
        if (0x00000003 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_struct_type;
    }


    /*!
     * @brief This function copies the value in member union_type
     * @param _union_type New value to be copied in member union_type
     */
    eProsima_user_DllExport void union_type(
            const MinimalUnionType& _union_type)
    {
        union_type_() = _union_type;
        m__d = TK_UNION;
    }

    /*!
     * @brief This function moves the value in member union_type
     * @param _union_type New value to be moved in member union_type
     */
    eProsima_user_DllExport void union_type(
            MinimalUnionType&& _union_type)
    {
        union_type_() = _union_type;
        m__d = TK_UNION;
    }

    /*!
     * @brief This function returns a constant reference to member union_type
     * @return Constant reference to member union_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const MinimalUnionType& union_type() const
    {
        if (0x00000004 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_union_type;
    }

    /*!
     * @brief This function returns a reference to member union_type
     * @return Reference to member union_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport MinimalUnionType& union_type()
    {
        if (0x00000004 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_union_type;
    }


    /*!
     * @brief This function copies the value in member bitset_type
     * @param _bitset_type New value to be copied in member bitset_type
     */
    eProsima_user_DllExport void bitset_type(
            const MinimalBitsetType& _bitset_type)
    {
        bitset_type_() = _bitset_type;
        m__d = TK_BITSET;
    }

    /*!
     * @brief This function moves the value in member bitset_type
     * @param _bitset_type New value to be moved in member bitset_type
     */
    eProsima_user_DllExport void bitset_type(
            MinimalBitsetType&& _bitset_type)
    {
        bitset_type_() = _bitset_type;
        m__d = TK_BITSET;
    }

    /*!
     * @brief This function returns a constant reference to member bitset_type
     * @return Constant reference to member bitset_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const MinimalBitsetType& bitset_type() const
    {
        if (0x00000005 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_bitset_type;
    }

    /*!
     * @brief This function returns a reference to member bitset_type
     * @return Reference to member bitset_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport MinimalBitsetType& bitset_type()
    {
        if (0x00000005 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_bitset_type;
    }


    /*!
     * @brief This function copies the value in member sequence_type
     * @param _sequence_type New value to be copied in member sequence_type
     */
    eProsima_user_DllExport void sequence_type(
            const MinimalSequenceType& _sequence_type)
    {
        sequence_type_() = _sequence_type;
        m__d = TK_SEQUENCE;
    }

    /*!
     * @brief This function moves the value in member sequence_type
     * @param _sequence_type New value to be moved in member sequence_type
     */
    eProsima_user_DllExport void sequence_type(
            MinimalSequenceType&& _sequence_type)
    {
        sequence_type_() = _sequence_type;
        m__d = TK_SEQUENCE;
    }

    /*!
     * @brief This function returns a constant reference to member sequence_type
     * @return Constant reference to member sequence_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const MinimalSequenceType& sequence_type() const
    {
        if (0x00000006 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_sequence_type;
    }

    /*!
     * @brief This function returns a reference to member sequence_type
     * @return Reference to member sequence_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport MinimalSequenceType& sequence_type()
    {
        if (0x00000006 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_sequence_type;
    }


    /*!
     * @brief This function copies the value in member array_type
     * @param _array_type New value to be copied in member array_type
     */
    eProsima_user_DllExport void array_type(
            const MinimalArrayType& _array_type)
    {
        array_type_() = _array_type;
        m__d = TK_ARRAY;
    }

    /*!
     * @brief This function moves the value in member array_type
     * @param _array_type New value to be moved in member array_type
     */
    eProsima_user_DllExport void array_type(
            MinimalArrayType&& _array_type)
    {
        array_type_() = _array_type;
        m__d = TK_ARRAY;
    }

    /*!
     * @brief This function returns a constant reference to member array_type
     * @return Constant reference to member array_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const MinimalArrayType& array_type() const
    {
        if (0x00000007 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_array_type;
    }

    /*!
     * @brief This function returns a reference to member array_type
     * @return Reference to member array_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport MinimalArrayType& array_type()
    {
        if (0x00000007 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_array_type;
    }


    /*!
     * @brief This function copies the value in member map_type
     * @param _map_type New value to be copied in member map_type
     */
    eProsima_user_DllExport void map_type(
            const MinimalMapType& _map_type)
    {
        map_type_() = _map_type;
        m__d = TK_MAP;
    }

    /*!
     * @brief This function moves the value in member map_type
     * @param _map_type New value to be moved in member map_type
     */
    eProsima_user_DllExport void map_type(
            MinimalMapType&& _map_type)
    {
        map_type_() = _map_type;
        m__d = TK_MAP;
    }

    /*!
     * @brief This function returns a constant reference to member map_type
     * @return Constant reference to member map_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const MinimalMapType& map_type() const
    {
        if (0x00000008 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_map_type;
    }

    /*!
     * @brief This function returns a reference to member map_type
     * @return Reference to member map_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport MinimalMapType& map_type()
    {
        if (0x00000008 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_map_type;
    }


    /*!
     * @brief This function copies the value in member enumerated_type
     * @param _enumerated_type New value to be copied in member enumerated_type
     */
    eProsima_user_DllExport void enumerated_type(
            const MinimalEnumeratedType& _enumerated_type)
    {
        enumerated_type_() = _enumerated_type;
        m__d = TK_ENUM;
    }

    /*!
     * @brief This function moves the value in member enumerated_type
     * @param _enumerated_type New value to be moved in member enumerated_type
     */
    eProsima_user_DllExport void enumerated_type(
            MinimalEnumeratedType&& _enumerated_type)
    {
        enumerated_type_() = _enumerated_type;
        m__d = TK_ENUM;
    }

    /*!
     * @brief This function returns a constant reference to member enumerated_type
     * @return Constant reference to member enumerated_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const MinimalEnumeratedType& enumerated_type() const
    {
        if (0x00000009 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_enumerated_type;
    }

    /*!
     * @brief This function returns a reference to member enumerated_type
     * @return Reference to member enumerated_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport MinimalEnumeratedType& enumerated_type()
    {
        if (0x00000009 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_enumerated_type;
    }


    /*!
     * @brief This function copies the value in member bitmask_type
     * @param _bitmask_type New value to be copied in member bitmask_type
     */
    eProsima_user_DllExport void bitmask_type(
            const MinimalBitmaskType& _bitmask_type)
    {
        bitmask_type_() = _bitmask_type;
        m__d = TK_BITMASK;
    }

    /*!
     * @brief This function moves the value in member bitmask_type
     * @param _bitmask_type New value to be moved in member bitmask_type
     */
    eProsima_user_DllExport void bitmask_type(
            MinimalBitmaskType&& _bitmask_type)
    {
        bitmask_type_() = _bitmask_type;
        m__d = TK_BITMASK;
    }

    /*!
     * @brief This function returns a constant reference to member bitmask_type
     * @return Constant reference to member bitmask_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const MinimalBitmaskType& bitmask_type() const
    {
        if (0x0000000a != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_bitmask_type;
    }

    /*!
     * @brief This function returns a reference to member bitmask_type
     * @return Reference to member bitmask_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport MinimalBitmaskType& bitmask_type()
    {
        if (0x0000000a != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_bitmask_type;
    }


    /*!
     * @brief This function copies the value in member extended_type
     * @param _extended_type New value to be copied in member extended_type
     */
    eProsima_user_DllExport void extended_type(
            const MinimalExtendedType& _extended_type)
    {
        extended_type_() = _extended_type;
        m__d = 127;
    }

    /*!
     * @brief This function moves the value in member extended_type
     * @param _extended_type New value to be moved in member extended_type
     */
    eProsima_user_DllExport void extended_type(
            MinimalExtendedType&& _extended_type)
    {
        extended_type_() = _extended_type;
        m__d = 127;
    }

    /*!
     * @brief This function returns a constant reference to member extended_type
     * @return Constant reference to member extended_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const MinimalExtendedType& extended_type() const
    {
        if (0x0000000b != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_extended_type;
    }

    /*!
     * @brief This function returns a reference to member extended_type
     * @return Reference to member extended_type
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport MinimalExtendedType& extended_type()
    {
        if (0x0000000b != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_extended_type;
    }



private:

            MinimalAliasType& alias_type_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        m_alias_type.~MinimalAliasType();
                    };
                    new(&m_alias_type) MinimalAliasType();

                }

                return m_alias_type;
            }

            MinimalAnnotationType& annotation_type_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = [&]()
                    {
                        m_annotation_type.~MinimalAnnotationType();
                    };
                    new(&m_annotation_type) MinimalAnnotationType();

                }

                return m_annotation_type;
            }

            MinimalStructType& struct_type_()
            {
                if (0x00000003 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000003;
                    member_destructor_ = [&]()
                    {
                        m_struct_type.~MinimalStructType();
                    };
                    new(&m_struct_type) MinimalStructType();

                }

                return m_struct_type;
            }

            MinimalUnionType& union_type_()
            {
                if (0x00000004 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000004;
                    member_destructor_ = [&]()
                    {
                        m_union_type.~MinimalUnionType();
                    };
                    new(&m_union_type) MinimalUnionType();

                }

                return m_union_type;
            }

            MinimalBitsetType& bitset_type_()
            {
                if (0x00000005 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000005;
                    member_destructor_ = [&]()
                    {
                        m_bitset_type.~MinimalBitsetType();
                    };
                    new(&m_bitset_type) MinimalBitsetType();

                }

                return m_bitset_type;
            }

            MinimalSequenceType& sequence_type_()
            {
                if (0x00000006 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000006;
                    member_destructor_ = [&]()
                    {
                        m_sequence_type.~MinimalSequenceType();
                    };
                    new(&m_sequence_type) MinimalSequenceType();

                }

                return m_sequence_type;
            }

            MinimalArrayType& array_type_()
            {
                if (0x00000007 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000007;
                    member_destructor_ = [&]()
                    {
                        m_array_type.~MinimalArrayType();
                    };
                    new(&m_array_type) MinimalArrayType();

                }

                return m_array_type;
            }

            MinimalMapType& map_type_()
            {
                if (0x00000008 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000008;
                    member_destructor_ = [&]()
                    {
                        m_map_type.~MinimalMapType();
                    };
                    new(&m_map_type) MinimalMapType();

                }

                return m_map_type;
            }

            MinimalEnumeratedType& enumerated_type_()
            {
                if (0x00000009 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000009;
                    member_destructor_ = [&]()
                    {
                        m_enumerated_type.~MinimalEnumeratedType();
                    };
                    new(&m_enumerated_type) MinimalEnumeratedType();

                }

                return m_enumerated_type;
            }

            MinimalBitmaskType& bitmask_type_()
            {
                if (0x0000000a != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x0000000a;
                    member_destructor_ = [&]()
                    {
                        m_bitmask_type.~MinimalBitmaskType();
                    };
                    new(&m_bitmask_type) MinimalBitmaskType();

                }

                return m_bitmask_type;
            }

            MinimalExtendedType& extended_type_()
            {
                if (0x0000000b != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x0000000b;
                    member_destructor_ = [&]()
                    {
                        m_extended_type.~MinimalExtendedType();
                    };
                    new(&m_extended_type) MinimalExtendedType();

                }

                return m_extended_type;
            }


    uint8_t m__d {TK_NONE};

    union
    {
        MinimalAliasType m_alias_type;
        MinimalAnnotationType m_annotation_type;
        MinimalStructType m_struct_type;
        MinimalUnionType m_union_type;
        MinimalBitsetType m_bitset_type;
        MinimalSequenceType m_sequence_type;
        MinimalArrayType m_array_type;
        MinimalMapType m_map_type;
        MinimalEnumeratedType m_enumerated_type;
        MinimalBitmaskType m_bitmask_type;
        MinimalExtendedType m_extended_type;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
/*!
 * @brief This class represents the union TypeObject defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class TypeObject
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeObject()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeObject()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeObject that will be copied.
     */
    eProsima_user_DllExport TypeObject(
            const TypeObject& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            complete_() = x.m_complete;
                            break;

                        case 0x00000002:
                            minimal_() = x.m_minimal;
                            break;

        }
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeObject that will be copied.
     */
    eProsima_user_DllExport TypeObject(
            TypeObject&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            complete_() = std::move(x.m_complete);
                            break;

                        case 0x00000002:
                            minimal_() = std::move(x.m_minimal);
                            break;

        }
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeObject that will be copied.
     */
    eProsima_user_DllExport TypeObject& operator =(
            const TypeObject& x)
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            complete_() = x.m_complete;
                            break;

                        case 0x00000002:
                            minimal_() = x.m_minimal;
                            break;

        }

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeObject that will be copied.
     */
    eProsima_user_DllExport TypeObject& operator =(
            TypeObject&& x) noexcept
    {
        m__d = x.m__d;

        switch (x.selected_member_)
        {
                        case 0x00000001:
                            complete_() = std::move(x.m_complete);
                            break;

                        case 0x00000002:
                            minimal_() = std::move(x.m_minimal);
                            break;

        }

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeObject object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeObject& x) const
    {
        bool ret_value {false};

        if (x.selected_member_ == selected_member_)
        {
            if (0x0FFFFFFFu != selected_member_)
            {
                if (x.m__d == m__d)
                {
                    switch (selected_member_)
                    {
                                                    case 0x00000001:
                                                        ret_value = (x.m_complete == m_complete);
                                                        break;

                                                    case 0x00000002:
                                                        ret_value = (x.m_minimal == m_minimal);
                                                        break;

                    }
                }
            }
            else
            {
                ret_value = true;
            }
        }

        return ret_value;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeObject object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeObject& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets the discriminator value.
     * @param __d New value for the discriminator.
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the new value doesn't correspond to the selected union member.
     */
    eProsima_user_DllExport void _d(
            uint8_t __d)
    {
        bool valid_discriminator = false;

        switch (__d)
        {
                        case EK_COMPLETE:
                            if (0x00000001 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

                        case EK_MINIMAL:
                            if (0x00000002 == selected_member_)
                            {
                                valid_discriminator = true;
                            }
                            break;

        }

        if (!valid_discriminator)
        {
            throw eprosima::fastcdr::exception::BadParamException("Discriminator doesn't correspond with the selected union member");
        }

        m__d = __d;
    }

    /*!
     * @brief This function returns the value of the discriminator.
     * @return Value of the discriminator
     */
    eProsima_user_DllExport uint8_t _d() const
    {
        return m__d;
    }

    /*!
     * @brief This function copies the value in member complete
     * @param _complete New value to be copied in member complete
     */
    eProsima_user_DllExport void complete(
            const CompleteTypeObject& _complete)
    {
        complete_() = _complete;
        m__d = EK_COMPLETE;
    }

    /*!
     * @brief This function moves the value in member complete
     * @param _complete New value to be moved in member complete
     */
    eProsima_user_DllExport void complete(
            CompleteTypeObject&& _complete)
    {
        complete_() = _complete;
        m__d = EK_COMPLETE;
    }

    /*!
     * @brief This function returns a constant reference to member complete
     * @return Constant reference to member complete
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const CompleteTypeObject& complete() const
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_complete;
    }

    /*!
     * @brief This function returns a reference to member complete
     * @return Reference to member complete
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport CompleteTypeObject& complete()
    {
        if (0x00000001 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_complete;
    }


    /*!
     * @brief This function copies the value in member minimal
     * @param _minimal New value to be copied in member minimal
     */
    eProsima_user_DllExport void minimal(
            const MinimalTypeObject& _minimal)
    {
        minimal_() = _minimal;
        m__d = EK_MINIMAL;
    }

    /*!
     * @brief This function moves the value in member minimal
     * @param _minimal New value to be moved in member minimal
     */
    eProsima_user_DllExport void minimal(
            MinimalTypeObject&& _minimal)
    {
        minimal_() = _minimal;
        m__d = EK_MINIMAL;
    }

    /*!
     * @brief This function returns a constant reference to member minimal
     * @return Constant reference to member minimal
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport const MinimalTypeObject& minimal() const
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_minimal;
    }

    /*!
     * @brief This function returns a reference to member minimal
     * @return Reference to member minimal
     * @exception eprosima::fastcdr::exception::BadParamException This exception is thrown if the requested union member is not the current selection.
     */
    eProsima_user_DllExport MinimalTypeObject& minimal()
    {
        if (0x00000002 != selected_member_)
        {
            throw eprosima::fastcdr::exception::BadParamException("This member has not been selected");
        }

        return m_minimal;
    }


    void _default()
    {
        if (member_destructor_)
        {
            member_destructor_();
        }

        selected_member_ = 0x0FFFFFFFu;
    }


private:

            CompleteTypeObject& complete_()
            {
                if (0x00000001 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000001;
                    member_destructor_ = [&]()
                    {
                        m_complete.~CompleteTypeObject();
                    };
                    new(&m_complete) CompleteTypeObject();

                }

                return m_complete;
            }

            MinimalTypeObject& minimal_()
            {
                if (0x00000002 != selected_member_)
                {
                    if (member_destructor_)
                    {
                        member_destructor_();
                    }

                    selected_member_ = 0x00000002;
                    member_destructor_ = [&]()
                    {
                        m_minimal.~MinimalTypeObject();
                    };
                    new(&m_minimal) MinimalTypeObject();

                }

                return m_minimal;
            }


    uint8_t m__d {TK_NONE};

    union
    {
        CompleteTypeObject m_complete;
        MinimalTypeObject m_minimal;
    };

    uint32_t selected_member_ {0x0FFFFFFFu};

    std::function<void()> member_destructor_;
};
typedef std::vector<TypeObject> TypeObjectSeq;

typedef TypeObjectSeq StronglyConnectedComponent;

/*!
 * @brief This class represents the structure TypeIdentifierTypeObjectPair defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class TypeIdentifierTypeObjectPair
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeIdentifierTypeObjectPair()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeIdentifierTypeObjectPair()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeIdentifierTypeObjectPair that will be copied.
     */
    eProsima_user_DllExport TypeIdentifierTypeObjectPair(
            const TypeIdentifierTypeObjectPair& x)
    {
                    m_type_identifier = x.m_type_identifier;

                    m_type_object = x.m_type_object;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeIdentifierTypeObjectPair that will be copied.
     */
    eProsima_user_DllExport TypeIdentifierTypeObjectPair(
            TypeIdentifierTypeObjectPair&& x) noexcept
    {
        m_type_identifier = std::move(x.m_type_identifier);
        m_type_object = std::move(x.m_type_object);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeIdentifierTypeObjectPair that will be copied.
     */
    eProsima_user_DllExport TypeIdentifierTypeObjectPair& operator =(
            const TypeIdentifierTypeObjectPair& x)
    {

                    m_type_identifier = x.m_type_identifier;

                    m_type_object = x.m_type_object;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeIdentifierTypeObjectPair that will be copied.
     */
    eProsima_user_DllExport TypeIdentifierTypeObjectPair& operator =(
            TypeIdentifierTypeObjectPair&& x) noexcept
    {

        m_type_identifier = std::move(x.m_type_identifier);
        m_type_object = std::move(x.m_type_object);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeIdentifierTypeObjectPair object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeIdentifierTypeObjectPair& x) const
    {
        return (m_type_identifier == x.m_type_identifier &&
           m_type_object == x.m_type_object);
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeIdentifierTypeObjectPair object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeIdentifierTypeObjectPair& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member type_identifier
     * @param _type_identifier New value to be copied in member type_identifier
     */
    eProsima_user_DllExport void type_identifier(
            const TypeIdentifier& _type_identifier)
    {
        m_type_identifier = _type_identifier;
    }

    /*!
     * @brief This function moves the value in member type_identifier
     * @param _type_identifier New value to be moved in member type_identifier
     */
    eProsima_user_DllExport void type_identifier(
            TypeIdentifier&& _type_identifier)
    {
        m_type_identifier = std::move(_type_identifier);
    }

    /*!
     * @brief This function returns a constant reference to member type_identifier
     * @return Constant reference to member type_identifier
     */
    eProsima_user_DllExport const TypeIdentifier& type_identifier() const
    {
        return m_type_identifier;
    }

    /*!
     * @brief This function returns a reference to member type_identifier
     * @return Reference to member type_identifier
     */
    eProsima_user_DllExport TypeIdentifier& type_identifier()
    {
        return m_type_identifier;
    }


    /*!
     * @brief This function copies the value in member type_object
     * @param _type_object New value to be copied in member type_object
     */
    eProsima_user_DllExport void type_object(
            const TypeObject& _type_object)
    {
        m_type_object = _type_object;
    }

    /*!
     * @brief This function moves the value in member type_object
     * @param _type_object New value to be moved in member type_object
     */
    eProsima_user_DllExport void type_object(
            TypeObject&& _type_object)
    {
        m_type_object = std::move(_type_object);
    }

    /*!
     * @brief This function returns a constant reference to member type_object
     * @return Constant reference to member type_object
     */
    eProsima_user_DllExport const TypeObject& type_object() const
    {
        return m_type_object;
    }

    /*!
     * @brief This function returns a reference to member type_object
     * @return Reference to member type_object
     */
    eProsima_user_DllExport TypeObject& type_object()
    {
        return m_type_object;
    }



private:

    TypeIdentifier m_type_identifier;
    TypeObject m_type_object;

};
typedef std::vector<TypeIdentifierTypeObjectPair> TypeIdentifierTypeObjectPairSeq;

/*!
 * @brief This class represents the structure TypeIdentifierPair defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class TypeIdentifierPair
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeIdentifierPair()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeIdentifierPair()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeIdentifierPair that will be copied.
     */
    eProsima_user_DllExport TypeIdentifierPair(
            const TypeIdentifierPair& x)
    {
                    m_type_identifier1 = x.m_type_identifier1;

                    m_type_identifier2 = x.m_type_identifier2;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeIdentifierPair that will be copied.
     */
    eProsima_user_DllExport TypeIdentifierPair(
            TypeIdentifierPair&& x) noexcept
    {
        m_type_identifier1 = std::move(x.m_type_identifier1);
        m_type_identifier2 = std::move(x.m_type_identifier2);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeIdentifierPair that will be copied.
     */
    eProsima_user_DllExport TypeIdentifierPair& operator =(
            const TypeIdentifierPair& x)
    {

                    m_type_identifier1 = x.m_type_identifier1;

                    m_type_identifier2 = x.m_type_identifier2;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeIdentifierPair that will be copied.
     */
    eProsima_user_DllExport TypeIdentifierPair& operator =(
            TypeIdentifierPair&& x) noexcept
    {

        m_type_identifier1 = std::move(x.m_type_identifier1);
        m_type_identifier2 = std::move(x.m_type_identifier2);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeIdentifierPair object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeIdentifierPair& x) const
    {
        return (m_type_identifier1 == x.m_type_identifier1 &&
           m_type_identifier2 == x.m_type_identifier2);
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeIdentifierPair object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeIdentifierPair& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member type_identifier1
     * @param _type_identifier1 New value to be copied in member type_identifier1
     */
    eProsima_user_DllExport void type_identifier1(
            const TypeIdentifier& _type_identifier1)
    {
        m_type_identifier1 = _type_identifier1;
    }

    /*!
     * @brief This function moves the value in member type_identifier1
     * @param _type_identifier1 New value to be moved in member type_identifier1
     */
    eProsima_user_DllExport void type_identifier1(
            TypeIdentifier&& _type_identifier1)
    {
        m_type_identifier1 = std::move(_type_identifier1);
    }

    /*!
     * @brief This function returns a constant reference to member type_identifier1
     * @return Constant reference to member type_identifier1
     */
    eProsima_user_DllExport const TypeIdentifier& type_identifier1() const
    {
        return m_type_identifier1;
    }

    /*!
     * @brief This function returns a reference to member type_identifier1
     * @return Reference to member type_identifier1
     */
    eProsima_user_DllExport TypeIdentifier& type_identifier1()
    {
        return m_type_identifier1;
    }


    /*!
     * @brief This function copies the value in member type_identifier2
     * @param _type_identifier2 New value to be copied in member type_identifier2
     */
    eProsima_user_DllExport void type_identifier2(
            const TypeIdentifier& _type_identifier2)
    {
        m_type_identifier2 = _type_identifier2;
    }

    /*!
     * @brief This function moves the value in member type_identifier2
     * @param _type_identifier2 New value to be moved in member type_identifier2
     */
    eProsima_user_DllExport void type_identifier2(
            TypeIdentifier&& _type_identifier2)
    {
        m_type_identifier2 = std::move(_type_identifier2);
    }

    /*!
     * @brief This function returns a constant reference to member type_identifier2
     * @return Constant reference to member type_identifier2
     */
    eProsima_user_DllExport const TypeIdentifier& type_identifier2() const
    {
        return m_type_identifier2;
    }

    /*!
     * @brief This function returns a reference to member type_identifier2
     * @return Reference to member type_identifier2
     */
    eProsima_user_DllExport TypeIdentifier& type_identifier2()
    {
        return m_type_identifier2;
    }



private:

    TypeIdentifier m_type_identifier1;
    TypeIdentifier m_type_identifier2;

};
typedef std::vector<TypeIdentifierPair> TypeIdentifierPairSeq;

/*!
 * @brief This class represents the structure TypeIdentfierWithSize defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class TypeIdentfierWithSize
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeIdentfierWithSize()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeIdentfierWithSize()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeIdentfierWithSize that will be copied.
     */
    eProsima_user_DllExport TypeIdentfierWithSize(
            const TypeIdentfierWithSize& x)
    {
                    m_type_id = x.m_type_id;

                    m_typeobject_serialized_size = x.m_typeobject_serialized_size;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeIdentfierWithSize that will be copied.
     */
    eProsima_user_DllExport TypeIdentfierWithSize(
            TypeIdentfierWithSize&& x) noexcept
    {
        m_type_id = std::move(x.m_type_id);
        m_typeobject_serialized_size = x.m_typeobject_serialized_size;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeIdentfierWithSize that will be copied.
     */
    eProsima_user_DllExport TypeIdentfierWithSize& operator =(
            const TypeIdentfierWithSize& x)
    {

                    m_type_id = x.m_type_id;

                    m_typeobject_serialized_size = x.m_typeobject_serialized_size;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeIdentfierWithSize that will be copied.
     */
    eProsima_user_DllExport TypeIdentfierWithSize& operator =(
            TypeIdentfierWithSize&& x) noexcept
    {

        m_type_id = std::move(x.m_type_id);
        m_typeobject_serialized_size = x.m_typeobject_serialized_size;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeIdentfierWithSize object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeIdentfierWithSize& x) const
    {
        return (m_type_id == x.m_type_id &&
           m_typeobject_serialized_size == x.m_typeobject_serialized_size);
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeIdentfierWithSize object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeIdentfierWithSize& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member type_id
     * @param _type_id New value to be copied in member type_id
     */
    eProsima_user_DllExport void type_id(
            const TypeIdentifier& _type_id)
    {
        m_type_id = _type_id;
    }

    /*!
     * @brief This function moves the value in member type_id
     * @param _type_id New value to be moved in member type_id
     */
    eProsima_user_DllExport void type_id(
            TypeIdentifier&& _type_id)
    {
        m_type_id = std::move(_type_id);
    }

    /*!
     * @brief This function returns a constant reference to member type_id
     * @return Constant reference to member type_id
     */
    eProsima_user_DllExport const TypeIdentifier& type_id() const
    {
        return m_type_id;
    }

    /*!
     * @brief This function returns a reference to member type_id
     * @return Reference to member type_id
     */
    eProsima_user_DllExport TypeIdentifier& type_id()
    {
        return m_type_id;
    }


    /*!
     * @brief This function sets a value in member typeobject_serialized_size
     * @param _typeobject_serialized_size New value for member typeobject_serialized_size
     */
    eProsima_user_DllExport void typeobject_serialized_size(
            uint32_t _typeobject_serialized_size)
    {
        m_typeobject_serialized_size = _typeobject_serialized_size;
    }

    /*!
     * @brief This function returns the value of member typeobject_serialized_size
     * @return Value of member typeobject_serialized_size
     */
    eProsima_user_DllExport uint32_t typeobject_serialized_size() const
    {
        return m_typeobject_serialized_size;
    }

    /*!
     * @brief This function returns a reference to member typeobject_serialized_size
     * @return Reference to member typeobject_serialized_size
     */
    eProsima_user_DllExport uint32_t& typeobject_serialized_size()
    {
        return m_typeobject_serialized_size;
    }



private:

    TypeIdentifier m_type_id;
    uint32_t m_typeobject_serialized_size{0};

};
typedef std::vector<TypeIdentfierWithSize> TypeIdentfierWithSizeSeq;

/*!
 * @brief This class represents the structure TypeIdentifierWithDependencies defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class TypeIdentifierWithDependencies
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeIdentifierWithDependencies()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeIdentifierWithDependencies()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeIdentifierWithDependencies that will be copied.
     */
    eProsima_user_DllExport TypeIdentifierWithDependencies(
            const TypeIdentifierWithDependencies& x)
    {
                    m_typeid_with_size = x.m_typeid_with_size;

                    m_dependent_typeid_count = x.m_dependent_typeid_count;

                    m_dependent_typeids = x.m_dependent_typeids;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeIdentifierWithDependencies that will be copied.
     */
    eProsima_user_DllExport TypeIdentifierWithDependencies(
            TypeIdentifierWithDependencies&& x) noexcept
    {
        m_typeid_with_size = std::move(x.m_typeid_with_size);
        m_dependent_typeid_count = x.m_dependent_typeid_count;
        m_dependent_typeids = std::move(x.m_dependent_typeids);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeIdentifierWithDependencies that will be copied.
     */
    eProsima_user_DllExport TypeIdentifierWithDependencies& operator =(
            const TypeIdentifierWithDependencies& x)
    {

                    m_typeid_with_size = x.m_typeid_with_size;

                    m_dependent_typeid_count = x.m_dependent_typeid_count;

                    m_dependent_typeids = x.m_dependent_typeids;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeIdentifierWithDependencies that will be copied.
     */
    eProsima_user_DllExport TypeIdentifierWithDependencies& operator =(
            TypeIdentifierWithDependencies&& x) noexcept
    {

        m_typeid_with_size = std::move(x.m_typeid_with_size);
        m_dependent_typeid_count = x.m_dependent_typeid_count;
        m_dependent_typeids = std::move(x.m_dependent_typeids);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeIdentifierWithDependencies object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeIdentifierWithDependencies& x) const
    {
        return (m_typeid_with_size == x.m_typeid_with_size &&
           m_dependent_typeid_count == x.m_dependent_typeid_count &&
           m_dependent_typeids == x.m_dependent_typeids);
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeIdentifierWithDependencies object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeIdentifierWithDependencies& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member typeid_with_size
     * @param _typeid_with_size New value to be copied in member typeid_with_size
     */
    eProsima_user_DllExport void typeid_with_size(
            const TypeIdentfierWithSize& _typeid_with_size)
    {
        m_typeid_with_size = _typeid_with_size;
    }

    /*!
     * @brief This function moves the value in member typeid_with_size
     * @param _typeid_with_size New value to be moved in member typeid_with_size
     */
    eProsima_user_DllExport void typeid_with_size(
            TypeIdentfierWithSize&& _typeid_with_size)
    {
        m_typeid_with_size = std::move(_typeid_with_size);
    }

    /*!
     * @brief This function returns a constant reference to member typeid_with_size
     * @return Constant reference to member typeid_with_size
     */
    eProsima_user_DllExport const TypeIdentfierWithSize& typeid_with_size() const
    {
        return m_typeid_with_size;
    }

    /*!
     * @brief This function returns a reference to member typeid_with_size
     * @return Reference to member typeid_with_size
     */
    eProsima_user_DllExport TypeIdentfierWithSize& typeid_with_size()
    {
        return m_typeid_with_size;
    }


    /*!
     * @brief This function sets a value in member dependent_typeid_count
     * @param _dependent_typeid_count New value for member dependent_typeid_count
     */
    eProsima_user_DllExport void dependent_typeid_count(
            int32_t _dependent_typeid_count)
    {
        m_dependent_typeid_count = _dependent_typeid_count;
    }

    /*!
     * @brief This function returns the value of member dependent_typeid_count
     * @return Value of member dependent_typeid_count
     */
    eProsima_user_DllExport int32_t dependent_typeid_count() const
    {
        return m_dependent_typeid_count;
    }

    /*!
     * @brief This function returns a reference to member dependent_typeid_count
     * @return Reference to member dependent_typeid_count
     */
    eProsima_user_DllExport int32_t& dependent_typeid_count()
    {
        return m_dependent_typeid_count;
    }


    /*!
     * @brief This function copies the value in member dependent_typeids
     * @param _dependent_typeids New value to be copied in member dependent_typeids
     */
    eProsima_user_DllExport void dependent_typeids(
            const std::vector<TypeIdentfierWithSize>& _dependent_typeids)
    {
        m_dependent_typeids = _dependent_typeids;
    }

    /*!
     * @brief This function moves the value in member dependent_typeids
     * @param _dependent_typeids New value to be moved in member dependent_typeids
     */
    eProsima_user_DllExport void dependent_typeids(
            std::vector<TypeIdentfierWithSize>&& _dependent_typeids)
    {
        m_dependent_typeids = std::move(_dependent_typeids);
    }

    /*!
     * @brief This function returns a constant reference to member dependent_typeids
     * @return Constant reference to member dependent_typeids
     */
    eProsima_user_DllExport const std::vector<TypeIdentfierWithSize>& dependent_typeids() const
    {
        return m_dependent_typeids;
    }

    /*!
     * @brief This function returns a reference to member dependent_typeids
     * @return Reference to member dependent_typeids
     */
    eProsima_user_DllExport std::vector<TypeIdentfierWithSize>& dependent_typeids()
    {
        return m_dependent_typeids;
    }



private:

    TypeIdentfierWithSize m_typeid_with_size;
    int32_t m_dependent_typeid_count{0};
    std::vector<TypeIdentfierWithSize> m_dependent_typeids;

};
typedef std::vector<TypeIdentifierWithDependencies> TypeIdentifierWithDependenciesSeq;

/*!
 * @brief This class represents the structure TypeInformation defined by the user in the IDL file.
 * @ingroup dds_xtypes_typeobject
 */
class TypeInformation
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeInformation()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeInformation()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeInformation that will be copied.
     */
    eProsima_user_DllExport TypeInformation(
            const TypeInformation& x)
    {
                    m_minimal = x.m_minimal;

                    m_complete = x.m_complete;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeInformation that will be copied.
     */
    eProsima_user_DllExport TypeInformation(
            TypeInformation&& x) noexcept
    {
        m_minimal = std::move(x.m_minimal);
        m_complete = std::move(x.m_complete);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeInformation that will be copied.
     */
    eProsima_user_DllExport TypeInformation& operator =(
            const TypeInformation& x)
    {

                    m_minimal = x.m_minimal;

                    m_complete = x.m_complete;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeInformation that will be copied.
     */
    eProsima_user_DllExport TypeInformation& operator =(
            TypeInformation&& x) noexcept
    {

        m_minimal = std::move(x.m_minimal);
        m_complete = std::move(x.m_complete);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeInformation object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeInformation& x) const
    {
        return (m_minimal == x.m_minimal &&
           m_complete == x.m_complete);
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeInformation object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeInformation& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member minimal
     * @param _minimal New value to be copied in member minimal
     */
    eProsima_user_DllExport void minimal(
            const TypeIdentifierWithDependencies& _minimal)
    {
        m_minimal = _minimal;
    }

    /*!
     * @brief This function moves the value in member minimal
     * @param _minimal New value to be moved in member minimal
     */
    eProsima_user_DllExport void minimal(
            TypeIdentifierWithDependencies&& _minimal)
    {
        m_minimal = std::move(_minimal);
    }

    /*!
     * @brief This function returns a constant reference to member minimal
     * @return Constant reference to member minimal
     */
    eProsima_user_DllExport const TypeIdentifierWithDependencies& minimal() const
    {
        return m_minimal;
    }

    /*!
     * @brief This function returns a reference to member minimal
     * @return Reference to member minimal
     */
    eProsima_user_DllExport TypeIdentifierWithDependencies& minimal()
    {
        return m_minimal;
    }


    /*!
     * @brief This function copies the value in member complete
     * @param _complete New value to be copied in member complete
     */
    eProsima_user_DllExport void complete(
            const TypeIdentifierWithDependencies& _complete)
    {
        m_complete = _complete;
    }

    /*!
     * @brief This function moves the value in member complete
     * @param _complete New value to be moved in member complete
     */
    eProsima_user_DllExport void complete(
            TypeIdentifierWithDependencies&& _complete)
    {
        m_complete = std::move(_complete);
    }

    /*!
     * @brief This function returns a constant reference to member complete
     * @return Constant reference to member complete
     */
    eProsima_user_DllExport const TypeIdentifierWithDependencies& complete() const
    {
        return m_complete;
    }

    /*!
     * @brief This function returns a reference to member complete
     * @return Reference to member complete
     */
    eProsima_user_DllExport TypeIdentifierWithDependencies& complete()
    {
        return m_complete;
    }



private:

    TypeIdentifierWithDependencies m_minimal;
    TypeIdentifierWithDependencies m_complete;

};
typedef std::vector<TypeInformation> TypeInformationSeq;


} // namespace xtypes


} // namespace dds

} // namespace fastdds

} // namespace eprosima


#endif // _FAST_DDS_GENERATED_EPROSIMA_FASTDDS_DDS_XTYPES_DDS_XTYPES_TYPEOBJECT_HPP_


