/* $Id: AmbiguousTypes.cpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/reporting/AmbiguousTypes.hpp"
#include "frontend/ast/TypeDeclaration.hpp"

namespace ast {

AmbiguousTypes::AmbiguousTypes(
	const AstNode &ambigousNode,
	std::list<const TypeDeclaration*> possibleTypes,
	std::string msg
) : CompileError(ambigousNode, msg) 
{
	for (std::list<const TypeDeclaration*>::const_iterator i = 
		possibleTypes.begin();
		i != possibleTypes.end(); i++) {

		if ((*i)->name == NULL) {
			typeNames.push_back(make_pair(
						std::string(""),
						(*i)->location));
			continue;
		}

		typeNames.push_back(make_pair(*(*i)->name, (*i)->location));
	}
}

void 
AmbiguousTypes::put(std::ostream &stream) const
{
	stream << this->location << ": "
		<< "ambigous types ("
		<< this->message << ")" 
		<< std::endl;

	stream << "\tPossible types are: " << std::endl;
		

	for (std::list< std::pair<std::string, Location> >::const_iterator i =
		this->typeNames.begin();
		i != this->typeNames.end(); i++) {

		stream << "\t\t" << (*i).first << " (defined at: "
			<< (*i).second << ")" << std::endl;
	}
}

}; /* namespace ast */
