/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  Copyright (C) 2004-2005 Takuro Ashie
 *  Copyright (C) 2012 CSSlayer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <stdlib.h>
#include <fcitx-config/hotkey.h>
#include "default_tables.h"

/* from Suikyo */
ConvRule fcitx_anthy_romaji_typing_rule[] = {
{"-",	"ー",	""},
#if 0
{"[",   "「",	""},
{"]",   "」",	""},
#endif
{"a",	"あ",	""},
{"i",	"い",	""},
{"u",	"う",	""},
{"e",	"え",	""},
{"o",	"お",	""},
{"xa",	"ぁ",	""},
{"xi",	"ぃ",	""},
{"xu",	"ぅ",	""},
{"xe",	"ぇ",	""},
{"xo",	"ぉ",	""},
{"la",	"ぁ",	""},
{"li",	"ぃ",	""},
{"lu",	"ぅ",	""},
{"le",	"ぇ",	""},
{"lo",	"ぉ",	""},
{"wi",	"うぃ",	""},
{"we",	"うぇ",	""},
{"wha",	"うぁ",	""},
{"whi",	"うぃ",	""},
{"whe",	"うぇ",	""},
{"who",	"うぉ",	""},
#if 0
{"va",	"う゛ぁ",	""},
{"vi",	"う゛ぃ",	""},
{"vu",	"う゛",	""},
{"ve",	"う゛ぇ",	""},
{"vo",	"う゛ぉ",	""},
#else
{"va",	"ヴぁ",	""},
{"vi",	"ヴぃ",	""},
{"vu",	"ヴ",	""},
{"ve",	"ヴぇ",	""},
{"vo",	"ヴぉ",	""},
#endif
{"ka",	"か",	""},
{"ki",	"き",	""},
{"ku",	"く",	""},
{"ke",	"け",	""},
{"ko",	"こ",	""},
{"ga",	"が",	""},
{"gi",	"ぎ",	""},
{"gu",	"ぐ",	""},
{"ge",	"げ",	""},
{"go",	"ご",	""},
{"kya",	"きゃ",	""},
{"kyi",	"きぃ",	""},
{"kyu",	"きゅ",	""},
{"kye",	"きぇ",	""},
{"kyo",	"きょ",	""},
{"gya",	"ぎゃ",	""},
{"gyi",	"ぎぃ",	""},
{"gyu",	"ぎゅ",	""},
{"gye",	"ぎぇ",	""},
{"gyo",	"ぎょ",	""},
{"sa",	"さ",	""},
{"si",	"し",	""},
{"su",	"す",	""},
{"se",	"せ",	""},
{"so",	"そ",	""},
{"za",	"ざ",	""},
{"zi",	"じ",	""},
{"zu",	"ず",	""},
{"ze",	"ぜ",	""},
{"zo",	"ぞ",	""},
{"sya",	"しゃ",	""},
{"syi",	"しぃ",	""},
{"syu",	"しゅ",	""},
{"sye",	"しぇ",	""},
{"syo",	"しょ",	""},
{"sha",	"しゃ",	""},
{"shi",	"し",	""},
{"shu",	"しゅ",	""},
{"she",	"しぇ",	""},
{"sho",	"しょ",	""},
{"zya",	"じゃ",	""},
{"zyi",	"じぃ",	""},
{"zyu",	"じゅ",	""},
{"zye",	"じぇ",	""},
{"zyo",	"じょ",	""},
{"ja",	"じゃ",	""},
{"jya", "じゃ",	""},
{"ji",	"じ",	""},
{"jyi", "じぃ",	""},
{"ju",	"じゅ",	""},
{"jyu",	"じゅ",	""},
{"je",	"じぇ",	""},
{"jye",	"じぇ",	""},
{"jo",	"じょ",	""},
{"jyo",	"じょ",	""},
{"ta",	"た",	""},
{"ti",	"ち",	""},
{"tu",	"つ",	""},
{"tsu",	"つ",	""},
{"te",	"て",	""},
{"to",	"と",	""},
{"da",	"だ",	""},
{"di",	"ぢ",	""},
{"du",	"づ",	""},
{"de",	"で",	""},
{"do",	"ど",	""},
{"xtu",	"っ",	""},
{"xtsu","っ",	""},
{"ltu",	"っ",	""},
{"ltsu","っ",	""},
{"tya",	"ちゃ",	""},
{"tyi",	"ちぃ",	""},
{"tyu",	"ちゅ",	""},
{"tye",	"ちぇ",	""},
{"tyo",	"ちょ",	""},
{"cha",	"ちゃ",	""},
{"chi",	"ち",	""},
{"chu",	"ちゅ",	""},
{"che",	"ちぇ",	""},
{"cho",	"ちょ",	""},
{"dya",	"ぢゃ",	""},
{"dyi",	"ぢぃ",	""},
{"dyu",	"ぢゅ",	""},
{"dye",	"ぢぇ",	""},
{"dyo",	"ぢょ",	""},
{"tha",	"てゃ",	""},
{"thi",	"てぃ",	""},
{"thu",	"てゅ",	""},
{"the",	"てぇ",	""},
{"tho",	"てょ",	""},
{"dha",	"でゃ",	""},
{"dhi",	"でぃ",	""},
{"dhu",	"でゅ",	""},
{"dhe",	"でぇ",	""},
{"dho",	"でょ",	""},
{"na",	"な",	""},
{"ni",	"に",	""},
{"nu",	"ぬ",	""},
{"ne",	"ね",	""},
{"no",	"の",	""},
{"nya",	"にゃ",	""},
{"nyi",	"にぃ",	""},
{"nyu",	"にゅ",	""},
{"nye",	"にぇ",	""},
{"nyo",	"にょ",	""},
{"ha",	"は",	""},
{"hi",	"ひ",	""},
{"hu",	"ふ",	""},
{"fu",	"ふ",	""},
{"he",	"へ",	""},
{"ho",	"ほ",	""},
{"ba",	"ば",	""},
{"bi",	"び",	""},
{"bu",	"ぶ",	""},
{"be",	"べ",	""},
{"bo",	"ぼ",	""},
{"pa",	"ぱ",	""},
{"pi",	"ぴ",	""},
{"pu",	"ぷ",	""},
{"pe",	"ぺ",	""},
{"po",	"ぽ",	""},
{"hya",	"ひゃ",	""},
{"hyi",	"ひぃ",	""},
{"hyu",	"ひゅ",	""},
{"hye",	"ひぇ",	""},
{"hyo",	"ひょ",	""},
{"bya",	"びゃ",	""},
{"byi",	"びぃ",	""},
{"byu",	"びゅ",	""},
{"bye",	"びぇ",	""},
{"byo",	"びょ",	""},
{"pya",	"ぴゃ",	""},
{"pyi",	"ぴぃ",	""},
{"pyu",	"ぴゅ",	""},
{"pye",	"ぴぇ",	""},
{"pyo",	"ぴょ",	""},
{"fa",	"ふぁ",	""},
{"fi",	"ふぃ",	""},
{"fu",	"ふ",	""},
{"fe",	"ふぇ",	""},
{"fo",	"ふぉ",	""},
{"ma",	"ま",	""},
{"mi",	"み",	""},
{"mu",	"む",	""},
{"me",	"め",	""},
{"mo",	"も",	""},
{"mya",	"みゃ",	""},
{"myi",	"みぃ",	""},
{"myu",	"みゅ",	""},
{"mye",	"みぇ",	""},
{"myo",	"みょ",	""},
{"lya",	"ゃ",	""},
{"xya",	"ゃ",	""},
{"ya",	"や",	""},
{"lyu",	"ゅ",	""},
{"xyu",	"ゅ",	""},
{"yu",	"ゆ",	""},
{"lyo",	"ょ",	""},
{"xyo",	"ょ",	""},
{"yo",	"よ",	""},
{"ra",	"ら",	""},
{"ri",	"り",	""},
{"ru",	"る",	""},
{"re",	"れ",	""},
{"ro",	"ろ",	""},
{"rya",	"りゃ",	""},
{"ryi",	"りぃ",	""},
{"ryu",	"りゅ",	""},
{"rye",	"りぇ",	""},
{"ryo",	"りょ",	""},
{"xwa",	"ゎ",	""},
{"wa",	"わ",	""},
{"wo",	"を",	""},
{"n'",	"ん",	""},
{"nn",	"ん",	""},
{"n",	"ん",	""},
{"wyi",	"ゐ",	""},
{"wye",	"ゑ",	""},
#if 0 /* emulate dead key */
{"\\.",	"・",	""},
{";r",	"→",	""},
{";l",	"←",	""},
{";u",  "↑",	""},
{";d",	"↓",	""},
{";p",	"〒",	""},
{";e",	"€",	""},
{";t",	"™",	""},
{";s",	"®",	""},
{";c",	"©",	""},
#endif
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_romaji_double_consonant_rule[] = {
{"vv",	"っ",	"v"},
{"xx",	"っ",	"x"},
{"kk",	"っ",	"k"},
{"gg",	"っ",	"g"},
{"ss",	"っ",	"s"},
{"zz",	"っ",	"z"},
{"jj",	"っ",	"j"},
{"tt",	"っ",	"t"},
{"dd",	"っ",	"d"},
{"hh",	"っ",	"h"},
{"ff",	"っ",	"f"},
{"bb",	"っ",	"b"},
{"pp",	"っ",	"p"},
{"mm",	"っ",	"m"},
{"yy",	"っ",	"y"},
{"rr",	"っ",	"r"},
{"ww",	"っ",	"w"},
{"cc",	"っ",	"c"},
{NULL,  NULL,   NULL},
};

ConvRule fcitx_anthy_half_symbol_rule[] = {
{",",	",",	""},
{".",	".",	""},
{"!",	"!",	""},
{"\"",	"\"",	""},
{"#",	"#",	""},
{"$",	"$",	""},
{"%",	"%",	""},
{"&",	"&",	""},
{"'",	"'",	""},
{"(",	"(",	""},
{")",	")",	""},
{"~",	"~",	""},
{"-",	"-",	""},
{"=",	"=",	""},
{"^",	"^",	""},
{"\\",	"\\",	""},
{"|",	"|",	""},
{"`",	"`",	""},
{"@",	"@",	""},
{"{",	"{",	""},
{"[",	"[",	""},
{"+",	"+",	""},
{";",	";",	""},
{"*",	"*",	""},
{":",	":",	""},
{"}",	"}",	""},
{"]",	"]",	""},
{"<",	"<",	""},
{">",	">",	""},
{"?",	"?",	""},
{"/",	"/",	""},
{"_",	"_",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_wide_symbol_rule[] = {
{",",	"、",	""},
{".",	"。",	""},
{"!",	"！",	""},
{"\"",	"”",	""},
{"#",	"＃",	""},
{"$",	"＄",	""},
{"%",	"％",	""},
{"&",	"＆",	""},
{"'",	"’",	""},
{"(",	"（",	""},
{")",	"）",	""},
{"~",	"〜",	""},
{"-",	"ー",	""},
{"=",	"＝",	""},
{"^",	"＾",	""},
{"\\",	"＼",	""},
{"|",	"｜",	""},
{"`",	"‘",	""},
{"@",	"＠",	""},
{"{",	"｛",	""},
{"[",	"「",	""},
{"+",	"＋",	""},
{";",	"；",	""},
{"*",	"＊",	""},
{":",	"：",	""},
{"}",	"｝",	""},
{"]",	"」",	""},
{"<",	"＜",	""},
{">",	"＞",	""},
{"?",	"？",	""},
{"/",	"／",	""},
{"_",	"＿",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_half_number_rule[] = {
{"1", "1", ""},
{"2", "2", ""},
{"3", "3", ""},
{"4", "4", ""},
{"5", "5", ""},
{"6", "6", ""},
{"7", "7", ""},
{"8", "8", ""},
{"9", "9", ""},
{"0", "0", ""},
{NULL,	NULL,	NULL},
};


ConvRule fcitx_anthy_wide_number_rule[] = {
{"1", "１", ""},
{"2", "２", ""},
{"3", "３", ""},
{"4", "４", ""},
{"5", "５", ""},
{"6", "６", ""},
{"7", "７", ""},
{"8", "８", ""},
{"9", "９", ""},
{"0", "０", ""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_kana_typing_rule[] = {
// no modifiers keys
{"1",	"ぬ",	""},
{"2",	"",	"ふ"},
{"3",	"あ",	""},
{"4",	"う",	""},
{"5",	"え",	""},
{"6",	"お",	""},
{"7",	"や",	""},
{"8",	"ゆ",	""},
{"9",	"よ",	""},
{"0",	"わ",	""},
{"-",	"",	"ほ"},
{"^",	"",	"へ"},

{"q",	"",	"た"},
{"w",	"",	"て"},
{"e",	"い",	""},
{"r",	"",	"す"},
{"t",	"",	"か"},
{"y",	"ん",	""},
{"u",	"な",	""},
{"i",	"に",	""},
{"o",	"ら",	""},
{"p",	"",	"せ"},
{"@",	"゛",	""},
{"[",	"゜",	""},

{"a",	"",	"ち"},
{"s",	"",	"と"},
{"d",	"",	"し"},
{"f",	"",	"は"},
{"g",	"",	"き"},
{"h",	"",	"く"},
{"j",	"ま",	""},
{"k",	"の",	""},
{"l",	"り",	""},
{";",	"れ",	""},
{":",	"",	"け"},
{"]",	"む",	""},

{"z",	"",	"つ"},
{"x",	"",	"さ"},
{"c",	"",	"そ"},
{"v",	"",	"ひ"},
{"b",	"",	"こ"},
{"n",	"み",	""},
{"m",	"も",	""},
{",",	"ね",	""},
{".",	"る",	""},
{"/",	"め",	""},
{"\\",	"ー",	""},

// shift modifiered keys
{"!",	"ぬ",	""},
{"\"",	"",	"ふ"},
{"#",	"ぁ",	""},
{"$",	"ぅ",	""},
{"%",	"ぇ",	""},
{"&",	"ぉ",	""},
{"'",	"ゃ",	""},
{"(",	"ゅ",	""},
{")",	"ょ",	""},
{"~",	"を",	""},
{"=",	"",	"ほ"},
{"|",	"ー",	""},

{"Q",	"",	"た"},
{"W",	"",	"て"},
{"E",	"ぃ",	""},
{"R",	"",	"す"},
{"T",	"ヵ",	""},
{"Y",	"ん",	""},
{"U",	"な",	""},
{"I",	"に",	""},
{"O",	"ら",	""},
{"P",	"",	"せ"},
{"`",	"゛",	""},
#if 0
{"{",	"「",	""},
#endif

{"A",	"",	"ち"},
{"S",	"",	"と"},
{"D",	"",	"し"},
{"F",	"ゎ",	""},
{"G",	"",	"き"},
{"H",	"",	"く"},
{"J",	"ま",	""},
{"K",	"の",	""},
{"L",	"り",	""},
{"+",	"れ",	""},
{"*",	"ヶ",	""},
#if 0
{"}",	"」",	""},
#endif

{"Z",	"っ",	""},
{"X",	"",	"さ"},
{"C",	"",	"そ"},
{"V",	"",	"ゐ"},
{"B",	"",	"こ"},
{"M",	"も",	""},
{"N",	"み",	""},
#if 0
{"?",	"・",	""},
#endif
{"_",	"ろ",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_kana_voiced_consonant_rule[] = {
{"か@",	"が",	""},
{"き@",	"ぎ",	""},
{"く@",	"ぐ",	""},
{"け@",	"げ",	""},
{"こ@",	"ご",	""},
{"さ@",	"ざ",	""},
{"し@",	"じ",	""},
{"す@",	"ず",	""},
{"せ@",	"ぜ",	""},
{"そ@",	"ぞ",	""},
{"た@",	"だ",	""},
{"ち@",	"ぢ",	""},
{"つ@",	"づ",	""},
{"て@",	"で",	""},
{"と@",	"ど",	""},
{"は@",	"ば",	""},
{"ひ@",	"び",	""},
{"ふ@",	"ぶ",	""},
{"へ@",	"べ",	""},
{"ほ@",	"ぼ",	""},
{"か`",	"が",	""},
{"き`",	"ぎ",	""},
{"く`",	"ぐ",	""},
{"け`",	"げ",	""},
{"こ`",	"ご",	""},
{"さ`",	"ざ",	""},
{"し`",	"じ",	""},
{"す`",	"ず",	""},
{"せ`",	"ぜ",	""},
{"そ`",	"ぞ",	""},
{"た`",	"だ",	""},
{"ち`",	"ぢ",	""},
{"つ`",	"づ",	""},
{"て`",	"で",	""},
{"と`",	"ど",	""},
{"は`",	"ば",	""},
{"ひ`",	"び",	""},
{"ふ`",	"ぶ",	""},
{"へ`",	"べ",	""},
{"ほ`",	"ぼ",	""},
{"は[",	"ぱ",	""},
{"ひ[",	"ぴ",	""},
{"ふ[",	"ぷ",	""},
{"へ[",	"ぺ",	""},
{"ほ[",	"ぽ",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_romaji_ja_period_rule[] = {
{".",	"。",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_romaji_ja_comma_rule[] = {
{",",	"、",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_romaji_wide_period_rule[] = {
{".",	"．",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_romaji_wide_comma_rule[] = {
{",",	"，",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_romaji_half_period_rule[] = {
{".",	".",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_romaji_half_comma_rule[] = {
{",",	",",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_kana_ja_period_rule[] = {
{">",	"。",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_kana_ja_comma_rule[] = {
{"<",	"、",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_kana_wide_period_rule[] = {
{">",	"．",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_kana_wide_comma_rule[] = {
{"<",	"，",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_kana_half_period_rule[] = {
{">",	".",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_kana_half_comma_rule[] = {
{"<",	",",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_romaji_ja_bracket_rule[] = {
{"[",	"「",	""},
{"]",	"」",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_romaji_wide_bracket_rule[] = {
{"[",	"［",	""},
{"]",	"］",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_kana_ja_bracket_rule[] = {
{"{",	"「",	""},
{"}",	"」",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_kana_wide_bracket_rule[] = {
{"{",	"［",	""},
{"}",	"］",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_romaji_ja_slash_rule[] = {
{"/",	"・",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_romaji_wide_slash_rule[] = {
{"/",	"／",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_kana_ja_slash_rule[] = {
{"?",	"・",	""},
{NULL,	NULL,	NULL},
};

ConvRule fcitx_anthy_kana_wide_slash_rule[] = {
{"?",	"／",	""},
{NULL,	NULL,	NULL},
};

HiraganaKatakanaRule fcitx_anthy_hiragana_katakana_table[] = {
{"あ", "ア", "ｱ"},
{"い", "イ", "ｲ"},
{"う", "ウ", "ｳ"},
{"え", "エ", "ｴ"},
{"お", "オ", "ｵ"},
{"か", "カ", "ｶ"},
{"き", "キ", "ｷ"},
{"く", "ク", "ｸ"},
{"け", "ケ", "ｹ"},
{"こ", "コ", "ｺ"},
{"が", "ガ", "ｶﾞ"},
{"ぎ", "ギ", "ｷﾞ"},
{"ぐ", "グ", "ｸﾞ"},
{"げ", "ゲ", "ｹﾞ"},
{"ご", "ゴ", "ｺﾞ"},
{"さ", "サ", "ｻ"},
{"し", "シ", "ｼ"},
{"す", "ス", "ｽ"},
{"せ", "セ", "ｾ"},
{"そ", "ソ", "ｿ"},
{"ざ", "ザ", "ｻﾞ"},
{"じ", "ジ", "ｼﾞ"},
{"ず", "ズ", "ｽﾞ"},
{"ぜ", "ゼ", "ｾﾞ"},
{"ぞ", "ゾ", "ｿﾞ"},
{"た", "タ", "ﾀ"},
{"ち", "チ", "ﾁ"},
{"つ", "ツ", "ﾂ"},
{"て", "テ", "ﾃ"},
{"と", "ト", "ﾄ"},
{"だ", "ダ", "ﾀﾞ"},
{"ぢ", "ヂ", "ﾁﾞ"},
{"づ", "ヅ", "ﾂﾞ"},
{"で", "デ", "ﾃﾞ"},
{"ど", "ド", "ﾄﾞ"},
{"な", "ナ", "ﾅ"},
{"に", "ニ", "ﾆ"},
{"ぬ", "ヌ", "ﾇ"},
{"ね", "ネ", "ﾈ"},
{"の", "ノ", "ﾉ"},
{"は", "ハ", "ﾊ"},
{"ひ", "ヒ", "ﾋ"},
{"ふ", "フ", "ﾌ"},
{"へ", "ヘ", "ﾍ"},
{"ほ", "ホ", "ﾎ"},
{"ば", "バ", "ﾊﾞ"},
{"び", "ビ", "ﾋﾞ"},
{"ぶ", "ブ", "ﾌﾞ"},
{"べ", "ベ", "ﾍﾞ"},
{"ぼ", "ボ", "ﾎﾞ"},
{"ぱ", "パ", "ﾊﾟ"},
{"ぴ", "ピ", "ﾋﾟ"},
{"ぷ", "プ", "ﾌﾟ"},
{"ぺ", "ペ", "ﾍﾟ"},
{"ぽ", "ポ", "ﾎﾟ"},
{"ま", "マ", "ﾏ"},
{"み", "ミ", "ﾐ"},
{"む", "ム", "ﾑ"},
{"め", "メ", "ﾒ"},
{"も", "モ", "ﾓ"},
{"や", "ヤ", "ﾔ"},
{"ゆ", "ユ", "ﾕ"},
{"よ", "ヨ", "ﾖ"},
{"ら", "ラ", "ﾗ"},
{"り", "リ", "ﾘ"},
{"る", "ル", "ﾙ"},
{"れ", "レ", "ﾚ"},
{"ろ", "ロ", "ﾛ"},

{"わ", "ワ", "ﾜ"},
{"を", "ヲ", "ｦ"},
{"ん", "ン", "ﾝ"},

{"ぁ", "ァ", "ｧ"},
{"ぃ", "ィ", "ｨ"},
{"ぅ", "ゥ", "ｩ"},
{"ぇ", "ェ", "ｪ"},
{"ぉ", "ォ", "ｫ"},

{"っ", "ッ", "ｯ"},

{"ゃ", "ャ", "ｬ"},
{"ゅ", "ュ", "ｭ"},
{"ょ", "ョ", "ｮ"},

{"ヵ", "ヵ", "ｶ"},
{"ヶ", "ヶ", "ｹ"},

{"ゎ", "ヮ", "ﾜ"},
{"ゐ", "ヰ", "ｨ"},
{"ゑ", "ヱ", "ｪ"},

#if 1
//{"う゛" "ヴ" "ｳﾞ"},
{"ヴ", "ヴ", "ｳﾞ"},
#endif

#if 1
{"ー",	"ー",	"ｰ"},
{"、",	"、",	"､"},
{"。",	"。",	"｡"},
{"！",	"！",	"!"},
{"”",	"”",	"\""},
{"＃",	"＃",	"#"},
{"＄",	"＄",	"$"},
{"％",	"％",	"%"},
{"＆",	"＆",	"&"},
{"’",	"’",	"'"},
{"（",	"（",	"("},
{"）",	"）",	")"},
{"〜",	"〜",	"~"},
{"＝",	"＝",	"="},
{"＾",	"＾",	"^"},
{"＼",	"＼",	"\\"},
{"｜",	"｜",	"|"},
{"‘",	"‘",	"`"},
{"＠",	"＠",	"@"},
{"｛",	"｛",	"{"},
{"「",	"「",	"｢"},
{"＋",	"＋",	"+"},
{"；",	"；",	";"},
{"＊",	"＊",	"*"},
{"：",	"：",	":"},
{"｝",	"｝",	"}"},
{"」",	"」",	"｣"},
{"＜",	"＜",	"<"},
{"＞",	"＞",	">"},
{"？",	"？",	"?"},
{"／",	"／",	"/"},
{"＿",	"＿",	"_"},
#endif
{NULL,	NULL,	NULL},
};

WideRule fcitx_anthy_wide_table[] = {
{"a", "ａ"},
{"b", "ｂ"},
{"c", "ｃ"},
{"d", "ｄ"},
{"e", "ｅ"},
{"f", "ｆ"},
{"g", "ｇ"},
{"h", "ｈ"},
{"i", "ｉ"},
{"j", "ｊ"},
{"k", "ｋ"},
{"l", "ｌ"},
{"m", "ｍ"},
{"n", "ｎ"},
{"o", "ｏ"},
{"p", "ｐ"},
{"q", "ｑ"},
{"r", "ｒ"},
{"s", "ｓ"},
{"t", "ｔ"},
{"u", "ｕ"},
{"v", "ｖ"},
{"w", "ｗ"},
{"x", "ｘ"},
{"y", "ｙ"},
{"z", "ｚ"},
{"A", "Ａ"},
{"B", "Ｂ"},
{"C", "Ｃ"},
{"D", "Ｄ"},
{"E", "Ｅ"},
{"F", "Ｆ"},
{"G", "Ｇ"},
{"H", "Ｈ"},
{"I", "Ｉ"},
{"J", "Ｊ"},
{"K", "Ｋ"},
{"L", "Ｌ"},
{"M", "Ｍ"},
{"N", "Ｎ"},
{"O", "Ｏ"},
{"P", "Ｐ"},
{"Q", "Ｑ"},
{"R", "Ｒ"},
{"S", "Ｓ"},
{"T", "Ｔ"},
{"U", "Ｕ"},
{"V", "Ｖ"},
{"W", "Ｗ"},
{"X", "Ｘ"},
{"Y", "Ｙ"},
{"Z", "Ｚ"},
{"1", "１"},
{"2", "２"},
{"3", "３"},
{"4", "４"},
{"5", "５"},
{"6", "６"},
{"7", "７"},
{"8", "８"},
{"9", "９"},
{"0", "０"},
{"-", "−"},
{",", "，"},
{".", "．"},
{"!", "！"},
{"\"", "”"},
{"#", "＃"},
{"$", "＄"},
{"%", "％"},
{"&", "＆"},
{"'", "’"},
{"(", "（"},
{")", "）"},
{"~", "〜"},
{"=", "＝"},
{"^", "＾"},
{"\\", "＼"},
{"|", "｜"},
{"`", "‘"},
{"@", "＠"},
{"{", "｛"},
{"[", "［"},
{"+", "＋"},
{";", "；"},
{":", "："},
{"}", "｝"},
{"]", "］"},
{"<", "＜"},
{">", "＞"},
{"?", "？"},
{"/", "／"},
{"_", "＿"},
{"*", "＊"},
{NULL, NULL},
};

VoicedConsonantRule fcitx_anthy_voiced_consonant_table[] = {
{"か",	"が",	""},
{"き",	"ぎ",	""},
{"く",	"ぐ",	""},
{"け",	"げ",	""},
{"こ",	"ご",	""},
{"さ",	"ざ",	""},
{"し",	"じ",	""},
{"す",	"ず",	""},
{"せ",	"ぜ",	""},
{"そ",	"ぞ",	""},
{"た",	"だ",	""},
{"ち",	"ぢ",	""},
{"つ",	"づ",	""},
{"て",	"で",	""},
{"と",	"ど",	""},
{"は",	"ば",	"ぱ"},
{"ひ",	"び",	"ぴ"},
{"ふ",	"ぶ",	"ぷ"},
{"へ",	"べ",	"ぺ"},
{"ほ",	"ぼ",	"ぽ"},
{NULL, NULL, NULL},
};

KeyCodeToCharRule fcitx_anthy_keypad_table[] = {
{FcitxKey_KP_Equal,		"="},
{FcitxKey_KP_Multiply,	"*"},
{FcitxKey_KP_Add,		"+"},
{FcitxKey_KP_Separator,	","},
{FcitxKey_KP_Subtract,	"-"},
{FcitxKey_KP_Decimal,	"."},
{FcitxKey_KP_Divide,	"/"},
{FcitxKey_KP_0,			"0"},
{FcitxKey_KP_1,			"1"},
{FcitxKey_KP_2,			"2"},
{FcitxKey_KP_3,			"3"},
{FcitxKey_KP_4,			"4"},
{FcitxKey_KP_5,			"5"},
{FcitxKey_KP_6,			"6"},
{FcitxKey_KP_7,			"7"},
{FcitxKey_KP_8,			"8"},
{FcitxKey_KP_9,			"9"},
{0, NULL}
};

KeyCodeToCharRule fcitx_anthy_kana_table[] = {
{FcitxKey_kana_fullstop,        "。"},
{FcitxKey_kana_openingbracket,  "「"},
{FcitxKey_kana_closingbracket,  "」"},
{FcitxKey_kana_comma,           "、"},
{FcitxKey_kana_conjunctive,     "・"},
{FcitxKey_kana_middledot,       "・"},
{FcitxKey_kana_WO,              "を"},
{FcitxKey_kana_a,               "ぁ"},
{FcitxKey_kana_i,               "ぃ"},
{FcitxKey_kana_u,               "ぅ"},
{FcitxKey_kana_e,               "ぇ"},
{FcitxKey_kana_o,               "ぉ"},
{FcitxKey_kana_ya,              "ゃ"},
{FcitxKey_kana_yu,              "ゅ"},
{FcitxKey_kana_yo,              "ょ"},
{FcitxKey_kana_tsu,             "っ"},
{FcitxKey_kana_tu,              "っ"},
{FcitxKey_prolongedsound,       "ー"},
{FcitxKey_kana_A,               "あ"},
{FcitxKey_kana_I,               "い"},
{FcitxKey_kana_U,               "う"},
{FcitxKey_kana_E,               "え"},
{FcitxKey_kana_O,               "お"},
{FcitxKey_kana_O,               "お"},
{FcitxKey_kana_KA,              "か"},
{FcitxKey_kana_KI,              "き"},
{FcitxKey_kana_KU,              "く"},
{FcitxKey_kana_KE,              "け"},
{FcitxKey_kana_KO,              "こ"},
{FcitxKey_kana_SA,              "さ"},
{FcitxKey_kana_SHI,             "し"},
{FcitxKey_kana_SU,              "す"},
{FcitxKey_kana_SE,              "せ"},
{FcitxKey_kana_SO,              "そ"},
{FcitxKey_kana_TA,              "た"},
{FcitxKey_kana_CHI,             "ち"},
{FcitxKey_kana_TI,              "ち"},
{FcitxKey_kana_TSU,             "つ"},
{FcitxKey_kana_TU,              "つ"},
{FcitxKey_kana_TE,              "て"},
{FcitxKey_kana_TO,              "と"},
{FcitxKey_kana_NA,              "な"},
{FcitxKey_kana_NI,              "に"},
{FcitxKey_kana_NU,              "ぬ"},
{FcitxKey_kana_NE,              "ね"},
{FcitxKey_kana_NO,              "の"},
{FcitxKey_kana_HA,              "は"},
{FcitxKey_kana_HI,              "ひ"},
{FcitxKey_kana_FU,              "ふ"},
{FcitxKey_kana_HU,              "ふ"},
{FcitxKey_kana_HE,              "へ"},
{FcitxKey_kana_HO,              "ほ"},
{FcitxKey_kana_MA,              "ま"},
{FcitxKey_kana_MI,              "み"},
{FcitxKey_kana_MU,              "む"},
{FcitxKey_kana_ME,              "め"},
{FcitxKey_kana_MO,              "も"},
{FcitxKey_kana_YA,              "や"},
{FcitxKey_kana_YU,              "ゆ"},
{FcitxKey_kana_YO,              "よ"},
{FcitxKey_kana_RA,              "ら"},
{FcitxKey_kana_RI,              "り"},
{FcitxKey_kana_RU,              "る"},
{FcitxKey_kana_RE,              "れ"},
{FcitxKey_kana_RO,              "ろ"},
{FcitxKey_kana_WA,              "わ"},
{FcitxKey_kana_N,               "ん"},
{FcitxKey_voicedsound,          "゛"},
{FcitxKey_semivoicedsound,      "゜"},
{0, NULL}
};

NicolaRule fcitx_anthy_nicola_table[] = {
// no modifiered keys
{"1",	"１",	"？",	"！"},
{"2",	"２",	"／",	"゛"},
{"3",	"３",	"〜",	"＃"},
{"4",	"４",	"「",	"＄"},
{"5",	"５",	"」",	"％"},
{"6",	"６",	"＆",	"［"},
{"7",	"７",	"’",	"］"},
{"8",	"８",	"（",	"（"},
{"9",	"９",	"）",	"）"},
{"0",	"０",	"〜",	"『"},
{"-",	"−",	"＝",	"』"},
{"^",	"＾",	"",	""},
{"\\",	"￥",	"",	""},

{"q",	"。",	"ぁ",	"ゐ"},
{"w",	"か",	"え",	"が"},
{"e",	"た",	"り",	"だ"},
{"r",	"こ",	"ゃ",	"ご"},
{"t",	"さ",	"れ",	"ざ"},
{"y",	"ら",	"ぱ",	"よ"},
{"u",	"ち",	"ぢ",	"に"},
{"i",	"く",	"ぐ",	"る"},
{"o",	"つ",	"づ",	"ま"},
{"p",	"，",	"ぴ",	"ぇ"},
{"@",	"、",	"",	""},
{"[",	"゛",	"゜",	"゜"},

{"a",	"う",	"を",	"ヴ"},
{"s",	"し",	"あ",	"じ"},
{"d",	"て",	"な",	"で"},
{"f",	"け",	"ゅ",	"げ"},
{"g",	"せ",	"も",	"ぜ"},
{"h",	"は",	"ば",	"み"},
{"j",	"と",	"ど",	"お"},
{"k",	"き",	"ぎ",	"の"},
{"l",	"い",	"ぽ",	"ょ"},
{";",	"ん",	"",	"っ"},
{":",	"",	"",	""},
{"]",	"",	"",	""},

{"z",	"．",	"ぅ",	"ゑ"},
{"x",	"ひ",	"ー",	"び"},
{"c",	"す",	"ろ",	"ず"},
{"v",	"ふ",	"や",	"ぶ"},
{"b",	"へ",	"ぃ",	"べ"},
{"n",	"め",	"ぷ",	"ぬ"},
{"m",	"そ",	"ぞ",	"ゆ"},
{",",	"ね",	"ぺ",	"む"},
{".",	"ほ",	"ぼ",	"わ"},
{"/",	"・",	"ゎ",	"ぉ"},

// normal shift modifiered keys
{"!",	"！",	"",	""},
{"\"",	"”",	"",	""},
{"#",	"＃",	"",	""},
{"$",	"＄",	"",	""},
{"%",	"％",	"",	""},
{"&",	"＆",	"",	""},
{"'",	"’",	"",	""},
{"(",	"（",	"",	""},
{")",	"）",	"",	""},
{"~",	"〜",	"",	""},
{"=",	"＝",	"",	""},
{"|",	"｜",	"",	""},

{"`",	"‘",	"",	""},
{"{",	"｛",	"",	""},

{"+",	"＋",	"",	""},
{"*",	"＊",	"",	""},
{"}",	"｝",	"",	""},

{"<",	"＜",	"",	""},
{">",	"＞",	"",	""},
{"?",	"？",	"",	""},
{"_",	"＿",	"",	""},

{"Q",	"。",	"ぁ",	"ゐ"},
{"W",	"が",	"え",	"が"},
{"E",	"だ",	"り",	"だ"},
{"R",	"ご",	"ゃ",	"ご"},
{"T",	"ざ",	"れ",	"ざ"},
{"Y",	"ぱ",	"ぱ",	"よ"},
{"U",	"ぢ",	"ぢ",	"に"},
{"I",	"ぐ",	"ぐ",	"る"},
{"O",	"づ",	"づ",	"ま"},
{"P",	"ぴ",	"ぴ",	"ぇ"},
{"`",	"、",	"",	""},
{"{",	"゛",	"゜",	"゜"},

{"A",	"ヴ",	"を",	"ヴ"},
{"S",	"じ",	"あ",	"じ"},
{"D",	"で",	"な",	"で"},
{"F",	"げ",	"ゅ",	"げ"},
{"G",	"ぜ",	"も",	"ぜ"},
{"H",	"ば",	"ば",	"み"},
{"J",	"ど",	"ど",	"お"},
{"K",	"ぎ",	"ぎ",	"の"},
{"L",	"ぽ",	"ぽ",	"ょ"},
{"+",	"ん",	"",	"っ"},
{"*",	"",	"",	""},
{"}",	"",	"",	""},

{"Z",	"．",	"ぅ",	"ゑ"},
{"X",	"び",	"ー",	"び"},
{"C",	"ず",	"ろ",	"ず"},
{"V",	"ぶ",	"や",	"ぶ"},
{"B",	"べ",	"ぃ",	"べ"},
{"N",	"ぷ",	"ぷ",	"ぬ"},
{"M",	"ぞ",	"ぞ",	"ゆ"},
{"<",	"ぺ",	"ぺ",	"む"},
{">",	"ぽ",	"ぼ",	"わ"},
{"?",	"・",	"ゎ",	"ぉ"},

{NULL,	NULL,	NULL,	NULL},
};
