#                                                         -*- Perl -*-
# Copyright (c) 1999, 2000  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# ñ쥯饹 (FreePWING::Word)ñ쥯饹
# (FreePWING::EndWord) Ʊ륯饹
#
package FreePWING::Word2;

require 5.005;
require Exporter;
use English;
use FreePWING::Word;
use FreePWING::EndWord;
use strict;
use integer;

use vars qw(@ISA
	    @EXPORT
	    @EXPORT_OK);

@ISA = qw(Exporter);

#
# :
#	new()
# ᥽åɤζʬ:
# 	public 饹᥽åɡ
# :
# 	֥Ȥ롣
# :
# 	֥ȤؤΥե󥹤֤
#
sub new {
    my $type = shift;
    my $new = {
	# ñ
	'word' => FreePWING::Word->new(),

	# ñ
	'endword' => FreePWING::EndWord->new(),

	# ñե̾
	'word_file_name' => '',

	# ñե̾
	'endword_file_name' => '',

	# ޤǤ˽񤭹ȥ
	'entry_count' => 0,

	# 顼å
	'error_message' => '',
    };
    return bless($new, $type);
}

#
# :
#	open(word_file_name, endword_file_name)
#           word_file_name
#		ñե̾
#           endword_file_name
#		ñե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽å
# :
# 	񤭹Ѥñե򳫤
# :
#	 1 ֤Ԥ 0 ֤
#
sub open {
    my $self = shift;
    my ($word_file_name, $endword_file_name) = @ARG;

    #
    # ñե򳫤
    #
    $self->{'word_file_name'} = $word_file_name;
    $self->{'endword_file_name'} = $endword_file_name;
    if (!$self->{'word'}->open($word_file_name)) {
	$self->{'error_message'} = $self->{'word'}->error_message();
	return 0;
    }
    if (!$self->{'endword'}->open($endword_file_name)) {
	$self->{'error_message'} = $self->{'endword'}->error_message();
	$self->{'word'}->close();
	return 0;
    }
    return 1;
}

#
# :
#	close()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ñեĤ롣ƤʤС⤷ʤ
# :
#	 1 ֤
#
sub close {
    my $self = shift;

    $self->{'word'}->close();
    $self->{'endword'}->close();
    return 1;
}

#
# :
#	add_entry(word, heading_position, heading_file_name,
#		  text_position, text_file_name)
#           word
#		ñ
#           heading_position
# 		Фΰ
#           heading_file_name
# 		ФΥե̾
#           text_position
# 		ʸΰ
#           text_file_name
# 		ʸΥե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	ñեñɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_entry {
    my $self = shift;

    if (!$self->{'word'}->add_entry(@ARG)) {
	$self->{'error_message'} = $self->{'word'}->error_message();
	$self->{'endword'}->close();
	return 0;
    }
    if (!$self->{'endword'}->add_entry(@ARG)) {
	$self->{'error_message'} = $self->{'endword'}->error_message();
	$self->{'word'}->close();
	return 0;
    }
    $self->{'entry_count'}++;

    return 1;
}

######################################################################
# <󥹥ѿ֤ͤ᥽åɷ>
#
# :
#	󥹥ѿ̾()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
#	󥹥ѿ֤ͤ
#
sub word_file_name {
    my $self = shift;
    return $self->{'word_file_name'};
}

sub endword_file_name {
    my $self = shift;
    return $self->{'endword_file_name'};
}

sub entry_count {
    my $self = shift;
    return $self->{'entry_count'};
}

sub error_message {
    my $self = shift;
    return $self->{'error_message'};
}

1;
