/*
 * Copyright 2013 Canonical Ltd.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * telephony-app is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import Ubuntu.Components 0.1

Item {
    height: units.gu(4)
    anchors {
        topMargin: main.header.height + units.gu(1) // show it below the header

        top: parent.top
        left: parent.left
        right: parent.right
    }

    property bool refreshed: state == "pulled" ? true : false
    property int refreshThreshold: header.height + units.gu(6)

    states: [
        State {
            name: "unpulled"; when: listView.contentY >= -refreshThreshold
            PropertyChanges { target: refreshLabel; text: i18n.tr("Pull down to refresh...") }
            PropertyChanges { target: refreshArrow; rotation: 180 }
        },
        State {
            name: "pulled"; when: listView.contentY < -refreshThreshold
            PropertyChanges { target: refreshLabel; text: i18n.tr("Release to refresh...") }
            PropertyChanges { target: refreshArrow; rotation: 0 }
        }
    ]

    Row {
        spacing: units.gu(1)
        height: childrenRect.height
        anchors.centerIn: parent

        Image {
            id: refreshArrow
            source: "images/go-top.png"
            Behavior on rotation { NumberAnimation { duration: 200 } }
        }

        Label {
            id: refreshLabel
            text: i18n.tr("Pull down to refresh...")
            fontSize: "large"
            color: Theme.palette.normal.baseText
        }
    }
}
