/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;

public final class ScriptBasedMapping
extends CachedDNSToSwitchMapping
implements Configurable {
    static final int MIN_ALLOWABLE_ARGS = 1;
    static final int DEFAULT_ARG_COUNT = 100;
    static final String SCRIPT_FILENAME_KEY = "topology.script.file.name";
    static final String SCRIPT_ARG_COUNT_KEY = "topology.script.number.args";

    public ScriptBasedMapping() {
        super(new RawScriptBasedMapping());
    }

    public ScriptBasedMapping(Configuration conf) {
        this();
        this.setConf(conf);
    }

    @Override
    public Configuration getConf() {
        return ((RawScriptBasedMapping)this.rawMapping).getConf();
    }

    @Override
    public void setConf(Configuration conf) {
        ((RawScriptBasedMapping)this.rawMapping).setConf(conf);
    }

    private static final class RawScriptBasedMapping
    implements DNSToSwitchMapping {
        private String scriptName;
        private Configuration conf;
        private int maxArgs;
        private static Log LOG = LogFactory.getLog(ScriptBasedMapping.class);

        public void setConf(Configuration conf) {
            this.scriptName = conf.get(ScriptBasedMapping.SCRIPT_FILENAME_KEY);
            this.maxArgs = conf.getInt(ScriptBasedMapping.SCRIPT_ARG_COUNT_KEY, 100);
            this.conf = conf;
        }

        public Configuration getConf() {
            return this.conf;
        }

        @Override
        public List<String> resolve(List<String> names) {
            ArrayList<String> m = new ArrayList<String>(names.size());
            if (names.isEmpty()) {
                return m;
            }
            if (this.scriptName == null) {
                for (int i = 0; i < names.size(); ++i) {
                    m.add("/default-rack");
                }
                return m;
            }
            String output = this.runResolveCommand(names);
            if (output != null) {
                StringTokenizer allSwitchInfo = new StringTokenizer(output);
                while (allSwitchInfo.hasMoreTokens()) {
                    String switchInfo = allSwitchInfo.nextToken();
                    m.add(switchInfo);
                }
                if (m.size() != names.size()) {
                    LOG.warn((Object)("Script " + this.scriptName + " returned " + Integer.toString(m.size()) + " values when " + Integer.toString(names.size()) + " were expected."));
                    return null;
                }
            } else {
                return null;
            }
            return m;
        }

        private String runResolveCommand(List<String> args) {
            int loopCount = 0;
            if (args.size() == 0) {
                return null;
            }
            StringBuffer allOutput = new StringBuffer();
            int numProcessed = 0;
            if (this.maxArgs < 1) {
                LOG.warn((Object)("Invalid value " + Integer.toString(this.maxArgs) + " for " + ScriptBasedMapping.SCRIPT_ARG_COUNT_KEY + "; must be >= " + Integer.toString(1)));
                return null;
            }
            while (numProcessed != args.size()) {
                int start = this.maxArgs * loopCount;
                ArrayList<String> cmdList = new ArrayList<String>();
                cmdList.add(this.scriptName);
                for (numProcessed = start; numProcessed < start + this.maxArgs && numProcessed < args.size(); ++numProcessed) {
                    cmdList.add(args.get(numProcessed));
                }
                File dir = null;
                String userDir = System.getProperty("user.dir");
                if (userDir != null) {
                    dir = new File(userDir);
                }
                Shell.ShellCommandExecutor s = new Shell.ShellCommandExecutor(cmdList.toArray(new String[0]), dir);
                try {
                    s.execute();
                    allOutput.append(s.getOutput() + " ");
                }
                catch (Exception e) {
                    LOG.warn((Object)StringUtils.stringifyException(e));
                    return null;
                }
                ++loopCount;
            }
            return allOutput.toString();
        }
    }
}

