# This makefile compiles a dummy executable linked against
# those shared libraries that are dlopen'd by Julia modules
# in Base. The dummy executable is passed to dpkg-shlibdeps
# to generate library dependencies for the julia package.
#
# The dummy executable is further used to generate symbolic
# links lib*.so => lib*.so.SOVERSION in the private library
# path for Julia, which ensures that ccall() loads exactly
# those library versions that the julia package was built
# with and depends on.

# Include Julia makefile with LIB*NAME definitions.
include Make.inc

ifeq ($(USE_SYSTEM_ARPACK),1)
SHLIBDEPS += -larpack
endif

ifeq ($(USE_SYSTEM_BLAS),1)
SHLIBDEPS += $(LIBBLAS)
# OpenBLAS library provides both BLAS and LAPACK.
ifneq ($(LIBBLASNAME),$(LIBLAPACKNAME))
SHLIBDEPS += $(LIBLAPACK)
endif
endif

ifeq ($(USE_SYSTEM_DSFMT),1)
SHLIBDEPS += -ldSFMT
endif

ifeq ($(USE_SYSTEM_FFTW),1)
SHLIBDEPS += -lfftw3_threads -lfftw3f_threads
endif

ifeq ($(USE_SYSTEM_GMP),1)
SHLIBDEPS += -lgmp
endif

ifeq ($(USE_SYSTEM_LIBM),1)
SHLIBDEPS += $(LIBM)
else ifeq ($(USE_SYSTEM_OPENLIBM),1)
SHLIBDEPS += $(LIBM)
endif

ifeq ($(USE_SYSTEM_MPFR),1)
SHLIBDEPS += -lmpfr
endif

ifeq ($(USE_SYSTEM_OPENSPECFUN),1)
SHLIBDEPS += -lopenspecfun
endif

ifeq ($(USE_SYSTEM_PCRE),1)
SHLIBDEPS += -lpcre2-8
endif

ifeq ($(USE_SYSTEM_SUITESPARSE),1)
SHLIBDEPS += -lcholmod -lspqr -lsuitesparseconfig -lumfpack
endif

# The dummy executable is linked with --no-as-needed to prevent
# the linker from potentially disregarding the given libraries
# because none of the library symbols are used at compile time.
debian/shlibdeps: debian/shlibdeps.c
	$(CC) -fPIE -o $@ $< -ldl -Wl,--no-as-needed $(SHLIBDEPS)

# The soname for each library is looked up by invoking the
# dummy executable with the name of an arbitrary symbol such
# as a function exported by that library. Ideally, these
# should be functions that are ccall'd by the Julia modules.
debian/julia.links: debian/shlibdeps
	rm -f $@.tmp
ifeq ($(USE_SYSTEM_ARPACK),1)
	debian/shlibdeps snaupd_ >> $@.tmp
	echo " $(private_libdir)/libarpack.so" >> $@.tmp
endif
ifeq ($(USE_SYSTEM_BLAS),1)
	debian/shlibdeps daxpy_ >> $@.tmp
	echo " $(private_libdir)/$(LIBBLASNAME).so" >> $@.tmp
ifneq ($(LIBBLASNAME),$(LIBLAPACKNAME))
	debian/shlibdeps dggsvd_ >> $@.tmp
	echo " $(private_libdir)/$(LIBLAPACKNAME).so" >> $@.tmp
endif
endif
ifeq ($(USE_SYSTEM_DSFMT),1)
	debian/shlibdeps dsfmt_get_idstring >> $@.tmp
	echo " $(private_libdir)/libdSFMT.so" >> $@.tmp
endif
ifeq ($(USE_SYSTEM_FFTW),1)
	debian/shlibdeps fftw_init_threads >> $@.tmp
	echo " $(private_libdir)/$(LIBFFTWNAME).so" >> $@.tmp
	debian/shlibdeps fftwf_init_threads >> $@.tmp
	echo " $(private_libdir)/$(LIBFFTWFNAME).so" >> $@.tmp
endif
ifeq ($(USE_SYSTEM_GMP),1)
	debian/shlibdeps __gmpz_get_str >> $@.tmp
	echo " $(private_libdir)/libgmp.so" >> $@.tmp
endif
ifeq ($(USE_SYSTEM_LIBM),1)
	debian/shlibdeps pow >> $@.tmp
	echo " $(private_libdir)/$(LIBMNAME).so" >> $@.tmp
else ifeq ($(USE_SYSTEM_OPENLIBM),1)
	debian/shlibdeps pow >> $@.tmp
	echo " $(private_libdir)/$(LIBMNAME).so" >> $@.tmp
endif
ifeq ($(USE_SYSTEM_MPFR),1)
	debian/shlibdeps mpfr_init2 >> $@.tmp
	echo " $(private_libdir)/libmpfr.so" >> $@.tmp
endif
ifeq ($(USE_SYSTEM_OPENSPECFUN),1)
	debian/shlibdeps Faddeeva_w >> $@.tmp
	echo " $(private_libdir)/libopenspecfun.so" >> $@.tmp
endif
ifeq ($(USE_SYSTEM_PCRE),1)
	debian/shlibdeps pcre2_compile_8 >> $@.tmp
	echo " $(private_libdir)/libpcre2-8.so" >> $@.tmp
endif
ifeq ($(USE_SYSTEM_SUITESPARSE),1)
	debian/shlibdeps cholmod_version >> $@.tmp
	echo " $(private_libdir)/libcholmod.so" >> $@.tmp
	debian/shlibdeps SuiteSparseQR_C_free >> $@.tmp
	echo " $(private_libdir)/libspqr.so" >> $@.tmp
	debian/shlibdeps SuiteSparse_config >> $@.tmp
	echo " $(private_libdir)/libsuitesparseconfig.so" >> $@.tmp
	debian/shlibdeps umfpack_dl_report_info >> $@.tmp
	echo " $(private_libdir)/libumfpack.so" >> $@.tmp
endif
	mv $@.tmp $@
