/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <QtGui/QInputDialog>
#include <QtGui/QStringListModel>

#include "itemview.h"

#include "hostsfield.h"

using namespace Form;

class HostModel : public QStringListModel
{
  public:
    HostModel( QObject *parent = 0 )
      : QStringListModel( parent )
    {
    }

    virtual Qt::ItemFlags flags( const QModelIndex& ) const
    {
      return ( Qt::ItemIsSelectable | Qt::ItemIsEnabled );
    }
};

class HostItemView : public ItemView
{
  public:
    HostItemView( QWidget *parent )
      : ItemView( parent )
    {
    }

  protected:
    virtual void doAdd()
    {
      bool ok = true;

      QString host = QInputDialog::getText( this, tr( "New Kolab Host" ), tr( "Kolab Host:" ),
                                            QLineEdit::Normal, QString(), &ok );

      if ( ok && !host.isEmpty() ) {
        QAbstractItemModel *model = mListView->model();

        bool found = false;
        for ( int i = 0; i < model->rowCount(); ++i ) {
          if ( host == model->data( model->index( i, 0 ), Qt::DisplayRole ).toString() ) {
            found = true;
            break;
          }
        }

        if ( !found ) {
          int pos = model->rowCount();
          model->insertRow( pos );
          model->setData( model->index( pos, 0 ), host );
        }
      }
    }
};

HostsField::HostsField( const QString &name, QWidget *parent )
  : Field( name, parent )
{
  mView = new HostItemView( this );

  mModel = new HostModel( this );
  mView->setModel( mModel );

  fieldLayout()->addWidget( mView, 0, 0 );
}

void HostsField::loadEntry( const Entry &entry )
{
  mModel->setStringList( entry.values( "kolabHost" ) );
}

void HostsField::saveEntry( Entry &entry ) const
{
  entry.clearValue( "kolabHost" );

  const QStringList hosts = mModel->stringList();
  for ( int i = 0; i < hosts.count(); ++i ) {
    entry.addValue( "kolabHost", hosts[ i ] );
  }
}

bool HostsField::isValid( QString&, PagePolicy::State ) const
{
  return true;
}

void HostsField::setEditable( bool editable )
{
  mView->setEnabled( editable );
}

