/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#include "file_manager.h"

FileManager::FileManager(auth_tcp_client *file_tcp_client, QObject *parent)
    : tcp_client(file_tcp_client), QObject(parent)
{
#ifdef WIN32
    slash = QString("\\");
#else
    slash = QString("/");
#endif
    file_queue = new QQueue<File*>;  
}

void FileManager::received_stream_slot_files(QString message)
{
    QApplication::processEvents();
    QByteArray file_array = QByteArray::fromBase64(message.toUtf8());
    QApplication::processEvents();
    if (!file_queue->isEmpty()) {
        current_file = file_queue->dequeue();

        emit showLabelSignal(tr("Decrypting and Writing ") + current_file->name + tr(" to ") + current_file->to + tr(", please wait..."));
        QApplication::processEvents();
        QFile *file = new QFile(current_file->to + current_file->name);
        if(file->isOpen()==false) {
            if(!file->open(QIODevice::WriteOnly)) {
                emit showMessage(tr("File error"),tr("An error occured while getting remote file : The local file is not correctly opened."), 4000);
                return;
            }
        }
        QApplication::processEvents();
        file->write(file_array);
        file->close();
        emit file_received(current_file);
        current_file = NULL;
    }
}

void FileManager::append_file(File* file)
{
    file_queue->enqueue(file);
}

/**
    Send document to remote client.
*/
int FileManager::send_document(QString name, QString path)
{
    emit update_percent(100, 0);
    QApplication::processEvents();
    QString file_path = path + slash + name;
    QFile *file = new QFile(file_path);
    if (file->exists()) {
        if (file->open(QIODevice::ReadOnly)) {
            if (file->isReadable()) {
                while (!file->atEnd()) {
                    // Envoyer packet par packet...
                    tcp_client->write_encrypted_data_to_socket(file->readAll().toBase64());
                    QApplication::processEvents();
                }
                file->close();
                delete file;
                return 1;
            } else {
                qDebug("File unreadable");
                return 0;
            }
        } else {
            qDebug("File not opened");
            return 0;
        }
    } else {
        qDebug("File does not exist.");
        return 0;
    }
}
