.\" @(#)$RCSfile: srmv1.man,v $ $Revision: 6384 $ $Date: 2012-06-06 16:39:34 +0200 (Wed, 06 Jun 2012) $ CERN IT-GD/CT Jean-Philippe Baud
.\" Copyright (C) 1999-2011 by CERN/IT/GD/CT
.\" All rights reserved
.\"
.TH SRMV1 8 "$Date: 2012-06-06 16:39:34 +0200 (Wed, 06 Jun 2012) $" LCG "DPM Administrator Commands"
.SH NAME
srmv1 \- start the SRM v1 server
.SH SYNOPSIS
.B srmv1
[
.BI -c " config_file"
] [
.BI -l " log_file"
]
.SH DESCRIPTION
.LP
The
.B srmv1
command starts the SRM v1 server.
This command is usually executed at system startup time
.RB ( /etc/rc.local ).
This will read the Disk Pool Manager "request" database configuration file,
create a pool of threads and look for requests.
Each of them is processed in a thread which opens a connection to the
database server if necessary.
When a request has been completed, the thread becomes idle until it is allocated
to another request.
The connection to the database server is kept open between 2 requests.
.LP
All error messages and statistical information are kept in a log.
.LP
The Disk Pool Manager listen port number can be defined on client hosts and
on the server itself in either of the following ways:
.RS
.LP
setting an environment variable SRMV1_PORT
.RS
.HP
setenv SRMV1_PORT 8443
.RE
.LP
an entry in
.B /etc/shift.conf
like:
.RS
.HP
SRMV1	PORT	8443
.RE
.RE
.LP
If none of these methods is used, the default port number is taken from the
definition of SRMV1_PORT in srm_server.h.
.LP
The Disk Pool Manager "request" database keeps the requests and their status
even after completion.
.LP
The Disk Pool Manager configuration file contains password information for the
database and must be readable/writable only by root.
It contains a single line in the format:
.HP
.RS 
username/password@server
.RE 
or
.RS
username/password@server/dbname
.RE
.sp 
where 'username' and 'password' are the credentials to login to the database
instance identified by 'server'. If 'dbname' is not specified, "dpm_db" is used.
.LP
In the log each entry has a timestamp.
All entries corresponding to one request have the same request id.
For each user command there is one message giving information about
the requestor (hostname, dn) and one message SRM98 giving the command
itself.
The completion code of the command is also logged.
.SH OPTIONS
.TP
.BI -c " config_file"
Specifies a different path for the Disk Pool Manager configuration file.
.TP
.BI -l " log_file"
Specifies a different path for the Disk Pool Manager log file.
The special value
.B syslog
will send the log messages to the system logger syslogd.
.SH FILES
.TP 1.5i
.B /etc/DPMCONFIG
configuration file
.TP
.B /var/log/srmv1/log
.SH EXAMPLES
.TP
Here is a small log:
.nf
11/26 15:26:38  8706,0 ping: request by xxx from lxb1523.cern.ch
11/26 15:26:38  8706,0 ping: returns 0
11/26 15:40:05  8706,0 put: request by xxx from lxb1523.cern.ch
11/26 15:40:05  8706,0 put: SRM98 - put 10 10
11/26 15:40:05  8706,0 put: SRM98 - put 0 srm://lxb0722.cern.ch:8443//pnfs/cern.ch/data/dteam/srm_test_suite_file.18684.26535
11/26 15:40:05  8706,0 put: SRM98 - put 1 srm://lxb0722.cern.ch:8443//pnfs/cern.ch/data/dteam/srm_test_suite_file.18684.26535.SECOND_FILE
.fi
.SH SEE ALSO
.BR Clogit(3) ,
.B dpm(1)
