#include <cmath>
#include "switcher.h"
#include "logger.h"

using namespace std;

Switcher::Switcher(AppletWindowParams params,
	const std::string& apps,
	const std::string& phone,
	const std::string& launch)
		:Applet(params), apps_icon(apps), phone_icon(phone), launch_icon(launch){
}
AppAction Switcher::OnMousePress(int x, int y){
    lastx = x;
    lasty = y;
    for (int i=0; i<buttons.size(); ++i)
	if (x>=buttons[i].px && y>=buttons[i].py && x<buttons[i].px + buttons[i].w && y<buttons[i].py + buttons[i].h){
	    pressed_button = i;
	    return "";
	}
    return "";
}


AppAction Switcher::OnMouseRelease(int x, int y){
    if (pressed_button > -1){
	int but = pressed_button;
	pressed_button = -1;
	if (y < lasty - 50){
	    Hide();
	    return "top_slider_show";
	} else {
	    win.GetDisplay().GenKeyEvent(buttons[but].action);
	    LOG(INFO) << "Gen action " << buttons[but].action;
	    Hide();
	    return "top_slider_show";
	    return "";
	}
    }
    return "";
}
void Switcher::OnRotate(Rotation r){
    win.Clear();
    DrawButtons();
    win.Refresh();
    SetTransparent(IsTransparent());
}

void Switcher::DrawButtons(){
    buttons.clear();
    buttons.push_back(Button(0, 0, GetCurrentWidth()/3, GetCurrentHeight(), "$desktop_switch2", phone_icon));
    buttons.push_back(Button(GetCurrentWidth()/3, 0, GetCurrentWidth()/3, GetCurrentHeight(), "$desktop_switch1", launch_icon));
    buttons.push_back(Button(GetCurrentWidth()/3*2, 0, GetCurrentWidth()/3, GetCurrentHeight(), "$desktop_switch0", apps_icon));

    for (int i=0; i<buttons.size(); ++i){
	string look = buttons[i].look;
	win.AddImage(buttons[i].px + buttons[i].w/2, buttons[i].py + buttons[i].h/2, look, NULL, NULL, MyWindow::CENTER);
    }
}

