<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne and Yves Trudeau
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
	require_once 'dbFunctions.php';
	
	/**
	*
	* Printers Browser class
	* 
	* @package MILLE-CONFIGURATOR
	* @author Alban Crequy
	*/
	class Printer {

		/**
		* Id of the printer (primary key)
		* @access private
		* @var int
		*/
		var $id;
		/**
		* printer name
		* @access private
		* @var string
		*/
		var $printername;
		/**
		* printer description
		* @access private
		* @var string
		*/
		var $description;
		/**
		* printer price per page
		* @access private
		* @var string
		*/
		var $priceperpage;
		/**
		* printer price per job
		* @access private
		* @var float
		*/
		var $priceperjob;

		/**
		* OK: FALSE/TRUE: Show if the instantiation is correct
		* @access private
		* @var boolean
		*/
		var $ok;
		/**
		* Last Error
		* @access private
		* @var string
		*/
		var $lastError;
		

		/**
		* The constructor of a Printer
		*
		* Can be initialised in two different ways :
		* <ul>
		* <li> ID of the printer
		* <li> Printer name
		* </ul>
		* 
		* Example of valid initialisation :
		*
		* <code>
		*   $prt=new Printer(7); // Use the Printer ID initialisation
		*   $prt=new Printer("printer01"); //Use the printer name initialisation
		* </code>
		*
		* @access public
		*/
		function Printer($id) {
			$this->ok = true;
			
			if (is_numeric($id)) 
				$prt = $this->getFromDB("*", "id=".$id);
			elseif (is_string($id))
				$prt = $this->getFromDB("*","printername='".$id."'");
			else {
				$this->ok = false;
				$this->lastError = getMessage('bad_printer_id')." : id=".$id;
			}
			$this->id = $prt['id'];
			$this->printername = $prt['printername'];
			$this->description = $prt['description'];
			$this->priceperpage = $prt['priceperpage'];
			$this->priceperjob = $prt['priceperjob'];
		}

		/**
		* Get the printer ID
		*
		* @access public
		* @return int
		*/
		function getID() {
			return $this->id;
		}

		/**
		* Get the printer name
		*
		* @access public
		* @return string
		*/
		function getPrinterName() {
			return $this->printername;
		}

		/**
		* Get the printer description
		*
		* @access public
		* @return string
		*/
		function getDescription() {
			return $this->description;
		}

		/**
		* Get the printer price per page
		*
		* @access public
		* @return float
		*/
		function getPriceperpage() {
			return $this->priceperpage;
		}

		/**
		* Get the printer price per job
		*
		* @access public
		* @return float
		*/
		function getPriceperjob() {
			return $this->priceperjob;
		}

		/**
		* Return yes if the object exists
		* To be used just after the construction
		*
		* @access public
		* @return float
		*/
		function isError() {
			return !$this->ok;
		}

		/**
		* Get the last error
		*
		* @access public
		* @return float
		*/
		function lastError() {
			return $this->lastError;
		}

		/**
		* GetFromDB
		*
		* @access private
		* @return array
		*/
		function getFromDB($column,$where,$from="printers") {
			$sql_query='SELECT '.$column.' FROM '.$from.' WHERE '.$where;
			if (!$result = singleResultSelect($sql_query)) {
				$this->lastError = getMessage('printer_not_found')." : ".htmlspecialchars($where);
				$this->ok = false;
				return NULL;
			}
			elseif (!is_array($result)) {
				$this->lastError = getMessage('db_error').htmlspecialchars($result)." : ".htmlspecialchars($sql_query);
				$this->ok = false;
				return NULL;
			}
			else 
				return $result;
		}

		/**
		* Change the printer name
		*
		* Return false if error.
		*
		* @access public
		* @return unknown
		*/
		function setPrinterName($name) {
			if (strlen($name) > 0) {
				$this->printername = $name;
				return $this->updatePrinter("printername='".$name."'");
			}
			else {
				$this->lastError = getMessage('empty_printer_name');
				return false;
			}
		}

		/**
		* updatePrinter
		*
		* @access private
		* @return unknown
		*/
		function updatePrinter($toSet, $from="printers") {
			if ($error = write("UPDATE ".$from." SET ".$toSet." WHERE id=".$this->id)) {
				$this->lastError = getMessage('db_write_error').htmlspecialchars($error);
				return false;
			}
			else
				return true;
		}

		/**
		* Print all informations about the printer with printerView.php
		*
		* @access public
		* @return none
		*/
		function print_printer() {
			include 'printerView.php';
		}

		/**
		* Print just a little informations about the printer
		*
		* @access public
		* @return none
		*/
		function print_printer_resume() {
			print $this->getPrinterName()." (#".$this->getId().")";
		}
		
	} // class Printer
?>